<%
/************************************************************************************************************
*	Name			:	DeleteExternalAgents.jsp
*	Purpose			:	to delete external agents which do not manage any hosts
*	Version			:	4.3
*	CreationDate	:	8/27/2008
*	Author			:	James Thomas P
*	Design Changes	:	Jaiwin
***********************************************************************************************************/
%>
<%@ include file = "EgTrackerA.jsp"%>
<%@ page errorPage = "EgProbs.jsp"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ taglib prefix = "egui" uri= "../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>
<%
	trans.createFile("eg_external.ini");
	String[] externalAgents = trans.getVariables("Eg_External_Agents");
	String [] externalAgentHosts = trans.getVariables(EgExternalInfo.testMapSection);

	Vector deleteExternalAgents = null;
	if(externalAgents != null && externalAgents.length>0)
	{
		deleteExternalAgents = new Vector(Arrays.asList(externalAgents));
		deleteExternalAgents.remove(new EgSpecsInfo("manager").getEGServer());
	}
	else
		deleteExternalAgents = new Vector();

	for(int a=deleteExternalAgents.size()-1;a>=0;a--)
	{
		String externalAgent = (String) deleteExternalAgents.get(a);
		for (int i=0; i<externalAgentHosts.length; i++)
		{
			String externalAgentsToNick = trans.getStrValue(EgExternalInfo.testMapSection, externalAgentHosts[i]);
			if (externalAgentsToNick.indexOf(",") > -1
				&& (externalAgentsToNick.indexOf(externalAgent+",") > -1 || externalAgentsToNick.startsWith(externalAgent+",")
				|| externalAgentsToNick.endsWith(externalAgent)))
			{
				deleteExternalAgents.remove(externalAgent);
			}
			else if(externalAgentsToNick.equals(externalAgent))
			{
				deleteExternalAgents.remove(externalAgent);
			}
		}
	}

	if(deleteExternalAgents.size()>0)
		Collections.sort(deleteExternalAgents,String.CASE_INSENSITIVE_ORDER);
%>
<html>
<head>
<title>DELETE EXTERNAL AGENTS</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<egui:skin ui="admin"/>
<script language="JavaScript1.2">

function isNetscape()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for Navigator ver 4+.
	if ((appName == "Netscape") && (appVer >= 4)) return true;
	return false;
}

function isIE()
{
	// get browser info.
	appName= navigator.appName;
	appLongVer = navigator.appVersion;
	appVer = appLongVer.substring(0, 1);

	// check for IE ver 4+.
	if ((appName == "Microsoft Internet Explorer") && (appVer >= 4)) return true;
	return false;
}

function egTitleSearch()
{
	var egTitleSearchStr = document.externalAgentForm.egTitleSearchStr.value;
	var isAgentFound = false;
	if (egTitleSearchStr != null)
	{
		var str = egTitleSearchStr;
		while (str.substring(0,1) == ' ')
		{
			str = str.substring(1,str.length);
		}
		while (str.substring(str.length-1,str.length) == ' ')
		{
			str = str.substring(0,str.length-1);
		}
		egTitleSearchStr = str;
	}

	if(egTitleSearchStr==""||egTitleSearchStr==null)
	{
		alert('<egui:intnl text="admin.common.Please enter a Search String"/>');
	}
	else
	{
		var displayArray = document.externalAgentForm.extAgent;
		var backupArray = document.externalAgentForm.extAgent;
		for (var i=0; i<backupArray.length; i++)
		{
			var thisOption = backupArray[i];
			var thisValue = thisOption.value;
			var thisName = thisOption.name;
			if (egTitleSearchStr=="")
			{
				thisOption.selected=false;
			}
			else
			{
				scrTokens = egTitleSearchStr.split(" ");
				thisIndex = -1;
				for (var j=0;j<scrTokens.length;j++)
				{
					thisIndex = (thisValue.toLowerCase()).indexOf(scrTokens[j].toLowerCase());
					if (thisIndex != -1)
					{
						break;
					}
				}
				if (thisIndex!= -1)
				{
					thisOption.selected=true;
					isAgentFound = true;
				}
				else
				{
					thisOption.selected=false;
				}
			}
		}
		if (!isAgentFound)
		{
			alert('<egui:intnl text="admin.common.No external agent(s) found for your search"/>');
		}
	}
}

function valform()
{
	var a;
	if (document.externalAgentForm.extAgent.selectedIndex == -1)
	{
		alert('<egui:intnl text="admin.common.Please select external agent(s)"/>');
	}
	else
	{
		a = confirm('<egui:intnl text="admin.common.Are you sure you want to delete selected external agent(s)"/>'+'?');
		if(a)
		{
			thisForm = document.externalAgentForm;
			selectedAgents = "";
			for(i=0;i<thisForm.extAgent.options.length;i++)
			{
				if(thisForm.extAgent.options[i].selected)
				{
					if(selectedAgents.length==0)
						selectedAgents = thisForm.extAgent.options[i].value;
					else
						selectedAgents += "," + thisForm.extAgent.options[i].value;
				}
			}
			if(selectedAgents.length>0)
				thisForm.externalAgents.value = selectedAgents;

			if (isNetscape()) targetObj = document.externalAgentForm.deleteuser.disabled=true;
			if (isIE()) targetObj = document.externalAgentForm.deleteuser.disabled=true;
			document.externalAgentForm.deleteuser.value='<egui:intnl text="admin.common.Deleting"/>'+"...";
			document.externalAgentForm.action="deleteAgentsp.jsp";
			document.externalAgentForm.submit();
		}
	}
}

</script>
</head>
<body style="overflow:auto" scrolling="yes" id="space6" >
<form name="externalAgentForm" method="post" style="margin:0px" action="javascript:egTitleSearch();">
<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
	<jsp:include page="listSearch.jsp?title=DELETE EXTERNAL AGENTS"/>
	<tr>
		<td width="100%" id="eg_whitebg" align="center" height="100%" valign="top">
			<table align="center" cellspacing="0" cellpadding="0" width="85%" border="0">
				<tr>
					<td colspan="3" width="100%" height="22">
						<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0" id="eg_subcontentbg" height="22">
							<tr>
								<td id="subhead_left" width="7">
								<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
								<td width="100%" align="center" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
								<strong>
								<egui:intnl text="admin.common.External agents which are not associated to any hosts" />
								</strong>
								</td>
								<td id="subhead_right" width="7">
								<img src="/final/admin/eg_images/spacer.gif" border="0" width="7">
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg"  width="100%" align="center" valign="top" colspan="3" class="eg_blankspace" height="10px">&nbsp;&nbsp;</td>
				</tr>
				<tr>
					<td id="eg_subcontentbg"  width="100%" align="center" valign="top" colspan="3" class="form_spacing">&nbsp;&nbsp;
					<select name="extAgent" multiple size="25" style="width:350px">
<%
	for(int i=0;i<deleteExternalAgents.size();i++)
	{
		String externalAgent = (String) deleteExternalAgents.get(i);
%>
		<option value="<%=externalAgent%>"><%=externalAgent%></option>
<%
	}
%>
					</select>
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" height="10" nowrap colspan="3" class="eg_subcontentbg">&nbsp;</td>
				</tr>
				<tr>
					<td height="6" class="inner_bott_left" width="7" > <img src="/final/admin/eg_images/spacer.gif" width="7" height="6" border="0"></td>
					<td id="eg_subcontentbg"  width="1000px" valign="top" ><img src="/final/admin/eg_images/spacer.gif" height="6" border="0"></td>
					<td height="6" align="right" class="inner_bott_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" width="7px" height="6px" border="0"></td>
				</tr>
				<tr>
					<td id="eg_blankspace" height="10" nowrap colspan="3">&nbsp;</td>
				</tr>
				<tr>
					<td width="100%" align="center" colspan="3">
					<input type="button" name="deleteuser" value='<egui:intnl text="admin.common.Delete" />' style="width: 80px;" class="eg_darkbutton" onClick="javascript:valform()" />
					</td>
				</tr>
				<tr>
					<td id="eg_blankspace" height="10" nowrap colspan="3">&nbsp;</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<input type='hidden' name='externalAgents'>
<input type='hidden' name='from' value='deleteExternalAgentsPage'>
</form>
</body>
</html>
