
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgConfigFilesSync"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	JSONObject rootObj = new JSONObject();
	JSONObject errorObj = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	String pageTitle = "SAML Identity Providers";

	boolean isAuditUpdate = false;
	boolean isUpdateClusterData = false;
	//ctype=Add&'+"idpName="+idpName+"&loginURL="+loginURL+"&logoutURL="+logoutURL+"&certInfo="+certInfo;;

	String isSecondary = request.getParameter("cluster");
	if (!com.egurkha.util.StringUtils.isNull(isSecondary) && isSecondary.equalsIgnoreCase("true"))
	{
		isUpdateClusterData = true;
	}
	boolean isClusterSupported  = EgInstallInfo.isClusterSupported ;
	rootObj.put("isClusterSupported",isClusterSupported);

	String ctype = request.getParameter("ctype");
	String idptypes = request.getParameter("idpName");
	IniFile iniFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_samlsso.ini",true);
	String strSSOLogin = iniFile.getValue("SAML_SSO","SSO_ENABLED");
	String strDefaultLoginIdp = iniFile.getValue("SAML_SSO","defaultIdPForLogin");

	boolean isSsoEnabled = false;
	if (!com.egurkha.util.StringUtils.isNull(strSSOLogin) && strSSOLogin.equalsIgnoreCase("yes"))
	{
		isSsoEnabled = true;
	}

	/* code for audit log starts */
	String curPwd = request.getParameter("newpwd");
	String preSSL = request.getParameter("$_ssl");
	ArrayList previous = new ArrayList();
	ArrayList current = new ArrayList();

	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","SAML Identity Providers");
	auditLogThread.setValue("Activity","Configure");

	/* code for auditlog ends */


	rootObj.put("isSsoEnabled",isSsoEnabled);
	if(ctype!=null && (ctype.equalsIgnoreCase("Add") || ctype.equalsIgnoreCase("Modify")))
	{
		String idpName = request.getParameter("idpName");
		idpName = com.egurkha.util.StringUtils.decodeSecurityChar(idpName);

		String loginURL = request.getParameter("loginURL");
		loginURL = com.egurkha.util.StringUtils.decodeSecurityChar(loginURL);

		String logoutURL = request.getParameter("logoutURL");
		logoutURL = com.egurkha.util.StringUtils.decodeSecurityChar(logoutURL);

		String certInfo = request.getParameter("certInfo");
		certInfo = com.egurkha.util.StringUtils.decodeSecurityChar(certInfo);

		String defaultidp = request.getParameter("defaultidp");

		try
		{
			String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
			String issuerURL = mngrIProc+"/final/sso";
			certInfo = certInfo.replaceAll("\n", "");
			certInfo = certInfo.replaceAll(" ", "");
			if(logoutURL==null || logoutURL.length()==0)
			{
				logoutURL="none";
			}

			if (ctype.equalsIgnoreCase("Add"))
			{
				isAuditUpdate = true;
				/* code for auditlog starts */
				auditLogThread.setValue("Description",idpName+" SAML identity provider has been added successfully");
				auditLogThread.setCurrentValue("00~~SAML IdP Name",idpName);
				auditLogThread.setCurrentValue("01~~Login URL",loginURL);
				auditLogThread.setCurrentValue("02~~Logout URL",logoutURL);
				auditLogThread.setCurrentValue("03~~Certificate","*******");
				if (!com.egurkha.util.StringUtils.isNull(defaultidp) && defaultidp.equalsIgnoreCase("yes"))
				{
					auditLogThread.setCurrentValue("04~~Is default IdP for login",idpName);
				}
				/* code for auditlog ends */
			}
			else
			{
				/* code for auditlog starts */

				String prevLoginUrl = iniFile.getValue(idpName, "loginURL");
				String prevLogoutUrl = iniFile.getValue(idpName, "logoutURL");
				String prevCertInfo = iniFile.getValue(idpName, "certInfo");

				if (!com.egurkha.util.StringUtils.isNull(prevLoginUrl) && !com.egurkha.util.StringUtils.isNull(loginURL) && !prevLoginUrl.equals(loginURL))
				{
					isAuditUpdate = true;
					auditLogThread.setPreviousValue("00~~Login URL",prevLoginUrl);
					auditLogThread.setCurrentValue("00~~Login URL",loginURL);

				}

				if (!com.egurkha.util.StringUtils.isNull(prevLogoutUrl) && !com.egurkha.util.StringUtils.isNull(logoutURL) && !prevLogoutUrl.equals(logoutURL))
				{
					isAuditUpdate = true;
					auditLogThread.setPreviousValue("01~~Logout URL",prevLogoutUrl);
					auditLogThread.setCurrentValue("01~~Logout URL",logoutURL);
				}

				if (!com.egurkha.util.StringUtils.isNull(defaultidp) && defaultidp.equalsIgnoreCase("yes"))
				{
					if (!strDefaultLoginIdp.equals(idpName))
					{
						isAuditUpdate = true;
						auditLogThread.setPreviousValue("02~~Is default IdP for login",strDefaultLoginIdp);
						auditLogThread.setCurrentValue("02~~Is default IdP for login",idpName);
					}
				}
				else
				{
					if (strDefaultLoginIdp.equals(idpName))
					{
						isAuditUpdate = true;
						auditLogThread.setPreviousValue("02~~Is default IdP for login",strDefaultLoginIdp);
						auditLogThread.setCurrentValue("02~~Is default IdP for login","-");
					}

				}

				if (!com.egurkha.util.StringUtils.isNull(prevCertInfo) && !com.egurkha.util.StringUtils.isNull(certInfo) && !prevCertInfo.equals(certInfo))
				{
					isAuditUpdate = true;
					auditLogThread.setPreviousValue("03~~Certificate","*******");
					auditLogThread.setCurrentValue("03~~Certificate","*******");
				}

				auditLogThread.setValue("Description",idpName+" SAML identity provider has been modified successfully");
				/* code for auditlog ends */
			}

			if (isClusterSupported)
			{
				if (isUpdateClusterData)
				{
					String secLoginURL = request.getParameter("secloginurl");
					secLoginURL = com.egurkha.util.StringUtils.decodeSecurityChar(secLoginURL);

					String secLogoutURL = request.getParameter("seclogouturl");
					secLogoutURL = com.egurkha.util.StringUtils.decodeSecurityChar(secLogoutURL);

					String secCertInfo = request.getParameter("secidpcert");
					secCertInfo = com.egurkha.util.StringUtils.decodeSecurityChar(secCertInfo);
					secCertInfo = secCertInfo.replaceAll("\n", "");
					secCertInfo = secCertInfo.replaceAll(" ", "");

					if (ctype.equalsIgnoreCase("Add"))
					{
						isAuditUpdate = true;
						auditLogThread.setCurrentValue("04~~Enable Secondary IdP ","Yes");
						auditLogThread.setCurrentValue("05~~Secondary Login URL",secLoginURL);
						auditLogThread.setCurrentValue("06~~Secondary Logout URL",secLogoutURL);
						auditLogThread.setCurrentValue("07~~Secondary Certificate","*******");
					}
					else
					{
						String prevSecLoginUrl = iniFile.getValue("SECONDARY_"+idpName, "loginURL");
						String prevSecLogoutUrl = iniFile.getValue("SECONDARY_"+idpName, "logoutURL");
						String prevSecCertInfo = iniFile.getValue("SECONDARY_"+idpName, "certInfo");

						if (!com.egurkha.util.StringUtils.isNull(prevSecLoginUrl) && !com.egurkha.util.StringUtils.isNull(secLoginURL) && !prevSecLoginUrl.equals(secLoginURL))
						{
							isAuditUpdate = true;
							auditLogThread.setPreviousValue("05~~Secondary Login URL",prevSecLoginUrl);
							auditLogThread.setCurrentValue("05~~Secondary Login URL",secLoginURL);

						}

						if (!com.egurkha.util.StringUtils.isNull(prevSecLogoutUrl) && !com.egurkha.util.StringUtils.isNull(secLogoutURL) && !prevSecLogoutUrl.equals(secLogoutURL))
						{
							isAuditUpdate = true;
							auditLogThread.setPreviousValue("06~~Secondary Logout URL",prevSecLogoutUrl);
							auditLogThread.setCurrentValue("06~~Secondary Logout URL",secLogoutURL);
						}

						if (!com.egurkha.util.StringUtils.isNull(prevSecCertInfo) && !com.egurkha.util.StringUtils.isNull(secCertInfo) && !prevSecCertInfo.equals(secCertInfo))
						{
							isAuditUpdate = true;
							auditLogThread.setCurrentValue("07~~Certificate","*******");
							auditLogThread.setCurrentValue("07~~Certificate","*******");
						}
					}
				}
				else
				{
					isAuditUpdate = true;
					auditLogThread.setCurrentValue("05~~Enable Secondary IdP ","No");
				}
			}

			if(iniFile != null)
			{
				if(ctype.equalsIgnoreCase("Add"))
				{
					String subjs[]=iniFile.getSubjects();
					for(int i=0;i<subjs.length;i++)
					{
						if (!com.egurkha.util.StringUtils.isNull(subjs[i]) && subjs[i].equals("SAML_SSO"))
						{
							continue;
						}

						if(subjs[i].equalsIgnoreCase(idpName))
						{
							rootObj.put("success","true");
							rootObj.put("requestStatus","failed");
							errorObj.put("title",pageTitle);
							errorObj.put("message","IdP Name is already exist");
							rootObj.put("errors",errorObj);
							out.println(rootObj.toString());
							return;
						}
					}
				}
				iniFile.setValue(idpName, "loginURL", loginURL);
				iniFile.setValue(idpName, "logoutURL", logoutURL);
				iniFile.setValue(idpName, "certInfo", certInfo);

				if (ctype.equalsIgnoreCase("Add"))
				{
					iniFile.setValue(idpName, "ComparisonRuleForAuthenticationContext", "none");
				}
				else if (ctype.equalsIgnoreCase("Modify"))
				{
					String existComprisonType = iniFile.getValue(idpName, "ComparisonRuleForAuthenticationContext");
					if (com.egurkha.util.StringUtils.isNull(existComprisonType))
					{
						iniFile.setValue(idpName, "ComparisonRuleForAuthenticationContext", "none");
					}
				}

				if (!com.egurkha.util.StringUtils.isNull(defaultidp))
				{
					if (defaultidp.equalsIgnoreCase("yes"))
					{
						iniFile.setValue("SAML_SSO", "defaultIdPForLogin", idpName);
					}
					else if (defaultidp.equalsIgnoreCase("no"))
					{
						if (strDefaultLoginIdp.equals(idpName))
						{
							iniFile.setValue("SAML_SSO", "defaultIdPForLogin", "");
						}
					}
				}

				if (isClusterSupported)
				{
					if (isUpdateClusterData)
					{
						String secLoginURL = request.getParameter("secloginurl");
						secLoginURL = com.egurkha.util.StringUtils.decodeSecurityChar(secLoginURL);

						String secLogoutURL = request.getParameter("seclogouturl");
						secLogoutURL = com.egurkha.util.StringUtils.decodeSecurityChar(secLogoutURL);

						String secCertInfo = request.getParameter("secidpcert");
						secCertInfo = com.egurkha.util.StringUtils.decodeSecurityChar(secCertInfo);
						secCertInfo = secCertInfo.replaceAll("\n", "");
						secCertInfo = secCertInfo.replaceAll(" ", "");

						iniFile.setValue(idpName, "isSecondary", "Yes");

						iniFile.setValue("SECONDARY_"+idpName, "loginURL", secLoginURL);
						iniFile.setValue("SECONDARY_"+idpName, "logoutURL", secLogoutURL);
						iniFile.setValue("SECONDARY_"+idpName, "certInfo", secCertInfo);

						if (ctype.equalsIgnoreCase("Add"))
						{
							iniFile.setValue("SECONDARY_"+idpName, "ComparisonRuleForAuthenticationContext", "exact");
						}
						else if (ctype.equalsIgnoreCase("Modify"))
						{
							String existComprisonType = iniFile.getValue("SECONDARY_"+idpName, "ComparisonRuleForAuthenticationContext");
							if (com.egurkha.util.StringUtils.isNull(existComprisonType))
							{
								iniFile.setValue("SECONDARY_"+idpName, "ComparisonRuleForAuthenticationContext", "exact");
							}
						}
					}
					else
					{
						iniFile.setValue(idpName, "isSecondary", "No");

						iniFile.deleteSubject("SECONDARY_"+idpName);
					}

				}
				iniFile.saveFile();
				
			}
			else
			{
				rootObj.put("success","true");
				rootObj.put("requestStatus","failed");
				errorObj.put("title",pageTitle);
				errorObj.put("message","IdP can't be configured. Try again");
				rootObj.put("errors",errorObj);
				out.println(rootObj.toString());
				return;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			rootObj.put("success","true");
			rootObj.put("requestStatus","failed");
			errorObj.put("title",pageTitle);
			errorObj.put("message","IdP can't be configured. Try again");
			rootObj.put("errors",errorObj);
			out.println(rootObj.toString());
			return;
		}

		if (isAuditUpdate)
		{
			auditLogThread.sendItToDB();
		}

		rootObj.put("success",true);
		rootObj.put("requestStatus","success");
		JSONObject resultMsg = new JSONObject();
		resultMsg.put("title",pageTitle);
		resultMsg.put("message","IdP configured successfully");
		rootObj.put("result",resultMsg);
		out.println(rootObj.toString());
	}

	if(ctype!=null && (ctype.equalsIgnoreCase("deleteAll") || ctype.equalsIgnoreCase("delete")))
	{
		String loggedInIdp="All the IdP(s) are deleted successfully";
		ArrayList idpToDelete = new ArrayList();
		String idptypes1="";
		if(idptypes!=null)
		{
			StringTokenizer st = new StringTokenizer(idptypes,"~!~");
			while(st.hasMoreTokens())
			{
				idpToDelete.add(st.nextToken());
			}
		}
		Object idpUsers = session.getAttribute("idpUsers");
		Vector idpobj=null;
		ArrayList delIdpList = new ArrayList();
		if(idpUsers!=null)
		{
			idpobj=(Vector)idpUsers;
		}
		else
		{
			 idpobj= new Vector();
		}
		
		String enableSecondary = "";
		String subjs[]=iniFile.getSubjects();
		boolean saveFile=false;

		for(int i= 0;i<subjs.length;i++)
		{
			if (!com.egurkha.util.StringUtils.isNull(subjs[i]) && subjs[i].equals("SAML_SSO"))
			{
				continue;
			}

			if(!ctype.equalsIgnoreCase("delete"))
			{
				if (idpobj.contains(subjs[i]))
				{
					//loggedInIdp="Some IdP(s) can't be delete, because you are users are exist ";
					loggedInIdp="SAML identity providers containing users have not been deleted";
				}
				else
				{
					delIdpList.add(subjs[i]);
					enableSecondary = iniFile.getValue(subjs[i],"isSecondary");
					iniFile.deleteSubject(subjs[i]);
					if (!com.egurkha.util.StringUtils.isNull(enableSecondary) && enableSecondary.equalsIgnoreCase("yes"))
					{
						iniFile.deleteSubject("SECONDARY_"+subjs[i]);
					}
					saveFile = true;
				}
			}
			else
			{
				Iterator it = idpToDelete.iterator();
				while(it.hasNext())
				{
					idptypes1 = it.next().toString();
					enableSecondary = iniFile.getValue(idptypes1,"isSecondary");
					iniFile.deleteSubject(idptypes1);
					if (!com.egurkha.util.StringUtils.isNull(enableSecondary) && enableSecondary.equalsIgnoreCase("yes"))
					{
						iniFile.deleteSubject("SECONDARY_"+idptypes1);
					}
					loggedInIdp="IdP have been deleted successfully";
					saveFile = true;
				}
			}
		}

		if (ctype.equalsIgnoreCase("delete"))
		{
			if (!com.egurkha.util.StringUtils.isNull(strDefaultLoginIdp))
			{
				Iterator it = idpToDelete.iterator();
				while(it.hasNext())
				{
					idptypes1 = it.next().toString();
					if(strDefaultLoginIdp.equals(idptypes1))
					{
						iniFile.deleteValue("SAML_SSO","defaultIdPForLogin");
					}
				}
			}
			isAuditUpdate = true;
			if (idpToDelete.size() == 1)
			{
				auditLogThread.setValue("Description","SAML identity provider has been deleted successfully");
			}
			else
			{
				auditLogThread.setValue("Description","SAML identity provider have been deleted successfully");
			}
			String deletedIdpsNames = com.egurkha.util.StringUtils.getString(idpToDelete);
			auditLogThread.setCurrentValue("SAML IdP Name",deletedIdpsNames);
		}
		else
		{
			/* code for auditlog starts */
			String strDispIdps = "";

			if (delIdpList != null && delIdpList.size() > 0)
			{
				if (!com.egurkha.util.StringUtils.isNull(strDefaultLoginIdp) && delIdpList.contains(strDefaultLoginIdp))
				{
					iniFile.deleteValue("SAML_SSO","defaultIdPForLogin");
				}

				strDispIdps = com.egurkha.util.StringUtils.getString(delIdpList);
				isAuditUpdate = true;
				auditLogThread.setCurrentValue("SAML IdP Names",strDispIdps);
			}

			auditLogThread.setValue("Description","SAML identity providers have been deleted successfully");
			/* code for auditlog ends */
		}

		if (isAuditUpdate)
		{
			auditLogThread.sendItToDB();
		}

		if (saveFile)
		{
			iniFile.saveFile();
		}

		rootObj.put("success","true");
		rootObj.put("requestStatus","success");
		JSONObject resultMsg = new JSONObject();
		resultMsg.put("title",pageTitle);
		resultMsg.put("message",loggedInIdp);
		rootObj.put("result",resultMsg);
		out.println(rootObj.toString());
	}
	EgConfigFilesSync.releaseInstance(iniFile);

%>
