<%
/*************************************************************************************************/
/*                 Name          : EgAutoManagePageJson.jsp                                          */
/*                 Purpose       : This page is used to create Java script Auto Topology         */
/*                 Version       : 5.4                                                           */
/*                 Created On    : 05-08-2011                                                    */
/*************************************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "net.sf.json.*"%>
<jsp:useBean id="zoneI" class="egurkha.ZoneInfoBean" scope="page" />
<jsp:useBean id="user" class="egurkha.UserBean" scope="page"/>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
try
{
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	
	JSONObject gridObj = new JSONObject();
	JSONArray gridArr = new JSONArray();
	JSONObject saveTopoObj = new JSONObject();
	JSONArray saveTopoArr = new JSONArray();
	JSONObject grpObj = new JSONObject();
	JSONObject managedgrpObj = new JSONObject();
	JSONArray grpArr = new JSONArray();
	JSONArray managedgrpArr = new JSONArray();
	JSONObject groupCompObj = new JSONObject();
	JSONArray groupCompArr = new JSONArray();
	JSONObject zoneCompObj = new JSONObject();
	JSONArray zoneCompArr = new JSONArray();
	JSONObject segmentCompObj = new JSONObject();
	JSONArray segmentCompArr = new JSONArray();

	boolean isDouble=EgDbInfo.doubleByteEnabled;
	String [] groups = zoneI.getZoneNames();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String segment = request.getParameter("segment");
	String action = request.getParameter("action");
	String zone  = request.getParameter("zone");
	String dragFn = request.getParameter("enableDrag");
	if(dragFn==null)
		dragFn="false";

	String saveFrom = request.getParameter("saveFrom");
	if(saveFrom==null) saveFrom="";

	EgGroupInfo groupInfo = new EgGroupInfo();
	ArrayList thisZoneComponents = new ArrayList();	// Contains all components from the given zone.

	// Collect Zone componets, if zone is not Default
	boolean isZone = false;
	if(zone!=null && !zone.equals("-1"))
	{
		thisZoneComponents = groupInfo.getAllComponentsUnderZone(zone);
		isZone = true;

		// If any group exists in the zone, add the Group names with type
		TreeSet mySet =  groupInfo.getAllGroupsUnderZone(zone, true);
		if(mySet!=null && mySet.size() > 0)
		{
			Iterator thisItr = mySet.iterator();
			while(thisItr.hasNext())
			{
				String thisStr = (String) thisItr.next();
				thisZoneComponents.add(thisStr);
			}
		}
	}
	boolean isNoCompInSegment=false;
	boolean isNewCompExists = false;
	boolean isUnManageExists = false;
	boolean isManageExists = false;
	boolean isNewDiscGrp = false;
	boolean isManGrp = false;
	boolean isComplete = false;
	boolean isSave = false;
	boolean addToZone = false;
	boolean addToGroup=false;
	boolean saveAs = false;
	boolean segLimitExceed = false;

	Hashtable compHash = new Hashtable();
	ArrayList compGroupList = new ArrayList();
	ArrayList newCompList = new ArrayList();
	ArrayList unManageList = new ArrayList();
	ArrayList manageList = new ArrayList();
	ArrayList segComponents = new ArrayList();
	ArrayList incompleteList = new ArrayList();
	ArrayList addTothisZone = new ArrayList();
	ArrayList newGrpArr = new ArrayList();
	ArrayList manGrpArr = new ArrayList();

	if(segment!=null && segment.length() > 0)
	{
		segComponents = getSegmentComponents(segment);
		if(segComponents!=null && segComponents.size() == 0)
			isNoCompInSegment = true;
	}
	if(!user.checkSegmentCount())
	{
		segLimitExceed = true;
	}
	if(isNoCompInSegment)
	{
		// There is no components in the given segment..
	}
	else
	{
		if(segment!=null && action!=null && action.equals("save"))
		{
			isSave = true;
			if(isZone)
			{
				for(int k=0;k<segComponents.size();k++)
				{
					String thisComp = (String) segComponents.get(k);
					if(thisZoneComponents.contains(thisComp))
						continue;
					addTothisZone.add(thisComp);
				}
			}
		}
		if(segment!=null && action!=null && action.equals("saveAs"))
		{
			saveAs = true;
			if(isZone)
			{
				for(int k=0;k<segComponents.size();k++)
				{
					String thisComp = (String) segComponents.get(k);
					if(thisZoneComponents.contains(thisComp))
						continue;
					addTothisZone.add(thisComp);
				}
			}
		}

		if(segment!=null)
		{
			Hashtable myTable = getUnmanageAndNewComponents(segment);
			newCompList = (ArrayList) myTable.get("NEW");
			if(newCompList!=null && newCompList.size() > 0)
				isNewCompExists = true;

			unManageList = (ArrayList) myTable.get("UNMANAGE");
			if(unManageList!=null && unManageList.size() > 0)
				isUnManageExists = true;

			manageList = (ArrayList) myTable.get("MANAGE");
			if(manageList!=null && manageList.size() > 0)
				isManageExists = true;

			incompleteList = getSingleLeadingComponents(segment);
			if(incompleteList!=null && incompleteList.size() > 0)
				isComplete = true;
			//new group exist
			manGrpArr = getManagedGrp(segment);
			if(manGrpArr!=null && manGrpArr.size() > 0)
				isManGrp = true;

			newGrpArr = getNewDiscGrp(segment);
			newGrpArr.removeAll(manGrpArr);
			if(newGrpArr!=null && newGrpArr.size() > 0)
				isNewDiscGrp = true;

		
		}

		if(addTothisZone!=null && addTothisZone.size() > 0)
			addToZone = true;
		
		// To Check if the component is already added to group
		String subArr[];
		ArrayList groupList = new ArrayList();
		IniFile topoIni1 = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
		subArr = topoIni1.getVariables("GROUP_DETAILS");
		if(subArr == null)
			return;
		for(int i=0; i<subArr.length; i++)
		{
			if(segComponents.contains(subArr[i]))
			{
				compGroupList.add(subArr[i]);
				String value = topoIni1.getValue("GROUP_DETAILS",subArr[i]);
				if(compHash.containsKey(value))
				{
					ArrayList list = (ArrayList) compHash.get(value);
					list.add(subArr[i]);
					compHash.put(value,(ArrayList)list);
				}
				else
				{
					ArrayList list = new ArrayList();
					list.add(subArr[i]);
					compHash.put(value,(ArrayList)list);
				}
			}
		}
		if(compHash!=null && compHash.size()>0)
			addToGroup = true;
	}
	rootJson.put("segLimitExceed",segLimitExceed);
	rootJson.put("NoComponents","false");
	if(isNoCompInSegment)
	{
		rootJson.put("NoComponents","true");
		screenLabels.put("NoComponentsMsg",_mapping.getTextDescription("admin.segment.No component is available in the given segment"));
	}
	else
	{
		rootJson.put("isNewCompExists",isNewCompExists);
		rootJson.put("isUnManageExists",isUnManageExists);
		rootJson.put("isManageExists",isManageExists);
		rootJson.put("isComplete",isComplete);
		rootJson.put("isNewDiscGrp",isNewDiscGrp);
		if(isManageExists)
		{
			String saveString = " The following are the managed components  !";
			rootJson.put("saveString",_mapping.getTextDescription("admin.topology."+saveString));
			for(int k=0;k<manageList.size();k++)
			{
				String element = (String) manageList.get(k);
				StringTokenizer st = new StringTokenizer(element,":");
				int count = st.countTokens();
				String compType = "";
				String hostName = "";
				String portNo = "";
				String sid = "-";
				boolean isOraServer = false;
				if(count == 3)
				{
					compType = st.nextToken();
					hostName = st.nextToken();
					portNo = st.nextToken();
				}
				else if(count == 4)	// Only for Oracle_Database Component
				{
					compType = st.nextToken();
					hostName = st.nextToken();
					portNo = st.nextToken();
					sid = st.nextToken();
					isOraServer = true;
				}
				if(portNo.equals("NULL"))
						portNo ="-";

				if(isOraServer)
				{
					hostName = hostName+"("+sid+")";
				}
				saveTopoObj.put("Hostname",hostName);
				saveTopoObj.put("Port",portNo);
				saveTopoObj.put("Comptype",_mapping.getComponentTypeDescription(compType));
				saveTopoObj.put("Cbvalue",element);
				saveTopoArr.add(saveTopoObj);
			}
			if(isManGrp)
			{
				for(int k=0;k<manGrpArr.size();k++)
				{
					String manCompGrp = (String)manGrpArr.get(k);
					StringTokenizer strTok = new StringTokenizer(manCompGrp,":");
					int count = strTok.countTokens();
					String compType = "";
					String compName = "";
					if(count>=3)
					{
						compType = strTok.nextToken();
						compName = strTok.nextToken();
					}
					managedgrpObj.put("groupnameValue",compName);
					managedgrpArr.add(managedgrpObj);
				}
			}
		}
		if(isNewCompExists || isUnManageExists || isNewDiscGrp )//|| isUnamanageGrp
		{
			String saveString = " Manage the following new (or) unmanaged components !";
			if(isSave || saveAs){
				saveString = "To save this topology, manage the following new (or) unmanaged components !";
			}
			rootJson.put("saveString",_mapping.getTextDescription("admin.topology."+saveString));

			for(int k=0;k<newCompList.size();k++)
			{
				String element = (String) newCompList.get(k);
				StringTokenizer st = new StringTokenizer(element,":");
				int count = st.countTokens();
				String compType = "";
				String hostName = "";
				String portNo = "";
				String sid = "-";
				boolean isOraServer = false;
				if(count == 3)
				{
					compType = st.nextToken();
					hostName = st.nextToken();
					portNo = st.nextToken();
				}
				else if(count == 4)	// Only for Oracle_Database Component
				{
					compType = st.nextToken();
					hostName = st.nextToken();
					portNo = st.nextToken();
					sid = st.nextToken();
					isOraServer = true;
				}
				if(portNo.equals("NULL"))
						portNo ="-";

				if(isOraServer)
				{
					hostName = hostName+"("+sid+")";
				}
				gridObj.put("Hostname",hostName);
				gridObj.put("Port",portNo);
				gridObj.put("Comptype",_mapping.getComponentTypeDescription(compType));
				gridObj.put("Cbvalue",element);
				gridArr.add(gridObj);
			}
			//UnManage componenet List ....
			for(int k=0;k<unManageList.size();k++)
			{
				String element = (String) unManageList.get(k);
				StringTokenizer st = new StringTokenizer(element,":");
				int count = st.countTokens();
				String compType = "";
				String hostName = "";
				String portNo = "";
				String sid = "-";
				boolean isOraServer = false;
				if(count == 3)
				{
					compType = st.nextToken();
					hostName = st.nextToken();
					portNo = st.nextToken();
				}
				else if(count == 4)	// Only for Oracle_Database Component
				{
					compType = st.nextToken();
					hostName = st.nextToken();
					portNo = st.nextToken();
					sid = st.nextToken();
					isOraServer = true;
				}
				if(portNo.equals("NULL"))
						portNo ="-";

				if(isOraServer)
				{
					hostName = hostName+"("+sid+")";
				}
				gridObj.put("Hostname",hostName);
				gridObj.put("Port",portNo);
				gridObj.put("Comptype",_mapping.getComponentTypeDescription(compType));
				gridObj.put("Cbvalue",element);
				gridArr.add(gridObj);
			}
			for(int k=0;k<newGrpArr.size();k++)
			{
				String newCompGrp = (String)newGrpArr.get(k);
				StringTokenizer strTok = new StringTokenizer(newCompGrp,":");
				int count = strTok.countTokens();
				String compType = "";
				String compName = "";
				String nullVal = "";
				if(count>=3)
				{
					compType = strTok.nextToken();
					compName = strTok.nextToken();
					nullVal = strTok.nextToken();
				}
				grpObj.put("groupname",compName);
				grpArr.add(grpObj);
			}
		}
		else if(isComplete)
		{
			String inCompleteString = " No link(s) from the following leading components !";
			rootJson.put("inCompleteString",_mapping.getTextDescription("admin.topology."+inCompleteString));

				for(int k=0;k<incompleteList.size();k++)
				{
					String element = (String) incompleteList.get(k);
					StringTokenizer st = new StringTokenizer(element,":");
					int count = st.countTokens();
					String compType = "";
					String hostName = "";
					String portNo = "";
					String sid = "-";
					boolean isOraServer = false;
					if(count == 3)
					{
						compType = st.nextToken();
						hostName = st.nextToken();
						portNo = st.nextToken();
					}
					else if(count == 4)	// Only for Oracle_Database Component
					{
						compType = st.nextToken();
						hostName = st.nextToken();
						portNo = st.nextToken();
						sid = st.nextToken();
						isOraServer = true;
					}
					if(portNo.equals("NULL"))
							portNo ="-";

					if(isOraServer)
					{
						hostName = hostName+"("+sid+")";
					}
					gridObj.put("Hostname",hostName);
					gridObj.put("Port",portNo);
					gridObj.put("Comptype",_mapping.getComponentTypeDescription(compType));
					gridObj.put("Cbvalue",element);
					gridArr.add(gridObj);
				}
		}
		else if(isNewDiscGrp)
		{
			for(int k=0;k<newGrpArr.size();k++)
			{
				String newCompGrp = (String)newGrpArr.get(k);
				StringTokenizer strTok = new StringTokenizer(newCompGrp,":");
				int count = strTok.countTokens();
				String compType = "";
				String compName = "";
				if(count>=3)
				{
					compType = strTok.nextToken();
					compName = strTok.nextToken();
				}
				grpObj.put("groupname",compName);
				grpArr.add(grpObj);
			}
		}
		else
		{
			String msgString ="";
			if(isSave)
			{
				msgString = "admin.servertypes.Do you want to save this segment?";
			}
			else
			{
				msgString = "admin.servertypes.All the components are already managed in this segment !";
			}
			rootJson.put("addToGroup",addToGroup);
			rootJson.put("addToZone",addToZone);
			if(!saveAs)
			{
				if(isSave)
				{
					if(addToGroup)
					{
						Enumeration keys = compHash.keys();
						while(keys.hasMoreElements())
						{
							String group = (String)keys.nextElement();
							ArrayList componentList = (ArrayList)compHash.get(group);
							rootJson.put("RecentlyAddedtoGroup",group);

							for(int k=0;k<componentList.size();k++)
							{
								String element = (String) componentList.get(k);
								StringTokenizer st = new StringTokenizer(element,":");
								int count = st.countTokens();
								String compType = "";
								String hostName = "";
								String portNo = "";
								String sid = "-";
								boolean isOraServer = false;
								if(count == 3)
								{
									compType = st.nextToken();
									hostName = st.nextToken();
									portNo = st.nextToken();
								}
								else if(count == 4)	// Only for Oracle_Database Component
								{
									compType = st.nextToken();
									hostName = st.nextToken();
									portNo = st.nextToken();
									sid = st.nextToken();
									isOraServer = true;
								}
								if(portNo.equals("NULL"))
										portNo ="-";

								if(isOraServer)
								{
									hostName = hostName+"("+sid+")";
								}
								groupCompObj.put("Hostname",hostName);
								groupCompObj.put("Port",portNo);
								groupCompObj.put("Comptype",_mapping.getComponentTypeDescription(compType));
								groupCompObj.put("Cbvalue",element);
								groupCompArr.add(groupCompObj);
							}
						}
					}
					if(addToZone)
					{
						if(zone.equals("-1"))
							rootJson.put("RecentlyAddedtoZone","Default");
						else
							rootJson.put("RecentlyAddedtoZone",zone);

						for(int k=0;k<addTothisZone.size();k++)
						{
							String element = (String) addTothisZone.get(k);
							StringTokenizer st = new StringTokenizer(element,":");
							int count = st.countTokens();
							String compType = "";
							String hostName = "";
							String portNo = "";
							String sid = "-";
							boolean isOraServer = false;
							if(count == 3)
							{
								compType = st.nextToken();
								hostName = st.nextToken();
								portNo = st.nextToken();
							}
							else if(count == 4)	// Only for Oracle_Database Component
							{
								compType = st.nextToken();
								hostName = st.nextToken();
								portNo = st.nextToken();
								sid = st.nextToken();
								isOraServer = true;
							}
							if(portNo.equals("NULL"))
									portNo ="-";
							if(!compGroupList.contains(element))
							{
								if(isOraServer)
								{
									hostName = hostName+"("+sid+")";
								}
								zoneCompObj.put("Hostname",hostName);
								zoneCompObj.put("Port",portNo);
								zoneCompObj.put("Comptype",_mapping.getComponentTypeDescription(compType));
								zoneCompObj.put("Cbvalue",element);
								zoneCompArr.add(zoneCompObj);
							}
						}
					}
					rootJson.put("RecentlyAddedtoSegment",segment);

					for(int k=0;k<segComponents.size();k++)
					{
						String element = (String) segComponents.get(k);
						StringTokenizer st = new StringTokenizer(element,":");
						int count = st.countTokens();
						String compType = "";
						String hostName = "";
						String portNo = "";
						String sid = "-";
						boolean isOraServer = false;
						if(count == 3)
						{
							compType = st.nextToken();
							hostName = st.nextToken();
							portNo = st.nextToken();
						}
						else if(count == 4)	// Only for Oracle_Database Component
						{
							compType = st.nextToken();
							hostName = st.nextToken();
							portNo = st.nextToken();
							sid = st.nextToken();
							isOraServer = true;
						}
						if(portNo.equals("NULL"))
								portNo ="-";
						if(!compGroupList.contains(element))
						{
							if(isOraServer)
							{
								hostName = hostName+"("+sid+")";
							}
							segmentCompObj.put("Hostname",hostName);
							segmentCompObj.put("Port",portNo);
							segmentCompObj.put("Comptype",_mapping.getComponentTypeDescription(compType));
							segmentCompObj.put("Cbvalue",element);
							segmentCompArr.add(segmentCompObj);
						}
					}
				}
			}
			else if(saveAs)
			{

			}
		}
	}
	rootJson.put("CommonGrid",gridArr);
	rootJson.put("saveTopoArr",saveTopoArr);
	rootJson.put("CommonGrpGrid",grpArr);
	rootJson.put("GroupGrid",groupCompArr);
	rootJson.put("ManagedGroupGrid",managedgrpArr);
	rootJson.put("ZoneGrid",zoneCompArr);
	rootJson.put("SegmentGrid",segmentCompArr);
	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());
}
catch(Exception e)
{
	System.out.println("Exception in EgAutoManagePage.jsp");
	e.printStackTrace();
}
%>

<%!
	/*
		This method returns, list of New & Unmanaged components form the given segment name
	*/
	private Hashtable getUnmanageAndNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		ArrayList newList = new ArrayList();
		ArrayList unmanageList = new ArrayList();
		ArrayList manageList = new ArrayList();
		Set newSet = new TreeSet();
		Set manageSet = new TreeSet();
		Set unmanageSet = new TreeSet();

		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			String manageValue = disIniFile.getValue(thisCompName,varName);
			
			if(manageValue!=null && manageValue.length() > 0)
			{
				manageSet.add(varName);
			}
			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else // Check for unmanage component
			{
				String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
				if(unmanageValue!=null && unmanageValue.length() > 0)
				{
					unmanageSet.add(varName);
				}
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				String manageval = disIniFile.getValue(tmpcompname,tmpvar);
				if(manageval!=null && manageval.length() > 0)
				{
					if(manageValue!=null && manageValue.length() > 0)
					{
						manageSet.add(tmpvar);
					}
				}
				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else
				{
					String unmanageValue = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
					if(unmanageValue!=null && unmanageValue.length() > 0)
					{
						unmanageSet.add(tmpvar);
					}
				}
			}
		}

		if(newSet!=null && newSet.size() > 0)
			newList = new ArrayList(newSet);
		if(unmanageSet!=null && unmanageSet.size() > 0)
			unmanageList = new ArrayList(unmanageSet);
		if(manageSet!=null && manageSet.size() > 0)
		{
			manageList = new ArrayList(manageSet);
		}
		result.put("NEW" , newList);
		result.put("UNMANAGE" , unmanageList);
		result.put("MANAGE" , manageList);
		return result;
	}

	private ArrayList getNewDiscGrp(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile autoTopoFile = new IniFile(iniFilePath);
		String[] segVar = autoTopoFile.getVariables(segmentName); 
		ArrayList newGrp = new ArrayList();
		//boolean isManGrp = false;
		for(int k=0; k<segVar.length; k++)
		{
			String var = segVar[k];
			String val = autoTopoFile.getValue(segmentName,var);
			StringTokenizer compTok = new StringTokenizer(val,",");
			while(compTok.hasMoreTokens())
			{
				String singleComp = compTok.nextToken();
				if(singleComp.startsWith("DGroup:"))
				{
					boolean isManGrp = isManagedGrp(singleComp,segmentName);
					if(!isManGrp && !newGrp.contains(singleComp))
					{
						newGrp.add(singleComp);
					}
				}
			}
		}
		return newGrp;
	}
	private ArrayList getManagedGrp(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile autoTopoFile = new IniFile(iniFilePath);
		String[] segVar = autoTopoFile.getVariables(segmentName); 
		ArrayList manGrp = new ArrayList();
		for(int k=0; k<segVar.length; k++)
		{
			String var = segVar[k];
			String val = autoTopoFile.getValue(segmentName,var);
			StringTokenizer compTok = new StringTokenizer(val,",");
			while(compTok.hasMoreTokens())
			{
				String singleComp = compTok.nextToken();
				if(singleComp.startsWith("DGroup:"))
				{
					boolean isManGrp = isManagedGrp(singleComp);
					if(isManGrp && !manGrp.contains(singleComp))
					{
						manGrp.add(singleComp);
					}
				}
			}
		}
		return manGrp;
	}

	private ArrayList getSegmentComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		ArrayList result = new ArrayList();
		Set thisSet = new TreeSet();
		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompType = varName.substring(0,varName.indexOf(":"));
			thisSet.add(varName);
			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcomptype = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				thisSet.add(tmpvar);
			}
		}
		if(thisSet!=null && thisSet.size() > 0){
			result = new ArrayList(thisSet);
		}
		return result;
	}

	public ArrayList getSingleLeadingComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		ArrayList result = new ArrayList();
		String[] varArray = iniFile.getVariables(segmentName);
		ArrayList valueList =new ArrayList();
		for(int v=0;v<varArray.length;v++)
		{
			String variable = (String)varArray[v];
			String value = iniFile.getValue(segmentName,variable);
			if(value!=null && !value.equals("") && !value.equals("null"))
			{
				StringTokenizer stz = new StringTokenizer(value,",");
				while(stz.hasMoreTokens())
				{
					String tkn = (String)stz.nextToken();
					String finalTkn = tkn.substring(0,tkn.lastIndexOf(":"));
					if(!valueList.contains(finalTkn))
						valueList.add(finalTkn);
				}
			}
		}
		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
			{
				if(!valueList.contains(varName))
					result.add(varName);
			}
		}
		return result;
	}
	public boolean isManagedGrp(String autoGrpName)
	{
		EgGroupInfo groupInfo = new EgGroupInfo();
		if(autoGrpName.startsWith("DGroup:"))
		{
			autoGrpName = autoGrpName.replace("DGroup:","");
			if(autoGrpName.endsWith(":L"))
			{
				autoGrpName = autoGrpName.replace(":L","");
			}

			if(autoGrpName.endsWith(":NULL"))
			{
				autoGrpName = autoGrpName.replace(":NULL","");
			}
			
		}
		boolean isManaged = false;
		String[] grpNames = groupInfo.getGroupNames();
		for(int k=0; k<grpNames.length; k++)
		{
			String grpName = grpNames[k];
			if(grpName.equalsIgnoreCase(autoGrpName))
			{
				isManaged = true;
			}
		}
		return isManaged;
	}
	
	public boolean isManagedGrp(String autoGrpName, String segmentName)
	{
		EgGroupInfo groupInfo = new EgGroupInfo();
		if(autoGrpName.startsWith("DGroup:"))
		{
			autoGrpName = autoGrpName.replace("DGroup:","");
			if(autoGrpName.endsWith(":L"))
			{
				autoGrpName = autoGrpName.replace(":L","");
			}

			if(autoGrpName.endsWith(":NULL"))
			{
				autoGrpName = autoGrpName.replace(":NULL","");
			}
			
		}
		String siteName = getSiteMappingForGroup(autoGrpName,segmentName);
		String grpNameWithSite = autoGrpName;
		if(siteName != null && siteName.length() > 0)
		{
			grpNameWithSite=siteName+"#"+autoGrpName;
		}
		boolean isManaged = false;
		String[] grpNames = groupInfo.getAllComponentsFromAutoGroups();
		for(int k=0; k<grpNames.length; k++)
		{
			String grpName = grpNames[k];
			if(grpName.indexOf(grpNameWithSite) >= 0)
			{
				isManaged = true;
			}
		}
		return isManaged;
	}
	public String getSiteMappingForGroup(String groupName, String segmentName )
	{
		String result = "";
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile autoiniFile = new IniFile(iniFilePath);
		String grpName = "DGroup:"+groupName+":NULL:L";
		String[] varArray = autoiniFile.getVariables(segmentName);
		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String valName = autoiniFile.getValue(segmentName,varName);
			if(valName == null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens()){
				String tok = st.nextToken();
				if(tok.equalsIgnoreCase(grpName))
				{
					result = getSiteMapping(varName+":L",segmentName);
				}
			}
		}
		return result;
	}
	public String getSiteMapping(String compName, String segmentName)
	{
		String siteComp = "";
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile autoiniFile = new IniFile(iniFilePath);
		String[] varArray = autoiniFile.getVariables(segmentName);
		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String valName = autoiniFile.getValue(segmentName,varName);
			boolean isFound = false;
			if(valName == null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens()){
				String tok = st.nextToken();
				if(tok.equalsIgnoreCase(compName))
				{
					siteComp = varName;
					isFound = true;
					break;
				}
			}
			if (isFound)
			{
				break;
			}
		}
		return siteComp;
	}
%>