<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@page import="com.eg.EgAggregateInfo"%>
<%@ page import="com.egurkha.*"%>
<%@ page import  = "com.eg.UpdateAndTransmitSiteInfo"%>
<%@ page import = "com.eg.EgGroupInfo" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgDiscInfo" %>
<%@ page import="com.eg.EgTopoInfo" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import="java.io.*" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.egurkha.EgConstants" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>
<%@ page import = "com.egurkha.EgNewTopology" %>
<%@ page import = "com.eg.TopoRhsComp" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<jsp:useBean id="user" class="egurkha.UserBean" scope="page"/>

<%!
	/*
		This method returns, list of New & Unmanaged components form the given segment name
	*/
	private Hashtable getUnmanageAndNewComponents(String segmentName)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		String disIniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_discover.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		IniFile disIniFile = new IniFile(disIniFilePath);
		String newstr = "#New|";
		String unmanagestr = "#Unmanage|";
		
		Hashtable result = new Hashtable();
		//ArrayList newList = new ArrayList();
		//ArrayList unmanageList = new ArrayList();

		Set newSet = new TreeSet();
		Set unmanageSet = new TreeSet();

		String[] varArray = iniFile.getVariables(segmentName);

		for(int k=0;k<varArray.length;k++)
		{
			String varName = varArray[k];
			String thisCompName = varName.substring(0,varName.indexOf(":"));
			String newValue = disIniFile.getValue(thisCompName,newstr+varName);
			if(newValue!=null && newValue.length() > 0)	// Check for new component
			{
				newSet.add(varName);
			}
			else	// Check for unmanage component
			{
				String unmanageValue = disIniFile.getValue(thisCompName,unmanagestr+varName);
				if(unmanageValue!=null && unmanageValue.length() > 0)
				{
					unmanageSet.add(varName);
				}
			}

			String valName = iniFile.getValue(segmentName,varName);
			if(valName!=null && valName.equals("null"))
				continue;
			StringTokenizer st = new StringTokenizer(valName,",");
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				String tmpcompname = tok.substring(0,tok.indexOf(":"));
				String tmpvar = tok.substring(0,tok.lastIndexOf(":"));
				String newval = disIniFile.getValue(tmpcompname,newstr+tmpvar);
				if(newval!=null && newval.length() > 0)
				{
					newSet.add(tmpvar);
				}
				else
				{
					String unmanageValue = disIniFile.getValue(tmpcompname,unmanagestr+tmpvar);
					if(unmanageValue!=null && unmanageValue.length() > 0)
					{
						unmanageSet.add(tmpvar);
					}
				}
			}
		}

		/*if(newSet!=null && newSet.size() > 0)
			newList = new ArrayList(newSet);
		if(unmanageSet!=null && unmanageSet.size() > 0)
			unmanageList = new ArrayList(unmanageSet);*/
		result.put("NEW" , newSet);
		result.put("UNMANAGE" , unmanageSet);
		return result;
	}

	private String getTopologyString(String segmentName, String site , String phyTopology)
	{
		String iniFilePath = EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini";
		IniFile iniFile = new IniFile(iniFilePath);
		//EgCrawler strBean = new EgCrawler(iniFile);
		String str = null;
		if (phyTopology.equals("1"))
		{
			String[] lines = iniFile.getLinesUnderSubject(segmentName);
			if(lines!=null)
			{
				//str = strBean.getPhysicalTopology(segmentName ,lines);
				str = getPhysicalTopology(segmentName ,lines);
			}
		}
		AlarmPriorities ap = AlarmPriorities.getInstance();
		String newString = null;
		if (StringUtils.isNull(str))
			newString = EgConstants.BLANK_SPACE;
		else
			//newString = str; //ap.getTopologyPriority(str, site);
			newString = ap.getTopologyPriority(str, site);
		newString = sortTopoString(newString);
		return newString;
	}

	public String getPhysicalTopology(String s_segment, String[] lines)
	{
		if(lines==null)
			return "";
		StringBuffer s_pt = new StringBuffer("Web_site:egurkha.physical.topology=");
		try
		{
			String[] s_var = null;
			ArrayList valList = new ArrayList();
			Hashtable myHt = new Hashtable();
			String state = "NO";
			if (s_segment != null && (!s_segment.equals("null")))
			{
				//s_subject = s_segment;
				for(int i=0;i<lines.length;i++)
				{
					String thisLine = lines[i];
					String thisvar = thisLine.substring(0,thisLine.indexOf("="));
					String thisval = thisLine.substring(thisLine.indexOf("=")+1);
					valList.add(thisvar);
					myHt.put(thisvar,thisval);
				}
				s_var = (String []) valList.toArray (new String [valList.size ()]);
			}
			if (s_var == null || s_var.length < 1)
			{
				return "";
			}
			//setConnection();
			Vector v_com =  new Vector(); //getAllValues(s_subject, s_var, "NO");

			//Get All Values (Begin)
			for (int q = 0; q < s_var.length; q++)
			{
				String thisVar = s_var[q];
				if (thisVar.startsWith("#"))
				{
					continue;
				}
				String s_temp = (String) myHt.get(thisVar);
				if (s_temp.indexOf(",") > 0)
				{
					StringTokenizer st = new StringTokenizer(s_temp, ",");
					while (st.hasMoreTokens())
					{
						if (state.equals("YES"))
						{
							v_com.addElement(st.nextToken());
						}
						else
						{
							String ss = st.nextToken();
							v_com.addElement(ss.substring(0, ss.lastIndexOf(":")));
						}
					}
				}
				else if (!s_temp.equals("null"))
				{
					if (state.equals("YES"))
					{
						v_com.addElement(s_temp);
					}
					else
					{
						v_com.addElement(s_temp.substring(0, s_temp.lastIndexOf(":")));
					}
				}
			}
			//Get All Values (End)

			Vector v_unAssgnList=new Vector();
			StringBuffer s_fline = new StringBuffer();
			int maxCount = s_var.length;

			for (int j = 0; j < maxCount; j++)
			{
				if (s_var[j].startsWith("#"))
					continue;

				if (!v_com.contains(s_var[j]))
				{
					//s_fline.append(s_var[j] +":N:"+ getState(s_var[j], "NULL") +",");
					s_fline.append(s_var[j] +":N:"+ "GOOD" +",");
					v_unAssgnList.add(s_var[j]);
				}
			}
			if (s_fline.toString().endsWith(","))
			{
				int bufferLength = s_fline.length();
				s_fline.delete(bufferLength-1, bufferLength);
			}

			s_pt.append(s_fline.toString());

			while(v_unAssgnList.size()>0)
			{
				String s_key = (String)v_unAssgnList.get(0);
				String s_val = (String) myHt.get(s_key);
				if (s_val==null || s_val=="")			//if there cud be any issue with end component of topology node
					s_val = "null";

				s_pt.append("|" + s_key + "=");

				if(!s_val.equalsIgnoreCase("null"))
				{
					if(s_val.indexOf(",") > -1)
					{
						StringTokenizer st = new StringTokenizer(s_val,",");
						while(st.hasMoreTokens())
						{
							String s_token= st.nextToken().trim();
							String s_comp=s_token.substring(0, s_token.lastIndexOf(":"));
							s_pt.append(s_token + ":" + "GOOD");
							if (st.hasMoreTokens())
								s_pt.append(",");
							if(!v_unAssgnList.contains(s_comp)) v_unAssgnList.add(s_comp);
						}
					}
					else
					{
						String s_comp = s_val.substring(0, s_val.lastIndexOf(":"));
						s_pt.append(s_val +":"+"GOOD");
						if(!v_unAssgnList.contains(s_comp)) v_unAssgnList.add(s_comp);
					}
				}
				else
				{
					s_pt.append("null");
				}
				v_unAssgnList.removeElementAt(0);
			}
			//releaseConnection(false);
		}
		catch (Exception e)
		{
			System.out.println("Exception in getPhysicalTopology............");
			e.printStackTrace();
			//releaseConnection(true);
			return "";
		}
		return s_pt.toString();
	}

	/*
	To sort the topology string so that the new topology applet will understand
	*/
	public String sortTopoString(String topoStr) 
	{
		if(topoStr==null)
			return null;
		Hashtable h = new Hashtable();

		String [] topoToks = StringUtils.getTokens(topoStr, "|");

		ArrayList finalLhs = new ArrayList();
		ArrayList finalRhs = new ArrayList();
		ArrayList leftOver = new ArrayList();
		boolean changesOccured = false;
		while (!changesOccured)	 //loop until sorted properly changesOccured becomes true
		{
			changesOccured = true;	
			for (int i=0;i<topoToks.length ;i++ )
			{
				String [] relation = StringUtils.getTokens(topoToks[i], "=");
				String thisLhs ="";
				String thisRhs ="";
				if(relation!=null && relation.length==2)
				{
				 thisLhs = relation[0];
				 thisRhs = relation[1];	//Network_node:Core_Switch_1:NULL:N:GOOD,Network_node:Core_Switch_2:NULL:N:GOOD
				}
				else if(relation!=null && relation.length==1)
				{
					thisLhs = relation[0];
				}
				//System.out.println("! thisLhs:"+thisLhs);
				if (i==0)
				{
					//add first component
					if (finalLhs.indexOf(thisLhs)==-1)	 //if lhs is already added, skip
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}
				}else
				{
					Object rhsObj = h.get(thisLhs);
					/*
						if rhsObj is null, it means that we get a wrong entry, i.e. the component comes in improper order. 
						a component which havnt come in rhs, has been given as lhs. so dont add it right now. wait until the 
						necessary rhs is getting added.
					*/
					if (rhsObj!=null && finalLhs.indexOf(thisLhs)==-1)
					{
						finalLhs.add(thisLhs);
						finalRhs.add(getRhsList(thisRhs, thisLhs, h));
					}else
					{
						if (rhsObj==null)				//if rhsObj is null, it means that some component is not yet added
							changesOccured = false;
					}
				}
			}
		}

		StringBuffer sb = new StringBuffer();
		for (int i=0;i<finalLhs.size() ;i++ )
		{
			String thisStr = (String)finalLhs.get(i);
			ArrayList rhsList = (ArrayList) finalRhs.get(i);
			Iterator myIter = rhsList.iterator();
			StringBuffer sb2 = new StringBuffer();
			while (myIter.hasNext())
			{
				TopoRhsComp thisRhsComp = (TopoRhsComp) myIter.next();
				sb2.append(thisRhsComp.getComponent());
				if (myIter.hasNext())
					sb2.append(",");
			}
			sb.append(finalLhs.get(i));
			sb.append("=");
			sb.append(sb2.toString());
			sb.append("|");
		}
		String result = sb.toString();
		if (result.endsWith("|"))
		{
			result = result.substring(0, result.lastIndexOf("|"));
		}
		return result;
	}

	public ArrayList getRhsList(String thisRhs, String thisLhs, Hashtable h)
	{
		ArrayList result = new ArrayList();
		if(thisRhs!=null && !thisRhs.equals(""))
		{
			String [] toks = StringUtils.getTokens(thisRhs, ",");
			for (int i=0;i<toks.length ;i++ )
			{
				String thisStr = toks[i];
				TopoRhsComp rhsCmp = new TopoRhsComp(thisStr);
				result.add(rhsCmp);
				//System.out.println("$$$$$:"+rhsCmp.toString()+"\t"+thisLhs);
				if (!rhsCmp.toString().equals("null"))
				{
					h.put(rhsCmp.toString(), thisLhs);
				}
			}
		}
		return result;
	}

	public Hashtable getSegmentComps(String segment)
	{
		Hashtable result = new Hashtable();
		IniFile autoTopoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");

		String[] thisSegVar = autoTopoIniFile.getVariables(segment);
		if(thisSegVar!=null && thisSegVar.length > 0)
		{
			for(int k=0;k<thisSegVar.length;k++)
			{
				String varName = thisSegVar[k];
				String thisServerType = varName.substring(0,varName.indexOf(":"));
				String compName =  varName.substring(varName.indexOf(":")+1);

				if(result.containsKey(thisServerType))
				{
					ArrayList tmpList = (ArrayList) result.get(thisServerType);
					if(!tmpList.contains(compName))
					{
						tmpList.add(compName);
						result.put(thisServerType,tmpList);
					}
				}
				else
				{
					ArrayList tmpList =new ArrayList();
					tmpList.add(compName);
					result.put(thisServerType,tmpList);
				}

				String thisSegValue = autoTopoIniFile.getValue(segment, varName);
				StringTokenizer st = new StringTokenizer(thisSegValue,",");
				while(st.hasMoreTokens())
				{
					String thistoken = st.nextToken();
					if(thistoken!=null && thistoken.equals("null"))
						continue;
					String thiscomp = thistoken.substring(0,thistoken.lastIndexOf(":"));
					String this_server_type = thiscomp.substring(0,thiscomp.indexOf(":"));
					String this_compname = thiscomp.substring(thiscomp.indexOf(":")+1);
					if(result.containsKey(this_server_type))
					{
						ArrayList tmpList = (ArrayList) result.get(this_server_type);
						if(!tmpList.contains(this_compname))
						{
							tmpList.add(this_compname);
							result.put(this_server_type,tmpList);
						}
					}
					else
					{
						ArrayList tmpList =new ArrayList();
						tmpList.add(this_compname);
						result.put(this_server_type,tmpList);
					}
				}
			}
		}
		return result;
	}

	private Hashtable getGroupDetails(EgGroupInfo egGroupInfo)
	{
		// Collect Group Details, if Group Exists
		Hashtable result = new Hashtable();
		List groupList = new ArrayList();
		String[] groupComponents = egGroupInfo.getAllComponentsFromGroups();
		if(groupComponents!=null && groupComponents.length > 0)
		{
			for(int k=0;k<groupComponents.length;k++)
			{
				String groupVariable = groupComponents[k];
				String groupValue = egGroupInfo.getValue("GROUP_DETAILS", groupVariable);
				result.put(groupVariable , groupValue);
			}
		}
		return result;
	}

	public Hashtable getStartCompsFromTopoAuto(ArrayList allZoneCompList)
	{
		Hashtable result = new Hashtable();
		IniFile autoTopoIniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_autotopology.ini");
		String autoSubject = "Topo_Auto";
		String[] autoVar = autoTopoIniFile.getVariables(autoSubject);
		EgGroupInfo egGroupInfo = new EgGroupInfo();

		Hashtable groupTable = getGroupDetails(egGroupInfo);
		boolean isGroupExists = false;
		if(groupTable!=null && groupTable.size() > 0)
			isGroupExists = true;

		for(int k=0;k<autoVar.length;k++)
		{
			String varName = autoVar[k];
			String valName = autoTopoIniFile.getValue(autoSubject,varName);
			if(allZoneCompList.contains(varName))
				continue;

			StringTokenizer st = new StringTokenizer(valName,",");
			boolean isValid = false;
			while(st.hasMoreTokens())
			{
				String tok = st.nextToken();
				tok = tok.substring(0,tok.lastIndexOf(":"));
				if(!allZoneCompList.contains(tok))
				{
					isValid = true;
					break;
				}
			}

			if(isValid)
			{
				String thisServerType = "";
				String compName = "";

				if(isGroupExists && groupTable.containsKey(varName))
				{
					String groupName = (String) groupTable.get(varName);
					boolean checkFlag = checkFunction(valName, groupName, egGroupInfo);
					if(checkFlag)
					{
						thisServerType = "Group";
						compName = groupName+":"+"NULL";
					}
				}
				else
				{
					thisServerType = varName.substring(0,varName.indexOf(":"));
					compName =  varName.substring(varName.indexOf(":")+1);
				}

				if(thisServerType.equals(""))
					continue;

				if(result.containsKey(thisServerType))
				{
					ArrayList tmpList = (ArrayList) result.get(thisServerType);
					if(!tmpList.contains(compName))
					{
						tmpList.add(compName);
						result.put(thisServerType,tmpList);
					}
				}
				else
				{
					ArrayList tmpList =new ArrayList();
					tmpList.add(compName);
					result.put(thisServerType,tmpList);
				}
			}
		}
		return result;
	}

	private boolean checkFunction(String valueString, String groupName , EgGroupInfo egGroupInfo)
	{
		boolean flag = false;
		StringTokenizer strTokenizer = new StringTokenizer(valueString,",");
		ArrayList groupCompList = egGroupInfo.getAllComponentsUnderGroup(groupName);
		while(strTokenizer.hasMoreTokens())
		{
			String val = strTokenizer.nextToken();
			val = val.substring(0,val.lastIndexOf(":"));
			if(!groupCompList.contains(val))
			{
				flag = true;
				break;
			}
		}
		return flag;
	}
%>
<%

	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	boolean segLimitExceed = false;
	if(!user.checkSegmentCount())
	{
		segLimitExceed = true;
	}
	rootJson.put("segLimitExceed",segLimitExceed);
	// My code starts // 
	EgGroupInfo groupInfo = new EgGroupInfo();
	ArrayList thisZoneComponents = new ArrayList();	// Contains all components from the given zone.
	ArrayList allZoneComponents = new ArrayList();	// Contains all components from all Zones Except the selected Zone
	String zone = request.getParameter("zone");
	String segmentName = request.getParameter("segment");
	String zoomLevel = request.getParameter("zoom");
	String site = request.getParameter("site");
	String phyTopology = request.getParameter("physical_topology");

	String hlc_type = request.getParameter("hlcomptype");	// High_Lighted_CompType
	String hlc = request.getParameter("hlcomp");			// High_Lighted_Comp
	if(hlc_type == null) 
		hlc_type = "";
	if(hlc == null)
		hlc = "";
	String color = "A0A0A0";
	String dark = "150517";
	if(zoomLevel == null) zoomLevel = "100";
	if(phyTopology == null) phyTopology = "1";
	if(site == null) site = "egurkha.physical.topology";
	boolean isEntry = false;
	String conPath = request.getContextPath();
	String contextPath = request.getContextPath()+"/admin/eg_images/";
	String finalTopoStr = new String();

	// Collect Zone componets, if zone is not Default
	boolean isZone = false;
	if(zone!=null && !zone.equals("-1")){
		thisZoneComponents = groupInfo.getAllComponentsUnderZone(zone);
		isZone = true;
	}

	Hashtable tmpHt = groupInfo.getAllComponentsUnderZone();
	if(tmpHt!=null && tmpHt.size() > 0)
	{
		if(isZone && tmpHt.containsKey(zone)){
			tmpHt.remove(zone);
		}
		ArrayList valList = new ArrayList(tmpHt.values());
		for(int k=0;k<valList.size();k++)
		{
			ArrayList tmpList = (ArrayList) valList.get(k);
			
			allZoneComponents.addAll(tmpList);
		}
	}

/* New Coding Starts here */
	String mode=request.getParameter("mode");
	if(mode==null)
		mode="add";
	String comptype = request.getParameter("comptype");
	if(comptype==null) comptype="";
	String compname = request.getParameter("compname");
	if(compname==null) compname="";
	Hashtable compList = getStartCompsFromTopoAuto(allZoneComponents); 
	Hashtable segmentCompTable = getSegmentComps(segmentName);
	//Remove segment components from compList...(Begin)
	if(segmentCompTable!=null && segmentCompTable.size() > 0)
	{
		Set myKeys = segmentCompTable.keySet();
		Iterator myItr = myKeys.iterator();
		while(myItr.hasNext())
		{
			String myKey  = (String) myItr.next();
			ArrayList totalList = (ArrayList) compList.get(myKey);
			if(totalList!=null && totalList.size() > 0)
			{
				ArrayList myList = (ArrayList) segmentCompTable.get(myKey);
				if(myList!=null && myList.size() > 0)
				{
					boolean remove = false;
					for(int k=0;k<myList.size();k++)
					{
						String thisString = (String) myList.get(k);
						int index = totalList.indexOf(thisString);
						if(index >= 0)
						{
							totalList.remove(index);
							remove = true;
						}
					}
					if(remove)
					{
						if(totalList.size() > 0)
							
							compList.put(myKey, totalList);
						else
							compList.remove(myKey);
					}
				}
			}
		}
	}
	//Remove segment components from compList...(End)
	ArrayList serverTypes = new ArrayList();
	ArrayList compNames = new ArrayList(); 
	if(compList!=null && compList.size() > 0)
	{
		Set compTypeSet = compList.keySet();
		if(compTypeSet!=null && compTypeSet.size() > 0)
		{
			serverTypes = new ArrayList(compTypeSet);
			Collections.sort(serverTypes);
		}
		if(comptype!=null && comptype.length() > 0)
		{
			compNames = (ArrayList) compList.get(comptype);
			if(compNames!=null)
				Collections.sort(compNames);
		}
	}
	
	JSONArray compTypeArray = new JSONArray();
	JSONObject compTypeObject = new JSONObject();

	compTypeObject.put("displayField","Choose one");
	compTypeObject.put("valueField","-1");
	compTypeArray.add(compTypeObject);
	for(int k=0;k<serverTypes.size();k++)
	{
		String selected="";
		String compType = (String)serverTypes.get(k);
		String mappingCompType = _mapping.getComponentTypeDescription(compType);

		//compTypeObject.put("displayField",compType);
		//compTypeObject.put("valueField",mappingCompType);
		compTypeObject.put("displayField",mappingCompType);
		compTypeObject.put("valueField",compType);
		compTypeArray.add(compTypeObject);
	}

	rootJson.put("ComponentTypeList",compTypeArray);

	JSONArray componentListArr = new JSONArray();
	JSONObject componentListObj = new JSONObject();
	componentListObj.put("displayField","Choose one");
	componentListObj.put("valueField","-1");
	componentListArr.add(componentListObj);
	if(compNames!=null)
	{
		for(int k=0;k<compNames.size();k++)
		{
			String cName = (String) compNames.get(k);
			String displayName = cName;
			if(displayName.indexOf(":NULL") > 0)
				displayName = displayName.substring(0,displayName.indexOf(":NULL"));

			//componentListObj.put("displayField",cName);
			//componentListObj.put("valueField",displayName);
			componentListObj.put("displayField",displayName);
			componentListObj.put("valueField",cName);
			componentListArr.add(componentListObj);
		}
	}

	rootJson.put("ComponentList",componentListArr);
	rootJson.put("mode",mode);
%>
	<jsp:useBean id="EgConfigTopo" scope="page" class="egurkha.ConfigTopology"/>
	<jsp:useBean id="zoneinfo" scope="page" class="egurkha.ZoneInfoBean"/>
	<jsp:useBean id="topobean" scope="page" class="egurkha.ConfigTopoBean"/>
	<jsp:useBean id="admintopo" scope="page" class="com.egurkha.admin.AdminTopologyBean"/>
<%
	JSONArray zoneArray = new JSONArray();
	JSONObject zoneObject = new JSONObject();

	String [] groups = zoneinfo.getZoneNames();
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	rootJson.put("isDouble",isDouble);
	int groupLength = groups.length;
	if ((groups != null) && (groupLength != 0))
	{
		rootJson.put("AssociatedToZone","true");
		zoneObject.put("displayField","None");
		zoneObject.put("valueField","-1");
		zoneArray.add(zoneObject);

		for (int i=0; i<groupLength; i++)
		{
			zoneObject.put("displayField",groups[i]);
			zoneObject.put("valueField",groups[i]);
			zoneArray.add(zoneObject);
		}
	}
	else
	{
		rootJson.put("AssociatedToZone","false");
	}
	rootJson.put("AssociatedZones",zoneArray);

	JSONArray imageArray = new JSONArray();
	JSONObject imageObject = new JSONObject();
	String imageVariable[]=null;
	IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	imageVariable = uiIni.getVariables("SEGMENT_IMAGE_MAPPING");
	
	if(imageVariable!=null && imageVariable.length>0)
	{
		for(int i=0; i<imageVariable.length;i++)
		{
			String displayText=imageVariable[i];
			String imgClassName = uiIni.getValue("SEGMENT_IMAGE_MAPPING",displayText);
			imageObject.put("abbr",imgClassName);
			imageObject.put("name",displayText);
			imageArray.add(imageObject);
		}
	}
	rootJson.put("imageArray",imageArray);

	out.println(rootJson.toString());
%>