DROP TABLE AzrADUsrAuthTest CASCADE CONSTRAINTS;
CREATE TABLE AzrADUsrAuthTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Total_User NUMBER(20,4) NOT NULL,
Total_User_ST varchar2(32) NOT NULL,
Mfa_Capable NUMBER(20,4) NOT NULL,
Mfa_Capable_ST varchar2(32) NOT NULL,
Mfa_NotCapable NUMBER(20,4) NOT NULL,
Mfa_NotCapable_ST varchar2(32) NOT NULL,
Passwordless_Capable NUMBER(20,4) NOT NULL,
Passwordless_Capable_ST varchar2(32) NOT NULL,
Passwordless_NotCapable NUMBER(20,4) NOT NULL,
Passwordless_NotCapable_ST varchar2(32) NOT NULL,
Sspr_Capable NUMBER(20,4) NOT NULL,
Sspr_Capable_ST varchar2(32) NOT NULL,
Sspr_NotCapable NUMBER(20,4) NOT NULL,
Sspr_NotCapable_ST varchar2(32) NOT NULL,
Mobile NUMBER(20,4) NOT NULL,
Mobile_ST varchar2(32) NOT NULL,
Email NUMBER(20,4) NOT NULL,
Email_ST varchar2(32) NOT NULL,
Software_token NUMBER(20,4) NOT NULL,
Software_token_ST varchar2(32) NOT NULL,
Alternative_mobile NUMBER(20,4) NOT NULL,
Alternative_mobile_ST varchar2(32) NOT NULL,
Office_phone NUMBER(20,4) NOT NULL,
Office_phone_ST varchar2(32) NOT NULL,
Password NUMBER(20,4) NOT NULL,
Password_ST varchar2(32) NOT NULL,
Temp_access_pass NUMBER(20,4) NOT NULL,
Temp_access_pass_ST varchar2(32) NOT NULL,
App_notification NUMBER(20,4) NOT NULL,
App_notification_ST varchar2(32) NOT NULL,
Hardware_token NUMBER(20,4) NOT NULL,
Hardware_token_ST varchar2(32) NOT NULL,
Passwordless_app NUMBER(20,4) NOT NULL,
Passwordless_app_ST varchar2(32) NOT NULL,
Wind_hello_for_business NUMBER(20,4) NOT NULL,
Wind_hello_for_business_ST varchar2(32) NOT NULL,
Fido2_security_key NUMBER(20,4) NOT NULL,
Fido2_security_key_ST varchar2(32) NOT NULL,
Security_question NUMBER(20,4) NOT NULL,
Security_question_ST varchar2(32) NOT NULL,
Total NUMBER(20,4) NOT NULL,
Total_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_AzrADUsrAuthTest ON AzrADUsrAuthTest(MSMT_TIME);
ALTER TABLE AzrADUsrAuthTest ADD constraint PK_AzrADUsrAuthTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE AzrADUsrAuthTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE AzrADUsrAuthTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_User_MIN Number(20,4) NOT NULL,
Total_User_MAX Number(20,4) NOT NULL,
Total_User_STCNT varchar2(32) NOT NULL,
Mfa_Capable_MIN Number(20,4) NOT NULL,
Mfa_Capable_MAX Number(20,4) NOT NULL,
Mfa_Capable_STCNT varchar2(32) NOT NULL,
Mfa_NotCapable_MIN Number(20,4) NOT NULL,
Mfa_NotCapable_MAX Number(20,4) NOT NULL,
Mfa_NotCapable_STCNT varchar2(32) NOT NULL,
Passwordless_Capable_MIN Number(20,4) NOT NULL,
Passwordless_Capable_MAX Number(20,4) NOT NULL,
Passwordless_Capable_STCNT varchar2(32) NOT NULL,
Passwordless_NotCapable_MIN Number(20,4) NOT NULL,
Passwordless_NotCapable_MAX Number(20,4) NOT NULL,
Passwordless_NotCapable_STCNT varchar2(32) NOT NULL,
Sspr_Capable_MIN Number(20,4) NOT NULL,
Sspr_Capable_MAX Number(20,4) NOT NULL,
Sspr_Capable_STCNT varchar2(32) NOT NULL,
Sspr_NotCapable_MIN Number(20,4) NOT NULL,
Sspr_NotCapable_MAX Number(20,4) NOT NULL,
Sspr_NotCapable_STCNT varchar2(32) NOT NULL,
Mobile_MIN Number(20,4) NOT NULL,
Mobile_MAX Number(20,4) NOT NULL,
Mobile_STCNT varchar2(32) NOT NULL,
Email_MIN Number(20,4) NOT NULL,
Email_MAX Number(20,4) NOT NULL,
Email_STCNT varchar2(32) NOT NULL,
Software_token_MIN Number(20,4) NOT NULL,
Software_token_MAX Number(20,4) NOT NULL,
Software_token_STCNT varchar2(32) NOT NULL,
Alternative_mobile_MIN Number(20,4) NOT NULL,
Alternative_mobile_MAX Number(20,4) NOT NULL,
Alternative_mobile_STCNT varchar2(32) NOT NULL,
Office_phone_MIN Number(20,4) NOT NULL,
Office_phone_MAX Number(20,4) NOT NULL,
Office_phone_STCNT varchar2(32) NOT NULL,
Password_MIN Number(20,4) NOT NULL,
Password_MAX Number(20,4) NOT NULL,
Password_STCNT varchar2(32) NOT NULL,
Temp_access_pass_MIN Number(20,4) NOT NULL,
Temp_access_pass_MAX Number(20,4) NOT NULL,
Temp_access_pass_STCNT varchar2(32) NOT NULL,
App_notification_MIN Number(20,4) NOT NULL,
App_notification_MAX Number(20,4) NOT NULL,
App_notification_STCNT varchar2(32) NOT NULL,
Hardware_token_MIN Number(20,4) NOT NULL,
Hardware_token_MAX Number(20,4) NOT NULL,
Hardware_token_STCNT varchar2(32) NOT NULL,
Passwordless_app_MIN Number(20,4) NOT NULL,
Passwordless_app_MAX Number(20,4) NOT NULL,
Passwordless_app_STCNT varchar2(32) NOT NULL,
Wind_hello_for_business_MIN Number(20,4) NOT NULL,
Wind_hello_for_business_MAX Number(20,4) NOT NULL,
Wind_hello_for_business_STCNT varchar2(32) NOT NULL,
Fido2_security_key_MIN Number(20,4) NOT NULL,
Fido2_security_key_MAX Number(20,4) NOT NULL,
Fido2_security_key_STCNT varchar2(32) NOT NULL,
Security_question_MIN Number(20,4) NOT NULL,
Security_question_MAX Number(20,4) NOT NULL,
Security_question_STCNT varchar2(32) NOT NULL,
Total_MIN Number(20,4) NOT NULL,
Total_MAX Number(20,4) NOT NULL,
Total_STCNT varchar2(32) NOT NULL);
ALTER TABLE AzrADUsrAuthTest_TREND ADD constraint PK_AzrADUsrAuthTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE AzrADUsrAuthTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AzrADUsrAuthTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_User_MIN varchar2(256) NOT NULL,
Total_User_MAX varchar2(256) NOT NULL,
Mfa_Capable_MIN varchar2(256) NOT NULL,
Mfa_Capable_MAX varchar2(256) NOT NULL,
Mfa_NotCapable_MIN varchar2(256) NOT NULL,
Mfa_NotCapable_MAX varchar2(256) NOT NULL,
Passwordless_Capable_MIN varchar2(256) NOT NULL,
Passwordless_Capable_MAX varchar2(256) NOT NULL,
Passwordless_NotCapable_MIN varchar2(256) NOT NULL,
Passwordless_NotCapable_MAX varchar2(256) NOT NULL,
Sspr_Capable_MIN varchar2(256) NOT NULL,
Sspr_Capable_MAX varchar2(256) NOT NULL,
Sspr_NotCapable_MIN varchar2(256) NOT NULL,
Sspr_NotCapable_MAX varchar2(256) NOT NULL,
Mobile_MIN varchar2(256) NOT NULL,
Mobile_MAX varchar2(256) NOT NULL,
Email_MIN varchar2(256) NOT NULL,
Email_MAX varchar2(256) NOT NULL,
Software_token_MIN varchar2(256) NOT NULL,
Software_token_MAX varchar2(256) NOT NULL,
Alternative_mobile_MIN varchar2(256) NOT NULL,
Alternative_mobile_MAX varchar2(256) NOT NULL,
Office_phone_MIN varchar2(256) NOT NULL,
Office_phone_MAX varchar2(256) NOT NULL,
Password_MIN varchar2(256) NOT NULL,
Password_MAX varchar2(256) NOT NULL,
Temp_access_pass_MIN varchar2(256) NOT NULL,
Temp_access_pass_MAX varchar2(256) NOT NULL,
App_notification_MIN varchar2(256) NOT NULL,
App_notification_MAX varchar2(256) NOT NULL,
Hardware_token_MIN varchar2(256) NOT NULL,
Hardware_token_MAX varchar2(256) NOT NULL,
Passwordless_app_MIN varchar2(256) NOT NULL,
Passwordless_app_MAX varchar2(256) NOT NULL,
Wind_hello_for_business_MIN varchar2(256) NOT NULL,
Wind_hello_for_business_MAX varchar2(256) NOT NULL,
Fido2_security_key_MIN varchar2(256) NOT NULL,
Fido2_security_key_MAX varchar2(256) NOT NULL,
Security_question_MIN varchar2(256) NOT NULL,
Security_question_MAX varchar2(256) NOT NULL,
Total_MIN varchar2(256) NOT NULL,
Total_MAX varchar2(256) NOT NULL);
ALTER TABLE AzrADUsrAuthTest_THRESH ADD constraint PK_AzrADUsrAuthTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AzrADUsrAuthTest_THRESH ON AzrADUsrAuthTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AzrADUsrAuthTest ON AzrADUsrAuthTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AzrADUsrAuthTest ON AzrADUsrAuthTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE O365CertNSecrtExpTest CASCADE CONSTRAINTS;
CREATE TABLE O365CertNSecrtExpTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CertExpiry Number(20,4) NOT NULL,
CertExpiry_ST varchar2(32) NOT NULL,
SecretExpiry Number(20,4) NOT NULL,
SecretExpiry_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_O365CertNSecrtExpTest ON O365CertNSecrtExpTest(MSMT_TIME);
ALTER TABLE O365CertNSecrtExpTest ADD constraint PK_O365CertNSecrtExpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE O365CertNSecrtExpTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365CertNSecrtExpTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CertExpiry_MIN Number(20,4) NOT NULL,
CertExpiry_MAX Number(20,4) NOT NULL,
CertExpiry_STCNT varchar2(32) NOT NULL,
SecretExpiry_MIN Number(20,4) NOT NULL,
SecretExpiry_MAX Number(20,4) NOT NULL,
SecretExpiry_STCNT varchar2(32) NOT NULL);
ALTER TABLE O365CertNSecrtExpTest_TREND ADD constraint PK_O365CertNSecrtExpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE O365CertNSecrtExpTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365CertNSecrtExpTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CertExpiry_MIN VARCHAR2(256) NOT NULL,
CertExpiry_MAX VARCHAR2(256) NOT NULL,
SecretExpiry_MIN VARCHAR2(256) NOT NULL,
SecretExpiry_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE O365CertNSecrtExpTest_THRESH ADD constraint PK_O365CertNSecrtExp_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365CertNSecrtExp_THRESH ON O365CertNSecrtExpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365CertNSecrtExpTest ON O365CertNSecrtExpTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365CertNSecrtExpTest ON O365CertNSecrtExpTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomServStatusTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomServStatusTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Status 			NUMBER(20,4) NOT NULL,
Status_ST 		varchar2(32) NOT NULL,
ScheduledMaintenance NUMBER(20,4) NOT NULL,
ScheduledMaintenance_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ZoomServStatusTest ON ZoomServStatusTest(MSMT_TIME);
ALTER TABLE ZoomServStatusTest ADD constraint PK_ZoomServStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomServStatusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomServStatusTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Status_MIN 		NUMBER(20,4) NOT NULL,
Status_MAX 		NUMBER(20,4) NOT NULL,
Status_STCNT 	varchar2(32) NOT NULL,
ScheduledMaintenance_MIN NUMBER(20,4) NOT NULL,
ScheduledMaintenance_MAX NUMBER(20,4) NOT NULL,
ScheduledMaintenance_STCNT varchar2(32) NOT NULL);

ALTER TABLE ZoomServStatusTest_TREND ADD constraint PK_ZoomServStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomServStatusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomServStatusTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Status_MIN 		varchar2(256) NOT NULL,
Status_MAX 		varchar2(256) NOT NULL,
ScheduledMaintenance_MIN varchar2(256) NOT NULL,
ScheduledMaintenance_MAX varchar2(256) NOT NULL);

ALTER TABLE ZoomServStatusTest_THRESH ADD constraint PK_ZoomServStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomServStatusTest_THRESH ON ZoomServStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomServStatusTest ON ZoomServStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomServStatusTest ON ZoomServStatusTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPIRoomsTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIRoomsTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOTotRo NUMBER(20,4) NOT NULL,
ZOTotRo_ST varchar2(32) NOT NULL,
ZOCritRo NUMBER(20,4) NOT NULL,
ZOCritRo_ST varchar2(32) NOT NULL,
ZOWarnRo NUMBER(20,4) NOT NULL,
ZOWarnRo_ST varchar2(32) NOT NULL,
ZOWORo NUMBER(20,4) NOT NULL,
ZOWORo_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPIRoomsTest ON ZoomAPIRoomsTest(MSMT_TIME);
ALTER TABLE ZoomAPIRoomsTest ADD constraint PK_ZoomAPIRoomsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPIRoomsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIRoomsTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOTotRo_MIN NUMBER(20,4) NOT NULL,
ZOTotRo_MAX NUMBER(20,4) NOT NULL,
ZOTotRo_STCNT varchar2(32) NOT NULL,
ZOCritRo_MIN NUMBER(20,4) NOT NULL,
ZOCritRo_MAX NUMBER(20,4) NOT NULL,
ZOCritRo_STCNT varchar2(32) NOT NULL,
ZOWarnRo_MIN NUMBER(20,4) NOT NULL,
ZOWarnRo_MAX NUMBER(20,4) NOT NULL,
ZOWarnRo_STCNT varchar2(32) NOT NULL,
ZOWORo_MIN NUMBER(20,4) NOT NULL,
ZOWORo_MAX NUMBER(20,4) NOT NULL,
ZOWORo_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPIRoomsTest_TREND ADD constraint PK_ZoomAPIRoomsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPIRoomsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIRoomsTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOTotRo_MIN varchar2(256) NOT NULL,
ZOTotRo_MAX varchar2(256) NOT NULL,
ZOCritRo_MIN varchar2(256) NOT NULL,
ZOCritRo_MAX varchar2(256) NOT NULL,
ZOWarnRo_MIN varchar2(256) NOT NULL,
ZOWarnRo_MAX varchar2(256) NOT NULL,
ZOWORo_MIN varchar2(256) NOT NULL,
ZOWORo_MAX varchar2(256) NOT NULL
);
ALTER TABLE ZoomAPIRoomsTest_THRESH ADD constraint PK_ZoomAPIRoomsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPIRoomsTest_THRESH ON ZoomAPIRoomsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPIRoomsTest ON ZoomAPIRoomsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPIRoomsTest ON ZoomAPIRoomsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPIUsersTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIUsersTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOTotUs NUMBER(20,4) NOT NULL,
ZOTotUs_ST varchar2(32) NOT NULL,
ZOBaUs NUMBER(20,4) NOT NULL,
ZOBaUs_ST varchar2(32) NOT NULL,
ZOLiUs NUMBER(20,4) NOT NULL,
ZOLiUs_ST varchar2(32) NOT NULL,
ZOOnPrUs NUMBER(20,4) NOT NULL,
ZOOnPrUs_ST varchar2(32) NOT NULL,
ZOAcUs NUMBER(20,4) NOT NULL,
ZOAcUs_ST varchar2(32) NOT NULL,
ZOInAcUs NUMBER(20,4) NOT NULL,
ZOInAcUs_ST varchar2(32) NOT NULL,
ZOPeUs NUMBER(20,4) NOT NULL,
ZOPeUs_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPIUsersTest ON ZoomAPIUsersTest(MSMT_TIME);
ALTER TABLE ZoomAPIUsersTest ADD constraint PK_ZoomAPIUsersTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPIUsersTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIUsersTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOTotUs_MIN NUMBER(20,4) NOT NULL,
ZOTotUs_MAX NUMBER(20,4) NOT NULL,
ZOTotUs_STCNT varchar2(32) NOT NULL,
ZOBaUs_MIN NUMBER(20,4) NOT NULL,
ZOBaUs_MAX NUMBER(20,4) NOT NULL,
ZOBaUs_STCNT varchar2(32) NOT NULL,
ZOLiUs_MIN NUMBER(20,4) NOT NULL,
ZOLiUs_MAX NUMBER(20,4) NOT NULL,
ZOLiUs_STCNT varchar2(32) NOT NULL,
ZOOnPrUs_MIN NUMBER(20,4) NOT NULL,
ZOOnPrUs_MAX NUMBER(20,4) NOT NULL,
ZOOnPrUs_STCNT varchar2(32) NOT NULL,
ZOAcUs_MIN NUMBER(20,4) NOT NULL,
ZOAcUs_MAX NUMBER(20,4) NOT NULL,
ZOAcUs_STCNT varchar2(32) NOT NULL,
ZOInAcUs_MIN NUMBER(20,4) NOT NULL,
ZOInAcUs_MAX NUMBER(20,4) NOT NULL,
ZOInAcUs_STCNT varchar2(32) NOT NULL,
ZOPeUs_MIN NUMBER(20,4) NOT NULL,
ZOPeUs_MAX NUMBER(20,4) NOT NULL,
ZOPeUs_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPIUsersTest_TREND ADD constraint PK_ZoomAPIUsersTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPIUsersTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIUsersTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOTotUs_MIN varchar2(256) NOT NULL,
ZOTotUs_MAX varchar2(256) NOT NULL,
ZOBaUs_MIN varchar2(256) NOT NULL,
ZOBaUs_MAX varchar2(256) NOT NULL,
ZOLiUs_MIN varchar2(256) NOT NULL,
ZOLiUs_MAX varchar2(256) NOT NULL,
ZOOnPrUs_MIN varchar2(256) NOT NULL,
ZOOnPrUs_MAX varchar2(256) NOT NULL,
ZOAcUs_MIN varchar2(256) NOT NULL,
ZOAcUs_MAX varchar2(256) NOT NULL,
ZOInAcUs_MIN varchar2(256) NOT NULL,
ZOInAcUs_MAX varchar2(256) NOT NULL,
ZOPeUs_MIN varchar2(256) NOT NULL,
ZOPeUs_MAX varchar2(256) NOT NULL
);
ALTER TABLE ZoomAPIUsersTest_THRESH ADD constraint PK_ZoomAPIUsersTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPIUsersTest_THRESH ON ZoomAPIUsersTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPIUsersTest ON ZoomAPIUsersTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPIUsersTest ON ZoomAPIUsersTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPIDlyUsgTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIDlyUsgTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOMeet NUMBER(20,4) NOT NULL,
ZOMeet_ST varchar2(32) NOT NULL,
ZOMeetmin NUMBER(20,4) NOT NULL,
ZOMeetmin_ST varchar2(32) NOT NULL,
ZONewUsers NUMBER(20,4) NOT NULL,
ZONewUsers_ST varchar2(32) NOT NULL,
ZOPartpnts NUMBER(20,4) NOT NULL,
ZOPartpnts_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPIDlyUsgTest ON ZoomAPIDlyUsgTest(MSMT_TIME);
ALTER TABLE ZoomAPIDlyUsgTest ADD constraint PK_ZoomAPIDlyUsgTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPIDlyUsgTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIDlyUsgTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOMeet_MIN NUMBER(20,4) NOT NULL,
ZOMeet_MAX NUMBER(20,4) NOT NULL,
ZOMeet_STCNT varchar2(32) NOT NULL,
ZOMeetmin_MIN NUMBER(20,4) NOT NULL,
ZOMeetmin_MAX NUMBER(20,4) NOT NULL,
ZOMeetmin_STCNT varchar2(32) NOT NULL,
ZONewUsers_MIN NUMBER(20,4) NOT NULL,
ZONewUsers_MAX NUMBER(20,4) NOT NULL,
ZONewUsers_STCNT varchar2(32) NOT NULL,
ZOPartpnts_MIN NUMBER(20,4) NOT NULL,
ZOPartpnts_MAX NUMBER(20,4) NOT NULL,
ZOPartpnts_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPIDlyUsgTest_TREND ADD constraint PK_ZoomAPIDlyUsgTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPIDlyUsgTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIDlyUsgTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOMeet_MIN varchar2(256) NOT NULL,
ZOMeet_MAX varchar2(256) NOT NULL,
ZOMeetmin_MIN varchar2(256) NOT NULL,
ZOMeetmin_MAX varchar2(256) NOT NULL,
ZONewUsers_MIN varchar2(256) NOT NULL,
ZONewUsers_MAX varchar2(256) NOT NULL,
ZOPartpnts_MIN varchar2(256) NOT NULL,
ZOPartpnts_MAX varchar2(256) NOT NULL
);
ALTER TABLE ZoomAPIDlyUsgTest_THRESH ADD constraint PK_ZoomAPIDlyUsgTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPIDlyUsgTest_THRESH ON ZoomAPIDlyUsgTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPIDlyUsgTest ON ZoomAPIDlyUsgTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPIDlyUsgTest ON ZoomAPIDlyUsgTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPIActInAcTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIActInAcTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOActHos NUMBER(20,4) NOT NULL,
ZOActHos_ST varchar2(32) NOT NULL,
ZOInActHos NUMBER(20,4) NOT NULL,
ZOInActHos_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPIActInAcTest ON ZoomAPIActInAcTest(MSMT_TIME);
ALTER TABLE ZoomAPIActInAcTest ADD constraint PK_ZoomAPIActInAcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPIActInAcTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIActInAcTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOActHos_MIN NUMBER(20,4) NOT NULL,
ZOActHos_MAX NUMBER(20,4) NOT NULL,
ZOActHos_STCNT varchar2(32) NOT NULL,
ZOInActHos_MIN NUMBER(20,4) NOT NULL,
ZOInActHos_MAX NUMBER(20,4) NOT NULL,
ZOInActHos_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPIActInAcTest_TREND ADD constraint PK_ZoomAPIActInAcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPIActInAcTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIActInAcTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOActHos_MIN varchar2(256) NOT NULL,
ZOActHos_MAX varchar2(256) NOT NULL,
ZOInActHos_MIN varchar2(256) NOT NULL,
ZOInActHos_MAX varchar2(256) NOT NULL
);
ALTER TABLE ZoomAPIActInAcTest_THRESH ADD constraint PK_ZoomAPIActInAcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPIActInAcTest_THRESH ON ZoomAPIActInAcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPIActInAcTest ON ZoomAPIActInAcTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPIActInAcTest ON ZoomAPIActInAcTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPIOprlogTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIOprlogTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZONoOplgs NUMBER(20,4) NOT NULL,
ZONoOplgs_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPIOprlogTest ON ZoomAPIOprlogTest(MSMT_TIME);
ALTER TABLE ZoomAPIOprlogTest ADD constraint PK_ZoomAPIOprlogTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPIOprlogTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIOprlogTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZONoOplgs_MIN NUMBER(20,4) NOT NULL,
ZONoOplgs_MAX NUMBER(20,4) NOT NULL,
ZONoOplgs_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPIOprlogTest_TREND ADD constraint PK_ZoomAPIOprlogTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPIOprlogTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIOprlogTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZONoOplgs_MIN varchar2(256) NOT NULL,
ZONoOplgs_MAX varchar2(256) NOT NULL
);
ALTER TABLE ZoomAPIOprlogTest_THRESH ADD constraint PK_ZoomAPIOprlogTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPIOprlogTest_THRESH ON ZoomAPIOprlogTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPIOprlogTest ON ZoomAPIOprlogTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPIOprlogTest ON ZoomAPIOprlogTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPICldStgTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPICldStgTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOPlanUsage NUMBER(20,4) NOT NULL,
ZOPlanUsage_ST varchar2(32) NOT NULL,
ZOFreeUsage NUMBER(20,4) NOT NULL,
ZOFreeUsage_ST varchar2(32) NOT NULL,
ZOUsage NUMBER(20,4) NOT NULL,
ZOUsage_ST varchar2(32) NOT NULL,
ZOUsagePct NUMBER(20,4) NOT NULL,
ZOUsagePct_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPICldStgTest ON ZoomAPICldStgTest(MSMT_TIME);
ALTER TABLE ZoomAPICldStgTest ADD constraint PK_ZoomAPICldStgTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPICldStgTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPICldStgTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOPlanUsage_MIN NUMBER(20,4) NOT NULL,
ZOPlanUsage_MAX NUMBER(20,4) NOT NULL,
ZOPlanUsage_STCNT varchar2(32) NOT NULL,
ZOFreeUsage_MIN NUMBER(20,4) NOT NULL,
ZOFreeUsage_MAX NUMBER(20,4) NOT NULL,
ZOFreeUsage_STCNT varchar2(32) NOT NULL,
ZOUsage_MIN NUMBER(20,4) NOT NULL,
ZOUsage_MAX NUMBER(20,4) NOT NULL,
ZOUsage_STCNT varchar2(32) NOT NULL,
ZOUsagePct_MIN NUMBER(20,4) NOT NULL,
ZOUsagePct_MAX NUMBER(20,4) NOT NULL,
ZOUsagePct_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPICldStgTest_TREND ADD constraint PK_ZoomAPICldStgTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPICldStgTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPICldStgTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOPlanUsage_MIN varchar2(256) NOT NULL,
ZOPlanUsage_MAX varchar2(256) NOT NULL,
ZOFreeUsage_MIN varchar2(256) NOT NULL,
ZOFreeUsage_MAX varchar2(256) NOT NULL,
ZOUsage_MIN varchar2(256) NOT NULL,
ZOUsage_MAX varchar2(256) NOT NULL,
ZOUsagePct_MIN varchar2(256) NOT NULL,
ZOUsagePct_MAX varchar2(256) NOT NULL
);
ALTER TABLE ZoomAPICldStgTest_THRESH ADD constraint PK_ZoomAPICldStgTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPICldStgTest_THRESH ON ZoomAPICldStgTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPICldStgTest ON ZoomAPICldStgTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPICldStgTest ON ZoomAPICldStgTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPIUpcEvntTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIUpcEvntTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOUpcmgEv NUMBER(20,4) NOT NULL,
ZOUpcmgEv_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPIUpcEvntTest ON ZoomAPIUpcEvntTest(MSMT_TIME);
ALTER TABLE ZoomAPIUpcEvntTest ADD constraint PK_ZoomAPIUpcEvntTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPIUpcEvntTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIUpcEvntTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOUpcmgEv_MIN NUMBER(20,4) NOT NULL,
ZOUpcmgEv_MAX NUMBER(20,4) NOT NULL,
ZOUpcmgEv_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPIUpcEvntTest_TREND ADD constraint PK_ZoomAPIUpcEvntTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPIUpcEvntTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIUpcEvntTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOUpcmgEv_MIN varchar2(256) NOT NULL,
ZOUpcmgEv_MAX varchar2(256) NOT NULL

);
ALTER TABLE ZoomAPIUpcEvntTest_THRESH ADD constraint PK_ZoomAPIUpcEvntTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPIUpcEvntTest_THRESH ON ZoomAPIUpcEvntTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPIUpcEvntTest ON ZoomAPIUpcEvntTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPIUpcEvntTest ON ZoomAPIUpcEvntTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPISignIOTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPISignIOTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOSignIn NUMBER(20,4) NOT NULL,
ZOSignIn_ST varchar2(32) NOT NULL,
ZOSignOut NUMBER(20,4) NOT NULL,
ZOSignOut_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPISignIOTest ON ZoomAPISignIOTest(MSMT_TIME);
ALTER TABLE ZoomAPISignIOTest ADD constraint PK_ZoomAPISignIOTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPISignIOTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPISignIOTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOSignIn_MIN NUMBER(20,4) NOT NULL,
ZOSignIn_MAX NUMBER(20,4) NOT NULL,
ZOSignIn_STCNT varchar2(32) NOT NULL,
ZOSignOut_MIN NUMBER(20,4) NOT NULL,
ZOSignOut_MAX NUMBER(20,4) NOT NULL,
ZOSignOut_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPISignIOTest_TREND ADD constraint PK_ZoomAPISignIOTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPISignIOTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPISignIOTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOSignIn_MIN varchar2(256) NOT NULL,
ZOSignIn_MAX varchar2(256) NOT NULL,
ZOSignOut_MIN varchar2(256) NOT NULL,
ZOSignOut_MAX varchar2(256) NOT NULL

);
ALTER TABLE ZoomAPISignIOTest_THRESH ADD constraint PK_ZoomAPISignIOTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPISignIOTest_THRESH ON ZoomAPISignIOTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPISignIOTest ON ZoomAPISignIOTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPISignIOTest ON ZoomAPISignIOTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPILiveMetTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPILiveMetTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOLivMeet NUMBER(20,4) NOT NULL,
ZOLivMeet_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPILiveMetTest ON ZoomAPILiveMetTest(MSMT_TIME);
ALTER TABLE ZoomAPILiveMetTest ADD constraint PK_ZoomAPILiveMetTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPILiveMetTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPILiveMetTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOLivMeet_MIN NUMBER(20,4) NOT NULL,
ZOLivMeet_MAX NUMBER(20,4) NOT NULL,
ZOLivMeet_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPILiveMetTest_TREND ADD constraint PK_ZoomAPILiveMetTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPILiveMetTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPILiveMetTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOLivMeet_MIN varchar2(256) NOT NULL,
ZOLivMeet_MAX varchar2(256) NOT NULL

);
ALTER TABLE ZoomAPILiveMetTest_THRESH ADD constraint PK_ZoomAPILiveMetTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPILiveMetTest_THRESH ON ZoomAPILiveMetTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPILiveMetTest ON ZoomAPILiveMetTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPILiveMetTest ON ZoomAPILiveMetTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPIQtyScreTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIQtyScreTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOAudBad NUMBER(20,4) NOT NULL,
ZOAudBad_ST varchar2(32) NOT NULL,
ZOAudPoor NUMBER(20,4) NOT NULL,
ZOAudPoor_ST varchar2(32) NOT NULL,
ZOAudFair NUMBER(20,4) NOT NULL,
ZOAudFair_ST varchar2(32) NOT NULL,
ZOAudGood NUMBER(20,4) NOT NULL,
ZOAudGood_ST varchar2(32) NOT NULL,
ZOVidBad NUMBER(20,4) NOT NULL,
ZOVidBad_ST varchar2(32) NOT NULL,
ZOVidPoor NUMBER(20,4) NOT NULL,
ZOVidPoor_ST varchar2(32) NOT NULL,
ZOVidFair NUMBER(20,4) NOT NULL,
ZOVidFair_ST varchar2(32) NOT NULL,
ZOVidGood NUMBER(20,4) NOT NULL,
ZOVidGood_ST varchar2(32) NOT NULL,
ZOScrnShreBad NUMBER(20,4) NOT NULL,
ZOScrnShreBad_ST varchar2(32) NOT NULL,
ZOScrnShrePoor NUMBER(20,4) NOT NULL,
ZOScrnShrePoor_ST varchar2(32) NOT NULL,
ZOScrnShreFair NUMBER(20,4) NOT NULL,
ZOScrnShreFair_ST varchar2(32) NOT NULL,
ZOScrnShreGood NUMBER(20,4) NOT NULL,
ZOScrnShreGood_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPIQtyScreTest ON ZoomAPIQtyScreTest(MSMT_TIME);
ALTER TABLE ZoomAPIQtyScreTest ADD constraint PK_ZoomAPIQtyScreTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPIQtyScreTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIQtyScreTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOAudBad_MIN NUMBER(20,4) NOT NULL,
ZOAudBad_MAX NUMBER(20,4) NOT NULL,
ZOAudBad_STCNT varchar2(32) NOT NULL,
ZOAudPoor_MIN NUMBER(20,4) NOT NULL,
ZOAudPoor_MAX NUMBER(20,4) NOT NULL,
ZOAudPoor_STCNT varchar2(32) NOT NULL,
ZOAudFair_MIN NUMBER(20,4) NOT NULL,
ZOAudFair_MAX NUMBER(20,4) NOT NULL,
ZOAudFair_STCNT varchar2(32) NOT NULL,
ZOAudGood_MIN NUMBER(20,4) NOT NULL,
ZOAudGood_MAX NUMBER(20,4) NOT NULL,
ZOAudGood_STCNT varchar2(32) NOT NULL,
ZOVidBad_MIN NUMBER(20,4) NOT NULL,
ZOVidBad_MAX NUMBER(20,4) NOT NULL,
ZOVidBad_STCNT varchar2(32) NOT NULL,
ZOVidPoor_MIN NUMBER(20,4) NOT NULL,
ZOVidPoor_MAX NUMBER(20,4) NOT NULL,
ZOVidPoor_STCNT varchar2(32) NOT NULL,
ZOVidFair_MIN NUMBER(20,4) NOT NULL,
ZOVidFair_MAX NUMBER(20,4) NOT NULL,
ZOVidFair_STCNT varchar2(32) NOT NULL,
ZOVidGood_MIN NUMBER(20,4) NOT NULL,
ZOVidGood_MAX NUMBER(20,4) NOT NULL,
ZOVidGood_STCNT varchar2(32) NOT NULL,
ZOScrnShreBad_MIN NUMBER(20,4) NOT NULL,
ZOScrnShreBad_MAX NUMBER(20,4) NOT NULL,
ZOScrnShreBad_STCNT varchar2(32) NOT NULL,
ZOScrnShrePoor_MIN NUMBER(20,4) NOT NULL,
ZOScrnShrePoor_MAX NUMBER(20,4) NOT NULL,
ZOScrnShrePoor_STCNT varchar2(32) NOT NULL,
ZOScrnShreFair_MIN NUMBER(20,4) NOT NULL,
ZOScrnShreFair_MAX NUMBER(20,4) NOT NULL,
ZOScrnShreFair_STCNT varchar2(32) NOT NULL,
ZOScrnShreGood_MIN NUMBER(20,4) NOT NULL,
ZOScrnShreGood_MAX NUMBER(20,4) NOT NULL,
ZOScrnShreGood_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPIQtyScreTest_TREND ADD constraint PK_ZoomAPIQtyScreTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPIQtyScreTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIQtyScreTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOAudBad_MIN varchar2(256) NOT NULL,
ZOAudBad_MAX varchar2(256) NOT NULL,
ZOAudPoor_MIN varchar2(256) NOT NULL,
ZOAudPoor_MAX varchar2(256) NOT NULL,
ZOAudFair_MIN varchar2(256) NOT NULL,
ZOAudFair_MAX varchar2(256) NOT NULL,
ZOAudGood_MIN varchar2(256) NOT NULL,
ZOAudGood_MAX varchar2(256) NOT NULL,
ZOVidBad_MIN varchar2(256) NOT NULL,
ZOVidBad_MAX varchar2(256) NOT NULL,
ZOVidPoor_MIN varchar2(256) NOT NULL,
ZOVidPoor_MAX varchar2(256) NOT NULL,
ZOVidFair_MIN varchar2(256) NOT NULL,
ZOVidFair_MAX varchar2(256) NOT NULL,
ZOVidGood_MIN varchar2(256) NOT NULL,
ZOVidGood_MAX varchar2(256) NOT NULL,
ZOScrnShreBad_MIN varchar2(256) NOT NULL,
ZOScrnShreBad_MAX varchar2(256) NOT NULL,
ZOScrnShrePoor_MIN varchar2(256) NOT NULL,
ZOScrnShrePoor_MAX varchar2(256) NOT NULL,
ZOScrnShreFair_MIN varchar2(256) NOT NULL,
ZOScrnShreFair_MAX varchar2(256) NOT NULL,
ZOScrnShreGood_MIN varchar2(256) NOT NULL,
ZOScrnShreGood_MAX varchar2(256) NOT NULL

);
ALTER TABLE ZoomAPIQtyScreTest_THRESH ADD constraint PK_ZoomAPIQtyScreTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPIQtyScreTest_THRESH ON ZoomAPIQtyScreTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPIQtyScreTest ON ZoomAPIQtyScreTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPIQtyScreTest ON ZoomAPIQtyScreTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPIMetSatsTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIMetSatsTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOCliSatGo NUMBER(20,4) NOT NULL,
ZOCliSatGo_ST varchar2(32) NOT NULL,
ZOCliSatNoGo NUMBER(20,4) NOT NULL,
ZOCliSatNoGo_ST varchar2(32) NOT NULL,
ZOCliSatNone NUMBER(20,4) NOT NULL,
ZOCliSatNone_ST varchar2(32) NOT NULL,
ZOCliSatPercent NUMBER(20,4) NOT NULL,
ZOCliSatPercent_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPIMetSatsTest ON ZoomAPIMetSatsTest(MSMT_TIME);
ALTER TABLE ZoomAPIMetSatsTest ADD constraint PK_ZoomAPIMetSatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPIMetSatsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIMetSatsTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOCliSatGo_MIN NUMBER(20,4) NOT NULL,
ZOCliSatGo_MAX NUMBER(20,4) NOT NULL,
ZOCliSatGo_STCNT varchar2(32) NOT NULL,
ZOCliSatNoGo_MIN NUMBER(20,4) NOT NULL,
ZOCliSatNoGo_MAX NUMBER(20,4) NOT NULL,
ZOCliSatNoGo_STCNT varchar2(32) NOT NULL,
ZOCliSatNone_MIN NUMBER(20,4) NOT NULL,
ZOCliSatNone_MAX NUMBER(20,4) NOT NULL,
ZOCliSatNone_STCNT varchar2(32) NOT NULL,
ZOCliSatPercent_MIN NUMBER(20,4) NOT NULL,
ZOCliSatPercent_MAX NUMBER(20,4) NOT NULL,
ZOCliSatPercent_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPIMetSatsTest_TREND ADD constraint PK_ZoomAPIMetSatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPIMetSatsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIMetSatsTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOCliSatGo_MIN varchar2(256) NOT NULL,
ZOCliSatGo_MAX varchar2(256) NOT NULL,
ZOCliSatNoGo_MIN varchar2(256) NOT NULL,
ZOCliSatNoGo_MAX varchar2(256) NOT NULL,
ZOCliSatNone_MIN varchar2(256) NOT NULL,
ZOCliSatNone_MAX varchar2(256) NOT NULL,
ZOCliSatPercent_MIN varchar2(256) NOT NULL,
ZOCliSatPercent_MAX varchar2(256) NOT NULL

);
ALTER TABLE ZoomAPIMetSatsTest_THRESH ADD constraint PK_ZoomAPIMetSatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPIMetSatsTest_THRESH ON ZoomAPIMetSatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPIMetSatsTest ON ZoomAPIMetSatsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPIMetSatsTest ON ZoomAPIMetSatsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPIChtMetsTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIChtMetsTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOTotSe NUMBER(20,4) NOT NULL,
ZOTotSe_ST varchar2(32) NOT NULL,
ZOP2PSe NUMBER(20,4) NOT NULL,
ZOP2PSe_ST varchar2(32) NOT NULL,
ZOGrpSe NUMBER(20,4) NOT NULL,
ZOGrpSe_ST varchar2(32) NOT NULL,
ZOFileSe NUMBER(20,4) NOT NULL,
ZOFileSe_ST varchar2(32) NOT NULL,
ZOTextSe NUMBER(20,4) NOT NULL,
ZOTextSe_ST varchar2(32) NOT NULL,
ZOImagSe NUMBER(20,4) NOT NULL,
ZOImagSe_ST varchar2(32) NOT NULL,
ZOCodSiSe NUMBER(20,4) NOT NULL,
ZOCodSiSe_ST varchar2(32) NOT NULL,
ZOGipSe NUMBER(20,4) NOT NULL,
ZOGipSe_ST varchar2(32) NOT NULL,
ZOAudSe NUMBER(20,4) NOT NULL,
ZOAudSe_ST varchar2(32) NOT NULL,
ZOVidSe NUMBER(20,4) NOT NULL,
ZOVidSe_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPIChtMetsTest ON ZoomAPIChtMetsTest(MSMT_TIME);
ALTER TABLE ZoomAPIChtMetsTest ADD constraint PK_ZoomAPIChtMetsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPIChtMetsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIChtMetsTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOTotSe_MIN NUMBER(20,4) NOT NULL,
ZOTotSe_MAX NUMBER(20,4) NOT NULL,
ZOTotSe_STCNT varchar2(32) NOT NULL,
ZOP2PSe_MIN NUMBER(20,4) NOT NULL,
ZOP2PSe_MAX NUMBER(20,4) NOT NULL,
ZOP2PSe_STCNT varchar2(32) NOT NULL,
ZOGrpSe_MIN NUMBER(20,4) NOT NULL,
ZOGrpSe_MAX NUMBER(20,4) NOT NULL,
ZOGrpSe_STCNT varchar2(32) NOT NULL,
ZOFileSe_MIN NUMBER(20,4) NOT NULL,
ZOFileSe_MAX NUMBER(20,4) NOT NULL,
ZOFileSe_STCNT varchar2(32) NOT NULL,
ZOTextSe_MIN NUMBER(20,4) NOT NULL,
ZOTextSe_MAX NUMBER(20,4) NOT NULL,
ZOTextSe_STCNT varchar2(32) NOT NULL,
ZOImagSe_MIN NUMBER(20,4) NOT NULL,
ZOImagSe_MAX NUMBER(20,4) NOT NULL,
ZOImagSe_STCNT varchar2(32) NOT NULL,
ZOCodSiSe_MIN NUMBER(20,4) NOT NULL,
ZOCodSiSe_MAX NUMBER(20,4) NOT NULL,
ZOCodSiSe_STCNT varchar2(32) NOT NULL,
ZOGipSe_MIN NUMBER(20,4) NOT NULL,
ZOGipSe_MAX NUMBER(20,4) NOT NULL,
ZOGipSe_STCNT varchar2(32) NOT NULL,
ZOAudSe_MIN NUMBER(20,4) NOT NULL,
ZOAudSe_MAX NUMBER(20,4) NOT NULL,
ZOAudSe_STCNT varchar2(32) NOT NULL,
ZOVidSe_MIN NUMBER(20,4) NOT NULL,
ZOVidSe_MAX NUMBER(20,4) NOT NULL,
ZOVidSe_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPIChtMetsTest_TREND ADD constraint PK_ZoomAPIChtMetsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPIChtMetsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIChtMetsTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOTotSe_MIN varchar2(256) NOT NULL,
ZOTotSe_MAX varchar2(256) NOT NULL,
ZOP2PSe_MIN varchar2(256) NOT NULL,
ZOP2PSe_MAX varchar2(256) NOT NULL,
ZOGrpSe_MIN varchar2(256) NOT NULL,
ZOGrpSe_MAX varchar2(256) NOT NULL,
ZOFileSe_MIN varchar2(256) NOT NULL,
ZOFileSe_MAX varchar2(256) NOT NULL,
ZOTextSe_MIN varchar2(256) NOT NULL,
ZOTextSe_MAX varchar2(256) NOT NULL,
ZOImagSe_MIN varchar2(256) NOT NULL,
ZOImagSe_MAX varchar2(256) NOT NULL,
ZOCodSiSe_MIN varchar2(256) NOT NULL,
ZOCodSiSe_MAX varchar2(256) NOT NULL,
ZOGipSe_MIN varchar2(256) NOT NULL,
ZOGipSe_MAX varchar2(256) NOT NULL,
ZOAudSe_MIN varchar2(256) NOT NULL,
ZOAudSe_MAX varchar2(256) NOT NULL,
ZOVidSe_MIN varchar2(256) NOT NULL,
ZOVidSe_MAX varchar2(256) NOT NULL

);
ALTER TABLE ZoomAPIChtMetsTest_THRESH ADD constraint PK_ZoomAPIChtMetsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPIChtMetsTest_THRESH ON ZoomAPIChtMetsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPIChtMetsTest ON ZoomAPIChtMetsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPIChtMetsTest ON ZoomAPIChtMetsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPIPortUsgTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIPortUsgTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOMaxUs NUMBER(20,4) NOT NULL,
ZOMaxUs_ST varchar2(32) NOT NULL,
ZOTotUs NUMBER(20,4) NOT NULL,
ZOTotUs_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPIPortUsgTest ON ZoomAPIPortUsgTest(MSMT_TIME);
ALTER TABLE ZoomAPIPortUsgTest ADD constraint PK_ZoomAPIPortUsgTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPIPortUsgTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIPortUsgTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOMaxUs_MIN NUMBER(20,4) NOT NULL,
ZOMaxUs_MAX NUMBER(20,4) NOT NULL,
ZOMaxUs_STCNT varchar2(32) NOT NULL,
ZOTotUs_MIN NUMBER(20,4) NOT NULL,
ZOTotUs_MAX NUMBER(20,4) NOT NULL,
ZOTotUs_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPIPortUsgTest_TREND ADD constraint PK_ZoomAPIPortUsgTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPIPortUsgTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIPortUsgTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOMaxUs_MIN varchar2(256) NOT NULL,
ZOMaxUs_MAX varchar2(256) NOT NULL,
ZOTotUs_MIN varchar2(256) NOT NULL,
ZOTotUs_MAX varchar2(256) NOT NULL
);
ALTER TABLE ZoomAPIPortUsgTest_THRESH ADD constraint PK_ZoomAPIPortUsgTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPIPortUsgTest_THRESH ON ZoomAPIPortUsgTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPIPortUsgTest ON ZoomAPIPortUsgTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPIPortUsgTest ON ZoomAPIPortUsgTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPIMetFbckTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIMetFbckTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOFeed NUMBER(20,4) NOT NULL,
ZOFeed_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPIMetFbckTest ON ZoomAPIMetFbckTest(MSMT_TIME);
ALTER TABLE ZoomAPIMetFbckTest ADD constraint PK_ZoomAPIMetFbckTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPIMetFbckTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIMetFbckTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOFeed_MIN NUMBER(20,4) NOT NULL,
ZOFeed_MAX NUMBER(20,4) NOT NULL,
ZOFeed_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPIMetFbckTest_TREND ADD constraint PK_ZoomAPIMetFbckTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPIMetFbckTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIMetFbckTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOFeed_MIN varchar2(256) NOT NULL,
ZOFeed_MAX varchar2(256) NOT NULL
);
ALTER TABLE ZoomAPIMetFbckTest_THRESH ADD constraint PK_ZoomAPIMetFbckTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPIMetFbckTest_THRESH ON ZoomAPIMetFbckTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPIMetFbckTest ON ZoomAPIMetFbckTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPIMetFbckTest ON ZoomAPIMetFbckTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomAPIPlanUsgTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIPlanUsgTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ZOPlnBasType NUMBER(20,4) NOT NULL,
ZOPlnBasType_ST varchar2(32) NOT NULL,
ZOPlnBasHost NUMBER(20,4) NOT NULL,
ZOPlnBasHost_ST varchar2(32) NOT NULL,
ZOPlnBasUsage NUMBER(20,4) NOT NULL,
ZOPlnBasUsage_ST varchar2(32) NOT NULL,
ZOPlnLaMeetHost NUMBER(20,4) NOT NULL,
ZOPlnLaMeetHost_ST varchar2(32) NOT NULL,
ZOPlnLaMeetUsage NUMBER(20,4) NOT NULL,
ZOPlnLaMeetUsage_ST varchar2(32) NOT NULL,
ZORoomsType NUMBER(20,4) NOT NULL,
ZORoomsType_ST varchar2(32) NOT NULL,
ZORoomsHost NUMBER(20,4) NOT NULL,
ZORoomsHost_ST varchar2(32) NOT NULL,
ZORoomsUsage NUMBER(20,4) NOT NULL,
ZORoomsUsage_ST varchar2(32) NOT NULL,
ZORecrdPlnStge NUMBER(20,4) NOT NULL,
ZORecrdPlnStge_ST varchar2(32) NOT NULL,
ZORecrdPlnStgeUsge NUMBER(20,4) NOT NULL,
ZORecrdPlnStgeUsge_ST varchar2(32) NOT NULL,
ZORecrdPlnStgeUsgePct NUMBER(20,4) NOT NULL,
ZORecrdPlnStgeUsgePct_ST varchar2(32) NOT NULL,
ZORecrdPlnStgeExcd NUMBER(20,4) NOT NULL,
ZORecrdPlnStgeExcd_ST varchar2(32) NOT NULL,
ZORecrdFreStge NUMBER(20,4) NOT NULL,
ZORecrdFreStge_ST varchar2(32) NOT NULL,
ZORecrdFreStgeUsge NUMBER(20,4) NOT NULL,
ZORecrdFreStgeUsge_ST varchar2(32) NOT NULL,
ZORecrdFreStgeUsgePct NUMBER(20,4) NOT NULL,
ZORecrdFreStgeUsgePct_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_ZoomAPIPlanUsgTest ON ZoomAPIPlanUsgTest(MSMT_TIME);
ALTER TABLE ZoomAPIPlanUsgTest ADD constraint PK_ZoomAPIPlanUsgTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ZoomAPIPlanUsgTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIPlanUsgTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ZOPlnBasType_MIN NUMBER(20,4) NOT NULL,
ZOPlnBasType_MAX NUMBER(20,4) NOT NULL,
ZOPlnBasType_STCNT varchar2(32) NOT NULL,
ZOPlnBasHost_MIN NUMBER(20,4) NOT NULL,
ZOPlnBasHost_MAX NUMBER(20,4) NOT NULL,
ZOPlnBasHost_STCNT varchar2(32) NOT NULL,
ZOPlnBasUsage_MIN NUMBER(20,4) NOT NULL,
ZOPlnBasUsage_MAX NUMBER(20,4) NOT NULL,
ZOPlnBasUsage_STCNT varchar2(32) NOT NULL,
ZOPlnLaMeetHost_MIN NUMBER(20,4) NOT NULL,
ZOPlnLaMeetHost_MAX NUMBER(20,4) NOT NULL,
ZOPlnLaMeetHost_STCNT varchar2(32) NOT NULL,
ZOPlnLaMeetUsage_MIN NUMBER(20,4) NOT NULL,
ZOPlnLaMeetUsage_MAX NUMBER(20,4) NOT NULL,
ZOPlnLaMeetUsage_STCNT varchar2(32) NOT NULL,
ZORoomsType_MIN NUMBER(20,4) NOT NULL,
ZORoomsType_MAX NUMBER(20,4) NOT NULL,
ZORoomsType_STCNT varchar2(32) NOT NULL,
ZORoomsHost_MIN NUMBER(20,4) NOT NULL,
ZORoomsHost_MAX NUMBER(20,4) NOT NULL,
ZORoomsHost_STCNT varchar2(32) NOT NULL,
ZORoomsUsage_MIN NUMBER(20,4) NOT NULL,
ZORoomsUsage_MAX NUMBER(20,4) NOT NULL,
ZORoomsUsage_STCNT varchar2(32) NOT NULL,
ZORecrdPlnStge_MIN NUMBER(20,4) NOT NULL,
ZORecrdPlnStge_MAX NUMBER(20,4) NOT NULL,
ZORecrdPlnStge_STCNT varchar2(32) NOT NULL,
ZORecrdPlnStgeUsge_MIN NUMBER(20,4) NOT NULL,
ZORecrdPlnStgeUsge_MAX NUMBER(20,4) NOT NULL,
ZORecrdPlnStgeUsge_STCNT varchar2(32) NOT NULL,
ZORecrdPlnStgeUsgePct_MIN NUMBER(20,4) NOT NULL,
ZORecrdPlnStgeUsgePct_MAX NUMBER(20,4) NOT NULL,
ZORecrdPlnStgeUsgePct_STCNT varchar2(32) NOT NULL,
ZORecrdPlnStgeExcd_MIN NUMBER(20,4) NOT NULL,
ZORecrdPlnStgeExcd_MAX NUMBER(20,4) NOT NULL,
ZORecrdPlnStgeExcd_STCNT varchar2(32) NOT NULL,
ZORecrdFreStge_MIN NUMBER(20,4) NOT NULL,
ZORecrdFreStge_MAX NUMBER(20,4) NOT NULL,
ZORecrdFreStge_STCNT varchar2(32) NOT NULL,
ZORecrdFreStgeUsge_MIN NUMBER(20,4) NOT NULL,
ZORecrdFreStgeUsge_MAX NUMBER(20,4) NOT NULL,
ZORecrdFreStgeUsge_STCNT varchar2(32) NOT NULL,
ZORecrdFreStgeUsgePct_MIN NUMBER(20,4) NOT NULL,
ZORecrdFreStgeUsgePct_MAX NUMBER(20,4) NOT NULL,
ZORecrdFreStgeUsgePct_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAPIPlanUsgTest_TREND ADD constraint PK_ZoomAPIPlanUsgTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ZoomAPIPlanUsgTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAPIPlanUsgTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ZOPlnBasType_MIN varchar2(256) NOT NULL,
ZOPlnBasType_MAX varchar2(256) NOT NULL,
ZOPlnBasHost_MIN varchar2(256) NOT NULL,
ZOPlnBasHost_MAX varchar2(256) NOT NULL,
ZOPlnBasUsage_MIN varchar2(256) NOT NULL,
ZOPlnBasUsage_MAX varchar2(256) NOT NULL,
ZOPlnLaMeetHost_MIN varchar2(256) NOT NULL,
ZOPlnLaMeetHost_MAX varchar2(256) NOT NULL,
ZOPlnLaMeetUsage_MIN varchar2(256) NOT NULL,
ZOPlnLaMeetUsage_MAX varchar2(256) NOT NULL,
ZORoomsType_MIN varchar2(256) NOT NULL,
ZORoomsType_MAX varchar2(256) NOT NULL,
ZORoomsHost_MIN varchar2(256) NOT NULL,
ZORoomsHost_MAX varchar2(256) NOT NULL,
ZORoomsUsage_MIN varchar2(256) NOT NULL,
ZORoomsUsage_MAX varchar2(256) NOT NULL,
ZORecrdPlnStge_MIN varchar2(256) NOT NULL,
ZORecrdPlnStge_MAX varchar2(256) NOT NULL,
ZORecrdPlnStgeUsge_MIN varchar2(256) NOT NULL,
ZORecrdPlnStgeUsge_MAX varchar2(256) NOT NULL,
ZORecrdPlnStgeUsgePct_MIN varchar2(256) NOT NULL,
ZORecrdPlnStgeUsgePct_MAX varchar2(256) NOT NULL,
ZORecrdPlnStgeExcd_MIN varchar2(256) NOT NULL,
ZORecrdPlnStgeExcd_MAX varchar2(256) NOT NULL,
ZORecrdFreStge_MIN varchar2(256) NOT NULL,
ZORecrdFreStge_MAX varchar2(256) NOT NULL,
ZORecrdFreStgeUsge_MIN varchar2(256) NOT NULL,
ZORecrdFreStgeUsge_MAX varchar2(256) NOT NULL,
ZORecrdFreStgeUsgePct_MIN varchar2(256) NOT NULL,
ZORecrdFreStgeUsgePct_MAX varchar2(256) NOT NULL
);
ALTER TABLE ZoomAPIPlanUsgTest_THRESH ADD constraint PK_ZoomAPIPlanUsgTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAPIPlanUsgTest_THRESH ON ZoomAPIPlanUsgTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAPIPlanUsgTest ON ZoomAPIPlanUsgTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ZoomAPIPlanUsgTest ON ZoomAPIPlanUsgTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE ZoomPhoneTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomPhoneTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
callee_missed NUMBER(20,4) NOT NULL,
callee_missed_ST varchar2(32) NOT NULL,
callee_rejected NUMBER(20,4) NOT NULL,
callee_rejected_ST varchar2(32) NOT NULL,
callee_ended NUMBER(20,4) NOT NULL,
callee_ended_ST varchar2(32) NOT NULL,
caller_ended NUMBER(20,4) NOT NULL,
caller_ended_ST varchar2(32) NOT NULL,
emergency_alert NUMBER(20,4) NOT NULL,
emergency_alert_ST varchar2(32) NOT NULL,
caller_ringing NUMBER(20,4) NOT NULL,
caller_ringing_ST varchar2(32) NOT NULL,
caller_connected NUMBER(20,4) NOT NULL,
caller_connected_ST varchar2(32) NOT NULL,
callee_ringing NUMBER(20,4) NOT NULL,
callee_ringing_ST varchar2(32) NOT NULL,
callee_answered NUMBER(20,4) NOT NULL,
callee_answered_ST varchar2(32) NOT NULL,
voicemail_received NUMBER(20,4) NOT NULL,
voicemail_received_ST varchar2(32) NOT NULL,
caller_calllog_compltd NUMBER(20,4) NOT NULL,
caller_calllog_compltd_ST varchar2(32) NOT NULL,
callee_calllog_compltd NUMBER(20,4) NOT NULL,
callee_calllog_compltd_ST varchar2(32) NOT NULL,
recording_completed NUMBER(20,4) NOT NULL,
recording_completed_ST varchar2(32) NOT NULL,
gendevice_provision NUMBER(20,4) NOT NULL,
gendevice_provision_ST varchar2(32) NOT NULL,
recording_started NUMBER(20,4) NOT NULL,
recording_started_ST varchar2(32) NOT NULL,
recording_stopped NUMBER(20,4) NOT NULL,
recording_stopped_ST varchar2(32) NOT NULL,
calllog_deleted NUMBER(20,4) NOT NULL,
calllog_deleted_ST varchar2(32) NOT NULL,
calllog_permntly_deleted NUMBER(20,4) NOT NULL,
calllog_permntly_deleted_ST varchar2(32) NOT NULL,
voicemail_deleted NUMBER(20,4) NOT NULL,
voicemail_deleted_ST varchar2(32) NOT NULL,
voicemail_permnt_delted NUMBER(20,4) NOT NULL,
voicemail_permnt_delted_ST varchar2(32) NOT NULL,
caller_hold NUMBER(20,4) NOT NULL,
caller_hold_ST varchar2(32) NOT NULL,
caller_unhold NUMBER(20,4) NOT NULL,
caller_unhold_ST varchar2(32) NOT NULL,
callee_hold NUMBER(20,4) NOT NULL,
callee_hold_ST varchar2(32) NOT NULL,
callee_unhold NUMBER(20,4) NOT NULL,
callee_unhold_ST varchar2(32) NOT NULL,
caller_meeting_inviting NUMBER(20,4) NOT NULL,
caller_meeting_inviting_ST varchar2(32) NOT NULL,
callee_meeting_inviting NUMBER(20,4) NOT NULL,
callee_meeting_inviting_ST varchar2(32) NOT NULL,
warm_transfer_accepted NUMBER(20,4) NOT NULL,
warm_transfer_accepted_ST varchar2(32) NOT NULL,
peer_num_cnam_updated NUMBER(20,4) NOT NULL,
peer_num_cnam_updated_ST varchar2(32) NOT NULL,
peer_num_emr_adrs_update NUMBER(20,4) NOT NULL,
peer_num_emr_adrs_update_ST varchar2(32) NOT NULL
);
ALTER TABLE ZoomPhoneTest ADD constraint PK_ZoomPhoneTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ZoomPhoneTest ON ZoomPhoneTest
(
	 MSMT_TIME
);

DROP TABLE ZoomPhoneTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomPhoneTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
callee_missed_MIN NUMBER(20,4) NOT NULL,
callee_missed_MAX NUMBER(20,4) NOT NULL,
callee_missed_STCNT varchar2(32) NOT NULL,
callee_rejected_MIN NUMBER(20,4) NOT NULL,
callee_rejected_MAX NUMBER(20,4) NOT NULL,
callee_rejected_STCNT varchar2(32) NOT NULL,
callee_ended_MIN NUMBER(20,4) NOT NULL,
callee_ended_MAX NUMBER(20,4) NOT NULL,
callee_ended_STCNT varchar2(32) NOT NULL,
caller_ended_MIN NUMBER(20,4) NOT NULL,
caller_ended_MAX NUMBER(20,4) NOT NULL,
caller_ended_STCNT varchar2(32) NOT NULL,
emergency_alert_MIN NUMBER(20,4) NOT NULL,
emergency_alert_MAX NUMBER(20,4) NOT NULL,
emergency_alert_STCNT varchar2(32) NOT NULL,
caller_ringing_MIN NUMBER(20,4) NOT NULL,
caller_ringing_MAX NUMBER(20,4) NOT NULL,
caller_ringing_STCNT varchar2(32) NOT NULL,
caller_connected_MIN NUMBER(20,4) NOT NULL,
caller_connected_MAX NUMBER(20,4) NOT NULL,
caller_connected_STCNT varchar2(32) NOT NULL,
callee_ringing_MIN NUMBER(20,4) NOT NULL,
callee_ringing_MAX NUMBER(20,4) NOT NULL,
callee_ringing_STCNT varchar2(32) NOT NULL,
callee_answered_MIN NUMBER(20,4) NOT NULL,
callee_answered_MAX NUMBER(20,4) NOT NULL,
callee_answered_STCNT varchar2(32) NOT NULL,
voicemail_received_MIN NUMBER(20,4) NOT NULL,
voicemail_received_MAX NUMBER(20,4) NOT NULL,
voicemail_received_STCNT varchar2(32) NOT NULL,
caller_calllog_compltd_MIN NUMBER(20,4) NOT NULL,
caller_calllog_compltd_MAX NUMBER(20,4) NOT NULL,
caller_calllog_compltd_STCNT varchar2(32) NOT NULL,
callee_calllog_compltd_MIN NUMBER(20,4) NOT NULL,
callee_calllog_compltd_MAX NUMBER(20,4) NOT NULL,
callee_calllog_compltd_STCNT varchar2(32) NOT NULL,
recording_completed_MIN NUMBER(20,4) NOT NULL,
recording_completed_MAX NUMBER(20,4) NOT NULL,
recording_completed_STCNT varchar2(32) NOT NULL,
gendevice_provision_MIN NUMBER(20,4) NOT NULL,
gendevice_provision_MAX NUMBER(20,4) NOT NULL,
gendevice_provision_STCNT varchar2(32) NOT NULL,
recording_started_MIN NUMBER(20,4) NOT NULL,
recording_started_MAX NUMBER(20,4) NOT NULL,
recording_started_STCNT varchar2(32) NOT NULL,
recording_stopped_MIN NUMBER(20,4) NOT NULL,
recording_stopped_MAX NUMBER(20,4) NOT NULL,
recording_stopped_STCNT varchar2(32) NOT NULL,
calllog_deleted_MIN NUMBER(20,4) NOT NULL,
calllog_deleted_MAX NUMBER(20,4) NOT NULL,
calllog_deleted_STCNT varchar2(32) NOT NULL,
calllog_permntly_deleted_MIN NUMBER(20,4) NOT NULL,
calllog_permntly_deleted_MAX NUMBER(20,4) NOT NULL,
calllog_permntly_deleted_STCNT varchar2(32) NOT NULL,
voicemail_deleted_MIN NUMBER(20,4) NOT NULL,
voicemail_deleted_MAX NUMBER(20,4) NOT NULL,
voicemail_deleted_STCNT varchar2(32) NOT NULL,
voicemail_permnt_delted_MIN NUMBER(20,4) NOT NULL,
voicemail_permnt_delted_MAX NUMBER(20,4) NOT NULL,
voicemail_permnt_delted_STCNT varchar2(32) NOT NULL,
caller_hold_MIN NUMBER(20,4) NOT NULL,
caller_hold_MAX NUMBER(20,4) NOT NULL,
caller_hold_STCNT varchar2(32) NOT NULL,
caller_unhold_MIN NUMBER(20,4) NOT NULL,
caller_unhold_MAX NUMBER(20,4) NOT NULL,
caller_unhold_STCNT varchar2(32) NOT NULL,
callee_hold_MIN NUMBER(20,4) NOT NULL,
callee_hold_MAX NUMBER(20,4) NOT NULL,
callee_hold_STCNT varchar2(32) NOT NULL,
callee_unhold_MIN NUMBER(20,4) NOT NULL,
callee_unhold_MAX NUMBER(20,4) NOT NULL,
callee_unhold_STCNT varchar2(32) NOT NULL,
caller_meeting_inviting_MIN NUMBER(20,4) NOT NULL,
caller_meeting_inviting_MAX NUMBER(20,4) NOT NULL,
caller_meeting_inviting_STCNT varchar2(32) NOT NULL,
callee_meeting_inviting_MIN NUMBER(20,4) NOT NULL,
callee_meeting_inviting_MAX NUMBER(20,4) NOT NULL,
callee_meeting_inviting_STCNT varchar2(32) NOT NULL,
warm_transfer_accepted_MIN NUMBER(20,4) NOT NULL,
warm_transfer_accepted_MAX NUMBER(20,4) NOT NULL,
warm_transfer_accepted_STCNT varchar2(32) NOT NULL,
peer_num_cnam_updated_MIN NUMBER(20,4) NOT NULL,
peer_num_cnam_updated_MAX NUMBER(20,4) NOT NULL,
peer_num_cnam_updated_STCNT varchar2(32) NOT NULL,
peer_num_emr_adrs_update_MIN NUMBER(20,4) NOT NULL,
peer_num_emr_adrs_update_MAX NUMBER(20,4) NOT NULL,
peer_num_emr_adrs_update_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomPhoneTest_TREND ADD constraint PK_ZoomPhoneTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
CREATE INDEX IDX_TR_ZoomPhoneTest on ZoomPhoneTest_TREND(msmt_time,period);

DROP TABLE ZoomPhoneTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomPhoneTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
callee_missed_MIN	varchar2(256)	 NOT NULL,
callee_missed_MAX	varchar2(256)	 NOT NULL,
callee_rejected_MIN	varchar2(256)	 NOT NULL,
callee_rejected_MAX	varchar2(256)	 NOT NULL,
callee_ended_MIN	varchar2(256)	 NOT NULL,
callee_ended_MAX	varchar2(256)	 NOT NULL,
caller_ended_MIN	varchar2(256)	 NOT NULL,
caller_ended_MAX	varchar2(256)	 NOT NULL,
emergency_alert_MIN	varchar2(256)	 NOT NULL,
emergency_alert_MAX	varchar2(256)	 NOT NULL,
caller_ringing_MIN	varchar2(256)	 NOT NULL,
caller_ringing_MAX	varchar2(256)	 NOT NULL,
caller_connected_MIN	varchar2(256)	 NOT NULL,
caller_connected_MAX	varchar2(256)	 NOT NULL,
callee_ringing_MIN	varchar2(256)	 NOT NULL,
callee_ringing_MAX	varchar2(256)	 NOT NULL,
callee_answered_MIN	varchar2(256)	 NOT NULL,
callee_answered_MAX	varchar2(256)	 NOT NULL,
voicemail_received_MIN	varchar2(256)	 NOT NULL,
voicemail_received_MAX	varchar2(256)	 NOT NULL,
caller_calllog_compltd_MIN	varchar2(256)	 NOT NULL,
caller_calllog_compltd_MAX	varchar2(256)	 NOT NULL,
callee_calllog_compltd_MIN	varchar2(256)	 NOT NULL,
callee_calllog_compltd_MAX	varchar2(256)	 NOT NULL,
recording_completed_MIN	varchar2(256)	 NOT NULL,
recording_completed_MAX	varchar2(256)	 NOT NULL,
gendevice_provision_MIN	varchar2(256)	 NOT NULL,
gendevice_provision_MAX	varchar2(256)	 NOT NULL,
recording_started_MIN	varchar2(256)	 NOT NULL,
recording_started_MAX	varchar2(256)	 NOT NULL,
recording_stopped_MIN	varchar2(256)	 NOT NULL,
recording_stopped_MAX	varchar2(256)	 NOT NULL,
calllog_deleted_MIN	varchar2(256)	 NOT NULL,
calllog_deleted_MAX	varchar2(256)	 NOT NULL,
calllog_permntly_deleted_MIN	varchar2(256)	 NOT NULL,
calllog_permntly_deleted_MAX	varchar2(256)	 NOT NULL,
voicemail_deleted_MIN	varchar2(256)	 NOT NULL,
voicemail_deleted_MAX	varchar2(256)	 NOT NULL,
voicemail_permnt_delted_MIN	varchar2(256)	 NOT NULL,
voicemail_permnt_delted_MAX	varchar2(256)	 NOT NULL,
caller_hold_MIN	varchar2(256)	 NOT NULL,
caller_hold_MAX	varchar2(256)	 NOT NULL,
caller_unhold_MIN	varchar2(256)	 NOT NULL,
caller_unhold_MAX	varchar2(256)	 NOT NULL,
callee_hold_MIN	varchar2(256)	 NOT NULL,
callee_hold_MAX	varchar2(256)	 NOT NULL,
callee_unhold_MIN	varchar2(256)	 NOT NULL,
callee_unhold_MAX	varchar2(256)	 NOT NULL,
caller_meeting_inviting_MIN	varchar2(256)	 NOT NULL,
caller_meeting_inviting_MAX	varchar2(256)	 NOT NULL,
callee_meeting_inviting_MIN	varchar2(256)	 NOT NULL,
callee_meeting_inviting_MAX	varchar2(256)	 NOT NULL,
warm_transfer_accepted_MIN	varchar2(256)	 NOT NULL,
warm_transfer_accepted_MAX	varchar2(256)	 NOT NULL,
peer_num_cnam_updated_MIN	varchar2(256)	 NOT NULL,
peer_num_cnam_updated_MAX	varchar2(256)	 NOT NULL,
peer_num_emr_adrs_update_MIN	varchar2(256)	 NOT NULL,
peer_num_emr_adrs_update_MAX	varchar2(256)	 NOT NULL
);
ALTER TABLE ZoomPhoneTest_THRESH ADD constraint PK_ZoomPhoneTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomPhoneTest_THRESH ON ZoomPhoneTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomPhoneTest on ZoomPhoneTest_THRESH(msmt_time_start);

DROP TABLE ZoomMeetingTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomMeetingTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CREATED NUMBER(20,4) NOT NULL,
CREATED_ST varchar2(32) NOT NULL,
UPDATED NUMBER(20,4) NOT NULL,
UPDATED_ST varchar2(32) NOT NULL,
DELETED NUMBER(20,4) NOT NULL,
DELETED_ST varchar2(32) NOT NULL,
STARTED NUMBER(20,4) NOT NULL,
STARTED_ST varchar2(32) NOT NULL,
ENDED NUMBER(20,4) NOT NULL,
ENDED_ST varchar2(32) NOT NULL,
sharingstarted NUMBER(20,4) NOT NULL,
sharingstarted_ST varchar2(32) NOT NULL,
sharingended NUMBER(20,4) NOT NULL,
sharingended_ST varchar2(32) NOT NULL,
regcreated NUMBER(20,4) NOT NULL,
regcreated_ST varchar2(32) NOT NULL,
regapproved NUMBER(20,4) NOT NULL,
regapproved_ST varchar2(32) NOT NULL,
regdenied NUMBER(20,4) NOT NULL,
regdenied_ST varchar2(32) NOT NULL,
regcancelled NUMBER(20,4) NOT NULL,
regcancelled_ST varchar2(32) NOT NULL,
pcpntjoined NUMBER(20,4) NOT NULL,
pcpntjoined_ST varchar2(32) NOT NULL,
pcpntleft NUMBER(20,4) NOT NULL,
pcpntleft_ST varchar2(32) NOT NULL,
livestarted NUMBER(20,4) NOT NULL,
livestarted_ST varchar2(32) NOT NULL,
livestopped NUMBER(20,4) NOT NULL,
livestopped_ST varchar2(32) NOT NULL,
RECOVERED NUMBER(20,4) NOT NULL,
RECOVERED_ST varchar2(32) NOT NULL,
permdeleted NUMBER(20,4) NOT NULL,
permdeleted_ST varchar2(32) NOT NULL,
ALERT NUMBER(20,4) NOT NULL,
ALERT_ST varchar2(32) NOT NULL,
riskalert NUMBER(20,4) NOT NULL,
riskalert_ST varchar2(32) NOT NULL,
devicetested NUMBER(20,4) NOT NULL,
devicetested_ST varchar2(32) NOT NULL
);
ALTER TABLE ZoomMeetingTest ADD constraint PK_ZoomMeetingTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ZoomMeetingTest ON ZoomMeetingTest
(
	 MSMT_TIME
);
DROP TABLE ZoomMeetingTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomMeetingTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CREATED_MIN NUMBER(20,4) NOT NULL,
CREATED_MAX NUMBER(20,4) NOT NULL,
CREATED_STCNT varchar2(32) NOT NULL,
UPDATED_MIN NUMBER(20,4) NOT NULL,
UPDATED_MAX NUMBER(20,4) NOT NULL,
UPDATED_STCNT varchar2(32) NOT NULL,
DELETED_MIN NUMBER(20,4) NOT NULL,
DELETED_MAX NUMBER(20,4) NOT NULL,
DELETED_STCNT varchar2(32) NOT NULL,
STARTED_MIN NUMBER(20,4) NOT NULL,
STARTED_MAX NUMBER(20,4) NOT NULL,
STARTED_STCNT varchar2(32) NOT NULL,
ENDED_MIN NUMBER(20,4) NOT NULL,
ENDED_MAX NUMBER(20,4) NOT NULL,
ENDED_STCNT varchar2(32) NOT NULL,
sharingstarted_MIN NUMBER(20,4) NOT NULL,
sharingstarted_MAX NUMBER(20,4) NOT NULL,
sharingstarted_STCNT varchar2(32) NOT NULL,
sharingended_MIN NUMBER(20,4) NOT NULL,
sharingended_MAX NUMBER(20,4) NOT NULL,
sharingended_STCNT varchar2(32) NOT NULL,
regcreated_MIN NUMBER(20,4) NOT NULL,
regcreated_MAX NUMBER(20,4) NOT NULL,
regcreated_STCNT varchar2(32) NOT NULL,
regapproved_MIN NUMBER(20,4) NOT NULL,
regapproved_MAX NUMBER(20,4) NOT NULL,
regapproved_STCNT varchar2(32) NOT NULL,
regdenied_MIN NUMBER(20,4) NOT NULL,
regdenied_MAX NUMBER(20,4) NOT NULL,
regdenied_STCNT varchar2(32) NOT NULL,
regcancelled_MIN NUMBER(20,4) NOT NULL,
regcancelled_MAX NUMBER(20,4) NOT NULL,
regcancelled_STCNT varchar2(32) NOT NULL,
pcpntjoined_MIN NUMBER(20,4) NOT NULL,
pcpntjoined_MAX NUMBER(20,4) NOT NULL,
pcpntjoined_STCNT varchar2(32) NOT NULL,
pcpntleft_MIN NUMBER(20,4) NOT NULL,
pcpntleft_MAX NUMBER(20,4) NOT NULL,
pcpntleft_STCNT varchar2(32) NOT NULL,
livestarted_MIN NUMBER(20,4) NOT NULL,
livestarted_MAX NUMBER(20,4) NOT NULL,
livestarted_STCNT varchar2(32) NOT NULL,
livestopped_MIN NUMBER(20,4) NOT NULL,
livestopped_MAX NUMBER(20,4) NOT NULL,
livestopped_STCNT varchar2(32) NOT NULL,
RECOVERED_MIN NUMBER(20,4) NOT NULL,
RECOVERED_MAX NUMBER(20,4) NOT NULL,
RECOVERED_STCNT varchar2(32) NOT NULL,
permdeleted_MIN NUMBER(20,4) NOT NULL,
permdeleted_MAX NUMBER(20,4) NOT NULL,
permdeleted_STCNT varchar2(32) NOT NULL,
ALERT_MIN NUMBER(20,4) NOT NULL,
ALERT_MAX NUMBER(20,4) NOT NULL,
ALERT_STCNT varchar2(32) NOT NULL,
riskalert_MIN NUMBER(20,4) NOT NULL,
riskalert_MAX NUMBER(20,4) NOT NULL,
riskalert_STCNT varchar2(32) NOT NULL,
devicetested_MIN NUMBER(20,4) NOT NULL,
devicetested_MAX NUMBER(20,4) NOT NULL,
devicetested_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomMeetingTest_TREND ADD constraint PK_ZoomMeetingTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
CREATE INDEX IDX_TR_ZoomMeetingTest on ZoomMeetingTest_TREND(msmt_time,period);
DROP TABLE ZoomMeetingTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomMeetingTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CREATED_MIN	varchar2(256)	 NOT NULL,
CREATED_MAX	varchar2(256)	 NOT NULL,
UPDATED_MIN	varchar2(256)	 NOT NULL,
UPDATED_MAX	varchar2(256)	 NOT NULL,
DELETED_MIN	varchar2(256)	 NOT NULL,
DELETED_MAX	varchar2(256)	 NOT NULL,
STARTED_MIN	varchar2(256)	 NOT NULL,
STARTED_MAX	varchar2(256)	 NOT NULL,
ENDED_MIN	varchar2(256)	 NOT NULL,
ENDED_MAX	varchar2(256)	 NOT NULL,
sharingstarted_MIN	varchar2(256)	 NOT NULL,
sharingstarted_MAX	varchar2(256)	 NOT NULL,
sharingended_MIN	varchar2(256)	 NOT NULL,
sharingended_MAX	varchar2(256)	 NOT NULL,
regcreated_MIN	varchar2(256)	 NOT NULL,
regcreated_MAX	varchar2(256)	 NOT NULL,
regapproved_MIN	varchar2(256)	 NOT NULL,
regapproved_MAX	varchar2(256)	 NOT NULL,
regdenied_MIN	varchar2(256)	 NOT NULL,
regdenied_MAX	varchar2(256)	 NOT NULL,
regcancelled_MIN	varchar2(256)	 NOT NULL,
regcancelled_MAX	varchar2(256)	 NOT NULL,
pcpntjoined_MIN	varchar2(256)	 NOT NULL,
pcpntjoined_MAX	varchar2(256)	 NOT NULL,
pcpntleft_MIN	varchar2(256)	 NOT NULL,
pcpntleft_MAX	varchar2(256)	 NOT NULL,
livestarted_MIN	varchar2(256)	 NOT NULL,
livestarted_MAX	varchar2(256)	 NOT NULL,
livestopped_MIN	varchar2(256)	 NOT NULL,
livestopped_MAX	varchar2(256)	 NOT NULL,
RECOVERED_MIN	varchar2(256)	 NOT NULL,
RECOVERED_MAX	varchar2(256)	 NOT NULL,
permdeleted_MIN	varchar2(256)	 NOT NULL,
permdeleted_MAX	varchar2(256)	 NOT NULL,
ALERT_MIN	varchar2(256)	 NOT NULL,
ALERT_MAX	varchar2(256)	 NOT NULL,
riskalert_MIN	varchar2(256)	 NOT NULL,
riskalert_MAX	varchar2(256)	 NOT NULL,
devicetested_MIN	varchar2(256)	 NOT NULL,
devicetested_MAX	varchar2(256)	 NOT NULL
);
ALTER TABLE ZoomMeetingTest_THRESH ADD constraint PK_ZoomMeetingTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomMeetingTest_THRESH ON ZoomMeetingTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomMeetingTest on ZoomMeetingTest_THRESH(msmt_time_start);

DROP TABLE ZoomWebinarTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomWebinarTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CREATED NUMBER(20,4) NOT NULL,
CREATED_ST varchar2(32) NOT NULL,
UPDATED NUMBER(20,4) NOT NULL,
UPDATED_ST varchar2(32) NOT NULL,
DELETED NUMBER(20,4) NOT NULL,
DELETED_ST varchar2(32) NOT NULL,
STARTED NUMBER(20,4) NOT NULL,
STARTED_ST varchar2(32) NOT NULL,
ENDED NUMBER(20,4) NOT NULL,
ENDED_ST varchar2(32) NOT NULL,
sharingstarted NUMBER(20,4) NOT NULL,
sharingstarted_ST varchar2(32) NOT NULL,
sharingended NUMBER(20,4) NOT NULL,
sharingended_ST varchar2(32) NOT NULL,
regcreated NUMBER(20,4) NOT NULL,
regcreated_ST varchar2(32) NOT NULL,
regapproved NUMBER(20,4) NOT NULL,
regapproved_ST varchar2(32) NOT NULL,
regdenied NUMBER(20,4) NOT NULL,
regdenied_ST varchar2(32) NOT NULL,
regcancelled NUMBER(20,4) NOT NULL,
regcancelled_ST varchar2(32) NOT NULL,
pcpntjoined NUMBER(20,4) NOT NULL,
pcpntjoined_ST varchar2(32) NOT NULL,
pcpntleft NUMBER(20,4) NOT NULL,
pcpntleft_ST varchar2(32) NOT NULL,
ALERT NUMBER(20,4) NOT NULL,
ALERT_ST varchar2(32) NOT NULL
);
ALTER TABLE ZoomWebinarTest ADD constraint PK_ZoomWebinarTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ZoomWebinarTest ON ZoomWebinarTest
(
	 MSMT_TIME
);

DROP TABLE ZoomWebinarTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomWebinarTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CREATED_MIN NUMBER(20,4) NOT NULL,
CREATED_MAX NUMBER(20,4) NOT NULL,
CREATED_STCNT varchar2(32) NOT NULL,
UPDATED_MIN NUMBER(20,4) NOT NULL,
UPDATED_MAX NUMBER(20,4) NOT NULL,
UPDATED_STCNT varchar2(32) NOT NULL,
DELETED_MIN NUMBER(20,4) NOT NULL,
DELETED_MAX NUMBER(20,4) NOT NULL,
DELETED_STCNT varchar2(32) NOT NULL,
STARTED_MIN NUMBER(20,4) NOT NULL,
STARTED_MAX NUMBER(20,4) NOT NULL,
STARTED_STCNT varchar2(32) NOT NULL,
ENDED_MIN NUMBER(20,4) NOT NULL,
ENDED_MAX NUMBER(20,4) NOT NULL,
ENDED_STCNT varchar2(32) NOT NULL,
sharingstarted_MIN NUMBER(20,4) NOT NULL,
sharingstarted_MAX NUMBER(20,4) NOT NULL,
sharingstarted_STCNT varchar2(32) NOT NULL,
sharingended_MIN NUMBER(20,4) NOT NULL,
sharingended_MAX NUMBER(20,4) NOT NULL,
sharingended_STCNT varchar2(32) NOT NULL,
regcreated_MIN NUMBER(20,4) NOT NULL,
regcreated_MAX NUMBER(20,4) NOT NULL,
regcreated_STCNT varchar2(32) NOT NULL,
regapproved_MIN NUMBER(20,4) NOT NULL,
regapproved_MAX NUMBER(20,4) NOT NULL,
regapproved_STCNT varchar2(32) NOT NULL,
regdenied_MIN NUMBER(20,4) NOT NULL,
regdenied_MAX NUMBER(20,4) NOT NULL,
regdenied_STCNT varchar2(32) NOT NULL,
regcancelled_MIN NUMBER(20,4) NOT NULL,
regcancelled_MAX NUMBER(20,4) NOT NULL,
regcancelled_STCNT varchar2(32) NOT NULL,
pcpntjoined_MIN NUMBER(20,4) NOT NULL,
pcpntjoined_MAX NUMBER(20,4) NOT NULL,
pcpntjoined_STCNT varchar2(32) NOT NULL,
pcpntleft_MIN NUMBER(20,4) NOT NULL,
pcpntleft_MAX NUMBER(20,4) NOT NULL,
pcpntleft_STCNT varchar2(32) NOT NULL,
ALERT_MIN NUMBER(20,4) NOT NULL,
ALERT_MAX NUMBER(20,4) NOT NULL,
ALERT_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomWebinarTest_TREND ADD constraint PK_ZoomWebinarTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
CREATE INDEX IDX_TR_ZoomWebinarTest on ZoomWebinarTest_TREND(msmt_time,period);

DROP TABLE ZoomWebinarTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomWebinarTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CREATED_MIN	varchar2(256)	 NOT NULL,
CREATED_MAX	varchar2(256)	 NOT NULL,
UPDATED_MIN	varchar2(256)	 NOT NULL,
UPDATED_MAX	varchar2(256)	 NOT NULL,
DELETED_MIN	varchar2(256)	 NOT NULL,
DELETED_MAX	varchar2(256)	 NOT NULL,
STARTED_MIN	varchar2(256)	 NOT NULL,
STARTED_MAX	varchar2(256)	 NOT NULL,
ENDED_MIN	varchar2(256)	 NOT NULL,
ENDED_MAX	varchar2(256)	 NOT NULL,
sharingstarted_MIN	varchar2(256)	 NOT NULL,
sharingstarted_MAX	varchar2(256)	 NOT NULL,
sharingended_MIN	varchar2(256)	 NOT NULL,
sharingended_MAX	varchar2(256)	 NOT NULL,
regcreated_MIN	varchar2(256)	 NOT NULL,
regcreated_MAX	varchar2(256)	 NOT NULL,
regapproved_MIN	varchar2(256)	 NOT NULL,
regapproved_MAX	varchar2(256)	 NOT NULL,
regdenied_MIN	varchar2(256)	 NOT NULL,
regdenied_MAX	varchar2(256)	 NOT NULL,
regcancelled_MIN	varchar2(256)	 NOT NULL,
regcancelled_MAX	varchar2(256)	 NOT NULL,
pcpntjoined_MIN	varchar2(256)	 NOT NULL,
pcpntjoined_MAX	varchar2(256)	 NOT NULL,
pcpntleft_MIN	varchar2(256)	 NOT NULL,
pcpntleft_MAX	varchar2(256)	 NOT NULL,
ALERT_MIN	varchar2(256)	 NOT NULL,
ALERT_MAX	varchar2(256)	 NOT NULL
);
ALTER TABLE ZoomWebinarTest_THRESH ADD constraint PK_ZoomWebinarTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomWebinarTest_THRESH ON ZoomWebinarTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomWebinarTest on ZoomWebinarTest_THRESH(msmt_time_start);

DROP TABLE ZoomRecordTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomRecordTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
STARTED NUMBER(20,4) NOT NULL,
STARTED_ST varchar2(32) NOT NULL,
paused NUMBER(20,4) NOT NULL,
paused_ST varchar2(32) NOT NULL,
resumed NUMBER(20,4) NOT NULL,
resumed_ST varchar2(32) NOT NULL,
stopped NUMBER(20,4) NOT NULL,
stopped_ST varchar2(32) NOT NULL,
completed NUMBER(20,4) NOT NULL,
completed_ST varchar2(32) NOT NULL,
renamed NUMBER(20,4) NOT NULL,
renamed_ST varchar2(32) NOT NULL,
trashed NUMBER(20,4) NOT NULL,
trashed_ST varchar2(32) NOT NULL,
deleted NUMBER(20,4) NOT NULL,
deleted_ST varchar2(32) NOT NULL,
recovered NUMBER(20,4) NOT NULL,
recovered_ST varchar2(32) NOT NULL,
transcriptcompleted NUMBER(20,4) NOT NULL,
transcriptcompleted_ST varchar2(32) NOT NULL,
reg_created NUMBER(20,4) NOT NULL,
reg_created_ST varchar2(32) NOT NULL,
reg_approved NUMBER(20,4) NOT NULL,
reg_approved_ST varchar2(32) NOT NULL,
reg_denied NUMBER(20,4) NOT NULL,
reg_denied_ST varchar2(32) NOT NULL
);
ALTER TABLE ZoomRecordTest ADD constraint PK_ZoomRecordTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ZoomRecordTest ON ZoomRecordTest
(
	 MSMT_TIME
);

DROP TABLE ZoomRecordTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomRecordTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
STARTED_MIN NUMBER(20,4) NOT NULL,
STARTED_MAX NUMBER(20,4) NOT NULL,
STARTED_STCNT varchar2(32) NOT NULL,
paused_MIN NUMBER(20,4) NOT NULL,
paused_MAX NUMBER(20,4) NOT NULL,
paused_STCNT varchar2(32) NOT NULL,
resumed_MIN NUMBER(20,4) NOT NULL,
resumed_MAX NUMBER(20,4) NOT NULL,
resumed_STCNT varchar2(32) NOT NULL,
stopped_MIN NUMBER(20,4) NOT NULL,
stopped_MAX NUMBER(20,4) NOT NULL,
stopped_STCNT varchar2(32) NOT NULL,
completed_MIN NUMBER(20,4) NOT NULL,
completed_MAX NUMBER(20,4) NOT NULL,
completed_STCNT varchar2(32) NOT NULL,
renamed_MIN NUMBER(20,4) NOT NULL,
renamed_MAX NUMBER(20,4) NOT NULL,
renamed_STCNT varchar2(32) NOT NULL,
trashed_MIN NUMBER(20,4) NOT NULL,
trashed_MAX NUMBER(20,4) NOT NULL,
trashed_STCNT varchar2(32) NOT NULL,
deleted_MIN NUMBER(20,4) NOT NULL,
deleted_MAX NUMBER(20,4) NOT NULL,
deleted_STCNT varchar2(32) NOT NULL,
recovered_MIN NUMBER(20,4) NOT NULL,
recovered_MAX NUMBER(20,4) NOT NULL,
recovered_STCNT varchar2(32) NOT NULL,
transcriptcompleted_MIN NUMBER(20,4) NOT NULL,
transcriptcompleted_MAX NUMBER(20,4) NOT NULL,
transcriptcompleted_STCNT varchar2(32) NOT NULL,
reg_created_MIN NUMBER(20,4) NOT NULL,
reg_created_MAX NUMBER(20,4) NOT NULL,
reg_created_STCNT varchar2(32) NOT NULL,
reg_approved_MIN NUMBER(20,4) NOT NULL,
reg_approved_MAX NUMBER(20,4) NOT NULL,
reg_approved_STCNT varchar2(32) NOT NULL,
reg_denied_MIN NUMBER(20,4) NOT NULL,
reg_denied_MAX NUMBER(20,4) NOT NULL,
reg_denied_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomRecordTest_TREND ADD constraint PK_ZoomRecordTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
CREATE INDEX IDX_TR_ZoomRecordTest on ZoomRecordTest_TREND(msmt_time,period);

DROP TABLE ZoomRecordTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomRecordTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
STARTED_MIN	varchar2(256)	 NOT NULL,
STARTED_MAX	varchar2(256)	 NOT NULL,
paused_MIN	varchar2(256)	 NOT NULL,
paused_MAX	varchar2(256)	 NOT NULL,
resumed_MIN	varchar2(256)	 NOT NULL,
resumed_MAX	varchar2(256)	 NOT NULL,
stopped_MIN	varchar2(256)	 NOT NULL,
stopped_MAX	varchar2(256)	 NOT NULL,
completed_MIN	varchar2(256)	 NOT NULL,
completed_MAX	varchar2(256)	 NOT NULL,
renamed_MIN	varchar2(256)	 NOT NULL,
renamed_MAX	varchar2(256)	 NOT NULL,
trashed_MIN	varchar2(256)	 NOT NULL,
trashed_MAX	varchar2(256)	 NOT NULL,
deleted_MIN	varchar2(256)	 NOT NULL,
deleted_MAX	varchar2(256)	 NOT NULL,
recovered_MIN	varchar2(256)	 NOT NULL,
recovered_MAX	varchar2(256)	 NOT NULL,
transcriptcompleted_MIN	varchar2(256)	 NOT NULL,
transcriptcompleted_MAX	varchar2(256)	 NOT NULL,
reg_created_MIN	varchar2(256)	 NOT NULL,
reg_created_MAX	varchar2(256)	 NOT NULL,
reg_approved_MIN	varchar2(256)	 NOT NULL,
reg_approved_MAX	varchar2(256)	 NOT NULL,
reg_denied_MIN	varchar2(256)	 NOT NULL,
reg_denied_MAX	varchar2(256)	 NOT NULL
);
ALTER TABLE ZoomRecordTest_THRESH ADD constraint PK_ZoomRecordTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomRecordTest_THRESH ON ZoomRecordTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomRecordTest on ZoomRecordTest_THRESH(msmt_time_start);

DROP TABLE ZoomUserTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomUserTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CREATED NUMBER(20,4) NOT NULL,
CREATED_ST varchar2(32) NOT NULL,
UPDATED NUMBER(20,4) NOT NULL,
UPDATED_ST varchar2(32) NOT NULL,
DELETED NUMBER(20,4) NOT NULL,
DELETED_ST varchar2(32) NOT NULL,
activated NUMBER(20,4) NOT NULL,
activated_ST varchar2(32) NOT NULL,
deactivated NUMBER(20,4) NOT NULL,
deactivated_ST varchar2(32) NOT NULL,
accepted NUMBER(20,4) NOT NULL,
accepted_ST varchar2(32) NOT NULL,
disassociated NUMBER(20,4) NOT NULL,
disassociated_ST varchar2(32) NOT NULL,
settingsupdated NUMBER(20,4) NOT NULL,
settingsupdated_ST varchar2(32) NOT NULL
);
ALTER TABLE ZoomUserTest ADD constraint PK_ZoomUserTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ZoomUserTest ON ZoomUserTest
(
	 MSMT_TIME
);

DROP TABLE ZoomUserTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomUserTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CREATED_MIN NUMBER(20,4) NOT NULL,
CREATED_MAX NUMBER(20,4) NOT NULL,
CREATED_STCNT varchar2(32) NOT NULL,
UPDATED_MIN NUMBER(20,4) NOT NULL,
UPDATED_MAX NUMBER(20,4) NOT NULL,
UPDATED_STCNT varchar2(32) NOT NULL,
DELETED_MIN NUMBER(20,4) NOT NULL,
DELETED_MAX NUMBER(20,4) NOT NULL,
DELETED_STCNT varchar2(32) NOT NULL,
activated_MIN NUMBER(20,4) NOT NULL,
activated_MAX NUMBER(20,4) NOT NULL,
activated_STCNT varchar2(32) NOT NULL,
deactivated_MIN NUMBER(20,4) NOT NULL,
deactivated_MAX NUMBER(20,4) NOT NULL,
deactivated_STCNT varchar2(32) NOT NULL,
accepted_MIN NUMBER(20,4) NOT NULL,
accepted_MAX NUMBER(20,4) NOT NULL,
accepted_STCNT varchar2(32) NOT NULL,
disassociated_MIN NUMBER(20,4) NOT NULL,
disassociated_MAX NUMBER(20,4) NOT NULL,
disassociated_STCNT varchar2(32) NOT NULL,
settingsupdated_MIN NUMBER(20,4) NOT NULL,
settingsupdated_MAX NUMBER(20,4) NOT NULL,
settingsupdated_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomUserTest_TREND ADD constraint PK_ZoomUserTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
CREATE INDEX IDX_TR_ZoomUserTest on ZoomUserTest_TREND(msmt_time,period);

DROP TABLE ZoomUserTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomUserTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CREATED_MIN	varchar2(256)	 NOT NULL,
CREATED_MAX	varchar2(256)	 NOT NULL,
UPDATED_MIN	varchar2(256)	 NOT NULL,
UPDATED_MAX	varchar2(256)	 NOT NULL,
DELETED_MIN	varchar2(256)	 NOT NULL,
DELETED_MAX	varchar2(256)	 NOT NULL,
activated_MIN	varchar2(256)	 NOT NULL,
activated_MAX	varchar2(256)	 NOT NULL,
deactivated_MIN	varchar2(256)	 NOT NULL,
deactivated_MAX	varchar2(256)	 NOT NULL,
accepted_MIN	varchar2(256)	 NOT NULL,
accepted_MAX	varchar2(256)	 NOT NULL,
disassociated_MIN	varchar2(256)	 NOT NULL,
disassociated_MAX	varchar2(256)	 NOT NULL,
settingsupdated_MIN	varchar2(256)	 NOT NULL,
settingsupdated_MAX	varchar2(256)	 NOT NULL
);
ALTER TABLE ZoomUserTest_THRESH ADD constraint PK_ZoomUserTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomUserTest_THRESH ON ZoomUserTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomUserTest on ZoomUserTest_THRESH(msmt_time_start);

DROP TABLE ZoomUserActTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomUserActTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
signin NUMBER(20,4) NOT NULL,
signin_ST varchar2(32) NOT NULL,
signout NUMBER(20,4) NOT NULL,
signout_ST varchar2(32) NOT NULL,
statusupdated NUMBER(20,4) NOT NULL,
statusupdated_ST varchar2(32) NOT NULL,
notesupdated NUMBER(20,4) NOT NULL,
notesupdated_ST varchar2(32) NOT NULL
);
ALTER TABLE ZoomUserActTest ADD constraint PK_ZoomUserActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ZoomUserActTest ON ZoomUserActTest
(
	 MSMT_TIME
);

DROP TABLE ZoomUserActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomUserActTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
signin_MIN NUMBER(20,4) NOT NULL,
signin_MAX NUMBER(20,4) NOT NULL,
signin_STCNT varchar2(32) NOT NULL,
signout_MIN NUMBER(20,4) NOT NULL,
signout_MAX NUMBER(20,4) NOT NULL,
signout_STCNT varchar2(32) NOT NULL,
statusupdated_MIN NUMBER(20,4) NOT NULL,
statusupdated_MAX NUMBER(20,4) NOT NULL,
statusupdated_STCNT varchar2(32) NOT NULL,
notesupdated_MIN NUMBER(20,4) NOT NULL,
notesupdated_MAX NUMBER(20,4) NOT NULL,
notesupdated_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomUserActTest_TREND ADD constraint PK_ZoomUserActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
CREATE INDEX IDX_TR_ZoomUserActTest on ZoomUserActTest_TREND(msmt_time,period);

DROP TABLE ZoomUserActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomUserActTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
signin_MIN	varchar2(256)	 NOT NULL,
signin_MAX	varchar2(256)	 NOT NULL,
signout_MIN	varchar2(256)	 NOT NULL,
signout_MAX	varchar2(256)	 NOT NULL,
statusupdated_MIN	varchar2(256)	 NOT NULL,
statusupdated_MAX	varchar2(256)	 NOT NULL,
notesupdated_MIN	varchar2(256)	 NOT NULL,
notesupdated_MAX	varchar2(256)	 NOT NULL
);
ALTER TABLE ZoomUserActTest_THRESH ADD constraint PK_ZoomUserActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomUserActTest_THRESH ON ZoomUserActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomUserActTest on ZoomUserActTest_THRESH(msmt_time_start);

DROP TABLE ZoomRoomTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomRoomTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
alert NUMBER(20,4) NOT NULL,
alert_ST varchar2(32) NOT NULL,
delayed_alert NUMBER(20,4) NOT NULL,
delayed_alert_ST varchar2(32) NOT NULL,
checked_in NUMBER(20,4) NOT NULL,
checked_in_ST varchar2(32) NOT NULL,
checked_out NUMBER(20,4) NOT NULL,
checked_out_ST varchar2(32) NOT NULL
);
ALTER TABLE ZoomRoomTest ADD constraint PK_ZoomRoomTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ZoomRoomTest ON ZoomRoomTest
(
	 MSMT_TIME
);

DROP TABLE ZoomRoomTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomRoomTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
alert_MIN NUMBER(20,4) NOT NULL,
alert_MAX NUMBER(20,4) NOT NULL,
alert_STCNT varchar2(32) NOT NULL,
delayed_alert_MIN NUMBER(20,4) NOT NULL,
delayed_alert_MAX NUMBER(20,4) NOT NULL,
delayed_alert_STCNT varchar2(32) NOT NULL,
checked_in_MIN NUMBER(20,4) NOT NULL,
checked_in_MAX NUMBER(20,4) NOT NULL,
checked_in_STCNT varchar2(32) NOT NULL,
checked_out_MIN NUMBER(20,4) NOT NULL,
checked_out_MAX NUMBER(20,4) NOT NULL,
checked_out_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomRoomTest_TREND ADD constraint PK_ZoomRoomTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
CREATE INDEX IDX_TR_ZoomRoomTest on ZoomRoomTest_TREND(msmt_time,period);

DROP TABLE ZoomRoomTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomRoomTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
alert_MIN	varchar2(256)	 NOT NULL,
alert_MAX	varchar2(256)	 NOT NULL,
delayed_alert_MIN	varchar2(256)	 NOT NULL,
delayed_alert_MAX	varchar2(256)	 NOT NULL,
checked_in_MIN	varchar2(256)	 NOT NULL,
checked_in_MAX	varchar2(256)	 NOT NULL,
checked_out_MIN	varchar2(256)	 NOT NULL,
checked_out_MAX	varchar2(256)	 NOT NULL
);
ALTER TABLE ZoomRoomTest_THRESH ADD constraint PK_ZoomRoomTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomRoomTest_THRESH ON ZoomRoomTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomRoomTest on ZoomRoomTest_THRESH(msmt_time_start);

DROP TABLE ZoomTSPTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomTSPTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CREATED NUMBER(20,4) NOT NULL,
CREATED_ST varchar2(32) NOT NULL,
UPDATED NUMBER(20,4) NOT NULL,
UPDATED_ST varchar2(32) NOT NULL,
DELETED NUMBER(20,4) NOT NULL,
DELETED_ST varchar2(32) NOT NULL);
ALTER TABLE ZoomTSPTest ADD constraint PK_ZoomTSPTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ZoomTSPTest ON ZoomTSPTest
(
	 MSMT_TIME
);
DROP TABLE ZoomTSPTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomTSPTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CREATED_MIN NUMBER(20,4) NOT NULL,
CREATED_MAX NUMBER(20,4) NOT NULL,
CREATED_STCNT varchar2(32) NOT NULL,
UPDATED_MIN NUMBER(20,4) NOT NULL,
UPDATED_MAX NUMBER(20,4) NOT NULL,
UPDATED_STCNT varchar2(32) NOT NULL,
DELETED_MIN NUMBER(20,4) NOT NULL,
DELETED_MAX NUMBER(20,4) NOT NULL,
DELETED_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomTSPTest_TREND ADD constraint PK_ZoomTSPTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
CREATE INDEX IDX_TR_ZoomTSPTest on ZoomTSPTest_TREND(msmt_time,period);
DROP TABLE ZoomTSPTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomTSPTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CREATED_MIN	varchar2(256)	 NOT NULL,
CREATED_MAX	varchar2(256)	 NOT NULL,
UPDATED_MIN	varchar2(256)	 NOT NULL,
UPDATED_MAX	varchar2(256)	 NOT NULL,
DELETED_MIN	varchar2(256)	 NOT NULL,
DELETED_MAX	varchar2(256)	 NOT NULL
);
ALTER TABLE ZoomTSPTest_THRESH ADD constraint PK_ZoomTSPTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomTSPTest_THRESH ON ZoomTSPTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomTSPTest on ZoomTSPTest_THRESH(msmt_time_start);

DROP TABLE ZoomBillingTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomBillingTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
NEW 			NUMBER(20,4) NOT NULL,
NEW_ST 			varchar2(32) NOT NULL,
ADDON 			NUMBER(20,4) NOT NULL,
ADDON_ST 		varchar2(32) NOT NULL,
UPDATED NUMBER(20,4) NOT NULL,
UPDATED_ST varchar2(32) NOT NULL,
CANCELLED NUMBER(20,4) NOT NULL,
CANCELLED_ST varchar2(32) NOT NULL
);
ALTER TABLE ZoomBillingTest ADD constraint PK_ZoomBillingTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ZoomBillingTest ON ZoomBillingTest
(
	 MSMT_TIME
);
DROP TABLE ZoomBillingTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomBillingTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
NEW_MIN NUMBER(20,4) NOT NULL,
NEW_MAX NUMBER(20,4) NOT NULL,
NEW_STCNT varchar2(32) NOT NULL,
ADDON_MIN NUMBER(20,4) NOT NULL,
ADDON_MAX NUMBER(20,4) NOT NULL,
ADDON_STCNT varchar2(32) NOT NULL,
UPDATED_MIN NUMBER(20,4) NOT NULL,
UPDATED_MAX NUMBER(20,4) NOT NULL,
UPDATED_STCNT varchar2(32) NOT NULL,
CANCELLED_MIN NUMBER(20,4) NOT NULL,
CANCELLED_MAX NUMBER(20,4) NOT NULL,
CANCELLED_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomBillingTest_TREND ADD constraint PK_ZoomBillingTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
CREATE INDEX IDX_TR_ZoomBillingTest on ZoomBillingTest_TREND(msmt_time,period);
DROP TABLE ZoomBillingTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomBillingTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
NEW_MIN	varchar2(256)	 NOT NULL,
NEW_MAX	varchar2(256)	 NOT NULL,
ADDON_MIN	varchar2(256)	 NOT NULL,
ADDON_MAX	varchar2(256)	 NOT NULL,
UPDATED_MIN	varchar2(256)	 NOT NULL,
UPDATED_MAX	varchar2(256)	 NOT NULL,
CANCELLED_MIN	varchar2(256)	 NOT NULL,
CANCELLED_MAX	varchar2(256)	 NOT NULL
);
ALTER TABLE ZoomBillingTest_THRESH ADD constraint PK_ZoomBillingTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomBillingTest_THRESH ON ZoomBillingTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomBillingTest on ZoomBillingTest_THRESH(msmt_time_start);

DROP TABLE ZoomAccountTest CASCADE CONSTRAINTS;
CREATE TABLE ZoomAccountTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CREATED NUMBER(20,4) NOT NULL,
CREATED_ST varchar2(32) NOT NULL,
UPDATED NUMBER(20,4) NOT NULL,
UPDATED_ST varchar2(32) NOT NULL,
settings_updated NUMBER(20,4) NOT NULL,
settings_updated_ST varchar2(32) NOT NULL,
disassociated NUMBER(20,4) NOT NULL,
disassociated_ST varchar2(32) NOT NULL,
vanityurlapproved NUMBER(20,4) NOT NULL,
vanityurlapproved_ST varchar2(32) NOT NULL,
vanityurlrejected NUMBER(20,4) NOT NULL,
vanityurlrejected_ST varchar2(32) NOT NULL
);
ALTER TABLE ZoomAccountTest ADD constraint PK_ZoomAccountTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
CREATE  INDEX IDX_ZoomAccountTest ON ZoomAccountTest
(
	 MSMT_TIME
);

DROP TABLE ZoomAccountTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ZoomAccountTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CREATED_MIN NUMBER(20,4) NOT NULL,
CREATED_MAX NUMBER(20,4) NOT NULL,
CREATED_STCNT varchar2(32) NOT NULL,
UPDATED_MIN NUMBER(20,4) NOT NULL,
UPDATED_MAX NUMBER(20,4) NOT NULL,
UPDATED_STCNT varchar2(32) NOT NULL,
settings_updated_MIN NUMBER(20,4) NOT NULL,
settings_updated_MAX NUMBER(20,4) NOT NULL,
settings_updated_STCNT varchar2(32) NOT NULL,
disassociated_MIN NUMBER(20,4) NOT NULL,
disassociated_MAX NUMBER(20,4) NOT NULL,
disassociated_STCNT varchar2(32) NOT NULL,
vanityurlapproved_MIN NUMBER(20,4) NOT NULL,
vanityurlapproved_MAX NUMBER(20,4) NOT NULL,
vanityurlapproved_STCNT varchar2(32) NOT NULL,
vanityurlrejected_MIN NUMBER(20,4) NOT NULL,
vanityurlrejected_MAX NUMBER(20,4) NOT NULL,
vanityurlrejected_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ZoomAccountTest_TREND ADD constraint PK_ZoomAccountTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
CREATE INDEX IDX_TR_ZoomAccountTest on ZoomAccountTest_TREND(msmt_time,period);

DROP TABLE ZoomAccountTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ZoomAccountTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CREATED_MIN	varchar2(256)	 NOT NULL,
CREATED_MAX	varchar2(256)	 NOT NULL,
UPDATED_MIN	varchar2(256)	 NOT NULL,
UPDATED_MAX	varchar2(256)	 NOT NULL,
settings_updated_MIN	varchar2(256)	 NOT NULL,
settings_updated_MAX	varchar2(256)	 NOT NULL,
disassociated_MIN	varchar2(256)	 NOT NULL,
disassociated_MAX	varchar2(256)	 NOT NULL,
vanityurlapproved_MIN	varchar2(256)	 NOT NULL,
vanityurlapproved_MAX	varchar2(256)	 NOT NULL,
vanityurlrejected_MIN	varchar2(256)	 NOT NULL,
vanityurlrejected_MAX	varchar2(256)	 NOT NULL
);
ALTER TABLE ZoomAccountTest_THRESH ADD constraint PK_ZoomAccountTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ZoomAccountTest_THRESH ON ZoomAccountTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ZoomAccountTest on ZoomAccountTest_THRESH(msmt_time_start);

DROP TABLE RedisStrmKeyStatTest CASCADE CONSTRAINTS;
CREATE TABLE RedisStrmKeyStatTest(
TRGT_HOST			VARCHAR2(32),
PORT_NO				VARCHAR2(32),
SITE_NAME			VARCHAR2(64),
INFO				VARCHAR2(128),
MSMT_HOST			VARCHAR2(32),
MSMT_TIME			DATE,
MemUsage			NUMBER(20,4)	NOT NULL,
MemUsage_ST		VARCHAR2(32)	NOT NULL,
ttl				NUMBER(20,4)	NOT NULL,
ttl_ST			VARCHAR2(32)	NOT NULL,
Length				NUMBER(20,4)	NOT NULL,
Length_ST				VARCHAR2(32)	NOT NULL);

CREATE INDEX IDX_RedisStrmKeyStatTest ON RedisStrmKeyStatTest(MSMT_TIME);
ALTER TABLE RedisStrmKeyStatTest ADD constraint PK_RedisStrmKeyStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE RedisStrmKeyStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RedisStrmKeyStatTest_TREND(
TRGT_HOST			VARCHAR2(32),
PORT_NO				VARCHAR2(32),
SITE_NAME			VARCHAR2(64),
INFO				VARCHAR2(128),
MSMT_HOST			VARCHAR2(32),
MSMT_TIME			DATE,
PERIOD				VARCHAR2(32),
MemUsage_MIN		NUMBER(20,4)	NOT NULL,
MemUsage_MAX		NUMBER(20,4)	NOT NULL,
MemUsage_STCNT		VARCHAR2(32)	NOT NULL,
ttl_MIN			NUMBER(20,4)	NOT NULL,
ttl_MAX			NUMBER(20,4)	NOT NULL,
ttl_STCNT			VARCHAR2(32)	NOT NULL,
Length_MIN			NUMBER(20,4)	NOT NULL,
Length_MAX			NUMBER(20,4)	NOT NULL,
Length_STCNT			VARCHAR2(32)	NOT NULL);
ALTER TABLE RedisStrmKeyStatTest_TREND ADD constraint PK_RedisStrmKeyStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE RedisStrmKeyStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RedisStrmKeyStatTest_THRESH(
TRGT_HOST			VARCHAR2(32),
PORT_NO				VARCHAR2(32),
SITE_NAME			VARCHAR2(64),
INFO				VARCHAR2(128),
MSMT_HOST			VARCHAR2(32),
MSMT_TIME_START			DATE,
MSMT_TIME_END			DATE,
MemUsage_MIN		VARCHAR2(256)	NOT NULL,
MemUsage_MAX		VARCHAR2(256)	NOT NULL,
ttl_MIN			VARCHAR2(256)	NOT NULL,
ttl_MAX			VARCHAR2(256)	NOT NULL,
Length_MIN			VARCHAR2(256)	NOT NULL,
Length_MAX			VARCHAR2(256)	NOT NULL);

ALTER TABLE RedisStrmKeyStatTest_THRESH ADD constraint PK_RedisStrmKeyStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RedisStrmKeyStat_THRESH ON RedisStrmKeyStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RedisStrmKeyStatTest ON RedisStrmKeyStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RedisStrmKeyStatTest ON RedisStrmKeyStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE RedisStrmGrpStTest CASCADE CONSTRAINTS;
CREATE TABLE RedisStrmGrpStTest(
TRGT_HOST			VARCHAR2(32),
PORT_NO				VARCHAR2(32),
SITE_NAME			VARCHAR2(64),
INFO				VARCHAR2(128),
MSMT_HOST			VARCHAR2(32),
MSMT_TIME			DATE,
PendEntList			NUMBER(20,4)	NOT NULL,
PendEntList_ST		VARCHAR2(32)	NOT NULL);

CREATE INDEX IDX_RedisStrmGrpStTest ON RedisStrmGrpStTest(MSMT_TIME);
ALTER TABLE RedisStrmGrpStTest ADD constraint PK_RedisStrmGrpStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE RedisStrmGrpStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE RedisStrmGrpStTest_TREND(
TRGT_HOST			VARCHAR2(32),
PORT_NO				VARCHAR2(32),
SITE_NAME			VARCHAR2(64),
INFO				VARCHAR2(128),
MSMT_HOST			VARCHAR2(32),
MSMT_TIME			DATE,
PERIOD				VARCHAR2(32),
PendEntList_MIN		NUMBER(20,4)	NOT NULL,
PendEntList_MAX		NUMBER(20,4)	NOT NULL,
PendEntList_STCNT		VARCHAR2(32)	NOT NULL);
ALTER TABLE RedisStrmGrpStTest_TREND ADD constraint PK_RedisStrmGroupStat_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE RedisStrmGrpStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RedisStrmGrpStTest_THRESH(
TRGT_HOST			VARCHAR2(32),
PORT_NO				VARCHAR2(32),
SITE_NAME			VARCHAR2(64),
INFO				VARCHAR2(128),
MSMT_HOST			VARCHAR2(32),
MSMT_TIME_START			DATE,
MSMT_TIME_END			DATE,
PendEntList_MIN		VARCHAR2(256)	NOT NULL,
PendEntList_MAX		VARCHAR2(256)	NOT NULL);

ALTER TABLE RedisStrmGrpStTest_THRESH ADD constraint PK_RedisStrmGroupStat_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RedisStrmGroupStat_THRESH ON RedisStrmGrpStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RedisStrmGrpStTest ON RedisStrmGrpStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RedisStrmGrpStTest ON RedisStrmGrpStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE StormClustTest CASCADE CONSTRAINTS;
CREATE TABLE StormClustTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SUPERVISORS Number(20,4) NOT NULL,
SUPERVISORS_ST varchar2(32) NOT NULL,
TOPOLOGIES Number(20,4) NOT NULL,
TOPOLOGIES_ST varchar2(32) NOT NULL,
EXECUTORSTOTAL Number(20,4) NOT NULL,
EXECUTORSTOTAL_ST varchar2(32) NOT NULL,
TASKSTOTAL Number(20,4) NOT NULL,
TASKSTOTAL_ST varchar2(32) NOT NULL,
TOTALMEM Number(20,4) NOT NULL,
TOTALMEM_ST varchar2(32) NOT NULL,
AVAILMEM Number(20,4) NOT NULL,
AVAILMEM_ST varchar2(32) NOT NULL,
USEDMEM Number(20,4) NOT NULL,
USEDMEM_ST varchar2(32) NOT NULL,
AVAILMEMPERCENT Number(20,4) NOT NULL,
AVAILMEMPERCENT_ST varchar2(32) NOT NULL,
TOTALCPU Number(20,4) NOT NULL,
TOTALCPU_ST varchar2(32) NOT NULL,
AVAILCPU Number(20,4) NOT NULL,
AVAILCPU_ST varchar2(32) NOT NULL,
USEDCPU Number(20,4) NOT NULL,
USEDCPU_ST varchar2(32) NOT NULL,
AVAILCPUPERCENT Number(20,4) NOT NULL,
AVAILCPUPERCENT_ST varchar2(32) NOT NULL,
SLOTSTOTAL Number(20,4) NOT NULL,
SLOTSTOTAL_ST varchar2(32) NOT NULL,
SLOTSFREE Number(20,4) NOT NULL,
SLOTSFREE_ST varchar2(32) NOT NULL,
SLOTSUSED Number(20,4) NOT NULL,
SLOTSUSED_ST varchar2(32) NOT NULL,
SLOTSUSEDPERCENT Number(20,4) NOT NULL,
SLOTSUSEDPERCENT_ST varchar2(32) NOT NULL,
MEMASSIGNEDPERCENTUTIL Number(20,4) NOT NULL,
MEMASSIGNEDPERCENTUTIL_ST varchar2(32) NOT NULL,
CPUASSIGNEDPERCENTUTIL Number(20,4) NOT NULL,
CPUASSIGNEDPERCENTUTIL_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_StormClustTest ON StormClustTest(MSMT_TIME);
ALTER TABLE StormClustTest ADD constraint PK_StormClustTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE StormClustTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE StormClustTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SUPERVISORS_MIN Number(20,4) NOT NULL,
SUPERVISORS_MAX Number(20,4) NOT NULL,
SUPERVISORS_STCNT varchar2(32) NOT NULL,
TOPOLOGIES_MIN Number(20,4) NOT NULL,
TOPOLOGIES_MAX Number(20,4) NOT NULL,
TOPOLOGIES_STCNT varchar2(32) NOT NULL,
EXECUTORSTOTAL_MIN Number(20,4) NOT NULL,
EXECUTORSTOTAL_MAX Number(20,4) NOT NULL,
EXECUTORSTOTAL_STCNT varchar2(32) NOT NULL,
TASKSTOTAL_MIN Number(20,4) NOT NULL,
TASKSTOTAL_MAX Number(20,4) NOT NULL,
TASKSTOTAL_STCNT varchar2(32) NOT NULL,
TOTALMEM_MIN Number(20,4) NOT NULL,
TOTALMEM_MAX Number(20,4) NOT NULL,
TOTALMEM_STCNT varchar2(32) NOT NULL,
AVAILMEM_MIN Number(20,4) NOT NULL,
AVAILMEM_MAX Number(20,4) NOT NULL,
AVAILMEM_STCNT varchar2(32) NOT NULL,
USEDMEM_MIN Number(20,4) NOT NULL,
USEDMEM_MAX Number(20,4) NOT NULL,
USEDMEM_STCNT varchar2(32) NOT NULL,
AVAILMEMPERCENT_MIN Number(20,4) NOT NULL,
AVAILMEMPERCENT_MAX Number(20,4) NOT NULL,
AVAILMEMPERCENT_STCNT varchar2(32) NOT NULL,
TOTALCPU_MIN Number(20,4) NOT NULL,
TOTALCPU_MAX Number(20,4) NOT NULL,
TOTALCPU_STCNT varchar2(32) NOT NULL,
AVAILCPU_MIN Number(20,4) NOT NULL,
AVAILCPU_MAX Number(20,4) NOT NULL,
AVAILCPU_STCNT varchar2(32) NOT NULL,
USEDCPU_MIN Number(20,4) NOT NULL,
USEDCPU_MAX Number(20,4) NOT NULL,
USEDCPU_STCNT varchar2(32) NOT NULL,
AVAILCPUPERCENT_MIN Number(20,4) NOT NULL,
AVAILCPUPERCENT_MAX Number(20,4) NOT NULL,
AVAILCPUPERCENT_STCNT varchar2(32) NOT NULL,
SLOTSTOTAL_MIN Number(20,4) NOT NULL,
SLOTSTOTAL_MAX Number(20,4) NOT NULL,
SLOTSTOTAL_STCNT varchar2(32) NOT NULL,
SLOTSFREE_MIN Number(20,4) NOT NULL,
SLOTSFREE_MAX Number(20,4) NOT NULL,
SLOTSFREE_STCNT varchar2(32) NOT NULL,
SLOTSUSED_MIN Number(20,4) NOT NULL,
SLOTSUSED_MAX Number(20,4) NOT NULL,
SLOTSUSED_STCNT varchar2(32) NOT NULL,
SLOTSUSEDPERCENT_MIN Number(20,4) NOT NULL,
SLOTSUSEDPERCENT_MAX Number(20,4) NOT NULL,
SLOTSUSEDPERCENT_STCNT varchar2(32) NOT NULL,
MEMASSIGNEDPERCENTUTIL_MIN Number(20,4) NOT NULL,
MEMASSIGNEDPERCENTUTIL_MAX Number(20,4) NOT NULL,
MEMASSIGNEDPERCENTUTIL_STCNT varchar2(32) NOT NULL,
CPUASSIGNEDPERCENTUTIL_MIN Number(20,4) NOT NULL,
CPUASSIGNEDPERCENTUTIL_MAX Number(20,4) NOT NULL,
CPUASSIGNEDPERCENTUTIL_STCNT varchar2(32) NOT NULL);

ALTER TABLE StormClustTest_TREND ADD constraint PK_StormClustTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE StormClustTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE StormClustTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SUPERVISORS_MIN VARCHAR2(256) NOT NULL,
SUPERVISORS_MAX VARCHAR2(256) NOT NULL,
TOPOLOGIES_MIN VARCHAR2(256) NOT NULL,
TOPOLOGIES_MAX VARCHAR2(256) NOT NULL,
EXECUTORSTOTAL_MIN VARCHAR2(256) NOT NULL,
EXECUTORSTOTAL_MAX VARCHAR2(256) NOT NULL,
TASKSTOTAL_MIN VARCHAR2(256) NOT NULL,
TASKSTOTAL_MAX VARCHAR2(256) NOT NULL,
TOTALMEM_MIN VARCHAR2(256) NOT NULL,
TOTALMEM_MAX VARCHAR2(256) NOT NULL,
AVAILMEM_MIN VARCHAR2(256) NOT NULL,
AVAILMEM_MAX VARCHAR2(256) NOT NULL,
USEDMEM_MIN VARCHAR2(256) NOT NULL,
USEDMEM_MAX VARCHAR2(256) NOT NULL,
AVAILMEMPERCENT_MIN VARCHAR2(256) NOT NULL,
AVAILMEMPERCENT_MAX VARCHAR2(256) NOT NULL,
TOTALCPU_MIN VARCHAR2(256) NOT NULL,
TOTALCPU_MAX VARCHAR2(256) NOT NULL,
AVAILCPU_MIN VARCHAR2(256) NOT NULL,
AVAILCPU_MAX VARCHAR2(256) NOT NULL,
USEDCPU_MIN VARCHAR2(256) NOT NULL,
USEDCPU_MAX VARCHAR2(256) NOT NULL,
AVAILCPUPERCENT_MIN VARCHAR2(256) NOT NULL,
AVAILCPUPERCENT_MAX VARCHAR2(256) NOT NULL,
SLOTSTOTAL_MIN VARCHAR2(256) NOT NULL,
SLOTSTOTAL_MAX VARCHAR2(256) NOT NULL,
SLOTSFREE_MIN VARCHAR2(256) NOT NULL,
SLOTSFREE_MAX VARCHAR2(256) NOT NULL,
SLOTSUSED_MIN VARCHAR2(256) NOT NULL,
SLOTSUSED_MAX VARCHAR2(256) NOT NULL,
SLOTSUSEDPERCENT_MIN VARCHAR2(256) NOT NULL,
SLOTSUSEDPERCENT_MAX VARCHAR2(256) NOT NULL,
MEMASSIGNEDPERCENTUTIL_MIN VARCHAR2(256) NOT NULL,
MEMASSIGNEDPERCENTUTIL_MAX VARCHAR2(256) NOT NULL,
CPUASSIGNEDPERCENTUTIL_MIN VARCHAR2(256) NOT NULL,
CPUASSIGNEDPERCENTUTIL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE StormClustTest_THRESH ADD constraint PK_StormClustTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_StormClustTest_THRESH ON StormClustTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_StormClustTest ON StormClustTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_StormClustTest ON StormClustTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE StormNimbusTest CASCADE CONSTRAINTS;
CREATE TABLE StormNimbusTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
STATUS Number(20,4) NOT NULL,
STATUS_ST varchar2(32) NOT NULL,
NIMBUSUPTIME Number(20,4) NOT NULL,
NIMBUSUPTIME_ST varchar2(32) NOT NULL,
REBOOTED Number(20,4) NOT NULL,
REBOOTED_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_StormNimbusTest ON StormNimbusTest(MSMT_TIME);
ALTER TABLE StormNimbusTest ADD constraint PK_StormNimbusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE StormNimbusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE StormNimbusTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
STATUS_MIN Number(20,4) NOT NULL,
STATUS_MAX Number(20,4) NOT NULL,
STATUS_STCNT varchar2(32) NOT NULL,
NIMBUSUPTIME_MIN Number(20,4) NOT NULL,
NIMBUSUPTIME_MAX Number(20,4) NOT NULL,
NIMBUSUPTIME_STCNT varchar2(32) NOT NULL,
REBOOTED_MIN Number(20,4) NOT NULL,
REBOOTED_MAX Number(20,4) NOT NULL,
REBOOTED_STCNT varchar2(32) NOT NULL);

ALTER TABLE StormNimbusTest_TREND ADD constraint PK_StormNimbusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE StormNimbusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE StormNimbusTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
STATUS_MIN VARCHAR2(256) NOT NULL,
STATUS_MAX VARCHAR2(256) NOT NULL,
NIMBUSUPTIME_MIN VARCHAR2(256) NOT NULL,
NIMBUSUPTIME_MAX VARCHAR2(256) NOT NULL,
REBOOTED_MIN VARCHAR2(256) NOT NULL,
REBOOTED_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE StormNimbusTest_THRESH ADD constraint PK_StormNimbusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_StormNimbusTest_THRESH ON StormNimbusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_StormNimbusTest ON StormNimbusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_StormNimbusTest ON StormNimbusTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE StormOwnResTest CASCADE CONSTRAINTS;
CREATE TABLE StormOwnResTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTALTOPOLOGIES Number(20,4) NOT NULL,
TOTALTOPOLOGIES_ST varchar2(32) NOT NULL,
TOTALEXECUTORS Number(20,4) NOT NULL,
TOTALEXECUTORS_ST varchar2(32) NOT NULL,
TOTALWORKERS Number(20,4) NOT NULL,
TOTALWORKERS_ST varchar2(32) NOT NULL,
TOTALTASKS Number(20,4) NOT NULL,
TOTALTASKS_ST varchar2(32) NOT NULL,
TOTALREQMEM Number(20,4) NOT NULL,
TOTALREQMEM_ST varchar2(32) NOT NULL,
TOTALMEMORYUSAGE Number(20,4) NOT NULL,
TOTALMEMORYUSAGE_ST varchar2(32) NOT NULL,
TOTALREQCPU Number(20,4) NOT NULL,
TOTALREQCPU_ST varchar2(32) NOT NULL,
TOTALCPUUSAGE Number(20,4) NOT NULL,
TOTALCPUUSAGE_ST varchar2(32) NOT NULL,
MEMORYGUARANTEE Number(20,4) NOT NULL,
MEMORYGUARANTEE_ST varchar2(32) NOT NULL,
MEMORYGUARANTEEREMAINING Number(20,4) NOT NULL,
MEMORYGUARANTEEREMAINING_ST varchar2(32) NOT NULL,
CPUGUARANTEE Number(20,4) NOT NULL,
CPUGUARANTEE_ST varchar2(32) NOT NULL,
CPUGUARANTEEREMAINING Number(20,4) NOT NULL,
CPUGUARANTEEREMAINING_ST varchar2(32) NOT NULL,
ISOLATEDNODES Number(20,4) NOT NULL,
ISOLATEDNODES_ST varchar2(32) NOT NULL,
TOTALREQONHEAPMEM Number(20,4) NOT NULL,
TOTALREQONHEAPMEM_ST varchar2(32) NOT NULL,
TOTALASSIGNEDONHEAPMEM Number(20,4) NOT NULL,
TOTALASSIGNEDONHEAPMEM_ST varchar2(32) NOT NULL,
TOTALREQOFFHEAPMEM Number(20,4) NOT NULL,
TOTALREQOFFHEAPMEM_ST varchar2(32) NOT NULL,
TOTALASSIGNEDOFFHEAPMEM Number(20,4) NOT NULL,
TOTALASSIGNEDOFFHEAPMEM_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_StormOwnResTest ON StormOwnResTest(MSMT_TIME);
ALTER TABLE StormOwnResTest ADD constraint PK_StormOwnResTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE StormOwnResTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE StormOwnResTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTALTOPOLOGIES_MIN Number(20,4) NOT NULL,
TOTALTOPOLOGIES_MAX Number(20,4) NOT NULL,
TOTALTOPOLOGIES_STCNT varchar2(32) NOT NULL,
TOTALEXECUTORS_MIN Number(20,4) NOT NULL,
TOTALEXECUTORS_MAX Number(20,4) NOT NULL,
TOTALEXECUTORS_STCNT varchar2(32) NOT NULL,
TOTALWORKERS_MIN Number(20,4) NOT NULL,
TOTALWORKERS_MAX Number(20,4) NOT NULL,
TOTALWORKERS_STCNT varchar2(32) NOT NULL,
TOTALTASKS_MIN Number(20,4) NOT NULL,
TOTALTASKS_MAX Number(20,4) NOT NULL,
TOTALTASKS_STCNT varchar2(32) NOT NULL,
TOTALREQMEM_MIN Number(20,4) NOT NULL,
TOTALREQMEM_MAX Number(20,4) NOT NULL,
TOTALREQMEM_STCNT varchar2(32) NOT NULL,
TOTALMEMORYUSAGE_MIN Number(20,4) NOT NULL,
TOTALMEMORYUSAGE_MAX Number(20,4) NOT NULL,
TOTALMEMORYUSAGE_STCNT varchar2(32) NOT NULL,
TOTALREQCPU_MIN Number(20,4) NOT NULL,
TOTALREQCPU_MAX Number(20,4) NOT NULL,
TOTALREQCPU_STCNT varchar2(32) NOT NULL,
TOTALCPUUSAGE_MIN Number(20,4) NOT NULL,
TOTALCPUUSAGE_MAX Number(20,4) NOT NULL,
TOTALCPUUSAGE_STCNT varchar2(32) NOT NULL,
MEMORYGUARANTEE_MIN Number(20,4) NOT NULL,
MEMORYGUARANTEE_MAX Number(20,4) NOT NULL,
MEMORYGUARANTEE_STCNT varchar2(32) NOT NULL,
MEMORYGUARANTEEREMAINING_MIN Number(20,4) NOT NULL,
MEMORYGUARANTEEREMAINING_MAX Number(20,4) NOT NULL,
MEMORYGUARANTEEREMAINING_STCNT varchar2(32) NOT NULL,
CPUGUARANTEE_MIN Number(20,4) NOT NULL,
CPUGUARANTEE_MAX Number(20,4) NOT NULL,
CPUGUARANTEE_STCNT varchar2(32) NOT NULL,
CPUGUARANTEEREMAINING_MIN Number(20,4) NOT NULL,
CPUGUARANTEEREMAINING_MAX Number(20,4) NOT NULL,
CPUGUARANTEEREMAINING_STCNT varchar2(32) NOT NULL,
ISOLATEDNODES_MIN Number(20,4) NOT NULL,
ISOLATEDNODES_MAX Number(20,4) NOT NULL,
ISOLATEDNODES_STCNT varchar2(32) NOT NULL,
TOTALREQONHEAPMEM_MIN Number(20,4) NOT NULL,
TOTALREQONHEAPMEM_MAX Number(20,4) NOT NULL,
TOTALREQONHEAPMEM_STCNT varchar2(32) NOT NULL,
TOTALASSIGNEDONHEAPMEM_MIN Number(20,4) NOT NULL,
TOTALASSIGNEDONHEAPMEM_MAX Number(20,4) NOT NULL,
TOTALASSIGNEDONHEAPMEM_STCNT varchar2(32) NOT NULL,
TOTALREQOFFHEAPMEM_MIN Number(20,4) NOT NULL,
TOTALREQOFFHEAPMEM_MAX Number(20,4) NOT NULL,
TOTALREQOFFHEAPMEM_STCNT varchar2(32) NOT NULL,
TOTALASSIGNEDOFFHEAPMEM_MIN Number(20,4) NOT NULL,
TOTALASSIGNEDOFFHEAPMEM_MAX Number(20,4) NOT NULL,
TOTALASSIGNEDOFFHEAPMEM_STCNT varchar2(32) NOT NULL);

ALTER TABLE StormOwnResTest_TREND ADD constraint PK_StormOwnResTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE StormOwnResTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE StormOwnResTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTALTOPOLOGIES_MIN VARCHAR2(256) NOT NULL,
TOTALTOPOLOGIES_MAX VARCHAR2(256) NOT NULL,
TOTALEXECUTORS_MIN VARCHAR2(256) NOT NULL,
TOTALEXECUTORS_MAX VARCHAR2(256) NOT NULL,
TOTALWORKERS_MIN VARCHAR2(256) NOT NULL,
TOTALWORKERS_MAX VARCHAR2(256) NOT NULL,
TOTALTASKS_MIN VARCHAR2(256) NOT NULL,
TOTALTASKS_MAX VARCHAR2(256) NOT NULL,
TOTALREQMEM_MIN VARCHAR2(256) NOT NULL,
TOTALREQMEM_MAX VARCHAR2(256) NOT NULL,
TOTALMEMORYUSAGE_MIN VARCHAR2(256) NOT NULL,
TOTALMEMORYUSAGE_MAX VARCHAR2(256) NOT NULL,
TOTALREQCPU_MIN VARCHAR2(256) NOT NULL,
TOTALREQCPU_MAX VARCHAR2(256) NOT NULL,
TOTALCPUUSAGE_MIN VARCHAR2(256) NOT NULL,
TOTALCPUUSAGE_MAX VARCHAR2(256) NOT NULL,
MEMORYGUARANTEE_MIN VARCHAR2(256) NOT NULL,
MEMORYGUARANTEE_MAX VARCHAR2(256) NOT NULL,
MEMORYGUARANTEEREMAINING_MIN VARCHAR2(256) NOT NULL,
MEMORYGUARANTEEREMAINING_MAX VARCHAR2(256) NOT NULL,
CPUGUARANTEE_MIN VARCHAR2(256) NOT NULL,
CPUGUARANTEE_MAX VARCHAR2(256) NOT NULL,
CPUGUARANTEEREMAINING_MIN VARCHAR2(256) NOT NULL,
CPUGUARANTEEREMAINING_MAX VARCHAR2(256) NOT NULL,
ISOLATEDNODES_MIN VARCHAR2(256) NOT NULL,
ISOLATEDNODES_MAX VARCHAR2(256) NOT NULL,
TOTALREQONHEAPMEM_MIN VARCHAR2(256) NOT NULL,
TOTALREQONHEAPMEM_MAX VARCHAR2(256) NOT NULL,
TOTALASSIGNEDONHEAPMEM_MIN VARCHAR2(256) NOT NULL,
TOTALASSIGNEDONHEAPMEM_MAX VARCHAR2(256) NOT NULL,
TOTALREQOFFHEAPMEM_MIN VARCHAR2(256) NOT NULL,
TOTALREQOFFHEAPMEM_MAX VARCHAR2(256) NOT NULL,
TOTALASSIGNEDOFFHEAPMEM_MIN VARCHAR2(256) NOT NULL,
TOTALASSIGNEDOFFHEAPMEM_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE StormOwnResTest_THRESH ADD constraint PK_StormOwnResTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_StormOwnResTest_THRESH ON StormOwnResTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_StormOwnResTest ON StormOwnResTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_StormOwnResTest ON StormOwnResTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE StormSupSumTest CASCADE CONSTRAINTS;
CREATE TABLE StormSupSumTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SLOTSTOTAL Number(20,4) NOT NULL,
SLOTSTOTAL_ST varchar2(32) NOT NULL,
SLOTSUSED Number(20,4) NOT NULL,
SLOTSUSED_ST varchar2(32) NOT NULL,
SLOTSFREE Number(20,4) NOT NULL,
SLOTSFREE_ST varchar2(32) NOT NULL,
TOTALCPU Number(20,4) NOT NULL,
TOTALCPU_ST varchar2(32) NOT NULL,
USEDCPU Number(20,4) NOT NULL,
USEDCPU_ST varchar2(32) NOT NULL,
AVAILCPU Number(20,4) NOT NULL,
AVAILCPU_ST varchar2(32) NOT NULL,
AVAILCPUPERCENT Number(20,4) NOT NULL,
AVAILCPUPERCENT_ST varchar2(32) NOT NULL,
TOTALMEM Number(20,4) NOT NULL,
TOTALMEM_ST varchar2(32) NOT NULL,
USEDMEM Number(20,4) NOT NULL,
USEDMEM_ST varchar2(32) NOT NULL,
AVAILMEM Number(20,4) NOT NULL,
AVAILMEM_ST varchar2(32) NOT NULL,
AVAILMEMPERCENT Number(20,4) NOT NULL,
AVAILMEMPERCENT_ST varchar2(32) NOT NULL,
UPTIME Number(20,4) NOT NULL,
UPTIME_ST varchar2(32) NOT NULL,
REBOOTED Number(20,4) NOT NULL,
REBOOTED_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_StormSupSumTest ON StormSupSumTest(MSMT_TIME);
ALTER TABLE StormSupSumTest ADD constraint PK_StormSupSumTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE StormSupSumTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE StormSupSumTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SLOTSTOTAL_MIN Number(20,4) NOT NULL,
SLOTSTOTAL_MAX Number(20,4) NOT NULL,
SLOTSTOTAL_STCNT varchar2(32) NOT NULL,
SLOTSUSED_MIN Number(20,4) NOT NULL,
SLOTSUSED_MAX Number(20,4) NOT NULL,
SLOTSUSED_STCNT varchar2(32) NOT NULL,
SLOTSFREE_MIN Number(20,4) NOT NULL,
SLOTSFREE_MAX Number(20,4) NOT NULL,
SLOTSFREE_STCNT varchar2(32) NOT NULL,
TOTALCPU_MIN Number(20,4) NOT NULL,
TOTALCPU_MAX Number(20,4) NOT NULL,
TOTALCPU_STCNT varchar2(32) NOT NULL,
USEDCPU_MIN Number(20,4) NOT NULL,
USEDCPU_MAX Number(20,4) NOT NULL,
USEDCPU_STCNT varchar2(32) NOT NULL,
AVAILCPU_MIN Number(20,4) NOT NULL,
AVAILCPU_MAX Number(20,4) NOT NULL,
AVAILCPU_STCNT varchar2(32) NOT NULL,
AVAILCPUPERCENT_MIN Number(20,4) NOT NULL,
AVAILCPUPERCENT_MAX Number(20,4) NOT NULL,
AVAILCPUPERCENT_STCNT varchar2(32) NOT NULL,
TOTALMEM_MIN Number(20,4) NOT NULL,
TOTALMEM_MAX Number(20,4) NOT NULL,
TOTALMEM_STCNT varchar2(32) NOT NULL,
USEDMEM_MIN Number(20,4) NOT NULL,
USEDMEM_MAX Number(20,4) NOT NULL,
USEDMEM_STCNT varchar2(32) NOT NULL,
AVAILMEM_MIN Number(20,4) NOT NULL,
AVAILMEM_MAX Number(20,4) NOT NULL,
AVAILMEM_STCNT varchar2(32) NOT NULL,
AVAILMEMPERCENT_MIN Number(20,4) NOT NULL,
AVAILMEMPERCENT_MAX Number(20,4) NOT NULL,
AVAILMEMPERCENT_STCNT varchar2(32) NOT NULL,
UPTIME_MIN Number(20,4) NOT NULL,
UPTIME_MAX Number(20,4) NOT NULL,
UPTIME_STCNT varchar2(32) NOT NULL,
REBOOTED_MIN Number(20,4) NOT NULL,
REBOOTED_MAX Number(20,4) NOT NULL,
REBOOTED_STCNT varchar2(32) NOT NULL);

ALTER TABLE StormSupSumTest_TREND ADD constraint PK_StormSupSumTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE StormSupSumTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE StormSupSumTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SLOTSTOTAL_MIN VARCHAR2(256) NOT NULL,
SLOTSTOTAL_MAX VARCHAR2(256) NOT NULL,
SLOTSUSED_MIN VARCHAR2(256) NOT NULL,
SLOTSUSED_MAX VARCHAR2(256) NOT NULL,
SLOTSFREE_MIN VARCHAR2(256) NOT NULL,
SLOTSFREE_MAX VARCHAR2(256) NOT NULL,
TOTALCPU_MIN VARCHAR2(256) NOT NULL,
TOTALCPU_MAX VARCHAR2(256) NOT NULL,
USEDCPU_MIN VARCHAR2(256) NOT NULL,
USEDCPU_MAX VARCHAR2(256) NOT NULL,
AVAILCPU_MIN VARCHAR2(256) NOT NULL,
AVAILCPU_MAX VARCHAR2(256) NOT NULL,
AVAILCPUPERCENT_MIN VARCHAR2(256) NOT NULL,
AVAILCPUPERCENT_MAX VARCHAR2(256) NOT NULL,
TOTALMEM_MIN VARCHAR2(256) NOT NULL,
TOTALMEM_MAX VARCHAR2(256) NOT NULL,
USEDMEM_MIN VARCHAR2(256) NOT NULL,
USEDMEM_MAX VARCHAR2(256) NOT NULL,
AVAILMEM_MIN VARCHAR2(256) NOT NULL,
AVAILMEM_MAX VARCHAR2(256) NOT NULL,
AVAILMEMPERCENT_MIN VARCHAR2(256) NOT NULL,
AVAILMEMPERCENT_MAX VARCHAR2(256) NOT NULL,
UPTIME_MIN VARCHAR2(256) NOT NULL,
UPTIME_MAX VARCHAR2(256) NOT NULL,
REBOOTED_MIN VARCHAR2(256) NOT NULL,
REBOOTED_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE StormSupSumTest_THRESH ADD constraint PK_StormSupSumTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_StormSupSumTest_THRESH ON StormSupSumTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_StormSupSumTest ON StormSupSumTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_StormSupSumTest ON StormSupSumTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE StormTopSumTest CASCADE CONSTRAINTS;
CREATE TABLE StormTopSumTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
STATUS Number(20,4) NOT NULL,
STATUS_ST varchar2(32) NOT NULL,
WORKERSTOTAL Number(20,4) NOT NULL,
WORKERSTOTAL_ST varchar2(32) NOT NULL,
EXECUTORSTOTAL Number(20,4) NOT NULL,
EXECUTORSTOTAL_ST varchar2(32) NOT NULL,
TASKSTOTAL Number(20,4) NOT NULL,
TASKSTOTAL_ST varchar2(32) NOT NULL,
REPLICATIONCOUNT Number(20,4) NOT NULL,
REPLICATIONCOUNT_ST varchar2(32) NOT NULL,
REQUESTEDTOTALMEM Number(20,4) NOT NULL,
REQUESTEDTOTALMEM_ST varchar2(32) NOT NULL,
ASSIGNEDTOTALMEM Number(20,4) NOT NULL,
ASSIGNEDTOTALMEM_ST varchar2(32) NOT NULL,
REQUESTEDMEMONHEAP Number(20,4) NOT NULL,
REQUESTEDMEMONHEAP_ST varchar2(32) NOT NULL,
ASSIGNEDMEMONHEAP Number(20,4) NOT NULL,
ASSIGNEDMEMONHEAP_ST varchar2(32) NOT NULL,
REQUESTEDMEMOFFHEAP Number(20,4) NOT NULL,
REQUESTEDMEMOFFHEAP_ST varchar2(32) NOT NULL,
ASSIGNEDMEMOFFHEAP Number(20,4) NOT NULL,
ASSIGNEDMEMOFFHEAP_ST varchar2(32) NOT NULL,
REQUESTEDCPU Number(20,4) NOT NULL,
REQUESTEDCPU_ST varchar2(32) NOT NULL,
ASSIGNEDCPU Number(20,4) NOT NULL,
ASSIGNEDCPU_ST varchar2(32) NOT NULL,
UPTIME Number(20,4) NOT NULL,
UPTIME_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_StormTopSumTest ON StormTopSumTest(MSMT_TIME);
ALTER TABLE StormTopSumTest ADD constraint PK_StormTopSumTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE StormTopSumTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE StormTopSumTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
STATUS_MIN Number(20,4) NOT NULL,
STATUS_MAX Number(20,4) NOT NULL,
STATUS_STCNT varchar2(32) NOT NULL,
WORKERSTOTAL_MIN Number(20,4) NOT NULL,
WORKERSTOTAL_MAX Number(20,4) NOT NULL,
WORKERSTOTAL_STCNT varchar2(32) NOT NULL,
EXECUTORSTOTAL_MIN Number(20,4) NOT NULL,
EXECUTORSTOTAL_MAX Number(20,4) NOT NULL,
EXECUTORSTOTAL_STCNT varchar2(32) NOT NULL,
TASKSTOTAL_MIN Number(20,4) NOT NULL,
TASKSTOTAL_MAX Number(20,4) NOT NULL,
TASKSTOTAL_STCNT varchar2(32) NOT NULL,
REPLICATIONCOUNT_MIN Number(20,4) NOT NULL,
REPLICATIONCOUNT_MAX Number(20,4) NOT NULL,
REPLICATIONCOUNT_STCNT varchar2(32) NOT NULL,
REQUESTEDTOTALMEM_MIN Number(20,4) NOT NULL,
REQUESTEDTOTALMEM_MAX Number(20,4) NOT NULL,
REQUESTEDTOTALMEM_STCNT varchar2(32) NOT NULL,
ASSIGNEDTOTALMEM_MIN Number(20,4) NOT NULL,
ASSIGNEDTOTALMEM_MAX Number(20,4) NOT NULL,
ASSIGNEDTOTALMEM_STCNT varchar2(32) NOT NULL,
REQUESTEDMEMONHEAP_MIN Number(20,4) NOT NULL,
REQUESTEDMEMONHEAP_MAX Number(20,4) NOT NULL,
REQUESTEDMEMONHEAP_STCNT varchar2(32) NOT NULL,
ASSIGNEDMEMONHEAP_MIN Number(20,4) NOT NULL,
ASSIGNEDMEMONHEAP_MAX Number(20,4) NOT NULL,
ASSIGNEDMEMONHEAP_STCNT varchar2(32) NOT NULL,
REQUESTEDMEMOFFHEAP_MIN Number(20,4) NOT NULL,
REQUESTEDMEMOFFHEAP_MAX Number(20,4) NOT NULL,
REQUESTEDMEMOFFHEAP_STCNT varchar2(32) NOT NULL,
ASSIGNEDMEMOFFHEAP_MIN Number(20,4) NOT NULL,
ASSIGNEDMEMOFFHEAP_MAX Number(20,4) NOT NULL,
ASSIGNEDMEMOFFHEAP_STCNT varchar2(32) NOT NULL,
REQUESTEDCPU_MIN Number(20,4) NOT NULL,
REQUESTEDCPU_MAX Number(20,4) NOT NULL,
REQUESTEDCPU_STCNT varchar2(32) NOT NULL,
ASSIGNEDCPU_MIN Number(20,4) NOT NULL,
ASSIGNEDCPU_MAX Number(20,4) NOT NULL,
ASSIGNEDCPU_STCNT varchar2(32) NOT NULL,
UPTIME_MIN Number(20,4) NOT NULL,
UPTIME_MAX Number(20,4) NOT NULL,
UPTIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE StormTopSumTest_TREND ADD constraint PK_StormTopSumTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE StormTopSumTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE StormTopSumTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
STATUS_MIN VARCHAR2(256) NOT NULL,
STATUS_MAX VARCHAR2(256) NOT NULL,
WORKERSTOTAL_MIN VARCHAR2(256) NOT NULL,
WORKERSTOTAL_MAX VARCHAR2(256) NOT NULL,
EXECUTORSTOTAL_MIN VARCHAR2(256) NOT NULL,
EXECUTORSTOTAL_MAX VARCHAR2(256) NOT NULL,
TASKSTOTAL_MIN VARCHAR2(256) NOT NULL,
TASKSTOTAL_MAX VARCHAR2(256) NOT NULL,
REPLICATIONCOUNT_MIN VARCHAR2(256) NOT NULL,
REPLICATIONCOUNT_MAX VARCHAR2(256) NOT NULL,
REQUESTEDTOTALMEM_MIN VARCHAR2(256) NOT NULL,
REQUESTEDTOTALMEM_MAX VARCHAR2(256) NOT NULL,
ASSIGNEDTOTALMEM_MIN VARCHAR2(256) NOT NULL,
ASSIGNEDTOTALMEM_MAX VARCHAR2(256) NOT NULL,
REQUESTEDMEMONHEAP_MIN VARCHAR2(256) NOT NULL,
REQUESTEDMEMONHEAP_MAX VARCHAR2(256) NOT NULL,
ASSIGNEDMEMONHEAP_MIN VARCHAR2(256) NOT NULL,
ASSIGNEDMEMONHEAP_MAX VARCHAR2(256) NOT NULL,
REQUESTEDMEMOFFHEAP_MIN VARCHAR2(256) NOT NULL,
REQUESTEDMEMOFFHEAP_MAX VARCHAR2(256) NOT NULL,
ASSIGNEDMEMOFFHEAP_MIN VARCHAR2(256) NOT NULL,
ASSIGNEDMEMOFFHEAP_MAX VARCHAR2(256) NOT NULL,
REQUESTEDCPU_MIN VARCHAR2(256) NOT NULL,
REQUESTEDCPU_MAX VARCHAR2(256) NOT NULL,
ASSIGNEDCPU_MIN VARCHAR2(256) NOT NULL,
ASSIGNEDCPU_MAX VARCHAR2(256) NOT NULL,
UPTIME_MIN VARCHAR2(256) NOT NULL,
UPTIME_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE StormTopSumTest_THRESH ADD constraint PK_StormTopSumTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_StormTopSumTest_THRESH ON StormTopSumTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_StormTopSumTest ON StormTopSumTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_StormTopSumTest ON StormTopSumTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE StormWorkerTest CASCADE CONSTRAINTS;
CREATE TABLE StormWorkerTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
EXECUTORSTOTAL Number(20,4) NOT NULL,
EXECUTORSTOTAL_ST varchar2(32) NOT NULL,
ASSIGNEDMEMONHEAP Number(20,4) NOT NULL,
ASSIGNEDMEMONHEAP_ST varchar2(32) NOT NULL,
ASSIGNEDMEMOFFHEAP Number(20,4) NOT NULL,
ASSIGNEDMEMOFFHEAP_ST varchar2(32) NOT NULL,
ASSIGNEDCPU Number(20,4) NOT NULL,
ASSIGNEDCPU_ST varchar2(32) NOT NULL,
UPTIME Number(20,4) NOT NULL,
UPTIME_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_StormWorkerTest ON StormWorkerTest(MSMT_TIME);
ALTER TABLE StormWorkerTest ADD constraint PK_StormWorkerTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE StormWorkerTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE StormWorkerTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
EXECUTORSTOTAL_MIN Number(20,4) NOT NULL,
EXECUTORSTOTAL_MAX Number(20,4) NOT NULL,
EXECUTORSTOTAL_STCNT varchar2(32) NOT NULL,
ASSIGNEDMEMONHEAP_MIN Number(20,4) NOT NULL,
ASSIGNEDMEMONHEAP_MAX Number(20,4) NOT NULL,
ASSIGNEDMEMONHEAP_STCNT varchar2(32) NOT NULL,
ASSIGNEDMEMOFFHEAP_MIN Number(20,4) NOT NULL,
ASSIGNEDMEMOFFHEAP_MAX Number(20,4) NOT NULL,
ASSIGNEDMEMOFFHEAP_STCNT varchar2(32) NOT NULL,
ASSIGNEDCPU_MIN Number(20,4) NOT NULL,
ASSIGNEDCPU_MAX Number(20,4) NOT NULL,
ASSIGNEDCPU_STCNT varchar2(32) NOT NULL,
UPTIME_MIN Number(20,4) NOT NULL,
UPTIME_MAX Number(20,4) NOT NULL,
UPTIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE StormWorkerTest_TREND ADD constraint PK_StormWorkerTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE StormWorkerTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE StormWorkerTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
EXECUTORSTOTAL_MIN VARCHAR2(256) NOT NULL,
EXECUTORSTOTAL_MAX VARCHAR2(256) NOT NULL,
ASSIGNEDMEMONHEAP_MIN VARCHAR2(256) NOT NULL,
ASSIGNEDMEMONHEAP_MAX VARCHAR2(256) NOT NULL,
ASSIGNEDMEMOFFHEAP_MIN VARCHAR2(256) NOT NULL,
ASSIGNEDMEMOFFHEAP_MAX VARCHAR2(256) NOT NULL,
ASSIGNEDCPU_MIN VARCHAR2(256) NOT NULL,
ASSIGNEDCPU_MAX VARCHAR2(256) NOT NULL,
UPTIME_MIN VARCHAR2(256) NOT NULL,
UPTIME_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE StormWorkerTest_THRESH ADD constraint PK_StormWorkerTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_StormWorkerTest_THRESH ON StormWorkerTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_StormWorkerTest ON StormWorkerTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_StormWorkerTest ON StormWorkerTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE PPCBatInStatTest CASCADE CONSTRAINTS;
CREATE TABLE PPCBatInStatTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
VOLTRECVD Number(20,4) NOT NULL,
VOLTRECVD_ST varchar2(32) NOT NULL,
VOLTFREQ Number(20,4) NOT NULL,
VOLTFREQ_ST varchar2(32) NOT NULL,
VOLTFAIL Number(20,4) NOT NULL,
VOLTFAIL_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_PPCBatInStatTest ON PPCBatInStatTest(MSMT_TIME);
ALTER TABLE PPCBatInStatTest ADD constraint PK_PPCBatInStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE PPCBatInStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE PPCBatInStatTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
VOLTRECVD_MIN Number(20,4) NOT NULL,
VOLTRECVD_MAX Number(20,4) NOT NULL,
VOLTRECVD_STCNT varchar2(32) NOT NULL,
VOLTFREQ_MIN Number(20,4) NOT NULL,
VOLTFREQ_MAX Number(20,4) NOT NULL,
VOLTFREQ_STCNT varchar2(32) NOT NULL,
VOLTFAIL_MIN Number(20,4) NOT NULL,
VOLTFAIL_MAX Number(20,4) NOT NULL,
VOLTFAIL_STCNT varchar2(32) NOT NULL);

ALTER TABLE PPCBatInStatTest_TREND ADD constraint PK_PPCBatInStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE PPCBatInStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE PPCBatInStatTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
VOLTRECVD_MIN VARCHAR2(256) NOT NULL,
VOLTRECVD_MAX VARCHAR2(256) NOT NULL,
VOLTFREQ_MIN VARCHAR2(256) NOT NULL,
VOLTFREQ_MAX VARCHAR2(256) NOT NULL,
VOLTFAIL_MIN VARCHAR2(256) NOT NULL,
VOLTFAIL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE PPCBatInStatTest_THRESH ADD constraint PK_PPCBatInStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_PPCBatInStatTest_THRESH ON PPCBatInStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_PPCBatInStatTest ON PPCBatInStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_PPCBatInStatTest ON PPCBatInStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE PPCBatOutStTest CASCADE CONSTRAINTS;
CREATE TABLE PPCBatOutStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
VOLTSTATUS Number(20,4) NOT NULL,
VOLTSTATUS_ST varchar2(32) NOT NULL,
VOLTTRANS Number(20,4) NOT NULL,
VOLTTRANS_ST varchar2(32) NOT NULL,
VOLTFREQ Number(20,4) NOT NULL,
VOLTFREQ_ST varchar2(32) NOT NULL,
UPSLOAD Number(20,4) NOT NULL,
UPSLOAD_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_PPCBatOutStTest ON PPCBatOutStTest(MSMT_TIME);
ALTER TABLE PPCBatOutStTest ADD constraint PK_PPCBatOutStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE PPCBatOutStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE PPCBatOutStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
VOLTSTATUS_MIN Number(20,4) NOT NULL,
VOLTSTATUS_MAX Number(20,4) NOT NULL,
VOLTSTATUS_STCNT varchar2(32) NOT NULL,
VOLTTRANS_MIN Number(20,4) NOT NULL,
VOLTTRANS_MAX Number(20,4) NOT NULL,
VOLTTRANS_STCNT varchar2(32) NOT NULL,
VOLTFREQ_MIN Number(20,4) NOT NULL,
VOLTFREQ_MAX Number(20,4) NOT NULL,
VOLTFREQ_STCNT varchar2(32) NOT NULL,
UPSLOAD_MIN Number(20,4) NOT NULL,
UPSLOAD_MAX Number(20,4) NOT NULL,
UPSLOAD_STCNT varchar2(32) NOT NULL);

ALTER TABLE PPCBatOutStTest_TREND ADD constraint PK_PPCBatOutStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE PPCBatOutStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE PPCBatOutStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
VOLTSTATUS_MIN VARCHAR2(256) NOT NULL,
VOLTSTATUS_MAX VARCHAR2(256) NOT NULL,
VOLTTRANS_MIN VARCHAR2(256) NOT NULL,
VOLTTRANS_MAX VARCHAR2(256) NOT NULL,
VOLTFREQ_MIN VARCHAR2(256) NOT NULL,
VOLTFREQ_MAX VARCHAR2(256) NOT NULL,
UPSLOAD_MIN VARCHAR2(256) NOT NULL,
UPSLOAD_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE PPCBatOutStTest_THRESH ADD constraint PK_PPCBatOutStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_PPCBatOutStTest_THRESH ON PPCBatOutStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_PPCBatOutStTest ON PPCBatOutStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_PPCBatOutStTest ON PPCBatOutStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE PPCBattInfoTest CASCADE CONSTRAINTS;
CREATE TABLE PPCBattInfoTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
BATTSTATUS Number(20,4) NOT NULL,
BATTSTATUS_ST varchar2(32) NOT NULL,
BATTPOWER Number(20,4) NOT NULL,
BATTPOWER_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_PPCBattInfoTest ON PPCBattInfoTest(MSMT_TIME);
ALTER TABLE PPCBattInfoTest ADD constraint PK_PPCBattInfoTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE PPCBattInfoTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE PPCBattInfoTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
BATTSTATUS_MIN Number(20,4) NOT NULL,
BATTSTATUS_MAX Number(20,4) NOT NULL,
BATTSTATUS_STCNT varchar2(32) NOT NULL,
BATTPOWER_MIN Number(20,4) NOT NULL,
BATTPOWER_MAX Number(20,4) NOT NULL,
BATTPOWER_STCNT varchar2(32) NOT NULL);

ALTER TABLE PPCBattInfoTest_TREND ADD constraint PK_PPCBattInfoTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE PPCBattInfoTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE PPCBattInfoTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
BATTSTATUS_MIN VARCHAR2(256) NOT NULL,
BATTSTATUS_MAX VARCHAR2(256) NOT NULL,
BATTPOWER_MIN VARCHAR2(256) NOT NULL,
BATTPOWER_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE PPCBattInfoTest_THRESH ADD constraint PK_PPCBattInfoTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_PPCBattInfoTest_THRESH ON PPCBattInfoTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_PPCBattInfoTest ON PPCBattInfoTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_PPCBattInfoTest ON PPCBattInfoTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE PPCBattStatsTest CASCADE CONSTRAINTS;
CREATE TABLE PPCBattStatsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
BATTCPTY Number(20,4) NOT NULL,
BATTCPTY_ST varchar2(32) NOT NULL,
BATTVOLT Number(20,4) NOT NULL,
BATTVOLT_ST varchar2(32) NOT NULL,
BATTTEMP Number(20,4) NOT NULL,
BATTTEMP_ST varchar2(32) NOT NULL,
BATTRUNTIME Number(20,4) NOT NULL,
BATTRUNTIME_ST varchar2(32) NOT NULL,
BATTREPLACE Number(20,4) NOT NULL,
BATTREPLACE_ST varchar2(32) NOT NULL,
BATTCHRG Number(20,4) NOT NULL,
BATTCHRG_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_PPCBattStatsTest ON PPCBattStatsTest(MSMT_TIME);
ALTER TABLE PPCBattStatsTest ADD constraint PK_PPCBattStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE PPCBattStatsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE PPCBattStatsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
BATTCPTY_MIN Number(20,4) NOT NULL,
BATTCPTY_MAX Number(20,4) NOT NULL,
BATTCPTY_STCNT varchar2(32) NOT NULL,
BATTVOLT_MIN Number(20,4) NOT NULL,
BATTVOLT_MAX Number(20,4) NOT NULL,
BATTVOLT_STCNT varchar2(32) NOT NULL,
BATTTEMP_MIN Number(20,4) NOT NULL,
BATTTEMP_MAX Number(20,4) NOT NULL,
BATTTEMP_STCNT varchar2(32) NOT NULL,
BATTRUNTIME_MIN Number(20,4) NOT NULL,
BATTRUNTIME_MAX Number(20,4) NOT NULL,
BATTRUNTIME_STCNT varchar2(32) NOT NULL,
BATTREPLACE_MIN Number(20,4) NOT NULL,
BATTREPLACE_MAX Number(20,4) NOT NULL,
BATTREPLACE_STCNT varchar2(32) NOT NULL,
BATTCHRG_MIN Number(20,4) NOT NULL,
BATTCHRG_MAX Number(20,4) NOT NULL,
BATTCHRG_STCNT varchar2(32) NOT NULL);

ALTER TABLE PPCBattStatsTest_TREND ADD constraint PK_PPCBattStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE PPCBattStatsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE PPCBattStatsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
BATTCPTY_MIN VARCHAR2(256) NOT NULL,
BATTCPTY_MAX VARCHAR2(256) NOT NULL,
BATTVOLT_MIN VARCHAR2(256) NOT NULL,
BATTVOLT_MAX VARCHAR2(256) NOT NULL,
BATTTEMP_MIN VARCHAR2(256) NOT NULL,
BATTTEMP_MAX VARCHAR2(256) NOT NULL,
BATTRUNTIME_MIN VARCHAR2(256) NOT NULL,
BATTRUNTIME_MAX VARCHAR2(256) NOT NULL,
BATTREPLACE_MIN VARCHAR2(256) NOT NULL,
BATTREPLACE_MAX VARCHAR2(256) NOT NULL,
BATTCHRG_MIN VARCHAR2(256) NOT NULL,
BATTCHRG_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE PPCBattStatsTest_THRESH ADD constraint PK_PPCBattStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_PPCBattStatsTest_THRESH ON PPCBattStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_PPCBattStatsTest ON PPCBattStatsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_PPCBattStatsTest ON PPCBattStatsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXVPIStatTest CASCADE CONSTRAINTS;
CREATE TABLE MLXVPIStatTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PHYSTATE		Number(20,4) NOT NULL,
PHYSTATE_ST		varchar2(32) NOT NULL,
LOGSTATE		Number(20,4) NOT NULL,
LOGSTATE_ST		varchar2(32) NOT NULL,
PORTTRANS		Number(20,4) NOT NULL,
PORTTRANS_ST		varchar2(32) NOT NULL,
ERRCNT			Number(20,4) NOT NULL,
ERRCNT_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXVPIStatTest ON MLXVPIStatTest(MSMT_TIME);
ALTER TABLE MLXVPIStatTest ADD constraint PK_MLXVPIStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXVPIStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXVPIStatTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
PHYSTATE_MIN		Number(20,4) NOT NULL,
PHYSTATE_MAX		Number(20,4) NOT NULL,
PHYSTATE_STCNT		varchar2(32) NOT NULL,
LOGSTATE_MIN		Number(20,4) NOT NULL,
LOGSTATE_MAX		Number(20,4) NOT NULL,
LOGSTATE_STCNT		varchar2(32) NOT NULL,
PORTTRANS_MIN		Number(20,4) NOT NULL,
PORTTRANS_MAX		Number(20,4) NOT NULL,
PORTTRANS_STCNT		varchar2(32) NOT NULL,
ERRCNT_MIN		Number(20,4) NOT NULL,
ERRCNT_MAX		Number(20,4) NOT NULL,
ERRCNT_STCNT		varchar2(32) NOT NULL);

ALTER TABLE MLXVPIStatTest_TREND ADD constraint PK_MLXVPIStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXVPIStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXVPIStatTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
PHYSTATE_MIN		VARCHAR2(256) NOT NULL,
PHYSTATE_MAX		VARCHAR2(256) NOT NULL,
LOGSTATE_MIN		VARCHAR2(256) NOT NULL,
LOGSTATE_MAX		VARCHAR2(256) NOT NULL,
PORTTRANS_MIN		VARCHAR2(256) NOT NULL,
PORTTRANS_MAX		VARCHAR2(256) NOT NULL,
ERRCNT_MIN		VARCHAR2(256) NOT NULL,
ERRCNT_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE MLXVPIStatTest_THRESH ADD constraint PK_MLXVPIStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXVPIStatTest_THRESH ON MLXVPIStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXVPIStatTest ON MLXVPIStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXVPIStatTest ON MLXVPIStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXCPUStatTest CASCADE CONSTRAINTS;
CREATE TABLE MLXCPUStatTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
IDLETIME		Number(20,4) NOT NULL,
IDLETIME_ST		varchar2(32) NOT NULL,
SYSTIME			Number(20,4) NOT NULL,
SYSTIME_ST		varchar2(32) NOT NULL,
USERTIME		Number(20,4) NOT NULL,
USERTIME_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXCPUStatTest ON MLXCPUStatTest(MSMT_TIME);
ALTER TABLE MLXCPUStatTest ADD constraint PK_MLXCPUStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXCPUStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXCPUStatTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
IDLETIME_MIN		Number(20,4) NOT NULL,
IDLETIME_MAX		Number(20,4) NOT NULL,
IDLETIME_STCNT		varchar2(32) NOT NULL,
SYSTIME_MIN		Number(20,4) NOT NULL,
SYSTIME_MAX		Number(20,4) NOT NULL,
SYSTIME_STCNT		varchar2(32) NOT NULL,
USERTIME_MIN		Number(20,4) NOT NULL,
USERTIME_MAX		Number(20,4) NOT NULL,
USERTIME_STCNT		varchar2(32) NOT NULL);

ALTER TABLE MLXCPUStatTest_TREND ADD constraint PK_MLXCPUStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXCPUStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXCPUStatTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
IDLETIME_MIN		VARCHAR2(256) NOT NULL,
IDLETIME_MAX		VARCHAR2(256) NOT NULL,
SYSTIME_MIN		VARCHAR2(256) NOT NULL,
SYSTIME_MAX		VARCHAR2(256) NOT NULL,
USERTIME_MIN		VARCHAR2(256) NOT NULL,
USERTIME_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE MLXCPUStatTest_THRESH ADD constraint PK_MLXCPUStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXCPUStatTest_THRESH ON MLXCPUStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXCPUStatTest ON MLXCPUStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXCPUStatTest ON MLXCPUStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXFanStatTest CASCADE CONSTRAINTS;
CREATE TABLE MLXFanStatTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
FSPEED			Number(20,4) NOT NULL,
FSPEED_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXFanStatTest ON MLXFanStatTest(MSMT_TIME);
ALTER TABLE MLXFanStatTest ADD constraint PK_MLXFanStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXFanStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXFanStatTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
FSPEED_MIN		Number(20,4) NOT NULL,
FSPEED_MAX		Number(20,4) NOT NULL,
FSPEED_STCNT		varchar2(32) NOT NULL);

ALTER TABLE MLXFanStatTest_TREND ADD constraint PK_MLXFanStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXFanStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXFanStatTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
FSPEED_MIN		VARCHAR2(256) NOT NULL,
FSPEED_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE MLXFanStatTest_THRESH ADD constraint PK_MLXFanStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXFanStatTest_THRESH ON MLXFanStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXFanStatTest ON MLXFanStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXFanStatTest ON MLXFanStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXPFCStatTest CASCADE CONSTRAINTS;
CREATE TABLE MLXPFCStatTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
RECVPAUPKTS		Number(20,4) NOT NULL,
RECVPAUPKTS_ST		varchar2(32) NOT NULL,
RECVPAUDURTN		Number(20,4) NOT NULL,
RECVPAUDURTN_ST		varchar2(32) NOT NULL,
TRANSPAUPKTS		Number(20,4) NOT NULL,
TRANSPAUPKTS_ST		varchar2(32) NOT NULL,
TRANSPAUDURTN		Number(20,4) NOT NULL,
TRANSPAUDURTN_ST	varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXPFCStatTest ON MLXPFCStatTest(MSMT_TIME);
ALTER TABLE MLXPFCStatTest ADD constraint PK_MLXPFCStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXPFCStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXPFCStatTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
RECVPAUPKTS_MIN		Number(20,4) NOT NULL,
RECVPAUPKTS_MAX		Number(20,4) NOT NULL,
RECVPAUPKTS_STCNT	varchar2(32) NOT NULL,
RECVPAUDURTN_MIN	Number(20,4) NOT NULL,
RECVPAUDURTN_MAX	Number(20,4) NOT NULL,
RECVPAUDURTN_STCNT	varchar2(32) NOT NULL,
TRANSPAUPKTS_MIN	Number(20,4) NOT NULL,
TRANSPAUPKTS_MAX	Number(20,4) NOT NULL,
TRANSPAUPKTS_STCNT	varchar2(32) NOT NULL,
TRANSPAUDURTN_MIN	Number(20,4) NOT NULL,
TRANSPAUDURTN_MAX	Number(20,4) NOT NULL,
TRANSPAUDURTN_STCNT	varchar2(32) NOT NULL);

ALTER TABLE MLXPFCStatTest_TREND ADD constraint PK_MLXPFCStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXPFCStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXPFCStatTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
RECVPAUPKTS_MIN		VARCHAR2(256) NOT NULL,
RECVPAUPKTS_MAX		VARCHAR2(256) NOT NULL,
RECVPAUDURTN_MIN	VARCHAR2(256) NOT NULL,
RECVPAUDURTN_MAX	VARCHAR2(256) NOT NULL,
TRANSPAUPKTS_MIN	VARCHAR2(256) NOT NULL,
TRANSPAUPKTS_MAX	VARCHAR2(256) NOT NULL,
TRANSPAUDURTN_MIN	VARCHAR2(256) NOT NULL,
TRANSPAUDURTN_MAX	VARCHAR2(256) NOT NULL);

ALTER TABLE MLXPFCStatTest_THRESH ADD constraint PK_MLXPFCStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXPFCStatTest_THRESH ON MLXPFCStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXPFCStatTest ON MLXPFCStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXPFCStatTest ON MLXPFCStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXPGStatTest CASCADE CONSTRAINTS;
CREATE TABLE MLXPGStatTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
RECVPKTS		Number(20,4) NOT NULL,
RECVPKTS_ST		varchar2(32) NOT NULL,
RECVBYTE		Number(20,4) NOT NULL,
RECVBYTE_ST		varchar2(32) NOT NULL,
QDEPTH			Number(20,4) NOT NULL,
QDEPTH_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXPGStatTest ON MLXPGStatTest(MSMT_TIME);
ALTER TABLE MLXPGStatTest ADD constraint PK_MLXPGStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXPGStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXPGStatTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
RECVPKTS_MIN		Number(20,4) NOT NULL,
RECVPKTS_MAX		Number(20,4) NOT NULL,
RECVPKTS_STCNT		varchar2(32) NOT NULL,
RECVBYTE_MIN		Number(20,4) NOT NULL,
RECVBYTE_MAX		Number(20,4) NOT NULL,
RECVBYTE_STCNT		varchar2(32) NOT NULL,
QDEPTH_MIN		Number(20,4) NOT NULL,
QDEPTH_MAX		Number(20,4) NOT NULL,
QDEPTH_STCNT		varchar2(32) NOT NULL);

ALTER TABLE MLXPGStatTest_TREND ADD constraint PK_MLXPGStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXPGStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXPGStatTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
RECVPKTS_MIN		VARCHAR2(256) NOT NULL,
RECVPKTS_MAX		VARCHAR2(256) NOT NULL,
RECVBYTE_MIN		VARCHAR2(256) NOT NULL,
RECVBYTE_MAX		VARCHAR2(256) NOT NULL,
QDEPTH_MIN		VARCHAR2(256) NOT NULL,
QDEPTH_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE MLXPGStatTest_THRESH ADD constraint PK_MLXPGStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXPGStatTest_THRESH ON MLXPGStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXPGStatTest ON MLXPGStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXPGStatTest ON MLXPGStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXPortStatTest CASCADE CONSTRAINTS;
CREATE TABLE MLXPortStatTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
RECVPAUPKTS		Number(20,4) NOT NULL,
RECVPAUPKTS_ST		varchar2(32) NOT NULL,
TRANPAUPKTS		Number(20,4) NOT NULL,
TRANPAUPKTS_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXPortStatTest ON MLXPortStatTest(MSMT_TIME);
ALTER TABLE MLXPortStatTest ADD constraint PK_MLXPortStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXPortStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXPortStatTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
RECVPAUPKTS_MIN		Number(20,4) NOT NULL,
RECVPAUPKTS_MAX		Number(20,4) NOT NULL,
RECVPAUPKTS_STCNT	varchar2(32) NOT NULL,
TRANPAUPKTS_MIN		Number(20,4) NOT NULL,
TRANPAUPKTS_MAX		Number(20,4) NOT NULL,
TRANPAUPKTS_STCNT	varchar2(32) NOT NULL);

ALTER TABLE MLXPortStatTest_TREND ADD constraint PK_MLXPortStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXPortStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXPortStatTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
RECVPAUPKTS_MIN		VARCHAR2(256) NOT NULL,
RECVPAUPKTS_MAX		VARCHAR2(256) NOT NULL,
TRANPAUPKTS_MIN		VARCHAR2(256) NOT NULL,
TRANPAUPKTS_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE MLXPortStatTest_THRESH ADD constraint PK_MLXPortStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXPortStatTest_THRESH ON MLXPortStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXPortStatTest ON MLXPortStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXPortStatTest ON MLXPortStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXQOSPIStTest CASCADE CONSTRAINTS;
CREATE TABLE MLXQOSPIStTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
RECVPKTS		Number(20,4) NOT NULL,
RECVPKTS_ST		varchar2(32) NOT NULL,
RECVUNIPKTS		Number(20,4) NOT NULL,
RECVUNIPKTS_ST		varchar2(32) NOT NULL,
RECMULPKTS		Number(20,4) NOT NULL,
RECMULPKTS_ST		varchar2(32) NOT NULL,
RECBROPKTS		Number(20,4) NOT NULL,
RECBROPKTS_ST		varchar2(32) NOT NULL,
RECVBYTES		Number(20,4) NOT NULL,
RECVBYTES_ST		varchar2(32) NOT NULL,
RECVPAUPKTS		Number(20,4) NOT NULL,
RECVPAUPKTS_ST		varchar2(32) NOT NULL,
RECVPAUDURTN		Number(20,4) NOT NULL,
RECVPAUDURTN_ST		varchar2(32) NOT NULL,
TRANSPKTS		Number(20,4) NOT NULL,
TRANSPKTS_ST		varchar2(32) NOT NULL,
TRANSUNIPKTS		Number(20,4) NOT NULL,
TRANSUNIPKTS_ST		varchar2(32) NOT NULL,
TRANSMULPKTS		Number(20,4) NOT NULL,
TRANSMULPKTS_ST		varchar2(32) NOT NULL,
TRANSBROPKTS		Number(20,4) NOT NULL,
TRANSBROPKTS_ST		varchar2(32) NOT NULL,
TRANSBYTES		Number(20,4) NOT NULL,
TRANSBYTES_ST		varchar2(32) NOT NULL,
TRANSPAUPKTS		Number(20,4) NOT NULL,
TRANSPAUPKTS_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXQOSPIStTest ON MLXQOSPIStTest(MSMT_TIME);
ALTER TABLE MLXQOSPIStTest ADD constraint PK_MLXQOSPIStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXQOSPIStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXQOSPIStTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
RECVPKTS_MIN		Number(20,4) NOT NULL,
RECVPKTS_MAX		Number(20,4) NOT NULL,
RECVPKTS_STCNT		varchar2(32) NOT NULL,
RECVUNIPKTS_MIN		Number(20,4) NOT NULL,
RECVUNIPKTS_MAX		Number(20,4) NOT NULL,
RECVUNIPKTS_STCNT	varchar2(32) NOT NULL,
RECMULPKTS_MIN		Number(20,4) NOT NULL,
RECMULPKTS_MAX		Number(20,4) NOT NULL,
RECMULPKTS_STCNT	varchar2(32) NOT NULL,
RECBROPKTS_MIN		Number(20,4) NOT NULL,
RECBROPKTS_MAX		Number(20,4) NOT NULL,
RECBROPKTS_STCNT	varchar2(32) NOT NULL,
RECVBYTES_MIN		Number(20,4) NOT NULL,
RECVBYTES_MAX		Number(20,4) NOT NULL,
RECVBYTES_STCNT		varchar2(32) NOT NULL,
RECVPAUPKTS_MIN		Number(20,4) NOT NULL,
RECVPAUPKTS_MAX		Number(20,4) NOT NULL,
RECVPAUPKTS_STCNT	varchar2(32) NOT NULL,
RECVPAUDURTN_MIN	Number(20,4) NOT NULL,
RECVPAUDURTN_MAX	Number(20,4) NOT NULL,
RECVPAUDURTN_STCNT	varchar2(32) NOT NULL,
TRANSPKTS_MIN		Number(20,4) NOT NULL,
TRANSPKTS_MAX		Number(20,4) NOT NULL,
TRANSPKTS_STCNT		varchar2(32) NOT NULL,
TRANSUNIPKTS_MIN	Number(20,4) NOT NULL,
TRANSUNIPKTS_MAX	Number(20,4) NOT NULL,
TRANSUNIPKTS_STCNT	varchar2(32) NOT NULL,
TRANSMULPKTS_MIN	Number(20,4) NOT NULL,
TRANSMULPKTS_MAX	Number(20,4) NOT NULL,
TRANSMULPKTS_STCNT	varchar2(32) NOT NULL,
TRANSBROPKTS_MIN	Number(20,4) NOT NULL,
TRANSBROPKTS_MAX	Number(20,4) NOT NULL,
TRANSBROPKTS_STCNT	varchar2(32) NOT NULL,
TRANSBYTES_MIN		Number(20,4) NOT NULL,
TRANSBYTES_MAX		Number(20,4) NOT NULL,
TRANSBYTES_STCNT	varchar2(32) NOT NULL,
TRANSPAUPKTS_MIN	Number(20,4) NOT NULL,
TRANSPAUPKTS_MAX	Number(20,4) NOT NULL,
TRANSPAUPKTS_STCNT	varchar2(32) NOT NULL);

ALTER TABLE MLXQOSPIStTest_TREND ADD constraint PK_MLXQOSPIStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXQOSPIStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXQOSPIStTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
RECVPKTS_MIN		VARCHAR2(256) NOT NULL,
RECVPKTS_MAX		VARCHAR2(256) NOT NULL,
RECVUNIPKTS_MIN		VARCHAR2(256) NOT NULL,
RECVUNIPKTS_MAX		VARCHAR2(256) NOT NULL,
RECMULPKTS_MIN		VARCHAR2(256) NOT NULL,
RECMULPKTS_MAX		VARCHAR2(256) NOT NULL,
RECBROPKTS_MIN		VARCHAR2(256) NOT NULL,
RECBROPKTS_MAX		VARCHAR2(256) NOT NULL,
RECVBYTES_MIN		VARCHAR2(256) NOT NULL,
RECVBYTES_MAX		VARCHAR2(256) NOT NULL,
RECVPAUPKTS_MIN		VARCHAR2(256) NOT NULL,
RECVPAUPKTS_MAX		VARCHAR2(256) NOT NULL,
RECVPAUDURTN_MIN	VARCHAR2(256) NOT NULL,
RECVPAUDURTN_MAX	VARCHAR2(256) NOT NULL,
TRANSPKTS_MIN		VARCHAR2(256) NOT NULL,
TRANSPKTS_MAX		VARCHAR2(256) NOT NULL,
TRANSUNIPKTS_MIN	VARCHAR2(256) NOT NULL,
TRANSUNIPKTS_MAX	VARCHAR2(256) NOT NULL,
TRANSMULPKTS_MIN	VARCHAR2(256) NOT NULL,
TRANSMULPKTS_MAX	VARCHAR2(256) NOT NULL,
TRANSBROPKTS_MIN	VARCHAR2(256) NOT NULL,
TRANSBROPKTS_MAX	VARCHAR2(256) NOT NULL,
TRANSBYTES_MIN		VARCHAR2(256) NOT NULL,
TRANSBYTES_MAX		VARCHAR2(256) NOT NULL,
TRANSPAUPKTS_MIN	VARCHAR2(256) NOT NULL,
TRANSPAUPKTS_MAX	VARCHAR2(256) NOT NULL);

ALTER TABLE MLXQOSPIStTest_THRESH ADD constraint PK_MLXQOSPIStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXQOSPIStTest_THRESH ON MLXQOSPIStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXQOSPIStTest ON MLXQOSPIStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXQOSPIStTest ON MLXQOSPIStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXStorStatTest CASCADE CONSTRAINTS;
CREATE TABLE MLXStorStatTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
TOTSPACE		Number(20,4) NOT NULL,
TOTSPACE_ST		varchar2(32) NOT NULL,
USESPACE		Number(20,4) NOT NULL,
USESPACE_ST		varchar2(32) NOT NULL,
FREESPACE		Number(20,4) NOT NULL,
FREESPACE_ST		varchar2(32) NOT NULL,
AVAILSPACE		Number(20,4) NOT NULL,
AVAILSPACE_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXStorStatTest ON MLXStorStatTest(MSMT_TIME);
ALTER TABLE MLXStorStatTest ADD constraint PK_MLXStorStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXStorStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXStorStatTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
TOTSPACE_MIN		Number(20,4) NOT NULL,
TOTSPACE_MAX		Number(20,4) NOT NULL,
TOTSPACE_STCNT		varchar2(32) NOT NULL,
USESPACE_MIN		Number(20,4) NOT NULL,
USESPACE_MAX		Number(20,4) NOT NULL,
USESPACE_STCNT		varchar2(32) NOT NULL,
FREESPACE_MIN		Number(20,4) NOT NULL,
FREESPACE_MAX		Number(20,4) NOT NULL,
FREESPACE_STCNT		varchar2(32) NOT NULL,
AVAILSPACE_MIN		Number(20,4) NOT NULL,
AVAILSPACE_MAX		Number(20,4) NOT NULL,
AVAILSPACE_STCNT	varchar2(32) NOT NULL);

ALTER TABLE MLXStorStatTest_TREND ADD constraint PK_MLXStorStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXStorStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXStorStatTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
TOTSPACE_MIN		VARCHAR2(256) NOT NULL,
TOTSPACE_MAX		VARCHAR2(256) NOT NULL,
USESPACE_MIN		VARCHAR2(256) NOT NULL,
USESPACE_MAX		VARCHAR2(256) NOT NULL,
FREESPACE_MIN		VARCHAR2(256) NOT NULL,
FREESPACE_MAX		VARCHAR2(256) NOT NULL,
AVAILSPACE_MIN		VARCHAR2(256) NOT NULL,
AVAILSPACE_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE MLXStorStatTest_THRESH ADD constraint PK_MLXStorStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXStorStatTest_THRESH ON MLXStorStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXStorStatTest ON MLXStorStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXStorStatTest ON MLXStorStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXTCStatTest CASCADE CONSTRAINTS;
CREATE TABLE MLXTCStatTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
RECVPKTS		Number(20,4) NOT NULL,
RECVPKTS_ST		varchar2(32) NOT NULL,
RECVBYTE		Number(20,4) NOT NULL,
RECVBYTE_ST		varchar2(32) NOT NULL,
QDEPTH			Number(20,4) NOT NULL,
QDEPTH_ST		varchar2(32) NOT NULL,
QDEPTHUNITRAF		Number(20,4) NOT NULL,
QDEPTHUNITRAF_ST	varchar2(32) NOT NULL,
QDEPTHMULTRAF		Number(20,4) NOT NULL,
QDEPTHMULTRAF_ST	varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXTCStatTest ON MLXTCStatTest(MSMT_TIME);
ALTER TABLE MLXTCStatTest ADD constraint PK_MLXTCStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXTCStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXTCStatTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
RECVPKTS_MIN		Number(20,4) NOT NULL,
RECVPKTS_MAX		Number(20,4) NOT NULL,
RECVPKTS_STCNT		varchar2(32) NOT NULL,
RECVBYTE_MIN		Number(20,4) NOT NULL,
RECVBYTE_MAX		Number(20,4) NOT NULL,
RECVBYTE_STCNT		varchar2(32) NOT NULL,
QDEPTH_MIN		Number(20,4) NOT NULL,
QDEPTH_MAX		Number(20,4) NOT NULL,
QDEPTH_STCNT		varchar2(32) NOT NULL,
QDEPTHUNITRAF_MIN	Number(20,4) NOT NULL,
QDEPTHUNITRAF_MAX	Number(20,4) NOT NULL,
QDEPTHUNITRAF_STCNT	varchar2(32) NOT NULL,
QDEPTHMULTRAF_MIN	Number(20,4) NOT NULL,
QDEPTHMULTRAF_MAX	Number(20,4) NOT NULL,
QDEPTHMULTRAF_STCNT	varchar2(32) NOT NULL);

ALTER TABLE MLXTCStatTest_TREND ADD constraint PK_MLXTCStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXTCStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXTCStatTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
RECVPKTS_MIN		VARCHAR2(256) NOT NULL,
RECVPKTS_MAX		VARCHAR2(256) NOT NULL,
RECVBYTE_MIN		VARCHAR2(256) NOT NULL,
RECVBYTE_MAX		VARCHAR2(256) NOT NULL,
QDEPTH_MIN		VARCHAR2(256) NOT NULL,
QDEPTH_MAX		VARCHAR2(256) NOT NULL,
QDEPTHUNITRAF_MIN	VARCHAR2(256) NOT NULL,
QDEPTHUNITRAF_MAX	VARCHAR2(256) NOT NULL,
QDEPTHMULTRAF_MIN	VARCHAR2(256) NOT NULL,
QDEPTHMULTRAF_MAX	VARCHAR2(256) NOT NULL);

ALTER TABLE MLXTCStatTest_THRESH ADD constraint PK_MLXTCStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXTCStatTest_THRESH ON MLXTCStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXTCStatTest ON MLXTCStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXTCStatTest ON MLXTCStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXTempStTest CASCADE CONSTRAINTS;
CREATE TABLE MLXTempStTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
TSENSOR			Number(20,4) NOT NULL,
TSENSOR_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXTempStTest ON MLXTempStTest(MSMT_TIME);
ALTER TABLE MLXTempStTest ADD constraint PK_MLXTempStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXTempStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXTempStTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
TSENSOR_MIN		Number(20,4) NOT NULL,
TSENSOR_MAX		Number(20,4) NOT NULL,
TSENSOR_STCNT		varchar2(32) NOT NULL);

ALTER TABLE MLXTempStTest_TREND ADD constraint PK_MLXTempStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXTempStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXTempStTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
TSENSOR_MIN		VARCHAR2(256) NOT NULL,
TSENSOR_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE MLXTempStTest_THRESH ADD constraint PK_MLXTempStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXTempStTest_THRESH ON MLXTempStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXTempStTest ON MLXTempStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXTempStTest ON MLXTempStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXTempSensorTest CASCADE CONSTRAINTS;
CREATE TABLE MLXTempSensorTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
SENSORVALUE		Number(20,4) NOT NULL,
SENSORVALUE_ST		varchar2(32) NOT NULL,
OPERATIONALSTATUS	Number(20,4) NOT NULL,
OPERATIONALSTATUS_ST	varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXTempSensorTest ON MLXTempSensorTest(MSMT_TIME);
ALTER TABLE MLXTempSensorTest ADD constraint PK_MLXTempSensorTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXTempSensorTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXTempSensorTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
SENSORVALUE_MIN		Number(20,4) NOT NULL,
SENSORVALUE_MAX		Number(20,4) NOT NULL,
SENSORVALUE_STCNT	varchar2(32) NOT NULL,
OPERATIONALSTATUS_MIN	Number(20,4) NOT NULL,
OPERATIONALSTATUS_MAX	Number(20,4) NOT NULL,
OPERATIONALSTATUS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MLXTempSensorTest_TREND ADD constraint PK_MLXTempSensorTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXTempSensorTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXTempSensorTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
SENSORVALUE_MIN		VARCHAR2(256) NOT NULL,
SENSORVALUE_MAX		VARCHAR2(256) NOT NULL,
OPERATIONALSTATUS_MIN	VARCHAR2(256) NOT NULL,
OPERATIONALSTATUS_MAX	VARCHAR2(256) NOT NULL);

ALTER TABLE MLXTempSensorTest_THRESH ADD constraint PK_MLXTempSensorTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXTempSensorTest_THRESH ON MLXTempSensorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXTempSensorTest ON MLXTempSensorTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXTempSensorTest ON MLXTempSensorTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXFanSensorTest CASCADE CONSTRAINTS;
CREATE TABLE MLXFanSensorTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
SENSORVALUE		Number(20,4) NOT NULL,
SENSORVALUE_ST		varchar2(32) NOT NULL,
OPERATIONALSTATUS	Number(20,4) NOT NULL,
OPERATIONALSTATUS_ST	varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXFanSensorTest ON MLXFanSensorTest(MSMT_TIME);
ALTER TABLE MLXFanSensorTest ADD constraint PK_MLXFanSensorTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXFanSensorTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXFanSensorTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
SENSORVALUE_MIN		Number(20,4) NOT NULL,
SENSORVALUE_MAX		Number(20,4) NOT NULL,
SENSORVALUE_STCNT	varchar2(32) NOT NULL,
OPERATIONALSTATUS_MIN	Number(20,4) NOT NULL,
OPERATIONALSTATUS_MAX	Number(20,4) NOT NULL,
OPERATIONALSTATUS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MLXFanSensorTest_TREND ADD constraint PK_MLXFanSensorTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXFanSensorTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXFanSensorTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
SENSORVALUE_MIN		VARCHAR2(256) NOT NULL,
SENSORVALUE_MAX		VARCHAR2(256) NOT NULL,
OPERATIONALSTATUS_MIN	VARCHAR2(256) NOT NULL,
OPERATIONALSTATUS_MAX	VARCHAR2(256) NOT NULL);

ALTER TABLE MLXFanSensorTest_THRESH ADD constraint PK_MLXFanSensorTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXFanSensorTest_THRESH ON MLXFanSensorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXFanSensorTest ON MLXFanSensorTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXFanSensorTest ON MLXFanSensorTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXCPUSensorTest CASCADE CONSTRAINTS;
CREATE TABLE MLXCPUSensorTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
SENSORVALUE		Number(20,4) NOT NULL,
SENSORVALUE_ST		varchar2(32) NOT NULL,
OPERATIONALSTATUS	Number(20,4) NOT NULL,
OPERATIONALSTATUS_ST	varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXCPUSensorTest ON MLXCPUSensorTest(MSMT_TIME);
ALTER TABLE MLXCPUSensorTest ADD constraint PK_MLXCPUSensorTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXCPUSensorTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXCPUSensorTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
SENSORVALUE_MIN		Number(20,4) NOT NULL,
SENSORVALUE_MAX		Number(20,4) NOT NULL,
SENSORVALUE_STCNT	varchar2(32) NOT NULL,
OPERATIONALSTATUS_MIN	Number(20,4) NOT NULL,
OPERATIONALSTATUS_MAX	Number(20,4) NOT NULL,
OPERATIONALSTATUS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MLXCPUSensorTest_TREND ADD constraint PK_MLXCPUSensorTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXCPUSensorTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXCPUSensorTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
SENSORVALUE_MIN		VARCHAR2(256) NOT NULL,
SENSORVALUE_MAX		VARCHAR2(256) NOT NULL,
OPERATIONALSTATUS_MIN	VARCHAR2(256) NOT NULL,
OPERATIONALSTATUS_MAX	VARCHAR2(256) NOT NULL);

ALTER TABLE MLXCPUSensorTest_THRESH ADD constraint PK_MLXCPUSensorTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXCPUSensorTest_THRESH ON MLXCPUSensorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXCPUSensorTest ON MLXCPUSensorTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXCPUSensorTest ON MLXCPUSensorTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MLXPSSensorTest CASCADE CONSTRAINTS;
CREATE TABLE MLXPSSensorTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
SENSORVALUE		Number(20,4) NOT NULL,
SENSORVALUE_ST		varchar2(32) NOT NULL,
OPERATIONALSTATUS	Number(20,4) NOT NULL,
OPERATIONALSTATUS_ST	varchar2(32) NOT NULL);

CREATE INDEX IDX_MLXPSSensorTest ON MLXPSSensorTest(MSMT_TIME);
ALTER TABLE MLXPSSensorTest ADD constraint PK_MLXPSSensorTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MLXPSSensorTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MLXPSSensorTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
SENSORVALUE_MIN		Number(20,4) NOT NULL,
SENSORVALUE_MAX		Number(20,4) NOT NULL,
SENSORVALUE_STCNT	varchar2(32) NOT NULL,
OPERATIONALSTATUS_MIN	Number(20,4) NOT NULL,
OPERATIONALSTATUS_MAX	Number(20,4) NOT NULL,
OPERATIONALSTATUS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MLXPSSensorTest_TREND ADD constraint PK_MLXPSSensorTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MLXPSSensorTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MLXPSSensorTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
SENSORVALUE_MIN		VARCHAR2(256) NOT NULL,
SENSORVALUE_MAX		VARCHAR2(256) NOT NULL,
OPERATIONALSTATUS_MIN	VARCHAR2(256) NOT NULL,
OPERATIONALSTATUS_MAX	VARCHAR2(256) NOT NULL);

ALTER TABLE MLXPSSensorTest_THRESH ADD constraint PK_MLXPSSensorTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MLXPSSensorTest_THRESH ON MLXPSSensorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MLXPSSensorTest ON MLXPSSensorTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MLXPSSensorTest ON MLXPSSensorTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE BB12XDpDBConnTest CASCADE CONSTRAINTS;
CREATE TABLE BB12XDpDBConnTest(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
CONNECTIONSTATUS				Number(20,4) NOT NULL,
CONNECTIONSTATUS_ST				varchar2(32) NOT NULL,
TRANSACTIONSTODB				Number(20,4) NOT NULL,
TRANSACTIONSTODB_ST				varchar2(32) NOT NULL,
ERRORSENCOUNTEREDFORDB			Number(20,4) NOT NULL,
ERRORSENCOUNTEREDFORDB_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_BB12XDpDBConnTest ON BB12XDpDBConnTest(MSMT_TIME);
ALTER TABLE BB12XDpDBConnTest ADD constraint PK_BB12XDpDBConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE BB12XDpDBConnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE BB12XDpDBConnTest_TREND(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
PERIOD							varchar2(32),
CONNECTIONSTATUS_MIN			Number(20,4) NOT NULL,
CONNECTIONSTATUS_MAX			Number(20,4) NOT NULL,
CONNECTIONSTATUS_STCNT			varchar2(32) NOT NULL,
TRANSACTIONSTODB_MIN			Number(20,4) NOT NULL,
TRANSACTIONSTODB_MAX			Number(20,4) NOT NULL,
TRANSACTIONSTODB_STCNT			varchar2(32) NOT NULL,
ERRORSENCOUNTEREDFORDB_MIN		Number(20,4) NOT NULL,
ERRORSENCOUNTEREDFORDB_MAX		Number(20,4) NOT NULL,
ERRORSENCOUNTEREDFORDB_STCNT	varchar2(32) NOT NULL);

ALTER TABLE BB12XDpDBConnTest_TREND ADD constraint PK_BB12XDpDBConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BB12XDpDBConnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE BB12XDpDBConnTest_THRESH(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME_START					date,
MSMT_TIME_END					date,
CONNECTIONSTATUS_MIN			VARCHAR2(256) NOT NULL,
CONNECTIONSTATUS_MAX			VARCHAR2(256) NOT NULL,
TRANSACTIONSTODB_MIN			VARCHAR2(256) NOT NULL,
TRANSACTIONSTODB_MAX			VARCHAR2(256) NOT NULL,
ERRORSENCOUNTEREDFORDB_MIN		VARCHAR2(256) NOT NULL,
ERRORSENCOUNTEREDFORDB_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE BB12XDpDBConnTest_THRESH ADD constraint PK_BB12XDpDBConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_BB12XDpDBConnTest_THRESH ON BB12XDpDBConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_BB12XDpDBConnTest ON BB12XDpDBConnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_BB12XDpDBConnTest ON BB12XDpDBConnTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE BB12XDpRcpConnTest CASCADE CONSTRAINTS;
CREATE TABLE BB12XDpRcpConnTest(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO				            varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
CONNECTIONSTATUS				Number(20,4) NOT NULL,
CONNECTIONSTATUS_ST				varchar2(32) NOT NULL,
TRANSACTIONWAITINGTOSENT		Number(20,4) NOT NULL,
TRANSACTIONWAITINGTOSENT_ST		varchar2(32) NOT NULL,
DATARECEIVEDOVERRCPCONN			Number(20,4) NOT NULL,
DATARECEIVEDOVERRCPCONN_ST		varchar2(32) NOT NULL,
DATATRANSMITOVERRCPCONN			Number(20,4) NOT NULL,
DATATRANSMITOVERRCPCONN_ST		varchar2(32) NOT NULL,
TRANSACRECEIVEDOVERRCP			Number(20,4) NOT NULL,
TRANSACRECEIVEDOVERRCP_ST		varchar2(32) NOT NULL,
TRANSACSENTOVERRCP				Number(20,4) NOT NULL,
TRANSACSENTOVERRCP_ST			varchar2(32) NOT NULL);

CREATE INDEX IDX_BB12XDpRcpConnTest ON BB12XDpRcpConnTest(MSMT_TIME);
ALTER TABLE BB12XDpRcpConnTest ADD constraint PK_BB12XDpRcpConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE BB12XDpRcpConnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE BB12XDpRcpConnTest_TREND(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
PERIOD							varchar2(32),
CONNECTIONSTATUS_MIN			Number(20,4) NOT NULL,
CONNECTIONSTATUS_MAX			Number(20,4) NOT NULL,
CONNECTIONSTATUS_STCNT			varchar2(32) NOT NULL,
TRANSACTIONWAITINGTOSENT_MIN	Number(20,4) NOT NULL,
TRANSACTIONWAITINGTOSENT_MAX	Number(20,4) NOT NULL,
TRANSACTIONWAITINGTOSENT_STCNT	varchar2(32) NOT NULL,
DATARECEIVEDOVERRCPCONN_MIN		Number(20,4) NOT NULL,
DATARECEIVEDOVERRCPCONN_MAX		Number(20,4) NOT NULL,
DATARECEIVEDOVERRCPCONN_STCNT	varchar2(32) NOT NULL,
DATATRANSMITOVERRCPCONN_MIN		Number(20,4) NOT NULL,
DATATRANSMITOVERRCPCONN_MAX		Number(20,4) NOT NULL,
DATATRANSMITOVERRCPCONN_STCNT	varchar2(32) NOT NULL,
TRANSACRECEIVEDOVERRCP_MIN		Number(20,4) NOT NULL,
TRANSACRECEIVEDOVERRCP_MAX		Number(20,4) NOT NULL,
TRANSACRECEIVEDOVERRCP_STCNT	varchar2(32) NOT NULL,
TRANSACSENTOVERRCP_MIN			Number(20,4) NOT NULL,
TRANSACSENTOVERRCP_MAX			Number(20,4) NOT NULL,
TRANSACSENTOVERRCP_STCNT		varchar2(32) NOT NULL);

ALTER TABLE BB12XDpRcpConnTest_TREND ADD constraint PK_BB12XDpRcpConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BB12XDpRcpConnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE BB12XDpRcpConnTest_THRESH(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME_START					date,
MSMT_TIME_END					date,
CONNECTIONSTATUS_MIN			VARCHAR2(256) NOT NULL,
CONNECTIONSTATUS_MAX			VARCHAR2(256) NOT NULL,
TRANSACTIONWAITINGTOSENT_MIN	VARCHAR2(256) NOT NULL,
TRANSACTIONWAITINGTOSENT_MAX	VARCHAR2(256) NOT NULL,
DATARECEIVEDOVERRCPCONN_MIN		VARCHAR2(256) NOT NULL,
DATARECEIVEDOVERRCPCONN_MAX		VARCHAR2(256) NOT NULL,
DATATRANSMITOVERRCPCONN_MIN		VARCHAR2(256) NOT NULL,
DATATRANSMITOVERRCPCONN_MAX		VARCHAR2(256) NOT NULL,
TRANSACRECEIVEDOVERRCP_MIN		VARCHAR2(256) NOT NULL,
TRANSACRECEIVEDOVERRCP_MAX		VARCHAR2(256) NOT NULL,
TRANSACSENTOVERRCP_MIN			VARCHAR2(256) NOT NULL,
TRANSACSENTOVERRCP_MAX			VARCHAR2(256) NOT NULL);

ALTER TABLE BB12XDpRcpConnTest_THRESH ADD constraint PK_BB12XDpRcpConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_BB12XDpRcpConnTest_THRESH ON BB12XDpRcpConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_BB12XDpRcpConnTest ON BB12XDpRcpConnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_BB12XDpRcpConnTest ON BB12XDpRcpConnTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE BB12XMDSAdvStatTest CASCADE CONSTRAINTS;
CREATE TABLE BB12XMDSAdvStatTest(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
REQUESTRECEIVEDDFTP				Number(20,4) NOT NULL,
REQUESTRECEIVEDDFTP_ST			varchar2(32) NOT NULL,
REQUESTRECEIEVDDFTPLIST			Number(20,4) NOT NULL,
REQUESTRECEIEVDDFTPLIST_ST		varchar2(32) NOT NULL,
REQUESTRECEIVEDDFTPSTATS		Number(20,4) NOT NULL,
REQUESTRECEIVEDDFTPSTATS_ST		varchar2(32) NOT NULL,
REQUESTRECEIVEDDFTPGET			Number(20,4) NOT NULL,
REQUESTRECEIVEDDFTPGET_ST 		varchar2(32) NOT NULL,
REQUESTRECEIVEDDFTPPUT			Number(20,4) NOT NULL,
REQUESTRECEIVEDDFTPPUT_ST		varchar2(32) NOT NULL,
REQUESTHANDLEDDFTP				Number(20,4) NOT NULL,
REQUESTHANDLEDDFTP_ST			varchar2(32) NOT NULL,
DATAPACKETSGMETOIPPP			Number(20,4) NOT NULL,
DATAPACKETSGMETOIPPP_ST			varchar2(32) NOT NULL,
DATAPACKETSGMETOSRP				Number(20,4) NOT NULL,
DATAPACKETSGMETOSRP_ST			varchar2(32) NOT NULL,
DATAPACKETSIPPPTOGME			Number(20,4) NOT NULL,
DATAPACKETSIPPPTOGME_ST			varchar2(32) NOT NULL,
RECEIVINGPACKETSSRPTOGME		Number(20,4) NOT NULL,
RECEIVINGPACKETSSRPTOGME_ST		varchar2(32) NOT NULL,
OPENFAILEDTCPSOCKETCONN			Number(20,4) NOT NULL,
OPENFAILEDTCPSOCKETCONN_ST		varchar2(32) NOT NULL,
OPENSUCCESSTCPSOCKETCONN		Number(20,4) NOT NULL,
OPENSUCCESSTCPSOCKETCONN_ST		varchar2(32) NOT NULL,
CLOSEDSUCCESSTCPSOCKET			Number(20,4) NOT NULL,
CLOSEDSUCCESSTCPSOCKET_ST		varchar2(32) NOT NULL,
PACKETSSENTOVEROUTBNDTCP		Number(20,4) NOT NULL,
PACKETSSENTOVEROUTBNDTCP_ST		varchar2(32) NOT NULL,
PACKETSRCVDOVEROUTBNDTCP		Number(20,4) NOT NULL,
PACKETSRCVDOVEROUTBNDTCP_ST		varchar2(32) NOT NULL,
FAILEDSRPCONN					Number(20,4) NOT NULL,
FAILEDSRPCONN_ST				varchar2(32) NOT NULL,
REFUSEDSRPCONN					Number(20,4) NOT NULL,
REFUSEDSRPCONN_ST				varchar2(32) NOT NULL,
INVALIDSRPCONN					Number(20,4) NOT NULL,
INVALIDSRPCONN_ST				varchar2(32) NOT NULL,
SUCCESSSRPCONN					Number(20,4) NOT NULL,
SUCCESSSRPCONN_ST				varchar2(32) NOT NULL,
ACTIVEIPPPCONN					Number(20,4) NOT NULL,
ACTIVEIPPPCONN_ST				varchar2(32) NOT NULL,
PACKETSRECEIVEDOVERTCP			Number(20,4) NOT NULL,
PACKETSRECEIVEDOVERTCP_ST		varchar2(32) NOT NULL,
PACKETSSENTOVERTCP				Number(20,4) NOT NULL,
PACKETSSENTOVERTCP_ST			varchar2(32) NOT NULL,
SOCKETCONNERRORS				Number(20,4) NOT NULL,
SOCKETCONNERRORS_ST				varchar2(32) NOT NULL);

CREATE INDEX IDX_BB12XMDSAdvStatTest ON BB12XMDSAdvStatTest(MSMT_TIME);
ALTER TABLE BB12XMDSAdvStatTest ADD constraint PK_BB12XMDSAdvStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE BB12XMDSAdvStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE BB12XMDSAdvStatTest_TREND(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
PERIOD							varchar2(32),
REQUESTRECEIVEDDFTP_MIN			Number(20,4) NOT NULL,
REQUESTRECEIVEDDFTP_MAX			Number(20,4) NOT NULL,
REQUESTRECEIVEDDFTP_STCNT		varchar2(32) NOT NULL,
REQUESTRECEIEVDDFTPLIST_MIN		Number(20,4) NOT NULL,
REQUESTRECEIEVDDFTPLIST_MAX		Number(20,4) NOT NULL,
REQUESTRECEIEVDDFTPLIST_STCNT	varchar2(32) NOT NULL,
REQUESTRECEIVEDDFTPSTATS_MIN	Number(20,4) NOT NULL,
REQUESTRECEIVEDDFTPSTATS_MAX	Number(20,4) NOT NULL,
REQUESTRECEIVEDDFTPSTATS_STCNT	varchar2(32) NOT NULL,
REQUESTRECEIVEDDFTPGET_MIN		Number(20,4) NOT NULL,
REQUESTRECEIVEDDFTPGET_MAX		Number(20,4) NOT NULL,
REQUESTRECEIVEDDFTPGET_STCNT	varchar2(32) NOT NULL,
REQUESTRECEIVEDDFTPPUT_MIN		Number(20,4) NOT NULL,
REQUESTRECEIVEDDFTPPUT_MAX		Number(20,4) NOT NULL,
REQUESTRECEIVEDDFTPPUT_STCNT	varchar2(32) NOT NULL,
REQUESTHANDLEDDFTP_MIN			Number(20,4) NOT NULL,
REQUESTHANDLEDDFTP_MAX			Number(20,4) NOT NULL,
REQUESTHANDLEDDFTP_STCNT		varchar2(32) NOT NULL,
DATAPACKETSGMETOIPPP_MIN		Number(20,4) NOT NULL,
DATAPACKETSGMETOIPPP_MAX		Number(20,4) NOT NULL,
DATAPACKETSGMETOIPPP_STCNT		varchar2(32) NOT NULL,
DATAPACKETSGMETOSRP_MIN			Number(20,4) NOT NULL,
DATAPACKETSGMETOSRP_MAX			Number(20,4) NOT NULL,
DATAPACKETSGMETOSRP_STCNT		varchar2(32) NOT NULL,
DATAPACKETSIPPPTOGME_MIN		Number(20,4) NOT NULL,
DATAPACKETSIPPPTOGME_MAX		Number(20,4) NOT NULL,
DATAPACKETSIPPPTOGME_STCNT		varchar2(32) NOT NULL,
RECEIVINGPACKETSSRPTOGME_MIN	Number(20,4) NOT NULL,
RECEIVINGPACKETSSRPTOGME_MAX	Number(20,4) NOT NULL,
RECEIVINGPACKETSSRPTOGME_STCNT	varchar2(32) NOT NULL,
OPENFAILEDTCPSOCKETCONN_MIN		Number(20,4) NOT NULL,
OPENFAILEDTCPSOCKETCONN_MAX		Number(20,4) NOT NULL,
OPENFAILEDTCPSOCKETCONN_STCNT	varchar2(32) NOT NULL,
OPENSUCCESSTCPSOCKETCONN_MIN	Number(20,4) NOT NULL,
OPENSUCCESSTCPSOCKETCONN_MAX	Number(20,4) NOT NULL,
OPENSUCCESSTCPSOCKETCONN_STCNT	varchar2(32) NOT NULL,
CLOSEDSUCCESSTCPSOCKET_MIN		Number(20,4) NOT NULL,
CLOSEDSUCCESSTCPSOCKET_MAX		Number(20,4) NOT NULL,
CLOSEDSUCCESSTCPSOCKET_STCNT	varchar2(32) NOT NULL,
PACKETSSENTOVEROUTBNDTCP_MIN	Number(20,4) NOT NULL,
PACKETSSENTOVEROUTBNDTCP_MAX	Number(20,4) NOT NULL,
PACKETSSENTOVEROUTBNDTCP_STCNT	varchar2(32) NOT NULL,
PACKETSRCVDOVEROUTBNDTCP_MIN	Number(20,4) NOT NULL,
PACKETSRCVDOVEROUTBNDTCP_MAX	Number(20,4) NOT NULL,
PACKETSRCVDOVEROUTBNDTCP_STCNT	varchar2(32) NOT NULL,
FAILEDSRPCONN_MIN				Number(20,4) NOT NULL,
FAILEDSRPCONN_MAX				Number(20,4) NOT NULL,
FAILEDSRPCONN_STCNT				varchar2(32) NOT NULL,
REFUSEDSRPCONN_MIN				Number(20,4) NOT NULL,
REFUSEDSRPCONN_MAX				Number(20,4) NOT NULL,
REFUSEDSRPCONN_STCNT			varchar2(32) NOT NULL,
INVALIDSRPCONN_MIN				Number(20,4) NOT NULL,
INVALIDSRPCONN_MAX				Number(20,4) NOT NULL,
INVALIDSRPCONN_STCNT			varchar2(32) NOT NULL,
SUCCESSSRPCONN_MIN				Number(20,4) NOT NULL,
SUCCESSSRPCONN_MAX				Number(20,4) NOT NULL,
SUCCESSSRPCONN_STCNT			varchar2(32) NOT NULL,
ACTIVEIPPPCONN_MIN				Number(20,4) NOT NULL,
ACTIVEIPPPCONN_MAX				Number(20,4) NOT NULL,
ACTIVEIPPPCONN_STCNT			varchar2(32) NOT NULL,
PACKETSRECEIVEDOVERTCP_MIN		Number(20,4) NOT NULL,
PACKETSRECEIVEDOVERTCP_MAX		Number(20,4) NOT NULL,
PACKETSRECEIVEDOVERTCP_STCNT	varchar2(32) NOT NULL,
PACKETSSENTOVERTCP_MIN			Number(20,4) NOT NULL,
PACKETSSENTOVERTCP_MAX			Number(20,4) NOT NULL,
PACKETSSENTOVERTCP_STCNT		varchar2(32) NOT NULL,
SOCKETCONNERRORS_MIN			Number(20,4) NOT NULL,
SOCKETCONNERRORS_MAX			Number(20,4) NOT NULL,
SOCKETCONNERRORS_STCNT			varchar2(32) NOT NULL);

ALTER TABLE BB12XMDSAdvStatTest_TREND ADD constraint PK_BB12XMDSAdvStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BB12XMDSAdvStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE BB12XMDSAdvStatTest_THRESH(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME_START					date,
MSMT_TIME_END					date,
REQUESTRECEIVEDDFTP_MIN			VARCHAR2(256) NOT NULL,
REQUESTRECEIVEDDFTP_MAX			VARCHAR2(256) NOT NULL,
REQUESTRECEIEVDDFTPLIST_MIN		VARCHAR2(256) NOT NULL,
REQUESTRECEIEVDDFTPLIST_MAX		VARCHAR2(256) NOT NULL,
REQUESTRECEIVEDDFTPSTATS_MIN	VARCHAR2(256) NOT NULL,
REQUESTRECEIVEDDFTPSTATS_MAX	VARCHAR2(256) NOT NULL,
REQUESTRECEIVEDDFTPGET_MIN		VARCHAR2(256) NOT NULL,
REQUESTRECEIVEDDFTPGET_MAX		VARCHAR2(256) NOT NULL,
REQUESTRECEIVEDDFTPPUT_MIN		VARCHAR2(256) NOT NULL,
REQUESTRECEIVEDDFTPPUT_MAX		VARCHAR2(256) NOT NULL,
REQUESTHANDLEDDFTP_MIN			VARCHAR2(256) NOT NULL,
REQUESTHANDLEDDFTP_MAX			VARCHAR2(256) NOT NULL,
DATAPACKETSGMETOIPPP_MIN		VARCHAR2(256) NOT NULL,
DATAPACKETSGMETOIPPP_MAX		VARCHAR2(256) NOT NULL,
DATAPACKETSGMETOSRP_MIN			VARCHAR2(256) NOT NULL,
DATAPACKETSGMETOSRP_MAX			VARCHAR2(256) NOT NULL,
DATAPACKETSIPPPTOGME_MIN		VARCHAR2(256) NOT NULL,
DATAPACKETSIPPPTOGME_MAX		VARCHAR2(256) NOT NULL,
RECEIVINGPACKETSSRPTOGME_MIN	VARCHAR2(256) NOT NULL,
RECEIVINGPACKETSSRPTOGME_MAX	VARCHAR2(256) NOT NULL,
OPENFAILEDTCPSOCKETCONN_MIN		VARCHAR2(256) NOT NULL,
OPENFAILEDTCPSOCKETCONN_MAX		VARCHAR2(256) NOT NULL,
OPENSUCCESSTCPSOCKETCONN_MIN	VARCHAR2(256) NOT NULL,
OPENSUCCESSTCPSOCKETCONN_MAX	VARCHAR2(256) NOT NULL,
CLOSEDSUCCESSTCPSOCKET_MIN		VARCHAR2(256) NOT NULL,
CLOSEDSUCCESSTCPSOCKET_MAX		VARCHAR2(256) NOT NULL,
PACKETSSENTOVEROUTBNDTCP_MIN	VARCHAR2(256) NOT NULL,
PACKETSSENTOVEROUTBNDTCP_MAX	VARCHAR2(256) NOT NULL,
PACKETSRCVDOVEROUTBNDTCP_MIN	VARCHAR2(256) NOT NULL,
PACKETSRCVDOVEROUTBNDTCP_MAX	VARCHAR2(256) NOT NULL,
FAILEDSRPCONN_MIN				VARCHAR2(256) NOT NULL,
FAILEDSRPCONN_MAX				VARCHAR2(256) NOT NULL,
REFUSEDSRPCONN_MIN				VARCHAR2(256) NOT NULL,
REFUSEDSRPCONN_MAX				VARCHAR2(256) NOT NULL,
INVALIDSRPCONN_MIN				VARCHAR2(256) NOT NULL,
INVALIDSRPCONN_MAX				VARCHAR2(256) NOT NULL,
SUCCESSSRPCONN_MIN				VARCHAR2(256) NOT NULL,
SUCCESSSRPCONN_MAX				VARCHAR2(256) NOT NULL,
ACTIVEIPPPCONN_MIN				VARCHAR2(256) NOT NULL,
ACTIVEIPPPCONN_MAX				VARCHAR2(256) NOT NULL,
PACKETSRECEIVEDOVERTCP_MIN		VARCHAR2(256) NOT NULL,
PACKETSRECEIVEDOVERTCP_MAX		VARCHAR2(256) NOT NULL,
PACKETSSENTOVERTCP_MIN			VARCHAR2(256) NOT NULL,
PACKETSSENTOVERTCP_MAX			VARCHAR2(256) NOT NULL,
SOCKETCONNERRORS_MIN			VARCHAR2(256) NOT NULL,
SOCKETCONNERRORS_MAX			VARCHAR2(256) NOT NULL);

ALTER TABLE BB12XMDSAdvStatTest_THRESH ADD constraint PK_BB12XMDSAdvStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_BB12XMDSAdvStatTest_THRESH ON BB12XMDSAdvStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_BB12XMDSAdvStatTest ON BB12XMDSAdvStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_BB12XMDSAdvStatTest ON BB12XMDSAdvStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE BB12XMDSConnTest CASCADE CONSTRAINTS;
CREATE TABLE BB12XMDSConnTest(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
TRANSACTIONPENDINGPROCQL		Number(20,4) NOT NULL,
TRANSACTIONPENDINGPROCQL_ST		varchar2(32) NOT NULL,
ENABLEDMDSCONNUSERS				Number(20,4) NOT NULL,
ENABLEDMDSCONNUSERS_ST			varchar2(32) NOT NULL);

CREATE INDEX IDX_BB12XMDSConnTest ON BB12XMDSConnTest(MSMT_TIME);
ALTER TABLE BB12XMDSConnTest ADD constraint PK_BB12XMDSConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE BB12XMDSConnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE BB12XMDSConnTest_TREND(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
PERIOD							varchar2(32),
TRANSACTIONPENDINGPROCQL_MIN	Number(20,4) NOT NULL,
TRANSACTIONPENDINGPROCQL_MAX	Number(20,4) NOT NULL,
TRANSACTIONPENDINGPROCQL_STCNT	varchar2(32) NOT NULL,
ENABLEDMDSCONNUSERS_MIN			Number(20,4) NOT NULL,
ENABLEDMDSCONNUSERS_MAX			Number(20,4) NOT NULL,
ENABLEDMDSCONNUSERS_STCNT		varchar2(32) NOT NULL);

ALTER TABLE BB12XMDSConnTest_TREND ADD constraint PK_BB12XMDSConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BB12XMDSConnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE BB12XMDSConnTest_THRESH(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME_START					date,
MSMT_TIME_END					date,
TRANSACTIONPENDINGPROCQL_MIN	VARCHAR2(256) NOT NULL,
TRANSACTIONPENDINGPROCQL_MAX	VARCHAR2(256) NOT NULL,
ENABLEDMDSCONNUSERS_MIN			VARCHAR2(256) NOT NULL,
ENABLEDMDSCONNUSERS_MAX			VARCHAR2(256) NOT NULL);

ALTER TABLE BB12XMDSConnTest_THRESH ADD constraint PK_BB12XMDSConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_BB12XMDSConnTest_THRESH ON BB12XMDSConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_BB12XMDSConnTest ON BB12XMDSConnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_BB12XMDSConnTest ON BB12XMDSConnTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE BB12XMDSStatTest CASCADE CONSTRAINTS;
CREATE TABLE BB12XMDSStatTest(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
PACKETSSIZERCVDFROMDVCS			Number(20,4) NOT NULL,
PACKETSSIZERCVDFROMDVCS_ST		varchar2(32) NOT NULL,
PACKETSSIZESENTTODEVICES		Number(20,4) NOT NULL,
PACKETSSIZESENTTODEVICES_ST		varchar2(32) NOT NULL,
PACKETSRCVDFROMDEVICES			Number(20,4) NOT NULL,
PACKETSRCVDFROMDEVICES_ST		varchar2(32) NOT NULL,
PACKETSSENTTODEVICES			Number(20,4) NOT NULL,
PACKETSSENTTODEVICES_ST			varchar2(32) NOT NULL,
PUSHCONNECTIONSBYDEVICES		Number(20,4) NOT NULL,
PUSHCONNECTIONSBYDEVICES_ST		varchar2(32) NOT NULL,
PACKETSDISPATCHRDECLINED		Number(20,4) NOT NULL,
PACKETSDISPATCHRDECLINED_ST		varchar2(32) NOT NULL,
INVALIDPACKETSTODISPTCHR		Number(20,4) NOT NULL,
INVALIDPACKETSTODISPTCHR_ST		varchar2(32) NOT NULL,
EXPIREDIPPPPACKETS				Number(20,4) NOT NULL,
EXPIREDIPPPPACKETS_ST			varchar2(32) NOT NULL,
TRUNCATEDCONNECTIONS			Number(20,4) NOT NULL,
TRUNCATEDCONNECTIONS_ST			varchar2(32) NOT NULL,
TIMEOUTCONNECTIONS				Number(20,4) NOT NULL,
TIMEOUTCONNECTIONS_ST			varchar2(32) NOT NULL,
REFUSEDIPPPCONNECTIONS			Number(20,4) NOT NULL,
REFUSEDIPPPCONNECTIONS_ST		varchar2(32) NOT NULL,
SUCCESSSRPCONNECTIONS			Number(20,4) NOT NULL,
SUCCESSSRPCONNECTIONS_ST		varchar2(32) NOT NULL,
FAILURESRPCONNECTIONS			Number(20,4) NOT NULL,
FAILURESRPCONNECTIONS_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_BB12XMDSStatTest ON BB12XMDSStatTest(MSMT_TIME);
ALTER TABLE BB12XMDSStatTest ADD constraint PK_BB12XMDSStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE BB12XMDSStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE BB12XMDSStatTest_TREND(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
PERIOD							varchar2(32),
PACKETSSIZERCVDFROMDVCS_MIN		Number(20,4) NOT NULL,
PACKETSSIZERCVDFROMDVCS_MAX		Number(20,4) NOT NULL,
PACKETSSIZERCVDFROMDVCS_STCNT	varchar2(32) NOT NULL,
PACKETSSIZESENTTODEVICES_MIN	Number(20,4) NOT NULL,
PACKETSSIZESENTTODEVICES_MAX	Number(20,4) NOT NULL,
PACKETSSIZESENTTODEVICES_STCNT	varchar2(32) NOT NULL,
PACKETSRCVDFROMDEVICES_MIN		Number(20,4) NOT NULL,
PACKETSRCVDFROMDEVICES_MAX		Number(20,4) NOT NULL,
PACKETSRCVDFROMDEVICES_STCNT	varchar2(32) NOT NULL,
PACKETSSENTTODEVICES_MIN		Number(20,4) NOT NULL,
PACKETSSENTTODEVICES_MAX		Number(20,4) NOT NULL,
PACKETSSENTTODEVICES_STCNT		varchar2(32) NOT NULL,
PUSHCONNECTIONSBYDEVICES_MIN	Number(20,4) NOT NULL,
PUSHCONNECTIONSBYDEVICES_MAX	Number(20,4) NOT NULL,
PUSHCONNECTIONSBYDEVICES_STCNT	varchar2(32) NOT NULL,
PACKETSDISPATCHRDECLINED_MIN	Number(20,4) NOT NULL,
PACKETSDISPATCHRDECLINED_MAX	Number(20,4) NOT NULL,
PACKETSDISPATCHRDECLINED_STCNT	varchar2(32) NOT NULL,
INVALIDPACKETSTODISPTCHR_MIN	Number(20,4) NOT NULL,
INVALIDPACKETSTODISPTCHR_MAX	Number(20,4) NOT NULL,
INVALIDPACKETSTODISPTCHR_STCNT	varchar2(32) NOT NULL,
EXPIREDIPPPPACKETS_MIN			Number(20,4) NOT NULL,
EXPIREDIPPPPACKETS_MAX			Number(20,4) NOT NULL,
EXPIREDIPPPPACKETS_STCNT		varchar2(32) NOT NULL,
TRUNCATEDCONNECTIONS_MIN		Number(20,4) NOT NULL,
TRUNCATEDCONNECTIONS_MAX		Number(20,4) NOT NULL,
TRUNCATEDCONNECTIONS_STCNT		varchar2(32) NOT NULL,
TIMEOUTCONNECTIONS_MIN			Number(20,4) NOT NULL,
TIMEOUTCONNECTIONS_MAX			Number(20,4) NOT NULL,
TIMEOUTCONNECTIONS_STCNT		varchar2(32) NOT NULL,
REFUSEDIPPPCONNECTIONS_MIN		Number(20,4) NOT NULL,
REFUSEDIPPPCONNECTIONS_MAX		Number(20,4) NOT NULL,
REFUSEDIPPPCONNECTIONS_STCNT	varchar2(32) NOT NULL,
SUCCESSSRPCONNECTIONS_MIN		Number(20,4) NOT NULL,
SUCCESSSRPCONNECTIONS_MAX		Number(20,4) NOT NULL,
SUCCESSSRPCONNECTIONS_STCNT		varchar2(32) NOT NULL,
FAILURESRPCONNECTIONS_MIN		Number(20,4) NOT NULL,
FAILURESRPCONNECTIONS_MAX		Number(20,4) NOT NULL,
FAILURESRPCONNECTIONS_STCNT		varchar2(32) NOT NULL);

ALTER TABLE BB12XMDSStatTest_TREND ADD constraint PK_BB12XMDSStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BB12XMDSStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE BB12XMDSStatTest_THRESH(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME_START					date,
MSMT_TIME_END					date,
PACKETSSIZERCVDFROMDVCS_MIN		VARCHAR2(256) NOT NULL,
PACKETSSIZERCVDFROMDVCS_MAX		VARCHAR2(256) NOT NULL,
PACKETSSIZESENTTODEVICES_MIN	VARCHAR2(256) NOT NULL,
PACKETSSIZESENTTODEVICES_MAX	VARCHAR2(256) NOT NULL,
PACKETSRCVDFROMDEVICES_MIN		VARCHAR2(256) NOT NULL,
PACKETSRCVDFROMDEVICES_MAX		VARCHAR2(256) NOT NULL,
PACKETSSENTTODEVICES_MIN		VARCHAR2(256) NOT NULL,
PACKETSSENTTODEVICES_MAX		VARCHAR2(256) NOT NULL,
PUSHCONNECTIONSBYDEVICES_MIN	VARCHAR2(256) NOT NULL,
PUSHCONNECTIONSBYDEVICES_MAX	VARCHAR2(256) NOT NULL,
PACKETSDISPATCHRDECLINED_MIN	VARCHAR2(256) NOT NULL,
PACKETSDISPATCHRDECLINED_MAX	VARCHAR2(256) NOT NULL,
INVALIDPACKETSTODISPTCHR_MIN	VARCHAR2(256) NOT NULL,
INVALIDPACKETSTODISPTCHR_MAX	VARCHAR2(256) NOT NULL,
EXPIREDIPPPPACKETS_MIN			VARCHAR2(256) NOT NULL,
EXPIREDIPPPPACKETS_MAX			VARCHAR2(256) NOT NULL,
TRUNCATEDCONNECTIONS_MIN		VARCHAR2(256) NOT NULL,
TRUNCATEDCONNECTIONS_MAX		VARCHAR2(256) NOT NULL,
TIMEOUTCONNECTIONS_MIN			VARCHAR2(256) NOT NULL,
TIMEOUTCONNECTIONS_MAX			VARCHAR2(256) NOT NULL,
REFUSEDIPPPCONNECTIONS_MIN		VARCHAR2(256) NOT NULL,
REFUSEDIPPPCONNECTIONS_MAX		VARCHAR2(256) NOT NULL,
SUCCESSSRPCONNECTIONS_MIN		VARCHAR2(256) NOT NULL,
SUCCESSSRPCONNECTIONS_MAX		VARCHAR2(256) NOT NULL,
FAILURESRPCONNECTIONS_MIN		VARCHAR2(256) NOT NULL,
FAILURESRPCONNECTIONS_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE BB12XMDSStatTest_THRESH ADD constraint PK_BB12XMDSStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_BB12XMDSStatTest_THRESH ON BB12XMDSStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_BB12XMDSStatTest ON BB12XMDSStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_BB12XMDSStatTest ON BB12XMDSStatTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE BB12XMDSPushConTest CASCADE CONSTRAINTS;
CREATE TABLE BB12XMDSPushConTest(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
PACKETSSIZETODVCSONPUSH			Number(20,4) NOT NULL,
PACKETSSIZETODVCSONPUSH_ST		varchar2(32) NOT NULL,
PACKETSTODEVICEONPUSH			Number(20,4) NOT NULL,
PACKETSTODEVICEONPUSH_ST		varchar2(32) NOT NULL,
PUSHCONNECTIONSBYMDS			Number(20,4) NOT NULL,
PUSHCONNECTIONSBYMDS_ST			varchar2(32) NOT NULL,
CACHEDPUSHCONNECTION			Number(20,4) NOT NULL,
CACHEDPUSHCONNECTION_ST			varchar2(32) NOT NULL);

CREATE INDEX IDX_BB12XMDSPushConTest ON BB12XMDSPushConTest(MSMT_TIME);
ALTER TABLE BB12XMDSPushConTest ADD constraint PK_BB12XMDSPushConTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE BB12XMDSPushConTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE BB12XMDSPushConTest_TREND(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
PERIOD							varchar2(32),
PACKETSSIZETODVCSONPUSH_MIN		Number(20,4) NOT NULL,
PACKETSSIZETODVCSONPUSH_MAX		Number(20,4) NOT NULL,
PACKETSSIZETODVCSONPUSH_STCNT	varchar2(32) NOT NULL,
PACKETSTODEVICEONPUSH_MIN		Number(20,4) NOT NULL,
PACKETSTODEVICEONPUSH_MAX		Number(20,4) NOT NULL,
PACKETSTODEVICEONPUSH_STCNT		varchar2(32) NOT NULL,
PUSHCONNECTIONSBYMDS_MIN		Number(20,4) NOT NULL,
PUSHCONNECTIONSBYMDS_MAX		Number(20,4) NOT NULL,
PUSHCONNECTIONSBYMDS_STCNT		varchar2(32) NOT NULL,
CACHEDPUSHCONNECTION_MIN		Number(20,4) NOT NULL,
CACHEDPUSHCONNECTION_MAX		Number(20,4) NOT NULL,
CACHEDPUSHCONNECTION_STCNT		varchar2(32) NOT NULL);

ALTER TABLE BB12XMDSPushConTest_TREND ADD constraint PK_BB12XMDSPushConTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BB12XMDSPushConTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE BB12XMDSPushConTest_THRESH(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME_START					date,
MSMT_TIME_END					date,
PACKETSSIZETODVCSONPUSH_MIN		VARCHAR2(256) NOT NULL,
PACKETSSIZETODVCSONPUSH_MAX		VARCHAR2(256) NOT NULL,
PACKETSTODEVICEONPUSH_MIN		VARCHAR2(256) NOT NULL,
PACKETSTODEVICEONPUSH_MAX		VARCHAR2(256) NOT NULL,
PUSHCONNECTIONSBYMDS_MIN		VARCHAR2(256) NOT NULL,
PUSHCONNECTIONSBYMDS_MAX		VARCHAR2(256) NOT NULL,
CACHEDPUSHCONNECTION_MIN		VARCHAR2(256) NOT NULL,
CACHEDPUSHCONNECTION_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE BB12XMDSPushConTest_THRESH ADD constraint PK_BB12XMDSPushConTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_BB12XMDSPushConTest_THRESH ON BB12XMDSPushConTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_BB12XMDSPushConTest ON BB12XMDSPushConTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_BB12XMDSPushConTest ON BB12XMDSPushConTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE BB12XAffDBTest CASCADE CONSTRAINTS;
CREATE TABLE BB12XAffDBTest(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
CONNECTIONSTATUS				Number(20,4) NOT NULL,
CONNECTIONSTATUS_ST				varchar2(32) NOT NULL,
TRANSACTRANSMTDTODB				Number(20,4) NOT NULL,
TRANSACTRANSMTDTODB_ST			varchar2(32) NOT NULL,
ERRORSENCOUNTEREDFORDB			Number(20,4) NOT NULL,
ERRORSENCOUNTEREDFORDB_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_BB12XAffDBTest ON BB12XAffDBTest(MSMT_TIME);
ALTER TABLE BB12XAffDBTest ADD constraint PK_BB12XAffDBTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE BB12XAffDBTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE BB12XAffDBTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
PERIOD							varchar2(32),
CONNECTIONSTATUS_MIN			Number(20,4) NOT NULL,
CONNECTIONSTATUS_MAX			Number(20,4) NOT NULL,
CONNECTIONSTATUS_STCNT			varchar2(32) NOT NULL,
TRANSACTRANSMTDTODB_MIN			Number(20,4) NOT NULL,
TRANSACTRANSMTDTODB_MAX			Number(20,4) NOT NULL,
TRANSACTRANSMTDTODB_STCNT		varchar2(32) NOT NULL,
ERRORSENCOUNTEREDFORDB_MIN		Number(20,4) NOT NULL,
ERRORSENCOUNTEREDFORDB_MAX		Number(20,4) NOT NULL,
ERRORSENCOUNTEREDFORDB_STCNT	varchar2(32) NOT NULL);

ALTER TABLE BB12XAffDBTest_TREND ADD constraint PK_BB12XAffDBTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BB12XAffDBTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE BB12XAffDBTest_THRESH(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME_START					date,
MSMT_TIME_END					date,
CONNECTIONSTATUS_MIN			VARCHAR2(256) NOT NULL,
CONNECTIONSTATUS_MAX			VARCHAR2(256) NOT NULL,
TRANSACTRANSMTDTODB_MIN			VARCHAR2(256) NOT NULL,
TRANSACTRANSMTDTODB_MAX			VARCHAR2(256) NOT NULL,
ERRORSENCOUNTEREDFORDB_MIN		VARCHAR2(256) NOT NULL,
ERRORSENCOUNTEREDFORDB_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE BB12XAffDBTest_THRESH ADD constraint PK_BB12XAffDBTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_BB12XAffDBTest_THRESH ON BB12XAffDBTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_BB12XAffDBTest ON BB12XAffDBTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_BB12XAffDBTest ON BB12XAffDBTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE BB12XAffExtRCPTest CASCADE CONSTRAINTS;
CREATE TABLE BB12XAffExtRCPTest(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
TRANSACTIONWAITINGTOSENT		Number(20,4) NOT NULL,
TRANSACTIONWAITINGTOSENT_ST		varchar2(32) NOT NULL,
DATARECEIVEDOVERRCPCONN			Number(20,4) NOT NULL,
DATARECEIVEDOVERRCPCONN_ST		varchar2(32) NOT NULL,
DATATRANSMITOVERRCPCONN			Number(20,4) NOT NULL,
DATATRANSMITOVERRCPCONN_ST		varchar2(32) NOT NULL,
TRANSACRECEIVEDOVERRCP			Number(20,4) NOT NULL,
TRANSACRECEIVEDOVERRCP_ST		varchar2(32) NOT NULL,
TRANSACSENTOVERRCP				Number(20,4) NOT NULL,
TRANSACSENTOVERRCP_ST			varchar2(32) NOT NULL);

CREATE INDEX IDX_BB12XAffExtRCPTest ON BB12XAffExtRCPTest(MSMT_TIME);
ALTER TABLE BB12XAffExtRCPTest ADD constraint PK_BB12XAffExtRCPTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE BB12XAffExtRCPTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE BB12XAffExtRCPTest_TREND(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
PERIOD							varchar2(32),
TRANSACTIONWAITINGTOSENT_MIN	Number(20,4) NOT NULL,
TRANSACTIONWAITINGTOSENT_MAX	Number(20,4) NOT NULL,
TRANSACTIONWAITINGTOSENT_STCNT	varchar2(32) NOT NULL,
DATARECEIVEDOVERRCPCONN_MIN		Number(20,4) NOT NULL,
DATARECEIVEDOVERRCPCONN_MAX		Number(20,4) NOT NULL,
DATARECEIVEDOVERRCPCONN_STCNT	varchar2(32) NOT NULL,
DATATRANSMITOVERRCPCONN_MIN		Number(20,4) NOT NULL,
DATATRANSMITOVERRCPCONN_MAX		Number(20,4) NOT NULL,
DATATRANSMITOVERRCPCONN_STCNT	varchar2(32) NOT NULL,
TRANSACRECEIVEDOVERRCP_MIN		Number(20,4) NOT NULL,
TRANSACRECEIVEDOVERRCP_MAX		Number(20,4) NOT NULL,
TRANSACRECEIVEDOVERRCP_STCNT	varchar2(32) NOT NULL,
TRANSACSENTOVERRCP_MIN			Number(20,4) NOT NULL,
TRANSACSENTOVERRCP_MAX			Number(20,4) NOT NULL,
TRANSACSENTOVERRCP_STCNT		varchar2(32) NOT NULL);

ALTER TABLE BB12XAffExtRCPTest_TREND ADD constraint PK_BB12XAffExtRCPTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BB12XAffExtRCPTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE BB12XAffExtRCPTest_THRESH(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME_START					date,
MSMT_TIME_END					date,
TRANSACTIONWAITINGTOSENT_MIN	VARCHAR2(256) NOT NULL,
TRANSACTIONWAITINGTOSENT_MAX	VARCHAR2(256) NOT NULL,
DATARECEIVEDOVERRCPCONN_MIN		VARCHAR2(256) NOT NULL,
DATARECEIVEDOVERRCPCONN_MAX		VARCHAR2(256) NOT NULL,
DATATRANSMITOVERRCPCONN_MIN		VARCHAR2(256) NOT NULL,
DATATRANSMITOVERRCPCONN_MAX		VARCHAR2(256) NOT NULL,
TRANSACRECEIVEDOVERRCP_MIN		VARCHAR2(256) NOT NULL,
TRANSACRECEIVEDOVERRCP_MAX		VARCHAR2(256) NOT NULL,
TRANSACSENTOVERRCP_MIN			VARCHAR2(256) NOT NULL,
TRANSACSENTOVERRCP_MAX			VARCHAR2(256) NOT NULL);

ALTER TABLE BB12XAffExtRCPTest_THRESH ADD constraint PK_BB12XAffExtRCPTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_BB12XAffExtRCPTest_THRESH ON BB12XAffExtRCPTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_BB12XAffExtRCPTest ON BB12XAffExtRCPTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_BB12XAffExtRCPTest ON BB12XAffExtRCPTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE BB12XAffIntSvcTest CASCADE CONSTRAINTS;
CREATE TABLE BB12XAffIntSvcTest(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
TRANSACTIONWAITINGTOSENT		Number(20,4) NOT NULL,
TRANSACTIONWAITINGTOSENT_ST		varchar2(32) NOT NULL,
DATARECEIVEDOVERRCPCONN			Number(20,4) NOT NULL,
DATARECEIVEDOVERRCPCONN_ST		varchar2(32) NOT NULL,
DATATRANSMITOVERRCPCONN			Number(20,4) NOT NULL,
DATATRANSMITOVERRCPCONN_ST		varchar2(32) NOT NULL,
TRANSACRECEIVEDOVERRCP			Number(20,4) NOT NULL,
TRANSACRECEIVEDOVERRCP_ST		varchar2(32) NOT NULL,
TRANSACSENTOVERRCP				Number(20,4) NOT NULL,
TRANSACSENTOVERRCP_ST			varchar2(32) NOT NULL);

CREATE INDEX IDX_BB12XAffIntSvcTest ON BB12XAffIntSvcTest(MSMT_TIME);
ALTER TABLE BB12XAffIntSvcTest ADD constraint PK_BB12XAffIntSvcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE BB12XAffIntSvcTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE BB12XAffIntSvcTest_TREND(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
PERIOD							varchar2(32),
TRANSACTIONWAITINGTOSENT_MIN	Number(20,4) NOT NULL,
TRANSACTIONWAITINGTOSENT_MAX	Number(20,4) NOT NULL,
TRANSACTIONWAITINGTOSENT_STCNT	varchar2(32) NOT NULL,
DATARECEIVEDOVERRCPCONN_MIN		Number(20,4) NOT NULL,
DATARECEIVEDOVERRCPCONN_MAX		Number(20,4) NOT NULL,
DATARECEIVEDOVERRCPCONN_STCNT	varchar2(32) NOT NULL,
DATATRANSMITOVERRCPCONN_MIN		Number(20,4) NOT NULL,
DATATRANSMITOVERRCPCONN_MAX		Number(20,4) NOT NULL,
DATATRANSMITOVERRCPCONN_STCNT	varchar2(32) NOT NULL,
TRANSACRECEIVEDOVERRCP_MIN		Number(20,4) NOT NULL,
TRANSACRECEIVEDOVERRCP_MAX		Number(20,4) NOT NULL,
TRANSACRECEIVEDOVERRCP_STCNT	varchar2(32) NOT NULL,
TRANSACSENTOVERRCP_MIN			Number(20,4) NOT NULL,
TRANSACSENTOVERRCP_MAX			Number(20,4) NOT NULL,
TRANSACSENTOVERRCP_STCNT		varchar2(32) NOT NULL);

ALTER TABLE BB12XAffIntSvcTest_TREND ADD constraint PK_BB12XAffIntSvcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BB12XAffIntSvcTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE BB12XAffIntSvcTest_THRESH(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME_START					date,
MSMT_TIME_END					date,
TRANSACTIONWAITINGTOSENT_MIN	VARCHAR2(256) NOT NULL,
TRANSACTIONWAITINGTOSENT_MAX	VARCHAR2(256) NOT NULL,
DATARECEIVEDOVERRCPCONN_MIN		VARCHAR2(256) NOT NULL,
DATARECEIVEDOVERRCPCONN_MAX		VARCHAR2(256) NOT NULL,
DATATRANSMITOVERRCPCONN_MIN		VARCHAR2(256) NOT NULL,
DATATRANSMITOVERRCPCONN_MAX		VARCHAR2(256) NOT NULL,
TRANSACRECEIVEDOVERRCP_MIN		VARCHAR2(256) NOT NULL,
TRANSACRECEIVEDOVERRCP_MAX		VARCHAR2(256) NOT NULL,
TRANSACSENTOVERRCP_MIN			VARCHAR2(256) NOT NULL,
TRANSACSENTOVERRCP_MAX			VARCHAR2(256) NOT NULL);

ALTER TABLE BB12XAffIntSvcTest_THRESH ADD constraint PK_BB12XAffIntSvcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_BB12XAffIntSvcTest_THRESH ON BB12XAffIntSvcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_BB12XAffIntSvcTest ON BB12XAffIntSvcTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_BB12XAffIntSvcTest ON BB12XAffIntSvcTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE BB12XAffManRcpTest CASCADE CONSTRAINTS;
CREATE TABLE BB12XAffManRcpTest(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
BYTESRECEIVEDOVERRCPCONN		Number(20,4) NOT NULL,
BYTESRECEIVEDOVERRCPCONN_ST		varchar2(32) NOT NULL,
BYTESSENTOVERRCPCONN			Number(20,4) NOT NULL,
BYTESSENTOVERRCPCONN_ST			varchar2(32) NOT NULL,
TRANSACRCVDOVERRCPCONN			Number(20,4) NOT NULL,
TRANSACRCVDOVERRCPCONN_ST		varchar2(32) NOT NULL,
TRANSACSENTOVERRCPCONN			Number(20,4) NOT NULL,
TRANSACSENTOVERRCPCONN_ST		varchar2(32) NOT NULL,
EXTERNALRCPCONN					Number(20,4) NOT NULL,
EXTERNALRCPCONN_ST				varchar2(32) NOT NULL,
INTERNALSERVERCONN				Number(20,4) NOT NULL,
INTERNALSERVERCONN_ST			varchar2(32) NOT NULL);

CREATE INDEX IDX_BB12XAffManRcpTest ON BB12XAffManRcpTest(MSMT_TIME);
ALTER TABLE BB12XAffManRcpTest ADD constraint PK_BB12XAffManRcpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE BB12XAffManRcpTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE BB12XAffManRcpTest_TREND(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME						date,
PERIOD							varchar2(32),
BYTESRECEIVEDOVERRCPCONN_MIN	Number(20,4) NOT NULL,
BYTESRECEIVEDOVERRCPCONN_MAX	Number(20,4) NOT NULL,
BYTESRECEIVEDOVERRCPCONN_STCNT	varchar2(32) NOT NULL,
BYTESSENTOVERRCPCONN_MIN		Number(20,4) NOT NULL,
BYTESSENTOVERRCPCONN_MAX		Number(20,4) NOT NULL,
BYTESSENTOVERRCPCONN_STCNT		varchar2(32) NOT NULL,
TRANSACRCVDOVERRCPCONN_MIN		Number(20,4) NOT NULL,
TRANSACRCVDOVERRCPCONN_MAX		Number(20,4) NOT NULL,
TRANSACRCVDOVERRCPCONN_STCNT	varchar2(32) NOT NULL,
TRANSACSENTOVERRCPCONN_MIN		Number(20,4) NOT NULL,
TRANSACSENTOVERRCPCONN_MAX		Number(20,4) NOT NULL,
TRANSACSENTOVERRCPCONN_STCNT	varchar2(32) NOT NULL,
EXTERNALRCPCONN_MIN				Number(20,4) NOT NULL,
EXTERNALRCPCONN_MAX				Number(20,4) NOT NULL,
EXTERNALRCPCONN_STCNT			varchar2(32) NOT NULL,
INTERNALSERVERCONN_MIN			Number(20,4) NOT NULL,
INTERNALSERVERCONN_MAX			Number(20,4) NOT NULL,
INTERNALSERVERCONN_STCNT		varchar2(32) NOT NULL);

ALTER TABLE BB12XAffManRcpTest_TREND ADD constraint PK_BB12XAffManRcpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE BB12XAffManRcpTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE BB12XAffManRcpTest_THRESH(
TRGT_HOST						varchar2(32),
PORT_NO							varchar2(32),
SITE_NAME						varchar2(64),
INFO							varchar2(128),
MSMT_HOST						varchar2(32),
MSMT_TIME_START					date,
MSMT_TIME_END					date,
BYTESRECEIVEDOVERRCPCONN_MIN	VARCHAR2(256) NOT NULL,
BYTESRECEIVEDOVERRCPCONN_MAX	VARCHAR2(256) NOT NULL,
BYTESSENTOVERRCPCONN_MIN		VARCHAR2(256) NOT NULL,
BYTESSENTOVERRCPCONN_MAX		VARCHAR2(256) NOT NULL,
TRANSACRCVDOVERRCPCONN_MIN		VARCHAR2(256) NOT NULL,
TRANSACRCVDOVERRCPCONN_MAX		VARCHAR2(256) NOT NULL,
TRANSACSENTOVERRCPCONN_MIN		VARCHAR2(256) NOT NULL,
TRANSACSENTOVERRCPCONN_MAX		VARCHAR2(256) NOT NULL,
EXTERNALRCPCONN_MIN				VARCHAR2(256) NOT NULL,
EXTERNALRCPCONN_MAX				VARCHAR2(256) NOT NULL,
INTERNALSERVERCONN_MIN			VARCHAR2(256) NOT NULL,
INTERNALSERVERCONN_MAX			VARCHAR2(256) NOT NULL);

ALTER TABLE BB12XAffManRcpTest_THRESH ADD constraint PK_BB12XAffManRcpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_BB12XAffManRcpTest_THRESH ON BB12XAffManRcpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_BB12XAffManRcpTest ON BB12XAffManRcpTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_BB12XAffManRcpTest ON BB12XAffManRcpTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE TPDLUNCapctyTest CASCADE CONSTRAINTS;
CREATE TABLE TPDLUNCapctyTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
VOLUMESIZE Number(20,4) NOT NULL,
VOLUMESIZE_ST varchar2(32) NOT NULL,
ADMINUSED Number(20,4) NOT NULL,
ADMINUSED_ST varchar2(32) NOT NULL,
SNAPUSED Number(20,4) NOT NULL,
SNAPUSED_ST varchar2(32) NOT NULL,
SNAPUSEDPCT Number(20,4) NOT NULL,
SNAPUSEDPCT_ST varchar2(32) NOT NULL,
USERUSED Number(20,4) NOT NULL,
USERUSED_ST varchar2(32) NOT NULL,
USERUSEDPCT Number(20,4) NOT NULL,
USERUSEDPCT_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_TPDLUNCapctyTest ON TPDLUNCapctyTest(MSMT_TIME);
ALTER TABLE TPDLUNCapctyTest ADD constraint PK_TPDLUNCapctyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TPDLUNCapctyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE TPDLUNCapctyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
VOLUMESIZE_MIN Number(20,4) NOT NULL,
VOLUMESIZE_MAX Number(20,4) NOT NULL,
VOLUMESIZE_STCNT varchar2(32) NOT NULL,
ADMINUSED_MIN Number(20,4) NOT NULL,
ADMINUSED_MAX Number(20,4) NOT NULL,
ADMINUSED_STCNT varchar2(32) NOT NULL,
SNAPUSED_MIN Number(20,4) NOT NULL,
SNAPUSED_MAX Number(20,4) NOT NULL,
SNAPUSED_STCNT varchar2(32) NOT NULL,
SNAPUSEDPCT_MIN Number(20,4) NOT NULL,
SNAPUSEDPCT_MAX Number(20,4) NOT NULL,
SNAPUSEDPCT_STCNT varchar2(32) NOT NULL,
USERUSED_MIN Number(20,4) NOT NULL,
USERUSED_MAX Number(20,4) NOT NULL,
USERUSED_STCNT varchar2(32) NOT NULL,
USERUSEDPCT_MIN Number(20,4) NOT NULL,
USERUSEDPCT_MAX Number(20,4) NOT NULL,
USERUSEDPCT_STCNT varchar2(32) NOT NULL);

ALTER TABLE TPDLUNCapctyTest_TREND ADD constraint PK_TPDLUNCapctyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TPDLUNCapctyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TPDLUNCapctyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
VOLUMESIZE_MIN VARCHAR2(256) NOT NULL,
VOLUMESIZE_MAX VARCHAR2(256) NOT NULL,
ADMINUSED_MIN VARCHAR2(256) NOT NULL,
ADMINUSED_MAX VARCHAR2(256) NOT NULL,
SNAPUSED_MIN VARCHAR2(256) NOT NULL,
SNAPUSED_MAX VARCHAR2(256) NOT NULL,
SNAPUSEDPCT_MIN VARCHAR2(256) NOT NULL,
SNAPUSEDPCT_MAX VARCHAR2(256) NOT NULL,
USERUSED_MIN VARCHAR2(256) NOT NULL,
USERUSED_MAX VARCHAR2(256) NOT NULL,
USERUSEDPCT_MIN VARCHAR2(256) NOT NULL,
USERUSEDPCT_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE TPDLUNCapctyTest_THRESH ADD constraint PK_TPDLUNCapctyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TPDLUNCapctyTest_THRESH ON TPDLUNCapctyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TPDLUNCapctyTest ON TPDLUNCapctyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TPDLUNCapctyTest ON TPDLUNCapctyTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE TPDPhyDisCapTest CASCADE CONSTRAINTS;
CREATE TABLE TPDPhyDisCapTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
STATE Number(20,4) NOT NULL,
STATE_ST varchar2(32) NOT NULL,
TOTALCAPACITY Number(20,4) NOT NULL,
TOTALCAPACITY_ST varchar2(32) NOT NULL,
FREECAPACITY Number(20,4) NOT NULL,
FREECAPACITY_ST varchar2(32) NOT NULL,
USEDCAPACITY Number(20,4) NOT NULL,
USEDCAPACITY_ST varchar2(32) NOT NULL,
FREECAPACITYPCT Number(20,4) NOT NULL,
FREECAPACITYPCT_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_TPDPhyDisCapTest ON TPDPhyDisCapTest(MSMT_TIME);
ALTER TABLE TPDPhyDisCapTest ADD constraint PK_TPDPhyDisCapTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE TPDPhyDisCapTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE TPDPhyDisCapTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
STATE_MIN Number(20,4) NOT NULL,
STATE_MAX Number(20,4) NOT NULL,
STATE_STCNT varchar2(32) NOT NULL,
TOTALCAPACITY_MIN Number(20,4) NOT NULL,
TOTALCAPACITY_MAX Number(20,4) NOT NULL,
TOTALCAPACITY_STCNT varchar2(32) NOT NULL,
FREECAPACITY_MIN Number(20,4) NOT NULL,
FREECAPACITY_MAX Number(20,4) NOT NULL,
FREECAPACITY_STCNT varchar2(32) NOT NULL,
USEDCAPACITY_MIN Number(20,4) NOT NULL,
USEDCAPACITY_MAX Number(20,4) NOT NULL,
USEDCAPACITY_STCNT varchar2(32) NOT NULL,
FREECAPACITYPCT_MIN Number(20,4) NOT NULL,
FREECAPACITYPCT_MAX Number(20,4) NOT NULL,
FREECAPACITYPCT_STCNT varchar2(32) NOT NULL);

ALTER TABLE TPDPhyDisCapTest_TREND ADD constraint PK_TPDPhyDisCapTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE TPDPhyDisCapTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE TPDPhyDisCapTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
STATE_MIN VARCHAR2(256) NOT NULL,
STATE_MAX VARCHAR2(256) NOT NULL,
TOTALCAPACITY_MIN VARCHAR2(256) NOT NULL,
TOTALCAPACITY_MAX VARCHAR2(256) NOT NULL,
FREECAPACITY_MIN VARCHAR2(256) NOT NULL,
FREECAPACITY_MAX VARCHAR2(256) NOT NULL,
USEDCAPACITY_MIN VARCHAR2(256) NOT NULL,
USEDCAPACITY_MAX VARCHAR2(256) NOT NULL,
FREECAPACITYPCT_MIN VARCHAR2(256) NOT NULL,
FREECAPACITYPCT_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE TPDPhyDisCapTest_THRESH ADD constraint PK_TPDPhyDisCapTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_TPDPhyDisCapTest_THRESH ON TPDPhyDisCapTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_TPDPhyDisCapTest ON TPDPhyDisCapTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_TPDPhyDisCapTest ON TPDPhyDisCapTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMStrmsByUsrTest CASCADE CONSTRAINTS;
CREATE TABLE MTMStrmsByUsrTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TotStrms Number(20,4) NOT NULL,
TotStrms_ST varchar2(32) NOT NULL,
TotGdStrms Number(20,4) NOT NULL,
TotGdStrms_ST varchar2(32) NOT NULL,
GdAdoStrms Number(20,4) NOT NULL,
GdAdoStrms_ST varchar2(32) NOT NULL,
GdVdoStrms Number(20,4) NOT NULL,
GdVdoStrms_ST varchar2(32) NOT NULL,
GdVbsStrms Number(20,4) NOT NULL,
GdVbsStrms_ST varchar2(32) NOT NULL,
GdInNtwkStrms Number(20,4) NOT NULL,
GdInNtwkStrms_ST varchar2(32) NOT NULL,
GdExNtwkStrms Number(20,4) NOT NULL,
GdExNtwkStrms_ST varchar2(32) NOT NULL,
TotPrStrms Number(20,4) NOT NULL,
TotPrStrms_ST varchar2(32) NOT NULL,
PrAdoStrms Number(20,4) NOT NULL,
PrAdoStrms_ST varchar2(32) NOT NULL,
PrVdoStrms Number(20,4) NOT NULL,
PrVdoStrms_ST varchar2(32) NOT NULL,
PrVbsStrms Number(20,4) NOT NULL,
PrVbsStrms_ST varchar2(32) NOT NULL,
PrInNtwkStrms Number(20,4) NOT NULL,
PrInNtwkStrms_ST varchar2(32) NOT NULL,
PrExNtwkStrms Number(20,4) NOT NULL,
PrExNtwkStrms_ST varchar2(32) NOT NULL,
TotUnclsStrms Number(20,4) NOT NULL,
TotUnclsStrms_ST varchar2(32) NOT NULL,
TotMOSVal Number(20,4) NOT NULL,
TotMOSVal_ST varchar2(32) NOT NULL,
TotVdoFrmRatAvg Number(20,4) NOT NULL,
TotVdoFrmRatAvg_ST varchar2(32) NOT NULL,
PrAdoJitter Number(20,4) NOT NULL,
PrAdoJitter_ST varchar2(32) NOT NULL,
PrAdoPktLos Number(20,4) NOT NULL,
PrAdoPktLos_ST varchar2(32) NOT NULL,
PrAdoDegrad Number(20,4) NOT NULL,
PrAdoDegrad_ST varchar2(32) NOT NULL,
PrAdoRndTrip Number(20,4) NOT NULL,
PrAdoRndTrip_ST varchar2(32) NOT NULL,
PrAdoCnRatio Number(20,4) NOT NULL,
PrAdoCnRatio_ST varchar2(32) NOT NULL,
PrVdoFECPLR Number(20,4) NOT NULL,
PrVdoFECPLR_ST varchar2(32) NOT NULL,
PrVdoLFrmLos Number(20,4) NOT NULL,
PrVdoLFrmLos_ST varchar2(32) NOT NULL,
PrVdoFrmRat Number(20,4) NOT NULL,
PrVdoFrmRat_ST varchar2(32) NOT NULL,
PrVbsFECPLR Number(20,4) NOT NULL,
PrVbsFECPLR_ST varchar2(32) NOT NULL,
PrVbsLFrmLos Number(20,4) NOT NULL,
PrVbsLFrmLos_ST varchar2(32) NOT NULL,
PrVbsFrmRat Number(20,4) NOT NULL,
PrVbsFrmRat_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMStrmsByUsrTest ON MTMStrmsByUsrTest(MSMT_TIME);
ALTER TABLE MTMStrmsByUsrTest ADD constraint PK_MTMStrmsByUsrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMStrmsByUsrTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMStrmsByUsrTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TotStrms_MIN Number(20,4) NOT NULL,
TotStrms_MAX Number(20,4) NOT NULL,
TotStrms_STCNT varchar2(32) NOT NULL,
TotGdStrms_MIN Number(20,4) NOT NULL,
TotGdStrms_MAX Number(20,4) NOT NULL,
TotGdStrms_STCNT varchar2(32) NOT NULL,
GdAdoStrms_MIN Number(20,4) NOT NULL,
GdAdoStrms_MAX Number(20,4) NOT NULL,
GdAdoStrms_STCNT varchar2(32) NOT NULL,
GdVdoStrms_MIN Number(20,4) NOT NULL,
GdVdoStrms_MAX Number(20,4) NOT NULL,
GdVdoStrms_STCNT varchar2(32) NOT NULL,
GdVbsStrms_MIN Number(20,4) NOT NULL,
GdVbsStrms_MAX Number(20,4) NOT NULL,
GdVbsStrms_STCNT varchar2(32) NOT NULL,
GdInNtwkStrms_MIN Number(20,4) NOT NULL,
GdInNtwkStrms_MAX Number(20,4) NOT NULL,
GdInNtwkStrms_STCNT varchar2(32) NOT NULL,
GdExNtwkStrms_MIN Number(20,4) NOT NULL,
GdExNtwkStrms_MAX Number(20,4) NOT NULL,
GdExNtwkStrms_STCNT varchar2(32) NOT NULL,
TotPrStrms_MIN Number(20,4) NOT NULL,
TotPrStrms_MAX Number(20,4) NOT NULL,
TotPrStrms_STCNT varchar2(32) NOT NULL,
PrAdoStrms_MIN Number(20,4) NOT NULL,
PrAdoStrms_MAX Number(20,4) NOT NULL,
PrAdoStrms_STCNT varchar2(32) NOT NULL,
PrVdoStrms_MIN Number(20,4) NOT NULL,
PrVdoStrms_MAX Number(20,4) NOT NULL,
PrVdoStrms_STCNT varchar2(32) NOT NULL,
PrVbsStrms_MIN Number(20,4) NOT NULL,
PrVbsStrms_MAX Number(20,4) NOT NULL,
PrVbsStrms_STCNT varchar2(32) NOT NULL,
PrInNtwkStrms_MIN Number(20,4) NOT NULL,
PrInNtwkStrms_MAX Number(20,4) NOT NULL,
PrInNtwkStrms_STCNT varchar2(32) NOT NULL,
PrExNtwkStrms_MIN Number(20,4) NOT NULL,
PrExNtwkStrms_MAX Number(20,4) NOT NULL,
PrExNtwkStrms_STCNT varchar2(32) NOT NULL,
TotUnclsStrms_MIN Number(20,4) NOT NULL,
TotUnclsStrms_MAX Number(20,4) NOT NULL,
TotUnclsStrms_STCNT varchar2(32) NOT NULL,
TotMOSVal_MIN Number(20,4) NOT NULL,
TotMOSVal_MAX Number(20,4) NOT NULL,
TotMOSVal_STCNT varchar2(32) NOT NULL,
TotVdoFrmRatAvg_MIN Number(20,4) NOT NULL,
TotVdoFrmRatAvg_MAX Number(20,4) NOT NULL,
TotVdoFrmRatAvg_STCNT varchar2(32) NOT NULL,
PrAdoJitter_MIN Number(20,4) NOT NULL,
PrAdoJitter_MAX Number(20,4) NOT NULL,
PrAdoJitter_STCNT varchar2(32) NOT NULL,
PrAdoPktLos_MIN Number(20,4) NOT NULL,
PrAdoPktLos_MAX Number(20,4) NOT NULL,
PrAdoPktLos_STCNT varchar2(32) NOT NULL,
PrAdoDegrad_MIN Number(20,4) NOT NULL,
PrAdoDegrad_MAX Number(20,4) NOT NULL,
PrAdoDegrad_STCNT varchar2(32) NOT NULL,
PrAdoRndTrip_MIN Number(20,4) NOT NULL,
PrAdoRndTrip_MAX Number(20,4) NOT NULL,
PrAdoRndTrip_STCNT varchar2(32) NOT NULL,
PrAdoCnRatio_MIN Number(20,4) NOT NULL,
PrAdoCnRatio_MAX Number(20,4) NOT NULL,
PrAdoCnRatio_STCNT varchar2(32) NOT NULL,
PrVdoFECPLR_MIN Number(20,4) NOT NULL,
PrVdoFECPLR_MAX Number(20,4) NOT NULL,
PrVdoFECPLR_STCNT varchar2(32) NOT NULL,
PrVdoLFrmLos_MIN Number(20,4) NOT NULL,
PrVdoLFrmLos_MAX Number(20,4) NOT NULL,
PrVdoLFrmLos_STCNT varchar2(32) NOT NULL,
PrVdoFrmRat_MIN Number(20,4) NOT NULL,
PrVdoFrmRat_MAX Number(20,4) NOT NULL,
PrVdoFrmRat_STCNT varchar2(32) NOT NULL,
PrVbsFECPLR_MIN Number(20,4) NOT NULL,
PrVbsFECPLR_MAX Number(20,4) NOT NULL,
PrVbsFECPLR_STCNT varchar2(32) NOT NULL,
PrVbsLFrmLos_MIN Number(20,4) NOT NULL,
PrVbsLFrmLos_MAX Number(20,4) NOT NULL,
PrVbsLFrmLos_STCNT varchar2(32) NOT NULL,
PrVbsFrmRat_MIN Number(20,4) NOT NULL,
PrVbsFrmRat_MAX Number(20,4) NOT NULL,
PrVbsFrmRat_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMStrmsByUsrTest_TREND ADD constraint PK_MTMStrmsByUsrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMStrmsByUsrTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMStrmsByUsrTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TotStrms_MIN varchar2(256) NOT NULL,
TotStrms_MAX varchar2(256) NOT NULL,
TotGdStrms_MIN varchar2(256) NOT NULL,
TotGdStrms_MAX varchar2(256) NOT NULL,
GdAdoStrms_MIN varchar2(256) NOT NULL,
GdAdoStrms_MAX varchar2(256) NOT NULL,
GdVdoStrms_MIN varchar2(256) NOT NULL,
GdVdoStrms_MAX varchar2(256) NOT NULL,
GdVbsStrms_MIN varchar2(256) NOT NULL,
GdVbsStrms_MAX varchar2(256) NOT NULL,
GdInNtwkStrms_MIN varchar2(256) NOT NULL,
GdInNtwkStrms_MAX varchar2(256) NOT NULL,
GdExNtwkStrms_MIN varchar2(256) NOT NULL,
GdExNtwkStrms_MAX varchar2(256) NOT NULL,
TotPrStrms_MIN varchar2(256) NOT NULL,
TotPrStrms_MAX varchar2(256) NOT NULL,
PrAdoStrms_MIN varchar2(256) NOT NULL,
PrAdoStrms_MAX varchar2(256) NOT NULL,
PrVdoStrms_MIN varchar2(256) NOT NULL,
PrVdoStrms_MAX varchar2(256) NOT NULL,
PrVbsStrms_MIN varchar2(256) NOT NULL,
PrVbsStrms_MAX varchar2(256) NOT NULL,
PrInNtwkStrms_MIN varchar2(256) NOT NULL,
PrInNtwkStrms_MAX varchar2(256) NOT NULL,
PrExNtwkStrms_MIN varchar2(256) NOT NULL,
PrExNtwkStrms_MAX varchar2(256) NOT NULL,
TotUnclsStrms_MIN varchar2(256) NOT NULL,
TotUnclsStrms_MAX varchar2(256) NOT NULL,
TotMOSVal_MIN varchar2(256) NOT NULL,
TotMOSVal_MAX varchar2(256) NOT NULL,
TotVdoFrmRatAvg_MIN varchar2(256) NOT NULL,
TotVdoFrmRatAvg_MAX varchar2(256) NOT NULL,
PrAdoJitter_MIN varchar2(256) NOT NULL,
PrAdoJitter_MAX varchar2(256) NOT NULL,
PrAdoPktLos_MIN varchar2(256) NOT NULL,
PrAdoPktLos_MAX varchar2(256) NOT NULL,
PrAdoDegrad_MIN varchar2(256) NOT NULL,
PrAdoDegrad_MAX varchar2(256) NOT NULL,
PrAdoRndTrip_MIN varchar2(256) NOT NULL,
PrAdoRndTrip_MAX varchar2(256) NOT NULL,
PrAdoCnRatio_MIN varchar2(256) NOT NULL,
PrAdoCnRatio_MAX varchar2(256) NOT NULL,
PrVdoFECPLR_MIN varchar2(256) NOT NULL,
PrVdoFECPLR_MAX varchar2(256) NOT NULL,
PrVdoLFrmLos_MIN varchar2(256) NOT NULL,
PrVdoLFrmLos_MAX varchar2(256) NOT NULL,
PrVdoFrmRat_MIN varchar2(256) NOT NULL,
PrVdoFrmRat_MAX varchar2(256) NOT NULL,
PrVbsFECPLR_MIN varchar2(256) NOT NULL,
PrVbsFECPLR_MAX varchar2(256) NOT NULL,
PrVbsLFrmLos_MIN varchar2(256) NOT NULL,
PrVbsLFrmLos_MAX varchar2(256) NOT NULL,
PrVbsFrmRat_MIN varchar2(256) NOT NULL,
PrVbsFrmRat_MAX varchar2(256) NOT NULL
);

ALTER TABLE MTMStrmsByUsrTest_THRESH ADD constraint PK_MTMStrmsByUsrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMStrmsByUsrTest_THRESH ON MTMStrmsByUsrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMStrmsByUsrTest ON MTMStrmsByUsrTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMStrmsByUsrTest ON MTMStrmsByUsrTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MTMWHStrmsByUsrTest CASCADE CONSTRAINTS;
CREATE TABLE MTMWHStrmsByUsrTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TotStrms Number(20,4) NOT NULL,
TotStrms_ST varchar2(32) NOT NULL,
TotGdStrms Number(20,4) NOT NULL,
TotGdStrms_ST varchar2(32) NOT NULL,
GdAdoStrms Number(20,4) NOT NULL,
GdAdoStrms_ST varchar2(32) NOT NULL,
GdVdoStrms Number(20,4) NOT NULL,
GdVdoStrms_ST varchar2(32) NOT NULL,
GdVbsStrms Number(20,4) NOT NULL,
GdVbsStrms_ST varchar2(32) NOT NULL,
GdInNtwkStrms Number(20,4) NOT NULL,
GdInNtwkStrms_ST varchar2(32) NOT NULL,
GdExNtwkStrms Number(20,4) NOT NULL,
GdExNtwkStrms_ST varchar2(32) NOT NULL,
TotPrStrms Number(20,4) NOT NULL,
TotPrStrms_ST varchar2(32) NOT NULL,
PrAdoStrms Number(20,4) NOT NULL,
PrAdoStrms_ST varchar2(32) NOT NULL,
PrVdoStrms Number(20,4) NOT NULL,
PrVdoStrms_ST varchar2(32) NOT NULL,
PrVbsStrms Number(20,4) NOT NULL,
PrVbsStrms_ST varchar2(32) NOT NULL,
PrInNtwkStrms Number(20,4) NOT NULL,
PrInNtwkStrms_ST varchar2(32) NOT NULL,
PrExNtwkStrms Number(20,4) NOT NULL,
PrExNtwkStrms_ST varchar2(32) NOT NULL,
TotUnclsStrms Number(20,4) NOT NULL,
TotUnclsStrms_ST varchar2(32) NOT NULL,
TotMOSVal Number(20,4) NOT NULL,
TotMOSVal_ST varchar2(32) NOT NULL,
TotVdoFrmRatAvg Number(20,4) NOT NULL,
TotVdoFrmRatAvg_ST varchar2(32) NOT NULL,
PrAdoJitter Number(20,4) NOT NULL,
PrAdoJitter_ST varchar2(32) NOT NULL,
PrAdoPktLos Number(20,4) NOT NULL,
PrAdoPktLos_ST varchar2(32) NOT NULL,
PrAdoDegrad Number(20,4) NOT NULL,
PrAdoDegrad_ST varchar2(32) NOT NULL,
PrAdoRndTrip Number(20,4) NOT NULL,
PrAdoRndTrip_ST varchar2(32) NOT NULL,
PrAdoCnRatio Number(20,4) NOT NULL,
PrAdoCnRatio_ST varchar2(32) NOT NULL,
PrVdoFECPLR Number(20,4) NOT NULL,
PrVdoFECPLR_ST varchar2(32) NOT NULL,
PrVdoLFrmLos Number(20,4) NOT NULL,
PrVdoLFrmLos_ST varchar2(32) NOT NULL,
PrVdoFrmRat Number(20,4) NOT NULL,
PrVdoFrmRat_ST varchar2(32) NOT NULL,
PrVbsFECPLR Number(20,4) NOT NULL,
PrVbsFECPLR_ST varchar2(32) NOT NULL,
PrVbsLFrmLos Number(20,4) NOT NULL,
PrVbsLFrmLos_ST varchar2(32) NOT NULL,
PrVbsFrmRat Number(20,4) NOT NULL,
PrVbsFrmRat_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMWHStrmsByUsrTest ON MTMWHStrmsByUsrTest(MSMT_TIME);
ALTER TABLE MTMWHStrmsByUsrTest ADD constraint PK_MTMWHStrmsByUsrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMWHStrmsByUsrTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMWHStrmsByUsrTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TotStrms_MIN Number(20,4) NOT NULL,
TotStrms_MAX Number(20,4) NOT NULL,
TotStrms_STCNT varchar2(32) NOT NULL,
TotGdStrms_MIN Number(20,4) NOT NULL,
TotGdStrms_MAX Number(20,4) NOT NULL,
TotGdStrms_STCNT varchar2(32) NOT NULL,
GdAdoStrms_MIN Number(20,4) NOT NULL,
GdAdoStrms_MAX Number(20,4) NOT NULL,
GdAdoStrms_STCNT varchar2(32) NOT NULL,
GdVdoStrms_MIN Number(20,4) NOT NULL,
GdVdoStrms_MAX Number(20,4) NOT NULL,
GdVdoStrms_STCNT varchar2(32) NOT NULL,
GdVbsStrms_MIN Number(20,4) NOT NULL,
GdVbsStrms_MAX Number(20,4) NOT NULL,
GdVbsStrms_STCNT varchar2(32) NOT NULL,
GdInNtwkStrms_MIN Number(20,4) NOT NULL,
GdInNtwkStrms_MAX Number(20,4) NOT NULL,
GdInNtwkStrms_STCNT varchar2(32) NOT NULL,
GdExNtwkStrms_MIN Number(20,4) NOT NULL,
GdExNtwkStrms_MAX Number(20,4) NOT NULL,
GdExNtwkStrms_STCNT varchar2(32) NOT NULL,
TotPrStrms_MIN Number(20,4) NOT NULL,
TotPrStrms_MAX Number(20,4) NOT NULL,
TotPrStrms_STCNT varchar2(32) NOT NULL,
PrAdoStrms_MIN Number(20,4) NOT NULL,
PrAdoStrms_MAX Number(20,4) NOT NULL,
PrAdoStrms_STCNT varchar2(32) NOT NULL,
PrVdoStrms_MIN Number(20,4) NOT NULL,
PrVdoStrms_MAX Number(20,4) NOT NULL,
PrVdoStrms_STCNT varchar2(32) NOT NULL,
PrVbsStrms_MIN Number(20,4) NOT NULL,
PrVbsStrms_MAX Number(20,4) NOT NULL,
PrVbsStrms_STCNT varchar2(32) NOT NULL,
PrInNtwkStrms_MIN Number(20,4) NOT NULL,
PrInNtwkStrms_MAX Number(20,4) NOT NULL,
PrInNtwkStrms_STCNT varchar2(32) NOT NULL,
PrExNtwkStrms_MIN Number(20,4) NOT NULL,
PrExNtwkStrms_MAX Number(20,4) NOT NULL,
PrExNtwkStrms_STCNT varchar2(32) NOT NULL,
TotUnclsStrms_MIN Number(20,4) NOT NULL,
TotUnclsStrms_MAX Number(20,4) NOT NULL,
TotUnclsStrms_STCNT varchar2(32) NOT NULL,
TotMOSVal_MIN Number(20,4) NOT NULL,
TotMOSVal_MAX Number(20,4) NOT NULL,
TotMOSVal_STCNT varchar2(32) NOT NULL,
TotVdoFrmRatAvg_MIN Number(20,4) NOT NULL,
TotVdoFrmRatAvg_MAX Number(20,4) NOT NULL,
TotVdoFrmRatAvg_STCNT varchar2(32) NOT NULL,
PrAdoJitter_MIN Number(20,4) NOT NULL,
PrAdoJitter_MAX Number(20,4) NOT NULL,
PrAdoJitter_STCNT varchar2(32) NOT NULL,
PrAdoPktLos_MIN Number(20,4) NOT NULL,
PrAdoPktLos_MAX Number(20,4) NOT NULL,
PrAdoPktLos_STCNT varchar2(32) NOT NULL,
PrAdoDegrad_MIN Number(20,4) NOT NULL,
PrAdoDegrad_MAX Number(20,4) NOT NULL,
PrAdoDegrad_STCNT varchar2(32) NOT NULL,
PrAdoRndTrip_MIN Number(20,4) NOT NULL,
PrAdoRndTrip_MAX Number(20,4) NOT NULL,
PrAdoRndTrip_STCNT varchar2(32) NOT NULL,
PrAdoCnRatio_MIN Number(20,4) NOT NULL,
PrAdoCnRatio_MAX Number(20,4) NOT NULL,
PrAdoCnRatio_STCNT varchar2(32) NOT NULL,
PrVdoFECPLR_MIN Number(20,4) NOT NULL,
PrVdoFECPLR_MAX Number(20,4) NOT NULL,
PrVdoFECPLR_STCNT varchar2(32) NOT NULL,
PrVdoLFrmLos_MIN Number(20,4) NOT NULL,
PrVdoLFrmLos_MAX Number(20,4) NOT NULL,
PrVdoLFrmLos_STCNT varchar2(32) NOT NULL,
PrVdoFrmRat_MIN Number(20,4) NOT NULL,
PrVdoFrmRat_MAX Number(20,4) NOT NULL,
PrVdoFrmRat_STCNT varchar2(32) NOT NULL,
PrVbsFECPLR_MIN Number(20,4) NOT NULL,
PrVbsFECPLR_MAX Number(20,4) NOT NULL,
PrVbsFECPLR_STCNT varchar2(32) NOT NULL,
PrVbsLFrmLos_MIN Number(20,4) NOT NULL,
PrVbsLFrmLos_MAX Number(20,4) NOT NULL,
PrVbsLFrmLos_STCNT varchar2(32) NOT NULL,
PrVbsFrmRat_MIN Number(20,4) NOT NULL,
PrVbsFrmRat_MAX Number(20,4) NOT NULL,
PrVbsFrmRat_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMWHStrmsByUsrTest_TREND ADD constraint PK_MTMWHStrmsByUsrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMWHStrmsByUsrTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMWHStrmsByUsrTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TotStrms_MIN varchar2(256) NOT NULL,
TotStrms_MAX varchar2(256) NOT NULL,
TotGdStrms_MIN varchar2(256) NOT NULL,
TotGdStrms_MAX varchar2(256) NOT NULL,
GdAdoStrms_MIN varchar2(256) NOT NULL,
GdAdoStrms_MAX varchar2(256) NOT NULL,
GdVdoStrms_MIN varchar2(256) NOT NULL,
GdVdoStrms_MAX varchar2(256) NOT NULL,
GdVbsStrms_MIN varchar2(256) NOT NULL,
GdVbsStrms_MAX varchar2(256) NOT NULL,
GdInNtwkStrms_MIN varchar2(256) NOT NULL,
GdInNtwkStrms_MAX varchar2(256) NOT NULL,
GdExNtwkStrms_MIN varchar2(256) NOT NULL,
GdExNtwkStrms_MAX varchar2(256) NOT NULL,
TotPrStrms_MIN varchar2(256) NOT NULL,
TotPrStrms_MAX varchar2(256) NOT NULL,
PrAdoStrms_MIN varchar2(256) NOT NULL,
PrAdoStrms_MAX varchar2(256) NOT NULL,
PrVdoStrms_MIN varchar2(256) NOT NULL,
PrVdoStrms_MAX varchar2(256) NOT NULL,
PrVbsStrms_MIN varchar2(256) NOT NULL,
PrVbsStrms_MAX varchar2(256) NOT NULL,
PrInNtwkStrms_MIN varchar2(256) NOT NULL,
PrInNtwkStrms_MAX varchar2(256) NOT NULL,
PrExNtwkStrms_MIN varchar2(256) NOT NULL,
PrExNtwkStrms_MAX varchar2(256) NOT NULL,
TotUnclsStrms_MIN varchar2(256) NOT NULL,
TotUnclsStrms_MAX varchar2(256) NOT NULL,
TotMOSVal_MIN varchar2(256) NOT NULL,
TotMOSVal_MAX varchar2(256) NOT NULL,
TotVdoFrmRatAvg_MIN varchar2(256) NOT NULL,
TotVdoFrmRatAvg_MAX varchar2(256) NOT NULL,
PrAdoJitter_MIN varchar2(256) NOT NULL,
PrAdoJitter_MAX varchar2(256) NOT NULL,
PrAdoPktLos_MIN varchar2(256) NOT NULL,
PrAdoPktLos_MAX varchar2(256) NOT NULL,
PrAdoDegrad_MIN varchar2(256) NOT NULL,
PrAdoDegrad_MAX varchar2(256) NOT NULL,
PrAdoRndTrip_MIN varchar2(256) NOT NULL,
PrAdoRndTrip_MAX varchar2(256) NOT NULL,
PrAdoCnRatio_MIN varchar2(256) NOT NULL,
PrAdoCnRatio_MAX varchar2(256) NOT NULL,
PrVdoFECPLR_MIN varchar2(256) NOT NULL,
PrVdoFECPLR_MAX varchar2(256) NOT NULL,
PrVdoLFrmLos_MIN varchar2(256) NOT NULL,
PrVdoLFrmLos_MAX varchar2(256) NOT NULL,
PrVdoFrmRat_MIN varchar2(256) NOT NULL,
PrVdoFrmRat_MAX varchar2(256) NOT NULL,
PrVbsFECPLR_MIN varchar2(256) NOT NULL,
PrVbsFECPLR_MAX varchar2(256) NOT NULL,
PrVbsLFrmLos_MIN varchar2(256) NOT NULL,
PrVbsLFrmLos_MAX varchar2(256) NOT NULL,
PrVbsFrmRat_MIN varchar2(256) NOT NULL,
PrVbsFrmRat_MAX varchar2(256) NOT NULL
);

ALTER TABLE MTMWHStrmsByUsrTest_THRESH ADD constraint PK_MTMWHStrmsByUsrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMWHStrmsByUsrTest_THRESH ON MTMWHStrmsByUsrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMWHStrmsByUsrTest ON MTMWHStrmsByUsrTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMWHStrmsByUsrTest ON MTMWHStrmsByUsrTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EXOMailFlowTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMailFlowTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
SEND_AUTH_STATUS		Number(20,4) NOT NULL,
SEND_AUTH_STATUS_ST		varchar2(32) NOT NULL,
SEND_AVAIL Number(20,4) NOT NULL,
SEND_AVAIL_ST varchar2(32) NOT NULL,
SENT_MSGS Number(20,4) NOT NULL,
SENT_MSGS_ST varchar2(32) NOT NULL,
FAILED_MSGS Number(20,4) NOT NULL,
FAILED_MSGS_ST varchar2(32) NOT NULL,
SENT_TIME Number(20,4) NOT NULL,
SENT_TIME_ST varchar2(32) NOT NULL,
SEND_TOTAL_SIM_TIME Number(20,4) NOT NULL,
SEND_TOTAL_SIM_TIME_ST varchar2(32) NOT NULL,
RECEIVE_AUTH_STATUS		Number(20,4) NOT NULL,
RECEIVE_AUTH_STATUS_ST		varchar2(32) NOT NULL,
RCVD_AVAIL		Number(20,4) NOT NULL,
RCVD_AVAIL_ST		varchar2(32) NOT NULL,
RCVD_MSGS		Number(20,4) NOT NULL,
RCVD_MSGS_ST		varchar2(32) NOT NULL,
RCVD_TIME		Number(20,4) NOT NULL,
RCVD_TIME_ST		varchar2(32) NOT NULL,
AVG_ROUNDTRIP_TIME		Number(20,4) NOT NULL,
AVG_ROUNDTRIP_TIME_ST		varchar2(32) NOT NULL,
MAX_ROUNDTRIP_TIME		Number(20,4) NOT NULL,
MAX_ROUNDTRIP_TIME_ST		varchar2(32) NOT NULL,
LAST_MAIL_TIME		Number(20,4) NOT NULL,
LAST_MAIL_TIME_ST		varchar2(32) NOT NULL,
RECEIVE_TOTAL_SIM_TIME		Number(20,4) NOT NULL,
RECEIVE_TOTAL_SIM_TIME_ST		varchar2(32) NOT NULL,
MISSING_ORDER		Number(20,4) NOT NULL,
MISSING_ORDER_ST		varchar2(32) NOT NULL);
CREATE INDEX IDX_EXOMailFlowTest ON EXOMailFlowTest(MSMT_TIME);
ALTER TABLE EXOMailFlowTest ADD constraint PK_EXOMailFlowTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailFlowTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMailFlowTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
SEND_AUTH_STATUS_MIN Number(20,4) NOT NULL,
SEND_AUTH_STATUS_MAX Number(20,4) NOT NULL,
SEND_AUTH_STATUS_STCNT varchar2(32) NOT NULL,
SEND_AVAIL_MIN Number(20,4) NOT NULL,
SEND_AVAIL_MAX Number(20,4) NOT NULL,
SEND_AVAIL_STCNT varchar2(32) NOT NULL,
SENT_MSGS_MIN Number(20,4) NOT NULL,
SENT_MSGS_MAX Number(20,4) NOT NULL,
SENT_MSGS_STCNT varchar2(32) NOT NULL,
FAILED_MSGS_MIN Number(20,4) NOT NULL,
FAILED_MSGS_MAX Number(20,4) NOT NULL,
FAILED_MSGS_STCNT varchar2(32) NOT NULL,
SENT_TIME_MIN Number(20,4) NOT NULL,
SENT_TIME_MAX Number(20,4) NOT NULL,
SENT_TIME_STCNT varchar2(32) NOT NULL,
SEND_TOTAL_SIM_TIME_MIN Number(20,4) NOT NULL,
SEND_TOTAL_SIM_TIME_MAX Number(20,4) NOT NULL,
SEND_TOTAL_SIM_TIME_STCNT varchar2(32) NOT NULL,
RECEIVE_AUTH_STATUS_MIN		Number(20,4) NOT NULL,
RECEIVE_AUTH_STATUS_MAX		Number(20,4) NOT NULL,
RECEIVE_AUTH_STATUS_STCNT	varchar2(32) NOT NULL,
RCVD_AVAIL_MIN		Number(20,4) NOT NULL,
RCVD_AVAIL_MAX		Number(20,4) NOT NULL,
RCVD_AVAIL_STCNT	varchar2(32) NOT NULL,
RCVD_MSGS_MIN		Number(20,4) NOT NULL,
RCVD_MSGS_MAX		Number(20,4) NOT NULL,
RCVD_MSGS_STCNT	    varchar2(32) NOT NULL,
RCVD_TIME_MIN		Number(20,4) NOT NULL,
RCVD_TIME_MAX		Number(20,4) NOT NULL,
RCVD_TIME_STCNT	    varchar2(32) NOT NULL,
AVG_ROUNDTRIP_TIME_MIN		Number(20,4) NOT NULL,
AVG_ROUNDTRIP_TIME_MAX		Number(20,4) NOT NULL,
AVG_ROUNDTRIP_TIME_STCNT	varchar2(32) NOT NULL,
MAX_ROUNDTRIP_TIME_MIN		Number(20,4) NOT NULL,
MAX_ROUNDTRIP_TIME_MAX		Number(20,4) NOT NULL,
MAX_ROUNDTRIP_TIME_STCNT	varchar2(32) NOT NULL,
LAST_MAIL_TIME_MIN		Number(20,4) NOT NULL,
LAST_MAIL_TIME_MAX		Number(20,4) NOT NULL,
LAST_MAIL_TIME_STCNT	varchar2(32) NOT NULL,
RECEIVE_TOTAL_SIM_TIME_MIN		Number(20,4) NOT NULL,
RECEIVE_TOTAL_SIM_TIME_MAX		Number(20,4) NOT NULL,
RECEIVE_TOTAL_SIM_TIME_STCNT	varchar2(32) NOT NULL,
MISSING_ORDER_MIN		Number(20,4) NOT NULL,
MISSING_ORDER_MAX		Number(20,4) NOT NULL,
MISSING_ORDER_STCNT		varchar2(32) NOT NULL);
ALTER TABLE EXOMailFlowTest_TREND ADD constraint PK_EXOMailFlowTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE EXOMailFlowTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMailFlowTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
SEND_AUTH_STATUS_MIN	VARCHAR2(256) NOT NULL,
SEND_AUTH_STATUS_MAX	VARCHAR2(256) NOT NULL,
SEND_AVAIL_MIN	VARCHAR2(256) NOT NULL,
SEND_AVAIL_MAX	VARCHAR2(256) NOT NULL,
SENT_MSGS_MIN	VARCHAR2(256) NOT NULL,
SENT_MSGS_MAX	VARCHAR2(256) NOT NULL,
FAILED_MSGS_MIN	VARCHAR2(256) NOT NULL,
FAILED_MSGS_MAX	VARCHAR2(256) NOT NULL,
SENT_TIME_MIN	VARCHAR2(256) NOT NULL,
SENT_TIME_MAX	VARCHAR2(256) NOT NULL,
SEND_TOTAL_SIM_TIME_MIN	VARCHAR2(256) NOT NULL,
SEND_TOTAL_SIM_TIME_MAX	VARCHAR2(256) NOT NULL,
RECEIVE_AUTH_STATUS_MIN		VARCHAR2(256) NOT NULL,
RECEIVE_AUTH_STATUS_MAX		VARCHAR2(256) NOT NULL,
RCVD_AVAIL_MIN		VARCHAR2(256) NOT NULL,
RCVD_AVAIL_MAX		VARCHAR2(256) NOT NULL,
RCVD_MSGS_MIN		VARCHAR2(256) NOT NULL,
RCVD_MSGS_MAX		VARCHAR2(256) NOT NULL,
RCVD_TIME_MIN		VARCHAR2(256) NOT NULL,
RCVD_TIME_MAX		VARCHAR2(256) NOT NULL,
AVG_ROUNDTRIP_TIME_MIN		VARCHAR2(256) NOT NULL,
AVG_ROUNDTRIP_TIME_MAX		VARCHAR2(256) NOT NULL,
MAX_ROUNDTRIP_TIME_MIN		VARCHAR2(256) NOT NULL,
MAX_ROUNDTRIP_TIME_MAX		VARCHAR2(256) NOT NULL,
LAST_MAIL_TIME_MIN		VARCHAR2(256) NOT NULL,
LAST_MAIL_TIME_MAX		VARCHAR2(256) NOT NULL,
RECEIVE_TOTAL_SIM_TIME_MIN		VARCHAR2(256) NOT NULL,
RECEIVE_TOTAL_SIM_TIME_MAX		VARCHAR2(256) NOT NULL,
MISSING_ORDER_MIN		VARCHAR2(256) NOT NULL,
MISSING_ORDER_MAX		VARCHAR2(256) NOT NULL);
ALTER TABLE EXOMailFlowTest_THRESH ADD constraint PK_EXOMailFlowTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMailFlowTest_THRESH ON EXOMailFlowTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailFlowTest ON EXOMailFlowTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailFlowTest ON EXOMailFlowTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MariaCluActTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
DELAYEDWRITERATE Number(20,4) NOT NULL,
DELAYEDWRITERATE_ST varchar2(32) NOT NULL,
DELAYEDERRORRATE Number(20,4) NOT NULL,
DELAYEDERRORRATE_ST varchar2(32) NOT NULL,
UPDATERATE Number(20,4) NOT NULL,
UPDATERATE_ST varchar2(32) NOT NULL,
INSERTRATE Number(20,4) NOT NULL,
INSERTRATE_ST varchar2(32) NOT NULL,
DELETIONRATE Number(20,4) NOT NULL,
DELETIONRATE_ST varchar2(32) NOT NULL,
FLUSHRATE Number(20,4) NOT NULL,
FLUSHRATE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluActTest ON MariaCluActTest(MSMT_TIME);
ALTER TABLE MariaCluActTest ADD constraint PK_MariaCluActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
DELAYEDWRITERATE_MIN Number(20,4) NOT NULL,
DELAYEDWRITERATE_MAX Number(20,4) NOT NULL,
DELAYEDWRITERATE_STCNT varchar2(32) NOT NULL,
DELAYEDERRORRATE_MIN Number(20,4) NOT NULL,
DELAYEDERRORRATE_MAX Number(20,4) NOT NULL,
DELAYEDERRORRATE_STCNT varchar2(32) NOT NULL,
UPDATERATE_MIN Number(20,4) NOT NULL,
UPDATERATE_MAX Number(20,4) NOT NULL,
UPDATERATE_STCNT varchar2(32) NOT NULL,
INSERTRATE_MIN Number(20,4) NOT NULL,
INSERTRATE_MAX Number(20,4) NOT NULL,
INSERTRATE_STCNT varchar2(32) NOT NULL,
DELETIONRATE_MIN Number(20,4) NOT NULL,
DELETIONRATE_MAX Number(20,4) NOT NULL,
DELETIONRATE_STCNT varchar2(32) NOT NULL,
FLUSHRATE_MIN Number(20,4) NOT NULL,
FLUSHRATE_MAX Number(20,4) NOT NULL,
FLUSHRATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluActTest_TREND ADD constraint PK_MariaCluActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
DELAYEDWRITERATE_MIN VARCHAR2(256) NOT NULL,
DELAYEDWRITERATE_MAX VARCHAR2(256) NOT NULL,
DELAYEDERRORRATE_MIN VARCHAR2(256) NOT NULL,
DELAYEDERRORRATE_MAX VARCHAR2(256) NOT NULL,
UPDATERATE_MIN VARCHAR2(256) NOT NULL,
UPDATERATE_MAX VARCHAR2(256) NOT NULL,
INSERTRATE_MIN VARCHAR2(256) NOT NULL,
INSERTRATE_MAX VARCHAR2(256) NOT NULL,
DELETIONRATE_MIN VARCHAR2(256) NOT NULL,
DELETIONRATE_MAX VARCHAR2(256) NOT NULL,
FLUSHRATE_MIN VARCHAR2(256) NOT NULL,
FLUSHRATE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluActTest_THRESH ADD constraint PK_MariaCluActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluActTest_THRESH ON MariaCluActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluActTest ON MariaCluActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluActTest ON MariaCluActTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluCachTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluCachTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
KEYREADS Number(20,4) NOT NULL,
KEYREADS_ST varchar2(32) NOT NULL,
KEYREADREQUESTS Number(20,4) NOT NULL,
KEYREADREQUESTS_ST varchar2(32) NOT NULL,
NOTFLUSHEDKEYBLOCKS Number(20,4) NOT NULL,
NOTFLUSHEDKEYBLOCKS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluCachTest ON MariaCluCachTest(MSMT_TIME);
ALTER TABLE MariaCluCachTest ADD constraint PK_MariaCluCachTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluCachTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluCachTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
KEYREADS_MIN Number(20,4) NOT NULL,
KEYREADS_MAX Number(20,4) NOT NULL,
KEYREADS_STCNT varchar2(32) NOT NULL,
KEYREADREQUESTS_MIN Number(20,4) NOT NULL,
KEYREADREQUESTS_MAX Number(20,4) NOT NULL,
KEYREADREQUESTS_STCNT varchar2(32) NOT NULL,
NOTFLUSHEDKEYBLOCKS_MIN Number(20,4) NOT NULL,
NOTFLUSHEDKEYBLOCKS_MAX Number(20,4) NOT NULL,
NOTFLUSHEDKEYBLOCKS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluCachTest_TREND ADD constraint PK_MariaCluCachTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluCachTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluCachTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
KEYREADS_MIN VARCHAR2(256) NOT NULL,
KEYREADS_MAX VARCHAR2(256) NOT NULL,
KEYREADREQUESTS_MIN VARCHAR2(256) NOT NULL,
KEYREADREQUESTS_MAX VARCHAR2(256) NOT NULL,
NOTFLUSHEDKEYBLOCKS_MIN VARCHAR2(256) NOT NULL,
NOTFLUSHEDKEYBLOCKS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluCachTest_THRESH ADD constraint PK_MariaCluCachTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluCachTest_THRESH ON MariaCluCachTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluCachTest ON MariaCluCachTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluCachTest ON MariaCluCachTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluCnErTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluCnErTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
HOST_CONNECTED Number(20,4) NOT NULL,
HOST_CONNECTED_ST varchar2(32) NOT NULL,
CONNECTION_ERRORS Number(20,4) NOT NULL,
CONNECTION_ERRORS_ST varchar2(32) NOT NULL,
MAXCONNECTIONERRORS Number(20,4) NOT NULL,
MAXCONNECTIONERRORS_ST varchar2(32) NOT NULL,
CONNECTIONERRPERCENTAGE Number(20,4) NOT NULL,
CONNECTIONERRPERCENTAGE_ST varchar2(32) NOT NULL,
HOSTBLOCKED Number(20,4) NOT NULL,
HOSTBLOCKED_ST varchar2(32) NOT NULL,
TRANSIENTERRORS Number(20,4) NOT NULL,
TRANSIENTERRORS_ST varchar2(32) NOT NULL,
PERMANENTERRORS Number(20,4) NOT NULL,
PERMANENTERRORS_ST varchar2(32) NOT NULL,
HOSTNAMEFORMATERRORS Number(20,4) NOT NULL,
HOSTNAMEFORMATERRORS_ST varchar2(32) NOT NULL,
REVERSELOOKUPERRORS Number(20,4) NOT NULL,
REVERSELOOKUPERRORS_ST varchar2(32) NOT NULL,
HOSTNAMENOTPRIVILEDGEDER Number(20,4) NOT NULL,
HOSTNAMENOTPRIVILEDGEDER_ST varchar2(32) NOT NULL,
AUTHENTICATIONERROR Number(20,4) NOT NULL,
AUTHENTICATIONERROR_ST varchar2(32) NOT NULL,
AUTHENTICATIONPLUGINERR Number(20,4) NOT NULL,
AUTHENTICATIONPLUGINERR_ST varchar2(32) NOT NULL,
HANDSHAKEERRORS Number(20,4) NOT NULL,
HANDSHAKEERRORS_ST varchar2(32) NOT NULL,
PROXYUSERS Number(20,4) NOT NULL,
PROXYUSERS_ST varchar2(32) NOT NULL,
MAXUSERAUTHENTICATIONERR Number(20,4) NOT NULL,
MAXUSERAUTHENTICATIONERR_ST varchar2(32) NOT NULL,
DEFAULTDATABASEERRORS Number(20,4) NOT NULL,
DEFAULTDATABASEERRORS_ST varchar2(32) NOT NULL,
LOCALERRORS Number(20,4) NOT NULL,
LOCALERRORS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluCnErTest ON MariaCluCnErTest(MSMT_TIME);
ALTER TABLE MariaCluCnErTest ADD constraint PK_MariaCluCnErTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluCnErTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluCnErTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
HOST_CONNECTED_MIN Number(20,4) NOT NULL,
HOST_CONNECTED_MAX Number(20,4) NOT NULL,
HOST_CONNECTED_STCNT varchar2(32) NOT NULL,
CONNECTION_ERRORS_MIN Number(20,4) NOT NULL,
CONNECTION_ERRORS_MAX Number(20,4) NOT NULL,
CONNECTION_ERRORS_STCNT varchar2(32) NOT NULL,
MAXCONNECTIONERRORS_MIN Number(20,4) NOT NULL,
MAXCONNECTIONERRORS_MAX Number(20,4) NOT NULL,
MAXCONNECTIONERRORS_STCNT varchar2(32) NOT NULL,
CONNECTIONERRPERCENTAGE_MIN Number(20,4) NOT NULL,
CONNECTIONERRPERCENTAGE_MAX Number(20,4) NOT NULL,
CONNECTIONERRPERCENTAGE_STCNT varchar2(32) NOT NULL,
HOSTBLOCKED_MIN Number(20,4) NOT NULL,
HOSTBLOCKED_MAX Number(20,4) NOT NULL,
HOSTBLOCKED_STCNT varchar2(32) NOT NULL,
TRANSIENTERRORS_MIN Number(20,4) NOT NULL,
TRANSIENTERRORS_MAX Number(20,4) NOT NULL,
TRANSIENTERRORS_STCNT varchar2(32) NOT NULL,
PERMANENTERRORS_MIN Number(20,4) NOT NULL,
PERMANENTERRORS_MAX Number(20,4) NOT NULL,
PERMANENTERRORS_STCNT varchar2(32) NOT NULL,
HOSTNAMEFORMATERRORS_MIN Number(20,4) NOT NULL,
HOSTNAMEFORMATERRORS_MAX Number(20,4) NOT NULL,
HOSTNAMEFORMATERRORS_STCNT varchar2(32) NOT NULL,
REVERSELOOKUPERRORS_MIN Number(20,4) NOT NULL,
REVERSELOOKUPERRORS_MAX Number(20,4) NOT NULL,
REVERSELOOKUPERRORS_STCNT varchar2(32) NOT NULL,
HOSTNAMENOTPRIVILEDGEDER_MIN Number(20,4) NOT NULL,
HOSTNAMENOTPRIVILEDGEDER_MAX Number(20,4) NOT NULL,
HOSTNAMENOTPRIVILEDGEDER_STCNT varchar2(32) NOT NULL,
AUTHENTICATIONERROR_MIN Number(20,4) NOT NULL,
AUTHENTICATIONERROR_MAX Number(20,4) NOT NULL,
AUTHENTICATIONERROR_STCNT varchar2(32) NOT NULL,
AUTHENTICATIONPLUGINERR_MIN Number(20,4) NOT NULL,
AUTHENTICATIONPLUGINERR_MAX Number(20,4) NOT NULL,
AUTHENTICATIONPLUGINERR_STCNT varchar2(32) NOT NULL,
HANDSHAKEERRORS_MIN Number(20,4) NOT NULL,
HANDSHAKEERRORS_MAX Number(20,4) NOT NULL,
HANDSHAKEERRORS_STCNT varchar2(32) NOT NULL,
PROXYUSERS_MIN Number(20,4) NOT NULL,
PROXYUSERS_MAX Number(20,4) NOT NULL,
PROXYUSERS_STCNT varchar2(32) NOT NULL,
MAXUSERAUTHENTICATIONERR_MIN Number(20,4) NOT NULL,
MAXUSERAUTHENTICATIONERR_MAX Number(20,4) NOT NULL,
MAXUSERAUTHENTICATIONERR_STCNT varchar2(32) NOT NULL,
DEFAULTDATABASEERRORS_MIN Number(20,4) NOT NULL,
DEFAULTDATABASEERRORS_MAX Number(20,4) NOT NULL,
DEFAULTDATABASEERRORS_STCNT varchar2(32) NOT NULL,
LOCALERRORS_MIN Number(20,4) NOT NULL,
LOCALERRORS_MAX Number(20,4) NOT NULL,
LOCALERRORS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluCnErTest_TREND ADD constraint PK_MariaCluCnErTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluCnErTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluCnErTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
HOST_CONNECTED_MIN VARCHAR2(256) NOT NULL,
HOST_CONNECTED_MAX VARCHAR2(256) NOT NULL,
CONNECTION_ERRORS_MIN VARCHAR2(256) NOT NULL,
CONNECTION_ERRORS_MAX VARCHAR2(256) NOT NULL,
MAXCONNECTIONERRORS_MIN VARCHAR2(256) NOT NULL,
MAXCONNECTIONERRORS_MAX VARCHAR2(256) NOT NULL,
CONNECTIONERRPERCENTAGE_MIN VARCHAR2(256) NOT NULL,
CONNECTIONERRPERCENTAGE_MAX VARCHAR2(256) NOT NULL,
HOSTBLOCKED_MIN VARCHAR2(256) NOT NULL,
HOSTBLOCKED_MAX VARCHAR2(256) NOT NULL,
TRANSIENTERRORS_MIN VARCHAR2(256) NOT NULL,
TRANSIENTERRORS_MAX VARCHAR2(256) NOT NULL,
PERMANENTERRORS_MIN VARCHAR2(256) NOT NULL,
PERMANENTERRORS_MAX VARCHAR2(256) NOT NULL,
HOSTNAMEFORMATERRORS_MIN VARCHAR2(256) NOT NULL,
HOSTNAMEFORMATERRORS_MAX VARCHAR2(256) NOT NULL,
REVERSELOOKUPERRORS_MIN VARCHAR2(256) NOT NULL,
REVERSELOOKUPERRORS_MAX VARCHAR2(256) NOT NULL,
HOSTNAMENOTPRIVILEDGEDER_MIN VARCHAR2(256) NOT NULL,
HOSTNAMENOTPRIVILEDGEDER_MAX VARCHAR2(256) NOT NULL,
AUTHENTICATIONERROR_MIN VARCHAR2(256) NOT NULL,
AUTHENTICATIONERROR_MAX VARCHAR2(256) NOT NULL,
AUTHENTICATIONPLUGINERR_MIN VARCHAR2(256) NOT NULL,
AUTHENTICATIONPLUGINERR_MAX VARCHAR2(256) NOT NULL,
HANDSHAKEERRORS_MIN VARCHAR2(256) NOT NULL,
HANDSHAKEERRORS_MAX VARCHAR2(256) NOT NULL,
PROXYUSERS_MIN VARCHAR2(256) NOT NULL,
PROXYUSERS_MAX VARCHAR2(256) NOT NULL,
MAXUSERAUTHENTICATIONERR_MIN VARCHAR2(256) NOT NULL,
MAXUSERAUTHENTICATIONERR_MAX VARCHAR2(256) NOT NULL,
DEFAULTDATABASEERRORS_MIN VARCHAR2(256) NOT NULL,
DEFAULTDATABASEERRORS_MAX VARCHAR2(256) NOT NULL,
LOCALERRORS_MIN VARCHAR2(256) NOT NULL,
LOCALERRORS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluCnErTest_THRESH ADD constraint PK_MariaCluCnErTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluCnErTest_THRESH ON MariaCluCnErTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluCnErTest ON MariaCluCnErTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluCnErTest ON MariaCluCnErTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluConnTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluConnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CONNECTIONSCREATERATE Number(20,4) NOT NULL,
CONNECTIONSCREATERATE_ST varchar2(32) NOT NULL,
ACTIVECONNECTIONS Number(20,4) NOT NULL,
ACTIVECONNECTIONS_ST varchar2(32) NOT NULL,
CONNECTIONSABORTED Number(20,4) NOT NULL,
CONNECTIONSABORTED_ST varchar2(32) NOT NULL,
CONNECTIONSFAILED Number(20,4) NOT NULL,
CONNECTIONSFAILED_ST varchar2(32) NOT NULL,
MAXCONNECTIONS Number(20,4) NOT NULL,
MAXCONNECTIONS_ST varchar2(32) NOT NULL,
MAXCONNECTIONSLIMIT Number(20,4) NOT NULL,
MAXCONNECTIONSLIMIT_ST varchar2(32) NOT NULL,
CONNECTIONUSAGE Number(20,4) NOT NULL,
CONNECTIONUSAGE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluConnTest ON MariaCluConnTest(MSMT_TIME);
ALTER TABLE MariaCluConnTest ADD constraint PK_MariaCluConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluConnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluConnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CONNECTIONSCREATERATE_MIN Number(20,4) NOT NULL,
CONNECTIONSCREATERATE_MAX Number(20,4) NOT NULL,
CONNECTIONSCREATERATE_STCNT varchar2(32) NOT NULL,
ACTIVECONNECTIONS_MIN Number(20,4) NOT NULL,
ACTIVECONNECTIONS_MAX Number(20,4) NOT NULL,
ACTIVECONNECTIONS_STCNT varchar2(32) NOT NULL,
CONNECTIONSABORTED_MIN Number(20,4) NOT NULL,
CONNECTIONSABORTED_MAX Number(20,4) NOT NULL,
CONNECTIONSABORTED_STCNT varchar2(32) NOT NULL,
CONNECTIONSFAILED_MIN Number(20,4) NOT NULL,
CONNECTIONSFAILED_MAX Number(20,4) NOT NULL,
CONNECTIONSFAILED_STCNT varchar2(32) NOT NULL,
MAXCONNECTIONS_MIN Number(20,4) NOT NULL,
MAXCONNECTIONS_MAX Number(20,4) NOT NULL,
MAXCONNECTIONS_STCNT varchar2(32) NOT NULL,
MAXCONNECTIONSLIMIT_MIN Number(20,4) NOT NULL,
MAXCONNECTIONSLIMIT_MAX Number(20,4) NOT NULL,
MAXCONNECTIONSLIMIT_STCNT varchar2(32) NOT NULL,
CONNECTIONUSAGE_MIN Number(20,4) NOT NULL,
CONNECTIONUSAGE_MAX Number(20,4) NOT NULL,
CONNECTIONUSAGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluConnTest_TREND ADD constraint PK_MariaCluConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluConnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluConnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CONNECTIONSCREATERATE_MIN VARCHAR2(256) NOT NULL,
CONNECTIONSCREATERATE_MAX VARCHAR2(256) NOT NULL,
ACTIVECONNECTIONS_MIN VARCHAR2(256) NOT NULL,
ACTIVECONNECTIONS_MAX VARCHAR2(256) NOT NULL,
CONNECTIONSABORTED_MIN VARCHAR2(256) NOT NULL,
CONNECTIONSABORTED_MAX VARCHAR2(256) NOT NULL,
CONNECTIONSFAILED_MIN VARCHAR2(256) NOT NULL,
CONNECTIONSFAILED_MAX VARCHAR2(256) NOT NULL,
MAXCONNECTIONS_MIN VARCHAR2(256) NOT NULL,
MAXCONNECTIONS_MAX VARCHAR2(256) NOT NULL,
MAXCONNECTIONSLIMIT_MIN VARCHAR2(256) NOT NULL,
MAXCONNECTIONSLIMIT_MAX VARCHAR2(256) NOT NULL,
CONNECTIONUSAGE_MIN VARCHAR2(256) NOT NULL,
CONNECTIONUSAGE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluConnTest_THRESH ADD constraint PK_MariaCluConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluConnTest_THRESH ON MariaCluConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluConnTest ON MariaCluConnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluConnTest ON MariaCluConnTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluDbUsTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluDbUsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
DATABASESIZE Number(20,4) NOT NULL,
DATABASESIZE_ST varchar2(32) NOT NULL,
INDEXSIZE Number(20,4) NOT NULL,
INDEXSIZE_ST varchar2(32) NOT NULL,
DATASIZE Number(20,4) NOT NULL,
DATASIZE_ST varchar2(32) NOT NULL,
GROWTHRATE Number(20,4) NOT NULL,
GROWTHRATE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluDbUsTest ON MariaCluDbUsTest(MSMT_TIME);
ALTER TABLE MariaCluDbUsTest ADD constraint PK_MariaCluDbUsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluDbUsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluDbUsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
DATABASESIZE_MIN Number(20,4) NOT NULL,
DATABASESIZE_MAX Number(20,4) NOT NULL,
DATABASESIZE_STCNT varchar2(32) NOT NULL,
INDEXSIZE_MIN Number(20,4) NOT NULL,
INDEXSIZE_MAX Number(20,4) NOT NULL,
INDEXSIZE_STCNT varchar2(32) NOT NULL,
DATASIZE_MIN Number(20,4) NOT NULL,
DATASIZE_MAX Number(20,4) NOT NULL,
DATASIZE_STCNT varchar2(32) NOT NULL,
GROWTHRATE_MIN Number(20,4) NOT NULL,
GROWTHRATE_MAX Number(20,4) NOT NULL,
GROWTHRATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluDbUsTest_TREND ADD constraint PK_MariaCluDbUsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluDbUsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluDbUsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
DATABASESIZE_MIN VARCHAR2(256) NOT NULL,
DATABASESIZE_MAX VARCHAR2(256) NOT NULL,
INDEXSIZE_MIN VARCHAR2(256) NOT NULL,
INDEXSIZE_MAX VARCHAR2(256) NOT NULL,
DATASIZE_MIN VARCHAR2(256) NOT NULL,
DATASIZE_MAX VARCHAR2(256) NOT NULL,
GROWTHRATE_MIN VARCHAR2(256) NOT NULL,
GROWTHRATE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluDbUsTest_THRESH ADD constraint PK_MariaCluDbUsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluDbUsTest_THRESH ON MariaCluDbUsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluDbUsTest ON MariaCluDbUsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluDbUsTest ON MariaCluDbUsTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluEvStTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluEvStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTALEVENTS Number(20,4) NOT NULL,
TOTALEVENTS_ST varchar2(32) NOT NULL,
RUNNINGEVENTS Number(20,4) NOT NULL,
RUNNINGEVENTS_ST varchar2(32) NOT NULL,
COMPLETEDEVENTS Number(20,4) NOT NULL,
COMPLETEDEVENTS_ST varchar2(32) NOT NULL,
NESTEDEVENTS Number(20,4) NOT NULL,
NESTEDEVENTS_ST varchar2(32) NOT NULL,
WAITEDEVENTS Number(20,4) NOT NULL,
WAITEDEVENTS_ST varchar2(32) NOT NULL,
WAITEDEVENTPERCENTAGE Number(20,4) NOT NULL,
WAITEDEVENTPERCENTAGE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluEvStTest ON MariaCluEvStTest(MSMT_TIME);
ALTER TABLE MariaCluEvStTest ADD constraint PK_MariaCluEvStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluEvStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluEvStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTALEVENTS_MIN Number(20,4) NOT NULL,
TOTALEVENTS_MAX Number(20,4) NOT NULL,
TOTALEVENTS_STCNT varchar2(32) NOT NULL,
RUNNINGEVENTS_MIN Number(20,4) NOT NULL,
RUNNINGEVENTS_MAX Number(20,4) NOT NULL,
RUNNINGEVENTS_STCNT varchar2(32) NOT NULL,
COMPLETEDEVENTS_MIN Number(20,4) NOT NULL,
COMPLETEDEVENTS_MAX Number(20,4) NOT NULL,
COMPLETEDEVENTS_STCNT varchar2(32) NOT NULL,
NESTEDEVENTS_MIN Number(20,4) NOT NULL,
NESTEDEVENTS_MAX Number(20,4) NOT NULL,
NESTEDEVENTS_STCNT varchar2(32) NOT NULL,
WAITEDEVENTS_MIN Number(20,4) NOT NULL,
WAITEDEVENTS_MAX Number(20,4) NOT NULL,
WAITEDEVENTS_STCNT varchar2(32) NOT NULL,
WAITEDEVENTPERCENTAGE_MIN Number(20,4) NOT NULL,
WAITEDEVENTPERCENTAGE_MAX Number(20,4) NOT NULL,
WAITEDEVENTPERCENTAGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluEvStTest_TREND ADD constraint PK_MariaCluEvStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluEvStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluEvStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTALEVENTS_MIN VARCHAR2(256) NOT NULL,
TOTALEVENTS_MAX VARCHAR2(256) NOT NULL,
RUNNINGEVENTS_MIN VARCHAR2(256) NOT NULL,
RUNNINGEVENTS_MAX VARCHAR2(256) NOT NULL,
COMPLETEDEVENTS_MIN VARCHAR2(256) NOT NULL,
COMPLETEDEVENTS_MAX VARCHAR2(256) NOT NULL,
NESTEDEVENTS_MIN VARCHAR2(256) NOT NULL,
NESTEDEVENTS_MAX VARCHAR2(256) NOT NULL,
WAITEDEVENTS_MIN VARCHAR2(256) NOT NULL,
WAITEDEVENTS_MAX VARCHAR2(256) NOT NULL,
WAITEDEVENTPERCENTAGE_MIN VARCHAR2(256) NOT NULL,
WAITEDEVENTPERCENTAGE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluEvStTest_THRESH ADD constraint PK_MariaCluEvStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluEvStTest_THRESH ON MariaCluEvStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluEvStTest ON MariaCluEvStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluEvStTest ON MariaCluEvStTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluEvtSTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluEvtSTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
RUNNINGSTATEMENTS Number(20,4) NOT NULL,
RUNNINGSTATEMENTS_ST varchar2(32) NOT NULL,
WAITEDSTATEMENTS Number(20,4) NOT NULL,
WAITEDSTATEMENTS_ST varchar2(32) NOT NULL,
LOCKWAITSTATEMENTS Number(20,4) NOT NULL,
LOCKWAITSTATEMENTS_ST varchar2(32) NOT NULL,
ERRORSTATEMENTS Number(20,4) NOT NULL,
ERRORSTATEMENTS_ST varchar2(32) NOT NULL,
DIGESTSTATEMENTS Number(20,4) NOT NULL,
DIGESTSTATEMENTS_ST varchar2(32) NOT NULL,
WARNINGSTATEMENTS Number(20,4) NOT NULL,
WARNINGSTATEMENTS_ST varchar2(32) NOT NULL,
ROWSAFFECTED Number(20,4) NOT NULL,
ROWSAFFECTED_ST varchar2(32) NOT NULL,
ROWSSENT Number(20,4) NOT NULL,
ROWSSENT_ST varchar2(32) NOT NULL,
ROWSEXAMINED Number(20,4) NOT NULL,
ROWSEXAMINED_ST varchar2(32) NOT NULL,
CREATEDTEMPDISKTABLES Number(20,4) NOT NULL,
CREATEDTEMPDISKTABLES_ST varchar2(32) NOT NULL,
CREATEDTEMPTABLES Number(20,4) NOT NULL,
CREATEDTEMPTABLES_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluEvtSTest ON MariaCluEvtSTest(MSMT_TIME);
ALTER TABLE MariaCluEvtSTest ADD constraint PK_MariaCluEvtSTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluEvtSTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluEvtSTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
RUNNINGSTATEMENTS_MIN Number(20,4) NOT NULL,
RUNNINGSTATEMENTS_MAX Number(20,4) NOT NULL,
RUNNINGSTATEMENTS_STCNT varchar2(32) NOT NULL,
WAITEDSTATEMENTS_MIN Number(20,4) NOT NULL,
WAITEDSTATEMENTS_MAX Number(20,4) NOT NULL,
WAITEDSTATEMENTS_STCNT varchar2(32) NOT NULL,
LOCKWAITSTATEMENTS_MIN Number(20,4) NOT NULL,
LOCKWAITSTATEMENTS_MAX Number(20,4) NOT NULL,
LOCKWAITSTATEMENTS_STCNT varchar2(32) NOT NULL,
ERRORSTATEMENTS_MIN Number(20,4) NOT NULL,
ERRORSTATEMENTS_MAX Number(20,4) NOT NULL,
ERRORSTATEMENTS_STCNT varchar2(32) NOT NULL,
DIGESTSTATEMENTS_MIN Number(20,4) NOT NULL,
DIGESTSTATEMENTS_MAX Number(20,4) NOT NULL,
DIGESTSTATEMENTS_STCNT varchar2(32) NOT NULL,
WARNINGSTATEMENTS_MIN Number(20,4) NOT NULL,
WARNINGSTATEMENTS_MAX Number(20,4) NOT NULL,
WARNINGSTATEMENTS_STCNT varchar2(32) NOT NULL,
ROWSAFFECTED_MIN Number(20,4) NOT NULL,
ROWSAFFECTED_MAX Number(20,4) NOT NULL,
ROWSAFFECTED_STCNT varchar2(32) NOT NULL,
ROWSSENT_MIN Number(20,4) NOT NULL,
ROWSSENT_MAX Number(20,4) NOT NULL,
ROWSSENT_STCNT varchar2(32) NOT NULL,
ROWSEXAMINED_MIN Number(20,4) NOT NULL,
ROWSEXAMINED_MAX Number(20,4) NOT NULL,
ROWSEXAMINED_STCNT varchar2(32) NOT NULL,
CREATEDTEMPDISKTABLES_MIN Number(20,4) NOT NULL,
CREATEDTEMPDISKTABLES_MAX Number(20,4) NOT NULL,
CREATEDTEMPDISKTABLES_STCNT varchar2(32) NOT NULL,
CREATEDTEMPTABLES_MIN Number(20,4) NOT NULL,
CREATEDTEMPTABLES_MAX Number(20,4) NOT NULL,
CREATEDTEMPTABLES_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluEvtSTest_TREND ADD constraint PK_MariaCluEvtSTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluEvtSTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluEvtSTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
RUNNINGSTATEMENTS_MIN VARCHAR2(256) NOT NULL,
RUNNINGSTATEMENTS_MAX VARCHAR2(256) NOT NULL,
WAITEDSTATEMENTS_MIN VARCHAR2(256) NOT NULL,
WAITEDSTATEMENTS_MAX VARCHAR2(256) NOT NULL,
LOCKWAITSTATEMENTS_MIN VARCHAR2(256) NOT NULL,
LOCKWAITSTATEMENTS_MAX VARCHAR2(256) NOT NULL,
ERRORSTATEMENTS_MIN VARCHAR2(256) NOT NULL,
ERRORSTATEMENTS_MAX VARCHAR2(256) NOT NULL,
DIGESTSTATEMENTS_MIN VARCHAR2(256) NOT NULL,
DIGESTSTATEMENTS_MAX VARCHAR2(256) NOT NULL,
WARNINGSTATEMENTS_MIN VARCHAR2(256) NOT NULL,
WARNINGSTATEMENTS_MAX VARCHAR2(256) NOT NULL,
ROWSAFFECTED_MIN VARCHAR2(256) NOT NULL,
ROWSAFFECTED_MAX VARCHAR2(256) NOT NULL,
ROWSSENT_MIN VARCHAR2(256) NOT NULL,
ROWSSENT_MAX VARCHAR2(256) NOT NULL,
ROWSEXAMINED_MIN VARCHAR2(256) NOT NULL,
ROWSEXAMINED_MAX VARCHAR2(256) NOT NULL,
CREATEDTEMPDISKTABLES_MIN VARCHAR2(256) NOT NULL,
CREATEDTEMPDISKTABLES_MAX VARCHAR2(256) NOT NULL,
CREATEDTEMPTABLES_MIN VARCHAR2(256) NOT NULL,
CREATEDTEMPTABLES_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluEvtSTest_THRESH ADD constraint PK_MariaCluEvtSTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluEvtSTest_THRESH ON MariaCluEvtSTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluEvtSTest ON MariaCluEvtSTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluEvtSTest ON MariaCluEvtSTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluFileTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluFileTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTALOPENEDFILES Number(20,4) NOT NULL,
TOTALOPENEDFILES_ST varchar2(32) NOT NULL,
MAXFILEINSTANCE Number(20,4) NOT NULL,
MAXFILEINSTANCE_ST varchar2(32) NOT NULL,
TOTALFILEINSTANCE Number(20,4) NOT NULL,
TOTALFILEINSTANCE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluFileTest ON MariaCluFileTest(MSMT_TIME);
ALTER TABLE MariaCluFileTest ADD constraint PK_MariaCluFileTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluFileTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluFileTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTALOPENEDFILES_MIN Number(20,4) NOT NULL,
TOTALOPENEDFILES_MAX Number(20,4) NOT NULL,
TOTALOPENEDFILES_STCNT varchar2(32) NOT NULL,
MAXFILEINSTANCE_MIN Number(20,4) NOT NULL,
MAXFILEINSTANCE_MAX Number(20,4) NOT NULL,
MAXFILEINSTANCE_STCNT varchar2(32) NOT NULL,
TOTALFILEINSTANCE_MIN Number(20,4) NOT NULL,
TOTALFILEINSTANCE_MAX Number(20,4) NOT NULL,
TOTALFILEINSTANCE_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluFileTest_TREND ADD constraint PK_MariaCluFileTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluFileTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluFileTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTALOPENEDFILES_MIN VARCHAR2(256) NOT NULL,
TOTALOPENEDFILES_MAX VARCHAR2(256) NOT NULL,
MAXFILEINSTANCE_MIN VARCHAR2(256) NOT NULL,
MAXFILEINSTANCE_MAX VARCHAR2(256) NOT NULL,
TOTALFILEINSTANCE_MIN VARCHAR2(256) NOT NULL,
TOTALFILEINSTANCE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluFileTest_THRESH ADD constraint PK_MariaCluFileTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluFileTest_THRESH ON MariaCluFileTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluFileTest ON MariaCluFileTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluFileTest ON MariaCluFileTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluLcTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluLcTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTALLOCKS Number(20,4) NOT NULL,
TOTALLOCKS_ST varchar2(32) NOT NULL,
READLOCKS Number(20,4) NOT NULL,
READLOCKS_ST varchar2(32) NOT NULL,
WRITELOCKS Number(20,4) NOT NULL,
WRITELOCKS_ST varchar2(32) NOT NULL,
PERCENTAGEOFRDWRLOCKS Number(20,4) NOT NULL,
PERCENTAGEOFRDWRLOCKS_ST varchar2(32) NOT NULL,
MAXROWLOCKS Number(20,4) NOT NULL,
MAXROWLOCKS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluLcTest ON MariaCluLcTest(MSMT_TIME);
ALTER TABLE MariaCluLcTest ADD constraint PK_MariaCluLcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluLcTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluLcTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTALLOCKS_MIN Number(20,4) NOT NULL,
TOTALLOCKS_MAX Number(20,4) NOT NULL,
TOTALLOCKS_STCNT varchar2(32) NOT NULL,
READLOCKS_MIN Number(20,4) NOT NULL,
READLOCKS_MAX Number(20,4) NOT NULL,
READLOCKS_STCNT varchar2(32) NOT NULL,
WRITELOCKS_MIN Number(20,4) NOT NULL,
WRITELOCKS_MAX Number(20,4) NOT NULL,
WRITELOCKS_STCNT varchar2(32) NOT NULL,
PERCENTAGEOFRDWRLOCKS_MIN Number(20,4) NOT NULL,
PERCENTAGEOFRDWRLOCKS_MAX Number(20,4) NOT NULL,
PERCENTAGEOFRDWRLOCKS_STCNT varchar2(32) NOT NULL,
MAXROWLOCKS_MIN Number(20,4) NOT NULL,
MAXROWLOCKS_MAX Number(20,4) NOT NULL,
MAXROWLOCKS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluLcTest_TREND ADD constraint PK_MariaCluLcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluLcTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluLcTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTALLOCKS_MIN VARCHAR2(256) NOT NULL,
TOTALLOCKS_MAX VARCHAR2(256) NOT NULL,
READLOCKS_MIN VARCHAR2(256) NOT NULL,
READLOCKS_MAX VARCHAR2(256) NOT NULL,
WRITELOCKS_MIN VARCHAR2(256) NOT NULL,
WRITELOCKS_MAX VARCHAR2(256) NOT NULL,
PERCENTAGEOFRDWRLOCKS_MIN VARCHAR2(256) NOT NULL,
PERCENTAGEOFRDWRLOCKS_MAX VARCHAR2(256) NOT NULL,
MAXROWLOCKS_MIN VARCHAR2(256) NOT NULL,
MAXROWLOCKS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluLcTest_THRESH ADD constraint PK_MariaCluLcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluLcTest_THRESH ON MariaCluLcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluLcTest ON MariaCluLcTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluLcTest ON MariaCluLcTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluLcWtTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluLcWtTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERCENTAGELOCKWAITS Number(20,4) NOT NULL,
PERCENTAGELOCKWAITS_ST varchar2(32) NOT NULL,
TABLELOCKWAITED Number(20,4) NOT NULL,
TABLELOCKWAITED_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluLcWtTest ON MariaCluLcWtTest(MSMT_TIME);
ALTER TABLE MariaCluLcWtTest ADD constraint PK_MariaCluLcWtTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluLcWtTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluLcWtTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
PERCENTAGELOCKWAITS_MIN Number(20,4) NOT NULL,
PERCENTAGELOCKWAITS_MAX Number(20,4) NOT NULL,
PERCENTAGELOCKWAITS_STCNT varchar2(32) NOT NULL,
TABLELOCKWAITED_MIN Number(20,4) NOT NULL,
TABLELOCKWAITED_MAX Number(20,4) NOT NULL,
TABLELOCKWAITED_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluLcWtTest_TREND ADD constraint PK_MariaCluLcWtTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluLcWtTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluLcWtTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
PERCENTAGELOCKWAITS_MIN VARCHAR2(256) NOT NULL,
PERCENTAGELOCKWAITS_MAX VARCHAR2(256) NOT NULL,
TABLELOCKWAITED_MIN VARCHAR2(256) NOT NULL,
TABLELOCKWAITED_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluLcWtTest_THRESH ADD constraint PK_MariaCluLcWtTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluLcWtTest_THRESH ON MariaCluLcWtTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluLcWtTest ON MariaCluLcWtTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluLcWtTest ON MariaCluLcWtTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluLgRnTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluLgRnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NUMBEROFLONGRUNQUERY Number(20,4) NOT NULL,
NUMBEROFLONGRUNQUERY_ST varchar2(32) NOT NULL,
MAXIMUMDURATION Number(20,4) NOT NULL,
MAXIMUMDURATION_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluLgRnTest ON MariaCluLgRnTest(MSMT_TIME);
ALTER TABLE MariaCluLgRnTest ADD constraint PK_MariaCluLgRnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluLgRnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluLgRnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NUMBEROFLONGRUNQUERY_MIN Number(20,4) NOT NULL,
NUMBEROFLONGRUNQUERY_MAX Number(20,4) NOT NULL,
NUMBEROFLONGRUNQUERY_STCNT varchar2(32) NOT NULL,
MAXIMUMDURATION_MIN Number(20,4) NOT NULL,
MAXIMUMDURATION_MAX Number(20,4) NOT NULL,
MAXIMUMDURATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluLgRnTest_TREND ADD constraint PK_MariaCluLgRnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluLgRnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluLgRnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NUMBEROFLONGRUNQUERY_MIN VARCHAR2(256) NOT NULL,
NUMBEROFLONGRUNQUERY_MAX VARCHAR2(256) NOT NULL,
MAXIMUMDURATION_MIN VARCHAR2(256) NOT NULL,
MAXIMUMDURATION_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluLgRnTest_THRESH ADD constraint PK_MariaCluLgRnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluLgRnTest_THRESH ON MariaCluLgRnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluLgRnTest ON MariaCluLgRnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluLgRnTest ON MariaCluLgRnTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluMemTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluMemTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
STATUS Number(20,4) NOT NULL,
STATUS_ST varchar2(32) NOT NULL,
NODESTATE Number(20,4) NOT NULL,
NODESTATE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluMemTest ON MariaCluMemTest(MSMT_TIME);
ALTER TABLE MariaCluMemTest ADD constraint PK_MariaCluMemTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluMemTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluMemTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
STATUS_MIN Number(20,4) NOT NULL,
STATUS_MAX Number(20,4) NOT NULL,
STATUS_STCNT varchar2(32) NOT NULL,
NODESTATE_MIN Number(20,4) NOT NULL,
NODESTATE_MAX Number(20,4) NOT NULL,
NODESTATE_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluMemTest_TREND ADD constraint PK_MariaCluMemTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluMemTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluMemTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
STATUS_MIN VARCHAR2(256) NOT NULL,
STATUS_MAX VARCHAR2(256) NOT NULL,
NODESTATE_MIN VARCHAR2(256) NOT NULL,
NODESTATE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluMemTest_THRESH ADD constraint PK_MariaCluMemTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluMemTest_THRESH ON MariaCluMemTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluMemTest ON MariaCluMemTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluMemTest ON MariaCluMemTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluNetTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluNetTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AVAILABILITY Number(20,4) NOT NULL,
AVAILABILITY_ST varchar2(32) NOT NULL,
RESPONSETIME Number(20,4) NOT NULL,
RESPONSETIME_ST varchar2(32) NOT NULL,
CONNECTIONAVAILABILITY Number(20,4) NOT NULL,
CONNECTIONAVAILABILITY_ST varchar2(32) NOT NULL,
CONNECTIONRESPONSETIME Number(20,4) NOT NULL,
CONNECTIONRESPONSETIME_ST varchar2(32) NOT NULL,
QUERYAVAILABILITY Number(20,4) NOT NULL,
QUERYAVAILABILITY_ST varchar2(32) NOT NULL,
QUERYRESPONSETIME Number(20,4) NOT NULL,
QUERYRESPONSETIME_ST varchar2(32) NOT NULL,
RECONRDSCOUNT Number(20,4) NOT NULL,
RECONRDSCOUNT_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluNetTest ON MariaCluNetTest(MSMT_TIME);
ALTER TABLE MariaCluNetTest ADD constraint PK_MariaCluNetTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluNetTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluNetTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AVAILABILITY_MIN Number(20,4) NOT NULL,
AVAILABILITY_MAX Number(20,4) NOT NULL,
AVAILABILITY_STCNT varchar2(32) NOT NULL,
RESPONSETIME_MIN Number(20,4) NOT NULL,
RESPONSETIME_MAX Number(20,4) NOT NULL,
RESPONSETIME_STCNT varchar2(32) NOT NULL,
CONNECTIONAVAILABILITY_MIN Number(20,4) NOT NULL,
CONNECTIONAVAILABILITY_MAX Number(20,4) NOT NULL,
CONNECTIONAVAILABILITY_STCNT varchar2(32) NOT NULL,
CONNECTIONRESPONSETIME_MIN Number(20,4) NOT NULL,
CONNECTIONRESPONSETIME_MAX Number(20,4) NOT NULL,
CONNECTIONRESPONSETIME_STCNT varchar2(32) NOT NULL,
QUERYAVAILABILITY_MIN Number(20,4) NOT NULL,
QUERYAVAILABILITY_MAX Number(20,4) NOT NULL,
QUERYAVAILABILITY_STCNT varchar2(32) NOT NULL,
QUERYRESPONSETIME_MIN Number(20,4) NOT NULL,
QUERYRESPONSETIME_MAX Number(20,4) NOT NULL,
QUERYRESPONSETIME_STCNT varchar2(32) NOT NULL,
RECONRDSCOUNT_MIN Number(20,4) NOT NULL,
RECONRDSCOUNT_MAX Number(20,4) NOT NULL,
RECONRDSCOUNT_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluNetTest_TREND ADD constraint PK_MariaCluNetTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluNetTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluNetTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AVAILABILITY_MIN VARCHAR2(256) NOT NULL,
AVAILABILITY_MAX VARCHAR2(256) NOT NULL,
RESPONSETIME_MIN VARCHAR2(256) NOT NULL,
RESPONSETIME_MAX VARCHAR2(256) NOT NULL,
CONNECTIONAVAILABILITY_MIN VARCHAR2(256) NOT NULL,
CONNECTIONAVAILABILITY_MAX VARCHAR2(256) NOT NULL,
CONNECTIONRESPONSETIME_MIN VARCHAR2(256) NOT NULL,
CONNECTIONRESPONSETIME_MAX VARCHAR2(256) NOT NULL,
QUERYAVAILABILITY_MIN VARCHAR2(256) NOT NULL,
QUERYAVAILABILITY_MAX VARCHAR2(256) NOT NULL,
QUERYRESPONSETIME_MIN VARCHAR2(256) NOT NULL,
QUERYRESPONSETIME_MAX VARCHAR2(256) NOT NULL,
RECONRDSCOUNT_MIN VARCHAR2(256) NOT NULL,
RECONRDSCOUNT_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluNetTest_THRESH ADD constraint PK_MariaCluNetTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluNetTest_THRESH ON MariaCluNetTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluNetTest ON MariaCluNetTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluNetTest ON MariaCluNetTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluQCacTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluQCacTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
QUERIESREGISTERED Number(20,4) NOT NULL,
QUERIESREGISTERED_ST varchar2(32) NOT NULL,
QUERIESADDED Number(20,4) NOT NULL,
QUERIESADDED_ST varchar2(32) NOT NULL,
CACHEHITS Number(20,4) NOT NULL,
CACHEHITS_ST varchar2(32) NOT NULL,
QUERIESDELETED Number(20,4) NOT NULL,
QUERIESDELETED_ST varchar2(32) NOT NULL,
NONCACHEDQUERIES Number(20,4) NOT NULL,
NONCACHEDQUERIES_ST varchar2(32) NOT NULL,
FREEMEMORY Number(20,4) NOT NULL,
FREEMEMORY_ST varchar2(32) NOT NULL,
FREEBLOCKS Number(20,4) NOT NULL,
FREEBLOCKS_ST varchar2(32) NOT NULL,
TOTALBLOCKS Number(20,4) NOT NULL,
TOTALBLOCKS_ST varchar2(32) NOT NULL,
TOTALQUERIES Number(20,4) NOT NULL,
TOTALQUERIES_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluQCacTest ON MariaCluQCacTest(MSMT_TIME);
ALTER TABLE MariaCluQCacTest ADD constraint PK_MariaCluQCacTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluQCacTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluQCacTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
QUERIESREGISTERED_MIN Number(20,4) NOT NULL,
QUERIESREGISTERED_MAX Number(20,4) NOT NULL,
QUERIESREGISTERED_STCNT varchar2(32) NOT NULL,
QUERIESADDED_MIN Number(20,4) NOT NULL,
QUERIESADDED_MAX Number(20,4) NOT NULL,
QUERIESADDED_STCNT varchar2(32) NOT NULL,
CACHEHITS_MIN Number(20,4) NOT NULL,
CACHEHITS_MAX Number(20,4) NOT NULL,
CACHEHITS_STCNT varchar2(32) NOT NULL,
QUERIESDELETED_MIN Number(20,4) NOT NULL,
QUERIESDELETED_MAX Number(20,4) NOT NULL,
QUERIESDELETED_STCNT varchar2(32) NOT NULL,
NONCACHEDQUERIES_MIN Number(20,4) NOT NULL,
NONCACHEDQUERIES_MAX Number(20,4) NOT NULL,
NONCACHEDQUERIES_STCNT varchar2(32) NOT NULL,
FREEMEMORY_MIN Number(20,4) NOT NULL,
FREEMEMORY_MAX Number(20,4) NOT NULL,
FREEMEMORY_STCNT varchar2(32) NOT NULL,
FREEBLOCKS_MIN Number(20,4) NOT NULL,
FREEBLOCKS_MAX Number(20,4) NOT NULL,
FREEBLOCKS_STCNT varchar2(32) NOT NULL,
TOTALBLOCKS_MIN Number(20,4) NOT NULL,
TOTALBLOCKS_MAX Number(20,4) NOT NULL,
TOTALBLOCKS_STCNT varchar2(32) NOT NULL,
TOTALQUERIES_MIN Number(20,4) NOT NULL,
TOTALQUERIES_MAX Number(20,4) NOT NULL,
TOTALQUERIES_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluQCacTest_TREND ADD constraint PK_MariaCluQCacTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluQCacTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluQCacTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
QUERIESREGISTERED_MIN VARCHAR2(256) NOT NULL,
QUERIESREGISTERED_MAX VARCHAR2(256) NOT NULL,
QUERIESADDED_MIN VARCHAR2(256) NOT NULL,
QUERIESADDED_MAX VARCHAR2(256) NOT NULL,
CACHEHITS_MIN VARCHAR2(256) NOT NULL,
CACHEHITS_MAX VARCHAR2(256) NOT NULL,
QUERIESDELETED_MIN VARCHAR2(256) NOT NULL,
QUERIESDELETED_MAX VARCHAR2(256) NOT NULL,
NONCACHEDQUERIES_MIN VARCHAR2(256) NOT NULL,
NONCACHEDQUERIES_MAX VARCHAR2(256) NOT NULL,
FREEMEMORY_MIN VARCHAR2(256) NOT NULL,
FREEMEMORY_MAX VARCHAR2(256) NOT NULL,
FREEBLOCKS_MIN VARCHAR2(256) NOT NULL,
FREEBLOCKS_MAX VARCHAR2(256) NOT NULL,
TOTALBLOCKS_MIN VARCHAR2(256) NOT NULL,
TOTALBLOCKS_MAX VARCHAR2(256) NOT NULL,
TOTALQUERIES_MIN VARCHAR2(256) NOT NULL,
TOTALQUERIES_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluQCacTest_THRESH ADD constraint PK_MariaCluQCacTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluQCacTest_THRESH ON MariaCluQCacTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluQCacTest ON MariaCluQCacTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluQCacTest ON MariaCluQCacTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluQryTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluQryTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
QUERYRATE Number(20,4) NOT NULL,
QUERYRATE_ST varchar2(32) NOT NULL,
SLOWQUERIES Number(20,4) NOT NULL,
SLOWQUERIES_ST varchar2(32) NOT NULL,
HANDLERREADFIRST Number(20,4) NOT NULL,
HANDLERREADFIRST_ST varchar2(32) NOT NULL,
HANDLERREADKEY Number(20,4) NOT NULL,
HANDLERREADKEY_ST varchar2(32) NOT NULL,
HANDLERREADNEXT Number(20,4) NOT NULL,
HANDLERREADNEXT_ST varchar2(32) NOT NULL,
HANDLERREADPREV Number(20,4) NOT NULL,
HANDLERREADPREV_ST varchar2(32) NOT NULL,
HANDLERREADRND Number(20,4) NOT NULL,
HANDLERREADRND_ST varchar2(32) NOT NULL,
HANDLERREADRNDNEXT Number(20,4) NOT NULL,
HANDLERREADRNDNEXT_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluQryTest ON MariaCluQryTest(MSMT_TIME);
ALTER TABLE MariaCluQryTest ADD constraint PK_MariaCluQryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluQryTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluQryTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
QUERYRATE_MIN Number(20,4) NOT NULL,
QUERYRATE_MAX Number(20,4) NOT NULL,
QUERYRATE_STCNT varchar2(32) NOT NULL,
SLOWQUERIES_MIN Number(20,4) NOT NULL,
SLOWQUERIES_MAX Number(20,4) NOT NULL,
SLOWQUERIES_STCNT varchar2(32) NOT NULL,
HANDLERREADFIRST_MIN Number(20,4) NOT NULL,
HANDLERREADFIRST_MAX Number(20,4) NOT NULL,
HANDLERREADFIRST_STCNT varchar2(32) NOT NULL,
HANDLERREADKEY_MIN Number(20,4) NOT NULL,
HANDLERREADKEY_MAX Number(20,4) NOT NULL,
HANDLERREADKEY_STCNT varchar2(32) NOT NULL,
HANDLERREADNEXT_MIN Number(20,4) NOT NULL,
HANDLERREADNEXT_MAX Number(20,4) NOT NULL,
HANDLERREADNEXT_STCNT varchar2(32) NOT NULL,
HANDLERREADPREV_MIN Number(20,4) NOT NULL,
HANDLERREADPREV_MAX Number(20,4) NOT NULL,
HANDLERREADPREV_STCNT varchar2(32) NOT NULL,
HANDLERREADRND_MIN Number(20,4) NOT NULL,
HANDLERREADRND_MAX Number(20,4) NOT NULL,
HANDLERREADRND_STCNT varchar2(32) NOT NULL,
HANDLERREADRNDNEXT_MIN Number(20,4) NOT NULL,
HANDLERREADRNDNEXT_MAX Number(20,4) NOT NULL,
HANDLERREADRNDNEXT_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluQryTest_TREND ADD constraint PK_MariaCluQryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluQryTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluQryTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
QUERYRATE_MIN VARCHAR2(256) NOT NULL,
QUERYRATE_MAX VARCHAR2(256) NOT NULL,
SLOWQUERIES_MIN VARCHAR2(256) NOT NULL,
SLOWQUERIES_MAX VARCHAR2(256) NOT NULL,
HANDLERREADFIRST_MIN VARCHAR2(256) NOT NULL,
HANDLERREADFIRST_MAX VARCHAR2(256) NOT NULL,
HANDLERREADKEY_MIN VARCHAR2(256) NOT NULL,
HANDLERREADKEY_MAX VARCHAR2(256) NOT NULL,
HANDLERREADNEXT_MIN VARCHAR2(256) NOT NULL,
HANDLERREADNEXT_MAX VARCHAR2(256) NOT NULL,
HANDLERREADPREV_MIN VARCHAR2(256) NOT NULL,
HANDLERREADPREV_MAX VARCHAR2(256) NOT NULL,
HANDLERREADRND_MIN VARCHAR2(256) NOT NULL,
HANDLERREADRND_MAX VARCHAR2(256) NOT NULL,
HANDLERREADRNDNEXT_MIN VARCHAR2(256) NOT NULL,
HANDLERREADRNDNEXT_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluQryTest_THRESH ADD constraint PK_MariaCluQryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluQryTest_THRESH ON MariaCluQryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluQryTest ON MariaCluQryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluQryTest ON MariaCluQryTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluStatTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluStatTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
NOOFSORTSRANGE Number(20,4) NOT NULL,
NOOFSORTSRANGE_ST varchar2(32) NOT NULL,
SORTRANGERATE Number(20,4) NOT NULL,
SORTRANGERATE_ST varchar2(32) NOT NULL,
NOOFSORTSCANS Number(20,4) NOT NULL,
NOOFSORTSCANS_ST varchar2(32) NOT NULL,
SORTSCANSRATE Number(20,4) NOT NULL,
SORTSCANSRATE_ST varchar2(32) NOT NULL,
NOOFMERGEPASS Number(20,4) NOT NULL,
NOOFMERGEPASS_ST varchar2(32) NOT NULL,
MERGEPASSRATE Number(20,4) NOT NULL,
MERGEPASSRATE_ST varchar2(32) NOT NULL,
JOINSNOTUSINGINDEX Number(20,4) NOT NULL,
JOINSNOTUSINGINDEX_ST varchar2(32) NOT NULL,
NOOFSORTFULLJOINS Number(20,4) NOT NULL,
NOOFSORTFULLJOINS_ST varchar2(32) NOT NULL,
RANGECHECKWITHOUTKEYS Number(20,4) NOT NULL,
RANGECHECKWITHOUTKEYS_ST varchar2(32) NOT NULL,
TABLESCANSWITHINDEX Number(20,4) NOT NULL,
TABLESCANSWITHINDEX_ST varchar2(32) NOT NULL,
TABLESCANSWITHOUTINDEX Number(20,4) NOT NULL,
TABLESCANSWITHOUTINDEX_ST varchar2(32) NOT NULL,
EXECUTEDBYGOODINDEX Number(20,4) NOT NULL,
EXECUTEDBYGOODINDEX_ST varchar2(32) NOT NULL,
EXECUTEDBYBADINDEX Number(20,4) NOT NULL,
EXECUTEDBYBADINDEX_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluStatTest ON MariaCluStatTest(MSMT_TIME);
ALTER TABLE MariaCluStatTest ADD constraint PK_MariaCluStatTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluStatTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluStatTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
NOOFSORTSRANGE_MIN Number(20,4) NOT NULL,
NOOFSORTSRANGE_MAX Number(20,4) NOT NULL,
NOOFSORTSRANGE_STCNT varchar2(32) NOT NULL,
SORTRANGERATE_MIN Number(20,4) NOT NULL,
SORTRANGERATE_MAX Number(20,4) NOT NULL,
SORTRANGERATE_STCNT varchar2(32) NOT NULL,
NOOFSORTSCANS_MIN Number(20,4) NOT NULL,
NOOFSORTSCANS_MAX Number(20,4) NOT NULL,
NOOFSORTSCANS_STCNT varchar2(32) NOT NULL,
SORTSCANSRATE_MIN Number(20,4) NOT NULL,
SORTSCANSRATE_MAX Number(20,4) NOT NULL,
SORTSCANSRATE_STCNT varchar2(32) NOT NULL,
NOOFMERGEPASS_MIN Number(20,4) NOT NULL,
NOOFMERGEPASS_MAX Number(20,4) NOT NULL,
NOOFMERGEPASS_STCNT varchar2(32) NOT NULL,
MERGEPASSRATE_MIN Number(20,4) NOT NULL,
MERGEPASSRATE_MAX Number(20,4) NOT NULL,
MERGEPASSRATE_STCNT varchar2(32) NOT NULL,
JOINSNOTUSINGINDEX_MIN Number(20,4) NOT NULL,
JOINSNOTUSINGINDEX_MAX Number(20,4) NOT NULL,
JOINSNOTUSINGINDEX_STCNT varchar2(32) NOT NULL,
NOOFSORTFULLJOINS_MIN Number(20,4) NOT NULL,
NOOFSORTFULLJOINS_MAX Number(20,4) NOT NULL,
NOOFSORTFULLJOINS_STCNT varchar2(32) NOT NULL,
RANGECHECKWITHOUTKEYS_MIN Number(20,4) NOT NULL,
RANGECHECKWITHOUTKEYS_MAX Number(20,4) NOT NULL,
RANGECHECKWITHOUTKEYS_STCNT varchar2(32) NOT NULL,
TABLESCANSWITHINDEX_MIN Number(20,4) NOT NULL,
TABLESCANSWITHINDEX_MAX Number(20,4) NOT NULL,
TABLESCANSWITHINDEX_STCNT varchar2(32) NOT NULL,
TABLESCANSWITHOUTINDEX_MIN Number(20,4) NOT NULL,
TABLESCANSWITHOUTINDEX_MAX Number(20,4) NOT NULL,
TABLESCANSWITHOUTINDEX_STCNT varchar2(32) NOT NULL,
EXECUTEDBYGOODINDEX_MIN Number(20,4) NOT NULL,
EXECUTEDBYGOODINDEX_MAX Number(20,4) NOT NULL,
EXECUTEDBYGOODINDEX_STCNT varchar2(32) NOT NULL,
EXECUTEDBYBADINDEX_MIN Number(20,4) NOT NULL,
EXECUTEDBYBADINDEX_MAX Number(20,4) NOT NULL,
EXECUTEDBYBADINDEX_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluStatTest_TREND ADD constraint PK_MariaCluStatTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluStatTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluStatTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
NOOFSORTSRANGE_MIN VARCHAR2(256) NOT NULL,
NOOFSORTSRANGE_MAX VARCHAR2(256) NOT NULL,
SORTRANGERATE_MIN VARCHAR2(256) NOT NULL,
SORTRANGERATE_MAX VARCHAR2(256) NOT NULL,
NOOFSORTSCANS_MIN VARCHAR2(256) NOT NULL,
NOOFSORTSCANS_MAX VARCHAR2(256) NOT NULL,
SORTSCANSRATE_MIN VARCHAR2(256) NOT NULL,
SORTSCANSRATE_MAX VARCHAR2(256) NOT NULL,
NOOFMERGEPASS_MIN VARCHAR2(256) NOT NULL,
NOOFMERGEPASS_MAX VARCHAR2(256) NOT NULL,
MERGEPASSRATE_MIN VARCHAR2(256) NOT NULL,
MERGEPASSRATE_MAX VARCHAR2(256) NOT NULL,
JOINSNOTUSINGINDEX_MIN VARCHAR2(256) NOT NULL,
JOINSNOTUSINGINDEX_MAX VARCHAR2(256) NOT NULL,
NOOFSORTFULLJOINS_MIN VARCHAR2(256) NOT NULL,
NOOFSORTFULLJOINS_MAX VARCHAR2(256) NOT NULL,
RANGECHECKWITHOUTKEYS_MIN VARCHAR2(256) NOT NULL,
RANGECHECKWITHOUTKEYS_MAX VARCHAR2(256) NOT NULL,
TABLESCANSWITHINDEX_MIN VARCHAR2(256) NOT NULL,
TABLESCANSWITHINDEX_MAX VARCHAR2(256) NOT NULL,
TABLESCANSWITHOUTINDEX_MIN VARCHAR2(256) NOT NULL,
TABLESCANSWITHOUTINDEX_MAX VARCHAR2(256) NOT NULL,
EXECUTEDBYGOODINDEX_MIN VARCHAR2(256) NOT NULL,
EXECUTEDBYGOODINDEX_MAX VARCHAR2(256) NOT NULL,
EXECUTEDBYBADINDEX_MIN VARCHAR2(256) NOT NULL,
EXECUTEDBYBADINDEX_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluStatTest_THRESH ADD constraint PK_MariaCluStatTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluStatTest_THRESH ON MariaCluStatTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluStatTest ON MariaCluStatTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluStatTest ON MariaCluStatTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluStTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ISCLUSTERENABLED Number(20,4) NOT NULL,
ISCLUSTERENABLED_ST varchar2(32) NOT NULL,
AVAILABLEMEMBERS Number(20,4) NOT NULL,
AVAILABLEMEMBERS_ST varchar2(32) NOT NULL,
UNAVAILABLEMEMBERS Number(20,4) NOT NULL,
UNAVAILABLEMEMBERS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluStTest ON MariaCluStTest(MSMT_TIME);
ALTER TABLE MariaCluStTest ADD constraint PK_MariaCluStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
ISCLUSTERENABLED_MIN Number(20,4) NOT NULL,
ISCLUSTERENABLED_MAX Number(20,4) NOT NULL,
ISCLUSTERENABLED_STCNT varchar2(32) NOT NULL,
AVAILABLEMEMBERS_MIN Number(20,4) NOT NULL,
AVAILABLEMEMBERS_MAX Number(20,4) NOT NULL,
AVAILABLEMEMBERS_STCNT varchar2(32) NOT NULL,
UNAVAILABLEMEMBERS_MIN Number(20,4) NOT NULL,
UNAVAILABLEMEMBERS_MAX Number(20,4) NOT NULL,
UNAVAILABLEMEMBERS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluStTest_TREND ADD constraint PK_MariaCluStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ISCLUSTERENABLED_MIN VARCHAR2(256) NOT NULL,
ISCLUSTERENABLED_MAX VARCHAR2(256) NOT NULL,
AVAILABLEMEMBERS_MIN VARCHAR2(256) NOT NULL,
AVAILABLEMEMBERS_MAX VARCHAR2(256) NOT NULL,
UNAVAILABLEMEMBERS_MIN VARCHAR2(256) NOT NULL,
UNAVAILABLEMEMBERS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluStTest_THRESH ADD constraint PK_MariaCluStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluStTest_THRESH ON MariaCluStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluStTest ON MariaCluStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluStTest ON MariaCluStTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluThrdTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluThrdTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTALTHREADS Number(20,4) NOT NULL,
TOTALTHREADS_ST varchar2(32) NOT NULL,
BACKGROUNDTHREADS Number(20,4) NOT NULL,
BACKGROUNDTHREADS_ST varchar2(32) NOT NULL,
FOREGROUNDTHREADS Number(20,4) NOT NULL,
FOREGROUNDTHREADS_ST varchar2(32) NOT NULL,
KILLINGTHREADS Number(20,4) NOT NULL,
KILLINGTHREADS_ST varchar2(32) NOT NULL,
ERRORTHREADS Number(20,4) NOT NULL,
ERRORTHREADS_ST varchar2(32) NOT NULL,
DELAYEDINSERTTHREADS Number(20,4) NOT NULL,
DELAYEDINSERTTHREADS_ST varchar2(32) NOT NULL,
RETRIEVEDLOGDATATHREADS Number(20,4) NOT NULL,
RETRIEVEDLOGDATATHREADS_ST varchar2(32) NOT NULL,
MAXDUARTIONTHREADS Number(20,4) NOT NULL,
MAXDUARTIONTHREADS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluThrdTest ON MariaCluThrdTest(MSMT_TIME);
ALTER TABLE MariaCluThrdTest ADD constraint PK_MariaCluThrdTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluThrdTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluThrdTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTALTHREADS_MIN Number(20,4) NOT NULL,
TOTALTHREADS_MAX Number(20,4) NOT NULL,
TOTALTHREADS_STCNT varchar2(32) NOT NULL,
BACKGROUNDTHREADS_MIN Number(20,4) NOT NULL,
BACKGROUNDTHREADS_MAX Number(20,4) NOT NULL,
BACKGROUNDTHREADS_STCNT varchar2(32) NOT NULL,
FOREGROUNDTHREADS_MIN Number(20,4) NOT NULL,
FOREGROUNDTHREADS_MAX Number(20,4) NOT NULL,
FOREGROUNDTHREADS_STCNT varchar2(32) NOT NULL,
KILLINGTHREADS_MIN Number(20,4) NOT NULL,
KILLINGTHREADS_MAX Number(20,4) NOT NULL,
KILLINGTHREADS_STCNT varchar2(32) NOT NULL,
ERRORTHREADS_MIN Number(20,4) NOT NULL,
ERRORTHREADS_MAX Number(20,4) NOT NULL,
ERRORTHREADS_STCNT varchar2(32) NOT NULL,
DELAYEDINSERTTHREADS_MIN Number(20,4) NOT NULL,
DELAYEDINSERTTHREADS_MAX Number(20,4) NOT NULL,
DELAYEDINSERTTHREADS_STCNT varchar2(32) NOT NULL,
RETRIEVEDLOGDATATHREADS_MIN Number(20,4) NOT NULL,
RETRIEVEDLOGDATATHREADS_MAX Number(20,4) NOT NULL,
RETRIEVEDLOGDATATHREADS_STCNT varchar2(32) NOT NULL,
MAXDUARTIONTHREADS_MIN Number(20,4) NOT NULL,
MAXDUARTIONTHREADS_MAX Number(20,4) NOT NULL,
MAXDUARTIONTHREADS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluThrdTest_TREND ADD constraint PK_MariaCluThrdTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluThrdTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluThrdTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTALTHREADS_MIN VARCHAR2(256) NOT NULL,
TOTALTHREADS_MAX VARCHAR2(256) NOT NULL,
BACKGROUNDTHREADS_MIN VARCHAR2(256) NOT NULL,
BACKGROUNDTHREADS_MAX VARCHAR2(256) NOT NULL,
FOREGROUNDTHREADS_MIN VARCHAR2(256) NOT NULL,
FOREGROUNDTHREADS_MAX VARCHAR2(256) NOT NULL,
KILLINGTHREADS_MIN VARCHAR2(256) NOT NULL,
KILLINGTHREADS_MAX VARCHAR2(256) NOT NULL,
ERRORTHREADS_MIN VARCHAR2(256) NOT NULL,
ERRORTHREADS_MAX VARCHAR2(256) NOT NULL,
DELAYEDINSERTTHREADS_MIN VARCHAR2(256) NOT NULL,
DELAYEDINSERTTHREADS_MAX VARCHAR2(256) NOT NULL,
RETRIEVEDLOGDATATHREADS_MIN VARCHAR2(256) NOT NULL,
RETRIEVEDLOGDATATHREADS_MAX VARCHAR2(256) NOT NULL,
MAXDUARTIONTHREADS_MIN VARCHAR2(256) NOT NULL,
MAXDUARTIONTHREADS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluThrdTest_THRESH ADD constraint PK_MariaCluThrdTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluThrdTest_THRESH ON MariaCluThrdTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluThrdTest ON MariaCluThrdTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluThrdTest ON MariaCluThrdTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluTranTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluTranTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
USERCOMMITS Number(20,4) NOT NULL,
USERCOMMITS_ST varchar2(32) NOT NULL,
USERROLLBACKS Number(20,4) NOT NULL,
USERROLLBACKS_ST varchar2(32) NOT NULL,
PERCENTAGEROLLBACKS Number(20,4) NOT NULL,
PERCENTAGEROLLBACKS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluTranTest ON MariaCluTranTest(MSMT_TIME);
ALTER TABLE MariaCluTranTest ADD constraint PK_MariaCluTranTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluTranTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluTranTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
USERCOMMITS_MIN Number(20,4) NOT NULL,
USERCOMMITS_MAX Number(20,4) NOT NULL,
USERCOMMITS_STCNT varchar2(32) NOT NULL,
USERROLLBACKS_MIN Number(20,4) NOT NULL,
USERROLLBACKS_MAX Number(20,4) NOT NULL,
USERROLLBACKS_STCNT varchar2(32) NOT NULL,
PERCENTAGEROLLBACKS_MIN Number(20,4) NOT NULL,
PERCENTAGEROLLBACKS_MAX Number(20,4) NOT NULL,
PERCENTAGEROLLBACKS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluTranTest_TREND ADD constraint PK_MariaCluTranTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluTranTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluTranTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
USERCOMMITS_MIN VARCHAR2(256) NOT NULL,
USERCOMMITS_MAX VARCHAR2(256) NOT NULL,
USERROLLBACKS_MIN VARCHAR2(256) NOT NULL,
USERROLLBACKS_MAX VARCHAR2(256) NOT NULL,
PERCENTAGEROLLBACKS_MIN VARCHAR2(256) NOT NULL,
PERCENTAGEROLLBACKS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluTranTest_THRESH ADD constraint PK_MariaCluTranTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluTranTest_THRESH ON MariaCluTranTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluTranTest ON MariaCluTranTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluTranTest ON MariaCluTranTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluUptmTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluUptmTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ISDATABASEREBOOTED Number(20,4) NOT NULL,
ISDATABASEREBOOTED_ST varchar2(32) NOT NULL,
DIFFUPTIME Number(20,4) NOT NULL,
DIFFUPTIME_ST varchar2(32) NOT NULL,
UPTIME Number(20,4) NOT NULL,
UPTIME_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluUptmTest ON MariaCluUptmTest(MSMT_TIME);
ALTER TABLE MariaCluUptmTest ADD constraint PK_MariaCluUptmTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluUptmTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluUptmTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
ISDATABASEREBOOTED_MIN Number(20,4) NOT NULL,
ISDATABASEREBOOTED_MAX Number(20,4) NOT NULL,
ISDATABASEREBOOTED_STCNT varchar2(32) NOT NULL,
DIFFUPTIME_MIN Number(20,4) NOT NULL,
DIFFUPTIME_MAX Number(20,4) NOT NULL,
DIFFUPTIME_STCNT varchar2(32) NOT NULL,
UPTIME_MIN Number(20,4) NOT NULL,
UPTIME_MAX Number(20,4) NOT NULL,
UPTIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluUptmTest_TREND ADD constraint PK_MariaCluUptmTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluUptmTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluUptmTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ISDATABASEREBOOTED_MIN VARCHAR2(256) NOT NULL,
ISDATABASEREBOOTED_MAX VARCHAR2(256) NOT NULL,
DIFFUPTIME_MIN VARCHAR2(256) NOT NULL,
DIFFUPTIME_MAX VARCHAR2(256) NOT NULL,
UPTIME_MIN VARCHAR2(256) NOT NULL,
UPTIME_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluUptmTest_THRESH ADD constraint PK_MariaCluUptmTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluUptmTest_THRESH ON MariaCluUptmTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluUptmTest ON MariaCluUptmTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluUptmTest ON MariaCluUptmTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluUsPrTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluUsPrTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTALPROCESS Number(20,4) NOT NULL,
TOTALPROCESS_ST varchar2(32) NOT NULL,
ACTIVEPROCESS Number(20,4) NOT NULL,
ACTIVEPROCESS_ST varchar2(32) NOT NULL,
IDLEPROCESS Number(20,4) NOT NULL,
IDLEPROCESS_ST varchar2(32) NOT NULL,
INACTIVEPROCESS Number(20,4) NOT NULL,
INACTIVEPROCESS_ST varchar2(32) NOT NULL,
MAXIMUMCONNECTIONS Number(20,4) NOT NULL,
MAXIMUMCONNECTIONS_ST varchar2(32) NOT NULL,
CONNECTIONUSAGE Number(20,4) NOT NULL,
CONNECTIONUSAGE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluUsPrTest ON MariaCluUsPrTest(MSMT_TIME);
ALTER TABLE MariaCluUsPrTest ADD constraint PK_MariaCluUsPrTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluUsPrTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluUsPrTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTALPROCESS_MIN Number(20,4) NOT NULL,
TOTALPROCESS_MAX Number(20,4) NOT NULL,
TOTALPROCESS_STCNT varchar2(32) NOT NULL,
ACTIVEPROCESS_MIN Number(20,4) NOT NULL,
ACTIVEPROCESS_MAX Number(20,4) NOT NULL,
ACTIVEPROCESS_STCNT varchar2(32) NOT NULL,
IDLEPROCESS_MIN Number(20,4) NOT NULL,
IDLEPROCESS_MAX Number(20,4) NOT NULL,
IDLEPROCESS_STCNT varchar2(32) NOT NULL,
INACTIVEPROCESS_MIN Number(20,4) NOT NULL,
INACTIVEPROCESS_MAX Number(20,4) NOT NULL,
INACTIVEPROCESS_STCNT varchar2(32) NOT NULL,
MAXIMUMCONNECTIONS_MIN Number(20,4) NOT NULL,
MAXIMUMCONNECTIONS_MAX Number(20,4) NOT NULL,
MAXIMUMCONNECTIONS_STCNT varchar2(32) NOT NULL,
CONNECTIONUSAGE_MIN Number(20,4) NOT NULL,
CONNECTIONUSAGE_MAX Number(20,4) NOT NULL,
CONNECTIONUSAGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluUsPrTest_TREND ADD constraint PK_MariaCluUsPrTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluUsPrTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluUsPrTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTALPROCESS_MIN VARCHAR2(256) NOT NULL,
TOTALPROCESS_MAX VARCHAR2(256) NOT NULL,
ACTIVEPROCESS_MIN VARCHAR2(256) NOT NULL,
ACTIVEPROCESS_MAX VARCHAR2(256) NOT NULL,
IDLEPROCESS_MIN VARCHAR2(256) NOT NULL,
IDLEPROCESS_MAX VARCHAR2(256) NOT NULL,
INACTIVEPROCESS_MIN VARCHAR2(256) NOT NULL,
INACTIVEPROCESS_MAX VARCHAR2(256) NOT NULL,
MAXIMUMCONNECTIONS_MIN VARCHAR2(256) NOT NULL,
MAXIMUMCONNECTIONS_MAX VARCHAR2(256) NOT NULL,
CONNECTIONUSAGE_MIN VARCHAR2(256) NOT NULL,
CONNECTIONUSAGE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluUsPrTest_THRESH ADD constraint PK_MariaCluUsPrTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluUsPrTest_THRESH ON MariaCluUsPrTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluUsPrTest ON MariaCluUsPrTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluUsPrTest ON MariaCluUsPrTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MariaCluWtEtTest CASCADE CONSTRAINTS;
CREATE TABLE MariaCluWtEtTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TOTALWAITS Number(20,4) NOT NULL,
TOTALWAITS_ST varchar2(32) NOT NULL,
READWAITS Number(20,4) NOT NULL,
READWAITS_ST varchar2(32) NOT NULL,
READWAITSRATE Number(20,4) NOT NULL,
READWAITSRATE_ST varchar2(32) NOT NULL,
MAXDURATIONFORREAD Number(20,4) NOT NULL,
MAXDURATIONFORREAD_ST varchar2(32) NOT NULL,
WRITEWAITS Number(20,4) NOT NULL,
WRITEWAITS_ST varchar2(32) NOT NULL,
WRITEWAITSRATE Number(20,4) NOT NULL,
WRITEWAITSRATE_ST varchar2(32) NOT NULL,
MAXDUARIONFORWRITE Number(20,4) NOT NULL,
MAXDUARIONFORWRITE_ST varchar2(32) NOT NULL,
LOCKWAITS Number(20,4) NOT NULL,
LOCKWAITS_ST varchar2(32) NOT NULL,
LOCKWAITSRATE Number(20,4) NOT NULL,
LOCKWAITSRATE_ST varchar2(32) NOT NULL,
MAXDURATIONFORLOCKS Number(20,4) NOT NULL,
MAXDURATIONFORLOCKS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MariaCluWtEtTest ON MariaCluWtEtTest(MSMT_TIME);
ALTER TABLE MariaCluWtEtTest ADD constraint PK_MariaCluWtEtTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MariaCluWtEtTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MariaCluWtEtTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TOTALWAITS_MIN Number(20,4) NOT NULL,
TOTALWAITS_MAX Number(20,4) NOT NULL,
TOTALWAITS_STCNT varchar2(32) NOT NULL,
READWAITS_MIN Number(20,4) NOT NULL,
READWAITS_MAX Number(20,4) NOT NULL,
READWAITS_STCNT varchar2(32) NOT NULL,
READWAITSRATE_MIN Number(20,4) NOT NULL,
READWAITSRATE_MAX Number(20,4) NOT NULL,
READWAITSRATE_STCNT varchar2(32) NOT NULL,
MAXDURATIONFORREAD_MIN Number(20,4) NOT NULL,
MAXDURATIONFORREAD_MAX Number(20,4) NOT NULL,
MAXDURATIONFORREAD_STCNT varchar2(32) NOT NULL,
WRITEWAITS_MIN Number(20,4) NOT NULL,
WRITEWAITS_MAX Number(20,4) NOT NULL,
WRITEWAITS_STCNT varchar2(32) NOT NULL,
WRITEWAITSRATE_MIN Number(20,4) NOT NULL,
WRITEWAITSRATE_MAX Number(20,4) NOT NULL,
WRITEWAITSRATE_STCNT varchar2(32) NOT NULL,
MAXDUARIONFORWRITE_MIN Number(20,4) NOT NULL,
MAXDUARIONFORWRITE_MAX Number(20,4) NOT NULL,
MAXDUARIONFORWRITE_STCNT varchar2(32) NOT NULL,
LOCKWAITS_MIN Number(20,4) NOT NULL,
LOCKWAITS_MAX Number(20,4) NOT NULL,
LOCKWAITS_STCNT varchar2(32) NOT NULL,
LOCKWAITSRATE_MIN Number(20,4) NOT NULL,
LOCKWAITSRATE_MAX Number(20,4) NOT NULL,
LOCKWAITSRATE_STCNT varchar2(32) NOT NULL,
MAXDURATIONFORLOCKS_MIN Number(20,4) NOT NULL,
MAXDURATIONFORLOCKS_MAX Number(20,4) NOT NULL,
MAXDURATIONFORLOCKS_STCNT varchar2(32) NOT NULL);

ALTER TABLE MariaCluWtEtTest_TREND ADD constraint PK_MariaCluWtEtTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MariaCluWtEtTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MariaCluWtEtTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTALWAITS_MIN VARCHAR2(256) NOT NULL,
TOTALWAITS_MAX VARCHAR2(256) NOT NULL,
READWAITS_MIN VARCHAR2(256) NOT NULL,
READWAITS_MAX VARCHAR2(256) NOT NULL,
READWAITSRATE_MIN VARCHAR2(256) NOT NULL,
READWAITSRATE_MAX VARCHAR2(256) NOT NULL,
MAXDURATIONFORREAD_MIN VARCHAR2(256) NOT NULL,
MAXDURATIONFORREAD_MAX VARCHAR2(256) NOT NULL,
WRITEWAITS_MIN VARCHAR2(256) NOT NULL,
WRITEWAITS_MAX VARCHAR2(256) NOT NULL,
WRITEWAITSRATE_MIN VARCHAR2(256) NOT NULL,
WRITEWAITSRATE_MAX VARCHAR2(256) NOT NULL,
MAXDUARIONFORWRITE_MIN VARCHAR2(256) NOT NULL,
MAXDUARIONFORWRITE_MAX VARCHAR2(256) NOT NULL,
LOCKWAITS_MIN VARCHAR2(256) NOT NULL,
LOCKWAITS_MAX VARCHAR2(256) NOT NULL,
LOCKWAITSRATE_MIN VARCHAR2(256) NOT NULL,
LOCKWAITSRATE_MAX VARCHAR2(256) NOT NULL,
MAXDURATIONFORLOCKS_MIN VARCHAR2(256) NOT NULL,
MAXDURATIONFORLOCKS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MariaCluWtEtTest_THRESH ADD constraint PK_MariaCluWtEtTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MariaCluWtEtTest_THRESH ON MariaCluWtEtTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MariaCluWtEtTest ON MariaCluWtEtTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MariaCluWtEtTest ON MariaCluWtEtTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMCallQualityTest CASCADE CONSTRAINTS;
CREATE TABLE MTMCallQualityTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MOS_SCORE Number(20,4) NOT NULL,
MOS_SCORE_ST varchar2(32) NOT NULL,
CONN_CHECKS_STATUS Number(20,4) NOT NULL,
CONN_CHECKS_STATUS_ST varchar2(32) NOT NULL,
PACKT_LOSS_RATE Number(20,4) NOT NULL,
PACKT_LOSS_RATE_ST varchar2(32) NOT NULL,
RTT_LATENCY Number(20,4) NOT NULL,
RTT_LATENCY_ST varchar2(32) NOT NULL,
JITTER Number(20,4) NOT NULL,
JITTER_ST varchar2(32) NOT NULL,
INFRA_CONN_ERR Number(20,4) NOT NULL,
INFRA_CONN_ERR_ST varchar2(32) NOT NULL,
URL_TOTAL_CONN Number(20,4) NOT NULL,
URL_TOTAL_CONN_ST varchar2(32) NOT NULL,
URL_SUCCESS_CONN Number(20,4) NOT NULL,
URL_SUCCESS_CONN_ST varchar2(32) NOT NULL,
URL_FAILED_CONN Number(20,4) NOT NULL,
URL_FAILED_CONN_ST varchar2(32) NOT NULL,
ECS_TOTAL_CONN Number(20,4) NOT NULL,
ECS_TOTAL_CONN_ST varchar2(32) NOT NULL,
ECS_SUCCESS_CONN Number(20,4) NOT NULL,
ECS_SUCCESS_CONN_ST varchar2(32) NOT NULL,
ECS_FAILED_CONN Number(20,4) NOT NULL,
ECS_FAILED_CONN_ST varchar2(32) NOT NULL,
CALLS_INITIATED Number(20,4) NOT NULL,
CALLS_INITIATED_ST varchar2(32) NOT NULL,
CALLS_COMPLETED Number(20,4) NOT NULL,
CALLS_COMPLETED_ST varchar2(32) NOT NULL,
CALLS_FAILED Number(20,4) NOT NULL,
CALLS_FAILED_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMCallQualityTest ON MTMCallQualityTest(MSMT_TIME);
ALTER TABLE MTMCallQualityTest ADD constraint PK_MTMCallQualityTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMCallQualityTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMCallQualityTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MOS_SCORE_MIN Number(20,4) NOT NULL,
MOS_SCORE_MAX Number(20,4) NOT NULL,
MOS_SCORE_STCNT varchar2(32) NOT NULL,
CONN_CHECKS_STATUS_MIN Number(20,4) NOT NULL,
CONN_CHECKS_STATUS_MAX Number(20,4) NOT NULL,
CONN_CHECKS_STATUS_STCNT varchar2(32) NOT NULL,
PACKT_LOSS_RATE_MIN Number(20,4) NOT NULL,
PACKT_LOSS_RATE_MAX Number(20,4) NOT NULL,
PACKT_LOSS_RATE_STCNT varchar2(32) NOT NULL,
RTT_LATENCY_MIN Number(20,4) NOT NULL,
RTT_LATENCY_MAX Number(20,4) NOT NULL,
RTT_LATENCY_STCNT varchar2(32) NOT NULL,
JITTER_MIN Number(20,4) NOT NULL,
JITTER_MAX Number(20,4) NOT NULL,
JITTER_STCNT varchar2(32) NOT NULL,
INFRA_CONN_ERR_MIN Number(20,4) NOT NULL,
INFRA_CONN_ERR_MAX Number(20,4) NOT NULL,
INFRA_CONN_ERR_STCNT varchar2(32) NOT NULL,
URL_TOTAL_CONN_MIN Number(20,4) NOT NULL,
URL_TOTAL_CONN_MAX Number(20,4) NOT NULL,
URL_TOTAL_CONN_STCNT varchar2(32) NOT NULL,
URL_SUCCESS_CONN_MIN Number(20,4) NOT NULL,
URL_SUCCESS_CONN_MAX Number(20,4) NOT NULL,
URL_SUCCESS_CONN_STCNT varchar2(32) NOT NULL,
URL_FAILED_CONN_MIN Number(20,4) NOT NULL,
URL_FAILED_CONN_MAX Number(20,4) NOT NULL,
URL_FAILED_CONN_STCNT varchar2(32) NOT NULL,
ECS_TOTAL_CONN_MIN Number(20,4) NOT NULL,
ECS_TOTAL_CONN_MAX Number(20,4) NOT NULL,
ECS_TOTAL_CONN_STCNT varchar2(32) NOT NULL,
ECS_SUCCESS_CONN_MIN Number(20,4) NOT NULL,
ECS_SUCCESS_CONN_MAX Number(20,4) NOT NULL,
ECS_SUCCESS_CONN_STCNT varchar2(32) NOT NULL,
ECS_FAILED_CONN_MIN Number(20,4) NOT NULL,
ECS_FAILED_CONN_MAX Number(20,4) NOT NULL,
ECS_FAILED_CONN_STCNT varchar2(32) NOT NULL,
CALLS_INITIATED_MIN Number(20,4) NOT NULL,
CALLS_INITIATED_MAX Number(20,4) NOT NULL,
CALLS_INITIATED_STCNT varchar2(32) NOT NULL,
CALLS_COMPLETED_MIN Number(20,4) NOT NULL,
CALLS_COMPLETED_MAX Number(20,4) NOT NULL,
CALLS_COMPLETED_STCNT varchar2(32) NOT NULL,
CALLS_FAILED_MIN Number(20,4) NOT NULL,
CALLS_FAILED_MAX Number(20,4) NOT NULL,
CALLS_FAILED_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMCallQualityTest_TREND ADD constraint PK_MTMCallQualityTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMCallQualityTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMCallQualityTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MOS_SCORE_MIN varchar2(256) NOT NULL,
MOS_SCORE_MAX varchar2(256) NOT NULL,
CONN_CHECKS_STATUS_MIN varchar2(256) NOT NULL,
CONN_CHECKS_STATUS_MAX varchar2(256) NOT NULL,
PACKT_LOSS_RATE_MIN varchar2(256) NOT NULL,
PACKT_LOSS_RATE_MAX varchar2(256) NOT NULL,
RTT_LATENCY_MIN varchar2(256) NOT NULL,
RTT_LATENCY_MAX varchar2(256) NOT NULL,
JITTER_MIN varchar2(256) NOT NULL,
JITTER_MAX varchar2(256) NOT NULL,
INFRA_CONN_ERR_MIN varchar2(256) NOT NULL,
INFRA_CONN_ERR_MAX varchar2(256) NOT NULL,
URL_TOTAL_CONN_MIN varchar2(256) NOT NULL,
URL_TOTAL_CONN_MAX varchar2(256) NOT NULL,
URL_SUCCESS_CONN_MIN varchar2(256) NOT NULL,
URL_SUCCESS_CONN_MAX varchar2(256) NOT NULL,
URL_FAILED_CONN_MIN varchar2(256) NOT NULL,
URL_FAILED_CONN_MAX varchar2(256) NOT NULL,
ECS_TOTAL_CONN_MIN varchar2(256) NOT NULL,
ECS_TOTAL_CONN_MAX varchar2(256) NOT NULL,
ECS_SUCCESS_CONN_MIN varchar2(256) NOT NULL,
ECS_SUCCESS_CONN_MAX varchar2(256) NOT NULL,
ECS_FAILED_CONN_MIN varchar2(256) NOT NULL,
ECS_FAILED_CONN_MAX varchar2(256) NOT NULL,
CALLS_INITIATED_MIN varchar2(256) NOT NULL,
CALLS_INITIATED_MAX varchar2(256) NOT NULL,
CALLS_COMPLETED_MIN varchar2(256) NOT NULL,
CALLS_COMPLETED_MAX varchar2(256) NOT NULL,
CALLS_FAILED_MIN varchar2(256) NOT NULL,
CALLS_FAILED_MAX varchar2(256) NOT NULL
);

ALTER TABLE MTMCallQualityTest_THRESH ADD constraint PK_MTMCallQualityTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMCallQualityTest_THRESH ON MTMCallQualityTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMCallQualityTest ON MTMCallQualityTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMCallQualityTest ON MTMCallQualityTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE CalendarEventTest CASCADE CONSTRAINTS;
CREATE TABLE CalendarEventTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Create_Event_Status Number(20,4) NOT NULL,
Create_Event_Status_ST varchar2(32) NOT NULL,
Create_Event_Time Number(20,4) NOT NULL,
Create_Event_Time_ST varchar2(32) NOT NULL,
List_Event_Status Number(20,4) NOT NULL,
List_Event_Status_ST varchar2(32) NOT NULL,
List_Event_Time Number(20,4) NOT NULL,
List_Event_Time_ST varchar2(32) NOT NULL,
Read_Event_Status Number(20,4) NOT NULL,
Read_Event_Status_ST varchar2(32) NOT NULL,
Read_Event_Time Number(20,4) NOT NULL,
Read_Event_Time_ST varchar2(32) NOT NULL,
Update_Event_Status Number(20,4) NOT NULL,
Update_Event_Status_ST varchar2(32) NOT NULL,
Update_Event_Time Number(20,4) NOT NULL,
Update_Event_Time_ST varchar2(32) NOT NULL,
Delete_Event_Status Number(20,4) NOT NULL,
Delete_Event_Status_ST varchar2(32) NOT NULL,
Delete_Event_Time Number(20,4) NOT NULL,
Delete_Event_Time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_CalendarEventTest ON CalendarEventTest(MSMT_TIME);
ALTER TABLE CalendarEventTest ADD constraint PK_CalendarEventTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE CalendarEventTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE CalendarEventTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Create_Event_Status_MIN Number(20,4) NOT NULL,
Create_Event_Status_MAX Number(20,4) NOT NULL,
Create_Event_Status_STCNT varchar2(32) NOT NULL,
Create_Event_Time_MIN Number(20,4) NOT NULL,
Create_Event_Time_MAX Number(20,4) NOT NULL,
Create_Event_Time_STCNT varchar2(32) NOT NULL,
List_Event_Status_MIN Number(20,4) NOT NULL,
List_Event_Status_MAX Number(20,4) NOT NULL,
List_Event_Status_STCNT varchar2(32) NOT NULL,
List_Event_Time_MIN Number(20,4) NOT NULL,
List_Event_Time_MAX Number(20,4) NOT NULL,
List_Event_Time_STCNT varchar2(32) NOT NULL,
Read_Event_Status_MIN Number(20,4) NOT NULL,
Read_Event_Status_MAX Number(20,4) NOT NULL,
Read_Event_Status_STCNT varchar2(32) NOT NULL,
Read_Event_Time_MIN Number(20,4) NOT NULL,
Read_Event_Time_MAX Number(20,4) NOT NULL,
Read_Event_Time_STCNT varchar2(32) NOT NULL,
Update_Event_Status_MIN Number(20,4) NOT NULL,
Update_Event_Status_MAX Number(20,4) NOT NULL,
Update_Event_Status_STCNT varchar2(32) NOT NULL,
Update_Event_Time_MIN Number(20,4) NOT NULL,
Update_Event_Time_MAX Number(20,4) NOT NULL,
Update_Event_Time_STCNT varchar2(32) NOT NULL,
Delete_Event_Status_MIN Number(20,4) NOT NULL,
Delete_Event_Status_MAX Number(20,4) NOT NULL,
Delete_Event_Status_STCNT varchar2(32) NOT NULL,
Delete_Event_Time_MIN Number(20,4) NOT NULL,
Delete_Event_Time_MAX Number(20,4) NOT NULL,
Delete_Event_Time_STCNT varchar2(32) NOT NULL);

ALTER TABLE CalendarEventTest_TREND ADD constraint PK_CalendarEventTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE CalendarEventTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE CalendarEventTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Create_Event_Status_MIN VARCHAR2(256) NOT NULL,
Create_Event_Status_MAX VARCHAR2(256) NOT NULL,
Create_Event_Time_MIN VARCHAR2(256) NOT NULL,
Create_Event_Time_MAX VARCHAR2(256) NOT NULL,
List_Event_Status_MIN VARCHAR2(256) NOT NULL,
List_Event_Status_MAX VARCHAR2(256) NOT NULL,
List_Event_Time_MIN VARCHAR2(256) NOT NULL,
List_Event_Time_MAX VARCHAR2(256) NOT NULL,
Read_Event_Status_MIN VARCHAR2(256) NOT NULL,
Read_Event_Status_MAX VARCHAR2(256) NOT NULL,
Read_Event_Time_MIN VARCHAR2(256) NOT NULL,
Read_Event_Time_MAX VARCHAR2(256) NOT NULL,
Update_Event_Status_MIN VARCHAR2(256) NOT NULL,
Update_Event_Status_MAX VARCHAR2(256) NOT NULL,
Update_Event_Time_MIN VARCHAR2(256) NOT NULL,
Update_Event_Time_MAX VARCHAR2(256) NOT NULL,
Delete_Event_Status_MIN VARCHAR2(256) NOT NULL,
Delete_Event_Status_MAX VARCHAR2(256) NOT NULL,
Delete_Event_Time_MIN VARCHAR2(256) NOT NULL,
Delete_Event_Time_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE CalendarEventTest_THRESH ADD constraint PK_CalendarEventTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_CalendarEventTest_THRESH ON CalendarEventTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_CalendarEventTest ON CalendarEventTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_CalendarEventTest ON CalendarEventTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE RegLogMonitorTest CASCADE CONSTRAINTS;
CREATE TABLE RegLogMonitorTest (
	 TRGT_HOST 	 varchar2(32),
	 PORT_NO 	 varchar2(32),
	 SITE_NAME 	 varchar2(64) ,
	 INFO 		 varchar2(128) ,
	 MSMT_HOST 	 varchar2(32) ,
	 MSMT_TIME 	 date ,
	 matchedLines 	 NUMBER(20, 4) NOT NULL,
	 matchedLines_ST 	 varchar2(32) NOT NULL,
	 discardedLines 	 NUMBER(20, 4) NOT NULL,
	 discardedLines_ST 	 varchar2(32) NOT NULL,
	 duplicateLines 	 NUMBER(20, 4) NOT NULL,
	 duplicateLines_ST 	 varchar2(32) NOT NULL,
	 totalLines 	 NUMBER(20, 4) NOT NULL,
	 totalLines_ST 	 varchar2(32) NOT NULL,
	 PerofMatchedLines 	 NUMBER(20, 4) NOT NULL,
	 PerofMatchedLines_ST 	 varchar2(32) NOT NULL,
	 PerofDuplicateLines 	 NUMBER(20, 4) NOT NULL,
	 PerofDuplicateLines_ST 	 varchar2(32) NOT NULL,
	 LineRate 	 NUMBER(20, 4) NOT NULL,
	 LineRate_ST 	 varchar2(32) NOT NULL
);
CREATE INDEX IDX_RegLogMonitorTest ON RegLogMonitorTest(MSMT_TIME);
ALTER TABLE RegLogMonitorTest ADD constraint PK_RegLogMonitorTest PRIMARY KEY (TRGT_HOST, PORT_NO, SITE_NAME, INFO, MSMT_HOST, MSMT_TIME);

DROP TABLE RegLogMonitorTest_TREND  CASCADE CONSTRAINTS;
CREATE TABLE RegLogMonitorTest_TREND (
	 TRGT_HOST 	 varchar2(32) ,
	 PORT_NO 	 varchar2(32) ,
	 SITE_NAME 	 varchar2(64) ,
	 INFO 		 varchar2(128) ,
	 MSMT_HOST 	 varchar2(32) ,
	 MSMT_TIME 	 date ,
	 PERIOD 	 varchar2(32) ,
	 matchedLines_MIN 	 NUMBER(20,4) NOT NULL,
	 matchedLines_MAX 	 NUMBER(20,4) NOT NULL,
	 matchedLines_STCNT 	 varchar2(32) NOT NULL,
	 discardedLines_MIN 	 NUMBER(20,4) NOT NULL,
	 discardedLines_MAX 	 NUMBER(20,4) NOT NULL,
	 discardedLines_STCNT 	 varchar2(32) NOT NULL,
	 duplicateLines_MIN 	 NUMBER(20,4) NOT NULL,
	 duplicateLines_MAX 	 NUMBER(20,4) NOT NULL,
	 duplicateLines_STCNT 	 varchar2(32) NOT NULL,
	 totalLines_MIN 	 NUMBER(20,4) NOT NULL,
	 totalLines_MAX 	 NUMBER(20,4) NOT NULL,
	 totalLines_STCNT 	 varchar2(32) NOT NULL,
	 PerofMatchedLines_MIN 	 NUMBER(20,4) NOT NULL,
	 PerofMatchedLines_MAX 	 NUMBER(20,4) NOT NULL,
	 PerofMatchedLines_STCNT 	 varchar2(32) NOT NULL,
	 PerofDuplicateLines_MIN 	 NUMBER(20,4) NOT NULL,
	 PerofDuplicateLines_MAX 	 NUMBER(20,4) NOT NULL,
	 PerofDuplicateLines_STCNT 	 varchar2(32) NOT NULL,
	 LineRate_MIN 	 NUMBER(20,4) NOT NULL,
	 LineRate_MAX 	 NUMBER(20,4) NOT NULL,
	 LineRate_STCNT 	 varchar2(32) NOT NULL
);

ALTER TABLE RegLogMonitorTest_TREND ADD constraint PK_RegLogMonitorTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE RegLogMonitorTest_THRESH  CASCADE CONSTRAINTS;
CREATE TABLE RegLogMonitorTest_THRESH (
	 TRGT_HOST 	 varchar2(32) ,
	 PORT_NO 	 varchar2(32) ,
	 SITE_NAME 	 varchar2(64) ,
	 INFO 		 varchar2(128) ,
	 MSMT_HOST 	 varchar2(32) ,
	 MSMT_TIME_START 	 date ,
	 MSMT_TIME_END 	 date ,
	 matchedLines_MIN 	 varchar2(256) NOT NULL,
	 matchedLines_MAX 	 varchar2(256) NOT NULL,
	 discardedLines_MIN 	 varchar2(256) NOT NULL,
	 discardedLines_MAX 	 varchar2(256) NOT NULL,
	 duplicateLines_MIN 	 varchar2(256) NOT NULL,
	 duplicateLines_MAX 	 varchar2(256) NOT NULL,
	 totalLines_MIN 	 varchar2(256) NOT NULL,
	 totalLines_MAX 	 varchar2(256) NOT NULL,
	 PerofMatchedLines_MIN 	 varchar2(256) NOT NULL,
	 PerofMatchedLines_MAX 	 varchar2(256) NOT NULL,
	 PerofDuplicateLines_MIN 	 varchar2(256) NOT NULL,
	 PerofDuplicateLines_MAX 	 varchar2(256) NOT NULL,
	 LineRate_MIN 	 varchar2(256) NOT NULL,
	 LineRate_MAX 	 varchar2(256) NOT NULL
);
ALTER TABLE RegLogMonitorTest_THRESH ADD constraint PK_RegLogMonitorTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RegLogMonitorTest_THRESH ON RegLogMonitorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RegLogMonitorTest ON RegLogMonitorTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RegLogMonitorTest ON RegLogMonitorTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE OraRacDgTest CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgTest(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL,
MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
IS_DG_ENABLED Number(20,4) NOT NULL,
IS_DG_ENABLED_ST Varchar2(32) NOT NULL,
DB_MODE Number(20,4) NOT NULL,
DB_MODE_ST Varchar2(32) NOT NULL,
DB_OPEN_MODE Number(20,4) NOT NULL,
DB_OPEN_MODE_ST Varchar2(32) NOT NULL,
IS_SWITCHED Number(20,4) NOT NULL,
IS_SWITCHED_ST Varchar2(32) NOT NULL);

CREATE INDEX IDX_OraRacDgTest ON OraRacDgTest(MSMT_TIME);
ALTER TABLE OraRacDgTest ADD constraint PK_OraRacDgTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraRacDgTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgTest_TREND(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL,
MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	Varchar2(32) NOT NULL,
IS_DG_ENABLED_MIN Number(20,4) NOT NULL,
IS_DG_ENABLED_MAX Number(20,4) NOT NULL,
IS_DG_ENABLED_STCNT Varchar2(32) NOT NULL,
DB_MODE_MIN Number(20,4) NOT NULL,
DB_MODE_MAX Number(20,4) NOT NULL,
DB_MODE_STCNT Varchar2(32) NOT NULL,
DB_OPEN_MODE_MIN Number(20,4) NOT NULL,
DB_OPEN_MODE_MAX Number(20,4) NOT NULL,
DB_OPEN_MODE_STCNT Varchar2(32) NOT NULL,
IS_SWITCHED_MIN Number(20,4) NOT NULL,
IS_SWITCHED_MAX Number(20,4) NOT NULL,
IS_SWITCHED_STCNT Varchar2(32) NOT NULL);

ALTER TABLE OraRacDgTest_TREND ADD constraint PK_OraRacDgTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraRacDgTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgTest_THRESH(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL
,MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
IS_DG_ENABLED_MIN Varchar2(256) NOT NULL,
IS_DG_ENABLED_MAX Varchar2(256) NOT NULL,
DB_MODE_MIN Varchar2(256) NOT NULL,
DB_MODE_MAX Varchar2(256) NOT NULL,
DB_OPEN_MODE_MIN Varchar2(256) NOT NULL,
DB_OPEN_MODE_MAX Varchar2(256) NOT NULL,
IS_SWITCHED_MIN Varchar2(256) NOT NULL,
IS_SWITCHED_MAX Varchar2(256) NOT NULL);

ALTER TABLE OraRacDgTest_THRESH ADD constraint PK_OraRacDgTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraRacDgTest_THRESH ON OraRacDgTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_OraRacDgTest ON OraRacDgTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_OraRacDgTest ON OraRacDgTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE OraRacDgStatsTest CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgStatsTest(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL,
MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
APPLYLAG Number(20,4) NOT NULL,
APPLYLAG_ST Varchar2(32) NOT NULL,
TRANSPORTLAG Number(20,4) NOT NULL,
TRANSPORTLAG_ST Varchar2(32) NOT NULL,
APPLYFINISHTIMELAG Number(20,4) NOT NULL,
APPLYFINISHTIMELAG_ST Varchar2(32) NOT NULL,
ESTIMATEDSTARTEDTIME Number(20,4) NOT NULL,
ESTIMATEDSTARTEDTIME_ST Varchar2(32) NOT NULL);

CREATE INDEX IDX_OraRacDgStatsTest ON OraRacDgStatsTest(MSMT_TIME);
ALTER TABLE OraRacDgStatsTest ADD constraint PK_OraRacDgStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE OraRacDgStatsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgStatsTest_TREND(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL,
MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	Varchar2(32) NOT NULL,
APPLYLAG_MIN Number(20,4) NOT NULL,
APPLYLAG_MAX Number(20,4) NOT NULL,
APPLYLAG_STCNT Varchar2(32) NOT NULL,
TRANSPORTLAG_MIN Number(20,4) NOT NULL,
TRANSPORTLAG_MAX Number(20,4) NOT NULL,
TRANSPORTLAG_STCNT Varchar2(32) NOT NULL,
APPLYFINISHTIMELAG_MIN Number(20,4) NOT NULL,
APPLYFINISHTIMELAG_MAX Number(20,4) NOT NULL,
APPLYFINISHTIMELAG_STCNT Varchar2(32) NOT NULL,
ESTIMATEDSTARTEDTIME_MIN Number(20,4) NOT NULL,
ESTIMATEDSTARTEDTIME_MAX Number(20,4) NOT NULL,
ESTIMATEDSTARTEDTIME_STCNT Varchar2(32) NOT NULL);

ALTER TABLE OraRacDgStatsTest_TREND ADD constraint PK_OraRacDgStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraRacDgStatsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgStatsTest_THRESH(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL,
MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
APPLYLAG_MIN Varchar2(256) NOT NULL,
APPLYLAG_MAX Varchar2(256) NOT NULL,
TRANSPORTLAG_MIN Varchar2(256) NOT NULL,
TRANSPORTLAG_MAX Varchar2(256) NOT NULL,
APPLYFINISHTIMELAG_MIN Varchar2(256) NOT NULL,
APPLYFINISHTIMELAG_MAX Varchar2(256) NOT NULL,
ESTIMATEDSTARTEDTIME_MIN Varchar2(256) NOT NULL,
ESTIMATEDSTARTEDTIME_MAX Varchar2(256) NOT NULL);

ALTER TABLE OraRacDgStatsTest_THRESH ADD constraint PK_OraRacDgStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraRacDgStatsTest_THRESH ON OraRacDgStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_OraRacDgStatsTest ON OraRacDgStatsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_OraRacDgStatsTest ON OraRacDgStatsTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE OraRacDgLogStTest CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgLogStTest(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL,
MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
STATUS Number(20,4) NOT NULL,
STATUS_ST Varchar2(32) NOT NULL,
RECOVERY_MODE Number(20,4) NOT NULL,
RECOVERY_MODE_ST Varchar2(32) NOT NULL);

CREATE INDEX IDX_OraRacDgLogStTest ON OraRacDgLogStTest(MSMT_TIME);
ALTER TABLE OraRacDgLogStTest ADD constraint PK_OraRacDgLogStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraRacDgLogStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgLogStTest_TREND(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL,
MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	Varchar2(32) NOT NULL,
STATUS_MIN Number(20,4) NOT NULL,
STATUS_MAX Number(20,4) NOT NULL,
STATUS_STCNT Varchar2(32) NOT NULL,
RECOVERY_MODE_MIN Number(20,4) NOT NULL,
RECOVERY_MODE_MAX Number(20,4) NOT NULL,
RECOVERY_MODE_STCNT Varchar2(32) NOT NULL);

ALTER TABLE OraRacDgLogStTest_TREND ADD constraint PK_OraRacDgLogStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraRacDgLogStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgLogStTest_THRESH(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL
,MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
STATUS_MIN Varchar2(256) NOT NULL,
STATUS_MAX Varchar2(256) NOT NULL,
RECOVERY_MODE_MIN Varchar2(256) NOT NULL,
RECOVERY_MODE_MAX Varchar2(256) NOT NULL);

ALTER TABLE OraRacDgLogStTest_THRESH ADD constraint PK_OraRacDgLogStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraRacDgLogStTest_THRESH ON OraRacDgLogStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_OraRacDgLogStTest ON OraRacDgLogStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_OraRacDgLogStTest ON OraRacDgLogStTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE OraRacDgLogGapTest CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgLogGapTest(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL,
MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
LOG_SEQ_ARCHIVED Number(20,4) NOT NULL,
LOG_SEQ_ARCHIVED_ST Varchar2(32) NOT NULL,
LOG_SEQ_APPLIED Number(20,4) NOT NULL,
LOG_SEQ_APPLIED_ST Varchar2(32) NOT NULL,
LOG_GAP Number(20,4) NOT NULL,
LOG_GAP_ST Varchar2(32) NOT NULL,
LOG_GAP_STATUS Number(20,4) NOT NULL,
LOG_GAP_STATUS_ST Varchar2(32) NOT NULL);

CREATE INDEX IDX_OraRacDgLogGapTest ON OraRacDgLogGapTest(MSMT_TIME);
ALTER TABLE OraRacDgLogGapTest ADD constraint PK_OraRacDgLogGapTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraRacDgLogGapTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgLogGapTest_TREND(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL,
MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	Varchar2(32) NOT NULL,
LOG_SEQ_ARCHIVED_MIN Number(20,4) NOT NULL,
LOG_SEQ_ARCHIVED_MAX Number(20,4) NOT NULL,
LOG_SEQ_ARCHIVED_STCNT Varchar2(32) NOT NULL,
LOG_SEQ_APPLIED_MIN Number(20,4) NOT NULL,
LOG_SEQ_APPLIED_MAX Number(20,4) NOT NULL,
LOG_SEQ_APPLIED_STCNT Varchar2(32) NOT NULL,
LOG_GAP_MIN Number(20,4) NOT NULL,
LOG_GAP_MAX Number(20,4) NOT NULL,
LOG_GAP_STCNT Varchar2(32) NOT NULL,
LOG_GAP_STATUS_MIN Number(20,4) NOT NULL,
LOG_GAP_STATUS_MAX Number(20,4) NOT NULL,
LOG_GAP_STATUS_STCNT Varchar2(32) NOT NULL);

ALTER TABLE OraRacDgLogGapTest_TREND ADD constraint PK_OraRacDgLogGapTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraRacDgLogGapTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgLogGapTest_THRESH(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL
,MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
LOG_SEQ_ARCHIVED_MIN Varchar2(256) NOT NULL,
LOG_SEQ_ARCHIVED_MAX Varchar2(256) NOT NULL,
LOG_SEQ_APPLIED_MIN Varchar2(256) NOT NULL,
LOG_SEQ_APPLIED_MAX Varchar2(256) NOT NULL,
LOG_GAP_MIN Varchar2(256) NOT NULL,
LOG_GAP_MAX Varchar2(256) NOT NULL,
LOG_GAP_STATUS_MIN Varchar2(256) NOT NULL,
LOG_GAP_STATUS_MAX Varchar2(256) NOT NULL);

ALTER TABLE OraRacDgLogGapTest_THRESH ADD constraint PK_OraRacDgLogGapTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraRacDgLogGapTest_THRESH ON OraRacDgLogGapTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_OraRacDgLogGapTest ON OraRacDgLogGapTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_OraRacDgLogGapTest ON OraRacDgLogGapTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE OraRacDgErrorTest CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgErrorTest(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL,
MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
INFORMATIONAL_MSG Number(20,4) NOT NULL,
INFORMATIONAL_MSG_ST Varchar2(32) NOT NULL,
WARNING_MSG Number(20,4) NOT NULL,
WARNING_MSG_ST Varchar2(32) NOT NULL,
ERROR_MSG Number(20,4) NOT NULL,
ERROR_MSG_ST Varchar2(32) NOT NULL,
FATAL_MSG Number(20,4) NOT NULL,
FATAL_MSG_ST Varchar2(32) NOT NULL);

CREATE INDEX IDX_OraRacDgErrorTest ON OraRacDgErrorTest(MSMT_TIME);
ALTER TABLE OraRacDgErrorTest ADD constraint PK_OraRacDgErrorTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraRacDgErrorTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgErrorTest_TREND(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL,
MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	Varchar2(32) NOT NULL,
INFORMATIONAL_MSG_MIN Number(20,4) NOT NULL,
INFORMATIONAL_MSG_MAX Number(20,4) NOT NULL,
INFORMATIONAL_MSG_STCNT Varchar2(32) NOT NULL,
WARNING_MSG_MIN Number(20,4) NOT NULL,
WARNING_MSG_MAX Number(20,4) NOT NULL,
WARNING_MSG_STCNT Varchar2(32) NOT NULL,
ERROR_MSG_MIN Number(20,4) NOT NULL,
ERROR_MSG_MAX Number(20,4) NOT NULL,
ERROR_MSG_STCNT Varchar2(32) NOT NULL,
FATAL_MSG_MIN Number(20,4) NOT NULL,
FATAL_MSG_MAX Number(20,4) NOT NULL,
FATAL_MSG_STCNT Varchar2(32) NOT NULL);

ALTER TABLE OraRacDgErrorTest_TREND ADD constraint PK_OraRacDgErrorTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraRacDgErrorTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraRacDgErrorTest_THRESH(
TRGT_HOST       Varchar2(32) NOT NULL,
PORT_NO         Varchar2(32) NOT NULL,
SITE_NAME       Varchar2(64) NOT NULL,
INFO            Varchar2(128) NOT NULL
,MSMT_HOST       Varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
INFORMATIONAL_MSG_MIN Varchar2(256) NOT NULL,
INFORMATIONAL_MSG_MAX Varchar2(256) NOT NULL,
WARNING_MSG_MIN Varchar2(256) NOT NULL,
WARNING_MSG_MAX Varchar2(256) NOT NULL,
ERROR_MSG_MIN Varchar2(256) NOT NULL,
ERROR_MSG_MAX Varchar2(256) NOT NULL,
FATAL_MSG_MIN Varchar2(256) NOT NULL,
FATAL_MSG_MAX Varchar2(256) NOT NULL);

ALTER TABLE OraRacDgErrorTest_THRESH ADD constraint PK_OraRacDgErrorTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraRacDgErrorTest_THRESH ON OraRacDgErrorTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_OraRacDgErrorTest ON OraRacDgErrorTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_OraRacDgErrorTest ON OraRacDgErrorTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE OraRacArchAreaTest CASCADE CONSTRAINTS;
CREATE TABLE OraRacArchAreaTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ARCHIVE_AREA_USED NUMBER(20,4) NOT NULL,
ARCHIVE_AREA_USED_ST varchar2(32) NOT NULL,
TOTAL_USED_AREA NUMBER(20,4) NOT NULL,
TOTAL_USED_AREA_ST varchar2(32) NOT NULL,
PCT_ARCHIVE_AREA_USED NUMBER(20,4) NOT NULL,
PCT_ARCHIVE_AREA_USED_ST varchar2(32) NOT NULL,
AVAILABLE NUMBER(20,4) NOT NULL,
AVAILABLE_ST varchar2(32) NOT NULL,
PCT_AVAILABLE NUMBER(20,4) NOT NULL,
PCT_AVAILABLE_ST varchar2(32) NOT NULL,
ARCH_GRTH NUMBER(20,4) NOT NULL,
ARCH_GRTH_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_OraRacArchAreaTest ON OraRacArchAreaTest(MSMT_TIME);
ALTER TABLE OraRacArchAreaTest ADD constraint PK_OraRacArchAreaTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraRacArchAreaTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraRacArchAreaTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ARCHIVE_AREA_USED_MIN NUMBER(20,4) NOT NULL,
ARCHIVE_AREA_USED_MAX NUMBER(20,4) NOT NULL,
ARCHIVE_AREA_USED_STCNT varchar2(32) NOT NULL,
TOTAL_USED_AREA_MIN NUMBER(20,4) NOT NULL,
TOTAL_USED_AREA_MAX NUMBER(20,4) NOT NULL,
TOTAL_USED_AREA_STCNT varchar2(32) NOT NULL,
PCT_ARCHIVE_AREA_USED_MIN NUMBER(20,4) NOT NULL,
PCT_ARCHIVE_AREA_USED_MAX NUMBER(20,4) NOT NULL,
PCT_ARCHIVE_AREA_USED_STCNT varchar2(32) NOT NULL,
AVAILABLE_MIN NUMBER(20,4) NOT NULL,
AVAILABLE_MAX NUMBER(20,4) NOT NULL,
AVAILABLE_STCNT varchar2(32) NOT NULL,
PCT_AVAILABLE_MIN NUMBER(20,4) NOT NULL,
PCT_AVAILABLE_MAX NUMBER(20,4) NOT NULL,
PCT_AVAILABLE_STCNT varchar2(32) NOT NULL,
ARCH_GRTH_MIN NUMBER(20,4) NOT NULL,
ARCH_GRTH_MAX NUMBER(20,4) NOT NULL,
ARCH_GRTH_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraRacArchAreaTest_TREND ADD constraint PK_OraRacArchAreaTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraRacArchAreaTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraRacArchAreaTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ARCHIVE_AREA_USED_MIN varchar2(256) NOT NULL,
ARCHIVE_AREA_USED_MAX varchar2(256) NOT NULL,
TOTAL_USED_AREA_MIN varchar2(256) NOT NULL,
TOTAL_USED_AREA_MAX varchar2(256) NOT NULL,
PCT_ARCHIVE_AREA_USED_MIN varchar2(256) NOT NULL,
PCT_ARCHIVE_AREA_USED_MAX varchar2(256) NOT NULL,
AVAILABLE_MIN varchar2(256) NOT NULL,
AVAILABLE_MAX varchar2(256) NOT NULL,
PCT_AVAILABLE_MIN varchar2(256) NOT NULL,
PCT_AVAILABLE_MAX varchar2(256) NOT NULL,
ARCH_GRTH_MIN varchar2(256) NOT NULL,
ARCH_GRTH_MAX varchar2(256) NOT NULL);

ALTER TABLE OraRacArchAreaTest_THRESH ADD constraint PK_OraRacArchAreaTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraRacArchAreaTest_THRESH ON OraRacArchAreaTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_OraRacArchAreaTest ON OraRacArchAreaTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_OraRacArchAreaTest ON OraRacArchAreaTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE OraRacDumpAreaTest CASCADE CONSTRAINTS;
CREATE TABLE OraRacDumpAreaTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
DUMP_AREA_USED NUMBER(20,4) NOT NULL,
DUMP_AREA_USED_ST varchar2(32) NOT NULL,
TOTAL_USED_AREA NUMBER(20,4) NOT NULL,
TOTAL_USED_AREA_ST varchar2(32) NOT NULL,
PCT_DUMP_AREA_USED NUMBER(20,4) NOT NULL,
PCT_DUMP_AREA_USED_ST varchar2(32) NOT NULL,
AVAILABLE NUMBER(20,4) NOT NULL,
AVAILABLE_ST varchar2(32) NOT NULL,
PCT_AVAILABLE NUMBER(20,4) NOT NULL,
PCT_AVAILABLE_ST varchar2(32) NOT NULL,
DUMP_GRTH NUMBER(20,4) NOT NULL, 
DUMP_GRTH_ST varchar2(32) NOT NULL,
DUMP_AVAIL NUMBER(20,4) NOT NULL,
DUMP_AVAIL_ST varchar2(32) NOT NULL,
DUMP_USD_PRCNT NUMBER(20,4) NOT NULL,
DUMP_USD_PRCNT_ST varchar2(32) NOT NULL,
DUMP_FREE_PRCNT NUMBER(20,4) NOT NULL,
DUMP_FREE_PRCNT_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_OraRacDumpAreaTest ON OraRacDumpAreaTest(MSMT_TIME);
ALTER TABLE OraRacDumpAreaTest ADD constraint PK_OraRacDumpAreaTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraRacDumpAreaTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraRacDumpAreaTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
DUMP_AREA_USED_MIN NUMBER(20,4) NOT NULL,
DUMP_AREA_USED_MAX NUMBER(20,4) NOT NULL,
DUMP_AREA_USED_STCNT varchar2(32) NOT NULL,
TOTAL_USED_AREA_MIN NUMBER(20,4) NOT NULL,
TOTAL_USED_AREA_MAX NUMBER(20,4) NOT NULL,
TOTAL_USED_AREA_STCNT varchar2(32) NOT NULL,
PCT_DUMP_AREA_USED_MIN NUMBER(20,4) NOT NULL,
PCT_DUMP_AREA_USED_MAX NUMBER(20,4) NOT NULL,
PCT_DUMP_AREA_USED_STCNT varchar2(32) NOT NULL,
AVAILABLE_MIN NUMBER(20,4) NOT NULL,
AVAILABLE_MAX NUMBER(20,4) NOT NULL,
AVAILABLE_STCNT varchar2(32) NOT NULL,
PCT_AVAILABLE_MIN NUMBER(20,4) NOT NULL,
PCT_AVAILABLE_MAX NUMBER(20,4) NOT NULL,
PCT_AVAILABLE_STCNT varchar2(32) NOT NULL,
DUMP_GRTH_MIN NUMBER(20,4) NOT NULL,
DUMP_GRTH_MAX NUMBER(20,4) NOT NULL,
DUMP_GRTH_STCNT varchar2(32) NOT NULL,
DUMP_AVAIL_MIN NUMBER(20,4) NOT NULL,
DUMP_AVAIL_MAX NUMBER(20,4) NOT NULL,
DUMP_AVAIL_STCNT varchar2(32) NOT NULL,
DUMP_USD_PRCNT_MIN NUMBER(20,4) NOT NULL,
DUMP_USD_PRCNT_MAX NUMBER(20,4) NOT NULL,
DUMP_USD_PRCNT_STCNT varchar2(32) NOT NULL,
DUMP_FREE_PRCNT_MIN NUMBER(20,4) NOT NULL,
DUMP_FREE_PRCNT_MAX NUMBER(20,4) NOT NULL,
DUMP_FREE_PRCNT_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraRacDumpAreaTest_TREND ADD constraint PK_OraRacDumpAreaTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraRacDumpAreaTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraRacDumpAreaTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
DUMP_AREA_USED_MIN varchar2(256) NOT NULL,
DUMP_AREA_USED_MAX varchar2(256) NOT NULL,
TOTAL_USED_AREA_MIN varchar2(256) NOT NULL,
TOTAL_USED_AREA_MAX varchar2(256) NOT NULL,
PCT_DUMP_AREA_USED_MIN varchar2(256) NOT NULL,
PCT_DUMP_AREA_USED_MAX varchar2(256) NOT NULL,
AVAILABLE_MIN varchar2(256) NOT NULL,
AVAILABLE_MAX varchar2(256) NOT NULL,
PCT_AVAILABLE_MIN varchar2(256) NOT NULL,
PCT_AVAILABLE_MAX varchar2(256) NOT NULL,
DUMP_GRTH_MIN varchar2(256) NOT NULL, 
DUMP_GRTH_MAX varchar2(256) NOT NULL,
DUMP_AVAIL_MIN varchar2(256) NOT NULL,
DUMP_AVAIL_MAX varchar2(256) NOT NULL,
DUMP_USD_PRCNT_MIN varchar2(256) NOT NULL,
DUMP_USD_PRCNT_MAX varchar2(256) NOT NULL,
DUMP_FREE_PRCNT_MIN varchar2(256) NOT NULL, 
DUMP_FREE_PRCNT_MAX varchar2(256) NOT NULL);

ALTER TABLE OraRacDumpAreaTest_THRESH ADD constraint PK_OraRacDumpAreaTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraRacDumpAreaTest_THRESH ON OraRacDumpAreaTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_OraRacDumpAreaTest ON OraRacDumpAreaTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_OraRacDumpAreaTest ON OraRacDumpAreaTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE OraRacVIPStTest CASCADE CONSTRAINTS;
CREATE TABLE OraRacVIPStTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
NUMBEROFSCANVIPS Number(20,4) NOT NULL,
NUMBEROFSCANVIPS_ST varchar2(32) NOT NULL,
ISSCANVIPENABLED Number(20,4) NOT NULL,
ISSCANVIPENABLED_ST varchar2(32) NOT NULL,
ISSCANVIPRUNNING Number(20,4) NOT NULL,
ISSCANVIPRUNNING_ST varchar2(32) NOT NULL,
SCANVIPRELOCATED Number(20,4) NOT NULL,
SCANVIPRELOCATED_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_OraRacVIPStTest ON OraRacVIPStTest(MSMT_TIME);
ALTER TABLE OraRacVIPStTest ADD constraint PK_OraRacVIPStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraRacVIPStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraRacVIPStTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
NUMBEROFSCANVIPS_MIN Number(20,4) NOT NULL,
NUMBEROFSCANVIPS_MAX Number(20,4) NOT NULL,
NUMBEROFSCANVIPS_STCNT varchar2(32) NOT NULL,
ISSCANVIPENABLED_MIN Number(20,4) NOT NULL,
ISSCANVIPENABLED_MAX Number(20,4) NOT NULL,
ISSCANVIPENABLED_STCNT varchar2(32) NOT NULL,
ISSCANVIPRUNNING_MIN Number(20,4) NOT NULL,
ISSCANVIPRUNNING_MAX Number(20,4) NOT NULL,
ISSCANVIPRUNNING_STCNT varchar2(32) NOT NULL,
SCANVIPRELOCATED_MIN Number(20,4) NOT NULL,
SCANVIPRELOCATED_MAX Number(20,4) NOT NULL,
SCANVIPRELOCATED_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraRacVIPStTest_TREND ADD constraint PK_OraRacVIPStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraRacVIPStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraRacVIPStTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
NUMBEROFSCANVIPS_MIN varchar2(256) NOT NULL,
NUMBEROFSCANVIPS_MAX varchar2(256) NOT NULL,
ISSCANVIPENABLED_MIN varchar2(256) NOT NULL,
ISSCANVIPENABLED_MAX varchar2(256) NOT NULL,
ISSCANVIPRUNNING_MIN varchar2(256) NOT NULL,
ISSCANVIPRUNNING_MAX varchar2(256) NOT NULL,
SCANVIPRELOCATED_MIN varchar2(256) NOT NULL,
SCANVIPRELOCATED_MAX varchar2(256) NOT NULL);

ALTER TABLE OraRacVIPStTest_THRESH ADD constraint PK_OraRacVIPStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraRacVIPStTest_THRESH ON OraRacVIPStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_OraRacVIPStTest ON OraRacVIPStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_OraRacVIPStTest ON OraRacVIPStTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE OraRacResUsgeTest CASCADE CONSTRAINTS;
CREATE TABLE OraRacResUsgeTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
INITIAL_ALLOCATION Number(20,4) NOT NULL,
INITIAL_ALLOCATION_ST varchar2(32) NOT NULL,
CUR_UTILIZATION Number(20,4) NOT NULL,
CUR_UTILIZATION_ST varchar2(32) NOT NULL,
MAX_UTILIZATION_LIMIT Number(20,4) NOT NULL,
MAX_UTILIZATION_LIMIT_ST varchar2(32) NOT NULL,
CONFIG_LIMIT Number(20,4) NOT NULL,
CONFIG_LIMIT_ST varchar2(32) NOT NULL,
PCT_UTIL Number(20,4) NOT NULL,
PCT_UTIL_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_OraRacResUsgeTest ON OraRacResUsgeTest(MSMT_TIME);
ALTER TABLE OraRacResUsgeTest ADD constraint PK_OraRacResUsgeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE OraRacResUsgeTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraRacResUsgeTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
INITIAL_ALLOCATION_MIN Number(20,4) NOT NULL,
INITIAL_ALLOCATION_MAX Number(20,4) NOT NULL,
INITIAL_ALLOCATION_STCNT varchar2(32) NOT NULL,
CUR_UTILIZATION_MIN Number(20,4) NOT NULL,
CUR_UTILIZATION_MAX Number(20,4) NOT NULL,
CUR_UTILIZATION_STCNT varchar2(32) NOT NULL,
MAX_UTILIZATION_LIMIT_MIN Number(20,4) NOT NULL,
MAX_UTILIZATION_LIMIT_MAX Number(20,4) NOT NULL,
MAX_UTILIZATION_LIMIT_STCNT varchar2(32) NOT NULL,
CONFIG_LIMIT_MIN Number(20,4) NOT NULL,
CONFIG_LIMIT_MAX Number(20,4) NOT NULL,
CONFIG_LIMIT_STCNT varchar2(32) NOT NULL,
PCT_UTIL_MIN Number(20,4) NOT NULL,
PCT_UTIL_MAX Number(20,4) NOT NULL,
PCT_UTIL_STCNT varchar2(32) NOT NULL);
ALTER TABLE OraRacResUsgeTest_TREND ADD constraint PK_OraRacResUsgeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE OraRacResUsgeTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraRacResUsgeTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
INITIAL_ALLOCATION_MIN VARCHAR2(256) NOT NULL,
INITIAL_ALLOCATION_MAX VARCHAR2(256) NOT NULL,
CUR_UTILIZATION_MIN VARCHAR2(256) NOT NULL,
CUR_UTILIZATION_MAX VARCHAR2(256) NOT NULL,
MAX_UTILIZATION_LIMIT_MIN VARCHAR2(256) NOT NULL,
MAX_UTILIZATION_LIMIT_MAX VARCHAR2(256) NOT NULL,
CONFIG_LIMIT_MIN VARCHAR2(256) NOT NULL,
CONFIG_LIMIT_MAX VARCHAR2(256) NOT NULL,
PCT_UTIL_MIN VARCHAR2(256) NOT NULL,
PCT_UTIL_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE OraRacResUsgeTest_THRESH ADD constraint PK_OraRacResUsgeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);

CREATE INDEX IDX_OraRacResUsgeTest_THRESH ON OraRacResUsgeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_OraRacResUsgeTest ON OraRacResUsgeTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_OraRacResUsgeTest ON OraRacResUsgeTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE OraExePlnStTest CASCADE CONSTRAINTS;
CREATE TABLE OraExePlnStTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ExplainPlanChangeCount Number(20,4) NOT NULL,
ExplainPlanChangeCount_ST varchar2(32) NOT NULL,
RateofExePlanChange Number(20,4) NOT NULL,
RateofExePlanChange_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_OraExePlnStTest ON OraExePlnStTest(MSMT_TIME);
ALTER TABLE OraExePlnStTest ADD constraint PK_OraExePlnStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraExePlnStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraExePlnStTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ExplainPlanChangeCount_MIN Number(20,4) NOT NULL,
ExplainPlanChangeCount_MAX Number(20,4) NOT NULL,
ExplainPlanChangeCount_STCNT varchar2(32) NOT NULL,
RateofExePlanChange_MIN Number(20,4) NOT NULL,
RateofExePlanChange_MAX Number(20,4) NOT NULL,
RateofExePlanChange_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraExePlnStTest_TREND ADD constraint PK_OraExePlnStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraExePlnStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraExePlnStTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ExplainPlanChangeCount_MIN varchar2(256) NOT NULL,
ExplainPlanChangeCount_MAX varchar2(256) NOT NULL,
RateofExePlanChange_MIN varchar2(256) NOT NULL,
RateofExePlanChange_MAX varchar2(256) NOT NULL);

ALTER TABLE OraExePlnStTest_THRESH ADD constraint PK_OraExePlnStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraExePlnStTest_THRESH ON OraExePlnStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_OraExePlnStTest ON OraExePlnStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_OraExePlnStTest ON OraExePlnStTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE OraRacExePlnStTest CASCADE CONSTRAINTS;
CREATE TABLE OraRacExePlnStTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ExplainPlanChangeCount Number(20,4) NOT NULL,
ExplainPlanChangeCount_ST varchar2(32) NOT NULL,
RateofExePlanChange Number(20,4) NOT NULL,
RateofExePlanChange_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_OraRacExePlnStTest ON OraRacExePlnStTest(MSMT_TIME);
ALTER TABLE OraRacExePlnStTest ADD constraint PK_OraRacExePlnStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraRacExePlnStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE OraRacExePlnStTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ExplainPlanChangeCount_MIN Number(20,4) NOT NULL,
ExplainPlanChangeCount_MAX Number(20,4) NOT NULL,
ExplainPlanChangeCount_STCNT varchar2(32) NOT NULL,
RateofExePlanChange_MIN Number(20,4) NOT NULL,
RateofExePlanChange_MAX Number(20,4) NOT NULL,
RateofExePlanChange_STCNT varchar2(32) NOT NULL);

ALTER TABLE OraRacExePlnStTest_TREND ADD constraint PK_OraRacExePlnStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraRacExePlnStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE OraRacExePlnStTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ExplainPlanChangeCount_MIN varchar2(256) NOT NULL,
ExplainPlanChangeCount_MAX varchar2(256) NOT NULL,
RateofExePlanChange_MIN varchar2(256) NOT NULL,
RateofExePlanChange_MAX varchar2(256) NOT NULL);

ALTER TABLE OraRacExePlnStTest_THRESH ADD constraint PK_OraRacExePlnStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraRacExePlnStTest_THRESH ON OraRacExePlnStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_OraRacExePlnStTest ON OraRacExePlnStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_OraRacExePlnStTest ON OraRacExePlnStTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE OraRacAlertTest CASCADE CONSTRAINTS;
CREATE TABLE OraRacAlertTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ErrorCount Number(20,4) NOT NULL,
ErrorCount_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_OraRacAlertTest ON OraRacAlertTest(MSMT_TIME);
ALTER TABLE OraRacAlertTest ADD constraint PK_OraRacAlertTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE OraRacAlertTest_TREND;
CREATE TABLE OraRacAlertTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ErrorCount_MIN Number(20,4) NOT NULL,
ErrorCount_MAX Number(20,4) NOT NULL,
ErrorCount_STCNT varchar2(32) NOT NULL);


ALTER TABLE OraRacAlertTest_TREND ADD constraint PK_OraRacAlertTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE OraRacAlertTest_THRESH;
CREATE TABLE OraRacAlertTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ErrorCount_MIN varchar2(256) NOT NULL,
ErrorCount_MAX varchar2(256) NOT NULL);

ALTER TABLE OraRacAlertTest_THRESH ADD constraint PK_OraRacAlertTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_OraRacAlertTest_THRESH ON OraRacAlertTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_OraRacAlertTest ON OraRacAlertTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_OraRacAlertTest ON OraRacAlertTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MsSqlThreadStTest CASCADE CONSTRAINTS;
CREATE TABLE MsSqlThreadStTest(
TRGT_HOST	varchar2(32) NOT NULL,
PORT_NO	varchar2(32) NOT NULL,
SITE_NAME	varchar2(64) NOT NULL,
INFO		varchar2(128) NOT NULL,
MSMT_HOST	varchar2(32) NOT NULL,
MSMT_TIME	date NOT NULL,
MAXIMUMTHREADS Number(20,4) NOT NULL,
MAXIMUMTHREADS_ST varchar2(32) NOT NULL,
ACTIVETHREADS Number(20,4) NOT NULL,	
ACTIVETHREADS_ST varchar2(32) NOT NULL,
IDLETHREADS Number(20,4) NOT NULL,
IDLETHREADS_ST varchar2(32) NOT NULL,
FREETHREADS Number(20,4) NOT NULL,
FREETHREADS_ST varchar2(32) NOT NULL,
THREADUTILIZATION Number(20,4) NOT NULL,
THREADUTILIZATION_ST varchar2(32) NOT NULL,
QUEUEDTHREADS Number(20,4) NOT NULL,
QUEUEDTHREADS_ST varchar2(32) NOT NULL,
THREADWAITSFRCPU Number(20,4) NOT NULL,
THREADWAITSFRCPU_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MsSqlThreadStTest ON MsSqlThreadStTest(MSMT_TIME);
ALTER TABLE MsSqlThreadStTest ADD constraint PK_MsSqlThreadStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MsSqlThreadStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MsSqlThreadStTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
MAXIMUMTHREADS_MIN Number(20,4) NOT NULL,
MAXIMUMTHREADS_MAX Number(20,4) NOT NULL,
MAXIMUMTHREADS_STCNT varchar2(32) NOT NULL,
ACTIVETHREADS_MIN Number(20,4) NOT NULL,
ACTIVETHREADS_MAX Number(20,4) NOT NULL,
ACTIVETHREADS_STCNT varchar2(32) NOT NULL,
IDLETHREADS_MIN Number(20,4) NOT NULL,
IDLETHREADS_MAX Number(20,4) NOT NULL,
IDLETHREADS_STCNT varchar2(32) NOT NULL,
FREETHREADS_MIN Number(20,4) NOT NULL,
FREETHREADS_MAX Number(20,4) NOT NULL,
FREETHREADS_STCNT varchar2(32) NOT NULL,
THREADUTILIZATION_MIN Number(20,4) NOT NULL,
THREADUTILIZATION_MAX Number(20,4) NOT NULL,
THREADUTILIZATION_STCNT varchar2(32) NOT NULL,
QUEUEDTHREADS_MIN Number(20,4) NOT NULL,
QUEUEDTHREADS_MAX Number(20,4) NOT NULL,
QUEUEDTHREADS_STCNT varchar2(32) NOT NULL,
THREADWAITSFRCPU_MIN Number(20,4) NOT NULL,
THREADWAITSFRCPU_MAX Number(20,4) NOT NULL,
THREADWAITSFRCPU_STCNT varchar2(32) NOT NULL);

ALTER TABLE MsSqlThreadStTest_TREND ADD constraint PK_MsSqlThreadStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsSqlThreadStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MsSqlThreadStTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
MAXIMUMTHREADS_MIN varchar2(256) NOT NULL,
MAXIMUMTHREADS_MAX varchar2(256) NOT NULL,
ACTIVETHREADS_MIN varchar2(256) NOT NULL,
ACTIVETHREADS_MAX varchar2(256) NOT NULL,
IDLETHREADS_MIN varchar2(256) NOT NULL,
IDLETHREADS_MAX varchar2(256) NOT NULL,
FREETHREADS_MIN varchar2(256) NOT NULL,
FREETHREADS_MAX varchar2(256) NOT NULL,
THREADUTILIZATION_MIN varchar2(256) NOT NULL,
THREADUTILIZATION_MAX varchar2(256) NOT NULL,
QUEUEDTHREADS_MIN varchar2(256) NOT NULL,
QUEUEDTHREADS_MAX varchar2(256) NOT NULL,
THREADWAITSFRCPU_MIN varchar2(256) NOT NULL,
THREADWAITSFRCPU_MAX varchar2(256) NOT NULL);

ALTER TABLE MsSqlThreadStTest_THRESH ADD constraint PK_MsSqlThreadStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsSqlThreadStTest_THRESH ON MsSqlThreadStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MsSqlThreadStTest ON MsSqlThreadStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MsSqlThreadStTest ON MsSqlThreadStTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MsSqlExpPlStTest CASCADE CONSTRAINTS;
CREATE TABLE MsSqlExpPlStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
EXPLAINPLANCHANGED Number(20,4) NOT NULL,
EXPLAINPLANCHANGED_ST varchar2(32) NOT NULL,
RATEOFEXPLAINPLANCHANGE Number(20,4) NOT NULL,
RATEOFEXPLAINPLANCHANGE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MsSqlExpPlStTest ON MsSqlExpPlStTest(MSMT_TIME);
ALTER TABLE MsSqlExpPlStTest ADD constraint PK_MsSqlExpPlStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MsSqlExpPlStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MsSqlExpPlStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
EXPLAINPLANCHANGED_MIN Number(20,4) NOT NULL,
EXPLAINPLANCHANGED_MAX Number(20,4) NOT NULL,
EXPLAINPLANCHANGED_STCNT varchar2(32) NOT NULL,
RATEOFEXPLAINPLANCHANGE_MIN Number(20,4) NOT NULL,
RATEOFEXPLAINPLANCHANGE_MAX Number(20,4) NOT NULL,
RATEOFEXPLAINPLANCHANGE_STCNT varchar2(32) NOT NULL);

ALTER TABLE MsSqlExpPlStTest_TREND ADD constraint PK_MsSqlExpPlStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MsSqlExpPlStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MsSqlExpPlStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
EXPLAINPLANCHANGED_MIN VARCHAR2(256) NOT NULL,
EXPLAINPLANCHANGED_MAX VARCHAR2(256) NOT NULL,
RATEOFEXPLAINPLANCHANGE_MIN VARCHAR2(256) NOT NULL,
RATEOFEXPLAINPLANCHANGE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE MsSqlExpPlStTest_THRESH ADD constraint PK_MsSqlExpPlStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MsSqlExpPlStTest_THRESH ON MsSqlExpPlStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MsSqlExpPlStTest ON MsSqlExpPlStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MsSqlExpPlStTest ON MsSqlExpPlStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE YMRMsgCenTest CASCADE CONSTRAINTS;
CREATE TABLE YMRMsgCenTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_YMRMsgCenTest ON YMRMsgCenTest(MSMT_TIME);
ALTER TABLE YMRMsgCenTest ADD constraint PK_YMRMsgCenTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE YMRMsgCenTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE YMRMsgCenTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE YMRMsgCenTest_TREND ADD constraint PK_YMRMsgCenTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE YMRMsgCenTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE YMRMsgCenTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MsgCenterCommunication_MIN varchar2(256) NOT NULL,
MsgCenterCommunication_MAX varchar2(256) NOT NULL);

ALTER TABLE YMRMsgCenTest_THRESH ADD constraint PK_YMRMsgCenTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_YMRMsgCenTest_THRESH ON YMRMsgCenTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_YMRMsgCenTest ON YMRMsgCenTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_YMRMsgCenTest ON YMRMsgCenTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE AWDvcEvntsTest CASCADE CONSTRAINTS;
CREATE TABLE AWDvcEvntsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
EventType Number(20,4) NOT NULL,
EventType_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_AWDvcEvntsTest ON AWDvcEvntsTest(MSMT_TIME);
ALTER TABLE AWDvcEvntsTest ADD constraint PK_AWDvcEvntsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AWDvcEvntsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE AWDvcEvntsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
EventType_MIN Number(20,4) NOT NULL,
EventType_MAX Number(20,4) NOT NULL,
EventType_STCNT varchar2(32) NOT NULL);
ALTER TABLE AWDvcEvntsTest_TREND ADD constraint PK_AWDvcEvntsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AWDvcEvntsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AWDvcEvntsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
EventType_MIN VARCHAR2(256) NOT NULL,
EventType_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE AWDvcEvntsTest_THRESH ADD constraint PK_AWDvcEvntsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AWDvcEvntsTest_THRESH ON AWDvcEvntsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AWDvcEvntsTest ON AWDvcEvntsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AWDvcEvntsTest ON AWDvcEvntsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE RUMCOLLSITETEST CASCADE CONSTRAINTS;
CREATE TABLE RUMCOLLSITETEST(
	TRGT_HOST		VARCHAR2(32) NOT NULL,
	PORT_NO			VARCHAR2(32) NOT NULL,
	SITE_NAME		VARCHAR2(64) NOT NULL,
	INFO			VARCHAR2(128) NOT NULL,
	MSMT_HOST		VARCHAR2(32) NOT NULL,
	MSMT_TIME		DATE NOT NULL,
	CONFIGURED_SITE 	NUMBER(20,4) NOT NULL,
	CONFIGURED_SITE_ST 	VARCHAR2(32) NOT NULL,
	ACTIVE_SITE 		NUMBER(20,4) NOT NULL,
	ACTIVE_SITE_ST 		VARCHAR2(32) NOT NULL,
	INACTIVE_SITE 		NUMBER(20,4) NOT NULL,
	INACTIVE_SITE_ST 	VARCHAR2(32) NOT NULL);
CREATE  INDEX IDX_RUMCOLLSITETEST ON RUMCOLLSITETEST(MSMT_TIME);
ALTER TABLE RUMCOLLSITETEST ADD CONSTRAINT PK_RUMCOLLSITETEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE RUMCOLLSITETEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE RUMCOLLSITETEST_TREND(
	TRGT_HOST       	VARCHAR2(32) NOT NULL,
	PORT_NO         	VARCHAR2(32) NOT NULL,
	SITE_NAME       	VARCHAR2(64) NOT NULL,
	INFO            	VARCHAR2(128) NOT NULL,
	MSMT_HOST       	VARCHAR2(32) NOT NULL,
	MSMT_TIME       	DATE NOT NULL,
	PERIOD       		VARCHAR2(32) NOT NULL,
	CONFIGURED_SITE_MIN 	NUMBER(20,4) NOT NULL,
	CONFIGURED_SITE_MAX 	NUMBER(20,4) NOT NULL,
	CONFIGURED_SITE_STCNT 	VARCHAR2(32) NOT NULL,
	ACTIVE_SITE_MIN 	NUMBER(20,4) NOT NULL,
	ACTIVE_SITE_MAX 	NUMBER(20,4) NOT NULL,
	ACTIVE_SITE_STCNT 	VARCHAR2(32) NOT NULL,
	INACTIVE_SITE_MIN 	NUMBER(20,4) NOT NULL,
	INACTIVE_SITE_MAX 	NUMBER(20,4) NOT NULL,
	INACTIVE_SITE_STCNT 	VARCHAR2(32) NOT NULL);
ALTER TABLE RUMCOLLSITETEST_TREND ADD CONSTRAINT PK_RUMCOLLSITETEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE RUMCOLLSITETEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RUMCOLLSITETEST_THRESH(
	TRGT_HOST       	VARCHAR2(32) NOT NULL,
	PORT_NO         	VARCHAR2(32) NOT NULL,
	SITE_NAME       	VARCHAR2(64) NOT NULL,
	INFO            	VARCHAR2(128) NOT NULL,
	MSMT_HOST       	VARCHAR2(32) NOT NULL,
	MSMT_TIME_START 	DATE NOT NULL,
	MSMT_TIME_END   	DATE NOT NULL,
	CONFIGURED_SITE_MIN 	VARCHAR2(256) NOT NULL,
	CONFIGURED_SITE_MAX 	VARCHAR2(256) NOT NULL,
	ACTIVE_SITE_MIN 	VARCHAR2(256) NOT NULL,
	ACTIVE_SITE_MAX 	VARCHAR2(256) NOT NULL,
	INACTIVE_SITE_MIN 	VARCHAR2(256) NOT NULL,
	INACTIVE_SITE_MAX 	VARCHAR2(256) NOT NULL);
ALTER TABLE RUMCOLLSITETEST_THRESH ADD CONSTRAINT PK_RUMCOLLSITETEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RUMCOLLSITETEST_THRESH ON RUMCOLLSITETEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RUMCOLLSITETEST ON RUMCOLLSITETEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RUMCOLLSITETEST ON RUMCOLLSITETEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE RUMCOLLTEST CASCADE CONSTRAINTS;
CREATE TABLE RUMCOLLTEST(
	TRGT_HOST			VARCHAR2(32) NOT NULL,
	PORT_NO				VARCHAR2(32) NOT NULL,
	SITE_NAME			VARCHAR2(64) NOT NULL,
	INFO				VARCHAR2(128) NOT NULL,
	MSMT_HOST			VARCHAR2(32) NOT NULL,
	MSMT_TIME			DATE NOT NULL,
	RDR_REQ_COUNT 			NUMBER(20,4) NOT NULL,
	RDR_REQ_COUNT_ST 		VARCHAR2(32) NOT NULL,
	RDR_SUCCESSFUL_REQS 		NUMBER(20,4) NOT NULL,
	RDR_SUCCESSFUL_REQS_ST 		VARCHAR2(32) NOT NULL,
	RDR_SUCCESSFUL_PERCENT 		NUMBER(20,4) NOT NULL,
	RDR_SUCCESSFUL_PERCENT_ST 	VARCHAR2(32) NOT NULL,	
	RDR_REQ_COUNT_RATE 		NUMBER(20,4) NOT NULL,
	RDR_REQ_COUNT_RATE_ST 		VARCHAR2(32) NOT NULL,
	RDR_REQ_PROCESS_RATE 		NUMBER(20,4) NOT NULL,
	RDR_REQ_PROCESS_RATE_ST		VARCHAR2(32) NOT NULL,
	RDR_FAILED_REQ_COUNT 		NUMBER(20,4) NOT NULL,
	RDR_FAILED_REQ_COUNT_ST 	VARCHAR2(32) NOT NULL,
	RDR_FAILED_REQ_RATE 		NUMBER(20,4) NOT NULL,
	RDR_FAILED_REQ_RATE_ST 		VARCHAR2(32) NOT NULL,
	RDR_FAILED_REQ_PERCENT 		NUMBER(20,4) NOT NULL,
	RDR_FAILED_REQ_PERCENT_ST 	VARCHAR2(32) NOT NULL,
	RDR_IGNORED_REQ_COUNT 		NUMBER(20,4) NOT NULL,
	RDR_IGNORED_REQ_COUNT_ST 	VARCHAR2(32) NOT NULL,
	RDR_IGNORED_REQ_RATE 		NUMBER(20,4) NOT NULL,
	RDR_IGNORED_REQ_RATE_ST 	VARCHAR2(32) NOT NULL,
	RDR_IGNORED_REQ_PERCENT		NUMBER(20,4) NOT NULL,
	RDR_IGNORED_REQ_PERCENT_ST 	VARCHAR2(32) NOT NULL,
	RDR_DISCARD_REQ_COUNT 		NUMBER(20,4) NOT NULL,
	RDR_DISCARD_REQ_COUNT_ST 	VARCHAR2(32) NOT NULL,
	RDR_DISCARD_REQ_RATE 		NUMBER(20,4) NOT NULL,
	RDR_DISCARD_REQ_RATE_ST 	VARCHAR2(32) NOT NULL,
	RDR_DISCARD_REQ_PERCENT 	NUMBER(20,4) NOT NULL,
	RDR_DISCARD_REQ_PERCENT_ST 	VARCHAR2(32) NOT NULL);
CREATE INDEX IDX_RUMCOLLTEST ON RUMCOLLTEST(MSMT_TIME);
ALTER TABLE RUMCOLLTEST ADD CONSTRAINT PK_RUMCOLLTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE RUMCOLLTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE RUMCOLLTEST_TREND(
	TRGT_HOST       		VARCHAR2(32) NOT NULL,
	PORT_NO         		VARCHAR2(32) NOT NULL,
	SITE_NAME       		VARCHAR2(64) NOT NULL,
	INFO            		VARCHAR2(128) NOT NULL,
	MSMT_HOST       		VARCHAR2(32) NOT NULL,
	MSMT_TIME       		DATE NOT NULL,
	PERIOD       			VARCHAR2(32) NOT NULL,
	RDR_REQ_COUNT_MIN 		NUMBER(20,4) NOT NULL,
	RDR_REQ_COUNT_MAX 		NUMBER(20,4) NOT NULL,
	RDR_REQ_COUNT_STCNT 		VARCHAR2(32) NOT NULL,
	RDR_SUCCESSFUL_REQS_MIN 	NUMBER(20,4) NOT NULL,
	RDR_SUCCESSFUL_REQS_MAX 	NUMBER(20,4) NOT NULL,
	RDR_SUCCESSFUL_REQS_STCNT 	VARCHAR2(32) NOT NULL,
	RDR_SUCCESSFUL_PERCENT_MIN 	NUMBER(20,4) NOT NULL,
	RDR_SUCCESSFUL_PERCENT_MAX 	NUMBER(20,4) NOT NULL,
	RDR_SUCCESSFUL_PERCENT_STCNT 	VARCHAR2(32) NOT NULL,	
	RDR_REQ_COUNT_RATE_MIN 		NUMBER(20,4) NOT NULL,
	RDR_REQ_COUNT_RATE_MAX 		NUMBER(20,4) NOT NULL,
	RDR_REQ_COUNT_RATE_STCNT 	VARCHAR2(32) NOT NULL,
	RDR_REQ_PROCESS_RATE_MIN 	NUMBER(20,4) NOT NULL,
	RDR_REQ_PROCESS_RATE_MAX 	NUMBER(20,4) NOT NULL,
	RDR_REQ_PROCESS_RATE_STCNT 	VARCHAR2(32) NOT NULL,
	RDR_FAILED_REQ_COUNT_MIN 	NUMBER(20,4) NOT NULL,
	RDR_FAILED_REQ_COUNT_MAX 	NUMBER(20,4) NOT NULL,
	RDR_FAILED_REQ_COUNT_STCNT 	VARCHAR2(32) NOT NULL,
	RDR_FAILED_REQ_RATE_MIN 	NUMBER(20,4) NOT NULL,
	RDR_FAILED_REQ_RATE_MAX 	NUMBER(20,4) NOT NULL,
	RDR_FAILED_REQ_RATE_STCNT 	VARCHAR2(32) NOT NULL,
	RDR_FAILED_REQ_PERCENT_MIN 	NUMBER(20,4) NOT NULL,
	RDR_FAILED_REQ_PERCENT_MAX 	NUMBER(20,4) NOT NULL,
	RDR_FAILED_REQ_PERCENT_STCNT 	VARCHAR2(32) NOT NULL,
	RDR_IGNORED_REQ_COUNT_MIN 	NUMBER(20,4) NOT NULL,
	RDR_IGNORED_REQ_COUNT_MAX 	NUMBER(20,4) NOT NULL,
	RDR_IGNORED_REQ_COUNT_STCNT 	VARCHAR2(32) NOT NULL,
	RDR_IGNORED_REQ_RATE_MIN 	NUMBER(20,4) NOT NULL,
	RDR_IGNORED_REQ_RATE_MAX 	NUMBER(20,4) NOT NULL,
	RDR_IGNORED_REQ_RATE_STCNT 	VARCHAR2(32) NOT NULL,
	RDR_IGNORED_REQ_PERCENT_MIN 	NUMBER(20,4) NOT NULL,
	RDR_IGNORED_REQ_PERCENT_MAX 	NUMBER(20,4) NOT NULL,
	RDR_IGNORED_REQ_PERCENT_STCNT 	VARCHAR2(32) NOT NULL,
	RDR_DISCARD_REQ_COUNT_MIN 	NUMBER(20,4) NOT NULL,
	RDR_DISCARD_REQ_COUNT_MAX 	NUMBER(20,4) NOT NULL,
	RDR_DISCARD_REQ_COUNT_STCNT 	VARCHAR2(32) NOT NULL,
	RDR_DISCARD_REQ_RATE_MIN 	NUMBER(20,4) NOT NULL,
	RDR_DISCARD_REQ_RATE_MAX	NUMBER(20,4) NOT NULL,
	RDR_DISCARD_REQ_RATE_STCNT 	VARCHAR2(32) NOT NULL,
	RDR_DISCARD_REQ_PERCENT_MIN 	NUMBER(20,4) NOT NULL,
	RDR_DISCARD_REQ_PERCENT_MAX 	NUMBER(20,4) NOT NULL,
	RDR_DISCARD_REQ_PERCENT_STCNT 	VARCHAR2(32) NOT NULL);
ALTER TABLE RUMCOLLTEST_TREND ADD CONSTRAINT PK_RUMCOLLTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE RUMCOLLTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RUMCOLLTEST_THRESH(
	TRGT_HOST       		VARCHAR2(32) NOT NULL,
	PORT_NO         		VARCHAR2(32) NOT NULL,
	SITE_NAME       		VARCHAR2(64) NOT NULL,
	INFO            		VARCHAR2(128) NOT NULL,
	MSMT_HOST       		VARCHAR2(32) NOT NULL,
	MSMT_TIME_START 		DATE NOT NULL,
	MSMT_TIME_END   		DATE NOT NULL,
	RDR_REQ_COUNT_MIN 		VARCHAR2(256) NOT NULL,
	RDR_REQ_COUNT_MAX 		VARCHAR2(256) NOT NULL,
	RDR_SUCCESSFUL_REQS_MIN 	VARCHAR2(256) NOT NULL,
	RDR_SUCCESSFUL_REQS_MAX 	VARCHAR2(256) NOT NULL,
	RDR_SUCCESSFUL_PERCENT_MIN 	VARCHAR2(256) NOT NULL,
	RDR_SUCCESSFUL_PERCENT_MAX 	VARCHAR2(256) NOT NULL,	
	RDR_REQ_COUNT_RATE_MIN 		VARCHAR2(256) NOT NULL,
	RDR_REQ_COUNT_RATE_MAX 		VARCHAR2(256) NOT NULL,
	RDR_REQ_PROCESS_RATE_MIN 	VARCHAR2(256) NOT NULL,
	RDR_REQ_PROCESS_RATE_MAX 	VARCHAR2(256) NOT NULL,
	RDR_FAILED_REQ_COUNT_MIN 	VARCHAR2(256) NOT NULL,
	RDR_FAILED_REQ_COUNT_MAX 	VARCHAR2(256) NOT NULL,
	RDR_FAILED_REQ_RATE_MIN 	VARCHAR2(256) NOT NULL,
	RDR_FAILED_REQ_RATE_MAX 	VARCHAR2(256) NOT NULL,
	RDR_FAILED_REQ_PERCENT_MIN 	VARCHAR2(256) NOT NULL,
	RDR_FAILED_REQ_PERCENT_MAX 	VARCHAR2(256) NOT NULL,
	RDR_IGNORED_REQ_COUNT_MIN 	VARCHAR2(256) NOT NULL,
	RDR_IGNORED_REQ_COUNT_MAX 	VARCHAR2(256) NOT NULL,
	RDR_IGNORED_REQ_RATE_MIN 	VARCHAR2(256) NOT NULL,
	RDR_IGNORED_REQ_RATE_MAX 	VARCHAR2(256) NOT NULL,
	RDR_IGNORED_REQ_PERCENT_MIN 	VARCHAR2(256) NOT NULL,
	RDR_IGNORED_REQ_PERCENT_MAX 	VARCHAR2(256) NOT NULL,
	RDR_DISCARD_REQ_COUNT_MIN 	VARCHAR2(256) NOT NULL,
	RDR_DISCARD_REQ_COUNT_MAX 	VARCHAR2(256) NOT NULL,
	RDR_DISCARD_REQ_RATE_MIN 	VARCHAR2(256) NOT NULL,
	RDR_DISCARD_REQ_RATE_MAX 	VARCHAR2(256) NOT NULL,
	RDR_DISCARD_REQ_PERCENT_MIN	VARCHAR2(256) NOT NULL,
	RDR_DISCARD_REQ_PERCENT_MAX 	VARCHAR2(256) NOT NULL);
ALTER TABLE RUMCOLLTEST_THRESH ADD CONSTRAINT PK_RUMCOLLTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RUMCOLLTEST_THRESH ON RUMCOLLTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RUMCOLLTEST ON RUMCOLLTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RUMCOLLTEST ON RUMCOLLTEST_TREND (MSMT_TIME,PERIOD);

DROP TABLE RUMCOLLTESTAGNT CASCADE CONSTRAINTS;
CREATE TABLE RUMCOLLTESTAGNT(
	TRGT_HOST			VARCHAR2(32) NOT NULL,
	PORT_NO				VARCHAR2(32) NOT NULL,
	SITE_NAME			VARCHAR2(64) NOT NULL,
	INFO				VARCHAR2(128) NOT NULL,
	MSMT_HOST			VARCHAR2(32) NOT NULL,
	MSMT_TIME			DATE NOT NULL,
	RMD_REQ_COUNT 			NUMBER(20,4) NOT NULL,
	RMD_REQ_COUNT_ST 		VARCHAR2(32) NOT NULL,
	RMD_REQ_RATE 			NUMBER(20,4) NOT NULL,
	RMD_REQ_RATE_ST 		VARCHAR2(32) NOT NULL,
	RMD_FAILED_REQ_COUNT 		NUMBER(20,4) NOT NULL,
	RMD_FAILED_REQ_COUNT_ST 	VARCHAR2(32) NOT NULL,
	RMD_FAILED_REQ_RATE 		NUMBER(20,4) NOT NULL,
	RMD_FAILED_REQ_RATE_ST 		VARCHAR2(32) NOT NULL,
	RMD_FAILED_REQ_PERCENT 		NUMBER(20,4) NOT NULL,
	RMD_FAILED_REQ_PERCENT_ST 	VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_RUMCOLLTESTAGNT ON RUMCOLLTESTAGNT(MSMT_TIME);
ALTER TABLE RUMCOLLTESTAGNT ADD CONSTRAINT PK_RUMCOLLTESTAGNT PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME);

DROP TABLE RUMCOLLTESTAGNT_TREND CASCADE CONSTRAINTS;
CREATE TABLE RUMCOLLTESTAGNT_TREND(
	TRGT_HOST       		VARCHAR2(32) NOT NULL,
	PORT_NO         		VARCHAR2(32) NOT NULL,
	SITE_NAME       		VARCHAR2(64) NOT NULL,
	INFO            		VARCHAR2(128) NOT NULL,
	MSMT_HOST       		VARCHAR2(32) NOT NULL,
	MSMT_TIME       		DATE NOT NULL,
	PERIOD       			VARCHAR2(32) NOT NULL,
	RMD_REQ_COUNT_MIN 		NUMBER(20,4) NOT NULL,
	RMD_REQ_COUNT_MAX 		NUMBER(20,4) NOT NULL,
	RMD_REQ_COUNT_STCNT 		VARCHAR2(32) NOT NULL,
	RMD_REQ_RATE_MIN 		NUMBER(20,4) NOT NULL,
	RMD_REQ_RATE_MAX 		NUMBER(20,4) NOT NULL,
	RMD_REQ_RATE_STCNT 		VARCHAR2(32) NOT NULL,
	RMD_FAILED_REQ_COUNT_MIN 	NUMBER(20,4) NOT NULL,
	RMD_FAILED_REQ_COUNT_MAX 	NUMBER(20,4) NOT NULL,
	RMD_FAILED_REQ_COUNT_STCNT 	VARCHAR2(32) NOT NULL,
	RMD_FAILED_REQ_RATE_MIN 		NUMBER(20,4) NOT NULL,
	RMD_FAILED_REQ_RATE_MAX 	NUMBER(20,4) NOT NULL,
	RMD_FAILED_REQ_RATE_STCNT 	VARCHAR2(32) NOT NULL,
	RMD_FAILED_REQ_PERCENT_MIN 	NUMBER(20,4) NOT NULL,
	RMD_FAILED_REQ_PERCENT_MAX 	NUMBER(20,4) NOT NULL,
	RMD_FAILED_REQ_PERCENT_STCNT 	VARCHAR2(32) NOT NULL);

ALTER TABLE RUMCOLLTESTAGNT_TREND ADD CONSTRAINT PK_RUMCOLLTESTAGNT_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE RUMCOLLTESTAGNT_THRESH CASCADE CONSTRAINTS;
CREATE TABLE RUMCOLLTESTAGNT_THRESH(
	TRGT_HOST       		VARCHAR2(32) NOT NULL,
	PORT_NO         		VARCHAR2(32) NOT NULL,
	SITE_NAME       		VARCHAR2(64) NOT NULL,
	INFO           		 	VARCHAR2(128) NOT NULL,
	MSMT_HOST       		VARCHAR2(32) NOT NULL,
	MSMT_TIME_START 		DATE NOT NULL,
	MSMT_TIME_END   		DATE NOT NULL,
	RMD_REQ_COUNT_MIN 		VARCHAR2(256) NOT NULL,
	RMD_REQ_COUNT_MAX		VARCHAR2(256) NOT NULL,
	RMD_REQ_RATE_MIN 		VARCHAR2(256) NOT NULL,
	RMD_REQ_RATE_MAX		VARCHAR2(256) NOT NULL,
	RMD_FAILED_REQ_COUNT_MIN 	VARCHAR2(256) NOT NULL,
	RMD_FAILED_REQ_COUNT_MAX 	VARCHAR2(256) NOT NULL,
	RMD_FAILED_REQ_RATE_MIN 	VARCHAR2(256) NOT NULL,
	RMD_FAILED_REQ_RATE_MAX 	VARCHAR2(256) NOT NULL,
	RMD_FAILED_REQ_PERCENT_MIN 	VARCHAR2(256) NOT NULL,
	RMD_FAILED_REQ_PERCENT_MAX 	VARCHAR2(256) NOT NULL);

ALTER TABLE RUMCOLLTESTAGNT_THRESH ADD CONSTRAINT PK_RUMCOLLTESTAGNT_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_RUMCOLLTESTAGNT_THRESH ON RUMCOLLTESTAGNT_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_RUMCOLLTESTAGNT ON RUMCOLLTESTAGNT_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_RUMCOLLTESTAGNT ON RUMCOLLTESTAGNT_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMWHAudioStrmsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMWHAudioStrmsTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AStrm Number(20,4) NOT NULL,
AStrm_ST varchar2(32) NOT NULL,
APrStm Number(20,4) NOT NULL,
APrStm_ST varchar2(32) NOT NULL,
AGdStm Number(20,4) NOT NULL,
AGdStm_ST varchar2(32) NOT NULL,
AUcfStm Number(20,4) NOT NULL,
AUcfStm_ST varchar2(32) NOT NULL,
APrPrct Number(20,4) NOT NULL,
APrPrct_ST varchar2(32) NOT NULL,
APrDJtr Number(20,4) NOT NULL,
APrDJtr_ST varchar2(32) NOT NULL,
APrDPktLs Number(20,4) NOT NULL,
APrDPktLs_ST varchar2(32) NOT NULL,
APrDDgdtn Number(20,4) NOT NULL,
APrDDgdtn_ST varchar2(32) NOT NULL,
APrDRndTp Number(20,4) NOT NULL,
APrDRndTp_ST varchar2(32) NOT NULL,
APrDCnclRt Number(20,4) NOT NULL,
APrDCnclRt_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_MTMWHAudioStrmsTest ON MTMWHAudioStrmsTest(MSMT_TIME);
ALTER TABLE MTMWHAudioStrmsTest ADD constraint PK_MTMWHAudioStrmsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMWHAudioStrmsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMWHAudioStrmsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AStrm_MIN Number(20,4) NOT NULL,
AStrm_MAX Number(20,4) NOT NULL,
AStrm_STCNT varchar2(32) NOT NULL,
APrStm_MIN Number(20,4) NOT NULL,
APrStm_MAX Number(20,4) NOT NULL,
APrStm_STCNT varchar2(32) NOT NULL,
AGdStm_MIN Number(20,4) NOT NULL,
AGdStm_MAX Number(20,4) NOT NULL,
AGdStm_STCNT varchar2(32) NOT NULL,
AUcfStm_MIN Number(20,4) NOT NULL,
AUcfStm_MAX Number(20,4) NOT NULL,
AUcfStm_STCNT varchar2(32) NOT NULL,
APrPrct_MIN Number(20,4) NOT NULL,
APrPrct_MAX Number(20,4) NOT NULL,
APrPrct_STCNT varchar2(32) NOT NULL,
APrDJtr_MIN Number(20,4) NOT NULL,
APrDJtr_MAX Number(20,4) NOT NULL,
APrDJtr_STCNT varchar2(32) NOT NULL,
APrDPktLs_MIN Number(20,4) NOT NULL,
APrDPktLs_MAX Number(20,4) NOT NULL,
APrDPktLs_STCNT varchar2(32) NOT NULL,
APrDDgdtn_MIN Number(20,4) NOT NULL,
APrDDgdtn_MAX Number(20,4) NOT NULL,
APrDDgdtn_STCNT varchar2(32) NOT NULL,
APrDRndTp_MIN Number(20,4) NOT NULL,
APrDRndTp_MAX Number(20,4) NOT NULL,
APrDRndTp_STCNT varchar2(32) NOT NULL,
APrDCnclRt_MIN Number(20,4) NOT NULL,
APrDCnclRt_MAX Number(20,4) NOT NULL,
APrDCnclRt_STCNT varchar2(32) NOT NULL
);
ALTER TABLE MTMWHAudioStrmsTest_TREND ADD constraint PK_MTMWHAudioStrmsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMWHAudioStrmsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMWHAudioStrmsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AStrm_MIN varchar2(256) NOT NULL,
AStrm_MAX varchar2(256) NOT NULL,
APrStm_MIN varchar2(256) NOT NULL,
APrStm_MAX varchar2(256) NOT NULL,
AGdStm_MIN varchar2(256) NOT NULL,
AGdStm_MAX varchar2(256) NOT NULL,
AUcfStm_MIN varchar2(256) NOT NULL,
AUcfStm_MAX varchar2(256) NOT NULL,
APrPrct_MIN varchar2(256) NOT NULL,
APrPrct_MAX varchar2(256) NOT NULL,
APrDJtr_MIN varchar2(256) NOT NULL,
APrDJtr_MAX varchar2(256) NOT NULL,
APrDPktLs_MIN varchar2(256) NOT NULL,
APrDPktLs_MAX varchar2(256) NOT NULL,
APrDDgdtn_MIN varchar2(256) NOT NULL,
APrDDgdtn_MAX varchar2(256) NOT NULL,
APrDRndTp_MIN varchar2(256) NOT NULL,
APrDRndTp_MAX varchar2(256) NOT NULL,
APrDCnclRt_MIN varchar2(256) NOT NULL,
APrDCnclRt_MAX varchar2(256) NOT NULL
);
ALTER TABLE MTMWHAudioStrmsTest_THRESH ADD constraint PK_MTMWHAudioStrmsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMWHAudioStrmsTest_THRESH ON MTMWHAudioStrmsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMWHAudioStrmsTest ON MTMWHAudioStrmsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMWHAudioStrmsTest ON MTMWHAudioStrmsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMWHVideoStrmsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMWHVideoStrmsTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Strmcnt Number(20,4) NOT NULL,
Strmcnt_ST varchar2(32) NOT NULL,
ViPstFclr Number(20,4) NOT NULL,
ViPstFclr_ST varchar2(32) NOT NULL,
ViLFrPrAg Number(20,4) NOT NULL,
ViLFrPrAg_ST varchar2(32) NOT NULL,
ViFrRteAg Number(20,4) NOT NULL,
ViFrRteAg_ST varchar2(32) NOT NULL,
PrStrmcnt Number(20,4) NOT NULL,
PrStrmcnt_ST varchar2(32) NOT NULL,
GdStrmCnt Number(20,4) NOT NULL,
GdStrmCnt_ST varchar2(32) NOT NULL,
UncfdSmCnt Number(20,4) NOT NULL,
UncfdSmCnt_ST varchar2(32) NOT NULL,
PrPercent Number(20,4) NOT NULL,
PrPercent_ST varchar2(32) NOT NULL,
AvPsFECPLR Number(20,4) NOT NULL,
AvPsFECPLR_ST varchar2(32) NOT NULL,
AvLclFmLs Number(20,4) NOT NULL,
AvLclFmLs_ST varchar2(32) NOT NULL,
AvRcvFmRtAg Number(20,4) NOT NULL,
AvRcvFmRtAg_ST varchar2(32) NOT NULL,
AvLwFmRtCPt Number(20,4) NOT NULL,
AvLwFmRtCPt_ST varchar2(32) NOT NULL,
AvPktLsRt Number(20,4) NOT NULL,
AvPktLsRt_ST varchar2(32) NOT NULL,
AvDycCpyPnt Number(20,4) NOT NULL,
AvDycCpyPnt_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_MTMWHVideoStrmsTest ON MTMWHVideoStrmsTest(MSMT_TIME);
ALTER TABLE MTMWHVideoStrmsTest ADD constraint PK_MTMWHVideoStrmsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMWHVideoStrmsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMWHVideoStrmsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Strmcnt_MIN Number(20,4) NOT NULL,
Strmcnt_MAX Number(20,4) NOT NULL,
Strmcnt_STCNT varchar2(32) NOT NULL,
ViPstFclr_MIN Number(20,4) NOT NULL,
ViPstFclr_MAX Number(20,4) NOT NULL,
ViPstFclr_STCNT varchar2(32) NOT NULL,
ViLFrPrAg_MIN Number(20,4) NOT NULL,
ViLFrPrAg_MAX Number(20,4) NOT NULL,
ViLFrPrAg_STCNT varchar2(32) NOT NULL,
ViFrRteAg_MIN Number(20,4) NOT NULL,
ViFrRteAg_MAX Number(20,4) NOT NULL,
ViFrRteAg_STCNT varchar2(32) NOT NULL,
PrStrmcnt_MIN Number(20,4) NOT NULL,
PrStrmcnt_MAX Number(20,4) NOT NULL,
PrStrmcnt_STCNT varchar2(32) NOT NULL,
GdStrmCnt_MIN Number(20,4) NOT NULL,
GdStrmCnt_MAX Number(20,4) NOT NULL,
GdStrmCnt_STCNT varchar2(32) NOT NULL,
UncfdSmCnt_MIN Number(20,4) NOT NULL,
UncfdSmCnt_MAX Number(20,4) NOT NULL,
UncfdSmCnt_STCNT varchar2(32) NOT NULL,
PrPercent_MIN Number(20,4) NOT NULL,
PrPercent_MAX Number(20,4) NOT NULL,
PrPercent_STCNT varchar2(32) NOT NULL,
AvPsFECPLR_MIN Number(20,4) NOT NULL,
AvPsFECPLR_MAX Number(20,4) NOT NULL,
AvPsFECPLR_STCNT varchar2(32) NOT NULL,
AvLclFmLs_MIN Number(20,4) NOT NULL,
AvLclFmLs_MAX Number(20,4) NOT NULL,
AvLclFmLs_STCNT varchar2(32) NOT NULL,
AvRcvFmRtAg_MIN Number(20,4) NOT NULL,
AvRcvFmRtAg_MAX Number(20,4) NOT NULL,
AvRcvFmRtAg_STCNT varchar2(32) NOT NULL,
AvLwFmRtCPt_MIN Number(20,4) NOT NULL,
AvLwFmRtCPt_MAX Number(20,4) NOT NULL,
AvLwFmRtCPt_STCNT varchar2(32) NOT NULL,
AvPktLsRt_MIN Number(20,4) NOT NULL,
AvPktLsRt_MAX Number(20,4) NOT NULL,
AvPktLsRt_STCNT varchar2(32) NOT NULL,
AvDycCpyPnt_MIN Number(20,4) NOT NULL,
AvDycCpyPnt_MAX Number(20,4) NOT NULL,
AvDycCpyPnt_STCNT varchar2(32) NOT NULL
);
ALTER TABLE MTMWHVideoStrmsTest_TREND ADD constraint PK_MTMWHVideoStrmsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMWHVideoStrmsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMWHVideoStrmsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Strmcnt_MIN varchar2(256) NOT NULL,
Strmcnt_MAX varchar2(256) NOT NULL,
ViPstFclr_MIN varchar2(256) NOT NULL,
ViPstFclr_MAX varchar2(256) NOT NULL,
ViLFrPrAg_MIN varchar2(256) NOT NULL,
ViLFrPrAg_MAX varchar2(256) NOT NULL,
ViFrRteAg_MIN varchar2(256) NOT NULL,
ViFrRteAg_MAX varchar2(256) NOT NULL,
PrStrmcnt_MIN varchar2(256) NOT NULL,
PrStrmcnt_MAX varchar2(256) NOT NULL,
GdStrmCnt_MIN varchar2(256) NOT NULL,
GdStrmCnt_MAX varchar2(256) NOT NULL,
UncfdSmCnt_MIN varchar2(256) NOT NULL,
UncfdSmCnt_MAX varchar2(256) NOT NULL,
PrPercent_MIN varchar2(256) NOT NULL,
PrPercent_MAX varchar2(256) NOT NULL,
AvPsFECPLR_MIN varchar2(256) NOT NULL,
AvPsFECPLR_MAX varchar2(256) NOT NULL,
AvLclFmLs_MIN varchar2(256) NOT NULL,
AvLclFmLs_MAX varchar2(256) NOT NULL,
AvRcvFmRtAg_MIN varchar2(256) NOT NULL,
AvRcvFmRtAg_MAX varchar2(256) NOT NULL,
AvLwFmRtCPt_MIN varchar2(256) NOT NULL,
AvLwFmRtCPt_MAX varchar2(256) NOT NULL,
AvPktLsRt_MIN varchar2(256) NOT NULL,
AvPktLsRt_MAX varchar2(256) NOT NULL,
AvDycCpyPnt_MIN varchar2(256) NOT NULL,
AvDycCpyPnt_MAX varchar2(256) NOT NULL);
ALTER TABLE MTMWHVideoStrmsTest_THRESH ADD constraint PK_MTMWHVideoStrmsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMWHVideoStrmsTest_THRESH ON MTMWHVideoStrmsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMWHVideoStrmsTest ON MTMWHVideoStrmsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMWHVideoStrmsTest ON MTMWHVideoStrmsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMWHVBSSStrmsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMWHVBSSStrmsTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
VBSStms Number(20,4) NOT NULL,
VBSStms_ST varchar2(32) NOT NULL,
VBSStmPrVpF Number(20,4) NOT NULL,
VBSStmPrVpF_ST varchar2(32) NOT NULL,
VBSPrVLsAv Number(20,4) NOT NULL,
VBSPrVLsAv_ST varchar2(32) NOT NULL,
VBSPrVFmeAv Number(20,4) NOT NULL,
VBSPrVFmeAv_ST varchar2(32) NOT NULL,
VBSPrStm Number(20,4) NOT NULL,
VBSPrStm_ST varchar2(32) NOT NULL,
VBSGdStm Number(20,4) NOT NULL,
VBSGdStm_ST varchar2(32) NOT NULL,
VBSUclfdStm Number(20,4) NOT NULL,
VBSUclfdStm_ST varchar2(32) NOT NULL,
VBSPrPrcnt Number(20,4) NOT NULL,
VBSPrPrcnt_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_MTMWHVBSSStrmsTest ON MTMWHVBSSStrmsTest(MSMT_TIME);
ALTER TABLE MTMWHVBSSStrmsTest ADD constraint PK_MTMWHVBSSStrmsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMWHVBSSStrmsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMWHVBSSStrmsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
VBSStms_MIN Number(20,4) NOT NULL,
VBSStms_MAX Number(20,4) NOT NULL,
VBSStms_STCNT varchar2(32) NOT NULL,
VBSStmPrVpF_MIN Number(20,4) NOT NULL,
VBSStmPrVpF_MAX Number(20,4) NOT NULL,
VBSStmPrVpF_STCNT varchar2(32) NOT NULL,
VBSPrVLsAv_MIN Number(20,4) NOT NULL,
VBSPrVLsAv_MAX Number(20,4) NOT NULL,
VBSPrVLsAv_STCNT varchar2(32) NOT NULL,
VBSPrVFmeAv_MIN Number(20,4) NOT NULL,
VBSPrVFmeAv_MAX Number(20,4) NOT NULL,
VBSPrVFmeAv_STCNT varchar2(32) NOT NULL,
VBSPrStm_MIN Number(20,4) NOT NULL,
VBSPrStm_MAX Number(20,4) NOT NULL,
VBSPrStm_STCNT varchar2(32) NOT NULL,
VBSGdStm_MIN Number(20,4) NOT NULL,
VBSGdStm_MAX Number(20,4) NOT NULL,
VBSGdStm_STCNT varchar2(32) NOT NULL,
VBSUclfdStm_MIN Number(20,4) NOT NULL,
VBSUclfdStm_MAX Number(20,4) NOT NULL,
VBSUclfdStm_STCNT varchar2(32) NOT NULL,
VBSPrPrcnt_MIN Number(20,4) NOT NULL,
VBSPrPrcnt_MAX Number(20,4) NOT NULL,
VBSPrPrcnt_STCNT varchar2(32) NOT NULL
);
ALTER TABLE MTMWHVBSSStrmsTest_TREND ADD constraint PK_MTMWHVBSSStrmsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMWHVBSSStrmsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMWHVBSSStrmsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
VBSStms_MIN varchar2(256) NOT NULL,
VBSStms_MAX varchar2(256) NOT NULL,
VBSStmPrVpF_MIN varchar2(256) NOT NULL,
VBSStmPrVpF_MAX varchar2(256) NOT NULL,
VBSPrVLsAv_MIN varchar2(256) NOT NULL,
VBSPrVLsAv_MAX varchar2(256) NOT NULL,
VBSPrVFmeAv_MIN varchar2(256) NOT NULL,
VBSPrVFmeAv_MAX varchar2(256) NOT NULL,
VBSPrStm_MIN varchar2(256) NOT NULL,
VBSPrStm_MAX varchar2(256) NOT NULL,
VBSGdStm_MIN varchar2(256) NOT NULL,
VBSGdStm_MAX varchar2(256) NOT NULL,
VBSUclfdStm_MIN varchar2(256) NOT NULL,
VBSUclfdStm_MAX varchar2(256) NOT NULL,
VBSPrPrcnt_MIN varchar2(256) NOT NULL,
VBSPrPrcnt_MAX varchar2(256) NOT NULL
);
ALTER TABLE MTMWHVBSSStrmsTest_THRESH ADD constraint PK_MTMWHVBSSStrmsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMWHVBSSStrmsTest_THRESH ON MTMWHVBSSStrmsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMWHVBSSStrmsTest ON MTMWHVBSSStrmsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMWHVBSSStrmsTest ON MTMWHVBSSStrmsTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MTMWHCalSumryTest CASCADE CONSTRAINTS;
CREATE TABLE MTMWHCalSumryTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TotStrmCt Number(20,4) NOT NULL,
TotStrmCt_ST varchar2(32) NOT NULL,
MedFldStrmCt Number(20,4) NOT NULL,
MedFldStrmCt_ST varchar2(32) NOT NULL,
ClSupFldStrmCt Number(20,4) NOT NULL,
ClSupFldStrmCt_ST varchar2(32) NOT NULL,
ClDrpdStrmCt Number(20,4) NOT NULL,
ClDrpdStrmCt_ST varchar2(32) NOT NULL,
MedSudedStrmCt Number(20,4) NOT NULL,
MedSudedStrmCt_ST varchar2(32) NOT NULL,
ClSupSudStrmCt Number(20,4) NOT NULL,
ClSupSudStrmCt_ST varchar2(32) NOT NULL,
ClSupFlrPer Number(20,4) NOT NULL,
ClSupFlrPer_ST varchar2(32) NOT NULL,
ClDrpdFlrPer Number(20,4) NOT NULL,
ClDrpdFlrPer_ST varchar2(32) NOT NULL,
MedFlrPer Number(20,4) NOT NULL,
MedFlrPer_ST varchar2(32) NOT NULL,
AvgCalDurtn Number(20,4) NOT NULL,
AvgCalDurtn_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_MTMWHCalSumryTest ON MTMWHCalSumryTest(MSMT_TIME);
ALTER TABLE MTMWHCalSumryTest ADD constraint PK_MTMWHCalSumryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMWHCalSumryTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMWHCalSumryTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TotStrmCt_MIN Number(20,4) NOT NULL,
TotStrmCt_MAX Number(20,4) NOT NULL,
TotStrmCt_STCNT varchar2(32) NOT NULL,
MedFldStrmCt_MIN Number(20,4) NOT NULL,
MedFldStrmCt_MAX Number(20,4) NOT NULL,
MedFldStrmCt_STCNT varchar2(32) NOT NULL,
ClSupFldStrmCt_MIN Number(20,4) NOT NULL,
ClSupFldStrmCt_MAX Number(20,4) NOT NULL,
ClSupFldStrmCt_STCNT varchar2(32) NOT NULL,
ClDrpdStrmCt_MIN Number(20,4) NOT NULL,
ClDrpdStrmCt_MAX Number(20,4) NOT NULL,
ClDrpdStrmCt_STCNT varchar2(32) NOT NULL,
MedSudedStrmCt_MIN Number(20,4) NOT NULL,
MedSudedStrmCt_MAX Number(20,4) NOT NULL,
MedSudedStrmCt_STCNT varchar2(32) NOT NULL,
ClSupSudStrmCt_MIN Number(20,4) NOT NULL,
ClSupSudStrmCt_MAX Number(20,4) NOT NULL,
ClSupSudStrmCt_STCNT varchar2(32) NOT NULL,
ClSupFlrPer_MIN Number(20,4) NOT NULL,
ClSupFlrPer_MAX Number(20,4) NOT NULL,
ClSupFlrPer_STCNT varchar2(32) NOT NULL,
ClDrpdFlrPer_MIN Number(20,4) NOT NULL,
ClDrpdFlrPer_MAX Number(20,4) NOT NULL,
ClDrpdFlrPer_STCNT varchar2(32) NOT NULL,
MedFlrPer_MIN Number(20,4) NOT NULL,
MedFlrPer_MAX Number(20,4) NOT NULL,
MedFlrPer_STCNT varchar2(32) NOT NULL,
AvgCalDurtn_MIN Number(20,4) NOT NULL,
AvgCalDurtn_MAX Number(20,4) NOT NULL,
AvgCalDurtn_STCNT varchar2(32) NOT NULL
);
ALTER TABLE MTMWHCalSumryTest_TREND ADD constraint PK_MTMWHCalSumryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMWHCalSumryTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMWHCalSumryTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TotStrmCt_MIN varchar2(256) NOT NULL,
TotStrmCt_MAX varchar2(256) NOT NULL,
MedFldStrmCt_MIN varchar2(256) NOT NULL,
MedFldStrmCt_MAX varchar2(256) NOT NULL,
ClSupFldStrmCt_MIN varchar2(256) NOT NULL,
ClSupFldStrmCt_MAX varchar2(256) NOT NULL,
ClDrpdStrmCt_MIN varchar2(256) NOT NULL,
ClDrpdStrmCt_MAX varchar2(256) NOT NULL,
MedSudedStrmCt_MIN varchar2(256) NOT NULL,
MedSudedStrmCt_MAX varchar2(256) NOT NULL,
ClSupSudStrmCt_MIN varchar2(256) NOT NULL,
ClSupSudStrmCt_MAX varchar2(256) NOT NULL,
ClSupFlrPer_MIN varchar2(256) NOT NULL,
ClSupFlrPer_MAX varchar2(256) NOT NULL,
ClDrpdFlrPer_MIN varchar2(256) NOT NULL,
ClDrpdFlrPer_MAX varchar2(256) NOT NULL,
MedFlrPer_MIN varchar2(256) NOT NULL,
MedFlrPer_MAX varchar2(256) NOT NULL,
AvgCalDurtn_MIN varchar2(256) NOT NULL,
AvgCalDurtn_MAX varchar2(256) NOT NULL
);
ALTER TABLE MTMWHCalSumryTest_THRESH ADD constraint PK_MTMWHCalSumryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMWHCalSumryTest_THRESH ON MTMWHCalSumryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMWHCalSumryTest ON MTMWHCalSumryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMWHCalSumryTest ON MTMWHCalSumryTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMWHFdBckSmryTest CASCADE CONSTRAINTS;
CREATE TABLE MTMWHFdBckSmryTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
FFbkRgPrCt Number(20,4) NOT NULL,
FFbkRgPrCt_ST varchar2(32) NOT NULL,
SFbkRgPrCt Number(20,4) NOT NULL,
SFbkRgPrCt_ST varchar2(32) NOT NULL,
FFbkRgPrPt Number(20,4) NOT NULL,
FFbkRgPrPt_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_MTMWHFdBckSmryTest ON MTMWHFdBckSmryTest(MSMT_TIME);
ALTER TABLE MTMWHFdBckSmryTest ADD constraint PK_MTMWHFdBckSmryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMWHFdBckSmryTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMWHFdBckSmryTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
FFbkRgPrCt_MIN Number(20,4) NOT NULL,
FFbkRgPrCt_MAX Number(20,4) NOT NULL,
FFbkRgPrCt_STCNT varchar2(32) NOT NULL,
SFbkRgPrCt_MIN Number(20,4) NOT NULL,
SFbkRgPrCt_MAX Number(20,4) NOT NULL,
SFbkRgPrCt_STCNT varchar2(32) NOT NULL,
FFbkRgPrPt_MIN Number(20,4) NOT NULL,
FFbkRgPrPt_MAX Number(20,4) NOT NULL,
FFbkRgPrPt_STCNT varchar2(32) NOT NULL
);
ALTER TABLE MTMWHFdBckSmryTest_TREND ADD constraint PK_MTMWHFdBckSmryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMWHFdBckSmryTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMWHFdBckSmryTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
FFbkRgPrCt_MIN varchar2(256) NOT NULL,
FFbkRgPrCt_MAX varchar2(256) NOT NULL,
SFbkRgPrCt_MIN varchar2(256) NOT NULL,
SFbkRgPrCt_MAX varchar2(256) NOT NULL,
FFbkRgPrPt_MIN varchar2(256) NOT NULL,
FFbkRgPrPt_MAX varchar2(256) NOT NULL
);
ALTER TABLE MTMWHFdBckSmryTest_THRESH ADD constraint PK_MTMWHFdBckSmryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMWHFdBckSmryTest_THRESH ON MTMWHFdBckSmryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMWHFdBckSmryTest ON MTMWHFdBckSmryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMWHFdBckSmryTest ON MTMWHFdBckSmryTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMWHNetQtySmyTest CASCADE CONSTRAINTS;
CREATE TABLE MTMWHNetQtySmyTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AvgAudDgtn Number(20,4) NOT NULL,
AvgAudDgtn_ST varchar2(32) NOT NULL,
AvgJitter Number(20,4) NOT NULL,
AvgJitter_ST varchar2(32) NOT NULL,
MxmJitter Number(20,4) NOT NULL,
MxmJitter_ST varchar2(32) NOT NULL,
AvgPtLsRt Number(20,4) NOT NULL,
AvgPtLsRt_ST varchar2(32) NOT NULL,
MxPtLsRte Number(20,4) NOT NULL,
MxPtLsRte_ST varchar2(32) NOT NULL,
CnldSmplAvg Number(20,4) NOT NULL,
CnldSmplAvg_ST varchar2(32) NOT NULL,
AvgRndTrip Number(20,4) NOT NULL,
AvgRndTrip_ST varchar2(32) NOT NULL,
AvgRndTripMx Number(20,4) NOT NULL,
AvgRndTripMx_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_MTMWHNetQtySmyTest ON MTMWHNetQtySmyTest(MSMT_TIME);
ALTER TABLE MTMWHNetQtySmyTest ADD constraint PK_MTMWHNetQtySmyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMWHNetQtySmyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMWHNetQtySmyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AvgAudDgtn_MIN Number(20,4) NOT NULL,
AvgAudDgtn_MAX Number(20,4) NOT NULL,
AvgAudDgtn_STCNT varchar2(32) NOT NULL,
AvgJitter_MIN Number(20,4) NOT NULL,
AvgJitter_MAX Number(20,4) NOT NULL,
AvgJitter_STCNT varchar2(32) NOT NULL,
MxmJitter_MIN Number(20,4) NOT NULL,
MxmJitter_MAX Number(20,4) NOT NULL,
MxmJitter_STCNT varchar2(32) NOT NULL,
AvgPtLsRt_MIN Number(20,4) NOT NULL,
AvgPtLsRt_MAX Number(20,4) NOT NULL,
AvgPtLsRt_STCNT varchar2(32) NOT NULL,
MxPtLsRte_MIN Number(20,4) NOT NULL,
MxPtLsRte_MAX Number(20,4) NOT NULL,
MxPtLsRte_STCNT varchar2(32) NOT NULL,
CnldSmplAvg_MIN Number(20,4) NOT NULL,
CnldSmplAvg_MAX Number(20,4) NOT NULL,
CnldSmplAvg_STCNT varchar2(32) NOT NULL,
AvgRndTrip_MIN Number(20,4) NOT NULL,
AvgRndTrip_MAX Number(20,4) NOT NULL,
AvgRndTrip_STCNT varchar2(32) NOT NULL,
AvgRndTripMx_MIN Number(20,4) NOT NULL,
AvgRndTripMx_MAX Number(20,4) NOT NULL,
AvgRndTripMx_STCNT varchar2(32) NOT NULL
);
ALTER TABLE MTMWHNetQtySmyTest_TREND ADD constraint PK_MTMWHNetQtySmyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMWHNetQtySmyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMWHNetQtySmyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AvgAudDgtn_MIN varchar2(256) NOT NULL,
AvgAudDgtn_MAX varchar2(256) NOT NULL,
AvgJitter_MIN varchar2(256) NOT NULL,
AvgJitter_MAX varchar2(256) NOT NULL,
MxmJitter_MIN varchar2(256) NOT NULL,
MxmJitter_MAX varchar2(256) NOT NULL,
AvgPtLsRt_MIN varchar2(256) NOT NULL,
AvgPtLsRt_MAX varchar2(256) NOT NULL,
MxPtLsRte_MIN varchar2(256) NOT NULL,
MxPtLsRte_MAX varchar2(256) NOT NULL,
CnldSmplAvg_MIN varchar2(256) NOT NULL,
CnldSmplAvg_MAX varchar2(256) NOT NULL,
AvgRndTrip_MIN varchar2(256) NOT NULL,
AvgRndTrip_MAX varchar2(256) NOT NULL,
AvgRndTripMx_MIN varchar2(256) NOT NULL,
AvgRndTripMx_MAX varchar2(256) NOT NULL
);
ALTER TABLE MTMWHNetQtySmyTest_THRESH ADD constraint PK_MTMWHNetQtySmyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMWHNetQtySmyTest_THRESH ON MTMWHNetQtySmyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMWHNetQtySmyTest ON MTMWHNetQtySmyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMWHNetQtySmyTest ON MTMWHNetQtySmyTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE YMRLoginTest CASCADE CONSTRAINTS;
CREATE TABLE YMRLoginTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
LOGIN_STATUS Number(20,4) NOT NULL,
LOGIN_STATUS_ST varchar2(32) NOT NULL,
LOGIN_TIME Number(20,4) NOT NULL,
LOGIN_TIME_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_YMRLoginTest ON YMRLoginTest(MSMT_TIME);
ALTER TABLE YMRLoginTest ADD constraint PK_YMRLoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE YMRLoginTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE YMRLoginTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
LOGIN_STATUS_MIN Number(20,4) NOT NULL,
LOGIN_STATUS_MAX Number(20,4) NOT NULL,
LOGIN_STATUS_STCNT varchar2(32) NOT NULL,
LOGIN_TIME_MIN Number(20,4) NOT NULL,
LOGIN_TIME_MAX Number(20,4) NOT NULL,
LOGIN_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE YMRLoginTest_TREND ADD constraint PK_YMRLoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE YMRLoginTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE YMRLoginTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
LOGIN_STATUS_MIN varchar2(256) NOT NULL,
LOGIN_STATUS_MAX varchar2(256) NOT NULL,
LOGIN_TIME_MIN varchar2(256) NOT NULL,
LOGIN_TIME_MAX varchar2(256) NOT NULL);

ALTER TABLE YMRLoginTest_THRESH ADD constraint PK_YMRLoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_YMRLoginTest_THRESH ON YMRLoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_YMRLoginTest ON YMRLoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_YMRLoginTest ON YMRLoginTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MTMTeamOprtnTest CASCADE CONSTRAINTS;
CREATE TABLE MTMTeamOprtnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
getTeam_status Number(20,4) NOT NULL,
getTeam_status_ST varchar2(32) NOT NULL,
getTeam_Tim Number(20,4) NOT NULL,
getTeam_Tim_ST varchar2(32) NOT NULL,
updatTeam_status Number(20,4) NOT NULL,
updatTeam_status_ST varchar2(32) NOT NULL,
updatTeam_Tim Number(20,4) NOT NULL,
updatTeam_Tim_ST varchar2(32) NOT NULL,
getMem_status Number(20,4) NOT NULL,
getMem_status_ST varchar2(32) NOT NULL,
getMem_Tim Number(20,4) NOT NULL,
getMem_Tim_ST varchar2(32) NOT NULL,
lstMem_status Number(20,4) NOT NULL,
lstMem_status_ST varchar2(32) NOT NULL,
lstMem_Tim Number(20,4) NOT NULL,
lstMem_Tim_ST varchar2(32) NOT NULL,
updatMem_status Number(20,4) NOT NULL,
updatMem_status_ST varchar2(32) NOT NULL,
updatMem_Tim Number(20,4) NOT NULL,
updatMem_Tim_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMTeamOprtnTest ON MTMTeamOprtnTest(MSMT_TIME);
ALTER TABLE MTMTeamOprtnTest ADD constraint PK_MTMTeamOprtnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMTeamOprtnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMTeamOprtnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
getTeam_status_MIN Number(20,4) NOT NULL,
getTeam_status_MAX Number(20,4) NOT NULL,
getTeam_status_STCNT varchar2(32) NOT NULL,
getTeam_Tim_MIN Number(20,4) NOT NULL,
getTeam_Tim_MAX Number(20,4) NOT NULL,
getTeam_Tim_STCNT varchar2(32) NOT NULL,
updatTeam_status_MIN Number(20,4) NOT NULL,
updatTeam_status_MAX Number(20,4) NOT NULL,
updatTeam_status_STCNT varchar2(32) NOT NULL,
updatTeam_Tim_MIN Number(20,4) NOT NULL,
updatTeam_Tim_MAX Number(20,4) NOT NULL,
updatTeam_Tim_STCNT varchar2(32) NOT NULL,
getMem_status_MIN Number(20,4) NOT NULL,
getMem_status_MAX Number(20,4) NOT NULL,
getMem_status_STCNT varchar2(32) NOT NULL,
getMem_Tim_MIN Number(20,4) NOT NULL,
getMem_Tim_MAX Number(20,4) NOT NULL,
getMem_Tim_STCNT varchar2(32) NOT NULL,
lstMem_status_MIN Number(20,4) NOT NULL,
lstMem_status_MAX Number(20,4) NOT NULL,
lstMem_status_STCNT varchar2(32) NOT NULL,
lstMem_Tim_MIN Number(20,4) NOT NULL,
lstMem_Tim_MAX Number(20,4) NOT NULL,
lstMem_Tim_STCNT varchar2(32) NOT NULL,
updatMem_status_MIN Number(20,4) NOT NULL,
updatMem_status_MAX Number(20,4) NOT NULL,
updatMem_status_STCNT varchar2(32) NOT NULL,
updatMem_Tim_MIN Number(20,4) NOT NULL,
updatMem_Tim_MAX Number(20,4) NOT NULL,
updatMem_Tim_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMTeamOprtnTest_TREND ADD constraint PK_MTMTeamOprtnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMTeamOprtnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMTeamOprtnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
getTeam_status_MIN VARCHAR2(256) NOT NULL,
getTeam_status_MAX VARCHAR2(256) NOT NULL,
getTeam_Tim_MIN VARCHAR2(256) NOT NULL,
getTeam_Tim_MAX VARCHAR2(256) NOT NULL,
updatTeam_status_MIN VARCHAR2(256) NOT NULL,
updatTeam_status_MAX VARCHAR2(256) NOT NULL,
updatTeam_Tim_MIN VARCHAR2(256) NOT NULL,
updatTeam_Tim_MAX VARCHAR2(256) NOT NULL,
getMem_status_MIN VARCHAR2(256) NOT NULL,
getMem_status_MAX VARCHAR2(256) NOT NULL,
getMem_Tim_MIN VARCHAR2(256) NOT NULL,
getMem_Tim_MAX VARCHAR2(256) NOT NULL,
lstMem_status_MIN VARCHAR2(256) NOT NULL,
lstMem_status_MAX VARCHAR2(256) NOT NULL,
lstMem_Tim_MIN VARCHAR2(256) NOT NULL,
lstMem_Tim_MAX VARCHAR2(256) NOT NULL,
updatMem_status_MIN VARCHAR2(256) NOT NULL,
updatMem_status_MAX VARCHAR2(256) NOT NULL,
updatMem_Tim_MIN VARCHAR2(256) NOT NULL,
updatMem_Tim_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE MTMTeamOprtnTest_THRESH ADD constraint PK_MTMTeamOprtnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMTeamOprtnTest_THRESH ON MTMTeamOprtnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMTeamOprtnTest ON MTMTeamOprtnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMTeamOprtnTest ON MTMTeamOprtnTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MTMChatOprtnTest CASCADE CONSTRAINTS;
CREATE TABLE MTMChatOprtnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
getChat_status Number(20,4) NOT NULL,
getChat_status_ST varchar2(32) NOT NULL,
getChat_Tim Number(20,4) NOT NULL,
getChat_Tim_ST varchar2(32) NOT NULL,
updatChat_status Number(20,4) NOT NULL,
updatChat_status_ST varchar2(32) NOT NULL,
updatChat_Tim Number(20,4) NOT NULL,
updatChat_Tim_ST varchar2(32) NOT NULL,
getMemC_status Number(20,4) NOT NULL,
getMemC_status_ST varchar2(32) NOT NULL,
getMemC_Tim Number(20,4) NOT NULL,
getMemC_Tim_ST varchar2(32) NOT NULL,
lstMemC_status Number(20,4) NOT NULL,
lstMemC_status_ST varchar2(32) NOT NULL,
lstMemC_Tim Number(20,4) NOT NULL,
lstMemC_Tim_ST varchar2(32) NOT NULL,
sndMsg_status Number(20,4) NOT NULL,
sndMsg_status_ST varchar2(32) NOT NULL,
sndMsg_Tim Number(20,4) NOT NULL,
sndMsg_Tim_ST varchar2(32) NOT NULL,
getMsg_status Number(20,4) NOT NULL,
getMsg_status_ST varchar2(32) NOT NULL,
getMsg_Tim Number(20,4) NOT NULL,
getMsg_Tim_ST varchar2(32) NOT NULL,
lstMsg_status Number(20,4) NOT NULL,
lstMsg_status_ST varchar2(32) NOT NULL,
lstMsg_Tim Number(20,4) NOT NULL,
lstMsg_Tim_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMChatOprtnTest ON MTMChatOprtnTest(MSMT_TIME);
ALTER TABLE MTMChatOprtnTest ADD constraint PK_MTMChatOprtnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMChatOprtnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMChatOprtnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
getChat_status_MIN Number(20,4) NOT NULL,
getChat_status_MAX Number(20,4) NOT NULL,
getChat_status_STCNT varchar2(32) NOT NULL,
getChat_Tim_MIN Number(20,4) NOT NULL,
getChat_Tim_MAX Number(20,4) NOT NULL,
getChat_Tim_STCNT varchar2(32) NOT NULL,
updatChat_status_MIN Number(20,4) NOT NULL,
updatChat_status_MAX Number(20,4) NOT NULL,
updatChat_status_STCNT varchar2(32) NOT NULL,
updatChat_Tim_MIN Number(20,4) NOT NULL,
updatChat_Tim_MAX Number(20,4) NOT NULL,
updatChat_Tim_STCNT varchar2(32) NOT NULL,
getMemC_status_MIN Number(20,4) NOT NULL,
getMemC_status_MAX Number(20,4) NOT NULL,
getMemC_status_STCNT varchar2(32) NOT NULL,
getMemC_Tim_MIN Number(20,4) NOT NULL,
getMemC_Tim_MAX Number(20,4) NOT NULL,
getMemC_Tim_STCNT varchar2(32) NOT NULL,
lstMemC_status_MIN Number(20,4) NOT NULL,
lstMemC_status_MAX Number(20,4) NOT NULL,
lstMemC_status_STCNT varchar2(32) NOT NULL,
lstMemC_Tim_MIN Number(20,4) NOT NULL,
lstMemC_Tim_MAX Number(20,4) NOT NULL,
lstMemC_Tim_STCNT varchar2(32) NOT NULL,
sndMsg_status_MIN Number(20,4) NOT NULL,
sndMsg_status_MAX Number(20,4) NOT NULL,
sndMsg_status_STCNT varchar2(32) NOT NULL,
sndMsg_Tim_MIN Number(20,4) NOT NULL,
sndMsg_Tim_MAX Number(20,4) NOT NULL,
sndMsg_Tim_STCNT varchar2(32) NOT NULL,
getMsg_status_MIN Number(20,4) NOT NULL,
getMsg_status_MAX Number(20,4) NOT NULL,
getMsg_status_STCNT varchar2(32) NOT NULL,
getMsg_Tim_MIN Number(20,4) NOT NULL,
getMsg_Tim_MAX Number(20,4) NOT NULL,
getMsg_Tim_STCNT varchar2(32) NOT NULL,
lstMsg_status_MIN Number(20,4) NOT NULL,
lstMsg_status_MAX Number(20,4) NOT NULL,
lstMsg_status_STCNT varchar2(32) NOT NULL,
lstMsg_Tim_MIN Number(20,4) NOT NULL,
lstMsg_Tim_MAX Number(20,4) NOT NULL,
lstMsg_Tim_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMChatOprtnTest_TREND ADD constraint PK_MTMChatOprtnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMChatOprtnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMChatOprtnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
getChat_status_MIN VARCHAR2(256) NOT NULL,
getChat_status_MAX VARCHAR2(256) NOT NULL,
getChat_Tim_MIN VARCHAR2(256) NOT NULL,
getChat_Tim_MAX VARCHAR2(256) NOT NULL,
updatChat_status_MIN VARCHAR2(256) NOT NULL,
updatChat_status_MAX VARCHAR2(256) NOT NULL,
updatChat_Tim_MIN VARCHAR2(256) NOT NULL,
updatChat_Tim_MAX VARCHAR2(256) NOT NULL,
getMemC_status_MIN VARCHAR2(256) NOT NULL,
getMemC_status_MAX VARCHAR2(256) NOT NULL,
getMemC_Tim_MIN VARCHAR2(256) NOT NULL,
getMemC_Tim_MAX VARCHAR2(256) NOT NULL,
lstMemC_status_MIN VARCHAR2(256) NOT NULL,
lstMemC_status_MAX VARCHAR2(256) NOT NULL,
lstMemC_Tim_MIN VARCHAR2(256) NOT NULL,
lstMemC_Tim_MAX VARCHAR2(256) NOT NULL,
sndMsg_status_MIN VARCHAR2(256) NOT NULL,
sndMsg_status_MAX VARCHAR2(256) NOT NULL,
sndMsg_Tim_MIN VARCHAR2(256) NOT NULL,
sndMsg_Tim_MAX VARCHAR2(256) NOT NULL,
getMsg_status_MIN VARCHAR2(256) NOT NULL,
getMsg_status_MAX VARCHAR2(256) NOT NULL,
getMsg_Tim_MIN VARCHAR2(256) NOT NULL,
getMsg_Tim_MAX VARCHAR2(256) NOT NULL,
lstMsg_status_MIN VARCHAR2(256) NOT NULL,
lstMsg_status_MAX VARCHAR2(256) NOT NULL,
lstMsg_Tim_MIN VARCHAR2(256) NOT NULL,
lstMsg_Tim_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE MTMChatOprtnTest_THRESH ADD constraint PK_MTMChatOprtnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMChatOprtnTest_THRESH ON MTMChatOprtnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMChatOprtnTest ON MTMChatOprtnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMChatOprtnTest ON MTMChatOprtnTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MTMChannelOprtnTest CASCADE CONSTRAINTS;
CREATE TABLE MTMChannelOprtnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
getChnl_status Number(20,4) NOT NULL,
getChnl_status_ST varchar2(32) NOT NULL,
getChnl_Tim Number(20,4) NOT NULL,
getChnl_Tim_ST varchar2(32) NOT NULL,
updatChnl_status Number(20,4) NOT NULL,
updatChnl_status_ST varchar2(32) NOT NULL,
updatChnl_Tim Number(20,4) NOT NULL,
updatChnl_Tim_ST varchar2(32) NOT NULL,
getMemC_status Number(20,4) NOT NULL,
getMemC_status_ST varchar2(32) NOT NULL,
getMemC_Tim Number(20,4) NOT NULL,
getMemC_Tim_ST varchar2(32) NOT NULL,
lstMemC_status Number(20,4) NOT NULL,
lstMemC_status_ST varchar2(32) NOT NULL,
lstMemC_Tim Number(20,4) NOT NULL,
lstMemC_Tim_ST varchar2(32) NOT NULL,
updatMemC_status Number(20,4) NOT NULL,
updatMemC_status_ST varchar2(32) NOT NULL,
updatMemC_Tim Number(20,4) NOT NULL,
updatMemC_Tim_ST varchar2(32) NOT NULL,
sndMsg_status Number(20,4) NOT NULL,
sndMsg_status_ST varchar2(32) NOT NULL,
sndMsg_Tim Number(20,4) NOT NULL,
sndMsg_Tim_ST varchar2(32) NOT NULL,
rmsg_status Number(20,4) NOT NULL,
rmsg_status_ST varchar2(32) NOT NULL,
rmsg_Tim Number(20,4) NOT NULL,
rmsg_Tim_ST varchar2(32) NOT NULL,
getMsgR_status Number(20,4) NOT NULL,
getMsgR_status_ST varchar2(32) NOT NULL,
getMsgR_Tim Number(20,4) NOT NULL,
getMsgR_Tim_ST varchar2(32) NOT NULL,
lstMsgR_status Number(20,4) NOT NULL,
lstMsgR_status_ST varchar2(32) NOT NULL,
lstMsgR_Tim Number(20,4) NOT NULL,
lstMsgR_Tim_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMChannelOprtnTest ON MTMChannelOprtnTest(MSMT_TIME);
ALTER TABLE MTMChannelOprtnTest ADD constraint PK_MTMChannelOprtnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMChannelOprtnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMChannelOprtnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
getChnl_status_MIN Number(20,4) NOT NULL,
getChnl_status_MAX Number(20,4) NOT NULL,
getChnl_status_STCNT varchar2(32) NOT NULL,
getChnl_Tim_MIN Number(20,4) NOT NULL,
getChnl_Tim_MAX Number(20,4) NOT NULL,
getChnl_Tim_STCNT varchar2(32) NOT NULL,
updatChnl_status_MIN Number(20,4) NOT NULL,
updatChnl_status_MAX Number(20,4) NOT NULL,
updatChnl_status_STCNT varchar2(32) NOT NULL,
updatChnl_Tim_MIN Number(20,4) NOT NULL,
updatChnl_Tim_MAX Number(20,4) NOT NULL,
updatChnl_Tim_STCNT varchar2(32) NOT NULL,
getMemC_status_MIN Number(20,4) NOT NULL,
getMemC_status_MAX Number(20,4) NOT NULL,
getMemC_status_STCNT varchar2(32) NOT NULL,
getMemC_Tim_MIN Number(20,4) NOT NULL,
getMemC_Tim_MAX Number(20,4) NOT NULL,
getMemC_Tim_STCNT varchar2(32) NOT NULL,
lstMemC_status_MIN Number(20,4) NOT NULL,
lstMemC_status_MAX Number(20,4) NOT NULL,
lstMemC_status_STCNT varchar2(32) NOT NULL,
lstMemC_Tim_MIN Number(20,4) NOT NULL,
lstMemC_Tim_MAX Number(20,4) NOT NULL,
lstMemC_Tim_STCNT varchar2(32) NOT NULL,
updatMemC_status_MIN Number(20,4) NOT NULL,
updatMemC_status_MAX Number(20,4) NOT NULL,
updatMemC_status_STCNT varchar2(32) NOT NULL,
updatMemC_Tim_MIN Number(20,4) NOT NULL,
updatMemC_Tim_MAX Number(20,4) NOT NULL,
updatMemC_Tim_STCNT varchar2(32) NOT NULL,
sndMsg_status_MIN Number(20,4) NOT NULL,
sndMsg_status_MAX Number(20,4) NOT NULL,
sndMsg_status_STCNT varchar2(32) NOT NULL,
sndMsg_Tim_MIN Number(20,4) NOT NULL,
sndMsg_Tim_MAX Number(20,4) NOT NULL,
sndMsg_Tim_STCNT varchar2(32) NOT NULL,
rmsg_status_MIN Number(20,4) NOT NULL,
rmsg_status_MAX Number(20,4) NOT NULL,
rmsg_status_STCNT varchar2(32) NOT NULL,
rmsg_Tim_MIN Number(20,4) NOT NULL,
rmsg_Tim_MAX Number(20,4) NOT NULL,
rmsg_Tim_STCNT varchar2(32) NOT NULL,
getMsgR_status_MIN Number(20,4) NOT NULL,
getMsgR_status_MAX Number(20,4) NOT NULL,
getMsgR_status_STCNT varchar2(32) NOT NULL,
getMsgR_Tim_MIN Number(20,4) NOT NULL,
getMsgR_Tim_MAX Number(20,4) NOT NULL,
getMsgR_Tim_STCNT varchar2(32) NOT NULL,
lstMsgR_status_MIN Number(20,4) NOT NULL,
lstMsgR_status_MAX Number(20,4) NOT NULL,
lstMsgR_status_STCNT varchar2(32) NOT NULL,
lstMsgR_Tim_MIN Number(20,4) NOT NULL,
lstMsgR_Tim_MAX Number(20,4) NOT NULL,
lstMsgR_Tim_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMChannelOprtnTest_TREND ADD constraint PK_MTMChannelOprtnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMChannelOprtnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMChannelOprtnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
getChnl_status_MIN VARCHAR2(256) NOT NULL,
getChnl_status_MAX VARCHAR2(256) NOT NULL,
getChnl_Tim_MIN VARCHAR2(256) NOT NULL,
getChnl_Tim_MAX VARCHAR2(256) NOT NULL,
updatChnl_status_MIN VARCHAR2(256) NOT NULL,
updatChnl_status_MAX VARCHAR2(256) NOT NULL,
updatChnl_Tim_MIN VARCHAR2(256) NOT NULL,
updatChnl_Tim_MAX VARCHAR2(256) NOT NULL,
getMemC_status_MIN VARCHAR2(256) NOT NULL,
getMemC_status_MAX VARCHAR2(256) NOT NULL,
getMemC_Tim_MIN VARCHAR2(256) NOT NULL,
getMemC_Tim_MAX VARCHAR2(256) NOT NULL,
lstMemC_status_MIN VARCHAR2(256) NOT NULL,
lstMemC_status_MAX VARCHAR2(256) NOT NULL,
lstMemC_Tim_MIN VARCHAR2(256) NOT NULL,
lstMemC_Tim_MAX VARCHAR2(256) NOT NULL,
updatMemC_status_MIN VARCHAR2(256) NOT NULL,
updatMemC_status_MAX VARCHAR2(256) NOT NULL,
updatMemC_Tim_MIN VARCHAR2(256) NOT NULL,
updatMemC_Tim_MAX VARCHAR2(256) NOT NULL,
sndMsg_status_MIN VARCHAR2(256) NOT NULL,
sndMsg_status_MAX VARCHAR2(256) NOT NULL,
sndMsg_Tim_MIN VARCHAR2(256) NOT NULL,
sndMsg_Tim_MAX VARCHAR2(256) NOT NULL,
rmsg_status_MIN VARCHAR2(256) NOT NULL,
rmsg_status_MAX VARCHAR2(256) NOT NULL,
rmsg_Tim_MIN VARCHAR2(256) NOT NULL,
rmsg_Tim_MAX VARCHAR2(256) NOT NULL,
getMsgR_status_MIN VARCHAR2(256) NOT NULL,
getMsgR_status_MAX VARCHAR2(256) NOT NULL,
getMsgR_Tim_MIN VARCHAR2(256) NOT NULL,
getMsgR_Tim_MAX VARCHAR2(256) NOT NULL,
lstMsgR_status_MIN VARCHAR2(256) NOT NULL,
lstMsgR_status_MAX VARCHAR2(256) NOT NULL,
lstMsgR_Tim_MIN VARCHAR2(256) NOT NULL,
lstMsgR_Tim_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE MTMChannelOprtnTest_THRESH ADD constraint PK_MTMChannelOprtnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMChannelOprtnTest_THRESH ON MTMChannelOprtnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMChannelOprtnTest ON MTMChannelOprtnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMChannelOprtnTest ON MTMChannelOprtnTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE YMROperationsTest CASCADE CONSTRAINTS;
CREATE TABLE YMROperationsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Message_Post_status Number(20,4) NOT NULL,
Message_Post_status_ST varchar2(32) NOT NULL,
Message_Post_time Number(20,4) NOT NULL,
Message_Post_time_ST varchar2(32) NOT NULL,
Message_Like_status Number(20,4) NOT NULL,
Message_Like_status_ST varchar2(32) NOT NULL,
Message_Like_time Number(20,4) NOT NULL,
Message_Like_time_ST varchar2(32) NOT NULL,
Message_Delete_status Number(20,4) NOT NULL,
Message_Delete_status_ST varchar2(32) NOT NULL,
Message_Delete_time Number(20,4) NOT NULL,
Message_Delete_time_ST varchar2(32) NOT NULL,
File_Upload_status Number(20,4) NOT NULL,
File_Upload_status_ST varchar2(32) NOT NULL,
File_Upload_time Number(20,4) NOT NULL,
File_Upload_time_ST varchar2(32) NOT NULL,
File_Delete_status Number(20,4) NOT NULL,
File_Delete_status_ST varchar2(32) NOT NULL,
File_Delete_time Number(20,4) NOT NULL,
File_Delete_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_YMROperationsTest ON YMROperationsTest(MSMT_TIME);
ALTER TABLE YMROperationsTest ADD constraint PK_YMROperationsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE YMROperationsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE YMROperationsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Message_Post_status_MIN Number(20,4) NOT NULL,
Message_Post_status_MAX Number(20,4) NOT NULL,
Message_Post_status_STCNT varchar2(32) NOT NULL,
Message_Post_time_MIN Number(20,4) NOT NULL,
Message_Post_time_MAX Number(20,4) NOT NULL,
Message_Post_time_STCNT varchar2(32) NOT NULL,
Message_Like_status_MIN Number(20,4) NOT NULL,
Message_Like_status_MAX Number(20,4) NOT NULL,
Message_Like_status_STCNT varchar2(32) NOT NULL,
Message_Like_time_MIN Number(20,4) NOT NULL,
Message_Like_time_MAX Number(20,4) NOT NULL,
Message_Like_time_STCNT varchar2(32) NOT NULL,
Message_Delete_status_MIN Number(20,4) NOT NULL,
Message_Delete_status_MAX Number(20,4) NOT NULL,
Message_Delete_status_STCNT varchar2(32) NOT NULL,
Message_Delete_time_MIN Number(20,4) NOT NULL,
Message_Delete_time_MAX Number(20,4) NOT NULL,
Message_Delete_time_STCNT varchar2(32) NOT NULL,
File_Upload_status_MIN Number(20,4) NOT NULL,
File_Upload_status_MAX Number(20,4) NOT NULL,
File_Upload_status_STCNT varchar2(32) NOT NULL,
File_Upload_time_MIN Number(20,4) NOT NULL,
File_Upload_time_MAX Number(20,4) NOT NULL,
File_Upload_time_STCNT varchar2(32) NOT NULL,
File_Delete_status_MIN Number(20,4) NOT NULL,
File_Delete_status_MAX Number(20,4) NOT NULL,
File_Delete_status_STCNT varchar2(32) NOT NULL,
File_Delete_time_MIN Number(20,4) NOT NULL,
File_Delete_time_MAX Number(20,4) NOT NULL,
File_Delete_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE YMROperationsTest_TREND ADD constraint PK_YMROperationsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE YMROperationsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE YMROperationsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Message_Post_status_MIN VARCHAR2(256) NOT NULL,
Message_Post_status_MAX VARCHAR2(256) NOT NULL,
Message_Post_time_MIN VARCHAR2(256) NOT NULL,
Message_Post_time_MAX VARCHAR2(256) NOT NULL,
Message_Like_status_MIN VARCHAR2(256) NOT NULL,
Message_Like_status_MAX VARCHAR2(256) NOT NULL,
Message_Like_time_MIN VARCHAR2(256) NOT NULL,
Message_Like_time_MAX VARCHAR2(256) NOT NULL,
Message_Delete_status_MIN VARCHAR2(256) NOT NULL,
Message_Delete_status_MAX VARCHAR2(256) NOT NULL,
Message_Delete_time_MIN VARCHAR2(256) NOT NULL,
Message_Delete_time_MAX VARCHAR2(256) NOT NULL,
File_Upload_status_MIN VARCHAR2(256) NOT NULL,
File_Upload_status_MAX VARCHAR2(256) NOT NULL,
File_Upload_time_MIN VARCHAR2(256) NOT NULL,
File_Upload_time_MAX VARCHAR2(256) NOT NULL,
File_Delete_status_MIN VARCHAR2(256) NOT NULL,
File_Delete_status_MAX VARCHAR2(256) NOT NULL,
File_Delete_time_MIN VARCHAR2(256) NOT NULL,
File_Delete_time_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE YMROperationsTest_THRESH ADD constraint PK_YMROperationsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_YMROperationsTest_THRESH ON YMROperationsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_YMROperationsTest ON YMROperationsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_YMROperationsTest ON YMROperationsTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SMTPMailSenderTest CASCADE CONSTRAINTS;
CREATE TABLE SMTPMailSenderTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
AUTH_STATUS		Number(20,4) NOT NULL,
AUTH_STATUS_ST		varchar2(32) NOT NULL,
AUTH_TIME		Number(20,4) NOT NULL,
AUTH_TIME_ST		varchar2(32) NOT NULL,
SEND_AVAIL		Number(20,4) NOT NULL,
SEND_AVAIL_ST		varchar2(32) NOT NULL,
SENT_MSGS		Number(20,4) NOT NULL,
SENT_MSGS_ST		varchar2(32) NOT NULL,
FAILED_MSGS		Number(20,4) NOT NULL,
FAILED_MSGS_ST		varchar2(32) NOT NULL,
SENT_TIME		Number(20,4) NOT NULL,
SENT_TIME_ST		varchar2(32) NOT NULL,
TOTAL_SIM_TIME		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_ST	varchar2(32) NOT NULL);
CREATE INDEX IDX_SMTPMailSenderTest ON SMTPMailSenderTest(MSMT_TIME);
ALTER TABLE SMTPMailSenderTest ADD constraint PK_SMTPMailSenderTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SMTPMailSenderTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SMTPMailSenderTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
AUTH_STATUS_MIN		Number(20,4) NOT NULL,
AUTH_STATUS_MAX		Number(20,4) NOT NULL,
AUTH_STATUS_STCNT	varchar2(32) NOT NULL,
AUTH_TIME_MIN		Number(20,4) NOT NULL,
AUTH_TIME_MAX		Number(20,4) NOT NULL,
AUTH_TIME_STCNT	varchar2(32) NOT NULL,
SEND_AVAIL_MIN		Number(20,4) NOT NULL,
SEND_AVAIL_MAX		Number(20,4) NOT NULL,
SEND_AVAIL_STCNT	varchar2(32) NOT NULL,
SENT_MSGS_MIN		Number(20,4) NOT NULL,
SENT_MSGS_MAX		Number(20,4) NOT NULL,
SENT_MSGS_STCNT	varchar2(32) NOT NULL,
FAILED_MSGS_MIN		Number(20,4) NOT NULL,
FAILED_MSGS_MAX		Number(20,4) NOT NULL,
FAILED_MSGS_STCNT	varchar2(32) NOT NULL,
SENT_TIME_MIN		Number(20,4) NOT NULL,
SENT_TIME_MAX		Number(20,4) NOT NULL,
SENT_TIME_STCNT	varchar2(32) NOT NULL,
TOTAL_SIM_TIME_MIN		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_MAX		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_STCNT	varchar2(32) NOT NULL);
ALTER TABLE SMTPMailSenderTest_TREND ADD constraint PK_SMTPMailSenderTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
CREATE INDEX IDX_TR_SMTPMailSenderTest ON SMTPMailSenderTest_TREND (MSMT_TIME,PERIOD);
DROP TABLE SMTPMailSenderTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SMTPMailSenderTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
AUTH_STATUS_MIN		VARCHAR2(256) NOT NULL,
AUTH_STATUS_MAX		VARCHAR2(256) NOT NULL,
AUTH_TIME_MIN		VARCHAR2(256) NOT NULL,
AUTH_TIME_MAX		VARCHAR2(256) NOT NULL,
SEND_AVAIL_MIN		VARCHAR2(256) NOT NULL,
SEND_AVAIL_MAX		VARCHAR2(256) NOT NULL,
SENT_MSGS_MIN		VARCHAR2(256) NOT NULL,
SENT_MSGS_MAX		VARCHAR2(256) NOT NULL,
FAILED_MSGS_MIN		VARCHAR2(256) NOT NULL,
FAILED_MSGS_MAX		VARCHAR2(256) NOT NULL,
SENT_TIME_MIN		VARCHAR2(256) NOT NULL,
SENT_TIME_MAX		VARCHAR2(256) NOT NULL,
TOTAL_SIM_TIME_MIN		VARCHAR2(256) NOT NULL,
TOTAL_SIM_TIME_MAX		VARCHAR2(256) NOT NULL);
ALTER TABLE SMTPMailSenderTest_THRESH ADD constraint PK_SMTPMailSenderTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SMTPMailSenderTest_THRESH ON SMTPMailSenderTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SMTPMailSenderTest ON SMTPMailSenderTest_THRESH (MSMT_TIME_START);

DROP TABLE MailRecverTest CASCADE CONSTRAINTS;
CREATE TABLE MailRecverTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
AUTH_STATUS		Number(20,4) NOT NULL,
AUTH_STATUS_ST		varchar2(32) NOT NULL,
AUTH_TIME		Number(20,4) NOT NULL,
AUTH_TIME_ST		varchar2(32) NOT NULL,
RCVD_AVAIL		Number(20,4) NOT NULL,
RCVD_AVAIL_ST		varchar2(32) NOT NULL,
RCVD_MSGS		Number(20,4) NOT NULL,
RCVD_MSGS_ST		varchar2(32) NOT NULL,
RCVD_TIME		Number(20,4) NOT NULL,
RCVD_TIME_ST		varchar2(32) NOT NULL,
AVG_ROUNDTRIP_TIME		Number(20,4) NOT NULL,
AVG_ROUNDTRIP_TIME_ST		varchar2(32) NOT NULL,
MAX_ROUNDTRIP_TIME		Number(20,4) NOT NULL,
MAX_ROUNDTRIP_TIME_ST		varchar2(32) NOT NULL,
LAST_MAIL_TIME		Number(20,4) NOT NULL,
LAST_MAIL_TIME_ST		varchar2(32) NOT NULL,
TOTAL_SIM_TIME		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_ST		varchar2(32) NOT NULL,
MISSING_ORDER		Number(20,4) NOT NULL,
MISSING_ORDER_ST		varchar2(32) NOT NULL);
CREATE INDEX IDX_MailRecverTest ON MailRecverTest(MSMT_TIME);
ALTER TABLE MailRecverTest ADD constraint PK_MailRecverTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MailRecverTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MailRecverTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
AUTH_STATUS_MIN		Number(20,4) NOT NULL,
AUTH_STATUS_MAX		Number(20,4) NOT NULL,
AUTH_STATUS_STCNT	varchar2(32) NOT NULL,
AUTH_TIME_MIN		Number(20,4) NOT NULL,
AUTH_TIME_MAX		Number(20,4) NOT NULL,
AUTH_TIME_STCNT	varchar2(32) NOT NULL,
RCVD_AVAIL_MIN		Number(20,4) NOT NULL,
RCVD_AVAIL_MAX		Number(20,4) NOT NULL,
RCVD_AVAIL_STCNT	varchar2(32) NOT NULL,
RCVD_MSGS_MIN		Number(20,4) NOT NULL,
RCVD_MSGS_MAX		Number(20,4) NOT NULL,
RCVD_MSGS_STCNT	    varchar2(32) NOT NULL,
RCVD_TIME_MIN		Number(20,4) NOT NULL,
RCVD_TIME_MAX		Number(20,4) NOT NULL,
RCVD_TIME_STCNT	    varchar2(32) NOT NULL,
AVG_ROUNDTRIP_TIME_MIN		Number(20,4) NOT NULL,
AVG_ROUNDTRIP_TIME_MAX		Number(20,4) NOT NULL,
AVG_ROUNDTRIP_TIME_STCNT	varchar2(32) NOT NULL,
MAX_ROUNDTRIP_TIME_MIN		Number(20,4) NOT NULL,
MAX_ROUNDTRIP_TIME_MAX		Number(20,4) NOT NULL,
MAX_ROUNDTRIP_TIME_STCNT	varchar2(32) NOT NULL,
LAST_MAIL_TIME_MIN		Number(20,4) NOT NULL,
LAST_MAIL_TIME_MAX		Number(20,4) NOT NULL,
LAST_MAIL_TIME_STCNT	varchar2(32) NOT NULL,
TOTAL_SIM_TIME_MIN		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_MAX		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_STCNT	varchar2(32) NOT NULL,
MISSING_ORDER_MIN		Number(20,4) NOT NULL,
MISSING_ORDER_MAX		Number(20,4) NOT NULL,
MISSING_ORDER_STCNT		varchar2(32) NOT NULL);
ALTER TABLE MailRecverTest_TREND ADD constraint PK_MailRecverTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE MailRecverTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MailRecverTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
AUTH_STATUS_MIN		VARCHAR2(256) NOT NULL,
AUTH_STATUS_MAX		VARCHAR2(256) NOT NULL,
AUTH_TIME_MIN		VARCHAR2(256) NOT NULL,
AUTH_TIME_MAX		VARCHAR2(256) NOT NULL,
RCVD_AVAIL_MIN		VARCHAR2(256) NOT NULL,
RCVD_AVAIL_MAX		VARCHAR2(256) NOT NULL,
RCVD_MSGS_MIN		VARCHAR2(256) NOT NULL,
RCVD_MSGS_MAX		VARCHAR2(256) NOT NULL,
RCVD_TIME_MIN		VARCHAR2(256) NOT NULL,
RCVD_TIME_MAX		VARCHAR2(256) NOT NULL,
AVG_ROUNDTRIP_TIME_MIN		VARCHAR2(256) NOT NULL,
AVG_ROUNDTRIP_TIME_MAX		VARCHAR2(256) NOT NULL,
MAX_ROUNDTRIP_TIME_MIN		VARCHAR2(256) NOT NULL,
MAX_ROUNDTRIP_TIME_MAX		VARCHAR2(256) NOT NULL,
LAST_MAIL_TIME_MIN		VARCHAR2(256) NOT NULL,
LAST_MAIL_TIME_MAX		VARCHAR2(256) NOT NULL,
TOTAL_SIM_TIME_MIN		VARCHAR2(256) NOT NULL,
TOTAL_SIM_TIME_MAX		VARCHAR2(256) NOT NULL,
MISSING_ORDER_MIN		VARCHAR2(256) NOT NULL,
MISSING_ORDER_MAX		VARCHAR2(256) NOT NULL);
ALTER TABLE MailRecverTest_THRESH ADD constraint PK_MailRecverTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MailRecverTest_THRESH ON MailRecverTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MailRecverTest ON MailRecverTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MailRecverTest ON MailRecverTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE O365GraphTest CASCADE CONSTRAINTS;
CREATE TABLE O365GraphTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
testCount		Number(20,4) NOT NULL,
testCount_ST		varchar2(32) NOT NULL);
CREATE INDEX IDX_O365GraphTest ON O365GraphTest(MSMT_TIME);
ALTER TABLE O365GraphTest ADD constraint PK_O365GraphTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365GraphTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365GraphTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
testCount_MIN		Number(20,4) NOT NULL,
testCount_MAX		Number(20,4) NOT NULL,
testCount_STCNT	varchar2(32) NOT NULL);
ALTER TABLE O365GraphTest_TREND ADD constraint PK_O365GraphTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365GraphTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365GraphTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
testCount_MIN		VARCHAR2(256) NOT NULL,
testCount_MAX		VARCHAR2(256) NOT NULL);
ALTER TABLE O365GraphTest_THRESH ADD constraint PK_O365GraphTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365GraphTest_THRESH ON O365GraphTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365GraphTest ON O365GraphTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365GraphTest ON O365GraphTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE O365UsersDetails CASCADE CONSTRAINTS;
CREATE TABLE O365UsersDetails(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
totalUsers		Number(20,4) NOT NULL,
totalUsers_ST		varchar2(32) NOT NULL
);
CREATE INDEX IDX_O365UsersDetails ON O365UsersDetails(MSMT_TIME);
ALTER TABLE O365UsersDetails ADD constraint PK_O365UsersDetails PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UsersDetails_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365UsersDetails_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
totalUsers_MIN		Number(20,4) NOT NULL,
totalUsers_MAX		Number(20,4) NOT NULL,
totalUsers_STCNT	varchar2(32) NOT NULL
);
ALTER TABLE O365UsersDetails_TREND ADD constraint PK_O365UsersDetails_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UsersDetails_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365UsersDetails_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
totalUsers_MIN		VARCHAR2(256) NOT NULL,
totalUsers_MAX		VARCHAR2(256) NOT NULL
);
ALTER TABLE O365UsersDetails_THRESH ADD constraint PK_O365UsersDetails_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UsersDetails_THRESH ON O365UsersDetails_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UsersDetails ON O365UsersDetails_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UsersDetails ON O365UsersDetails_TREND (MSMT_TIME,PERIOD);


DROP TABLE EXOUsersMailsnMailboxes CASCADE CONSTRAINTS;
CREATE TABLE EXOUsersMailsnMailboxes(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ItemCount Number(20,4) NOT NULL,
ItemCount_ST varchar2(32) NOT NULL,
StrgUsed Number(20,4) NOT NULL,
StrgUsed_ST varchar2(32) NOT NULL,
WarngQuota Number(20,4) NOT NULL,
WarngQuota_ST varchar2(32) NOT NULL,
SndQuota Number(20,4) NOT NULL,
SndQuota_ST varchar2(32) NOT NULL,
SndRcvQuota Number(20,4) NOT NULL,
SndRcvQuota_ST varchar2(32) NOT NULL,
RchWarngQuota Number(20,4) NOT NULL,
RchWarngQuota_ST varchar2(32) NOT NULL,
RchSndQuota Number(20,4) NOT NULL,
RchSndQuota_ST varchar2(32) NOT NULL,
RchSndRcvQuota Number(20,4) NOT NULL,
RchSndRcvQuota_ST varchar2(32) NOT NULL,
DeltdItemCount Number(20,4) NOT NULL,
DeltdItemCount_ST varchar2(32) NOT NULL,
DeltdItemSize Number(20,4) NOT NULL,
DeltdItemSize_ST varchar2(32) NOT NULL,
sendCount Number(20,4) NOT NULL,
sendCount_ST varchar2(32) NOT NULL,
rcvCount Number(20,4) NOT NULL,
rcvCount_ST varchar2(32) NOT NULL,
readCount Number(20,4) NOT NULL,
readCount_ST varchar2(32) NOT NULL,
MailForMac Number(20,4) NOT NULL,
MailForMac_ST varchar2(32) NOT NULL,
OutlookForMac Number(20,4) NOT NULL,
OutlookForMac_ST varchar2(32) NOT NULL,
OutlookForWindows Number(20,4) NOT NULL,
OutlookForWindows_ST varchar2(32) NOT NULL,
OutlookForMobile Number(20,4) NOT NULL,
OutlookForMobile_ST varchar2(32) NOT NULL,
OtherForMobile Number(20,4) NOT NULL,
OtherForMobile_ST varchar2(32) NOT NULL,
OutlookForWeb Number(20,4) NOT NULL,
OutlookForWeb_ST varchar2(32) NOT NULL,
POP3App Number(20,4) NOT NULL,
POP3App_ST varchar2(32) NOT NULL,
IMAP4App Number(20,4) NOT NULL,
IMAP4App_ST varchar2(32) NOT NULL,
SMTPApp Number(20,4) NOT NULL,
SMTPApp_ST varchar2(32) NOT NULL,
RchRecovrableQuota Number(20,4) NOT NULL,
RchRecovrableQuota_ST varchar2(32) NOT NULL,
hasLicenses Number(20,4) NOT NULL,
hasLicenses_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOUsersMailsnMailboxes ON EXOUsersMailsnMailboxes(MSMT_TIME);
ALTER TABLE EXOUsersMailsnMailboxes ADD constraint PK_EXOUsersMailsnMailboxes PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUsersMailsnMailboxes_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOUsersMailsnMailboxes_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD                varchar2(32),
ItemCount_MIN Number(20,4) NOT NULL,
ItemCount_MAX Number(20,4) NOT NULL,
ItemCount_STCNT varchar2(32) NOT NULL,
StrgUsed_MIN Number(20,4) NOT NULL,
StrgUsed_MAX Number(20,4) NOT NULL,
StrgUsed_STCNT varchar2(32) NOT NULL,
WarngQuota_MIN Number(20,4) NOT NULL,
WarngQuota_MAX Number(20,4) NOT NULL,
WarngQuota_STCNT varchar2(32) NOT NULL,
SndQuota_MIN Number(20,4) NOT NULL,
SndQuota_MAX Number(20,4) NOT NULL,
SndQuota_STCNT varchar2(32) NOT NULL,
SndRcvQuota_MIN Number(20,4) NOT NULL,
SndRcvQuota_MAX Number(20,4) NOT NULL,
SndRcvQuota_STCNT varchar2(32) NOT NULL,
RchWarngQuota_MIN Number(20,4) NOT NULL,
RchWarngQuota_MAX Number(20,4) NOT NULL,
RchWarngQuota_STCNT varchar2(32) NOT NULL,
RchSndQuota_MIN Number(20,4) NOT NULL,
RchSndQuota_MAX Number(20,4) NOT NULL,
RchSndQuota_STCNT varchar2(32) NOT NULL,
RchSndRcvQuota_MIN Number(20,4) NOT NULL,
RchSndRcvQuota_MAX Number(20,4) NOT NULL,
RchSndRcvQuota_STCNT varchar2(32) NOT NULL,
DeltdItemCount_MIN Number(20,4) NOT NULL,
DeltdItemCount_MAX Number(20,4) NOT NULL,
DeltdItemCount_STCNT varchar2(32) NOT NULL,
DeltdItemSize_MIN Number(20,4) NOT NULL,
DeltdItemSize_MAX Number(20,4) NOT NULL,
DeltdItemSize_STCNT varchar2(32) NOT NULL,
sendCount_MIN Number(20,4) NOT NULL,
sendCount_MAX Number(20,4) NOT NULL,
sendCount_STCNT varchar2(32) NOT NULL,
rcvCount_MIN Number(20,4) NOT NULL,
rcvCount_MAX Number(20,4) NOT NULL,
rcvCount_STCNT varchar2(32) NOT NULL,
readCount_MIN Number(20,4) NOT NULL,
readCount_MAX Number(20,4) NOT NULL,
readCount_STCNT varchar2(32) NOT NULL,
MailForMac_MIN Number(20,4) NOT NULL,
MailForMac_MAX Number(20,4) NOT NULL,
MailForMac_STCNT varchar2(32) NOT NULL,
OutlookForMac_MIN Number(20,4) NOT NULL,
OutlookForMac_MAX Number(20,4) NOT NULL,
OutlookForMac_STCNT varchar2(32) NOT NULL,
OutlookForWindows_MIN Number(20,4) NOT NULL,
OutlookForWindows_MAX Number(20,4) NOT NULL,
OutlookForWindows_STCNT varchar2(32) NOT NULL,
OutlookForMobile_MIN Number(20,4) NOT NULL,
OutlookForMobile_MAX Number(20,4) NOT NULL,
OutlookForMobile_STCNT varchar2(32) NOT NULL,
OtherForMobile_MIN Number(20,4) NOT NULL,
OtherForMobile_MAX Number(20,4) NOT NULL,
OtherForMobile_STCNT varchar2(32) NOT NULL,
OutlookForWeb_MIN Number(20,4) NOT NULL,
OutlookForWeb_MAX Number(20,4) NOT NULL,
OutlookForWeb_STCNT varchar2(32) NOT NULL,
POP3App_MIN Number(20,4) NOT NULL,
POP3App_MAX Number(20,4) NOT NULL,
POP3App_STCNT varchar2(32) NOT NULL,
IMAP4App_MIN Number(20,4) NOT NULL,
IMAP4App_MAX Number(20,4) NOT NULL,
IMAP4App_STCNT varchar2(32) NOT NULL,
SMTPApp_MIN Number(20,4) NOT NULL,
SMTPApp_MAX Number(20,4) NOT NULL,
SMTPApp_STCNT varchar2(32) NOT NULL,
RchRecovrableQuota_MIN Number(20,4) NOT NULL,
RchRecovrableQuota_MAX Number(20,4) NOT NULL,
RchRecovrableQuota_STCNT varchar2(32) NOT NULL,
hasLicenses_MIN Number(20,4) NOT NULL,
hasLicenses_MAX Number(20,4) NOT NULL,
hasLicenses_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOUsersMailsnMailboxes_TREND ADD constraint PK_EXOUsrsMailnMailbx_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUsersMailsnMailboxes_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOUsersMailsnMailboxes_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ItemCount_MIN VARCHAR2(256) NOT NULL,
ItemCount_MAX VARCHAR2(256) NOT NULL,
StrgUsed_MIN VARCHAR2(256) NOT NULL,
StrgUsed_MAX VARCHAR2(256) NOT NULL,
WarngQuota_MIN VARCHAR2(256) NOT NULL,
WarngQuota_MAX VARCHAR2(256) NOT NULL,
SndQuota_MIN VARCHAR2(256) NOT NULL,
SndQuota_MAX VARCHAR2(256) NOT NULL,
SndRcvQuota_MIN VARCHAR2(256) NOT NULL,
SndRcvQuota_MAX VARCHAR2(256) NOT NULL,
RchWarngQuota_MIN VARCHAR2(256) NOT NULL,
RchWarngQuota_MAX VARCHAR2(256) NOT NULL,
RchSndQuota_MIN VARCHAR2(256) NOT NULL,
RchSndQuota_MAX VARCHAR2(256) NOT NULL,
RchSndRcvQuota_MIN VARCHAR2(256) NOT NULL,
RchSndRcvQuota_MAX VARCHAR2(256) NOT NULL,
DeltdItemCount_MIN VARCHAR2(256) NOT NULL,
DeltdItemCount_MAX VARCHAR2(256) NOT NULL,
DeltdItemSize_MIN VARCHAR2(256) NOT NULL,
DeltdItemSize_MAX VARCHAR2(256) NOT NULL,
sendCount_MIN VARCHAR2(256) NOT NULL,
sendCount_MAX VARCHAR2(256) NOT NULL,
rcvCount_MIN VARCHAR2(256) NOT NULL,
rcvCount_MAX VARCHAR2(256) NOT NULL,
readCount_MIN VARCHAR2(256) NOT NULL,
readCount_MAX VARCHAR2(256) NOT NULL,
MailForMac_MIN VARCHAR2(256) NOT NULL,
MailForMac_MAX VARCHAR2(256) NOT NULL,
OutlookForMac_MIN VARCHAR2(256) NOT NULL,
OutlookForMac_MAX VARCHAR2(256) NOT NULL,
OutlookForWindows_MIN VARCHAR2(256) NOT NULL,
OutlookForWindows_MAX VARCHAR2(256) NOT NULL,
OutlookForMobile_MIN VARCHAR2(256) NOT NULL,
OutlookForMobile_MAX VARCHAR2(256) NOT NULL,
OtherForMobile_MIN VARCHAR2(256) NOT NULL,
OtherForMobile_MAX VARCHAR2(256) NOT NULL,
OutlookForWeb_MIN VARCHAR2(256) NOT NULL,
OutlookForWeb_MAX VARCHAR2(256) NOT NULL,
POP3App_MIN VARCHAR2(256) NOT NULL,
POP3App_MAX VARCHAR2(256) NOT NULL,
IMAP4App_MIN VARCHAR2(256) NOT NULL,
IMAP4App_MAX VARCHAR2(256) NOT NULL,
SMTPApp_MIN VARCHAR2(256) NOT NULL,
SMTPApp_MAX VARCHAR2(256) NOT NULL,
RchRecovrableQuota_MIN VARCHAR2(256) NOT NULL,
RchRecovrableQuota_MAX VARCHAR2(256) NOT NULL,
hasLicenses_MIN VARCHAR2(256) NOT NULL,
hasLicenses_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE EXOUsersMailsnMailboxes_THRESH ADD constraint PK_EXOUsrsMailnMailbx_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUsrsMailnMailbx_THRESH ON EXOUsersMailsnMailboxes_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUsrsMailnMailbx ON EXOUsersMailsnMailboxes_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUsrsMailnMailbx ON EXOUsersMailsnMailboxes_TREND (MSMT_TIME,PERIOD);

DROP TABLE ODBUsersDetails CASCADE CONSTRAINTS;
CREATE TABLE ODBUsersDetails(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
fileCount		Number(20,4) NOT NULL,
fileCount_ST		varchar2(32) NOT NULL,
actvFileCount		Number(20,4) NOT NULL,
actvFileCount_ST		varchar2(32) NOT NULL,
storageUsed		Number(20,4) NOT NULL,
storageUsed_ST		varchar2(32) NOT NULL,
storageAllocated		Number(20,4) NOT NULL,
storageAllocated_ST		varchar2(32) NOT NULL,
storageUsedPcnt		Number(20,4) NOT NULL,
storageUsedPcnt_ST		varchar2(32) NOT NULL,
viewedEditedFileCnt		Number(20,4) NOT NULL,
viewedEditedFileCnt_ST		varchar2(32) NOT NULL,
syncedFileCnt		Number(20,4) NOT NULL,
syncedFileCnt_ST		varchar2(32) NOT NULL,
sharedInFileCnt		Number(20,4) NOT NULL,
sharedInFileCnt_ST		varchar2(32) NOT NULL,
sharedExFileCnt		Number(20,4) NOT NULL,
sharedExFileCnt_ST		varchar2(32) NOT NULL,
hasLicenses Number(20,4) NOT NULL,
hasLicenses_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_ODBUsersDetails ON ODBUsersDetails(MSMT_TIME);
ALTER TABLE ODBUsersDetails ADD constraint PK_ODBUsersDetails PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBUsersDetails_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBUsersDetails_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
fileCount_MIN		Number(20,4) NOT NULL,
fileCount_MAX		Number(20,4) NOT NULL,
fileCount_STCNT	varchar2(32) NOT NULL,
actvFileCount_MIN		Number(20,4) NOT NULL,
actvFileCount_MAX		Number(20,4) NOT NULL,
actvFileCount_STCNT	varchar2(32) NOT NULL,
storageUsed_MIN		Number(20,4) NOT NULL,
storageUsed_MAX		Number(20,4) NOT NULL,
storageUsed_STCNT	varchar2(32) NOT NULL,
storageAllocated_MIN		Number(20,4) NOT NULL,
storageAllocated_MAX		Number(20,4) NOT NULL,
storageAllocated_STCNT	varchar2(32) NOT NULL,
storageUsedPcnt_MIN		Number(20,4) NOT NULL,
storageUsedPcnt_MAX		Number(20,4) NOT NULL,
storageUsedPcnt_STCNT	varchar2(32) NOT NULL,
viewedEditedFileCnt_MIN		Number(20,4) NOT NULL,
viewedEditedFileCnt_MAX		Number(20,4) NOT NULL,
viewedEditedFileCnt_STCNT	varchar2(32) NOT NULL,
syncedFileCnt_MIN		Number(20,4) NOT NULL,
syncedFileCnt_MAX		Number(20,4) NOT NULL,
syncedFileCnt_STCNT	varchar2(32) NOT NULL,
sharedInFileCnt_MIN		Number(20,4) NOT NULL,
sharedInFileCnt_MAX		Number(20,4) NOT NULL,
sharedInFileCnt_STCNT	varchar2(32) NOT NULL,
sharedExFileCnt_MIN		Number(20,4) NOT NULL,
sharedExFileCnt_MAX		Number(20,4) NOT NULL,
sharedExFileCnt_STCNT	varchar2(32) NOT NULL,
hasLicenses_MIN Number(20,4) NOT NULL,
hasLicenses_MAX Number(20,4) NOT NULL,
hasLicenses_STCNT varchar2(32) NOT NULL
);
ALTER TABLE ODBUsersDetails_TREND ADD constraint PK_ODBUsersDetails_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBUsersDetails_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBUsersDetails_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
fileCount_MIN		VARCHAR2(256) NOT NULL,
fileCount_MAX		VARCHAR2(256) NOT NULL,
actvFileCount_MIN		VARCHAR2(256) NOT NULL,
actvFileCount_MAX		VARCHAR2(256) NOT NULL,
storageUsed_MIN		VARCHAR2(256) NOT NULL,
storageUsed_MAX		VARCHAR2(256) NOT NULL,
storageAllocated_MIN		VARCHAR2(256) NOT NULL,
storageAllocated_MAX		VARCHAR2(256) NOT NULL,
storageUsedPcnt_MIN		VARCHAR2(256) NOT NULL,
storageUsedPcnt_MAX		VARCHAR2(256) NOT NULL,
viewedEditedFileCnt_MIN		VARCHAR2(256) NOT NULL,
viewedEditedFileCnt_MAX		VARCHAR2(256) NOT NULL,
syncedFileCnt_MIN		VARCHAR2(256) NOT NULL,
syncedFileCnt_MAX		VARCHAR2(256) NOT NULL,
sharedInFileCnt_MIN		VARCHAR2(256) NOT NULL,
sharedInFileCnt_MAX		VARCHAR2(256) NOT NULL,
sharedExFileCnt_MIN		VARCHAR2(256) NOT NULL,
sharedExFileCnt_MAX		VARCHAR2(256) NOT NULL,
hasLicenses_MIN VARCHAR2(256) NOT NULL,
hasLicenses_MAX VARCHAR2(256) NOT NULL
);
ALTER TABLE ODBUsersDetails_THRESH ADD constraint PK_ODBUsersDetails_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBUsersDetails_THRESH ON ODBUsersDetails_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBUsersDetails ON ODBUsersDetails_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBUsersDetails ON ODBUsersDetails_TREND (MSMT_TIME,PERIOD);


DROP TABLE MTMUsersDetails CASCADE CONSTRAINTS;
CREATE TABLE MTMUsersDetails(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
teamChatMsgs		Number(20,4) NOT NULL,
teamChatMsgs_ST		varchar2(32) NOT NULL,
pvtChatMsgs		Number(20,4) NOT NULL,
pvtChatMsgs_ST		varchar2(32) NOT NULL,
calls		Number(20,4) NOT NULL,
calls_ST		varchar2(32) NOT NULL,
meetings		Number(20,4) NOT NULL,
meetings_ST		varchar2(32) NOT NULL,
otherActions		Number(20,4) NOT NULL,
otherActions_ST		varchar2(32) NOT NULL,
web		Number(20,4) NOT NULL,
web_ST		varchar2(32) NOT NULL,
winPh		Number(20,4) NOT NULL,
winPh_ST		varchar2(32) NOT NULL,
ios		Number(20,4) NOT NULL,
ios_ST		varchar2(32) NOT NULL,
mac		Number(20,4) NOT NULL,
mac_ST		varchar2(32) NOT NULL,
androidPh		Number(20,4) NOT NULL,
androidPh_ST		varchar2(32) NOT NULL,
win		Number(20,4) NOT NULL,
win_ST		varchar2(32) NOT NULL,
hasLicenses Number(20,4) NOT NULL,
hasLicenses_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_MTMUsersDetails ON MTMUsersDetails(MSMT_TIME);
ALTER TABLE MTMUsersDetails ADD constraint PK_MTMUsersDetails PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMUsersDetails_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMUsersDetails_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
teamChatMsgs_MIN		Number(20,4) NOT NULL,
teamChatMsgs_MAX		Number(20,4) NOT NULL,
teamChatMsgs_STCNT	varchar2(32) NOT NULL,
pvtChatMsgs_MIN		Number(20,4) NOT NULL,
pvtChatMsgs_MAX		Number(20,4) NOT NULL,
pvtChatMsgs_STCNT	varchar2(32) NOT NULL,
calls_MIN		Number(20,4) NOT NULL,
calls_MAX		Number(20,4) NOT NULL,
calls_STCNT	varchar2(32) NOT NULL,
meetings_MIN		Number(20,4) NOT NULL,
meetings_MAX		Number(20,4) NOT NULL,
meetings_STCNT	varchar2(32) NOT NULL,
otherActions_MIN		Number(20,4) NOT NULL,
otherActions_MAX		Number(20,4) NOT NULL,
otherActions_STCNT	varchar2(32) NOT NULL,
web_MIN		Number(20,4) NOT NULL,
web_MAX		Number(20,4) NOT NULL,
web_STCNT	varchar2(32) NOT NULL,
winPh_MIN		Number(20,4) NOT NULL,
winPh_MAX		Number(20,4) NOT NULL,
winPh_STCNT	varchar2(32) NOT NULL,
ios_MIN		Number(20,4) NOT NULL,
ios_MAX		Number(20,4) NOT NULL,
ios_STCNT	varchar2(32) NOT NULL,
mac_MIN		Number(20,4) NOT NULL,
mac_MAX		Number(20,4) NOT NULL,
mac_STCNT	varchar2(32) NOT NULL,
androidPh_MIN		Number(20,4) NOT NULL,
androidPh_MAX		Number(20,4) NOT NULL,
androidPh_STCNT	varchar2(32) NOT NULL,
win_MIN		Number(20,4) NOT NULL,
win_MAX		Number(20,4) NOT NULL,
win_STCNT	varchar2(32) NOT NULL,
hasLicenses_MIN Number(20,4) NOT NULL,
hasLicenses_MAX Number(20,4) NOT NULL,
hasLicenses_STCNT varchar2(32) NOT NULL
);
ALTER TABLE MTMUsersDetails_TREND ADD constraint PK_MTMUsersDetails_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMUsersDetails_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMUsersDetails_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
teamChatMsgs_MIN		VARCHAR2(256) NOT NULL,
teamChatMsgs_MAX		VARCHAR2(256) NOT NULL,
pvtChatMsgs_MIN		VARCHAR2(256) NOT NULL,
pvtChatMsgs_MAX		VARCHAR2(256) NOT NULL,
calls_MIN		VARCHAR2(256) NOT NULL,
calls_MAX		VARCHAR2(256) NOT NULL,
meetings_MIN		VARCHAR2(256) NOT NULL,
meetings_MAX		VARCHAR2(256) NOT NULL,
otherActions_MIN		VARCHAR2(256) NOT NULL,
otherActions_MAX		VARCHAR2(256) NOT NULL,
web_MIN		VARCHAR2(256) NOT NULL,
web_MAX		VARCHAR2(256) NOT NULL,
winPh_MIN		VARCHAR2(256) NOT NULL,
winPh_MAX		VARCHAR2(256) NOT NULL,
ios_MIN		VARCHAR2(256) NOT NULL,
ios_MAX		VARCHAR2(256) NOT NULL,
mac_MIN		VARCHAR2(256) NOT NULL,
mac_MAX		VARCHAR2(256) NOT NULL,
androidPh_MIN		VARCHAR2(256) NOT NULL,
androidPh_MAX		VARCHAR2(256) NOT NULL,
win_MIN		VARCHAR2(256) NOT NULL,
win_MAX		VARCHAR2(256) NOT NULL,
hasLicenses_MIN VARCHAR2(256) NOT NULL,
hasLicenses_MAX VARCHAR2(256) NOT NULL
);
ALTER TABLE MTMUsersDetails_THRESH ADD constraint PK_MTMUsersDetails_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMUsersDetails_THRESH ON MTMUsersDetails_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMUsersDetails ON MTMUsersDetails_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMUsersDetails ON MTMUsersDetails_TREND (MSMT_TIME,PERIOD);



DROP TABLE YMRUsersActivity CASCADE CONSTRAINTS;
CREATE TABLE YMRUsersActivity(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
postedcount Number(20,4) NOT NULL,
postedcount_ST varchar2(32) NOT NULL,
readcount Number(20,4) NOT NULL,
readcount_ST varchar2(32) NOT NULL,
likedcount Number(20,4) NOT NULL,
likedcount_ST varchar2(32) NOT NULL,
hasLicenses Number(20,4) NOT NULL,
hasLicenses_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_YMRUsersActivity ON YMRUsersActivity(MSMT_TIME);
ALTER TABLE YMRUsersActivity ADD constraint PK_YMRUsersActivity PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE YMRUsersActivity_TREND CASCADE CONSTRAINTS;
CREATE TABLE YMRUsersActivity_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
postedcount_MIN Number(20,4) NOT NULL,
postedcount_MAX Number(20,4) NOT NULL,
postedcount_STCNT varchar2(32) NOT NULL,
readcount_MIN Number(20,4) NOT NULL,
readcount_MAX Number(20,4) NOT NULL,
readcount_STCNT varchar2(32) NOT NULL,
likedcount_MIN Number(20,4) NOT NULL,
likedcount_MAX Number(20,4) NOT NULL,
likedcount_STCNT varchar2(32) NOT NULL,
hasLicenses_MIN Number(20,4) NOT NULL,
hasLicenses_MAX Number(20,4) NOT NULL,
hasLicenses_STCNT varchar2(32) NOT NULL);

ALTER TABLE YMRUsersActivity_TREND ADD constraint PK_YMRUsersActivity_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE YMRUsersActivity_THRESH CASCADE CONSTRAINTS;
CREATE TABLE YMRUsersActivity_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
postedcount_MIN VARCHAR2(256) NOT NULL,
postedcount_MAX VARCHAR2(256) NOT NULL,
readcount_MIN VARCHAR2(256) NOT NULL,
readcount_MAX VARCHAR2(256) NOT NULL,
likedcount_MIN VARCHAR2(256) NOT NULL,
likedcount_MAX VARCHAR2(256) NOT NULL,
hasLicenses_MIN VARCHAR2(256) NOT NULL,
hasLicenses_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE YMRUsersActivity_THRESH ADD constraint PK_YMRUsersActivity_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_YMRUsersActivity_THRESH ON YMRUsersActivity_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_YMRUsersActivity ON YMRUsersActivity_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_YMRUsersActivity ON YMRUsersActivity_TREND (MSMT_TIME,PERIOD);



DROP TABLE YMRSrvcHlthTest CASCADE CONSTRAINTS;
CREATE TABLE YMRSrvcHlthTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SERVICE_INCIDENTS Number(20,4) NOT NULL,
SERVICE_INCIDENTS_ST varchar2(32) NOT NULL,
MAINTENANCE_EVENTS Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_ST varchar2(32) NOT NULL,
SERVICE_STATUS Number(20,4) NOT NULL,
SERVICE_STATUS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_YMRSrvcHlthTest ON YMRSrvcHlthTest(MSMT_TIME);
ALTER TABLE YMRSrvcHlthTest ADD constraint PK_YMRSrvcHlthTest PRIMARY KEY(
TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE YMRSrvcHlthTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE YMRSrvcHlthTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SERVICE_INCIDENTS_MIN Number(20,4) NOT NULL,
SERVICE_INCIDENTS_MAX Number(20,4) NOT NULL,
SERVICE_INCIDENTS_STCNT varchar2(32) NOT NULL,
MAINTENANCE_EVENTS_MIN Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_MAX Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_STCNT varchar2(32) NOT NULL,
SERVICE_STATUS_MIN Number(20,4) NOT NULL,
SERVICE_STATUS_MAX Number(20,4) NOT NULL,
SERVICE_STATUS_STCNT varchar2(32) NOT NULL);
ALTER TABLE YMRSrvcHlthTest_TREND ADD constraint PK_YMRSrvcHlthTest_TREND PRIMARY KEY(
TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE YMRSrvcHlthTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE YMRSrvcHlthTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SERVICE_INCIDENTS_MIN varchar2(256) NOT NULL,
SERVICE_INCIDENTS_MAX varchar2(256) NOT NULL,
MAINTENANCE_EVENTS_MIN varchar2(256) NOT NULL,
MAINTENANCE_EVENTS_MAX varchar2(256) NOT NULL,
SERVICE_STATUS_MIN varchar2(256) NOT NULL,
SERVICE_STATUS_MAX varchar2(256) NOT NULL);
ALTER TABLE YMRSrvcHlthTest_THRESH ADD constraint PK_YMRSrvcHlthTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_YMRSrvcHlthTest_THRESH ON YMRSrvcHlthTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_YMRSrvcHlthTest ON YMRSrvcHlthTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_YMRSrvcHlthTest ON YMRSrvcHlthTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE YMRUsrsSumryTest CASCADE CONSTRAINTS;
CREATE TABLE YMRUsrsSumryTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
ActvUsrs Number(20,4) NOT NULL,
ActvUsrs_ST varchar2(32) NOT NULL,
InactvUsrs Number(20,4) NOT NULL,
InactvUsrs_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_YMRUsrsSumryTest ON YMRUsrsSumryTest(MSMT_TIME);
ALTER TABLE YMRUsrsSumryTest ADD constraint PK_YMRUsrsSumryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE YMRUsrsSumryTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE YMRUsrsSumryTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
ActvUsrs_MIN Number(20,4) NOT NULL,
ActvUsrs_MAX Number(20,4) NOT NULL,
ActvUsrs_STCNT varchar2(32) NOT NULL,
InactvUsrs_MIN Number(20,4) NOT NULL,
InactvUsrs_MAX Number(20,4) NOT NULL,
InactvUsrs_STCNT varchar2(32) NOT NULL
);

ALTER TABLE YMRUsrsSumryTest_TREND ADD constraint PK_YMRUsrsSumryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE YMRUsrsSumryTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE YMRUsrsSumryTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
ActvUsrs_MIN VARCHAR2(256) NOT NULL,
ActvUsrs_MAX VARCHAR2(256) NOT NULL,
InactvUsrs_MIN VARCHAR2(256) NOT NULL,
InactvUsrs_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE YMRUsrsSumryTest_THRESH ADD constraint PK_YMRUsrsSumryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_YMRUsrsSumryTest_THRESH ON YMRUsrsSumryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_YMRUsrsSumryTest ON YMRUsrsSumryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_YMRUsrsSumryTest ON YMRUsrsSumryTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE YMRUsersByDevTest CASCADE CONSTRAINTS;
CREATE TABLE YMRUsersByDevTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
UnqUsers Number(20,4) NOT NULL,
UnqUsers_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_YMRUsersByDevTest ON YMRUsersByDevTest(MSMT_TIME);
ALTER TABLE YMRUsersByDevTest ADD constraint PK_YMRUsersByDevTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE YMRUsersByDevTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE YMRUsersByDevTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
UnqUsers_MIN Number(20,4) NOT NULL,
UnqUsers_MAX Number(20,4) NOT NULL,
UnqUsers_STCNT varchar2(32) NOT NULL
);

ALTER TABLE YMRUsersByDevTest_TREND ADD constraint PK_YMRUsersByDevTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE YMRUsersByDevTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE YMRUsersByDevTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
UnqUsers_MIN VARCHAR2(256) NOT NULL,
UnqUsers_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE YMRUsersByDevTest_THRESH ADD constraint PK_YMRUsersByDevTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_YMRUsersByDevTest_THRESH ON YMRUsersByDevTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_YMRUsersByDevTest ON YMRUsersByDevTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_YMRUsersByDevTest ON YMRUsersByDevTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE YMRUsrsByActTest CASCADE CONSTRAINTS;
CREATE TABLE YMRUsrsByActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
LikedCnt Number(20,4) NOT NULL,
LikedCnt_ST varchar2(32) NOT NULL,
PostedCnt Number(20,4) NOT NULL,
PostedCnt_ST varchar2(32) NOT NULL,
ReadCnt Number(20,4) NOT NULL,
ReadCnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_YMRUsrsByActTest ON YMRUsrsByActTest(MSMT_TIME);
ALTER TABLE YMRUsrsByActTest ADD constraint PK_YMRUsrsByActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE YMRUsrsByActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE YMRUsrsByActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
LikedCnt_MIN Number(20,4) NOT NULL,
LikedCnt_MAX Number(20,4) NOT NULL,
LikedCnt_STCNT varchar2(32) NOT NULL,
PostedCnt_MIN Number(20,4) NOT NULL,
PostedCnt_MAX Number(20,4) NOT NULL,
PostedCnt_STCNT varchar2(32) NOT NULL,
ReadCnt_MIN Number(20,4) NOT NULL,
ReadCnt_MAX Number(20,4) NOT NULL,
ReadCnt_STCNT varchar2(32) NOT NULL
);

ALTER TABLE YMRUsrsByActTest_TREND ADD constraint PK_YMRUsrsByActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE YMRUsrsByActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE YMRUsrsByActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
LikedCnt_MIN VARCHAR2(256) NOT NULL,
LikedCnt_MAX VARCHAR2(256) NOT NULL,
PostedCnt_MIN VARCHAR2(256) NOT NULL,
PostedCnt_MAX VARCHAR2(256) NOT NULL,
ReadCnt_MIN VARCHAR2(256) NOT NULL,
ReadCnt_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE YMRUsrsByActTest_THRESH ADD constraint PK_YMRUsrsByActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_YMRUsrsByActTest_THRESH ON YMRUsrsByActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_YMRUsrsByActTest ON YMRUsrsByActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_YMRUsrsByActTest ON YMRUsrsByActTest_TREND (MSMT_TIME,PERIOD);






DROP TABLE YMRGroupsTest CASCADE CONSTRAINTS;
CREATE TABLE YMRGroupsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TotalGrps Number(20,4) NOT NULL,
TotalGrps_ST varchar2(32) NOT NULL,
ActiveGrps Number(20,4) NOT NULL,
ActiveGrps_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_YMRGroupsTest ON YMRGroupsTest(MSMT_TIME);
ALTER TABLE YMRGroupsTest ADD constraint PK_YMRGroupsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE YMRGroupsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE YMRGroupsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TotalGrps_MIN Number(20,4) NOT NULL,
TotalGrps_MAX Number(20,4) NOT NULL,
TotalGrps_STCNT varchar2(32) NOT NULL,
ActiveGrps_MIN Number(20,4) NOT NULL,
ActiveGrps_MAX Number(20,4) NOT NULL,
ActiveGrps_STCNT varchar2(32) NOT NULL
);

ALTER TABLE YMRGroupsTest_TREND ADD constraint PK_YMRGroupsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE YMRGroupsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE YMRGroupsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TotalGrps_MIN VARCHAR2(256) NOT NULL,
TotalGrps_MAX VARCHAR2(256) NOT NULL,
ActiveGrps_MIN VARCHAR2(256) NOT NULL,
ActiveGrps_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE YMRGroupsTest_THRESH ADD constraint PK_YMRGroupsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_YMRGroupsTest_THRESH ON YMRGroupsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_YMRGroupsTest ON YMRGroupsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_YMRGroupsTest ON YMRGroupsTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE YMRMsgsInGrpsTest CASCADE CONSTRAINTS;
CREATE TABLE YMRMsgsInGrpsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
LikedCnt Number(20,4) NOT NULL,
LikedCnt_ST varchar2(32) NOT NULL,
PostedCnt Number(20,4) NOT NULL,
PostedCnt_ST varchar2(32) NOT NULL,
ReadCnt Number(20,4) NOT NULL,
ReadCnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_YMRMsgsInGrpsTest ON YMRMsgsInGrpsTest(MSMT_TIME);
ALTER TABLE YMRMsgsInGrpsTest ADD constraint PK_YMRMsgsInGrpsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE YMRMsgsInGrpsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE YMRMsgsInGrpsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
LikedCnt_MIN Number(20,4) NOT NULL,
LikedCnt_MAX Number(20,4) NOT NULL,
LikedCnt_STCNT varchar2(32) NOT NULL,
PostedCnt_MIN Number(20,4) NOT NULL,
PostedCnt_MAX Number(20,4) NOT NULL,
PostedCnt_STCNT varchar2(32) NOT NULL,
ReadCnt_MIN Number(20,4) NOT NULL,
ReadCnt_MAX Number(20,4) NOT NULL,
ReadCnt_STCNT varchar2(32) NOT NULL
);

ALTER TABLE YMRMsgsInGrpsTest_TREND ADD constraint PK_YMRMsgsInGrpsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE YMRMsgsInGrpsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE YMRMsgsInGrpsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
LikedCnt_MIN VARCHAR2(256) NOT NULL,
LikedCnt_MAX VARCHAR2(256) NOT NULL,
PostedCnt_MIN VARCHAR2(256) NOT NULL,
PostedCnt_MAX VARCHAR2(256) NOT NULL,
ReadCnt_MIN VARCHAR2(256) NOT NULL,
ReadCnt_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE YMRMsgsInGrpsTest_THRESH ADD constraint PK_YMRMsgsInGrpsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_YMRMsgsInGrpsTest_THRESH ON YMRMsgsInGrpsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_YMRMsgsInGrpsTest ON YMRMsgsInGrpsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_YMRMsgsInGrpsTest ON YMRMsgsInGrpsTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE YMRActvtySumryTest CASCADE CONSTRAINTS;
CREATE TABLE YMRActvtySumryTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
LikedCnt Number(20,4) NOT NULL,
LikedCnt_ST varchar2(32) NOT NULL,
PostedCnt Number(20,4) NOT NULL,
PostedCnt_ST varchar2(32) NOT NULL,
ReadCnt Number(20,4) NOT NULL,
ReadCnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_YMRActvtySumryTest ON YMRActvtySumryTest(MSMT_TIME);
ALTER TABLE YMRActvtySumryTest ADD constraint PK_YMRActvtySumryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE YMRActvtySumryTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE YMRActvtySumryTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
LikedCnt_MIN Number(20,4) NOT NULL,
LikedCnt_MAX Number(20,4) NOT NULL,
LikedCnt_STCNT varchar2(32) NOT NULL,
PostedCnt_MIN Number(20,4) NOT NULL,
PostedCnt_MAX Number(20,4) NOT NULL,
PostedCnt_STCNT varchar2(32) NOT NULL,
ReadCnt_MIN Number(20,4) NOT NULL,
ReadCnt_MAX Number(20,4) NOT NULL,
ReadCnt_STCNT varchar2(32) NOT NULL
);

ALTER TABLE YMRActvtySumryTest_TREND ADD constraint PK_YMRActvtySumryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE YMRActvtySumryTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE YMRActvtySumryTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
LikedCnt_MIN VARCHAR2(256) NOT NULL,
LikedCnt_MAX VARCHAR2(256) NOT NULL,
PostedCnt_MIN VARCHAR2(256) NOT NULL,
PostedCnt_MAX VARCHAR2(256) NOT NULL,
ReadCnt_MIN VARCHAR2(256) NOT NULL,
ReadCnt_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE YMRActvtySumryTest_THRESH ADD constraint PK_YMRActvtySumryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_YMRActvtySumryTest_THRESH ON YMRActvtySumryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_YMRActvtySumryTest ON YMRActvtySumryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_YMRActvtySumryTest ON YMRActvtySumryTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365MailSenderTest CASCADE CONSTRAINTS;
CREATE TABLE O365MailSenderTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
AUTH_STATUS		Number(20,4) NOT NULL,
AUTH_STATUS_ST		varchar2(32) NOT NULL,
AUTH_TIME		Number(20,4) NOT NULL,
AUTH_TIME_ST		varchar2(32) NOT NULL,
SEND_AVAIL		Number(20,4) NOT NULL,
SEND_AVAIL_ST		varchar2(32) NOT NULL,
SENT_MSGS		Number(20,4) NOT NULL,
SENT_MSGS_ST		varchar2(32) NOT NULL,
FAILED_MSGS		Number(20,4) NOT NULL,
FAILED_MSGS_ST		varchar2(32) NOT NULL,
SENT_TIME		Number(20,4) NOT NULL,
SENT_TIME_ST		varchar2(32) NOT NULL,
TOTAL_SIM_TIME		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_ST	varchar2(32) NOT NULL);
CREATE INDEX IDX_O365MailSenderTest ON O365MailSenderTest(MSMT_TIME);
ALTER TABLE O365MailSenderTest ADD constraint PK_O365MailSenderTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365MailSenderTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365MailSenderTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
AUTH_STATUS_MIN		Number(20,4) NOT NULL,
AUTH_STATUS_MAX		Number(20,4) NOT NULL,
AUTH_STATUS_STCNT	varchar2(32) NOT NULL,
AUTH_TIME_MIN		Number(20,4) NOT NULL,
AUTH_TIME_MAX		Number(20,4) NOT NULL,
AUTH_TIME_STCNT	varchar2(32) NOT NULL,
SEND_AVAIL_MIN		Number(20,4) NOT NULL,
SEND_AVAIL_MAX		Number(20,4) NOT NULL,
SEND_AVAIL_STCNT	varchar2(32) NOT NULL,
SENT_MSGS_MIN		Number(20,4) NOT NULL,
SENT_MSGS_MAX		Number(20,4) NOT NULL,
SENT_MSGS_STCNT	varchar2(32) NOT NULL,
FAILED_MSGS_MIN		Number(20,4) NOT NULL,
FAILED_MSGS_MAX		Number(20,4) NOT NULL,
FAILED_MSGS_STCNT	varchar2(32) NOT NULL,
SENT_TIME_MIN		Number(20,4) NOT NULL,
SENT_TIME_MAX		Number(20,4) NOT NULL,
SENT_TIME_STCNT	varchar2(32) NOT NULL,
TOTAL_SIM_TIME_MIN		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_MAX		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_STCNT	varchar2(32) NOT NULL);
ALTER TABLE O365MailSenderTest_TREND ADD constraint PK_O365MailSenderTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE O365MailSenderTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365MailSenderTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
AUTH_STATUS_MIN		VARCHAR2(256) NOT NULL,
AUTH_STATUS_MAX		VARCHAR2(256) NOT NULL,
AUTH_TIME_MIN		VARCHAR2(256) NOT NULL,
AUTH_TIME_MAX		VARCHAR2(256) NOT NULL,
SEND_AVAIL_MIN		VARCHAR2(256) NOT NULL,
SEND_AVAIL_MAX		VARCHAR2(256) NOT NULL,
SENT_MSGS_MIN		VARCHAR2(256) NOT NULL,
SENT_MSGS_MAX		VARCHAR2(256) NOT NULL,
FAILED_MSGS_MIN		VARCHAR2(256) NOT NULL,
FAILED_MSGS_MAX		VARCHAR2(256) NOT NULL,
SENT_TIME_MIN		VARCHAR2(256) NOT NULL,
SENT_TIME_MAX		VARCHAR2(256) NOT NULL,
TOTAL_SIM_TIME_MIN		VARCHAR2(256) NOT NULL,
TOTAL_SIM_TIME_MAX		VARCHAR2(256) NOT NULL);
ALTER TABLE O365MailSenderTest_THRESH ADD constraint PK_O365MailSenderTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365MailSenderTest_THRESH ON O365MailSenderTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365MailSenderTest ON O365MailSenderTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365MailSenderTest ON O365MailSenderTest_TREND (MSMT_TIME,PERIOD);
DROP TABLE O365MailRecverTest CASCADE CONSTRAINTS;
CREATE TABLE O365MailRecverTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
AUTH_STATUS		Number(20,4) NOT NULL,
AUTH_STATUS_ST		varchar2(32) NOT NULL,
AUTH_TIME		Number(20,4) NOT NULL,
AUTH_TIME_ST		varchar2(32) NOT NULL,
RCVD_AVAIL		Number(20,4) NOT NULL,
RCVD_AVAIL_ST		varchar2(32) NOT NULL,
RCVD_MSGS		Number(20,4) NOT NULL,
RCVD_MSGS_ST		varchar2(32) NOT NULL,
RCVD_TIME		Number(20,4) NOT NULL,
RCVD_TIME_ST		varchar2(32) NOT NULL,
AVG_ROUNDTRIP_TIME		Number(20,4) NOT NULL,
AVG_ROUNDTRIP_TIME_ST		varchar2(32) NOT NULL,
MAX_ROUNDTRIP_TIME		Number(20,4) NOT NULL,
MAX_ROUNDTRIP_TIME_ST		varchar2(32) NOT NULL,
LAST_MAIL_TIME		Number(20,4) NOT NULL,
LAST_MAIL_TIME_ST		varchar2(32) NOT NULL,
TOTAL_SIM_TIME		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_ST		varchar2(32) NOT NULL,
MISSING_ORDER		Number(20,4) NOT NULL,
MISSING_ORDER_ST		varchar2(32) NOT NULL);
CREATE INDEX IDX_O365MailRecverTest ON O365MailRecverTest(MSMT_TIME);
ALTER TABLE O365MailRecverTest ADD constraint PK_O365MailRecverTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365MailRecverTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365MailRecverTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
AUTH_STATUS_MIN		Number(20,4) NOT NULL,
AUTH_STATUS_MAX		Number(20,4) NOT NULL,
AUTH_STATUS_STCNT	varchar2(32) NOT NULL,
AUTH_TIME_MIN		Number(20,4) NOT NULL,
AUTH_TIME_MAX		Number(20,4) NOT NULL,
AUTH_TIME_STCNT	varchar2(32) NOT NULL,
RCVD_AVAIL_MIN		Number(20,4) NOT NULL,
RCVD_AVAIL_MAX		Number(20,4) NOT NULL,
RCVD_AVAIL_STCNT	varchar2(32) NOT NULL,
RCVD_MSGS_MIN		Number(20,4) NOT NULL,
RCVD_MSGS_MAX		Number(20,4) NOT NULL,
RCVD_MSGS_STCNT	    varchar2(32) NOT NULL,
RCVD_TIME_MIN		Number(20,4) NOT NULL,
RCVD_TIME_MAX		Number(20,4) NOT NULL,
RCVD_TIME_STCNT	    varchar2(32) NOT NULL,
AVG_ROUNDTRIP_TIME_MIN		Number(20,4) NOT NULL,
AVG_ROUNDTRIP_TIME_MAX		Number(20,4) NOT NULL,
AVG_ROUNDTRIP_TIME_STCNT	varchar2(32) NOT NULL,
MAX_ROUNDTRIP_TIME_MIN		Number(20,4) NOT NULL,
MAX_ROUNDTRIP_TIME_MAX		Number(20,4) NOT NULL,
MAX_ROUNDTRIP_TIME_STCNT	varchar2(32) NOT NULL,
LAST_MAIL_TIME_MIN		Number(20,4) NOT NULL,
LAST_MAIL_TIME_MAX		Number(20,4) NOT NULL,
LAST_MAIL_TIME_STCNT	varchar2(32) NOT NULL,
TOTAL_SIM_TIME_MIN		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_MAX		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_STCNT	varchar2(32) NOT NULL,
MISSING_ORDER_MIN		Number(20,4) NOT NULL,
MISSING_ORDER_MAX		Number(20,4) NOT NULL,
MISSING_ORDER_STCNT		varchar2(32) NOT NULL);
ALTER TABLE O365MailRecverTest_TREND ADD constraint PK_O365MailRecverTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE O365MailRecverTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365MailRecverTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
AUTH_STATUS_MIN		VARCHAR2(256) NOT NULL,
AUTH_STATUS_MAX		VARCHAR2(256) NOT NULL,
AUTH_TIME_MIN		VARCHAR2(256) NOT NULL,
AUTH_TIME_MAX		VARCHAR2(256) NOT NULL,
RCVD_AVAIL_MIN		VARCHAR2(256) NOT NULL,
RCVD_AVAIL_MAX		VARCHAR2(256) NOT NULL,
RCVD_MSGS_MIN		VARCHAR2(256) NOT NULL,
RCVD_MSGS_MAX		VARCHAR2(256) NOT NULL,
RCVD_TIME_MIN		VARCHAR2(256) NOT NULL,
RCVD_TIME_MAX		VARCHAR2(256) NOT NULL,
AVG_ROUNDTRIP_TIME_MIN		VARCHAR2(256) NOT NULL,
AVG_ROUNDTRIP_TIME_MAX		VARCHAR2(256) NOT NULL,
MAX_ROUNDTRIP_TIME_MIN		VARCHAR2(256) NOT NULL,
MAX_ROUNDTRIP_TIME_MAX		VARCHAR2(256) NOT NULL,
LAST_MAIL_TIME_MIN		VARCHAR2(256) NOT NULL,
LAST_MAIL_TIME_MAX		VARCHAR2(256) NOT NULL,
TOTAL_SIM_TIME_MIN		VARCHAR2(256) NOT NULL,
TOTAL_SIM_TIME_MAX		VARCHAR2(256) NOT NULL,
MISSING_ORDER_MIN		VARCHAR2(256) NOT NULL,
MISSING_ORDER_MAX		VARCHAR2(256) NOT NULL);
ALTER TABLE O365MailRecverTest_THRESH ADD constraint PK_O365MailRecverTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365MailRecverTest_THRESH ON O365MailRecverTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365MailRecverTest ON O365MailRecverTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365MailRecverTest ON O365MailRecverTest_TREND (MSMT_TIME,PERIOD);
DROP TABLE EXPMailSenderTest CASCADE CONSTRAINTS;
CREATE TABLE EXPMailSenderTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
AUTH_STATUS		Number(20,4) NOT NULL,
AUTH_STATUS_ST		varchar2(32) NOT NULL,
AUTH_TIME		Number(20,4) NOT NULL,
AUTH_TIME_ST		varchar2(32) NOT NULL,
SEND_AVAIL		Number(20,4) NOT NULL,
SEND_AVAIL_ST		varchar2(32) NOT NULL,
SENT_MSGS		Number(20,4) NOT NULL,
SENT_MSGS_ST		varchar2(32) NOT NULL,
FAILED_MSGS		Number(20,4) NOT NULL,
FAILED_MSGS_ST		varchar2(32) NOT NULL,
SENT_TIME		Number(20,4) NOT NULL,
SENT_TIME_ST		varchar2(32) NOT NULL,
TOTAL_SIM_TIME		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_ST		varchar2(32) NOT NULL);
CREATE INDEX IDX_EXPMailSenderTest ON EXPMailSenderTest(MSMT_TIME);
ALTER TABLE EXPMailSenderTest ADD constraint PK_EXPMailSenderTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXPMailSenderTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXPMailSenderTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
AUTH_STATUS_MIN		Number(20,4) NOT NULL,
AUTH_STATUS_MAX		Number(20,4) NOT NULL,
AUTH_STATUS_STCNT	varchar2(32) NOT NULL,
AUTH_TIME_MIN		Number(20,4) NOT NULL,
AUTH_TIME_MAX		Number(20,4) NOT NULL,
AUTH_TIME_STCNT	varchar2(32) NOT NULL,
SEND_AVAIL_MIN		Number(20,4) NOT NULL,
SEND_AVAIL_MAX		Number(20,4) NOT NULL,
SEND_AVAIL_STCNT	varchar2(32) NOT NULL,
SENT_MSGS_MIN		Number(20,4) NOT NULL,
SENT_MSGS_MAX		Number(20,4) NOT NULL,
SENT_MSGS_STCNT	varchar2(32) NOT NULL,
FAILED_MSGS_MIN		Number(20,4) NOT NULL,
FAILED_MSGS_MAX		Number(20,4) NOT NULL,
FAILED_MSGS_STCNT	varchar2(32) NOT NULL,
SENT_TIME_MIN		Number(20,4) NOT NULL,
SENT_TIME_MAX		Number(20,4) NOT NULL,
SENT_TIME_STCNT	varchar2(32) NOT NULL,
TOTAL_SIM_TIME_MIN		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_MAX		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_STCNT	varchar2(32) NOT NULL);
ALTER TABLE EXPMailSenderTest_TREND ADD constraint PK_EXPMailSenderTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE EXPMailSenderTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXPMailSenderTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
AUTH_STATUS_MIN		VARCHAR2(256) NOT NULL,
AUTH_STATUS_MAX		VARCHAR2(256) NOT NULL,
AUTH_TIME_MIN		VARCHAR2(256) NOT NULL,
AUTH_TIME_MAX		VARCHAR2(256) NOT NULL,
SEND_AVAIL_MIN		VARCHAR2(256) NOT NULL,
SEND_AVAIL_MAX		VARCHAR2(256) NOT NULL,
SENT_MSGS_MIN		VARCHAR2(256) NOT NULL,
SENT_MSGS_MAX		VARCHAR2(256) NOT NULL,
FAILED_MSGS_MIN		VARCHAR2(256) NOT NULL,
FAILED_MSGS_MAX		VARCHAR2(256) NOT NULL,
SENT_TIME_MIN		VARCHAR2(256) NOT NULL,
SENT_TIME_MAX		VARCHAR2(256) NOT NULL,
TOTAL_SIM_TIME_MIN		VARCHAR2(256) NOT NULL,
TOTAL_SIM_TIME_MAX		VARCHAR2(256) NOT NULL);
ALTER TABLE EXPMailSenderTest_THRESH ADD constraint PK_EXPMailSenderTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXPMailSenderTest_THRESH ON EXPMailSenderTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXPMailSenderTest ON EXPMailSenderTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXPMailSenderTest ON EXPMailSenderTest_TREND (MSMT_TIME,PERIOD);
DROP TABLE EXPMailRecverTest CASCADE CONSTRAINTS;
CREATE TABLE EXPMailRecverTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
AUTH_STATUS		Number(20,4) NOT NULL,
AUTH_STATUS_ST		varchar2(32) NOT NULL,
AUTH_TIME		Number(20,4) NOT NULL,
AUTH_TIME_ST		varchar2(32) NOT NULL,
RCVD_AVAIL		Number(20,4) NOT NULL,
RCVD_AVAIL_ST		varchar2(32) NOT NULL,
RCVD_MSGS		Number(20,4) NOT NULL,
RCVD_MSGS_ST		varchar2(32) NOT NULL,
RCVD_TIME		Number(20,4) NOT NULL,
RCVD_TIME_ST		varchar2(32) NOT NULL,
AVG_ROUNDTRIP_TIME		Number(20,4) NOT NULL,
AVG_ROUNDTRIP_TIME_ST		varchar2(32) NOT NULL,
MAX_ROUNDTRIP_TIME		Number(20,4) NOT NULL,
MAX_ROUNDTRIP_TIME_ST		varchar2(32) NOT NULL,
LAST_MAIL_TIME		Number(20,4) NOT NULL,
LAST_MAIL_TIME_ST		varchar2(32) NOT NULL,
TOTAL_SIM_TIME		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_ST		varchar2(32) NOT NULL,
MISSING_ORDER		Number(20,4) NOT NULL,
MISSING_ORDER_ST		varchar2(32) NOT NULL);
CREATE INDEX IDX_EXPMailRecverTest ON EXPMailRecverTest(MSMT_TIME);
ALTER TABLE EXPMailRecverTest ADD constraint PK_EXPMailRecverTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXPMailRecverTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXPMailRecverTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
AUTH_STATUS_MIN		Number(20,4) NOT NULL,
AUTH_STATUS_MAX		Number(20,4) NOT NULL,
AUTH_STATUS_STCNT	varchar2(32) NOT NULL,
AUTH_TIME_MIN		Number(20,4) NOT NULL,
AUTH_TIME_MAX		Number(20,4) NOT NULL,
AUTH_TIME_STCNT	varchar2(32) NOT NULL,
RCVD_AVAIL_MIN		Number(20,4) NOT NULL,
RCVD_AVAIL_MAX		Number(20,4) NOT NULL,
RCVD_AVAIL_STCNT	varchar2(32) NOT NULL,
RCVD_MSGS_MIN		Number(20,4) NOT NULL,
RCVD_MSGS_MAX		Number(20,4) NOT NULL,
RCVD_MSGS_STCNT	    varchar2(32) NOT NULL,
RCVD_TIME_MIN		Number(20,4) NOT NULL,
RCVD_TIME_MAX		Number(20,4) NOT NULL,
RCVD_TIME_STCNT	    varchar2(32) NOT NULL,
AVG_ROUNDTRIP_TIME_MIN		Number(20,4) NOT NULL,
AVG_ROUNDTRIP_TIME_MAX		Number(20,4) NOT NULL,
AVG_ROUNDTRIP_TIME_STCNT	varchar2(32) NOT NULL,
MAX_ROUNDTRIP_TIME_MIN		Number(20,4) NOT NULL,
MAX_ROUNDTRIP_TIME_MAX		Number(20,4) NOT NULL,
MAX_ROUNDTRIP_TIME_STCNT	varchar2(32) NOT NULL,
LAST_MAIL_TIME_MIN		Number(20,4) NOT NULL,
LAST_MAIL_TIME_MAX		Number(20,4) NOT NULL,
LAST_MAIL_TIME_STCNT	varchar2(32) NOT NULL,
TOTAL_SIM_TIME_MIN		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_MAX		Number(20,4) NOT NULL,
TOTAL_SIM_TIME_STCNT	varchar2(32) NOT NULL,
MISSING_ORDER_MIN		Number(20,4) NOT NULL,
MISSING_ORDER_MAX		Number(20,4) NOT NULL,
MISSING_ORDER_STCNT		varchar2(32) NOT NULL);
ALTER TABLE EXPMailRecverTest_TREND ADD constraint PK_EXPMailRecverTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE EXPMailRecverTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXPMailRecverTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
AUTH_STATUS_MIN		VARCHAR2(256) NOT NULL,
AUTH_STATUS_MAX		VARCHAR2(256) NOT NULL,
AUTH_TIME_MIN		VARCHAR2(256) NOT NULL,
AUTH_TIME_MAX		VARCHAR2(256) NOT NULL,
RCVD_AVAIL_MIN		VARCHAR2(256) NOT NULL,
RCVD_AVAIL_MAX		VARCHAR2(256) NOT NULL,
RCVD_MSGS_MIN		VARCHAR2(256) NOT NULL,
RCVD_MSGS_MAX		VARCHAR2(256) NOT NULL,
RCVD_TIME_MIN		VARCHAR2(256) NOT NULL,
RCVD_TIME_MAX		VARCHAR2(256) NOT NULL,
AVG_ROUNDTRIP_TIME_MIN		VARCHAR2(256) NOT NULL,
AVG_ROUNDTRIP_TIME_MAX		VARCHAR2(256) NOT NULL,
MAX_ROUNDTRIP_TIME_MIN		VARCHAR2(256) NOT NULL,
MAX_ROUNDTRIP_TIME_MAX		VARCHAR2(256) NOT NULL,
LAST_MAIL_TIME_MIN		VARCHAR2(256) NOT NULL,
LAST_MAIL_TIME_MAX		VARCHAR2(256) NOT NULL,
TOTAL_SIM_TIME_MIN		VARCHAR2(256) NOT NULL,
TOTAL_SIM_TIME_MAX		VARCHAR2(256) NOT NULL,
MISSING_ORDER_MIN		VARCHAR2(256) NOT NULL,
MISSING_ORDER_MAX		VARCHAR2(256) NOT NULL);
ALTER TABLE EXPMailRecverTest_THRESH ADD constraint PK_EXPMailRecverTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXPMailRecverTest_THRESH ON EXPMailRecverTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXPMailRecverTest ON EXPMailRecverTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXPMailRecverTest ON EXPMailRecverTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SBOUsersActvtyDtl CASCADE CONSTRAINTS;
CREATE TABLE SBOUsersActvtyDtl(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
totalPtPSessionCnt		Number(20,4) NOT NULL,
totalPtPSessionCnt_ST		varchar2(32) NOT NULL,
totalOrgzdConCnt		Number(20,4) NOT NULL,
totalOrgzdConCnt_ST		varchar2(32) NOT NULL,
totalPtcpdConCnt		Number(20,4) NOT NULL,
totalPtcpdConCnt_ST		varchar2(32) NOT NULL,
ptpIMCnt		Number(20,4) NOT NULL,
ptpIMCnt_ST		varchar2(32) NOT NULL,
ptpAudioCnt		Number(20,4) NOT NULL,
ptpAudioCnt_ST		varchar2(32) NOT NULL,
ptpAudioMins		Number(20,4) NOT NULL,
ptpAudioMins_ST		varchar2(32) NOT NULL,
ptpVideoCnt		Number(20,4) NOT NULL,
ptpVideoCnt_ST		varchar2(32) NOT NULL,
ptpVideoMins		Number(20,4) NOT NULL,
ptpVideoMins_ST		varchar2(32) NOT NULL,
ptpAppSharingCnt		Number(20,4) NOT NULL,
ptpAppSharingCnt_ST		varchar2(32) NOT NULL,
ptpFileTransferCnt		Number(20,4) NOT NULL,
ptpFileTransferCnt_ST		varchar2(32) NOT NULL,
ptcpdConIMCnt		Number(20,4) NOT NULL,
ptcpdConIMCnt_ST		varchar2(32) NOT NULL,
ptcpdConA_V_Cnt		Number(20,4) NOT NULL,
ptcpdConA_V_Cnt_ST		varchar2(32) NOT NULL,
ptcpdConA_V_Mins		Number(20,4) NOT NULL,
ptcpdConA_V_Mins_ST		varchar2(32) NOT NULL,
ptcpdConAppSharingCnt		Number(20,4) NOT NULL,
ptcpdConAppSharingCnt_ST		varchar2(32) NOT NULL,
ptcpdConWebCnt		Number(20,4) NOT NULL,
ptcpdConWebCnt_ST		varchar2(32) NOT NULL,
ptcpdConDailInOutCnt		Number(20,4) NOT NULL,
ptcpdConDailInOutCnt_ST		varchar2(32) NOT NULL,
orgzdConIMCnt		Number(20,4) NOT NULL,
orgzdConIMCnt_ST		varchar2(32) NOT NULL,
orgzdConA_V_Cnt		Number(20,4) NOT NULL,
orgzdConA_V_Cnt_ST		varchar2(32) NOT NULL,
orgzdConA_V_Mins		Number(20,4) NOT NULL,
orgzdConA_V_Mins_ST		varchar2(32) NOT NULL,
orgzdConAppSharingCnt		Number(20,4) NOT NULL,
orgzdConAppSharingCnt_ST		varchar2(32) NOT NULL,
orgzdConWebCnt		Number(20,4) NOT NULL,
orgzdConWebCnt_ST		varchar2(32) NOT NULL,
orgzdConDailInOutCnt		Number(20,4) NOT NULL,
orgzdConDailInOutCnt_ST		varchar2(32) NOT NULL,
orgzdConDailInOutMSCnt		Number(20,4) NOT NULL,
orgzdConDailInOutMSCnt_ST		varchar2(32) NOT NULL,
orgzdConDailInMSMins		Number(20,4) NOT NULL,
orgzdConDailInMSMins_ST		varchar2(32) NOT NULL,
orgzdConDailOutMsMins		Number(20,4) NOT NULL,
orgzdConDailOutMsMins_ST		varchar2(32) NOT NULL,
hasLicenses Number(20,4) NOT NULL,
hasLicenses_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_SBOUsersActvtyDtl ON SBOUsersActvtyDtl(MSMT_TIME);
ALTER TABLE SBOUsersActvtyDtl ADD constraint PK_SBOUsersActvtyDtl PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOUsersActvtyDtl_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOUsersActvtyDtl_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
totalPtPSessionCnt_MIN		Number(20,4) NOT NULL,
totalPtPSessionCnt_MAX		Number(20,4) NOT NULL,
totalPtPSessionCnt_STCNT	varchar2(32) NOT NULL,
totalOrgzdConCnt_MIN		Number(20,4) NOT NULL,
totalOrgzdConCnt_MAX		Number(20,4) NOT NULL,
totalOrgzdConCnt_STCNT	varchar2(32) NOT NULL,
totalPtcpdConCnt_MIN		Number(20,4) NOT NULL,
totalPtcpdConCnt_MAX		Number(20,4) NOT NULL,
totalPtcpdConCnt_STCNT	varchar2(32) NOT NULL,
ptpIMCnt_MIN		Number(20,4) NOT NULL,
ptpIMCnt_MAX		Number(20,4) NOT NULL,
ptpIMCnt_STCNT	varchar2(32) NOT NULL,
ptpAudioCnt_MIN		Number(20,4) NOT NULL,
ptpAudioCnt_MAX		Number(20,4) NOT NULL,
ptpAudioCnt_STCNT	varchar2(32) NOT NULL,
ptpAudioMins_MIN		Number(20,4) NOT NULL,
ptpAudioMins_MAX		Number(20,4) NOT NULL,
ptpAudioMins_STCNT	varchar2(32) NOT NULL,
ptpVideoCnt_MIN		Number(20,4) NOT NULL,
ptpVideoCnt_MAX		Number(20,4) NOT NULL,
ptpVideoCnt_STCNT	varchar2(32) NOT NULL,
ptpVideoMins_MIN		Number(20,4) NOT NULL,
ptpVideoMins_MAX		Number(20,4) NOT NULL,
ptpVideoMins_STCNT	varchar2(32) NOT NULL,
ptpAppSharingCnt_MIN		Number(20,4) NOT NULL,
ptpAppSharingCnt_MAX		Number(20,4) NOT NULL,
ptpAppSharingCnt_STCNT	varchar2(32) NOT NULL,
ptpFileTransferCnt_MIN		Number(20,4) NOT NULL,
ptpFileTransferCnt_MAX		Number(20,4) NOT NULL,
ptpFileTransferCnt_STCNT	varchar2(32) NOT NULL,
ptcpdConIMCnt_MIN		Number(20,4) NOT NULL,
ptcpdConIMCnt_MAX		Number(20,4) NOT NULL,
ptcpdConIMCnt_STCNT	varchar2(32) NOT NULL,
ptcpdConA_V_Cnt_MIN		Number(20,4) NOT NULL,
ptcpdConA_V_Cnt_MAX		Number(20,4) NOT NULL,
ptcpdConA_V_Cnt_STCNT	varchar2(32) NOT NULL,
ptcpdConA_V_Mins_MIN		Number(20,4) NOT NULL,
ptcpdConA_V_Mins_MAX		Number(20,4) NOT NULL,
ptcpdConA_V_Mins_STCNT	varchar2(32) NOT NULL,
ptcpdConAppSharingCnt_MIN		Number(20,4) NOT NULL,
ptcpdConAppSharingCnt_MAX		Number(20,4) NOT NULL,
ptcpdConAppSharingCnt_STCNT	varchar2(32) NOT NULL,
ptcpdConWebCnt_MIN		Number(20,4) NOT NULL,
ptcpdConWebCnt_MAX		Number(20,4) NOT NULL,
ptcpdConWebCnt_STCNT	varchar2(32) NOT NULL,
ptcpdConDailInOutCnt_MIN		Number(20,4) NOT NULL,
ptcpdConDailInOutCnt_MAX		Number(20,4) NOT NULL,
ptcpdConDailInOutCnt_STCNT	varchar2(32) NOT NULL,
orgzdConIMCnt_MIN		Number(20,4) NOT NULL,
orgzdConIMCnt_MAX		Number(20,4) NOT NULL,
orgzdConIMCnt_STCNT	varchar2(32) NOT NULL,
orgzdConA_V_Cnt_MIN		Number(20,4) NOT NULL,
orgzdConA_V_Cnt_MAX		Number(20,4) NOT NULL,
orgzdConA_V_Cnt_STCNT	varchar2(32) NOT NULL,
orgzdConA_V_Mins_MIN		Number(20,4) NOT NULL,
orgzdConA_V_Mins_MAX		Number(20,4) NOT NULL,
orgzdConA_V_Mins_STCNT	varchar2(32) NOT NULL,
orgzdConAppSharingCnt_MIN		Number(20,4) NOT NULL,
orgzdConAppSharingCnt_MAX		Number(20,4) NOT NULL,
orgzdConAppSharingCnt_STCNT	varchar2(32) NOT NULL,
orgzdConWebCnt_MIN		Number(20,4) NOT NULL,
orgzdConWebCnt_MAX		Number(20,4) NOT NULL,
orgzdConWebCnt_STCNT	varchar2(32) NOT NULL,
orgzdConDailInOutCnt_MIN		Number(20,4) NOT NULL,
orgzdConDailInOutCnt_MAX		Number(20,4) NOT NULL,
orgzdConDailInOutCnt_STCNT	varchar2(32) NOT NULL,
orgzdConDailInOutMSCnt_MIN		Number(20,4) NOT NULL,
orgzdConDailInOutMSCnt_MAX		Number(20,4) NOT NULL,
orgzdConDailInOutMSCnt_STCNT	varchar2(32) NOT NULL,
orgzdConDailInMSMins_MIN		Number(20,4) NOT NULL,
orgzdConDailInMSMins_MAX		Number(20,4) NOT NULL,
orgzdConDailInMSMins_STCNT	varchar2(32) NOT NULL,
orgzdConDailOutMsMins_MIN		Number(20,4) NOT NULL,
orgzdConDailOutMsMins_MAX		Number(20,4) NOT NULL,
orgzdConDailOutMsMins_STCNT	varchar2(32) NOT NULL,
hasLicenses_MIN Number(20,4) NOT NULL,
hasLicenses_MAX Number(20,4) NOT NULL,
hasLicenses_STCNT varchar2(32) NOT NULL);
ALTER TABLE SBOUsersActvtyDtl_TREND ADD constraint PK_SBOUsersActvtyDtl_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOUsersActvtyDtl_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOUsersActvtyDtl_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
totalPtPSessionCnt_MIN		VARCHAR2(256) NOT NULL,
totalPtPSessionCnt_MAX		VARCHAR2(256) NOT NULL,
totalOrgzdConCnt_MIN		VARCHAR2(256) NOT NULL,
totalOrgzdConCnt_MAX		VARCHAR2(256) NOT NULL,
totalPtcpdConCnt_MIN		VARCHAR2(256) NOT NULL,
totalPtcpdConCnt_MAX		VARCHAR2(256) NOT NULL,
ptpIMCnt_MIN		VARCHAR2(256) NOT NULL,
ptpIMCnt_MAX		VARCHAR2(256) NOT NULL,
ptpAudioCnt_MIN		VARCHAR2(256) NOT NULL,
ptpAudioCnt_MAX		VARCHAR2(256) NOT NULL,
ptpAudioMins_MIN		VARCHAR2(256) NOT NULL,
ptpAudioMins_MAX		VARCHAR2(256) NOT NULL,
ptpVideoCnt_MIN		VARCHAR2(256) NOT NULL,
ptpVideoCnt_MAX		VARCHAR2(256) NOT NULL,
ptpVideoMins_MIN		VARCHAR2(256) NOT NULL,
ptpVideoMins_MAX		VARCHAR2(256) NOT NULL,
ptpAppSharingCnt_MIN		VARCHAR2(256) NOT NULL,
ptpAppSharingCnt_MAX		VARCHAR2(256) NOT NULL,
ptpFileTransferCnt_MIN		VARCHAR2(256) NOT NULL,
ptpFileTransferCnt_MAX		VARCHAR2(256) NOT NULL,
ptcpdConIMCnt_MIN		VARCHAR2(256) NOT NULL,
ptcpdConIMCnt_MAX		VARCHAR2(256) NOT NULL,
ptcpdConA_V_Cnt_MIN		VARCHAR2(256) NOT NULL,
ptcpdConA_V_Cnt_MAX		VARCHAR2(256) NOT NULL,
ptcpdConA_V_Mins_MIN		VARCHAR2(256) NOT NULL,
ptcpdConA_V_Mins_MAX		VARCHAR2(256) NOT NULL,
ptcpdConAppSharingCnt_MIN		VARCHAR2(256) NOT NULL,
ptcpdConAppSharingCnt_MAX		VARCHAR2(256) NOT NULL,
ptcpdConWebCnt_MIN		VARCHAR2(256) NOT NULL,
ptcpdConWebCnt_MAX		VARCHAR2(256) NOT NULL,
ptcpdConDailInOutCnt_MIN		VARCHAR2(256) NOT NULL,
ptcpdConDailInOutCnt_MAX		VARCHAR2(256) NOT NULL,
orgzdConIMCnt_MIN		VARCHAR2(256) NOT NULL,
orgzdConIMCnt_MAX		VARCHAR2(256) NOT NULL,
orgzdConA_V_Cnt_MIN		VARCHAR2(256) NOT NULL,
orgzdConA_V_Cnt_MAX		VARCHAR2(256) NOT NULL,
orgzdConA_V_Mins_MIN		VARCHAR2(256) NOT NULL,
orgzdConA_V_Mins_MAX		VARCHAR2(256) NOT NULL,
orgzdConAppSharingCnt_MIN		VARCHAR2(256) NOT NULL,
orgzdConAppSharingCnt_MAX		VARCHAR2(256) NOT NULL,
orgzdConWebCnt_MIN		VARCHAR2(256) NOT NULL,
orgzdConWebCnt_MAX		VARCHAR2(256) NOT NULL,
orgzdConDailInOutCnt_MIN		VARCHAR2(256) NOT NULL,
orgzdConDailInOutCnt_MAX		VARCHAR2(256) NOT NULL,
orgzdConDailInOutMSCnt_MIN		VARCHAR2(256) NOT NULL,
orgzdConDailInOutMSCnt_MAX		VARCHAR2(256) NOT NULL,
orgzdConDailInMSMins_MIN		VARCHAR2(256) NOT NULL,
orgzdConDailInMSMins_MAX		VARCHAR2(256) NOT NULL,
orgzdConDailOutMsMins_MIN		VARCHAR2(256) NOT NULL,
orgzdConDailOutMsMins_MAX		VARCHAR2(256) NOT NULL,
hasLicenses_MIN VARCHAR2(256) NOT NULL,
hasLicenses_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE SBOUsersActvtyDtl_THRESH ADD constraint PK_SBOUsersActvtyDtl_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOUsersActvtyDtl_THRESH ON SBOUsersActvtyDtl_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOUsersActvtyDtl ON SBOUsersActvtyDtl_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOUsersActvtyDtl ON SBOUsersActvtyDtl_TREND (MSMT_TIME,PERIOD);


DROP TABLE SPOUsersActvtyDtl CASCADE CONSTRAINTS;
CREATE TABLE SPOUsersActvtyDtl(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
viewedEditedFileCnt		Number(20,4) NOT NULL,
viewedEditedFileCnt_ST		varchar2(32) NOT NULL,
syncedFileCnt		Number(20,4) NOT NULL,
syncedFileCnt_ST		varchar2(32) NOT NULL,
sharedInFileCnt		Number(20,4) NOT NULL,
sharedInFileCnt_ST		varchar2(32) NOT NULL,
sharedExFileCnt		Number(20,4) NOT NULL,
sharedExFileCnt_ST		varchar2(32) NOT NULL,
visitedPgCount		Number(20,4) NOT NULL,
visitedPgCount_ST		varchar2(32) NOT NULL,
hasLicenses Number(20,4) NOT NULL,
hasLicenses_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_SPOUsersActvtyDtl ON SPOUsersActvtyDtl(MSMT_TIME);
ALTER TABLE SPOUsersActvtyDtl ADD constraint PK_SPOUsersActvtyDtl PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOUsersActvtyDtl_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOUsersActvtyDtl_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
viewedEditedFileCnt_MIN		Number(20,4) NOT NULL,
viewedEditedFileCnt_MAX		Number(20,4) NOT NULL,
viewedEditedFileCnt_STCNT	varchar2(32) NOT NULL,
syncedFileCnt_MIN		Number(20,4) NOT NULL,
syncedFileCnt_MAX		Number(20,4) NOT NULL,
syncedFileCnt_STCNT	varchar2(32) NOT NULL,
sharedInFileCnt_MIN		Number(20,4) NOT NULL,
sharedInFileCnt_MAX		Number(20,4) NOT NULL,
sharedInFileCnt_STCNT	varchar2(32) NOT NULL,
sharedExFileCnt_MIN		Number(20,4) NOT NULL,
sharedExFileCnt_MAX		Number(20,4) NOT NULL,
sharedExFileCnt_STCNT	varchar2(32) NOT NULL,
visitedPgCount_MIN		Number(20,4) NOT NULL,
visitedPgCount_MAX		Number(20,4) NOT NULL,
visitedPgCount_STCNT	varchar2(32) NOT NULL,
hasLicenses_MIN Number(20,4) NOT NULL,
hasLicenses_MAX Number(20,4) NOT NULL,
hasLicenses_STCNT varchar2(32) NOT NULL);
ALTER TABLE SPOUsersActvtyDtl_TREND ADD constraint PK_SPOUsersActvtyDtl_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOUsersActvtyDtl_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOUsersActvtyDtl_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
viewedEditedFileCnt_MIN		VARCHAR2(256) NOT NULL,
viewedEditedFileCnt_MAX		VARCHAR2(256) NOT NULL,
syncedFileCnt_MIN		VARCHAR2(256) NOT NULL,
syncedFileCnt_MAX		VARCHAR2(256) NOT NULL,
sharedInFileCnt_MIN		VARCHAR2(256) NOT NULL,
sharedInFileCnt_MAX		VARCHAR2(256) NOT NULL,
sharedExFileCnt_MIN		VARCHAR2(256) NOT NULL,
sharedExFileCnt_MAX		VARCHAR2(256) NOT NULL,
visitedPgCount_MIN		VARCHAR2(256) NOT NULL,
visitedPgCount_MAX		VARCHAR2(256) NOT NULL,
hasLicenses_MIN VARCHAR2(256) NOT NULL,
hasLicenses_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE SPOUsersActvtyDtl_THRESH ADD constraint PK_SPOUsersActvtyDtl_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOUsersActvtyDtl_THRESH ON SPOUsersActvtyDtl_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOUsersActvtyDtl ON SPOUsersActvtyDtl_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOUsersActvtyDtl ON SPOUsersActvtyDtl_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365UsersLicnsDtls CASCADE CONSTRAINTS;
CREATE TABLE O365UsersLicnsDtls(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TotLicAssgnd Number(20,4) NOT NULL,
TotLicAssgnd_ST varchar2(32) NOT NULL,
HasEXOLicns Number(20,4) NOT NULL,
HasEXOLicns_ST varchar2(32) NOT NULL,
HasODBLicns Number(20,4) NOT NULL,
HasODBLicns_ST varchar2(32) NOT NULL,
HasSPOLicns Number(20,4) NOT NULL,
HasSPOLicns_ST varchar2(32) NOT NULL,
HasSBOLicns Number(20,4) NOT NULL,
HasSBOLicns_ST varchar2(32) NOT NULL,
HasYamrLicns Number(20,4) NOT NULL,
HasYamrLicns_ST varchar2(32) NOT NULL,
HasMTMLicns Number(20,4) NOT NULL,
HasMTMLicns_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365UsersLicnsDtls ON O365UsersLicnsDtls(MSMT_TIME);
ALTER TABLE O365UsersLicnsDtls ADD constraint PK_O365UsersLicnsDtls PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UsersLicnsDtls_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365UsersLicnsDtls_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TotLicAssgnd_MIN Number(20,4) NOT NULL,
TotLicAssgnd_MAX Number(20,4) NOT NULL,
TotLicAssgnd_STCNT varchar2(32) NOT NULL,
HasEXOLicns_MIN Number(20,4) NOT NULL,
HasEXOLicns_MAX Number(20,4) NOT NULL,
HasEXOLicns_STCNT varchar2(32) NOT NULL,
HasODBLicns_MIN Number(20,4) NOT NULL,
HasODBLicns_MAX Number(20,4) NOT NULL,
HasODBLicns_STCNT varchar2(32) NOT NULL,
HasSPOLicns_MIN Number(20,4) NOT NULL,
HasSPOLicns_MAX Number(20,4) NOT NULL,
HasSPOLicns_STCNT varchar2(32) NOT NULL,
HasSBOLicns_MIN Number(20,4) NOT NULL,
HasSBOLicns_MAX Number(20,4) NOT NULL,
HasSBOLicns_STCNT varchar2(32) NOT NULL,
HasYamrLicns_MIN Number(20,4) NOT NULL,
HasYamrLicns_MAX Number(20,4) NOT NULL,
HasYamrLicns_STCNT varchar2(32) NOT NULL,
HasMTMLicns_MIN Number(20,4) NOT NULL,
HasMTMLicns_MAX Number(20,4) NOT NULL,
HasMTMLicns_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365UsersLicnsDtls_TREND ADD constraint PK_O365UsersLicnsDtls_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UsersLicnsDtls_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365UsersLicnsDtls_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TotLicAssgnd_MIN VARCHAR2(256) NOT NULL,
TotLicAssgnd_MAX VARCHAR2(256) NOT NULL,
HasEXOLicns_MIN VARCHAR2(256) NOT NULL,
HasEXOLicns_MAX VARCHAR2(256) NOT NULL,
HasODBLicns_MIN VARCHAR2(256) NOT NULL,
HasODBLicns_MAX VARCHAR2(256) NOT NULL,
HasSPOLicns_MIN VARCHAR2(256) NOT NULL,
HasSPOLicns_MAX VARCHAR2(256) NOT NULL,
HasSBOLicns_MIN VARCHAR2(256) NOT NULL,
HasSBOLicns_MAX VARCHAR2(256) NOT NULL,
HasYamrLicns_MIN VARCHAR2(256) NOT NULL,
HasYamrLicns_MAX VARCHAR2(256) NOT NULL,
HasMTMLicns_MIN VARCHAR2(256) NOT NULL,
HasMTMLicns_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365UsersLicnsDtls_THRESH ADD constraint PK_O365UsersLicnsDtls_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UsersLicnsDtls_THRESH ON O365UsersLicnsDtls_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UsersLicnsDtls ON O365UsersLicnsDtls_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UsersLicnsDtls ON O365UsersLicnsDtls_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UsersGrpsActvtyDtls CASCADE CONSTRAINTS;
CREATE TABLE O365UsersGrpsActvtyDtls(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MemberCnt Number(20,4) NOT NULL,
MemberCnt_ST varchar2(32) NOT NULL,
ExtMemCnt Number(20,4) NOT NULL,
ExtMemCnt_ST varchar2(32) NOT NULL,
ExRcvmailCnt Number(20,4) NOT NULL,
ExRcvmailCnt_ST varchar2(32) NOT NULL,
SPActFileCnt Number(20,4) NOT NULL,
SPActFileCnt_ST varchar2(32) NOT NULL,
YmrPstdMsgCnt Number(20,4) NOT NULL,
YmrPstdMsgCnt_ST varchar2(32) NOT NULL,
YmrReadMsgCnt Number(20,4) NOT NULL,
YmrReadMsgCnt_ST varchar2(32) NOT NULL,
YmrLikdMsgCnt Number(20,4) NOT NULL,
YmrLikdMsgCnt_ST varchar2(32) NOT NULL,
ExMlbxTotItmCnt Number(20,4) NOT NULL,
ExMlbxTotItmCnt_ST varchar2(32) NOT NULL,
ExMailbxStrgUsd Number(20,4) NOT NULL,
ExMailbxStrgUsd_ST varchar2(32) NOT NULL,
SPTotFileCnt Number(20,4) NOT NULL,
SPTotFileCnt_ST varchar2(32) NOT NULL,
SPSitStrgUsd Number(20,4) NOT NULL,
SPSitStrgUsd_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365UsrsGrpActDtls ON O365UsersGrpsActvtyDtls(MSMT_TIME);
ALTER TABLE O365UsersGrpsActvtyDtls ADD constraint PK_O365UsersGrpsActvtyDtls PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UsersGrpsActvtyDtls_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365UsersGrpsActvtyDtls_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MemberCnt_MIN Number(20,4) NOT NULL,
MemberCnt_MAX Number(20,4) NOT NULL,
MemberCnt_STCNT varchar2(32) NOT NULL,
ExtMemCnt_MIN Number(20,4) NOT NULL,
ExtMemCnt_MAX Number(20,4) NOT NULL,
ExtMemCnt_STCNT varchar2(32) NOT NULL,
ExRcvmailCnt_MIN Number(20,4) NOT NULL,
ExRcvmailCnt_MAX Number(20,4) NOT NULL,
ExRcvmailCnt_STCNT varchar2(32) NOT NULL,
SPActFileCnt_MIN Number(20,4) NOT NULL,
SPActFileCnt_MAX Number(20,4) NOT NULL,
SPActFileCnt_STCNT varchar2(32) NOT NULL,
YmrPstdMsgCnt_MIN Number(20,4) NOT NULL,
YmrPstdMsgCnt_MAX Number(20,4) NOT NULL,
YmrPstdMsgCnt_STCNT varchar2(32) NOT NULL,
YmrReadMsgCnt_MIN Number(20,4) NOT NULL,
YmrReadMsgCnt_MAX Number(20,4) NOT NULL,
YmrReadMsgCnt_STCNT varchar2(32) NOT NULL,
YmrLikdMsgCnt_MIN Number(20,4) NOT NULL,
YmrLikdMsgCnt_MAX Number(20,4) NOT NULL,
YmrLikdMsgCnt_STCNT varchar2(32) NOT NULL,
ExMlbxTotItmCnt_MIN Number(20,4) NOT NULL,
ExMlbxTotItmCnt_MAX Number(20,4) NOT NULL,
ExMlbxTotItmCnt_STCNT varchar2(32) NOT NULL,
ExMailbxStrgUsd_MIN Number(20,4) NOT NULL,
ExMailbxStrgUsd_MAX Number(20,4) NOT NULL,
ExMailbxStrgUsd_STCNT varchar2(32) NOT NULL,
SPTotFileCnt_MIN Number(20,4) NOT NULL,
SPTotFileCnt_MAX Number(20,4) NOT NULL,
SPTotFileCnt_STCNT varchar2(32) NOT NULL,
SPSitStrgUsd_MIN Number(20,4) NOT NULL,
SPSitStrgUsd_MAX Number(20,4) NOT NULL,
SPSitStrgUsd_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365UsersGrpsActvtyDtls_TREND ADD constraint PK_O365UsrsGrpActDtls_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UsersGrpsActvtyDtls_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365UsersGrpsActvtyDtls_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MemberCnt_MIN VARCHAR2(256) NOT NULL,
MemberCnt_MAX VARCHAR2(256) NOT NULL,
ExtMemCnt_MIN VARCHAR2(256) NOT NULL,
ExtMemCnt_MAX VARCHAR2(256) NOT NULL,
ExRcvmailCnt_MIN VARCHAR2(256) NOT NULL,
ExRcvmailCnt_MAX VARCHAR2(256) NOT NULL,
SPActFileCnt_MIN VARCHAR2(256) NOT NULL,
SPActFileCnt_MAX VARCHAR2(256) NOT NULL,
YmrPstdMsgCnt_MIN VARCHAR2(256) NOT NULL,
YmrPstdMsgCnt_MAX VARCHAR2(256) NOT NULL,
YmrReadMsgCnt_MIN VARCHAR2(256) NOT NULL,
YmrReadMsgCnt_MAX VARCHAR2(256) NOT NULL,
YmrLikdMsgCnt_MIN VARCHAR2(256) NOT NULL,
YmrLikdMsgCnt_MAX VARCHAR2(256) NOT NULL,
ExMlbxTotItmCnt_MIN VARCHAR2(256) NOT NULL,
ExMlbxTotItmCnt_MAX VARCHAR2(256) NOT NULL,
ExMailbxStrgUsd_MIN VARCHAR2(256) NOT NULL,
ExMailbxStrgUsd_MAX VARCHAR2(256) NOT NULL,
SPTotFileCnt_MIN VARCHAR2(256) NOT NULL,
SPTotFileCnt_MAX VARCHAR2(256) NOT NULL,
SPSitStrgUsd_MIN VARCHAR2(256) NOT NULL,
SPSitStrgUsd_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365UsersGrpsActvtyDtls_THRESH ADD constraint PK_O365UsrsGrpActDtls_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UsrsGrpActDtls_THRESH ON O365UsersGrpsActvtyDtls_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UsrsGrpActDtls ON O365UsersGrpsActvtyDtls_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UsrsGrpActDtls ON O365UsersGrpsActvtyDtls_TREND (MSMT_TIME,PERIOD);


DROP TABLE WASActiveSpecStTest CASCADE CONSTRAINTS;
CREATE TABLE WASActiveSpecStTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
STATUS Number(20,4) NOT NULL,
STATUS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_WASActiveSpecStTest ON WASActiveSpecStTest(MSMT_TIME);
ALTER TABLE WASActiveSpecStTest ADD constraint PK_WASActiveSpecStTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE WASActiveSpecStTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE WASActiveSpecStTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
STATUS_MIN Number(20,4) NOT NULL,
STATUS_MAX Number(20,4) NOT NULL,
STATUS_STCNT varchar2(32) NOT NULL);

ALTER TABLE WASActiveSpecStTest_TREND ADD constraint PK_WASActiveSpecStTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE WASActiveSpecStTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE WASActiveSpecStTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
STATUS_MIN VARCHAR2(256) NOT NULL,
STATUS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE WASActiveSpecStTest_THRESH ADD constraint PK_WASActiveSpecStTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_WASActiveSpecStTest_THRESH ON WASActiveSpecStTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_WASActiveSpecStTest ON WASActiveSpecStTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_WASActiveSpecStTest ON WASActiveSpecStTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE FileUpdateTest CASCADE CONSTRAINTS;
CREATE TABLE FileUpdateTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
FileCount		Number(20,4) NOT NULL,
FileCount_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_FileUpdateTest ON FileUpdateTest(MSMT_TIME);
ALTER TABLE FileUpdateTest ADD constraint PK_FileUpdateTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE FileUpdateTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE FileUpdateTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
FileCount_MIN		Number(20,4) NOT NULL,
FileCount_MAX		Number(20,4) NOT NULL,
FileCount_STCNT	varchar2(32) NOT NULL);

ALTER TABLE FileUpdateTest_TREND ADD constraint PK_FileUpdateTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE FileUpdateTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE FileUpdateTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
FileCount_MIN		VARCHAR2(256) NOT NULL,
FileCount_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE FileUpdateTest_THRESH ADD constraint PK_FileUpdateTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_FileUpdateTest_THRESH ON FileUpdateTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_FileUpdateTest ON FileUpdateTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_FileUpdateTest ON FileUpdateTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE EXOMailActSumTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMailActSumTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Mails_sent Number(20,4) NOT NULL,
Mails_sent_ST varchar2(32) NOT NULL,
Mails_received Number(20,4) NOT NULL,
Mails_received_ST varchar2(32) NOT NULL,
Mails_read Number(20,4) NOT NULL,
Mails_read_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOMailActSumTest ON EXOMailActSumTest(MSMT_TIME);
ALTER TABLE EXOMailActSumTest ADD constraint PK_EXOMailActSumTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailActSumTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMailActSumTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Mails_sent_MIN Number(20,4) NOT NULL,
Mails_sent_MAX Number(20,4) NOT NULL,
Mails_sent_STCNT varchar2(32) NOT NULL,
Mails_received_MIN Number(20,4) NOT NULL,
Mails_received_MAX Number(20,4) NOT NULL,
Mails_received_STCNT varchar2(32) NOT NULL,
Mails_read_MIN Number(20,4) NOT NULL,
Mails_read_MAX Number(20,4) NOT NULL,
Mails_read_STCNT varchar2(32) NOT NULL
);

ALTER TABLE EXOMailActSumTest_TREND ADD constraint PK_EXOMailActSumTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailActSumTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMailActSumTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Mails_sent_MIN VARCHAR2(256) NOT NULL,
Mails_sent_MAX VARCHAR2(256) NOT NULL,
Mails_received_MIN VARCHAR2(256) NOT NULL,
Mails_received_MAX VARCHAR2(256) NOT NULL,
Mails_read_MIN VARCHAR2(256) NOT NULL,
Mails_read_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE EXOMailActSumTest_THRESH ADD constraint PK_EXOMailActSumTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMailActSumTest_THRESH ON EXOMailActSumTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailActSumTest ON EXOMailActSumTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailActSumTest ON EXOMailActSumTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE NetworkConnTest CASCADE CONSTRAINTS;
CREATE TABLE NetworkConnTest(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
RESULT_MSG		Number(20,4) NOT NULL,
RESULT_MSG_ST		varchar2(32) NOT NULL,
RESP_TIME		Number(20,4) NOT NULL,
RESP_TIME_ST		varchar2(32) NOT NULL);

CREATE INDEX IDX_NetworkConnTest ON NetworkConnTest(MSMT_TIME);
ALTER TABLE NetworkConnTest ADD constraint PK_NetworkConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE NetworkConnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE NetworkConnTest_TREND(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME		date,
PERIOD			varchar2(32),
RESULT_MSG_MIN		Number(20,4) NOT NULL,
RESULT_MSG_MAX		Number(20,4) NOT NULL,
RESULT_MSG_STCNT	varchar2(32) NOT NULL,
RESP_TIME_MIN		Number(20,4) NOT NULL,
RESP_TIME_MAX		Number(20,4) NOT NULL,
RESP_TIME_STCNT		varchar2(32) NOT NULL);

ALTER TABLE NetworkConnTest_TREND ADD constraint PK_NetworkConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE NetworkConnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE NetworkConnTest_THRESH(
TRGT_HOST		varchar2(32),
PORT_NO			varchar2(32),
SITE_NAME		varchar2(64),
INFO			varchar2(128),
MSMT_HOST		varchar2(32),
MSMT_TIME_START		date,
MSMT_TIME_END		date,
RESULT_MSG_MIN		VARCHAR2(256) NOT NULL,
RESULT_MSG_MAX		VARCHAR2(256) NOT NULL,
RESP_TIME_MIN		VARCHAR2(256) NOT NULL,
RESP_TIME_MAX		VARCHAR2(256) NOT NULL);

ALTER TABLE NetworkConnTest_THRESH ADD constraint PK_NetworkConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_NetworkConnTest_THRESH ON NetworkConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_NetworkConnTest ON NetworkConnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_NetworkConnTest ON NetworkConnTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HybDataSrcTest CASCADE CONSTRAINTS;
CREATE TABLE HybDataSrcTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Status Number(20,4) NOT NULL,
Status_ST varchar2(32) NOT NULL,
ConnRate Number(20,4) NOT NULL,
ConnRate_ST varchar2(32) NOT NULL,
OpenConn Number(20,4) NOT NULL,
OpenConn_ST varchar2(32) NOT NULL,
UsedConn Number(20,4) NOT NULL,
UsedConn_ST varchar2(32) NOT NULL,
MaxAllowOpenConn Number(20,4) NOT NULL,
MaxAllowOpenConn_ST varchar2(32) NOT NULL,
OpenConnPerc Number(20,4) NOT NULL,
OpenConnPerc_ST varchar2(32) NOT NULL,
UsedConnPerc Number(20,4) NOT NULL,
UsedConnPerc_ST varchar2(32) NOT NULL,
AvgWaitTimeConn Number(20,4) NOT NULL,
AvgWaitTimeConn_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybDataSrcTest ON HybDataSrcTest(MSMT_TIME);
ALTER TABLE HybDataSrcTest ADD constraint PK_HybDataSrcTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HybDataSrcTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybDataSrcTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Status_MIN Number(20,4) NOT NULL,
Status_MAX Number(20,4) NOT NULL,
Status_STCNT varchar2(32) NOT NULL,
ConnRate_MIN Number(20,4) NOT NULL,
ConnRate_MAX Number(20,4) NOT NULL,
ConnRate_STCNT varchar2(32) NOT NULL,
OpenConn_MIN Number(20,4) NOT NULL,
OpenConn_MAX Number(20,4) NOT NULL,
OpenConn_STCNT varchar2(32) NOT NULL,
UsedConn_MIN Number(20,4) NOT NULL,
UsedConn_MAX Number(20,4) NOT NULL,
UsedConn_STCNT varchar2(32) NOT NULL,
MaxAllowOpenConn_MIN Number(20,4) NOT NULL,
MaxAllowOpenConn_MAX Number(20,4) NOT NULL,
MaxAllowOpenConn_STCNT varchar2(32) NOT NULL,
OpenConnPerc_MIN Number(20,4) NOT NULL,
OpenConnPerc_MAX Number(20,4) NOT NULL,
OpenConnPerc_STCNT varchar2(32) NOT NULL,
UsedConnPerc_MIN Number(20,4) NOT NULL,
UsedConnPerc_MAX Number(20,4) NOT NULL,
UsedConnPerc_STCNT varchar2(32) NOT NULL,
AvgWaitTimeConn_MIN Number(20,4) NOT NULL,
AvgWaitTimeConn_MAX Number(20,4) NOT NULL,
AvgWaitTimeConn_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybDataSrcTest_TREND ADD constraint PK_HybDataSrcTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybDataSrcTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybDataSrcTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Status_MIN varchar2(256) NOT NULL,
Status_MAX varchar2(256) NOT NULL,
ConnRate_MIN varchar2(256) NOT NULL,
ConnRate_MAX varchar2(256) NOT NULL,
OpenConn_MIN varchar2(256) NOT NULL,
OpenConn_MAX varchar2(256) NOT NULL,
UsedConn_MIN varchar2(256) NOT NULL,
UsedConn_MAX varchar2(256) NOT NULL,
MaxAllowOpenConn_MIN varchar2(256) NOT NULL,
MaxAllowOpenConn_MAX varchar2(256) NOT NULL,
OpenConnPerc_MIN varchar2(256) NOT NULL,
OpenConnPerc_MAX varchar2(256) NOT NULL,
UsedConnPerc_MIN varchar2(256) NOT NULL,
UsedConnPerc_MAX varchar2(256) NOT NULL,
AvgWaitTimeConn_MIN varchar2(256) NOT NULL,
AvgWaitTimeConn_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybDataSrcTest_THRESH ADD constraint PK_HybDataSrcTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybDataSrcTest_THRESH ON HybDataSrcTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybDataSrcTest ON HybDataSrcTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybDataSrcTest ON HybDataSrcTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE HybFlexQueryTest CASCADE CONSTRAINTS;
CREATE TABLE HybFlexQueryTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CurrentSize Number(20,4) NOT NULL,
CurrentSize_ST varchar2(32) NOT NULL,
CurrentSizeInPercent Number(20,4) NOT NULL,
CurrentSizeInPercent_ST varchar2(32) NOT NULL,
MaxSize Number(20,4) NOT NULL,
MaxSize_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybFlexQueryTest ON HybFlexQueryTest(MSMT_TIME);
ALTER TABLE HybFlexQueryTest ADD constraint PK_HybFlexQueryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE HybFlexQueryTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybFlexQueryTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CurrentSize_MIN Number(20,4) NOT NULL,
CurrentSize_MAX Number(20,4) NOT NULL,
CurrentSize_STCNT varchar2(32) NOT NULL,
CurrentSizeInPercent_MIN Number(20,4) NOT NULL,
CurrentSizeInPercent_MAX Number(20,4) NOT NULL,
CurrentSizeInPercent_STCNT varchar2(32) NOT NULL,
MaxSize_MIN Number(20,4) NOT NULL,
MaxSize_MAX Number(20,4) NOT NULL,
MaxSize_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybFlexQueryTest_TREND ADD constraint PK_HybFlexQueryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybFlexQueryTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybFlexQueryTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CurrentSize_MIN varchar2(256) NOT NULL,
CurrentSize_MAX varchar2(256) NOT NULL,
CurrentSizeInPercent_MIN varchar2(256) NOT NULL,
CurrentSizeInPercent_MAX varchar2(256) NOT NULL,
MaxSize_MIN varchar2(256) NOT NULL,
MaxSize_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybFlexQueryTest_THRESH ADD constraint PK_HybFlexQueryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybFlexQueryTest_THRESH ON HybFlexQueryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybFlexQueryTest ON HybFlexQueryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybFlexQueryTest ON HybFlexQueryTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HybMainCacheTest CASCADE CONSTRAINTS;
CREATE TABLE HybMainCacheTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CurCacheSize Number(20,4) NOT NULL,
CurCacheSize_ST varchar2(32) NOT NULL,
CurCacheSizeInPercent Number(20,4) NOT NULL,
CurCacheSizeInPercent_ST varchar2(32) NOT NULL,
MaximumCacheSize Number(20,4) NOT NULL,
MaximumCacheSize_ST varchar2(32) NOT NULL,
EntitiesGetCount Number(20,4) NOT NULL,
EntitiesGetCount_ST varchar2(32) NOT NULL,
EntitiesHitCount Number(20,4) NOT NULL,
EntitiesHitCount_ST varchar2(32) NOT NULL,
HitInPerc Number(20,4) NOT NULL,
HitInPerc_ST varchar2(32) NOT NULL,
MissInPerc Number(20,4) NOT NULL,
MissInPerc_ST varchar2(32) NOT NULL,
EntitiesAddCount Number(20,4) NOT NULL,
EntitiesAddCount_ST varchar2(32) NOT NULL,
EntitiesRemoveCount Number(20,4) NOT NULL,
EntitiesRemoveCount_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybMainCacheTest ON HybMainCacheTest(MSMT_TIME);
ALTER TABLE HybMainCacheTest ADD constraint PK_HybMainCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybMainCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybMainCacheTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CurCacheSize_MIN Number(20,4) NOT NULL,
CurCacheSize_MAX Number(20,4) NOT NULL,
CurCacheSize_STCNT varchar2(32) NOT NULL,
CurCacheSizeInPercent_MIN Number(20,4) NOT NULL,
CurCacheSizeInPercent_MAX Number(20,4) NOT NULL,
CurCacheSizeInPercent_STCNT varchar2(32) NOT NULL,
MaximumCacheSize_MIN Number(20,4) NOT NULL,
MaximumCacheSize_MAX Number(20,4) NOT NULL,
MaximumCacheSize_STCNT varchar2(32) NOT NULL,
EntitiesGetCount_MIN Number(20,4) NOT NULL,
EntitiesGetCount_MAX Number(20,4) NOT NULL,
EntitiesGetCount_STCNT varchar2(32) NOT NULL,
EntitiesHitCount_MIN Number(20,4) NOT NULL,
EntitiesHitCount_MAX Number(20,4) NOT NULL,
EntitiesHitCount_STCNT varchar2(32) NOT NULL,
HitInPerc_MIN Number(20,4) NOT NULL,
HitInPerc_MAX Number(20,4) NOT NULL,
HitInPerc_STCNT varchar2(32) NOT NULL,
MissInPerc_MIN Number(20,4) NOT NULL,
MissInPerc_MAX Number(20,4) NOT NULL,
MissInPerc_STCNT varchar2(32) NOT NULL,
EntitiesAddCount_MIN Number(20,4) NOT NULL,
EntitiesAddCount_MAX Number(20,4) NOT NULL,
EntitiesAddCount_STCNT varchar2(32) NOT NULL,
EntitiesRemoveCount_MIN Number(20,4) NOT NULL,
EntitiesRemoveCount_MAX Number(20,4) NOT NULL,
EntitiesRemoveCount_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybMainCacheTest_TREND ADD constraint PK_HybMainCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybMainCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybMainCacheTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CurCacheSize_MIN varchar2(256) NOT NULL,
CurCacheSize_MAX varchar2(256) NOT NULL,
CurCacheSizeInPercent_MIN varchar2(256) NOT NULL,
CurCacheSizeInPercent_MAX varchar2(256) NOT NULL,
MaximumCacheSize_MIN varchar2(256) NOT NULL,
MaximumCacheSize_MAX varchar2(256) NOT NULL,
EntitiesGetCount_MIN varchar2(256) NOT NULL,
EntitiesGetCount_MAX varchar2(256) NOT NULL,
EntitiesHitCount_MIN varchar2(256) NOT NULL,
EntitiesHitCount_MAX varchar2(256) NOT NULL,
HitInPerc_MIN varchar2(256) NOT NULL,
HitInPerc_MAX varchar2(256) NOT NULL,
MissInPerc_MIN varchar2(256) NOT NULL,
MissInPerc_MAX varchar2(256) NOT NULL,
EntitiesAddCount_MIN varchar2(256) NOT NULL,
EntitiesAddCount_MAX varchar2(256) NOT NULL,
EntitiesRemoveCount_MIN varchar2(256) NOT NULL,
EntitiesRemoveCount_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybMainCacheTest_THRESH ADD constraint PK_HybMainCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybMainCacheTest_THRESH ON HybMainCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybMainCacheTest ON HybMainCacheTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybMainCacheTest ON HybMainCacheTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HybEntCacheTest CASCADE CONSTRAINTS;
CREATE TABLE HybEntCacheTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CurrentCacheSize Number(20,4) NOT NULL,
CurrentCacheSize_ST varchar2(32) NOT NULL,
CacheFillRatio Number(20,4) NOT NULL,
CacheFillRatio_ST varchar2(32) NOT NULL,
MaximumCacheSize Number(20,4) NOT NULL,
MaximumCacheSize_ST varchar2(32) NOT NULL,
FetchCount Number(20,4) NOT NULL,
FetchCount_ST varchar2(32) NOT NULL,
HitCount Number(20,4) NOT NULL,
HitCount_ST varchar2(32) NOT NULL,
MissCount Number(20,4) NOT NULL,
MissCount_ST varchar2(32) NOT NULL,
HitRatio Number(20,4) NOT NULL,
HitRatio_ST varchar2(32) NOT NULL,
InvalidationCount Number(20,4) NOT NULL,
InvalidationCount_ST varchar2(32) NOT NULL,
EvictionCount Number(20,4) NOT NULL,
EvictionCount_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybEntCacheTest ON HybEntCacheTest(MSMT_TIME);
ALTER TABLE HybEntCacheTest ADD constraint PK_HybEntCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybEntCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybEntCacheTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CurrentCacheSize_MIN Number(20,4) NOT NULL,
CurrentCacheSize_MAX Number(20,4) NOT NULL,
CurrentCacheSize_STCNT varchar2(32) NOT NULL,
CacheFillRatio_MIN Number(20,4) NOT NULL,
CacheFillRatio_MAX Number(20,4) NOT NULL,
CacheFillRatio_STCNT varchar2(32) NOT NULL,
MaximumCacheSize_MIN Number(20,4) NOT NULL,
MaximumCacheSize_MAX Number(20,4) NOT NULL,
MaximumCacheSize_STCNT varchar2(32) NOT NULL,
FetchCount_MIN Number(20,4) NOT NULL,
FetchCount_MAX Number(20,4) NOT NULL,
FetchCount_STCNT varchar2(32) NOT NULL,
HitCount_MIN Number(20,4) NOT NULL,
HitCount_MAX Number(20,4) NOT NULL,
HitCount_STCNT varchar2(32) NOT NULL,
MissCount_MIN Number(20,4) NOT NULL,
MissCount_MAX Number(20,4) NOT NULL,
MissCount_STCNT varchar2(32) NOT NULL,
HitRatio_MIN Number(20,4) NOT NULL,
HitRatio_MAX Number(20,4) NOT NULL,
HitRatio_STCNT varchar2(32) NOT NULL,
InvalidationCount_MIN Number(20,4) NOT NULL,
InvalidationCount_MAX Number(20,4) NOT NULL,
InvalidationCount_STCNT varchar2(32) NOT NULL,
EvictionCount_MIN Number(20,4) NOT NULL,
EvictionCount_MAX Number(20,4) NOT NULL,
EvictionCount_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybEntCacheTest_TREND ADD constraint PK_HybEntCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybEntCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybEntCacheTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CurrentCacheSize_MIN varchar2(256) NOT NULL,
CurrentCacheSize_MAX varchar2(256) NOT NULL,
CacheFillRatio_MIN varchar2(256) NOT NULL,
CacheFillRatio_MAX varchar2(256) NOT NULL,
MaximumCacheSize_MIN varchar2(256) NOT NULL,
MaximumCacheSize_MAX varchar2(256) NOT NULL,
FetchCount_MIN varchar2(256) NOT NULL,
FetchCount_MAX varchar2(256) NOT NULL,
HitCount_MIN varchar2(256) NOT NULL,
HitCount_MAX varchar2(256) NOT NULL,
MissCount_MIN varchar2(256) NOT NULL,
MissCount_MAX varchar2(256) NOT NULL,
HitRatio_MIN varchar2(256) NOT NULL,
HitRatio_MAX varchar2(256) NOT NULL,
InvalidationCount_MIN varchar2(256) NOT NULL,
InvalidationCount_MAX varchar2(256) NOT NULL,
EvictionCount_MIN varchar2(256) NOT NULL,
EvictionCount_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybEntCacheTest_THRESH ADD constraint PK_HybEntCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybEntCacheTest_THRESH ON HybEntCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybEntCacheTest ON HybEntCacheTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybEntCacheTest ON HybEntCacheTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HybQyCacheTest CASCADE CONSTRAINTS;
CREATE TABLE HybQyCacheTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
CurrentCacheSize Number(20,4) NOT NULL,
CurrentCacheSize_ST varchar2(32) NOT NULL,
CacheFillRatio Number(20,4) NOT NULL,
CacheFillRatio_ST varchar2(32) NOT NULL,
MaximumCacheSize Number(20,4) NOT NULL,
MaximumCacheSize_ST varchar2(32) NOT NULL,
FetchCount Number(20,4) NOT NULL,
FetchCount_ST varchar2(32) NOT NULL,
HitCount Number(20,4) NOT NULL,
HitCount_ST varchar2(32) NOT NULL,
MissCount Number(20,4) NOT NULL,
MissCount_ST varchar2(32) NOT NULL,
HitRatio Number(20,4) NOT NULL,
HitRatio_ST varchar2(32) NOT NULL,
InvalidationCount Number(20,4) NOT NULL,
InvalidationCount_ST varchar2(32) NOT NULL,
EvictionCount Number(20,4) NOT NULL,
EvictionCount_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybQyCacheTest ON HybQyCacheTest(MSMT_TIME);
ALTER TABLE HybQyCacheTest ADD constraint PK_HybQyCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybQyCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybQyCacheTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
CurrentCacheSize_MIN Number(20,4) NOT NULL,
CurrentCacheSize_MAX Number(20,4) NOT NULL,
CurrentCacheSize_STCNT varchar2(32) NOT NULL,
CacheFillRatio_MIN Number(20,4) NOT NULL,
CacheFillRatio_MAX Number(20,4) NOT NULL,
CacheFillRatio_STCNT varchar2(32) NOT NULL,
MaximumCacheSize_MIN Number(20,4) NOT NULL,
MaximumCacheSize_MAX Number(20,4) NOT NULL,
MaximumCacheSize_STCNT varchar2(32) NOT NULL,
FetchCount_MIN Number(20,4) NOT NULL,
FetchCount_MAX Number(20,4) NOT NULL,
FetchCount_STCNT varchar2(32) NOT NULL,
HitCount_MIN Number(20,4) NOT NULL,
HitCount_MAX Number(20,4) NOT NULL,
HitCount_STCNT varchar2(32) NOT NULL,
MissCount_MIN Number(20,4) NOT NULL,
MissCount_MAX Number(20,4) NOT NULL,
MissCount_STCNT varchar2(32) NOT NULL,
HitRatio_MIN Number(20,4) NOT NULL,
HitRatio_MAX Number(20,4) NOT NULL,
HitRatio_STCNT varchar2(32) NOT NULL,
InvalidationCount_MIN Number(20,4) NOT NULL,
InvalidationCount_MAX Number(20,4) NOT NULL,
InvalidationCount_STCNT varchar2(32) NOT NULL,
EvictionCount_MIN Number(20,4) NOT NULL,
EvictionCount_MAX Number(20,4) NOT NULL,
EvictionCount_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybQyCacheTest_TREND ADD constraint PK_HybQyCacheTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybQyCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybQyCacheTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
CurrentCacheSize_MIN varchar2(256) NOT NULL,
CurrentCacheSize_MAX varchar2(256) NOT NULL,
CacheFillRatio_MIN varchar2(256) NOT NULL,
CacheFillRatio_MAX varchar2(256) NOT NULL,
MaximumCacheSize_MIN varchar2(256) NOT NULL,
MaximumCacheSize_MAX varchar2(256) NOT NULL,
FetchCount_MIN varchar2(256) NOT NULL,
FetchCount_MAX varchar2(256) NOT NULL,
HitCount_MIN varchar2(256) NOT NULL,
HitCount_MAX varchar2(256) NOT NULL,
MissCount_MIN varchar2(256) NOT NULL,
MissCount_MAX varchar2(256) NOT NULL,
HitRatio_MIN varchar2(256) NOT NULL,
HitRatio_MAX varchar2(256) NOT NULL,
InvalidationCount_MIN varchar2(256) NOT NULL,
InvalidationCount_MAX varchar2(256) NOT NULL,
EvictionCount_MIN varchar2(256) NOT NULL,
EvictionCount_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybQyCacheTest_THRESH ADD constraint PK_HybQyCacheTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybQyCacheTest_THRESH ON HybQyCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybQyCacheTest ON HybQyCacheTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybQyCacheTest ON HybQyCacheTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HybCronJobTest CASCADE CONSTRAINTS;
CREATE TABLE HybCronJobTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
cronjob Number(20,4) NOT NULL,
cronjob_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybCronJobTest ON HybCronJobTest(MSMT_TIME);
ALTER TABLE HybCronJobTest ADD constraint PK_HybCronJobTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybCronJobTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybCronJobTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
cronjob_MIN Number(20,4) NOT NULL,
cronjob_MAX Number(20,4) NOT NULL,
cronjob_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybCronJobTest_TREND ADD constraint PK_HybCronJobTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybCronJobTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybCronJobTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
cronjob_MIN varchar2(256) NOT NULL,
cronjob_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybCronJobTest_THRESH ADD constraint PK_HybCronJobTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybCronJobTest_THRESH ON HybCronJobTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybCronJobTest ON HybCronJobTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybCronJobTest ON HybCronJobTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HybTaskEngDBTest CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngDBTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
TblCondSize Number(20,4) NOT NULL,
TblCondSize_ST varchar2(32) NOT NULL,
TblTaskSize Number(20,4) NOT NULL,
TblTaskSize_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybTaskEngDBTest ON HybTaskEngDBTest(MSMT_TIME);
ALTER TABLE HybTaskEngDBTest ADD constraint PK_HybTaskEngDBTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybTaskEngDBTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngDBTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
TblCondSize_MIN Number(20,4) NOT NULL,
TblCondSize_MAX Number(20,4) NOT NULL,
TblCondSize_STCNT varchar2(32) NOT NULL,
TblTaskSize_MIN Number(20,4) NOT NULL,
TblTaskSize_MAX Number(20,4) NOT NULL,
TblTaskSize_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybTaskEngDBTest_TREND ADD constraint PK_HybTaskEngDBTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybTaskEngDBTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngDBTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
TblCondSize_MIN varchar2(256) NOT NULL,
TblCondSize_MAX varchar2(256) NOT NULL,
TblTaskSize_MIN varchar2(256) NOT NULL,
TblTaskSize_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybTaskEngDBTest_THRESH ADD constraint PK_HybTaskEngDBTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybTaskEngDBTest_THRESH ON HybTaskEngDBTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybTaskEngDBTest ON HybTaskEngDBTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybTaskEngDBTest ON HybTaskEngDBTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HybTaskEngExeTest CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngExeTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ExeHits Number(20,4) NOT NULL,
ExeHits_ST varchar2(32) NOT NULL,
ExeLockTime Number(20,4) NOT NULL,
ExeLockTime_ST varchar2(32) NOT NULL,
ExeTime Number(20,4) NOT NULL,
ExeTime_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybTaskEngExeTest ON HybTaskEngExeTest(MSMT_TIME);
ALTER TABLE HybTaskEngExeTest ADD constraint PK_HybTaskEngExeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybTaskEngExeTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngExeTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ExeHits_MIN Number(20,4) NOT NULL,
ExeHits_MAX Number(20,4) NOT NULL,
ExeHits_STCNT varchar2(32) NOT NULL,
ExeLockTime_MIN Number(20,4) NOT NULL,
ExeLockTime_MAX Number(20,4) NOT NULL,
ExeLockTime_STCNT varchar2(32) NOT NULL,
ExeTime_MIN Number(20,4) NOT NULL,
ExeTime_MAX Number(20,4) NOT NULL,
ExeTime_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybTaskEngExeTest_TREND ADD constraint PK_HybTaskEngExeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybTaskEngExeTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngExeTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ExeHits_MIN varchar2(256) NOT NULL,
ExeHits_MAX varchar2(256) NOT NULL,
ExeLockTime_MIN varchar2(256) NOT NULL,
ExeLockTime_MAX varchar2(256) NOT NULL,
ExeTime_MIN varchar2(256) NOT NULL,
ExeTime_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybTaskEngExeTest_THRESH ADD constraint PK_HybTaskEngExeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybTaskEngExeTest_THRESH ON HybTaskEngExeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybTaskEngExeTest ON HybTaskEngExeTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybTaskEngExeTest ON HybTaskEngExeTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE HybTaskEngPlTest CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngPlTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PlBufSize Number(20,4) NOT NULL,
PlBufSize_ST varchar2(32) NOT NULL,
PlQueueSize Number(20,4) NOT NULL,
PlQueueSize_ST varchar2(32) NOT NULL,
PlConditionSize Number(20,4) NOT NULL,
PlConditionSize_ST varchar2(32) NOT NULL,
PlTime Number(20,4) NOT NULL,
PlTime_ST varchar2(32) NOT NULL,
QueueSize Number(20,4) NOT NULL,
QueueSize_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_HybTaskEngPlTest ON HybTaskEngPlTest(MSMT_TIME);
ALTER TABLE HybTaskEngPlTest ADD constraint PK_HybTaskEngPlTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybTaskEngPlTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngPlTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
PlBufSize_MIN Number(20,4) NOT NULL,
PlBufSize_MAX Number(20,4) NOT NULL,
PlBufSize_STCNT varchar2(32) NOT NULL,
PlQueueSize_MIN Number(20,4) NOT NULL,
PlQueueSize_MAX Number(20,4) NOT NULL,
PlQueueSize_STCNT varchar2(32) NOT NULL,
PlConditionSize_MIN Number(20,4) NOT NULL,
PlConditionSize_MAX Number(20,4) NOT NULL,
PlConditionSize_STCNT varchar2(32) NOT NULL,
PlTime_MIN Number(20,4) NOT NULL,
PlTime_MAX Number(20,4) NOT NULL,
PlTime_STCNT varchar2(32) NOT NULL,
QueueSize_MIN Number(20,4) NOT NULL,
QueueSize_MAX Number(20,4) NOT NULL,
QueueSize_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybTaskEngPlTest_TREND ADD constraint PK_HybTaskEngPlTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybTaskEngPlTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybTaskEngPlTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
PlBufSize_MIN varchar2(256) NOT NULL,
PlBufSize_MAX varchar2(256) NOT NULL,
PlQueueSize_MIN varchar2(256) NOT NULL,
PlQueueSize_MAX varchar2(256) NOT NULL,
PlConditionSize_MIN varchar2(256) NOT NULL,
PlConditionSize_MAX varchar2(256) NOT NULL,
PlTime_MIN varchar2(256) NOT NULL,
PlTime_MAX varchar2(256) NOT NULL,
QueueSize_MIN varchar2(256) NOT NULL,
QueueSize_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybTaskEngPlTest_THRESH ADD constraint PK_HybTaskEngPlTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybTaskEngPlTest_THRESH ON HybTaskEngPlTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybTaskEngPlTest ON HybTaskEngPlTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybTaskEngPlTest ON HybTaskEngPlTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE HybTaskPlSchdTest CASCADE CONSTRAINTS;
CREATE TABLE HybTaskPlSchdTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
ActWorkTime Number(20,4) NOT NULL,
ActWorkTime_ST varchar2(32) NOT NULL,
CopyTaskTime Number(20,4) NOT NULL,
CopyTaskTime_ST varchar2(32) NOT NULL,
CountTaskTime Number(20,4) NOT NULL,
CountTaskTime_ST varchar2(32) NOT NULL,
DeactWorkTime Number(20,4) NOT NULL,
DeactWorkTime_ST varchar2(32) NOT NULL,
LockTime Number(20,4) NOT NULL,
LockTime_ST varchar2(32) NOT NULL,
PlTime Number(20,4) NOT NULL,
PlTime_ST varchar2(32) NOT NULL

);
CREATE INDEX IDX_HybTaskPlSchdTest ON HybTaskPlSchdTest(MSMT_TIME);
ALTER TABLE HybTaskPlSchdTest ADD constraint PK_HybTaskPlSchdTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE HybTaskPlSchdTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE HybTaskPlSchdTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
ActWorkTime_MIN Number(20,4) NOT NULL,
ActWorkTime_MAX Number(20,4) NOT NULL,
ActWorkTime_STCNT varchar2(32) NOT NULL,
CopyTaskTime_MIN Number(20,4) NOT NULL,
CopyTaskTime_MAX Number(20,4) NOT NULL,
CopyTaskTime_STCNT varchar2(32) NOT NULL,
CountTaskTime_MIN Number(20,4) NOT NULL,
CountTaskTime_MAX Number(20,4) NOT NULL,
CountTaskTime_STCNT varchar2(32) NOT NULL,
DeactWorkTime_MIN Number(20,4) NOT NULL,
DeactWorkTime_MAX Number(20,4) NOT NULL,
DeactWorkTime_STCNT varchar2(32) NOT NULL,
LockTime_MIN Number(20,4) NOT NULL,
LockTime_MAX Number(20,4) NOT NULL,
LockTime_STCNT varchar2(32) NOT NULL,
PlTime_MIN Number(20,4) NOT NULL,
PlTime_MAX Number(20,4) NOT NULL,
PlTime_STCNT varchar2(32) NOT NULL
);
ALTER TABLE HybTaskPlSchdTest_TREND ADD constraint PK_HybTaskPlSchdTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE HybTaskPlSchdTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE HybTaskPlSchdTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
ActWorkTime_MIN varchar2(256) NOT NULL,
ActWorkTime_MAX varchar2(256) NOT NULL,
CopyTaskTime_MIN varchar2(256) NOT NULL,
CopyTaskTime_MAX varchar2(256) NOT NULL,
CountTaskTime_MIN varchar2(256) NOT NULL,
CountTaskTime_MAX varchar2(256) NOT NULL,
DeactWorkTime_MIN varchar2(256) NOT NULL,
DeactWorkTime_MAX varchar2(256) NOT NULL,
LockTime_MIN varchar2(256) NOT NULL,
LockTime_MAX varchar2(256) NOT NULL,
PlTime_MIN varchar2(256) NOT NULL,
PlTime_MAX varchar2(256) NOT NULL
);
ALTER TABLE HybTaskPlSchdTest_THRESH ADD constraint PK_HybTaskPlSchdTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_HybTaskPlSchdTest_THRESH ON HybTaskPlSchdTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_HybTaskPlSchdTest ON HybTaskPlSchdTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_HybTaskPlSchdTest ON HybTaskPlSchdTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SaaSTcpCnctvtyTest CASCADE CONSTRAINTS;
CREATE TABLE SaaSTcpCnctvtyTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
tcp_psent Number(20,4) NOT NULL,
tcp_psent_ST varchar2(32) NOT NULL,
tcp_plost Number(20,4) NOT NULL,
tcp_plost_ST varchar2(32) NOT NULL,
tcp_plost_p Number(20,4) NOT NULL,
tcp_plost_p_ST varchar2(32) NOT NULL,
tcp_tmax Number(20,4) NOT NULL,
tcp_tmax_ST varchar2(32) NOT NULL,
tcp_tmin Number(20,4) NOT NULL,
tcp_tmin_ST varchar2(32) NOT NULL,
tcp_tavg Number(20,4) NOT NULL,
tcp_tavg_ST varchar2(32) NOT NULL,
tcp_jmax Number(20,4) NOT NULL,
tcp_jmax_ST varchar2(32) NOT NULL,
tcp_jmin Number(20,4) NOT NULL,
tcp_jmin_ST varchar2(32) NOT NULL,
tcp_javg Number(20,4) NOT NULL,
tcp_javg_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_SaaSTcpCnctvtyTest ON SaaSTcpCnctvtyTest(MSMT_TIME);
ALTER TABLE SaaSTcpCnctvtyTest ADD constraint PK_SaaSTcpCnctvtyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SaaSTcpCnctvtyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SaaSTcpCnctvtyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
tcp_psent_MIN Number(20,4) NOT NULL,
tcp_psent_MAX Number(20,4) NOT NULL,
tcp_psent_STCNT varchar2(32) NOT NULL,
tcp_plost_MIN Number(20,4) NOT NULL,
tcp_plost_MAX Number(20,4) NOT NULL,
tcp_plost_STCNT varchar2(32) NOT NULL,
tcp_plost_p_MIN Number(20,4) NOT NULL,
tcp_plost_p_MAX Number(20,4) NOT NULL,
tcp_plost_p_STCNT varchar2(32) NOT NULL,
tcp_tmax_MIN Number(20,4) NOT NULL,
tcp_tmax_MAX Number(20,4) NOT NULL,
tcp_tmax_STCNT varchar2(32) NOT NULL,
tcp_tmin_MIN Number(20,4) NOT NULL,
tcp_tmin_MAX Number(20,4) NOT NULL,
tcp_tmin_STCNT varchar2(32) NOT NULL,
tcp_tavg_MIN Number(20,4) NOT NULL,
tcp_tavg_MAX Number(20,4) NOT NULL,
tcp_tavg_STCNT varchar2(32) NOT NULL,
tcp_jmax_MIN Number(20,4) NOT NULL,
tcp_jmax_MAX Number(20,4) NOT NULL,
tcp_jmax_STCNT varchar2(32) NOT NULL,
tcp_jmin_MIN Number(20,4) NOT NULL,
tcp_jmin_MAX Number(20,4) NOT NULL,
tcp_jmin_STCNT varchar2(32) NOT NULL,
tcp_javg_MIN Number(20,4) NOT NULL,
tcp_javg_MAX Number(20,4) NOT NULL,
tcp_javg_STCNT varchar2(32) NOT NULL
);

ALTER TABLE SaaSTcpCnctvtyTest_TREND ADD constraint PK_SaaSTcpCnctvtyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SaaSTcpCnctvtyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SaaSTcpCnctvtyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
tcp_psent_MIN VARCHAR2(256) NOT NULL,
tcp_psent_MAX VARCHAR2(256) NOT NULL,
tcp_plost_MIN VARCHAR2(256) NOT NULL,
tcp_plost_MAX VARCHAR2(256) NOT NULL,
tcp_plost_p_MIN VARCHAR2(256) NOT NULL,
tcp_plost_p_MAX VARCHAR2(256) NOT NULL,
tcp_tmax_MIN VARCHAR2(256) NOT NULL,
tcp_tmax_MAX VARCHAR2(256) NOT NULL,
tcp_tmin_MIN VARCHAR2(256) NOT NULL,
tcp_tmin_MAX VARCHAR2(256) NOT NULL,
tcp_tavg_MIN VARCHAR2(256) NOT NULL,
tcp_tavg_MAX VARCHAR2(256) NOT NULL,
tcp_jmax_MIN VARCHAR2(256) NOT NULL,
tcp_jmax_MAX VARCHAR2(256) NOT NULL,
tcp_jmin_MIN VARCHAR2(256) NOT NULL,
tcp_jmin_MAX VARCHAR2(256) NOT NULL,
tcp_javg_MIN VARCHAR2(256) NOT NULL,
tcp_javg_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE SaaSTcpCnctvtyTest_THRESH ADD constraint PK_SaaSTcpCnctvtyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SaaSTcpCnctvtyTest_THRESH ON SaaSTcpCnctvtyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SaaSTcpCnctvtyTest ON SaaSTcpCnctvtyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SaaSTcpCnctvtyTest ON SaaSTcpCnctvtyTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ShareFileStatusTest CASCADE CONSTRAINTS;
CREATE TABLE ShareFileStatusTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
status Number(20,4) NOT NULL,
status_ST varchar2(32) NOT NULL,
incidents Number(20,4) NOT NULL,
incidents_ST varchar2(32) NOT NULL,
maintanence Number(20,4) NOT NULL,
maintanence_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ShareFileStatusTest ON ShareFileStatusTest(MSMT_TIME);
ALTER TABLE ShareFileStatusTest ADD constraint PK_ShareFileStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ShareFileStatusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ShareFileStatusTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
status_MIN Number(20,4) NOT NULL,
status_MAX Number(20,4) NOT NULL,
status_STCNT varchar2(32) NOT NULL,
incidents_MIN Number(20,4) NOT NULL,
incidents_MAX Number(20,4) NOT NULL,
incidents_STCNT varchar2(32) NOT NULL,
maintanence_MIN Number(20,4) NOT NULL,
maintanence_MAX Number(20,4) NOT NULL,
maintanence_STCNT varchar2(32) NOT NULL
);

ALTER TABLE ShareFileStatusTest_TREND ADD constraint PK_ShareFileStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ShareFileStatusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ShareFileStatusTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
status_MIN VARCHAR2(256) NOT NULL,
status_MAX VARCHAR2(256) NOT NULL,
incidents_MIN VARCHAR2(256) NOT NULL,
incidents_MAX VARCHAR2(256) NOT NULL,
maintanence_MIN VARCHAR2(256) NOT NULL,
maintanence_MAX VARCHAR2(256) NOT NULL
);

ALTER TABLE ShareFileStatusTest_THRESH ADD constraint PK_SharFilStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SharFilStatusTest_THRESH ON ShareFileStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ShareFileStatusTest ON ShareFileStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ShareFileStatusTest ON ShareFileStatusTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EgSysLogLevelTest CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogLevelTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
error Number(20,4) NOT NULL,
error_ST varchar2(32) NOT NULL,
emergency Number(20,4) NOT NULL,
emergency_ST varchar2(32) NOT NULL,
critical Number(20,4) NOT NULL,
critical_ST varchar2(32) NOT NULL,
debug Number(20,4) NOT NULL,
debug_ST varchar2(32) NOT NULL,
infomation Number(20,4) NOT NULL,
infomation_ST varchar2(32) NOT NULL,
warning Number(20,4) NOT NULL,
warning_ST varchar2(32) NOT NULL,
alert Number(20,4) NOT NULL,
alert_ST varchar2(32) NOT NULL,
notice Number(20,4) NOT NULL,
notice_ST varchar2(32) NOT NULL,
other Number(20,4) NOT NULL,
other_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EgSysLogLevelTest ON EgSysLogLevelTest(MSMT_TIME);
ALTER TABLE EgSysLogLevelTest ADD constraint PK_EgSysLogLevelTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EgSysLogLevelTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogLevelTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
error_MIN Number(20,4) NOT NULL,
error_MAX Number(20,4) NOT NULL,
error_STCNT varchar2(32) NOT NULL,
emergency_MIN Number(20,4) NOT NULL,
emergency_MAX Number(20,4) NOT NULL,
emergency_STCNT varchar2(32) NOT NULL,
critical_MIN Number(20,4) NOT NULL,
critical_MAX Number(20,4) NOT NULL,
critical_STCNT varchar2(32) NOT NULL,
debug_MIN Number(20,4) NOT NULL,
debug_MAX Number(20,4) NOT NULL,
debug_STCNT varchar2(32) NOT NULL,
infomation_MIN Number(20,4) NOT NULL,
infomation_MAX Number(20,4) NOT NULL,
infomation_STCNT varchar2(32) NOT NULL,
warning_MIN Number(20,4) NOT NULL,
warning_MAX Number(20,4) NOT NULL,
warning_STCNT varchar2(32) NOT NULL,
alert_MIN Number(20,4) NOT NULL,
alert_MAX Number(20,4) NOT NULL,
alert_STCNT varchar2(32) NOT NULL,
notice_MIN Number(20,4) NOT NULL,
notice_MAX Number(20,4) NOT NULL,
notice_STCNT varchar2(32) NOT NULL,
other_MIN Number(20,4) NOT NULL,
other_MAX Number(20,4) NOT NULL,
other_STCNT varchar2(32) NOT NULL);

ALTER TABLE EgSysLogLevelTest_TREND ADD constraint PK_EgSysLogLevelTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EgSysLogLevelTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EgSysLogLevelTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
error_MIN VARCHAR2(256) NOT NULL,
error_MAX VARCHAR2(256) NOT NULL,
emergency_MIN VARCHAR2(256) NOT NULL,
emergency_MAX VARCHAR2(256) NOT NULL,
critical_MIN VARCHAR2(256) NOT NULL,
critical_MAX VARCHAR2(256) NOT NULL,
debug_MIN VARCHAR2(256) NOT NULL,
debug_MAX VARCHAR2(256) NOT NULL,
infomation_MIN VARCHAR2(256) NOT NULL,
infomation_MAX VARCHAR2(256) NOT NULL,
warning_MIN VARCHAR2(256) NOT NULL,
warning_MAX VARCHAR2(256) NOT NULL,
alert_MIN VARCHAR2(256) NOT NULL,
alert_MAX VARCHAR2(256) NOT NULL,
notice_MIN VARCHAR2(256) NOT NULL,
notice_MAX VARCHAR2(256) NOT NULL,
other_MIN VARCHAR2(256) NOT NULL,
other_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE EgSysLogLevelTest_THRESH ADD constraint PK_EgSysLogLevelTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EgSysLogLevelTest_THRESH ON EgSysLogLevelTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EgSysLogLevelTest ON EgSysLogLevelTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EgSysLogLevelTest ON EgSysLogLevelTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SPOUsrDtlsTest CASCADE CONSTRAINTS;
CREATE TABLE SPOUsrDtlsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Active_Usrs Number(20,4) NOT NULL,
Active_Usrs_ST varchar2(32) NOT NULL,
InActive_Usrs Number(20,4) NOT NULL,
InActive_Usrs_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOUsrDtlsTest ON SPOUsrDtlsTest(MSMT_TIME);
ALTER TABLE SPOUsrDtlsTest ADD constraint PK_SPOUsrDtlsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOUsrDtlsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOUsrDtlsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Active_Usrs_MIN Number(20,4) NOT NULL,
Active_Usrs_MAX Number(20,4) NOT NULL,
Active_Usrs_STCNT varchar2(32) NOT NULL,
InActive_Usrs_MIN Number(20,4) NOT NULL,
InActive_Usrs_MAX Number(20,4) NOT NULL,
InActive_Usrs_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOUsrDtlsTest_TREND ADD constraint PK_SPOUsrDtlsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOUsrDtlsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOUsrDtlsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Active_Usrs_MIN VARCHAR2(256) NOT NULL,
Active_Usrs_MAX VARCHAR2(256) NOT NULL,
InActive_Usrs_MIN VARCHAR2(256) NOT NULL,
InActive_Usrs_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOUsrDtlsTest_THRESH ADD constraint PK_SPOUsrDtlsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOUsrDtlsTest_THRESH ON SPOUsrDtlsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOUsrDtlsTest ON SPOUsrDtlsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOUsrDtlsTest ON SPOUsrDtlsTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE ODBSiteConnvtyTest CASCADE CONSTRAINTS;
CREATE TABLE ODBSiteConnvtyTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Web_availability Number(20,4) NOT NULL,
Web_availability_ST varchar2(32) NOT NULL,
Response_code Number(20,4) NOT NULL,
Response_code_ST varchar2(32) NOT NULL,
Response_time Number(20,4) NOT NULL,
Response_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBSiteConnvtyTest ON ODBSiteConnvtyTest(MSMT_TIME);
ALTER TABLE ODBSiteConnvtyTest ADD constraint PK_ODBSiteConnvtyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSiteConnvtyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBSiteConnvtyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Web_availability_MIN Number(20,4) NOT NULL,
Web_availability_MAX Number(20,4) NOT NULL,
Web_availability_STCNT varchar2(32) NOT NULL,
Response_code_MIN Number(20,4) NOT NULL,
Response_code_MAX Number(20,4) NOT NULL,
Response_code_STCNT varchar2(32) NOT NULL,
Response_time_MIN Number(20,4) NOT NULL,
Response_time_MAX Number(20,4) NOT NULL,
Response_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBSiteConnvtyTest_TREND ADD constraint PK_ODBSiteConnvtyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSiteConnvtyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBSiteConnvtyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Web_availability_MIN VARCHAR2(256) NOT NULL,
Web_availability_MAX VARCHAR2(256) NOT NULL,
Response_code_MIN VARCHAR2(256) NOT NULL,
Response_code_MAX VARCHAR2(256) NOT NULL,
Response_time_MIN VARCHAR2(256) NOT NULL,
Response_time_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBSiteConnvtyTest_THRESH ADD constraint PK_ODBSiteConnvtyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSiteConnvtyTest_THRESH ON ODBSiteConnvtyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSiteConnvtyTest ON ODBSiteConnvtyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSiteConnvtyTest ON ODBSiteConnvtyTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBFileActTest CASCADE CONSTRAINTS;
CREATE TABLE ODBFileActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
File_accesses Number(20,4) NOT NULL,
File_accesses_ST varchar2(32) NOT NULL,
File_check_ins Number(20,4) NOT NULL,
File_check_ins_ST varchar2(32) NOT NULL,
File_checkouts Number(20,4) NOT NULL,
File_checkouts_ST varchar2(32) NOT NULL,
File_copies Number(20,4) NOT NULL,
File_copies_ST varchar2(32) NOT NULL,
File_deletes Number(20,4) NOT NULL,
File_deletes_ST varchar2(32) NOT NULL,
File_deletes_frm_I_stage Number(20,4) NOT NULL,
File_deletes_frm_I_stage_ST varchar2(32) NOT NULL,
File_deletes_frm_II_stag Number(20,4) NOT NULL,
File_deletes_frm_II_stag_ST varchar2(32) NOT NULL,
File_checkout_discards Number(20,4) NOT NULL,
File_checkout_discards_ST varchar2(32) NOT NULL,
File_downloads Number(20,4) NOT NULL,
File_downloads_ST varchar2(32) NOT NULL,
File_modifications Number(20,4) NOT NULL,
File_modifications_ST varchar2(32) NOT NULL,
File_moves Number(20,4) NOT NULL,
File_moves_ST varchar2(32) NOT NULL,
File_renames Number(20,4) NOT NULL,
File_renames_ST varchar2(32) NOT NULL,
File_restores Number(20,4) NOT NULL,
File_restores_ST varchar2(32) NOT NULL,
File_uploads Number(20,4) NOT NULL,
File_uploads_ST varchar2(32) NOT NULL,
Page_views Number(20,4) NOT NULL,
Page_views_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBFileActTest ON ODBFileActTest(MSMT_TIME);
ALTER TABLE ODBFileActTest ADD constraint PK_ODBFileActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFileActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBFileActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
File_accesses_MIN Number(20,4) NOT NULL,
File_accesses_MAX Number(20,4) NOT NULL,
File_accesses_STCNT varchar2(32) NOT NULL,
File_check_ins_MIN Number(20,4) NOT NULL,
File_check_ins_MAX Number(20,4) NOT NULL,
File_check_ins_STCNT varchar2(32) NOT NULL,
File_checkouts_MIN Number(20,4) NOT NULL,
File_checkouts_MAX Number(20,4) NOT NULL,
File_checkouts_STCNT varchar2(32) NOT NULL,
File_copies_MIN Number(20,4) NOT NULL,
File_copies_MAX Number(20,4) NOT NULL,
File_copies_STCNT varchar2(32) NOT NULL,
File_deletes_MIN Number(20,4) NOT NULL,
File_deletes_MAX Number(20,4) NOT NULL,
File_deletes_STCNT varchar2(32) NOT NULL,
File_deletes_frm_I_stage_MIN Number(20,4) NOT NULL,
File_deletes_frm_I_stage_MAX Number(20,4) NOT NULL,
File_deletes_frm_I_stage_STCNT varchar2(32) NOT NULL,
File_deletes_frm_II_stag_MIN Number(20,4) NOT NULL,
File_deletes_frm_II_stag_MAX Number(20,4) NOT NULL,
File_deletes_frm_II_stag_STCNT varchar2(32) NOT NULL,
File_checkout_discards_MIN Number(20,4) NOT NULL,
File_checkout_discards_MAX Number(20,4) NOT NULL,
File_checkout_discards_STCNT varchar2(32) NOT NULL,
File_downloads_MIN Number(20,4) NOT NULL,
File_downloads_MAX Number(20,4) NOT NULL,
File_downloads_STCNT varchar2(32) NOT NULL,
File_modifications_MIN Number(20,4) NOT NULL,
File_modifications_MAX Number(20,4) NOT NULL,
File_modifications_STCNT varchar2(32) NOT NULL,
File_moves_MIN Number(20,4) NOT NULL,
File_moves_MAX Number(20,4) NOT NULL,
File_moves_STCNT varchar2(32) NOT NULL,
File_renames_MIN Number(20,4) NOT NULL,
File_renames_MAX Number(20,4) NOT NULL,
File_renames_STCNT varchar2(32) NOT NULL,
File_restores_MIN Number(20,4) NOT NULL,
File_restores_MAX Number(20,4) NOT NULL,
File_restores_STCNT varchar2(32) NOT NULL,
File_uploads_MIN Number(20,4) NOT NULL,
File_uploads_MAX Number(20,4) NOT NULL,
File_uploads_STCNT varchar2(32) NOT NULL,
Page_views_MIN Number(20,4) NOT NULL,
Page_views_MAX Number(20,4) NOT NULL,
Page_views_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBFileActTest_TREND ADD constraint PK_ODBFileActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFileActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBFileActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
File_accesses_MIN VARCHAR2(256) NOT NULL,
File_accesses_MAX VARCHAR2(256) NOT NULL,
File_check_ins_MIN VARCHAR2(256) NOT NULL,
File_check_ins_MAX VARCHAR2(256) NOT NULL,
File_checkouts_MIN VARCHAR2(256) NOT NULL,
File_checkouts_MAX VARCHAR2(256) NOT NULL,
File_copies_MIN VARCHAR2(256) NOT NULL,
File_copies_MAX VARCHAR2(256) NOT NULL,
File_deletes_MIN VARCHAR2(256) NOT NULL,
File_deletes_MAX VARCHAR2(256) NOT NULL,
File_deletes_frm_I_stage_MIN VARCHAR2(256) NOT NULL,
File_deletes_frm_I_stage_MAX VARCHAR2(256) NOT NULL,
File_deletes_frm_II_stag_MIN VARCHAR2(256) NOT NULL,
File_deletes_frm_II_stag_MAX VARCHAR2(256) NOT NULL,
File_checkout_discards_MIN VARCHAR2(256) NOT NULL,
File_checkout_discards_MAX VARCHAR2(256) NOT NULL,
File_downloads_MIN VARCHAR2(256) NOT NULL,
File_downloads_MAX VARCHAR2(256) NOT NULL,
File_modifications_MIN VARCHAR2(256) NOT NULL,
File_modifications_MAX VARCHAR2(256) NOT NULL,
File_moves_MIN VARCHAR2(256) NOT NULL,
File_moves_MAX VARCHAR2(256) NOT NULL,
File_renames_MIN VARCHAR2(256) NOT NULL,
File_renames_MAX VARCHAR2(256) NOT NULL,
File_restores_MIN VARCHAR2(256) NOT NULL,
File_restores_MAX VARCHAR2(256) NOT NULL,
File_uploads_MIN VARCHAR2(256) NOT NULL,
File_uploads_MAX VARCHAR2(256) NOT NULL,
Page_views_MIN VARCHAR2(256) NOT NULL,
Page_views_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBFileActTest_THRESH ADD constraint PK_ODBFileActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFileActTest_THRESH ON ODBFileActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFileActTest ON ODBFileActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFileActTest ON ODBFileActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBUsrsByServTest CASCADE CONSTRAINTS;
CREATE TABLE ODBUsrsByServTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Active_Usrs Number(20,4) NOT NULL,
Active_Usrs_ST varchar2(32) NOT NULL,
InActive_Usrs Number(20,4) NOT NULL,
InActive_Usrs_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBUsrsByServTest ON ODBUsrsByServTest(MSMT_TIME);
ALTER TABLE ODBUsrsByServTest ADD constraint PK_ODBUsrsByServTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBUsrsByServTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBUsrsByServTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Active_Usrs_MIN Number(20,4) NOT NULL,
Active_Usrs_MAX Number(20,4) NOT NULL,
Active_Usrs_STCNT varchar2(32) NOT NULL,
InActive_Usrs_MIN Number(20,4) NOT NULL,
InActive_Usrs_MAX Number(20,4) NOT NULL,
InActive_Usrs_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBUsrsByServTest_TREND ADD constraint PK_ODBUsrsByServTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBUsrsByServTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBUsrsByServTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Active_Usrs_MIN VARCHAR2(256) NOT NULL,
Active_Usrs_MAX VARCHAR2(256) NOT NULL,
InActive_Usrs_MIN VARCHAR2(256) NOT NULL,
InActive_Usrs_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBUsrsByServTest_THRESH ADD constraint PK_ODBUsrsByServTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBUsrsByServTest_THRESH ON ODBUsrsByServTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBUsrsByServTest ON ODBUsrsByServTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBUsrsByServTest ON ODBUsrsByServTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBFileOperatnsTest CASCADE CONSTRAINTS;
CREATE TABLE ODBFileOperatnsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
File_upload_status Number(20,4) NOT NULL,
File_upload_status_ST varchar2(32) NOT NULL,
File_upload_time Number(20,4) NOT NULL,
File_upload_time_ST varchar2(32) NOT NULL,
File_download_status Number(20,4) NOT NULL,
File_download_status_ST varchar2(32) NOT NULL,
File_download_time Number(20,4) NOT NULL,
File_download_time_ST varchar2(32) NOT NULL,
File_deletion_status Number(20,4) NOT NULL,
File_deletion_status_ST varchar2(32) NOT NULL,
File_deletion_time Number(20,4) NOT NULL,
File_deletion_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBFileOperatnsTest ON ODBFileOperatnsTest(MSMT_TIME);
ALTER TABLE ODBFileOperatnsTest ADD constraint PK_ODBFileOperatnsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFileOperatnsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBFileOperatnsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
File_upload_status_MIN Number(20,4) NOT NULL,
File_upload_status_MAX Number(20,4) NOT NULL,
File_upload_status_STCNT varchar2(32) NOT NULL,
File_upload_time_MIN Number(20,4) NOT NULL,
File_upload_time_MAX Number(20,4) NOT NULL,
File_upload_time_STCNT varchar2(32) NOT NULL,
File_download_status_MIN Number(20,4) NOT NULL,
File_download_status_MAX Number(20,4) NOT NULL,
File_download_status_STCNT varchar2(32) NOT NULL,
File_download_time_MIN Number(20,4) NOT NULL,
File_download_time_MAX Number(20,4) NOT NULL,
File_download_time_STCNT varchar2(32) NOT NULL,
File_deletion_status_MIN Number(20,4) NOT NULL,
File_deletion_status_MAX Number(20,4) NOT NULL,
File_deletion_status_STCNT varchar2(32) NOT NULL,
File_deletion_time_MIN Number(20,4) NOT NULL,
File_deletion_time_MAX Number(20,4) NOT NULL,
File_deletion_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBFileOperatnsTest_TREND ADD constraint PK_ODBFileOperatnsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFileOperatnsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBFileOperatnsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
File_upload_status_MIN VARCHAR2(256) NOT NULL,
File_upload_status_MAX VARCHAR2(256) NOT NULL,
File_upload_time_MIN VARCHAR2(256) NOT NULL,
File_upload_time_MAX VARCHAR2(256) NOT NULL,
File_download_status_MIN VARCHAR2(256) NOT NULL,
File_download_status_MAX VARCHAR2(256) NOT NULL,
File_download_time_MIN VARCHAR2(256) NOT NULL,
File_download_time_MAX VARCHAR2(256) NOT NULL,
File_deletion_status_MIN VARCHAR2(256) NOT NULL,
File_deletion_status_MAX VARCHAR2(256) NOT NULL,
File_deletion_time_MIN VARCHAR2(256) NOT NULL,
File_deletion_time_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBFileOperatnsTest_THRESH ADD constraint PK_ODBFileOperatnsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFileOperatnsTest_THRESH ON ODBFileOperatnsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFileOperatnsTest ON ODBFileOperatnsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFileOperatnsTest ON ODBFileOperatnsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBSyncActTest CASCADE CONSTRAINTS;
CREATE TABLE ODBSyncActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
File_sync_permits Number(20,4) NOT NULL,
File_sync_permits_ST varchar2(32) NOT NULL,
File_sync_blocks Number(20,4) NOT NULL,
File_sync_blocks_ST varchar2(32) NOT NULL,
File_downloads Number(20,4) NOT NULL,
File_downloads_ST varchar2(32) NOT NULL,
File_changes_downloads Number(20,4) NOT NULL,
File_changes_downloads_ST varchar2(32) NOT NULL,
File_uploads Number(20,4) NOT NULL,
File_uploads_ST varchar2(32) NOT NULL,
File_changes_uploads Number(20,4) NOT NULL,
File_changes_uploads_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBSyncActTest ON ODBSyncActTest(MSMT_TIME);
ALTER TABLE ODBSyncActTest ADD constraint PK_ODBSyncActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSyncActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBSyncActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
File_sync_permits_MIN Number(20,4) NOT NULL,
File_sync_permits_MAX Number(20,4) NOT NULL,
File_sync_permits_STCNT varchar2(32) NOT NULL,
File_sync_blocks_MIN Number(20,4) NOT NULL,
File_sync_blocks_MAX Number(20,4) NOT NULL,
File_sync_blocks_STCNT varchar2(32) NOT NULL,
File_downloads_MIN Number(20,4) NOT NULL,
File_downloads_MAX Number(20,4) NOT NULL,
File_downloads_STCNT varchar2(32) NOT NULL,
File_changes_downloads_MIN Number(20,4) NOT NULL,
File_changes_downloads_MAX Number(20,4) NOT NULL,
File_changes_downloads_STCNT varchar2(32) NOT NULL,
File_uploads_MIN Number(20,4) NOT NULL,
File_uploads_MAX Number(20,4) NOT NULL,
File_uploads_STCNT varchar2(32) NOT NULL,
File_changes_uploads_MIN Number(20,4) NOT NULL,
File_changes_uploads_MAX Number(20,4) NOT NULL,
File_changes_uploads_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBSyncActTest_TREND ADD constraint PK_ODBSyncActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSyncActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBSyncActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
File_sync_permits_MIN VARCHAR2(256) NOT NULL,
File_sync_permits_MAX VARCHAR2(256) NOT NULL,
File_sync_blocks_MIN VARCHAR2(256) NOT NULL,
File_sync_blocks_MAX VARCHAR2(256) NOT NULL,
File_downloads_MIN VARCHAR2(256) NOT NULL,
File_downloads_MAX VARCHAR2(256) NOT NULL,
File_changes_downloads_MIN VARCHAR2(256) NOT NULL,
File_changes_downloads_MAX VARCHAR2(256) NOT NULL,
File_uploads_MIN VARCHAR2(256) NOT NULL,
File_uploads_MAX VARCHAR2(256) NOT NULL,
File_changes_uploads_MIN VARCHAR2(256) NOT NULL,
File_changes_uploads_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBSyncActTest_THRESH ADD constraint PK_ODBSyncActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSyncActTest_THRESH ON ODBSyncActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSyncActTest ON ODBSyncActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSyncActTest ON ODBSyncActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBSrvcHlhTest CASCADE CONSTRAINTS;
CREATE TABLE ODBSrvcHlhTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Service_incidents Number(20,4) NOT NULL,
Service_incidents_ST varchar2(32) NOT NULL,
Maintenance_events Number(20,4) NOT NULL,
Maintenance_events_ST varchar2(32) NOT NULL,
Service_Status Number(20,4) NOT NULL,
Service_Status_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBSrvcHlhTest ON ODBSrvcHlhTest(MSMT_TIME);
ALTER TABLE ODBSrvcHlhTest ADD constraint PK_ODBSrvcHlhTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSrvcHlhTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBSrvcHlhTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Service_incidents_MIN Number(20,4) NOT NULL,
Service_incidents_MAX Number(20,4) NOT NULL,
Service_incidents_STCNT varchar2(32) NOT NULL,
Maintenance_events_MIN Number(20,4) NOT NULL,
Maintenance_events_MAX Number(20,4) NOT NULL,
Maintenance_events_STCNT varchar2(32) NOT NULL,
Service_Status_MIN Number(20,4) NOT NULL,
Service_Status_MAX Number(20,4) NOT NULL,
Service_Status_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBSrvcHlhTest_TREND ADD constraint PK_ODBSrvcHlhTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSrvcHlhTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBSrvcHlhTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Service_incidents_MIN VARCHAR2(256) NOT NULL,
Service_incidents_MAX VARCHAR2(256) NOT NULL,
Maintenance_events_MIN VARCHAR2(256) NOT NULL,
Maintenance_events_MAX VARCHAR2(256) NOT NULL,
Service_Status_MIN VARCHAR2(256) NOT NULL,
Service_Status_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBSrvcHlhTest_THRESH ADD constraint PK_ODBSrvcHlhTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSrvcHlhTest_THRESH ON ODBSrvcHlhTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSrvcHlhTest ON ODBSrvcHlhTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSrvcHlhTest ON ODBSrvcHlhTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBFileInteractnTest CASCADE CONSTRAINTS;
CREATE TABLE ODBFileInteractnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
File_vieworedit Number(20,4) NOT NULL,
File_vieworedit_ST varchar2(32) NOT NULL,
File_synced Number(20,4) NOT NULL,
File_synced_ST varchar2(32) NOT NULL,
File_shared_intern Number(20,4) NOT NULL,
File_shared_intern_ST varchar2(32) NOT NULL,
File_shared_extern Number(20,4) NOT NULL,
File_shared_extern_ST varchar2(32) NOT NULL,
Usr_vieworedit Number(20,4) NOT NULL,
Usr_vieworedit_ST varchar2(32) NOT NULL,
Usr_synced Number(20,4) NOT NULL,
Usr_synced_ST varchar2(32) NOT NULL,
Usr_shared_intern Number(20,4) NOT NULL,
Usr_shared_intern_ST varchar2(32) NOT NULL,
Usr_shared_extern Number(20,4) NOT NULL,
Usr_shared_extern_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBFileInteractnTest ON ODBFileInteractnTest(MSMT_TIME);
ALTER TABLE ODBFileInteractnTest ADD constraint PK_ODBFileInteractnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFileInteractnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBFileInteractnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
File_vieworedit_MIN Number(20,4) NOT NULL,
File_vieworedit_MAX Number(20,4) NOT NULL,
File_vieworedit_STCNT varchar2(32) NOT NULL,
File_synced_MIN Number(20,4) NOT NULL,
File_synced_MAX Number(20,4) NOT NULL,
File_synced_STCNT varchar2(32) NOT NULL,
File_shared_intern_MIN Number(20,4) NOT NULL,
File_shared_intern_MAX Number(20,4) NOT NULL,
File_shared_intern_STCNT varchar2(32) NOT NULL,
File_shared_extern_MIN Number(20,4) NOT NULL,
File_shared_extern_MAX Number(20,4) NOT NULL,
File_shared_extern_STCNT varchar2(32) NOT NULL,
Usr_vieworedit_MIN Number(20,4) NOT NULL,
Usr_vieworedit_MAX Number(20,4) NOT NULL,
Usr_vieworedit_STCNT varchar2(32) NOT NULL,
Usr_synced_MIN Number(20,4) NOT NULL,
Usr_synced_MAX Number(20,4) NOT NULL,
Usr_synced_STCNT varchar2(32) NOT NULL,
Usr_shared_intern_MIN Number(20,4) NOT NULL,
Usr_shared_intern_MAX Number(20,4) NOT NULL,
Usr_shared_intern_STCNT varchar2(32) NOT NULL,
Usr_shared_extern_MIN Number(20,4) NOT NULL,
Usr_shared_extern_MAX Number(20,4) NOT NULL,
Usr_shared_extern_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBFileInteractnTest_TREND ADD constraint PK_ODBFileInteractnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFileInteractnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBFileInteractnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
File_vieworedit_MIN VARCHAR2(256) NOT NULL,
File_vieworedit_MAX VARCHAR2(256) NOT NULL,
File_synced_MIN VARCHAR2(256) NOT NULL,
File_synced_MAX VARCHAR2(256) NOT NULL,
File_shared_intern_MIN VARCHAR2(256) NOT NULL,
File_shared_intern_MAX VARCHAR2(256) NOT NULL,
File_shared_extern_MIN VARCHAR2(256) NOT NULL,
File_shared_extern_MAX VARCHAR2(256) NOT NULL,
Usr_vieworedit_MIN VARCHAR2(256) NOT NULL,
Usr_vieworedit_MAX VARCHAR2(256) NOT NULL,
Usr_synced_MIN VARCHAR2(256) NOT NULL,
Usr_synced_MAX VARCHAR2(256) NOT NULL,
Usr_shared_intern_MIN VARCHAR2(256) NOT NULL,
Usr_shared_intern_MAX VARCHAR2(256) NOT NULL,
Usr_shared_extern_MIN VARCHAR2(256) NOT NULL,
Usr_shared_extern_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBFileInteractnTest_THRESH ADD constraint PK_ODBFileInteractnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFilIntractnTst_THRESH ON ODBFileInteractnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFileInteractnTest ON ODBFileInteractnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFileInteractnTest ON ODBFileInteractnTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBSharngActTest CASCADE CONSTRAINTS;
CREATE TABLE ODBSharngActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Access_req_acceptance Number(20,4) NOT NULL,
Access_req_acceptance_ST varchar2(32) NOT NULL,
Sharng_invitatn_acceptnc Number(20,4) NOT NULL,
Sharng_invitatn_acceptnc_ST varchar2(32) NOT NULL,
Sharng_invitatn_blocked Number(20,4) NOT NULL,
Sharng_invitatn_blocked_ST varchar2(32) NOT NULL,
Company_link_creations Number(20,4) NOT NULL,
Company_link_creations_ST varchar2(32) NOT NULL,
Access_request_creations Number(20,4) NOT NULL,
Access_request_creations_ST varchar2(32) NOT NULL,
Anonymous_link_creations Number(20,4) NOT NULL,
Anonymous_link_creations_ST varchar2(32) NOT NULL,
Sharng_invitatn_creation Number(20,4) NOT NULL,
Sharng_invitatn_creation_ST varchar2(32) NOT NULL,
Access_request_denials Number(20,4) NOT NULL,
Access_request_denials_ST varchar2(32) NOT NULL,
Company_link_removals Number(20,4) NOT NULL,
Company_link_removals_ST varchar2(32) NOT NULL,
Anonymous_link_removals Number(20,4) NOT NULL,
Anonymous_link_removals_ST varchar2(32) NOT NULL,
File_Folder_Site_share Number(20,4) NOT NULL,
File_Folder_Site_share_ST varchar2(32) NOT NULL,
Anonymous_link_updates Number(20,4) NOT NULL,
Anonymous_link_updates_ST varchar2(32) NOT NULL,
Anonymous_link_usage Number(20,4) NOT NULL,
Anonymous_link_usage_ST varchar2(32) NOT NULL,
Sharing_revokes Number(20,4) NOT NULL,
Sharing_revokes_ST varchar2(32) NOT NULL,
Company_link_usage Number(20,4) NOT NULL,
Company_link_usage_ST varchar2(32) NOT NULL,
Sharng_invitatn_withdrw Number(20,4) NOT NULL,
Sharng_invitatn_withdrw_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBSharngActTest ON ODBSharngActTest(MSMT_TIME);
ALTER TABLE ODBSharngActTest ADD constraint PK_ODBSharngActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSharngActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBSharngActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Access_req_acceptance_MIN Number(20,4) NOT NULL,
Access_req_acceptance_MAX Number(20,4) NOT NULL,
Access_req_acceptance_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_acceptnc_MIN Number(20,4) NOT NULL,
Sharng_invitatn_acceptnc_MAX Number(20,4) NOT NULL,
Sharng_invitatn_acceptnc_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_blocked_MIN Number(20,4) NOT NULL,
Sharng_invitatn_blocked_MAX Number(20,4) NOT NULL,
Sharng_invitatn_blocked_STCNT varchar2(32) NOT NULL,
Company_link_creations_MIN Number(20,4) NOT NULL,
Company_link_creations_MAX Number(20,4) NOT NULL,
Company_link_creations_STCNT varchar2(32) NOT NULL,
Access_request_creations_MIN Number(20,4) NOT NULL,
Access_request_creations_MAX Number(20,4) NOT NULL,
Access_request_creations_STCNT varchar2(32) NOT NULL,
Anonymous_link_creations_MIN Number(20,4) NOT NULL,
Anonymous_link_creations_MAX Number(20,4) NOT NULL,
Anonymous_link_creations_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_creation_MIN Number(20,4) NOT NULL,
Sharng_invitatn_creation_MAX Number(20,4) NOT NULL,
Sharng_invitatn_creation_STCNT varchar2(32) NOT NULL,
Access_request_denials_MIN Number(20,4) NOT NULL,
Access_request_denials_MAX Number(20,4) NOT NULL,
Access_request_denials_STCNT varchar2(32) NOT NULL,
Company_link_removals_MIN Number(20,4) NOT NULL,
Company_link_removals_MAX Number(20,4) NOT NULL,
Company_link_removals_STCNT varchar2(32) NOT NULL,
Anonymous_link_removals_MIN Number(20,4) NOT NULL,
Anonymous_link_removals_MAX Number(20,4) NOT NULL,
Anonymous_link_removals_STCNT varchar2(32) NOT NULL,
File_Folder_Site_share_MIN Number(20,4) NOT NULL,
File_Folder_Site_share_MAX Number(20,4) NOT NULL,
File_Folder_Site_share_STCNT varchar2(32) NOT NULL,
Anonymous_link_updates_MIN Number(20,4) NOT NULL,
Anonymous_link_updates_MAX Number(20,4) NOT NULL,
Anonymous_link_updates_STCNT varchar2(32) NOT NULL,
Anonymous_link_usage_MIN Number(20,4) NOT NULL,
Anonymous_link_usage_MAX Number(20,4) NOT NULL,
Anonymous_link_usage_STCNT varchar2(32) NOT NULL,
Sharing_revokes_MIN Number(20,4) NOT NULL,
Sharing_revokes_MAX Number(20,4) NOT NULL,
Sharing_revokes_STCNT varchar2(32) NOT NULL,
Company_link_usage_MIN Number(20,4) NOT NULL,
Company_link_usage_MAX Number(20,4) NOT NULL,
Company_link_usage_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_withdrw_MIN Number(20,4) NOT NULL,
Sharng_invitatn_withdrw_MAX Number(20,4) NOT NULL,
Sharng_invitatn_withdrw_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBSharngActTest_TREND ADD constraint PK_ODBSharngActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSharngActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBSharngActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
Access_req_acceptance_MIN VARCHAR2(256) NOT NULL,
Access_req_acceptance_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_acceptnc_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_acceptnc_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_blocked_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_blocked_MAX VARCHAR2(256) NOT NULL,
Company_link_creations_MIN VARCHAR2(256) NOT NULL,
Company_link_creations_MAX VARCHAR2(256) NOT NULL,
Access_request_creations_MIN VARCHAR2(256) NOT NULL,
Access_request_creations_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_creations_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_creations_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_creation_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_creation_MAX VARCHAR2(256) NOT NULL,
Access_request_denials_MIN VARCHAR2(256) NOT NULL,
Access_request_denials_MAX VARCHAR2(256) NOT NULL,
Company_link_removals_MIN VARCHAR2(256) NOT NULL,
Company_link_removals_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_removals_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_removals_MAX VARCHAR2(256) NOT NULL,
File_Folder_Site_share_MIN VARCHAR2(256) NOT NULL,
File_Folder_Site_share_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_updates_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_updates_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_usage_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_usage_MAX VARCHAR2(256) NOT NULL,
Sharing_revokes_MIN VARCHAR2(256) NOT NULL,
Sharing_revokes_MAX VARCHAR2(256) NOT NULL,
Company_link_usage_MIN VARCHAR2(256) NOT NULL,
Company_link_usage_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_withdrw_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_withdrw_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBSharngActTest_THRESH ADD constraint PK_ODBSharngActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSharngActTest_THRESH ON ODBSharngActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSharngActTest ON ODBSharngActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSharngActTest ON ODBSharngActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBSAdminActTest CASCADE CONSTRAINTS;
CREATE TABLE ODBSAdminActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Usr_agent_exmpt_addition Number(20,4) NOT NULL,
Usr_agent_exmpt_addition_ST varchar2(32) NOT NULL,
Usr_agent_exmpt_modifitn Number(20,4) NOT NULL,
Usr_agent_exmpt_modifitn_ST varchar2(32) NOT NULL,
Sit_collectn_admin_addtn Number(20,4) NOT NULL,
Sit_collectn_admin_addtn_ST varchar2(32) NOT NULL,
User_group_additions Number(20,4) NOT NULL,
User_group_additions_ST varchar2(32) NOT NULL,
Add_usergroup_permits Number(20,4) NOT NULL,
Add_usergroup_permits_ST varchar2(32) NOT NULL,
Sharing_policy_modifctn Number(20,4) NOT NULL,
Sharing_policy_modifctn_ST varchar2(32) NOT NULL,
Group_additions Number(20,4) NOT NULL,
Group_additions_ST varchar2(32) NOT NULL,
Send_to_conn_creation Number(20,4) NOT NULL,
Send_to_conn_creation_ST varchar2(32) NOT NULL,
Site_collection_creation Number(20,4) NOT NULL,
Site_collection_creation_ST varchar2(32) NOT NULL,
Group_deletes Number(20,4) NOT NULL,
Group_deletes_ST varchar2(32) NOT NULL,
Send_to_conn_deletes Number(20,4) NOT NULL,
Send_to_conn_deletes_ST varchar2(32) NOT NULL,
Site_deletes Number(20,4) NOT NULL,
Site_deletes_ST varchar2(32) NOT NULL,
Document_preview_permits Number(20,4) NOT NULL,
Document_preview_permits_ST varchar2(32) NOT NULL,
Workflow_task_contnt Number(20,4) NOT NULL,
Workflow_task_contnt_ST varchar2(32) NOT NULL,
Office_ondemand_permits Number(20,4) NOT NULL,
Office_ondemand_permits_ST varchar2(32) NOT NULL,
News_feed_permits Number(20,4) NOT NULL,
News_feed_permits_ST varchar2(32) NOT NULL,
Site_permissn_modifictn Number(20,4) NOT NULL,
Site_permissn_modifictn_ST varchar2(32) NOT NULL,
Removals_from_group Number(20,4) NOT NULL,
Removals_from_group_ST varchar2(32) NOT NULL,
Site_renames Number(20,4) NOT NULL,
Site_renames_ST varchar2(32) NOT NULL,
Site_admin_requests Number(20,4) NOT NULL,
Site_admin_requests_ST varchar2(32) NOT NULL,
Host_site_changes Number(20,4) NOT NULL,
Host_site_changes_ST varchar2(32) NOT NULL,
Group_settings_changes Number(20,4) NOT NULL,
Group_settings_changes_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBSAdminActTest ON ODBSAdminActTest(MSMT_TIME);
ALTER TABLE ODBSAdminActTest ADD constraint PK_ODBSAdminActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSAdminActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBSAdminActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Usr_agent_exmpt_addition_MIN Number(20,4) NOT NULL,
Usr_agent_exmpt_addition_MAX Number(20,4) NOT NULL,
Usr_agent_exmpt_addition_STCNT varchar2(32) NOT NULL,
Usr_agent_exmpt_modifitn_MIN Number(20,4) NOT NULL,
Usr_agent_exmpt_modifitn_MAX Number(20,4) NOT NULL,
Usr_agent_exmpt_modifitn_STCNT varchar2(32) NOT NULL,
Sit_collectn_admin_addtn_MIN Number(20,4) NOT NULL,
Sit_collectn_admin_addtn_MAX Number(20,4) NOT NULL,
Sit_collectn_admin_addtn_STCNT varchar2(32) NOT NULL,
User_group_additions_MIN Number(20,4) NOT NULL,
User_group_additions_MAX Number(20,4) NOT NULL,
User_group_additions_STCNT varchar2(32) NOT NULL,
Add_usergroup_permits_MIN Number(20,4) NOT NULL,
Add_usergroup_permits_MAX Number(20,4) NOT NULL,
Add_usergroup_permits_STCNT varchar2(32) NOT NULL,
Sharing_policy_modifctn_MIN Number(20,4) NOT NULL,
Sharing_policy_modifctn_MAX Number(20,4) NOT NULL,
Sharing_policy_modifctn_STCNT varchar2(32) NOT NULL,
Group_additions_MIN Number(20,4) NOT NULL,
Group_additions_MAX Number(20,4) NOT NULL,
Group_additions_STCNT varchar2(32) NOT NULL,
Send_to_conn_creation_MIN Number(20,4) NOT NULL,
Send_to_conn_creation_MAX Number(20,4) NOT NULL,
Send_to_conn_creation_STCNT varchar2(32) NOT NULL,
Site_collection_creation_MIN Number(20,4) NOT NULL,
Site_collection_creation_MAX Number(20,4) NOT NULL,
Site_collection_creation_STCNT varchar2(32) NOT NULL,
Group_deletes_MIN Number(20,4) NOT NULL,
Group_deletes_MAX Number(20,4) NOT NULL,
Group_deletes_STCNT varchar2(32) NOT NULL,
Send_to_conn_deletes_MIN Number(20,4) NOT NULL,
Send_to_conn_deletes_MAX Number(20,4) NOT NULL,
Send_to_conn_deletes_STCNT varchar2(32) NOT NULL,
Site_deletes_MIN Number(20,4) NOT NULL,
Site_deletes_MAX Number(20,4) NOT NULL,
Site_deletes_STCNT varchar2(32) NOT NULL,
Document_preview_permits_MIN Number(20,4) NOT NULL,
Document_preview_permits_MAX Number(20,4) NOT NULL,
Document_preview_permits_STCNT varchar2(32) NOT NULL,
Workflow_task_contnt_MIN Number(20,4) NOT NULL,
Workflow_task_contnt_MAX Number(20,4) NOT NULL,
Workflow_task_contnt_STCNT varchar2(32) NOT NULL,
Office_ondemand_permits_MIN Number(20,4) NOT NULL,
Office_ondemand_permits_MAX Number(20,4) NOT NULL,
Office_ondemand_permits_STCNT varchar2(32) NOT NULL,
News_feed_permits_MIN Number(20,4) NOT NULL,
News_feed_permits_MAX Number(20,4) NOT NULL,
News_feed_permits_STCNT varchar2(32) NOT NULL,
Site_permissn_modifictn_MIN Number(20,4) NOT NULL,
Site_permissn_modifictn_MAX Number(20,4) NOT NULL,
Site_permissn_modifictn_STCNT varchar2(32) NOT NULL,
Removals_from_group_MIN Number(20,4) NOT NULL,
Removals_from_group_MAX Number(20,4) NOT NULL,
Removals_from_group_STCNT varchar2(32) NOT NULL,
Site_renames_MIN Number(20,4) NOT NULL,
Site_renames_MAX Number(20,4) NOT NULL,
Site_renames_STCNT varchar2(32) NOT NULL,
Site_admin_requests_MIN Number(20,4) NOT NULL,
Site_admin_requests_MAX Number(20,4) NOT NULL,
Site_admin_requests_STCNT varchar2(32) NOT NULL,
Host_site_changes_MIN Number(20,4) NOT NULL,
Host_site_changes_MAX Number(20,4) NOT NULL,
Host_site_changes_STCNT varchar2(32) NOT NULL,
Group_settings_changes_MIN Number(20,4) NOT NULL,
Group_settings_changes_MAX Number(20,4) NOT NULL,
Group_settings_changes_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBSAdminActTest_TREND ADD constraint PK_ODBSAdminActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSAdminActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBSAdminActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_addition_MIN VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_addition_MAX VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_modifitn_MIN VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_modifitn_MAX VARCHAR2(256) NOT NULL,
Sit_collectn_admin_addtn_MIN VARCHAR2(256) NOT NULL,
Sit_collectn_admin_addtn_MAX VARCHAR2(256) NOT NULL,
User_group_additions_MIN VARCHAR2(256) NOT NULL,
User_group_additions_MAX VARCHAR2(256) NOT NULL,
Add_usergroup_permits_MIN VARCHAR2(256) NOT NULL,
Add_usergroup_permits_MAX VARCHAR2(256) NOT NULL,
Sharing_policy_modifctn_MIN VARCHAR2(256) NOT NULL,
Sharing_policy_modifctn_MAX VARCHAR2(256) NOT NULL,
Group_additions_MIN VARCHAR2(256) NOT NULL,
Group_additions_MAX VARCHAR2(256) NOT NULL,
Send_to_conn_creation_MIN VARCHAR2(256) NOT NULL,
Send_to_conn_creation_MAX VARCHAR2(256) NOT NULL,
Site_collection_creation_MIN VARCHAR2(256) NOT NULL,
Site_collection_creation_MAX VARCHAR2(256) NOT NULL,
Group_deletes_MIN VARCHAR2(256) NOT NULL,
Group_deletes_MAX VARCHAR2(256) NOT NULL,
Send_to_conn_deletes_MIN VARCHAR2(256) NOT NULL,
Send_to_conn_deletes_MAX VARCHAR2(256) NOT NULL,
Site_deletes_MIN VARCHAR2(256) NOT NULL,
Site_deletes_MAX VARCHAR2(256) NOT NULL,
Document_preview_permits_MIN VARCHAR2(256) NOT NULL,
Document_preview_permits_MAX VARCHAR2(256) NOT NULL,
Workflow_task_contnt_MIN VARCHAR2(256) NOT NULL,
Workflow_task_contnt_MAX VARCHAR2(256) NOT NULL,
Office_ondemand_permits_MIN VARCHAR2(256) NOT NULL,
Office_ondemand_permits_MAX VARCHAR2(256) NOT NULL,
News_feed_permits_MIN VARCHAR2(256) NOT NULL,
News_feed_permits_MAX VARCHAR2(256) NOT NULL,
Site_permissn_modifictn_MIN VARCHAR2(256) NOT NULL,
Site_permissn_modifictn_MAX VARCHAR2(256) NOT NULL,
Removals_from_group_MIN VARCHAR2(256) NOT NULL,
Removals_from_group_MAX VARCHAR2(256) NOT NULL,
Site_renames_MIN VARCHAR2(256) NOT NULL,
Site_renames_MAX VARCHAR2(256) NOT NULL,
Site_admin_requests_MIN VARCHAR2(256) NOT NULL,
Site_admin_requests_MAX VARCHAR2(256) NOT NULL,
Host_site_changes_MIN VARCHAR2(256) NOT NULL,
Host_site_changes_MAX VARCHAR2(256) NOT NULL,
Group_settings_changes_MIN VARCHAR2(256) NOT NULL,
Group_settings_changes_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBSAdminActTest_THRESH ADD constraint PK_ODBSAdminActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSAdminActTest_THRESH ON ODBSAdminActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSAdminActTest ON ODBSAdminActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSAdminActTest ON ODBSAdminActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBMsgCenTest CASCADE CONSTRAINTS;
CREATE TABLE ODBMsgCenTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBMsgCenTest ON ODBMsgCenTest(MSMT_TIME);
ALTER TABLE ODBMsgCenTest ADD constraint PK_ODBMsgCenTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBMsgCenTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBMsgCenTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBMsgCenTest_TREND ADD constraint PK_ODBMsgCenTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBMsgCenTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBMsgCenTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MsgCenterCommunication_MIN VARCHAR2(256) NOT NULL,
MsgCenterCommunication_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBMsgCenTest_THRESH ADD constraint PK_ODBMsgCenTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBMsgCenTest_THRESH ON ODBMsgCenTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBMsgCenTest ON ODBMsgCenTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBMsgCenTest ON ODBMsgCenTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBFolderActTest CASCADE CONSTRAINTS;
CREATE TABLE ODBFolderActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Folder_copies Number(20,4) NOT NULL,
Folder_copies_ST varchar2(32) NOT NULL,
Folder_creations Number(20,4) NOT NULL,
Folder_creations_ST varchar2(32) NOT NULL,
Folder_deletions Number(20,4) NOT NULL,
Folder_deletions_ST varchar2(32) NOT NULL,
Folder_deletions_I_bin Number(20,4) NOT NULL,
Folder_deletions_I_bin_ST varchar2(32) NOT NULL,
Folder_deletions_II_bin Number(20,4) NOT NULL,
Folder_deletions_II_bin_ST varchar2(32) NOT NULL,
Folder_modifications Number(20,4) NOT NULL,
Folder_modifications_ST varchar2(32) NOT NULL,
Folder_moves Number(20,4) NOT NULL,
Folder_moves_ST varchar2(32) NOT NULL,
Folder_renames Number(20,4) NOT NULL,
Folder_renames_ST varchar2(32) NOT NULL,
Folder_restores Number(20,4) NOT NULL,
Folder_restores_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBFolderActTest ON ODBFolderActTest(MSMT_TIME);
ALTER TABLE ODBFolderActTest ADD constraint PK_ODBFolderActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFolderActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBFolderActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Folder_copies_MIN Number(20,4) NOT NULL,
Folder_copies_MAX Number(20,4) NOT NULL,
Folder_copies_STCNT varchar2(32) NOT NULL,
Folder_creations_MIN Number(20,4) NOT NULL,
Folder_creations_MAX Number(20,4) NOT NULL,
Folder_creations_STCNT varchar2(32) NOT NULL,
Folder_deletions_MIN Number(20,4) NOT NULL,
Folder_deletions_MAX Number(20,4) NOT NULL,
Folder_deletions_STCNT varchar2(32) NOT NULL,
Folder_deletions_I_bin_MIN Number(20,4) NOT NULL,
Folder_deletions_I_bin_MAX Number(20,4) NOT NULL,
Folder_deletions_I_bin_STCNT varchar2(32) NOT NULL,
Folder_deletions_II_bin_MIN Number(20,4) NOT NULL,
Folder_deletions_II_bin_MAX Number(20,4) NOT NULL,
Folder_deletions_II_bin_STCNT varchar2(32) NOT NULL,
Folder_modifications_MIN Number(20,4) NOT NULL,
Folder_modifications_MAX Number(20,4) NOT NULL,
Folder_modifications_STCNT varchar2(32) NOT NULL,
Folder_moves_MIN Number(20,4) NOT NULL,
Folder_moves_MAX Number(20,4) NOT NULL,
Folder_moves_STCNT varchar2(32) NOT NULL,
Folder_renames_MIN Number(20,4) NOT NULL,
Folder_renames_MAX Number(20,4) NOT NULL,
Folder_renames_STCNT varchar2(32) NOT NULL,
Folder_restores_MIN Number(20,4) NOT NULL,
Folder_restores_MAX Number(20,4) NOT NULL,
Folder_restores_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBFolderActTest_TREND ADD constraint PK_ODBFolderActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFolderActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBFolderActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
Folder_copies_MIN VARCHAR2(256) NOT NULL,
Folder_copies_MAX VARCHAR2(256) NOT NULL,
Folder_creations_MIN VARCHAR2(256) NOT NULL,
Folder_creations_MAX VARCHAR2(256) NOT NULL,
Folder_deletions_MIN VARCHAR2(256) NOT NULL,
Folder_deletions_MAX VARCHAR2(256) NOT NULL,
Folder_deletions_I_bin_MIN VARCHAR2(256) NOT NULL,
Folder_deletions_I_bin_MAX VARCHAR2(256) NOT NULL,
Folder_deletions_II_bin_MIN VARCHAR2(256) NOT NULL,
Folder_deletions_II_bin_MAX VARCHAR2(256) NOT NULL,
Folder_modifications_MIN VARCHAR2(256) NOT NULL,
Folder_modifications_MAX VARCHAR2(256) NOT NULL,
Folder_moves_MIN VARCHAR2(256) NOT NULL,
Folder_moves_MAX VARCHAR2(256) NOT NULL,
Folder_renames_MIN VARCHAR2(256) NOT NULL,
Folder_renames_MAX VARCHAR2(256) NOT NULL,
Folder_restores_MIN VARCHAR2(256) NOT NULL,
Folder_restores_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBFolderActTest_THRESH ADD constraint PK_ODBFolderActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFolderActTest_THRESH ON ODBFolderActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFolderActTest ON ODBFolderActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFolderActTest ON ODBFolderActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBSiteUsageTest CASCADE CONSTRAINTS;
CREATE TABLE ODBSiteUsageTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_sites Number(20,4) NOT NULL,
Total_sites_ST varchar2(32) NOT NULL,
Active_sites Number(20,4) NOT NULL,
Active_sites_ST varchar2(32) NOT NULL,
Active_site_percent Number(20,4) NOT NULL,
Active_site_percent_ST varchar2(32) NOT NULL,
Inactiv_sites Number(20,4) NOT NULL,
Inactiv_sites_ST varchar2(32) NOT NULL,
Strgusd_site Number(20,4) NOT NULL,
Strgusd_site_ST varchar2(32) NOT NULL,
Strgalctd_site Number(20,4) NOT NULL,
Strgalctd_site_ST varchar2(32) NOT NULL,
Strg_used Number(20,4) NOT NULL,
Strg_used_ST varchar2(32) NOT NULL,
Strg_limit Number(20,4) NOT NULL,
Strg_limit_ST varchar2(32) NOT NULL,
Orph_sites Number(20,4) NOT NULL,
Orph_sites_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBSiteUsageTest ON ODBSiteUsageTest(MSMT_TIME);
ALTER TABLE ODBSiteUsageTest ADD constraint PK_ODBSiteUsageTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBSiteUsageTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBSiteUsageTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_sites_MIN Number(20,4) NOT NULL,
Total_sites_MAX Number(20,4) NOT NULL,
Total_sites_STCNT varchar2(32) NOT NULL,
Active_sites_MIN Number(20,4) NOT NULL,
Active_sites_MAX Number(20,4) NOT NULL,
Active_sites_STCNT varchar2(32) NOT NULL,
Active_site_percent_MIN Number(20,4) NOT NULL,
Active_site_percent_MAX Number(20,4) NOT NULL,
Active_site_percent_STCNT varchar2(32) NOT NULL,
Inactiv_sites_MIN Number(20,4) NOT NULL,
Inactiv_sites_MAX Number(20,4) NOT NULL,
Inactiv_sites_STCNT varchar2(32) NOT NULL,
Strgusd_site_MIN Number(20,4) NOT NULL,
Strgusd_site_MAX Number(20,4) NOT NULL,
Strgusd_site_STCNT varchar2(32) NOT NULL,
Strgalctd_site_MIN Number(20,4) NOT NULL,
Strgalctd_site_MAX Number(20,4) NOT NULL,
Strgalctd_site_STCNT varchar2(32) NOT NULL,
Strg_used_MIN Number(20,4) NOT NULL,
Strg_used_MAX Number(20,4) NOT NULL,
Strg_used_STCNT varchar2(32) NOT NULL,
Strg_limit_MIN Number(20,4) NOT NULL,
Strg_limit_MAX Number(20,4) NOT NULL,
Strg_limit_STCNT varchar2(32) NOT NULL,
Orph_sites_MIN Number(20,4) NOT NULL,
Orph_sites_MAX Number(20,4) NOT NULL,
Orph_sites_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBSiteUsageTest_TREND ADD constraint PK_ODBSiteUsageTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBSiteUsageTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBSiteUsageTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_sites_MIN VARCHAR2(256) NOT NULL,
Total_sites_MAX VARCHAR2(256) NOT NULL,
Active_sites_MIN VARCHAR2(256) NOT NULL,
Active_sites_MAX VARCHAR2(256) NOT NULL,
Active_site_percent_MIN VARCHAR2(256) NOT NULL,
Active_site_percent_MAX VARCHAR2(256) NOT NULL,
Inactiv_sites_MIN VARCHAR2(256) NOT NULL,
Inactiv_sites_MAX VARCHAR2(256) NOT NULL,
Strgusd_site_MIN VARCHAR2(256) NOT NULL,
Strgusd_site_MAX VARCHAR2(256) NOT NULL,
Strgalctd_site_MIN VARCHAR2(256) NOT NULL,
Strgalctd_site_MAX VARCHAR2(256) NOT NULL,
Strg_used_MIN VARCHAR2(256) NOT NULL,
Strg_used_MAX VARCHAR2(256) NOT NULL,
Strg_limit_MIN VARCHAR2(256) NOT NULL,
Strg_limit_MAX VARCHAR2(256) NOT NULL,
Orph_sites_MIN VARCHAR2(256) NOT NULL,
Orph_sites_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBSiteUsageTest_THRESH ADD constraint PK_ODBSiteUsageTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBSiteUsageTest_THRESH ON ODBSiteUsageTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBSiteUsageTest ON ODBSiteUsageTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBSiteUsageTest ON ODBSiteUsageTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE ODBFileUsageTest CASCADE CONSTRAINTS;
CREATE TABLE ODBFileUsageTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_file Number(20,4) NOT NULL,
Total_file_ST varchar2(32) NOT NULL,
Active_file Number(20,4) NOT NULL,
Active_file_ST varchar2(32) NOT NULL,
Active_file_percent Number(20,4) NOT NULL,
Active_file_percent_ST varchar2(32) NOT NULL,
File_growth_rate Number(20,4) NOT NULL,
File_growth_rate_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_ODBFileUsageTest ON ODBFileUsageTest(MSMT_TIME);
ALTER TABLE ODBFileUsageTest ADD constraint PK_ODBFileUsageTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE ODBFileUsageTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE ODBFileUsageTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_file_MIN Number(20,4) NOT NULL,
Total_file_MAX Number(20,4) NOT NULL,
Total_file_STCNT varchar2(32) NOT NULL,
Active_file_MIN Number(20,4) NOT NULL,
Active_file_MAX Number(20,4) NOT NULL,
Active_file_STCNT varchar2(32) NOT NULL,
Active_file_percent_MIN Number(20,4) NOT NULL,
Active_file_percent_MAX Number(20,4) NOT NULL,
Active_file_percent_STCNT varchar2(32) NOT NULL,
File_growth_rate_MIN Number(20,4) NOT NULL,
File_growth_rate_MAX Number(20,4) NOT NULL,
File_growth_rate_STCNT varchar2(32) NOT NULL);

ALTER TABLE ODBFileUsageTest_TREND ADD constraint PK_ODBFileUsageTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE ODBFileUsageTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE ODBFileUsageTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_file_MIN VARCHAR2(256) NOT NULL,
Total_file_MAX VARCHAR2(256) NOT NULL,
Active_file_MIN VARCHAR2(256) NOT NULL,
Active_file_MAX VARCHAR2(256) NOT NULL,
Active_file_percent_MIN VARCHAR2(256) NOT NULL,
Active_file_percent_MAX VARCHAR2(256) NOT NULL,
File_growth_rate_MIN VARCHAR2(256) NOT NULL,
File_growth_rate_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE ODBFileUsageTest_THRESH ADD constraint PK_ODBFileUsageTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_ODBFileUsageTest_THRESH ON ODBFileUsageTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_ODBFileUsageTest ON ODBFileUsageTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_ODBFileUsageTest ON ODBFileUsageTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EXOUsrConByAppTest CASCADE CONSTRAINTS;
CREATE TABLE EXOUsrConByAppTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date,
usrcount Number(20,4) NOT NULL,
usrcount_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_EXOUsrConByAppTest ON EXOUsrConByAppTest(MSMT_TIME);
ALTER TABLE EXOUsrConByAppTest ADD constraint PK_EXOUsrConByAppTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUsrConByAppTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOUsrConByAppTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date,
PERIOD       	varchar2(32) NOT NULL,
usrcount_MIN Number(20,4) NOT NULL,
usrcount_MAX Number(20,4) NOT NULL,
usrcount_STCNT varchar2(32) NOT NULL
);

ALTER TABLE EXOUsrConByAppTest_TREND ADD constraint PK_EXOUsrConByAppTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUsrConByAppTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOUsrConByAppTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date,
MSMT_TIME_END   date,
usrcount_MIN varchar2(256) NOT NULL,
usrcount_MAX varchar2(256) NOT NULL
);

ALTER TABLE EXOUsrConByAppTest_THRESH ADD constraint PK_EXOUsrConByAppTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUsrConByAppTest_THRESH ON EXOUsrConByAppTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUsrConByAppTest ON EXOUsrConByAppTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUsrConByAppTest ON EXOUsrConByAppTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOUsrLyncVersnTest CASCADE CONSTRAINTS;
CREATE TABLE EXOUsrLyncVersnTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date,
usrcount Number(20,4) NOT NULL,
usrcount_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_EXOUsrLyncVersnTest ON EXOUsrLyncVersnTest(MSMT_TIME);
ALTER TABLE EXOUsrLyncVersnTest ADD constraint PK_EXOUsrLyncVersnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUsrLyncVersnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOUsrLyncVersnTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date,
PERIOD       	varchar2(32) NOT NULL,
usrcount_MIN Number(20,4) NOT NULL,
usrcount_MAX Number(20,4) NOT NULL,
usrcount_STCNT varchar2(32) NOT NULL
);

ALTER TABLE EXOUsrLyncVersnTest_TREND ADD constraint PK_EXOUsrLyncVersnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUsrLyncVersnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOUsrLyncVersnTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date,
MSMT_TIME_END   date,
usrcount_MIN varchar2(256) NOT NULL,
usrcount_MAX varchar2(256) NOT NULL
);

ALTER TABLE EXOUsrLyncVersnTest_THRESH ADD constraint PK_EXOUsrLyncVersnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUsrLyncVersnTest_THRESH ON EXOUsrLyncVersnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUsrLyncVersnTest ON EXOUsrLyncVersnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUsrLyncVersnTest ON EXOUsrLyncVersnTest_TREND (MSMT_TIME,PERIOD);






DROP TABLE SPOSitUsageSumTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSitUsageSumTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date,
TOTAL_SITES Number(20,4) NOT NULL,
TOTAL_SITES_ST varchar2(32) NOT NULL,
ACTIVE_SITES Number(20,4) NOT NULL,
ACTIVE_SITES_ST varchar2(32) NOT NULL,
TOTAL_FILES Number(20,4) NOT NULL,
TOTAL_FILES_ST varchar2(32) NOT NULL,
ACTIVE_FILES Number(20,4) NOT NULL,
ACTIVE_FILES_ST varchar2(32) NOT NULL,
ACTIVE_FILES_PERCENT Number(20,4) NOT NULL,
ACTIVE_FILES_PERCENT_ST varchar2(32) NOT NULL,
PAGE_VIEWS Number(20,4) NOT NULL,
PAGE_VIEWS_ST varchar2(32) NOT NULL,
VISITED_PAGES Number(20,4) NOT NULL,
VISITED_PAGES_ST varchar2(32) NOT NULL,
SITE_CONSUMING Number(20,4) NOT NULL,
SITE_CONSUMING_ST varchar2(32) NOT NULL,
STORAGE_USED Number(20,4) NOT NULL,
STORAGE_USED_ST varchar2(32) NOT NULL,
STORAGE_ALLOCATED Number(20,4) NOT NULL,
STORAGE_ALLOCATED_ST varchar2(32) NOT NULL,
STORAGE_USED_PERCENT Number(20,4) NOT NULL,
STORAGE_USED_PERCENT_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSitUsageSumTest ON SPOSitUsageSumTest(MSMT_TIME);
ALTER TABLE SPOSitUsageSumTest ADD constraint PK_SPOSitUsageSumTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSitUsageSumTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSitUsageSumTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date,
PERIOD       	varchar2(32) NOT NULL,
TOTAL_SITES_MIN Number(20,4) NOT NULL,
TOTAL_SITES_MAX Number(20,4) NOT NULL,
TOTAL_SITES_STCNT varchar2(32) NOT NULL,
ACTIVE_SITES_MIN Number(20,4) NOT NULL,
ACTIVE_SITES_MAX Number(20,4) NOT NULL,
ACTIVE_SITES_STCNT varchar2(32) NOT NULL,
TOTAL_FILES_MIN Number(20,4) NOT NULL,
TOTAL_FILES_MAX Number(20,4) NOT NULL,
TOTAL_FILES_STCNT varchar2(32) NOT NULL,
ACTIVE_FILES_MIN Number(20,4) NOT NULL,
ACTIVE_FILES_MAX Number(20,4) NOT NULL,
ACTIVE_FILES_STCNT varchar2(32) NOT NULL,
ACTIVE_FILES_PERCENT_MIN Number(20,4) NOT NULL,
ACTIVE_FILES_PERCENT_MAX Number(20,4) NOT NULL,
ACTIVE_FILES_PERCENT_STCNT varchar2(32) NOT NULL,
PAGE_VIEWS_MIN Number(20,4) NOT NULL,
PAGE_VIEWS_MAX Number(20,4) NOT NULL,
PAGE_VIEWS_STCNT varchar2(32) NOT NULL,
VISITED_PAGES_MIN Number(20,4) NOT NULL,
VISITED_PAGES_MAX Number(20,4) NOT NULL,
VISITED_PAGES_STCNT varchar2(32) NOT NULL,
SITE_CONSUMING_MIN Number(20,4) NOT NULL,
SITE_CONSUMING_MAX Number(20,4) NOT NULL,
SITE_CONSUMING_STCNT varchar2(32) NOT NULL,
STORAGE_USED_MIN Number(20,4) NOT NULL,
STORAGE_USED_MAX Number(20,4) NOT NULL,
STORAGE_USED_STCNT varchar2(32) NOT NULL,
STORAGE_ALLOCATED_MIN Number(20,4) NOT NULL,
STORAGE_ALLOCATED_MAX Number(20,4) NOT NULL,
STORAGE_ALLOCATED_STCNT varchar2(32) NOT NULL,
STORAGE_USED_PERCENT_MIN Number(20,4) NOT NULL,
STORAGE_USED_PERCENT_MAX Number(20,4) NOT NULL,
STORAGE_USED_PERCENT_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSitUsageSumTest_TREND ADD constraint PK_SPOSitUsgSumTst_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSitUsageSumTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSitUsageSumTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date,
MSMT_TIME_END   date,
TOTAL_SITES_MIN varchar2(256) NOT NULL,
TOTAL_SITES_MAX varchar2(256) NOT NULL,
ACTIVE_SITES_MIN varchar2(256) NOT NULL,
ACTIVE_SITES_MAX varchar2(256) NOT NULL,
TOTAL_FILES_MIN varchar2(256) NOT NULL,
TOTAL_FILES_MAX varchar2(256) NOT NULL,
ACTIVE_FILES_MIN varchar2(256) NOT NULL,
ACTIVE_FILES_MAX varchar2(256) NOT NULL,
ACTIVE_FILES_PERCENT_MIN varchar2(256) NOT NULL,
ACTIVE_FILES_PERCENT_MAX varchar2(256) NOT NULL,
PAGE_VIEWS_MIN varchar2(256) NOT NULL,
PAGE_VIEWS_MAX varchar2(256) NOT NULL,
VISITED_PAGES_MIN varchar2(256) NOT NULL,
VISITED_PAGES_MAX varchar2(256) NOT NULL,
SITE_CONSUMING_MIN varchar2(256) NOT NULL,
SITE_CONSUMING_MAX varchar2(256) NOT NULL,
STORAGE_USED_MIN varchar2(256) NOT NULL,
STORAGE_USED_MAX varchar2(256) NOT NULL,
STORAGE_ALLOCATED_MIN varchar2(256) NOT NULL,
STORAGE_ALLOCATED_MAX varchar2(256) NOT NULL,
STORAGE_USED_PERCENT_MIN varchar2(256) NOT NULL,
STORAGE_USED_PERCENT_MAX varchar2(256) NOT NULL);

ALTER TABLE SPOSitUsageSumTest_THRESH ADD constraint PK_SPOSitUsgSumTst_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSitUsSumTst_THRESH ON SPOSitUsageSumTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSitUsgSumTst ON SPOSitUsageSumTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSitUsgSumTst ON SPOSitUsageSumTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE MTMSrvcHlhTest CASCADE CONSTRAINTS;
CREATE TABLE MTMSrvcHlhTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SERVICE_INCIDENTS Number(20,4) NOT NULL,
SERVICE_INCIDENTS_ST varchar2(32) NOT NULL,
MAINTENANCE_EVENTS Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_ST varchar2(32) NOT NULL,
SERVICE_STATUS Number(20,4) NOT NULL,
SERVICE_STATUS_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_MTMSrvcHlhTest ON MTMSrvcHlhTest(MSMT_TIME);
ALTER TABLE MTMSrvcHlhTest ADD constraint PK_MTMSrvcHlhTest PRIMARY KEY(
TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMSrvcHlhTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMSrvcHlhTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SERVICE_INCIDENTS_MIN Number(20,4) NOT NULL,
SERVICE_INCIDENTS_MAX Number(20,4) NOT NULL,
SERVICE_INCIDENTS_STCNT varchar2(32) NOT NULL,
MAINTENANCE_EVENTS_MIN Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_MAX Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_STCNT varchar2(32) NOT NULL,
SERVICE_STATUS_MIN Number(20,4) NOT NULL,
SERVICE_STATUS_MAX Number(20,4) NOT NULL,
SERVICE_STATUS_STCNT varchar2(32) NOT NULL);
ALTER TABLE MTMSrvcHlhTest_TREND ADD constraint PK_MTMSrvcHlhTest_TREND PRIMARY KEY(
TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMSrvcHlhTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMSrvcHlhTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SERVICE_INCIDENTS_MIN varchar2(256) NOT NULL,
SERVICE_INCIDENTS_MAX varchar2(256) NOT NULL,
MAINTENANCE_EVENTS_MIN varchar2(256) NOT NULL,
MAINTENANCE_EVENTS_MAX varchar2(256) NOT NULL,
SERVICE_STATUS_MIN varchar2(256) NOT NULL,
SERVICE_STATUS_MAX varchar2(256) NOT NULL);
ALTER TABLE MTMSrvcHlhTest_THRESH ADD constraint PK_MTMSrvcHlhTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMSrvcHlhTest_THRESH ON MTMSrvcHlhTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMSrvcHlhTest ON MTMSrvcHlhTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMSrvcHlhTest ON MTMSrvcHlhTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMAudioStrmsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMAudioStrmsTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AStrm Number(20,4) NOT NULL,
AStrm_ST varchar2(32) NOT NULL,
APrStm Number(20,4) NOT NULL,
APrStm_ST varchar2(32) NOT NULL,
AGdStm Number(20,4) NOT NULL,
AGdStm_ST varchar2(32) NOT NULL,
AUcfStm Number(20,4) NOT NULL,
AUcfStm_ST varchar2(32) NOT NULL,
APrPrct Number(20,4) NOT NULL,
APrPrct_ST varchar2(32) NOT NULL,
APrDJtr Number(20,4) NOT NULL,
APrDJtr_ST varchar2(32) NOT NULL,
APrDPktLs Number(20,4) NOT NULL,
APrDPktLs_ST varchar2(32) NOT NULL,
APrDDgdtn Number(20,4) NOT NULL,
APrDDgdtn_ST varchar2(32) NOT NULL,
APrDRndTp Number(20,4) NOT NULL,
APrDRndTp_ST varchar2(32) NOT NULL,
APrDCnclRt Number(20,4) NOT NULL,
APrDCnclRt_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMAudioStrmsTest ON MTMAudioStrmsTest(MSMT_TIME);
ALTER TABLE MTMAudioStrmsTest ADD constraint PK_MTMAudioStrmsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMAudioStrmsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMAudioStrmsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AStrm_MIN Number(20,4) NOT NULL,
AStrm_MAX Number(20,4) NOT NULL,
AStrm_STCNT varchar2(32) NOT NULL,
APrStm_MIN Number(20,4) NOT NULL,
APrStm_MAX Number(20,4) NOT NULL,
APrStm_STCNT varchar2(32) NOT NULL,
AGdStm_MIN Number(20,4) NOT NULL,
AGdStm_MAX Number(20,4) NOT NULL,
AGdStm_STCNT varchar2(32) NOT NULL,
AUcfStm_MIN Number(20,4) NOT NULL,
AUcfStm_MAX Number(20,4) NOT NULL,
AUcfStm_STCNT varchar2(32) NOT NULL,
APrPrct_MIN Number(20,4) NOT NULL,
APrPrct_MAX Number(20,4) NOT NULL,
APrPrct_STCNT varchar2(32) NOT NULL,
APrDJtr_MIN Number(20,4) NOT NULL,
APrDJtr_MAX Number(20,4) NOT NULL,
APrDJtr_STCNT varchar2(32) NOT NULL,
APrDPktLs_MIN Number(20,4) NOT NULL,
APrDPktLs_MAX Number(20,4) NOT NULL,
APrDPktLs_STCNT varchar2(32) NOT NULL,
APrDDgdtn_MIN Number(20,4) NOT NULL,
APrDDgdtn_MAX Number(20,4) NOT NULL,
APrDDgdtn_STCNT varchar2(32) NOT NULL,
APrDRndTp_MIN Number(20,4) NOT NULL,
APrDRndTp_MAX Number(20,4) NOT NULL,
APrDRndTp_STCNT varchar2(32) NOT NULL,
APrDCnclRt_MIN Number(20,4) NOT NULL,
APrDCnclRt_MAX Number(20,4) NOT NULL,
APrDCnclRt_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMAudioStrmsTest_TREND ADD constraint PK_MTMAudioStrmsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMAudioStrmsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMAudioStrmsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AStrm_MIN varchar2(256) NOT NULL,
AStrm_MAX varchar2(256) NOT NULL,
APrStm_MIN varchar2(256) NOT NULL,
APrStm_MAX varchar2(256) NOT NULL,
AGdStm_MIN varchar2(256) NOT NULL,
AGdStm_MAX varchar2(256) NOT NULL,
AUcfStm_MIN varchar2(256) NOT NULL,
AUcfStm_MAX varchar2(256) NOT NULL,
APrPrct_MIN varchar2(256) NOT NULL,
APrPrct_MAX varchar2(256) NOT NULL,
APrDJtr_MIN varchar2(256) NOT NULL,
APrDJtr_MAX varchar2(256) NOT NULL,
APrDPktLs_MIN varchar2(256) NOT NULL,
APrDPktLs_MAX varchar2(256) NOT NULL,
APrDDgdtn_MIN varchar2(256) NOT NULL,
APrDDgdtn_MAX varchar2(256) NOT NULL,
APrDRndTp_MIN varchar2(256) NOT NULL,
APrDRndTp_MAX varchar2(256) NOT NULL,
APrDCnclRt_MIN varchar2(256) NOT NULL,
APrDCnclRt_MAX varchar2(256) NOT NULL
);

ALTER TABLE MTMAudioStrmsTest_THRESH ADD constraint PK_MTMAudioStrmsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMAudioStrmsTest_THRESH ON MTMAudioStrmsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMAudioStrmsTest ON MTMAudioStrmsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMAudioStrmsTest ON MTMAudioStrmsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMNtwkQtySmyTest CASCADE CONSTRAINTS;
CREATE TABLE MTMNtwkQtySmyTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AvgAudDgtn Number(20,4) NOT NULL,
AvgAudDgtn_ST varchar2(32) NOT NULL,
AvgJitter Number(20,4) NOT NULL,
AvgJitter_ST varchar2(32) NOT NULL,
MxmJitter Number(20,4) NOT NULL,
MxmJitter_ST varchar2(32) NOT NULL,
AvgPtLsRt Number(20,4) NOT NULL,
AvgPtLsRt_ST varchar2(32) NOT NULL,
MxPtLsRte Number(20,4) NOT NULL,
MxPtLsRte_ST varchar2(32) NOT NULL,
AvgSdLnMOS Number(20,4) NOT NULL,
AvgSdLnMOS_ST varchar2(32) NOT NULL,
OrlAvgNtMOS Number(20,4) NOT NULL,
OrlAvgNtMOS_ST varchar2(32) NOT NULL,
CnldSmplAvg Number(20,4) NOT NULL,
CnldSmplAvg_ST varchar2(32) NOT NULL,
AvgRtStchSpl Number(20,4) NOT NULL,
AvgRtStchSpl_ST varchar2(32) NOT NULL,
AvgRndTrip Number(20,4) NOT NULL,
AvgRndTrip_ST varchar2(32) NOT NULL,
AvgRndTripMx Number(20,4) NOT NULL,
AvgRndTripMx_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMNtwkQtySmyTest ON MTMNtwkQtySmyTest(MSMT_TIME);
ALTER TABLE MTMNtwkQtySmyTest ADD constraint PK_MTMNtwkQtySmyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMNtwkQtySmyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMNtwkQtySmyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AvgAudDgtn_MIN Number(20,4) NOT NULL,
AvgAudDgtn_MAX Number(20,4) NOT NULL,
AvgAudDgtn_STCNT varchar2(32) NOT NULL,
AvgJitter_MIN Number(20,4) NOT NULL,
AvgJitter_MAX Number(20,4) NOT NULL,
AvgJitter_STCNT varchar2(32) NOT NULL,
MxmJitter_MIN Number(20,4) NOT NULL,
MxmJitter_MAX Number(20,4) NOT NULL,
MxmJitter_STCNT varchar2(32) NOT NULL,
AvgPtLsRt_MIN Number(20,4) NOT NULL,
AvgPtLsRt_MAX Number(20,4) NOT NULL,
AvgPtLsRt_STCNT varchar2(32) NOT NULL,
MxPtLsRte_MIN Number(20,4) NOT NULL,
MxPtLsRte_MAX Number(20,4) NOT NULL,
MxPtLsRte_STCNT varchar2(32) NOT NULL,
AvgSdLnMOS_MIN Number(20,4) NOT NULL,
AvgSdLnMOS_MAX Number(20,4) NOT NULL,
AvgSdLnMOS_STCNT varchar2(32) NOT NULL,
OrlAvgNtMOS_MIN Number(20,4) NOT NULL,
OrlAvgNtMOS_MAX Number(20,4) NOT NULL,
OrlAvgNtMOS_STCNT varchar2(32) NOT NULL,
CnldSmplAvg_MIN Number(20,4) NOT NULL,
CnldSmplAvg_MAX Number(20,4) NOT NULL,
CnldSmplAvg_STCNT varchar2(32) NOT NULL,
AvgRtStchSpl_MIN Number(20,4) NOT NULL,
AvgRtStchSpl_MAX Number(20,4) NOT NULL,
AvgRtStchSpl_STCNT varchar2(32) NOT NULL,
AvgRndTrip_MIN Number(20,4) NOT NULL,
AvgRndTrip_MAX Number(20,4) NOT NULL,
AvgRndTrip_STCNT varchar2(32) NOT NULL,
AvgRndTripMx_MIN Number(20,4) NOT NULL,
AvgRndTripMx_MAX Number(20,4) NOT NULL,
AvgRndTripMx_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMNtwkQtySmyTest_TREND ADD constraint PK_MTMNtwkQtySmyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMNtwkQtySmyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMNtwkQtySmyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AvgAudDgtn_MIN varchar2(256) NOT NULL,
AvgAudDgtn_MAX varchar2(256) NOT NULL,
AvgJitter_MIN varchar2(256) NOT NULL,
AvgJitter_MAX varchar2(256) NOT NULL,
MxmJitter_MIN varchar2(256) NOT NULL,
MxmJitter_MAX varchar2(256) NOT NULL,
AvgPtLsRt_MIN varchar2(256) NOT NULL,
AvgPtLsRt_MAX varchar2(256) NOT NULL,
MxPtLsRte_MIN varchar2(256) NOT NULL,
MxPtLsRte_MAX varchar2(256) NOT NULL,
AvgSdLnMOS_MIN varchar2(256) NOT NULL,
AvgSdLnMOS_MAX varchar2(256) NOT NULL,
OrlAvgNtMOS_MIN varchar2(256) NOT NULL,
OrlAvgNtMOS_MAX varchar2(256) NOT NULL,
CnldSmplAvg_MIN varchar2(256) NOT NULL,
CnldSmplAvg_MAX varchar2(256) NOT NULL,
AvgRtStchSpl_MIN varchar2(256) NOT NULL,
AvgRtStchSpl_MAX varchar2(256) NOT NULL,
AvgRndTrip_MIN varchar2(256) NOT NULL,
AvgRndTrip_MAX varchar2(256) NOT NULL,
AvgRndTripMx_MIN varchar2(256) NOT NULL,
AvgRndTripMx_MAX varchar2(256) NOT NULL
);

ALTER TABLE MTMNtwkQtySmyTest_THRESH ADD constraint PK_MTMNtwkQtySmyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMNtwkQtySmyTest_THRESH ON MTMNtwkQtySmyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMNtwkQtySmyTest ON MTMNtwkQtySmyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMNtwkQtySmyTest ON MTMNtwkQtySmyTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMVideoStreamsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMVideoStreamsTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Strmcnt Number(20,4) NOT NULL,
Strmcnt_ST varchar2(32) NOT NULL,
ViPstFclr Number(20,4) NOT NULL,
ViPstFclr_ST varchar2(32) NOT NULL,
ViLFrPrAg Number(20,4) NOT NULL,
ViLFrPrAg_ST varchar2(32) NOT NULL,
ViFrRteAg Number(20,4) NOT NULL,
ViFrRteAg_ST varchar2(32) NOT NULL,
PrStrmcnt Number(20,4) NOT NULL,
PrStrmcnt_ST varchar2(32) NOT NULL,
GdStrmCnt Number(20,4) NOT NULL,
GdStrmCnt_ST varchar2(32) NOT NULL,
UncfdSmCnt Number(20,4) NOT NULL,
UncfdSmCnt_ST varchar2(32) NOT NULL,
PrPercent Number(20,4) NOT NULL,
PrPercent_ST varchar2(32) NOT NULL,
AvPsFECPLR Number(20,4) NOT NULL,
AvPsFECPLR_ST varchar2(32) NOT NULL,
AvLclFmLs Number(20,4) NOT NULL,
AvLclFmLs_ST varchar2(32) NOT NULL,
AvRcvFmRtAg Number(20,4) NOT NULL,
AvRcvFmRtAg_ST varchar2(32) NOT NULL,
AvLwFmRtCPt Number(20,4) NOT NULL,
AvLwFmRtCPt_ST varchar2(32) NOT NULL,
AvPktLsRt Number(20,4) NOT NULL,
AvPktLsRt_ST varchar2(32) NOT NULL,
AvDycCpyPnt Number(20,4) NOT NULL,
AvDycCpyPnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMVideoStreamsTest ON MTMVideoStreamsTest(MSMT_TIME);
ALTER TABLE MTMVideoStreamsTest ADD constraint PK_MTMVideoStreamsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMVideoStreamsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMVideoStreamsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Strmcnt_MIN Number(20,4) NOT NULL,
Strmcnt_MAX Number(20,4) NOT NULL,
Strmcnt_STCNT varchar2(32) NOT NULL,
ViPstFclr_MIN Number(20,4) NOT NULL,
ViPstFclr_MAX Number(20,4) NOT NULL,
ViPstFclr_STCNT varchar2(32) NOT NULL,
ViLFrPrAg_MIN Number(20,4) NOT NULL,
ViLFrPrAg_MAX Number(20,4) NOT NULL,
ViLFrPrAg_STCNT varchar2(32) NOT NULL,
ViFrRteAg_MIN Number(20,4) NOT NULL,
ViFrRteAg_MAX Number(20,4) NOT NULL,
ViFrRteAg_STCNT varchar2(32) NOT NULL,
PrStrmcnt_MIN Number(20,4) NOT NULL,
PrStrmcnt_MAX Number(20,4) NOT NULL,
PrStrmcnt_STCNT varchar2(32) NOT NULL,
GdStrmCnt_MIN Number(20,4) NOT NULL,
GdStrmCnt_MAX Number(20,4) NOT NULL,
GdStrmCnt_STCNT varchar2(32) NOT NULL,
UncfdSmCnt_MIN Number(20,4) NOT NULL,
UncfdSmCnt_MAX Number(20,4) NOT NULL,
UncfdSmCnt_STCNT varchar2(32) NOT NULL,
PrPercent_MIN Number(20,4) NOT NULL,
PrPercent_MAX Number(20,4) NOT NULL,
PrPercent_STCNT varchar2(32) NOT NULL,
AvPsFECPLR_MIN Number(20,4) NOT NULL,
AvPsFECPLR_MAX Number(20,4) NOT NULL,
AvPsFECPLR_STCNT varchar2(32) NOT NULL,
AvLclFmLs_MIN Number(20,4) NOT NULL,
AvLclFmLs_MAX Number(20,4) NOT NULL,
AvLclFmLs_STCNT varchar2(32) NOT NULL,
AvRcvFmRtAg_MIN Number(20,4) NOT NULL,
AvRcvFmRtAg_MAX Number(20,4) NOT NULL,
AvRcvFmRtAg_STCNT varchar2(32) NOT NULL,
AvLwFmRtCPt_MIN Number(20,4) NOT NULL,
AvLwFmRtCPt_MAX Number(20,4) NOT NULL,
AvLwFmRtCPt_STCNT varchar2(32) NOT NULL,
AvPktLsRt_MIN Number(20,4) NOT NULL,
AvPktLsRt_MAX Number(20,4) NOT NULL,
AvPktLsRt_STCNT varchar2(32) NOT NULL,
AvDycCpyPnt_MIN Number(20,4) NOT NULL,
AvDycCpyPnt_MAX Number(20,4) NOT NULL,
AvDycCpyPnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMVideoStreamsTest_TREND ADD constraint PK_MTMVideoStreamsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMVideoStreamsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMVideoStreamsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Strmcnt_MIN varchar2(256) NOT NULL,
Strmcnt_MAX varchar2(256) NOT NULL,
ViPstFclr_MIN varchar2(256) NOT NULL,
ViPstFclr_MAX varchar2(256) NOT NULL,
ViLFrPrAg_MIN varchar2(256) NOT NULL,
ViLFrPrAg_MAX varchar2(256) NOT NULL,
ViFrRteAg_MIN varchar2(256) NOT NULL,
ViFrRteAg_MAX varchar2(256) NOT NULL,
PrStrmcnt_MIN varchar2(256) NOT NULL,
PrStrmcnt_MAX varchar2(256) NOT NULL,
GdStrmCnt_MIN varchar2(256) NOT NULL,
GdStrmCnt_MAX varchar2(256) NOT NULL,
UncfdSmCnt_MIN varchar2(256) NOT NULL,
UncfdSmCnt_MAX varchar2(256) NOT NULL,
PrPercent_MIN varchar2(256) NOT NULL,
PrPercent_MAX varchar2(256) NOT NULL,
AvPsFECPLR_MIN varchar2(256) NOT NULL,
AvPsFECPLR_MAX varchar2(256) NOT NULL,
AvLclFmLs_MIN varchar2(256) NOT NULL,
AvLclFmLs_MAX varchar2(256) NOT NULL,
AvRcvFmRtAg_MIN varchar2(256) NOT NULL,
AvRcvFmRtAg_MAX varchar2(256) NOT NULL,
AvLwFmRtCPt_MIN varchar2(256) NOT NULL,
AvLwFmRtCPt_MAX varchar2(256) NOT NULL,
AvPktLsRt_MIN varchar2(256) NOT NULL,
AvPktLsRt_MAX varchar2(256) NOT NULL,
AvDycCpyPnt_MIN varchar2(256) NOT NULL,
AvDycCpyPnt_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMVideoStreamsTest_THRESH ADD constraint PK_MTMVideoStreamsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMVideoStreamsTest_THRESH ON MTMVideoStreamsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMVideoStreamsTest ON MTMVideoStreamsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMVideoStreamsTest ON MTMVideoStreamsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMAppShrngStrmsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMAppShrngStrmsTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
StreamCount Number(20,4) NOT NULL,
StreamCount_ST varchar2(32) NOT NULL,
PDSpldTlePrTlCt Number(20,4) NOT NULL,
PDSpldTlePrTlCt_ST varchar2(32) NOT NULL,
PDRlOnWyAvgCnt Number(20,4) NOT NULL,
PDRlOnWyAvgCnt_ST varchar2(32) NOT NULL,
PDRDPTlPngLyAgCt Number(20,4) NOT NULL,
PDRDPTlPngLyAgCt_ST varchar2(32) NOT NULL,
PoorStreamCount Number(20,4) NOT NULL,
PoorStreamCount_ST varchar2(32) NOT NULL,
GoodStreamCount Number(20,4) NOT NULL,
GoodStreamCount_ST varchar2(32) NOT NULL,
UnclasfedStmCnt Number(20,4) NOT NULL,
UnclasfedStmCnt_ST varchar2(32) NOT NULL,
PoorPercentage Number(20,4) NOT NULL,
PoorPercentage_ST varchar2(32) NOT NULL,
SpldTlPrcntTtl Number(20,4) NOT NULL,
SpldTlPrcntTtl_ST varchar2(32) NOT NULL,
RDPTlPcngLtncy Number(20,4) NOT NULL,
RDPTlPcngLtncy_ST varchar2(32) NOT NULL,
AvReltveOneWy Number(20,4) NOT NULL,
AvReltveOneWy_ST varchar2(32) NOT NULL,
AvRltvOneWyMx Number(20,4) NOT NULL,
AvRltvOneWyMx_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMAppShrngStrmsTest ON MTMAppShrngStrmsTest(MSMT_TIME);
ALTER TABLE MTMAppShrngStrmsTest ADD constraint PK_MTMAppShrngStrmsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMAppShrngStrmsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMAppShrngStrmsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
StreamCount_MIN Number(20,4) NOT NULL,
StreamCount_MAX Number(20,4) NOT NULL,
StreamCount_STCNT varchar2(32) NOT NULL,
PDSpldTlePrTlCt_MIN Number(20,4) NOT NULL,
PDSpldTlePrTlCt_MAX Number(20,4) NOT NULL,
PDSpldTlePrTlCt_STCNT varchar2(32) NOT NULL,
PDRlOnWyAvgCnt_MIN Number(20,4) NOT NULL,
PDRlOnWyAvgCnt_MAX Number(20,4) NOT NULL,
PDRlOnWyAvgCnt_STCNT varchar2(32) NOT NULL,
PDRDPTlPngLyAgCt_MIN Number(20,4) NOT NULL,
PDRDPTlPngLyAgCt_MAX Number(20,4) NOT NULL,
PDRDPTlPngLyAgCt_STCNT varchar2(32) NOT NULL,
PoorStreamCount_MIN Number(20,4) NOT NULL,
PoorStreamCount_MAX Number(20,4) NOT NULL,
PoorStreamCount_STCNT varchar2(32) NOT NULL,
GoodStreamCount_MIN Number(20,4) NOT NULL,
GoodStreamCount_MAX Number(20,4) NOT NULL,
GoodStreamCount_STCNT varchar2(32) NOT NULL,
UnclasfedStmCnt_MIN Number(20,4) NOT NULL,
UnclasfedStmCnt_MAX Number(20,4) NOT NULL,
UnclasfedStmCnt_STCNT varchar2(32) NOT NULL,
PoorPercentage_MIN Number(20,4) NOT NULL,
PoorPercentage_MAX Number(20,4) NOT NULL,
PoorPercentage_STCNT varchar2(32) NOT NULL,
SpldTlPrcntTtl_MIN Number(20,4) NOT NULL,
SpldTlPrcntTtl_MAX Number(20,4) NOT NULL,
SpldTlPrcntTtl_STCNT varchar2(32) NOT NULL,
RDPTlPcngLtncy_MIN Number(20,4) NOT NULL,
RDPTlPcngLtncy_MAX Number(20,4) NOT NULL,
RDPTlPcngLtncy_STCNT varchar2(32) NOT NULL,
AvReltveOneWy_MIN Number(20,4) NOT NULL,
AvReltveOneWy_MAX Number(20,4) NOT NULL,
AvReltveOneWy_STCNT varchar2(32) NOT NULL,
AvRltvOneWyMx_MIN Number(20,4) NOT NULL,
AvRltvOneWyMx_MAX Number(20,4) NOT NULL,
AvRltvOneWyMx_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMAppShrngStrmsTest_TREND ADD constraint PK_MTMAppShrngStrmsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMAppShrngStrmsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMAppShrngStrmsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
StreamCount_MIN varchar2(256) NOT NULL,
StreamCount_MAX varchar2(256) NOT NULL,
PDSpldTlePrTlCt_MIN varchar2(256) NOT NULL,
PDSpldTlePrTlCt_MAX varchar2(256) NOT NULL,
PDRlOnWyAvgCnt_MIN varchar2(256) NOT NULL,
PDRlOnWyAvgCnt_MAX varchar2(256) NOT NULL,
PDRDPTlPngLyAgCt_MIN varchar2(256) NOT NULL,
PDRDPTlPngLyAgCt_MAX varchar2(256) NOT NULL,
PoorStreamCount_MIN varchar2(256) NOT NULL,
PoorStreamCount_MAX varchar2(256) NOT NULL,
GoodStreamCount_MIN varchar2(256) NOT NULL,
GoodStreamCount_MAX varchar2(256) NOT NULL,
UnclasfedStmCnt_MIN varchar2(256) NOT NULL,
UnclasfedStmCnt_MAX varchar2(256) NOT NULL,
PoorPercentage_MIN varchar2(256) NOT NULL,
PoorPercentage_MAX varchar2(256) NOT NULL,
SpldTlPrcntTtl_MIN varchar2(256) NOT NULL,
SpldTlPrcntTtl_MAX varchar2(256) NOT NULL,
RDPTlPcngLtncy_MIN varchar2(256) NOT NULL,
RDPTlPcngLtncy_MAX varchar2(256) NOT NULL,
AvReltveOneWy_MIN varchar2(256) NOT NULL,
AvReltveOneWy_MAX varchar2(256) NOT NULL,
AvRltvOneWyMx_MIN varchar2(256) NOT NULL,
AvRltvOneWyMx_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMAppShrngStrmsTest_THRESH ADD constraint PK_MTMAppShngStrmTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMAppShngStrmTest_THRESH ON MTMAppShrngStrmsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMAppShrngStrmsTest ON MTMAppShrngStrmsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMAppShrngStrmsTest ON MTMAppShrngStrmsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMFeedBckSmryTest CASCADE CONSTRAINTS;
CREATE TABLE MTMFeedBckSmryTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
FFbckRgAv Number(20,4) NOT NULL,
FFbckRgAv_ST varchar2(32) NOT NULL,
SFbckRgAv Number(20,4) NOT NULL,
SFbckRgAv_ST varchar2(32) NOT NULL,
FFbckRg Number(20,4) NOT NULL,
FFbckRg_ST varchar2(32) NOT NULL,
SFbckRg Number(20,4) NOT NULL,
SFbckRg_ST varchar2(32) NOT NULL,
FFbkRgPrCt Number(20,4) NOT NULL,
FFbkRgPrCt_ST varchar2(32) NOT NULL,
SFbkRgPrCt Number(20,4) NOT NULL,
SFbkRgPrCt_ST varchar2(32) NOT NULL,
FFbkRgPrPt Number(20,4) NOT NULL,
FFbkRgPrPt_ST varchar2(32) NOT NULL,
SFbkRgPrPt Number(20,4) NOT NULL,
SFbkRgPrPt_ST varchar2(32) NOT NULL,
FFbkTnAdCt Number(20,4) NOT NULL,
FFbkTnAdCt_ST varchar2(32) NOT NULL,
SFbkTnAdCt Number(20,4) NOT NULL,
SFbkTnAdCt_ST varchar2(32) NOT NULL,
FFbkTnVdCt Number(20,4) NOT NULL,
FFbkTnVdCt_ST varchar2(32) NOT NULL,
SFbkTnVdCt Number(20,4) NOT NULL,
SFbkTnVdCt_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMFeedBckSmryTest ON MTMFeedBckSmryTest(MSMT_TIME);
ALTER TABLE MTMFeedBckSmryTest ADD constraint PK_MTMFeedBckSmryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMFeedBckSmryTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMFeedBckSmryTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
FFbckRgAv_MIN Number(20,4) NOT NULL,
FFbckRgAv_MAX Number(20,4) NOT NULL,
FFbckRgAv_STCNT varchar2(32) NOT NULL,
SFbckRgAv_MIN Number(20,4) NOT NULL,
SFbckRgAv_MAX Number(20,4) NOT NULL,
SFbckRgAv_STCNT varchar2(32) NOT NULL,
FFbckRg_MIN Number(20,4) NOT NULL,
FFbckRg_MAX Number(20,4) NOT NULL,
FFbckRg_STCNT varchar2(32) NOT NULL,
SFbckRg_MIN Number(20,4) NOT NULL,
SFbckRg_MAX Number(20,4) NOT NULL,
SFbckRg_STCNT varchar2(32) NOT NULL,
FFbkRgPrCt_MIN Number(20,4) NOT NULL,
FFbkRgPrCt_MAX Number(20,4) NOT NULL,
FFbkRgPrCt_STCNT varchar2(32) NOT NULL,
SFbkRgPrCt_MIN Number(20,4) NOT NULL,
SFbkRgPrCt_MAX Number(20,4) NOT NULL,
SFbkRgPrCt_STCNT varchar2(32) NOT NULL,
FFbkRgPrPt_MIN Number(20,4) NOT NULL,
FFbkRgPrPt_MAX Number(20,4) NOT NULL,
FFbkRgPrPt_STCNT varchar2(32) NOT NULL,
SFbkRgPrPt_MIN Number(20,4) NOT NULL,
SFbkRgPrPt_MAX Number(20,4) NOT NULL,
SFbkRgPrPt_STCNT varchar2(32) NOT NULL,
FFbkTnAdCt_MIN Number(20,4) NOT NULL,
FFbkTnAdCt_MAX Number(20,4) NOT NULL,
FFbkTnAdCt_STCNT varchar2(32) NOT NULL,
SFbkTnAdCt_MIN Number(20,4) NOT NULL,
SFbkTnAdCt_MAX Number(20,4) NOT NULL,
SFbkTnAdCt_STCNT varchar2(32) NOT NULL,
FFbkTnVdCt_MIN Number(20,4) NOT NULL,
FFbkTnVdCt_MAX Number(20,4) NOT NULL,
FFbkTnVdCt_STCNT varchar2(32) NOT NULL,
SFbkTnVdCt_MIN Number(20,4) NOT NULL,
SFbkTnVdCt_MAX Number(20,4) NOT NULL,
SFbkTnVdCt_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMFeedBckSmryTest_TREND ADD constraint PK_MTMFeedBckSmryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMFeedBckSmryTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMFeedBckSmryTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
FFbckRgAv_MIN varchar2(256) NOT NULL,
FFbckRgAv_MAX varchar2(256) NOT NULL,
SFbckRgAv_MIN varchar2(256) NOT NULL,
SFbckRgAv_MAX varchar2(256) NOT NULL,
FFbckRg_MIN varchar2(256) NOT NULL,
FFbckRg_MAX varchar2(256) NOT NULL,
SFbckRg_MIN varchar2(256) NOT NULL,
SFbckRg_MAX varchar2(256) NOT NULL,
FFbkRgPrCt_MIN varchar2(256) NOT NULL,
FFbkRgPrCt_MAX varchar2(256) NOT NULL,
SFbkRgPrCt_MIN varchar2(256) NOT NULL,
SFbkRgPrCt_MAX varchar2(256) NOT NULL,
FFbkRgPrPt_MIN varchar2(256) NOT NULL,
FFbkRgPrPt_MAX varchar2(256) NOT NULL,
SFbkRgPrPt_MIN varchar2(256) NOT NULL,
SFbkRgPrPt_MAX varchar2(256) NOT NULL,
FFbkTnAdCt_MIN varchar2(256) NOT NULL,
FFbkTnAdCt_MAX varchar2(256) NOT NULL,
SFbkTnAdCt_MIN varchar2(256) NOT NULL,
SFbkTnAdCt_MAX varchar2(256) NOT NULL,
FFbkTnVdCt_MIN varchar2(256) NOT NULL,
FFbkTnVdCt_MAX varchar2(256) NOT NULL,
SFbkTnVdCt_MIN varchar2(256) NOT NULL,
SFbkTnVdCt_MAX varchar2(256) NOT NULL
);

ALTER TABLE MTMFeedBckSmryTest_THRESH ADD constraint PK_MTMFeedBckSmryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMFeedBckSmryTest_THRESH ON MTMFeedBckSmryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMFeedBckSmryTest ON MTMFeedBckSmryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMFeedBckSmryTest ON MTMFeedBckSmryTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMVBSSStrmsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMVBSSStrmsTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
VBSStms Number(20,4) NOT NULL,
VBSStms_ST varchar2(32) NOT NULL,
VBSStmPrVpF Number(20,4) NOT NULL,
VBSStmPrVpF_ST varchar2(32) NOT NULL,
VBSPrVLsAv Number(20,4) NOT NULL,
VBSPrVLsAv_ST varchar2(32) NOT NULL,
VBSPrVFmeAv Number(20,4) NOT NULL,
VBSPrVFmeAv_ST varchar2(32) NOT NULL,
VBSPrStm Number(20,4) NOT NULL,
VBSPrStm_ST varchar2(32) NOT NULL,
VBSGdStm Number(20,4) NOT NULL,
VBSGdStm_ST varchar2(32) NOT NULL,
VBSUclfdStm Number(20,4) NOT NULL,
VBSUclfdStm_ST varchar2(32) NOT NULL,
VBSPrPrcnt Number(20,4) NOT NULL,
VBSPrPrcnt_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_MTMVBSSStrmsTest ON MTMVBSSStrmsTest(MSMT_TIME);
ALTER TABLE MTMVBSSStrmsTest ADD constraint PK_MTMVBSSStrmsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMVBSSStrmsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMVBSSStrmsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
VBSStms_MIN Number(20,4) NOT NULL,
VBSStms_MAX Number(20,4) NOT NULL,
VBSStms_STCNT varchar2(32) NOT NULL,
VBSStmPrVpF_MIN Number(20,4) NOT NULL,
VBSStmPrVpF_MAX Number(20,4) NOT NULL,
VBSStmPrVpF_STCNT varchar2(32) NOT NULL,
VBSPrVLsAv_MIN Number(20,4) NOT NULL,
VBSPrVLsAv_MAX Number(20,4) NOT NULL,
VBSPrVLsAv_STCNT varchar2(32) NOT NULL,
VBSPrVFmeAv_MIN Number(20,4) NOT NULL,
VBSPrVFmeAv_MAX Number(20,4) NOT NULL,
VBSPrVFmeAv_STCNT varchar2(32) NOT NULL,
VBSPrStm_MIN Number(20,4) NOT NULL,
VBSPrStm_MAX Number(20,4) NOT NULL,
VBSPrStm_STCNT varchar2(32) NOT NULL,
VBSGdStm_MIN Number(20,4) NOT NULL,
VBSGdStm_MAX Number(20,4) NOT NULL,
VBSGdStm_STCNT varchar2(32) NOT NULL,
VBSUclfdStm_MIN Number(20,4) NOT NULL,
VBSUclfdStm_MAX Number(20,4) NOT NULL,
VBSUclfdStm_STCNT varchar2(32) NOT NULL,
VBSPrPrcnt_MIN Number(20,4) NOT NULL,
VBSPrPrcnt_MAX Number(20,4) NOT NULL,
VBSPrPrcnt_STCNT varchar2(32) NOT NULL
);

ALTER TABLE MTMVBSSStrmsTest_TREND ADD constraint PK_MTMVBSSStrmsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMVBSSStrmsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMVBSSStrmsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
VBSStms_MIN varchar2(256) NOT NULL,
VBSStms_MAX varchar2(256) NOT NULL,
VBSStmPrVpF_MIN varchar2(256) NOT NULL,
VBSStmPrVpF_MAX varchar2(256) NOT NULL,
VBSPrVLsAv_MIN varchar2(256) NOT NULL,
VBSPrVLsAv_MAX varchar2(256) NOT NULL,
VBSPrVFmeAv_MIN varchar2(256) NOT NULL,
VBSPrVFmeAv_MAX varchar2(256) NOT NULL,
VBSPrStm_MIN varchar2(256) NOT NULL,
VBSPrStm_MAX varchar2(256) NOT NULL,
VBSGdStm_MIN varchar2(256) NOT NULL,
VBSGdStm_MAX varchar2(256) NOT NULL,
VBSUclfdStm_MIN varchar2(256) NOT NULL,
VBSUclfdStm_MAX varchar2(256) NOT NULL,
VBSPrPrcnt_MIN varchar2(256) NOT NULL,
VBSPrPrcnt_MAX varchar2(256) NOT NULL
);

ALTER TABLE MTMVBSSStrmsTest_THRESH ADD constraint PK_MTMVBSSStrmsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMVBSSStrmsTest_THRESH ON MTMVBSSStrmsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMVBSSStrmsTest ON MTMVBSSStrmsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMVBSSStrmsTest ON MTMVBSSStrmsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMCalSumryTest CASCADE CONSTRAINTS;
CREATE TABLE MTMCalSumryTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
TotStrmCt Number(20,4) NOT NULL,
TotStrmCt_ST varchar2(32) NOT NULL,
CDRAvlblstrmCt Number(20,4) NOT NULL,
CDRAvlblstrmCt_ST varchar2(32) NOT NULL,
MedFldStrmCt Number(20,4) NOT NULL,
MedFldStrmCt_ST varchar2(32) NOT NULL,
ClSupFldStrmCt Number(20,4) NOT NULL,
ClSupFldStrmCt_ST varchar2(32) NOT NULL,
ClDrpdStrmCt Number(20,4) NOT NULL,
ClDrpdStrmCt_ST varchar2(32) NOT NULL,
MedSudedStrmCt Number(20,4) NOT NULL,
MedSudedStrmCt_ST varchar2(32) NOT NULL,
ClSupSudStrmCt Number(20,4) NOT NULL,
ClSupSudStrmCt_ST varchar2(32) NOT NULL,
ClSupFlrPer Number(20,4) NOT NULL,
ClSupFlrPer_ST varchar2(32) NOT NULL,
ClDrpdFlrPer Number(20,4) NOT NULL,
ClDrpdFlrPer_ST varchar2(32) NOT NULL,
AnsSeiRatio Number(20,4) NOT NULL,
AnsSeiRatio_ST varchar2(32) NOT NULL,
ShrtCalPer Number(20,4) NOT NULL,
ShrtCalPer_ST varchar2(32) NOT NULL,
MedFlrPer Number(20,4) NOT NULL,
MedFlrPer_ST varchar2(32) NOT NULL,
AvgCalDurtn Number(20,4) NOT NULL,
AvgCalDurtn_ST varchar2(32) NOT NULL,
MedFldFWStrmCt Number(20,4) NOT NULL,
MedFldFWStrmCt_ST varchar2(32) NOT NULL,
FWMedFlrPer Number(20,4) NOT NULL,
FWMedFlrPer_ST varchar2(32) NOT NULL,
FWIPBldStrmCt Number(20,4) NOT NULL,
FWIPBldStrmCt_ST varchar2(32) NOT NULL,
FWIPBldMFlrPer Number(20,4) NOT NULL,
FWIPBldMFlrPer_ST varchar2(32) NOT NULL,
MFldOtrStrmCnt Number(20,4) NOT NULL,
MFldOtrStrmCnt_ST varchar2(32) NOT NULL,
OtrMedFlrPer Number(20,4) NOT NULL,
OtrMedFlrPer_ST varchar2(32) NOT NULL
);
CREATE INDEX IDX_MTMCalSumryTest ON MTMCalSumryTest(MSMT_TIME);
ALTER TABLE MTMCalSumryTest ADD constraint PK_MTMCalSumryTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE MTMCalSumryTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMCalSumryTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
TotStrmCt_MIN Number(20,4) NOT NULL,
TotStrmCt_MAX Number(20,4) NOT NULL,
TotStrmCt_STCNT varchar2(32) NOT NULL,
CDRAvlblstrmCt_MIN Number(20,4) NOT NULL,
CDRAvlblstrmCt_MAX Number(20,4) NOT NULL,
CDRAvlblstrmCt_STCNT varchar2(32) NOT NULL,
MedFldStrmCt_MIN Number(20,4) NOT NULL,
MedFldStrmCt_MAX Number(20,4) NOT NULL,
MedFldStrmCt_STCNT varchar2(32) NOT NULL,
ClSupFldStrmCt_MIN Number(20,4) NOT NULL,
ClSupFldStrmCt_MAX Number(20,4) NOT NULL,
ClSupFldStrmCt_STCNT varchar2(32) NOT NULL,
ClDrpdStrmCt_MIN Number(20,4) NOT NULL,
ClDrpdStrmCt_MAX Number(20,4) NOT NULL,
ClDrpdStrmCt_STCNT varchar2(32) NOT NULL,
MedSudedStrmCt_MIN Number(20,4) NOT NULL,
MedSudedStrmCt_MAX Number(20,4) NOT NULL,
MedSudedStrmCt_STCNT varchar2(32) NOT NULL,
ClSupSudStrmCt_MIN Number(20,4) NOT NULL,
ClSupSudStrmCt_MAX Number(20,4) NOT NULL,
ClSupSudStrmCt_STCNT varchar2(32) NOT NULL,
ClSupFlrPer_MIN Number(20,4) NOT NULL,
ClSupFlrPer_MAX Number(20,4) NOT NULL,
ClSupFlrPer_STCNT varchar2(32) NOT NULL,
ClDrpdFlrPer_MIN Number(20,4) NOT NULL,
ClDrpdFlrPer_MAX Number(20,4) NOT NULL,
ClDrpdFlrPer_STCNT varchar2(32) NOT NULL,
AnsSeiRatio_MIN Number(20,4) NOT NULL,
AnsSeiRatio_MAX Number(20,4) NOT NULL,
AnsSeiRatio_STCNT varchar2(32) NOT NULL,
ShrtCalPer_MIN Number(20,4) NOT NULL,
ShrtCalPer_MAX Number(20,4) NOT NULL,
ShrtCalPer_STCNT varchar2(32) NOT NULL,
MedFlrPer_MIN Number(20,4) NOT NULL,
MedFlrPer_MAX Number(20,4) NOT NULL,
MedFlrPer_STCNT varchar2(32) NOT NULL,
AvgCalDurtn_MIN Number(20,4) NOT NULL,
AvgCalDurtn_MAX Number(20,4) NOT NULL,
AvgCalDurtn_STCNT varchar2(32) NOT NULL,
MedFldFWStrmCt_MIN Number(20,4) NOT NULL,
MedFldFWStrmCt_MAX Number(20,4) NOT NULL,
MedFldFWStrmCt_STCNT varchar2(32) NOT NULL,
FWMedFlrPer_MIN Number(20,4) NOT NULL,
FWMedFlrPer_MAX Number(20,4) NOT NULL,
FWMedFlrPer_STCNT varchar2(32) NOT NULL,
FWIPBldStrmCt_MIN Number(20,4) NOT NULL,
FWIPBldStrmCt_MAX Number(20,4) NOT NULL,
FWIPBldStrmCt_STCNT varchar2(32) NOT NULL,
FWIPBldMFlrPer_MIN Number(20,4) NOT NULL,
FWIPBldMFlrPer_MAX Number(20,4) NOT NULL,
FWIPBldMFlrPer_STCNT varchar2(32) NOT NULL,
MFldOtrStrmCnt_MIN Number(20,4) NOT NULL,
MFldOtrStrmCnt_MAX Number(20,4) NOT NULL,
MFldOtrStrmCnt_STCNT varchar2(32) NOT NULL,
OtrMedFlrPer_MIN Number(20,4) NOT NULL,
OtrMedFlrPer_MAX Number(20,4) NOT NULL,
OtrMedFlrPer_STCNT varchar2(32) NOT NULL
);
ALTER TABLE MTMCalSumryTest_TREND ADD constraint PK_MTMCalSumryTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE MTMCalSumryTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMCalSumryTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
TotStrmCt_MIN varchar2(256) NOT NULL,
TotStrmCt_MAX varchar2(256) NOT NULL,
CDRAvlblstrmCt_MIN varchar2(256) NOT NULL,
CDRAvlblstrmCt_MAX varchar2(256) NOT NULL,
MedFldStrmCt_MIN varchar2(256) NOT NULL,
MedFldStrmCt_MAX varchar2(256) NOT NULL,
ClSupFldStrmCt_MIN varchar2(256) NOT NULL,
ClSupFldStrmCt_MAX varchar2(256) NOT NULL,
ClDrpdStrmCt_MIN varchar2(256) NOT NULL,
ClDrpdStrmCt_MAX varchar2(256) NOT NULL,
MedSudedStrmCt_MIN varchar2(256) NOT NULL,
MedSudedStrmCt_MAX varchar2(256) NOT NULL,
ClSupSudStrmCt_MIN varchar2(256) NOT NULL,
ClSupSudStrmCt_MAX varchar2(256) NOT NULL,
ClSupFlrPer_MIN varchar2(256) NOT NULL,
ClSupFlrPer_MAX varchar2(256) NOT NULL,
ClDrpdFlrPer_MIN varchar2(256) NOT NULL,
ClDrpdFlrPer_MAX varchar2(256) NOT NULL,
AnsSeiRatio_MIN varchar2(256) NOT NULL,
AnsSeiRatio_MAX varchar2(256) NOT NULL,
ShrtCalPer_MIN varchar2(256) NOT NULL,
ShrtCalPer_MAX varchar2(256) NOT NULL,
MedFlrPer_MIN varchar2(256) NOT NULL,
MedFlrPer_MAX varchar2(256) NOT NULL,
AvgCalDurtn_MIN varchar2(256) NOT NULL,
AvgCalDurtn_MAX varchar2(256) NOT NULL,
MedFldFWStrmCt_MIN varchar2(256) NOT NULL,
MedFldFWStrmCt_MAX varchar2(256) NOT NULL,
FWMedFlrPer_MIN varchar2(256) NOT NULL,
FWMedFlrPer_MAX varchar2(256) NOT NULL,
FWIPBldStrmCt_MIN varchar2(256) NOT NULL,
FWIPBldStrmCt_MAX varchar2(256) NOT NULL,
FWIPBldMFlrPer_MIN varchar2(256) NOT NULL,
FWIPBldMFlrPer_MAX varchar2(256) NOT NULL,
MFldOtrStrmCnt_MIN varchar2(256) NOT NULL,
MFldOtrStrmCnt_MAX varchar2(256) NOT NULL,
OtrMedFlrPer_MIN varchar2(256) NOT NULL,
OtrMedFlrPer_MAX varchar2(256) NOT NULL
);
ALTER TABLE MTMCalSumryTest_THRESH ADD constraint PK_MTMCalSumryTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMCalSumryTest_THRESH ON MTMCalSumryTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMCalSumryTest ON MTMCalSumryTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMCalSumryTest ON MTMCalSumryTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMSrvPrvStats CASCADE CONSTRAINTS;
CREATE TABLE MTMSrvPrvStats(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PNDING_ACTVTION Number(20,4) NOT NULL,
PNDING_ACTVTION_ST varchar2(32) NOT NULL,
PNDING_PRVISION Number(20,4) NOT NULL,
PNDING_PRVISION_ST varchar2(32) NOT NULL,
PNDING_INPUT Number(20,4) NOT NULL,
PNDING_INPUT_ST varchar2(32) NOT NULL,
SUCCESS Number(20,4) NOT NULL,
SUCCESS_ST varchar2(32) NOT NULL,
DISABLED Number(20,4) NOT NULL,
DISABLED_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMSrvPrvStats ON MTMSrvPrvStats(MSMT_TIME);
ALTER TABLE MTMSrvPrvStats ADD CONSTRAINT PK_MTMSrvPrvStats PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMSrvPrvStats_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMSrvPrvStats_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
PNDING_ACTVTION_MIN Number(20,4) NOT NULL,
PNDING_ACTVTION_MAX Number(20,4) NOT NULL,
PNDING_ACTVTION_STCNT varchar2(32) NOT NULL,
PNDING_PRVISION_MIN Number(20,4) NOT NULL,
PNDING_PRVISION_MAX Number(20,4) NOT NULL,
PNDING_PRVISION_STCNT varchar2(32) NOT NULL,
PNDING_INPUT_MIN Number(20,4) NOT NULL,
PNDING_INPUT_MAX Number(20,4) NOT NULL,
PNDING_INPUT_STCNT varchar2(32) NOT NULL,
SUCCESS_MIN Number(20,4) NOT NULL,
SUCCESS_MAX Number(20,4) NOT NULL,
SUCCESS_STCNT varchar2(32) NOT NULL,
DISABLED_MIN Number(20,4) NOT NULL,
DISABLED_MAX Number(20,4) NOT NULL,
DISABLED_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMSrvPrvStats_TREND ADD CONSTRAINT PK_MTMSrvPrvStats_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMSrvPrvStats_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMSrvPrvStats_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
PNDING_ACTVTION_MIN varchar2(256) NOT NULL,
PNDING_ACTVTION_MAX varchar2(256) NOT NULL,
PNDING_PRVISION_MIN varchar2(256) NOT NULL,
PNDING_PRVISION_MAX varchar2(256) NOT NULL,
PNDING_INPUT_MIN varchar2(256) NOT NULL,
PNDING_INPUT_MAX varchar2(256) NOT NULL,
SUCCESS_MIN varchar2(256) NOT NULL,
SUCCESS_MAX varchar2(256) NOT NULL,
DISABLED_MIN varchar2(256) NOT NULL,
DISABLED_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMSrvPrvStats_THRESH ADD CONSTRAINT PK_MTMSrvPrvStats_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMSrvPrvStats_THRESH ON MTMSrvPrvStats_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMSrvPrvStats ON MTMSrvPrvStats_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMSrvPrvStats ON MTMSrvPrvStats_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMUsrActvitiesTest CASCADE CONSTRAINTS;
CREATE TABLE MTMUsrActvitiesTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
uuteamchat Number(20,4) NOT NULL,
uuteamchat_ST varchar2(32) NOT NULL,
uuprvchat Number(20,4) NOT NULL,
uuprvchat_ST varchar2(32) NOT NULL,
uucalls Number(20,4) NOT NULL,
uucalls_ST varchar2(32) NOT NULL,
uumetings Number(20,4) NOT NULL,
uumetings_ST varchar2(32) NOT NULL,
uuothrAct Number(20,4) NOT NULL,
uuothrAct_ST varchar2(32) NOT NULL,
teamchat Number(20,4) NOT NULL,
teamchat_ST varchar2(32) NOT NULL,
privchat Number(20,4) NOT NULL,
privchat_ST varchar2(32) NOT NULL,
calls Number(20,4) NOT NULL,
calls_ST varchar2(32) NOT NULL,
meetings Number(20,4) NOT NULL,
meetings_ST varchar2(32) NOT NULL,
otherAct Number(20,4) NOT NULL,
otherAct_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMUsrActvitiesTest ON MTMUsrActvitiesTest(MSMT_TIME);
ALTER TABLE MTMUsrActvitiesTest ADD constraint PK_MTMUsrActvitiesTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMUsrActvitiesTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMUsrActvitiesTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
uuteamchat_MIN Number(20,4) NOT NULL,
uuteamchat_MAX Number(20,4) NOT NULL,
uuteamchat_STCNT varchar2(32) NOT NULL,
uuprvchat_MIN Number(20,4) NOT NULL,
uuprvchat_MAX Number(20,4) NOT NULL,
uuprvchat_STCNT varchar2(32) NOT NULL,
uucalls_MIN Number(20,4) NOT NULL,
uucalls_MAX Number(20,4) NOT NULL,
uucalls_STCNT varchar2(32) NOT NULL,
uumetings_MIN Number(20,4) NOT NULL,
uumetings_MAX Number(20,4) NOT NULL,
uumetings_STCNT varchar2(32) NOT NULL,
uuothrAct_MIN Number(20,4) NOT NULL,
uuothrAct_MAX Number(20,4) NOT NULL,
uuothrAct_STCNT varchar2(32) NOT NULL,
teamchat_MIN Number(20,4) NOT NULL,
teamchat_MAX Number(20,4) NOT NULL,
teamchat_STCNT varchar2(32) NOT NULL,
privchat_MIN Number(20,4) NOT NULL,
privchat_MAX Number(20,4) NOT NULL,
privchat_STCNT varchar2(32) NOT NULL,
calls_MIN Number(20,4) NOT NULL,
calls_MAX Number(20,4) NOT NULL,
calls_STCNT varchar2(32) NOT NULL,
meetings_MIN Number(20,4) NOT NULL,
meetings_MAX Number(20,4) NOT NULL,
meetings_STCNT varchar2(32) NOT NULL,
otherAct_MIN Number(20,4) NOT NULL,
otherAct_MAX Number(20,4) NOT NULL,
otherAct_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMUsrActvitiesTest_TREND ADD constraint PK_MTMUsrActvitiesTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMUsrActvitiesTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMUsrActvitiesTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
uuteamchat_MIN varchar2(256) NOT NULL,
uuteamchat_MAX varchar2(256) NOT NULL,
uuprvchat_MIN varchar2(256) NOT NULL,
uuprvchat_MAX varchar2(256) NOT NULL,
uucalls_MIN varchar2(256) NOT NULL,
uucalls_MAX varchar2(256) NOT NULL,
uumetings_MIN varchar2(256) NOT NULL,
uumetings_MAX varchar2(256) NOT NULL,
uuothrAct_MIN varchar2(256) NOT NULL,
uuothrAct_MAX varchar2(256) NOT NULL,
teamchat_MIN varchar2(256) NOT NULL,
teamchat_MAX varchar2(256) NOT NULL,
privchat_MIN varchar2(256) NOT NULL,
privchat_MAX varchar2(256) NOT NULL,
calls_MIN varchar2(256) NOT NULL,
calls_MAX varchar2(256) NOT NULL,
meetings_MIN varchar2(256) NOT NULL,
meetings_MAX varchar2(256) NOT NULL,
otherAct_MIN varchar2(256) NOT NULL,
otherAct_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMUsrActvitiesTest_THRESH ADD constraint PK_MTMUsrActvitiesTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMUsrActvitiesTest_THRESH ON MTMUsrActvitiesTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMUsrActvitiesTest ON MTMUsrActvitiesTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMUsrActvitiesTest ON MTMUsrActvitiesTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMTeamsInvTest CASCADE CONSTRAINTS;
CREATE TABLE MTMTeamsInvTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
teamscount Number(20,4) NOT NULL,
teamscount_ST varchar2(32) NOT NULL,
publictems Number(20,4) NOT NULL,
publictems_ST varchar2(32) NOT NULL,
privtetems Number(20,4) NOT NULL,
privtetems_ST varchar2(32) NOT NULL,
chanlsCnt Number(20,4) NOT NULL,
chanlsCnt_ST varchar2(32) NOT NULL,
activetems Number(20,4) NOT NULL,
activetems_ST varchar2(32) NOT NULL,
inactivtems Number(20,4) NOT NULL,
inactivtems_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMTeamsInvTest ON MTMTeamsInvTest(MSMT_TIME);
ALTER TABLE MTMTeamsInvTest ADD constraint PK_MTMTeamsInvTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMTeamsInvTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMTeamsInvTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
teamscount_MIN Number(20,4) NOT NULL,
teamscount_MAX Number(20,4) NOT NULL,
teamscount_STCNT varchar2(32) NOT NULL,
publictems_MIN Number(20,4) NOT NULL,
publictems_MAX Number(20,4) NOT NULL,
publictems_STCNT varchar2(32) NOT NULL,
privtetems_MIN Number(20,4) NOT NULL,
privtetems_MAX Number(20,4) NOT NULL,
privtetems_STCNT varchar2(32) NOT NULL,
chanlsCnt_MIN Number(20,4) NOT NULL,
chanlsCnt_MAX Number(20,4) NOT NULL,
chanlsCnt_STCNT varchar2(32) NOT NULL,
activetems_MIN Number(20,4) NOT NULL,
activetems_MAX Number(20,4) NOT NULL,
activetems_STCNT varchar2(32) NOT NULL,
inactivtems_MIN Number(20,4) NOT NULL,
inactivtems_MAX Number(20,4) NOT NULL,
inactivtems_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMTeamsInvTest_TREND ADD constraint PK_MTMTeamsInvTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMTeamsInvTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMTeamsInvTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
teamscount_MIN varchar2(256) NOT NULL,
teamscount_MAX varchar2(256) NOT NULL,
publictems_MIN varchar2(256) NOT NULL,
publictems_MAX varchar2(256) NOT NULL,
privtetems_MIN varchar2(256) NOT NULL,
privtetems_MAX varchar2(256) NOT NULL,
chanlsCnt_MIN varchar2(256) NOT NULL,
chanlsCnt_MAX varchar2(256) NOT NULL,
activetems_MIN varchar2(256) NOT NULL,
activetems_MAX varchar2(256) NOT NULL,
inactivtems_MIN varchar2(256) NOT NULL,
inactivtems_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMTeamsInvTest_THRESH ADD constraint PK_MTMTeamsInvTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMTeamsInvTest_THRESH ON MTMTeamsInvTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMTeamsInvTest ON MTMTeamsInvTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMTeamsInvTest ON MTMTeamsInvTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMtemsOAMactTest CASCADE CONSTRAINTS;
CREATE TABLE MTMtemsOAMactTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MemAdtions Number(20,4) NOT NULL,
MemAdtions_ST varchar2(32) NOT NULL,
MemRolChgd Number(20,4) NOT NULL,
MemRolChgd_ST varchar2(32) NOT NULL,
TemStgsChgd Number(20,4) NOT NULL,
TemStgsChgd_ST varchar2(32) NOT NULL,
temdelcnt Number(20,4) NOT NULL,
temdelcnt_ST varchar2(32) NOT NULL,
MembrRmvdCnt Number(20,4) NOT NULL,
MembrRmvdCnt_ST varchar2(32) NOT NULL,
CnlStgsCngCnt Number(20,4) NOT NULL,
CnlStgsCngCnt_ST varchar2(32) NOT NULL,
TmtentStgMds Number(20,4) NOT NULL,
TmtentStgMds_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMtemsOAMactTest ON MTMtemsOAMactTest(MSMT_TIME);
ALTER TABLE MTMtemsOAMactTest ADD constraint PK_MTMtemsOAMactTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMtemsOAMactTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMtemsOAMactTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MemAdtions_MIN Number(20,4) NOT NULL,
MemAdtions_MAX Number(20,4) NOT NULL,
MemAdtions_STCNT varchar2(32) NOT NULL,
MemRolChgd_MIN Number(20,4) NOT NULL,
MemRolChgd_MAX Number(20,4) NOT NULL,
MemRolChgd_STCNT varchar2(32) NOT NULL,
TemStgsChgd_MIN Number(20,4) NOT NULL,
TemStgsChgd_MAX Number(20,4) NOT NULL,
TemStgsChgd_STCNT varchar2(32) NOT NULL,
temdelcnt_MIN Number(20,4) NOT NULL,
temdelcnt_MAX Number(20,4) NOT NULL,
temdelcnt_STCNT varchar2(32) NOT NULL,
MembrRmvdCnt_MIN Number(20,4) NOT NULL,
MembrRmvdCnt_MAX Number(20,4) NOT NULL,
MembrRmvdCnt_STCNT varchar2(32) NOT NULL,
CnlStgsCngCnt_MIN Number(20,4) NOT NULL,
CnlStgsCngCnt_MAX Number(20,4) NOT NULL,
CnlStgsCngCnt_STCNT varchar2(32) NOT NULL,
TmtentStgMds_MIN Number(20,4) NOT NULL,
TmtentStgMds_MAX Number(20,4) NOT NULL,
TmtentStgMds_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMtemsOAMactTest_TREND ADD constraint PK_MTMtemsOAMactTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMtemsOAMactTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMtemsOAMactTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MemAdtions_MIN varchar2(256) NOT NULL,
MemAdtions_MAX varchar2(256) NOT NULL,
MemRolChgd_MIN varchar2(256) NOT NULL,
MemRolChgd_MAX varchar2(256) NOT NULL,
TemStgsChgd_MIN varchar2(256) NOT NULL,
TemStgsChgd_MAX varchar2(256) NOT NULL,
temdelcnt_MIN varchar2(256) NOT NULL,
temdelcnt_MAX varchar2(256) NOT NULL,
MembrRmvdCnt_MIN varchar2(256) NOT NULL,
MembrRmvdCnt_MAX varchar2(256) NOT NULL,
CnlStgsCngCnt_MIN varchar2(256) NOT NULL,
CnlStgsCngCnt_MAX varchar2(256) NOT NULL,
TmtentStgMds_MIN varchar2(256) NOT NULL,
TmtentStgMds_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMtemsOAMactTest_THRESH ADD constraint PK_MTMtemsOAMactTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMtemsOAMactTest_THRESH ON MTMtemsOAMactTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMtemsOAMactTest ON MTMtemsOAMactTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMtemsOAMactTest ON MTMtemsOAMactTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMtmChnlOperTest CASCADE CONSTRAINTS;
CREATE TABLE MTMtmChnlOperTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
botsAdditnCnt Number(20,4) NOT NULL,
botsAdditnCnt_ST varchar2(32) NOT NULL,
botsRemvedCnt Number(20,4) NOT NULL,
botsRemvedCnt_ST varchar2(32) NOT NULL,
chanlsAdtCnt Number(20,4) NOT NULL,
chanlsAdtCnt_ST varchar2(32) NOT NULL,
chanlsDelCnt Number(20,4) NOT NULL,
chanlsDelCnt_ST varchar2(32) NOT NULL,
temCreatCnt Number(20,4) NOT NULL,
temCreatCnt_ST varchar2(32) NOT NULL,
CnctAdtsClCnt Number(20,4) NOT NULL,
CnctAdtsClCnt_ST varchar2(32) NOT NULL,
TabAddtoClCnt Number(20,4) NOT NULL,
TabAddtoClCnt_ST varchar2(32) NOT NULL,
CnctrRmdClCnt Number(20,4) NOT NULL,
CnctrRmdClCnt_ST varchar2(32) NOT NULL,
TabRmdClCnt Number(20,4) NOT NULL,
TabRmdClCnt_ST varchar2(32) NOT NULL,
CnctMfInClCnt Number(20,4) NOT NULL,
CnctMfInClCnt_ST varchar2(32) NOT NULL,
TabMfInClCnt Number(20,4) NOT NULL,
TabMfInClCnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMtmChnlOperTest ON MTMtmChnlOperTest(MSMT_TIME);
ALTER TABLE MTMtmChnlOperTest ADD constraint PK_MTMtmChnlOperTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMtmChnlOperTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMtmChnlOperTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
botsAdditnCnt_MIN Number(20,4) NOT NULL,
botsAdditnCnt_MAX Number(20,4) NOT NULL,
botsAdditnCnt_STCNT varchar2(32) NOT NULL,
botsRemvedCnt_MIN Number(20,4) NOT NULL,
botsRemvedCnt_MAX Number(20,4) NOT NULL,
botsRemvedCnt_STCNT varchar2(32) NOT NULL,
chanlsAdtCnt_MIN Number(20,4) NOT NULL,
chanlsAdtCnt_MAX Number(20,4) NOT NULL,
chanlsAdtCnt_STCNT varchar2(32) NOT NULL,
chanlsDelCnt_MIN Number(20,4) NOT NULL,
chanlsDelCnt_MAX Number(20,4) NOT NULL,
chanlsDelCnt_STCNT varchar2(32) NOT NULL,
temCreatCnt_MIN Number(20,4) NOT NULL,
temCreatCnt_MAX Number(20,4) NOT NULL,
temCreatCnt_STCNT varchar2(32) NOT NULL,
CnctAdtsClCnt_MIN Number(20,4) NOT NULL,
CnctAdtsClCnt_MAX Number(20,4) NOT NULL,
CnctAdtsClCnt_STCNT varchar2(32) NOT NULL,
TabAddtoClCnt_MIN Number(20,4) NOT NULL,
TabAddtoClCnt_MAX Number(20,4) NOT NULL,
TabAddtoClCnt_STCNT varchar2(32) NOT NULL,
CnctrRmdClCnt_MIN Number(20,4) NOT NULL,
CnctrRmdClCnt_MAX Number(20,4) NOT NULL,
CnctrRmdClCnt_STCNT varchar2(32) NOT NULL,
TabRmdClCnt_MIN Number(20,4) NOT NULL,
TabRmdClCnt_MAX Number(20,4) NOT NULL,
TabRmdClCnt_STCNT varchar2(32) NOT NULL,
CnctMfInClCnt_MIN Number(20,4) NOT NULL,
CnctMfInClCnt_MAX Number(20,4) NOT NULL,
CnctMfInClCnt_STCNT varchar2(32) NOT NULL,
TabMfInClCnt_MIN Number(20,4) NOT NULL,
TabMfInClCnt_MAX Number(20,4) NOT NULL,
TabMfInClCnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMtmChnlOperTest_TREND ADD constraint PK_MTMtmChnlOperTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMtmChnlOperTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMtmChnlOperTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
botsAdditnCnt_MIN varchar2(256) NOT NULL,
botsAdditnCnt_MAX varchar2(256) NOT NULL,
botsRemvedCnt_MIN varchar2(256) NOT NULL,
botsRemvedCnt_MAX varchar2(256) NOT NULL,
chanlsAdtCnt_MIN varchar2(256) NOT NULL,
chanlsAdtCnt_MAX varchar2(256) NOT NULL,
chanlsDelCnt_MIN varchar2(256) NOT NULL,
chanlsDelCnt_MAX varchar2(256) NOT NULL,
temCreatCnt_MIN varchar2(256) NOT NULL,
temCreatCnt_MAX varchar2(256) NOT NULL,
CnctAdtsClCnt_MIN varchar2(256) NOT NULL,
CnctAdtsClCnt_MAX varchar2(256) NOT NULL,
TabAddtoClCnt_MIN varchar2(256) NOT NULL,
TabAddtoClCnt_MAX varchar2(256) NOT NULL,
CnctrRmdClCnt_MIN varchar2(256) NOT NULL,
CnctrRmdClCnt_MAX varchar2(256) NOT NULL,
TabRmdClCnt_MIN varchar2(256) NOT NULL,
TabRmdClCnt_MAX varchar2(256) NOT NULL,
CnctMfInClCnt_MIN varchar2(256) NOT NULL,
CnctMfInClCnt_MAX varchar2(256) NOT NULL,
TabMfInClCnt_MIN varchar2(256) NOT NULL,
TabMfInClCnt_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMtmChnlOperTest_THRESH ADD constraint PK_MTMtmChnlOperTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMtmChnlOperTest_THRESH ON MTMtmChnlOperTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMtmChnlOperTest ON MTMtmChnlOperTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMtmChnlOperTest ON MTMtmChnlOperTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMUsrLoginsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMUsrLoginsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
UsrloginsCnt Number(20,4) NOT NULL,
UsrloginsCnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMUsrLoginsTest ON MTMUsrLoginsTest(MSMT_TIME);
ALTER TABLE MTMUsrLoginsTest ADD constraint PK_MTMUsrLoginsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMUsrLoginsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMUsrLoginsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
UsrloginsCnt_MIN Number(20,4) NOT NULL,
UsrloginsCnt_MAX Number(20,4) NOT NULL,
UsrloginsCnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMUsrLoginsTest_TREND ADD constraint PK_MTMUsrLoginsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMUsrLoginsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMUsrLoginsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
UsrloginsCnt_MIN varchar2(256) NOT NULL,
UsrloginsCnt_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMUsrLoginsTest_THRESH ADD constraint PK_MTMUsrLoginsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMUsrLoginsTest_THRESH ON MTMUsrLoginsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMUsrLoginsTest ON MTMUsrLoginsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMUsrLoginsTest ON MTMUsrLoginsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMMsgCentTest CASCADE CONSTRAINTS;
CREATE TABLE MTMMsgCentTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMMsgCentTest ON MTMMsgCentTest(MSMT_TIME);
ALTER TABLE MTMMsgCentTest ADD constraint PK_MTMMsgCentTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMMsgCentTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMMsgCentTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMMsgCentTest_TREND ADD constraint PK_MTMMsgCentTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMMsgCentTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMMsgCentTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MsgCenterCommunication_MIN varchar2(256) NOT NULL,
MsgCenterCommunication_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMMsgCentTest_THRESH ADD constraint PK_MTMMsgCentTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMMsgCentTest_THRESH ON MTMMsgCentTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMMsgCentTest ON MTMMsgCentTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMMsgCentTest ON MTMMsgCentTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMConneChecksTest CASCADE CONSTRAINTS;
CREATE TABLE MTMConneChecksTest( 
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Connection_Status Number(20,4) NOT NULL,
Connection_Status_ST varchar2(32) NOT NULL,
Time_taken_to_connect Number(20,4) NOT NULL,
Time_taken_to_connect_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMConneChecksTest ON MTMConneChecksTest(MSMT_TIME);
ALTER TABLE MTMConneChecksTest ADD constraint PK_MTMConneChecksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMConneChecksTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMConneChecksTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Connection_Status_MIN Number(20,4) NOT NULL,
Connection_Status_MAX Number(20,4) NOT NULL,
Connection_Status_STCNT varchar2(32) NOT NULL,
Time_taken_to_connect_MIN Number(20,4) NOT NULL,
Time_taken_to_connect_MAX Number(20,4) NOT NULL,
Time_taken_to_connect_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMConneChecksTest_TREND ADD constraint PK_MTMConneChecksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMConneChecksTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMConneChecksTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Connection_Status_MIN varchar2(256) NOT NULL,
Connection_Status_MAX varchar2(256) NOT NULL,
Time_taken_to_connect_MIN varchar2(256) NOT NULL,
Time_taken_to_connect_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMConneChecksTest_THRESH ADD constraint PK_MTMConneChecksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMConneChecksTest_THRESH ON MTMConneChecksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMConneChecksTest ON MTMConneChecksTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMConneChecksTest ON MTMConneChecksTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE MTMCallConnTest CASCADE CONSTRAINTS;
CREATE TABLE MTMCallConnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
CALLS_INITIATED Number(20,4) NOT NULL,
CALLS_INITIATED_ST varchar2(32) NOT NULL,
CALLS_COMPLETED Number(20,4) NOT NULL,
CALLS_COMPLETED_ST varchar2(32) NOT NULL,
CALLS_FAILED Number(20,4) NOT NULL,
CALLS_FAILED_ST varchar2(32) NOT NULL,
CONN_CHECKS_STATUS Number(20,4) NOT NULL,
CONN_CHECKS_STATUS_ST varchar2(32) NOT NULL,
PACKT_LOSS_RATE Number(20,4) NOT NULL,
PACKT_LOSS_RATE_ST varchar2(32) NOT NULL,
RTT_LATENCY Number(20,4) NOT NULL,
RTT_LATENCY_ST varchar2(32) NOT NULL,
JITTER Number(20,4) NOT NULL,
JITTER_ST varchar2(32) NOT NULL,
PACKT_REORDER_RATIO Number(20,4) NOT NULL,
PACKT_REORDER_RATIO_ST varchar2(32) NOT NULL,
MOS_SCORE Number(20,4) NOT NULL,
MOS_SCORE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMCallConnTest ON MTMCallConnTest(MSMT_TIME);
ALTER TABLE MTMCallConnTest ADD constraint PK_MTMCallConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMCallConnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMCallConnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
CALLS_INITIATED_MIN Number(20,4) NOT NULL,
CALLS_INITIATED_MAX Number(20,4) NOT NULL,
CALLS_INITIATED_STCNT varchar2(32) NOT NULL,
CALLS_COMPLETED_MIN Number(20,4) NOT NULL,
CALLS_COMPLETED_MAX Number(20,4) NOT NULL,
CALLS_COMPLETED_STCNT varchar2(32) NOT NULL,
CALLS_FAILED_MIN Number(20,4) NOT NULL,
CALLS_FAILED_MAX Number(20,4) NOT NULL,
CALLS_FAILED_STCNT varchar2(32) NOT NULL,
CONN_CHECKS_STATUS_MIN Number(20,4) NOT NULL,
CONN_CHECKS_STATUS_MAX Number(20,4) NOT NULL,
CONN_CHECKS_STATUS_STCNT varchar2(32) NOT NULL,
PACKT_LOSS_RATE_MIN Number(20,4) NOT NULL,
PACKT_LOSS_RATE_MAX Number(20,4) NOT NULL,
PACKT_LOSS_RATE_STCNT varchar2(32) NOT NULL,
RTT_LATENCY_MIN Number(20,4) NOT NULL,
RTT_LATENCY_MAX Number(20,4) NOT NULL,
RTT_LATENCY_STCNT varchar2(32) NOT NULL,
JITTER_MIN Number(20,4) NOT NULL,
JITTER_MAX Number(20,4) NOT NULL,
JITTER_STCNT varchar2(32) NOT NULL,
PACKT_REORDER_RATIO_MIN Number(20,4) NOT NULL,
PACKT_REORDER_RATIO_MAX Number(20,4) NOT NULL,
PACKT_REORDER_RATIO_STCNT varchar2(32) NOT NULL,
MOS_SCORE_MIN Number(20,4) NOT NULL,
MOS_SCORE_MAX Number(20,4) NOT NULL,
MOS_SCORE_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMCallConnTest_TREND ADD constraint PK_MTMCallConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMCallConnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMCallConnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
CALLS_INITIATED_MIN varchar2(256) NOT NULL,
CALLS_INITIATED_MAX varchar2(256) NOT NULL,
CALLS_COMPLETED_MIN varchar2(256) NOT NULL,
CALLS_COMPLETED_MAX varchar2(256) NOT NULL,
CALLS_FAILED_MIN varchar2(256) NOT NULL,
CALLS_FAILED_MAX varchar2(256) NOT NULL,
CONN_CHECKS_STATUS_MIN varchar2(256) NOT NULL,
CONN_CHECKS_STATUS_MAX varchar2(256) NOT NULL,
PACKT_LOSS_RATE_MIN varchar2(256) NOT NULL,
PACKT_LOSS_RATE_MAX varchar2(256) NOT NULL,
RTT_LATENCY_MIN varchar2(256) NOT NULL,
RTT_LATENCY_MAX varchar2(256) NOT NULL,
JITTER_MIN varchar2(256) NOT NULL,
JITTER_MAX varchar2(256) NOT NULL,
PACKT_REORDER_RATIO_MIN varchar2(256) NOT NULL,
PACKT_REORDER_RATIO_MAX varchar2(256) NOT NULL,
MOS_SCORE_MIN varchar2(256) NOT NULL,
MOS_SCORE_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMCallConnTest_THRESH ADD constraint PK_MTMCallConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMCallConnTest_THRESH ON MTMCallConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMCallConnTest ON MTMCallConnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMCallConnTest ON MTMCallConnTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE MTMDeviceUsrDtlsTest CASCADE CONSTRAINTS;
CREATE TABLE MTMDeviceUsrDtlsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_MTMDeviceUsrDtlsTest ON MTMDeviceUsrDtlsTest(MSMT_TIME);
ALTER TABLE MTMDeviceUsrDtlsTest ADD constraint PK_MTMDeviceUsrDtlsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE MTMDeviceUsrDtlsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE MTMDeviceUsrDtlsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL);

ALTER TABLE MTMDeviceUsrDtlsTest_TREND ADD constraint PK_MTMDeviceUsrDtlsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE MTMDeviceUsrDtlsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE MTMDeviceUsrDtlsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Unique_users_MIN varchar2(256) NOT NULL,
Unique_users_MAX varchar2(256) NOT NULL);

ALTER TABLE MTMDeviceUsrDtlsTest_THRESH ADD constraint PK_MTMDevicUsrDtlTst_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_MTMDevicUsrDtlTst_THRESH ON MTMDeviceUsrDtlsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_MTMDeviceUsrDtlsTest ON MTMDeviceUsrDtlsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_MTMDeviceUsrDtlsTest ON MTMDeviceUsrDtlsTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE O365GrpsActsTest CASCADE CONSTRAINTS;
CREATE TABLE O365GrpsActsTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
mbstrgeusdbyGrps Number(20,4) NOT NULL,
mbstrgeusdbyGrps_ST varchar2(32) NOT NULL,
mbItemsinGrps Number(20,4) NOT NULL,
mbItemsinGrps_ST varchar2(32) NOT NULL,
ShrePointfilsCnt Number(20,4) NOT NULL,
ShrePointfilsCnt_ST varchar2(32) NOT NULL,
ShrePointSteStgeUsd Number(20,4) NOT NULL,
ShrePointSteStgeUsd_ST varchar2(32) NOT NULL,
ShrePntActfilsCnt Number(20,4) NOT NULL,
ShrePntActfilsCnt_ST varchar2(32) NOT NULL,
mailRcvdCnt Number(20,4) NOT NULL,
mailRcvdCnt_ST varchar2(32) NOT NULL,
ymmerPstedMsgCnt Number(20,4) NOT NULL,
ymmerPstedMsgCnt_ST varchar2(32) NOT NULL,
ymlReadmsgCnt Number(20,4) NOT NULL,
ymlReadmsgCnt_ST varchar2(32) NOT NULL,
ymrlikedMsgCnt Number(20,4) NOT NULL,
ymrlikedMsgCnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365GrpsActsTest ON O365GrpsActsTest(MSMT_TIME);
ALTER TABLE O365GrpsActsTest ADD constraint PK_O365GrpsActsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365GrpsActsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365GrpsActsTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
mbstrgeusdbyGrps_MIN Number(20,4) NOT NULL,
mbstrgeusdbyGrps_MAX Number(20,4) NOT NULL,
mbstrgeusdbyGrps_STCNT varchar2(32) NOT NULL,
mbItemsinGrps_MIN Number(20,4) NOT NULL,
mbItemsinGrps_MAX Number(20,4) NOT NULL,
mbItemsinGrps_STCNT varchar2(32) NOT NULL,
ShrePointfilsCnt_MIN Number(20,4) NOT NULL,
ShrePointfilsCnt_MAX Number(20,4) NOT NULL,
ShrePointfilsCnt_STCNT varchar2(32) NOT NULL,
ShrePointSteStgeUsd_MIN Number(20,4) NOT NULL,
ShrePointSteStgeUsd_MAX Number(20,4) NOT NULL,
ShrePointSteStgeUsd_STCNT varchar2(32) NOT NULL,
ShrePntActfilsCnt_MIN Number(20,4) NOT NULL,
ShrePntActfilsCnt_MAX Number(20,4) NOT NULL,
ShrePntActfilsCnt_STCNT varchar2(32) NOT NULL,
mailRcvdCnt_MIN Number(20,4) NOT NULL,
mailRcvdCnt_MAX Number(20,4) NOT NULL,
mailRcvdCnt_STCNT varchar2(32) NOT NULL,
ymmerPstedMsgCnt_MIN Number(20,4) NOT NULL,
ymmerPstedMsgCnt_MAX Number(20,4) NOT NULL,
ymmerPstedMsgCnt_STCNT varchar2(32) NOT NULL,
ymlReadmsgCnt_MIN Number(20,4) NOT NULL,
ymlReadmsgCnt_MAX Number(20,4) NOT NULL,
ymlReadmsgCnt_STCNT varchar2(32) NOT NULL,
ymrlikedMsgCnt_MIN Number(20,4) NOT NULL,
ymrlikedMsgCnt_MAX Number(20,4) NOT NULL,
ymrlikedMsgCnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365GrpsActsTest_TREND ADD constraint PK_O365GrpsActsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365GrpsActsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365GrpsActsTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
mbstrgeusdbyGrps_MIN varchar2(256) NOT NULL,
mbstrgeusdbyGrps_MAX varchar2(256) NOT NULL,
mbItemsinGrps_MIN varchar2(256) NOT NULL,
mbItemsinGrps_MAX varchar2(256) NOT NULL,
ShrePointfilsCnt_MIN varchar2(256) NOT NULL,
ShrePointfilsCnt_MAX varchar2(256) NOT NULL,
ShrePointSteStgeUsd_MIN varchar2(256) NOT NULL,
ShrePointSteStgeUsd_MAX varchar2(256) NOT NULL,
ShrePntActfilsCnt_MIN varchar2(256) NOT NULL,
ShrePntActfilsCnt_MAX varchar2(256) NOT NULL,
mailRcvdCnt_MIN varchar2(256) NOT NULL,
mailRcvdCnt_MAX varchar2(256) NOT NULL,
ymmerPstedMsgCnt_MIN varchar2(256) NOT NULL,
ymmerPstedMsgCnt_MAX varchar2(256) NOT NULL,
ymlReadmsgCnt_MIN varchar2(256) NOT NULL,
ymlReadmsgCnt_MAX varchar2(256) NOT NULL,
ymrlikedMsgCnt_MIN varchar2(256) NOT NULL,
ymrlikedMsgCnt_MAX varchar2(256) NOT NULL);

ALTER TABLE O365GrpsActsTest_THRESH ADD constraint PK_O365GrpsActsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365GrpsActsTest_THRESH ON O365GrpsActsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365GrpsActsTest ON O365GrpsActsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365GrpsActsTest ON O365GrpsActsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UsrStusBySrvTest CASCADE CONSTRAINTS;
CREATE TABLE O365UsrStusBySrvTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Active_Usrs Number(20,4) NOT NULL,
Active_Usrs_ST varchar2(32) NOT NULL,
InActive_Usrs Number(20,4) NOT NULL,
InActive_Usrs_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365UsrStusBySrvTest ON O365UsrStusBySrvTest(MSMT_TIME);
ALTER TABLE O365UsrStusBySrvTest ADD constraint PK_O365UsrStusBySrvTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UsrStusBySrvTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365UsrStusBySrvTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Active_Usrs_MIN Number(20,4) NOT NULL,
Active_Usrs_MAX Number(20,4) NOT NULL,
Active_Usrs_STCNT varchar2(32) NOT NULL,
InActive_Usrs_MIN Number(20,4) NOT NULL,
InActive_Usrs_MAX Number(20,4) NOT NULL,
InActive_Usrs_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365UsrStusBySrvTest_TREND ADD constraint PK_O365UsrStusBySrvTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UsrStusBySrvTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365UsrStusBySrvTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Active_Usrs_MIN varchar2(256) NOT NULL,
Active_Usrs_MAX varchar2(256) NOT NULL,
InActive_Usrs_MIN varchar2(256) NOT NULL,
InActive_Usrs_MAX varchar2(256) NOT NULL);

ALTER TABLE O365UsrStusBySrvTest_THRESH ADD constraint PK_O365UsrStusBySrvTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UsrStuBySrvTest_THRESH ON O365UsrStusBySrvTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UsrStusBySrvTest ON O365UsrStusBySrvTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UsrStusBySrvTest ON O365UsrStusBySrvTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365FailedLoginTest CASCADE CONSTRAINTS;
CREATE TABLE O365FailedLoginTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SUCCESS_LOG Number(20,4) NOT NULL,
SUCCESS_LOG_ST varchar2(32) NOT NULL,
FAILED_LOG Number(20,4) NOT NULL,
FAILED_LOG_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365FailedLoginTest ON O365FailedLoginTest(MSMT_TIME);
ALTER TABLE O365FailedLoginTest ADD constraint PK_O365FailedLoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);

DROP TABLE O365FailedLoginTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365FailedLoginTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SUCCESS_LOG_MIN Number(20,4) NOT NULL,
SUCCESS_LOG_MAX Number(20,4) NOT NULL,
SUCCESS_LOG_STCNT varchar2(32) NOT NULL,
FAILED_LOG_MIN Number(20,4) NOT NULL,
FAILED_LOG_MAX Number(20,4) NOT NULL,
FAILED_LOG_STCNT varchar2(32) NOT NULL);
ALTER TABLE O365FailedLoginTest_TREND ADD constraint PK_O365FailedLoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);

DROP TABLE O365FailedLoginTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365FailedLoginTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SUCCESS_LOG_MIN VARCHAR2(256) NOT NULL,
SUCCESS_LOG_MAX VARCHAR2(256) NOT NULL,
FAILED_LOG_MIN VARCHAR2(256) NOT NULL,
FAILED_LOG_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE O365FailedLoginTest_THRESH ADD constraint PK_O365FailedLoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365FailedLoginTest_THRESH ON O365FailedLoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365FailedLoginTest ON O365FailedLoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365FailedLoginTest ON O365FailedLoginTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SBOUsersTest CASCADE CONSTRAINTS;
CREATE TABLE SBOUsersTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
totalUsers Number(20,4) NOT NULL,
totalUsers_ST varchar2(32) NOT NULL,
unAssigned Number(20,4) NOT NULL,
unAssigned_ST varchar2(32) NOT NULL,
dialUpConf Number(20,4) NOT NULL,
dialUpConf_ST varchar2(32) NOT NULL,
createdUsers Number(20,4) NOT NULL,
createdUsers_ST varchar2(32) NOT NULL,
modifiedUsers Number(20,4) NOT NULL,
modifiedUsers_ST varchar2(32) NOT NULL,
softDeleteUsers Number(20,4) NOT NULL,
softDeleteUsers_ST varchar2(32) NOT NULL,
activeUsers Number(20,4) NOT NULL,
activeUsers_ST varchar2(32) NOT NULL,
inActiveUsers Number(20,4) NOT NULL,
inActiveUsers_ST varchar2(32) NOT NULL,
NvrLogUser Number(20,4) NOT NULL,
NvrLogUser_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOUsersTest ON SBOUsersTest(MSMT_TIME);
ALTER TABLE SBOUsersTest ADD constraint PK_SBOUsersTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOUsersTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOUsersTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
totalUsers_MIN Number(20,4) NOT NULL,
totalUsers_MAX Number(20,4) NOT NULL,
totalUsers_STCNT varchar2(32) NOT NULL,
unAssigned_MIN Number(20,4) NOT NULL,
unAssigned_MAX Number(20,4) NOT NULL,
unAssigned_STCNT varchar2(32) NOT NULL,
dialUpConf_MIN Number(20,4) NOT NULL,
dialUpConf_MAX Number(20,4) NOT NULL,
dialUpConf_STCNT varchar2(32) NOT NULL,
createdUsers_MIN Number(20,4) NOT NULL,
createdUsers_MAX Number(20,4) NOT NULL,
createdUsers_STCNT varchar2(32) NOT NULL,
modifiedUsers_MIN Number(20,4) NOT NULL,
modifiedUsers_MAX Number(20,4) NOT NULL,
modifiedUsers_STCNT varchar2(32) NOT NULL,
softDeleteUsers_MIN Number(20,4) NOT NULL,
softDeleteUsers_MAX Number(20,4) NOT NULL,
softDeleteUsers_STCNT varchar2(32) NOT NULL,
activeUsers_MIN Number(20,4) NOT NULL,
activeUsers_MAX Number(20,4) NOT NULL,
activeUsers_STCNT varchar2(32) NOT NULL,
inActiveUsers_MIN Number(20,4) NOT NULL,
inActiveUsers_MAX Number(20,4) NOT NULL,
inActiveUsers_STCNT varchar2(32) NOT NULL,
NvrLogUser_MIN Number(20,4) NOT NULL,
NvrLogUser_MAX Number(20,4) NOT NULL,
NvrLogUser_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOUsersTest_TREND ADD constraint PK_SBOUsersTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOUsersTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOUsersTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
totalUsers_MIN VARCHAR2(256) NOT NULL,
totalUsers_MAX VARCHAR2(256) NOT NULL,
unAssigned_MIN VARCHAR2(256) NOT NULL,
unAssigned_MAX VARCHAR2(256) NOT NULL,
dialUpConf_MIN VARCHAR2(256) NOT NULL,
dialUpConf_MAX VARCHAR2(256) NOT NULL,
createdUsers_MIN VARCHAR2(256) NOT NULL,
createdUsers_MAX VARCHAR2(256) NOT NULL,
modifiedUsers_MIN VARCHAR2(256) NOT NULL,
modifiedUsers_MAX VARCHAR2(256) NOT NULL,
softDeleteUsers_MIN VARCHAR2(256) NOT NULL,
softDeleteUsers_MAX VARCHAR2(256) NOT NULL,
activeUsers_MIN VARCHAR2(256) NOT NULL,
activeUsers_MAX VARCHAR2(256) NOT NULL,
inActiveUsers_MIN VARCHAR2(256) NOT NULL,
inActiveUsers_MAX VARCHAR2(256) NOT NULL,
NvrLogUser_MIN VARCHAR2(256) NOT NULL,
NvrLogUser_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOUsersTest_THRESH ADD constraint PK_SBOUsersTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOUsersTest_THRESH ON SBOUsersTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOUsersTest ON SBOUsersTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOUsersTest ON SBOUsersTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOSrvPrvStats CASCADE CONSTRAINTS;
CREATE TABLE SBOSrvPrvStats(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Pnding_Actvtion Number(20,4) NOT NULL,
Pnding_Actvtion_ST varchar2(32) NOT NULL,
Pnding_Prvision Number(20,4) NOT NULL,
Pnding_Prvision_ST varchar2(32) NOT NULL,
Pnding_input Number(20,4) NOT NULL,
Pnding_input_ST varchar2(32) NOT NULL,
Success Number(20,4) NOT NULL,
Success_ST varchar2(32) NOT NULL,
Disabled Number(20,4) NOT NULL,
Disabled_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOSrvPrvStats ON SBOSrvPrvStats(MSMT_TIME);
ALTER TABLE SBOSrvPrvStats ADD constraint PK_SBOSrvPrvStats PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOSrvPrvStats_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOSrvPrvStats_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Pnding_Actvtion_MIN Number(20,4) NOT NULL,
Pnding_Actvtion_MAX Number(20,4) NOT NULL,
Pnding_Actvtion_STCNT varchar2(32) NOT NULL,
Pnding_Prvision_MIN Number(20,4) NOT NULL,
Pnding_Prvision_MAX Number(20,4) NOT NULL,
Pnding_Prvision_STCNT varchar2(32) NOT NULL,
Pnding_input_MIN Number(20,4) NOT NULL,
Pnding_input_MAX Number(20,4) NOT NULL,
Pnding_input_STCNT varchar2(32) NOT NULL,
Success_MIN Number(20,4) NOT NULL,
Success_MAX Number(20,4) NOT NULL,
Success_STCNT varchar2(32) NOT NULL,
Disabled_MIN Number(20,4) NOT NULL,
Disabled_MAX Number(20,4) NOT NULL,
Disabled_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOSrvPrvStats_TREND ADD constraint PK_SBOSrvPrvStats_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOSrvPrvStats_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOSrvPrvStats_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Pnding_Actvtion_MIN VARCHAR2(256) NOT NULL,
Pnding_Actvtion_MAX VARCHAR2(256) NOT NULL,
Pnding_Prvision_MIN VARCHAR2(256) NOT NULL,
Pnding_Prvision_MAX VARCHAR2(256) NOT NULL,
Pnding_input_MIN VARCHAR2(256) NOT NULL,
Pnding_input_MAX VARCHAR2(256) NOT NULL,
Success_MIN VARCHAR2(256) NOT NULL,
Success_MAX VARCHAR2(256) NOT NULL,
Disabled_MIN VARCHAR2(256) NOT NULL,
Disabled_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOSrvPrvStats_THRESH ADD constraint PK_SBOSrvPrvStats_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOSrvPrvStats_THRESH ON SBOSrvPrvStats_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOSrvPrvStats ON SBOSrvPrvStats_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOSrvPrvStats ON SBOSrvPrvStats_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOFeedBackTest CASCADE CONSTRAINTS;
CREATE TABLE SBOFeedBackTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_Feedback Number(20,4) NOT NULL,
Total_Feedback_ST varchar2(32) NOT NULL,
Total_goodfeedback Number(20,4) NOT NULL,
Total_goodfeedback_ST varchar2(32) NOT NULL,
Total_poorfeedback Number(20,4) NOT NULL,
Total_poorfeedback_ST varchar2(32) NOT NULL,
Total_avoidfeedback Number(20,4) NOT NULL,
Total_avoidfeedback_ST varchar2(32) NOT NULL,
Per_of_goodfb Number(20,4) NOT NULL,
Per_of_goodfb_ST varchar2(32) NOT NULL,
Per_of_poodfb Number(20,4) NOT NULL,
Per_of_poodfb_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOFeedBackTest ON SBOFeedBackTest(MSMT_TIME);
ALTER TABLE SBOFeedBackTest ADD constraint PK_SBOFeedBackTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOFeedBackTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOFeedBackTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_Feedback_MIN Number(20,4) NOT NULL,
Total_Feedback_MAX Number(20,4) NOT NULL,
Total_Feedback_STCNT varchar2(32) NOT NULL,
Total_goodfeedback_MIN Number(20,4) NOT NULL,
Total_goodfeedback_MAX Number(20,4) NOT NULL,
Total_goodfeedback_STCNT varchar2(32) NOT NULL,
Total_poorfeedback_MIN Number(20,4) NOT NULL,
Total_poorfeedback_MAX Number(20,4) NOT NULL,
Total_poorfeedback_STCNT varchar2(32) NOT NULL,
Total_avoidfeedback_MIN Number(20,4) NOT NULL,
Total_avoidfeedback_MAX Number(20,4) NOT NULL,
Total_avoidfeedback_STCNT varchar2(32) NOT NULL,
Per_of_goodfb_MIN Number(20,4) NOT NULL,
Per_of_goodfb_MAX Number(20,4) NOT NULL,
Per_of_goodfb_STCNT varchar2(32) NOT NULL,
Per_of_poodfb_MIN Number(20,4) NOT NULL,
Per_of_poodfb_MAX Number(20,4) NOT NULL,
Per_of_poodfb_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOFeedBackTest_TREND ADD constraint PK_SBOFeedBackTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOFeedBackTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOFeedBackTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_Feedback_MIN VARCHAR2(256) NOT NULL,
Total_Feedback_MAX VARCHAR2(256) NOT NULL,
Total_goodfeedback_MIN VARCHAR2(256) NOT NULL,
Total_goodfeedback_MAX VARCHAR2(256) NOT NULL,
Total_poorfeedback_MIN VARCHAR2(256) NOT NULL,
Total_poorfeedback_MAX VARCHAR2(256) NOT NULL,
Total_avoidfeedback_MIN VARCHAR2(256) NOT NULL,
Total_avoidfeedback_MAX VARCHAR2(256) NOT NULL,
Per_of_goodfb_MIN VARCHAR2(256) NOT NULL,
Per_of_goodfb_MAX VARCHAR2(256) NOT NULL,
Per_of_poodfb_MIN VARCHAR2(256) NOT NULL,
Per_of_poodfb_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOFeedBackTest_THRESH ADD constraint PK_SBOFeedBackTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOFeedBackTest_THRESH ON SBOFeedBackTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOFeedBackTest ON SBOFeedBackTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOFeedBackTest ON SBOFeedBackTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOCallConnTest CASCADE CONSTRAINTS;
CREATE TABLE SBOCallConnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Calls_initiated Number(20,4) NOT NULL,
Calls_initiated_ST varchar2(32) NOT NULL,
Calls_completed Number(20,4) NOT NULL,
Calls_completed_ST varchar2(32) NOT NULL,
Calls_failed Number(20,4) NOT NULL,
Calls_failed_ST varchar2(32) NOT NULL,
Conn_checks_status Number(20,4) NOT NULL,
Conn_checks_status_ST varchar2(32) NOT NULL,
Packt_loss_rate Number(20,4) NOT NULL,
Packt_loss_rate_ST varchar2(32) NOT NULL,
RTT_latency Number(20,4) NOT NULL,
RTT_latency_ST varchar2(32) NOT NULL,
Jitter Number(20,4) NOT NULL,
Jitter_ST varchar2(32) NOT NULL,
Packt_reorder_ratio Number(20,4) NOT NULL,
Packt_reorder_ratio_ST varchar2(32) NOT NULL,
Mos_score Number(20,4) NOT NULL,
Mos_score_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOCallConnTest ON SBOCallConnTest(MSMT_TIME);
ALTER TABLE SBOCallConnTest ADD constraint PK_SBOCallConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOCallConnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOCallConnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Calls_initiated_MIN Number(20,4) NOT NULL,
Calls_initiated_MAX Number(20,4) NOT NULL,
Calls_initiated_STCNT varchar2(32) NOT NULL,
Calls_completed_MIN Number(20,4) NOT NULL,
Calls_completed_MAX Number(20,4) NOT NULL,
Calls_completed_STCNT varchar2(32) NOT NULL,
Calls_failed_MIN Number(20,4) NOT NULL,
Calls_failed_MAX Number(20,4) NOT NULL,
Calls_failed_STCNT varchar2(32) NOT NULL,
Conn_checks_status_MIN Number(20,4) NOT NULL,
Conn_checks_status_MAX Number(20,4) NOT NULL,
Conn_checks_status_STCNT varchar2(32) NOT NULL,
Packt_loss_rate_MIN Number(20,4) NOT NULL,
Packt_loss_rate_MAX Number(20,4) NOT NULL,
Packt_loss_rate_STCNT varchar2(32) NOT NULL,
RTT_latency_MIN Number(20,4) NOT NULL,
RTT_latency_MAX Number(20,4) NOT NULL,
RTT_latency_STCNT varchar2(32) NOT NULL,
Jitter_MIN Number(20,4) NOT NULL,
Jitter_MAX Number(20,4) NOT NULL,
Jitter_STCNT varchar2(32) NOT NULL,
Packt_reorder_ratio_MIN Number(20,4) NOT NULL,
Packt_reorder_ratio_MAX Number(20,4) NOT NULL,
Packt_reorder_ratio_STCNT varchar2(32) NOT NULL,
Mos_score_MIN Number(20,4) NOT NULL,
Mos_score_MAX Number(20,4) NOT NULL,
Mos_score_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOCallConnTest_TREND ADD constraint PK_SBOCallConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOCallConnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOCallConnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Calls_initiated_MIN VARCHAR2(256) NOT NULL,
Calls_initiated_MAX VARCHAR2(256) NOT NULL,
Calls_completed_MIN VARCHAR2(256) NOT NULL,
Calls_completed_MAX VARCHAR2(256) NOT NULL,
Calls_failed_MIN VARCHAR2(256) NOT NULL,
Calls_failed_MAX VARCHAR2(256) NOT NULL,
Conn_checks_status_MIN VARCHAR2(256) NOT NULL,
Conn_checks_status_MAX VARCHAR2(256) NOT NULL,
Packt_loss_rate_MIN VARCHAR2(256) NOT NULL,
Packt_loss_rate_MAX VARCHAR2(256) NOT NULL,
RTT_latency_MIN VARCHAR2(256) NOT NULL,
RTT_latency_MAX VARCHAR2(256) NOT NULL,
Jitter_MIN VARCHAR2(256) NOT NULL,
Jitter_MAX VARCHAR2(256) NOT NULL,
Packt_reorder_ratio_MIN VARCHAR2(256) NOT NULL,
Packt_reorder_ratio_MAX VARCHAR2(256) NOT NULL,
Mos_score_MIN VARCHAR2(256) NOT NULL,
Mos_score_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOCallConnTest_THRESH ADD constraint PK_SBOCallConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOCallConnTest_THRESH ON SBOCallConnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOCallConnTest ON SBOCallConnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOCallConnTest ON SBOCallConnTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOSesDomainsTest CASCADE CONSTRAINTS;
CREATE TABLE SBOSesDomainsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
domaincnt Number(20,4) NOT NULL,
domaincnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOSesDomainsTest ON SBOSesDomainsTest(MSMT_TIME);
ALTER TABLE SBOSesDomainsTest ADD constraint PK_SBOSesDomainsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOSesDomainsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOSesDomainsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
domaincnt_MIN Number(20,4) NOT NULL,
domaincnt_MAX Number(20,4) NOT NULL,
domaincnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOSesDomainsTest_TREND ADD constraint PK_SBOSesDomainsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOSesDomainsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOSesDomainsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
domaincnt_MIN VARCHAR2(256) NOT NULL,
domaincnt_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOSesDomainsTest_THRESH ADD constraint PK_SBOSesDomainsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOSesDomainsTest_THRESH ON SBOSesDomainsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOSesDomainsTest ON SBOSesDomainsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOSesDomainsTest ON SBOSesDomainsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOAppshrngQltyTest CASCADE CONSTRAINTS;
CREATE TABLE SBOAppshrngQltyTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
totalclsCnt Number(20,4) NOT NULL,
totalclsCnt_ST varchar2(32) NOT NULL,
Currentcals Number(20,4) NOT NULL,
Currentcals_ST varchar2(32) NOT NULL,
poorCalsCnt Number(20,4) NOT NULL,
poorCalsCnt_ST varchar2(32) NOT NULL,
poorCalsPerc Number(20,4) NOT NULL,
poorCalsPerc_ST varchar2(32) NOT NULL,
failedCalsCnt Number(20,4) NOT NULL,
failedCalsCnt_ST varchar2(32) NOT NULL,
failedClsPerct Number(20,4) NOT NULL,
failedClsPerct_ST varchar2(32) NOT NULL,
longCalsCnt Number(20,4) NOT NULL,
longCalsCnt_ST varchar2(32) NOT NULL,
totaldurtn Number(20,4) NOT NULL,
totaldurtn_ST varchar2(32) NOT NULL,
totalcnfcals Number(20,4) NOT NULL,
totalcnfcals_ST varchar2(32) NOT NULL,
CnfOrgUsrCnt Number(20,4) NOT NULL,
CnfOrgUsrCnt_ST varchar2(32) NOT NULL,
CnfPartUsrCnt Number(20,4) NOT NULL,
CnfPartUsrCnt_ST varchar2(32) NOT NULL,
BandWdUsage Number(20,4) NOT NULL,
BandWdUsage_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOAppshrngQltyTest ON SBOAppshrngQltyTest(MSMT_TIME);
ALTER TABLE SBOAppshrngQltyTest ADD constraint PK_SBOAppshrngQltyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOAppshrngQltyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOAppshrngQltyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
totalclsCnt_MIN Number(20,4) NOT NULL,
totalclsCnt_MAX Number(20,4) NOT NULL,
totalclsCnt_STCNT varchar2(32) NOT NULL,
Currentcals_MIN Number(20,4) NOT NULL,
Currentcals_MAX Number(20,4) NOT NULL,
Currentcals_STCNT varchar2(32) NOT NULL,
poorCalsCnt_MIN Number(20,4) NOT NULL,
poorCalsCnt_MAX Number(20,4) NOT NULL,
poorCalsCnt_STCNT varchar2(32) NOT NULL,
poorCalsPerc_MIN Number(20,4) NOT NULL,
poorCalsPerc_MAX Number(20,4) NOT NULL,
poorCalsPerc_STCNT varchar2(32) NOT NULL,
failedCalsCnt_MIN Number(20,4) NOT NULL,
failedCalsCnt_MAX Number(20,4) NOT NULL,
failedCalsCnt_STCNT varchar2(32) NOT NULL,
failedClsPerct_MIN Number(20,4) NOT NULL,
failedClsPerct_MAX Number(20,4) NOT NULL,
failedClsPerct_STCNT varchar2(32) NOT NULL,
longCalsCnt_MIN Number(20,4) NOT NULL,
longCalsCnt_MAX Number(20,4) NOT NULL,
longCalsCnt_STCNT varchar2(32) NOT NULL,
totaldurtn_MIN Number(20,4) NOT NULL,
totaldurtn_MAX Number(20,4) NOT NULL,
totaldurtn_STCNT varchar2(32) NOT NULL,
totalcnfcals_MIN Number(20,4) NOT NULL,
totalcnfcals_MAX Number(20,4) NOT NULL,
totalcnfcals_STCNT varchar2(32) NOT NULL,
CnfOrgUsrCnt_MIN Number(20,4) NOT NULL,
CnfOrgUsrCnt_MAX Number(20,4) NOT NULL,
CnfOrgUsrCnt_STCNT varchar2(32) NOT NULL,
CnfPartUsrCnt_MIN Number(20,4) NOT NULL,
CnfPartUsrCnt_MAX Number(20,4) NOT NULL,
CnfPartUsrCnt_STCNT varchar2(32) NOT NULL,
BandWdUsage_MIN Number(20,4) NOT NULL,
BandWdUsage_MAX Number(20,4) NOT NULL,
BandWdUsage_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOAppshrngQltyTest_TREND ADD constraint PK_SBOAppshrngQltyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOAppshrngQltyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOAppshrngQltyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
totalclsCnt_MIN VARCHAR2(256) NOT NULL,
totalclsCnt_MAX VARCHAR2(256) NOT NULL,
Currentcals_MIN VARCHAR2(256) NOT NULL,
Currentcals_MAX VARCHAR2(256) NOT NULL,
poorCalsCnt_MIN VARCHAR2(256) NOT NULL,
poorCalsCnt_MAX VARCHAR2(256) NOT NULL,
poorCalsPerc_MIN VARCHAR2(256) NOT NULL,
poorCalsPerc_MAX VARCHAR2(256) NOT NULL,
failedCalsCnt_MIN VARCHAR2(256) NOT NULL,
failedCalsCnt_MAX VARCHAR2(256) NOT NULL,
failedClsPerct_MIN VARCHAR2(256) NOT NULL,
failedClsPerct_MAX VARCHAR2(256) NOT NULL,
longCalsCnt_MIN VARCHAR2(256) NOT NULL,
longCalsCnt_MAX VARCHAR2(256) NOT NULL,
totaldurtn_MIN VARCHAR2(256) NOT NULL,
totaldurtn_MAX VARCHAR2(256) NOT NULL,
totalcnfcals_MIN VARCHAR2(256) NOT NULL,
totalcnfcals_MAX VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MAX VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MAX VARCHAR2(256) NOT NULL,
BandWdUsage_MIN VARCHAR2(256) NOT NULL,
BandWdUsage_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOAppshrngQltyTest_THRESH ADD constraint PK_SBOAppshrngQltyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOAppshrngQltyTest_THRESH ON SBOAppshrngQltyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOAppshrngQltyTest ON SBOAppshrngQltyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOAppshrngQltyTest ON SBOAppshrngQltyTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOusersbydevsTest CASCADE CONSTRAINTS;
CREATE TABLE SBOusersbydevsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Uniq_user Number(20,4) NOT NULL,
Uniq_user_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOusersbydevsTest ON SBOusersbydevsTest(MSMT_TIME);
ALTER TABLE SBOusersbydevsTest ADD constraint PK_SBOusersbydevsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOusersbydevsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOusersbydevsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Uniq_user_MIN Number(20,4) NOT NULL,
Uniq_user_MAX Number(20,4) NOT NULL,
Uniq_user_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOusersbydevsTest_TREND ADD constraint PK_SBOusersbydevsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOusersbydevsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOusersbydevsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Uniq_user_MIN VARCHAR2(256) NOT NULL,
Uniq_user_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOusersbydevsTest_THRESH ADD constraint PK_SBOusersbydevsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOusersbydevsTest_THRESH ON SBOusersbydevsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOusersbydevsTest ON SBOusersbydevsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOusersbydevsTest ON SBOusersbydevsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOImFileSesnTest CASCADE CONSTRAINTS;
CREATE TABLE SBOImFileSesnTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
totalclsCnt Number(20,4) NOT NULL,
totalclsCnt_ST varchar2(32) NOT NULL,
Currentcals Number(20,4) NOT NULL,
Currentcals_ST varchar2(32) NOT NULL,
totaldurtn Number(20,4) NOT NULL,
totaldurtn_ST varchar2(32) NOT NULL,
totalcnfcals Number(20,4) NOT NULL,
totalcnfcals_ST varchar2(32) NOT NULL,
CnfOrgUsrCnt Number(20,4) NOT NULL,
CnfOrgUsrCnt_ST varchar2(32) NOT NULL,
CnfPartUsrCnt Number(20,4) NOT NULL,
CnfPartUsrCnt_ST varchar2(32) NOT NULL,
filetransfers Number(20,4) NOT NULL,
filetransfers_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOImFileSesnTest ON SBOImFileSesnTest(MSMT_TIME);
ALTER TABLE SBOImFileSesnTest ADD constraint PK_SBOImFileSesnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOImFileSesnTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOImFileSesnTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
totalclsCnt_MIN Number(20,4) NOT NULL,
totalclsCnt_MAX Number(20,4) NOT NULL,
totalclsCnt_STCNT varchar2(32) NOT NULL,
Currentcals_MIN Number(20,4) NOT NULL,
Currentcals_MAX Number(20,4) NOT NULL,
Currentcals_STCNT varchar2(32) NOT NULL,
totaldurtn_MIN Number(20,4) NOT NULL,
totaldurtn_MAX Number(20,4) NOT NULL,
totaldurtn_STCNT varchar2(32) NOT NULL,
totalcnfcals_MIN Number(20,4) NOT NULL,
totalcnfcals_MAX Number(20,4) NOT NULL,
totalcnfcals_STCNT varchar2(32) NOT NULL,
CnfOrgUsrCnt_MIN Number(20,4) NOT NULL,
CnfOrgUsrCnt_MAX Number(20,4) NOT NULL,
CnfOrgUsrCnt_STCNT varchar2(32) NOT NULL,
CnfPartUsrCnt_MIN Number(20,4) NOT NULL,
CnfPartUsrCnt_MAX Number(20,4) NOT NULL,
CnfPartUsrCnt_STCNT varchar2(32) NOT NULL,
filetransfers_MIN Number(20,4) NOT NULL,
filetransfers_MAX Number(20,4) NOT NULL,
filetransfers_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOImFileSesnTest_TREND ADD constraint PK_SBOImFileSesnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOImFileSesnTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOImFileSesnTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
totalclsCnt_MIN VARCHAR2(256) NOT NULL,
totalclsCnt_MAX VARCHAR2(256) NOT NULL,
Currentcals_MIN VARCHAR2(256) NOT NULL,
Currentcals_MAX VARCHAR2(256) NOT NULL,
totaldurtn_MIN VARCHAR2(256) NOT NULL,
totaldurtn_MAX VARCHAR2(256) NOT NULL,
totalcnfcals_MIN VARCHAR2(256) NOT NULL,
totalcnfcals_MAX VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MAX VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MAX VARCHAR2(256) NOT NULL,
filetransfers_MIN VARCHAR2(256) NOT NULL,
filetransfers_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOImFileSesnTest_THRESH ADD constraint PK_SBOImFileSesnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOImFileSesnTest_THRESH ON SBOImFileSesnTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOImFileSesnTest ON SBOImFileSesnTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOImFileSesnTest ON SBOImFileSesnTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOVidCalQlityTest CASCADE CONSTRAINTS;
CREATE TABLE SBOVidCalQlityTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
totalclsCnt Number(20,4) NOT NULL,
totalclsCnt_ST varchar2(32) NOT NULL,
Currentcals Number(20,4) NOT NULL,
Currentcals_ST varchar2(32) NOT NULL,
poorCalsCnt Number(20,4) NOT NULL,
poorCalsCnt_ST varchar2(32) NOT NULL,
poorCalsPerc Number(20,4) NOT NULL,
poorCalsPerc_ST varchar2(32) NOT NULL,
failedCalsCnt Number(20,4) NOT NULL,
failedCalsCnt_ST varchar2(32) NOT NULL,
failedClsPerct Number(20,4) NOT NULL,
failedClsPerct_ST varchar2(32) NOT NULL,
longCalsCnt Number(20,4) NOT NULL,
longCalsCnt_ST varchar2(32) NOT NULL,
totaldurtn Number(20,4) NOT NULL,
totaldurtn_ST varchar2(32) NOT NULL,
totalcnfcals Number(20,4) NOT NULL,
totalcnfcals_ST varchar2(32) NOT NULL,
CnfOrgUsrCnt Number(20,4) NOT NULL,
CnfOrgUsrCnt_ST varchar2(32) NOT NULL,
CnfPartUsrCnt Number(20,4) NOT NULL,
CnfPartUsrCnt_ST varchar2(32) NOT NULL,
BandWdUsage Number(20,4) NOT NULL,
BandWdUsage_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOVidCalQlityTest ON SBOVidCalQlityTest(MSMT_TIME);
ALTER TABLE SBOVidCalQlityTest ADD constraint PK_SBOVidCalQlityTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOVidCalQlityTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOVidCalQlityTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
totalclsCnt_MIN Number(20,4) NOT NULL,
totalclsCnt_MAX Number(20,4) NOT NULL,
totalclsCnt_STCNT varchar2(32) NOT NULL,
Currentcals_MIN Number(20,4) NOT NULL,
Currentcals_MAX Number(20,4) NOT NULL,
Currentcals_STCNT varchar2(32) NOT NULL,
poorCalsCnt_MIN Number(20,4) NOT NULL,
poorCalsCnt_MAX Number(20,4) NOT NULL,
poorCalsCnt_STCNT varchar2(32) NOT NULL,
poorCalsPerc_MIN Number(20,4) NOT NULL,
poorCalsPerc_MAX Number(20,4) NOT NULL,
poorCalsPerc_STCNT varchar2(32) NOT NULL,
failedCalsCnt_MIN Number(20,4) NOT NULL,
failedCalsCnt_MAX Number(20,4) NOT NULL,
failedCalsCnt_STCNT varchar2(32) NOT NULL,
failedClsPerct_MIN Number(20,4) NOT NULL,
failedClsPerct_MAX Number(20,4) NOT NULL,
failedClsPerct_STCNT varchar2(32) NOT NULL,
longCalsCnt_MIN Number(20,4) NOT NULL,
longCalsCnt_MAX Number(20,4) NOT NULL,
longCalsCnt_STCNT varchar2(32) NOT NULL,
totaldurtn_MIN Number(20,4) NOT NULL,
totaldurtn_MAX Number(20,4) NOT NULL,
totaldurtn_STCNT varchar2(32) NOT NULL,
totalcnfcals_MIN Number(20,4) NOT NULL,
totalcnfcals_MAX Number(20,4) NOT NULL,
totalcnfcals_STCNT varchar2(32) NOT NULL,
CnfOrgUsrCnt_MIN Number(20,4) NOT NULL,
CnfOrgUsrCnt_MAX Number(20,4) NOT NULL,
CnfOrgUsrCnt_STCNT varchar2(32) NOT NULL,
CnfPartUsrCnt_MIN Number(20,4) NOT NULL,
CnfPartUsrCnt_MAX Number(20,4) NOT NULL,
CnfPartUsrCnt_STCNT varchar2(32) NOT NULL,
BandWdUsage_MIN Number(20,4) NOT NULL,
BandWdUsage_MAX Number(20,4) NOT NULL,
BandWdUsage_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOVidCalQlityTest_TREND ADD constraint PK_SBOVidCalQlityTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOVidCalQlityTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOVidCalQlityTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
totalclsCnt_MIN VARCHAR2(256) NOT NULL,
totalclsCnt_MAX VARCHAR2(256) NOT NULL,
Currentcals_MIN VARCHAR2(256) NOT NULL,
Currentcals_MAX VARCHAR2(256) NOT NULL,
poorCalsCnt_MIN VARCHAR2(256) NOT NULL,
poorCalsCnt_MAX VARCHAR2(256) NOT NULL,
poorCalsPerc_MIN VARCHAR2(256) NOT NULL,
poorCalsPerc_MAX VARCHAR2(256) NOT NULL,
failedCalsCnt_MIN VARCHAR2(256) NOT NULL,
failedCalsCnt_MAX VARCHAR2(256) NOT NULL,
failedClsPerct_MIN VARCHAR2(256) NOT NULL,
failedClsPerct_MAX VARCHAR2(256) NOT NULL,
longCalsCnt_MIN VARCHAR2(256) NOT NULL,
longCalsCnt_MAX VARCHAR2(256) NOT NULL,
totaldurtn_MIN VARCHAR2(256) NOT NULL,
totaldurtn_MAX VARCHAR2(256) NOT NULL,
totalcnfcals_MIN VARCHAR2(256) NOT NULL,
totalcnfcals_MAX VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MAX VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MAX VARCHAR2(256) NOT NULL,
BandWdUsage_MIN VARCHAR2(256) NOT NULL,
BandWdUsage_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOVidCalQlityTest_THRESH ADD constraint PK_SBOVidCalQlityTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOVidCalQlityTest_THRESH ON SBOVidCalQlityTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOVidCalQlityTest ON SBOVidCalQlityTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOVidCalQlityTest ON SBOVidCalQlityTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE SBOAudCalQltyTest CASCADE CONSTRAINTS;
CREATE TABLE SBOAudCalQltyTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
totalclsCnt Number(20,4) NOT NULL,
totalclsCnt_ST varchar2(32) NOT NULL,
Currentcals Number(20,4) NOT NULL,
Currentcals_ST varchar2(32) NOT NULL,
poorCalsCnt Number(20,4) NOT NULL,
poorCalsCnt_ST varchar2(32) NOT NULL,
poorCalsPerc Number(20,4) NOT NULL,
poorCalsPerc_ST varchar2(32) NOT NULL,
failedCalsCnt Number(20,4) NOT NULL,
failedCalsCnt_ST varchar2(32) NOT NULL,
failedClsPerct Number(20,4) NOT NULL,
failedClsPerct_ST varchar2(32) NOT NULL,
longCalsCnt Number(20,4) NOT NULL,
longCalsCnt_ST varchar2(32) NOT NULL,
totaldurtn Number(20,4) NOT NULL,
totaldurtn_ST varchar2(32) NOT NULL,
totalcnfcals Number(20,4) NOT NULL,
totalcnfcals_ST varchar2(32) NOT NULL,
CnfOrgUsrCnt Number(20,4) NOT NULL,
CnfOrgUsrCnt_ST varchar2(32) NOT NULL,
CnfPartUsrCnt Number(20,4) NOT NULL,
CnfPartUsrCnt_ST varchar2(32) NOT NULL,
BandWdUsage Number(20,4) NOT NULL,
BandWdUsage_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOAudCalQltyTest ON SBOAudCalQltyTest(MSMT_TIME);
ALTER TABLE SBOAudCalQltyTest ADD constraint PK_SBOAudCalQltyTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOAudCalQltyTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOAudCalQltyTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
totalclsCnt_MIN Number(20,4) NOT NULL,
totalclsCnt_MAX Number(20,4) NOT NULL,
totalclsCnt_STCNT varchar2(32) NOT NULL,
Currentcals_MIN Number(20,4) NOT NULL,
Currentcals_MAX Number(20,4) NOT NULL,
Currentcals_STCNT varchar2(32) NOT NULL,
poorCalsCnt_MIN Number(20,4) NOT NULL,
poorCalsCnt_MAX Number(20,4) NOT NULL,
poorCalsCnt_STCNT varchar2(32) NOT NULL,
poorCalsPerc_MIN Number(20,4) NOT NULL,
poorCalsPerc_MAX Number(20,4) NOT NULL,
poorCalsPerc_STCNT varchar2(32) NOT NULL,
failedCalsCnt_MIN Number(20,4) NOT NULL,
failedCalsCnt_MAX Number(20,4) NOT NULL,
failedCalsCnt_STCNT varchar2(32) NOT NULL,
failedClsPerct_MIN Number(20,4) NOT NULL,
failedClsPerct_MAX Number(20,4) NOT NULL,
failedClsPerct_STCNT varchar2(32) NOT NULL,
longCalsCnt_MIN Number(20,4) NOT NULL,
longCalsCnt_MAX Number(20,4) NOT NULL,
longCalsCnt_STCNT varchar2(32) NOT NULL,
totaldurtn_MIN Number(20,4) NOT NULL,
totaldurtn_MAX Number(20,4) NOT NULL,
totaldurtn_STCNT varchar2(32) NOT NULL,
totalcnfcals_MIN Number(20,4) NOT NULL,
totalcnfcals_MAX Number(20,4) NOT NULL,
totalcnfcals_STCNT varchar2(32) NOT NULL,
CnfOrgUsrCnt_MIN Number(20,4) NOT NULL,
CnfOrgUsrCnt_MAX Number(20,4) NOT NULL,
CnfOrgUsrCnt_STCNT varchar2(32) NOT NULL,
CnfPartUsrCnt_MIN Number(20,4) NOT NULL,
CnfPartUsrCnt_MAX Number(20,4) NOT NULL,
CnfPartUsrCnt_STCNT varchar2(32) NOT NULL,
BandWdUsage_MIN Number(20,4) NOT NULL,
BandWdUsage_MAX Number(20,4) NOT NULL,
BandWdUsage_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOAudCalQltyTest_TREND ADD constraint PK_SBOAudCalQltyTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOAudCalQltyTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOAudCalQltyTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
totalclsCnt_MIN VARCHAR2(256) NOT NULL,
totalclsCnt_MAX VARCHAR2(256) NOT NULL,
Currentcals_MIN VARCHAR2(256) NOT NULL,
Currentcals_MAX VARCHAR2(256) NOT NULL,
poorCalsCnt_MIN VARCHAR2(256) NOT NULL,
poorCalsCnt_MAX VARCHAR2(256) NOT NULL,
poorCalsPerc_MIN VARCHAR2(256) NOT NULL,
poorCalsPerc_MAX VARCHAR2(256) NOT NULL,
failedCalsCnt_MIN VARCHAR2(256) NOT NULL,
failedCalsCnt_MAX VARCHAR2(256) NOT NULL,
failedClsPerct_MIN VARCHAR2(256) NOT NULL,
failedClsPerct_MAX VARCHAR2(256) NOT NULL,
longCalsCnt_MIN VARCHAR2(256) NOT NULL,
longCalsCnt_MAX VARCHAR2(256) NOT NULL,
totaldurtn_MIN VARCHAR2(256) NOT NULL,
totaldurtn_MAX VARCHAR2(256) NOT NULL,
totalcnfcals_MIN VARCHAR2(256) NOT NULL,
totalcnfcals_MAX VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfOrgUsrCnt_MAX VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MIN VARCHAR2(256) NOT NULL,
CnfPartUsrCnt_MAX VARCHAR2(256) NOT NULL,
BandWdUsage_MIN VARCHAR2(256) NOT NULL,
BandWdUsage_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOAudCalQltyTest_THRESH ADD constraint PK_SBOAudCalQltyTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOAudCalQltyTest_THRESH ON SBOAudCalQltyTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOAudCalQltyTest ON SBOAudCalQltyTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOAudCalQltyTest ON SBOAudCalQltyTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOMsgCentTest CASCADE CONSTRAINTS;
CREATE TABLE SBOMsgCentTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOMsgCentTest ON SBOMsgCentTest(MSMT_TIME);
ALTER TABLE SBOMsgCentTest ADD constraint PK_SBOMsgCentTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOMsgCentTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOMsgCentTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOMsgCentTest_TREND ADD constraint PK_SBOMsgCentTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOMsgCentTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOMsgCentTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MsgCenterCommunication_MIN VARCHAR2(256) NOT NULL,
MsgCenterCommunication_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOMsgCentTest_THRESH ADD constraint PK_SBOMsgCentTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOMsgCentTest_THRESH ON SBOMsgCentTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOMsgCentTest ON SBOMsgCentTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOMsgCentTest ON SBOMsgCentTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOConcStatusTest CASCADE CONSTRAINTS;
CREATE TABLE SBOConcStatusTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
status Number(20,4) NOT NULL,
status_ST varchar2(32) NOT NULL,
pblmtcServ Number(20,4) NOT NULL,
pblmtcServ_ST varchar2(32) NOT NULL,
reslvedSrvc Number(20,4) NOT NULL,
reslvedSrvc_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOConcStatusTest ON SBOConcStatusTest(MSMT_TIME);
ALTER TABLE SBOConcStatusTest ADD constraint PK_SBOConcStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOConcStatusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOConcStatusTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
status_MIN Number(20,4) NOT NULL,
status_MAX Number(20,4) NOT NULL,
status_STCNT varchar2(32) NOT NULL,
pblmtcServ_MIN Number(20,4) NOT NULL,
pblmtcServ_MAX Number(20,4) NOT NULL,
pblmtcServ_STCNT varchar2(32) NOT NULL,
reslvedSrvc_MIN Number(20,4) NOT NULL,
reslvedSrvc_MAX Number(20,4) NOT NULL,
reslvedSrvc_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOConcStatusTest_TREND ADD constraint PK_SBOConcStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOConcStatusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOConcStatusTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
status_MIN VARCHAR2(256) NOT NULL,
status_MAX VARCHAR2(256) NOT NULL,
pblmtcServ_MIN VARCHAR2(256) NOT NULL,
pblmtcServ_MAX VARCHAR2(256) NOT NULL,
reslvedSrvc_MIN VARCHAR2(256) NOT NULL,
reslvedSrvc_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOConcStatusTest_THRESH ADD constraint PK_SBOConcStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOConcStatusTest_THRESH ON SBOConcStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOConcStatusTest ON SBOConcStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOConcStatusTest ON SBOConcStatusTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOConneChecksTest CASCADE CONSTRAINTS;
CREATE TABLE SBOConneChecksTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Connection_Status Number(20,4) NOT NULL,
Connection_Status_ST varchar2(32) NOT NULL,
Time_taken_to_connect Number(20,4) NOT NULL,
Time_taken_to_connect_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOConneChecksTest ON SBOConneChecksTest(MSMT_TIME);
ALTER TABLE SBOConneChecksTest ADD constraint PK_SBOConneChecksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOConneChecksTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOConneChecksTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Connection_Status_MIN Number(20,4) NOT NULL,
Connection_Status_MAX Number(20,4) NOT NULL,
Connection_Status_STCNT varchar2(32) NOT NULL,
Time_taken_to_connect_MIN Number(20,4) NOT NULL,
Time_taken_to_connect_MAX Number(20,4) NOT NULL,
Time_taken_to_connect_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOConneChecksTest_TREND ADD constraint PK_SBOConneChecksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOConneChecksTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOConneChecksTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Connection_Status_MIN VARCHAR2(256) NOT NULL,
Connection_Status_MAX VARCHAR2(256) NOT NULL,
Time_taken_to_connect_MIN VARCHAR2(256) NOT NULL,
Time_taken_to_connect_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOConneChecksTest_THRESH ADD constraint PK_SBOConneChecksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOConneChecksTest_THRESH ON SBOConneChecksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOConneChecksTest ON SBOConneChecksTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOConneChecksTest ON SBOConneChecksTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SBOSrvcHlhTest CASCADE CONSTRAINTS;
CREATE TABLE SBOSrvcHlhTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Service_incidents Number(20,4) NOT NULL,
Service_incidents_ST varchar2(32) NOT NULL,
Maintenance_events Number(20,4) NOT NULL,
Maintenance_events_ST varchar2(32) NOT NULL,
Service_Status Number(20,4) NOT NULL,
Service_Status_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SBOSrvcHlhTest ON SBOSrvcHlhTest(MSMT_TIME);
ALTER TABLE SBOSrvcHlhTest ADD constraint PK_SBOSrvcHlhTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SBOSrvcHlhTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SBOSrvcHlhTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Service_incidents_MIN Number(20,4) NOT NULL,
Service_incidents_MAX Number(20,4) NOT NULL,
Service_incidents_STCNT varchar2(32) NOT NULL,
Maintenance_events_MIN Number(20,4) NOT NULL,
Maintenance_events_MAX Number(20,4) NOT NULL,
Maintenance_events_STCNT varchar2(32) NOT NULL,
Service_Status_MIN Number(20,4) NOT NULL,
Service_Status_MAX Number(20,4) NOT NULL,
Service_Status_STCNT varchar2(32) NOT NULL);

ALTER TABLE SBOSrvcHlhTest_TREND ADD constraint PK_SBOSrvcHlhTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SBOSrvcHlhTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SBOSrvcHlhTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Service_incidents_MIN VARCHAR2(256) NOT NULL,
Service_incidents_MAX VARCHAR2(256) NOT NULL,
Maintenance_events_MIN VARCHAR2(256) NOT NULL,
Maintenance_events_MAX VARCHAR2(256) NOT NULL,
Service_Status_MIN VARCHAR2(256) NOT NULL,
Service_Status_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SBOSrvcHlhTest_THRESH ADD constraint PK_SBOSrvcHlhTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SBOSrvcHlhTest_THRESH ON SBOSrvcHlhTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SBOSrvcHlhTest ON SBOSrvcHlhTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SBOSrvcHlhTest ON SBOSrvcHlhTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE NginxZOPCacheTest CASCADE CONSTRAINTS;
CREATE TABLE NginxZOPCacheTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
OPCODE_CACHING Number(20,4) NOT NULL,
OPCODE_CACHING_ST varchar2(32) NOT NULL,
OPTIMIZATION Number(20,4) NOT NULL,
OPTIMIZATION_ST varchar2(32) NOT NULL,
CACHE_HITS Number(20,4) NOT NULL,
CACHE_HITS_ST varchar2(32) NOT NULL,
CACHE_MISSES Number(20,4) NOT NULL,
CACHE_MISSES_ST varchar2(32) NOT NULL,
CACHE_HIT_RATE Number(20,4) NOT NULL,
CACHE_HIT_RATE_ST varchar2(32) NOT NULL,
MISSES_RATIO Number(20,4) NOT NULL,
MISSES_RATIO_ST varchar2(32) NOT NULL,
USED_MEMORY Number(20,4) NOT NULL,
USED_MEMORY_ST varchar2(32) NOT NULL,
FREE_MEMORY Number(20,4) NOT NULL,
FREE_MEMORY_ST varchar2(32) NOT NULL,
WASTED_MEMORY Number(20,4) NOT NULL,
WASTED_MEMORY_ST varchar2(32) NOT NULL,
WASTED_MEM_PERC Number(20,4) NOT NULL,
WASTED_MEM_PERC_ST varchar2(32) NOT NULL,
INTRN_STR_USEDMEM Number(20,4) NOT NULL,
INTRN_STR_USEDMEM_ST varchar2(32) NOT NULL,
INTRN_STR_FREEMEM Number(20,4) NOT NULL,
INTRN_STR_FREEMEM_ST varchar2(32) NOT NULL,
CACHED_SCRIPTS Number(20,4) NOT NULL,
CACHED_SCRIPTS_ST varchar2(32) NOT NULL,
CACHED_KEYS Number(20,4) NOT NULL,
CACHED_KEYS_ST varchar2(32) NOT NULL,
MAX_KEYS Number(20,4) NOT NULL,
MAX_KEYS_ST varchar2(32) NOT NULL,
OOM_RESTARTS Number(20,4) NOT NULL,
OOM_RESTARTS_ST varchar2(32) NOT NULL,
HASH_KEYS_RESTARTS Number(20,4) NOT NULL,
HASH_KEYS_RESTARTS_ST varchar2(32) NOT NULL,
MANUAL_RESTARTS Number(20,4) NOT NULL,
MANUAL_RESTARTS_ST varchar2(32) NOT NULL);


CREATE INDEX IDX_NginxZOPCacheTest ON NginxZOPCacheTest(MSMT_TIME);
ALTER TABLE NginxZOPCacheTest ADD constraint PK_NginxZOPCacheTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE NginxZOPCacheTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE NginxZOPCacheTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD                varchar2(32),
OPCODE_CACHING_MIN Number(20,4) NOT NULL,
OPCODE_CACHING_MAX Number(20,4) NOT NULL,
OPCODE_CACHING_STCNT varchar2(32) NOT NULL,
OPTIMIZATION_MIN Number(20,4) NOT NULL,
OPTIMIZATION_MAX Number(20,4) NOT NULL,
OPTIMIZATION_STCNT varchar2(32) NOT NULL,
CACHE_HITS_MIN Number(20,4) NOT NULL,
CACHE_HITS_MAX Number(20,4) NOT NULL,
CACHE_HITS_STCNT varchar2(32) NOT NULL,
CACHE_MISSES_MIN Number(20,4) NOT NULL,
CACHE_MISSES_MAX Number(20,4) NOT NULL,
CACHE_MISSES_STCNT varchar2(32) NOT NULL,
CACHE_HIT_RATE_MIN Number(20,4) NOT NULL,
CACHE_HIT_RATE_MAX Number(20,4) NOT NULL,
CACHE_HIT_RATE_STCNT varchar2(32) NOT NULL,
MISSES_RATIO_MIN Number(20,4) NOT NULL,
MISSES_RATIO_MAX Number(20,4) NOT NULL,
MISSES_RATIO_STCNT varchar2(32) NOT NULL,
USED_MEMORY_MIN Number(20,4) NOT NULL,
USED_MEMORY_MAX Number(20,4) NOT NULL,
USED_MEMORY_STCNT varchar2(32) NOT NULL,
FREE_MEMORY_MIN Number(20,4) NOT NULL,
FREE_MEMORY_MAX Number(20,4) NOT NULL,
FREE_MEMORY_STCNT varchar2(32) NOT NULL,
WASTED_MEMORY_MIN Number(20,4) NOT NULL,
WASTED_MEMORY_MAX Number(20,4) NOT NULL,
WASTED_MEMORY_STCNT varchar2(32) NOT NULL,
WASTED_MEM_PERC_MIN Number(20,4) NOT NULL,
WASTED_MEM_PERC_MAX Number(20,4) NOT NULL,
WASTED_MEM_PERC_STCNT varchar2(32) NOT NULL,
INTRN_STR_USEDMEM_MIN Number(20,4) NOT NULL,
INTRN_STR_USEDMEM_MAX Number(20,4) NOT NULL,
INTRN_STR_USEDMEM_STCNT varchar2(32) NOT NULL,
INTRN_STR_FREEMEM_MIN Number(20,4) NOT NULL,
INTRN_STR_FREEMEM_MAX Number(20,4) NOT NULL,
INTRN_STR_FREEMEM_STCNT varchar2(32) NOT NULL,
CACHED_SCRIPTS_MIN Number(20,4) NOT NULL,
CACHED_SCRIPTS_MAX Number(20,4) NOT NULL,
CACHED_SCRIPTS_STCNT varchar2(32) NOT NULL,
CACHED_KEYS_MIN Number(20,4) NOT NULL,
CACHED_KEYS_MAX Number(20,4) NOT NULL,
CACHED_KEYS_STCNT varchar2(32) NOT NULL,
MAX_KEYS_MIN Number(20,4) NOT NULL,
MAX_KEYS_MAX Number(20,4) NOT NULL,
MAX_KEYS_STCNT varchar2(32) NOT NULL,
OOM_RESTARTS_MIN Number(20,4) NOT NULL,
OOM_RESTARTS_MAX Number(20,4) NOT NULL,
OOM_RESTARTS_STCNT varchar2(32) NOT NULL,
HASH_KEYS_RESTARTS_MIN Number(20,4) NOT NULL,
HASH_KEYS_RESTARTS_MAX Number(20,4) NOT NULL,
HASH_KEYS_RESTARTS_STCNT varchar2(32) NOT NULL,
MANUAL_RESTARTS_MIN Number(20,4) NOT NULL,
MANUAL_RESTARTS_MAX Number(20,4) NOT NULL,
MANUAL_RESTARTS_STCNT varchar2(32) NOT NULL);


ALTER TABLE NginxZOPCacheTest_TREND ADD constraint PK_NgxZOPCachTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE NginxZOPCacheTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE NginxZOPCacheTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
OPCODE_CACHING_MIN VARCHAR2(256) NOT NULL,
OPCODE_CACHING_MAX VARCHAR2(256) NOT NULL,
OPTIMIZATION_MIN VARCHAR2(256) NOT NULL,
OPTIMIZATION_MAX VARCHAR2(256) NOT NULL,
CACHE_HITS_MIN VARCHAR2(256) NOT NULL,
CACHE_HITS_MAX VARCHAR2(256) NOT NULL,
CACHE_MISSES_MIN VARCHAR2(256) NOT NULL,
CACHE_MISSES_MAX VARCHAR2(256) NOT NULL,
CACHE_HIT_RATE_MIN VARCHAR2(256) NOT NULL,
CACHE_HIT_RATE_MAX VARCHAR2(256) NOT NULL,
MISSES_RATIO_MIN VARCHAR2(256) NOT NULL,
MISSES_RATIO_MAX VARCHAR2(256) NOT NULL,
USED_MEMORY_MIN VARCHAR2(256) NOT NULL,
USED_MEMORY_MAX VARCHAR2(256) NOT NULL,
FREE_MEMORY_MIN VARCHAR2(256) NOT NULL,
FREE_MEMORY_MAX VARCHAR2(256) NOT NULL,
WASTED_MEMORY_MIN VARCHAR2(256) NOT NULL,
WASTED_MEMORY_MAX VARCHAR2(256) NOT NULL,
WASTED_MEM_PERC_MIN VARCHAR2(256) NOT NULL,
WASTED_MEM_PERC_MAX VARCHAR2(256) NOT NULL,
INTRN_STR_USEDMEM_MIN VARCHAR2(256) NOT NULL,
INTRN_STR_USEDMEM_MAX VARCHAR2(256) NOT NULL,
INTRN_STR_FREEMEM_MIN VARCHAR2(256) NOT NULL,
INTRN_STR_FREEMEM_MAX VARCHAR2(256) NOT NULL,
CACHED_SCRIPTS_MIN VARCHAR2(256) NOT NULL,
CACHED_SCRIPTS_MAX VARCHAR2(256) NOT NULL,
CACHED_KEYS_MIN VARCHAR2(256) NOT NULL,
CACHED_KEYS_MAX VARCHAR2(256) NOT NULL,
MAX_KEYS_MIN VARCHAR2(256) NOT NULL,
MAX_KEYS_MAX VARCHAR2(256) NOT NULL,
OOM_RESTARTS_MIN VARCHAR2(256) NOT NULL,
OOM_RESTARTS_MAX VARCHAR2(256) NOT NULL,
HASH_KEYS_RESTARTS_MIN VARCHAR2(256) NOT NULL,
HASH_KEYS_RESTARTS_MAX VARCHAR2(256) NOT NULL,
MANUAL_RESTARTS_MIN VARCHAR2(256) NOT NULL,
MANUAL_RESTARTS_MAX VARCHAR2(256) NOT NULL);


ALTER TABLE NginxZOPCacheTest_THRESH ADD constraint PK_NgxZOPCachTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_NginxZOPCacheTest_THRESH ON NginxZOPCacheTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_NginxZOPCacheTest ON NginxZOPCacheTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_NginxZOPCacheTest ON NginxZOPCacheTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE NginxPHPFPMTest CASCADE CONSTRAINTS;
CREATE TABLE NginxPHPFPMTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PRCS_MANAGER Number(20,4) NOT NULL,
PRCS_MANAGER_ST varchar2(32) NOT NULL,
REQ_ACCPT Number(20,4) NOT NULL,
REQ_ACCPT_ST varchar2(32) NOT NULL,
LISTEN_QUE Number(20,4) NOT NULL,
LISTEN_QUE_ST varchar2(32) NOT NULL,
MAX_LISTN_QUE Number(20,4) NOT NULL,
MAX_LISTN_QUE_ST varchar2(32) NOT NULL,
LISTN_QUE_LEN Number(20,4) NOT NULL,
LISTN_QUE_LEN_ST varchar2(32) NOT NULL,
PCNT_LISTN_QUE_USG Number(20,4) NOT NULL,
PCNT_LISTN_QUE_USG_ST varchar2(32) NOT NULL,
IDLE_PROCS Number(20,4) NOT NULL,
IDLE_PROCS_ST varchar2(32) NOT NULL,
ACTIV_PROCS Number(20,4) NOT NULL,
ACTIV_PROCS_ST varchar2(32) NOT NULL,
TOT_PROCS Number(20,4) NOT NULL,
TOT_PROCS_ST varchar2(32) NOT NULL,
PCNT_ACTIV_PROC Number(20,4) NOT NULL,
PCNT_ACTIV_PROC_ST varchar2(32) NOT NULL,
MAX_ACTIV_PROC Number(20,4) NOT NULL,
MAX_ACTIV_PROC_ST varchar2(32) NOT NULL,
MAX_CHILD_RCH Number(20,4) NOT NULL,
MAX_CHILD_RCH_ST varchar2(32) NOT NULL,
SLOW_REQ Number(20,4) NOT NULL,
SLOW_REQ_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_NginxPHPFPMTest ON NginxPHPFPMTest(MSMT_TIME);
ALTER TABLE NginxPHPFPMTest ADD constraint PK_NginxPHPFPMTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE NginxPHPFPMTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE NginxPHPFPMTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
PRCS_MANAGER_MIN Number(20,4) NOT NULL,
PRCS_MANAGER_MAX Number(20,4) NOT NULL,
PRCS_MANAGER_STCNT varchar2(32) NOT NULL,
REQ_ACCPT_MIN Number(20,4) NOT NULL,
REQ_ACCPT_MAX Number(20,4) NOT NULL,
REQ_ACCPT_STCNT varchar2(32) NOT NULL,
LISTEN_QUE_MIN Number(20,4) NOT NULL,
LISTEN_QUE_MAX Number(20,4) NOT NULL,
LISTEN_QUE_STCNT varchar2(32) NOT NULL,
MAX_LISTN_QUE_MIN Number(20,4) NOT NULL,
MAX_LISTN_QUE_MAX Number(20,4) NOT NULL,
MAX_LISTN_QUE_STCNT varchar2(32) NOT NULL,
LISTN_QUE_LEN_MIN Number(20,4) NOT NULL,
LISTN_QUE_LEN_MAX Number(20,4) NOT NULL,
LISTN_QUE_LEN_STCNT varchar2(32) NOT NULL,
PCNT_LISTN_QUE_USG_MIN Number(20,4) NOT NULL,
PCNT_LISTN_QUE_USG_MAX Number(20,4) NOT NULL,
PCNT_LISTN_QUE_USG_STCNT varchar2(32) NOT NULL,
IDLE_PROCS_MIN Number(20,4) NOT NULL,
IDLE_PROCS_MAX Number(20,4) NOT NULL,
IDLE_PROCS_STCNT varchar2(32) NOT NULL,
ACTIV_PROCS_MIN Number(20,4) NOT NULL,
ACTIV_PROCS_MAX Number(20,4) NOT NULL,
ACTIV_PROCS_STCNT varchar2(32) NOT NULL,
TOT_PROCS_MIN Number(20,4) NOT NULL,
TOT_PROCS_MAX Number(20,4) NOT NULL,
TOT_PROCS_STCNT varchar2(32) NOT NULL,
PCNT_ACTIV_PROC_MIN Number(20,4) NOT NULL,
PCNT_ACTIV_PROC_MAX Number(20,4) NOT NULL,
PCNT_ACTIV_PROC_STCNT varchar2(32) NOT NULL,
MAX_ACTIV_PROC_MIN Number(20,4) NOT NULL,
MAX_ACTIV_PROC_MAX Number(20,4) NOT NULL,
MAX_ACTIV_PROC_STCNT varchar2(32) NOT NULL,
MAX_CHILD_RCH_MIN Number(20,4) NOT NULL,
MAX_CHILD_RCH_MAX Number(20,4) NOT NULL,
MAX_CHILD_RCH_STCNT varchar2(32) NOT NULL,
SLOW_REQ_MIN Number(20,4) NOT NULL,
SLOW_REQ_MAX Number(20,4) NOT NULL,
SLOW_REQ_STCNT varchar2(32) NOT NULL);

ALTER TABLE NginxPHPFPMTest_TREND ADD constraint PK_NginxPHPFPMTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE NginxPHPFPMTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE NginxPHPFPMTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
PRCS_MANAGER_MIN VARCHAR2(256) NOT NULL,
PRCS_MANAGER_MAX VARCHAR2(256) NOT NULL,
REQ_ACCPT_MIN VARCHAR2(256) NOT NULL,
REQ_ACCPT_MAX VARCHAR2(256) NOT NULL,
LISTEN_QUE_MIN VARCHAR2(256) NOT NULL,
LISTEN_QUE_MAX VARCHAR2(256) NOT NULL,
MAX_LISTN_QUE_MIN VARCHAR2(256) NOT NULL,
MAX_LISTN_QUE_MAX VARCHAR2(256) NOT NULL,
LISTN_QUE_LEN_MIN VARCHAR2(256) NOT NULL,
LISTN_QUE_LEN_MAX VARCHAR2(256) NOT NULL,
PCNT_LISTN_QUE_USG_MIN VARCHAR2(256) NOT NULL,
PCNT_LISTN_QUE_USG_MAX VARCHAR2(256) NOT NULL,
IDLE_PROCS_MIN VARCHAR2(256) NOT NULL,
IDLE_PROCS_MAX VARCHAR2(256) NOT NULL,
ACTIV_PROCS_MIN VARCHAR2(256) NOT NULL,
ACTIV_PROCS_MAX VARCHAR2(256) NOT NULL,
TOT_PROCS_MIN VARCHAR2(256) NOT NULL,
TOT_PROCS_MAX VARCHAR2(256) NOT NULL,
PCNT_ACTIV_PROC_MIN VARCHAR2(256) NOT NULL,
PCNT_ACTIV_PROC_MAX VARCHAR2(256) NOT NULL,
MAX_ACTIV_PROC_MIN VARCHAR2(256) NOT NULL,
MAX_ACTIV_PROC_MAX VARCHAR2(256) NOT NULL,
MAX_CHILD_RCH_MIN VARCHAR2(256) NOT NULL,
MAX_CHILD_RCH_MAX VARCHAR2(256) NOT NULL,
SLOW_REQ_MIN VARCHAR2(256) NOT NULL,
SLOW_REQ_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE NginxPHPFPMTest_THRESH ADD constraint PK_NginxPHPFPMTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_NginxPHPFPMTest_THRESH ON NginxPHPFPMTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_NginxPHPFPMTest ON NginxPHPFPMTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_NginxPHPFPMTest ON NginxPHPFPMTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE SaaSNetworkTest CASCADE CONSTRAINTS;
CREATE TABLE SaaSNetworkTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
AVG_DELAY Number(20,4) NOT NULL,
AVG_DELAY_ST varchar2(32) NOT NULL,
MIN_DELAY Number(20,4) NOT NULL,
MIN_DELAY_ST varchar2(32) NOT NULL,
PKT_LOSS_PCT Number(20,4) NOT NULL,
PKT_LOSS_PCT_ST varchar2(32) NOT NULL,
AVAILABILITY Number(20,4) NOT NULL,
AVAILABILITY_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SaaSNetworkTest ON SaaSNetworkTest(MSMT_TIME);
ALTER TABLE SaaSNetworkTest ADD constraint PK_SaaSNetworkTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SaaSNetworkTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SaaSNetworkTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
AVG_DELAY_MIN Number(20,4) NOT NULL,
AVG_DELAY_MAX Number(20,4) NOT NULL,
AVG_DELAY_STCNT varchar2(32) NOT NULL,
MIN_DELAY_MIN Number(20,4) NOT NULL,
MIN_DELAY_MAX Number(20,4) NOT NULL,
MIN_DELAY_STCNT varchar2(32) NOT NULL,
PKT_LOSS_PCT_MIN Number(20,4) NOT NULL,
PKT_LOSS_PCT_MAX Number(20,4) NOT NULL,
PKT_LOSS_PCT_STCNT varchar2(32) NOT NULL,
AVAILABILITY_MIN Number(20,4) NOT NULL,
AVAILABILITY_MAX Number(20,4) NOT NULL,
AVAILABILITY_STCNT varchar2(32) NOT NULL);

ALTER TABLE SaaSNetworkTest_TREND ADD constraint PK_SaaSNetworkTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SaaSNetworkTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SaaSNetworkTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
AVG_DELAY_MIN VARCHAR2(256) NOT NULL,
AVG_DELAY_MAX VARCHAR2(256) NOT NULL,
MIN_DELAY_MIN VARCHAR2(256) NOT NULL,
MIN_DELAY_MAX VARCHAR2(256) NOT NULL,
PKT_LOSS_PCT_MIN VARCHAR2(256) NOT NULL,
PKT_LOSS_PCT_MAX VARCHAR2(256) NOT NULL,
AVAILABILITY_MIN VARCHAR2(256) NOT NULL,
AVAILABILITY_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SaaSNetworkTest_THRESH ADD constraint PK_SaaSNetworkTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SaaSNetworkTest_THRESH ON SaaSNetworkTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SaaSNetworkTest ON SaaSNetworkTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SaaSNetworkTest ON SaaSNetworkTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365SecurityGrpsTest CASCADE CONSTRAINTS;
CREATE TABLE O365SecurityGrpsTest(
TRGT_HOST       VARCHAR2(32),
PORT_NO         VARCHAR2(32),
SITE_NAME       VARCHAR2(64),
INFO            VARCHAR2(128),
MSMT_HOST       VARCHAR2(32),
MSMT_TIME       DATE,
NEWLY_CREATED_GROUPS NUMBER(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_ST VARCHAR2(32) NOT NULL,
SOFT_DELETED_GROUPS NUMBER(20,4) NOT NULL,
SOFT_DELETED_GROUPS_ST VARCHAR2(32) NOT NULL,
TOTAL_GROUPS NUMBER(20,4) NOT NULL,
TOTAL_GROUPS_ST VARCHAR2(32) NOT NULL,
ORPHANED_GROUPS NUMBER(20,4) NOT NULL,
ORPHANED_GROUPS_ST VARCHAR2(32) NOT NULL,
EMPTY_GROUPS NUMBER(20,4) NOT NULL,
EMPTY_GROUPS_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_O365SecrtyGrpsTest ON O365SecurityGrpsTest(MSMT_TIME);
ALTER TABLE O365SecurityGrpsTest ADD CONSTRAINT PK_O365SecrtyGrpsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365SecurityGrpsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365SecurityGrpsTest_TREND(
TRGT_HOST       VARCHAR2(32),
PORT_NO         VARCHAR2(32),
SITE_NAME       VARCHAR2(64),
INFO            VARCHAR2(128),
MSMT_HOST       VARCHAR2(32),
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32),
NEWLY_CREATED_GROUPS_MIN NUMBER(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_MAX NUMBER(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
SOFT_DELETED_GROUPS_MIN NUMBER(20,4) NOT NULL,
SOFT_DELETED_GROUPS_MAX NUMBER(20,4) NOT NULL,
SOFT_DELETED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
TOTAL_GROUPS_MIN NUMBER(20,4) NOT NULL,
TOTAL_GROUPS_MAX NUMBER(20,4) NOT NULL,
TOTAL_GROUPS_STCNT VARCHAR2(32) NOT NULL,
ORPHANED_GROUPS_MIN NUMBER(20,4) NOT NULL,
ORPHANED_GROUPS_MAX NUMBER(20,4) NOT NULL,
ORPHANED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
EMPTY_GROUPS_MIN NUMBER(20,4) NOT NULL,
EMPTY_GROUPS_MAX NUMBER(20,4) NOT NULL,
EMPTY_GROUPS_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE O365SecurityGrpsTest_TREND ADD CONSTRAINT PK_O365SecrtyGrpsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365SecurityGrpsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365SecurityGrpsTest_THRESH(
TRGT_HOST       VARCHAR2(32),
PORT_NO         VARCHAR2(32),
SITE_NAME       VARCHAR2(64),
INFO            VARCHAR2(128),
MSMT_HOST       VARCHAR2(32),
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
NEWLY_CREATED_GROUPS_MIN VARCHAR2(256) NOT NULL,
NEWLY_CREATED_GROUPS_MAX VARCHAR2(256) NOT NULL,
SOFT_DELETED_GROUPS_MIN VARCHAR2(256) NOT NULL,
SOFT_DELETED_GROUPS_MAX VARCHAR2(256) NOT NULL,
TOTAL_GROUPS_MIN VARCHAR2(256) NOT NULL,
TOTAL_GROUPS_MAX VARCHAR2(256) NOT NULL,
ORPHANED_GROUPS_MIN VARCHAR2(256) NOT NULL,
ORPHANED_GROUPS_MAX VARCHAR2(256) NOT NULL,
EMPTY_GROUPS_MIN VARCHAR2(256) NOT NULL,
EMPTY_GROUPS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365SecurityGrpsTest_THRESH ADD CONSTRAINT PK_O365SecrtyGrpsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365SecrtyGrpsTest_THRESH ON O365SecurityGrpsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365SecurityGrpsTest ON O365SecurityGrpsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365SecurityGrpsTest ON O365SecurityGrpsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOSiteConnectivityTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteConnectivityTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
WEB_AVAILABILITY Number(20,4) NOT NULL,
WEB_AVAILABILITY_ST varchar2(32) NOT NULL,
RESPONSE_CODE Number(20,4) NOT NULL,
RESPONSE_CODE_ST varchar2(32) NOT NULL,
RESPONSE_TIME Number(20,4) NOT NULL,
RESPONSE_TIME_ST varchar2(32) NOT NULL,
CONTENT_VALIDITY Number(20,4) NOT NULL,
CONTENT_VALIDITY_ST varchar2(32) NOT NULL,
CONTENT_LENGTH Number(20,4) NOT NULL,
CONTENT_LENGTH_ST varchar2(32) NOT NULL,
SPO_health_score Number(20,4) NOT NULL,
SPO_health_score_ST varchar2(32) NOT NULL,
SPO_request_duration Number(20,4) NOT NULL,
SPO_request_duration_ST varchar2(32) NOT NULL,
SPO_iis_latency Number(20,4) NOT NULL,
SPO_iis_latency_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSiteConnTest ON SPOSiteConnectivityTest(MSMT_TIME);
ALTER TABLE SPOSiteConnectivityTest ADD constraint PK_SPOSiteConnTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSiteConnectivityTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteConnectivityTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
WEB_AVAILABILITY_MIN Number(20,4) NOT NULL,
WEB_AVAILABILITY_MAX Number(20,4) NOT NULL,
WEB_AVAILABILITY_STCNT varchar2(32) NOT NULL,
RESPONSE_CODE_MIN Number(20,4) NOT NULL,
RESPONSE_CODE_MAX Number(20,4) NOT NULL,
RESPONSE_CODE_STCNT varchar2(32) NOT NULL,
RESPONSE_TIME_MIN Number(20,4) NOT NULL,
RESPONSE_TIME_MAX Number(20,4) NOT NULL,
RESPONSE_TIME_STCNT varchar2(32) NOT NULL,
CONTENT_VALIDITY_MIN Number(20,4) NOT NULL,
CONTENT_VALIDITY_MAX Number(20,4) NOT NULL,
CONTENT_VALIDITY_STCNT varchar2(32) NOT NULL,
CONTENT_LENGTH_MIN Number(20,4) NOT NULL,
CONTENT_LENGTH_MAX Number(20,4) NOT NULL,
CONTENT_LENGTH_STCNT varchar2(32) NOT NULL,
SPO_health_score_MIN Number(20,4) NOT NULL,
SPO_health_score_MAX Number(20,4) NOT NULL,
SPO_health_score_STCNT varchar2(32) NOT NULL,
SPO_request_duration_MIN Number(20,4) NOT NULL,
SPO_request_duration_MAX Number(20,4) NOT NULL,
SPO_request_duration_STCNT varchar2(32) NOT NULL,
SPO_iis_latency_MIN Number(20,4) NOT NULL,
SPO_iis_latency_MAX Number(20,4) NOT NULL,
SPO_iis_latency_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSiteConnectivityTest_TREND ADD constraint PK_SPOSiteConnTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSiteConnectivityTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteConnectivityTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
WEB_AVAILABILITY_MIN varchar2(256) NOT NULL,
WEB_AVAILABILITY_MAX varchar2(256) NOT NULL,
RESPONSE_CODE_MIN varchar2(256) NOT NULL,
RESPONSE_CODE_MAX varchar2(256) NOT NULL,
RESPONSE_TIME_MIN varchar2(256) NOT NULL,
RESPONSE_TIME_MAX varchar2(256) NOT NULL,
CONTENT_VALIDITY_MIN varchar2(256) NOT NULL,
CONTENT_VALIDITY_MAX varchar2(256) NOT NULL,
CONTENT_LENGTH_MIN varchar2(256) NOT NULL,
CONTENT_LENGTH_MAX varchar2(256) NOT NULL,
SPO_health_score_MIN varchar2(256) NOT NULL,
SPO_health_score_MAX varchar2(256) NOT NULL,
SPO_request_duration_MIN varchar2(256) NOT NULL,
SPO_request_duration_MAX varchar2(256) NOT NULL,
SPO_iis_latency_MIN varchar2(256) NOT NULL,
SPO_iis_latency_MAX varchar2(256) NOT NULL);

ALTER TABLE SPOSiteConnectivityTest_THRESH ADD constraint PK_SPOSiteConnTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSiteConnTest_THRESH ON SPOSiteConnectivityTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSiteConnTest ON SPOSiteConnectivityTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSiteConnTest ON SPOSiteConnectivityTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365DycDistbGrpTest CASCADE CONSTRAINTS;
CREATE TABLE O365DycDistbGrpTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Modified_groups Number(20,4) NOT NULL,
Modified_groups_ST varchar2(32) NOT NULL,
Newly_created_groups Number(20,4) NOT NULL,
Newly_created_groups_ST varchar2(32) NOT NULL,
Soft_deleted_groups Number(20,4) NOT NULL,
Soft_deleted_groups_ST varchar2(32) NOT NULL,
Total_groups Number(20,4) NOT NULL,
Total_groups_ST varchar2(32) NOT NULL,
Orphaned_groups Number(20,4) NOT NULL,
Orphaned_groups_ST varchar2(32) NOT NULL,
Empty_groups Number(20,4) NOT NULL,
Empty_groups_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365DycDistbGrpTest ON O365DycDistbGrpTest(MSMT_TIME);
ALTER TABLE O365DycDistbGrpTest ADD constraint PK_O365DycDistbGrpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365DycDistbGrpTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365DycDistbGrpTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Modified_groups_MIN Number(20,4) NOT NULL,
Modified_groups_MAX Number(20,4) NOT NULL,
Modified_groups_STCNT varchar2(32) NOT NULL,
Newly_created_groups_MIN Number(20,4) NOT NULL,
Newly_created_groups_MAX Number(20,4) NOT NULL,
Newly_created_groups_STCNT varchar2(32) NOT NULL,
Soft_deleted_groups_MIN Number(20,4) NOT NULL,
Soft_deleted_groups_MAX Number(20,4) NOT NULL,
Soft_deleted_groups_STCNT varchar2(32) NOT NULL,
Total_groups_MIN Number(20,4) NOT NULL,
Total_groups_MAX Number(20,4) NOT NULL,
Total_groups_STCNT varchar2(32) NOT NULL,
Orphaned_groups_MIN Number(20,4) NOT NULL,
Orphaned_groups_MAX Number(20,4) NOT NULL,
Orphaned_groups_STCNT varchar2(32) NOT NULL,
Empty_groups_MIN Number(20,4) NOT NULL,
Empty_groups_MAX Number(20,4) NOT NULL,
Empty_groups_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365DycDistbGrpTest_TREND ADD constraint PK_O365DycDistbGrpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365DycDistbGrpTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365DycDistbGrpTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Modified_groups_MIN VARCHAR2(256) NOT NULL,
Modified_groups_MAX VARCHAR2(256) NOT NULL,
Newly_created_groups_MIN VARCHAR2(256) NOT NULL,
Newly_created_groups_MAX VARCHAR2(256) NOT NULL,
Soft_deleted_groups_MIN VARCHAR2(256) NOT NULL,
Soft_deleted_groups_MAX VARCHAR2(256) NOT NULL,
Total_groups_MIN VARCHAR2(256) NOT NULL,
Total_groups_MAX VARCHAR2(256) NOT NULL,
Orphaned_groups_MIN VARCHAR2(256) NOT NULL,
Orphaned_groups_MAX VARCHAR2(256) NOT NULL,
Empty_groups_MIN VARCHAR2(256) NOT NULL,
Empty_groups_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365DycDistbGrpTest_THRESH ADD constraint PK_O365DycDistbGrpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365DycDistbGrpTest_THRESH ON O365DycDistbGrpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365DycDistbGrpTest ON O365DycDistbGrpTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365DycDistbGrpTest ON O365DycDistbGrpTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UserLogtest CASCADE CONSTRAINTS;
CREATE TABLE O365UserLogtest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Unlicensed_users Number(20,4) NOT NULL,
Unlicensed_users_ST varchar2(32) NOT NULL,
Deleted_users Number(20,4) NOT NULL,
Deleted_users_ST varchar2(32) NOT NULL,
Password_exp Number(20,4) NOT NULL,
Password_exp_ST varchar2(32) NOT NULL,
Allowed_users Number(20,4) NOT NULL,
Allowed_users_ST varchar2(32) NOT NULL,
Blocked_users Number(20,4) NOT NULL,
Blocked_users_ST varchar2(32) NOT NULL,
user_pwdexpire Number(20,4) NOT NULL,
user_pwdexpire_ST varchar2(32) NOT NULL,
TOTAL_USERS Number(20,4) NOT NULL,
TOTAL_USERS_ST varchar2(32) NOT NULL,
LICENSED_USERS Number(20,4) NOT NULL,
LICENSED_USERS_ST varchar2(32) NOT NULL,
MFA_ENABLED_USERS Number(20,4) NOT NULL,
MFA_ENABLED_USERS_ST varchar2(32) NOT NULL,
MFA_ENFORCED_USERS Number(20,4) NOT NULL,
MFA_ENFORCED_USERS_ST varchar2(32) NOT NULL,
MFA_DISABLED_USERS Number(20,4) NOT NULL,
MFA_DISABLED_USERS_ST varchar2(32) NOT NULL,
EXTERNAL_USERS Number(20,4) NOT NULL,
EXTERNAL_USERS_ST varchar2(32) NOT NULL);


CREATE INDEX IDX_O365UserLogtest ON O365UserLogtest(MSMT_TIME);
ALTER TABLE O365UserLogtest ADD constraint PK_O365UserLogtest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UserLogtest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365UserLogtest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Unlicensed_users_MIN Number(20,4) NOT NULL,
Unlicensed_users_MAX Number(20,4) NOT NULL,
Unlicensed_users_STCNT varchar2(32) NOT NULL,
Deleted_users_MIN Number(20,4) NOT NULL,
Deleted_users_MAX Number(20,4) NOT NULL,
Deleted_users_STCNT varchar2(32) NOT NULL,
Password_exp_MIN Number(20,4) NOT NULL,
Password_exp_MAX Number(20,4) NOT NULL,
Password_exp_STCNT varchar2(32) NOT NULL,
Allowed_users_MIN Number(20,4) NOT NULL,
Allowed_users_MAX Number(20,4) NOT NULL,
Allowed_users_STCNT varchar2(32) NOT NULL,
Blocked_users_MIN Number(20,4) NOT NULL,
Blocked_users_MAX Number(20,4) NOT NULL,
Blocked_users_STCNT varchar2(32) NOT NULL,
user_pwdexpire_MIN Number(20,4) NOT NULL,
user_pwdexpire_MAX Number(20,4) NOT NULL,
user_pwdexpire_STCNT varchar2(32) NOT NULL,
TOTAL_USERS_MIN Number(20,4) NOT NULL,
TOTAL_USERS_MAX Number(20,4) NOT NULL,
TOTAL_USERS_STCNT varchar2(32) NOT NULL,
LICENSED_USERS_MIN Number(20,4) NOT NULL,
LICENSED_USERS_MAX Number(20,4) NOT NULL,
LICENSED_USERS_STCNT varchar2(32) NOT NULL,
MFA_ENABLED_USERS_MIN Number(20,4) NOT NULL,
MFA_ENABLED_USERS_MAX Number(20,4) NOT NULL,
MFA_ENABLED_USERS_STCNT varchar2(32) NOT NULL,
MFA_ENFORCED_USERS_MIN Number(20,4) NOT NULL,
MFA_ENFORCED_USERS_MAX Number(20,4) NOT NULL,
MFA_ENFORCED_USERS_STCNT varchar2(32) NOT NULL,
MFA_DISABLED_USERS_MIN Number(20,4) NOT NULL,
MFA_DISABLED_USERS_MAX Number(20,4) NOT NULL,
MFA_DISABLED_USERS_STCNT varchar2(32) NOT NULL,
EXTERNAL_USERS_MIN Number(20,4) NOT NULL,
EXTERNAL_USERS_MAX Number(20,4) NOT NULL,
EXTERNAL_USERS_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365UserLogtest_TREND ADD constraint PK_O365UserLogtest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UserLogtest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365UserLogtest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Unlicensed_users_MIN VARCHAR2(256) NOT NULL,
Unlicensed_users_MAX VARCHAR2(256) NOT NULL,
Deleted_users_MIN VARCHAR2(256) NOT NULL,
Deleted_users_MAX VARCHAR2(256) NOT NULL,
Password_exp_MIN VARCHAR2(256) NOT NULL,
Password_exp_MAX VARCHAR2(256) NOT NULL,
Allowed_users_MIN VARCHAR2(256) NOT NULL,
Allowed_users_MAX VARCHAR2(256) NOT NULL,
Blocked_users_MIN VARCHAR2(256) NOT NULL,
Blocked_users_MAX VARCHAR2(256) NOT NULL,
user_pwdexpire_MIN VARCHAR2(256) NOT NULL,
user_pwdexpire_MAX VARCHAR2(256) NOT NULL,
TOTAL_USERS_MIN varchar2(256) NOT NULL,
TOTAL_USERS_MAX varchar2(256) NOT NULL,
LICENSED_USERS_MIN varchar2(256) NOT NULL,
LICENSED_USERS_MAX varchar2(256) NOT NULL,
MFA_ENABLED_USERS_MIN varchar2(256) NOT NULL,
MFA_ENABLED_USERS_MAX varchar2(256) NOT NULL,
MFA_ENFORCED_USERS_MIN varchar2(256) NOT NULL,
MFA_ENFORCED_USERS_MAX varchar2(256) NOT NULL,
MFA_DISABLED_USERS_MIN varchar2(256) NOT NULL,
MFA_DISABLED_USERS_MAX varchar2(256) NOT NULL,
EXTERNAL_USERS_MIN varchar2(256) NOT NULL,
EXTERNAL_USERS_MAX varchar2(256) NOT NULL);

ALTER TABLE O365UserLogtest_THRESH ADD constraint PK_O365UserLogtest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UserLogtest_THRESH ON O365UserLogtest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UserLogtest ON O365UserLogtest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UserLogtest ON O365UserLogtest_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365LicnsUsgTest CASCADE CONSTRAINTS;
CREATE TABLE O365LicnsUsgTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Licensed_users Number(20,4) NOT NULL,
Licensed_users_ST varchar2(32) NOT NULL,
Active_units Number(20,4) NOT NULL,
Active_units_ST varchar2(32) NOT NULL,
Warning_units Number(20,4) NOT NULL,
Warning_units_ST varchar2(32) NOT NULL,
Status Number(20,4) NOT NULL,
Status_ST varchar2(32) NOT NULL,
Trail Number(20,4) NOT NULL,
Trail_ST varchar2(32) NOT NULL,
Total_License Number(20,4) NOT NULL,
Total_License_ST varchar2(32) NOT NULL,
Days_to_Expire Number(20,4) NOT NULL,
Days_to_Expire_ST varchar2(32) NOT NULL,
License_usage Number(20,4) NOT NULL,
License_usage_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365LicnsUsgTest ON O365LicnsUsgTest(MSMT_TIME);
ALTER TABLE O365LicnsUsgTest ADD constraint PK_O365LicnsUsgTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365LicnsUsgTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365LicnsUsgTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Licensed_users_MIN Number(20,4) NOT NULL,
Licensed_users_MAX Number(20,4) NOT NULL,
Licensed_users_STCNT varchar2(32) NOT NULL,
Active_units_MIN Number(20,4) NOT NULL,
Active_units_MAX Number(20,4) NOT NULL,
Active_units_STCNT varchar2(32) NOT NULL,
Warning_units_MIN Number(20,4) NOT NULL,
Warning_units_MAX Number(20,4) NOT NULL,
Warning_units_STCNT varchar2(32) NOT NULL,
Status_MIN Number(20,4) NOT NULL,
Status_MAX Number(20,4) NOT NULL,
Status_STCNT varchar2(32) NOT NULL,
Trail_MIN Number(20,4) NOT NULL,
Trail_MAX Number(20,4) NOT NULL,
Trail_STCNT varchar2(32) NOT NULL,
Total_License_MIN Number(20,4) NOT NULL,
Total_License_MAX Number(20,4) NOT NULL,
Total_License_STCNT varchar2(32) NOT NULL,
Days_to_Expire_MIN Number(20,4) NOT NULL,
Days_to_Expire_MAX Number(20,4) NOT NULL,
Days_to_Expire_STCNT varchar2(32) NOT NULL,
License_usage_MIN Number(20,4) NOT NULL,
License_usage_MAX Number(20,4) NOT NULL,
License_usage_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365LicnsUsgTest_TREND ADD constraint PK_O365LicnsUsgTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365LicnsUsgTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365LicnsUsgTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Licensed_users_MIN VARCHAR2(256) NOT NULL,
Licensed_users_MAX VARCHAR2(256) NOT NULL,
Active_units_MIN VARCHAR2(256) NOT NULL,
Active_units_MAX VARCHAR2(256) NOT NULL,
Warning_units_MIN VARCHAR2(256) NOT NULL,
Warning_units_MAX VARCHAR2(256) NOT NULL,
Status_MIN VARCHAR2(256) NOT NULL,
Status_MAX VARCHAR2(256) NOT NULL,
Trail_MIN VARCHAR2(256) NOT NULL,
Trail_MAX VARCHAR2(256) NOT NULL,
Total_License_MIN VARCHAR2(256) NOT NULL,
Total_License_MAX VARCHAR2(256) NOT NULL,
Days_to_Expire_MIN VARCHAR2(256) NOT NULL,
Days_to_Expire_MAX VARCHAR2(256) NOT NULL,
License_usage_MIN VARCHAR2(256) NOT NULL,
License_usage_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365LicnsUsgTest_THRESH ADD constraint PK_O365LicnsUsgTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365LicnsUsgTest_THRESH ON O365LicnsUsgTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365LicnsUsgTest ON O365LicnsUsgTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365LicnsUsgTest ON O365LicnsUsgTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UserActivTest CASCADE CONSTRAINTS;
CREATE TABLE O365UserActivTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Operations Number(20,4) NOT NULL,
Operations_ST varchar2(32) NOT NULL,
Unique_oprs Number(20,4) NOT NULL,
Unique_oprs_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_O365UserActivTest ON O365UserActivTest(MSMT_TIME);
ALTER TABLE O365UserActivTest ADD constraint PK_O365UserActivTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UserActivTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365UserActivTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Operations_MIN Number(20,4) NOT NULL,
Operations_MAX Number(20,4) NOT NULL,
Operations_STCNT varchar2(32) NOT NULL,
Unique_oprs_MIN Number(20,4) NOT NULL,
Unique_oprs_MAX Number(20,4) NOT NULL,
Unique_oprs_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL);
ALTER TABLE O365UserActivTest_TREND ADD constraint PK_O365UserActivTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UserActivTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365UserActivTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Operations_MIN VARCHAR2(256) NOT NULL,
Operations_MAX VARCHAR2(256) NOT NULL,
Unique_oprs_MIN VARCHAR2(256) NOT NULL,
Unique_oprs_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE O365UserActivTest_THRESH ADD constraint PK_O365UserActivTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UserActivTest_THRESH ON O365UserActivTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UserActivTest ON O365UserActivTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UserActivTest ON O365UserActivTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365ConecChecksTest CASCADE CONSTRAINTS;
CREATE TABLE O365ConecChecksTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Connection_Status Number(20,4) NOT NULL,
Connection_Status_ST varchar2(32) NOT NULL,
Time_taken_to_connect Number(20,4) NOT NULL,
Time_taken_to_connect_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365ConecChecksTest ON O365ConecChecksTest(MSMT_TIME);
ALTER TABLE O365ConecChecksTest ADD constraint PK_O365ConecChecksTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365ConecChecksTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365ConecChecksTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Connection_Status_MIN Number(20,4) NOT NULL,
Connection_Status_MAX Number(20,4) NOT NULL,
Connection_Status_STCNT varchar2(32) NOT NULL,
Time_taken_to_connect_MIN Number(20,4) NOT NULL,
Time_taken_to_connect_MAX Number(20,4) NOT NULL,
Time_taken_to_connect_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365ConecChecksTest_TREND ADD constraint PK_O365ConecChecksTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365ConecChecksTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365ConecChecksTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Connection_Status_MIN VARCHAR2(256) NOT NULL,
Connection_Status_MAX VARCHAR2(256) NOT NULL,
Time_taken_to_connect_MIN VARCHAR2(256) NOT NULL,
Time_taken_to_connect_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365ConecChecksTest_THRESH ADD constraint PK_O365ConecChecksTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365ConecChecksTest_THRESH ON O365ConecChecksTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365ConecChecksTest ON O365ConecChecksTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365ConecChecksTest ON O365ConecChecksTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365DomainTest CASCADE CONSTRAINTS;
CREATE TABLE O365DomainTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Authent Number(20,4) NOT NULL,
Authent_ST varchar2(32) NOT NULL,
cap_cnt Number(20,4) NOT NULL,
cap_cnt_ST varchar2(32) NOT NULL,
IsDefault Number(20,4) NOT NULL,
IsDefault_ST varchar2(32) NOT NULL,
IsInitial Number(20,4) NOT NULL,
IsInitial_ST varchar2(32) NOT NULL,
Stat Number(20,4) NOT NULL,
Stat_ST varchar2(32) NOT NULL,
VerifMethod Number(20,4) NOT NULL,
VerifMethod_ST varchar2(32) NOT NULL,
rootDom_cnt Number(20,4) NOT NULL,
rootDom_cnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365DomainTest ON O365DomainTest(MSMT_TIME);
ALTER TABLE O365DomainTest ADD constraint PK_O365DomainTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365DomainTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365DomainTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Authent_MIN Number(20,4) NOT NULL,
Authent_MAX Number(20,4) NOT NULL,
Authent_STCNT varchar2(32) NOT NULL,
cap_cnt_MIN Number(20,4) NOT NULL,
cap_cnt_MAX Number(20,4) NOT NULL,
cap_cnt_STCNT varchar2(32) NOT NULL,
IsDefault_MIN Number(20,4) NOT NULL,
IsDefault_MAX Number(20,4) NOT NULL,
IsDefault_STCNT varchar2(32) NOT NULL,
IsInitial_MIN Number(20,4) NOT NULL,
IsInitial_MAX Number(20,4) NOT NULL,
IsInitial_STCNT varchar2(32) NOT NULL,
Stat_MIN Number(20,4) NOT NULL,
Stat_MAX Number(20,4) NOT NULL,
Stat_STCNT varchar2(32) NOT NULL,
VerifMethod_MIN Number(20,4) NOT NULL,
VerifMethod_MAX Number(20,4) NOT NULL,
VerifMethod_STCNT varchar2(32) NOT NULL,
rootDom_cnt_MIN Number(20,4) NOT NULL,
rootDom_cnt_MAX Number(20,4) NOT NULL,
rootDom_cnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365DomainTest_TREND ADD constraint PK_O365DomainTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365DomainTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365DomainTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Authent_MIN VARCHAR2(256) NOT NULL,
Authent_MAX VARCHAR2(256) NOT NULL,
cap_cnt_MIN VARCHAR2(256) NOT NULL,
cap_cnt_MAX VARCHAR2(256) NOT NULL,
IsDefault_MIN VARCHAR2(256) NOT NULL,
IsDefault_MAX VARCHAR2(256) NOT NULL,
IsInitial_MIN VARCHAR2(256) NOT NULL,
IsInitial_MAX VARCHAR2(256) NOT NULL,
Stat_MIN VARCHAR2(256) NOT NULL,
Stat_MAX VARCHAR2(256) NOT NULL,
VerifMethod_MIN VARCHAR2(256) NOT NULL,
VerifMethod_MAX VARCHAR2(256) NOT NULL,
rootDom_cnt_MIN VARCHAR2(256) NOT NULL,
rootDom_cnt_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365DomainTest_THRESH ADD constraint PK_O365DomainTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365DomainTest_THRESH ON O365DomainTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365DomainTest ON O365DomainTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365DomainTest ON O365DomainTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365MsgCenTest CASCADE CONSTRAINTS;
CREATE TABLE O365MsgCenTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365MsgCenTest ON O365MsgCenTest(MSMT_TIME);
ALTER TABLE O365MsgCenTest ADD constraint PK_O365MsgCenTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365MsgCenTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365MsgCenTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365MsgCenTest_TREND ADD constraint PK_O365MsgCenTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365MsgCenTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365MsgCenTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MsgCenterCommunication_MIN VARCHAR2(256) NOT NULL,
MsgCenterCommunication_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365MsgCenTest_THRESH ADD constraint PK_O365MsgCenTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365MsgCenTest_THRESH ON O365MsgCenTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365MsgCenTest ON O365MsgCenTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365MsgCenTest ON O365MsgCenTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365DistbnGrpsTest CASCADE CONSTRAINTS;
CREATE TABLE O365DistbnGrpsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Modified_groups Number(20,4) NOT NULL,
Modified_groups_ST varchar2(32) NOT NULL,
Newly_created_groups Number(20,4) NOT NULL,
Newly_created_groups_ST varchar2(32) NOT NULL,
Soft_deleted_groups Number(20,4) NOT NULL,
Soft_deleted_groups_ST varchar2(32) NOT NULL,
Total_groups Number(20,4) NOT NULL,
Total_groups_ST varchar2(32) NOT NULL,
Orphaned_groups Number(20,4) NOT NULL,
Orphaned_groups_ST varchar2(32) NOT NULL,
Empty_groups Number(20,4) NOT NULL,
Empty_groups_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365DistbnGrpsTest ON O365DistbnGrpsTest(MSMT_TIME);
ALTER TABLE O365DistbnGrpsTest ADD constraint PK_O365DistbnGrpsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365DistbnGrpsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365DistbnGrpsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Modified_groups_MIN Number(20,4) NOT NULL,
Modified_groups_MAX Number(20,4) NOT NULL,
Modified_groups_STCNT varchar2(32) NOT NULL,
Newly_created_groups_MIN Number(20,4) NOT NULL,
Newly_created_groups_MAX Number(20,4) NOT NULL,
Newly_created_groups_STCNT varchar2(32) NOT NULL,
Soft_deleted_groups_MIN Number(20,4) NOT NULL,
Soft_deleted_groups_MAX Number(20,4) NOT NULL,
Soft_deleted_groups_STCNT varchar2(32) NOT NULL,
Total_groups_MIN Number(20,4) NOT NULL,
Total_groups_MAX Number(20,4) NOT NULL,
Total_groups_STCNT varchar2(32) NOT NULL,
Orphaned_groups_MIN Number(20,4) NOT NULL,
Orphaned_groups_MAX Number(20,4) NOT NULL,
Orphaned_groups_STCNT varchar2(32) NOT NULL,
Empty_groups_MIN Number(20,4) NOT NULL,
Empty_groups_MAX Number(20,4) NOT NULL,
Empty_groups_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365DistbnGrpsTest_TREND ADD constraint PK_O365DistbnGrpsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365DistbnGrpsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365DistbnGrpsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Modified_groups_MIN VARCHAR2(256) NOT NULL,
Modified_groups_MAX VARCHAR2(256) NOT NULL,
Newly_created_groups_MIN VARCHAR2(256) NOT NULL,
Newly_created_groups_MAX VARCHAR2(256) NOT NULL,
Soft_deleted_groups_MIN VARCHAR2(256) NOT NULL,
Soft_deleted_groups_MAX VARCHAR2(256) NOT NULL,
Total_groups_MIN VARCHAR2(256) NOT NULL,
Total_groups_MAX VARCHAR2(256) NOT NULL,
Orphaned_groups_MIN VARCHAR2(256) NOT NULL,
Orphaned_groups_MAX VARCHAR2(256) NOT NULL,
Empty_groups_MIN VARCHAR2(256) NOT NULL,
Empty_groups_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365DistbnGrpsTest_THRESH ADD constraint PK_O365DistbnGrpsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365DistbnGrpsTest_THRESH ON O365DistbnGrpsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365DistbnGrpsTest ON O365DistbnGrpsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365DistbnGrpsTest ON O365DistbnGrpsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365SrvHealTest CASCADE CONSTRAINTS;
CREATE TABLE O365SrvHealTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Service_incidents Number(20,4) NOT NULL,
Service_incidents_ST varchar2(32) NOT NULL,
Maintenance_events Number(20,4) NOT NULL,
Maintenance_events_ST varchar2(32) NOT NULL,
Service_Status Number(20,4) NOT NULL,
Service_Status_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365SrvHealTest ON O365SrvHealTest(MSMT_TIME);
ALTER TABLE O365SrvHealTest ADD constraint PK_O365SrvHealTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365SrvHealTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365SrvHealTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Service_incidents_MIN Number(20,4) NOT NULL,
Service_incidents_MAX Number(20,4) NOT NULL,
Service_incidents_STCNT varchar2(32) NOT NULL,
Maintenance_events_MIN Number(20,4) NOT NULL,
Maintenance_events_MAX Number(20,4) NOT NULL,
Maintenance_events_STCNT varchar2(32) NOT NULL,
Service_Status_MIN Number(20,4) NOT NULL,
Service_Status_MAX Number(20,4) NOT NULL,
Service_Status_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365SrvHealTest_TREND ADD constraint PK_O365SrvHealTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365SrvHealTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365SrvHealTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Service_incidents_MIN VARCHAR2(256) NOT NULL,
Service_incidents_MAX VARCHAR2(256) NOT NULL,
Maintenance_events_MIN VARCHAR2(256) NOT NULL,
Maintenance_events_MAX VARCHAR2(256) NOT NULL,
Service_Status_MIN VARCHAR2(256) NOT NULL,
Service_Status_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365SrvHealTest_THRESH ADD constraint PK_O365SrvHealTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365SrvHealTest_THRESH ON O365SrvHealTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365SrvHealTest ON O365SrvHealTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365SrvHealTest ON O365SrvHealTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365UNFIEDGRPSTEST CASCADE CONSTRAINTS;
CREATE TABLE O365UNFIEDGRPSTEST(
TRGT_HOST       VARCHAR2(32),
PORT_NO         VARCHAR2(32),
SITE_NAME       VARCHAR2(64),
INFO            VARCHAR2(128),
MSMT_HOST       VARCHAR2(32),
MSMT_TIME       DATE,
MODIFIED_GROUPS NUMBER(20,4) NOT NULL,
MODIFIED_GROUPS_ST VARCHAR2(32) NOT NULL,
NEWLY_CREATED_GROUPS NUMBER(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_ST VARCHAR2(32) NOT NULL,
SOFT_DELETED_GROUPS NUMBER(20,4) NOT NULL,
SOFT_DELETED_GROUPS_ST VARCHAR2(32) NOT NULL,
TOTAL_GROUPS NUMBER(20,4) NOT NULL,
TOTAL_GROUPS_ST VARCHAR2(32) NOT NULL,
PUBLIC_GROUPS NUMBER(20,4) NOT NULL,
PUBLIC_GROUPS_ST VARCHAR2(32) NOT NULL,
PRIVATE_GROUPS NUMBER(20,4) NOT NULL,
PRIVATE_GROUPS_ST VARCHAR2(32) NOT NULL,
ORPHANED_GROUPS NUMBER(20,4) NOT NULL,
ORPHANED_GROUPS_ST VARCHAR2(32) NOT NULL,
EMPTY_GROUPS NUMBER(20,4) NOT NULL,
EMPTY_GROUPS_ST VARCHAR2(32) NOT NULL,
GROUPS_EXTERNAL NUMBER(20,4) NOT NULL,
GROUPS_EXTERNAL_ST VARCHAR2(32) NOT NULL);

CREATE INDEX IDX_O365UNFIEDGRPSTEST ON O365UNFIEDGRPSTEST(MSMT_TIME);
ALTER TABLE O365UNFIEDGRPSTEST ADD CONSTRAINT PK_O365UNFIEDGRPSTEST PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365UNFIEDGRPSTEST_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365UNFIEDGRPSTEST_TREND(
TRGT_HOST       VARCHAR2(32),
PORT_NO         VARCHAR2(32),
SITE_NAME       VARCHAR2(64),
INFO            VARCHAR2(128),
MSMT_HOST       VARCHAR2(32),
MSMT_TIME       DATE,
PERIOD       	VARCHAR2(32),
MODIFIED_GROUPS_MIN NUMBER(20,4) NOT NULL,
MODIFIED_GROUPS_MAX NUMBER(20,4) NOT NULL,
MODIFIED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
NEWLY_CREATED_GROUPS_MIN NUMBER(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_MAX NUMBER(20,4) NOT NULL,
NEWLY_CREATED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
SOFT_DELETED_GROUPS_MIN NUMBER(20,4) NOT NULL,
SOFT_DELETED_GROUPS_MAX NUMBER(20,4) NOT NULL,
SOFT_DELETED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
TOTAL_GROUPS_MIN NUMBER(20,4) NOT NULL,
TOTAL_GROUPS_MAX NUMBER(20,4) NOT NULL,
TOTAL_GROUPS_STCNT VARCHAR2(32) NOT NULL,
PUBLIC_GROUPS_MIN NUMBER(20,4) NOT NULL,
PUBLIC_GROUPS_MAX NUMBER(20,4) NOT NULL,
PUBLIC_GROUPS_STCNT VARCHAR2(32) NOT NULL,
PRIVATE_GROUPS_MIN NUMBER(20,4) NOT NULL,
PRIVATE_GROUPS_MAX NUMBER(20,4) NOT NULL,
PRIVATE_GROUPS_STCNT VARCHAR2(32) NOT NULL,
ORPHANED_GROUPS_MIN NUMBER(20,4) NOT NULL,
ORPHANED_GROUPS_MAX NUMBER(20,4) NOT NULL,
ORPHANED_GROUPS_STCNT VARCHAR2(32) NOT NULL,
EMPTY_GROUPS_MIN NUMBER(20,4) NOT NULL,
EMPTY_GROUPS_MAX NUMBER(20,4) NOT NULL,
EMPTY_GROUPS_STCNT VARCHAR2(32) NOT NULL,
GROUPS_EXTERNAL_MIN NUMBER(20,4) NOT NULL,
GROUPS_EXTERNAL_MAX NUMBER(20,4) NOT NULL,
GROUPS_EXTERNAL_STCNT VARCHAR2(32) NOT NULL);

ALTER TABLE O365UNFIEDGRPSTEST_TREND ADD CONSTRAINT PK_O365UNFIEDGRPSTEST_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365UNFIEDGRPSTEST_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365UNFIEDGRPSTEST_THRESH(
TRGT_HOST       VARCHAR2(32),
PORT_NO         VARCHAR2(32),
SITE_NAME       VARCHAR2(64),
INFO            VARCHAR2(128),
MSMT_HOST       VARCHAR2(32),
MSMT_TIME_START DATE,
MSMT_TIME_END   DATE,
MODIFIED_GROUPS_MIN VARCHAR2(256) NOT NULL,
MODIFIED_GROUPS_MAX VARCHAR2(256) NOT NULL,
NEWLY_CREATED_GROUPS_MIN VARCHAR2(256) NOT NULL,
NEWLY_CREATED_GROUPS_MAX VARCHAR2(256) NOT NULL,
SOFT_DELETED_GROUPS_MIN VARCHAR2(256) NOT NULL,
SOFT_DELETED_GROUPS_MAX VARCHAR2(256) NOT NULL,
TOTAL_GROUPS_MIN VARCHAR2(256) NOT NULL,
TOTAL_GROUPS_MAX VARCHAR2(256) NOT NULL,
PUBLIC_GROUPS_MIN VARCHAR2(256) NOT NULL,
PUBLIC_GROUPS_MAX VARCHAR2(256) NOT NULL,
PRIVATE_GROUPS_MIN VARCHAR2(256) NOT NULL,
PRIVATE_GROUPS_MAX VARCHAR2(256) NOT NULL,
ORPHANED_GROUPS_MIN VARCHAR2(256) NOT NULL,
ORPHANED_GROUPS_MAX VARCHAR2(256) NOT NULL,
EMPTY_GROUPS_MIN VARCHAR2(256) NOT NULL,
EMPTY_GROUPS_MAX VARCHAR2(256) NOT NULL,
GROUPS_EXTERNAL_MIN VARCHAR2(256) NOT NULL,
GROUPS_EXTERNAL_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365UNFIEDGRPSTEST_THRESH ADD CONSTRAINT PK_O365UNFIEDGRPSTEST_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365UNFIEDGRPSTEST_THRESH ON O365UNFIEDGRPSTEST_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365UNFIEDGRPSTEST ON O365UNFIEDGRPSTEST_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365UNFIEDGRPSTEST ON O365UNFIEDGRPSTEST_TREND (MSMT_TIME,PERIOD);


DROP TABLE O365SrvPrvStats CASCADE CONSTRAINTS;
CREATE TABLE O365SrvPrvStats(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Pnding_Actvtion Number(20,4) NOT NULL,
Pnding_Actvtion_ST varchar2(32) NOT NULL,
Pnding_Prvision Number(20,4) NOT NULL,
Pnding_Prvision_ST varchar2(32) NOT NULL,
Pnding_input Number(20,4) NOT NULL,
Pnding_input_ST varchar2(32) NOT NULL,
Success Number(20,4) NOT NULL,
Success_ST varchar2(32) NOT NULL,
Disabled Number(20,4) NOT NULL,
Disabled_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365SrvPrvStats ON O365SrvPrvStats(MSMT_TIME);
ALTER TABLE O365SrvPrvStats ADD constraint PK_O365SrvPrvStats PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365SrvPrvStats_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365SrvPrvStats_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Pnding_Actvtion_MIN Number(20,4) NOT NULL,
Pnding_Actvtion_MAX Number(20,4) NOT NULL,
Pnding_Actvtion_STCNT varchar2(32) NOT NULL,
Pnding_Prvision_MIN Number(20,4) NOT NULL,
Pnding_Prvision_MAX Number(20,4) NOT NULL,
Pnding_Prvision_STCNT varchar2(32) NOT NULL,
Pnding_input_MIN Number(20,4) NOT NULL,
Pnding_input_MAX Number(20,4) NOT NULL,
Pnding_input_STCNT varchar2(32) NOT NULL,
Success_MIN Number(20,4) NOT NULL,
Success_MAX Number(20,4) NOT NULL,
Success_STCNT varchar2(32) NOT NULL,
Disabled_MIN Number(20,4) NOT NULL,
Disabled_MAX Number(20,4) NOT NULL,
Disabled_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365SrvPrvStats_TREND ADD constraint PK_O365SrvPrvStats_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365SrvPrvStats_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365SrvPrvStats_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Pnding_Actvtion_MIN VARCHAR2(256) NOT NULL,
Pnding_Actvtion_MAX VARCHAR2(256) NOT NULL,
Pnding_Prvision_MIN VARCHAR2(256) NOT NULL,
Pnding_Prvision_MAX VARCHAR2(256) NOT NULL,
Pnding_input_MIN VARCHAR2(256) NOT NULL,
Pnding_input_MAX VARCHAR2(256) NOT NULL,
Success_MIN VARCHAR2(256) NOT NULL,
Success_MAX VARCHAR2(256) NOT NULL,
Disabled_MIN VARCHAR2(256) NOT NULL,
Disabled_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365SrvPrvStats_THRESH ADD constraint PK_O365SrvPrvStats_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365SrvPrvStats_THRESH ON O365SrvPrvStats_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365SrvPrvStats ON O365SrvPrvStats_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365SrvPrvStats ON O365SrvPrvStats_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365SpfAdtLgTest CASCADE CONSTRAINTS;
CREATE TABLE O365SpfAdtLgTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Operation_Cnt Number(20,4) NOT NULL,
Operation_Cnt_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365SpfAdtLgTest ON O365SpfAdtLgTest(MSMT_TIME);
ALTER TABLE O365SpfAdtLgTest ADD constraint PK_O365SpfAdtLgTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365SpfAdtLgTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365SpfAdtLgTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Operation_Cnt_MIN Number(20,4) NOT NULL,
Operation_Cnt_MAX Number(20,4) NOT NULL,
Operation_Cnt_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365SpfAdtLgTest_TREND ADD constraint PK_O365SpfAdtLgTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365SpfAdtLgTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365SpfAdtLgTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Operation_Cnt_MIN VARCHAR2(256) NOT NULL,
Operation_Cnt_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365SpfAdtLgTest_THRESH ADD constraint PK_O365SpfAdtLgTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365SpfAdtLgTest_THRESH ON O365SpfAdtLgTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365SpfAdtLgTest ON O365SpfAdtLgTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365SpfAdtLgTest ON O365SpfAdtLgTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE O365LoginTest CASCADE CONSTRAINTS;
CREATE TABLE O365LoginTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Authentication_status Number(20,4) NOT NULL,
Authentication_status_ST varchar2(32) NOT NULL,
Authentication_time Number(20,4) NOT NULL,
Authentication_time_ST varchar2(32) NOT NULL,
Login_status Number(20,4) NOT NULL,
Login_status_ST varchar2(32) NOT NULL,
Login_time Number(20,4) NOT NULL,
Login_time_ST varchar2(32) NOT NULL,
Total_login_time Number(20,4) NOT NULL,
Total_login_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_O365LoginTest ON O365LoginTest(MSMT_TIME);
ALTER TABLE O365LoginTest ADD constraint PK_O365LoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE O365LoginTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE O365LoginTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Authentication_status_MIN Number(20,4) NOT NULL,
Authentication_status_MAX Number(20,4) NOT NULL,
Authentication_status_STCNT varchar2(32) NOT NULL,
Authentication_time_MIN Number(20,4) NOT NULL,
Authentication_time_MAX Number(20,4) NOT NULL,
Authentication_time_STCNT varchar2(32) NOT NULL,
Login_status_MIN Number(20,4) NOT NULL,
Login_status_MAX Number(20,4) NOT NULL,
Login_status_STCNT varchar2(32) NOT NULL,
Login_time_MIN Number(20,4) NOT NULL,
Login_time_MAX Number(20,4) NOT NULL,
Login_time_STCNT varchar2(32) NOT NULL,
Total_login_time_MIN Number(20,4) NOT NULL,
Total_login_time_MAX Number(20,4) NOT NULL,
Total_login_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE O365LoginTest_TREND ADD constraint PK_O365LoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE O365LoginTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE O365LoginTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Authentication_status_MIN VARCHAR2(256) NOT NULL,
Authentication_status_MAX VARCHAR2(256) NOT NULL,
Authentication_time_MIN VARCHAR2(256) NOT NULL,
Authentication_time_MAX VARCHAR2(256) NOT NULL,
Login_status_MIN VARCHAR2(256) NOT NULL,
Login_status_MAX VARCHAR2(256) NOT NULL,
Login_time_MIN VARCHAR2(256) NOT NULL,
Login_time_MAX VARCHAR2(256) NOT NULL,
Total_login_time_MIN VARCHAR2(256) NOT NULL,
Total_login_time_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE O365LoginTest_THRESH ADD constraint PK_O365LoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_O365LoginTest_THRESH ON O365LoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_O365LoginTest ON O365LoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_O365LoginTest ON O365LoginTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOServiceTest CASCADE CONSTRAINTS;
CREATE TABLE SPOServiceTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Service_incidents Number(20,4) NOT NULL,
Service_incidents_ST varchar2(32) NOT NULL,
Maintenance_events Number(20,4) NOT NULL,
Maintenance_events_ST varchar2(32) NOT NULL,
SERVICE_STATUS Number(20,4) NOT NULL,
SERVICE_STATUS_ST varchar2(32) NOT NULL
);

CREATE INDEX IDX_SPOServiceTest ON SPOServiceTest(MSMT_TIME);
ALTER TABLE SPOServiceTest ADD constraint PK_SPOServiceTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOServiceTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOServiceTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Service_incidents_MIN Number(20,4) NOT NULL,
Service_incidents_MAX Number(20,4) NOT NULL,
Service_incidents_STCNT varchar2(32) NOT NULL,
Maintenance_events_MIN Number(20,4) NOT NULL,
Maintenance_events_MAX Number(20,4) NOT NULL,
Maintenance_events_STCNT varchar2(32) NOT NULL,
SERVICE_STATUS_MIN Number(20,4) NOT NULL,
SERVICE_STATUS_MAX Number(20,4) NOT NULL,
SERVICE_STATUS_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOServiceTest_TREND ADD constraint PK_SPOServiceTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOServiceTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOServiceTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Service_incidents_MIN VARCHAR2(256) NOT NULL,
Service_incidents_MAX VARCHAR2(256) NOT NULL,
Maintenance_events_MIN VARCHAR2(256) NOT NULL,
Maintenance_events_MAX VARCHAR2(256) NOT NULL,
SERVICE_STATUS_MIN VARCHAR2(256) NOT NULL,
SERVICE_STATUS_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOServiceTest_THRESH ADD constraint PK_SPOServiceTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOServiceTest_THRESH ON SPOServiceTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOServiceTest ON SPOServiceTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOServiceTest ON SPOServiceTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOFileFieldsTest CASCADE CONSTRAINTS;
CREATE TABLE SPOFileFieldsTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
File_upload_status Number(20,4) NOT NULL,
File_upload_status_ST varchar2(32) NOT NULL,
File_upload_time Number(20,4) NOT NULL,
File_upload_time_ST varchar2(32) NOT NULL,
File_download_status Number(20,4) NOT NULL,
File_download_status_ST varchar2(32) NOT NULL,
File_download_time Number(20,4) NOT NULL,
File_download_time_ST varchar2(32) NOT NULL,
File_checkout_status Number(20,4) NOT NULL,
File_checkout_status_ST varchar2(32) NOT NULL,
File_checkout_time Number(20,4) NOT NULL,
File_checkout_time_ST varchar2(32) NOT NULL,
File_checkin_status Number(20,4) NOT NULL,
File_checkin_status_ST varchar2(32) NOT NULL,
File_checkin_time Number(20,4) NOT NULL,
File_checkin_time_ST varchar2(32) NOT NULL,
File_deletion_status Number(20,4) NOT NULL,
File_deletion_status_ST varchar2(32) NOT NULL,
File_deletion_time Number(20,4) NOT NULL,
File_deletion_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOFileFieldsTest ON SPOFileFieldsTest(MSMT_TIME);
ALTER TABLE SPOFileFieldsTest ADD constraint PK_SPOFileFieldsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOFileFieldsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOFileFieldsTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
File_upload_status_MIN Number(20,4) NOT NULL,
File_upload_status_MAX Number(20,4) NOT NULL,
File_upload_status_STCNT varchar2(32) NOT NULL,
File_upload_time_MIN Number(20,4) NOT NULL,
File_upload_time_MAX Number(20,4) NOT NULL,
File_upload_time_STCNT varchar2(32) NOT NULL,
File_download_status_MIN Number(20,4) NOT NULL,
File_download_status_MAX Number(20,4) NOT NULL,
File_download_status_STCNT varchar2(32) NOT NULL,
File_download_time_MIN Number(20,4) NOT NULL,
File_download_time_MAX Number(20,4) NOT NULL,
File_download_time_STCNT varchar2(32) NOT NULL,
File_checkout_status_MIN Number(20,4) NOT NULL,
File_checkout_status_MAX Number(20,4) NOT NULL,
File_checkout_status_STCNT varchar2(32) NOT NULL,
File_checkout_time_MIN Number(20,4) NOT NULL,
File_checkout_time_MAX Number(20,4) NOT NULL,
File_checkout_time_STCNT varchar2(32) NOT NULL,
File_checkin_status_MIN Number(20,4) NOT NULL,
File_checkin_status_MAX Number(20,4) NOT NULL,
File_checkin_status_STCNT varchar2(32) NOT NULL,
File_checkin_time_MIN Number(20,4) NOT NULL,
File_checkin_time_MAX Number(20,4) NOT NULL,
File_checkin_time_STCNT varchar2(32) NOT NULL,
File_deletion_status_MIN Number(20,4) NOT NULL,
File_deletion_status_MAX Number(20,4) NOT NULL,
File_deletion_status_STCNT varchar2(32) NOT NULL,
File_deletion_time_MIN Number(20,4) NOT NULL,
File_deletion_time_MAX Number(20,4) NOT NULL,
File_deletion_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOFileFieldsTest_TREND ADD constraint PK_SPOFileFieldsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOFileFieldsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOFileFieldsTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
File_upload_status_MIN VARCHAR2(256) NOT NULL,
File_upload_status_MAX VARCHAR2(256) NOT NULL,
File_upload_time_MIN VARCHAR2(256) NOT NULL,
File_upload_time_MAX VARCHAR2(256) NOT NULL,
File_download_status_MIN VARCHAR2(256) NOT NULL,
File_download_status_MAX VARCHAR2(256) NOT NULL,
File_download_time_MIN VARCHAR2(256) NOT NULL,
File_download_time_MAX VARCHAR2(256) NOT NULL,
File_checkout_status_MIN VARCHAR2(256) NOT NULL,
File_checkout_status_MAX VARCHAR2(256) NOT NULL,
File_checkout_time_MIN VARCHAR2(256) NOT NULL,
File_checkout_time_MAX VARCHAR2(256) NOT NULL,
File_checkin_status_MIN VARCHAR2(256) NOT NULL,
File_checkin_status_MAX VARCHAR2(256) NOT NULL,
File_checkin_time_MIN VARCHAR2(256) NOT NULL,
File_checkin_time_MAX VARCHAR2(256) NOT NULL,
File_deletion_status_MIN VARCHAR2(256) NOT NULL,
File_deletion_status_MAX VARCHAR2(256) NOT NULL,
File_deletion_time_MIN VARCHAR2(256) NOT NULL,
File_deletion_time_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOFileFieldsTest_THRESH ADD constraint PK_SPOFileFieldsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOFileFieldsTest_THRESH ON SPOFileFieldsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOFileFieldsTest ON SPOFileFieldsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOFileFieldsTest ON SPOFileFieldsTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOTenantTest CASCADE CONSTRAINTS;
CREATE TABLE SPOTenantTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
OneDrive_storage_quota Number(20,4) NOT NULL,
OneDrive_storage_quota_ST varchar2(32) NOT NULL,
Resource_quota Number(20,4) NOT NULL,
Resource_quota_ST varchar2(32) NOT NULL,
Resource_quota_allocated Number(20,4) NOT NULL,
Resource_quota_allocated_ST varchar2(32) NOT NULL,
Storage_quota Number(20,4) NOT NULL,
Storage_quota_ST varchar2(32) NOT NULL,
Storage_quota_allocated Number(20,4) NOT NULL,
Storage_quota_allocated_ST varchar2(32) NOT NULL,
Deleted_sites Number(20,4) NOT NULL,
Deleted_sites_ST varchar2(32) NOT NULL,
Applications Number(20,4) NOT NULL,
Applications_ST varchar2(32) NOT NULL,
Web_templates Number(20,4) NOT NULL,
Web_templates_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOTenantTest ON SPOTenantTest(MSMT_TIME);
ALTER TABLE SPOTenantTest ADD constraint PK_SPOTenantTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOTenantTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOTenantTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
OneDrive_storage_quota_MIN Number(20,4) NOT NULL,
OneDrive_storage_quota_MAX Number(20,4) NOT NULL,
OneDrive_storage_quota_STCNT varchar2(32) NOT NULL,
Resource_quota_MIN Number(20,4) NOT NULL,
Resource_quota_MAX Number(20,4) NOT NULL,
Resource_quota_STCNT varchar2(32) NOT NULL,
Resource_quota_allocated_MIN Number(20,4) NOT NULL,
Resource_quota_allocated_MAX Number(20,4) NOT NULL,
Resource_quota_allocated_STCNT varchar2(32) NOT NULL,
Storage_quota_MIN Number(20,4) NOT NULL,
Storage_quota_MAX Number(20,4) NOT NULL,
Storage_quota_STCNT varchar2(32) NOT NULL,
Storage_quota_allocated_MIN Number(20,4) NOT NULL,
Storage_quota_allocated_MAX Number(20,4) NOT NULL,
Storage_quota_allocated_STCNT varchar2(32) NOT NULL,
Deleted_sites_MIN Number(20,4) NOT NULL,
Deleted_sites_MAX Number(20,4) NOT NULL,
Deleted_sites_STCNT varchar2(32) NOT NULL,
Applications_MIN Number(20,4) NOT NULL,
Applications_MAX Number(20,4) NOT NULL,
Applications_STCNT varchar2(32) NOT NULL,
Web_templates_MIN Number(20,4) NOT NULL,
Web_templates_MAX Number(20,4) NOT NULL,
Web_templates_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOTenantTest_TREND ADD constraint PK_SPOTenantTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOTenantTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOTenantTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
OneDrive_storage_quota_MIN VARCHAR2(256) NOT NULL,
OneDrive_storage_quota_MAX VARCHAR2(256) NOT NULL,
Resource_quota_MIN VARCHAR2(256) NOT NULL,
Resource_quota_MAX VARCHAR2(256) NOT NULL,
Resource_quota_allocated_MIN VARCHAR2(256) NOT NULL,
Resource_quota_allocated_MAX VARCHAR2(256) NOT NULL,
Storage_quota_MIN VARCHAR2(256) NOT NULL,
Storage_quota_MAX VARCHAR2(256) NOT NULL,
Storage_quota_allocated_MIN VARCHAR2(256) NOT NULL,
Storage_quota_allocated_MAX VARCHAR2(256) NOT NULL,
Deleted_sites_MIN VARCHAR2(256) NOT NULL,
Deleted_sites_MAX VARCHAR2(256) NOT NULL,
Applications_MIN VARCHAR2(256) NOT NULL,
Applications_MAX VARCHAR2(256) NOT NULL,
Web_templates_MIN VARCHAR2(256) NOT NULL,
Web_templates_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOTenantTest_THRESH ADD constraint PK_SPOTenantTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOTenantTest_THRESH ON SPOTenantTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOTenantTest ON SPOTenantTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOTenantTest ON SPOTenantTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOHealthStatusTest CASCADE CONSTRAINTS;
CREATE TABLE SPOHealthStatusTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
SP_health_score Number(20,4) NOT NULL,
SP_health_score_ST varchar2(32) NOT NULL,
SP_request_duration Number(20,4) NOT NULL,
SP_request_duration_ST varchar2(32) NOT NULL,
SP_iis_latency Number(20,4) NOT NULL,
SP_iis_latency_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOHealthStatusTest ON SPOHealthStatusTest(MSMT_TIME);
ALTER TABLE SPOHealthStatusTest ADD constraint PK_SPOHealthStatusTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOHealthStatusTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOHealthStatusTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
SP_health_score_MIN Number(20,4) NOT NULL,
SP_health_score_MAX Number(20,4) NOT NULL,
SP_health_score_STCNT varchar2(32) NOT NULL,
SP_request_duration_MIN Number(20,4) NOT NULL,
SP_request_duration_MAX Number(20,4) NOT NULL,
SP_request_duration_STCNT varchar2(32) NOT NULL,
SP_iis_latency_MIN Number(20,4) NOT NULL,
SP_iis_latency_MAX Number(20,4) NOT NULL,
SP_iis_latency_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOHealthStatusTest_TREND ADD constraint PK_SPOHealthStatusTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOHealthStatusTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOHealthStatusTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
SP_health_score_MIN VARCHAR2(256) NOT NULL,
SP_health_score_MAX VARCHAR2(256) NOT NULL,
SP_request_duration_MIN VARCHAR2(256) NOT NULL,
SP_request_duration_MAX VARCHAR2(256) NOT NULL,
SP_iis_latency_MIN VARCHAR2(256) NOT NULL,
SP_iis_latency_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOHealthStatusTest_THRESH ADD constraint PK_SPOHealthStatusTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOHealthStatusTest_THRESH ON SPOHealthStatusTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOHealthStatusTest ON SPOHealthStatusTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOHealthStatusTest ON SPOHealthStatusTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOMsgCommTest CASCADE CONSTRAINTS;
CREATE TABLE SPOMsgCommTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOMsgCommTest ON SPOMsgCommTest(MSMT_TIME);
ALTER TABLE SPOMsgCommTest ADD constraint PK_SPOMsgCommTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOMsgCommTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOMsgCommTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOMsgCommTest_TREND ADD constraint PK_SPOMsgCommTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOMsgCommTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOMsgCommTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
MsgCenterCommunication_MIN VARCHAR2(256) NOT NULL,
MsgCenterCommunication_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOMsgCommTest_THRESH ADD constraint PK_SPOMsgCommTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOMsgCommTest_THRESH ON SPOMsgCommTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOMsgCommTest ON SPOMsgCommTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOMsgCommTest ON SPOMsgCommTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SPOSiteTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Status Number(20,4) NOT NULL,
Status_ST varchar2(32) NOT NULL,
Webs_count Number(20,4) NOT NULL,
Webs_count_ST varchar2(32) NOT NULL,
Storage_quota Number(20,4) NOT NULL,
Storage_quota_ST varchar2(32) NOT NULL,
Current_storage_usage Number(20,4) NOT NULL,
Current_storage_usage_ST varchar2(32) NOT NULL,
storage_usage_percent Number(20,4) NOT NULL,
storage_usage_percent_ST varchar2(32) NOT NULL,
Current_resource_usage Number(20,4) NOT NULL,
Current_resource_usage_ST varchar2(32) NOT NULL,
Average_resource_usage Number(20,4) NOT NULL,
Average_resource_usage_ST varchar2(32) NOT NULL,
Resource_quota Number(20,4) NOT NULL,
Resource_quota_ST varchar2(32) NOT NULL,
RsQuotaWarningLevel Number(20,4) NOT NULL,
RsQuotaWarningLevel_ST varchar2(32) NOT NULL,
Locked Number(20,4) NOT NULL,
Locked_ST varchar2(32) NOT NULL,
LastContentModifiedDate Number(20,4) NOT NULL,
LastContentModifiedDate_ST varchar2(32) NOT NULL,
External_users Number(20,4) NOT NULL,
External_users_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSiteTest ON SPOSiteTest(MSMT_TIME);
ALTER TABLE SPOSiteTest ADD constraint PK_SPOSiteTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSiteTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Status_MIN Number(20,4) NOT NULL,
Status_MAX Number(20,4) NOT NULL,
Status_STCNT varchar2(32) NOT NULL,
Webs_count_MIN Number(20,4) NOT NULL,
Webs_count_MAX Number(20,4) NOT NULL,
Webs_count_STCNT varchar2(32) NOT NULL,
Storage_quota_MIN Number(20,4) NOT NULL,
Storage_quota_MAX Number(20,4) NOT NULL,
Storage_quota_STCNT varchar2(32) NOT NULL,
Current_storage_usage_MIN Number(20,4) NOT NULL,
Current_storage_usage_MAX Number(20,4) NOT NULL,
Current_storage_usage_STCNT varchar2(32) NOT NULL,
storage_usage_percent_MIN Number(20,4) NOT NULL,
storage_usage_percent_MAX Number(20,4) NOT NULL,
storage_usage_percent_STCNT varchar2(32) NOT NULL,
Current_resource_usage_MIN Number(20,4) NOT NULL,
Current_resource_usage_MAX Number(20,4) NOT NULL,
Current_resource_usage_STCNT varchar2(32) NOT NULL,
Average_resource_usage_MIN Number(20,4) NOT NULL,
Average_resource_usage_MAX Number(20,4) NOT NULL,
Average_resource_usage_STCNT varchar2(32) NOT NULL,
Resource_quota_MIN Number(20,4) NOT NULL,
Resource_quota_MAX Number(20,4) NOT NULL,
Resource_quota_STCNT varchar2(32) NOT NULL,
RsQuotaWarningLevel_MIN Number(20,4) NOT NULL,
RsQuotaWarningLevel_MAX Number(20,4) NOT NULL,
RsQuotaWarningLevel_STCNT varchar2(32) NOT NULL,
Locked_MIN Number(20,4) NOT NULL,
Locked_MAX Number(20,4) NOT NULL,
Locked_STCNT varchar2(32) NOT NULL,
LastContentModifiedDate_MIN Number(20,4) NOT NULL,
LastContentModifiedDate_MAX Number(20,4) NOT NULL,
LastContentModifiedDate_STCNT varchar2(32) NOT NULL,
External_users_MIN Number(20,4) NOT NULL,
External_users_MAX Number(20,4) NOT NULL,
External_users_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSiteTest_TREND ADD constraint PK_SPOSiteTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSiteTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Status_MIN VARCHAR2(256) NOT NULL,
Status_MAX VARCHAR2(256) NOT NULL,
Webs_count_MIN VARCHAR2(256) NOT NULL,
Webs_count_MAX VARCHAR2(256) NOT NULL,
Storage_quota_MIN VARCHAR2(256) NOT NULL,
Storage_quota_MAX VARCHAR2(256) NOT NULL,
Current_storage_usage_MIN VARCHAR2(256) NOT NULL,
Current_storage_usage_MAX VARCHAR2(256) NOT NULL,
storage_usage_percent_MIN VARCHAR2(256) NOT NULL,
storage_usage_percent_MAX VARCHAR2(256) NOT NULL,
Current_resource_usage_MIN VARCHAR2(256) NOT NULL,
Current_resource_usage_MAX VARCHAR2(256) NOT NULL,
Average_resource_usage_MIN VARCHAR2(256) NOT NULL,
Average_resource_usage_MAX VARCHAR2(256) NOT NULL,
Resource_quota_MIN VARCHAR2(256) NOT NULL,
Resource_quota_MAX VARCHAR2(256) NOT NULL,
RsQuotaWarningLevel_MIN VARCHAR2(256) NOT NULL,
RsQuotaWarningLevel_MAX VARCHAR2(256) NOT NULL,
Locked_MIN VARCHAR2(256) NOT NULL,
Locked_MAX VARCHAR2(256) NOT NULL,
LastContentModifiedDate_MIN VARCHAR2(256) NOT NULL,
LastContentModifiedDate_MAX VARCHAR2(256) NOT NULL,
External_users_MIN VARCHAR2(256) NOT NULL,
External_users_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOSiteTest_THRESH ADD constraint PK_SPOSiteTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSiteTest_THRESH ON SPOSiteTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSiteTest ON SPOSiteTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSiteTest ON SPOSiteTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOLoginTest CASCADE CONSTRAINTS;
CREATE TABLE SPOLoginTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Authentication_status Number(20,4) NOT NULL,
Authentication_status_ST varchar2(32) NOT NULL,
Authentication_time Number(20,4) NOT NULL,
Authentication_time_ST varchar2(32) NOT NULL,
Login_status Number(20,4) NOT NULL,
Login_status_ST varchar2(32) NOT NULL,
Login_time Number(20,4) NOT NULL,
Login_time_ST varchar2(32) NOT NULL,
Total_login_time Number(20,4) NOT NULL,
Total_login_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOLoginTest ON SPOLoginTest(MSMT_TIME);
ALTER TABLE SPOLoginTest ADD constraint PK_SPOLoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOLoginTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOLoginTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Authentication_status_MIN Number(20,4) NOT NULL,
Authentication_status_MAX Number(20,4) NOT NULL,
Authentication_status_STCNT varchar2(32) NOT NULL,
Authentication_time_MIN Number(20,4) NOT NULL,
Authentication_time_MAX Number(20,4) NOT NULL,
Authentication_time_STCNT varchar2(32) NOT NULL,
Login_status_MIN Number(20,4) NOT NULL,
Login_status_MAX Number(20,4) NOT NULL,
Login_status_STCNT varchar2(32) NOT NULL,
Login_time_MIN Number(20,4) NOT NULL,
Login_time_MAX Number(20,4) NOT NULL,
Login_time_STCNT varchar2(32) NOT NULL,
Total_login_time_MIN Number(20,4) NOT NULL,
Total_login_time_MAX Number(20,4) NOT NULL,
Total_login_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOLoginTest_TREND ADD constraint PK_SPOLoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOLoginTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOLoginTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Authentication_status_MIN VARCHAR2(256) NOT NULL,
Authentication_status_MAX VARCHAR2(256) NOT NULL,
Authentication_time_MIN VARCHAR2(256) NOT NULL,
Authentication_time_MAX VARCHAR2(256) NOT NULL,
Login_status_MIN VARCHAR2(256) NOT NULL,
Login_status_MAX VARCHAR2(256) NOT NULL,
Login_time_MIN VARCHAR2(256) NOT NULL,
Login_time_MAX VARCHAR2(256) NOT NULL,
Total_login_time_MIN VARCHAR2(256) NOT NULL,
Total_login_time_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOLoginTest_THRESH ADD constraint PK_SPOLoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOLoginTest_THRESH ON SPOLoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOLoginTest ON SPOLoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOLoginTest ON SPOLoginTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SPOSiteHealthCheckTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteHealthCheckTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Passed Number(20,4) NOT NULL,
Passed_ST varchar2(32) NOT NULL,
Failed_warnings Number(20,4) NOT NULL,
Failed_warnings_ST varchar2(32) NOT NULL,
Failed_errors Number(20,4) NOT NULL,
Failed_errors_ST varchar2(32) NOT NULL,
External_users Number(20,4) NOT NULL,
External_users_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_SPOSiteHealthCheckTest ON SPOSiteHealthCheckTest(MSMT_TIME);
ALTER TABLE SPOSiteHealthCheckTest ADD constraint PK_SPOSiteHealthCheckTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSiteHealthCheckTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteHealthCheckTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Passed_MIN Number(20,4) NOT NULL,
Passed_MAX Number(20,4) NOT NULL,
Passed_STCNT varchar2(32) NOT NULL,
Failed_warnings_MIN Number(20,4) NOT NULL,
Failed_warnings_MAX Number(20,4) NOT NULL,
Failed_warnings_STCNT varchar2(32) NOT NULL,
Failed_errors_MIN Number(20,4) NOT NULL,
Failed_errors_MAX Number(20,4) NOT NULL,
Failed_errors_STCNT varchar2(32) NOT NULL,
External_users_MIN Number(20,4) NOT NULL,
External_users_MAX Number(20,4) NOT NULL,
External_users_STCNT varchar2(32) NOT NULL);
ALTER TABLE SPOSiteHealthCheckTest_TREND ADD constraint PK_SPOSitHlthChckTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSiteHealthCheckTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSiteHealthCheckTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Passed_MIN VARCHAR2(256) NOT NULL,
Passed_MAX VARCHAR2(256) NOT NULL,
Failed_warnings_MIN VARCHAR2(256) NOT NULL,
Failed_warnings_MAX VARCHAR2(256) NOT NULL,
Failed_errors_MIN VARCHAR2(256) NOT NULL,
Failed_errors_MAX VARCHAR2(256) NOT NULL,
External_users_MIN VARCHAR2(256) NOT NULL,
External_users_MAX VARCHAR2(256) NOT NULL);
ALTER TABLE SPOSiteHealthCheckTest_THRESH ADD constraint PK_SPOSitHlthChckTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSitHlthChkTest_THRESH ON SPOSiteHealthCheckTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSiteHealthCheckTest ON SPOSiteHealthCheckTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSiteHealthCheckTest ON SPOSiteHealthCheckTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SPOSyncActTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSyncActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
File_sync_permits Number(20,4) NOT NULL,
File_sync_permits_ST varchar2(32) NOT NULL,
File_sync_blocks Number(20,4) NOT NULL,
File_sync_blocks_ST varchar2(32) NOT NULL,
File_downloads Number(20,4) NOT NULL,
File_downloads_ST varchar2(32) NOT NULL,
File_changes_downloads Number(20,4) NOT NULL,
File_changes_downloads_ST varchar2(32) NOT NULL,
File_uploads Number(20,4) NOT NULL,
File_uploads_ST varchar2(32) NOT NULL,
File_changes_uploads Number(20,4) NOT NULL,
File_changes_uploads_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSyncActTest ON SPOSyncActTest(MSMT_TIME);
ALTER TABLE SPOSyncActTest ADD constraint PK_SPOSyncActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSyncActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSyncActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
File_sync_permits_MIN Number(20,4) NOT NULL,
File_sync_permits_MAX Number(20,4) NOT NULL,
File_sync_permits_STCNT varchar2(32) NOT NULL,
File_sync_blocks_MIN Number(20,4) NOT NULL,
File_sync_blocks_MAX Number(20,4) NOT NULL,
File_sync_blocks_STCNT varchar2(32) NOT NULL,
File_downloads_MIN Number(20,4) NOT NULL,
File_downloads_MAX Number(20,4) NOT NULL,
File_downloads_STCNT varchar2(32) NOT NULL,
File_changes_downloads_MIN Number(20,4) NOT NULL,
File_changes_downloads_MAX Number(20,4) NOT NULL,
File_changes_downloads_STCNT varchar2(32) NOT NULL,
File_uploads_MIN Number(20,4) NOT NULL,
File_uploads_MAX Number(20,4) NOT NULL,
File_uploads_STCNT varchar2(32) NOT NULL,
File_changes_uploads_MIN Number(20,4) NOT NULL,
File_changes_uploads_MAX Number(20,4) NOT NULL,
File_changes_uploads_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSyncActTest_TREND ADD constraint PK_SPOSyncActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSyncActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSyncActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
File_sync_permits_MIN VARCHAR2(256) NOT NULL,
File_sync_permits_MAX VARCHAR2(256) NOT NULL,
File_sync_blocks_MIN VARCHAR2(256) NOT NULL,
File_sync_blocks_MAX VARCHAR2(256) NOT NULL,
File_downloads_MIN VARCHAR2(256) NOT NULL,
File_downloads_MAX VARCHAR2(256) NOT NULL,
File_changes_downloads_MIN VARCHAR2(256) NOT NULL,
File_changes_downloads_MAX VARCHAR2(256) NOT NULL,
File_uploads_MIN VARCHAR2(256) NOT NULL,
File_uploads_MAX VARCHAR2(256) NOT NULL,
File_changes_uploads_MIN VARCHAR2(256) NOT NULL,
File_changes_uploads_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOSyncActTest_THRESH ADD constraint PK_SPOSyncActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSyncActTest_THRESH ON SPOSyncActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSyncActTest ON SPOSyncActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSyncActTest ON SPOSyncActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOSAdminActTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSAdminActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Usr_agent_exmpt_addition Number(20,4) NOT NULL,
Usr_agent_exmpt_addition_ST varchar2(32) NOT NULL,
Usr_agent_exmpt_modifitn Number(20,4) NOT NULL,
Usr_agent_exmpt_modifitn_ST varchar2(32) NOT NULL,
Sit_collectn_admin_addtn Number(20,4) NOT NULL,
Sit_collectn_admin_addtn_ST varchar2(32) NOT NULL,
User_group_additions Number(20,4) NOT NULL,
User_group_additions_ST varchar2(32) NOT NULL,
Add_usergroup_permits Number(20,4) NOT NULL,
Add_usergroup_permits_ST varchar2(32) NOT NULL,
Sharing_policy_modifctn Number(20,4) NOT NULL,
Sharing_policy_modifctn_ST varchar2(32) NOT NULL,
Group_additions Number(20,4) NOT NULL,
Group_additions_ST varchar2(32) NOT NULL,
Send_to_conn_creation Number(20,4) NOT NULL,
Send_to_conn_creation_ST varchar2(32) NOT NULL,
Site_collection_creation Number(20,4) NOT NULL,
Site_collection_creation_ST varchar2(32) NOT NULL,
Group_deletes Number(20,4) NOT NULL,
Group_deletes_ST varchar2(32) NOT NULL,
Send_to_conn_deletes Number(20,4) NOT NULL,
Send_to_conn_deletes_ST varchar2(32) NOT NULL,
Site_deletes Number(20,4) NOT NULL,
Site_deletes_ST varchar2(32) NOT NULL,
Document_preview_permits Number(20,4) NOT NULL,
Document_preview_permits_ST varchar2(32) NOT NULL,
Workflow_task_contnt Number(20,4) NOT NULL,
Workflow_task_contnt_ST varchar2(32) NOT NULL,
Office_ondemand_permits Number(20,4) NOT NULL,
Office_ondemand_permits_ST varchar2(32) NOT NULL,
News_feed_permits Number(20,4) NOT NULL,
News_feed_permits_ST varchar2(32) NOT NULL,
Site_permissn_modifictn Number(20,4) NOT NULL,
Site_permissn_modifictn_ST varchar2(32) NOT NULL,
Removals_from_group Number(20,4) NOT NULL,
Removals_from_group_ST varchar2(32) NOT NULL,
Site_renames Number(20,4) NOT NULL,
Site_renames_ST varchar2(32) NOT NULL,
Site_admin_requests Number(20,4) NOT NULL,
Site_admin_requests_ST varchar2(32) NOT NULL,
Host_site_changes Number(20,4) NOT NULL,
Host_site_changes_ST varchar2(32) NOT NULL,
Group_settings_changes Number(20,4) NOT NULL,
Group_settings_changes_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSAdminActTest ON SPOSAdminActTest(MSMT_TIME);
ALTER TABLE SPOSAdminActTest ADD constraint PK_SPOSAdminActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSAdminActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSAdminActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Usr_agent_exmpt_addition_MIN Number(20,4) NOT NULL,
Usr_agent_exmpt_addition_MAX Number(20,4) NOT NULL,
Usr_agent_exmpt_addition_STCNT varchar2(32) NOT NULL,
Usr_agent_exmpt_modifitn_MIN Number(20,4) NOT NULL,
Usr_agent_exmpt_modifitn_MAX Number(20,4) NOT NULL,
Usr_agent_exmpt_modifitn_STCNT varchar2(32) NOT NULL,
Sit_collectn_admin_addtn_MIN Number(20,4) NOT NULL,
Sit_collectn_admin_addtn_MAX Number(20,4) NOT NULL,
Sit_collectn_admin_addtn_STCNT varchar2(32) NOT NULL,
User_group_additions_MIN Number(20,4) NOT NULL,
User_group_additions_MAX Number(20,4) NOT NULL,
User_group_additions_STCNT varchar2(32) NOT NULL,
Add_usergroup_permits_MIN Number(20,4) NOT NULL,
Add_usergroup_permits_MAX Number(20,4) NOT NULL,
Add_usergroup_permits_STCNT varchar2(32) NOT NULL,
Sharing_policy_modifctn_MIN Number(20,4) NOT NULL,
Sharing_policy_modifctn_MAX Number(20,4) NOT NULL,
Sharing_policy_modifctn_STCNT varchar2(32) NOT NULL,
Group_additions_MIN Number(20,4) NOT NULL,
Group_additions_MAX Number(20,4) NOT NULL,
Group_additions_STCNT varchar2(32) NOT NULL,
Send_to_conn_creation_MIN Number(20,4) NOT NULL,
Send_to_conn_creation_MAX Number(20,4) NOT NULL,
Send_to_conn_creation_STCNT varchar2(32) NOT NULL,
Site_collection_creation_MIN Number(20,4) NOT NULL,
Site_collection_creation_MAX Number(20,4) NOT NULL,
Site_collection_creation_STCNT varchar2(32) NOT NULL,
Group_deletes_MIN Number(20,4) NOT NULL,
Group_deletes_MAX Number(20,4) NOT NULL,
Group_deletes_STCNT varchar2(32) NOT NULL,
Send_to_conn_deletes_MIN Number(20,4) NOT NULL,
Send_to_conn_deletes_MAX Number(20,4) NOT NULL,
Send_to_conn_deletes_STCNT varchar2(32) NOT NULL,
Site_deletes_MIN Number(20,4) NOT NULL,
Site_deletes_MAX Number(20,4) NOT NULL,
Site_deletes_STCNT varchar2(32) NOT NULL,
Document_preview_permits_MIN Number(20,4) NOT NULL,
Document_preview_permits_MAX Number(20,4) NOT NULL,
Document_preview_permits_STCNT varchar2(32) NOT NULL,
Workflow_task_contnt_MIN Number(20,4) NOT NULL,
Workflow_task_contnt_MAX Number(20,4) NOT NULL,
Workflow_task_contnt_STCNT varchar2(32) NOT NULL,
Office_ondemand_permits_MIN Number(20,4) NOT NULL,
Office_ondemand_permits_MAX Number(20,4) NOT NULL,
Office_ondemand_permits_STCNT varchar2(32) NOT NULL,
News_feed_permits_MIN Number(20,4) NOT NULL,
News_feed_permits_MAX Number(20,4) NOT NULL,
News_feed_permits_STCNT varchar2(32) NOT NULL,
Site_permissn_modifictn_MIN Number(20,4) NOT NULL,
Site_permissn_modifictn_MAX Number(20,4) NOT NULL,
Site_permissn_modifictn_STCNT varchar2(32) NOT NULL,
Removals_from_group_MIN Number(20,4) NOT NULL,
Removals_from_group_MAX Number(20,4) NOT NULL,
Removals_from_group_STCNT varchar2(32) NOT NULL,
Site_renames_MIN Number(20,4) NOT NULL,
Site_renames_MAX Number(20,4) NOT NULL,
Site_renames_STCNT varchar2(32) NOT NULL,
Site_admin_requests_MIN Number(20,4) NOT NULL,
Site_admin_requests_MAX Number(20,4) NOT NULL,
Site_admin_requests_STCNT varchar2(32) NOT NULL,
Host_site_changes_MIN Number(20,4) NOT NULL,
Host_site_changes_MAX Number(20,4) NOT NULL,
Host_site_changes_STCNT varchar2(32) NOT NULL,
Group_settings_changes_MIN Number(20,4) NOT NULL,
Group_settings_changes_MAX Number(20,4) NOT NULL,
Group_settings_changes_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSAdminActTest_TREND ADD constraint PK_SPOSAdminActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSAdminActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSAdminActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_addition_MIN VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_addition_MAX VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_modifitn_MIN VARCHAR2(256) NOT NULL,
Usr_agent_exmpt_modifitn_MAX VARCHAR2(256) NOT NULL,
Sit_collectn_admin_addtn_MIN VARCHAR2(256) NOT NULL,
Sit_collectn_admin_addtn_MAX VARCHAR2(256) NOT NULL,
User_group_additions_MIN VARCHAR2(256) NOT NULL,
User_group_additions_MAX VARCHAR2(256) NOT NULL,
Add_usergroup_permits_MIN VARCHAR2(256) NOT NULL,
Add_usergroup_permits_MAX VARCHAR2(256) NOT NULL,
Sharing_policy_modifctn_MIN VARCHAR2(256) NOT NULL,
Sharing_policy_modifctn_MAX VARCHAR2(256) NOT NULL,
Group_additions_MIN VARCHAR2(256) NOT NULL,
Group_additions_MAX VARCHAR2(256) NOT NULL,
Send_to_conn_creation_MIN VARCHAR2(256) NOT NULL,
Send_to_conn_creation_MAX VARCHAR2(256) NOT NULL,
Site_collection_creation_MIN VARCHAR2(256) NOT NULL,
Site_collection_creation_MAX VARCHAR2(256) NOT NULL,
Group_deletes_MIN VARCHAR2(256) NOT NULL,
Group_deletes_MAX VARCHAR2(256) NOT NULL,
Send_to_conn_deletes_MIN VARCHAR2(256) NOT NULL,
Send_to_conn_deletes_MAX VARCHAR2(256) NOT NULL,
Site_deletes_MIN VARCHAR2(256) NOT NULL,
Site_deletes_MAX VARCHAR2(256) NOT NULL,
Document_preview_permits_MIN VARCHAR2(256) NOT NULL,
Document_preview_permits_MAX VARCHAR2(256) NOT NULL,
Workflow_task_contnt_MIN VARCHAR2(256) NOT NULL,
Workflow_task_contnt_MAX VARCHAR2(256) NOT NULL,
Office_ondemand_permits_MIN VARCHAR2(256) NOT NULL,
Office_ondemand_permits_MAX VARCHAR2(256) NOT NULL,
News_feed_permits_MIN VARCHAR2(256) NOT NULL,
News_feed_permits_MAX VARCHAR2(256) NOT NULL,
Site_permissn_modifictn_MIN VARCHAR2(256) NOT NULL,
Site_permissn_modifictn_MAX VARCHAR2(256) NOT NULL,
Removals_from_group_MIN VARCHAR2(256) NOT NULL,
Removals_from_group_MAX VARCHAR2(256) NOT NULL,
Site_renames_MIN VARCHAR2(256) NOT NULL,
Site_renames_MAX VARCHAR2(256) NOT NULL,
Site_admin_requests_MIN VARCHAR2(256) NOT NULL,
Site_admin_requests_MAX VARCHAR2(256) NOT NULL,
Host_site_changes_MIN VARCHAR2(256) NOT NULL,
Host_site_changes_MAX VARCHAR2(256) NOT NULL,
Group_settings_changes_MIN VARCHAR2(256) NOT NULL,
Group_settings_changes_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOSAdminActTest_THRESH ADD constraint PK_SPOSAdminActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSAdminActTest_THRESH ON SPOSAdminActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSAdminActTest ON SPOSAdminActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSAdminActTest ON SPOSAdminActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOFolderActTest CASCADE CONSTRAINTS;
CREATE TABLE SPOFolderActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Folder_copies Number(20,4) NOT NULL,
Folder_copies_ST varchar2(32) NOT NULL,
Folder_creations Number(20,4) NOT NULL,
Folder_creations_ST varchar2(32) NOT NULL,
Folder_deletions Number(20,4) NOT NULL,
Folder_deletions_ST varchar2(32) NOT NULL,
Folder_deletions_I_bin Number(20,4) NOT NULL,
Folder_deletions_I_bin_ST varchar2(32) NOT NULL,
Folder_deletions_II_bin Number(20,4) NOT NULL,
Folder_deletions_II_bin_ST varchar2(32) NOT NULL,
Folder_modifications Number(20,4) NOT NULL,
Folder_modifications_ST varchar2(32) NOT NULL,
Folder_moves Number(20,4) NOT NULL,
Folder_moves_ST varchar2(32) NOT NULL,
Folder_renames Number(20,4) NOT NULL,
Folder_renames_ST varchar2(32) NOT NULL,
Folder_restores Number(20,4) NOT NULL,
Folder_restores_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOFolderActTest ON SPOFolderActTest(MSMT_TIME);
ALTER TABLE SPOFolderActTest ADD constraint PK_SPOFolderActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOFolderActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOFolderActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Folder_copies_MIN Number(20,4) NOT NULL,
Folder_copies_MAX Number(20,4) NOT NULL,
Folder_copies_STCNT varchar2(32) NOT NULL,
Folder_creations_MIN Number(20,4) NOT NULL,
Folder_creations_MAX Number(20,4) NOT NULL,
Folder_creations_STCNT varchar2(32) NOT NULL,
Folder_deletions_MIN Number(20,4) NOT NULL,
Folder_deletions_MAX Number(20,4) NOT NULL,
Folder_deletions_STCNT varchar2(32) NOT NULL,
Folder_deletions_I_bin_MIN Number(20,4) NOT NULL,
Folder_deletions_I_bin_MAX Number(20,4) NOT NULL,
Folder_deletions_I_bin_STCNT varchar2(32) NOT NULL,
Folder_deletions_II_bin_MIN Number(20,4) NOT NULL,
Folder_deletions_II_bin_MAX Number(20,4) NOT NULL,
Folder_deletions_II_bin_STCNT varchar2(32) NOT NULL,
Folder_modifications_MIN Number(20,4) NOT NULL,
Folder_modifications_MAX Number(20,4) NOT NULL,
Folder_modifications_STCNT varchar2(32) NOT NULL,
Folder_moves_MIN Number(20,4) NOT NULL,
Folder_moves_MAX Number(20,4) NOT NULL,
Folder_moves_STCNT varchar2(32) NOT NULL,
Folder_renames_MIN Number(20,4) NOT NULL,
Folder_renames_MAX Number(20,4) NOT NULL,
Folder_renames_STCNT varchar2(32) NOT NULL,
Folder_restores_MIN Number(20,4) NOT NULL,
Folder_restores_MAX Number(20,4) NOT NULL,
Folder_restores_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOFolderActTest_TREND ADD constraint PK_SPOFolderActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOFolderActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOFolderActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
Folder_copies_MIN VARCHAR2(256) NOT NULL,
Folder_copies_MAX VARCHAR2(256) NOT NULL,
Folder_creations_MIN VARCHAR2(256) NOT NULL,
Folder_creations_MAX VARCHAR2(256) NOT NULL,
Folder_deletions_MIN VARCHAR2(256) NOT NULL,
Folder_deletions_MAX VARCHAR2(256) NOT NULL,
Folder_deletions_I_bin_MIN VARCHAR2(256) NOT NULL,
Folder_deletions_I_bin_MAX VARCHAR2(256) NOT NULL,
Folder_deletions_II_bin_MIN VARCHAR2(256) NOT NULL,
Folder_deletions_II_bin_MAX VARCHAR2(256) NOT NULL,
Folder_modifications_MIN VARCHAR2(256) NOT NULL,
Folder_modifications_MAX VARCHAR2(256) NOT NULL,
Folder_moves_MIN VARCHAR2(256) NOT NULL,
Folder_moves_MAX VARCHAR2(256) NOT NULL,
Folder_renames_MIN VARCHAR2(256) NOT NULL,
Folder_renames_MAX VARCHAR2(256) NOT NULL,
Folder_restores_MIN VARCHAR2(256) NOT NULL,
Folder_restores_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOFolderActTest_THRESH ADD constraint PK_SPOFolderActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOFolderActTest_THRESH ON SPOFolderActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOFolderActTest ON SPOFolderActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOFolderActTest ON SPOFolderActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOSharngActTest CASCADE CONSTRAINTS;
CREATE TABLE SPOSharngActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Access_req_acceptance Number(20,4) NOT NULL,
Access_req_acceptance_ST varchar2(32) NOT NULL,
Sharng_invitatn_acceptnc Number(20,4) NOT NULL,
Sharng_invitatn_acceptnc_ST varchar2(32) NOT NULL,
Sharng_invitatn_blocked Number(20,4) NOT NULL,
Sharng_invitatn_blocked_ST varchar2(32) NOT NULL,
Company_link_creations Number(20,4) NOT NULL,
Company_link_creations_ST varchar2(32) NOT NULL,
Access_request_creations Number(20,4) NOT NULL,
Access_request_creations_ST varchar2(32) NOT NULL,
Anonymous_link_creations Number(20,4) NOT NULL,
Anonymous_link_creations_ST varchar2(32) NOT NULL,
Sharng_invitatn_creation Number(20,4) NOT NULL,
Sharng_invitatn_creation_ST varchar2(32) NOT NULL,
Access_request_denials Number(20,4) NOT NULL,
Access_request_denials_ST varchar2(32) NOT NULL,
Company_link_removals Number(20,4) NOT NULL,
Company_link_removals_ST varchar2(32) NOT NULL,
Anonymous_link_removals Number(20,4) NOT NULL,
Anonymous_link_removals_ST varchar2(32) NOT NULL,
File_Folder_Site_share Number(20,4) NOT NULL,
File_Folder_Site_share_ST varchar2(32) NOT NULL,
Anonymous_link_updates Number(20,4) NOT NULL,
Anonymous_link_updates_ST varchar2(32) NOT NULL,
Anonymous_link_usage Number(20,4) NOT NULL,
Anonymous_link_usage_ST varchar2(32) NOT NULL,
Sharing_revokes Number(20,4) NOT NULL,
Sharing_revokes_ST varchar2(32) NOT NULL,
Company_link_usage Number(20,4) NOT NULL,
Company_link_usage_ST varchar2(32) NOT NULL,
Sharng_invitatn_withdrw Number(20,4) NOT NULL,
Sharng_invitatn_withdrw_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOSharngActTest ON SPOSharngActTest(MSMT_TIME);
ALTER TABLE SPOSharngActTest ADD constraint PK_SPOSharngActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOSharngActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOSharngActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Access_req_acceptance_MIN Number(20,4) NOT NULL,
Access_req_acceptance_MAX Number(20,4) NOT NULL,
Access_req_acceptance_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_acceptnc_MIN Number(20,4) NOT NULL,
Sharng_invitatn_acceptnc_MAX Number(20,4) NOT NULL,
Sharng_invitatn_acceptnc_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_blocked_MIN Number(20,4) NOT NULL,
Sharng_invitatn_blocked_MAX Number(20,4) NOT NULL,
Sharng_invitatn_blocked_STCNT varchar2(32) NOT NULL,
Company_link_creations_MIN Number(20,4) NOT NULL,
Company_link_creations_MAX Number(20,4) NOT NULL,
Company_link_creations_STCNT varchar2(32) NOT NULL,
Access_request_creations_MIN Number(20,4) NOT NULL,
Access_request_creations_MAX Number(20,4) NOT NULL,
Access_request_creations_STCNT varchar2(32) NOT NULL,
Anonymous_link_creations_MIN Number(20,4) NOT NULL,
Anonymous_link_creations_MAX Number(20,4) NOT NULL,
Anonymous_link_creations_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_creation_MIN Number(20,4) NOT NULL,
Sharng_invitatn_creation_MAX Number(20,4) NOT NULL,
Sharng_invitatn_creation_STCNT varchar2(32) NOT NULL,
Access_request_denials_MIN Number(20,4) NOT NULL,
Access_request_denials_MAX Number(20,4) NOT NULL,
Access_request_denials_STCNT varchar2(32) NOT NULL,
Company_link_removals_MIN Number(20,4) NOT NULL,
Company_link_removals_MAX Number(20,4) NOT NULL,
Company_link_removals_STCNT varchar2(32) NOT NULL,
Anonymous_link_removals_MIN Number(20,4) NOT NULL,
Anonymous_link_removals_MAX Number(20,4) NOT NULL,
Anonymous_link_removals_STCNT varchar2(32) NOT NULL,
File_Folder_Site_share_MIN Number(20,4) NOT NULL,
File_Folder_Site_share_MAX Number(20,4) NOT NULL,
File_Folder_Site_share_STCNT varchar2(32) NOT NULL,
Anonymous_link_updates_MIN Number(20,4) NOT NULL,
Anonymous_link_updates_MAX Number(20,4) NOT NULL,
Anonymous_link_updates_STCNT varchar2(32) NOT NULL,
Anonymous_link_usage_MIN Number(20,4) NOT NULL,
Anonymous_link_usage_MAX Number(20,4) NOT NULL,
Anonymous_link_usage_STCNT varchar2(32) NOT NULL,
Sharing_revokes_MIN Number(20,4) NOT NULL,
Sharing_revokes_MAX Number(20,4) NOT NULL,
Sharing_revokes_STCNT varchar2(32) NOT NULL,
Company_link_usage_MIN Number(20,4) NOT NULL,
Company_link_usage_MAX Number(20,4) NOT NULL,
Company_link_usage_STCNT varchar2(32) NOT NULL,
Sharng_invitatn_withdrw_MIN Number(20,4) NOT NULL,
Sharng_invitatn_withdrw_MAX Number(20,4) NOT NULL,
Sharng_invitatn_withdrw_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOSharngActTest_TREND ADD constraint PK_SPOSharngActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOSharngActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOSharngActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
Access_req_acceptance_MIN VARCHAR2(256) NOT NULL,
Access_req_acceptance_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_acceptnc_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_acceptnc_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_blocked_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_blocked_MAX VARCHAR2(256) NOT NULL,
Company_link_creations_MIN VARCHAR2(256) NOT NULL,
Company_link_creations_MAX VARCHAR2(256) NOT NULL,
Access_request_creations_MIN VARCHAR2(256) NOT NULL,
Access_request_creations_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_creations_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_creations_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_creation_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_creation_MAX VARCHAR2(256) NOT NULL,
Access_request_denials_MIN VARCHAR2(256) NOT NULL,
Access_request_denials_MAX VARCHAR2(256) NOT NULL,
Company_link_removals_MIN VARCHAR2(256) NOT NULL,
Company_link_removals_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_removals_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_removals_MAX VARCHAR2(256) NOT NULL,
File_Folder_Site_share_MIN VARCHAR2(256) NOT NULL,
File_Folder_Site_share_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_updates_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_updates_MAX VARCHAR2(256) NOT NULL,
Anonymous_link_usage_MIN VARCHAR2(256) NOT NULL,
Anonymous_link_usage_MAX VARCHAR2(256) NOT NULL,
Sharing_revokes_MIN VARCHAR2(256) NOT NULL,
Sharing_revokes_MAX VARCHAR2(256) NOT NULL,
Company_link_usage_MIN VARCHAR2(256) NOT NULL,
Company_link_usage_MAX VARCHAR2(256) NOT NULL,
Sharng_invitatn_withdrw_MIN VARCHAR2(256) NOT NULL,
Sharng_invitatn_withdrw_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOSharngActTest_THRESH ADD constraint PK_SPOSharngActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOSharngActTest_THRESH ON SPOSharngActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOSharngActTest ON SPOSharngActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOSharngActTest ON SPOSharngActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE SPOFileActTest CASCADE CONSTRAINTS;
CREATE TABLE SPOFileActTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_operations Number(20,4) NOT NULL,
Total_operations_ST varchar2(32) NOT NULL,
Unique_operations Number(20,4) NOT NULL,
Unique_operations_ST varchar2(32) NOT NULL,
Unique_users Number(20,4) NOT NULL,
Unique_users_ST varchar2(32) NOT NULL,
Unique_client_IPs Number(20,4) NOT NULL,
Unique_client_IPs_ST varchar2(32) NOT NULL,
Unique_sites Number(20,4) NOT NULL,
Unique_sites_ST varchar2(32) NOT NULL,
Affected_item_types Number(20,4) NOT NULL,
Affected_item_types_ST varchar2(32) NOT NULL,
Unique_destinations Number(20,4) NOT NULL,
Unique_destinations_ST varchar2(32) NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
File_accesses Number(20,4) NOT NULL,
File_accesses_ST varchar2(32) NOT NULL,
File_check_ins Number(20,4) NOT NULL,
File_check_ins_ST varchar2(32) NOT NULL,
File_checkouts Number(20,4) NOT NULL,
File_checkouts_ST varchar2(32) NOT NULL,
File_copies Number(20,4) NOT NULL,
File_copies_ST varchar2(32) NOT NULL,
File_deletes Number(20,4) NOT NULL,
File_deletes_ST varchar2(32) NOT NULL,
File_deletes_frm_I_stage Number(20,4) NOT NULL,
File_deletes_frm_I_stage_ST varchar2(32) NOT NULL,
File_deletes_frm_II_stag Number(20,4) NOT NULL,
File_deletes_frm_II_stag_ST varchar2(32) NOT NULL,
File_checkout_discards Number(20,4) NOT NULL,
File_checkout_discards_ST varchar2(32) NOT NULL,
File_downloads Number(20,4) NOT NULL,
File_downloads_ST varchar2(32) NOT NULL,
File_modifications Number(20,4) NOT NULL,
File_modifications_ST varchar2(32) NOT NULL,
File_moves Number(20,4) NOT NULL,
File_moves_ST varchar2(32) NOT NULL,
File_renames Number(20,4) NOT NULL,
File_renames_ST varchar2(32) NOT NULL,
File_restores Number(20,4) NOT NULL,
File_restores_ST varchar2(32) NOT NULL,
File_uploads Number(20,4) NOT NULL,
File_uploads_ST varchar2(32) NOT NULL,
Page_views Number(20,4) NOT NULL,
Page_views_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_SPOFileActTest ON SPOFileActTest(MSMT_TIME);
ALTER TABLE SPOFileActTest ADD constraint PK_SPOFileActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE SPOFileActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SPOFileActTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_operations_MIN Number(20,4) NOT NULL,
Total_operations_MAX Number(20,4) NOT NULL,
Total_operations_STCNT varchar2(32) NOT NULL,
Unique_operations_MIN Number(20,4) NOT NULL,
Unique_operations_MAX Number(20,4) NOT NULL,
Unique_operations_STCNT varchar2(32) NOT NULL,
Unique_users_MIN Number(20,4) NOT NULL,
Unique_users_MAX Number(20,4) NOT NULL,
Unique_users_STCNT varchar2(32) NOT NULL,
Unique_client_IPs_MIN Number(20,4) NOT NULL,
Unique_client_IPs_MAX Number(20,4) NOT NULL,
Unique_client_IPs_STCNT varchar2(32) NOT NULL,
Unique_sites_MIN Number(20,4) NOT NULL,
Unique_sites_MAX Number(20,4) NOT NULL,
Unique_sites_STCNT varchar2(32) NOT NULL,
Affected_item_types_MIN Number(20,4) NOT NULL,
Affected_item_types_MAX Number(20,4) NOT NULL,
Affected_item_types_STCNT varchar2(32) NOT NULL,
Unique_destinations_MIN Number(20,4) NOT NULL,
Unique_destinations_MAX Number(20,4) NOT NULL,
Unique_destinations_STCNT varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
File_accesses_MIN Number(20,4) NOT NULL,
File_accesses_MAX Number(20,4) NOT NULL,
File_accesses_STCNT varchar2(32) NOT NULL,
File_check_ins_MIN Number(20,4) NOT NULL,
File_check_ins_MAX Number(20,4) NOT NULL,
File_check_ins_STCNT varchar2(32) NOT NULL,
File_checkouts_MIN Number(20,4) NOT NULL,
File_checkouts_MAX Number(20,4) NOT NULL,
File_checkouts_STCNT varchar2(32) NOT NULL,
File_copies_MIN Number(20,4) NOT NULL,
File_copies_MAX Number(20,4) NOT NULL,
File_copies_STCNT varchar2(32) NOT NULL,
File_deletes_MIN Number(20,4) NOT NULL,
File_deletes_MAX Number(20,4) NOT NULL,
File_deletes_STCNT varchar2(32) NOT NULL,
File_deletes_frm_I_stage_MIN Number(20,4) NOT NULL,
File_deletes_frm_I_stage_MAX Number(20,4) NOT NULL,
File_deletes_frm_I_stage_STCNT varchar2(32) NOT NULL,
File_deletes_frm_II_stag_MIN Number(20,4) NOT NULL,
File_deletes_frm_II_stag_MAX Number(20,4) NOT NULL,
File_deletes_frm_II_stag_STCNT varchar2(32) NOT NULL,
File_checkout_discards_MIN Number(20,4) NOT NULL,
File_checkout_discards_MAX Number(20,4) NOT NULL,
File_checkout_discards_STCNT varchar2(32) NOT NULL,
File_downloads_MIN Number(20,4) NOT NULL,
File_downloads_MAX Number(20,4) NOT NULL,
File_downloads_STCNT varchar2(32) NOT NULL,
File_modifications_MIN Number(20,4) NOT NULL,
File_modifications_MAX Number(20,4) NOT NULL,
File_modifications_STCNT varchar2(32) NOT NULL,
File_moves_MIN Number(20,4) NOT NULL,
File_moves_MAX Number(20,4) NOT NULL,
File_moves_STCNT varchar2(32) NOT NULL,
File_renames_MIN Number(20,4) NOT NULL,
File_renames_MAX Number(20,4) NOT NULL,
File_renames_STCNT varchar2(32) NOT NULL,
File_restores_MIN Number(20,4) NOT NULL,
File_restores_MAX Number(20,4) NOT NULL,
File_restores_STCNT varchar2(32) NOT NULL,
File_uploads_MIN Number(20,4) NOT NULL,
File_uploads_MAX Number(20,4) NOT NULL,
File_uploads_STCNT varchar2(32) NOT NULL,
Page_views_MIN Number(20,4) NOT NULL,
Page_views_MAX Number(20,4) NOT NULL,
Page_views_STCNT varchar2(32) NOT NULL);

ALTER TABLE SPOFileActTest_TREND ADD constraint PK_SPOFileActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE SPOFileActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SPOFileActTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_operations_MIN VARCHAR2(256) NOT NULL,
Total_operations_MAX VARCHAR2(256) NOT NULL,
Unique_operations_MIN VARCHAR2(256) NOT NULL,
Unique_operations_MAX VARCHAR2(256) NOT NULL,
Unique_users_MIN VARCHAR2(256) NOT NULL,
Unique_users_MAX VARCHAR2(256) NOT NULL,
Unique_client_IPs_MIN VARCHAR2(256) NOT NULL,
Unique_client_IPs_MAX VARCHAR2(256) NOT NULL,
Unique_sites_MIN VARCHAR2(256) NOT NULL,
Unique_sites_MAX VARCHAR2(256) NOT NULL,
Affected_item_types_MIN VARCHAR2(256) NOT NULL,
Affected_item_types_MAX VARCHAR2(256) NOT NULL,
Unique_destinations_MIN VARCHAR2(256) NOT NULL,
Unique_destinations_MAX VARCHAR2(256) NOT NULL,
Unique_user_agents_MIN VARCHAR2(256) NOT NULL,
Unique_user_agents_MAX VARCHAR2(256) NOT NULL,
File_accesses_MIN VARCHAR2(256) NOT NULL,
File_accesses_MAX VARCHAR2(256) NOT NULL,
File_check_ins_MIN VARCHAR2(256) NOT NULL,
File_check_ins_MAX VARCHAR2(256) NOT NULL,
File_checkouts_MIN VARCHAR2(256) NOT NULL,
File_checkouts_MAX VARCHAR2(256) NOT NULL,
File_copies_MIN VARCHAR2(256) NOT NULL,
File_copies_MAX VARCHAR2(256) NOT NULL,
File_deletes_MIN VARCHAR2(256) NOT NULL,
File_deletes_MAX VARCHAR2(256) NOT NULL,
File_deletes_frm_I_stage_MIN VARCHAR2(256) NOT NULL,
File_deletes_frm_I_stage_MAX VARCHAR2(256) NOT NULL,
File_deletes_frm_II_stag_MIN VARCHAR2(256) NOT NULL,
File_deletes_frm_II_stag_MAX VARCHAR2(256) NOT NULL,
File_checkout_discards_MIN VARCHAR2(256) NOT NULL,
File_checkout_discards_MAX VARCHAR2(256) NOT NULL,
File_downloads_MIN VARCHAR2(256) NOT NULL,
File_downloads_MAX VARCHAR2(256) NOT NULL,
File_modifications_MIN VARCHAR2(256) NOT NULL,
File_modifications_MAX VARCHAR2(256) NOT NULL,
File_moves_MIN VARCHAR2(256) NOT NULL,
File_moves_MAX VARCHAR2(256) NOT NULL,
File_renames_MIN VARCHAR2(256) NOT NULL,
File_renames_MAX VARCHAR2(256) NOT NULL,
File_restores_MIN VARCHAR2(256) NOT NULL,
File_restores_MAX VARCHAR2(256) NOT NULL,
File_uploads_MIN VARCHAR2(256) NOT NULL,
File_uploads_MAX VARCHAR2(256) NOT NULL,
Page_views_MIN VARCHAR2(256) NOT NULL,
Page_views_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE SPOFileActTest_THRESH ADD constraint PK_SPOFileActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_SPOFileActTest_THRESH ON SPOFileActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_SPOFileActTest ON SPOFileActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_SPOFileActTest ON SPOFileActTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOMailBoxTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
Total_Mailboxes Number(20,4) NOT NULL,
Total_Mailboxes_ST varchar2(32) NOT NULL,
FrwdMailbx Number(20,4) NOT NULL,
FrwdMailbx_ST varchar2(32) NOT NULL,
litigation_hold Number(20,4) NOT NULL,
litigation_hold_ST varchar2(32) NOT NULL,
Inplace_hold Number(20,4) NOT NULL,
Inplace_hold_ST varchar2(32) NOT NULL,
AllMailbox_hold Number(20,4) NOT NULL,
AllMailbox_hold_ST varchar2(32) NOT NULL,
Shrdmailbx Number(20,4) NOT NULL,
Shrdmailbx_ST varchar2(32) NOT NULL,
NewlyCreateMailbx Number(20,4) NOT NULL,
NewlyCreateMailbx_ST varchar2(32) NOT NULL,
RecntModifyMailbx Number(20,4) NOT NULL,
RecntModifyMailbx_ST varchar2(32) NOT NULL,
SoftDeleteMailbx Number(20,4) NOT NULL,
SoftDeleteMailbx_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOMailBoxTest ON EXOMailBoxTest(MSMT_TIME);
ALTER TABLE EXOMailBoxTest ADD constraint PK_EXOMailBoxTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailBoxTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
Total_Mailboxes_MIN Number(20,4) NOT NULL,
Total_Mailboxes_MAX Number(20,4) NOT NULL,
Total_Mailboxes_STCNT varchar2(32) NOT NULL,
FrwdMailbx_MIN Number(20,4) NOT NULL,
FrwdMailbx_MAX Number(20,4) NOT NULL,
FrwdMailbx_STCNT varchar2(32) NOT NULL,
litigation_hold_MIN Number(20,4) NOT NULL,
litigation_hold_MAX Number(20,4) NOT NULL,
litigation_hold_STCNT varchar2(32) NOT NULL,
Inplace_hold_MIN Number(20,4) NOT NULL,
Inplace_hold_MAX Number(20,4) NOT NULL,
Inplace_hold_STCNT varchar2(32) NOT NULL,
AllMailbox_hold_MIN Number(20,4) NOT NULL,
AllMailbox_hold_MAX Number(20,4) NOT NULL,
AllMailbox_hold_STCNT varchar2(32) NOT NULL,
Shrdmailbx_MIN Number(20,4) NOT NULL,
Shrdmailbx_MAX Number(20,4) NOT NULL,
Shrdmailbx_STCNT varchar2(32) NOT NULL,
NewlyCreateMailbx_MIN Number(20,4) NOT NULL,
NewlyCreateMailbx_MAX Number(20,4) NOT NULL,
NewlyCreateMailbx_STCNT varchar2(32) NOT NULL,
RecntModifyMailbx_MIN Number(20,4) NOT NULL,
RecntModifyMailbx_MAX Number(20,4) NOT NULL,
RecntModifyMailbx_STCNT varchar2(32) NOT NULL,
SoftDeleteMailbx_MIN Number(20,4) NOT NULL,
SoftDeleteMailbx_MAX Number(20,4) NOT NULL,
SoftDeleteMailbx_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOMailBoxTest_TREND ADD constraint PK_EXOMailBoxTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailBoxTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
Total_Mailboxes_MIN VARCHAR2(256) NOT NULL,
Total_Mailboxes_MAX VARCHAR2(256) NOT NULL,
FrwdMailbx_MIN VARCHAR2(256) NOT NULL,
FrwdMailbx_MAX VARCHAR2(256) NOT NULL,
litigation_hold_MIN VARCHAR2(256) NOT NULL,
litigation_hold_MAX VARCHAR2(256) NOT NULL,
Inplace_hold_MIN VARCHAR2(256) NOT NULL,
Inplace_hold_MAX VARCHAR2(256) NOT NULL,
AllMailbox_hold_MIN VARCHAR2(256) NOT NULL,
AllMailbox_hold_MAX VARCHAR2(256) NOT NULL,
Shrdmailbx_MIN VARCHAR2(256) NOT NULL,
Shrdmailbx_MAX VARCHAR2(256) NOT NULL,
NewlyCreateMailbx_MIN VARCHAR2(256) NOT NULL,
NewlyCreateMailbx_MAX VARCHAR2(256) NOT NULL,
RecntModifyMailbx_MIN VARCHAR2(256) NOT NULL,
RecntModifyMailbx_MAX VARCHAR2(256) NOT NULL,
SoftDeleteMailbx_MIN VARCHAR2(256) NOT NULL,
SoftDeleteMailbx_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE EXOMailBoxTest_THRESH ADD constraint PK_EXOMailBoxTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMailBoxTest_THRESH ON EXOMailBoxTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailBoxTest ON EXOMailBoxTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailBoxTest ON EXOMailBoxTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOMailBoxStatsTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxStatsTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
TOTAL_MAILBOX_SIZE Number(20,4) NOT NULL,
TOTAL_MAILBOX_SIZE_ST varchar2(32) NOT NULL,
MAILBOXES_GROWTH_RATE Number(20,4) NOT NULL,
MAILBOXES_GROWTH_RATE_ST varchar2(32) NOT NULL,
MAILBOXES_OVER_QUOTA Number(20,4) NOT NULL,
MAILBOXES_OVER_QUOTA_ST varchar2(32) NOT NULL,
INACTIVE_MAILBOXES Number(20,4) NOT NULL,
INACTIVE_MAILBOXES_ST varchar2(32) NOT NULL,
INACTIVE_MAILBOXES_SIZE Number(20,4) NOT NULL,
INACTIVE_MAILBOXES_SIZE_ST varchar2(32) NOT NULL,
ARCHIVE_MAILBOXES Number(20,4) NOT NULL,
ARCHIVE_MAILBOXES_ST varchar2(32) NOT NULL,
ARCHIVE_MAILBOXES_SIZE Number(20,4) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_ST varchar2(32) NOT NULL,
CLUTTER_ENABLED_MAILBOX Number(20,4) NOT NULL,
CLUTTER_ENABLED_MAILBOX_ST varchar2(32) NOT NULL,
CLUTTER_DISABLED_MAILBOX Number(20,4) NOT NULL,
CLUTTER_DISABLED_MAILBOX_ST varchar2(32) NOT NULL,
DBSNDQTE Number(20,4) NOT NULL,
DBSNDQTE_ST varchar2(32) NOT NULL,
DBSNDRECQTE Number(20,4) NOT NULL,
DBSNDRECQTE_ST varchar2(32) NOT NULL,
ArrMailsExWnQta Number(20,4) NOT NULL,
ArrMailsExWnQta_ST varchar2(32) NOT NULL,
MbNearRecvrQuota Number(20,4) NOT NULL,
MbNearRecvrQuota_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOMailBoxStatsTest ON EXOMailBoxStatsTest(MSMT_TIME);
ALTER TABLE EXOMailBoxStatsTest ADD constraint PK_EXOMailBoxStatsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailBoxStatsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxStatsTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
TOTAL_MAILBOX_SIZE_MIN Number(20,4) NOT NULL,
TOTAL_MAILBOX_SIZE_MAX Number(20,4) NOT NULL,
TOTAL_MAILBOX_SIZE_STCNT varchar2(32) NOT NULL,
MAILBOXES_GROWTH_RATE_MIN Number(20,4) NOT NULL,
MAILBOXES_GROWTH_RATE_MAX Number(20,4) NOT NULL,
MAILBOXES_GROWTH_RATE_STCNT varchar2(32) NOT NULL,
MAILBOXES_OVER_QUOTA_MIN Number(20,4) NOT NULL,
MAILBOXES_OVER_QUOTA_MAX Number(20,4) NOT NULL,
MAILBOXES_OVER_QUOTA_STCNT varchar2(32) NOT NULL,
INACTIVE_MAILBOXES_MIN Number(20,4) NOT NULL,
INACTIVE_MAILBOXES_MAX Number(20,4) NOT NULL,
INACTIVE_MAILBOXES_STCNT varchar2(32) NOT NULL,
INACTIVE_MAILBOXES_SIZE_MIN Number(20,4) NOT NULL,
INACTIVE_MAILBOXES_SIZE_MAX Number(20,4) NOT NULL,
INACTIVE_MAILBOXES_SIZE_STCNT varchar2(32) NOT NULL,
ARCHIVE_MAILBOXES_MIN Number(20,4) NOT NULL,
ARCHIVE_MAILBOXES_MAX Number(20,4) NOT NULL,
ARCHIVE_MAILBOXES_STCNT varchar2(32) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_MIN Number(20,4) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_MAX Number(20,4) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_STCNT varchar2(32) NOT NULL,
CLUTTER_ENABLED_MAILBOX_MIN Number(20,4) NOT NULL,
CLUTTER_ENABLED_MAILBOX_MAX Number(20,4) NOT NULL,
CLUTTER_ENABLED_MAILBOX_STCNT varchar2(32) NOT NULL,
CLUTTER_DISABLED_MAILBOX_MIN Number(20,4) NOT NULL,
CLUTTER_DISABLED_MAILBOX_MAX Number(20,4) NOT NULL,
CLUTTER_DISABLED_MAILBOX_STCNT varchar2(32) NOT NULL,
DBSNDQTE_MIN Number(20,4) NOT NULL,
DBSNDQTE_MAX Number(20,4) NOT NULL,
DBSNDQTE_STCNT varchar2(32) NOT NULL,
DBSNDRECQTE_MIN Number(20,4) NOT NULL,
DBSNDRECQTE_MAX Number(20,4) NOT NULL,
DBSNDRECQTE_STCNT varchar2(32) NOT NULL,
ArrMailsExWnQta_MIN Number(20,4) NOT NULL,
ArrMailsExWnQta_MAX Number(20,4) NOT NULL,
ArrMailsExWnQta_STCNT varchar2(32) NOT NULL,
MbNearRecvrQuota_MIN Number(20,4) NOT NULL,
MbNearRecvrQuota_MAX Number(20,4) NOT NULL,
MbNearRecvrQuota_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOMailBoxStatsTest_TREND ADD constraint PK_EXOMailBoxStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailBoxStatsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxStatsTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
TOTAL_MAILBOX_SIZE_MIN varchar2(256) NOT NULL,
TOTAL_MAILBOX_SIZE_MAX varchar2(256) NOT NULL,
MAILBOXES_GROWTH_RATE_MIN varchar2(256) NOT NULL,
MAILBOXES_GROWTH_RATE_MAX varchar2(256) NOT NULL,
MAILBOXES_OVER_QUOTA_MIN varchar2(256) NOT NULL,
MAILBOXES_OVER_QUOTA_MAX varchar2(256) NOT NULL,
INACTIVE_MAILBOXES_MIN varchar2(256) NOT NULL,
INACTIVE_MAILBOXES_MAX varchar2(256) NOT NULL,
INACTIVE_MAILBOXES_SIZE_MIN varchar2(256) NOT NULL,
INACTIVE_MAILBOXES_SIZE_MAX varchar2(256) NOT NULL,
ARCHIVE_MAILBOXES_MIN varchar2(256) NOT NULL,
ARCHIVE_MAILBOXES_MAX varchar2(256) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_MIN varchar2(256) NOT NULL,
ARCHIVE_MAILBOXES_SIZE_MAX varchar2(256) NOT NULL,
CLUTTER_ENABLED_MAILBOX_MIN varchar2(256) NOT NULL,
CLUTTER_ENABLED_MAILBOX_MAX varchar2(256) NOT NULL,
CLUTTER_DISABLED_MAILBOX_MIN varchar2(256) NOT NULL,
CLUTTER_DISABLED_MAILBOX_MAX varchar2(256) NOT NULL,
DBSNDQTE_MIN varchar2(256) NOT NULL,
DBSNDQTE_MAX varchar2(256) NOT NULL,
DBSNDRECQTE_MIN varchar2(256) NOT NULL,
DBSNDRECQTE_MAX varchar2(256) NOT NULL,
ArrMailsExWnQta_MIN varchar2(256) NOT NULL,
ArrMailsExWnQta_MAX varchar2(256) NOT NULL,
MbNearRecvrQuota_MIN varchar2(256) NOT NULL,
MbNearRecvrQuota_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOMailBoxStatsTest_THRESH ADD constraint PK_EXOMailBoxStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMailBoxStatsTest_THRESH ON EXOMailBoxStatsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailBoxStatsTest ON EXOMailBoxStatsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailBoxStatsTest ON EXOMailBoxStatsTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE EXOUsersTest CASCADE CONSTRAINTS;
CREATE TABLE EXOUsersTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Activesync Number(20,4) NOT NULL,
Activesync_ST varchar2(32) NOT NULL,
Non_Activesync Number(20,4) NOT NULL,
Non_Activesync_ST varchar2(32) NOT NULL,
SendAsUsers Number(20,4) NOT NULL,
SendAsUsers_ST varchar2(32) NOT NULL,
SendOnBehlfUsers Number(20,4) NOT NULL,
SendOnBehlfUsers_ST varchar2(32) NOT NULL,
AdminUsers Number(20,4) NOT NULL,
AdminUsers_ST varchar2(32) NOT NULL,
ActvUser Number(20,4) NOT NULL,
ActvUser_ST varchar2(32) NOT NULL,
InActvUser Number(20,4) NOT NULL,
InActvUser_ST varchar2(32) NOT NULL,
NvrLogUser Number(20,4) NOT NULL,
NvrLogUser_ST varchar2(32) NOT NULL,
PassExpUsers Number(20,4) NOT NULL,
PassExpUsers_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOUsersTest ON EXOUsersTest(MSMT_TIME);
ALTER TABLE EXOUsersTest ADD constraint PK_EXOUsersTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUsersTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOUsersTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Activesync_MIN Number(20,4) NOT NULL,
Activesync_MAX Number(20,4) NOT NULL,
Activesync_STCNT varchar2(32) NOT NULL,
Non_Activesync_MIN Number(20,4) NOT NULL,
Non_Activesync_MAX Number(20,4) NOT NULL,
Non_Activesync_STCNT varchar2(32) NOT NULL,
SendAsUsers_MIN Number(20,4) NOT NULL,
SendAsUsers_MAX Number(20,4) NOT NULL,
SendAsUsers_STCNT varchar2(32) NOT NULL,
SendOnBehlfUsers_MIN Number(20,4) NOT NULL,
SendOnBehlfUsers_MAX Number(20,4) NOT NULL,
SendOnBehlfUsers_STCNT varchar2(32) NOT NULL,
AdminUsers_MIN Number(20,4) NOT NULL,
AdminUsers_MAX Number(20,4) NOT NULL,
AdminUsers_STCNT varchar2(32) NOT NULL,
ActvUser_MIN Number(20,4) NOT NULL,
ActvUser_MAX Number(20,4) NOT NULL,
ActvUser_STCNT varchar2(32) NOT NULL,
InActvUser_MIN Number(20,4) NOT NULL,
InActvUser_MAX Number(20,4) NOT NULL,
InActvUser_STCNT varchar2(32) NOT NULL,
NvrLogUser_MIN Number(20,4) NOT NULL,
NvrLogUser_MAX Number(20,4) NOT NULL,
NvrLogUser_STCNT varchar2(32) NOT NULL,
PassExpUsers_MIN Number(20,4) NOT NULL,
PassExpUsers_MAX Number(20,4) NOT NULL,
PassExpUsers_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOUsersTest_TREND ADD constraint PK_EXOUsersTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUsersTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOUsersTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Activesync_MIN varchar2(256) NOT NULL,
Activesync_MAX varchar2(256) NOT NULL,
Non_Activesync_MIN varchar2(256) NOT NULL,
Non_Activesync_MAX varchar2(256) NOT NULL,
SendAsUsers_MIN varchar2(256) NOT NULL,
SendAsUsers_MAX varchar2(256) NOT NULL,
SendOnBehlfUsers_MIN varchar2(256) NOT NULL,
SendOnBehlfUsers_MAX varchar2(256) NOT NULL,
AdminUsers_MIN varchar2(256) NOT NULL,
AdminUsers_MAX varchar2(256) NOT NULL,
ActvUser_MIN varchar2(256) NOT NULL,
ActvUser_MAX varchar2(256) NOT NULL,
InActvUser_MIN varchar2(256) NOT NULL,
InActvUser_MAX varchar2(256) NOT NULL,
NvrLogUser_MIN varchar2(256) NOT NULL,
NvrLogUser_MAX varchar2(256) NOT NULL,
PassExpUsers_MIN varchar2(256) NOT NULL,
PassExpUsers_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOUsersTest_THRESH ADD constraint PK_EXOUsersTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUsersTest_THRESH ON EXOUsersTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUsersTest ON EXOUsersTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUsersTest ON EXOUsersTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOReciTypeTest CASCADE CONSTRAINTS;
CREATE TABLE EXOReciTypeTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Count Number(20,4) NOT NULL,
Count_ST varchar2(32) NOT NULL,
Mailboxes_Size Number(20,4) NOT NULL,
Mailboxes_Size_ST varchar2(32) NOT NULL,
Item_Count Number(20,4) NOT NULL,
Item_Count_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOReciTypeTest ON EXOReciTypeTest(MSMT_TIME);
ALTER TABLE EXOReciTypeTest ADD constraint PK_EXOReciTypeTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOReciTypeTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOReciTypeTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Count_MIN Number(20,4) NOT NULL,
Count_MAX Number(20,4) NOT NULL,
Count_STCNT varchar2(32) NOT NULL,
Mailboxes_Size_MIN Number(20,4) NOT NULL,
Mailboxes_Size_MAX Number(20,4) NOT NULL,
Mailboxes_Size_STCNT varchar2(32) NOT NULL,
Item_Count_MIN Number(20,4) NOT NULL,
Item_Count_MAX Number(20,4) NOT NULL,
Item_Count_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOReciTypeTest_TREND ADD constraint PK_EXOReciTypeTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOReciTypeTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOReciTypeTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Count_MIN varchar2(256) NOT NULL,
Count_MAX varchar2(256) NOT NULL,
Mailboxes_Size_MIN varchar2(256) NOT NULL,
Mailboxes_Size_MAX varchar2(256) NOT NULL,
Item_Count_MIN varchar2(256) NOT NULL,
Item_Count_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOReciTypeTest_THRESH ADD constraint PK_EXOReciTypeTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOReciTypeTest_THRESH ON EXOReciTypeTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOReciTypeTest ON EXOReciTypeTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOReciTypeTest ON EXOReciTypeTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOMailTrfcStatisTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMailTrfcStatisTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Unique_Senders Number(20,4) NOT NULL,
Unique_Senders_ST varchar2(32) NOT NULL,
Unique_Receivers Number(20,4) NOT NULL,
Unique_Receivers_ST varchar2(32) NOT NULL,
Unique_Sender_IPs Number(20,4) NOT NULL,
Unique_Sender_IPs_ST varchar2(32) NOT NULL,
Inbound_Mail_Items Number(20,4) NOT NULL,
Inbound_Mail_Items_ST varchar2(32) NOT NULL,
Inbound_Mails_Size Number(20,4) NOT NULL,
Inbound_Mails_Size_ST varchar2(32) NOT NULL,
Outbound_Mail_Items Number(20,4) NOT NULL,
Outbound_Mail_Items_ST varchar2(32) NOT NULL,
Outbound_Mails_Size Number(20,4) NOT NULL,
Outbound_Mails_Size_ST varchar2(32) NOT NULL,
Total_Mail_Items Number(20,4) NOT NULL,
Total_Mail_Items_ST varchar2(32) NOT NULL,
Total_Mails_Size Number(20,4) NOT NULL,
Total_Mails_Size_ST varchar2(32) NOT NULL,
Internal_emails_sent Number(20,4) NOT NULL,
Internal_emails_sent_ST varchar2(32) NOT NULL,
Size_Intl_mailsent Number(20,4) NOT NULL,
Size_Intl_mailsent_ST varchar2(32) NOT NULL,
Internal_emails_recvd Number(20,4) NOT NULL,
Internal_emails_recvd_ST varchar2(32) NOT NULL,
Size_Intl_mailrecvd Number(20,4) NOT NULL,
Size_Intl_mailrecvd_ST varchar2(32) NOT NULL,
External_emails_sent Number(20,4) NOT NULL,
External_emails_sent_ST varchar2(32) NOT NULL,
Size_exrtl_mailsent Number(20,4) NOT NULL,
Size_exrtl_mailsent_ST varchar2(32) NOT NULL,
External_emails_recvd Number(20,4) NOT NULL,
External_emails_recvd_ST varchar2(32) NOT NULL,
Size_extl_mailrecvd Number(20,4) NOT NULL,
Size_extl_mailrecvd_ST varchar2(32) NOT NULL,
Nonecnt Number(20,4) NOT NULL,
Nonecnt_ST varchar2(32) NOT NULL,
Failedcnt Number(20,4) NOT NULL,
Failedcnt_ST varchar2(32) NOT NULL,
Pendingcnt Number(20,4) NOT NULL,
Pendingcnt_ST varchar2(32) NOT NULL,
Delvrycnt Number(20,4) NOT NULL,
Delvrycnt_ST varchar2(32) NOT NULL,
Expandcnt Number(20,4) NOT NULL,
Expandcnt_ST varchar2(32) NOT NULL,
Unq_outbud_doms Number(20,4) NOT NULL,
Unq_outbud_doms_ST varchar2(32) NOT NULL,
Unq_innbud_doms Number(20,4) NOT NULL,
Unq_innbud_doms_ST varchar2(32) NOT NULL,
Resloved Number(20,4) NOT NULL,
Resloved_ST varchar2(32) NOT NULL,
Filtered_as_spam Number(20,4) NOT NULL,
Filtered_as_spam_ST varchar2(32) NOT NULL,
Getting_status Number(20,4) NOT NULL,
Getting_status_ST varchar2(32) NOT NULL,
Quarantined Number(20,4) NOT NULL,
Quarantined_ST varchar2(32) NOT NULL,
Unknown Number(20,4) NOT NULL,
Unknown_ST varchar2(32) NOT NULL);


CREATE INDEX IDX_EXOMailTrfcStatisTest ON EXOMailTrfcStatisTest(MSMT_TIME);
ALTER TABLE EXOMailTrfcStatisTest ADD constraint PK_EXOMailTrfcStatisTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailTrfcStatisTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMailTrfcStatisTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Unique_Senders_MIN Number(20,4) NOT NULL,
Unique_Senders_MAX Number(20,4) NOT NULL,
Unique_Senders_STCNT varchar2(32) NOT NULL,
Unique_Receivers_MIN Number(20,4) NOT NULL,
Unique_Receivers_MAX Number(20,4) NOT NULL,
Unique_Receivers_STCNT varchar2(32) NOT NULL,
Unique_Sender_IPs_MIN Number(20,4) NOT NULL,
Unique_Sender_IPs_MAX Number(20,4) NOT NULL,
Unique_Sender_IPs_STCNT varchar2(32) NOT NULL,
Inbound_Mail_Items_MIN Number(20,4) NOT NULL,
Inbound_Mail_Items_MAX Number(20,4) NOT NULL,
Inbound_Mail_Items_STCNT varchar2(32) NOT NULL,
Inbound_Mails_Size_MIN Number(20,4) NOT NULL,
Inbound_Mails_Size_MAX Number(20,4) NOT NULL,
Inbound_Mails_Size_STCNT varchar2(32) NOT NULL,
Outbound_Mail_Items_MIN Number(20,4) NOT NULL,
Outbound_Mail_Items_MAX Number(20,4) NOT NULL,
Outbound_Mail_Items_STCNT varchar2(32) NOT NULL,
Outbound_Mails_Size_MIN Number(20,4) NOT NULL,
Outbound_Mails_Size_MAX Number(20,4) NOT NULL,
Outbound_Mails_Size_STCNT varchar2(32) NOT NULL,
Total_Mail_Items_MIN Number(20,4) NOT NULL,
Total_Mail_Items_MAX Number(20,4) NOT NULL,
Total_Mail_Items_STCNT varchar2(32) NOT NULL,
Total_Mails_Size_MIN Number(20,4) NOT NULL,
Total_Mails_Size_MAX Number(20,4) NOT NULL,
Total_Mails_Size_STCNT varchar2(32) NOT NULL,
Internal_emails_sent_MIN Number(20,4) NOT NULL,
Internal_emails_sent_MAX Number(20,4) NOT NULL,
Internal_emails_sent_STCNT varchar2(32) NOT NULL,
Size_Intl_mailsent_MIN Number(20,4) NOT NULL,
Size_Intl_mailsent_MAX Number(20,4) NOT NULL,
Size_Intl_mailsent_STCNT varchar2(32) NOT NULL,
Internal_emails_recvd_MIN Number(20,4) NOT NULL,
Internal_emails_recvd_MAX Number(20,4) NOT NULL,
Internal_emails_recvd_STCNT varchar2(32) NOT NULL,
Size_Intl_mailrecvd_MIN Number(20,4) NOT NULL,
Size_Intl_mailrecvd_MAX Number(20,4) NOT NULL,
Size_Intl_mailrecvd_STCNT varchar2(32) NOT NULL,
External_emails_sent_MIN Number(20,4) NOT NULL,
External_emails_sent_MAX Number(20,4) NOT NULL,
External_emails_sent_STCNT varchar2(32) NOT NULL,
Size_exrtl_mailsent_MIN Number(20,4) NOT NULL,
Size_exrtl_mailsent_MAX Number(20,4) NOT NULL,
Size_exrtl_mailsent_STCNT varchar2(32) NOT NULL,
External_emails_recvd_MIN Number(20,4) NOT NULL,
External_emails_recvd_MAX Number(20,4) NOT NULL,
External_emails_recvd_STCNT varchar2(32) NOT NULL,
Size_extl_mailrecvd_MIN Number(20,4) NOT NULL,
Size_extl_mailrecvd_MAX Number(20,4) NOT NULL,
Size_extl_mailrecvd_STCNT varchar2(32) NOT NULL,
Nonecnt_MIN Number(20,4) NOT NULL,
Nonecnt_MAX Number(20,4) NOT NULL,
Nonecnt_STCNT varchar2(32) NOT NULL,
Failedcnt_MIN Number(20,4) NOT NULL,
Failedcnt_MAX Number(20,4) NOT NULL,
Failedcnt_STCNT varchar2(32) NOT NULL,
Pendingcnt_MIN Number(20,4) NOT NULL,
Pendingcnt_MAX Number(20,4) NOT NULL,
Pendingcnt_STCNT varchar2(32) NOT NULL,
Delvrycnt_MIN Number(20,4) NOT NULL,
Delvrycnt_MAX Number(20,4) NOT NULL,
Delvrycnt_STCNT varchar2(32) NOT NULL,
Expandcnt_MIN Number(20,4) NOT NULL,
Expandcnt_MAX Number(20,4) NOT NULL,
Expandcnt_STCNT varchar2(32) NOT NULL,
Unq_outbud_doms_MIN Number(20,4) NOT NULL,
Unq_outbud_doms_MAX Number(20,4) NOT NULL,
Unq_outbud_doms_STCNT varchar2(32) NOT NULL,
Unq_innbud_doms_MIN Number(20,4) NOT NULL,
Unq_innbud_doms_MAX Number(20,4) NOT NULL,
Unq_innbud_doms_STCNT varchar2(32) NOT NULL,
Resloved_MIN Number(20,4) NOT NULL,
Resloved_MAX Number(20,4) NOT NULL,
Resloved_STCNT varchar2(32) NOT NULL,
Filtered_as_spam_MIN Number(20,4) NOT NULL,
Filtered_as_spam_MAX Number(20,4) NOT NULL,
Filtered_as_spam_STCNT varchar2(32) NOT NULL,
Getting_status_MIN Number(20,4) NOT NULL,
Getting_status_MAX Number(20,4) NOT NULL,
Getting_status_STCNT varchar2(32) NOT NULL,
Quarantined_MIN Number(20,4) NOT NULL,
Quarantined_MAX Number(20,4) NOT NULL,
Quarantined_STCNT varchar2(32) NOT NULL,
Unknown_MIN Number(20,4) NOT NULL,
Unknown_MAX Number(20,4) NOT NULL,
Unknown_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOMailTrfcStatisTest_TREND ADD constraint PK_EXOMalTrfcStatsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailTrfcStatisTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMailTrfcStatisTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Unique_Senders_MIN varchar2(256) NOT NULL,
Unique_Senders_MAX varchar2(256) NOT NULL,
Unique_Receivers_MIN varchar2(256) NOT NULL,
Unique_Receivers_MAX varchar2(256) NOT NULL,
Unique_Sender_IPs_MIN varchar2(256) NOT NULL,
Unique_Sender_IPs_MAX varchar2(256) NOT NULL,
Inbound_Mail_Items_MIN varchar2(256) NOT NULL,
Inbound_Mail_Items_MAX varchar2(256) NOT NULL,
Inbound_Mails_Size_MIN varchar2(256) NOT NULL,
Inbound_Mails_Size_MAX varchar2(256) NOT NULL,
Outbound_Mail_Items_MIN varchar2(256) NOT NULL,
Outbound_Mail_Items_MAX varchar2(256) NOT NULL,
Outbound_Mails_Size_MIN varchar2(256) NOT NULL,
Outbound_Mails_Size_MAX varchar2(256) NOT NULL,
Total_Mail_Items_MIN varchar2(256) NOT NULL,
Total_Mail_Items_MAX varchar2(256) NOT NULL,
Total_Mails_Size_MIN varchar2(256) NOT NULL,
Total_Mails_Size_MAX varchar2(256) NOT NULL,
Internal_emails_sent_MIN varchar2(256) NOT NULL,
Internal_emails_sent_MAX varchar2(256) NOT NULL,
Size_Intl_mailsent_MIN varchar2(256) NOT NULL,
Size_Intl_mailsent_MAX varchar2(256) NOT NULL,
Internal_emails_recvd_MIN varchar2(256) NOT NULL,
Internal_emails_recvd_MAX varchar2(256) NOT NULL,
Size_Intl_mailrecvd_MIN varchar2(256) NOT NULL,
Size_Intl_mailrecvd_MAX varchar2(256) NOT NULL,
External_emails_sent_MIN varchar2(256) NOT NULL,
External_emails_sent_MAX varchar2(256) NOT NULL,
Size_exrtl_mailsent_MIN varchar2(256) NOT NULL,
Size_exrtl_mailsent_MAX varchar2(256) NOT NULL,
External_emails_recvd_MIN varchar2(256) NOT NULL,
External_emails_recvd_MAX varchar2(256) NOT NULL,
Size_extl_mailrecvd_MIN varchar2(256) NOT NULL,
Size_extl_mailrecvd_MAX varchar2(256) NOT NULL,
Nonecnt_MIN varchar2(256) NOT NULL,
Nonecnt_MAX varchar2(256) NOT NULL,
Failedcnt_MIN varchar2(256) NOT NULL,
Failedcnt_MAX varchar2(256) NOT NULL,
Pendingcnt_MIN varchar2(256) NOT NULL,
Pendingcnt_MAX varchar2(256) NOT NULL,
Delvrycnt_MIN varchar2(256) NOT NULL,
Delvrycnt_MAX varchar2(256) NOT NULL,
Expandcnt_MIN varchar2(256) NOT NULL,
Expandcnt_MAX varchar2(256) NOT NULL,
Unq_outbud_doms_MIN varchar2(256) NOT NULL,
Unq_outbud_doms_MAX varchar2(256) NOT NULL,
Unq_innbud_doms_MIN varchar2(256) NOT NULL,
Unq_innbud_doms_MAX varchar2(256) NOT NULL,
Resloved_MIN varchar2(256) NOT NULL,
Resloved_MAX varchar2(256) NOT NULL,
Filtered_as_spam_MIN varchar2(256) NOT NULL,
Filtered_as_spam_MAX varchar2(256) NOT NULL,
Getting_status_MIN varchar2(256) NOT NULL,
Getting_status_MAX varchar2(256) NOT NULL,
Quarantined_MIN varchar2(256) NOT NULL,
Quarantined_MAX varchar2(256) NOT NULL,
Unknown_MIN varchar2(256) NOT NULL,
Unknown_MAX varchar2(256) NOT NULL);
ALTER TABLE EXOMailTrfcStatisTest_THRESH ADD constraint PK_EXOMalTrfcStatsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMalTrfStatTest_THRESH ON EXOMailTrfcStatisTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailTrfcStatisTest ON EXOMailTrfcStatisTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailTrfcStatisTest ON EXOMailTrfcStatisTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOUserMAPIConTest CASCADE CONSTRAINTS;
CREATE TABLE EXOUserMAPIConTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Status Number(20,4) NOT NULL,
Status_ST varchar2(32) NOT NULL,
Connect_time Number(20,4) NOT NULL,
Connect_time_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOUserMAPIConTest ON EXOUserMAPIConTest(MSMT_TIME);
ALTER TABLE EXOUserMAPIConTest ADD constraint PK_EXOUserMAPIConTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOUserMAPIConTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOUserMAPIConTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Status_MIN Number(20,4) NOT NULL,
Status_MAX Number(20,4) NOT NULL,
Status_STCNT varchar2(32) NOT NULL,
Connect_time_MIN Number(20,4) NOT NULL,
Connect_time_MAX Number(20,4) NOT NULL,
Connect_time_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOUserMAPIConTest_TREND ADD constraint PK_EXOUserMAPIConTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOUserMAPIConTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOUserMAPIConTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Status_MIN varchar2(256) NOT NULL,
Status_MAX varchar2(256) NOT NULL,
Connect_time_MIN varchar2(256) NOT NULL,
Connect_time_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOUserMAPIConTest_THRESH ADD constraint PK_EXOUserMAPIConTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOUserMAPIConTest_THRESH ON EXOUserMAPIConTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOUserMAPIConTest ON EXOUserMAPIConTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOUserMAPIConTest ON EXOUserMAPIConTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXODevicConTest CASCADE CONSTRAINTS;
CREATE TABLE EXODevicConTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Unique_user_agents Number(20,4) NOT NULL,
Unique_user_agents_ST varchar2(32) NOT NULL,
Unique_device_types Number(20,4) NOT NULL,
Unique_device_types_ST varchar2(32) NOT NULL,
Unique_OS Number(20,4) NOT NULL,
Unique_OS_ST varchar2(32) NOT NULL,
Unique_clients Number(20,4) NOT NULL,
Unique_clients_ST varchar2(32) NOT NULL,
Unique_dev_OS_lang Number(20,4) NOT NULL,
Unique_dev_OS_lang_ST varchar2(32) NOT NULL,
Synchronized_devices Number(20,4) NOT NULL,
Synchronized_devices_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXODevicConTest ON EXODevicConTest(MSMT_TIME);
ALTER TABLE EXODevicConTest ADD constraint PK_EXODevicConTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXODevicConTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXODevicConTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Unique_user_agents_MIN Number(20,4) NOT NULL,
Unique_user_agents_MAX Number(20,4) NOT NULL,
Unique_user_agents_STCNT varchar2(32) NOT NULL,
Unique_device_types_MIN Number(20,4) NOT NULL,
Unique_device_types_MAX Number(20,4) NOT NULL,
Unique_device_types_STCNT varchar2(32) NOT NULL,
Unique_OS_MIN Number(20,4) NOT NULL,
Unique_OS_MAX Number(20,4) NOT NULL,
Unique_OS_STCNT varchar2(32) NOT NULL,
Unique_clients_MIN Number(20,4) NOT NULL,
Unique_clients_MAX Number(20,4) NOT NULL,
Unique_clients_STCNT varchar2(32) NOT NULL,
Unique_dev_OS_lang_MIN Number(20,4) NOT NULL,
Unique_dev_OS_lang_MAX Number(20,4) NOT NULL,
Unique_dev_OS_lang_STCNT varchar2(32) NOT NULL,
Synchronized_devices_MIN Number(20,4) NOT NULL,
Synchronized_devices_MAX Number(20,4) NOT NULL,
Synchronized_devices_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXODevicConTest_TREND ADD constraint PK_EXODevicConTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXODevicConTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXODevicConTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Unique_user_agents_MIN varchar2(256) NOT NULL,
Unique_user_agents_MAX varchar2(256) NOT NULL,
Unique_device_types_MIN varchar2(256) NOT NULL,
Unique_device_types_MAX varchar2(256) NOT NULL,
Unique_OS_MIN varchar2(256) NOT NULL,
Unique_OS_MAX varchar2(256) NOT NULL,
Unique_clients_MIN varchar2(256) NOT NULL,
Unique_clients_MAX varchar2(256) NOT NULL,
Unique_dev_OS_lang_MIN varchar2(256) NOT NULL,
Unique_dev_OS_lang_MAX varchar2(256) NOT NULL,
Synchronized_devices_MIN varchar2(256) NOT NULL,
Synchronized_devices_MAX varchar2(256) NOT NULL);

ALTER TABLE EXODevicConTest_THRESH ADD constraint PK_EXODevicConTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXODevicConTest_THRESH ON EXODevicConTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXODevicConTest ON EXODevicConTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXODevicConTest ON EXODevicConTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE EXOSrvcHlhTest CASCADE CONSTRAINTS;
CREATE TABLE EXOSrvcHlhTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
SERVICE_INCIDENTS Number(20,4) NOT NULL,
SERVICE_INCIDENTS_ST varchar2(32) NOT NULL,
MAINTENANCE_EVENTS Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_ST varchar2(32) NOT NULL,
SERVICE_STATUS Number(20,4) NOT NULL,
SERVICE_STATUS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOSrvcHlhTest ON EXOSrvcHlhTest(MSMT_TIME);
ALTER TABLE EXOSrvcHlhTest ADD constraint PK_EXOSrvcHlhTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOSrvcHlhTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOSrvcHlhTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
SERVICE_INCIDENTS_MIN Number(20,4) NOT NULL,
SERVICE_INCIDENTS_MAX Number(20,4) NOT NULL,
SERVICE_INCIDENTS_STCNT varchar2(32) NOT NULL,
MAINTENANCE_EVENTS_MIN Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_MAX Number(20,4) NOT NULL,
MAINTENANCE_EVENTS_STCNT varchar2(32) NOT NULL,
SERVICE_STATUS_MIN Number(20,4) NOT NULL,
SERVICE_STATUS_MAX Number(20,4) NOT NULL,
SERVICE_STATUS_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOSrvcHlhTest_TREND ADD constraint PK_EXOSrvcHlhTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOSrvcHlhTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOSrvcHlhTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
SERVICE_INCIDENTS_MIN varchar2(256) NOT NULL,
SERVICE_INCIDENTS_MAX varchar2(256) NOT NULL,
MAINTENANCE_EVENTS_MIN varchar2(256) NOT NULL,
MAINTENANCE_EVENTS_MAX varchar2(256) NOT NULL,
SERVICE_STATUS_MIN varchar2(256) NOT NULL,
SERVICE_STATUS_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOSrvcHlhTest_THRESH ADD constraint PK_EXOSrvcHlhTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOSrvcHlhTest_THRESH ON EXOSrvcHlhTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOSrvcHlhTest ON EXOSrvcHlhTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOSrvcHlhTest ON EXOSrvcHlhTest_TREND (MSMT_TIME,PERIOD);




DROP TABLE EXOLicenseTest CASCADE CONSTRAINTS;
CREATE TABLE EXOLicenseTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
NON_TRIAL_ENTITLEMENTS Number(20,4) NOT NULL,
NON_TRIAL_ENTITLEMENTS_ST varchar2(32) NOT NULL,
TRIAL_ENTITLEMENTS Number(20,4) NOT NULL,
TRIAL_ENTITLEMENTS_ST varchar2(32) NOT NULL,
ACTIVE_USERS Number(20,4) NOT NULL,
ACTIVE_USERS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOLicenseTest ON EXOLicenseTest(MSMT_TIME);
ALTER TABLE EXOLicenseTest ADD constraint PK_EXOLicenseTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOLicenseTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOLicenseTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
NON_TRIAL_ENTITLEMENTS_MIN Number(20,4) NOT NULL,
NON_TRIAL_ENTITLEMENTS_MAX Number(20,4) NOT NULL,
NON_TRIAL_ENTITLEMENTS_STCNT varchar2(32) NOT NULL,
TRIAL_ENTITLEMENTS_MIN Number(20,4) NOT NULL,
TRIAL_ENTITLEMENTS_MAX Number(20,4) NOT NULL,
TRIAL_ENTITLEMENTS_STCNT varchar2(32) NOT NULL,
ACTIVE_USERS_MIN Number(20,4) NOT NULL,
ACTIVE_USERS_MAX Number(20,4) NOT NULL,
ACTIVE_USERS_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOLicenseTest_TREND ADD constraint PK_EXOLicenseTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOLicenseTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOLicenseTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL
,MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
NON_TRIAL_ENTITLEMENTS_MIN varchar2(256) NOT NULL,
NON_TRIAL_ENTITLEMENTS_MAX varchar2(256) NOT NULL,
TRIAL_ENTITLEMENTS_MIN varchar2(256) NOT NULL,
TRIAL_ENTITLEMENTS_MAX varchar2(256) NOT NULL,
ACTIVE_USERS_MIN varchar2(256) NOT NULL,
ACTIVE_USERS_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOLicenseTest_THRESH ADD constraint PK_EXOLicenseTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOLicenseTest_THRESH ON EXOLicenseTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOLicenseTest ON EXOLicenseTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOLicenseTest ON EXOLicenseTest_TREND (MSMT_TIME,PERIOD);







DROP TABLE EXOLoginTest CASCADE CONSTRAINTS;
CREATE TABLE EXOLoginTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
AUTHENTICATION_STATUS Number(20,4) NOT NULL,
AUTHENTICATION_STATUS_ST varchar2(32) NOT NULL,
AUTHENTICATION_TIME Number(20,4) NOT NULL,
AUTHENTICATION_TIME_ST varchar2(32) NOT NULL,
LOGIN_STATUS Number(20,4) NOT NULL,
LOGIN_STATUS_ST varchar2(32) NOT NULL,
LOGIN_TIME Number(20,4) NOT NULL,
LOGIN_TIME_ST varchar2(32) NOT NULL,
TOTAL_LOGIN_TIME Number(20,4) NOT NULL,
TOTAL_LOGIN_TIME_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOLoginTest ON EXOLoginTest(MSMT_TIME);
ALTER TABLE EXOLoginTest ADD constraint PK_EXOLoginTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOLoginTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOLoginTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
AUTHENTICATION_STATUS_MIN Number(20,4) NOT NULL,
AUTHENTICATION_STATUS_MAX Number(20,4) NOT NULL,
AUTHENTICATION_STATUS_STCNT varchar2(32) NOT NULL,
AUTHENTICATION_TIME_MIN Number(20,4) NOT NULL,
AUTHENTICATION_TIME_MAX Number(20,4) NOT NULL,
AUTHENTICATION_TIME_STCNT varchar2(32) NOT NULL,
LOGIN_STATUS_MIN Number(20,4) NOT NULL,
LOGIN_STATUS_MAX Number(20,4) NOT NULL,
LOGIN_STATUS_STCNT varchar2(32) NOT NULL,
LOGIN_TIME_MIN Number(20,4) NOT NULL,
LOGIN_TIME_MAX Number(20,4) NOT NULL,
LOGIN_TIME_STCNT varchar2(32) NOT NULL,
TOTAL_LOGIN_TIME_MIN Number(20,4) NOT NULL,
TOTAL_LOGIN_TIME_MAX Number(20,4) NOT NULL,
TOTAL_LOGIN_TIME_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOLoginTest_TREND ADD constraint PK_EXOLoginTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOLoginTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOLoginTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
AUTHENTICATION_STATUS_MIN varchar2(256) NOT NULL,
AUTHENTICATION_STATUS_MAX varchar2(256) NOT NULL,
AUTHENTICATION_TIME_MIN varchar2(256) NOT NULL,
AUTHENTICATION_TIME_MAX varchar2(256) NOT NULL,
LOGIN_STATUS_MIN varchar2(256) NOT NULL,
LOGIN_STATUS_MAX varchar2(256) NOT NULL,
LOGIN_TIME_MIN varchar2(256) NOT NULL,
LOGIN_TIME_MAX varchar2(256) NOT NULL,
TOTAL_LOGIN_TIME_MIN varchar2(256) NOT NULL,
TOTAL_LOGIN_TIME_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOLoginTest_THRESH ADD constraint PK_EXOLoginTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOLoginTest_THRESH ON EXOLoginTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOLoginTest ON EXOLoginTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOLoginTest ON EXOLoginTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOAdminActTest CASCADE CONSTRAINTS;
CREATE TABLE EXOAdminActTest( 
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Total_Operations Number(20,4) NOT NULL,
Total_Operations_ST varchar2(32) NOT NULL,
Unique_Operations Number(20,4) NOT NULL,
Unique_Operations_ST varchar2(32) NOT NULL,
Unique_Users Number(20,4) NOT NULL,
Unique_Users_ST varchar2(32) NOT NULL,
Unique_ClientIP Number(20,4) NOT NULL,
Unique_ClientIP_ST varchar2(32) NOT NULL,
Ms_AdminOperation Number(20,4) NOT NULL,
Ms_AdminOperation_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOAdminActTest ON EXOAdminActTest(MSMT_TIME);
ALTER TABLE EXOAdminActTest ADD constraint PK_EXOAdminActTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOAdminActTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOAdminActTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Total_Operations_MIN Number(20,4) NOT NULL,
Total_Operations_MAX Number(20,4) NOT NULL,
Total_Operations_STCNT varchar2(32) NOT NULL,
Unique_Operations_MIN Number(20,4) NOT NULL,
Unique_Operations_MAX Number(20,4) NOT NULL,
Unique_Operations_STCNT varchar2(32) NOT NULL,
Unique_Users_MIN Number(20,4) NOT NULL,
Unique_Users_MAX Number(20,4) NOT NULL,
Unique_Users_STCNT varchar2(32) NOT NULL,
Unique_ClientIP_MIN Number(20,4) NOT NULL,
Unique_ClientIP_MAX Number(20,4) NOT NULL,
Unique_ClientIP_STCNT varchar2(32) NOT NULL,
Ms_AdminOperation_MIN Number(20,4) NOT NULL,
Ms_AdminOperation_MAX Number(20,4) NOT NULL,
Ms_AdminOperation_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOAdminActTest_TREND ADD constraint PK_EXOAdminActTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOAdminActTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOAdminActTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Total_Operations_MIN varchar2(256) NOT NULL,
Total_Operations_MAX varchar2(256) NOT NULL,
Unique_Operations_MIN varchar2(256) NOT NULL,
Unique_Operations_MAX varchar2(256) NOT NULL,
Unique_Users_MIN varchar2(256) NOT NULL,
Unique_Users_MAX varchar2(256) NOT NULL,
Unique_ClientIP_MIN varchar2(256) NOT NULL,
Unique_ClientIP_MAX varchar2(256) NOT NULL,
Ms_AdminOperation_MIN varchar2(256) NOT NULL,
Ms_AdminOperation_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOAdminActTest_THRESH ADD constraint PK_EXOAdminActTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOAdminActTest_THRESH ON EXOAdminActTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOAdminActTest ON EXOAdminActTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOAdminActTest ON EXOAdminActTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOMailBoxLocTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxLocTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
TOT_DATCENT Number(20,4) NOT NULL,
TOT_DATCENT_ST varchar2(32) NOT NULL,
UNIQ_LOC Number(20,4) NOT NULL,
UNIQ_LOC_ST varchar2(32) NOT NULL,
UNIQ_USR_LOC Number(20,4) NOT NULL,
UNIQ_USR_LOC_ST varchar2(32) NOT NULL);
CREATE INDEX IDX_EXOMailBoxLocTest ON EXOMailBoxLocTest(MSMT_TIME);
ALTER TABLE EXOMailBoxLocTest ADD constraint PK_EXOMailBoxLocTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMailBoxLocTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxLocTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
TOT_DATCENT_MIN Number(20,4) NOT NULL,
TOT_DATCENT_MAX Number(20,4) NOT NULL,
TOT_DATCENT_STCNT varchar2(32) NOT NULL,
UNIQ_LOC_MIN Number(20,4) NOT NULL,
UNIQ_LOC_MAX Number(20,4) NOT NULL,
UNIQ_LOC_STCNT varchar2(32) NOT NULL,
UNIQ_USR_LOC_MIN Number(20,4) NOT NULL,
UNIQ_USR_LOC_MAX Number(20,4) NOT NULL,
UNIQ_USR_LOC_STCNT varchar2(32) NOT NULL);
ALTER TABLE EXOMailBoxLocTest_TREND ADD constraint PK_EXOMailBoxLocTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMailBoxLocTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMailBoxLocTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
TOT_DATCENT_MIN varchar2(256) NOT NULL,
TOT_DATCENT_MAX varchar2(256) NOT NULL,
UNIQ_LOC_MIN varchar2(256) NOT NULL,
UNIQ_LOC_MAX varchar2(256) NOT NULL,
UNIQ_USR_LOC_MIN varchar2(256) NOT NULL,
UNIQ_USR_LOC_MAX varchar2(256) NOT NULL);
ALTER TABLE EXOMailBoxLocTest_THRESH ADD constraint PK_EXOMailBoxLocTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMailBoxLocTest_THRESH ON EXOMailBoxLocTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMailBoxLocTest ON EXOMailBoxLocTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMailBoxLocTest ON EXOMailBoxLocTest_TREND (MSMT_TIME,PERIOD);






DROP TABLE EXOSpamTest CASCADE CONSTRAINTS;
CREATE TABLE EXOSpamTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
INBOUND_SPAM Number(20,4) NOT NULL,
INBOUND_SPAM_ST varchar2(32) NOT NULL,
OUTBOUND_SPAM Number(20,4) NOT NULL,
OUTBOUND_SPAM_ST varchar2(32) NOT NULL,
INBOUND_SIZE Number(20,4) NOT NULL,
INBOUND_SIZE_ST varchar2(32) NOT NULL,
OUTBOUND_SIZE Number(20,4) NOT NULL,
OUTBOUND_SIZE_ST varchar2(32) NOT NULL,
UNIQUE_SND Number(20,4) NOT NULL,
UNIQUE_SND_ST varchar2(32) NOT NULL,
UNIQUE_REC Number(20,4) NOT NULL,
UNIQUE_REC_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOSpamTest ON EXOSpamTest(MSMT_TIME);
ALTER TABLE EXOSpamTest ADD constraint PK_EXOSpamTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOSpamTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOSpamTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
INBOUND_SPAM_MIN Number(20,4) NOT NULL,
INBOUND_SPAM_MAX Number(20,4) NOT NULL,
INBOUND_SPAM_STCNT varchar2(32) NOT NULL,
OUTBOUND_SPAM_MIN Number(20,4) NOT NULL,
OUTBOUND_SPAM_MAX Number(20,4) NOT NULL,
OUTBOUND_SPAM_STCNT varchar2(32) NOT NULL,
INBOUND_SIZE_MIN Number(20,4) NOT NULL,
INBOUND_SIZE_MAX Number(20,4) NOT NULL,
INBOUND_SIZE_STCNT varchar2(32) NOT NULL,
OUTBOUND_SIZE_MIN Number(20,4) NOT NULL,
OUTBOUND_SIZE_MAX Number(20,4) NOT NULL,
OUTBOUND_SIZE_STCNT varchar2(32) NOT NULL,
UNIQUE_SND_MIN Number(20,4) NOT NULL,
UNIQUE_SND_MAX Number(20,4) NOT NULL,
UNIQUE_SND_STCNT varchar2(32) NOT NULL,
UNIQUE_REC_MIN Number(20,4) NOT NULL,
UNIQUE_REC_MAX Number(20,4) NOT NULL,
UNIQUE_REC_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOSpamTest_TREND ADD constraint PK_EXOSpamTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOSpamTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOSpamTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
INBOUND_SPAM_MIN varchar2(256) NOT NULL,
INBOUND_SPAM_MAX varchar2(256) NOT NULL,
OUTBOUND_SPAM_MIN varchar2(256) NOT NULL,
OUTBOUND_SPAM_MAX varchar2(256) NOT NULL,
INBOUND_SIZE_MIN varchar2(256) NOT NULL,
INBOUND_SIZE_MAX varchar2(256) NOT NULL,
OUTBOUND_SIZE_MIN varchar2(256) NOT NULL,
OUTBOUND_SIZE_MAX varchar2(256) NOT NULL,
UNIQUE_SND_MIN varchar2(256) NOT NULL,
UNIQUE_SND_MAX varchar2(256) NOT NULL,
UNIQUE_REC_MIN varchar2(256) NOT NULL,
UNIQUE_REC_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOSpamTest_THRESH ADD constraint PK_EXOSpamTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOSpamTest_THRESH ON EXOSpamTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOSpamTest ON EXOSpamTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOSpamTest ON EXOSpamTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOMalwareTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMalwareTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Inbound_malware Number(20,4) NOT NULL,
Inbound_malware_ST varchar2(32) NOT NULL,
Outbound_malware Number(20,4) NOT NULL,
Outbound_malware_ST varchar2(32) NOT NULL,
INBOUND_SIZE Number(20,4) NOT NULL,
INBOUND_SIZE_ST varchar2(32) NOT NULL,
OUTBOUND_SIZE Number(20,4) NOT NULL,
OUTBOUND_SIZE_ST varchar2(32) NOT NULL,
UNIQUE_SND Number(20,4) NOT NULL,
UNIQUE_SND_ST varchar2(32) NOT NULL,
UNIQUE_REC Number(20,4) NOT NULL,
UNIQUE_REC_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOMalwareTest ON EXOMalwareTest(MSMT_TIME);
ALTER TABLE EXOMalwareTest ADD constraint PK_EXOMalwareTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMalwareTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMalwareTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Inbound_malware_MIN Number(20,4) NOT NULL,
Inbound_malware_MAX Number(20,4) NOT NULL,
Inbound_malware_STCNT varchar2(32) NOT NULL,
Outbound_malware_MIN Number(20,4) NOT NULL,
Outbound_malware_MAX Number(20,4) NOT NULL,
Outbound_malware_STCNT varchar2(32) NOT NULL,
INBOUND_SIZE_MIN Number(20,4) NOT NULL,
INBOUND_SIZE_MAX Number(20,4) NOT NULL,
INBOUND_SIZE_STCNT varchar2(32) NOT NULL,
OUTBOUND_SIZE_MIN Number(20,4) NOT NULL,
OUTBOUND_SIZE_MAX Number(20,4) NOT NULL,
OUTBOUND_SIZE_STCNT varchar2(32) NOT NULL,
UNIQUE_SND_MIN Number(20,4) NOT NULL,
UNIQUE_SND_MAX Number(20,4) NOT NULL,
UNIQUE_SND_STCNT varchar2(32) NOT NULL,
UNIQUE_REC_MIN Number(20,4) NOT NULL,
UNIQUE_REC_MAX Number(20,4) NOT NULL,
UNIQUE_REC_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOMalwareTest_TREND ADD constraint PK_EXOMalwareTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMalwareTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMalwareTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Inbound_malware_MIN varchar2(256) NOT NULL,
Inbound_malware_MAX varchar2(256) NOT NULL,
Outbound_malware_MIN varchar2(256) NOT NULL,
Outbound_malware_MAX varchar2(256) NOT NULL,
INBOUND_SIZE_MIN varchar2(256) NOT NULL,
INBOUND_SIZE_MAX varchar2(256) NOT NULL,
OUTBOUND_SIZE_MIN varchar2(256) NOT NULL,
OUTBOUND_SIZE_MAX varchar2(256) NOT NULL,
UNIQUE_SND_MIN varchar2(256) NOT NULL,
UNIQUE_SND_MAX varchar2(256) NOT NULL,
UNIQUE_REC_MIN varchar2(256) NOT NULL,
UNIQUE_REC_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOMalwareTest_THRESH ADD constraint PK_EXOMalwareTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMalwareTest_THRESH ON EXOMalwareTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMalwareTest ON EXOMalwareTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMalwareTest ON EXOMalwareTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXOTranRuleTest CASCADE CONSTRAINTS;
CREATE TABLE EXOTranRuleTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
TOTAL_HIT Number(20,4) NOT NULL,
TOTAL_HIT_ST varchar2(32) NOT NULL,
INBOUND_RULE Number(20,4) NOT NULL,
INBOUND_RULE_ST varchar2(32) NOT NULL,
OUTBOUND_RULE Number(20,4) NOT NULL,
OUTBOUND_RULE_ST varchar2(32) NOT NULL,
UNIQUE_SENDERS Number(20,4) NOT NULL,
UNIQUE_SENDERS_ST varchar2(32) NOT NULL,
UNIQUE_RECEIVERS Number(20,4) NOT NULL,
UNIQUE_RECEIVERS_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOTranRuleTest ON EXOTranRuleTest(MSMT_TIME);
ALTER TABLE EXOTranRuleTest ADD constraint PK_EXOTranRuleTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOTranRuleTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOTranRuleTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
TOTAL_HIT_MIN Number(20,4) NOT NULL,
TOTAL_HIT_MAX Number(20,4) NOT NULL,
TOTAL_HIT_STCNT varchar2(32) NOT NULL,
INBOUND_RULE_MIN Number(20,4) NOT NULL,
INBOUND_RULE_MAX Number(20,4) NOT NULL,
INBOUND_RULE_STCNT varchar2(32) NOT NULL,
OUTBOUND_RULE_MIN Number(20,4) NOT NULL,
OUTBOUND_RULE_MAX Number(20,4) NOT NULL,
OUTBOUND_RULE_STCNT varchar2(32) NOT NULL,
UNIQUE_SENDERS_MIN Number(20,4) NOT NULL,
UNIQUE_SENDERS_MAX Number(20,4) NOT NULL,
UNIQUE_SENDERS_STCNT varchar2(32) NOT NULL,
UNIQUE_RECEIVERS_MIN Number(20,4) NOT NULL,
UNIQUE_RECEIVERS_MAX Number(20,4) NOT NULL,
UNIQUE_RECEIVERS_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOTranRuleTest_TREND ADD constraint PK_EXOTranRuleTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOTranRuleTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOTranRuleTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
TOTAL_HIT_MIN varchar2(256) NOT NULL,
TOTAL_HIT_MAX varchar2(256) NOT NULL,
INBOUND_RULE_MIN varchar2(256) NOT NULL,
INBOUND_RULE_MAX varchar2(256) NOT NULL,
OUTBOUND_RULE_MIN varchar2(256) NOT NULL,
OUTBOUND_RULE_MAX varchar2(256) NOT NULL,
UNIQUE_SENDERS_MIN varchar2(256) NOT NULL,
UNIQUE_SENDERS_MAX varchar2(256) NOT NULL,
UNIQUE_RECEIVERS_MIN varchar2(256) NOT NULL,
UNIQUE_RECEIVERS_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOTranRuleTest_THRESH ADD constraint PK_EXOTranRuleTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOTranRuleTest_THRESH ON EXOTranRuleTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOTranRuleTest ON EXOTranRuleTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOTranRuleTest ON EXOTranRuleTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EXODlpTest CASCADE CONSTRAINTS;
CREATE TABLE EXODlpTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
DLP_DETECT Number(20,4) NOT NULL,
DLP_DETECT_ST varchar2(32) NOT NULL,
UNIQUE_SENDERS Number(20,4) NOT NULL,
UNIQUE_SENDERS_ST varchar2(32) NOT NULL,
UNIQUE_RECEIVER Number(20,4) NOT NULL,
UNIQUE_RECEIVER_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXODlpTest ON EXODlpTest(MSMT_TIME);
ALTER TABLE EXODlpTest ADD constraint PK_EXODlpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXODlpTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXODlpTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
DLP_DETECT_MIN Number(20,4) NOT NULL,
DLP_DETECT_MAX Number(20,4) NOT NULL,
DLP_DETECT_STCNT varchar2(32) NOT NULL,
UNIQUE_SENDERS_MIN Number(20,4) NOT NULL,
UNIQUE_SENDERS_MAX Number(20,4) NOT NULL,
UNIQUE_SENDERS_STCNT varchar2(32) NOT NULL,
UNIQUE_RECEIVER_MIN Number(20,4) NOT NULL,
UNIQUE_RECEIVER_MAX Number(20,4) NOT NULL,
UNIQUE_RECEIVER_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXODlpTest_TREND ADD constraint PK_EXODlpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXODlpTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXODlpTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
DLP_DETECT_MIN varchar2(256) NOT NULL,
DLP_DETECT_MAX varchar2(256) NOT NULL,
UNIQUE_SENDERS_MIN varchar2(256) NOT NULL,
UNIQUE_SENDERS_MAX varchar2(256) NOT NULL,
UNIQUE_RECEIVER_MIN varchar2(256) NOT NULL,
UNIQUE_RECEIVER_MAX varchar2(256) NOT NULL);

ALTER TABLE EXODlpTest_THRESH ADD constraint PK_EXODlpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXODlpTest_THRESH ON EXODlpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXODlpTest ON EXODlpTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXODlpTest ON EXODlpTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE EXONonOwnerActivtsTest CASCADE CONSTRAINTS;
CREATE TABLE EXONonOwnerActivtsTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Total_Operations Number(20,4) NOT NULL,
Total_Operations_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXONonOwnerActivtsTest ON EXONonOwnerActivtsTest(MSMT_TIME);
ALTER TABLE EXONonOwnerActivtsTest ADD constraint PK_EXONonOwnerActivtsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXONonOwnerActivtsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXONonOwnerActivtsTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Total_Operations_MIN Number(20,4) NOT NULL,
Total_Operations_MAX Number(20,4) NOT NULL,
Total_Operations_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXONonOwnerActivtsTest_TREND ADD constraint PK_EXONonOwnerActiTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXONonOwnerActivtsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXONonOwnerActivtsTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Total_Operations_MIN varchar2(256) NOT NULL,
Total_Operations_MAX varchar2(256) NOT NULL);

ALTER TABLE EXONonOwnerActivtsTest_THRESH ADD constraint PK_EXONonOwnerActiTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXONonOwnerActiTest_THRESH ON EXONonOwnerActivtsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXONonOwnerActivtsTest ON EXONonOwnerActivtsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXONonOwnerActivtsTest ON EXONonOwnerActivtsTest_TREND (MSMT_TIME,PERIOD);





DROP TABLE EXOownerActivtsTest CASCADE CONSTRAINTS;
CREATE TABLE EXOownerActivtsTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
Total_Operations Number(20,4) NOT NULL,
Total_Operations_ST varchar2(32) NOT NULL,
Unique_Users Number(20,4) NOT NULL,
Unique_Users_ST varchar2(32) NOT NULL,
Unique_Client_IPs Number(20,4) NOT NULL,
Unique_Client_IPs_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOownerActivtsTest ON EXOownerActivtsTest(MSMT_TIME);
ALTER TABLE EXOownerActivtsTest ADD constraint PK_EXOownerActivtsTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOownerActivtsTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOownerActivtsTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
Total_Operations_MIN Number(20,4) NOT NULL,
Total_Operations_MAX Number(20,4) NOT NULL,
Total_Operations_STCNT varchar2(32) NOT NULL,
Unique_Users_MIN Number(20,4) NOT NULL,
Unique_Users_MAX Number(20,4) NOT NULL,
Unique_Users_STCNT varchar2(32) NOT NULL,
Unique_Client_IPs_MIN Number(20,4) NOT NULL,
Unique_Client_IPs_MAX Number(20,4) NOT NULL,
Unique_Client_IPs_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOownerActivtsTest_TREND ADD constraint PK_EXOownerActivtsTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOownerActivtsTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOownerActivtsTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
Total_Operations_MIN varchar2(256) NOT NULL,
Total_Operations_MAX varchar2(256) NOT NULL,
Unique_Users_MIN varchar2(256) NOT NULL,
Unique_Users_MAX varchar2(256) NOT NULL,
Unique_Client_IPs_MIN varchar2(256) NOT NULL,
Unique_Client_IPs_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOownerActivtsTest_THRESH ADD constraint PK_EXOownerActivtsTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOownerActivtsTest_THRESH ON EXOownerActivtsTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOownerActivtsTest ON EXOownerActivtsTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOownerActivtsTest ON EXOownerActivtsTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE EXOMsgCenTest CASCADE CONSTRAINTS;
CREATE TABLE EXOMsgCenTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
MsgCenterCommunication Number(20,4) NOT NULL,
MsgCenterCommunication_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_EXOMsgCenTest ON EXOMsgCenTest(MSMT_TIME);
ALTER TABLE EXOMsgCenTest ADD constraint PK_EXOMsgCenTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE EXOMsgCenTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE EXOMsgCenTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
MsgCenterCommunication_MIN Number(20,4) NOT NULL,
MsgCenterCommunication_MAX Number(20,4) NOT NULL,
MsgCenterCommunication_STCNT varchar2(32) NOT NULL);

ALTER TABLE EXOMsgCenTest_TREND ADD constraint PK_EXOMsgCenTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE EXOMsgCenTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE EXOMsgCenTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
MsgCenterCommunication_MIN varchar2(256) NOT NULL,
MsgCenterCommunication_MAX varchar2(256) NOT NULL);

ALTER TABLE EXOMsgCenTest_THRESH ADD constraint PK_EXOMsgCenTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_EXOMsgCenTest_THRESH ON EXOMsgCenTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_EXOMsgCenTest ON EXOMsgCenTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_EXOMsgCenTest ON EXOMsgCenTest_TREND (MSMT_TIME,PERIOD);



DROP TABLE AsSysDBBkUpTest CASCADE CONSTRAINTS;
CREATE TABLE AsSysDBBkUpTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
BKUP Number(20,4) NOT NULL,
BKUP_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_AsSysDBBkUpTest ON AsSysDBBkUpTest(MSMT_TIME);
ALTER TABLE AsSysDBBkUpTest ADD constraint PK_AsSysDBBkUpTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AsSysDBBkUpTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE AsSysDBBkUpTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
BKUP_MIN Number(20,4) NOT NULL,
BKUP_MAX Number(20,4) NOT NULL,
BKUP_STCNT varchar2(32) NOT NULL);

ALTER TABLE AsSysDBBkUpTest_TREND ADD constraint PK_AsSysDBBkUpTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AsSysDBBkUpTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AsSysDBBkUpTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
BKUP_MIN VARCHAR2(256) NOT NULL,
BKUP_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AsSysDBBkUpTest_THRESH ADD constraint PK_AsSysDBBkUpTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AsSysDBBkUpTest_THRESH ON AsSysDBBkUpTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AsSysDBBkUpTest ON AsSysDBBkUpTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AsSysDBBkUpTest ON AsSysDBBkUpTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE AsSysDBSpaTest CASCADE CONSTRAINTS;
CREATE TABLE AsSysDBSpaTest(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
USED_SPACE Number(20,4) NOT NULL,
USED_SPACE_ST varchar2(32) NOT NULL,
FREE_SPACE Number(20,4) NOT NULL,
FREE_SPACE_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_AsSysDBSpaTest ON AsSysDBSpaTest(MSMT_TIME);
ALTER TABLE AsSysDBSpaTest ADD constraint PK_AsSysDBSpaTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE AsSysDBSpaTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE AsSysDBSpaTest_TREND(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128),
MSMT_HOST       varchar2(32),
MSMT_TIME       date,
PERIOD       	varchar2(32),
USED_SPACE_MIN Number(20,4) NOT NULL,
USED_SPACE_MAX Number(20,4) NOT NULL,
USED_SPACE_STCNT varchar2(32) NOT NULL,
FREE_SPACE_MIN Number(20,4) NOT NULL,
FREE_SPACE_MAX Number(20,4) NOT NULL,
FREE_SPACE_STCNT varchar2(32) NOT NULL);

ALTER TABLE AsSysDBSpaTest_TREND ADD constraint PK_AsSysDBSpaTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE AsSysDBSpaTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE AsSysDBSpaTest_THRESH(
TRGT_HOST       varchar2(32),
PORT_NO         varchar2(32),
SITE_NAME       varchar2(64),
INFO            varchar2(128)
,MSMT_HOST       varchar2(32),
MSMT_TIME_START date,
MSMT_TIME_END   date,
USED_SPACE_MIN VARCHAR2(256) NOT NULL,
USED_SPACE_MAX VARCHAR2(256) NOT NULL,
FREE_SPACE_MIN VARCHAR2(256) NOT NULL,
FREE_SPACE_MAX VARCHAR2(256) NOT NULL);

ALTER TABLE AsSysDBSpaTest_THRESH ADD constraint PK_AsSysDBSpaTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_AsSysDBSpaTest_THRESH ON AsSysDBSpaTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_AsSysDBSpaTest ON AsSysDBSpaTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_AsSysDBSpaTest ON AsSysDBSpaTest_TREND (MSMT_TIME,PERIOD);


DROP TABLE XMAppLaunchTest CASCADE CONSTRAINTS;
CREATE TABLE XMAppLaunchTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
SUCCESSFUL_APPLICATION NUMBER(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_ST varchar2(32) NOT NULL,
FAILED_APPLICATION NUMBER(20,4) NOT NULL,
FAILED_APPLICATION_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_XMAppLaunchTest ON XMAppLaunchTest(MSMT_TIME);
ALTER TABLE XMAppLaunchTest ADD constraint PK_XMAppLaunchTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE XMAppLaunchTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE XMAppLaunchTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
SUCCESSFUL_APPLICATION_MIN NUMBER(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_MAX NUMBER(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_STCNT varchar2(32) NOT NULL,
FAILED_APPLICATION_MIN NUMBER(20,4) NOT NULL,
FAILED_APPLICATION_MAX NUMBER(20,4) NOT NULL,
FAILED_APPLICATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE XMAppLaunchTest_TREND ADD constraint PK_XMAppLaunchTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE XMAppLaunchTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE XMAppLaunchTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
SUCCESSFUL_APPLICATION_MIN varchar2(256) NOT NULL,
SUCCESSFUL_APPLICATION_MAX varchar2(256) NOT NULL,
FAILED_APPLICATION_MIN varchar2(256) NOT NULL,
FAILED_APPLICATION_MAX varchar2(256) NOT NULL);

ALTER TABLE XMAppLaunchTest_THRESH ADD constraint PK_XMAppLaunchTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XMAppLaunchTest_THRESH ON XMAppLaunchTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_XMAppLaunchTest ON XMAppLaunchTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_XMAppLaunchTest ON XMAppLaunchTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE XMAppNameTest CASCADE CONSTRAINTS;
CREATE TABLE XMAppNameTest(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
SUCCESSFUL_APPLICATION NUMBER(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_ST varchar2(32) NOT NULL,
FAILED_APPLICATION NUMBER(20,4) NOT NULL,
FAILED_APPLICATION_ST varchar2(32) NOT NULL);

CREATE INDEX IDX_XMAppNameTest ON XMAppNameTest(MSMT_TIME);
ALTER TABLE XMAppNameTest ADD constraint PK_XMAppNameTest PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE XMAppNameTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE XMAppNameTest_TREND(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME       date NOT NULL,
PERIOD       	varchar2(32) NOT NULL,
SUCCESSFUL_APPLICATION_MIN NUMBER(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_MAX NUMBER(20,4) NOT NULL,
SUCCESSFUL_APPLICATION_STCNT varchar2(32) NOT NULL,
FAILED_APPLICATION_MIN NUMBER(20,4) NOT NULL,
FAILED_APPLICATION_MAX NUMBER(20,4) NOT NULL,
FAILED_APPLICATION_STCNT varchar2(32) NOT NULL);

ALTER TABLE XMAppNameTest_TREND ADD constraint PK_XMAppNameTest_TREND PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME,PERIOD);
DROP TABLE XMAppNameTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE XMAppNameTest_THRESH(
TRGT_HOST       varchar2(32) NOT NULL,
PORT_NO         varchar2(32) NOT NULL,
SITE_NAME       varchar2(64) NOT NULL,
INFO            varchar2(128) NOT NULL,
MSMT_HOST       varchar2(32) NOT NULL,
MSMT_TIME_START date NOT NULL,
MSMT_TIME_END   date NOT NULL,
SUCCESSFUL_APPLICATION_MIN varchar2(256) NOT NULL,
SUCCESSFUL_APPLICATION_MAX varchar2(256) NOT NULL,
FAILED_APPLICATION_MIN varchar2(256) NOT NULL,
FAILED_APPLICATION_MAX varchar2(256) NOT NULL);

ALTER TABLE XMAppNameTest_THRESH ADD constraint PK_XMAppNameTest_THRESH PRIMARY KEY(TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME_START);
CREATE INDEX IDX_XMAppNameTest_THRESH ON XMAppNameTest_THRESH (MSMT_HOST,MSMT_TIME_START,MSMT_TIME_END);
CREATE INDEX IDX_TH_XMAppNameTest ON XMAppNameTest_THRESH (MSMT_TIME_START);
CREATE INDEX IDX_TR_XMAppNameTest ON XMAppNameTest_TREND (MSMT_TIME,PERIOD);

DROP TABLE SapWasUserSessTest CASCADE CONSTRAINTS;
CREATE TABLE SapWasUserSessTest
(
	TRGT_HOST			varchar2(32),
	PORT_NO				varchar2(32),
	SITE_NAME			varchar2(64),
	INFO				varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME 			date,
	LoggedInUsers			NUMBER(20,4) NOT NULL,
	LoggedInUsers_ST			varchar2(32) NOT NULL,
	OpenedSessions			NUMBER(20,4) NOT NULL,
	OpenedSessions_ST			varchar2(32) NOT NULL,
	ActiveSessions			NUMBER(20,4) NOT NULL,
	ActiveSessions_ST			varchar2(32) NOT NULL,
	SecuritySessions			NUMBER(20,4) NOT NULL,
	SecuritySessions_ST			varchar2(32) NOT NULL,
	EjbSessions			NUMBER(20,4) NOT NULL,
	EjbSessions_ST			varchar2(32) NOT NULL
);
CREATE INDEX IDX_SapWasUserSessTest ON SapWasUserSessTest(MSMT_TIME);
ALTER TABLE SapWasUserSessTest ADD constraint PK_SapWasUserSessTest
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST, MSMT_TIME);
DROP TABLE   SapWasUserSessTest_TREND CASCADE CONSTRAINTS;
CREATE TABLE SapWasUserSessTest_TREND
(
	TRGT_HOST			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME       		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32), 
	MSMT_TIME			date,
	PERIOD 				varchar2(32),
	LoggedInUsers_MIN			NUMBER(20,4) NOT NULL,
	LoggedInUsers_MAX			NUMBER(20,4) NOT NULL,
	LoggedInUsers_STCNT			varchar2(32) NOT NULL,
	OpenedSessions_MIN			NUMBER(20,4) NOT NULL,
	OpenedSessions_MAX			NUMBER(20,4) NOT NULL,
	OpenedSessions_STCNT			varchar2(32) NOT NULL,
	ActiveSessions_MIN			NUMBER(20,4) NOT NULL,
	ActiveSessions_MAX			NUMBER(20,4) NOT NULL,
	ActiveSessions_STCNT			varchar2(32) NOT NULL,
	SecuritySessions_MIN			NUMBER(20,4) NOT NULL,
	SecuritySessions_MAX			NUMBER(20,4) NOT NULL,
	SecuritySessions_STCNT			varchar2(32) NOT NULL,
	EjbSessions_MIN			NUMBER(20,4) NOT NULL,
	EjbSessions_MAX			NUMBER(20,4) NOT NULL,
	EjbSessions_STCNT			varchar2(32) NOT NULL
);
ALTER TABLE SapWasUserSessTest_TREND ADD constraint PK_SapWasUserSessTest_TREND
PRIMARY KEY (TRGT_HOST,PORT_NO,SITE_NAME,INFO,MSMT_HOST,MSMT_TIME,PERIOD);
DROP TABLE   SapWasUserSessTest_THRESH CASCADE CONSTRAINTS;
CREATE TABLE SapWasUserSessTest_THRESH 
(
	TRGT_HOST 			varchar2(32),
	PORT_NO         		varchar2(32),
	SITE_NAME        		varchar2(64),
	INFO            		varchar2(128),
	MSMT_HOST 			varchar2(32),
	MSMT_TIME_START			date,
	MSMT_TIME_END   		date,
	LoggedInUsers_MIN			VARCHAR2(256)	 NOT NULL,
	LoggedInUsers_MAX	VARCHAR2(256)	 NOT NULL,
	OpenedSessions_MIN			VARCHAR2(256)	 NOT NULL,
	OpenedSessions_MAX	VARCHAR2(256)	 NOT NULL,
	ActiveSessions_MIN			VARCHAR2(256)	 NOT NULL,
	ActiveSess