/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.Task;
import java.util.Vector;

class TaskTimer
extends Thread {
    private static boolean done = true;
    private static Vector tasks = null;
    private static TaskTimer timer = null;

    public static synchronized void add(Task task) {
        task.nextRun = System.currentTimeMillis() + task.msPeriod;
        if (tasks == null) {
            tasks = new Vector();
        }
        tasks.addElement(task);
        TaskTimer.sortTasks(tasks);
        if (timer == null) {
            done = false;
            timer = new TaskTimer();
        }
    }

    public static synchronized void deschedule(Task task) {
        task.runner.done = true;
        task.runner.notifier();
        tasks.removeElement(task);
        if (tasks.size() == 0) {
            done = true;
            tasks = null;
            timer.notifier();
            timer = null;
        }
    }

    public TaskTimer() {
        this.setPriority(10);
        this.start();
    }

    public synchronized void run() {
        while (!done) {
            Task nextTask = (Task)tasks.elementAt(0);
            long nextRun = nextTask.nextRun;
            try {
                this.wait(nextRun - System.currentTimeMillis());
            }
            catch (InterruptedException interruptedException) {}
            if (done) break;
            long now = System.currentTimeMillis();
            int i = 0;
            while (i < tasks.size()) {
                Task task = (Task)tasks.elementAt(i);
                if (task.nextRun > now) break;
                task.runner.notifier();
                task.nextRun += task.msPeriod;
                ++i;
            }
            TaskTimer.sortTasks(tasks);
        }
    }

    private static void sortTasks(Vector tasks) {
        int i = 0;
        while (i < tasks.size() - i) {
            Task taski = (Task)tasks.elementAt(i);
            int j = i + 1;
            while (j < tasks.size()) {
                Task taskj = (Task)tasks.elementAt(j);
                if (taskj.nextRun < taski.nextRun) {
                    tasks.setElementAt(taskj, i);
                    tasks.setElementAt(taski, j);
                    taski = taskj;
                }
                ++j;
            }
            ++i;
        }
    }

    public synchronized void notifier() {
        this.notify();
    }
}

