/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.HtmlObserver;
import Acme.HtmlScanner;
import Acme.LruHashtable;
import Acme.NoRobots;
import Acme.Queue;
import Acme.SpiderConnection;
import Acme.SpiderItem;
import Acme.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Spider
implements HtmlObserver,
Enumeration {
    protected PrintStream err;
    protected Queue todo = new Queue();
    private int todoLimit;
    protected Hashtable done;
    private SpiderItem item;
    private URL thisUrl;
    private String auth_cookie;
    private Vector observers = new Vector();
    private NoRobots noRobots = new NoRobots("Acme.Spider");
    private boolean gotOne = false;

    public Spider(PrintStream err) {
        this.err = err;
        this.done = new Hashtable();
    }

    public Spider() {
        this(System.err);
    }

    public Spider(String urlStr, PrintStream err) throws MalformedURLException {
        this(err);
        this.addUrl(urlStr);
    }

    public Spider(String urlStr) throws MalformedURLException {
        this(urlStr, System.err);
    }

    public Spider(int todoLimit, int doneLimit, PrintStream err) {
        this.err = err;
        this.todoLimit = todoLimit;
        this.done = doneLimit == 0 ? new Hashtable() : new LruHashtable(doneLimit);
    }

    public Spider(int todoLimit, int doneLimit) {
        this(todoLimit, doneLimit, System.err);
    }

    public synchronized void addUrl(String urlStr) throws MalformedURLException {
        URL url = Utils.plainUrl(urlStr);
        String thisUrlStr = url.toExternalForm();
        String baseUrlStr = Utils.baseUrlStr(thisUrlStr);
        this.todo.addBack(new SpiderItem(thisUrlStr, null, 0, baseUrlStr));
    }

    public synchronized void setAuth(String auth_cookie) {
        this.auth_cookie = auth_cookie;
    }

    public synchronized void addObserver(HtmlObserver observer) {
        this.observers.addElement(observer);
    }

    protected boolean doThisUrl(String thisUrlStr, int depth, String baseUrlStr) {
        return thisUrlStr.startsWith(baseUrlStr);
    }

    protected void brokenLink(String fromUrlStr, String toUrlStr, String errmsg) {
        this.err.println("Broken link in " + fromUrlStr);
        this.err.println("    pointing to " + toUrlStr);
        this.err.println("    " + errmsg);
    }

    protected void reportError(String fromUrlStr, String toUrlStr, String errmsg) {
        this.err.println("Error in " + fromUrlStr);
        this.err.println("    pointing to " + toUrlStr);
        this.err.println("    " + errmsg);
    }

    private synchronized void getOne() {
        while (!this.todo.isEmpty()) {
            this.item = (SpiderItem)this.todo.getFront();
            if (this.done.containsKey(this.item.thisUrlStr)) continue;
            this.done.put(this.item.thisUrlStr, this.item.thisUrlStr);
            try {
                this.thisUrl = new URL(this.item.thisUrlStr);
                if (!this.noRobots.ok(this.thisUrl)) continue;
                this.gotOne = true;
                return;
            }
            catch (MalformedURLException e) {
                String msg = e.getMessage();
                if (!Spider.checkMalformedURL(msg)) continue;
                this.brokenLink(this.myUrlToString(this.item.fromUrl), this.item.thisUrlStr, msg);
            }
            catch (Exception e) {
                this.reportError(this.myUrlToString(this.item.fromUrl), this.item.thisUrlStr, e.toString());
            }
        }
        this.gotOne = false;
    }

    private static boolean checkMalformedURL(String msg) {
        String protocol;
        return !msg.startsWith("unknown protocol: ") || !(protocol = msg.substring(msg.lastIndexOf(32) + 1)).equalsIgnoreCase("gopher") && !protocol.equalsIgnoreCase("ftp") && !protocol.equalsIgnoreCase("file") && !protocol.equalsIgnoreCase("telnet") && !protocol.equalsIgnoreCase("news") && !protocol.equalsIgnoreCase("mailto") && !protocol.equalsIgnoreCase("javascript");
    }

    public synchronized boolean hasMoreElements() {
        if (!this.gotOne) {
            this.getOne();
        }
        return this.gotOne;
    }

    public synchronized Object nextElement() {
        if (!this.gotOne) {
            this.getOne();
        }
        if (!this.gotOne) {
            return null;
        }
        this.gotOne = false;
        SpiderItem localItem = this.item;
        URL localThisUrl = this.thisUrl;
        try {
            URLConnection uc = localThisUrl.openConnection();
            if (this.auth_cookie != null) {
                uc.setRequestProperty("Authorization", "Basic " + Utils.base64Encode(this.auth_cookie));
            }
            uc.connect();
            InputStream s = uc.getInputStream();
            String contentType = uc.getContentType();
            if (contentType != null && contentType.equals("text/html")) {
                HtmlScanner scanner = new HtmlScanner(s, localThisUrl, this, localItem);
                Enumeration en = this.observers.elements();
                while (en.hasMoreElements()) {
                    HtmlObserver observer = (HtmlObserver)en.nextElement();
                    scanner.addObserver(observer);
                }
                SpiderConnection asc = new SpiderConnection(uc, scanner);
                return asc;
            }
            return uc;
        }
        catch (FileNotFoundException e) {
            this.brokenLink(this.myUrlToString(localItem.fromUrl), localItem.thisUrlStr, e.getMessage());
        }
        catch (UnknownHostException e) {
            this.brokenLink(this.myUrlToString(localItem.fromUrl), localItem.thisUrlStr, "unknown host -- " + e.getMessage());
        }
        catch (Exception e) {
            this.reportError(this.myUrlToString(localItem.fromUrl), localItem.thisUrlStr, e.toString());
        }
        return null;
    }

    private String myUrlToString(URL url) {
        if (url == null) {
            return "an initial URL";
        }
        return url.toExternalForm();
    }

    public void gotAHREF(String urlStr, URL contextUrl, Object clientData) {
        this.add(urlStr, contextUrl, (SpiderItem)clientData);
    }

    public void gotIMGSRC(String urlStr, URL contextUrl, Object clientData) {
        this.add(urlStr, contextUrl, (SpiderItem)clientData);
    }

    public void gotFRAMESRC(String urlStr, URL contextUrl, Object clientData) {
        this.add(urlStr, contextUrl, (SpiderItem)clientData);
    }

    public void gotBASEHREF(String urlStr, URL contextUrl, Object clientData) {
    }

    public void gotAREAHREF(String urlStr, URL contextUrl, Object clientData) {
        this.add(urlStr, contextUrl, (SpiderItem)clientData);
    }

    public void gotLINKHREF(String urlStr, URL contextUrl, Object clientData) {
        this.add(urlStr, contextUrl, (SpiderItem)clientData);
    }

    public void gotBODYBACKGROUND(String urlStr, URL contextUrl, Object clientData) {
        this.add(urlStr, contextUrl, (SpiderItem)clientData);
    }

    private void add(String urlStr, URL contextUrl, SpiderItem item) {
        block3: {
            try {
                URL url = Utils.plainUrl(contextUrl, urlStr);
                urlStr = url.toExternalForm();
                this.addOne(urlStr, contextUrl, item);
                String rootUrlStr = new URL(new URL(urlStr), "/").toExternalForm();
                while (urlStr.length() > rootUrlStr.length()) {
                    int lastSlash = urlStr.lastIndexOf(47, urlStr.length() - 2);
                    urlStr = urlStr.substring(0, lastSlash + 1);
                    this.addOne(urlStr, contextUrl, item);
                }
            }
            catch (MalformedURLException e) {
                String msg = e.getMessage();
                if (!Spider.checkMalformedURL(msg)) break block3;
                this.brokenLink(this.myUrlToString(contextUrl), urlStr, msg);
            }
        }
    }

    private void addOne(String urlStr, URL contextUrl, SpiderItem item) {
        if (!this.done.containsKey(urlStr) && this.doThisUrl(urlStr, item.depth + 1, item.baseUrlStr) && (this.todoLimit == 0 || this.todo.size() < this.todoLimit)) {
            this.todo.addBack(new SpiderItem(urlStr, contextUrl, item.depth + 1, item.baseUrlStr));
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: Spider URL");
            return;
        }
        try {
            as = new Spider(args[0], System.err);
            if (true) ** GOTO lbl25
        }
        catch (MalformedURLException e) {
            System.err.println(e);
            return;
        }
        do {
            uc = (URLConnection)as.nextElement();
            thisUrl = uc.getURL();
            thisUrlStr = thisUrl.toExternalForm();
            mimeType = uc.getContentType();
            bytes = 0;
            try {
                s = uc.getInputStream();
                while (s.read() != -1) {
                    ++bytes;
                }
                s.close();
            }
            catch (IOException v0) {}
            System.out.println(String.valueOf(thisUrlStr) + " " + mimeType + " " + bytes);
lbl25:
            // 2 sources

        } while (as.hasMoreElements());
    }
}

