/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.servlet.ServletException;
import Acme.Serve.servlet.ServletInputStream;
import Acme.Serve.servlet.ServletOutputStream;
import Acme.Serve.servlet.http.HttpServlet;
import Acme.Serve.servlet.http.HttpServletRequest;
import Acme.Serve.servlet.http.HttpServletResponse;
import Acme.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class CgiServlet
extends HttpServlet {
    public String getServletInfo() {
        return "runs CGI programs";
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!req.getMethod().equalsIgnoreCase("get") && !req.getMethod().equalsIgnoreCase("post")) {
            res.sendError(501);
            return;
        }
        String path = req.getServletPath();
        if (path == null || path.charAt(0) != '/') {
            res.sendError(400);
            return;
        }
        if (path.indexOf("/../") != -1 || path.endsWith("/..")) {
            res.sendError(403);
            return;
        }
        String pathname = path.substring(1);
        if (pathname.length() == 0) {
            pathname = "./";
        }
        this.dispatchPathname(req, res, path, pathname);
    }

    private void dispatchPathname(HttpServletRequest req, HttpServletResponse res, String path, String pathname) throws IOException {
        File file;
        String filename = pathname.replace('/', File.separatorChar);
        if (filename.charAt(filename.length() - 1) == File.separatorChar) {
            filename = filename.substring(0, filename.length() - 1);
        }
        if ((file = new File(filename = this.getServletContext().getRealPath(filename))).exists()) {
            this.serveFile(req, res, path, filename, file);
        } else {
            res.sendError(404);
        }
    }

    private void serveFile(HttpServletRequest req, HttpServletResponse res, String path, String filename, File file) throws IOException {
        String queryString = req.getQueryString();
        int contentLength = req.getContentLength();
        this.log("running " + path);
        Vector<String> argVec = new Vector<String>();
        argVec.addElement(filename);
        if (queryString != null && queryString.indexOf("=") == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(queryString, "+");
            while (stringTokenizer.hasMoreElements()) {
                argVec.addElement((String)stringTokenizer.nextElement());
            }
        }
        String[] argList = CgiServlet.makeList(argVec);
        Vector<String> envVec = new Vector<String>();
        envVec.addElement(CgiServlet.makeEnv("PATH", "/usr/local/bin:/usr/ucb:/bin:/usr/bin"));
        envVec.addElement(CgiServlet.makeEnv("GATEWAY_INTERFACE", "CGI/1.1"));
        envVec.addElement(CgiServlet.makeEnv("SERVER_SOFTWARE", this.getServletContext().getServerInfo()));
        envVec.addElement(CgiServlet.makeEnv("SERVER_NAME", req.getServerName()));
        envVec.addElement(CgiServlet.makeEnv("SERVER_PORT", Integer.toString(req.getServerPort())));
        envVec.addElement(CgiServlet.makeEnv("REMOTE_ADDR", req.getRemoteAddr()));
        envVec.addElement(CgiServlet.makeEnv("REMOTE_HOST", req.getRemoteHost()));
        envVec.addElement(CgiServlet.makeEnv("REQUEST_METHOD", req.getMethod()));
        if (contentLength != -1) {
            envVec.addElement(CgiServlet.makeEnv("CONTENT_LENGTH", Integer.toString(contentLength)));
        }
        if (req.getContentType() != null) {
            envVec.addElement(CgiServlet.makeEnv("CONTENT_TYPE", req.getContentType()));
        }
        envVec.addElement(CgiServlet.makeEnv("SCRIPT_NAME", req.getServletPath()));
        if (req.getPathInfo() != null) {
            envVec.addElement(CgiServlet.makeEnv("PATH_INFO", req.getPathInfo()));
        }
        if (req.getPathTranslated() != null) {
            envVec.addElement(CgiServlet.makeEnv("PATH_TRANSLATED", req.getPathTranslated()));
        }
        if (queryString != null) {
            envVec.addElement(CgiServlet.makeEnv("QUERY_STRING", queryString));
        }
        envVec.addElement(CgiServlet.makeEnv("SERVER_PROTOCOL", req.getProtocol()));
        if (req.getRemoteUser() != null) {
            envVec.addElement(CgiServlet.makeEnv("REMOTE_USER", req.getRemoteUser()));
        }
        if (req.getAuthType() != null) {
            envVec.addElement(CgiServlet.makeEnv("AUTH_TYPE", req.getAuthType()));
        }
        Enumeration enumeration = req.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = req.getHeader(name);
            if (value == null) {
                value = "";
            }
            envVec.addElement(CgiServlet.makeEnv("HTTP_" + name.toUpperCase().replace('-', '_'), value));
        }
        String[] envList = CgiServlet.makeList(envVec);
        Process proc = Runtime.getRuntime().exec(argList, envList);
        try {
            String line;
            if (req.getMethod().equalsIgnoreCase("post")) {
                ServletInputStream reqIn = req.getInputStream();
                OutputStream procOut = proc.getOutputStream();
                int i = 0;
                while (i < contentLength) {
                    int c = reqIn.read();
                    if (c == -1) break;
                    procOut.write(c);
                    ++i;
                }
                procOut.close();
            }
            BufferedReader procIn = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            ServletOutputStream resOut = res.getOutputStream();
            boolean firstLine = true;
            block19: while ((line = procIn.readLine()) != null && !(line = line.trim()).equals("")) {
                int colon = line.indexOf(":");
                if (colon == -1) {
                    if (!firstLine) continue;
                    StringTokenizer tok = new StringTokenizer(line, " ");
                    try {
                        switch (tok.countTokens()) {
                            default: {
                                continue block19;
                            }
                            case 2: {
                                tok.nextToken();
                                res.setStatus(Integer.parseInt(tok.nextToken()));
                                continue block19;
                            }
                            case 3: 
                        }
                        tok.nextToken();
                        res.setStatus(Integer.parseInt(tok.nextToken()), tok.nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                String name = line.substring(0, colon);
                String value = line.substring(colon + 1).trim();
                if (name.equalsIgnoreCase("Status")) {
                    StringTokenizer tok = new StringTokenizer(value, " ");
                    try {
                        switch (tok.countTokens()) {
                            default: {
                                continue block19;
                            }
                            case 1: {
                                res.setStatus(Integer.parseInt(tok.nextToken()));
                                continue block19;
                            }
                            case 2: 
                        }
                        res.setStatus(Integer.parseInt(tok.nextToken()), tok.nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equalsIgnoreCase("Content-type")) {
                    res.setContentType(value);
                    continue;
                }
                if (name.equalsIgnoreCase("Content-length")) {
                    try {
                        res.setContentLength(Integer.parseInt(value));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equalsIgnoreCase("Location")) {
                    res.setStatus(302);
                    res.setHeader(name, value);
                    continue;
                }
                res.setHeader(name, value);
            }
            Utils.copyStream((Reader)procIn, (OutputStream)resOut);
            procIn.close();
            resOut.close();
        }
        catch (IOException iOException) {}
    }

    private static String makeEnv(String name, String value) {
        return String.valueOf(name) + "=" + value;
    }

    private static String[] makeList(Vector vec) {
        String[] list = new String[vec.size()];
        int i = 0;
        while (i < vec.size()) {
            list[i] = (String)vec.elementAt(i);
            ++i;
        }
        return list;
    }
}

