/*
 * Decompiled with CFR 0.152.
 */
package Acme.Nnrpd;

import Acme.Fmt;
import Acme.Nnrpd.ArticleCache;
import Acme.Nnrpd.CrLfOutputStream;
import Acme.Nnrpd.NewsDb;
import Acme.Nnrpd.NewsDbArticle;
import Acme.Nnrpd.NewsDbException;
import Acme.Nnrpd.NewsDbGroup;
import Acme.Nnrpd.Nnrpd;
import Acme.Nnrpd.NnrpdException;
import Acme.Nnrpd.NnrpdUtils;
import Acme.TimeKiller;
import Acme.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;

class NnrpdSession
implements Runnable {
    private static String[] overviewFmt = new String[]{"Subject", "From", "Date", "Message-ID", "References", "Bytes", "Lines"};
    private Nnrpd nnrpd;
    private NewsDb newsDb;
    private boolean newsDbPostingOk;
    private ArticleCache articleCache;
    private Socket socket;
    private String clientHost;
    private DataInputStream din;
    private PrintStream pout;
    private NewsDbGroup currentGroup;
    private int currentArtNum = -1;
    private long startTime = System.currentTimeMillis();
    private int groupCount;
    private int artCount;
    private int postsOk;
    private int postsBad;
    private int groupArts;
    private String user;
    private String pass;

    public NnrpdSession(Nnrpd nnrpd, NewsDb newsDb, boolean newsDbPostingOk, ArticleCache articleCache, Socket socket) {
        this.nnrpd = nnrpd;
        this.newsDb = newsDb;
        this.newsDbPostingOk = newsDbPostingOk;
        this.articleCache = articleCache;
        this.socket = socket;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        try {
            this.clientHost = this.socket.getInetAddress().getHostName();
            this.notice(String.valueOf(this.clientHost) + " connect");
            try {
                this.din = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                this.pout = new PrintStream(new CrLfOutputStream(new BufferedOutputStream(this.socket.getOutputStream())));
            }
            catch (IOException e) {
                this.warning(String.valueOf(this.clientHost) + " problem getting streams: " + e);
                return;
            }
            this.handleSession();
            try {
                this.din.close();
                this.pout.flush();
                this.pout.close();
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
        catch (NnrpdException e) {
            System.err.println("uncaught exception: " + e);
        }
    }

    private void handleSession() throws NnrpdException {
        if (this.newsDbPostingOk) {
            this.response("200 Acme.Nnrpd v0.95 of 19dec96 ready - posting allowed");
        } else {
            this.response("201 Acme.Nnrpd v0.95 of 19dec96 ready - no posting allowed");
        }
        TimeKiller tk = new TimeKiller(900000L);
        while (true) {
            String commandLine;
            this.pout.flush();
            tk.reset();
            try {
                commandLine = this.din.readLine();
            }
            catch (IOException e) {
                this.warning(String.valueOf(this.clientHost) + " problem reading command: " + e);
                break;
            }
            this.debug(String.valueOf(this.clientHost) + " < " + commandLine);
            try {
                if (commandLine == null) {
                    this.cmdQuit(null);
                    break;
                }
                int ws = Utils.strCSpan(commandLine, " \t");
                String command = commandLine.substring(0, ws);
                String[] args = Utils.splitStr(commandLine.substring(ws).trim());
                if (command.equalsIgnoreCase("ARTICLE")) {
                    this.cmdArticle(args);
                    continue;
                }
                if (command.equalsIgnoreCase("AUTHINFO")) {
                    this.cmdAuthinfo(args);
                    continue;
                }
                if (command.equalsIgnoreCase("BODY")) {
                    this.cmdBody(args);
                    continue;
                }
                if (command.equalsIgnoreCase("DATE")) {
                    this.cmdDate(args);
                    continue;
                }
                if (command.equalsIgnoreCase("GROUP")) {
                    this.cmdGroup(args);
                    continue;
                }
                if (command.equalsIgnoreCase("HEAD")) {
                    this.cmdHead(args);
                    continue;
                }
                if (command.equalsIgnoreCase("HELP")) {
                    this.cmdHelp(args);
                    continue;
                }
                if (command.equalsIgnoreCase("LAST")) {
                    this.cmdLast(args);
                    continue;
                }
                if (command.equalsIgnoreCase("LIST")) {
                    this.cmdList(args);
                    continue;
                }
                if (command.equalsIgnoreCase("LISTGROUP")) {
                    this.cmdListgroup(args);
                    continue;
                }
                if (command.equalsIgnoreCase("MODE") || command.equalsIgnoreCase("XMODE")) {
                    this.cmdMode(args);
                    continue;
                }
                if (command.equalsIgnoreCase("NEWGROUPS")) {
                    this.cmdNewgroups(args);
                    continue;
                }
                if (command.equalsIgnoreCase("NEWNEWS")) {
                    this.cmdNewnews(args);
                    continue;
                }
                if (command.equalsIgnoreCase("NEXT")) {
                    this.cmdNext(args);
                    continue;
                }
                if (command.equalsIgnoreCase("POST")) {
                    this.cmdPost(args);
                    continue;
                }
                if (command.equalsIgnoreCase("QUIT")) {
                    this.cmdQuit(args);
                    break;
                }
                if (command.equalsIgnoreCase("SLAVE")) {
                    this.cmdSlave(args);
                    continue;
                }
                if (command.equalsIgnoreCase("STAT")) {
                    this.cmdStat(args);
                    continue;
                }
                if (command.equalsIgnoreCase("XGTITLE")) {
                    this.cmdXgtitle(args);
                    continue;
                }
                if (command.equalsIgnoreCase("XHDR")) {
                    this.cmdXhdr(args);
                    continue;
                }
                if (command.equalsIgnoreCase("XOVER")) {
                    this.cmdXover(args);
                    continue;
                }
                this.notice(String.valueOf(this.clientHost) + " unrecognized " + commandLine);
                this.response("500 command not recognized");
            }
            catch (NewsDbException e) {
                this.warning(String.valueOf(this.clientHost) + " " + e);
                this.response("503 program fault - command not performed: " + e);
            }
            catch (NnrpdException e) {
                this.warning(String.valueOf(this.clientHost) + " " + e);
                this.response("503 program fault - command not performed: " + e);
            }
        }
        tk.done();
    }

    private void cmdArticle(String[] args) throws NewsDbException, NnrpdException {
        this.cmdAhbs(args, 'a');
    }

    private void cmdAuthinfo(String[] args) throws NewsDbException, NnrpdException {
        if (args.length != 2) {
            this.response("501 command syntax error");
            return;
        }
        if (args[0].equalsIgnoreCase("user")) {
            this.user = args[1];
            this.response("381 AUTHINFO PASS required");
        } else if (args[0].equalsIgnoreCase("pass")) {
            if (this.user == null) {
                this.response("482 AUTHINFO USER required");
            } else if (this.newsDb.authorize(this.user, this.pass)) {
                this.response("281 authentication ok");
            } else {
                this.response("502 authentication failed");
            }
        } else {
            this.response("501 command syntax error");
        }
    }

    private void cmdBody(String[] args) throws NewsDbException, NnrpdException {
        this.cmdAhbs(args, 'b');
    }

    private void cmdDate(String[] args) throws NewsDbException, NnrpdException {
        if (args.length != 0) {
            this.response("501 command syntax error");
            return;
        }
        Date date = new Date();
        String gmtStr = date.toGMTString();
        String[] strArr = Utils.splitStr(gmtStr);
        int day = Integer.parseInt(strArr[0]);
        String months = "JanFebMarAprMayJunJulAugSepOctNovDec";
        int month = months.indexOf(strArr[1]) / 3 + 1;
        int year = Integer.parseInt(strArr[2]);
        int hour = Integer.parseInt(strArr[3].substring(0, 2));
        int minute = Integer.parseInt(strArr[3].substring(3, 5));
        int second = Integer.parseInt(strArr[3].substring(6, 8));
        this.response("111 " + Fmt.fmt(year, 4, 1) + Fmt.fmt(month, 2, 1) + Fmt.fmt(day, 2, 1) + Fmt.fmt(hour, 2, 1) + Fmt.fmt(minute, 2, 1) + Fmt.fmt(second, 2, 1));
    }

    private void cmdGroup(String[] args) throws NewsDbException, NnrpdException {
        if (args.length != 1) {
            this.response("501 command syntax error");
            return;
        }
        NewsDbGroup group = this.newsDb.getGroup(args[0]);
        if (group == null) {
            this.response("411 no such news group");
        } else {
            this.groupLog();
            this.currentGroup = group;
            this.currentArtNum = this.currentGroup.getFirstArtNum();
            this.response("211 " + this.currentGroup.getNumArts() + " " + this.currentArtNum + " " + this.currentGroup.getLastArtNum() + " " + this.currentGroup.getName());
        }
    }

    private void cmdHead(String[] args) throws NewsDbException, NnrpdException {
        this.cmdAhbs(args, 'h');
    }

    private void cmdHelp(String[] args) throws NewsDbException, NnrpdException {
        this.response("100 help text follows");
        this.pout.println("ARTICLE [<messageid>|number]");
        this.pout.println("AUTHINFO user name|pass password");
        this.pout.println("BODY [<messageid>|number]");
        this.pout.println("DATE");
        this.pout.println("GROUP newsgroup");
        this.pout.println("HEAD [<messageid>|number]");
        this.pout.println("HELP");
        this.pout.println("LAST");
        this.pout.println("LIST [active|newsgroups|distributions|schema] [group_pattern]");
        this.pout.println("LISTGROUP newsgroup");
        this.pout.println("MODE reader");
        this.pout.println("NEWGROUPS yymmdd hhmmss [GMT] [distributions]");
        this.pout.println("NEWNEWS newsgroups yymmdd hhmmss [GMT] [distributions]");
        this.pout.println("NEXT");
        this.pout.println("POST");
        this.pout.println("QUIT");
        this.pout.println("SLAVE");
        this.pout.println("STAT [<messageid>|number]");
        this.pout.println("XGTITLE [group_pattern]");
        this.pout.println("XHDR header [range|<messageid>]");
        this.pout.println("XOVER [range]");
        this.pout.println(".");
    }

    private void cmdLast(String[] args) throws NewsDbException, NnrpdException {
        if (args.length != 0) {
            this.response("501 command syntax error");
            return;
        }
        if (this.currentGroup == null) {
            this.response("412 no current newsgroup has been selected");
        } else if (this.currentArtNum == -1) {
            this.response("420 no current article has been selected");
        } else {
            int artNum = this.currentArtNum;
            while (--artNum >= this.currentGroup.getFirstArtNum()) {
                NewsDbArticle article = this.getArticle(this.currentGroup, artNum);
                if (article == null) continue;
                this.currentArtNum = artNum;
                this.sendAhbs(article, this.currentArtNum, 's');
                return;
            }
            this.response("422 no previous article in this group");
        }
    }

    private void cmdList(String[] args) throws NewsDbException, NnrpdException {
        if (args.length > 2) {
            this.response("501 command syntax error");
            return;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("active")) {
            this.response("215 list of newsgroups follows");
            Enumeration en = this.newsDb.getGroups();
            while (en.hasMoreElements()) {
                NewsDbGroup group = (NewsDbGroup)en.nextElement();
                if (args.length == 2 && !Utils.match(args[1], group.getName())) continue;
                this.sendGroup(group);
            }
            this.pout.println(".");
        } else if (args[0].equalsIgnoreCase("active.times")) {
            this.response("500 command not implemented");
        } else if (args[0].equalsIgnoreCase("newsgroups")) {
            this.response("215 list of descriptions follows");
            Enumeration en = this.newsDb.getGroups();
            while (en.hasMoreElements()) {
                String description;
                NewsDbGroup group = (NewsDbGroup)en.nextElement();
                String groupName = group.getName();
                if (args.length == 2 && !Utils.match(args[1], groupName) || (description = group.getDescription()) == null) continue;
                this.pout.println(String.valueOf(groupName) + "\t" + group.getDescription());
            }
            this.pout.println(".");
        } else if (args[0].equalsIgnoreCase("distributions")) {
            this.response("500 command not implemented");
        } else if (args[0].equalsIgnoreCase("distrib.pats")) {
            this.response("500 command not implemented");
        } else if (args[0].equalsIgnoreCase("schema") || args[0].equalsIgnoreCase("overview.fmt")) {
            this.response("215 Order of fields in overview database");
            int i = 0;
            while (i < overviewFmt.length) {
                this.pout.println(String.valueOf(overviewFmt[i]) + ":");
                ++i;
            }
            this.pout.println(".");
        } else {
            this.response("501 command syntax error");
        }
    }

    private void cmdListgroup(String[] args) throws NewsDbException, NnrpdException {
        if (args.length != 1) {
            this.response("501 command syntax error");
            return;
        }
        NewsDbGroup group = this.newsDb.getGroup(args[0]);
        if (group == null) {
            this.response("411 no such news group");
        } else {
            this.groupLog();
            this.currentGroup = group;
            this.currentArtNum = this.currentGroup.getFirstArtNum();
            this.response("211 article list follows");
            int artNum = this.currentGroup.getFirstArtNum();
            while (artNum <= this.currentGroup.getLastArtNum()) {
                this.pout.println(artNum);
                ++artNum;
            }
            this.pout.println(".");
        }
    }

    private void cmdMode(String[] args) throws NewsDbException, NnrpdException {
        if (args.length != 1) {
            this.response("501 command syntax error");
            return;
        }
        if (args[0].equalsIgnoreCase("reader")) {
            this.response("200 reading mode acknowledged");
        } else {
            this.response("501 command syntax error");
        }
    }

    private void cmdNewgroups(String[] args) throws NewsDbException, NnrpdException {
        long since;
        if (args.length < 2 || args.length > 4) {
            this.response("501 command syntax error");
            return;
        }
        String date = args[0];
        String time = args[1];
        boolean gmt = false;
        String distsPat = null;
        if (args.length >= 3) {
            if (args[2].equalsIgnoreCase("GMT")) {
                gmt = true;
                if (args.length == 4) {
                    distsPat = args[3];
                }
            } else {
                if (args.length == 4) {
                    this.response("501 command syntax error");
                    return;
                }
                distsPat = args[4];
            }
        }
        if ((since = NnrpdUtils.rfc977DateTime(date, time, gmt, -1L)) == -1L) {
            this.response("501 command syntax error");
            return;
        }
        this.response("231 list of new newsgroups follows");
        Enumeration en = distsPat == null ? this.newsDb.getGroups(since) : this.newsDb.getGroups(since, distsPat);
        while (en.hasMoreElements()) {
            NewsDbGroup group = (NewsDbGroup)en.nextElement();
            this.sendGroup(group);
        }
        this.pout.println(".");
    }

    private void cmdNewnews(String[] args) throws NewsDbException, NnrpdException {
        long since;
        if (args.length < 3 || args.length > 5) {
            this.response("501 command syntax error");
            return;
        }
        String groupsPat = args[0];
        String date = args[1];
        String time = args[2];
        boolean gmt = false;
        String distsPat = null;
        if (args.length >= 4) {
            if (args[3].equalsIgnoreCase("GMT")) {
                gmt = true;
                if (args.length == 5) {
                    distsPat = args[4];
                }
            } else {
                if (args.length == 5) {
                    this.response("501 command syntax error");
                    return;
                }
                distsPat = args[5];
            }
        }
        if ((since = NnrpdUtils.rfc977DateTime(date, time, gmt, -1L)) == -1L) {
            this.response("501 command syntax error");
            return;
        }
        this.notice(String.valueOf(this.clientHost) + " newnews " + groupsPat + " " + date + " " + time + " " + (gmt ? "GMT" : "local") + (distsPat != null ? distsPat : "none"));
        this.response("230 list of new articles by message-id follows");
        Enumeration en = distsPat == null ? this.newsDb.getMessageIds(groupsPat, since) : this.newsDb.getMessageIds(groupsPat, since, distsPat);
        while (en.hasMoreElements()) {
            String messageId = (String)en.nextElement();
            this.pout.println(messageId);
        }
        this.pout.println(".");
    }

    private void cmdNext(String[] args) throws NewsDbException, NnrpdException {
        if (args.length != 0) {
            this.response("501 command syntax error");
            return;
        }
        if (this.currentGroup == null) {
            this.response("412 no current newsgroup has been selected");
        } else if (this.currentArtNum == -1) {
            this.response("420 no current article has been selected");
        } else {
            int artNum = this.currentArtNum;
            while (++artNum <= this.currentGroup.getLastArtNum()) {
                NewsDbArticle article = this.getArticle(this.currentGroup, artNum);
                if (article == null) continue;
                this.currentArtNum = artNum;
                this.sendAhbs(article, this.currentArtNum, 's');
                return;
            }
            this.response("421 no next article in this group");
        }
    }

    private void cmdPost(String[] args) throws NewsDbException, NnrpdException {
        String text;
        if (args.length != 0) {
            this.response("501 command syntax error");
            return;
        }
        if (!this.newsDb.getPostingOk()) {
            this.notice(String.valueOf(this.clientHost) + " noperm post without permission");
            this.response("440 posting not allowed");
            return;
        }
        this.response("340 send article to be posted. End with <CR-LF>.<CR-LF>");
        this.pout.flush();
        try {
            text = NnrpdUtils.readText(this.din);
        }
        catch (IOException e) {
            this.warning(String.valueOf(this.clientHost) + "problem reading post: " + e);
            ++this.postsBad;
            this.response("441 posting failed: " + e);
            return;
        }
        try {
            this.newsDb.post(text);
            this.notice(String.valueOf(this.clientHost) + " post ok");
            ++this.postsOk;
            this.response("240 article posted ok");
        }
        catch (NewsDbException e) {
            this.notice(String.valueOf(this.clientHost) + " post failed: " + e);
            ++this.postsBad;
            this.response("441 posting failed: " + e);
        }
    }

    private void cmdSlave(String[] args) throws NewsDbException, NnrpdException {
        if (args.length != 0) {
            this.response("501 command syntax error");
            return;
        }
        this.response("202 slave status noted");
    }

    private void cmdQuit(String[] args) throws NewsDbException, NnrpdException {
        this.sessionLog();
        this.response("205 closing connection - goodbye!");
    }

    private void cmdStat(String[] args) throws NewsDbException, NnrpdException {
        this.cmdAhbs(args, 's');
    }

    private void cmdXgtitle(String[] args) throws NewsDbException, NnrpdException {
        String groupsPat;
        if (args.length > 1) {
            this.response("501 command syntax error");
            return;
        }
        if (args.length == 1) {
            groupsPat = args[0];
        } else {
            if (this.currentGroup == null) {
                this.response("412 no current newsgroup has been selected");
                return;
            }
            groupsPat = this.currentGroup.getName();
        }
        this.response("282 list follows");
        Enumeration en = this.newsDb.getGroups();
        while (en.hasMoreElements()) {
            String description;
            NewsDbGroup group = (NewsDbGroup)en.nextElement();
            String groupName = group.getName();
            if (!Utils.match(groupsPat, groupName) || (description = group.getDescription()) == null) continue;
            this.pout.println(String.valueOf(groupName) + "\t" + group.getDescription());
        }
        this.pout.println(".");
    }

    private void cmdXhdr(String[] args) throws NewsDbException, NnrpdException {
        if (args.length < 1 || args.length > 2) {
            this.response("501 command syntax error");
            return;
        }
        String header = args[0];
        if (args.length == 1) {
            if (this.currentGroup == null) {
                this.response("412 no current newsgroup has been selected");
            } else if (this.currentArtNum == -1) {
                this.response("420 no current article has been selected");
            } else {
                this.sendXhdrRange(this.currentArtNum, this.currentArtNum, header);
            }
        } else if (args[1].charAt(0) == '<') {
            String messageId = args[1];
            NewsDbArticle article = this.getArticle(messageId);
            if (article == null) {
                this.response("430 no such article found");
            } else {
                this.response("221 " + header + " header of article " + messageId);
                this.sendXhdrLine(article, header, messageId);
                this.pout.println(".");
            }
        } else {
            int[] range = this.parseRange(args[1]);
            if (range == null) {
                this.response("501 command syntax error");
            } else {
                this.sendXhdrRange(range[0], range[1], header);
            }
        }
    }

    private void sendXhdrRange(int firstArtNum, int lastArtNum, String header) throws NewsDbException, NnrpdException {
        this.response("221 " + header + " fields follow");
        int artNum = firstArtNum;
        while (artNum <= lastArtNum) {
            NewsDbArticle article = this.getArticle(this.currentGroup, artNum);
            if (article != null) {
                this.sendXhdrLine(article, header, Integer.toString(artNum));
            }
            ++artNum;
        }
        this.pout.println(".");
    }

    private void sendXhdrLine(NewsDbArticle article, String header, String ident) {
        String val = article.getHeader(header);
        if (val == null) {
            this.pout.println(String.valueOf(ident) + " (none)");
        } else {
            this.pout.println(String.valueOf(ident) + " " + val);
        }
    }

    private void cmdXover(String[] args) throws NewsDbException, NnrpdException {
        if (args.length > 1) {
            this.response("501 command syntax error");
            return;
        }
        if (args.length == 0) {
            if (this.currentGroup == null) {
                this.response("412 no current newsgroup has been selected");
            } else if (this.currentArtNum == -1) {
                this.response("420 no current article has been selected");
            } else {
                this.sendXoverRange(this.currentGroup, this.currentArtNum, this.currentArtNum);
            }
        } else {
            int[] range = this.parseRange(args[0]);
            if (range == null) {
                this.response("501 command syntax error");
            } else {
                this.sendXoverRange(this.currentGroup, range[0], range[1]);
            }
        }
    }

    private void sendXoverRange(NewsDbGroup group, int firstArtNum, int lastArtNum) throws NewsDbException, NnrpdException {
        int j;
        int artNum;
        int i;
        int numArts = lastArtNum - firstArtNum + 1;
        String[][] results = this.newsDb.getHeaders(overviewFmt, group, firstArtNum, lastArtNum);
        if (results == null) {
            results = new String[numArts][overviewFmt.length];
            i = 0;
            while (i < numArts) {
                artNum = firstArtNum + i;
                NewsDbArticle article = this.getArticle(group, artNum);
                if (article != null) {
                    j = 0;
                    while (j < overviewFmt.length) {
                        results[i][j] = article.getHeader(overviewFmt[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.response("224 data follows");
        i = 0;
        while (i < numArts) {
            if (results[i] != null) {
                artNum = firstArtNum + i;
                StringBuffer buf = new StringBuffer();
                buf.append(Integer.toString(artNum));
                j = 0;
                while (j < overviewFmt.length) {
                    buf.append('\t');
                    buf.append(results[i][j]);
                    ++j;
                }
                this.pout.println(buf.toString());
            }
            ++i;
        }
        this.pout.println(".");
    }

    private void cmdAhbs(String[] args, char which) throws NewsDbException, NnrpdException {
        if (args.length == 0) {
            if (this.currentArtNum == -1) {
                this.response("420 no current article has been selected");
            } else {
                this.cmdAhbsNum(this.currentArtNum, which);
            }
        } else if (args.length > 1) {
            this.response("501 command syntax error");
        } else if (args[0].charAt(0) == '<') {
            this.cmdAhbsId(args[0], which);
        } else {
            int artNum = Utils.parseInt(args[0], -1);
            if (artNum == -1) {
                this.response("501 command syntax error");
                return;
            }
            this.cmdAhbsNum(artNum, which);
        }
    }

    private void cmdAhbsNum(int artNum, char which) throws NewsDbException, NnrpdException {
        if (this.currentGroup == null) {
            this.response("412 no current newsgroup has been selected");
        } else {
            NewsDbArticle article = this.getArticle(this.currentGroup, artNum);
            if (article == null) {
                this.response("423 no such article number in this group");
                return;
            }
            this.currentArtNum = artNum;
            this.sendAhbs(article, artNum, which);
        }
    }

    private void cmdAhbsId(String messageId, char which) throws NewsDbException, NnrpdException {
        NewsDbArticle article = this.getArticle(messageId);
        if (article == null) {
            this.response("430 no such article found");
            return;
        }
        this.sendAhbs(article, -1, which);
    }

    private void sendAhbs(NewsDbArticle article, int artNum, char which) throws NewsDbException, NnrpdException {
        this.artLog();
        this.response(String.valueOf(NnrpdSession.whichStatus(which)) + " " + artNum + " " + article.getHeader("Message-ID") + NnrpdSession.whichStr(which));
        switch (which) {
            case 'a': {
                this.pout.print(article.getText());
                break;
            }
            case 'h': {
                this.pout.print(article.getText().substring(0, article.getHeadLen()));
                break;
            }
            case 'b': {
                this.pout.print(article.getText().substring(article.getBodyStart()));
                break;
            }
            case 's': {
                return;
            }
        }
        this.pout.println(".");
    }

    private static int whichStatus(char which) {
        switch (which) {
            case 'a': {
                return 220;
            }
            case 'h': {
                return 221;
            }
            case 'b': {
                return 222;
            }
            case 's': {
                return 223;
            }
        }
        return 500;
    }

    private static String whichStr(char which) {
        switch (which) {
            case 'a': {
                return " head and body follow";
            }
            case 'h': {
                return " head follows";
            }
            case 'b': {
                return " body follows";
            }
            case 's': {
                return " request text separately";
            }
        }
        return "???";
    }

    private void sendGroup(NewsDbGroup group) {
        this.pout.println(String.valueOf(group.getName()) + " " + group.getLastArtNum() + " " + group.getFirstArtNum() + " " + group.getFlag());
    }

    private void response(String resp) throws NnrpdException {
        this.debug(String.valueOf(this.clientHost) + " > " + resp);
        this.pout.println(resp);
    }

    private NewsDbArticle getArticle(NewsDbGroup group, int artNum) throws NewsDbException {
        NewsDbArticle article = this.articleCache.getArticle(group, artNum);
        if (article == null && (article = this.newsDb.getArticle(group, artNum)) != null) {
            this.articleCache.addArticle(article, group, artNum);
        }
        return article;
    }

    private NewsDbArticle getArticle(String messageId) throws NewsDbException {
        NewsDbArticle article = this.articleCache.getArticle(messageId);
        if (article == null && (article = this.newsDb.getArticle(messageId)) != null) {
            this.articleCache.addArticle(article, messageId);
        }
        return article;
    }

    private int[] parseRange(String rangeStr) {
        try {
            int[] range = new int[2];
            int dash = rangeStr.indexOf(45);
            if (dash == -1) {
                range[0] = range[1] = Integer.parseInt(rangeStr);
            } else {
                String firstStr = rangeStr.substring(0, dash);
                String lastStr = rangeStr.substring(dash + 1);
                range[0] = firstStr.length() == 0 ? this.currentGroup.getFirstArtNum() : Integer.parseInt(firstStr);
                range[1] = lastStr.length() == 0 ? this.currentGroup.getLastArtNum() : Integer.parseInt(lastStr);
            }
            return range;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private void artLog() throws NnrpdException {
        ++this.artCount;
        ++this.groupArts;
    }

    private void groupLog() throws NnrpdException {
        if (this.currentGroup != null) {
            this.notice(String.valueOf(this.clientHost) + " group " + this.currentGroup.getName() + " " + this.groupArts);
            ++this.groupCount;
        }
        this.groupArts = 0;
    }

    private void sessionLog() throws NnrpdException {
        long now = System.currentTimeMillis();
        this.groupLog();
        this.notice(String.valueOf(this.clientHost) + " exit articles " + this.artCount + " groups " + this.groupCount);
        if (this.postsOk != 0 || this.postsBad != 0) {
            this.notice(String.valueOf(this.clientHost) + " posts received " + this.postsOk + " rejected " + this.postsBad);
        }
        this.notice(String.valueOf(this.clientHost) + " elapsed " + (now - this.startTime) / 1000L);
    }

    private void debug(String message) throws NnrpdException {
        this.nnrpd.debug(message);
    }

    private void info(String message) throws NnrpdException {
        this.nnrpd.info(message);
    }

    private void notice(String message) throws NnrpdException {
        this.nnrpd.notice(message);
    }

    private void warning(String message) throws NnrpdException {
        this.nnrpd.warning(message);
    }

    private void error(String message) throws NnrpdException {
        this.nnrpd.error(message);
    }

    private void crit(String message) throws NnrpdException {
        this.nnrpd.crit(message);
    }

    private void alert(String message) throws NnrpdException {
        this.nnrpd.alert(message);
    }

    private void emerg(String message) throws NnrpdException {
        this.nnrpd.emerg(message);
    }
}

