/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.ImageMediaEntry;
import Acme.MediaEntry;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;

public class MediaTracker {
    Component compTarget;
    Toolkit tkTarget;
    MediaEntry head;
    public static final int LOADING = 1;
    public static final int ABORTED = 2;
    public static final int ERRORED = 4;
    public static final int COMPLETE = 8;
    static final int DONE = 14;

    public MediaTracker(Component comp) {
        this.compTarget = comp;
    }

    public MediaTracker(Toolkit tk) {
        this.compTarget = null;
        this.tkTarget = tk;
    }

    public void addImage(Image image, int id) {
        this.addImage(image, id, -1, -1);
    }

    public synchronized void addImage(Image image, int id, int w, int h) {
        this.head = MediaEntry.insert(this.head, new ImageMediaEntry(this, image, id, w, h));
    }

    public boolean checkAll() {
        return this.checkAll(false);
    }

    public synchronized boolean checkAll(boolean load) {
        MediaEntry cur = this.head;
        boolean done = true;
        while (cur != null) {
            if ((cur.getStatus(load) & 0xE) == 0) {
                done = false;
            }
            cur = cur.next;
        }
        return done;
    }

    public synchronized boolean isErrorAny() {
        MediaEntry cur = this.head;
        while (cur != null) {
            if ((cur.getStatus(false) & 4) != 0) {
                return true;
            }
            cur = cur.next;
        }
        return false;
    }

    public synchronized Object[] getErrorsAny() {
        MediaEntry cur = this.head;
        int numerrors = 0;
        while (cur != null) {
            if ((cur.getStatus(false) & 4) != 0) {
                ++numerrors;
            }
            cur = cur.next;
        }
        if (numerrors == 0) {
            return null;
        }
        Object[] errors = new Object[numerrors];
        cur = this.head;
        numerrors = 0;
        while (cur != null) {
            if ((cur.getStatus(false) & 4) != 0) {
                errors[numerrors++] = cur.getMedia();
            }
            cur = cur.next;
        }
        return errors;
    }

    public void waitForAll() throws InterruptedException {
        this.waitForAll(0L);
    }

    public synchronized boolean waitForAll(long ms) throws InterruptedException {
        long end = System.currentTimeMillis() + ms;
        boolean first = true;
        int status;
        while (((status = this.statusAll(first)) & 1) != 0) {
            long timeout;
            first = false;
            if (ms == 0L) {
                timeout = 0L;
            } else {
                timeout = end - System.currentTimeMillis();
                if (timeout <= 0L) {
                    return false;
                }
            }
            this.wait(timeout);
        }
        return status == 8;
    }

    public int statusAll(boolean load) {
        MediaEntry cur = this.head;
        int status = 0;
        while (cur != null) {
            status |= cur.getStatus(load);
            cur = cur.next;
        }
        return status;
    }

    public boolean checkID(int id) {
        return this.checkID(id, false);
    }

    public synchronized boolean checkID(int id, boolean load) {
        MediaEntry cur = this.head;
        boolean done = true;
        while (cur != null) {
            if (cur.getID() == id && (cur.getStatus(load) & 0xE) == 0) {
                done = false;
            }
            cur = cur.next;
        }
        return done;
    }

    public synchronized boolean isErrorID(int id) {
        MediaEntry cur = this.head;
        while (cur != null) {
            if (cur.getID() == id && (cur.getStatus(false) & 4) != 0) {
                return true;
            }
            cur = cur.next;
        }
        return false;
    }

    public synchronized Object[] getErrorsID(int id) {
        MediaEntry cur = this.head;
        int numerrors = 0;
        while (cur != null) {
            if (cur.getID() == id && (cur.getStatus(false) & 4) != 0) {
                ++numerrors;
            }
            cur = cur.next;
        }
        if (numerrors == 0) {
            return null;
        }
        Object[] errors = new Object[numerrors];
        cur = this.head;
        numerrors = 0;
        while (cur != null) {
            if (cur.getID() == id && (cur.getStatus(false) & 4) != 0) {
                errors[numerrors++] = cur.getMedia();
            }
            cur = cur.next;
        }
        return errors;
    }

    public void waitForID(int id) throws InterruptedException {
        this.waitForID(id, 0L);
    }

    public synchronized boolean waitForID(int id, long ms) throws InterruptedException {
        long end = System.currentTimeMillis() + ms;
        boolean first = true;
        int status;
        while (((status = this.statusID(id, first)) & 1) != 0) {
            long timeout;
            first = false;
            if (ms == 0L) {
                timeout = 0L;
            } else {
                timeout = end - System.currentTimeMillis();
                if (timeout <= 0L) {
                    return false;
                }
            }
            this.wait(timeout);
        }
        return status == 8;
    }

    public int statusID(int id, boolean load) {
        MediaEntry cur = this.head;
        int status = 0;
        while (cur != null) {
            if (cur.getID() == id) {
                status |= cur.getStatus(load);
            }
            cur = cur.next;
        }
        return status;
    }

    synchronized void setDone() {
        this.notifyAll();
    }
}

