/*
 * Decompiled with CFR 0.152.
 */
package com.pd4ml;

import com.pd4ml.Dimensions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class PageSize
implements Dimensions {
    public static final PageSize B5 = new PageSize(176.0f, 250.0f, Dimensions.Units.MM);
    public static final PageSize B4 = new PageSize(250.0f, 353.0f, Dimensions.Units.MM);
    public static final PageSize JIS_B5 = new PageSize(182.0f, 257.0f, Dimensions.Units.MM);
    public static final PageSize JIS_B4 = new PageSize(257.0f, 364.0f, Dimensions.Units.MM);
    public static final PageSize A10 = new PageSize(74.0f, 105.0f);
    public static final PageSize A9 = new PageSize(105.0f, 148.0f);
    public static final PageSize A8 = new PageSize(148.0f, 210.0f);
    public static final PageSize A7 = new PageSize(210.0f, 297.0f);
    public static final PageSize A6 = new PageSize(297.0f, 421.0f);
    public static final PageSize A5 = new PageSize(421.0f, 595.0f);
    public static final PageSize A4 = new PageSize(595.0f, 842.0f);
    public static final PageSize A3 = new PageSize(842.0f, 1190.0f);
    public static final PageSize A2 = new PageSize(1190.0f, 1684.0f);
    public static final PageSize A1 = new PageSize(1684.0f, 2384.0f);
    public static final PageSize A0 = new PageSize(2384.0f, 3370.0f);
    public static final PageSize ISOB5 = new PageSize(501.0f, 709.0f);
    public static final PageSize ISOB4 = new PageSize(709.0f, 1002.0f);
    public static final PageSize ISOB3 = new PageSize(1002.0f, 1418.0f);
    public static final PageSize ISOB2 = new PageSize(1418.0f, 2004.0f);
    public static final PageSize ISOB1 = new PageSize(2004.0f, 2836.0f);
    public static final PageSize ISOB0 = new PageSize(2836.0f, 4008.0f);
    public static final PageSize HALFLETTER = new PageSize(396.0f, 612.0f);
    public static final PageSize LETTER = new PageSize(612.0f, 792.0f);
    public static final PageSize TABLOID = new PageSize(792.0f, 1224.0f);
    public static final PageSize LEDGER = new PageSize(1224.0f, 792.0f);
    public static final PageSize NOTE = new PageSize(540.0f, 720.0f);
    public static final PageSize LEGAL = new PageSize(612.0f, 1008.0f);
    public static final PageSize ArchA = new PageSize(648.0f, 864.0f);
    public static final PageSize ArchB = new PageSize(864.0f, 1296.0f);
    public static final PageSize ArchC = new PageSize(1296.0f, 1728.0f);
    public static final PageSize ArchD = new PageSize(1728.0f, 2592.0f);
    public static final PageSize ArchE = new PageSize(2592.0f, 3456.0f);
    public static final PageSize ArchE1 = new PageSize(2160.0f, 3024.0f);
    public float width;
    public float height;
    public boolean rotated;

    public PageSize(float f2, float f3, Dimensions.Units units) {
        switch (units) {
            case PT: {
                this.width = f2;
                this.height = f3;
                break;
            }
            case MM: {
                this.width = f2 * 2.835f;
                this.height = f3 * 2.835f;
                break;
            }
            case PX: {
                this.width = f2 / 1.35f;
                this.height = f3 / 1.35f;
            }
        }
        this.o00000();
    }

    public PageSize(float f2, float f3) {
        this.width = f2;
        this.height = f3;
        this.o00000();
    }

    private PageSize(float f2, float f3, boolean bl) {
        this.width = f2;
        this.height = f3;
        this.rotated = bl;
        this.o00000();
    }

    private void o00000() {
        if (this.width <= 0.0f && this.height <= 0.0f) {
            this.width = PageSize.A4.width;
            this.height = PageSize.A4.height;
        } else if (this.width <= 0.0f) {
            this.width = this.height;
        } else if (this.height <= 0.0f) {
            this.height = this.width;
        }
    }

    public PageSize rotate() {
        return new PageSize(this.height, this.width, true);
    }

    public float mmWidth() {
        return this.width * 1.35f;
    }

    public float mmHeight() {
        return this.height * 1.35f;
    }

    public String toString() {
        return (int)this.width + "x" + (int)this.height;
    }

    public static PageSize getInstance(String string) throws IllegalArgumentException, IllegalAccessException {
        int n2;
        if (string == null) {
            return null;
        }
        string = string.trim();
        Object[] objectArray = PageSize.class.getDeclaredFields();
        int n3 = objectArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            Field field = objectArray[n2];
            int n4 = field.getModifiers();
            if (!Modifier.isStatic(n4) || !Modifier.isFinal(n4) || !field.getName().toLowerCase().equals(string)) continue;
            return (PageSize)field.get(null);
        }
        if (string.indexOf(120) > 0 && (objectArray = string.split("x")).length == 2) {
            try {
                n3 = Integer.parseInt(((String)objectArray[0]).trim());
                n2 = Integer.parseInt(((String)objectArray[1]).trim());
                return new PageSize(n3, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

