/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.Renderer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;

public class GridRenderer
extends Renderer
implements Runnable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    Rectangle graphBounds;
    Rectangle totalGraphBounds;
    Rectangle chartDataBounds;
    Rectangle[] rangeBounds;
    Rectangle[] rangeAdjusterBounds;
    Rectangle sampleScrollerBounds;
    int[] zeroLine;
    double leftScrollerFactor;
    double rightScrollerFactor;
    int sampleScrollerSpace;
    int leftAdjusterPos;
    int rightAdjusterPos;
    int adjusterIndex;
    int lastAdjusterClick;
    boolean leftPushed;
    boolean rightPushed;
    boolean insideLeftButton;
    boolean insideRightButton;
    boolean adjustingUpper;
    boolean adjustingLower;
    boolean slidingAdjuster;
    boolean adjustingLeft;
    boolean adjustingRight;
    boolean slidingScroller;
    int lastScrollerClick;
    protected long lastClickTime;
    boolean zoomedOnMousePress;
    private boolean zoomOutPushed;
    private int gridEdgeToAdjust;
    private Rectangle mouseBox;
    private int mousePressX;
    private int mousePressY;
    Thread scrollerThread;
    private boolean display3dOn;
    private int gridAlignment;
    private Point depth3dPoint;
    static final double[] STEPS = new double[]{1.0, 2.0, 2.5, 5.0};
    static final float ANGLE = 1.25f;
    static final float DEPTH = 0.75f;
    private static final int X_AXIS = 0;
    private static final int Y_AXIS = 1;
    Chart chart;

    public GridRenderer() {
    }

    public GridRenderer(Chart chart) {
        super(chart);
        this.chart = chart;
        this.zeroLine = new int[1];
        this.chartDataBounds = new Rectangle();
        this.graphBounds = new Rectangle();
        this.totalGraphBounds = new Rectangle();
        this.gridEdgeToAdjust = -1;
        this.rangeBounds = new Rectangle[1];
        this.rangeBounds[0] = new Rectangle();
        this.rangeAdjusterBounds = new Rectangle[2];
        this.rangeAdjusterBounds[0] = new Rectangle();
        this.rangeAdjusterBounds[1] = new Rectangle();
        this.sampleScrollerBounds = new Rectangle();
        this.adjusterIndex = -1;
        this.mousePressX = -1;
        this.mousePressY = -1;
    }

    void calculateRangeBounds(Grid grid, Rectangle gridBounds) {
        int range_length = grid.getRangeCount();
        this.checkRangeIntegrity(this.rangeBounds.length, range_length);
        boolean leftmost = true;
        boolean rightmost = true;
        boolean highest = true;
        boolean lowest = true;
        int gridAlignment = grid.gridAlignment;
        for (int index = range_length - 1; index >= 0; --index) {
            int rangePosition = grid.getRangePosition(index);
            int adjusterPosition = grid.getAdjusterPosition(index);
            boolean rangeAdjusterOn = grid.isRangeAdjusterOn(index);
            if (!grid.isRangeOn(index)) continue;
            int widest = this.getRangeWidth(grid, index, true, true);
            String rangeAxisLabel = null;
            int angle = 0;
            if (index == 0) {
                rangeAxisLabel = this.getLabel("rangeAxisLabel");
                angle = this.getLabelAngle("rangeAxisLabelAngle");
            } else if (index > 0) {
                rangeAxisLabel = this.getLabel("rangeAxisLabel_" + (index + 1));
                angle = this.getLabelAngle("rangeAxisLabelAngle_" + (index + 1));
            }
            angle = gridAlignment == 1 ? angle : 0;
            int labelWidth = 0;
            int labelHeight = 0;
            if (rangeAxisLabel != null) {
                Font rangeAxisLabelFont = this.getFont("rangeAxisLabelFont");
                Dimension labelSize = this.getLabelSize(rangeAxisLabel, this.getFontMetrics(rangeAxisLabelFont));
                Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
                labelWidth = angledSize.width + 5;
                labelHeight = angledSize.height;
            }
            if (rangePosition == 0) {
                if (gridAlignment == 1) {
                    this.rangeBounds[index].y = gridBounds.y;
                    this.rangeBounds[index].height = gridBounds.height;
                    this.rangeBounds[index].width = widest + 2 + labelWidth;
                    if (rangeAdjusterOn && adjusterPosition == rangePosition) {
                        this.rangeBounds[index].width += 6;
                    }
                    this.rangeBounds[index].width = this.rangeBounds[index].width + (leftmost ? 0 : 15);
                    leftmost = false;
                } else {
                    this.rangeBounds[index].x = gridBounds.x;
                    this.rangeBounds[index].width = gridBounds.width;
                    this.rangeBounds[index].height = widest + 2 + labelHeight;
                    if (rangeAdjusterOn && adjusterPosition == rangePosition) {
                        this.rangeBounds[index].y -= 6;
                        this.rangeBounds[index].height += 6;
                    }
                    this.rangeBounds[index].height = this.rangeBounds[index].height + (highest ? 0 : 10);
                    highest = false;
                }
            } else if (gridAlignment == 1) {
                this.rangeBounds[index].y = gridBounds.y;
                this.rangeBounds[index].height = gridBounds.height;
                this.rangeBounds[index].width = (widest > 0 ? widest + 2 : 0) + labelWidth;
                if (rangeAdjusterOn && adjusterPosition == rangePosition) {
                    this.rangeBounds[index].width += 6;
                }
                this.rangeBounds[index].width = this.rangeBounds[index].width + (rightmost ? 0 : 15);
                rightmost = false;
            } else {
                this.rangeBounds[index].x = gridBounds.x;
                this.rangeBounds[index].width = gridBounds.width;
                this.rangeBounds[index].height = widest + 2 + labelHeight;
                if (rangeAdjusterOn && adjusterPosition == rangePosition) {
                    this.rangeBounds[index].height += 6;
                }
                this.rangeBounds[index].height = this.rangeBounds[index].height + (lowest ? 0 : 10);
                lowest = false;
            }
            if (!(this.chart instanceof Chart)) continue;
            for (int j = 0; j < this.chart.getSeriesCount() && this.chart.getSeriesRange(j) != index; ++j) {
                for (int i = 0; i < this.chart.overlayCharts.size(); ++i) {
                    Chart overlay;
                    if (!(this.chart.overlayCharts.elementAt(i) instanceof Chart) || (overlay = (Chart)this.chart.overlayCharts.elementAt(i)) == null || overlay.chartType.equals("pie")) continue;
                    for (int k = 0; k < overlay.getSeriesCount(); ++k) {
                        if (overlay.getSeriesRange(k) != index) continue;
                        if (grid.getGridAlignment() == 1) {
                            double topOffset = (double)gridBounds.height * overlay.getOverlayInsets(2);
                            double bottomOffset = (double)gridBounds.height * overlay.getOverlayInsets(3);
                            this.rangeBounds[index].y = gridBounds.y + (int)topOffset;
                            this.rangeBounds[index].height = gridBounds.height - (int)topOffset - (int)bottomOffset;
                            continue;
                        }
                        double leftOffset = (double)gridBounds.width * overlay.getOverlayInsets(0);
                        double rightOffset = (double)gridBounds.width * overlay.getOverlayInsets(1);
                        this.rangeBounds[index].x = gridBounds.x + (int)leftOffset;
                        this.rangeBounds[index].width = gridBounds.width - (int)leftOffset - (int)rightOffset;
                    }
                }
            }
        }
        int right_total = 0;
        int left_total = 0;
        for (int index = 0; index < this.rangeBounds.length; ++index) {
            if (this.rangeBounds[index] == null || !this.chart.isRangeOn(index)) continue;
            int rangePosition = grid.getRangePosition(index);
            if (gridAlignment == 1) {
                if (rangePosition == 0) {
                    left_total += this.rangeBounds[index].width;
                    continue;
                }
                right_total += this.rangeBounds[index].width;
                continue;
            }
            if (rangePosition == 0) {
                left_total -= this.rangeBounds[index].height;
                continue;
            }
            right_total += this.rangeBounds[index].height;
        }
        Insets insets = grid.getGraphInsets();
        if (gridAlignment == 1) {
            int offset;
            if (insets.left == -1) {
                offset = left_total + 10 + this.depth3dPoint.x - gridBounds.x;
                if (this.chart.isLegendOn() && this.chart.getLegendPosition() == 0) {
                    offset = left_total - 10;
                }
                if (offset > 0) {
                    gridBounds.x += offset;
                    gridBounds.width -= offset;
                }
            }
            if (insets.right == -1) {
                offset = right_total + 10;
                if (this.chart.isLegendOn() && this.chart.getLegendPosition() == 1) {
                    offset = right_total;
                }
                if (offset > 0) {
                    gridBounds.width -= offset;
                }
            }
        } else {
            int bottom = this.chart.getSize().height - (gridBounds.y + gridBounds.height);
            bottom = this.chart.isLegendOn() && this.chart.getLegendPosition() == 3 ? (bottom -= left_total) : Math.max(bottom, -left_total + 10);
            if (insets.top == -1) {
                gridBounds.y = Math.max(gridBounds.y, right_total + 10);
            }
            if (insets.bottom == -1) {
                gridBounds.height = this.chart.getSize().height - gridBounds.y - bottom;
            }
        }
        if (grid.isRangeAdjusterOn(0) && grid.getRangePosition(0) == 0 && grid.getRangeAdjusterPosition() == 1) {
            if (grid.getGridAlignment() == 1 && insets.right == -1) {
                gridBounds.width -= 6;
            } else if (insets.bottom == -1) {
                gridBounds.y += 6;
                gridBounds.height -= 6;
            }
        }
        int left_offset = gridBounds.x;
        int right_offset = gridBounds.x + gridBounds.width;
        if (gridAlignment == 0) {
            left_offset = gridBounds.y + gridBounds.height;
            right_offset = gridBounds.y;
        }
        for (int index = 0; index < this.rangeBounds.length; ++index) {
            if (this.rangeBounds[index] == null) continue;
            int rangePosition = grid.getRangePosition(index);
            if (gridAlignment == 1) {
                if (rangePosition == 0) {
                    this.rangeBounds[index].x = left_offset -= this.rangeBounds[index].width;
                    continue;
                }
                this.rangeBounds[index].x = right_offset;
                right_offset += this.rangeBounds[index].width;
                continue;
            }
            this.rangeBounds[index].y = rangePosition == 0 ? (left_offset += this.rangeBounds[index].height) - this.rangeBounds[index].height : (right_offset -= this.rangeBounds[index].height);
        }
    }

    int getRangeWidth(Grid grid, int range, boolean rangeLabels, boolean targetLabels) {
        String postfix;
        String prefix;
        FontMetrics fm = this.getFontMetrics(this.getFont("rangeLabelFont"));
        if (range == 0) {
            prefix = this.getLabel("rangeLabelPrefix");
            postfix = this.getLabel("rangeLabelPostfix");
        } else {
            prefix = this.getLabel("rangeLabelPrefix_" + (range + 1));
            postfix = this.getLabel("rangeLabelPostfix_" + (range + 1));
        }
        double currentUpperRange = grid.getCurrentRange(range);
        double currentLowerRange = grid.getCurrentLowerRange(range);
        Rectangle r = new Rectangle(0, 0, this.chart.getSize().width, this.chart.getSize().height);
        double step = this.getTickStep(grid, r, range, fm);
        int widest = 0;
        int gridAlignment = grid.gridAlignment;
        if (gridAlignment == 1) {
            if (range >= 0 && range < grid.getRangeCount() && rangeLabels && grid.isRangeLabelsOn(range)) {
                String label;
                double value;
                if (currentUpperRange > currentLowerRange && currentUpperRange > 0.0) {
                    for (value = Math.max(0.0, currentLowerRange - currentLowerRange % step + step); value < currentUpperRange; value += step) {
                        if (value == 0.0) continue;
                        label = this.chart.formatRangeNumber(range, value);
                        widest = Math.max(fm.stringWidth(label), widest);
                    }
                } else if (currentUpperRange < currentLowerRange && currentUpperRange < 0.0) {
                    for (value = Math.min(0.0, currentLowerRange - currentLowerRange % step - step); value > currentUpperRange; value -= step) {
                        if (value == 0.0) continue;
                        label = this.chart.formatRangeNumber(range, value);
                        widest = Math.max(fm.stringWidth(label), widest);
                    }
                }
                if (currentUpperRange > currentLowerRange && currentLowerRange < 0.0) {
                    for (value = Math.min(0.0, currentUpperRange - currentUpperRange % step - step); value > currentLowerRange; value -= step) {
                        if (value == 0.0) continue;
                        label = this.chart.formatRangeNumber(range, value);
                        widest = Math.max(fm.stringWidth(label), widest);
                    }
                } else if (currentUpperRange < currentLowerRange && currentLowerRange > 0.0) {
                    for (value = Math.max(0.0, currentUpperRange - currentUpperRange % step + step); value < currentLowerRange; value += step) {
                        if (value == 0.0) continue;
                        label = this.chart.formatRangeNumber(range, value);
                        widest = Math.max(fm.stringWidth(label), widest);
                    }
                }
            }
            String upper = this.chart.formatRangeNumber(range, grid.getRange(range));
            String lower = this.chart.formatRangeNumber(range, grid.getLowerRange(range));
            widest = Math.max(widest, fm.stringWidth(lower));
            widest = Math.max(widest, fm.stringWidth(upper));
            widest += prefix != null ? fm.stringWidth(prefix) : 0;
            widest += postfix != null ? fm.stringWidth(postfix) : 0;
        } else {
            widest = fm.getHeight();
        }
        if (range < grid.getRangeCount() && targetLabels) {
            int target_pos = grid.getTargetLabelsPosition();
            if (range != 0 || grid.getRangePosition(0) == target_pos || target_pos == -1) {
                int widestTarget = 0;
                Enumeration e = grid.targetsLabel.keys();
                while (e.hasMoreElements()) {
                    String label;
                    String id = (String)e.nextElement();
                    int targetRange = (Integer)grid.targetsRange.get(id);
                    if (range != -1 && range != targetRange || (label = this.chart.getTargetLabel(id)) == null || label.length() <= 0) continue;
                    if (gridAlignment == 1) {
                        widestTarget = Math.max(widestTarget, fm.stringWidth(label));
                        continue;
                    }
                    widestTarget = fm.getHeight();
                }
                widest = range == -1 ? widestTarget : (gridAlignment == 1 ? Math.max(widestTarget, widest) : (widest += widestTarget));
            }
        }
        return widest;
    }

    void calculateZeroLines(Grid grid, Rectangle gridBounds) {
        int newLength = grid.getRangeCount();
        if (newLength > this.zeroLine.length) {
            int[] newZeroLine = new int[newLength];
            System.arraycopy(this.zeroLine, 0, newZeroLine, 0, Math.min(this.zeroLine.length, newLength));
            this.zeroLine = newZeroLine;
        }
        for (int rangeIndex = 0; rangeIndex < this.zeroLine.length; ++rangeIndex) {
            int positiveSpace;
            double upper = grid.currentUpperRange[rangeIndex];
            double lower = grid.currentLowerRange[rangeIndex];
            if (upper - lower == 0.0) continue;
            if (grid.gridAlignment == 1) {
                positiveSpace = (int)Math.round((double)gridBounds.height * (upper / (upper - lower)));
                this.zeroLine[rangeIndex] = gridBounds.y + positiveSpace;
                continue;
            }
            positiveSpace = (int)Math.round((double)gridBounds.width * (upper / (upper - lower)));
            this.zeroLine[rangeIndex] = gridBounds.x + gridBounds.width - positiveSpace;
        }
    }

    protected Rectangle getDataBounds(Grid grid) {
        if (this.graphBounds == null) {
            throw new IllegalArgumentException("graphBounds is NULL");
        }
        this.chartDataBounds.setBounds(this.graphBounds);
        double visible = 1.0 - this.leftScrollerFactor - this.rightScrollerFactor;
        if (grid.gridAlignment == 1) {
            this.chartDataBounds.width = (int)Math.round((double)this.graphBounds.width / visible);
            this.chartDataBounds.x = (int)((long)this.chartDataBounds.x - Math.round(this.leftScrollerFactor * (double)this.chartDataBounds.width));
        } else {
            this.chartDataBounds.height = (int)Math.round((double)this.graphBounds.height / visible);
            this.chartDataBounds.y = (int)((long)this.chartDataBounds.y - Math.round(this.leftScrollerFactor * (double)this.chartDataBounds.height));
        }
        return this.chartDataBounds;
    }

    protected Rectangle getGraphBounds() {
        return this.graphBounds;
    }

    void calculateGraphBounds(Grid grid, Rectangle gridBounds) {
        String sampleAxisLabel;
        int rangeCount = grid.getRangeCount();
        this.depth3dPoint = this.chart.renderer.depth3dPoint;
        this.display3dOn = this.chart.is3DModeOn();
        this.gridAlignment = grid.gridAlignment;
        Dimension size = this.chart.getSize();
        int left = gridBounds.x;
        int right = size.width - gridBounds.width - gridBounds.x;
        int top = gridBounds.y;
        int bottom = size.height - gridBounds.height - gridBounds.y;
        if (this.chart.isTitleOn()) {
            Dimension titleSize = this.getLabelSize(this.chart.getTitle(), this.getFontMetrics(this.getFont("titleFont")));
            top += titleSize.height;
        }
        if (grid.isSampleScrollerOn()) {
            if (this.gridAlignment == 1) {
                bottom += 10;
            } else {
                left += 10;
            }
        }
        if ((sampleAxisLabel = this.getLabel("sampleAxisLabel")) != null) {
            int angle = this.getLabelAngle("sampleAxisLabelAngle");
            angle = this.gridAlignment == 0 ? angle : 0;
            Font sampleAxisLabelFont = this.getFont("sampleAxisLabelFont");
            FontMetrics fm = this.getFontMetrics(sampleAxisLabelFont);
            Dimension labelSize = this.getLabelSize(sampleAxisLabel, fm);
            Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
            if (this.gridAlignment == 1) {
                bottom += angledSize.height + 3;
            } else {
                left += angledSize.width + 5;
            }
        }
        if (this.gridAlignment == 0) {
            int upper_width = 0;
            int lower_width = 0;
            for (int range = 0; range < rangeCount; ++range) {
                String postfix;
                String prefix;
                if (!grid.isRangeOn(range) || !grid.isRangeLabelsOn(range)) continue;
                FontMetrics fm = this.getFontMetrics(this.getFont("rangeLabelFont"));
                if (range == 0) {
                    prefix = this.getLabel("rangeLabelPrefix");
                    postfix = this.getLabel("rangeLabelPostfix");
                } else {
                    prefix = this.getLabel("rangeLabelPrefix_" + (range + 1));
                    postfix = this.getLabel("rangeLabelPostfix_" + (range + 1));
                }
                double upperRange = grid.getRange(range);
                double lowerRange = grid.getLowerRange(range);
                String upper = this.chart.formatRangeNumber(range, upperRange);
                String lower = this.chart.formatRangeNumber(range, lowerRange);
                if (upperRange < lowerRange) {
                    upper = this.chart.formatRangeNumber(range, lowerRange);
                    lower = this.chart.formatRangeNumber(range, upperRange);
                }
                upper = prefix != null ? prefix + upper : upper;
                lower = prefix != null ? prefix + lower : lower;
                upper = postfix != null ? upper + postfix : upper;
                lower = postfix != null ? lower + postfix : lower;
                upper_width = Math.max(fm.stringWidth(upper), upper_width);
                lower_width = Math.max(fm.stringWidth(lower), lower_width);
            }
            left = Math.max(lower_width / 2 + 5, left);
            right = Math.max(upper_width / 2 + 5, right);
        }
        if (this.gridAlignment == 1) {
            Dimension angledSize;
            String label = null;
            String label2 = null;
            try {
                label = this.chart.getSampleLabel(this.getSampleCount() - 1);
                label2 = this.chart.getSampleLabel(0);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            int label_width = 0;
            Font font = this.getFont("sampleLabelFont");
            FontMetrics fm = this.getFontMetrics(font);
            int angle = this.getLabelAngle("sampleLabelAngle");
            if (label != null) {
                Dimension labelSize = this.getLabelSize(label, fm);
                angledSize = this.getAngledLabelSize(labelSize, angle);
                if (angle == 0 || angle == 180) {
                    label_width = angledSize.width / 2;
                } else if (angle > 0 && angle < 90 || angle > 180 && angle < 270) {
                    label_width = angledSize.width;
                } else if (angle > 90 && angle < 180 || angle > 270 && angle < 360) {
                    label_width = 0;
                }
            }
            right = Math.max(right, label_width + 5);
            if (label2 != null) {
                Dimension labelSize = this.getLabelSize(label2, fm);
                angledSize = this.getAngledLabelSize(labelSize, angle);
                if (angle == 0 || angle == 180) {
                    label_width = angledSize.width / 2;
                } else if (angle > 0 && angle < 90 || angle > 180 && angle < 270) {
                    label_width = 0;
                } else if (angle > 90 && angle < 180 || angle > 270 && angle < 360) {
                    label_width = angledSize.width;
                }
            }
            left = Math.max(left, label_width + this.depth3dPoint.x + 5);
        }
        Insets insets = grid.getGraphInsets();
        boolean range_on = false;
        for (int i = 0; i < rangeCount; ++i) {
            range_on = grid.isRangeOn(i) || range_on;
        }
        gridBounds.x = insets.left != -1 ? insets.left : left;
        gridBounds.width = insets.right != -1 ? size.width - gridBounds.x - insets.right - 1 : size.width - gridBounds.x - right - 1;
        gridBounds.y = insets.top != -1 ? insets.top : top;
        int n = gridBounds.height = insets.bottom != -1 ? size.height - gridBounds.y - insets.bottom - 1 : size.height - gridBounds.y - bottom - 1;
        if (range_on || grid.targetsLabel.size() > 0) {
            this.calculateRangeBounds(grid, gridBounds);
        }
        this.graphBounds = gridBounds;
    }

    protected Rectangle getTotalGraphBounds() {
        Grid grid = this.chart.getGrid();
        int left_offset = 0;
        int right_offset = 0;
        int left_inner_range = -1;
        int right_inner_range = -1;
        for (int i = this.rangeBounds.length - 1; i >= 0; --i) {
            int rangePosition = grid.getRangePosition(i);
            if (rangePosition == 0) {
                left_inner_range = i;
                left_offset += this.gridAlignment == 1 ? this.rangeBounds[i].width : this.rangeBounds[i].height;
                continue;
            }
            if (rangePosition != 1) continue;
            right_inner_range = i;
            right_offset += this.gridAlignment == 1 ? this.rangeBounds[i].width : this.rangeBounds[i].height;
        }
        if (grid.getTargetLabelsPosition() == 0 && left_inner_range == -1) {
            left_offset += this.getRangeWidth(grid, -1, false, true);
        } else if (grid.getTargetLabelsPosition() == 1 && right_inner_range == -1) {
            right_offset += this.getRangeWidth(grid, -1, false, true);
        }
        if (grid.getRangeCount() == 1 && grid.isRangeOn(0) && grid.isRangeAdjusterOn(0)) {
            if (grid.getRangePosition(0) == 0 && grid.getRangeAdjusterPosition() == 1) {
                right_offset += 6;
            } else if (grid.getRangePosition(0) == 1 && grid.getRangeAdjusterPosition() == 0) {
                left_offset += 6;
            }
        }
        this.totalGraphBounds = new Rectangle(this.graphBounds);
        if (this.gridAlignment == 1) {
            this.totalGraphBounds.x -= left_offset;
            this.totalGraphBounds.width += left_offset + right_offset;
        } else {
            this.totalGraphBounds.y -= right_offset;
            this.totalGraphBounds.height += left_offset + right_offset;
        }
        if (grid.isSampleScrollerOn()) {
            if (this.gridAlignment == 1) {
                this.totalGraphBounds.height += 10;
            } else {
                this.totalGraphBounds.width += 10;
            }
        }
        return this.totalGraphBounds;
    }

    void paintGrid(Graphics g, Grid grid, Rectangle gridBounds) {
        Image image;
        GradientPaint gp;
        if (g == null || gridBounds == null) {
            return;
        }
        this.depth3dPoint = this.chart.renderer.depth3dPoint;
        Polygon left = new Polygon();
        Polygon bottom = new Polygon();
        if (this.display3dOn) {
            left.addPoint(gridBounds.x, gridBounds.y);
            left.addPoint(gridBounds.x - this.depth3dPoint.x, gridBounds.y - this.depth3dPoint.y);
            left.addPoint(left.xpoints[1], left.ypoints[1] + gridBounds.height);
            left.addPoint(gridBounds.x, gridBounds.y + gridBounds.height);
            left.addPoint(gridBounds.x, gridBounds.y);
            bottom.addPoint(gridBounds.x, gridBounds.y + gridBounds.height);
            bottom.addPoint(left.xpoints[2], left.ypoints[2]);
            bottom.addPoint(bottom.xpoints[1] + gridBounds.width, bottom.ypoints[1]);
            bottom.addPoint(gridBounds.x + gridBounds.width, gridBounds.y + gridBounds.height);
            bottom.addPoint(bottom.xpoints[0], bottom.ypoints[0]);
        }
        Color chartBackground = this.chart.getChartBackground();
        Color chartBackground2 = this.chart.getChartBackground2();
        g.setColor(chartBackground);
        if (chartBackground2 != null) {
            gp = new GradientPaint(0.0f, gridBounds.y + gridBounds.height, chartBackground2, 0.0f, gridBounds.y, chartBackground);
            ((Graphics2D)g).setPaint(gp);
        } else {
            g.setColor(this.chart.getChartBackground());
        }
        g.fillRect(gridBounds.x, gridBounds.y, gridBounds.width, gridBounds.height);
        if (this.display3dOn) {
            if (chartBackground2 != null) {
                gp = new GradientPaint(0.0f, gridBounds.y, chartBackground, 0.0f, gridBounds.y + gridBounds.height, chartBackground2);
                ((Graphics2D)g).setPaint(gp);
            } else {
                g.setColor(this.gridAlignment == 1 ? chartBackground : GridRenderer.getDarker(chartBackground));
            }
            g.fillPolygon(left);
            if (chartBackground2 != null) {
                gp = new GradientPaint(gridBounds.x, 0.0f, chartBackground2, gridBounds.x + gridBounds.width * 2, 0.0f, chartBackground);
                ((Graphics2D)g).setPaint(gp);
            } else {
                g.setColor(this.gridAlignment == 0 ? chartBackground : GridRenderer.getDarker(chartBackground));
            }
            g.fillPolygon(bottom);
        }
        Dimension image_size = this.getImageSize(this.chart.gridImage);
        if (this.chart.gridImage != null && image_size.height > 0 && image_size.width > 0 && (image = this.chart.getImage(this.chart.gridImage)) != null) {
            g.drawImage(image, gridBounds.x, gridBounds.y, gridBounds.width, gridBounds.height, this.chart);
        }
        for (int i = grid.getRangeCount() - 1; i >= 0; --i) {
            this.paintRange(g, grid, gridBounds, i);
        }
        g.setColor(this.chart.getChartForeground());
        if (this.display3dOn) {
            g.drawPolygon(left);
            g.drawPolygon(bottom);
        }
        g.drawRect(gridBounds.x, gridBounds.y, gridBounds.width, gridBounds.height);
        g.setFont(this.getFont("rangeLabelFont"));
        Enumeration e = grid.targetsLabel.keys();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            int targetRange = (Integer)grid.targetsRange.get(id);
            String target = grid.getTargetLabel(id);
            Double value = (Double)grid.targetsValue.get(id);
            Color color = (Color)grid.targetsColor.get(id);
            if (value == null || targetRange >= this.rangeBounds.length) continue;
            this.paintGridLine(g, grid, gridBounds, value, color, target, color, true, true, targetRange, 0);
        }
        g.setColor(this.chart.getChartForeground());
        if (this.getLabel("sampleAxisLabel") != null) {
            int y;
            int x;
            String chartType = this.chart.chartType;
            Dimension sampleLabel = new Dimension();
            boolean adjust_for_sample = this.chart.sampleLabelsOn;
            adjust_for_sample &= this.chart.sampleLabelStyle == 2 || this.chart.sampleLabelStyle == 4;
            if (adjust_for_sample |= chartType.equals("bar") && this.chart.barLabelsOn) {
                Font font = this.chart.getFont();
                int angle = 0;
                if (chartType.equals("bar")) {
                    font = this.getFont("barLabelFont");
                    angle = this.chart.barLabelsOn ? this.getLabelAngle("barLabelAngle") : this.getLabelAngle("sampleLabelAngle");
                } else if (chartType.equals("line")) {
                    font = this.getFont("sampleLabelFont");
                    angle = this.getLabelAngle("sampleLabelAngle");
                }
                String[] labels = this.chart.barLabels != null ? this.chart.barLabels : this.chart.getSampleLabels();
                FontMetrics sample_label_fm = this.getFontMetrics(font);
                for (int i = 0; i < labels.length; ++i) {
                    Dimension labelSize = this.getLabelSize(labels[i], sample_label_fm);
                    Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
                    sampleLabel.width = Math.max(sampleLabel.width, angledSize.width);
                    sampleLabel.height = Math.max(sampleLabel.height, angledSize.height);
                }
                if (angle % 180 != 0) {
                    sampleLabel.height += 3;
                }
            }
            String label = this.getLabel("sampleAxisLabel");
            Font sampleAxisLabelFont = this.getFont("sampleAxisLabelFont");
            FontMetrics fm = this.getFontMetrics(sampleAxisLabelFont);
            g.setFont(sampleAxisLabelFont);
            int angle = this.getLabelAngle("sampleAxisLabelAngle");
            angle = this.gridAlignment == 0 ? angle : 0;
            Dimension labelSize = this.getLabelSize(label, fm);
            Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
            if (this.gridAlignment == 1) {
                x = gridBounds.x + gridBounds.width / 2 - angledSize.width / 2;
                y = gridBounds.y + gridBounds.height + 7;
                if (angle % 180 == 0) {
                    y += fm.getMaxAscent() - 2;
                }
                if (this.display3dOn) {
                    x -= this.depth3dPoint.x;
                    y -= this.depth3dPoint.y;
                }
                y += sampleLabel.height + 1;
                if (grid.isSampleScrollerOn()) {
                    y += 10;
                }
            } else {
                x = gridBounds.x - angledSize.width - 5;
                y = gridBounds.y + gridBounds.height / 2 - angledSize.height / 2;
                if (angle % 180 == 0) {
                    y += fm.getAscent();
                }
                if (adjust_for_sample) {
                    x -= sampleLabel.width + 5;
                }
                if (this.display3dOn) {
                    y -= this.depth3dPoint.y;
                    x -= this.depth3dPoint.x;
                }
                if (grid.isSampleScrollerOn()) {
                    x -= 10;
                }
            }
            this.paintLabel(g, label, x, y, labelSize, 0, angle, false);
        }
        for (int i = 0; i < grid.getRangeCount(); ++i) {
            this.paintRangeAdjuster(g, grid, gridBounds, i);
        }
        if (grid.isSampleScrollerOn()) {
            this.paintSampleScroller(g, gridBounds);
        }
    }

    private double getTickStep(Grid grid, Rectangle bounds, int index, FontMetrics fm) {
        double step;
        long valueLineCount;
        String postfix;
        String prefix;
        int decimals = grid.getRangeDecimalCount(index);
        double upperRange = grid.getRange(index);
        double lowerRange = grid.getLowerRange(index);
        double currentUpperRange = grid.getCurrentRange(index);
        double currentLowerRange = grid.getCurrentLowerRange(index);
        double rangeInterval = grid.getRangeInterval(index);
        if (index == 0) {
            prefix = this.getLabel("rangeLabelPrefix");
            postfix = this.getLabel("rangeLabelPostfix");
        } else {
            prefix = this.getLabel("rangeLabelPrefix_" + (index + 1));
            postfix = this.getLabel("rangeLabelPostfix_" + (index + 1));
        }
        if (this.gridAlignment == 1) {
            valueLineCount = (int)Math.round((double)bounds.height / (double)fm.getHeight());
        } else {
            String upper = this.chart.formatRangeNumber(index, upperRange);
            String lower = this.chart.formatRangeNumber(index, lowerRange);
            if (prefix != null && prefix.length() > 0) {
                upper = prefix + upper;
                lower = prefix + lower;
            }
            if (postfix != null && postfix.length() > 0) {
                upper = upper + postfix;
                lower = lower + postfix;
            }
            int range_label_width = Math.max(fm.stringWidth(upper), fm.stringWidth(lower));
            valueLineCount = (int)Math.round((double)bounds.width / (double)range_label_width);
        }
        valueLineCount = Math.min((long)grid.maxValueLineCount, valueLineCount);
        long count = Math.round(Math.abs(currentUpperRange - currentLowerRange) * Math.pow(10.0, decimals));
        valueLineCount = Math.min(valueLineCount, count + 1L);
        valueLineCount = Math.max(2L, valueLineCount);
        double raw_step = (currentUpperRange - currentLowerRange) / (double)valueLineCount;
        raw_step = Math.abs(raw_step);
        if (index < grid.getRangeCount() && rangeInterval > 0.0) {
            step = rangeInterval;
            double multiplier = 1.0;
            while (step < raw_step) {
                for (int i = 0; i < STEPS.length; ++i) {
                    if (!(STEPS[i] * multiplier * step >= raw_step)) continue;
                    step = STEPS[i] * multiplier * step;
                    break;
                }
                multiplier *= 10.0;
            }
        } else {
            step = raw_step;
            boolean stepFound = false;
            double multiplier = 10.0;
            while (!stepFound && multiplier * 1.0E-12 < 1.0E14) {
                for (int i = 0; i < STEPS.length; ++i) {
                    if (!(STEPS[i] * multiplier * 1.0E-12 >= raw_step)) continue;
                    step = STEPS[i] * multiplier * 1.0E-12;
                    stepFound = true;
                    break;
                }
                multiplier *= 10.0;
            }
        }
        return step;
    }

    private void paintRange(Graphics g, Grid grid, Rectangle gridBounds, int index) {
        int i;
        String label;
        double value;
        int step_count;
        int y;
        int x;
        String postfix;
        String prefix;
        if (!grid.isRangeOn(index = Math.max(0, index)) || index >= this.rangeBounds.length || this.rangeBounds[index] == null) {
            return;
        }
        int rangePosition = grid.getRangePosition(index);
        double currentUpperRange = grid.getCurrentRange(index);
        double currentLowerRange = grid.getCurrentLowerRange(index);
        boolean rangeLabelsOn = grid.isRangeLabelsOn(index);
        boolean valueLinesOn = grid.isValueLinesOn();
        boolean rangeAdjusterOn = grid.isRangeAdjusterOn(index);
        double[] defaultGridLines = grid.defaultGridLines;
        double[] gridLines = grid.getGridLines();
        Color defaultGridLinesColor = grid.defaultGridLinesColor;
        Color valueLinesColor = grid.getValueLinesColor();
        Color[] gridLineColors = grid.getGridLineColors();
        if (index == 0) {
            prefix = this.getLabel("rangeLabelPrefix");
            postfix = this.getLabel("rangeLabelPostfix");
        } else {
            prefix = this.getLabel("rangeLabelPrefix_" + (index + 1));
            postfix = this.getLabel("rangeLabelPostfix_" + (index + 1));
        }
        Font rangeLabelFont = this.getFont("rangeLabelFont");
        FontMetrics fm = this.getFontMetrics(rangeLabelFont);
        g.setFont(rangeLabelFont);
        Color rangeLabelColor = grid.getRangeColor(index);
        g.setColor(rangeLabelColor);
        Rectangle b = this.rangeBounds[index];
        if (this.gridAlignment == 1) {
            if (rangePosition == 0 && b.x + b.width != gridBounds.x) {
                x = b.x + b.width - (this.display3dOn ? this.depth3dPoint.x : 0);
                y = b.y - (this.display3dOn ? this.depth3dPoint.y : 0);
                int height = b.height;
                g.drawLine(x, y, x, y + height);
            } else if (rangePosition == 1 && b.x != gridBounds.x + gridBounds.width) {
                g.drawLine(b.x, b.y, b.x, b.y + b.height);
            }
        } else if (rangePosition == 0 && b.y != gridBounds.y + gridBounds.height - (this.display3dOn ? this.depth3dPoint.y : 0)) {
            x = b.x - (this.display3dOn ? this.depth3dPoint.x : 0);
            y = b.y - (this.display3dOn ? this.depth3dPoint.y : 0);
            g.drawLine(x, y, x + gridBounds.width, y);
        } else if (rangePosition == 1 && b.y + b.height != gridBounds.y) {
            x = b.x;
            y = b.y + b.height;
            g.drawLine(x, y, x + b.width, y);
        }
        double step = this.getTickStep(grid, b, index, fm);
        if (currentUpperRange < currentLowerRange) {
            step = -step;
        }
        if ((step_count = (int)(currentUpperRange / step)) % 2 == 0) {
            ++step_count;
        }
        double upper = step * (double)step_count;
        if (index == 0 && this.chart.getAlternateChartBackground() != null) {
            double i2 = upper - step;
            while (step > 0.0 && upper > currentLowerRange || step < 0.0 && upper < currentLowerRange) {
                this.paintGridHighlight(g, grid, gridBounds, upper, i2, index, 0);
                upper -= step + step;
                i2 -= step + step;
            }
        }
        step = Math.abs(step);
        if (currentUpperRange > currentLowerRange && currentUpperRange > 0.0) {
            for (value = Math.max(0.0, currentLowerRange - currentLowerRange % step + step); value < currentUpperRange; value += step) {
                if (value == 0.0) continue;
                String string = label = rangeLabelsOn ? this.chart.formatRangeNumber(index, value) : null;
                if (label != null && prefix != null) {
                    label = prefix + label;
                }
                if (label != null && postfix != null) {
                    label = label + postfix;
                }
                this.paintGridLine(g, grid, gridBounds, value, valueLinesColor, label, rangeLabelColor, index == 0 && valueLinesOn, false, index, 0);
            }
        } else if (currentUpperRange < currentLowerRange && currentUpperRange < 0.0) {
            for (value = Math.min(0.0, currentLowerRange - currentLowerRange % step - step); value > currentUpperRange; value -= step) {
                if (value == 0.0) continue;
                String string = label = rangeLabelsOn ? this.chart.formatRangeNumber(index, value) : null;
                if (label != null && prefix != null) {
                    label = prefix + label;
                }
                if (label != null && postfix != null) {
                    label = label + postfix;
                }
                this.paintGridLine(g, grid, gridBounds, value, valueLinesColor, label, rangeLabelColor, index == 0 && valueLinesOn, false, index, 0);
            }
        }
        if (currentUpperRange > currentLowerRange && currentLowerRange < 0.0) {
            for (value = Math.min(0.0, currentUpperRange - currentUpperRange % step - step); value > currentLowerRange; value -= step) {
                if (value == 0.0) continue;
                String string = label = rangeLabelsOn ? this.chart.formatRangeNumber(index, value) : null;
                if (label != null && prefix != null) {
                    label = prefix + label;
                }
                if (label != null && postfix != null) {
                    label = label + postfix;
                }
                this.paintGridLine(g, grid, gridBounds, value, valueLinesColor, label, rangeLabelColor, index == 0 && valueLinesOn, false, index, 0);
            }
        } else if (currentUpperRange < currentLowerRange && currentLowerRange > 0.0) {
            for (value = Math.max(0.0, currentUpperRange - currentUpperRange % step + step); value < currentLowerRange; value += step) {
                if (value == 0.0) continue;
                String string = label = rangeLabelsOn ? this.chart.formatRangeNumber(index, value) : null;
                if (label != null && prefix != null) {
                    label = prefix + label;
                }
                if (label != null && postfix != null) {
                    label = label + postfix;
                }
                this.paintGridLine(g, grid, gridBounds, value, valueLinesColor, label, rangeLabelColor, index == 0 && valueLinesOn, false, index, 0);
            }
        }
        if (rangeLabelsOn) {
            String label2 = this.chart.formatRangeNumber(index, currentUpperRange);
            label2 = prefix != null ? prefix + label2 : label2;
            label2 = postfix != null ? label2 + postfix : label2;
            this.paintGridLine(g, grid, gridBounds, currentUpperRange, this.chart.getChartForeground(), label2, rangeLabelColor, index == 0, false, index, 0);
            label2 = rangeLabelsOn ? this.chart.formatRangeNumber(index, currentLowerRange) : null;
            label2 = prefix != null ? prefix + label2 : label2;
            label2 = postfix != null ? label2 + postfix : label2;
            this.paintGridLine(g, grid, gridBounds, currentLowerRange, this.chart.getChartForeground(), label2, rangeLabelColor, index == 0, false, index, 0);
        }
        if (rangeLabelsOn && currentUpperRange != 0.0 && currentLowerRange != 0.0) {
            String label3 = "0";
            label3 = prefix != null ? prefix + label3 : label3;
            label3 = postfix != null ? label3 + postfix : label3;
            this.paintGridLine(g, grid, gridBounds, 0.0, index == 0 ? this.chart.getChartForeground() : rangeLabelColor, label3, rangeLabelColor, true, false, index, 0);
        }
        if (this.chart.getAlternateChartBackground() != null) {
            Polygon poly = new Polygon();
            poly.addPoint(gridBounds.x, gridBounds.y + gridBounds.height);
            poly.addPoint(gridBounds.x + gridBounds.width, gridBounds.y + gridBounds.height);
            poly.addPoint(gridBounds.x + gridBounds.width - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
            poly.addPoint(gridBounds.x - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
            g.setClip(poly);
            for (int i3 = 0; defaultGridLines != null && i3 < defaultGridLines.length; i3 += 2) {
                if (i3 < defaultGridLines.length - 1) {
                    this.paintGridHighlight(g, grid, gridBounds, defaultGridLines[i3], defaultGridLines[i3 + 1], 0, 1);
                    continue;
                }
                this.paintGridHighlight(g, grid, gridBounds, defaultGridLines[i3], 100.0, 0, 1);
            }
            g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        }
        for (i = 0; defaultGridLines != null && i < defaultGridLines.length; ++i) {
            this.paintGridLine(g, grid, gridBounds, defaultGridLines[i], defaultGridLinesColor, null, null, true, false, 0, 1);
        }
        if (this.chart instanceof BarChart && ((BarChart)this.chart).getBarType() != 1) {
            if (defaultGridLines != null && defaultGridLines.length > 0) {
                g.setColor(defaultGridLinesColor);
            } else if (valueLinesOn) {
                g.setColor(defaultGridLinesColor);
            } else {
                g.setColor(this.chart.getChartForeground());
            }
            for (int series = 0; series < this.chart.getSeriesCount(); ++series) {
                if (this.chart.chartType != "line" && (this.chart.chartType != "bar" || ((BarChart)this.chart).getBarType() != 2)) continue;
                double depth_x = (double)this.depth3dPoint.x / (double)this.chart.getSeriesCount() * (double)series;
                double depth_y = (double)this.depth3dPoint.y / (double)this.chart.getSeriesCount() * (double)series;
                g.drawLine(gridBounds.x - (int)depth_x, gridBounds.y + gridBounds.height - (int)depth_y, gridBounds.x + gridBounds.width - (int)depth_x, gridBounds.y + gridBounds.height - (int)depth_y);
                g.drawLine(gridBounds.x - (int)depth_x, gridBounds.y - (int)depth_y, gridBounds.x - (int)depth_x, gridBounds.y + gridBounds.height - (int)depth_y);
            }
        }
        if (gridLines != null) {
            for (i = 0; i < gridLines.length; ++i) {
                Color color = defaultGridLinesColor;
                if (gridLineColors != null && gridLineColors.length > i && gridLineColors[i] != null) {
                    color = gridLineColors[i];
                }
                this.paintGridLine(g, grid, gridBounds, gridLines[i], color, null, null, true, true, 0, 1);
            }
        }
        String rangeAxisLabel = null;
        if (index == 0) {
            rangeAxisLabel = this.getLabel("rangeAxisLabel");
        } else if (index > 0) {
            rangeAxisLabel = this.getLabel("rangeAxisLabel_" + (index + 1));
        }
        if (rangeAxisLabel != null) {
            int label_y;
            int label_x;
            Font range_axis_label_font = this.getFont("rangeAxisLabelFont");
            fm = this.getFontMetrics(range_axis_label_font);
            g.setFont(range_axis_label_font);
            g.setColor(rangeLabelColor);
            int angle = index == 0 ? this.getLabelAngle("rangeAxisLabelAngle") : this.getLabelAngle("rangeAxisLabelAngle_" + (index + 1));
            angle = this.gridAlignment == 1 ? angle : 0;
            Dimension labelSize = this.getLabelSize(rangeAxisLabel, fm);
            Dimension angledSize = this.getAngledLabelSize(labelSize, angle);
            if (this.gridAlignment == 1) {
                if (rangePosition == 0) {
                    int widest = this.getRangeWidth(grid, index, true, true);
                    label_x = this.rangeBounds[index].x + this.rangeBounds[index].width - angledSize.width - widest - 9;
                    if (rangeAdjusterOn && grid.getAdjusterPosition(index) == rangePosition) {
                        label_x -= 6;
                    }
                    if (this.display3dOn) {
                        label_x -= this.depth3dPoint.x;
                    }
                } else {
                    int widest = this.getRangeWidth(grid, index, true, true);
                    label_x = this.rangeBounds[index].x + widest + 9;
                    if (rangeAdjusterOn && grid.getAdjusterPosition(index) == rangePosition) {
                        label_x += 6;
                    }
                }
                label_y = gridBounds.y + gridBounds.height / 2 - angledSize.height / 2;
                if (angle % 180 == 0) {
                    label_y += fm.getAscent();
                }
                if (this.display3dOn && rangePosition == 0) {
                    label_y -= this.depth3dPoint.y;
                }
            } else {
                label_x = gridBounds.x + gridBounds.width / 2 - angledSize.width / 2;
                if (rangePosition == 0) {
                    label_y = this.rangeBounds[index].y + 5 + this.getRangeWidth(grid, index, true, true) + (angle % 180 == 0 ? fm.getMaxAscent() - 3 : 0);
                    if (rangeAdjusterOn && grid.getAdjusterPosition(index) == rangePosition) {
                        label_y += 6;
                    }
                } else {
                    label_y = this.rangeBounds[index].y + this.rangeBounds[index].height - 7 - this.getRangeWidth(grid, index, true, true);
                    if (rangeAdjusterOn && grid.getAdjusterPosition(index) == rangePosition) {
                        label_y -= 6;
                    }
                }
                if (this.display3dOn && rangePosition == 0) {
                    label_y -= this.depth3dPoint.y;
                    label_x -= this.depth3dPoint.x;
                }
            }
            this.paintLabel(g, rangeAxisLabel, label_x, label_y, labelSize, 0, angle, false);
        }
    }

    private void paintRangeAdjuster(Graphics g, Grid grid, Rectangle gridBounds, int adjuster) {
        adjuster = Math.max(0, adjuster);
        boolean rangeOn = grid.isRangeOn(adjuster);
        boolean rangeAdjusterOn = grid.isRangeAdjusterOn(adjuster);
        if (!rangeOn || !rangeAdjusterOn || adjuster >= this.rangeBounds.length || this.rangeBounds[adjuster] == null) {
            return;
        }
        int rangeIndex = grid.getRangeAdjusted(adjuster);
        if (rangeIndex == -1) {
            rangeIndex = adjuster;
        }
        double upperRange = grid.getRange(rangeIndex);
        double lowerRange = grid.getLowerRange(rangeIndex);
        double currentUpperRange = grid.getCurrentRange(rangeIndex);
        double currentLowerRange = grid.getCurrentLowerRange(rangeIndex);
        int rangePosition = grid.getRangePosition(rangeIndex);
        int rangeAdjusterPosition = grid.getRangeAdjusterPosition();
        Rectangle b = this.rangeBounds[adjuster];
        if (this.gridAlignment == 1) {
            int xpos;
            int ypos = b.y;
            if (rangePosition == 0) {
                xpos = b.x + b.width - 5 - (this.display3dOn ? this.depth3dPoint.x : 0);
                ypos -= this.display3dOn ? this.depth3dPoint.y : 0;
            } else {
                xpos = b.x + 5;
            }
            if (grid.getRangeCount() > 2) {
                rangeAdjusterPosition = grid.getRangePosition(0);
            }
            if (adjuster == 0) {
                if (rangeAdjusterPosition == 0) {
                    xpos = gridBounds.x - 5 - (this.display3dOn ? this.depth3dPoint.x : 0);
                    ypos = b.y - (this.display3dOn ? this.depth3dPoint.y : 0);
                } else {
                    xpos = gridBounds.x + gridBounds.width + 5;
                    ypos = b.y;
                }
            }
            g.setColor(this.chart.getBackground().darker());
            g.drawLine(xpos, ypos, xpos, ypos + b.height);
            g.setColor(this.chart.getBackground().brighter());
            g.drawLine(xpos + 1, ypos, xpos + 1, ypos + b.height);
            double factor_u = 0.0;
            double factor_l = 0.0;
            if (upperRange - lowerRange != 0.0) {
                factor_u = (currentUpperRange - lowerRange) / (upperRange - lowerRange);
                factor_l = (currentLowerRange - lowerRange) / (upperRange - lowerRange);
            }
            int upper_y = (int)Math.round((double)(ypos + b.height) - factor_u * (double)b.height);
            int lower_y = (int)Math.round((double)(ypos + b.height) - factor_l * (double)b.height);
            this.rangeAdjusterBounds[adjuster].setBounds(xpos - 3, upper_y, 7, lower_y - upper_y);
            this.paintBox(g, Color.lightGray, xpos - 3, upper_y, 6, lower_y - upper_y, false);
            g.setColor(Color.gray);
            g.drawLine(xpos - 2, upper_y + 2, xpos + 2, upper_y + 2);
            g.setColor(Color.white);
            g.drawLine(xpos - 2, lower_y - 2, xpos + 2, lower_y - 2);
        } else {
            int ypos;
            int xpos = b.x;
            if (rangePosition == 0) {
                ypos = b.y + 5;
                xpos -= this.display3dOn ? this.depth3dPoint.x : 0;
            } else {
                ypos = b.y + b.height - 5;
            }
            if (grid.getRangeCount() > 2) {
                rangeAdjusterPosition = grid.getRangePosition(0);
            }
            if (adjuster == 0) {
                if (rangeAdjusterPosition == 0) {
                    xpos = b.x - (this.display3dOn ? this.depth3dPoint.x : 0);
                    ypos = gridBounds.y + gridBounds.height + 5 - (this.display3dOn ? this.depth3dPoint.y : 0);
                } else {
                    xpos = b.x;
                    ypos = gridBounds.y - 5;
                }
            }
            g.setColor(this.chart.getBackground().darker());
            g.drawLine(xpos, ypos, xpos + b.width, ypos);
            g.setColor(this.chart.getBackground().brighter());
            g.drawLine(xpos, ypos + 1, xpos + b.width, ypos + 1);
            double factor_u = 0.0;
            double factor_l = 0.0;
            if (upperRange - lowerRange != 0.0) {
                factor_u = (currentUpperRange - lowerRange) / (upperRange - lowerRange);
                factor_l = (currentLowerRange - lowerRange) / (upperRange - lowerRange);
            }
            int lower_x = (int)Math.round((double)xpos + factor_l * (double)b.width);
            int upper_x = (int)Math.round((double)xpos + factor_u * (double)b.width);
            this.rangeAdjusterBounds[adjuster].setBounds(lower_x, ypos - 3, upper_x - lower_x, 7);
            this.paintBox(g, Color.lightGray, lower_x, ypos - 3, upper_x - lower_x, 6, false);
            g.setColor(Color.gray);
            g.drawLine(lower_x + 2, ypos - 2, lower_x + 2, ypos + 2);
            g.setColor(Color.white);
            g.drawLine(upper_x - 2, ypos - 2, upper_x - 2, ypos + 2);
        }
    }

    private void paintSampleScroller(Graphics g, Rectangle bounds) {
        if (this.gridAlignment == 1) {
            int xpos = bounds.x;
            int ypos = bounds.y + bounds.height + 1;
            if (this.display3dOn) {
                xpos -= this.depth3dPoint.x;
                ypos -= this.depth3dPoint.y;
            }
            this.sampleScrollerBounds.x = xpos;
            this.sampleScrollerBounds.y = ypos;
            this.sampleScrollerBounds.height = 8;
            this.sampleScrollerBounds.width = bounds.width;
            g.setColor(this.chart.getBackground().darker());
            g.drawLine(xpos, ypos + 4, xpos + this.sampleScrollerBounds.width, ypos + 4);
            g.setColor(this.chart.getBackground().brighter());
            g.drawLine(xpos, ypos + 5, xpos + this.sampleScrollerBounds.width, ypos + 5);
            this.paintBox(g, Color.lightGray, xpos, ypos, 8, 8, this.leftPushed);
            int n = this.leftPushed ? 1 : 0;
            g.setColor(Color.black);
            g.drawLine((xpos += n) + 3, ypos + 4, xpos + 3, ypos + 4);
            g.drawLine(xpos + 4, ypos + 3, xpos + 4, ypos + 5);
            g.drawLine(xpos + 5, ypos + 2, xpos + 5, ypos + 6);
            xpos = this.sampleScrollerBounds.x + this.sampleScrollerBounds.width - 8;
            this.paintBox(g, Color.lightGray, xpos, ypos, 8, 8, this.rightPushed);
            int n2 = this.rightPushed ? 1 : 0;
            g.setColor(Color.black);
            g.drawLine((xpos += n2) + 3, ypos + 2, xpos + 3, ypos + 6);
            g.drawLine(xpos + 4, ypos + 3, xpos + 4, ypos + 5);
            g.drawLine(xpos + 5, ypos + 4, xpos + 5, ypos + 4);
            this.sampleScrollerSpace = this.sampleScrollerBounds.width - 18 - 8;
            int leftSpace = (int)Math.round(this.leftScrollerFactor * (double)this.sampleScrollerSpace);
            xpos = bounds.x + 9 + leftSpace;
            if (this.display3dOn) {
                xpos -= this.depth3dPoint.x;
            }
            int rightSpace = (int)Math.round(this.rightScrollerFactor * (double)this.sampleScrollerSpace);
            int width = this.sampleScrollerSpace + 8 - rightSpace - leftSpace;
            this.leftAdjusterPos = xpos;
            this.rightAdjusterPos = this.leftAdjusterPos + width;
            this.paintBox(g, Color.lightGray, xpos, ypos, width, 8, false);
            g.setColor(Color.gray);
            g.drawLine(xpos + 2, ypos + 1, xpos + 2, ypos + 7);
            g.setColor(Color.white);
            g.drawLine(xpos + width - 2, ypos + 1, xpos + width - 2, ypos + 7);
        } else {
            int xpos = bounds.x - 10;
            int ypos = bounds.y;
            if (this.display3dOn) {
                xpos -= this.depth3dPoint.x;
                ypos -= this.depth3dPoint.y;
            }
            this.sampleScrollerBounds.x = xpos;
            this.sampleScrollerBounds.y = ypos;
            this.sampleScrollerBounds.height = bounds.height;
            this.sampleScrollerBounds.width = 7;
            g.setColor(this.chart.getBackground().darker());
            g.drawLine(xpos + 4, ypos, xpos + 4, ypos + this.sampleScrollerBounds.height);
            g.setColor(this.chart.getBackground().brighter());
            g.drawLine(xpos + 5, ypos, xpos + 5, ypos + this.sampleScrollerBounds.height);
            this.paintBox(g, Color.lightGray, xpos, ypos, 8, 8, this.leftPushed);
            int n = this.leftPushed ? 1 : 0;
            g.setColor(Color.black);
            g.drawLine(xpos + 4, (ypos += n) + 3, xpos + 4, ypos + 3);
            g.drawLine(xpos + 3, ypos + 4, xpos + 5, ypos + 4);
            g.drawLine(xpos + 2, ypos + 5, xpos + 6, ypos + 5);
            ypos = this.sampleScrollerBounds.y + this.sampleScrollerBounds.height - 8;
            this.paintBox(g, Color.lightGray, xpos, ypos, 8, 8, this.rightPushed);
            int n3 = this.rightPushed ? 1 : 0;
            g.setColor(Color.black);
            g.drawLine(xpos + 4, (ypos += n3) + 5, xpos + 4, ypos + 5);
            g.drawLine(xpos + 3, ypos + 4, xpos + 5, ypos + 4);
            g.drawLine(xpos + 2, ypos + 3, xpos + 6, ypos + 3);
            this.sampleScrollerSpace = this.sampleScrollerBounds.height - 18 - 8;
            int topSpace = (int)Math.round(this.leftScrollerFactor * (double)this.sampleScrollerSpace);
            ypos = bounds.y + 9 + topSpace;
            if (this.display3dOn) {
                ypos -= this.depth3dPoint.y;
            }
            int bottomSpace = (int)Math.round(this.rightScrollerFactor * (double)this.sampleScrollerSpace);
            int height = this.sampleScrollerSpace + 8 - bottomSpace - topSpace;
            this.leftAdjusterPos = ypos;
            this.rightAdjusterPos = this.leftAdjusterPos + height;
            this.paintBox(g, Color.lightGray, xpos, ypos, 8, height, false);
            g.setColor(Color.gray);
            g.drawLine(xpos + 1, ypos + 2, xpos + 7, ypos + 2);
            g.setColor(Color.white);
            g.drawLine(xpos + 1, ypos + height - 2, xpos + 7, ypos + height - 2);
        }
    }

    private void paintGridLine(Graphics g, Grid grid, Rectangle gridBounds, double value, Color color, String label, Color labelColor, boolean lineOn, boolean target, int index, int align) {
        double factor = 0.0;
        int rangePosition = grid.getRangePosition(index);
        int adjusterPosition = grid.getAdjusterPosition(index);
        int targetLabelsPosition = grid.getTargetLabelsPosition();
        double currentUpperRange = grid.getCurrentRange(index);
        double currentLowerRange = grid.getCurrentLowerRange(index);
        double rightSampleAxisRange = grid.rightSampleAxisRange;
        double leftSampleAxisRange = grid.leftSampleAxisRange;
        Rectangle b = this.rangeBounds[index];
        if (align == 0) {
            index = Math.max(0, Math.min(grid.getRangeCount() - 1, index));
            if (currentUpperRange - currentLowerRange != 0.0) {
                factor = (value - currentLowerRange) / (currentUpperRange - currentLowerRange);
            }
        } else if (align == 1) {
            double currentMaxRange;
            double currentMinRange;
            Rectangle bounds = this.getDataBounds(grid);
            if (this.gridAlignment == 1) {
                currentMinRange = (double)(gridBounds.x - bounds.x) / (double)bounds.width * (rightSampleAxisRange - leftSampleAxisRange) + leftSampleAxisRange;
                currentMaxRange = (double)(gridBounds.width + gridBounds.x - bounds.x) / (double)bounds.width * (rightSampleAxisRange - leftSampleAxisRange) + leftSampleAxisRange;
            } else {
                currentMinRange = (double)(gridBounds.y - bounds.y) / (double)bounds.height * (rightSampleAxisRange - leftSampleAxisRange) + leftSampleAxisRange;
                currentMaxRange = (double)(gridBounds.height + gridBounds.y - bounds.y) / (double)bounds.height * (rightSampleAxisRange - leftSampleAxisRange) + leftSampleAxisRange;
            }
            factor = (value - currentMinRange) / (currentMaxRange - currentMinRange);
        }
        FontMetrics fm = g.getFontMetrics();
        int fheight = fm.getHeight();
        int descent = fm.getDescent();
        int label_width = label != null ? fm.stringWidth(label) : 0;
        int range_pos = rangePosition;
        if (target && index == 0 && targetLabelsPosition != -1) {
            range_pos = targetLabelsPosition;
        }
        if (this.gridAlignment == 1 && align == 0 || this.gridAlignment == 0 && align == 1) {
            int position = (int)Math.round((double)(b.y + b.height) - factor * (double)b.height);
            boolean inside = position > b.y && position < b.y + b.height;
            boolean room = position - fheight / 2 > b.y + descent / 2;
            room &= position + fheight / 2 < b.y + b.height - descent / 2;
            room |= align == 0 && value == 0.0;
            if (align == 1) {
                position = (int)Math.round((double)gridBounds.y + factor * (double)gridBounds.height);
                inside = position > gridBounds.y && position < gridBounds.y + gridBounds.height;
                room = position - fheight / 2 > gridBounds.y + descent / 2;
                room &= position + fheight / 2 < gridBounds.y + gridBounds.height - descent / 2;
                room |= position > gridBounds.y && position < gridBounds.y + gridBounds.height;
            }
            if (inside && (room || target) || align == 0 && (value == currentLowerRange || value == currentUpperRange)) {
                if (lineOn) {
                    g.setColor(color);
                    g.drawLine(gridBounds.x + 1, position, gridBounds.x + gridBounds.width - 1, position);
                    if (this.display3dOn) {
                        g.drawLine(gridBounds.x, position, gridBounds.x - this.depth3dPoint.x, position - this.depth3dPoint.y);
                    }
                }
                if (label != null) {
                    int label_x;
                    position -= this.display3dOn && range_pos == 0 ? this.depth3dPoint.y : 0;
                    g.setColor(labelColor);
                    if (range_pos == 0) {
                        int xpos = b.x + b.width - (this.display3dOn ? this.depth3dPoint.x : 0);
                        if (target && index == 0) {
                            xpos = gridBounds.x - (this.display3dOn ? this.depth3dPoint.x : 0);
                        }
                        g.drawLine(xpos, position, xpos - 3, position);
                        label_x = xpos - label_width - 4;
                        if (grid.isRangeAdjusterOn(index) && adjusterPosition == range_pos) {
                            label_x -= 6;
                        }
                    } else {
                        int xpos = b.x;
                        if (target && index == 0) {
                            xpos = gridBounds.x + gridBounds.width;
                        }
                        g.drawLine(xpos, position, xpos + 2, position);
                        label_x = xpos + 5;
                        if (index == 1 && grid.isRangeAdjusterOn(0) && adjusterPosition == 1 || grid.isRangeAdjusterOn(index) && adjusterPosition == range_pos) {
                            label_x += 7;
                        }
                    }
                    int label_y = position + fheight - fm.getAscent() + 1;
                    g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
                    g.drawString(label, label_x, label_y);
                }
            }
        } else {
            String postfix;
            String prefix;
            if (index == 0) {
                prefix = this.getLabel("rangeLabelPrefix");
                postfix = this.getLabel("rangeLabelPostfix");
            } else {
                prefix = this.getLabel("rangeLabelPrefix_" + (index + 1));
                postfix = this.getLabel("rangeLabelPostfix_" + (index + 1));
            }
            String upper = this.chart.formatRangeNumber(index, currentUpperRange);
            String lower = this.chart.formatRangeNumber(index, currentLowerRange);
            if (prefix != null && prefix.length() > 0) {
                upper = prefix + upper;
                lower = prefix + lower;
            }
            if (postfix != null && postfix.length() > 0) {
                upper = upper + postfix;
                lower = lower + postfix;
            }
            int position = (int)(index != 0 || value != 0.0 ? Math.round((double)b.x + factor * (double)b.width) : (long)this.zeroLine[index]);
            boolean inside = position > b.x && position < b.x + b.width;
            boolean room = position - label_width / 2 > b.x + fm.stringWidth(lower) / 2;
            room &= position + label_width / 2 < b.x + b.width - fm.stringWidth(upper) / 2;
            room |= align == 0 && value == 0.0;
            if (align == 1) {
                position = (int)Math.round((double)gridBounds.x + factor * (double)gridBounds.width);
                inside = position > gridBounds.x && position < gridBounds.x + gridBounds.width;
                room = position - label_width / 2 > gridBounds.x + fm.stringWidth(lower) / 2;
                room &= position + label_width / 2 < gridBounds.x + gridBounds.width - fm.stringWidth(upper) / 2;
                room |= position > gridBounds.x && position < gridBounds.x + gridBounds.width;
            }
            if (inside && (room || target) || align == 0 && (value == currentLowerRange || value == currentUpperRange)) {
                if (lineOn) {
                    g.setColor(color);
                    g.drawLine(position, gridBounds.y + 1, position, gridBounds.y + gridBounds.height - 1);
                    if (this.display3dOn) {
                        g.drawLine(position, gridBounds.y + gridBounds.height, position - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
                    }
                }
                if (label != null) {
                    int label_y;
                    g.setColor(labelColor);
                    position -= this.display3dOn && range_pos == 0 ? this.depth3dPoint.x : 0;
                    if (range_pos == 0) {
                        int ypos = b.y - (this.display3dOn ? this.depth3dPoint.y : 0);
                        if (target && index == 0) {
                            ypos = gridBounds.y + gridBounds.height - (this.display3dOn ? this.depth3dPoint.y : 0);
                        }
                        g.drawLine(position, ypos, position, ypos + 3);
                        label_y = ypos + fm.getHeight();
                        if (target && grid.isRangeLabelsOn(index) && range_pos == grid.getRangePosition(index)) {
                            label_y += fm.getHeight();
                        }
                        if (grid.isRangeAdjusterOn(index) && adjusterPosition == range_pos) {
                            label_y += 6;
                        }
                    } else {
                        int ypos = b.y + b.height;
                        if (target && index == 0) {
                            ypos = gridBounds.y;
                        }
                        g.drawLine(position, ypos, position, ypos - 3);
                        label_y = ypos - 5;
                        if (target && grid.isRangeLabelsOn(index) && range_pos == grid.getRangePosition(index)) {
                            label_y -= fm.getHeight();
                        }
                        if (index == 1 && grid.isRangeAdjusterOn(0) && adjusterPosition == 1 || grid.isRangeAdjusterOn(index) && adjusterPosition == range_pos) {
                            label_y -= 6;
                        }
                    }
                    int label_x = position - label_width / 2;
                    g.drawString(label, label_x, label_y);
                }
            }
        }
    }

    private void paintGridHighlight(Graphics g, Grid grid, Rectangle gridBounds, double value1, double value2, int index, int align) {
        if (new Double(value1).isNaN() || new Double(value2).isNaN()) {
            return;
        }
        g.setColor(this.chart.getAlternateChartBackground());
        if (align == 0) {
            double currentLowerRange;
            Rectangle b = this.rangeBounds[index];
            double currentUpperRange = grid.getCurrentRange(index);
            if (currentUpperRange > (currentLowerRange = grid.getCurrentLowerRange(index))) {
                value1 = Math.min(Math.max(value1, currentLowerRange), currentUpperRange);
                value2 = Math.min(Math.max(value2, currentLowerRange), currentUpperRange);
            } else {
                value1 = Math.min(Math.max(value1, currentUpperRange), currentLowerRange);
                value2 = Math.min(Math.max(value2, currentUpperRange), currentLowerRange);
            }
            double factor = (value1 - currentLowerRange) / (currentUpperRange - currentLowerRange);
            if (this.gridAlignment == 1) {
                int position1 = (int)Math.round((double)(b.y + b.height) - factor * (double)b.height);
                factor = (value2 - currentLowerRange) / (currentUpperRange - currentLowerRange);
                int position2 = (int)Math.round((double)(b.y + b.height) - factor * (double)b.height);
                g.fillRect(gridBounds.x, Math.min(position1, position2), gridBounds.width, Math.abs(position2 - position1));
                if (this.chart.is3DModeOn()) {
                    Polygon poly = new Polygon();
                    poly.addPoint(gridBounds.x, position1);
                    poly.addPoint(gridBounds.x, position2);
                    poly.addPoint(gridBounds.x - this.depth3dPoint.x, position2 - this.depth3dPoint.y);
                    poly.addPoint(gridBounds.x - this.depth3dPoint.x, position1 - this.depth3dPoint.y);
                    g.fillPolygon(poly);
                }
            } else {
                int position1 = (int)Math.round((double)b.x + factor * (double)b.width);
                factor = (value2 - currentLowerRange) / (currentUpperRange - currentLowerRange);
                int position2 = (int)Math.round((double)b.x + factor * (double)b.width);
                g.fillRect(Math.min(position1, position2), gridBounds.y, Math.abs(position2 - position1), gridBounds.height);
                if (this.chart.is3DModeOn()) {
                    Polygon poly = new Polygon();
                    poly.addPoint(position1, gridBounds.y + gridBounds.height);
                    poly.addPoint(position2, gridBounds.y + gridBounds.height);
                    poly.addPoint(position2 - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
                    poly.addPoint(position1 - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
                    g.fillPolygon(poly);
                }
            }
        } else {
            double currentMaxRange;
            double currentMinRange;
            Rectangle bounds = this.getDataBounds(grid);
            double rightSampleAxisRange = grid.rightSampleAxisRange;
            double leftSampleAxisRange = grid.leftSampleAxisRange;
            if (this.gridAlignment == 1) {
                currentMinRange = (double)(gridBounds.x - bounds.x) / (double)bounds.width * (rightSampleAxisRange - leftSampleAxisRange) + leftSampleAxisRange;
                currentMaxRange = (double)(gridBounds.width + gridBounds.x - bounds.x) / (double)bounds.width * (rightSampleAxisRange - leftSampleAxisRange) + leftSampleAxisRange;
            } else {
                currentMinRange = (double)(gridBounds.y - bounds.y) / (double)bounds.height * (rightSampleAxisRange - leftSampleAxisRange) + leftSampleAxisRange;
                currentMaxRange = (double)(gridBounds.height + gridBounds.y - bounds.y) / (double)bounds.height * (rightSampleAxisRange - leftSampleAxisRange) + leftSampleAxisRange;
            }
            double factor1 = (value1 - currentMinRange) / (currentMaxRange - currentMinRange);
            double factor2 = (value2 - currentMinRange) / (currentMaxRange - currentMinRange);
            if (this.gridAlignment == 1) {
                int position1 = (int)Math.round((double)gridBounds.x + factor1 * (double)gridBounds.width);
                int position2 = (int)Math.round((double)gridBounds.x + factor2 * (double)gridBounds.width);
                Polygon poly = new Polygon();
                if (this.chart.is3DModeOn()) {
                    poly.addPoint(position1, gridBounds.y + gridBounds.height);
                    poly.addPoint(position2, gridBounds.y + gridBounds.height);
                    poly.addPoint(position2 - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
                    poly.addPoint(position1 - this.depth3dPoint.x, gridBounds.y + gridBounds.height - this.depth3dPoint.y);
                    g.fillPolygon(poly);
                }
            } else {
                int position1 = (int)Math.round((double)gridBounds.y + factor1 * (double)gridBounds.height);
                int position2 = (int)Math.round((double)gridBounds.y + factor2 * (double)gridBounds.height);
                Polygon poly = new Polygon();
                if (this.chart.is3DModeOn()) {
                    poly.addPoint(gridBounds.x, position1);
                    poly.addPoint(gridBounds.x, position2);
                    poly.addPoint(gridBounds.x - this.depth3dPoint.x, position2 - this.depth3dPoint.y);
                    poly.addPoint(gridBounds.x - this.depth3dPoint.x, position1 - this.depth3dPoint.y);
                    g.fillPolygon(poly);
                }
            }
        }
    }

    protected void paintZoomOutButton(Graphics g, Grid grid, Rectangle bounds) {
        if (this.isZoomed(grid)) {
            int xpos = bounds.x + 8;
            int ypos = bounds.y + 8;
            if (this.display3dOn) {
                xpos -= this.depth3dPoint.x;
                ypos -= this.depth3dPoint.y;
            }
            if (this.gridAlignment == 0) {
                xpos = bounds.x + bounds.width - 16;
                ypos = bounds.y + 8;
            }
            this.paintBox(g, Color.lightGray, xpos, ypos, 8, 8, this.zoomOutPushed);
            g.setColor(Color.black);
            g.drawLine(xpos + 3, ypos + 4, xpos + 5, ypos + 4);
        }
    }

    void handleAdjusters(Grid grid, AWTEvent event) {
        int index;
        int adjuster;
        boolean adjuster_on = false;
        for (int i = 0; i < grid.getRangeCount(); ++i) {
            if (!grid.isRangeAdjusterOn(i)) continue;
            adjuster_on = true;
        }
        if (!adjuster_on && !grid.isSampleScrollerOn()) {
            return;
        }
        boolean inside_range = false;
        boolean inside_upper = false;
        boolean inside_lower = false;
        boolean inside_scroller = false;
        boolean inside_left_adjuster = false;
        boolean inside_right_adjuster = false;
        this.insideLeftButton = false;
        this.insideRightButton = false;
        int sampleCount = this.getSampleCount();
        int rangeCount = grid.getRangeCount();
        int xpos = ((MouseEvent)event).getX();
        int ypos = ((MouseEvent)event).getY();
        if (this.gridAlignment == 1) {
            adjuster = -1;
            for (index = 0; index < this.rangeAdjusterBounds.length; ++index) {
                inside_range = xpos >= this.rangeAdjusterBounds[index].x && xpos <= this.rangeAdjusterBounds[index].x + this.rangeAdjusterBounds[index].width;
                inside_range = inside_range && ypos >= this.rangeAdjusterBounds[index].y - 3 && ypos <= this.rangeAdjusterBounds[index].y + this.rangeAdjusterBounds[index].height + 1;
                inside_upper = ypos >= this.rangeAdjusterBounds[index].y - 1 && ypos <= this.rangeAdjusterBounds[index].y + 3;
                inside_upper = inside_upper && xpos >= this.rangeAdjusterBounds[index].x && xpos <= this.rangeAdjusterBounds[index].x + this.rangeAdjusterBounds[index].width;
                inside_lower = ypos >= this.rangeAdjusterBounds[index].y + this.rangeAdjusterBounds[index].height - 3 && ypos <= this.rangeAdjusterBounds[index].y + this.rangeAdjusterBounds[index].height + 1;
                boolean bl = inside_lower = inside_lower && xpos >= this.rangeAdjusterBounds[index].x && xpos <= this.rangeAdjusterBounds[index].x + this.rangeAdjusterBounds[index].width;
                if (!inside_range && !inside_upper && !inside_lower) continue;
                adjuster = index;
                break;
            }
        } else {
            adjuster = -1;
            for (index = 0; index < this.rangeAdjusterBounds.length; ++index) {
                inside_range = ypos >= this.rangeAdjusterBounds[index].y && ypos <= this.rangeAdjusterBounds[index].y + this.rangeAdjusterBounds[index].height;
                inside_range = inside_range && xpos >= this.rangeAdjusterBounds[index].x - 1 && xpos <= this.rangeAdjusterBounds[index].x + this.rangeAdjusterBounds[index].width + 1;
                inside_lower = xpos >= this.rangeAdjusterBounds[index].x - 1 && xpos <= this.rangeAdjusterBounds[index].x + 2;
                inside_lower = inside_lower && ypos >= this.rangeAdjusterBounds[index].y && ypos <= this.rangeAdjusterBounds[index].y + this.rangeAdjusterBounds[index].height;
                inside_upper = xpos >= this.rangeAdjusterBounds[index].x + this.rangeAdjusterBounds[index].width - 3 && xpos <= this.rangeAdjusterBounds[index].x + this.rangeAdjusterBounds[index].width + 1;
                boolean bl = inside_upper = inside_upper && ypos >= this.rangeAdjusterBounds[index].y && ypos <= this.rangeAdjusterBounds[index].y + this.rangeAdjusterBounds[index].height;
                if (!inside_range && !inside_upper && !inside_lower) continue;
                adjuster = index;
                break;
            }
        }
        if (!inside_range) {
            if (this.gridAlignment == 1) {
                int left = this.sampleScrollerBounds.x;
                int right = this.sampleScrollerBounds.x + this.sampleScrollerBounds.width;
                inside_scroller = ypos >= this.sampleScrollerBounds.y && ypos <= this.sampleScrollerBounds.y + this.sampleScrollerBounds.height;
                inside_scroller = inside_scroller && xpos >= left - 1 && xpos <= right + 1;
                this.insideLeftButton = inside_scroller && xpos >= left && xpos <= left + 8;
                this.insideRightButton = inside_scroller && xpos >= right - 8 && xpos <= right;
                inside_left_adjuster = inside_scroller && xpos >= this.leftAdjusterPos && xpos <= this.leftAdjusterPos + 2;
                inside_right_adjuster = inside_scroller && xpos >= this.rightAdjusterPos - 2 && xpos <= this.rightAdjusterPos;
                inside_scroller = inside_scroller && xpos > this.leftAdjusterPos + 2 && xpos < this.rightAdjusterPos - 2;
            } else {
                int top = this.sampleScrollerBounds.y;
                int bottom = this.sampleScrollerBounds.y + this.sampleScrollerBounds.height;
                inside_scroller = xpos >= this.sampleScrollerBounds.x && xpos <= this.sampleScrollerBounds.x + this.sampleScrollerBounds.width;
                inside_scroller = inside_scroller && ypos >= top - 1 && ypos <= bottom + 1;
                this.insideLeftButton = inside_scroller && ypos >= top && ypos <= top + 8;
                this.insideRightButton = inside_scroller && ypos >= bottom - 8 && ypos <= bottom;
                inside_left_adjuster = inside_scroller && ypos >= this.leftAdjusterPos && ypos <= this.leftAdjusterPos + 2;
                inside_right_adjuster = inside_scroller && ypos >= this.rightAdjusterPos - 2 && ypos <= this.rightAdjusterPos;
                boolean bl = inside_scroller = inside_scroller && ypos > this.leftAdjusterPos + 2 && ypos < this.rightAdjusterPos - 2;
            }
        }
        if ((inside_upper || inside_lower) && inside_range) {
            this.chart.new_cursor = this.gridAlignment == 1 ? RESIZE_CURSOR : RESIZE_HOR_CURSOR;
        } else if (inside_range) {
            this.chart.new_cursor = HAND_CURSOR;
        } else if (inside_left_adjuster || inside_right_adjuster) {
            this.chart.new_cursor = this.gridAlignment == 1 ? RESIZE_HOR_CURSOR : RESIZE_CURSOR;
        } else if (inside_scroller) {
            this.chart.new_cursor = HAND_CURSOR;
        }
        switch (event.getID()) {
            case 503: {
                break;
            }
            case 501: {
                this.adjustingUpper = inside_upper && inside_range;
                this.adjustingLower = inside_lower && inside_range;
                this.slidingAdjuster = inside_range && !inside_upper && !inside_lower;
                this.adjusterIndex = adjuster;
                int rangeAdjusted = grid.getRangeAdjusted(this.adjusterIndex);
                this.leftPushed = this.insideLeftButton;
                this.rightPushed = this.insideRightButton;
                this.adjustingLeft = inside_left_adjuster;
                this.adjustingRight = inside_right_adjuster;
                this.slidingScroller = inside_scroller && !inside_left_adjuster && !inside_right_adjuster;
                this.lastAdjusterClick = this.gridAlignment == 1 ? ypos : xpos;
                this.lastScrollerClick = this.gridAlignment == 1 ? xpos : ypos;
                long now = System.currentTimeMillis();
                if (this.insideLeftButton || this.insideRightButton || inside_scroller || inside_range || inside_upper || inside_lower || inside_right_adjuster || inside_left_adjuster) {
                    this.chart.shouldSelect = false;
                }
                if (this.insideLeftButton) {
                    double delta = (double)(this.chartDataBounds.width / sampleCount) / (double)this.chartDataBounds.width;
                    if (this.gridAlignment == 0) {
                        delta = (double)(this.chartDataBounds.height / sampleCount) / (double)this.chartDataBounds.height;
                    }
                    delta = Math.min(delta, this.leftScrollerFactor);
                    this.leftScrollerFactor -= delta;
                    this.rightScrollerFactor += delta;
                    if (this.scrollerThread == null) {
                        this.scrollerThread = new Thread(this);
                        this.scrollerThread.start();
                    }
                } else if (this.insideRightButton) {
                    double delta = (double)(this.chartDataBounds.width / sampleCount) / (double)this.chartDataBounds.width;
                    if (this.gridAlignment == 0) {
                        delta = (double)(this.chartDataBounds.height / sampleCount) / (double)this.chartDataBounds.height;
                    }
                    delta = Math.min(delta, this.rightScrollerFactor);
                    this.leftScrollerFactor += delta;
                    this.rightScrollerFactor -= delta;
                    if (this.scrollerThread == null) {
                        this.scrollerThread = new Thread(this);
                        this.scrollerThread.start();
                    }
                } else if (inside_scroller && !this.insideLeftButton && !this.insideRightButton) {
                    if (now - this.lastClickTime < 350L) {
                        this.leftScrollerFactor = 0.0;
                        this.rightScrollerFactor = 0.0;
                    }
                } else if (inside_range && !inside_upper && !inside_lower && now - this.lastClickTime < 350L) {
                    for (int i = 0; i < grid.getRangeCount(); ++i) {
                        int rangeIndex = rangeAdjusted == -1 ? i : rangeAdjusted;
                        grid.setCurrentRange(rangeIndex, grid.getRange(rangeIndex));
                        grid.setCurrentLowerRange(rangeIndex, grid.getLowerRange(rangeIndex));
                    }
                }
                if (!grid.rightToLeftScrollingOn) {
                    int firstSample = (int)Math.round((double)sampleCount * this.leftScrollerFactor);
                    int lastSample = (int)Math.round((double)(sampleCount - firstSample) - (double)sampleCount * this.rightScrollerFactor + 1.0);
                    this.chart.setVisibleSamples(firstSample, lastSample, false);
                }
                this.chart.needRender = true;
                this.chart.setNeedChartCalculation(true);
                this.chart.repaint();
                break;
            }
            case 506: {
                int i;
                if (!this.adjustingUpper && !this.adjustingLower && !this.slidingAdjuster && !this.slidingScroller && !this.leftPushed && !this.rightPushed && !this.adjustingLeft && !this.adjustingRight) break;
                int pos = ((MouseEvent)event).getY();
                if (this.gridAlignment == 0) {
                    pos = ((MouseEvent)event).getX();
                }
                int adjusterPos = grid.getRangeAdjusterPosition();
                int rangeAdjusted = grid.getRangeAdjusted(this.adjusterIndex);
                Rectangle bounds = this.rangeBounds[0];
                if (rangeAdjusted != -1) {
                    bounds = this.rangeBounds[rangeAdjusted];
                }
                if (this.adjustingUpper) {
                    double factor;
                    if (this.gridAlignment == 1) {
                        this.chart.new_cursor = RESIZE_CURSOR;
                        pos -= bounds.y;
                        if (this.display3dOn && adjusterPos == 0) {
                            pos += this.depth3dPoint.y;
                        }
                        factor = 1.0 - (double)pos / (double)bounds.height;
                    } else {
                        this.chart.new_cursor = RESIZE_HOR_CURSOR;
                        pos -= bounds.x;
                        if (this.display3dOn && adjusterPos == 0) {
                            pos += this.depth3dPoint.x;
                        }
                        factor = (double)pos / (double)bounds.width;
                    }
                    if (rangeAdjusted == -1) {
                        for (i = 0; i < rangeCount; ++i) {
                            this.adjustRange(this.chart, grid, i, factor, 0.0);
                        }
                    } else {
                        this.adjustRange(this.chart, grid, rangeAdjusted, factor, 0.0);
                    }
                } else if (this.adjustingLower) {
                    double factor;
                    if (this.gridAlignment == 1) {
                        this.chart.new_cursor = RESIZE_CURSOR;
                        pos -= bounds.y;
                        if (this.display3dOn && adjusterPos == 0) {
                            pos += this.depth3dPoint.y;
                        }
                        factor = 1.0 - (double)pos / (double)bounds.height;
                    } else {
                        this.chart.new_cursor = RESIZE_HOR_CURSOR;
                        pos -= bounds.x;
                        if (this.display3dOn && adjusterPos == 0) {
                            pos += this.depth3dPoint.x;
                        }
                        factor = (double)pos / (double)bounds.width;
                    }
                    if (rangeAdjusted == -1) {
                        for (i = 0; i < rangeCount; ++i) {
                            this.adjustRange(this.chart, grid, i, 0.0, factor);
                        }
                    } else {
                        this.adjustRange(this.chart, grid, rangeAdjusted, 0.0, factor);
                    }
                } else if (this.slidingAdjuster) {
                    this.chart.new_cursor = HAND_CURSOR;
                    int change_pos = this.lastAdjusterClick - pos;
                    double factor = this.gridAlignment == 1 ? (double)change_pos / (double)bounds.height : (double)change_pos / (double)bounds.width;
                    if (rangeAdjusted == -1) {
                        for (int i2 = 0; i2 < rangeCount; ++i2) {
                            this.adjustRangeSlide(this.chart, grid, i2, factor);
                        }
                    } else {
                        this.adjustRangeSlide(this.chart, grid, rangeAdjusted, factor);
                    }
                    this.lastAdjusterClick = pos;
                } else if (this.adjustingLeft) {
                    if (this.gridAlignment == 1) {
                        this.chart.new_cursor = RESIZE_HOR_CURSOR;
                        int left = this.sampleScrollerBounds.x + 8;
                        pos = Math.max(((MouseEvent)event).getX(), left);
                        pos = Math.min(pos, this.rightAdjusterPos - 10);
                        this.leftScrollerFactor = (double)(pos - left) / (double)this.sampleScrollerSpace;
                    } else {
                        this.chart.new_cursor = RESIZE_CURSOR;
                        int top = this.sampleScrollerBounds.y + 8;
                        pos = Math.max(((MouseEvent)event).getY(), top);
                        pos = Math.min(pos, this.rightAdjusterPos - 10);
                        this.leftScrollerFactor = (double)(pos - top) / (double)this.sampleScrollerSpace;
                    }
                } else if (this.adjustingRight) {
                    if (this.gridAlignment == 1) {
                        this.chart.new_cursor = RESIZE_HOR_CURSOR;
                        int right = this.sampleScrollerBounds.x + this.sampleScrollerBounds.width - 8;
                        pos = Math.min(((MouseEvent)event).getX(), right);
                        pos = Math.max(pos, this.leftAdjusterPos + 10);
                        this.rightScrollerFactor = (double)(right - pos) / (double)this.sampleScrollerSpace;
                    } else {
                        this.chart.new_cursor = RESIZE_CURSOR;
                        int bottom = this.sampleScrollerBounds.y + this.sampleScrollerBounds.height - 8;
                        pos = Math.min(((MouseEvent)event).getY(), bottom);
                        pos = Math.max(pos, this.leftAdjusterPos + 10);
                        this.rightScrollerFactor = (double)(bottom - pos) / (double)this.sampleScrollerSpace;
                    }
                } else if (this.slidingScroller) {
                    this.chart.new_cursor = HAND_CURSOR;
                    int delta = this.gridAlignment == 1 ? xpos - this.lastScrollerClick : ypos - this.lastScrollerClick;
                    double factor = (double)delta / (double)this.sampleScrollerSpace;
                    factor = delta > 0 ? Math.min(factor, this.rightScrollerFactor) : -Math.min(-factor, this.leftScrollerFactor);
                    this.leftScrollerFactor += factor;
                    this.rightScrollerFactor -= factor;
                    int n = this.lastScrollerClick = this.gridAlignment == 1 ? xpos : ypos;
                }
                if (!grid.rightToLeftScrollingOn) {
                    int firstSample = (int)Math.round((double)sampleCount * this.leftScrollerFactor);
                    int lastSample = (int)Math.round((double)(sampleCount - firstSample) - (double)sampleCount * this.rightScrollerFactor + 1.0);
                    this.chart.setVisibleSamples(firstSample, lastSample, false);
                }
                this.chart.needRender = true;
                this.chart.setNeedChartCalculation(true);
                this.chart.repaint();
                break;
            }
            case 502: {
                this.slidingAdjuster = false;
                this.adjustingLower = false;
                this.adjustingUpper = false;
                this.adjusterIndex = -1;
                this.rightPushed = false;
                this.leftPushed = false;
                this.slidingScroller = false;
                this.adjustingRight = false;
                this.adjustingLeft = false;
                if (this.scrollerThread != null) {
                    this.scrollerThread = null;
                }
                this.chart.needRender = true;
                this.chart.setNeedChartCalculation(true);
                this.chart.repaint();
            }
        }
    }

    private void adjustRange(Chart chart, Grid grid, int rangeIndex, double upperFactor, double lowerFactor) {
        double upperRange = grid.getRange(rangeIndex);
        double lowerRange = grid.getLowerRange(rangeIndex);
        double currentUpperRange = grid.getCurrentRange(rangeIndex);
        double currentLowerRange = grid.getCurrentLowerRange(rangeIndex);
        if (upperFactor != 0.0) {
            double upperValue = lowerRange + upperFactor * (upperRange - lowerRange);
            if (upperRange >= lowerRange) {
                if (upperValue > currentLowerRange) {
                    currentUpperRange = upperValue;
                }
                currentUpperRange = Math.min(currentUpperRange, upperRange);
            } else if (upperRange < lowerRange) {
                if (upperValue < currentLowerRange) {
                    currentUpperRange = upperValue;
                }
                currentUpperRange = Math.max(currentUpperRange, upperRange);
            }
        }
        if (lowerFactor != 0.0) {
            double lowerValue = lowerRange + lowerFactor * (upperRange - lowerRange);
            if (upperRange >= lowerRange) {
                if (lowerValue < currentUpperRange) {
                    currentLowerRange = lowerValue;
                }
                currentLowerRange = Math.max(currentLowerRange, lowerRange);
            } else if (upperRange < lowerRange) {
                if (lowerValue > currentUpperRange) {
                    currentLowerRange = lowerValue;
                }
                currentLowerRange = Math.min(currentLowerRange, lowerRange);
            }
        }
        chart.setCurrentRange(rangeIndex, currentUpperRange);
        chart.setCurrentLowerRange(rangeIndex, currentLowerRange);
    }

    private void adjustRangeSlide(Chart chart, Grid grid, int rangeIndex, double factor) {
        double upperRange = grid.getRange(rangeIndex);
        double lowerRange = grid.getLowerRange(rangeIndex);
        double currentUpperRange = grid.getCurrentRange(rangeIndex);
        double currentLowerRange = grid.getCurrentLowerRange(rangeIndex);
        double change = factor * (upperRange - lowerRange);
        double d = change = this.gridAlignment == 1 ? change : -change;
        if (upperRange >= lowerRange) {
            if (change >= 0.0) {
                change = Math.min(upperRange - currentUpperRange, change);
            } else if (currentLowerRange + change < lowerRange) {
                change = lowerRange - currentLowerRange;
            }
        } else if (upperRange < lowerRange) {
            if (change <= 0.0) {
                change = Math.max(upperRange - currentUpperRange, change);
            } else if (currentLowerRange + change > lowerRange) {
                change = lowerRange - currentLowerRange;
            }
        }
        chart.setCurrentRange(rangeIndex, currentUpperRange += change);
        chart.setCurrentLowerRange(rangeIndex, currentLowerRange += change);
    }

    void handleZoom(Grid grid, AWTEvent event) {
        if (this.adjustingUpper || this.adjustingLower || this.slidingAdjuster || this.adjustingLeft || this.adjustingRight || this.slidingScroller || this.leftPushed || this.rightPushed) {
            return;
        }
        int rangeLength = grid.getRangeCount();
        int xpos = ((MouseEvent)event).getX();
        int ypos = ((MouseEvent)event).getY();
        long now = System.currentTimeMillis();
        switch (event.getID()) {
            case 501: {
                int adjuster;
                boolean inside_zoom_out;
                this.mousePressX = xpos;
                this.mousePressY = ypos;
                if (this.gridAlignment == 1) {
                    int x = xpos;
                    int y = ypos;
                    if (this.display3dOn) {
                        x += this.depth3dPoint.x;
                        y += this.depth3dPoint.y;
                    }
                    inside_zoom_out = x > this.graphBounds.x + 8 && x < this.graphBounds.x + 17 && y > this.graphBounds.y + 8 && y < this.graphBounds.y + 17;
                } else {
                    inside_zoom_out = xpos < this.graphBounds.x + this.graphBounds.width - 7 && xpos > this.graphBounds.x + this.graphBounds.width - 16 && ypos > this.graphBounds.y + 8 && ypos < this.graphBounds.y + 17;
                }
                this.zoomedOnMousePress = false;
                if (this.isZoomed(grid) && inside_zoom_out) {
                    this.zoomedOnMousePress = true;
                    for (adjuster = 0; adjuster < rangeLength; ++adjuster) {
                        double upperRange = grid.getRange(adjuster);
                        double lowerRange = grid.getLowerRange(adjuster);
                        double currentUpperRange = grid.getCurrentRange(adjuster);
                        double currentLowerRange = grid.getCurrentLowerRange(adjuster);
                        double upperDiff = Math.abs(upperRange - currentUpperRange);
                        double lowerDiff = Math.abs(lowerRange - currentLowerRange);
                        if (!(upperDiff > 0.0) && !(lowerDiff > 0.0)) continue;
                        double factor = 0.1 * (upperRange - lowerRange);
                        double delta = factor * upperDiff / (upperDiff + lowerDiff);
                        grid.setCurrentRange(adjuster, currentUpperRange + delta);
                        grid.setCurrentLowerRange(adjuster, currentLowerRange - (factor - delta));
                    }
                    if (this.leftScrollerFactor > 0.0 || this.rightScrollerFactor > 0.0) {
                        double delta = 0.1 * this.leftScrollerFactor / (this.rightScrollerFactor + this.leftScrollerFactor);
                        this.leftScrollerFactor = Math.max(0.0, this.leftScrollerFactor - delta);
                        this.rightScrollerFactor = Math.max(0.0, this.rightScrollerFactor - (0.1 - delta));
                    }
                    if (!grid.rightToLeftScrollingOn) {
                        int sampleCount = this.getSampleCount();
                        int firstSample = (int)Math.round((double)sampleCount * this.leftScrollerFactor);
                        int lastSample = (int)Math.round((double)(sampleCount - firstSample) - (double)sampleCount * this.rightScrollerFactor + 1.0);
                        this.chart.setVisibleSamples(firstSample, lastSample, false);
                    }
                    this.zoomOutPushed = true;
                    this.chart.shouldSelect = false;
                } else if (now - this.lastClickTime < 350L) {
                    this.leftScrollerFactor = 0.0;
                    this.rightScrollerFactor = 0.0;
                    for (adjuster = 0; adjuster < rangeLength; ++adjuster) {
                        grid.setCurrentRange(adjuster, grid.getRange(adjuster));
                        grid.setCurrentLowerRange(adjuster, grid.getLowerRange(adjuster));
                    }
                    this.chart.shouldSelect = false;
                    this.chart.setVisibleSamples(0, this.getSampleCount(), false);
                }
                this.chart.needRender = true;
                this.chart.needChartCalculation = true;
                this.chart.repaint();
                break;
            }
            case 506: {
                if (this.zoomOutPushed || this.mousePressX < 0 || this.mousePressY < 0) break;
                int offset3d_x = 0;
                int offset3d_y = 0;
                if (this.display3dOn) {
                    offset3d_x = this.depth3dPoint.x;
                    offset3d_y = this.depth3dPoint.y;
                }
                int box_start_x = Math.max(this.graphBounds.x - offset3d_x + 1, this.mousePressX);
                int box_start_y = Math.max(this.graphBounds.y - offset3d_y + 1, this.mousePressY);
                box_start_x = Math.min(this.graphBounds.x + this.graphBounds.width - offset3d_x - 1, box_start_x);
                box_start_y = Math.min(this.graphBounds.y + this.graphBounds.height - offset3d_y - 1, box_start_y);
                int box_end_x = Math.max(this.graphBounds.x - offset3d_x + 1, xpos);
                int box_end_y = Math.max(this.graphBounds.y - offset3d_y + 1, ypos);
                box_end_x = Math.min(this.graphBounds.x + this.graphBounds.width - offset3d_x - 1, box_end_x);
                box_end_y = Math.min(this.graphBounds.y + this.graphBounds.height - offset3d_y - 1, box_end_y);
                this.mouseBox = new Rectangle();
                this.mouseBox.x = Math.min(box_start_x, box_end_x);
                this.mouseBox.y = Math.min(box_start_y, box_end_y);
                this.mouseBox.width = Math.abs(box_start_x - box_end_x);
                this.mouseBox.height = Math.abs(box_start_y - box_end_y);
                if (this.mouseBox.width < 3 || this.mouseBox.height < 3) {
                    this.mouseBox = null;
                }
                this.chart.repaint();
                break;
            }
            case 502: {
                if (now - this.lastClickTime > 100L && this.mouseBox != null) {
                    Rectangle rect = new Rectangle(this.mouseBox.x - 1, this.mouseBox.y - 1, this.mouseBox.width + 2, this.mouseBox.height + 2);
                    if (this.gridAlignment == 0) {
                        rect = new Rectangle(this.mouseBox.x - 1, this.mouseBox.y - 1, this.mouseBox.width + 2, this.mouseBox.height + 2);
                    }
                    if (this.display3dOn) {
                        rect.x += this.depth3dPoint.x;
                        rect.y += this.depth3dPoint.y;
                    }
                    for (int range = 0; range < rangeLength; ++range) {
                        double upperFactor = (double)(rect.y - this.chartDataBounds.y) / (double)this.chartDataBounds.height;
                        if (this.gridAlignment == 0) {
                            upperFactor = (double)(this.chartDataBounds.x + this.chartDataBounds.width - rect.x - rect.width) / (double)this.chartDataBounds.width;
                        }
                        double lowerFactor = (double)(this.chartDataBounds.y + this.chartDataBounds.height - rect.y - rect.height) / (double)this.chartDataBounds.height;
                        if (this.gridAlignment == 0) {
                            lowerFactor = (double)(rect.x - this.chartDataBounds.x) / (double)this.chartDataBounds.width;
                        }
                        double currentUpperRange = grid.getCurrentRange(range);
                        double currentLowerRange = grid.getCurrentLowerRange(range);
                        double upperRangeDelta = upperFactor * (currentUpperRange - currentLowerRange);
                        double lowerRangeDelta = lowerFactor * (currentUpperRange - currentLowerRange);
                        grid.setCurrentRange(range, currentUpperRange - upperRangeDelta);
                        grid.setCurrentLowerRange(range, currentLowerRange + lowerRangeDelta);
                    }
                    if (this.gridAlignment == 1) {
                        this.leftScrollerFactor = (double)(rect.x - this.chartDataBounds.x) / (double)this.chartDataBounds.width;
                        this.rightScrollerFactor = (double)(this.chartDataBounds.x + this.chartDataBounds.width - rect.x - rect.width) / (double)this.chartDataBounds.width;
                    } else {
                        this.leftScrollerFactor = (double)(rect.y - this.chartDataBounds.y) / (double)this.chartDataBounds.height;
                        this.rightScrollerFactor = (double)(this.chartDataBounds.y + this.chartDataBounds.height - rect.y - rect.height) / (double)this.chartDataBounds.height;
                    }
                    if (!grid.rightToLeftScrollingOn) {
                        int sampleCount = this.getSampleCount();
                        int firstSample = (int)Math.round((double)sampleCount * this.leftScrollerFactor);
                        int lastSample = (int)Math.round((double)(sampleCount - firstSample) - (double)sampleCount * this.rightScrollerFactor + 1.0);
                        this.chart.setVisibleSamples(firstSample, lastSample, false);
                    }
                    this.chart.shouldSelect = false;
                }
                this.mouseBox = null;
                this.zoomOutPushed = false;
                this.chart.needRender = true;
                this.chart.needGraphBounds = true;
                this.chart.needChartCalculation = true;
                this.chart.repaint();
            }
        }
    }

    void handleGridAdjustment(Grid grid, AWTEvent event) {
        int top = 0;
        int left = 0;
        int right = 0;
        int bottom = 0;
        if (this.graphBounds != null) {
            top = this.graphBounds.y;
            left = this.graphBounds.x - (this.display3dOn ? this.depth3dPoint.x : 0);
            right = this.graphBounds.x + this.graphBounds.width;
            bottom = this.graphBounds.y + this.graphBounds.height - (this.display3dOn ? this.depth3dPoint.y : 0);
        }
        long now = System.currentTimeMillis();
        int xpos = ((MouseEvent)event).getX();
        int ypos = ((MouseEvent)event).getY();
        Insets graphInsets = grid.getGraphInsets();
        switch (event.getID()) {
            case 501: {
                this.mousePressX = xpos;
                this.mousePressY = ypos;
                if (this.gridEdgeToAdjust < 0 || now - this.lastClickTime >= 350L) break;
                switch (this.gridEdgeToAdjust) {
                    case 0: {
                        graphInsets.left = -1;
                        break;
                    }
                    case 1: {
                        graphInsets.right = -1;
                        break;
                    }
                    case 2: {
                        graphInsets.top = -1;
                        break;
                    }
                    case 3: {
                        graphInsets.bottom = -1;
                    }
                }
                this.chart.needRender = true;
                this.chart.needGraphBounds = true;
                this.chart.needChartCalculation = true;
                break;
            }
            case 503: {
                if (grid.isGridAdjustmentOn(2) && xpos >= left && xpos <= right && ypos >= top - 1 && ypos <= top + 3) {
                    this.chart.new_cursor = GRID_CURSOR_VERT;
                    this.gridEdgeToAdjust = 2;
                    break;
                }
                if (grid.isGridAdjustmentOn(0) && xpos >= left - 1 && xpos <= left + 3 && ypos >= top && ypos <= bottom) {
                    this.chart.new_cursor = GRID_CURSOR_HORZ;
                    this.gridEdgeToAdjust = 0;
                    break;
                }
                if (grid.isGridAdjustmentOn(3) && xpos >= left && xpos <= right && ypos >= bottom - 3 && ypos <= bottom + 1) {
                    this.chart.new_cursor = GRID_CURSOR_VERT;
                    this.gridEdgeToAdjust = 3;
                    break;
                }
                if (grid.isGridAdjustmentOn(2) && xpos >= right - 3 && xpos <= right + 1 && ypos >= top && ypos <= bottom) {
                    this.chart.new_cursor = GRID_CURSOR_HORZ;
                    this.gridEdgeToAdjust = 1;
                    break;
                }
                this.gridEdgeToAdjust = -1;
                break;
            }
            case 506: {
                int xoff = 0;
                int yoff = 0;
                if (this.display3dOn) {
                    xoff = this.depth3dPoint.x;
                    yoff = this.depth3dPoint.y;
                }
                if (this.gridEdgeToAdjust < 0) break;
                Dimension size = this.chart.getSize();
                switch (this.gridEdgeToAdjust) {
                    case 0: {
                        graphInsets.left = Math.max(0, xpos) + xoff;
                        if (this.graphBounds != null) {
                            graphInsets.left = Math.min(graphInsets.left, this.graphBounds.x + this.graphBounds.width - 5);
                        }
                        this.chart.new_cursor = GRID_CURSOR_HORZ;
                        break;
                    }
                    case 1: {
                        graphInsets.right = Math.max(size.width - xpos, 0);
                        if (this.graphBounds != null) {
                            graphInsets.right = Math.min(graphInsets.right, size.width - this.graphBounds.x - 5);
                        }
                        this.chart.new_cursor = GRID_CURSOR_HORZ;
                        break;
                    }
                    case 2: {
                        graphInsets.top = Math.max(ypos, 0);
                        if (this.graphBounds != null) {
                            graphInsets.top = Math.min(graphInsets.top, this.graphBounds.y + this.graphBounds.height - 5);
                        }
                        this.chart.new_cursor = GRID_CURSOR_VERT;
                        break;
                    }
                    case 3: {
                        graphInsets.bottom = Math.max(size.height - ypos, 0) - yoff;
                        if (this.graphBounds != null) {
                            graphInsets.bottom = Math.min(graphInsets.bottom, size.height - this.graphBounds.y - 5);
                        }
                        this.chart.new_cursor = GRID_CURSOR_VERT;
                    }
                }
                this.chart.needRender = true;
                this.chart.setNeedChartCalculation(true);
                this.chart.needGraphBounds = true;
                this.chart.repaint();
            }
        }
        grid.setGraphInsets(graphInsets.top, graphInsets.left, graphInsets.bottom, graphInsets.right);
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int sampleCount = this.getSampleCount();
        double delta = (double)(this.chartDataBounds.width / this.getSampleCount()) / (double)this.chartDataBounds.width;
        while (this.scrollerThread == thisThread) {
            int lastSample;
            int firstSample;
            if (this.insideLeftButton) {
                delta = Math.min(delta, this.leftScrollerFactor);
                this.leftScrollerFactor -= delta;
                this.rightScrollerFactor += delta;
                if (!this.chart.getGrid().rightToLeftScrollingOn) {
                    firstSample = (int)Math.round((double)sampleCount * this.leftScrollerFactor);
                    lastSample = (int)Math.round((double)(sampleCount - firstSample) - (double)sampleCount * this.rightScrollerFactor + 1.0);
                    this.chart.setVisibleSamples(firstSample, lastSample, false);
                }
                this.chart.needRender = true;
                this.chart.needChartCalculation = true;
                this.chart.repaint();
            }
            if (this.insideRightButton) {
                delta = Math.min(delta, this.rightScrollerFactor);
                this.leftScrollerFactor += delta;
                this.rightScrollerFactor -= delta;
                if (!this.chart.getGrid().rightToLeftScrollingOn) {
                    firstSample = (int)Math.round((double)sampleCount * this.leftScrollerFactor);
                    lastSample = (int)Math.round((double)(sampleCount - firstSample) - (double)sampleCount * this.rightScrollerFactor + 1.0);
                    this.chart.setVisibleSamples(firstSample, lastSample, false);
                }
                this.chart.needRender = true;
                this.chart.needChartCalculation = true;
                this.chart.repaint();
            }
            try {
                Thread.sleep(35L);
            }
            catch (InterruptedException e) {}
        }
    }

    boolean isZoomed(Grid grid) {
        boolean is_zoomed = false;
        for (int range = 0; range < grid.getRangeCount(); ++range) {
            is_zoomed |= grid.getRange(range) != grid.getCurrentRange(range);
            is_zoomed |= grid.getLowerRange(range) != grid.getCurrentLowerRange(range);
        }
        is_zoomed = this.gridAlignment == 1 ? (is_zoomed |= this.chartDataBounds.width != this.graphBounds.width) : (is_zoomed |= this.chartDataBounds.height != this.graphBounds.height);
        return is_zoomed;
    }

    private void checkRangeIntegrity(int length, int newLength) {
        Rectangle[] newRangeBounds = new Rectangle[newLength];
        System.arraycopy(this.rangeBounds, 0, newRangeBounds, 0, Math.min(length, newLength));
        for (int i = length; i < newLength; ++i) {
            newRangeBounds[i] = new Rectangle();
        }
        this.rangeBounds = newRangeBounds;
        Rectangle[] newRangeAdjusterBounds = new Rectangle[newLength];
        System.arraycopy(this.rangeAdjusterBounds, 0, newRangeAdjusterBounds, 0, Math.min(length, newLength));
        for (int i = length; i < newLength; ++i) {
            newRangeAdjusterBounds[i] = new Rectangle();
        }
        this.rangeAdjusterBounds = newRangeAdjusterBounds;
    }

    protected void paintMouseBox(Graphics g) {
        g.setColor(this.chart.getChartForeground());
        if (this.mouseBox != null) {
            boolean dot = true;
            for (int x = this.mouseBox.x; x < this.mouseBox.x + this.mouseBox.width; ++x) {
                if (dot) {
                    g.drawLine(x, this.mouseBox.y, x, this.mouseBox.y);
                    g.drawLine(x, this.mouseBox.y + this.mouseBox.height, x, this.mouseBox.y + this.mouseBox.height);
                }
                dot = !dot;
            }
            dot = true;
            for (int y = this.mouseBox.y; y < this.mouseBox.y + this.mouseBox.height; ++y) {
                if (dot) {
                    g.drawLine(this.mouseBox.x, y, this.mouseBox.x, y);
                    g.drawLine(this.mouseBox.x + this.mouseBox.width, y, this.mouseBox.x + this.mouseBox.width, y);
                }
                dot = !dot;
            }
        }
    }
}

