/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.ChartSample;
import java.io.Serializable;
import java.util.Hashtable;

public class ChartData
implements Serializable {
    private ChartSample[][] data;
    private Hashtable sampleLookup;
    private String[] seriesLabels;
    private String[] sampleLabels;
    private int seriesCount;
    private int sampleCount;
    private long changedTime;

    public ChartData(int seriesCount, int sampleCount) {
        this.seriesCount = Math.max(0, seriesCount);
        this.sampleCount = Math.max(0, sampleCount);
        this.data = new ChartSample[this.seriesCount][];
        for (int serie = 0; serie < this.data.length; ++serie) {
            this.data[serie] = new ChartSample[this.sampleCount];
        }
        this.seriesLabels = new String[this.seriesCount];
        this.sampleLabels = new String[this.sampleCount];
        int count = Math.max(1, sampleCount) * Math.max(1, seriesCount);
        this.sampleLookup = new Hashtable(count);
        this.changedTime = System.currentTimeMillis();
    }

    public void setSamples(int serie, ChartSample[] samples) {
        if (serie < 0 || serie >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + serie);
        }
        if (this.data[serie] == null || samples == null) {
            this.data[serie] = new ChartSample[this.sampleCount];
        }
        if (samples != null) {
            for (int sample = 0; sample < this.sampleCount; ++sample) {
                if (sample >= samples.length || samples[sample] == null) continue;
                samples[sample].setIndex(sample);
                samples[sample].setSeries(serie);
                this.data[serie][sample] = samples[sample];
                if (samples[sample].key == null) {
                    samples[sample].key = serie + "." + sample;
                }
                this.sampleLookup.put(samples[sample].key, samples[sample]);
            }
        }
        this.setIndividualSampleLabels();
        this.changedTime = System.currentTimeMillis();
    }

    public ChartSample[] getSamples(int serie) {
        try {
            return this.data[serie];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + serie);
        }
    }

    public void setSample(int serie, int index, ChartSample sample) {
        if (serie < 0 || serie >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + serie);
        }
        try {
            sample.setIndex(index);
            sample.setSeries(serie);
            this.data[serie][index] = sample;
            if (sample.key == null) {
                sample.key = serie + "." + index;
            }
            this.sampleLookup.put(sample.key, sample);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        catch (NullPointerException e) {
            System.out.println("Internal error: setSample(serie, index, sample) method");
        }
        this.setIndividualSampleLabel(serie, index);
        this.changedTime = System.currentTimeMillis();
    }

    public ChartSample getSample(int serie, int index) {
        if (serie < 0 || serie >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + serie);
        }
        try {
            return this.data[serie][index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        catch (NullPointerException e) {
            System.out.println("Internal error: getSample(serie, index");
            return null;
        }
    }

    public ChartSample getSample(Object key) {
        return (ChartSample)this.sampleLookup.get(key);
    }

    public void setSampleValues(int serie, double[] values) {
        if (serie < 0 || serie >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + serie);
        }
        if (this.data[serie] == null || values == null) {
            this.data[serie] = new ChartSample[this.sampleCount];
        }
        if (values != null) {
            for (int sample = 0; sample < this.sampleCount && sample < this.data[serie].length; ++sample) {
                double value = Double.NaN;
                if (sample < values.length) {
                    value = values[sample];
                }
                if (this.data[serie][sample] == null) {
                    this.data[serie][sample] = new ChartSample(sample);
                    this.data[serie][sample].setSeries(serie);
                    this.data[serie][sample].key = serie + "." + sample;
                    this.sampleLookup.put(this.data[serie][sample].key, this.data[serie][sample]);
                }
                this.data[serie][sample].setValue(value);
            }
        }
        this.setIndividualSampleLabels();
        this.changedTime = System.currentTimeMillis();
    }

    public double[] getSampleValues(int serie) {
        try {
            ChartSample[] samples = this.data[serie];
            double[] values = new double[samples.length];
            for (int i = 0; i < samples.length; ++i) {
                values[i] = samples[i] != null && samples[i].value != null && !samples[i].value.isNaN() ? samples[i].getFloatValue() : Double.NaN;
            }
            return values;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + serie);
        }
        catch (Exception e) {
            System.out.println("Internal error: ChartData.getSampleValues(serie)");
            return null;
        }
    }

    public void setSampleValue(int serie, int index, double value) {
        if (serie < 0 || serie >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + serie);
        }
        try {
            if (this.data[serie][index] == null) {
                this.data[serie][index] = new ChartSample(index);
                this.data[serie][index].setSeries(serie);
                this.data[serie][index].key = serie + "." + index;
                this.sampleLookup.put(this.data[serie][index].key, this.data[serie][index]);
            }
            this.data[serie][index].setValue(value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        catch (NullPointerException e) {
            System.out.println("Internal error: setSampleValue(serie, index, value) method");
        }
        this.setIndividualSampleLabel(serie, index);
        this.changedTime = System.currentTimeMillis();
    }

    public double getSampleValue(int serie, int index) {
        if (serie < 0 || serie >= this.data.length) {
            throw new IllegalArgumentException("Invalid series: " + serie);
        }
        if (this.data[serie] == null) {
            return Double.NaN;
        }
        if (index < 0 || index >= this.data[serie].length) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        if (this.data[serie][index] != null) {
            return this.data[serie][index].getFloatValue();
        }
        return Double.NaN;
    }

    public int appendSample(int serie, ChartSample sample, boolean makeSpace) {
        int i;
        if (serie < 0 || serie >= this.seriesCount) {
            throw new IllegalArgumentException("Illegal serie: " + serie);
        }
        this.changedTime = System.currentTimeMillis();
        int lastSampleIndex = -1;
        for (i = 0; i < this.sampleCount; ++i) {
            ChartSample s = this.data[serie][i];
            if (s != null && s.value != null) continue;
            lastSampleIndex = i;
            break;
        }
        if (lastSampleIndex >= 0) {
            this.setSample(serie, lastSampleIndex, sample);
            return lastSampleIndex;
        }
        if (makeSpace) {
            int count = this.sampleCount;
            this.setSampleCount(count + 1);
            this.setSample(serie, count, sample);
            return count;
        }
        if (this.sampleCount > 0) {
            for (i = 0; i < this.data[serie].length - 1; ++i) {
                this.data[serie][i] = this.data[serie][i + 1];
            }
            this.setSample(serie, this.sampleCount - 1, sample);
            return this.sampleCount - 1;
        }
        return -1;
    }

    public int appendSampleValue(int serie, double value, boolean makeSpace) {
        if (serie < 0 || serie >= this.seriesCount) {
            throw new IllegalArgumentException("Illegal serie: " + serie);
        }
        this.changedTime = System.currentTimeMillis();
        int lastSampleIndex = -1;
        for (int i = 0; i < this.sampleCount; ++i) {
            ChartSample s = this.data[serie][i];
            if (s != null && s.hasValue()) continue;
            lastSampleIndex = i;
            break;
        }
        int return_index = lastSampleIndex;
        if (lastSampleIndex >= 0) {
            this.setSampleValue(serie, lastSampleIndex, value);
        } else if (makeSpace) {
            int count = this.sampleCount;
            this.setSampleCount(count + 1);
            this.setSampleValue(serie, count, value);
            return_index = count;
        } else if (this.sampleCount > 0) {
            double[] values = this.getSampleValues(serie);
            for (int i = 0; i < values.length - 1; ++i) {
                values[i] = values[i + 1];
            }
            values[values.length - 1] = value;
            this.setSampleValues(serie, values);
            return_index = values.length - 1;
        }
        return return_index;
    }

    public int appendSampleLabel(String label, boolean makeSpace) {
        this.changedTime = System.currentTimeMillis();
        int lastSampleIndex = -1;
        int sampleCount = this.getSampleCount();
        if (this.sampleLabels != null) {
            for (int i = 0; i < sampleCount; ++i) {
                if (this.getSampleLabel(i) != null) continue;
                lastSampleIndex = i;
                break;
            }
        }
        int return_index = lastSampleIndex;
        if (lastSampleIndex >= 0) {
            this.setSampleLabel(lastSampleIndex, label);
        } else if (makeSpace) {
            this.setSampleLabel(this.sampleLabels.length, label);
            return_index = this.sampleLabels.length;
        } else if (sampleCount > 0) {
            for (int i = 0; i < this.sampleLabels.length - 1; ++i) {
                this.sampleLabels[i] = this.sampleLabels[i + 1];
            }
            this.sampleLabels[this.sampleLabels.length - 1] = label;
            return_index = this.sampleLabels.length - 1;
        }
        return return_index;
    }

    public void setSampleLabels(String[] labels) {
        if (labels != null && labels.length > this.sampleLabels.length) {
            this.sampleLabels = new String[labels.length];
        }
        int count = Math.max(labels != null ? labels.length : 0, this.sampleLabels.length);
        for (int i = 0; i < count; ++i) {
            if (i >= this.sampleLabels.length) continue;
            this.sampleLabels[i] = labels == null ? null : (i < labels.length ? labels[i] : null);
        }
        this.setIndividualSampleLabels();
        this.changedTime = System.currentTimeMillis();
    }

    public String[] getSampleLabels() {
        if (this.sampleLabels != null) {
            return this.sampleLabels;
        }
        return new String[0];
    }

    public void setSampleLabel(int index, String label) {
        if (index < 0) {
            return;
        }
        if (this.sampleLabels == null || index >= this.sampleLabels.length) {
            int count = Math.max(this.getSampleCount(), index + 1);
            String[] newSampleLabels = new String[count];
            if (this.sampleLabels != null) {
                System.arraycopy(this.sampleLabels, 0, newSampleLabels, 0, Math.min(count, this.sampleLabels.length));
            }
            this.sampleLabels = newSampleLabels;
        }
        this.sampleLabels[index] = label;
        for (int serie = 0; serie < this.seriesCount; ++serie) {
            this.setIndividualSampleLabel(serie, index);
        }
        this.changedTime = System.currentTimeMillis();
    }

    public String getSampleLabel(int index) {
        try {
            return this.sampleLabels[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
    }

    public void setSeriesLabels(String[] labels) {
        for (int i = 0; i < this.seriesCount; ++i) {
            this.seriesLabels[i] = labels == null ? null : (i < labels.length ? labels[i] : null);
        }
        this.setIndividualSampleLabels();
        this.changedTime = System.currentTimeMillis();
    }

    public String[] getSeriesLabels() {
        String[] labels = new String[this.seriesCount];
        System.arraycopy(this.seriesLabels, 0, labels, 0, labels.length);
        return labels;
    }

    public void setSeriesLabel(int serie, String label) {
        try {
            this.seriesLabels[serie] = label;
            for (int index = 0; index < this.sampleCount; ++index) {
                this.setIndividualSampleLabel(serie, index);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + serie);
        }
        this.changedTime = System.currentTimeMillis();
    }

    public String getSeriesLabel(int serie) {
        try {
            return this.seriesLabels[serie];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid series: " + serie);
        }
    }

    public void setSelection(int serie, int sample, boolean selected) {
        this.setSelection(serie, sample, selected, false);
    }

    void setSelection(int serie, int sample, boolean selected, boolean clear) {
        if (clear) {
            this.setSelection(false);
        }
        if (serie == -1 && sample == -1) {
            for (int i = 0; i < this.seriesCount; ++i) {
                for (int j = 0; j < this.sampleCount; ++j) {
                    if (this.data[i] == null || this.data[i][j] == null) continue;
                    this.data[i][j].setSelection(selected);
                }
            }
        } else if (serie == -1) {
            for (int i = 0; i < this.seriesCount; ++i) {
                if (this.data[i] == null || sample < 0 || sample >= this.data[i].length || this.data[i][sample] == null) continue;
                this.data[i][sample].setSelection(selected);
            }
        } else if (sample == -1) {
            for (int i = 0; i < this.sampleCount; ++i) {
                if (serie < 0 || serie >= this.data.length || this.data[serie] == null || this.data[serie][i] == null) continue;
                this.data[serie][i].setSelection(selected);
            }
        } else if (this.data != null && serie >= 0 && serie < this.data.length && this.data[serie] != null && sample >= 0 && sample < this.data[serie].length && this.data[serie][sample] != null) {
            this.data[serie][sample].setSelection(selected);
        }
        this.changedTime = System.currentTimeMillis();
    }

    private void setSelection(boolean selected) {
        for (int serie = 0; serie < this.seriesCount; ++serie) {
            for (int sample = 0; sample < this.sampleCount; ++sample) {
                try {
                    if (this.data[serie] == null || this.data[serie][sample] == null) continue;
                    this.data[serie][sample].setSelection(selected);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.changedTime = System.currentTimeMillis();
    }

    public boolean isSelected(int serie, int sample) {
        if (serie < -1 || serie >= this.seriesCount) {
            throw new IllegalArgumentException("Invalid series index: " + serie);
        }
        if (sample < -1 || sample >= this.sampleCount) {
            throw new IllegalArgumentException("Invalid sample index: " + sample);
        }
        boolean selected = true;
        if (this.data != null && serie == -1 && sample == -1) {
            for (int i = 0; i < this.seriesCount && i < this.data.length; ++i) {
                for (int j = 0; j < this.sampleCount; ++j) {
                    if (this.data[i] != null && this.data[i][j] != null && this.data[i][j].isSelected()) continue;
                    selected = false;
                }
            }
        } else if (this.data != null && sample == -1 && serie >= 0) {
            for (int i = 0; i < this.sampleCount; ++i) {
                if (serie >= this.data.length || this.data[serie] == null || i >= this.data[serie].length || this.data[serie][i] == null || this.data[serie][i].isSelected()) continue;
                selected = false;
            }
        } else if (this.data != null && serie == -1) {
            for (int i = 0; i < this.seriesCount && i < this.data.length; ++i) {
                if (this.data[i] == null || sample >= this.data[i].length || this.data[i][sample] == null || this.data[i][sample].isSelected()) continue;
                selected = false;
            }
        } else if (!(this.data == null || this.data[serie] != null && this.data[serie][sample] != null && this.data[serie][sample].isSelected())) {
            selected = false;
        }
        return selected;
    }

    public void setSeriesCount(int count) {
        this.setDataCount(count, this.sampleCount);
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public void setSampleCount(int count) {
        this.setDataCount(this.seriesCount, count);
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public double getMaxValue(int serie) {
        boolean maximumOfOneSeries = serie >= 0 && serie < this.seriesCount;
        boolean sampleFound = false;
        double max = -1.7976931348623157E308;
        if (maximumOfOneSeries) {
            for (int i = 0; i < this.sampleCount; ++i) {
                ChartSample sample = this.data[serie][i];
                if (sample == null || sample.value == null || sample.value.isNaN()) continue;
                max = Math.max(max, sample.getFloatValue());
                sampleFound = true;
            }
        } else {
            for (int i = 0; i < this.seriesCount; ++i) {
                for (int j = 0; j < this.sampleCount; ++j) {
                    ChartSample sample = this.data[i][j];
                    if (sample == null || sample.value == null || sample.value.isNaN()) continue;
                    max = Math.max(max, sample.getFloatValue());
                    sampleFound = true;
                }
            }
        }
        if (sampleFound) {
            return max;
        }
        return 0.0;
    }

    public double getMinValue(int serie) {
        boolean minimumOfOneSeries = serie >= 0 && serie < this.seriesCount;
        boolean sampleFound = false;
        double min = Double.MAX_VALUE;
        if (minimumOfOneSeries) {
            for (int i = 0; i < this.sampleCount; ++i) {
                ChartSample sample = this.data[serie][i];
                if (sample == null || sample.value == null || sample.value.isNaN()) continue;
                min = Math.min(min, sample.getFloatValue());
                sampleFound = true;
            }
        } else {
            for (int i = 0; i < this.seriesCount; ++i) {
                for (int j = 0; j < this.sampleCount; ++j) {
                    ChartSample sample = this.data[i][j];
                    if (sample == null || sample.value == null || sample.value.isNaN()) continue;
                    min = Math.min(min, sample.getFloatValue());
                    sampleFound = true;
                }
            }
        }
        if (sampleFound) {
            return min;
        }
        return 0.0;
    }

    public boolean hasChangedSince(long time) {
        return this.changedTime >= time;
    }

    public String toString() {
        return "ChartData " + this.seriesCount + " series, " + this.sampleCount + " samples";
    }

    private void setDataCount(int seriesCount, int sampleCount) {
        int i;
        if (this.seriesCount == seriesCount && this.sampleCount == sampleCount) {
            return;
        }
        this.seriesCount = Math.max(0, seriesCount);
        this.sampleCount = Math.max(0, sampleCount);
        ChartSample[][] newData = new ChartSample[this.seriesCount][this.sampleCount];
        for (int serie = 0; serie < newData.length; ++serie) {
            if (serie >= this.data.length) continue;
            ChartSample[] samples = newData[serie];
            for (i = 0; i < samples.length; ++i) {
                if (i >= this.data[serie].length) continue;
                newData[serie][i] = this.data[serie][i];
            }
        }
        this.data = newData;
        String[] newSeriesLabels = new String[this.seriesCount];
        for (int i2 = 0; i2 < newSeriesLabels.length; ++i2) {
            if (i2 >= this.seriesLabels.length) continue;
            newSeriesLabels[i2] = this.seriesLabels[i2];
        }
        this.seriesLabels = newSeriesLabels;
        String[] newSampleLabels = new String[this.sampleCount];
        for (i = 0; i < newSampleLabels.length; ++i) {
            if (i >= this.sampleLabels.length) continue;
            newSampleLabels[i] = this.sampleLabels[i];
        }
        this.sampleLabels = newSampleLabels;
        this.changedTime = System.currentTimeMillis();
    }

    private void setIndividualSampleLabel(int serie, int index) {
        ChartSample sample;
        if (this.data != null && serie < this.data.length && this.data[serie] != null && index < this.data[serie].length && (sample = this.data[serie][index]) != null) {
            String seriesLabel = this.seriesLabels[serie];
            String sampleLabel = null;
            if (index < this.sampleLabels.length) {
                sampleLabel = this.sampleLabels[index];
            }
            String label = "";
            if (seriesLabel != null && sampleLabel != null) {
                label = seriesLabel + " " + sampleLabel;
            } else if (seriesLabel != null) {
                label = seriesLabel;
            } else if (sampleLabel != null) {
                label = sampleLabel;
            }
            sample.setLabel(label);
        }
    }

    private void setIndividualSampleLabels() {
        for (int serie = 0; serie < this.seriesCount; ++serie) {
            ChartSample[] samples = this.data[serie];
            if (samples == null) continue;
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] == null) continue;
                String seriesLabel = this.seriesLabels[serie];
                String sampleLabel = this.sampleLabels[i];
                if (seriesLabel != null && sampleLabel != null) {
                    samples[i].setLabel(seriesLabel + " " + sampleLabel);
                    continue;
                }
                if (seriesLabel != null) {
                    samples[i].setLabel(seriesLabel);
                    continue;
                }
                if (sampleLabel == null) continue;
                samples[i].setLabel(sampleLabel);
            }
        }
    }
}

