/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.utils.UnimplementedOperationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringBufferInputStream;
import java.sql.DriverManager;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Debug {
    private static final String MESSAGE = "Use jConnect devclasses for debugging.";
    private static final int MAX_JDB_OUTPUT = 128;
    private static boolean _printedMessage = false;
    private static boolean _debugAll = false;
    protected static String _debugClassList = null;
    private static byte[] _debugListBytes = null;
    protected static PrintStream _debugOutputStream;
    protected static PrintWriter _debugOutputWriter;
    private static Hashtable _times;
    private static long _staticTO;
    private static boolean _disableAssertTrace;

    static {
        _debugOutputWriter = null;
        _times = new Hashtable(8);
        _staticTO = 0L;
        _disableAssertTrace = false;
        _debugOutputStream = DriverManager.getLogStream();
        if (_debugOutputStream == null) {
            _debugOutputStream = System.out;
        }
    }

    private Debug() {
    }

    public static void assert(Object o, boolean condition) {
        Debug.assert(o, condition, null);
    }

    public static void assert(Object o, boolean condition, String n) throws RuntimeException {
        if (!condition) {
            String[] msgList = new String[]{n, Debug.className(o), Thread.currentThread().getName()};
            ErrorMessage.raiseRuntimeException("JZ0AF", msgList);
        }
    }

    public static final void assert(boolean statement, String exitMessage) {
        Debug.assert(null, statement, exitMessage);
    }

    public static void checkObj(Object o, String n, Object x) {
        if (x == null) {
            Debug.println(o, "checkObj: " + n + " is null");
        } else {
            Debug.println(o, "checkObj: " + n + x);
        }
    }

    private static String className(Object o) {
        if (o != null) {
            return o.getClass().getName();
        }
        return "";
    }

    public static void debug(boolean onOff) throws IOException {
        Debug.debug(onOff, "ALL");
    }

    public static void debug(boolean onOff, String classes) throws IOException {
        Debug.debug(onOff, classes, _debugOutputStream);
    }

    public static void debug(boolean onOff, String classes, PrintStream logstream) throws IOException {
        if (onOff) {
            if (classes == null) {
                classes = "ALL";
            }
            _debugClassList = classes;
            _debugOutputStream = logstream;
            if (_debugClassList != null) {
                _debugListBytes = new byte[_debugClassList.length()];
                _debugClassList.getBytes(0, _debugClassList.length(), _debugListBytes, 0);
                _debugAll = Debug.isDebugOn();
            }
        } else {
            _debugClassList = null;
            _debugListBytes = null;
            _debugOutputStream = null;
            _debugAll = false;
        }
    }

    public static void disableAssertTrace(boolean condition) {
        _disableAssertTrace = condition;
    }

    private static String formatString(Object o, String s) {
        return String.valueOf(Debug.className(o)) + "(" + Thread.currentThread() + "): " + s;
    }

    public static PrintStream getOutputStream() {
        return _debugOutputStream;
    }

    public static PrintWriter getOutputWriter() {
        return _debugOutputWriter;
    }

    private static boolean isDebugObject(Object o) {
        String name = o == null ? "STATIC" : Debug.stripPrefix(Debug.className(o));
        if (_debugListBytes == null) {
            return false;
        }
        return name != null && Debug.parseList(name);
    }

    private static boolean isDebugOn() {
        return Debug.parseList("ALL");
    }

    public static void notImplemented(Object o, String method) throws UnimplementedOperationException {
        String[] msgList = new String[]{String.valueOf(Debug.className(o)) + "." + method};
        ErrorMessage.raiseRuntimeException("ZZ00A", msgList);
    }

    public static void notSupported(Object o, String method) throws UnsupportedOperationException {
        String[] msgList = new String[]{String.valueOf(Debug.className(o)) + "." + method};
        ErrorMessage.raiseRuntimeException("JZ0NS", msgList);
    }

    private static boolean parseList(String name) {
        StreamTokenizer st = new StreamTokenizer(new ByteArrayInputStream(_debugListBytes));
        st.wordChars(0, 255);
        st.whitespaceChars(58, 58);
        try {
            while (st.nextToken() == -3) {
                if (st.sval.compareTo(name) != 0) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            Debug.println("parsing debugClassList exception for: " + _debugClassList);
            return false;
        }
        return false;
    }

    private static void printMessage() {
    }

    public static void printStackTrace(Object o, Exception e) {
        if (_debugAll || Debug.isDebugObject(o)) {
            Debug.println(Debug.formatString(o, e.toString()));
            if (!_disableAssertTrace && _debugOutputStream != null) {
                e.printStackTrace(_debugOutputStream);
            }
        }
    }

    public static void println(Object o, String s) {
        if (_debugAll || Debug.isDebugObject(o)) {
            Debug.println(Debug.formatString(o, s));
        }
    }

    public static void println(String s) {
        if (_debugOutputStream == null && _debugOutputWriter == null) {
            return;
        }
        int len = s.length();
        int start = 0;
        int end = 0;
        while (end < len) {
            end = start + 128;
            if (end >= len) {
                if (_debugOutputWriter != null) {
                    _debugOutputWriter.println(s.substring(start, len));
                } else {
                    _debugOutputStream.println(s.substring(start, len));
                }
            } else if (_debugOutputWriter != null) {
                _debugOutputWriter.println(s.substring(start, len));
            } else {
                _debugOutputStream.print(s.substring(start, end));
            }
            start = end;
        }
    }

    public static void setOutputStream(PrintStream ps) {
        _debugOutputStream = ps;
    }

    public static void setOutputWriter(PrintWriter pw) {
        _debugOutputWriter = pw;
    }

    public static void startTimer(Object obj) {
        long time = System.currentTimeMillis();
        if (_debugAll || Debug.isDebugObject(obj)) {
            if (obj != null) {
                _times.put(obj, new Long(System.currentTimeMillis()));
            } else {
                _staticTO = System.currentTimeMillis();
            }
        }
    }

    public static void stopTimer(Object obj, String str) {
        long time = System.currentTimeMillis();
        if (_debugAll || Debug.isDebugObject(obj)) {
            if (obj != null) {
                Long start = (Long)_times.get(obj);
                if (start == null) {
                    Debug.println(Debug.formatString(obj, "No start time found for " + str));
                    return;
                }
                time -= start.longValue();
                _times.remove(obj);
            } else {
                time -= _staticTO;
            }
            Debug.println(Debug.formatString(obj, String.valueOf(str) + "; elapsed time = " + time + "ms."));
        }
    }

    private static String stripPrefix(String fullName) {
        String name = fullName;
        StreamTokenizer st = new StreamTokenizer(new StringBufferInputStream(fullName));
        st.wordChars(0, 255);
        st.whitespaceChars(46, 46);
        try {
            while (st.nextToken() == -3) {
                name = st.sval;
            }
        }
        catch (IOException iOException) {
            Debug.println("parsing class name exception for: " + fullName);
            return null;
        }
        return name;
    }
}

