/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import com.sybase.jdbc2.utils.BufferPool;

public class BufferInterval {
    public byte[] _buf;
    public int _offset;
    public int _length;
    private BufferPool _bp;
    protected BufferInterval _prev;
    protected BufferInterval _next;

    public BufferInterval(byte[] buf, int off, int len, BufferPool bp) {
        this._buf = buf;
        this._offset = off;
        this._length = len;
        this._bp = bp;
        this._next = null;
        this._prev = null;
    }

    protected void attachAfter(BufferInterval lo) {
        this._next = lo._next;
        this._prev = lo;
        if (lo._next != null) {
            lo._next._prev = this;
        }
        lo._next = this;
    }

    protected void attachBefore(BufferInterval lo) {
        this._next = lo;
        this._prev = lo._prev;
        if (lo._prev != null) {
            lo._prev._next = this;
        }
        lo._prev = this;
    }

    protected void detach() {
        if (this._prev != null) {
            this._prev._next = this._next;
        }
        if (this._next != null) {
            this._next._prev = this._prev;
        }
        this._next = null;
        this._prev = null;
    }

    public synchronized BufferInterval divide(int len) throws IndexOutOfBoundsException {
        BufferInterval retbi = null;
        if (len > 0) {
            if (this._length == len) {
                throw new IndexOutOfBoundsException("BufferInterval");
            }
            retbi = new BufferInterval(this._buf, this._offset, len, this._bp);
            this._offset += len;
            this._length -= len;
        }
        return retbi;
    }

    public void free() {
        this._bp.put(this);
    }

    protected synchronized boolean merge(BufferInterval bi, boolean inList) {
        if (this._buf != bi._buf) {
            return false;
        }
        if (this._offset + this._length == bi._offset) {
            if (inList) {
                bi._length += this._length;
                bi._offset = this._offset;
            } else {
                this._length += bi._length;
            }
            return true;
        }
        if (bi._offset + bi._length == this._offset) {
            if (inList) {
                bi._length += this._length;
            } else {
                this._length += bi._length;
                this._offset = bi._offset;
            }
            return true;
        }
        return false;
    }
}

