/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.timedio;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.timedio.Dbio;
import com.sybase.jdbc2.timedio.InStreamMgr;
import com.sybase.jdbc2.timedio.TDSTunnellingIS;
import com.sybase.jdbc2.timedio.TDSTunnellingOS;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.Queue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.SQLException;

public class URLDbio
extends Dbio {
    private URL _urlNone = null;
    private URL _urlMore = null;
    private URL _urlPoll = null;
    private URL _urlClose = null;
    private URL _urlConnect = null;
    private URL _url = null;
    private String _protocol = null;
    private StringBuffer _file = null;
    private String _urlBase = null;
    protected String _tdsSessionID = null;
    private boolean _readRequested = false;
    private boolean _closing = false;
    private Queue _responses = null;
    private TDSTunnellingIS _ttis = null;
    private TDSTunnellingOS _ttos = null;
    public static final int NONE = 1;
    public static final int MORE = 2;
    public static final int POLL = 3;
    public static final int CLOSE = 4;
    public static final String TDS_SESSION = "Tds-Session";
    public static final String IGNORE_SESSION = "IGNORE";
    public static final String TDS_OPERATION = "Operation";
    public static final String TDS_TIMEOUT = "Timeout";
    public static final String OPERATION_POLL = "poll";
    public static final String OPERATION_MORE = "more";
    public static final String OPERATION_CLOSE = "close";
    public static final String HOST = "host";
    public static final String PORT = "port";

    protected URLDbio(String host, int port, InStreamMgr ioMgr, SybProperty props) throws SQLException {
        super(host, port, ioMgr, props);
        this._tdsSessionID = props.getString(20);
        if (this._tdsSessionID != null) {
            try {
                this.registerSessionId();
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.getMessage());
            }
            return;
        }
        int timeout = props.getInteger(19);
        this._file = new StringBuffer();
        this._file.append("?");
        this._file.append(HOST);
        this._file.append('=');
        this._file.append(host);
        this._file.append('&');
        this._file.append(PORT);
        this._file.append('=');
        this._file.append(port);
        this._file.append('&');
        this._file.append(TDS_OPERATION);
        this._file.append('=');
        this._file.append(OPERATION_MORE);
        if (timeout > 0) {
            this._file.append('&');
            this._file.append(TDS_TIMEOUT);
            this._file.append('=');
            this._file.append(timeout * 1000);
        }
    }

    protected synchronized void close() {
        while (!this._responses.empty()) {
            try {
                URLConnection uc = (URLConnection)this._responses.pop();
                InputStream is = uc.getInputStream();
                is.close();
            }
            catch (IOException iOException) {}
        }
        try {
            if (!this._closing) {
                this._ttos.close();
            }
        }
        catch (IOException iOException) {}
    }

    protected void closing() {
        this._closing = true;
    }

    protected void doConnect(int timeout) throws IOException {
        if (this._tdsSessionID == null) {
            this._urlConnect = new URL(String.valueOf(this._proxyHost) + this._file);
            Debug.println(this, "_urlConnect = " + this._urlConnect.toString());
        }
        this._ttis = new TDSTunnellingIS(this);
        this._in = this._ttis;
        this._ttos = new TDSTunnellingOS(this);
        this._out = this._ttos;
        this._responses = new Queue(4, 4);
    }

    public String getSessionID() {
        return this._tdsSessionID;
    }

    protected synchronized URLConnection getURLC(long timeout) throws IOException {
        URLConnection uc = null;
        while (uc == null) {
            uc = (URLConnection)this._responses.popNoEx();
            if (uc != null) continue;
            Debug.println(this, "asking for MORE");
            this._ttos.moreData(timeout);
        }
        Debug.println(this, "content-type = " + uc.getContentType());
        int i = 0;
        while (i < 100) {
            String name = uc.getHeaderFieldKey(i);
            String value = uc.getHeaderField(name);
            Debug.println(this, " " + i + ":  " + name + " = " + value);
            if (name == null && i > 0) break;
            ++i;
        }
        String tID = uc.getHeaderField(TDS_SESSION);
        if (tID == null) {
            ErrorMessage.raiseIOException("JZ0T6");
        }
        if (tID.equals(IGNORE_SESSION)) {
            Debug.println(this, "Ignoring empty response");
            InputStream is = uc.getInputStream();
            is.close();
            return this.getURLC(timeout);
        }
        if (this._tdsSessionID == null) {
            this._tdsSessionID = tID;
            this.registerSessionId();
        }
        return uc;
    }

    protected int reallyRead(long timeout) throws IOException {
        int nbytes = 0;
        nbytes = this._ttis.read(this._bufIntv._buf, this._bufIntv._offset + this._bRead, this._bufIntv._length - this._bRead, timeout);
        return nbytes;
    }

    private void registerSessionId() throws IOException {
        Debug.println(this, "Session ID = " + this._tdsSessionID);
        this._urlBase = "?Tds-Session=" + this._tdsSessionID;
        this._urlNone = new URL(String.valueOf(this._proxyHost) + this._urlBase);
        this._urlMore = new URL(String.valueOf(this._proxyHost) + this._urlBase + "&" + TDS_OPERATION + "=" + OPERATION_MORE);
        this._urlPoll = new URL(String.valueOf(this._proxyHost) + this._urlBase + "&" + TDS_OPERATION + "=" + OPERATION_POLL);
        this._urlClose = new URL(String.valueOf(this._proxyHost) + this._urlBase + "&" + TDS_OPERATION + "=" + OPERATION_CLOSE);
    }

    protected void write(int operation, byte[] buf, int length) throws IOException {
        Debug.println(this, "setURLC(" + operation + ")");
        switch (operation) {
            case 1: {
                this._url = this._urlNone;
                break;
            }
            case 2: {
                this._url = this._urlMore;
                break;
            }
            case 3: {
                this._url = this._urlPoll;
                break;
            }
            case 4: {
                if (this._urlClose == null) {
                    return;
                }
                this._url = this._urlClose;
                break;
            }
            default: {
                Debug.assert(this, false);
            }
        }
        if (this._closing) {
            this._url = this._urlClose;
        }
        if (this._url == null) {
            this._url = this._urlConnect;
        }
        URLConnection uc = this._url.openConnection();
        uc.setUseCaches(false);
        uc.setDoInput(true);
        uc.setRequestProperty("Connection", " Keep-Alive");
        if (length > 0) {
            uc.setDoOutput(true);
            OutputStream os = uc.getOutputStream();
            os.write(buf, 0, length);
            os.flush();
        }
        if (operation == 4) {
            InputStream is = uc.getInputStream();
            is.close();
        } else {
            this._responses.push(uc);
        }
    }
}

