/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;

public class Slurp
extends Token {
    public Slurp() {
    }

    public Slurp(TdsInputStream in, int ttype) throws IOException {
        try {
            int len = this.getLength(in, ttype);
            in.skipBytes(len);
        }
        catch (IOException ioe) {
            Token.readSQE(ioe);
        }
    }

    public int getLength(TdsInputStream in, int ttype) throws IOException {
        int len = 0;
        try {
            if ((ttype & 0xE0) == 192) {
                len = 0;
                Debug.println(this, "Ignoring 0-length token " + ttype);
            } else if ((ttype & 0x30) == 48) {
                switch (ttype & 0xC) {
                    case 0: {
                        len = 1;
                        break;
                    }
                    case 4: {
                        len = 2;
                        break;
                    }
                    case 8: {
                        len = 4;
                        break;
                    }
                    case 12: {
                        len = 8;
                        break;
                    }
                }
                Debug.println(this, "Ignoring fixed-length token " + ttype + " length = " + len);
            } else {
                switch (ttype & 0xFC) {
                    case 36: 
                    case 40: 
                    case 100: 
                    case 104: {
                        len = in.readUnsignedByte();
                        Debug.println(this, "Ignoring variable-length token (1byte) " + ttype + " length = " + len);
                        break;
                    }
                    case 32: 
                    case 96: {
                        len = in.readInt();
                        Debug.println(this, "Ignoring variable-length token (4byte) " + ttype + " length = " + len);
                        break;
                    }
                    default: {
                        len = in.readUnsignedShort();
                        Debug.println(this, "Ignoring variable-length token (2byte) " + ttype + " length = " + len);
                        break;
                    }
                }
            }
        }
        catch (IOException ioe) {
            Token.readSQE(ioe);
        }
        return len;
    }
}

