/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.RowDataFormat2;
import com.sybase.jdbc2.tds.RowFormatToken;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.sql.SQLException;

public class RowFormat2Token
extends RowFormatToken {
    public RowFormat2Token() throws SQLException {
        this._numColumns = 0;
        this._column = new RowDataFormat2[this._numColumns];
    }

    public RowFormat2Token(int columns) throws SQLException {
        this._numUserColumns = columns;
        this._numColumns = columns;
        this._column = new RowDataFormat2[this._numColumns];
    }

    public RowFormat2Token(TdsInputStream in) throws IOException {
        super(in);
    }

    protected DataFormat dataFormatFactory(TdsInputStream in) throws IOException {
        return new RowDataFormat2(in);
    }

    public String getCatalogName(int colIndex) throws SQLException {
        int column = this.mapColumn(colIndex);
        String catName = ((RowDataFormat2)this.getDataFormat((int)column))._catalogName;
        return catName;
    }

    public String getColumnLabel(int colIndex) throws SQLException {
        int column = this.mapColumn(colIndex);
        return this.getLabel(column);
    }

    protected String getDBOwnerName(int column) throws SQLException {
        Debug.assert(this, column < this._column.length && column >= 0);
        return ((RowDataFormat2)this.getDataFormat((int)column))._schemaName;
    }

    protected String getLabel(int column) throws SQLException {
        Debug.assert(this, column < this._column.length && column >= 0);
        return ((RowDataFormat2)this.getDataFormat((int)column))._labelName;
    }

    public String getSchemaName(int colIndex) throws SQLException {
        int column = this.mapColumn(colIndex);
        String schemaName = this.getDBOwnerName(column);
        return schemaName;
    }

    public String getTableName(int colIndex) throws SQLException {
        int column = this.mapColumn(colIndex);
        String tName = this.getDataFormat((int)column)._tableName;
        return tName;
    }

    protected long readLength(TdsInputStream in) throws IOException {
        long len = in.readUnsignedIntAsLong();
        return len;
    }
}

