/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;

public class LoginAckToken
extends Token {
    protected int _status;
    protected byte[] _tdsVers = null;
    protected String _progName = null;
    protected byte[] _progVers = null;

    protected LoginAckToken() {
    }

    public LoginAckToken(TdsInputStream in) throws IOException {
        int length = in.readShort();
        this._status = in.readUnsignedByte();
        this._tdsVers = new byte[4];
        in.read(this._tdsVers);
        length = in.readUnsignedByte();
        this._progName = in.readString(length);
        this._progVers = new byte[4];
        in.read(this._progVers);
        Debug.println(this, "\nLogin Ack: status = " + this._status + "\n\tTDS Version: " + LoginAckToken.makeVersionString(this._tdsVers) + "\n\tProgram Name: " + this._progName + "\n\tprogram Version: " + LoginAckToken.makeVersionString(this._progVers));
    }

    protected int getLoginStatus() {
        return this._status;
    }

    protected String getTdsVersionString() {
        return LoginAckToken.makeVersionString(this._tdsVers);
    }

    protected boolean loginOK() {
        boolean loginOK = false;
        String msg = "UNRECOGNIZED STATUS";
        switch (this._status) {
            case 5: {
                msg = "SUCCEED";
                loginOK = true;
                break;
            }
            case 7: {
                msg = "NEGOTIATE";
                loginOK = true;
                break;
            }
            case 6: {
                msg = "LOG_FAIL";
                break;
            }
            default: {
                Debug.assert(this, false, "Bad login status");
            }
        }
        Debug.println(this, "Login status = " + msg);
        return loginOK;
    }

    public static String makeVersionString(byte[] vers) {
        if (vers == null || vers.length < 4) {
            return null;
        }
        return String.valueOf(vers[0]) + "." + vers[1] + "." + vers[2] + "." + vers[3];
    }

    protected boolean tdsVersionOK() {
        return this._tdsVers != null && this._tdsVers[0] >= 5;
    }
}

