/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc2.jdbc.SybPooledConnection;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbc2.jdbc.SybXADataSource;
import com.sybase.jdbc2.jdbc.SybXAResource;
import com.sybase.jdbc2.jdbc.SybXid;
import com.sybase.jdbc2.utils.Debug;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Random;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class SybXAConnection
extends SybPooledConnection
implements XAConnection {
    private final SybXAResource _xaRes;

    protected SybXAConnection(SybXADataSource xds, SybUrlProvider up) throws SQLException {
        super(up, xds.getLoginTimeout());
        String errorState = null;
        String errorArg = null;
        int coordinatorType = xds.getResourceManagerType();
        if (coordinatorType == 1) {
            Debug.println(this, "constructing SybXAConnection for XA Server 11");
            this._xaRes = SybXAResource.createSybXAResource(coordinatorType, up.getResourceManagerName(), this, xds, up);
            Debug.assert(this, this._xaRes != null, "Failed to create SybXAResource for XA Server 11");
            Random rnd = new Random();
            byte[] gtrid = new byte[16];
            rnd.nextBytes(gtrid);
            byte[] bqual = new byte[8];
            rnd.nextBytes(bqual);
            SybXid xid = new SybXid(99, gtrid, bqual);
            try {
                this._xaRes.start(xid, 0);
                super.init();
                this._xaRes.end(xid, 0x4000000);
                int result = this._xaRes.prepare(xid);
                if (result == 0) {
                    this._xaRes.commit(xid, true);
                } else {
                    Debug.assert(this, result == 3);
                }
            }
            catch (XAException xae) {
                Debug.println(this, "failed to init connection");
                Debug.println(this, "XAException error is " + xae.errorCode);
                Debug.printStackTrace(this, xae);
                this.close();
                ErrorMessage.raiseError("JZ0XS");
            }
            return;
        }
        super.init();
        SybDatabaseMetaData dbmd = (SybDatabaseMetaData)this.getMetaData();
        ResultSet rs = dbmd.getXACoordinatorType();
        ResultSetMetaData rsmd = rs.getMetaData();
        int numCols = rsmd.getColumnCount();
        rs.next();
        coordinatorType = rs.getInt(1);
        String requiredRole = rs.getString(2);
        int statusBits = rs.getInt(3);
        String uniqueID = xds.toString();
        if (rsmd.getColumnCount() > 3) {
            uniqueID = rs.getString(4);
        }
        rs.close();
        Debug.println(this, "getxacoordinatortype returned: type = " + coordinatorType + ", role = " + requiredRole + ", status = " + statusBits);
        if (coordinatorType == 0) {
            this._xaRes = null;
            errorState = "JZ0XS";
        } else if ((statusBits & 1) == 0) {
            this._xaRes = null;
            errorState = "JZ0XU";
            errorArg = requiredRole;
        } else {
            this._xaRes = SybXAResource.createSybXAResource(coordinatorType, uniqueID, this, xds, up);
            if (this._xaRes == null) {
                errorState = "JZ0XC";
                errorArg = String.valueOf(coordinatorType);
            }
        }
        if (errorState != null) {
            this.close();
            if (errorArg != null) {
                ErrorMessage.raiseError(errorState, errorArg);
            } else {
                ErrorMessage.raiseError(errorState);
            }
        }
        Debug.println(this, "SybXAConnection() complete");
    }

    public void close() throws SQLException {
        Debug.println(this, "close()");
        if (this._xaRes != null) {
            this._xaRes.close();
        }
        super.close();
    }

    public XAResource getXAResource() {
        Debug.println(this, "getXAResource()");
        return this._xaRes;
    }

    protected void init() {
        Debug.println(this, "init() will do nothing at this time");
    }
}

