/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.ProtocolManager;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbc2.jdbc.SybUrlProviderImplBase;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;

public class SybUrlManager
extends SybUrlProviderImplBase {
    public static final String KEYWORD_JDBC = "jdbc";
    public static final String KEYWORD_SYBASE = "sybase";
    public static final String KEYWORD_JNDI = "jndi";
    public static final String PACKAGE_PREFIX = "com.sybase.jdbc2.";
    private static final String JNDI_PROVIDER = "jdbc.SybJndiProvider";
    private Properties _userProps = null;
    private String _url = null;
    private String _providerName = null;
    private String _urlRest = null;

    public SybUrlManager(String url, Properties userProps, SybProperty sybProps) throws SQLException {
        this._url = url;
        this._sybProps = sybProps;
        this._userProps = userProps;
        this._hostportList = new Vector();
        this.validateUrl();
    }

    public SybUrlProvider getUrlProvider() throws SQLException {
        String urlProviderName = PACKAGE_PREFIX;
        SybUrlProvider urlProvider = null;
        if (this._providerName == null) {
            return null;
        }
        if (this._providerName.equals(KEYWORD_JNDI)) {
            urlProviderName = String.valueOf(urlProviderName) + JNDI_PROVIDER;
            try {
                Debug.println(this, "loading URL Provider: " + urlProviderName);
                urlProvider = (SybUrlProvider)Class.forName(urlProviderName).newInstance();
            }
            catch (Exception ex) {
                Debug.println(null, "getUrlProvider -- unable to load " + urlProviderName);
                ErrorMessage.raiseError("JZ0D7", urlProviderName, ex.toString());
            }
        } else {
            urlProvider = this;
        }
        urlProvider.init(this._providerName, this._urlRest, this._userProps, this._sybProps);
        return urlProvider;
    }

    public void init(String protocol, String urlRest, Properties userProps, SybProperty sybProps) throws SQLException {
        String properties = null;
        String hostport = null;
        if (protocol.equals("shm")) {
            if (sybProps != null) {
                sybProps.setProperty(31, "com.sybase.shmem.ShmemSocketFactory");
            }
            protocol = "Tds";
        }
        this._protocol = SybUrlManager.loadProtocol(protocol);
        if (urlRest != null) {
            int slashIndex = urlRest.indexOf(47);
            int questionIndex = urlRest.indexOf(63);
            if (slashIndex > -1 && slashIndex < questionIndex) {
                hostport = urlRest.substring(0, slashIndex);
                this._dbName = urlRest.substring(slashIndex + 1, questionIndex);
                properties = urlRest.substring(questionIndex + 1);
            } else if (questionIndex > -1 && (slashIndex > questionIndex || slashIndex == -1)) {
                hostport = urlRest.substring(0, questionIndex);
                properties = urlRest.substring(questionIndex + 1);
            } else if (slashIndex > -1 && questionIndex == -1) {
                hostport = urlRest.substring(0, slashIndex);
                this._dbName = urlRest.substring(slashIndex + 1);
            } else {
                hostport = urlRest;
            }
        }
        Debug.println(this, "host+port = " + hostport + " and database = " + this._dbName);
        if (properties != null && sybProps != null) {
            this._sybProps.parsePropertyString(properties);
        }
        this._hostportList.addElement(hostport);
    }

    public static Protocol loadProtocol(String protocolName) throws SQLException {
        String protocolClassName = PACKAGE_PREFIX + protocolName.toLowerCase() + "." + protocolName;
        return ProtocolManager.getProtocol(protocolClassName);
    }

    private void validateUrl() throws SQLException {
        Debug.println(this, "parsing connect url: " + this._url);
        StreamTokenizer st = new StreamTokenizer(new StringReader(this._url));
        st.wordChars(0, 255);
        st.whitespaceChars(58, 58);
        try {
            if (st.nextToken() != -3) {
                Debug.println(this, "url doesn't start with word");
                return;
            }
            if (st.sval.compareTo(KEYWORD_JDBC) != 0) {
                Debug.println(this, "url doesn't start with 'jdbc'");
                return;
            }
            if (st.nextToken() != -3) {
                Debug.println(this, "url is not for sybase");
                return;
            }
            if (st.sval.compareTo(KEYWORD_SYBASE) != 0) {
                Debug.println(this, "url is not for sybase");
                return;
            }
            if (st.nextToken() != -3) {
                ErrorMessage.raiseError("JZ0D4", this._url);
            }
            this._providerName = st.sval;
            try {
                st.whitespaceChars(0, 0);
                st.resetSyntax();
                st.wordChars(0, 255);
                if (st.nextToken() == -3) {
                    this._urlRest = st.sval.substring(1);
                }
            }
            catch (IOException iOException) {
                Debug.println(this, "didn't find a colon ':' after the provider/protocol name");
                this._urlRest = null;
            }
        }
        catch (IOException ioe) {
            SQLException sqe = new SQLException(ioe.toString());
            throw sqe;
        }
    }
}

