/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.tds.Iana;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbcx.DynamicClassLoader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class SybProperty
implements Serializable,
Cloneable {
    private static final String OFF = "false";
    private static final String ON = "true";
    private static final String EMPTY_STRING = "";
    protected static final String IS_CLOSED_TEST_INTERNAL_VALUE = "INTERNAL";
    public static final int MAX_PROPS = 42;
    public static final int SERVICENAME = 0;
    public static final int HOSTNAME = 1;
    public static final int HOSTPROC = 2;
    public static final int USER = 3;
    public static final int PASSWORD = 4;
    public static final int APPLICATIONNAME = 5;
    public static final int USE_METADATA = 6;
    public static final int LANGUAGE = 7;
    public static final int CHARSET = 8;
    public static final int REMOTEPWD = 9;
    public static final int VERSIONSTRING = 10;
    public static final int EXPIRESTRING = 11;
    public static final int PACKETSIZE = 12;
    public static final int STREAM_CACHE_SIZE = 13;
    public static final int REPEAT_READ = 14;
    public static final int LITERAL_PARAMS = 15;
    public static final int CURSOR_ROWS = 16;
    public static final int PROXY = 17;
    public static final int SQL_INIT_STRING = 18;
    public static final int SESSION_TIMEOUT = 19;
    public static final int SESSION_ID = 20;
    public static final int CHARSET_CONVERTER_CLASS = 21;
    public static final int JCONNECT_VERSION = 22;
    public static final int CANCEL_ALL = 23;
    public static final int PROTOCOL_CAPTURE = 24;
    public static final int DYNAMIC_PREPARE = 25;
    public static final int CONNECTION_FAILOVER = 26;
    public static final int LANGUAGE_CURSOR = 27;
    public static final int SEND_LONG_PARAMS_REGARDLESS_OF_CAPABILITIES = 28;
    public static final int SERIALIZE_REQUESTS = 29;
    public static final int LSB_BYTE_ORDER = 30;
    public static final int SYBSOCKET_FACTORY = 31;
    public static final int IGNORE_DONE_IN_PROC = 32;
    public static final int SELECT_OPENS_CURSOR = 33;
    public static final int REQUEST_HA_SESSION = 34;
    public static final int ELIMINATE_010SM = 35;
    public static final int IS_CLOSED_TEST = 36;
    public static final int CLASS_LOADER = 37;
    public static final int PRELOAD_JARS = 38;
    public static final int FAKE_METADATA = 39;
    public static final int GET_BY_NAME_USES_COLUMN_LABEL = 40;
    public static final int BE_AS_JDBC_COMPLIANT_AS_POSSIBLE = 41;
    protected static final String[] PROPNAME = new String[]{"SERVICENAME", "HOSTNAME", "HOSTPROC", "user", "password", "APPLICATIONNAME", "USE_METADATA", "LANGUAGE", "CHARSET", "REMOTEPWD", "VERSIONSTRING", "EXPIRESTRING", "PACKETSIZE", "STREAM_CACHE_SIZE", "REPEAT_READ", "LITERAL_PARAMS", "CURSOR_ROWS", "proxy", "SQLInitString", "SESSION_TIMEOUT", "SESSION_ID", "CHARSET_CONVERTER_CLASS", "JCONNECT_VERSION", "CANCEL_ALL", "PROTOCOL_CAPTURE", "DYNAMIC_PREPARE", "CONNECTION_FAILOVER", "LANGUAGE_CURSOR", "SEND_LONG_PARAMS_REGARDLESS_OF_CAPABILITIES", "SERIALIZE_REQUESTS", "LSB_BYTE_ORDER", "SYBSOCKET_FACTORY", "IGNORE_DONE_IN_PROC", "SELECT_OPENS_CURSOR", "REQUEST_HA_SESSION", "ELIMINATE_010SM", "IS_CLOSED_TEST", "CLASS_LOADER", "PRELOAD_JARS", "FAKE_METADATA", "GET_BY_NAME_USES_COLUMN_LABEL", "BE_AS_JDBC_COMPLIANT_AS_POSSIBLE"};
    private static final String[] DEF_PROP_VALUE = new String[]{null, null, null, null, null, null, "true", null, null, null, "jConnect (TM) for JDBC(TM)/5.5(Build 25008)/P/DEBUG/JDK12/Tue May 29 14:29:40 2001", "Jul 28, 2001", String.valueOf(512), String.valueOf(-1), "true", "false", "1", null, null, "-1", null, "com.sybase.jdbc2.utils.PureConverter", "5", "true", null, "false", "true", "false", "false", "false", "false", null, "false", "false", "false", "false", null, null, null, "false", "true", "false"};
    protected static final String[] DESCRIPTION = new String[]{"interfaces entry corresponding to the backend which a DirectCONNECT gateway serves", "name of current host", "identify application's process on this host", "user name", "password", "application name", "Use JDBC metadata information installed on the database - if false, do not provide metadata", "language for messages from server", "character set for strings", "remote-server password", "jdbc driver version string", "jdbc driver expiration string, retreived from Key", "Size (in bytes) for network packets", "Maximum pre-fetch size of cache per connection", "Allow repeated use of getXXX for columns in any order - if false, read once from first to last only", "if set, parameter values are sent literally in the query", "Number of rows cursor should fetch at a time", "Address of the proxy gateway for the server", "A SQL Batch which will be executed at connection time", "The number of seconds an http tunnelled session will be kept alive while idle", "The identifier of an existing session in the TdsTunnelling gateway to re-attach to.", "the name of a class the driver should use to convert between tds/sybcharset and UCS-2 Unicode on this connection.", "The jConnect release version that this connection should emulate.", "Allow statements to cancel all pending results on the connection.", "If set, raw TDS will be written to this file.", "If true PreparedStatements will attempt to use dynamic prepared statement on the database.", "Try connecting to the next server address if the first attempt fails.", "Use language cursors to process JDBC 1.0 cursor API - otherwise use more efficient protocol cursors.", "Do not use this property.", "Do not send a new request on a connection until all responses from previous requests  have been completely received.", "Set LSB_BYTE_ORDER == true in order to swap the bytes being sent to and received from the server. By default this property is false.", "Name of factory class to use for custom sockets, or DEFAULT for  a default socket: new Socket();", "Set to true if you do not want updateCount() values returned for intermediate operations done within stored procedures or triggers on the database,  but only the counts of rows actually affected", "calls to getCursorName() will return a unique name, even if a cursor has not been opened.  Default is false, getCursorName() returns null.", "Set REQUEST_HA_SESSION true, if you are connecting to a Sybase server that is configured for HA failover, and you want this connection to be fault tolerant.", "Avoid the double-connect performance penalty and 010SM warning for older ASE databases.", "Allow the user to specify the query that they would like to execute against the backend database when Connection.isClosed() is called.", "Reference to the class loader to be used on this connection.", "Comma-seperated list of jar names to be preloaded.", "Force jConnect to return empty strings for calls to the ResultSetMetaData methods getSchemaName, getTableName and getCatalogName.", "When retrieving ResultSet values by using column name values instead of column index numbers, compare the name parameter with the label (alias) and not the actual name of the column.", "jConnect methods will be as compliant as possible with the JDBC standard."};
    private int _version;
    private Properties _info = null;
    protected Object[] _propValue = new Object[42];
    protected boolean[] _hasBeenSet = new boolean[42];
    private SQLWarning _warnings;

    static {
        Debug.assert(null, PROPNAME.length == 42 && DEF_PROP_VALUE.length == 42 && DESCRIPTION.length == 42);
    }

    public SybProperty(int version) {
        this._version = version;
        this.setPropertyDefaults();
        this.setVersionDefaults();
    }

    public SybProperty(Properties info, int version) throws SQLException {
        this._version = version;
        this._info = info;
        if (info != null) {
            Enumeration<?> e = info.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                try {
                    String userValue = null;
                    try {
                        Object o;
                        userValue = info.getProperty(propName);
                        if (userValue == null && (o = ((Hashtable)info).get(propName)) != null) {
                            userValue = o;
                        }
                    }
                    catch (ClassCastException cce) {
                        Debug.println(this, "JDK getProperty() bug: Tried to retrieve a non-String value.  Using get() instead.\n" + cce);
                        userValue = ((Hashtable)info).get(propName);
                    }
                    this.setConnProperty(propName, userValue, true);
                }
                catch (SQLException x) {
                    this.stashWarning(x);
                }
            }
        }
        this.setPropertyDefaults();
        this.setVersionDefaults();
    }

    protected Object clone() {
        Debug.println(this, "clone()");
        SybProperty clone = null;
        try {
            clone = new SybProperty(this._info, this._version);
        }
        catch (SQLException sqe) {
            Debug.printStackTrace(this, sqe);
            return clone;
        }
        int i = 0;
        while (i < 42) {
            if (this._hasBeenSet[i] && !clone._hasBeenSet[i]) {
                clone._propValue[i] = this._propValue[i] instanceof String ? new String((String)this._propValue[i]) : (this._propValue[i] instanceof Boolean ? new Boolean((Boolean)this._propValue[i]) : (this._propValue[i] instanceof Integer ? new Integer((Integer)this._propValue[i]) : this._propValue[i]));
                clone._hasBeenSet[i] = true;
            }
            ++i;
        }
        return clone;
    }

    public boolean getBoolean(int key) throws SQLException {
        switch (key) {
            case 6: 
            case 14: 
            case 15: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 41: {
                return Boolean.valueOf(this._propValue[key].toString());
            }
        }
        ErrorMessage.raiseError("JZ012", PROPNAME[key]);
        return false;
    }

    Object getConnProperty(String propName) {
        Debug.println(this, "getConnProperty( " + propName + " )");
        Object propValue = null;
        int i = 0;
        while (i <= 42) {
            if (PROPNAME[i].equalsIgnoreCase(propName)) {
                propValue = this._propValue[i];
                break;
            }
            ++i;
        }
        Debug.println(this, "returning " + propValue);
        return propValue;
    }

    public int getInteger(int key) throws SQLException {
        switch (key) {
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 22: {
                return Integer.valueOf(this._propValue[key].toString());
            }
        }
        ErrorMessage.raiseError("JZ012", PROPNAME[key]);
        return 0;
    }

    public Object getObject(int key) throws SQLException {
        switch (key) {
            case 37: 
            case 38: {
                return this._propValue[key];
            }
        }
        ErrorMessage.raiseError("JZ012", PROPNAME[key]);
        return null;
    }

    public Properties getProperties() {
        return this._info;
    }

    public String getString(int key) throws SQLException {
        switch (key) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 31: 
            case 36: {
                return this._propValue[key] == null ? null : this._propValue[key].toString();
            }
        }
        ErrorMessage.raiseError("JZ012", PROPNAME[key]);
        return null;
    }

    protected SQLWarning getWarnings() {
        return this._warnings;
    }

    /*
     * Unable to fully structure code
     */
    public void parsePropertyString(String properties) throws SQLException {
        block7: {
            sbis = new StringBufferInputStream(properties);
            property = new char[255];
            value = new char[255];
            c = '\u0000';
            propertyLength = 0;
            valueLength = 0;
            i = 0;
            b = 0;
            break block7;
            while ((c = (char)b) != '=') {
                property[i++] = c;
                if (sbis.available() == 0) break;
lbl13:
                // 2 sources

                ** while ((b = sbis.read()) <= -1)
lbl14:
                // 1 sources

            }
lbl15:
            // 3 sources

            propertyLength = i--;
            i = 0;
            while ((b = sbis.read()) > -1) {
                c = (char)b;
                if (c == '&') break;
                if (c == '\\') {
                    sbis.skip(1L);
                    value[i++] = 38;
                } else {
                    value[i++] = c;
                }
                if (sbis.available() == 0) break;
            }
            valueLength = i--;
            prop = new String(property, 0, propertyLength);
            val = new String(value, 0, valueLength);
            try {
                this.setConnProperty(prop, val, false);
            }
            catch (SQLException e) {
                this.stashWarning(e);
            }
            i = 0;
        }
        if (b > -1 && sbis.available() > 0) ** GOTO lbl13
    }

    void setConnProperty(String property, Object value, boolean ignoreUnknownProperties) throws SQLException {
        Debug.println(this, "setConnProperty " + property + ", " + value);
        if (property.equalsIgnoreCase("NO_REPEAT_READ")) {
            if (this._hasBeenSet[14]) {
                ErrorMessage.raiseWarning("010DP", property);
                return;
            }
            if (value != null) {
                this._propValue[14] = new Boolean(false);
                this._hasBeenSet[14] = true;
            }
            return;
        }
        int key = -1;
        int i = 0;
        while (i < 42 && key == -1) {
            if (PROPNAME[i].equalsIgnoreCase(property)) {
                key = i;
            }
            ++i;
        }
        Debug.println(this, "found key " + key);
        if (key == -1) {
            if (!ignoreUnknownProperties) {
                ErrorMessage.raiseWarning("010UP", property);
            }
            return;
        }
        if (this._hasBeenSet[key]) {
            ErrorMessage.raiseWarning("010DP", property);
            return;
        }
        this._hasBeenSet[key] = true;
        switch (key) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 31: 
            case 36: {
                if (value == null || value instanceof String && ((String)value).length() == 0) {
                    value = DEF_PROP_VALUE[key];
                }
                this.setProperty(key, value);
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 40: {
                if (value == null) {
                    value = ON;
                } else if (value instanceof String && !((String)value).equalsIgnoreCase(OFF) && !((String)value).equalsIgnoreCase(ON) || !(value instanceof String)) {
                    ErrorMessage.raiseError("JZ011", PROPNAME[key]);
                }
                this.setProperty(key, Boolean.valueOf((String)value));
                break;
            }
            case 41: {
                if (value == null) {
                    value = ON;
                } else if (value instanceof String && !((String)value).equalsIgnoreCase(OFF) && !((String)value).equalsIgnoreCase(ON) || !(value instanceof String)) {
                    ErrorMessage.raiseError("JZ011", PROPNAME[key]);
                }
                boolean setComplianceProps = Boolean.valueOf((String)value);
                this.setProperty(key, Boolean.valueOf((String)value));
                if (!setComplianceProps) break;
                this.setJDBCComplianceProps();
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 19: {
                try {
                    Integer.valueOf(value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ011", PROPNAME[key]);
                }
                this.setProperty(key, value);
                break;
            }
            case 22: {
                int version = 5;
                try {
                    version = Integer.valueOf(value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorMessage.raiseError("JZ011", PROPNAME[key]);
                }
                switch (version) {
                    case 0: {
                        version = 6;
                        value = new Integer(version);
                        break;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0D6", String.valueOf(version));
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                }
                this.setProperty(key, value);
                this._version = version;
                this.setVersionDefaults();
                break;
            }
            case 37: {
                if (value != null && !(value instanceof DynamicClassLoader)) {
                    ErrorMessage.raiseError("JZ011", PROPNAME[key]);
                }
                this.setProperty(key, value);
                break;
            }
            case 38: {
                if (value != null && !(value instanceof String)) {
                    ErrorMessage.raiseError("JZ011", PROPNAME[key]);
                }
                this.setProperty(key, SybProperty.tokenizeString((String)value, ","));
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ012", PROPNAME[key]);
            }
        }
    }

    private void setJDBCComplianceProps() {
        this.setProperty(23, new Boolean(OFF));
        this.setProperty(27, new Boolean(OFF));
        this.setProperty(33, new Boolean(ON));
        this.setProperty(39, new Boolean(ON));
        this.setProperty(40, new Boolean(OFF));
    }

    public void setProperty(int key, Object value) {
        Debug.println(this, "setting " + PROPNAME[key] + " to " + value);
        this._propValue[key] = value;
    }

    protected void setProperty(int key, Object value, boolean markItSet) {
        this.setProperty(key, value);
        this._hasBeenSet[key] = markItSet;
    }

    private void setPropertyDefaults() {
        int i = 0;
        while (i < 42) {
            if (!this._hasBeenSet[i]) {
                Debug.println(this, "setting value = " + DEF_PROP_VALUE[i] + " for key " + i);
                this._propValue[i] = DEF_PROP_VALUE[i];
            }
            ++i;
        }
        if (!this._hasBeenSet[22]) {
            this.setProperty(22, new Integer(this._version));
        }
    }

    private void setVersionDefaults() {
        if (!this._hasBeenSet[8]) {
            if (this._version == 2) {
                this.setProperty(8, "iso_1");
            } else {
                this.setProperty(8, DEF_PROP_VALUE[8]);
            }
        }
        if (!this._hasBeenSet[21]) {
            if (this._version == 2) {
                String cset;
                String string = cset = this._propValue[8] == null ? "iso_1" : this._propValue[8].toString();
                if (Iana.truncationConversionOK(cset)) {
                    this.setProperty(21, "com.sybase.jdbc2.utils.TruncationConverter");
                }
            } else {
                this.setProperty(21, DEF_PROP_VALUE[21]);
            }
        }
        if (!this._hasBeenSet[7]) {
            if (this._version == 2 || this._version == 3) {
                this.setProperty(7, "us_english");
            } else {
                this.setProperty(7, DEF_PROP_VALUE[7]);
            }
        }
        if (!this._hasBeenSet[23]) {
            if (this._version > 3) {
                this.setProperty(23, new Boolean(false));
            } else {
                this.setProperty(23, DEF_PROP_VALUE[23]);
            }
        }
        if (!this._hasBeenSet[35]) {
            if (this._version < 4) {
                this.setProperty(35, new Boolean(true));
            } else {
                this.setProperty(35, DEF_PROP_VALUE[35]);
            }
        }
    }

    private void stashWarning(SQLException e) throws SQLException {
        if (!(e instanceof SQLWarning)) {
            throw e;
        }
        if (this._warnings == null) {
            this._warnings = (SQLWarning)e;
        } else {
            this._warnings.setNextWarning((SQLWarning)e);
        }
    }

    private static String[] tokenizeString(String value, String delim) {
        StringTokenizer tokens = new StringTokenizer(value, delim, false);
        String[] answer = null;
        if (tokens != null) {
            int count = tokens.countTokens();
            answer = new String[count];
            int i = 0;
            while (i < count) {
                answer[i] = tokens.nextToken();
                ++i;
            }
        }
        return answer;
    }
}

