/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.LimiterInputStream;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.SybStatement;
import com.sybase.jdbc2.tds.SybBigDecimal;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public class SybPreparedStatement
extends SybStatement
implements com.sybase.jdbcx.SybPreparedStatement {
    private static final int MAX_PARAMETERS = 1000;
    String _dynStmtName = null;
    int _paramCount = 0;
    Vector _batchParams = null;
    protected String _query = null;
    protected ParamManager _paramMgr;

    SybPreparedStatement(ProtocolContext pc, String sql) throws SQLException {
        super(pc);
        Debug.println(this, "Constructor('" + sql + "')");
        sql = this.doEscapeProcessing(sql);
        this._paramMgr = this.countParams(sql);
    }

    SybPreparedStatement(ProtocolContext pc, String sql, int stmtNum) throws SQLException {
        super(pc);
        Debug.println(this, "Constructor('" + sql + "')");
        sql = this.doEscapeProcessing(sql);
        this._paramMgr = this.countParams(sql);
        String statementName = "dyn" + stmtNum;
        this._protocol.dynamicPrepare(pc, statementName, sql);
        this._dynStmtName = statementName;
    }

    public void addBatch() throws SQLException {
        this.checkDead();
        if (this._rpcName != null) {
            this._rpcName = null;
            this._doneinproc = true;
            this._query = "execute " + this._query;
            super.addBatch(this._query);
            Debug.println(this, "_rpcName was not null and sql = " + this._query);
        } else {
            String execKeyWord = "execute";
            if (this._query.toLowerCase().startsWith(execKeyWord)) {
                this._doneinproc = true;
            }
            super.addBatch(this._query);
        }
        if (this._paramCount == 0) {
            this._paramCount = this._paramMgr._params.length;
        }
        if (this._batchParams == null) {
            this._batchParams = new Vector();
        }
        int i = 0;
        while (i < this._paramCount) {
            Param param = this._paramMgr._params[i].cloneMe();
            this._batchParams.addElement(param);
            ++i;
        }
        Debug.println(this, "Batch Command = " + this.batchToString());
        int i2 = 0;
        while (i2 < this._batchParams.size()) {
            Param param = (Param)this._batchParams.elementAt(i2);
            Debug.println(this, "[" + i2 + "] Current Batch: sqlType(" + param._sqlType + ") inValue(" + param._inValue + ") scale(" + param._scale + ")");
            ++i2;
        }
    }

    public void addBatch(String query) throws SQLException {
        ErrorMessage.raiseError("JZ0S3", "addBatch(String)");
    }

    public void clearBatch() throws SQLException {
        super.clearBatch();
        this._batchParams = null;
        this._paramCount = 0;
    }

    public void clearParameters() throws SQLException {
        this.checkDead();
        try {
            this._paramMgr.clearParams(true);
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private ParamManager countParams(String query) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Vector createDynamicExecuteBatchParams() throws SQLException {
        Vector<ParamManager> batchParamMgrs = new Vector<ParamManager>();
        int offset = 0;
        int j = 0;
        while (j < this._batchCmds.size()) {
            ParamManager tempm = this.countParams((String)this._batchCmds.elementAt(0));
            int paramCount = tempm._params.length;
            int i = 0;
            while (i < paramCount) {
                Param param = (Param)this._batchParams.elementAt(offset);
                tempm.setParam(i + 1, param._sqlType, param._inValue, param._scale);
                ++offset;
                ++i;
            }
            batchParamMgrs.add(tempm);
            ++j;
        }
        return batchParamMgrs;
    }

    protected void deallocateDynamic() throws SQLException {
        if (this._dynStmtName != null) {
            this._protocol.dynamicDeallocate(this._context, this._dynStmtName);
        }
    }

    public boolean execute() throws SQLException {
        Debug.println(this, "execute " + this._query);
        return super.execute(this._query, this._paramMgr);
    }

    public boolean execute(String query) throws SQLException {
        ErrorMessage.raiseError("JZ0S3", "execute(String)");
        return false;
    }

    public int[] executeBatch() throws SQLException {
        this.checkDead();
        Debug.println(this, "executeBatch() - prep");
        if (this._batchCmds == null) {
            Debug.println(this, "executeBatch() -- returning empty array because clearBatch() was called and nothing more was added to the batch");
            return new int[0];
        }
        if (this.checkBatch()) {
            int offset = 0;
            int[] rowsAffected = new int[this._batchCmds.size()];
            int j = 0;
            while (j < this._batchCmds.size()) {
                ParamManager tempm = this.countParams((String)this._batchCmds.elementAt(j));
                int paramCount = tempm._params.length;
                int i = 0;
                while (i < paramCount) {
                    Param param = (Param)this._batchParams.elementAt(offset);
                    tempm.setParam(i + 1, param._sqlType, param._inValue, param._scale);
                    Debug.println(this, String.valueOf(String.valueOf(param._inValue)));
                    ++offset;
                    ++i;
                }
                int[] rows = super.executeBatch(tempm);
                rowsAffected[j] = rows[0];
                ++j;
            }
            this.clearBatch();
            return rowsAffected;
        }
        if (this._dynStmtName != null) {
            return super.executeBatch(null);
        }
        ParamManager pm = this.countParams(this.batchToString());
        Debug.assert(this, pm._params.length == this._batchParams.size());
        int paramCount = this._batchParams.size();
        int i = 0;
        while (i < paramCount) {
            Param param = (Param)this._batchParams.elementAt(i);
            pm.setParam(i + 1, param._sqlType, param._inValue, param._scale);
            Debug.println(this, String.valueOf(String.valueOf(param._inValue)));
            ++i;
        }
        return super.executeBatch(pm);
    }

    public ResultSet executeQuery() throws SQLException {
        Debug.println(this, "executeQuery " + this._query);
        return super.executeQuery(this._query, this._paramMgr);
    }

    public ResultSet executeQuery(String query) throws SQLException {
        ErrorMessage.raiseError("JZ0S3", "executeQuery(String)");
        return null;
    }

    public int executeUpdate() throws SQLException {
        Debug.println(this, "executeUpdate " + this._query);
        return super.executeUpdate(this._query, this._paramMgr);
    }

    public int executeUpdate(String query) throws SQLException {
        ErrorMessage.raiseError("JZ0S3", "executeUpdate(String)");
        return 0;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkDead();
        Debug.println(this, "getMetaData()");
        ResultSetMetaData rsmd = this._protocol.dynamicMetaData(this._context);
        if (rsmd == null) {
            ErrorMessage.raiseError("JZ0DP");
        }
        return rsmd;
    }

    public boolean sendQuery(String sql, ParamManager params) throws SQLException {
        this.checkDead();
        if (this._dynStmtName != null && this._cursor == null && !this.checkBatch()) {
            try {
                if (this._batchCmds == null) {
                    this._protocol.dynamicExecute(this._context, this._dynStmtName, params);
                } else {
                    this._protocol.dynamicExecuteBatch(this._context, this._dynStmtName, this.createDynamicExecuteBatchParams());
                }
            }
            catch (SQLException sqe) {
                this.handleSQLE(sqe);
            }
            this._state = 2;
            return false;
        }
        if (this._batchCmds != null) {
            return super.sendQuery(sql, params);
        }
        return super.sendQuery(this._query, this._paramMgr);
    }

    public void setArray(int i, Array x) throws SQLException {
        Debug.notSupported(this, "setArray(int, Array)");
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkDead();
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new LimiterInputStream(x, length), "8859_1");
            this.setParam(-1, parameterIndex, isr, length);
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkDead();
        this.setParam(2, parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x, int precision, int scale) throws SQLException {
        this.checkDead();
        if (x == null) {
            x = new BigDecimal("0");
        }
        SybBigDecimal sbd = new SybBigDecimal(x, precision, scale);
        this.setParam(2, parameterIndex, sbd);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkDead();
        this.setParam(-4, parameterIndex, x, length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        Debug.notSupported(this, "setBlob(int, Blob)");
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkDead();
        Boolean value = new Boolean(x);
        this.setParam(-7, parameterIndex, value);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkDead();
        Integer value = new Integer(x);
        if (value < 0) {
            this.setParam(5, parameterIndex, value);
        } else {
            this.setParam(-6, parameterIndex, value);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkDead();
        int length = 0;
        if (x != null) {
            length = x.length;
        }
        if (length > 255) {
            this.setParam(-4, parameterIndex, x);
        } else {
            this.setParam(-3, parameterIndex, x);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkDead();
        this.setParam(-1, parameterIndex, reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        Debug.notSupported(this, "setClob(int, Clob)");
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkDead();
        if (x == null) {
            this.setParam(91, parameterIndex, x);
        } else {
            this.setParam(91, parameterIndex, new DateObject(x));
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkDead();
        if (x == null) {
            this.setParam(91, parameterIndex, x);
        } else {
            this.setParam(91, parameterIndex, new DateObject(x, cal));
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkDead();
        Double value = new Double(x);
        this.setParam(8, parameterIndex, value);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkDead();
        Float value = new Float(x);
        this.setParam(7, parameterIndex, value);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkDead();
        Integer value = new Integer(x);
        this.setParam(4, parameterIndex, value);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkDead();
        Long value = new Long(x);
        this.setParam(-5, parameterIndex, value);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkDead();
        this.setParam(sqlType, parameterIndex, null);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        Debug.notImplemented(this, "setNull(int, int, String)");
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkDead();
        if (x == null) {
            ErrorMessage.raiseError("JZ0SE");
        }
        if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Boolean) {
            this.setParam(-7, parameterIndex, x);
        } else if (x instanceof Integer) {
            this.setParam(4, parameterIndex, x);
        } else if (x instanceof Long) {
            this.setParam(-5, parameterIndex, x);
        } else if (x instanceof Float) {
            this.setParam(7, parameterIndex, x);
        } else if (x instanceof Double) {
            this.setParam(8, parameterIndex, x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Serializable) {
            this.setParam(2000, parameterIndex, x);
        } else {
            ErrorMessage.raiseError("JZ0SE");
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkDead();
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object obj, int targetSqlType, int scale) throws SQLException {
        this.checkDead();
        if (obj == null) {
            this.setParam(targetSqlType, parameterIndex, null, scale);
        }
        switch (targetSqlType) {
            case -7: {
                this.setParam(targetSqlType, parameterIndex, Convert.objectToBoolean(obj), scale);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                this.setParam(targetSqlType, parameterIndex, Convert.objectToInt(obj), scale);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, Convert.objectToString(obj));
                break;
            }
            case 2: 
            case 3: {
                this.setParam(targetSqlType, parameterIndex, Convert.objectToBigDecimal(obj), scale);
                break;
            }
            case 7: {
                this.setParam(targetSqlType, parameterIndex, Convert.objectToFloat(obj), scale);
                break;
            }
            case 6: 
            case 8: {
                this.setParam(targetSqlType, parameterIndex, Convert.objectToDouble(obj), scale);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(parameterIndex, Convert.objectToBytes(obj));
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                this.setParam(targetSqlType, parameterIndex, Convert.objectToDateObject(obj, targetSqlType, null), scale);
                break;
            }
            case 1111: 
            case 2000: {
                if (obj instanceof Serializable) {
                    this.setParam(2000, parameterIndex, obj);
                    break;
                }
            }
            default: {
                ErrorMessage.raiseError("JZ0SE");
            }
        }
    }

    private void setParam(int type, int index, Object value) throws SQLException {
        this.setParam(type, index, value, 0);
    }

    private void setParam(int type, int index, Object value, int scale) throws SQLException {
        this._paramMgr.setParam(index, type, value, scale);
    }

    public void setRef(int i, Ref x) throws SQLException {
        Debug.notSupported(this, "setRef(int, Ref)");
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkDead();
        Integer value = new Integer(x);
        this.setParam(5, parameterIndex, value);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkDead();
        int length = 0;
        if (x != null && (length = x.length()) == 0) {
            x = new String(" ");
        }
        this.setParam(12, parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkDead();
        if (x == null) {
            this.setParam(92, parameterIndex, x);
        } else {
            this.setParam(92, parameterIndex, new DateObject(x));
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkDead();
        if (x == null) {
            this.setParam(92, parameterIndex, x);
        } else {
            this.setParam(92, parameterIndex, new DateObject(x, cal));
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkDead();
        if (x == null) {
            this.setParam(93, parameterIndex, x);
        } else {
            this.setParam(93, parameterIndex, new DateObject(x));
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkDead();
        if (x == null) {
            this.setParam(93, parameterIndex, x);
        } else {
            this.setParam(93, parameterIndex, new DateObject(x, cal));
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkDead();
        this.setParam(-1, parameterIndex, x, length);
    }

    public void switchContext(ProtocolContext pc) {
        this._context = pc;
    }
}

