/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource;
import com.sybase.jdbc2.jdbc.SybDataSource;
import com.sybase.jdbc2.jdbc.SybJndiProvider;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybXADataSource;
import com.sybase.jdbc2.utils.Debug;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.directory.DirContext;
import javax.naming.spi.ObjectFactory;

public class SybObjectFactory
implements ObjectFactory {
    static final String SYB_DATA_SOURCE_CLASSNAME = (class$com$sybase$jdbc2$jdbc$SybDataSource != null ? class$com$sybase$jdbc2$jdbc$SybDataSource : (class$com$sybase$jdbc2$jdbc$SybDataSource = SybObjectFactory.class$("com.sybase.jdbc2.jdbc.SybDataSource"))).getName();
    static final String SYB_POOLED_DATA_SOURCE_CLASSNAME = (class$com$sybase$jdbc2$jdbc$SybConnectionPoolDataSource != null ? class$com$sybase$jdbc2$jdbc$SybConnectionPoolDataSource : (class$com$sybase$jdbc2$jdbc$SybConnectionPoolDataSource = SybObjectFactory.class$("com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource"))).getName();
    static final String SYB_XA_DATA_SOURCE_CLASSNAME = (class$com$sybase$jdbc2$jdbc$SybXADataSource != null ? class$com$sybase$jdbc2$jdbc$SybXADataSource : (class$com$sybase$jdbc2$jdbc$SybXADataSource = SybObjectFactory.class$("com.sybase.jdbc2.jdbc.SybXADataSource"))).getName();
    static final String DATASOURCE_NAME = "DataSource";
    static final String CONNECTIONPOOLDATASOURCE_NAME = "ConnectionPoolDataSource";
    static final String XADATASOURCE_NAME = "XADataSource";
    static /* synthetic */ Class class$com$sybase$jdbc2$jdbc$SybDataSource;
    static /* synthetic */ Class class$com$sybase$jdbc2$jdbc$SybConnectionPoolDataSource;
    static /* synthetic */ Class class$com$sybase$jdbc2$jdbc$SybXADataSource;

    public SybObjectFactory() {
        Debug.println(this, "SybObjectFactory()");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) {
        Debug.println(this, "getObjectInstance()");
        Object newObj = null;
        if (env != null) {
            Debug.println(this, "JNDI Properties: \n\tjava.naming.provider.url = " + env.get("java.naming.provider.url") + "\n\t" + "java.naming.factory.initial" + " = " + env.get("java.naming.factory.initial") + "\n\t" + "java.naming.factory.object" + " = " + env.get("java.naming.factory.object"));
        }
        if (obj != null) {
            Debug.println(this, "obj's class = " + obj.getClass());
            Debug.println(this, "name = " + name);
            Debug.println(this, "ctx = " + ctx);
            Debug.println(this, "env = " + env);
            if (obj instanceof DirContext && ctx instanceof DirContext) {
                newObj = this.getObjectUsingDirContext(name, (DirContext)ctx);
            } else if (obj instanceof Reference) {
                newObj = this.getObjectUsingReference((Reference)obj, name, ctx, env);
            }
        }
        return newObj;
    }

    protected Object getObjectUsingDirContext(Name name, DirContext ctx) {
        Debug.println(this, "getObjectUsingDirContext(" + name + ")");
        SybDataSource newObject = null;
        try {
            SybProperty sybProps = new SybDataSource().getSybProperty();
            SybJndiProvider provider = new SybJndiProvider(ctx, name, sybProps);
            SybDataSource newDS = null;
            String dsType = provider.getDataSourceInterface();
            if (dsType.equals(DATASOURCE_NAME)) {
                newDS = new SybDataSource();
            } else if (dsType.equalsIgnoreCase(CONNECTIONPOOLDATASOURCE_NAME)) {
                newDS = new SybConnectionPoolDataSource();
            } else if (dsType.equalsIgnoreCase(XADATASOURCE_NAME)) {
                newDS = new SybXADataSource();
            } else {
                Debug.println(this, "unrecognized interface! " + dsType);
            }
            newDS.setAddressList(provider.getHostPortList());
            newDS.setDatabaseName(provider.getDatabaseName());
            newDS.setSybProperty(provider.getSybProperty());
            newDS.setResourceManagerName(provider.getResourceManagerName());
            newDS.setResourceManagerType(provider.getResourceManagerType());
            newObject = newDS;
        }
        catch (Exception e) {
            Debug.println(this, "Unable to configure SybDataSource. Exception follows:\n\t" + e);
            Debug.printStackTrace(this, e);
        }
        return newObject;
    }

    protected Object getObjectUsingReference(Reference ref, Name name, Context ctx, Hashtable env) {
        Debug.println(this, "getObjectUsingReference()");
        SybDataSource newObject = null;
        try {
            SybDataSource newDS = null;
            if (ref.getClassName().equals(SYB_DATA_SOURCE_CLASSNAME)) {
                newDS = new SybDataSource();
            } else if (ref.getClassName().equals(SYB_POOLED_DATA_SOURCE_CLASSNAME)) {
                newDS = new SybConnectionPoolDataSource();
            } else if (ref.getClassName().equals(SYB_XA_DATA_SOURCE_CLASSNAME)) {
                newDS = new SybXADataSource();
            }
            if (newDS != null) {
                newDS.setDatabaseName((String)ref.get("databaseName").getContent());
                newDS.setDataSourceName((String)ref.get("dataSourceName").getContent());
                newDS.setDescription((String)ref.get("description").getContent());
                newDS.setNetworkProtocol((String)ref.get("networkProtocol").getContent());
                newDS.setPortNumber((String)ref.get("portNumber").getContent());
                newDS.setServerName((String)ref.get("serverName").getContent());
                newDS.setUser((String)ref.get("user").getContent());
                newDS.setPassword((String)ref.get("password").getContent());
                newDS.setResourceManagerName((String)ref.get("resourceManagerName").getContent());
                newDS.setResourceManagerType(Integer.parseInt((String)ref.get("resourceManagerType").getContent()));
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])ref.get("sybProperty").getContent());
                ObjectInputStream ois = new ObjectInputStream(bais);
                newDS.setSybProperty((SybProperty)ois.readObject());
                newObject = newDS;
            }
        }
        catch (Exception e) {
            Debug.println(this, "Error occurred while building object:\n" + e);
            Debug.printStackTrace(this, e);
        }
        return newObject;
    }
}

