/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.JdbcDataObject;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.SybStatement;
import com.sybase.jdbc2.tds.TdsNumeric;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.Cacheable;
import com.sybase.jdbc2.utils.Debug;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;

public class ParamManager
implements Cacheable {
    protected Param[] _params;
    protected int _next = -1;
    protected int _last = -1;
    private int _maxOutParam = -1;
    protected SybStatement _stmt;
    protected ProtocolContext _context;
    protected Protocol _protocol;
    protected CacheManager _stmtMgr;
    private CacheManager _mgr;
    private boolean _haveOutParam = false;
    private boolean _ignoreClear = false;
    private boolean _clearingParams = false;

    public ParamManager(int numParams, ProtocolContext context) throws SQLException {
        this._context = context;
        this._protocol = this._context._protocol;
        this._params = this._protocol.paramArray(numParams, this._mgr);
    }

    public ParamManager(int numParams, int[] offsets, SybStatement stmt) throws SQLException {
        this._stmt = stmt;
        this._context = stmt._context;
        this._stmtMgr = stmt._statementManager;
        this._protocol = this._context._protocol;
        this._params = this._protocol.paramArray(this._context, numParams);
        int i = 0;
        while (i < numParams) {
            this._params[i]._paramMarkerOffset = offsets[i];
            ++i;
        }
        this._mgr = new CacheManager(this._context._is);
        boolean reReadable = this._context._conn._props.getBoolean(14);
        this._mgr.setReReadable(reReadable);
        int cacheSize = this._context._conn._props.getInteger(13);
        if (reReadable) {
            cacheSize = -1;
        }
        this._mgr.setCacheSize(cacheSize);
        this._mgr.setChunkSize(256);
        this._mgr.setAbortOnCacheOverflow(true);
    }

    public void adjustOffsets(int delta) {
        Debug.println(this, "add to each offset " + delta);
        int i = 0;
        while (i < this._params.length) {
            this._params[i]._paramMarkerOffset += delta;
            ++i;
        }
    }

    public void cache() throws IOException {
        if (this._ignoreClear) {
            return;
        }
        Debug.println(this, "cache() ");
        this._ignoreClear = true;
        this._mgr.register(this);
        this._mgr.open(this);
        this._mgr.doneReading();
        this._mgr.dead(this);
        this._ignoreClear = false;
        this._stmtMgr.doneReading();
    }

    private void checkIndex(int index) throws SQLException {
        if (index < 1 || index > this._params.length) {
            ErrorMessage.raiseError("JZ0SB", String.valueOf(index));
        }
    }

    public void checkParams(Protocol protocol, boolean isRPC) throws SQLException {
        Debug.println(this, "checkParams() ");
        int i = 0;
        while (i < this._params.length) {
            this._params[i].prepareForSend(protocol, i, isRPC);
            ++i;
        }
    }

    private void checkReceive() throws SQLException {
        if (this._next < 0) {
            ErrorMessage.raiseError("JZ0SF");
        }
    }

    private void checkType(int type) throws SQLException {
        switch (type) {
            default: {
                ErrorMessage.raiseError("JZ0SM", String.valueOf(type));
            }
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2000: 
        }
    }

    public void clear() throws IOException {
        if (this._ignoreClear) {
            return;
        }
        Debug.println(this, "clear() ");
        try {
            try {
                if (this._haveOutParam) {
                    if (this._maxOutParam >= 0 && this._params[this._maxOutParam]._outValue == null) {
                        this.getOutValueAt(this._maxOutParam + 1);
                    }
                    if (!this._clearingParams) {
                        this.clearParams(false);
                    }
                }
                this._mgr.clear();
            }
            catch (SQLException sqe) {
                ErrorMessage.raiseIOException("JZ006", sqe.getMessage());
            }
            Object var2_2 = null;
            this._stmtMgr.dead(this);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this._stmtMgr.dead(this);
            throw throwable;
        }
    }

    protected synchronized void clearParamArray(boolean all) throws IOException {
        Debug.println(this, "clearParamArray(" + all + ")");
        int startIndex = 0;
        if (this._params.length > 0 && this._params[0]._sqlType == -998) {
            startIndex = 1;
            this._params[0].clear(false);
        }
        int i = startIndex;
        while (i < this._params.length) {
            this._params[i].clear(all);
            ++i;
        }
        this._next = -1;
        this._last = -1;
    }

    protected synchronized void clearParams(boolean all) throws IOException {
        Debug.println(this, "clearParams(" + all + ")");
        if (this._clearingParams) {
            return;
        }
        if (this._haveOutParam) {
            this._clearingParams = true;
            this._stmtMgr.open(this);
            this.cache();
            this._clearingParams = false;
            this._haveOutParam = false;
        }
        this.clearParamArray(all);
        this._mgr.clear();
        this._mgr.allDead();
    }

    public ProtocolContext getContext() {
        return this._context;
    }

    public int getLength() {
        Debug.println(this, "getLength() ");
        int length = 0;
        int i = 0;
        while (i < this._params.length) {
            length += this._params[i].getLength();
            ++i;
        }
        return length;
    }

    public int getNext() {
        return this._next;
    }

    public Object getOutObjectAt(int index) throws SQLException {
        Debug.println(this, "getOutObjectAt() " + index);
        JdbcDataObject jdo = this.getOutValueAt(index);
        if ((this._params[--index]._regType == 2 || this._params[index]._regType == 3) && this._params[index]._scale != -999) {
            return jdo.getBigDecimal(this._params[index]._scale);
        }
        return jdo.getObject();
    }

    public JdbcDataObject getOutValueAt(int index) throws SQLException {
        Debug.println(this, "getOutValueAt() " + index);
        this.checkReceive();
        this.checkIndex(index);
        if (this._params[--index]._regType == -999 || this._stmt._hasReturn && index == 0 && !this._stmt._returnHasBeenRegistered) {
            ErrorMessage.raiseError("JZ0SB", String.valueOf(index));
        }
        while (this._params[index]._outValue == null) {
            this.nextOutParam();
            while (this._params[index]._outValue == null) {
                Debug.println(this, "reading for param " + this._next);
                this.nextResult();
            }
        }
        this._last = index;
        return this._params[index]._outValue;
    }

    protected void getParameter() throws SQLException {
        Debug.println(this, "getParameter: " + this._next);
        this.checkReceive();
        this._protocol.param(this);
    }

    public Param[] getParams() {
        return this._params;
    }

    public int getState() {
        return 1;
    }

    public boolean hasInParams() {
        if (this._params.length == 0) {
            Debug.println(this, "hasInParams - false");
            return false;
        }
        if (this._params.length > 1 || this._params[0]._sqlType != -998) {
            Debug.println(this, "hasInParams - true, _params.length = " + this._params.length + ", [0] == " + this._params[0]._sqlType);
            return true;
        }
        Debug.println(this, "hasInParams - false");
        return false;
    }

    protected void literalizeAll() {
        int i = 0;
        while (i < this._params.length) {
            this._params[i]._sendAsLiteral = true;
            ++i;
        }
    }

    public int makeFormats() throws IOException {
        Debug.println(this, "makeFormats() ");
        int numSendParms = 0;
        int i = 0;
        while (i < this._params.length) {
            if (this._params[i].makeFormat(this._protocol)) {
                ++numSendParms;
            }
            ++i;
        }
        return numSendParms;
    }

    public int nextOutParam() {
        Debug.println(this, "nextOutParam from " + this._next);
        if (this._next < this._params.length && this._params[this._next]._outValue != null) {
            ++this._next;
        }
        while (this._next < this._params.length && this._params[this._next]._regType == -999) {
            ++this._next;
        }
        return this._next;
    }

    private int nextResult() throws SQLException {
        int saveNext = this._next;
        while (true) {
            try {
                block7: while (true) {
                    int result = this._stmt.nextResult();
                    switch (result) {
                        default: {
                            continue block7;
                        }
                        case 3: {
                            Debug.println(this, "Got the next param");
                            return result;
                        }
                        case 0: 
                    }
                    ErrorMessage.raiseError("JZ0SG");
                }
            }
            catch (SQLException sqe) {
                this._stmt.handleSQLE(sqe);
                continue;
            }
            break;
        }
    }

    public void open(boolean cacheable) {
    }

    public String processParamMarkers(String query) throws SQLException {
        if (this._params.length == 0) {
            return null;
        }
        int nextParam = 0;
        if (this._params[nextParam]._sqlType == -998) {
            ++nextParam;
        }
        if (nextParam == this._params.length) {
            return null;
        }
        Debug.println(this, "performing param substitution on: " + query);
        StringBuffer sb = new StringBuffer("");
        int nextQueryChunk = 0;
        try {
            while (nextParam < this._params.length) {
                if (this._params[nextParam]._sqlType != -998) {
                    Debug.println(this, "param " + nextParam + ", offset = " + this._params[nextParam]._paramMarkerOffset);
                    sb.append(query.substring(nextQueryChunk, this._params[nextParam]._paramMarkerOffset));
                    sb.append(this._params[nextParam].literalValue(this._protocol, nextParam, this._context._maxFieldSize));
                    nextQueryChunk = this._params[nextParam]._paramMarkerOffset + 1;
                }
                ++nextParam;
            }
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
        if (nextQueryChunk < query.length()) {
            sb.append(query.substring(nextQueryChunk));
        }
        Debug.println(this, "converted to: " + sb.toString());
        return sb.toString();
    }

    public void registerParam(int index, int type) throws SQLException {
        Debug.println(this, "registerParam: (" + index + ") of type " + type);
        this.checkIndex(index);
        this.checkType(type);
        if (--index > this._maxOutParam) {
            this._maxOutParam = index;
        }
        this._params[index]._regType = type;
    }

    public void registerParam(int index, int type, int scale) throws SQLException {
        this.registerParam(index, type);
        this._params[index - 1]._scale = scale;
    }

    public void registerParam(int index, int type, String typeName) throws SQLException {
        this.registerParam(index, type);
        Debug.println(this, "registerParam: setting classname to " + typeName);
        this._params[--index]._outParamClassName = typeName;
    }

    public void registerParam(Cacheable param) throws SQLException {
        Debug.println(this, "registerParam # " + this._next);
        this.nextOutParam();
        try {
            this._haveOutParam = true;
            this._mgr.register(param);
            this._mgr.open(param);
            this._stmtMgr.register(this);
            this._stmtMgr.open(this);
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.getMessage());
        }
    }

    public void registerStatus(Cacheable param) throws SQLException {
        Debug.println(this, "registerStatus # " + this._next);
        if (this._params.length > 0 && this._params[0]._sqlType == -998) {
            this.registerParam(param);
        } else {
            try {
                param.clear();
            }
            catch (IOException ioe) {
                ErrorMessage.raiseError("JZ006", ioe.toString());
            }
        }
    }

    public void reset() throws IOException {
    }

    public void resetInputStream(InputStream is) {
    }

    public void send(OutputStream out) throws IOException, SQLException {
        Debug.println(this, "send() ");
        this._next = 0;
        int i = 0;
        while (i < this._params.length) {
            this._params[i].send(out, this._context._maxFieldSize);
            ++i;
        }
    }

    public void sendFormats(DataOutput out) throws IOException {
        Debug.println(this, "sendFormats() ");
        int i = 0;
        while (i < this._params.length) {
            this._params[i].sendFormat(out);
            ++i;
        }
    }

    public void setManager(CacheManager cm) {
    }

    public void setParam(int index, int type, Object value, int scale) throws SQLException {
        Debug.println(this, "setParam: (" + index + ") of type " + type);
        this.checkIndex(index);
        Param param = this._params[--index];
        if (param._sqlType == -998) {
            ErrorMessage.raiseError("JZ0SC");
        }
        try {
            param.clear(false);
        }
        catch (IOException ioe) {
            ErrorMessage.raiseError("JZ006", ioe.toString());
        }
        switch (type) {
            case 2: {
                if (!(value instanceof BigDecimal)) break;
                TdsNumeric.checkRange((BigDecimal)value);
                break;
            }
        }
        param._sqlType = type;
        param._inValue = value;
        param._scale = scale;
    }

    protected boolean wasNull() throws SQLException {
        this.checkReceive();
        if (this._last < 0 || this._params[this._last]._outValue == null) {
            ErrorMessage.raiseError("JZ0SD");
        }
        return this._params[this._last]._outValue.isNull();
    }
}

