/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.LoaderConnection;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public class DynamicClassLoader
extends ClassLoader
implements com.sybase.jdbcx.DynamicClassLoader {
    private LoaderConnection _connection;

    public DynamicClassLoader(LoaderConnection conn) throws SecurityException {
        this._connection = conn;
    }

    public DynamicClassLoader(String url, Properties props) throws SecurityException {
        this(new LoaderConnection(url, props));
    }

    public void closeConnection() throws SQLException {
        this._connection.kill();
    }

    public Class findClass(String className) {
        Debug.println(this, "parent loader didn't work for " + className + ". Trying findClass");
        byte[] classData = null;
        try {
            classData = this.loadClassData(className);
        }
        catch (SQLException sqlE) {
            sqlE.printStackTrace();
            Debug.println(this, sqlE.toString());
            return null;
        }
        catch (IOException ioE) {
            ioE.printStackTrace();
            Debug.println(this, ioE.toString());
            return null;
        }
        return this.defineClass(className, classData, 0, classData.length);
    }

    public Connection getConnection() {
        return this._connection.getConnection();
    }

    public boolean getKeepConnectionAlive() {
        return this._connection.getKeepAlive();
    }

    public boolean hasClassBeenLoaded(String className) {
        boolean answer = false;
        Class<?> c = this.findLoadedClass(className);
        if (c != null) {
            answer = true;
        }
        return answer;
    }

    private byte[] loadClassData(String className) throws SQLException, IOException {
        Debug.println(this, "loadClassData request is for " + className);
        byte[] answer = this._connection.fetchClass(className);
        return answer;
    }

    public void openConnection() throws SQLException {
        this._connection.open();
    }

    private void preloadAJar(String jarName) throws IOException, SQLException {
        boolean foundOne = false;
        Enumeration enumeration = this._connection.allClassesInJar(jarName);
        while (enumeration.hasMoreElements()) {
            foundOne = true;
            LoaderConnection.ClassData classDataObj = (LoaderConnection.ClassData)enumeration.nextElement();
            if (classDataObj == null) continue;
            byte[] classData = classDataObj._data;
            String className = classDataObj._name;
            Debug.println(this, "Now loading class " + className);
            Debug.println(this, "Class data = " + HexConverts.hexConvert(classData));
            Class<?> c = this.findLoadedClass(className);
            if (c == null) {
                c = this.defineClass(className, classData, 0, classData.length);
            }
            this.resolveClass(c);
        }
        if (!foundOne) {
            ErrorMessage.raiseWarning("010PF");
        }
    }

    public synchronized void preloadJars(String[] jarNames) throws SQLException {
        Debug.println(this, "DCL is preloading jars");
        int i = 0;
        while (i < jarNames.length) {
            String jarName = jarNames[i];
            try {
                Debug.println(this, "Preloading " + jarName);
                this.preloadAJar(jarName);
            }
            catch (IOException ioe) {
                throw new SQLException(ioe.toString());
            }
            ++i;
        }
    }

    public void setKeepConnectionAlive(boolean flag) {
        this._connection.setKeepAlive(flag);
    }
}

