/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.PVSSite;
import com.xensource.xenapi.Task;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.VIF;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class PVSProxy
extends XenAPIObject {
    protected final String ref;

    PVSProxy(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PVSProxy) {
            PVSProxy pVSProxy = (PVSProxy)object;
            return pVSProxy.ref.equals(this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_proxy.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPVSProxyRecord(v);
    }

    public static PVSProxy getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "PVS_proxy.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toPVSProxy(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_proxy.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public PVSSite getSite(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_proxy.get_site";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPVSSite(v);
    }

    public VIF getVIF(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_proxy.get_VIF";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toVIF(v);
    }

    public Boolean getCurrentlyAttached(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_proxy.get_currently_attached";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toBoolean(v);
    }

    public Types.PvsProxyStatus getStatus(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_proxy.get_status";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPvsProxyStatus(v);
    }

    public static Task createAsync(Connection connection, PVSSite pVSSite, VIF vIF) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PVS_proxy.create";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(pVSSite), Marshalling.toXMLRPC(vIF)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static PVSProxy create(Connection connection, PVSSite pVSSite, VIF vIF) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_proxy.create";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(pVSSite), Marshalling.toXMLRPC(vIF)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toPVSProxy(v);
    }

    public Task destroyAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "Async.PVS_proxy.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void destroy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_proxy.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<PVSProxy> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_proxy.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfPVSProxy(v);
    }

    public static Map<PVSProxy, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "PVS_proxy.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfPVSProxyPVSProxyRecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public PVSSite site;
        public VIF VIF;
        public Boolean currentlyAttached;
        public Types.PvsProxyStatus status;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "site", this.site);
            printWriter.printf("%1$20s: %2$s\n", "VIF", this.VIF);
            printWriter.printf("%1$20s: %2$s\n", "currentlyAttached", this.currentlyAttached);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"status", this.status});
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("site", this.site == null ? new PVSSite("OpaqueRef:NULL") : this.site);
            hashMap.put("VIF", this.VIF == null ? new VIF("OpaqueRef:NULL") : this.VIF);
            hashMap.put("currently_attached", this.currentlyAttached == null ? false : this.currentlyAttached);
            hashMap.put("status", (Object)(this.status == null ? Types.PvsProxyStatus.UNRECOGNIZED : this.status));
            return hashMap;
        }
    }
}

