/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.BarChartRenderer;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartRenderer;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.LineChart;
import com.objectplanet.chart.Renderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LineChartRenderer
extends ChartRenderer {
    private static final int A = 0;
    private static final int z = 1;
    private static final int w = 2;
    protected int[][][] samplePoints;
    private int[] x;
    private boolean y;
    protected int lastSelectedLine;
    LineChart chart;

    public LineChartRenderer(LineChart lineChart) {
        super(lineChart);
        this.chart = lineChart;
        this.legend = lineChart.legend;
        this.gridRenderer = lineChart.gridRenderer;
        this.legendRenderer = lineChart.legendRenderer;
        this.x = new int[lineChart.getSampleCount()];
        this.lastSelectedLine = -1;
    }

    public ChartSample checkSelection(Point point) {
        Serializable serializable;
        int n;
        int n2;
        int n3;
        if (point == null) {
            return null;
        }
        ChartSample chartSample = super.checkSelection(point);
        int n4 = this.getSeriesCount();
        int n5 = this.getSampleCount();
        if (chartSample == null && (n3 = this.legendRenderer.getSelectedElement(point, this.legend)) > -1) {
            if (n4 > 1 || this.chart.chartType.equals("line") || this.chart.u) {
                chartSample = new ChartSample(-1);
                chartSample.setSeries(n3);
            } else if (n3 < n5) {
                chartSample = this.chart.getSample(0, n3);
                if (chartSample != null) {
                    chartSample.setSeries(-1);
                }
            } else {
                if (n3 >= n5) {
                    n3 = -1;
                }
                chartSample = this.chart.getSample(0, n3);
            }
            if (chartSample != null && this.overlayRenderers != null) {
                n2 = this.overlayRenderers.size();
                for (n = n2 - 1; n >= 0; --n) {
                    serializable = (ChartRenderer)this.overlayRenderers.elementAt(n);
                    if (serializable == null) continue;
                    serializable.e = chartSample.getIndex();
                    serializable.case = chartSample.getSeries();
                    serializable.d.x = this.d.x;
                    serializable.d.y = -1;
                }
            }
        }
        if (chartSample == null && this.samplePoints != null) {
            n3 = 3;
            for (n2 = 0; chartSample == null && n2 < this.samplePoints.length; ++n2) {
                for (n = 0; chartSample == null && n < this.samplePoints[n2].length; ++n) {
                    serializable = new Point(this.samplePoints[n2][n][0], this.samplePoints[n2][n][1]);
                    if (this.chart.is3DModeOn()) {
                        ((Point)serializable).x -= this.depth3dPoint.x;
                    }
                    boolean bl = point.x >= ((Point)serializable).x - n3 && point.x <= ((Point)serializable).x + n3;
                    if (!(bl &= point.y >= ((Point)serializable).y - n3 && point.y <= ((Point)serializable).y + n3)) continue;
                    chartSample = this.chart.getSample(n2, n);
                }
            }
        }
        if (chartSample != null) {
            this.e = chartSample.getIndex();
            this.case = chartSample.getSeries();
            this.d = point;
        } else {
            this.e = -1;
            this.case = -1;
        }
        return chartSample;
    }

    public void render(Graphics graphics) {
        this.render(graphics, !this.chart.isServletModeOn());
    }

    protected void paintGrid(Graphics graphics, Grid grid, Rectangle rectangle) {
        this.gridRenderer.a(graphics, grid, rectangle);
        if (this.isAnyBelowLabelsOn()) {
            this.a(graphics, rectangle);
        } else {
            for (int i = 0; i < this.overlayRenderers.size(); ++i) {
                ChartRenderer chartRenderer = (ChartRenderer)this.overlayRenderers.elementAt(i);
                if (chartRenderer == null || !(chartRenderer.chart instanceof Chart) || !chartRenderer.isAnyBelowLabelsOn()) continue;
                chartRenderer.a(graphics, rectangle);
                break;
            }
        }
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
        int n;
        if (!this.chart.needChartCalculation && !this.chart.isServletModeOn()) {
            return;
        }
        int n2 = this.getSampleCount();
        int n3 = this.getSeriesCount();
        this.display3dOn = this.chart.is3DModeOn();
        this.y = this.chart.isStackedOn();
        this.gridRenderer.do(this.chart.a(), rectangle);
        if (this.samplePoints == null || this.samplePoints.length != n3 || this.samplePoints.length == 0 || this.samplePoints[0] == null || this.samplePoints[0].length != n2) {
            this.samplePoints = new int[n3][n2][2];
        }
        boolean bl = this.chart.isRightToLeftScrollingOn();
        int[] nArray = new int[n3];
        if (this.chart.isRightToLeftScrollingOn()) {
            block14: for (int i = 0; i < nArray.length; ++i) {
                ChartSample[] chartSampleArray = null;
                try {
                    chartSampleArray = this.chart.getSamples(i);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (chartSampleArray == null) continue;
                for (int j = chartSampleArray.length - 1; j >= 0; --j) {
                    if (chartSampleArray[j] == null || !chartSampleArray[j].hasValue()) continue;
                    nArray[i] = Math.max(nArray[i], j);
                    continue block14;
                }
            }
        }
        double d = rectangle2.width;
        if (n2 > 2) {
            d = (double)rectangle2.width / (double)(n2 - 1);
        }
        if (this.x == null || this.x.length < n2) {
            int[] nArray2 = new int[n2];
            if (this.x != null) {
                System.arraycopy(this.x, 0, nArray2, 0, Math.min(this.x.length, nArray2.length));
            }
            this.x = nArray2;
        }
        double d2 = rectangle2.x;
        if (bl) {
            n = 0;
            String[] stringArray = this.chart.getSampleLabels();
            if (stringArray != null) {
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    if (stringArray[i] == null) continue;
                    n = Math.max(n, i);
                    break;
                }
            }
            d2 = d2 + (double)rectangle2.width - d * (double)n;
        }
        if (n2 == 1) {
            this.x[0] = rectangle2.x + rectangle2.width / 2;
        } else {
            for (n = 0; n < n2 && n < this.x.length; ++n) {
                int n4 = d2 >= 0.0 ? (int)(d2 + 0.5) : (int)(d2 - 0.5);
                this.x[n] = n4;
                d2 += d;
            }
        }
        for (n = 0; n < n3 && this.samplePoints != null && n < this.samplePoints.length; ++n) {
            double d3 = (double)this.depth3dPoint.x / (double)n3 * (double)n;
            d2 = rectangle2.x;
            if (bl) {
                d2 = d2 + (double)rectangle2.width - d * (double)nArray[n];
            }
            double d4 = Double.NaN;
            for (int i = 0; i < n2 && this.samplePoints[n] != null && i < this.samplePoints[n].length; ++i) {
                double d5;
                int n5;
                int n6 = n2 == 1 ? rectangle2.x + rectangle2.width / 2 : (d2 >= 0.0 ? (int)(d2 + 0.5) : (int)(d2 - 0.5));
                try {
                    this.samplePoints[n][i][0] = n6;
                    if (this.display3dOn && this.chart.getLine3DLayout() == 0 && !this.y) {
                        int[] nArray3 = this.samplePoints[n][i];
                        nArray3[0] = (int)((double)nArray3[0] + d3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double d6 = Double.NaN;
                try {
                    d6 = this.chart.getSampleValue(n, i);
                    if (!this.chart.isConnectedLinesOn(n) && !this.chart.isMissingValuesInterpolated()) {
                        if (new Double(d6).isNaN()) {
                            d6 = 0.0;
                        }
                        d4 = d6;
                    } else if (!new Double(d6).isNaN()) {
                        d4 = d6;
                    } else if (this.y) {
                        for (n5 = i + 1; n5 < n2; ++n5) {
                            ChartSample chartSample = this.chart.getSample(n, n5);
                            if (chartSample == null || !chartSample.hasValue()) continue;
                            if (new Double(d4).isNaN()) {
                                d6 = chartSample.getValue();
                                break;
                            }
                            double d7 = ((double)chartSample.getValue() - d4) / (double)(n5 - i + 1);
                            d4 = d6 = d4 + d7;
                            if (!this.chart.isConnectedLinesOn(n)) break;
                            this.chart.setSampleValue(n, i, d6);
                            break;
                        }
                        if (new Double(d6).isNaN()) {
                            d6 = d4;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                n5 = this.chart.getSeriesRange(n);
                double d8 = this.chart.getCurrentRange(n5);
                double d9 = this.chart.getCurrentLowerRange(n5);
                try {
                    d5 = (d6 - d9) / (d8 - d9);
                }
                catch (Exception exception) {
                    d5 = Double.NaN;
                }
                double d10 = (double)(rectangle.y + rectangle.height) - d5 * (double)rectangle.height;
                if (n > 0 && this.y) {
                    try {
                        d5 = d6 / (d8 - d9);
                        d10 = (double)this.samplePoints[n - 1][i][1] - (double)rectangle.height * d5;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    this.samplePoints[n][i][1] = d10 >= 0.0 ? (int)(d10 + 0.5) : (int)(d10 - 0.5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.display3dOn && this.y) {
                        if (n == 0) {
                            int[] nArray4 = this.samplePoints[n][i];
                            nArray4[1] = nArray4[1] - this.depth3dPoint.y;
                        }
                    } else if (this.display3dOn) {
                        int[] nArray5 = this.samplePoints[n][i];
                        nArray5[1] = nArray5[1] - this.depth3dPoint.y;
                        double d11 = (double)this.depth3dPoint.y / (double)this.getSeriesCount() * (double)n;
                        int[] nArray6 = this.samplePoints[n][i];
                        nArray6[1] = nArray6[1] + (int)Math.round(d11);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                d2 += d;
            }
        }
        this.chart.needChartCalculation = false;
    }

    protected void checkDataIntegrity() {
        if (this.lastSelectedLine >= this.chart.getSeriesCount()) {
            this.lastSelectedLine = -1;
        }
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.a((Graphics2D)graphics, rectangle, rectangle2);
    }

    protected Point getSampleCenter(int n, int n2) {
        Point point;
        Rectangle rectangle = new Rectangle(this.chart.getGraphBounds());
        rectangle.grow(1, 1);
        if (this.chart.is3DModeOn()) {
            rectangle.x -= this.depth3dPoint.x;
            rectangle.width += this.depth3dPoint.x;
            rectangle.height -= this.depth3dPoint.y;
        }
        if ((point = this.chart.getSamplePoint(n2, n)) != null && rectangle.contains(point)) {
            return point;
        }
        return null;
    }

    protected void calculateGraphBounds(Rectangle rectangle) {
        Serializable serializable;
        int n;
        this.legendRenderer.calculateGraphBounds(this.legend, rectangle);
        Dimension dimension = this.chart.getSize();
        int n2 = rectangle.x;
        int n3 = dimension.width - rectangle.width - rectangle.x;
        int n4 = rectangle.y;
        int n5 = dimension.height - rectangle.height - rectangle.y;
        this.display3dOn = this.chart.is3DModeOn();
        this.y = this.chart.isStackedOn();
        boolean bl = this.chart.is3DModeOn();
        if (bl) {
            if (this.parentRenderer != null) {
                if (this.parentRenderer instanceof BarChartRenderer || this.parentRenderer instanceof LineChartRenderer) {
                    this.depth3dPoint.x = this.parentRenderer.depth3dPoint.x / this.parentRenderer.getSeriesCount();
                    this.depth3dPoint.y = this.parentRenderer.depth3dPoint.y / this.parentRenderer.getSeriesCount();
                }
            } else if (this.chart.H > -1) {
                this.depth3dPoint.x = Math.round((float)this.chart.H * 1.25f);
                this.depth3dPoint.y = Math.round((float)(-this.chart.H) / 1.25f);
            } else {
                int n6 = Math.max(this.chart.getSampleCount(), 20);
                if (this.chart.getSeriesCount() > 1 && !this.y) {
                    n6 /= this.chart.getSeriesCount();
                    n6 = Math.max(n6, 4);
                }
                double d = (double)rectangle.width / (double)n6;
                this.depth3dPoint.x = (int)Math.round(d * 1.25);
                this.depth3dPoint.y = (int)Math.round(-d / 1.25);
            }
        }
        String[] stringArray = null;
        Font font = this.getFont("sampleLabelFont");
        int n7 = this.getLabelAngle("sampleLabelAngle");
        if (this.isAnyBelowLabelsOn()) {
            stringArray = this.chart.getSampleLabels();
        } else {
            for (n = 0; n < this.overlayRenderers.size(); ++n) {
                serializable = (ChartRenderer)this.overlayRenderers.elementAt(n);
                if (serializable == null || !(((ChartRenderer)serializable).chart instanceof Chart) || !((ChartRenderer)serializable).isAnyBelowLabelsOn()) continue;
                font = ((Renderer)serializable).getFont("sampleLabelFont");
                n7 = ((Renderer)serializable).getLabelAngle("sampleLabelAngle");
                stringArray = ((Chart)((ChartRenderer)serializable).chart).getSampleLabels();
                if (!(serializable instanceof BarChartRenderer) || !((BarChart)((ChartRenderer)serializable).chart).isBarLabelsOn()) break;
                font = ((Renderer)serializable).getFont("barLabelFont");
                n7 = ((Renderer)serializable).getLabelAngle("barLabelAngle");
                stringArray = ((BarChart)((ChartRenderer)serializable).chart).getBarLabels();
                break;
            }
        }
        if (this.getSampleCount() > 0 && stringArray != null) {
            serializable = this.getFontMetrics(font);
            int n8 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                Dimension dimension2 = this.getLabelSize(stringArray[i], (FontMetrics)serializable);
                Dimension dimension3 = this.getAngledLabelSize(dimension2, n7);
                n8 = Math.max(dimension3.height, n8);
            }
            n = n8 + 6;
            if (n7 % 180 == 0) {
                n -= ((FontMetrics)serializable).getMaxDescent();
            }
            n5 += n;
        }
        if (bl) {
            n2 += this.depth3dPoint.x;
            n5 -= this.depth3dPoint.y;
            for (int i = 0; i < this.overlayRenderers.size(); ++i) {
                ChartRenderer chartRenderer = (ChartRenderer)this.overlayRenderers.elementAt(i);
                if (chartRenderer == null || !(chartRenderer.chart instanceof Chart)) continue;
                chartRenderer.depth3dPoint.x = this.depth3dPoint.x / this.chart.getSeriesCount();
                chartRenderer.depth3dPoint.y = this.depth3dPoint.y / this.chart.getSeriesCount();
            }
        }
        rectangle.x = n2;
        rectangle.width = dimension.width - n2 - n3;
        rectangle.y = n4;
        rectangle.height = dimension.height - n4 - n5;
        this.gridRenderer.if(this.chart.a(), rectangle);
    }

    private void a(Graphics2D graphics2D, Rectangle rectangle, Rectangle rectangle2) {
        int n = this.getSeriesCount();
        if (n > 0) {
            int n2;
            int n3;
            int n4;
            int[][] nArray = this.chart.aV;
            Color[] colorArray = this.chart.aT;
            if (this.display3dOn) {
                if (this.y) {
                    this.paintStacked3DLines(graphics2D, n, rectangle, rectangle2);
                } else {
                    for (n4 = n - 1; n4 >= 0; --n4) {
                        n3 = this.chart.getSeriesRange(n4);
                        if (this.chart.getCurrentRange(n3) == this.chart.getCurrentLowerRange(n3)) continue;
                        this.paintLine(graphics2D, n4, rectangle, rectangle2, this.chart.getSampleColor(n4), this.chart.isSelected(n4, -1));
                    }
                }
            }
            n4 = 1;
            for (n3 = 0; nArray != null && n3 < nArray.length; ++n3) {
                n2 = this.chart.getSeriesRange(n3);
                if (this.y || this.chart.getCurrentRange(n2) == this.chart.getCurrentLowerRange(n2) || nArray[n3] == null) continue;
                Color color = new Color(231, 231, 231);
                if (colorArray != null && n3 < colorArray.length && colorArray[n3] != null) {
                    color = colorArray[n3];
                }
                this.paintArea(graphics2D, n3, nArray[n3][0], nArray[n3][1], rectangle, rectangle2, color, false);
                if (nArray[n3][0] != this.lastSelectedLine && nArray[n3][1] != this.lastSelectedLine) continue;
                n4 = 0;
            }
            if (!this.display3dOn) {
                for (n3 = n - 1; n3 >= 0; --n3) {
                    n2 = this.chart.getSeriesRange(n3);
                    if (this.chart.getCurrentRange(n2) == this.chart.getCurrentLowerRange(n2)) continue;
                    this.paintLine(graphics2D, n3, rectangle, rectangle2, this.chart.getSampleColor(n3), this.chart.isSelected(n3, -1));
                }
            }
            if (!this.display3dOn && n4 != 0 && this.lastSelectedLine >= 0) {
                n3 = this.lastSelectedLine;
                this.paintLine(graphics2D, n3, rectangle, rectangle2, this.chart.getSampleColor(n3), this.chart.isSelected(n3, -1));
            }
            if (this.chart.isValueLabelsOn(-1) || this.chart.isSampleLabelsOn() || this.chart.isSeriesLabelsOn()) {
                this.a((Graphics)graphics2D, rectangle, rectangle2);
            }
        }
    }

    protected void paintStacked3DLines(Graphics2D graphics2D, int n, Rectangle rectangle, Rectangle rectangle2) {
        Object[] objectArray;
        int n2;
        int n3;
        Object[] objectArray2;
        int n4;
        int n5;
        Object[] objectArray3;
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x - this.depth3dPoint.x + 1, rectangle.y - this.depth3dPoint.y + 1);
        polygon.addPoint(rectangle.x + 1, rectangle.y + 1);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + 1);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        polygon.addPoint(rectangle.x + rectangle.width - this.depth3dPoint.x, rectangle.y + rectangle.height - this.depth3dPoint.y);
        polygon.addPoint(rectangle.x - this.depth3dPoint.x + 1, rectangle.y + rectangle.height - this.depth3dPoint.y);
        graphics2D.setClip(polygon);
        double d = this.depth3dPoint.x;
        double d2 = this.depth3dPoint.y;
        if (this.chart.getLine3DLayout() == 0 && !this.y) {
            d /= (double)n;
            d2 /= (double)n;
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < blArray.length; ++i) {
            int n6 = this.chart.getSeriesRange(i);
            blArray[i] = this.chart.getCurrentRange(n6) != this.chart.getCurrentLowerRange(n6);
            objectArray3 = this.chart.getSamples(i);
            if (objectArray3 != null && objectArray3.length != 0 && this.samplePoints != null && i < this.samplePoints.length) continue;
            blArray[i] = false;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        objectArray3 = new double[n];
        double[] dArray3 = new double[n];
        for (n5 = 0; n5 < n; ++n5) {
            dArray[n5] = -2.147483648E9;
            dArray2[n5] = -2.147483648E9;
            objectArray3[n5] = -2.147483648E9;
            dArray3[n5] = -2.147483648E9;
        }
        n5 = this.chart.getSampleCount();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (n4 = 0; n4 < n; ++n4) {
            nArray[n4] = Integer.MIN_VALUE;
            nArray2[n4] = Integer.MIN_VALUE;
        }
        block9: for (n4 = 0; n4 < n; ++n4) {
            objectArray2 = this.chart.getSamples(n4);
            for (n3 = 0; n3 < n5; ++n3) {
                if (objectArray2[n3] == null || objectArray2[n3].value == null || objectArray2[n3].value.isNaN()) continue;
                nArray[n4] = n3;
                break;
            }
            for (n3 = n5 - 1; n3 >= 0; --n3) {
                if (objectArray2[n3] == null || objectArray2[n3].value == null || objectArray2[n3].value.isNaN()) continue;
                nArray2[n4] = n3;
                continue block9;
            }
        }
        double[] dArray4 = new double[n];
        objectArray2 = new double[n];
        for (n3 = 0; n3 < n; ++n3) {
            double d3 = this.chart.getLine3DDepth(n3);
            dArray4[n3] = (1.0 - d3) * d * 0.5;
            objectArray2[n3] = (ChartSample)((1.0 - d3) * d2 * 0.5);
        }
        int[] nArray3 = this.chart.getVisibleSamples();
        int n7 = Math.max(nArray3[0] - 2, 0);
        int n8 = Math.min(n7 + nArray3[1] + 5, n5);
        if (this.chart.isRightToLeftScrollingOn()) {
            n7 = 0;
            n8 = n5;
        }
        for (n2 = n7; n2 <= n8 - 1; ++n2) {
            int n9;
            boolean[] blArray2 = new boolean[n];
            objectArray = new boolean[n];
            boolean[] blArray3 = new boolean[n];
            boolean[] blArray4 = new boolean[n];
            for (n9 = 0; n9 < n; ++n9) {
                ChartSample[] chartSampleArray = this.chart.getSamples(n9);
                blArray2[n9] = this.chart.isConnectedLinesOn(n9);
                objectArray[n9] = n2 > 0 && chartSampleArray[n2 - 1] != null && chartSampleArray[n2 - 1].value != null && !chartSampleArray[n2 - 1].value.isNaN();
                blArray3[n9] = chartSampleArray[n2] != null && chartSampleArray[n2].value != null && !chartSampleArray[n2].value.isNaN();
                blArray4[n9] = n2 < n5 - 1 && chartSampleArray[n2 + 1] != null && chartSampleArray[n2 + 1].value != null && !chartSampleArray[n2 + 1].value.isNaN();
            }
            for (n9 = 0; n9 < n; ++n9) {
                if (!blArray3[n9] || objectArray[n9]) continue;
                this.a(graphics2D, n9, n2, rectangle, d, d2, dArray4, (double[])objectArray2);
            }
            for (n9 = 0; n9 < n; ++n9) {
                if (!objectArray[n9] || !blArray3[n9] || blArray4[n9]) continue;
                this.a(graphics2D, n9, n2, rectangle, d, d2, dArray4, (double[])objectArray2);
            }
            for (n9 = n - 1; n9 >= 0; --n9) {
                if (!blArray[n9]) continue;
                try {
                    if (!blArray3[n9] || !blArray4[n9]) continue;
                    dArray[n9] = (double)(this.samplePoints[n9][n2][0] - this.depth3dPoint.x) + dArray4[n9];
                    dArray2[n9] = (double)this.samplePoints[n9][n2][1] + objectArray2[n9];
                    objectArray3[n9] = (double)(this.samplePoints[n9][n2 + 1][0] - this.depth3dPoint.x) + dArray4[n9];
                    dArray3[n9] = (double)this.samplePoints[n9][n2 + 1][1] + objectArray2[n9];
                    if (!this.chart.isSeriesLineOn(n9)) continue;
                    this.a(graphics2D, n9, dArray[n9], dArray2[n9], objectArray3[n9], dArray3[n9], 0.0, this.chart.getSampleColor(n9), true, false, 2, this.chart.isOutlineOn(n9));
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            for (n9 = 0; n9 < n; ++n9) {
                if (!blArray[n9]) continue;
                try {
                    if (!blArray3[n9] || !blArray4[n9]) continue;
                    dArray[n9] = (double)(this.samplePoints[n9][n2][0] - this.depth3dPoint.x) + dArray4[n9];
                    dArray2[n9] = (double)this.samplePoints[n9][n2][1] + objectArray2[n9];
                    objectArray3[n9] = (double)(this.samplePoints[n9][n2 + 1][0] - this.depth3dPoint.x) + dArray4[n9];
                    dArray3[n9] = (double)this.samplePoints[n9][n2 + 1][1] + objectArray2[n9];
                    if (!this.chart.isSeriesLineOn(n9)) continue;
                    this.a(graphics2D, n9, dArray[n9], dArray2[n9], objectArray3[n9], dArray3[n9], 0.0, this.chart.getSampleColor(n9), true, false, 1, this.chart.isOutlineOn(n9));
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            int n10 = this.chart.getSeriesRange(n2);
            if (this.chart.getCurrentRange(n10) == this.chart.getCurrentLowerRange(n10) || (objectArray = (Object[])this.chart.getSamples(n2)) == null || objectArray.length == 0 || this.samplePoints == null || n2 >= this.samplePoints.length) continue;
            this.paintLine(graphics2D, n2, rectangle, rectangle2, this.chart.getSampleColor(n2), this.chart.isSelected(n2, -1));
        }
    }

    private void a(Graphics2D graphics2D, int n, int n2, Rectangle rectangle, double d, double d2, double[] dArray, double[] dArray2) {
        GeneralPath generalPath = new GeneralPath();
        try {
            double d3 = (double)this.samplePoints[n][n2][0] - d + dArray[n];
            double d4 = (double)this.samplePoints[n][n2][1] + dArray2[n];
            double d5 = (n > 0 ? (double)this.samplePoints[n - 1][n2][1] : (double)(rectangle.y + rectangle.height) - d2) + dArray2[n];
            generalPath.moveTo((float)d3, (float)d4);
            generalPath.lineTo((float)(d3 + d - dArray[n] * 2.0), (float)(d4 + d2 - dArray2[n] * 2.0));
            generalPath.lineTo((float)(d3 + d - dArray[n] * 2.0), (float)(d5 + d2 - dArray2[n] * 2.0));
            generalPath.lineTo((float)d3, (float)d5);
            generalPath.closePath();
            graphics2D.setPaint(LineChartRenderer.getDarker(this.chart.getSampleColor(n)));
            graphics2D.fill(generalPath);
            if (this.chart.isOutlineOn(n)) {
                graphics2D.draw(generalPath);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected void paintLine(Graphics graphics, int n, Rectangle rectangle, Rectangle rectangle2, Color color, boolean bl) {
        ChartSample[] chartSampleArray;
        int n2 = this.getSeriesCount();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Invalid series: " + n);
        }
        if (bl) {
            this.lastSelectedLine = n;
        }
        if ((chartSampleArray = this.chart.getSamples(n)) == null || chartSampleArray.length == 0 || this.samplePoints == null || n >= this.samplePoints.length) {
            return;
        }
        Graphics graphics2 = graphics;
        if (this.display3dOn) {
            Polygon polygon = new Polygon();
            polygon.addPoint(rectangle.x - this.depth3dPoint.x + 1, rectangle.y - this.depth3dPoint.y + 1);
            polygon.addPoint(rectangle.x + 1, rectangle.y + 1);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + 1);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x + rectangle.width - this.depth3dPoint.x, rectangle.y + rectangle.height - this.depth3dPoint.y);
            polygon.addPoint(rectangle.x - this.depth3dPoint.x + 1, rectangle.y + rectangle.height - this.depth3dPoint.y);
            graphics2.setClip(polygon);
        } else {
            graphics2.setClip(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1);
        }
        if (this.chart.getLineStyle(n) == 1) {
            this.if((Graphics2D)graphics, chartSampleArray, n, rectangle, rectangle2, bl);
        } else if (this.y) {
            this.paintStackedLine((Graphics2D)graphics, chartSampleArray, n, rectangle, rectangle2, color, bl);
        } else if (this.display3dOn) {
            this.paintSimple3DLine((Graphics2D)graphics, chartSampleArray, n, rectangle, rectangle2, color, bl);
        } else {
            if (this.chart.isSeriesLineOn(n)) {
                this.paintSimpleLine((Graphics2D)graphics, chartSampleArray, n, rectangle, rectangle2, color, bl);
            }
            this.paintSampleHighlights(graphics, chartSampleArray, n, rectangle, color);
        }
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void paintSimpleLine(Graphics2D graphics2D, ChartSample[] chartSampleArray, int n, Rectangle rectangle, Rectangle rectangle2, Color color, boolean bl) {
        Color color2 = this.chart.getSampleColor2(n);
        if (bl) {
            color = LineChartRenderer.getDarker(color);
            color2 = LineChartRenderer.getDarker(color2);
        }
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        if (color2 == null || color == color2) {
            graphics2D.setColor(color);
        } else {
            GradientPaint gradientPaint = new GradientPaint(rectangle2.x, 0.0f, color, rectangle2.x + rectangle2.width, 0.0f, color2);
            graphics2D.setPaint(gradientPaint);
        }
        int n6 = this.chart.getLineWidth(n);
        float[] fArray = this.chart.getLineStroke(n);
        boolean bl2 = false;
        for (int i = 0; fArray != null && i < fArray.length; ++i) {
            if (fArray[0] == 0.0f) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            fArray = null;
        }
        BasicStroke basicStroke = new BasicStroke(n6, 1, 0, 1.0f, fArray, 0.0f);
        BasicStroke basicStroke2 = new BasicStroke(1.0f, 1, 0, 1.0f, null, 0.0f);
        for (int i = 0; i < chartSampleArray.length - 1; ++i) {
            boolean bl3;
            boolean bl4;
            boolean bl5 = this.chart.isSampleHighlightOn(n, i);
            boolean bl6 = chartSampleArray[i] != null && chartSampleArray[i].value != null && !chartSampleArray[i].value.isNaN();
            boolean bl7 = bl4 = chartSampleArray[i + 1] != null && chartSampleArray[i + 1].value != null && !chartSampleArray[i + 1].value.isNaN();
            if (bl6) {
                try {
                    n2 = this.samplePoints[n][i][0];
                    n3 = this.samplePoints[n][i][1];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            boolean bl8 = bl3 = chartSampleArray[i] == null || chartSampleArray[i].value == null || chartSampleArray[i].value.isNaN();
            if (bl3 && !this.chart.isConnectedLinesOn(n)) {
                n2 = Integer.MIN_VALUE;
            }
            if (!bl6 && n2 == Integer.MIN_VALUE || !bl4) continue;
            try {
                n4 = this.samplePoints[n][i + 1][0];
                n5 = this.samplePoints[n][i + 1][1];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (bl5) {
                if (n3 >= rectangle.y && n3 <= rectangle.y + rectangle.height - this.depth3dPoint.y && n2 >= rectangle.x - this.depth3dPoint.x && n2 <= rectangle.x + rectangle.width + 1 + this.depth3dPoint.x) {
                    this.paintSampleHighlight(graphics2D, n, i, n2, n3, color);
                }
                if (this.display3dOn) {
                    int n7 = this.chart.getSampleHighlightSize(n);
                    n2 += n7 / 2;
                    n4 -= n7 / 2;
                }
            }
            if (!this.chart.isSeriesLineOn(n)) continue;
            boolean bl9 = false;
            int n8 = rectangle.x - (this.display3dOn ? this.depth3dPoint.x * 2 : 0);
            int n9 = rectangle.x + rectangle.width;
            bl9 |= n2 >= n8 && n2 <= n9;
            bl9 |= n4 >= n8 && n4 <= n9;
            if (!(bl9 |= n2 <= n8 && n4 >= n9)) continue;
            graphics2D.setStroke(basicStroke);
            graphics2D.drawLine(n2, n3, n4, n5);
            graphics2D.setStroke(basicStroke2);
        }
    }

    protected void paintSampleHighlights(Graphics graphics, ChartSample[] chartSampleArray, int n, Rectangle rectangle, Color color) {
        for (int i = 0; chartSampleArray != null && i < chartSampleArray.length; ++i) {
            ChartSample chartSample = chartSampleArray[i];
            if (!this.chart.isSampleHighlightOn(n, i) || chartSample == null || !chartSample.hasValue()) continue;
            try {
                int n2 = this.getSamplePoint3DX(this.samplePoints[n][i][0], n) - this.depth3dPoint.x;
                int n3 = this.getSamplePoint3DY(this.samplePoints[n][i][1], n);
                if (n3 < rectangle.y || n3 > rectangle.y + rectangle.height - this.depth3dPoint.y || n2 < rectangle.x - this.depth3dPoint.x || n2 > rectangle.x + rectangle.width + 1 + this.depth3dPoint.x) continue;
                this.paintSampleHighlight(graphics, n, i, n2, n3, color);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void paintSimple3DLine(Graphics2D graphics2D, ChartSample[] chartSampleArray, int n, Rectangle rectangle, Rectangle rectangle2, Color color, boolean bl) {
        int n2;
        int n3 = this.chart.getSeriesCount();
        double d = this.depth3dPoint.x;
        double d2 = this.depth3dPoint.y;
        if (this.chart.getLine3DLayout() == 0 && !this.y) {
            d /= (double)n3;
            d2 /= (double)n3;
        }
        double d3 = this.chart.getLine3DDepth(n);
        int n4 = (int)((1.0 - d3) * d * 0.5);
        int n5 = (int)((1.0 - d3) * d2 * 0.5);
        d *= d3;
        d2 *= d3;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = Integer.MIN_VALUE;
        int n9 = Integer.MIN_VALUE;
        int[] nArray = this.chart.getVisibleSamples();
        int n10 = Math.max(nArray[0] - 2, 0);
        int n11 = Math.min(n10 + nArray[1] + 5, this.chart.getSampleCount());
        if (this.chart.isRightToLeftScrollingOn()) {
            n10 = 0;
            n11 = this.getSampleCount();
        }
        for (n2 = n10; n2 < n11 - 1; ++n2) {
            boolean bl2;
            boolean bl3;
            boolean bl4 = this.chart.isSampleHighlightOn(n, n2);
            boolean bl5 = chartSampleArray[n2] != null && chartSampleArray[n2].value != null && !chartSampleArray[n2].value.isNaN();
            boolean bl6 = bl3 = chartSampleArray[n2 + 1] != null && chartSampleArray[n2 + 1].value != null && !chartSampleArray[n2 + 1].value.isNaN();
            if (bl5) {
                try {
                    n6 = this.samplePoints[n][n2][0] - this.depth3dPoint.x + n4;
                    n7 = this.samplePoints[n][n2][1] + n5;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            boolean bl7 = bl2 = chartSampleArray[n2] != null && chartSampleArray[n2].value != null && chartSampleArray[n2].value.isNaN();
            if (bl2 && !this.chart.isConnectedLinesOn(n)) {
                n6 = Integer.MIN_VALUE;
            }
            if (!bl5 && n6 == Integer.MIN_VALUE || !bl3) continue;
            try {
                n8 = this.samplePoints[n][n2 + 1][0] - this.depth3dPoint.x + n4;
                n9 = this.samplePoints[n][n2 + 1][1] + n5;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (bl4) {
                this.paintSampleHighlight(graphics2D, n, n2, n6, n7, color);
                int n12 = this.chart.getSampleHighlightSize(n);
                n6 += n12 / 2;
                n8 -= n12 / 2;
            }
            if (!this.chart.isSeriesLineOn(n)) continue;
            this.a(graphics2D, n, n6, n7, n8, n9, 0.0, color, true, false, 0, this.chart.isOutlineOn(n));
        }
        ChartSample chartSample = chartSampleArray[n2];
        if (this.chart.isSampleHighlightOn(n, n2) && chartSample != null && chartSample.hasValue()) {
            this.paintSampleHighlight(graphics2D, n, n2, this.getSamplePoint3DX(this.samplePoints[n][n2][0], n) - this.depth3dPoint.x, this.getSamplePoint3DY(this.samplePoints[n][n2][1], n), color);
        }
    }

    protected void paintStackedLine(Graphics2D graphics2D, ChartSample[] chartSampleArray, int n, Rectangle rectangle, Rectangle rectangle2, Color color, boolean bl) {
        this.paintStackedLine(graphics2D, chartSampleArray, n, rectangle, rectangle2, color, bl, false);
    }

    protected void paintStackedLine(Graphics2D graphics2D, ChartSample[] chartSampleArray, int n, Rectangle rectangle, Rectangle rectangle2, Color color, boolean bl, boolean bl2) {
        Color color2 = this.chart.getSampleColor2(n);
        if (bl) {
            color = LineChartRenderer.getDarker(color);
            color2 = LineChartRenderer.getDarker(color2);
        }
        Paint paint = color;
        if (color2 != null) {
            paint = new GradientPaint(rectangle2.x, 0.0f, color, rectangle2.x + rectangle2.width, 0.0f, color2);
        }
        Paint paint2 = LineChartRenderer.getDarker(color);
        if (color2 != null) {
            paint2 = new GradientPaint(rectangle2.x, 0.0f, LineChartRenderer.getDarker(color), rectangle2.x + rectangle2.width, 0.0f, LineChartRenderer.getDarker(color2));
        }
        double d = this.display3dOn ? (double)this.depth3dPoint.x : 0.0;
        double d2 = this.display3dOn ? (double)this.depth3dPoint.y : 0.0;
        double d3 = this.chart.getLine3DDepth(n);
        double d4 = (1.0 - d3) * d2 * 0.5;
        double d5 = (1.0 - d3) * d * 0.5;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int[] nArray = this.chart.getVisibleSamples();
        int n2 = Math.max(nArray[0] - 2, 0);
        int n3 = Math.min(n2 + nArray[1] + 5, this.chart.getSampleCount());
        if (this.chart.isRightToLeftScrollingOn()) {
            n2 = 0;
            n3 = this.getSampleCount();
        }
        for (int i = n2; i < n3; ++i) {
            int n4;
            boolean bl3;
            boolean bl4 = bl3 = chartSampleArray[i] != null && chartSampleArray[i].value != null && !chartSampleArray[i].value.isNaN();
            while (!bl3 && i < n3 - 1) {
                bl3 = chartSampleArray[++i] != null && chartSampleArray[i].value != null && !chartSampleArray[i].value.isNaN();
            }
            double[][] dArray = new double[n3 - n2][2];
            double[][] dArray2 = new double[n3 - n2][2];
            int n5 = 0;
            while (bl3 && i < n3) {
                try {
                    d6 = (double)this.samplePoints[n][i][0] - d + d5;
                    d7 = (double)this.samplePoints[n][i][1] + d4;
                    d8 = (n > 0 ? (double)this.samplePoints[n - 1][i][1] : (double)this.gridRenderer.T[this.chart.getSeriesRange(n)] - d2) + d4;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                dArray[n5][0] = d6;
                dArray[n5][1] = d7;
                dArray2[n5][0] = d6;
                dArray2[n5][1] = d8;
                ++n5;
                bl3 = ++i < chartSampleArray.length && chartSampleArray[i] != null && chartSampleArray[i].value != null && !chartSampleArray[i].value.isNaN();
            }
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)dArray[0][0], (float)dArray[0][1]);
            for (n4 = 1; n4 < n5; ++n4) {
                generalPath.lineTo((float)dArray[n4][0], (float)dArray[n4][1]);
            }
            for (n4 = n5 - 1; n4 >= 0; --n4) {
                generalPath.lineTo((float)dArray2[n4][0], (float)dArray2[n4][1]);
            }
            generalPath.closePath();
            graphics2D.setPaint(paint);
            graphics2D.fill(generalPath);
            if (!this.chart.isOutlineOn(n)) continue;
            graphics2D.setPaint(paint2);
            graphics2D.draw(generalPath);
        }
    }

    private void if(Graphics2D graphics2D, ChartSample[] chartSampleArray, int n, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        int n2;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        Point2D.Float float_3 = new Point2D.Float();
        Point2D.Float float_4 = new Point2D.Float();
        Color color = this.chart.getSampleColor(n);
        Color color2 = this.chart.getSampleColor2(n);
        if (bl) {
            color = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            color2 = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color2));
        }
        if (color.equals(color2)) {
            color2 = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            color = LineChartRenderer.getBrighter(color);
        }
        if ((n2 = this.chart.getLineWidth(n)) == 1) {
            this.paintSimpleLine(graphics2D, chartSampleArray, n, rectangle, rectangle2, color, bl);
            return;
        }
        BasicStroke basicStroke = new BasicStroke(n2, 0, 0);
        for (int i = 0; i < chartSampleArray.length; ++i) {
            boolean bl2;
            boolean bl3 = chartSampleArray[i] != null && chartSampleArray[i].value != null && !chartSampleArray[i].value.isNaN();
            boolean bl4 = i > 0 && chartSampleArray[i - 1] != null && chartSampleArray[i - 1].value != null && !chartSampleArray[i - 1].value.isNaN();
            boolean bl5 = bl2 = i < chartSampleArray.length - 1 && chartSampleArray[i + 1] != null && chartSampleArray[i + 1].value != null && !chartSampleArray[i + 1].value.isNaN();
            if (!bl3) continue;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            try {
                n3 = this.getSamplePoint3DX(this.samplePoints[n][i][0], n) - this.depth3dPoint.x;
                n4 = this.getSamplePoint3DY(this.samplePoints[n][i][1], n);
                n5 = n3;
                n6 = n4;
                if (i < chartSampleArray.length - 1) {
                    n5 = this.getSamplePoint3DX(this.samplePoints[n][i + 1][0], n) - this.depth3dPoint.x;
                    n6 = this.getSamplePoint3DY(this.samplePoints[n][i + 1][1], n);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            Line2D.Float float_5 = new Line2D.Float(n3, n4, n5, n6);
            Shape shape = basicStroke.createStrokedShape(float_5);
            PathIterator pathIterator = shape.getPathIterator(null);
            float[] fArray = new float[2];
            pathIterator.currentSegment(fArray);
            Point2D.Float float_6 = new Point2D.Float(fArray[0], fArray[1]);
            pathIterator.next();
            pathIterator.currentSegment(fArray);
            Point2D.Float float_7 = new Point2D.Float(fArray[0], fArray[1]);
            pathIterator.next();
            pathIterator.currentSegment(fArray);
            Point2D.Float float_8 = new Point2D.Float(fArray[0], fArray[1]);
            pathIterator.next();
            pathIterator.currentSegment(fArray);
            Point2D.Float float_9 = new Point2D.Float(fArray[0], fArray[1]);
            Point2D.Float float_10 = new Point2D.Float(float_6.x, float_6.y);
            Point2D.Float float_11 = new Point2D.Float(float_9.x, float_9.y);
            if (bl4) {
                if (!bl2) {
                    float_10 = float_;
                    float_11 = float_2;
                } else {
                    double d = float_6.distance(float_);
                    double d2 = Math.acos(d / (double)n2);
                    double d3 = (double)n2 / (2.0 * Math.tan(d2));
                    double d4 = float_7.distance(float_6);
                    float f = float_7.x - float_6.x;
                    float f2 = float_7.y - float_6.y;
                    double d5 = d3 * (double)f / d4;
                    double d6 = d3 * (double)f2 / d4;
                    if (!new Double(d5).isNaN() && !new Double(d6).isNaN()) {
                        if (float_6.x < float_.x) {
                            float_10.x = float_6.x + (float)d5;
                            float_10.y = float_6.y + (float)d6;
                        } else {
                            float_10.x = float_6.x - (float)d5;
                            float_10.y = float_6.y - (float)d6;
                        }
                    }
                    d = float_9.distance(float_2);
                    d2 = Math.acos(d / (double)n2);
                    d3 = (double)n2 / (2.0 * Math.tan(d2));
                    d4 = float_8.distance(float_9);
                    f = float_8.x - float_9.x;
                    f2 = float_8.y - float_9.y;
                    d5 = d3 * (double)f / d4;
                    d6 = d3 * (double)f2 / d4;
                    if (float_9.x < float_2.x) {
                        float_11.x = float_9.x + (float)d5;
                        float_11.y = float_9.y + (float)d6;
                    } else {
                        float_11.x = float_9.x - (float)d5;
                        float_11.y = float_9.y - (float)d6;
                    }
                }
                float f = (float_2.x - float_.x) / 3.0f;
                float f3 = (float_.y - float_2.y) / 3.0f;
                if (color2 != null) {
                    graphics2D.setPaint(new GradientPaint(float_.x, float_.y, color2, float_2.x - f, float_2.y + f3, color, true));
                } else {
                    graphics2D.setPaint(new GradientPaint(float_.x, float_.y, LineChartRenderer.getDarker(LineChartRenderer.getDarker(color)), float_2.x - f, float_2.y + f3, color, true));
                }
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(float_3.x, float_3.y);
                generalPath.lineTo(float_4.x, float_4.y);
                generalPath.lineTo(float_11.x, float_11.y);
                generalPath.lineTo(float_10.x, float_10.y);
                generalPath.closePath();
                graphics2D.fill(generalPath);
                graphics2D.drawLine((int)float_10.x, (int)float_10.y - 1, (int)float_11.x, (int)float_11.y + 1);
            }
            float_3 = float_10;
            float_4 = float_11;
            float_ = float_7;
            float_2 = float_8;
        }
    }

    private void a(Graphics2D graphics2D, ChartSample[] chartSampleArray, int n, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        int n2;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        Point2D.Float float_3 = new Point2D.Float();
        Point2D.Float float_4 = new Point2D.Float();
        Color color = this.chart.getSampleColor(n);
        Color color2 = this.chart.getSampleColor2(n);
        if (bl) {
            color = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            color2 = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color2));
        }
        if (color.equals(color2)) {
            color2 = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            color = LineChartRenderer.getBrighter(color);
        }
        if ((n2 = this.chart.getLineWidth(n)) == 1) {
            this.paintSimpleLine(graphics2D, chartSampleArray, n, rectangle, rectangle2, color, bl);
            return;
        }
        BasicStroke basicStroke = new BasicStroke(n2, 0, 0);
        for (int i = 0; i < chartSampleArray.length; ++i) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            try {
                n3 = this.getSamplePoint3DX(this.samplePoints[n][i][0], n) - this.depth3dPoint.x;
                n4 = this.getSamplePoint3DY(this.samplePoints[n][i][1], n);
                n5 = n3;
                n6 = n4;
                if (i < chartSampleArray.length - 1) {
                    n5 = this.getSamplePoint3DX(this.samplePoints[n][i + 1][0], n) - this.depth3dPoint.x;
                    n6 = this.getSamplePoint3DY(this.samplePoints[n][i + 1][1], n);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            Line2D.Float float_5 = new Line2D.Float(n3, n4, n5, n6);
            Shape shape = basicStroke.createStrokedShape(float_5);
            PathIterator pathIterator = shape.getPathIterator(null);
            float[] fArray = new float[2];
            pathIterator.currentSegment(fArray);
            Point2D.Float float_6 = new Point2D.Float(fArray[0], fArray[1]);
            pathIterator.next();
            pathIterator.currentSegment(fArray);
            Point2D.Float float_7 = new Point2D.Float(fArray[0], fArray[1]);
            pathIterator.next();
            pathIterator.currentSegment(fArray);
            Point2D.Float float_8 = new Point2D.Float(fArray[0], fArray[1]);
            pathIterator.next();
            pathIterator.currentSegment(fArray);
            Point2D.Float float_9 = new Point2D.Float(fArray[0], fArray[1]);
            Point2D.Float float_10 = new Point2D.Float(float_6.x, float_6.y);
            Point2D.Float float_11 = new Point2D.Float(float_9.x, float_9.y);
            if (i > 0) {
                if (i == chartSampleArray.length - 1) {
                    float_10 = float_;
                    float_11 = float_2;
                } else {
                    double d = float_6.distance(float_);
                    double d2 = Math.acos(d / (double)n2);
                    double d3 = (double)n2 / (2.0 * Math.tan(d2));
                    double d4 = float_7.distance(float_6);
                    float f = float_7.x - float_6.x;
                    float f2 = float_7.y - float_6.y;
                    double d5 = d3 * (double)f / d4;
                    double d6 = d3 * (double)f2 / d4;
                    if (float_6.x < float_.x) {
                        float_10.x = float_6.x + (float)d5;
                        float_10.y = float_6.y + (float)d6;
                    } else {
                        float_10.x = float_6.x - (float)d5;
                        float_10.y = float_6.y - (float)d6;
                    }
                    d = float_9.distance(float_2);
                    d2 = Math.acos(d / (double)n2);
                    d3 = (double)n2 / (2.0 * Math.tan(d2));
                    d4 = float_8.distance(float_9);
                    f = float_8.x - float_9.x;
                    f2 = float_8.y - float_9.y;
                    d5 = d3 * (double)f / d4;
                    d6 = d3 * (double)f2 / d4;
                    if (float_9.x < float_2.x) {
                        float_11.x = float_9.x + (float)d5;
                        float_11.y = float_9.y + (float)d6;
                    } else {
                        float_11.x = float_9.x - (float)d5;
                        float_11.y = float_9.y - (float)d6;
                    }
                }
                float f = (float_2.x - float_.x) / 3.0f;
                float f3 = (float_.y - float_2.y) / 3.0f;
                if (color2 != null) {
                    graphics2D.setPaint(new GradientPaint(float_.x, float_.y, color2, float_2.x - f, float_2.y + f3, color, true));
                } else {
                    graphics2D.setPaint(new GradientPaint(float_.x, float_.y, LineChartRenderer.getDarker(LineChartRenderer.getDarker(color)), float_2.x - f, float_2.y + f3, color, true));
                }
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(float_3.x, float_3.y);
                generalPath.lineTo(float_4.x, float_4.y);
                generalPath.lineTo(float_11.x, float_11.y);
                generalPath.lineTo(float_10.x, float_10.y);
                generalPath.closePath();
                graphics2D.fill(generalPath);
                graphics2D.drawLine((int)float_10.x, (int)float_10.y - 1, (int)float_11.x, (int)float_11.y + 1);
            }
            float_3 = float_10;
            float_4 = float_11;
            float_ = float_7;
            float_2 = float_8;
        }
    }

    protected void paintArea(Graphics2D graphics2D, int n, int n2, int n3, Rectangle rectangle, Rectangle rectangle2, Color color, boolean bl) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Serializable serializable;
        if (n2 < 0 || n2 >= this.samplePoints.length || n3 < 0 || n3 >= this.samplePoints.length) {
            return;
        }
        int n10 = this.getSeriesCount();
        int n11 = Math.min(this.getSampleCount(), Math.min(this.samplePoints[n2].length, this.samplePoints[n3].length));
        ChartSample[] chartSampleArray = this.chart.getSamples(n2);
        ChartSample[] chartSampleArray2 = this.chart.getSamples(n3);
        if (chartSampleArray == null || chartSampleArray.length == 0 || chartSampleArray2 == null || chartSampleArray2.length == 0) {
            return;
        }
        if (this.display3dOn) {
            serializable = new Polygon();
            ((Polygon)serializable).addPoint(rectangle.x - this.depth3dPoint.x, rectangle.y - this.depth3dPoint.y);
            ((Polygon)serializable).addPoint(rectangle.x, rectangle.y);
            ((Polygon)serializable).addPoint(rectangle.x + rectangle.width, rectangle.y);
            ((Polygon)serializable).addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            ((Polygon)serializable).addPoint(rectangle.x + rectangle.width - this.depth3dPoint.x, rectangle.y + rectangle.height - this.depth3dPoint.y);
            ((Polygon)serializable).addPoint(rectangle.x - this.depth3dPoint.x, rectangle.y + rectangle.height - this.depth3dPoint.y);
            graphics2D.setClip((Shape)((Object)serializable));
        } else {
            graphics2D.setClip(rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height + 1);
        }
        serializable = this.chart.getAreaColor2(n);
        if (serializable == null) {
            serializable = color;
        }
        GradientPaint gradientPaint = new GradientPaint(rectangle2.x, 0.0f, color, rectangle2.x + rectangle2.width, 0.0f, (Color)serializable);
        GradientPaint gradientPaint2 = new GradientPaint(rectangle2.x, 0.0f, LineChartRenderer.getDarker(color), rectangle2.x + rectangle2.width, 0.0f, LineChartRenderer.getDarker((Color)serializable));
        int n12 = this.depth3dPoint.x;
        int n13 = this.depth3dPoint.y;
        int n14 = this.depth3dPoint.x;
        int n15 = this.depth3dPoint.y;
        if (this.chart.getLine3DLayout() == 0) {
            n12 = (int)Math.round((double)this.depth3dPoint.x / (double)n10);
            n13 = (int)Math.round((double)this.depth3dPoint.y / (double)n10);
            n14 = (int)Math.round((double)this.depth3dPoint.x / (double)n10);
            n15 = (int)Math.round((double)this.depth3dPoint.y / (double)n10);
        }
        n12 = (int)((double)n12 * this.chart.getLine3DDepth(n2));
        n13 = (int)((double)n13 * this.chart.getLine3DDepth(n2));
        n14 = (int)((double)n14 * this.chart.getLine3DDepth(n3));
        n15 = (int)((double)n15 * this.chart.getLine3DDepth(n3));
        Polygon polygon = new Polygon();
        int n16 = this.display3dOn ? this.depth3dPoint.x : 0;
        graphics2D.setPaint(gradientPaint2);
        for (n9 = 0; n9 < n11; ++n9) {
            if (chartSampleArray[n9] == null || !chartSampleArray[n9].hasValue()) continue;
            n8 = this.getSamplePoint3DX(this.samplePoints[n2][n9][0], n2) - n16;
            n7 = this.getSamplePoint3DY(this.samplePoints[n2][n9][1], n2);
            int n17 = n6 = this.chart.isSampleHighlightOn(n2) ? this.chart.getSampleHighlightSize(n2) + 2 : 0;
            if (n9 != 0) {
                polygon.addPoint(n8 - n6 / 2, n7);
            }
            polygon.addPoint(n8, n7);
            if (n9 != n11 - 1) {
                polygon.addPoint(n8 + n6 / 2, n7);
            }
            if (this.chart.isSeriesLineOn(n2) || n9 >= n11 - 1) continue;
            n5 = this.getSamplePoint3DX(this.samplePoints[n2][n9 + 1][0], n2) - n16;
            n4 = this.getSamplePoint3DY(this.samplePoints[n2][n9 + 1][1], n2);
            this.a(graphics2D, n2, n8 + n6 / 2, n7, n5 - n6 / 2, n4, 0.0, color, true, false, 1, false);
            this.a(graphics2D, n2, n8 + n6 / 2, n7, n5 - n6 / 2, n4, 0.0, color, true, false, 2, false);
        }
        for (n9 = n11 - 1; n9 >= 0; --n9) {
            if (chartSampleArray2[n9] == null || !chartSampleArray[n9].hasValue()) continue;
            n8 = this.getSamplePoint3DX(this.samplePoints[n3][n9][0], n3) - n16;
            n7 = this.getSamplePoint3DY(this.samplePoints[n3][n9][1], n3);
            int n18 = n6 = this.chart.isSampleHighlightOn(n3) ? this.chart.getSampleHighlightSize(n3) + 2 : 0;
            if (n9 != n11 - 1) {
                polygon.addPoint(n8 + n6 / 2, n7);
            }
            polygon.addPoint(n8, n7);
            if (n9 != 0) {
                polygon.addPoint(n8 - n6 / 2, n7);
            }
            if (this.chart.isSeriesLineOn(n3) || n9 >= n11 - 1) continue;
            n5 = this.getSamplePoint3DX(this.samplePoints[n3][n9 + 1][0], n3) - n16;
            n4 = this.getSamplePoint3DY(this.samplePoints[n3][n9 + 1][1], n3);
            this.a(graphics2D, n3, n8 + n6 / 2, n7, n5 - n6 / 2, n4, 0.0, color, true, false, 1, false);
            this.a(graphics2D, n3, n8 + n6 / 2, n7, n5 - n6 / 2, n4, 0.0, color, true, false, 2, false);
        }
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillPolygon(polygon);
        if (this.display3dOn) {
            n9 = this.getSamplePoint3DX(this.samplePoints[n2][n11 - 1][0], n2) - n16;
            n8 = this.getSamplePoint3DY(this.samplePoints[n2][n11 - 1][1], n2);
            n7 = this.getSamplePoint3DX(this.samplePoints[n3][n11 - 1][0], n3) - n16;
            n6 = this.getSamplePoint3DY(this.samplePoints[n3][n11 - 1][1], n3);
            polygon = new Polygon();
            polygon.addPoint(n9, n8);
            polygon.addPoint(n9 + n12, n8 + n13);
            polygon.addPoint(n7 + n14, n6 + n15);
            polygon.addPoint(n7, n6);
            graphics2D.setColor(LineChartRenderer.getDarker(color));
            graphics2D.fillPolygon(polygon);
            this.display3dOn = false;
            for (n5 = 0; n5 < n11 && n5 < this.samplePoints[n2].length; ++n5) {
                if (this.chart.isSampleHighlightOn(n2)) {
                    this.paintSampleHighlights(graphics2D, this.chart.getSamples(n2), n2, rectangle, this.chart.getSampleColor(n2));
                }
                if (!this.chart.isSampleHighlightOn(n3)) continue;
                this.paintSampleHighlights(graphics2D, this.chart.getSamples(n3), n3, rectangle, this.chart.getSampleColor(n3));
            }
            this.display3dOn = true;
            if (n8 < n6) {
                if (this.chart.isSampleHighlightOn(n2)) {
                    this.paintSampleHighlight(graphics2D, n2, n11 - 1, n9, n8, this.chart.getSampleColor(n2));
                }
            } else if (this.chart.isSampleHighlightOn(n3)) {
                this.paintSampleHighlight(graphics2D, n3, n11 - 1, n7, n6, this.chart.getSampleColor(n3));
            }
        }
        graphics2D.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected int getSamplePoint3DX(int n, int n2) {
        int n3 = this.chart.getSeriesCount();
        double d = this.depth3dPoint.x;
        if (this.chart.getLine3DLayout() == 0 && !this.y) {
            d /= (double)n3;
        }
        double d2 = this.chart.getLine3DDepth(n2);
        int n4 = (int)((1.0 - d2) * d * 0.5);
        if (this.chart.getLineStyle(n2) == 1) {
            n4 = (int)(d * 0.5);
        }
        return n + n4;
    }

    protected int getSamplePoint3DY(int n, int n2) {
        int n3 = this.chart.getSeriesCount();
        double d = this.depth3dPoint.y;
        if (this.chart.getLine3DLayout() == 0 && !this.y) {
            d /= (double)n3;
        }
        double d2 = this.chart.getLine3DDepth(n2);
        int n4 = (int)((1.0 - d2) * d * 0.5);
        if (this.chart.getLineStyle(n2) == 1) {
            n4 = (int)(d * 0.5);
        }
        return n + n4;
    }

    protected void paint3DLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl, boolean bl2, boolean bl3) {
        this.a((Graphics2D)graphics, 0, n, n2, n3, n4, n5, color, bl, bl2, 1, bl3);
        this.a((Graphics2D)graphics, 0, n, n2, n3, n4, n5, color, bl, bl2, 2, bl3);
    }

    private void a(Graphics2D graphics2D, int n, double d, double d2, double d3, double d4, double d5, Color color, boolean bl, boolean bl2, int n2, boolean bl3) {
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        int n3 = this.y ? 1 : Math.max(1, this.getSeriesCount());
        float f = (float)this.chart.getLine3DDepth(n);
        float f2 = this.depth3dPoint.x;
        float f3 = this.depth3dPoint.y;
        if (this.chart.getLine3DLayout() == 0 && !this.y) {
            f2 /= (float)n3;
            f3 /= (float)n3;
        }
        fArray[0] = (float)d;
        fArray2[0] = (float)d2;
        fArray[1] = fArray[0] + (f2 *= f);
        fArray2[1] = fArray2[0] + (f3 *= f);
        fArray[3] = (float)d3;
        fArray2[3] = (float)d4;
        fArray[2] = fArray[3] + f2;
        fArray2[2] = fArray2[3] + f3;
        Rectangle rectangle = this.chart.getDataBounds(this.chart.getGraphBounds());
        if (bl) {
            GradientPaint gradientPaint;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(fArray[0], fArray2[0]);
            generalPath.lineTo(fArray[1], fArray2[1]);
            generalPath.lineTo(fArray[2], fArray2[2]);
            generalPath.lineTo(fArray[3], fArray2[3]);
            double d6 = 0.0;
            if (d3 - d != 0.0) {
                d6 = (d2 - d4) / (d3 - d);
            }
            Color color2 = this.chart.getSampleColor2(n);
            if (this.y) {
                color = LineChartRenderer.getDarker(color);
                color2 = LineChartRenderer.getDarker(color2);
            }
            if (this.chart.isSelected(n, -1)) {
                color = LineChartRenderer.getDarker(color);
                color2 = LineChartRenderer.getDarker(color2);
            }
            if (color2 == null) {
                graphics2D.setColor(d6 > 0.69 ? LineChartRenderer.getDarker(color) : color);
            } else {
                gradientPaint = d6 > 0.69 ? new GradientPaint(rectangle.x, 0.0f, LineChartRenderer.getDarker(color), rectangle.x + rectangle.width, 0.0f, LineChartRenderer.getDarker(color2)) : new GradientPaint(rectangle.x, 0.0f, color, rectangle.x + rectangle.width, 0.0f, color2);
                graphics2D.setPaint(gradientPaint);
            }
            if (n2 == 0) {
                graphics2D.fill(generalPath);
            } else if (d6 > 0.69 && n2 == 2) {
                graphics2D.fill(generalPath);
            } else if (d6 <= 0.69 && n2 == 1) {
                graphics2D.fill(generalPath);
            }
            if (this.chart.isOutlineOn(n)) {
                generalPath.reset();
                generalPath.moveTo(fArray[0], fArray2[0]);
                generalPath.lineTo(fArray[1], fArray2[1]);
                generalPath.lineTo(fArray[2], fArray2[2]);
                if (!this.y) {
                    generalPath.lineTo(fArray[3], fArray2[3]);
                    generalPath.closePath();
                }
                if (color2 == null) {
                    graphics2D.setColor(LineChartRenderer.getDarker(color));
                } else {
                    gradientPaint = new GradientPaint(rectangle.x, 0.0f, LineChartRenderer.getDarker(color), rectangle.x + rectangle.width, 0.0f, LineChartRenderer.getDarker(color2));
                    graphics2D.setPaint(gradientPaint);
                }
                graphics2D.draw(generalPath);
            }
        }
    }

    private boolean a(double d, double d2, double d3, Rectangle rectangle) {
        boolean bl;
        if (this.display3dOn) {
            if (d2 <= d3) {
                bl = d2 >= (double)(rectangle.y - 2) && d2 <= (double)(rectangle.y + rectangle.height + 2 - this.depth3dPoint.y) && d >= (double)(rectangle.x - 2) && d <= (double)(rectangle.x + rectangle.width + this.depth3dPoint.x + 2);
            } else {
                double d4 = (double)this.depth3dPoint.x / (double)this.getSeriesCount();
                double d5 = (double)this.depth3dPoint.y / (double)this.getSeriesCount();
                bl = d2 >= (double)rectangle.y - d5 - 2.0 && d2 <= (double)(rectangle.y + rectangle.height - this.depth3dPoint.y) - d5 && d >= (double)rectangle.x - d4 - 2.0 && d <= (double)(rectangle.x + rectangle.width) - d4 + (double)this.depth3dPoint.x + 2.0;
            }
        } else {
            bl = d2 >= (double)(rectangle.y - 2) && d2 <= (double)(rectangle.y + rectangle.height + 2) && d >= (double)(rectangle.x - 4) && d <= (double)(rectangle.x + rectangle.width + 2);
        }
        return bl;
    }

    private void a(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        int n = this.getSampleCount();
        int n2 = this.getSeriesCount();
        double d = rectangle2.width;
        if (n > 2) {
            d = (double)rectangle2.width / (double)(n - 1);
        }
        Font font = this.getFont("seriesLabelFont");
        Font font2 = this.getFont("valueLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics(font2);
        int n3 = this.getLabelAngle("valueLabelAngle");
        Font font3 = this.getFont("sampleLabelFont");
        int n4 = this.getLabelAngle("sampleLabelAngle");
        for (int i = 0; i < n2; ++i) {
            String string;
            String string2;
            boolean bl;
            int n5 = this.chart.getValueLabelStyle();
            int n6 = this.chart.getSampleLabelStyle();
            int n7 = this.chart.getSeriesLabelStyle();
            boolean bl2 = this.chart.isValueLabelsOn(i);
            boolean bl3 = this.chart.isSampleLabelsOn();
            boolean bl4 = this.chart.isSeriesLabelsOn();
            boolean bl5 = n5 == 0 && bl2;
            boolean bl6 = bl = n5 == 1 && bl2 || n6 == 1 && bl3 || n7 == 1 && bl4;
            if (this.y && bl) {
                if (i != 0) break;
                i = n2 - 1;
            }
            if ((string2 = this.getLabel("valueLabelPrefix_" + i)) == null) {
                string2 = this.getLabel("valueLabelPrefix");
            }
            if ((string = this.getLabel("valueLabelPostfix_" + i)) == null) {
                string = this.getLabel("valueLabelPostfix");
            }
            ChartSample[] chartSampleArray = this.chart.getSamples(i);
            int[] nArray = this.chart.getVisibleSamples();
            int n8 = Math.max(nArray[0] - 1, 0);
            int n9 = Math.min(n8 + nArray[1] + 1, n);
            if (this.chart.isRightToLeftScrollingOn()) {
                n8 = 0;
                n9 = this.getSampleCount();
            }
            for (int j = n8; j < n9; ++j) {
                int n10;
                Serializable serializable;
                Serializable serializable2;
                if (!this.y && (chartSampleArray[j] == null || chartSampleArray[j].value == null || chartSampleArray[j].value.isNaN())) continue;
                double d2 = 0.0;
                if (this.y && bl) {
                    boolean bl7 = false;
                    for (int k = 0; k < n2; ++k) {
                        ChartSample chartSample = this.chart.getSample(k, j);
                        if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) continue;
                        d2 += chartSample.value.doubleValue();
                        bl7 = true;
                    }
                    if (!bl7) {
                        continue;
                    }
                } else {
                    ChartSample chartSample = this.chart.getSample(i, j);
                    if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) continue;
                    d2 = chartSampleArray[j].getFloatValue();
                }
                double d3 = d2;
                if (j >= 1 && chartSampleArray[j - 1] != null) {
                    d3 = chartSampleArray[j - 1].getFloatValue();
                }
                double d4 = d2;
                if (j < chartSampleArray.length - 1 && chartSampleArray[j + 1] != null) {
                    d4 = chartSampleArray[j + 1].getFloatValue();
                }
                double d5 = (d2 - d3) / d;
                double d6 = (d4 - d2) / d;
                Dimension dimension = new Dimension();
                int n11 = Integer.MIN_VALUE;
                int n12 = Integer.MIN_VALUE;
                if (this.samplePoints != null && i < this.samplePoints.length && j < this.samplePoints[i].length) {
                    n11 = this.samplePoints[i][j][0];
                    n12 = this.samplePoints[i][j][1] - 1;
                }
                if (bl5) {
                    String string3 = this.chart.formatSeriesNumber(i, d2);
                    string3 = string2 != null ? string2 + string3 : string3;
                    string3 = string != null ? string3 + string : string3;
                    serializable2 = this.getLabelSize(string3, fontMetrics);
                    dimension = this.getAngledLabelSize((Dimension)serializable2, n3);
                    serializable = this.chart.getValueLabelColor(i);
                    if (serializable == null) {
                        serializable = this.chart.getChartForeground();
                    }
                    n10 = Math.round(n11 - dimension.width / 2) + 1;
                    int n13 = n12;
                    n13 = n3 % 180 == 0 ? (n13 += fontMetrics.getAscent() / 2) : n12 - dimension.height / 2;
                    if (this.display3dOn && !this.y) {
                        n10 -= this.depth3dPoint.x;
                        if (d5 >= d6) {
                            n13 = (int)((double)n13 + (double)this.depth3dPoint.y / (double)n2);
                            n10 = (int)((double)n10 + (double)this.depth3dPoint.x / (double)n2);
                        }
                    } else if (this.display3dOn && this.y) {
                        n10 -= this.depth3dPoint.x;
                    }
                    if (this.a(n11, n12, n13 + dimension.height, rectangle)) {
                        graphics.setColor((Color)serializable);
                        graphics.setFont(font2);
                        this.paintLabel(graphics, string3, n10, n13, (Dimension)serializable2, this.chart.getMultilineLabelAlignment(), n3, false);
                    }
                }
                if (bl) {
                    String string4;
                    boolean bl8;
                    int n14 = 0;
                    serializable2 = null;
                    serializable = null;
                    if (n5 == 1 && bl2) {
                        n14 = n3;
                        serializable2 = this.chart.getValueLabelColor(i);
                        serializable = font2;
                    }
                    if (n6 == 1 && bl3) {
                        n14 = n4;
                        if (this.chart.getSampleLabelColor(j) != null) {
                            serializable2 = this.chart.getSampleLabelColor(j);
                        }
                        serializable = font3;
                    }
                    if (n7 == 1 && bl4) {
                        if (serializable == null) {
                            serializable = font;
                        }
                        if (serializable2 == null) {
                            serializable2 = this.chart.getSeriesLabelColor(i);
                        }
                    }
                    fontMetrics = this.getFontMetrics((Font)serializable);
                    n10 = fontMetrics.getAscent();
                    if (serializable2 == null) {
                        serializable2 = this.chart.getChartForeground();
                    }
                    String string5 = "";
                    boolean bl9 = bl8 = bl3 && n6 == 1;
                    if (bl4 && n7 == 1 && (string4 = this.chart.getSeriesLabel(i)) != null) {
                        string5 = string5 + string4;
                        if (!string4.endsWith("\n") && (bl8 && this.chart.getSampleLabel(j) != null || bl2 && n5 == 1)) {
                            string5 = string5 + ":";
                        }
                    }
                    string4 = this.chart.formatSeriesNumber(i, d2);
                    string4 = string2 != null ? string2 + string4 : string4;
                    String string6 = string4 = string != null ? string4 + string : string4;
                    if (bl8) {
                        String string7 = this.chart.getSampleLabel(j);
                        if (string7 != null && !string7.endsWith("\n") && string4 != null && bl2 && n5 == 1) {
                            string7 = string7 + ":";
                        }
                        if (string7 != null) {
                            string5 = string5 + string7;
                        }
                    }
                    if (bl2 && n5 == 1) {
                        string5 = string5 == null ? string4 : string5 + string4;
                    }
                    Dimension dimension2 = this.getLabelSize(string5, fontMetrics);
                    Dimension dimension3 = this.getAngledLabelSize(dimension2, n14);
                    int n15 = Math.round(n11 - dimension3.width / 2) + 1;
                    if (this.display3dOn) {
                        n15 -= this.depth3dPoint.x;
                    }
                    int n16 = n12;
                    if (this.display3dOn && d5 >= d6) {
                        n16 = (int)((double)n16 + (double)this.depth3dPoint.y / (double)n2);
                    }
                    int n17 = n16;
                    n17 = n14 % 180 == 0 ? (n17 += n10) : (n17 += 6);
                    int n18 = n16;
                    if (n14 % 180 != 0) {
                        n18 -= dimension3.height;
                    }
                    boolean bl10 = false;
                    int n19 = 0;
                    try {
                        bl10 = this.chart.isSampleHighlightOn(i, j);
                        n19 = this.chart.getSampleHighlightSize(i);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        System.out.println("Internal error with value labels");
                        indexOutOfBoundsException.printStackTrace();
                    }
                    if (bl10 || n5 == 0 && bl2) {
                        if (n19 >= dimension.height) {
                            n17 += n19 / 2;
                            n18 -= n19 / 2;
                        } else {
                            n17 += dimension.height / 2 - 3;
                            n18 -= dimension.height / 2 - 1;
                        }
                    }
                    if ((n16 = d5 < d6 && this.chart.getRange(0) >= this.chart.getLowerRange(0) || d5 >= d6 && this.chart.getLowerRange(0) >= this.chart.getRange(0) ? n17 : n18) != n17 && this.display3dOn && !this.y) {
                        n15 = (int)((double)n15 + (double)this.depth3dPoint.x / (double)n2);
                    }
                    if (this.display3dOn) {
                        n15 = Math.max(rectangle.x - this.depth3dPoint.x + 2, n15);
                        n16 = Math.min(n16, rectangle.y + rectangle.height - this.depth3dPoint.y);
                    } else {
                        n15 = Math.max(rectangle.x + 2, n15);
                        n16 = Math.min(n16, rectangle.y + rectangle.height);
                    }
                    n15 = Math.min(n15, rectangle.x + rectangle.width - dimension3.width - 1);
                    n16 = Math.max(n16, rectangle.y + dimension3.height - 2);
                    if (this.a(n11, n12, n16 + dimension3.height, rectangle)) {
                        graphics.setColor((Color)serializable2);
                        graphics.setFont((Font)serializable);
                        this.paintLabel(graphics, string5, n15, n16, dimension2, this.chart.getMultilineLabelAlignment(), n14, false);
                    }
                }
                n11 = (int)((double)n11 + d);
            }
        }
    }

    void a(Graphics graphics, Rectangle rectangle) {
        int n;
        Font font = this.getFont("sampleLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n2 = this.getLabelAngle("sampleLabelAngle");
        String[] stringArray = this.chart.getSampleLabels();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int[] nArray = this.chart.getVisibleSamples();
        int n3 = Math.min(nArray[0] + nArray[1], this.getSampleCount());
        for (n = Math.max(nArray[0], 0); n < this.getSampleCount() && n < stringArray.length && stringArray[n] == null; ++n) {
        }
        while (n3 > n && n3 < stringArray.length && stringArray[n3 - 1] == null) {
            --n3;
        }
        if (this.chart.isRightToLeftScrollingOn()) {
            n = 0;
            n3 = this.getSampleCount();
        }
        n3 = Math.min(n3, this.x.length);
        n3 = Math.max(n3, 1);
        Dimension dimension = this.getAngledLabelSize(this.getLabelSize(stringArray[n3 - 1], fontMetrics), n2);
        int n4 = n2 % 180 == 0 ? this.x[n3 - 1] - dimension.width / 2 : (n2 % 360 > 90 && n2 % 360 < 180 || n2 % 360 > 270 ? this.x[n3 - 1] - dimension.width + fontMetrics.getAscent() / 2 : this.x[n3 - 1] - fontMetrics.getAscent() / 2);
        if (this.display3dOn) {
            n4 -= this.depth3dPoint.x;
        }
        double d = 0.0;
        for (int i = n; i < n3 && i < stringArray.length; ++i) {
            String string = stringArray[i];
            Dimension dimension2 = this.getLabelSize(string, fontMetrics);
            Dimension dimension3 = this.getAngledLabelSize(dimension2, n2);
            if (!this.chart.isSampleLabelsOn() || this.chart.getSampleLabelStyle() != 2 && this.chart.getSampleLabelStyle() != 4) continue;
            int n5 = rectangle.y + rectangle.height;
            int n6 = rectangle.x;
            int n7 = rectangle.x + rectangle.width;
            if (this.display3dOn) {
                n5 -= this.depth3dPoint.y;
                n7 -= this.depth3dPoint.x;
                n6 -= this.depth3dPoint.x;
            }
            if (this.chart.isSampleScrollerOn()) {
                n5 += 10;
            }
            int n8 = 0;
            if (this.x != null && i < this.x.length) {
                n8 = this.x[i];
            }
            if (string == null || string.length() <= 0 || (n8 -= this.display3dOn ? this.depth3dPoint.x : 0) < n6 || n8 > n7 + 1) continue;
            int n9 = n5 + 8;
            if (n2 % 180 == 0) {
                n9 += fontMetrics.getMaxAscent() - 4;
            }
            int n10 = n2 % 180 == 0 ? n8 - dimension3.width / 2 : (n2 % 360 > 90 && n2 % 360 < 180 || n2 % 360 > 270 ? n8 - dimension3.width + fontMetrics.getAscent() / 2 : n8 - fontMetrics.getAscent() / 2);
            graphics.setFont(font);
            Color color = this.chart.getForeground();
            Color color2 = this.chart.getSampleLabelColor(i);
            if (color2 == null) {
                color2 = color;
            }
            graphics.setColor(color);
            if (this.chart.isAutoLabelSpacingOn()) {
                if (string == null || string.trim().length() <= 0 || !((double)n10 > d && n10 + dimension3.width <= n4 + 3 || i == n) && i != n3 - 1) continue;
                graphics.drawLine(Math.round(n8), n5, Math.round(n8), n5 + 3);
                graphics.setColor(color2);
                this.paintLabel(graphics, string, n10, n9, dimension2, 0, n2, false);
                d = n10 + dimension3.width;
                continue;
            }
            if (string == null || string.trim().length() <= 0) continue;
            graphics.drawLine(Math.round(n8), n5, Math.round(n8), n5 + 3);
            graphics.setColor(color2);
            this.paintLabel(graphics, string, n10, n9, dimension2, 0, n2, false);
        }
    }

    protected void paintFloatingLabel(Graphics graphics, String string, Rectangle rectangle, int n, int n2, Font font, FontMetrics fontMetrics) {
        if (string == null || this.samplePoints == null || this.samplePoints[n2] == null || this.samplePoints[n2][n] == null) {
            return;
        }
        int n3 = this.samplePoints[n2][n][0];
        int n4 = this.samplePoints[n2][n][1];
        if (n3 < rectangle.x || n3 > rectangle.x + rectangle.width + (this.display3dOn ? this.depth3dPoint.x : 0)) {
            return;
        }
        if (n4 < rectangle.y || n4 > rectangle.y + rectangle.height - (this.display3dOn ? this.depth3dPoint.y : 0)) {
            return;
        }
        Dimension dimension = this.getLabelSize(string, fontMetrics);
        int n5 = n3 - dimension.width / 2 - (this.display3dOn ? this.depth3dPoint.x : 0);
        int n6 = n4 - dimension.height + fontMetrics.getAscent() - 3;
        if (this.e > -1) {
            n5 = this.d.x - dimension.width / 2;
            n6 = this.d.y - dimension.height + fontMetrics.getAscent() - 3;
        }
        this.a(graphics, string, n5, n6, dimension, LineChartRenderer.getDarker(this.chart.getSampleColor(n2)), fontMetrics);
    }

    protected void paintSampleHighlight(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        String string;
        Shape shape = graphics.getClip();
        if (n2 != -1 && !this.display3dOn) {
            graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        }
        if ((string = this.chart.getSampleHighlightImage(n, n2)) == null) {
            string = this.chart.getSampleHighlightImage(n, -1);
        }
        if (string == null) {
            string = this.chart.getSampleHighlightImage(-1, -1);
        }
        if (string == null) {
            string = this.chart.getLegendImage(n);
        }
        Dimension dimension = this.getImageSize(string);
        if (string != null && dimension.width > 0 && dimension.height > 0) {
            Image image = this.chart.getImage(string);
            if (image != null) {
                graphics.drawImage(image, n3 - dimension.width / 2, n4 - dimension.height / 2, this.chart);
            }
        } else {
            boolean bl = this.chart.isSelected(n, -1) && n2 != -1;
            int n5 = 0;
            if (n >= 0) {
                n5 = this.chart.getSampleHighlightStyle(n);
            }
            int n6 = 7;
            if (n2 == -1) {
                switch (n5) {
                    case 2: {
                        n6 = 7;
                        break;
                    }
                    case 0: 
                    case 1: {
                        n6 = 6;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n6 = 5;
                    }
                }
            } else if (n >= 0) {
                n6 = this.chart.getSampleHighlightSize(n);
            }
            graphics.setColor(color);
            switch (n5) {
                case 0: 
                case 1: 
                case 2: {
                    this.if(graphics, n, n3, n4, n6, n5, color, bl);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.do(graphics, n, n3, n4, n6, n5, color, bl);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.a(graphics, n, n3, n4, n6, n5, color, bl);
                }
            }
        }
        graphics.setClip(shape);
    }

    private void if(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        Color color2 = this.chart.getChartBackground();
        if (this.display3dOn) {
            ++n2;
            int n6 = this.depth3dPoint.x;
            int n7 = this.depth3dPoint.y;
            if (this.chart.getLine3DLayout() == 0) {
                n6 = this.depth3dPoint.x / this.getSeriesCount();
                n7 = this.depth3dPoint.y / this.getSeriesCount();
            }
            n6 = (int)((double)n6 * this.chart.getLine3DDepth(n));
            n7 = (int)((double)n7 * this.chart.getLine3DDepth(n));
            int n8 = n2 + n6;
            int n9 = n3 + n7;
            Polygon polygon = new Polygon();
            int n10 = (int)((double)n4 * 0.35);
            polygon.addPoint(n2 - n10, n3 - n10);
            polygon.addPoint(n2 + n10, n3 + n10);
            polygon.addPoint(n8 + n10, n9 + n10);
            polygon.addPoint(n8 - n10, n9 - n10);
            Color color3 = color;
            Color color4 = LineChartRenderer.getDarker(color);
            if (bl) {
                color3 = LineChartRenderer.getDarker(color);
                color4 = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            }
            if (n5 != 2) {
                color3 = color2;
            }
            graphics.setColor(color4);
            graphics.fillOval(n8 - n4 / 2, n9 - n4 / 2, n4, n4);
            graphics.setColor(color3);
            graphics.fillOval(n8 - n4 / 2 + 1, n9 - n4 / 2 + 1, n4 - 2, n4 - 2);
            graphics.fillPolygon(polygon);
            graphics.setColor(color4);
            graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
            graphics.drawLine(n2 - n10, n3 - n10, n8 - n10, n9 - n10);
            graphics.drawLine(n2 + n10, n3 + n10, n8 + n10, n9 + n10);
            graphics.setColor(color3);
            graphics.fillOval(n2 - n4 / 2 + 1, n3 - n4 / 2 + 1, n4 - 2, n4 - 2);
        } else {
            if (n5 == 0) {
                graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
            } else if (n5 == 2) {
                if (n4 == 2) {
                    n4 = 3;
                }
                graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                graphics.setColor(LineChartRenderer.getDarker(color));
                graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
            } else if (n5 == 1) {
                graphics.setColor(color2);
                graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                graphics.setColor(color);
                graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
            }
            if (bl) {
                graphics.setColor(LineChartRenderer.getDarker(LineChartRenderer.getDarker(color)));
                if (n5 == 2) {
                    graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4 - 1, n4 - 1);
                } else {
                    graphics.drawOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                }
                if (n4 == 0 || n4 == 1) {
                    graphics.drawLine(n2, n3, n2, n3);
                }
            }
        }
    }

    private void do(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        Color color2 = this.chart.getChartBackground();
        if (this.display3dOn) {
            int n6 = this.depth3dPoint.x;
            int n7 = this.depth3dPoint.y;
            if (this.chart.getLine3DLayout() == 0) {
                n6 = this.depth3dPoint.x / this.getSeriesCount();
                n7 = this.depth3dPoint.y / this.getSeriesCount();
            }
            n6 = (int)((double)n6 * this.chart.getLine3DDepth(n));
            n7 = (int)((double)n7 * this.chart.getLine3DDepth(n));
            int[] nArray = new int[4];
            nArray[0] = nArray[3] = n2 - n4 / 2;
            nArray[1] = nArray[2] = n2 + n4 / 2;
            int[] nArray2 = new int[4];
            nArray2[0] = nArray2[1] = n3 - n4 / 2;
            nArray2[2] = nArray2[3] = n3 + n4 / 2;
            int[] nArray3 = new int[4];
            int[] nArray4 = new int[4];
            for (int i = 0; i < nArray3.length; ++i) {
                nArray3[i] = nArray[i] + n6;
                nArray4[i] = nArray2[i] + n7;
            }
            Polygon polygon = new Polygon();
            polygon.addPoint(nArray[0], nArray2[0]);
            polygon.addPoint(nArray[1], nArray2[1]);
            polygon.addPoint(nArray3[1], nArray4[1]);
            polygon.addPoint(nArray3[0], nArray4[0]);
            Polygon polygon2 = new Polygon();
            polygon2.addPoint(nArray[1], nArray2[1]);
            polygon2.addPoint(nArray[2], nArray2[2]);
            polygon2.addPoint(nArray3[2], nArray4[2]);
            polygon2.addPoint(nArray3[1], nArray4[1]);
            Color color3 = color;
            Color color4 = LineChartRenderer.getDarker(color);
            if (bl) {
                color3 = LineChartRenderer.getDarker(color);
                color4 = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            }
            if (n5 != 5) {
                color3 = color2;
            }
            graphics.setColor(color3);
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.fillPolygon(polygon);
            graphics.fillPolygon(polygon2);
            graphics.setColor(color4);
            graphics.drawPolygon(nArray, nArray2, 4);
            graphics.drawLine(nArray[0], nArray2[0], nArray3[0], nArray4[0]);
            graphics.drawLine(nArray[1], nArray2[1], nArray3[1], nArray4[1]);
            graphics.drawLine(nArray[2], nArray2[2], nArray3[2], nArray4[2]);
            graphics.drawLine(nArray3[0], nArray4[0], nArray3[1], nArray4[1]);
            graphics.drawLine(nArray3[1], nArray4[1], nArray3[2], nArray4[2]);
        } else {
            if (n5 == 3) {
                graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
            } else if (n5 == 5) {
                graphics.fillRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                graphics.setColor(LineChartRenderer.getDarker(color));
                graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
            } else if (n5 == 4) {
                graphics.setColor(color2);
                graphics.fillRect(n2 - n4 / 2, n3 - n4 / 2, n4 + 1, n4 + 1);
                graphics.setColor(color);
                graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
            }
            if (bl) {
                graphics.setColor(LineChartRenderer.getDarker(LineChartRenderer.getDarker(color)));
                graphics.drawRect(n2 - n4 / 2 - 1, n3 - n4 / 2 - 1, n4 + 2, n4 + 2);
            }
        }
    }

    private void a(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        Color color2 = this.chart.getChartBackground();
        int[] nArray = new int[4];
        nArray[0] = nArray[2] = n2;
        nArray[1] = n2 + n4 / 2;
        nArray[3] = n2 - n4 / 2;
        int[] nArray2 = new int[4];
        nArray2[0] = n3 - n4 / 2;
        nArray2[2] = n3 + n4 / 2;
        nArray2[1] = nArray2[3] = n3;
        if (this.display3dOn) {
            int n6 = this.depth3dPoint.x;
            int n7 = this.depth3dPoint.y;
            if (this.chart.getLine3DLayout() == 0 && !this.y) {
                n6 = this.depth3dPoint.x / this.getSeriesCount();
                n7 = this.depth3dPoint.y / this.getSeriesCount();
            }
            n6 = (int)((double)n6 * this.chart.getLine3DDepth(n));
            n7 = (int)((double)n7 * this.chart.getLine3DDepth(n));
            int[] nArray3 = new int[4];
            int[] nArray4 = new int[4];
            for (int i = 0; i < nArray3.length; ++i) {
                nArray3[i] = nArray[i] + n6;
                nArray4[i] = nArray2[i] + n7;
            }
            Polygon polygon = new Polygon();
            polygon.addPoint(nArray[0], nArray2[0]);
            polygon.addPoint(nArray[1], nArray2[1]);
            polygon.addPoint(nArray3[1], nArray4[1]);
            polygon.addPoint(nArray3[0], nArray4[0]);
            Polygon polygon2 = new Polygon();
            polygon2.addPoint(nArray[1], nArray2[1]);
            polygon2.addPoint(nArray[2], nArray2[2]);
            polygon2.addPoint(nArray3[2], nArray4[2]);
            polygon2.addPoint(nArray3[1], nArray4[1]);
            Color color3 = color;
            Color color4 = LineChartRenderer.getDarker(color);
            if (bl) {
                color3 = LineChartRenderer.getDarker(color);
                color4 = LineChartRenderer.getDarker(LineChartRenderer.getDarker(color));
            }
            if (n5 != 8) {
                color3 = color2;
            }
            graphics.setColor(color3);
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.fillPolygon(polygon);
            graphics.fillPolygon(polygon2);
            graphics.setColor(color4);
            graphics.drawPolygon(nArray, nArray2, 4);
            graphics.drawLine(nArray[0], nArray2[0], nArray3[0], nArray4[0]);
            graphics.drawLine(nArray[1], nArray2[1], nArray3[1], nArray4[1]);
            graphics.drawLine(nArray[2], nArray2[2], nArray3[2], nArray4[2]);
            graphics.drawLine(nArray3[0], nArray4[0], nArray3[1], nArray4[1]);
            graphics.drawLine(nArray3[1], nArray4[1], nArray3[2], nArray4[2]);
        } else {
            if (n5 == 7) {
                graphics.setColor(color2);
                graphics.fillPolygon(nArray, nArray2, 4);
            } else if (n5 == 8) {
                graphics.setColor(color);
                graphics.fillPolygon(nArray, nArray2, 4);
                graphics.setColor(LineChartRenderer.getDarker(color));
            }
            graphics.setColor(color);
            graphics.drawPolygon(nArray, nArray2, 4);
            if (bl) {
                nArray[1] = nArray[1] + 1;
                nArray[3] = nArray[3] - 1;
                nArray2[0] = nArray2[0] - 1;
                nArray2[2] = nArray2[2] + 1;
                graphics.setColor(LineChartRenderer.getDarker(LineChartRenderer.getDarker(color)));
                graphics.drawPolygon(nArray, nArray2, 4);
            }
        }
    }

    protected boolean isAnyFloatingLabelsOn(int n) {
        int n2 = this.chart.getValueLabelStyle();
        int n3 = this.chart.getSampleLabelStyle();
        int n4 = this.chart.getSeriesLabelStyle();
        boolean bl = this.chart.isValueLabelsOn(n);
        boolean bl2 = this.chart.isSampleLabelsOn();
        boolean bl3 = this.chart.isSeriesLabelsOn();
        boolean bl4 = bl && n2 == 3;
        bl4 |= bl2 && (n3 == 3 || n3 == 4);
        return bl4 |= bl3 && n4 == 3;
    }

    protected boolean isAnyBelowLabelsOn() {
        int n = this.chart.getSampleLabelStyle();
        boolean bl = this.chart.isSampleLabelsOn();
        boolean bl2 = bl && (n == 2 || n == 4);
        return bl2;
    }
}

