/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import com.eg.TomcatConfig;
import com.eg.UpdateDbConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class SetupConfig
extends EgConfigInfo {
    String egConfigFile = egMgrConfigDir + egSetupFile;
    String egServiceFile = egMgrConfigDir + egServicesConfigFile;
    IniFile configFile;
    String tomcatPort;
    String shutDownPort;
    String ramSize;
    String serverName;
    String userName;
    String groupName;
    String serverPort;
    String isSsl;
    Process process = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(egMgrErrorFile, true));
            System.setOut(printStream);
            System.setErr(printStream);
            System.out.println("==============SetupConfig starts==============");
            if (stringArray.length < 5) {
                System.out.println("Usage : java SetupConfig -egurkhaPath <egurkhaPath>  -javaPath <javaPath> ");
                return;
            }
            SetupConfig setupConfig = new SetupConfig();
            boolean bl = setupConfig.isFileExist();
            if (!bl) {
                return;
            }
            setupConfig.execute(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (printStream != null) {
                System.out.println("==============SetupConfig ends==============");
                printStream.close();
            }
        }
    }

    public void execute(String[] stringArray) {
        this.getData();
        String string = stringArray[1];
        String string2 = stringArray[3];
        String string3 = stringArray[4];
        string3 = string3.trim();
        TomcatConfig tomcatConfig = new TomcatConfig(string, string2, this.tomcatPort, this.shutDownPort, this.ramSize, string3, this.isSsl);
        tomcatConfig.execute(string3);
        UpdateDbConfig updateDbConfig = new UpdateDbConfig();
        updateDbConfig.execute();
    }

    public boolean isFileExist() {
        File file = new File(this.egConfigFile);
        if (!file.exists()) {
            String string = this.egConfigFile + "  Not Found ";
            this.logToErrorFile("Manager SetUp:", string);
            return false;
        }
        return true;
    }

    public SetupConfig() {
        super("manager");
    }

    public void getData() {
        String string;
        this.configFile = new IniFile(this.egConfigFile);
        this.serverName = this.configFile.getValue("SETTINGS", "EG_SERVER");
        this.tomcatPort = this.configFile.getValue("TOMCAT_SETTINGS", "tomcatPort");
        this.isSsl = this.configFile.getValue("TOMCAT_SETTINGS", "isSsl");
        this.shutDownPort = this.configFile.getValue("TOMCAT_SETTINGS", "shutDownPort");
        this.ramSize = this.configFile.getValue("TOMCAT_SETTINGS", "ramSize");
        this.configFile = new IniFile(this.egServiceFile, true);
        String string2 = this.configFile.getValue("MISC_ARGS", "ManagerOS");
        if ((string2 == null || string2.length() == 0) && (string = System.getProperty("os.name")) != null && string.length() > 0) {
            if ((string = string.toLowerCase()).indexOf("win") > -1) {
                this.configFile.setValue("MISC_ARGS", "ManagerOS", "WINDOWS");
            } else if (string.indexOf("sol") > -1) {
                this.configFile.setValue("MISC_ARGS", "ManagerOS", "SOLARIS");
            } else {
                this.configFile.setValue("MISC_ARGS", "ManagerOS", "LINUX");
            }
            this.configFile.saveFile();
        }
        this.configFile = null;
    }
}

