/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Hashtable;

public class GwIaDiscoveryHelperThread
extends Thread {
    private String hostIp;
    private int portNo;
    public Socket sd;
    private BufferedReader br;
    public int timeOut;
    public boolean status;
    public boolean done;
    public boolean isGwIa = false;
    public long start = 0L;
    public static long maxFailTime = 900000L;
    public static Hashtable failList = new Hashtable();

    public GwIaDiscoveryHelperThread(String string, int n, int n2) {
        this.hostIp = string;
        this.portNo = n;
        this.timeOut = (int)((double)n2 * 0.9);
        this.setName("GwIaDiscoveryHelperThread");
        this.start();
    }

    @Override
    public void run() {
        if (EgConfigInfo.todie) {
            return;
        }
        this.start = System.currentTimeMillis();
        String string = this.hostIp + ":" + this.portNo;
        Long l = (Long)failList.get(string);
        if (l != null) {
            long l2 = this.start;
            long l3 = l;
            if (l2 - l3 <= maxFailTime) {
                this.sd = null;
                this.done = true;
                return;
            }
            failList.remove(string);
        }
        try {
            this.sd = new Socket();
            int n = this.timeOut / 4;
            if (n < 400) {
                n = 400;
            }
            this.sd.connect(new InetSocketAddress(this.hostIp, this.portNo), n);
            this.sd.setSoTimeout(this.timeOut);
            failList.remove(this.hostIp + ":" + this.portNo);
        }
        catch (Exception exception) {
            failList.put(this.hostIp + ":" + this.portNo, new Long(System.currentTimeMillis()));
            this.status = false;
            this.done = true;
            this.cleanup();
            return;
        }
        this.status = true;
        try {
            this.br = new BufferedReader(new InputStreamReader(this.sd.getInputStream()));
            String string2 = null;
            if (this.br != null) {
                string2 = this.br.readLine();
            }
            if (string2 != null && string2.indexOf("GroupWise Internet Agent") >= 0) {
                this.isGwIa = true;
            }
            this.done = true;
            this.cleanup();
        }
        catch (Exception exception) {
            this.status = false;
            this.done = true;
            this.cleanup();
        }
    }

    public void cleanup() {
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.sd != null) {
                this.sd.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

