/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import java.util.StringTokenizer;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DbDirectory;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.RichTextItem;
import lotus.domino.Session;

public class EgDominoMailAgent
extends Thread {
    public static final int DEFAULT_PORT = 63148;
    private int port = 63148;
    private String host;
    private String user;
    private String pwd;
    private Vector toIds;
    private Vector ccIds;
    private Vector bcIds;
    private String subject;
    private String message;
    private boolean mailSend = false;
    private String error_message;
    public static final String EG_SUCCESS_MAIL = "Successfully mailed";
    public static final String EG_FAILIURE_SERVER = "Failed to mail:DIIOP task or the Domino server was not running";
    public static final String EG_FAILIURE_MAIL = "Failed to mail";
    public static final String EG_INVALID_AUTHENTICATION = "Invalid authenticaion parameters";
    public static final String EG_INVALID_RECEPIENTS = "Recepient name invalid or empty";
    public static final String EG_INVALID_SUBJECT = "Subject invalid or empty";
    public static final String EG_INVALID_MESSAGE = "Message invalid or empty";
    private static final String SEND_TO = "SendTo";
    private static final String COPY_TO = "CopyTo";
    private static final String BLIND_COPY_TO = "BlindCopyTo";
    private static final String MAIL_SUBJECT = "Subject";
    private static final String MAIL_BODY = "Body";

    public EgDominoMailAgent() {
        this.setName("EgDominoMailAgent");
        this.setDaemon(true);
        this.reinitializeAll();
    }

    public boolean sendMail(String string, String string2, String string3, int n, Vector vector, Vector vector2, Vector vector3, String string4, String string5) {
        this.reinitializeAll();
        if (string != null && string2 != null && string3 != null) {
            if (vector == null || vector.size() == 0) {
                this.writeErrorLog(EG_INVALID_RECEPIENTS);
                return false;
            }
            if (string4 == null || string4.trim().length() == 0) {
                this.writeErrorLog(EG_INVALID_SUBJECT);
                return false;
            }
            if (string5 == null || string5.trim().length() == 0) {
                this.writeErrorLog(EG_INVALID_MESSAGE);
                return false;
            }
            if (vector2 != null && vector2.size() > 0) {
                this.ccIds = vector2;
            }
            if (vector3 != null && vector3.size() > 0) {
                this.bcIds = vector3;
            }
            this.host = string3;
            if (n > 0) {
                this.port = n;
            }
            this.user = string;
            this.pwd = string2;
            this.host = this.host + ":" + this.port;
            this.toIds = vector;
            this.subject = string4;
            this.message = string5;
            this.setDaemon(true);
            this.start();
            try {
                this.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.mailSend;
        }
        this.writeErrorLog(EG_INVALID_AUTHENTICATION);
        return false;
    }

    private void reinitializeAll() {
        this.host = null;
        this.port = 63148;
        this.user = null;
        this.pwd = null;
        this.toIds = null;
        this.ccIds = null;
        this.bcIds = null;
        this.subject = null;
        this.message = null;
        this.mailSend = false;
        this.error_message = null;
    }

    @Override
    public void run() {
        if (EgConfigInfo.todie) {
            return;
        }
        if (this.user != null && this.pwd != null && this.host != null) {
            try {
                Session session = NotesFactory.createSession((String)this.host, (String)this.user, (String)this.pwd);
                DbDirectory dbDirectory = session.getDbDirectory(null);
                Database database = dbDirectory.openMailDatabase();
                Document document = database.createDocument();
                document.replaceItemValue(SEND_TO, (Object)this.toIds);
                if (this.ccIds != null && this.ccIds.size() > 0) {
                    document.replaceItemValue(COPY_TO, (Object)this.ccIds);
                }
                if (this.bcIds != null && this.bcIds.size() > 0) {
                    document.replaceItemValue(BLIND_COPY_TO, (Object)this.bcIds);
                }
                document.replaceItemValue(MAIL_SUBJECT, (Object)this.subject);
                RichTextItem richTextItem = document.createRichTextItem(MAIL_BODY);
                this.fillMessage(richTextItem, this.message);
                document.send();
                System.out.println("domino mail sent successfully..........");
                this.writeErrorLog(EG_SUCCESS_MAIL);
                this.mailSend = true;
            }
            catch (NotesException notesException) {
                notesException.printStackTrace();
                this.writeErrorLog(EG_FAILIURE_SERVER);
                this.mailSend = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.writeErrorLog(EG_FAILIURE_MAIL);
                this.mailSend = false;
            }
        }
    }

    private void fillMessage(RichTextItem richTextItem, String string) throws NotesException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\t");
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                richTextItem.appendText(string3);
                richTextItem.addTab();
            }
            richTextItem.addNewLine();
        }
    }

    private void writeErrorLog(String string) {
        this.error_message = string;
    }

    public String getErrorMessage() {
        return this.error_message;
    }

    public static void main(String[] stringArray) {
        EgDominoMailAgent egDominoMailAgent = new EgDominoMailAgent();
        Vector<String> vector = new Vector<String>(2);
        vector.addElement("Gopikannan M");
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        boolean bl = egDominoMailAgent.sendMail("Lotus Admin/EGI", "password", "192.168.10.35", 63148, vector, vector2, vector3, "eG Alert", "Hai all\r\t\tWelcome to egInnovations We \talways\tmonitor\t<b>you</b>");
        System.out.println("Mail status :" + bl);
        System.out.println(egDominoMailAgent.getErrorMessage());
    }
}

