/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.APMHashingMsmtUpdater;
import com.eg.EgAPMInfo;
import com.eg.EgInstallInfo;
import com.eg.apm.APMManagerConfigUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class APMSessionUserMapping
extends Thread {
    private final HashMap SESSION_USER_MAPPING = new HashMap();
    private final HashMap LAST_ACCESSED_TIME = new HashMap();
    private static long max_time_cleanup = 1800000L;
    private static long max_time_apm_cleanup = 900000L;
    private static long max_time_write = 360000L;
    private static long max_sleep_time = 30000L;
    private static final String THREAD_NAME = "APM Misc. Activity";
    private static final String APM_USERNAME_CONFIG = "APM_USERNAME_CONFIG";
    private final String mappingFileName = "btmmap.ser";
    private final String btmHashingFileName = "btmHashingTime.ser";
    private long lastCleanup = -1L;
    private long lastApmCleanup = -1L;
    private long lastWrite = -1L;
    private static EgAPMInfo apmInfo = new EgAPMInfo("manager");
    private static final String exnHashSync = new String("EXN_HASH");
    private static final String queryHashSync = new String("QUERY_HASH");
    private static final String stackHashSync = new String("STACK_HASH");
    private static final String BTM_SQL_QUERIES = "BTM_SQL_QUERIES";
    private static final String BTM_EXN_STACKTRACE = "BTM_EXN_STACKTRACE";
    private static final String BTM_EXN_MASTER = "BTM_EXN_MASTER";
    private final HashSet QUERY_HASH = new HashSet();
    private final HashSet STACK_HASH = new HashSet();
    private final HashSet EXN_HASH = new HashSet();
    private static long max_limit = 50000L;
    private static long hashInsertTime = -1L;
    private static long hash_update_interval = 43200000L;
    private static final APMSessionUserMapping USER_MAPPING_INSTANCE = new APMSessionUserMapping();

    private APMSessionUserMapping() {
        this.setName(THREAD_NAME);
        this.setDaemon(true);
        this.start();
    }

    public static APMSessionUserMapping getInstance() {
        return USER_MAPPING_INSTANCE;
    }

    @Override
    public void run() {
        long l = System.currentTimeMillis();
        if (this.lastCleanup < 0L) {
            this.lastCleanup = l;
        }
        if (this.lastApmCleanup < 0L) {
            this.lastApmCleanup = l;
        }
        if (this.lastWrite < 0L) {
            this.lastWrite = l;
        }
        String string = EgInstallInfo.getInstallDir() + "/manager/.btmhash";
        hashInsertTime = this.findLastHashInsertTime(string);
        boolean bl = false;
        max_limit = apmInfo.getHashingBoundaryLimit();
        hash_update_interval = apmInfo.getHashingUpdateInterval();
        while (true) {
            long l2;
            long l3;
            max_sleep_time = apmInfo.getThreadSleepPeriod();
            try {
                Thread.sleep(max_sleep_time);
            }
            catch (Exception exception) {
                // empty catch block
            }
            l = System.currentTimeMillis();
            max_time_apm_cleanup = apmInfo.getApmConfigSendToCleanupPeriod();
            long l4 = l - this.lastApmCleanup;
            if (l4 >= max_time_apm_cleanup) {
                this.lastApmCleanup = l;
                APMManagerConfigUtils.getInstance().apmConfigSendToCleanUp();
            }
            if ((l3 = l - this.lastCleanup) >= (max_time_cleanup = apmInfo.getSessionDetailsCleanupPeriod())) {
                this.cleanUpSessions(l, max_time_cleanup);
                this.lastCleanup = l;
                if (!bl) {
                    this.updateMsmtOnDB();
                    this.updateLastHashInsertTime(l, string);
                    hashInsertTime = l;
                    bl = true;
                } else {
                    hashInsertTime = this.findLastHashInsertTime(string);
                    l2 = l - hashInsertTime;
                    max_limit = apmInfo.getHashingBoundaryLimit();
                    hash_update_interval = apmInfo.getHashingUpdateInterval();
                    if (l2 >= hash_update_interval) {
                        this.updateMsmtOnDB();
                        this.updateLastHashInsertTime(l, string);
                        hashInsertTime = l;
                    }
                }
            }
            if (this.SESSION_USER_MAPPING.size() == 0 || (l2 = l - this.lastWrite) < (max_time_write = apmInfo.getSessionDetailsWriteFrequency())) continue;
            this.writeOnDisk();
            this.lastWrite = l;
        }
    }

    public void getSessionDetailsFromDisk() {
        Object e;
        HashMap hashMap;
        ArrayList arrayList = this.getDetailsFromDisk("btmmap.ser", 1);
        if (arrayList != null && arrayList.size() == 1 && (hashMap = (HashMap)(e = arrayList.get(0))) != null && hashMap.size() > 0) {
            Set set = hashMap.keySet();
            for (String string : set) {
                String string2 = (String)hashMap.get(string);
                if (string == null || string2 == null) continue;
                this.SESSION_USER_MAPPING.put(string, string2);
                long l = System.currentTimeMillis();
                Long l2 = new Long(l);
                this.LAST_ACCESSED_TIME.put(string, l2);
            }
        }
        System.out.println("APM SessionId User Mapping details from Disk :" + this.SESSION_USER_MAPPING);
    }

    public void writeOnDisk() {
        if (this.SESSION_USER_MAPPING.isEmpty()) {
            return;
        }
        ArrayList<HashMap> arrayList = new ArrayList<HashMap>();
        arrayList.add(this.SESSION_USER_MAPPING);
        this.writeDetailsOnDisk("btmmap.ser", arrayList, "btm session details");
    }

    public void cleanUpSessions(long l, long l2) {
        if (this.LAST_ACCESSED_TIME.size() > 0) {
            Set set = this.LAST_ACCESSED_TIME.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Long l3 = (Long)this.LAST_ACCESSED_TIME.get(string);
                long l4 = l3;
                long l5 = l - l4;
                if (l5 < l2) continue;
                try {
                    this.SESSION_USER_MAPPING.remove(string);
                    iterator.remove();
                    System.out.println("Successfully cleaned unused APM Session details " + string + " @ " + new Date());
                }
                catch (Exception exception) {
                    System.err.println("Problem occured while cleaning unused APM Session details " + string + " @ " + new Date());
                    exception.printStackTrace();
                }
            }
        }
    }

    public String getUserName(String string, String string2, String string3) {
        if (string2.startsWith("-")) {
            return string3;
        }
        String string4 = string + ":" + string2;
        String string5 = (String)this.SESSION_USER_MAPPING.get(string4);
        if (string5 == null) {
            if (string3.equals("-") || string3.equals("null")) {
                return string3;
            }
            this.SESSION_USER_MAPPING.put(string4, string3);
            long l = System.currentTimeMillis();
            Long l2 = new Long(l);
            this.LAST_ACCESSED_TIME.put(string4, l2);
        } else {
            if (string3.equals("-")) {
                string3 = string5;
            } else {
                this.SESSION_USER_MAPPING.put(string4, string3);
            }
            long l = System.currentTimeMillis();
            Long l3 = new Long(l);
            this.LAST_ACCESSED_TIME.put(string4, l3);
        }
        return string3;
    }

    public void printDetails() {
        System.out.println("[APMSessionUserMapping] - SESSION_USER_MAPPING :" + this.SESSION_USER_MAPPING);
    }

    private void updateMsmtOnDB() {
        if (this.QUERY_HASH.size() > 0) {
            this.doQueryHashUpdate();
        }
        if (this.STACK_HASH.size() > 0) {
            this.doStackHashUpdate();
        }
        if (this.EXN_HASH.size() > 0) {
            this.doExceptionHashUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueryHashUpdate() {
        String string = queryHashSync;
        synchronized (string) {
            HashSet hashSet = new HashSet(this.QUERY_HASH);
            this.QUERY_HASH.clear();
            APMHashingMsmtUpdater aPMHashingMsmtUpdater = new APMHashingMsmtUpdater(BTM_SQL_QUERIES, hashSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStackHashUpdate() {
        String string = stackHashSync;
        synchronized (string) {
            HashSet hashSet = new HashSet(this.STACK_HASH);
            this.STACK_HASH.clear();
            APMHashingMsmtUpdater aPMHashingMsmtUpdater = new APMHashingMsmtUpdater(BTM_EXN_STACKTRACE, hashSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExceptionHashUpdate() {
        String string = exnHashSync;
        synchronized (string) {
            HashSet hashSet = new HashSet(this.EXN_HASH);
            this.EXN_HASH.clear();
            APMHashingMsmtUpdater aPMHashingMsmtUpdater = new APMHashingMsmtUpdater(BTM_EXN_MASTER, hashSet);
        }
    }

    public void updateHashDetails(String string, String string2) {
        if (string.equals(BTM_SQL_QUERIES)) {
            this.updateQueryHash(string2);
        } else if (string.equals(BTM_EXN_STACKTRACE)) {
            this.updateStackHash(string2);
        } else if (string.equals(BTM_EXN_MASTER)) {
            this.updateExceptionHash(string2);
        }
    }

    private void updateQueryHash(String string) {
        this.QUERY_HASH.add(string);
        int n = this.QUERY_HASH.size();
        if ((long)n >= max_limit) {
            this.doQueryHashUpdate();
        }
    }

    private void updateStackHash(String string) {
        this.STACK_HASH.add(string);
        int n = this.STACK_HASH.size();
        if ((long)n >= max_limit) {
            this.doStackHashUpdate();
        }
    }

    private void updateExceptionHash(String string) {
        this.EXN_HASH.add(string);
        int n = this.EXN_HASH.size();
        if ((long)n >= max_limit) {
            this.doExceptionHashUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDetailsOnDisk(String string, ArrayList arrayList, String string2) {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        int n = arrayList.size();
        String string3 = EgInstallInfo.getInstallDir() + "/manager/" + string;
        try {
            fileOutputStream = new FileOutputStream(string3);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeObject(arrayList.get(i));
            }
            System.out.println("Successfully stored " + string2 + " on the disk !!! @ " + new Date());
        }
        catch (Exception exception) {
            System.err.println("Problem occured while storing " + string2 + " on the disk !!! @ " + new Date());
            exception.printStackTrace();
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void writeHashingDetailsOnDisk() {
        ArrayList<HashSet> arrayList = new ArrayList<HashSet>();
        arrayList.add(this.QUERY_HASH);
        arrayList.add(this.STACK_HASH);
        arrayList.add(this.EXN_HASH);
        this.writeDetailsOnDisk("btmHashingTime.ser", arrayList, "btm hashing details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getDetailsFromDisk(String string, int n) {
        Object object;
        String string2 = EgInstallInfo.getInstallDir() + "/manager/" + string;
        boolean bl = false;
        try {
            object = new File(string2);
            if (((File)object).exists()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!bl) {
            return null;
        }
        object = null;
        ObjectInputStream objectInputStream = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            object = new FileInputStream(string2);
            objectInputStream = new ObjectInputStream((InputStream)object);
            for (int i = 0; i < n; ++i) {
                Object object2 = objectInputStream.readObject();
                arrayList.add(object2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (object != null) {
                    ((FileInputStream)object).close();
                }
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    public void getHashingDetailsFromDisk() {
        ArrayList arrayList = this.getDetailsFromDisk("btmHashingTime.ser", 3);
        if (arrayList != null && arrayList.size() == 3) {
            HashSet hashSet;
            Object e = arrayList.get(0);
            Object e2 = arrayList.get(1);
            Object e3 = arrayList.get(2);
            if (e != null) {
                hashSet = (HashSet)e;
                for (Object e4 : hashSet) {
                    this.QUERY_HASH.add(e4);
                }
            }
            if (e2 != null) {
                hashSet = (HashSet)e2;
                for (Object e4 : hashSet) {
                    this.STACK_HASH.add(e4);
                }
            }
            if (e3 != null) {
                hashSet = (HashSet)e3;
                for (Object e4 : hashSet) {
                    this.EXN_HASH.add(e4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastHashInsertTime(long l, String string) {
        BufferedWriter bufferedWriter = null;
        try {
            File file = new File(string);
            bufferedWriter = new BufferedWriter(new FileWriter(file, false));
            bufferedWriter.write("" + l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findLastHashInsertTime(String string) {
        BufferedReader bufferedReader = null;
        long l = -1L;
        try {
            String string2;
            File file = new File(string);
            if (file != null && file.exists() && (string2 = (bufferedReader = new BufferedReader(new FileReader(string))).readLine()) != null) {
                if (string2.equals("")) {
                    l = -1L;
                } else {
                    try {
                        l = Long.parseLong(string2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return l;
    }
}

