/*
 * Decompiled with CFR 0.152.
 */
package com.eg.rum.ch.qos.logback.classic.layout;

import com.eg.rum.ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import com.eg.rum.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.rum.ch.qos.logback.classic.spi.IThrowableProxy;
import com.eg.rum.ch.qos.logback.core.CoreConstants;
import com.eg.rum.ch.qos.logback.core.LayoutBase;
import com.eg.rum.ch.qos.logback.core.util.CachingDateFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTLLLayout
extends LayoutBase<ILoggingEvent> {
    CachingDateFormatter cachingDateFormatter = new CachingDateFormatter("HH:mm:ss.SSS");
    ThrowableProxyConverter tpc = new ThrowableProxyConverter();

    @Override
    public void start() {
        this.tpc.start();
        super.start();
    }

    @Override
    public String doLayout(ILoggingEvent event) {
        if (!this.isStarted()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        long timestamp = event.getTimeStamp();
        sb.append(this.cachingDateFormatter.format(timestamp));
        sb.append(" [");
        sb.append(event.getThreadName());
        sb.append("] ");
        sb.append(event.getLevel().toString());
        sb.append(" ");
        sb.append(event.getLoggerName());
        sb.append(" - ");
        sb.append(event.getFormattedMessage());
        sb.append(CoreConstants.LINE_SEPARATOR);
        IThrowableProxy tp = event.getThrowableProxy();
        if (tp != null) {
            String stackTrace = this.tpc.convert(event);
            sb.append(stackTrace);
        }
        return sb.toString();
    }
}

