/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import java.util.ArrayList;

final class Utils {
    private Utils() {
    }

    static double[] GaussElimination(double[][] a) {
        int n = a.length;
        return Utils.GaussElimination(n, a);
    }

    static double[] GaussElimination(int n, double[][] a) {
        int k = 0;
        while (k < n - 1) {
            int i = k + 1;
            while (i < n) {
                double qt = a[i][k] / a[k][k];
                int j = k + 1;
                while (j < n + 1) {
                    double[] dArray = a[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - qt * a[k][j];
                    ++j;
                }
                a[i][k] = 0.0;
                ++i;
            }
            ++k;
        }
        double[] x = new double[n];
        x[n - 1] = a[n - 1][n] / a[n - 1][n - 1];
        int k2 = n - 2;
        while (k2 >= 0) {
            double sum = 0.0;
            int j = k2 + 1;
            while (j < n) {
                sum += a[k2][j] * x[j];
                ++j;
            }
            x[k2] = (a[k2][n] - sum) / a[k2][k2];
            --k2;
        }
        return x;
    }

    static double[] calculateSeasonalIndices(double[] observation, int seasonalCycle) {
        int numberOfCycles = observation.length / seasonalCycle;
        if (numberOfCycles < 2) {
            throw new IllegalArgumentException("Too few observations. Need at least " + seasonalCycle * 2 + " observations - preferably more - to calculate the seasonal indices");
        }
        if (seasonalCycle % 2 != 0) {
            throw new IllegalArgumentException("seasonalCycle must be even - for now at least");
        }
        if (observation.length % seasonalCycle > 0) {
            ++numberOfCycles;
        }
        double[] seasonalIndex = new double[seasonalCycle];
        ArrayList<Double> ratioToMovingAverage = new ArrayList<Double>(observation.length);
        double movingTotal = 0.0;
        int t = 0;
        while (t < seasonalCycle) {
            movingTotal += observation[t];
            ratioToMovingAverage.add(t, null);
            ++t;
        }
        int numberOfObservations = observation.length;
        int t2 = seasonalCycle;
        while (t2 < numberOfObservations) {
            double movingAverage = movingTotal / (double)(seasonalCycle * 2);
            movingTotal -= observation[t2 - seasonalCycle];
            int period = t2 - (seasonalCycle + 1) / 2;
            ratioToMovingAverage.add(period, new Double(observation[period] / (movingAverage += (movingTotal += observation[t2]) / (double)(seasonalCycle * 2))));
            ++t2;
        }
        boolean dropOutliers = numberOfCycles > 4;
        double sumIndices = 0.0;
        int season = 0;
        while (season < seasonalCycle) {
            int count = 0;
            double sum = 0.0;
            double minIndex = Double.POSITIVE_INFINITY;
            double maxIndex = Double.NEGATIVE_INFINITY;
            int cycle = 0;
            while (cycle < numberOfCycles) {
                int t3 = season + cycle * seasonalCycle;
                if (ratioToMovingAverage.get(t3) != null) {
                    double currentIndex = (Double)ratioToMovingAverage.get(t3);
                    if (dropOutliers) {
                        if (currentIndex < minIndex) {
                            minIndex = currentIndex;
                        }
                        if (currentIndex > maxIndex) {
                            maxIndex = currentIndex;
                        }
                    }
                    sum += currentIndex;
                    ++count;
                }
                ++cycle;
            }
            if (dropOutliers) {
                sum -= minIndex;
                --count;
                sum -= maxIndex;
                --count;
            }
            seasonalIndex[season] = sum / (double)count;
            sumIndices += seasonalIndex[season];
            ++season;
        }
        int season2 = 0;
        while (season2 < seasonalCycle) {
            int n = season2++;
            seasonalIndex[n] = seasonalIndex[n] * ((double)seasonalCycle / sumIndices);
        }
        return seasonalIndex;
    }
}

