/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import java.util.Iterator;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.models.AbstractForecastingModel;
import net.sourceforge.openforecast.models.ModelNotInitializedException;

public abstract class AbstractTimeBasedModel
extends AbstractForecastingModel {
    private String timeVariable = null;
    private double timeDiff = 0.0;
    private int minPeriods = 0;
    private DataSet observedValues;
    private DataSet forecastValues;
    private double minTimeValue;
    private double maxTimeValue;

    public AbstractTimeBasedModel() {
    }

    public AbstractTimeBasedModel(String timeVariable) {
        this.timeVariable = timeVariable;
    }

    protected abstract int getNumberOfPeriods();

    public void init(DataSet dataSet) {
        this.initTimeVariable(dataSet);
        if (dataSet == null || dataSet.size() == 0) {
            throw new IllegalArgumentException("Data set cannot be empty in call to init.");
        }
        int minPeriods = this.getNumberOfPeriods();
        if (dataSet.size() < minPeriods) {
            throw new IllegalArgumentException("Data set too small. Need " + minPeriods + " data points, but only " + dataSet.size() + " passed to init.");
        }
        this.observedValues = new DataSet(dataSet);
        this.observedValues.sort(this.timeVariable);
        Iterator it = this.observedValues.iterator();
        DataPoint dp = (DataPoint)it.next();
        double lastValue = dp.getIndependentValue(this.timeVariable);
        dp = (DataPoint)it.next();
        double currentValue = dp.getIndependentValue(this.timeVariable);
        this.forecastValues = new DataSet();
        this.timeDiff = currentValue - lastValue;
        this.minTimeValue = lastValue;
        while (it.hasNext()) {
            lastValue = currentValue;
            dp = (DataPoint)it.next();
            currentValue = dp.getIndependentValue(this.timeVariable);
            double diff = currentValue - lastValue;
            if (Math.abs(this.timeDiff - diff) > AbstractForecastingModel.TOLERANCE) {
                throw new IllegalArgumentException("Inconsistent intervals found in time series, using variable '" + this.timeVariable + "'");
            }
            try {
                this.initForecastValue(currentValue);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        DataSet testDataSet = new DataSet(this.observedValues);
        int count = 0;
        while (count++ < minPeriods) {
            testDataSet.remove(testDataSet.iterator().next());
        }
        this.calculateAccuracyIndicators(testDataSet);
    }

    protected void initTimeVariable(DataSet dataSet) throws IllegalArgumentException {
        if (this.timeVariable == null) {
            this.timeVariable = dataSet.getTimeVariable();
            if (this.timeVariable == null) {
                String[] independentVars = dataSet.getIndependentVariables();
                if (independentVars.length != 1) {
                    throw new IllegalArgumentException("Unable to determine the independent time variable for the data set passed to init for " + this.toString() + ". Please use DataSet.setTimeVariable before invoking model.init.");
                }
                this.timeVariable = independentVars[0];
            }
        }
    }

    private double initForecastValue(double timeValue) throws IllegalArgumentException {
        double forecast = this.forecast(timeValue);
        Observation dpForecast = new Observation(forecast);
        dpForecast.setIndependentValue(this.timeVariable, timeValue);
        this.forecastValues.add(dpForecast);
        if (timeValue > this.maxTimeValue) {
            this.maxTimeValue = timeValue;
        }
        return forecast;
    }

    public double forecast(DataPoint dataPoint) throws IllegalArgumentException {
        if (!this.initialized) {
            throw new ModelNotInitializedException();
        }
        double t = dataPoint.getIndependentValue(this.timeVariable);
        return this.getForecastValue(t);
    }

    protected abstract double forecast(double var1) throws IllegalArgumentException;

    protected double getForecastValue(double timeValue) throws IllegalArgumentException {
        if (timeValue >= this.minTimeValue - AbstractForecastingModel.TOLERANCE && timeValue <= this.maxTimeValue + AbstractForecastingModel.TOLERANCE) {
            Iterator it = this.forecastValues.iterator();
            while (it.hasNext()) {
                DataPoint dp = (DataPoint)it.next();
                double currentTime = dp.getIndependentValue(this.timeVariable);
                if (!(Math.abs(currentTime - timeValue) < AbstractForecastingModel.TOLERANCE)) continue;
                return dp.getDependentValue();
            }
        }
        try {
            return this.initForecastValue(timeValue);
        }
        catch (IllegalArgumentException idex) {
            throw new IllegalArgumentException("Time value (" + timeValue + ") invalid for Time Based forecasting model. Valid values are in the range " + this.minTimeValue + "-" + this.maxTimeValue + " in increments of " + this.timeDiff + ".");
        }
    }

    protected double getObservedValue(double timeValue) throws IllegalArgumentException {
        Iterator it = this.observedValues.iterator();
        while (it.hasNext()) {
            DataPoint dp = (DataPoint)it.next();
            double currentTime = dp.getIndependentValue(this.timeVariable);
            if (!(Math.abs(currentTime - timeValue) < AbstractForecastingModel.TOLERANCE)) continue;
            return dp.getDependentValue();
        }
        throw new IllegalArgumentException("No observation found for time value, " + this.timeVariable + "=" + timeValue);
    }

    public String getTimeVariable() {
        return this.timeVariable;
    }

    public double getMinimumTimeValue() {
        return this.minTimeValue;
    }

    public double getMaximumTimeValue() {
        return this.maxTimeValue;
    }

    public String getIndependentVariable() {
        return this.timeVariable;
    }

    protected double getTimeInterval() {
        return this.timeDiff;
    }

    public String getForecastType() {
        return "Time Based Model";
    }

    public String toString() {
        return "time based model, spanning " + this.getNumberOfPeriods() + " periods and using a time variable of " + this.timeVariable + ".";
    }
}

