/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast;

import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.openforecast.DataPoint;

public class Observation
implements DataPoint {
    private double dependentValue;
    private Hashtable independentValues;

    public Observation(double dependentValue) {
        this.dependentValue = dependentValue;
        this.independentValues = new Hashtable();
    }

    public Observation(DataPoint dataPoint) {
        this.dependentValue = dataPoint.getDependentValue();
        String[] varNames = dataPoint.getIndependentVariableNames();
        int numberOfVars = varNames.length;
        this.independentValues = new Hashtable(numberOfVars);
        int dp = 0;
        while (dp < numberOfVars) {
            this.independentValues.put(varNames[dp], new Double(dataPoint.getIndependentValue(varNames[dp])));
            ++dp;
        }
    }

    public void setDependentValue(double value) {
        this.dependentValue = value;
    }

    public double getDependentValue() {
        return this.dependentValue;
    }

    public void setIndependentValue(String name, double value) {
        this.independentValues.put(name, new Double(value));
    }

    public double getIndependentValue(String name) {
        Double value = (Double)this.independentValues.get(name);
        if (null == value) {
            throw new IllegalArgumentException("The independent variable " + name + " is not defined for the current Observation. The current Observation is as follows: " + this.toString());
        }
        return value;
    }

    public String[] getIndependentVariableNames() {
        String[] varNames = new String[this.independentValues.size()];
        Enumeration keys = this.independentValues.keys();
        int index = 0;
        while (keys.hasMoreElements()) {
            varNames[index] = (String)keys.nextElement();
            ++index;
        }
        return varNames;
    }

    public boolean equals(DataPoint dp) {
        String[] dpVars;
        if (this.dependentValue != dp.getDependentValue()) {
            return false;
        }
        String[] vars = this.getIndependentVariableNames();
        if (vars.length != (dpVars = this.getIndependentVariableNames()).length) {
            return false;
        }
        int v = 0;
        while (v < vars.length) {
            double dpValue;
            double thisValue = ((Number)this.independentValues.get(vars[v])).doubleValue();
            if (thisValue != (dpValue = dp.getIndependentValue(vars[v]))) {
                return false;
            }
            ++v;
        }
        return true;
    }

    public String toString() {
        String result = "(";
        Enumeration e = this.independentValues.keys();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            String key = obj.toString();
            String value = this.independentValues.get(obj).toString();
            result = result + key + "=" + value + ",";
        }
        return result + "dependentValue=" + this.dependentValue + ")";
    }
}

