/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartRenderer;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.Grid;
import com.objectplanet.chart.LineChartRenderer;
import com.objectplanet.chart.Renderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BarChartRenderer
extends ChartRenderer {
    private static final int aM = 0;
    private static final int aL = 1;
    private static final int aJ = 2;
    private int aO;
    private double aK;
    private Rectangle[][] aI;
    private int aN;
    BarChart chart;

    public BarChartRenderer(BarChart barChart) {
        super(barChart);
        this.chart = barChart;
        this.legend = barChart.legend;
        this.gridRenderer = barChart.gridRenderer;
        this.legendRenderer = barChart.legendRenderer;
    }

    public ChartSample checkSelection(Point point) {
        int n;
        int n2;
        int n3;
        if (point == null) {
            return null;
        }
        ChartSample chartSample = super.checkSelection(point);
        int n4 = this.getSeriesCount();
        int n5 = this.getSampleCount();
        boolean bl = false;
        if (chartSample == null && (n3 = this.legendRenderer.getSelectedElement(point, this.legend)) > -1) {
            if (n4 > 1 || this.chart.chartType.equals("line") || this.chart.u) {
                chartSample = new ChartSample(-1);
                chartSample.setSeries(n3);
            } else if (n3 < n5) {
                chartSample = this.chart.getSample(0, n3);
                if (chartSample != null) {
                    chartSample.setSeries(-1);
                }
            } else {
                if (n3 >= n5) {
                    n3 = -1;
                }
                chartSample = this.chart.getSample(0, n3);
            }
            bl = true;
            if (chartSample != null && this.overlayRenderers != null) {
                n2 = this.overlayRenderers.size();
                for (n = n2 - 1; n >= 0; --n) {
                    ChartRenderer chartRenderer = (ChartRenderer)this.overlayRenderers.elementAt(n);
                    if (chartRenderer == null) continue;
                    chartRenderer.ak = chartSample.getIndex();
                    chartRenderer.ab = chartSample.getSeries();
                    if (this.aN == 1) {
                        chartRenderer.aj.x = this.aj.x;
                        chartRenderer.aj.y = -1;
                        continue;
                    }
                    chartRenderer.aj.x = -1;
                    chartRenderer.aj.y = this.aj.y;
                }
            }
        }
        if (chartSample == null && this.aI != null) {
            n3 = Math.min(n5, this.chart.visibleSamples[1]);
            n2 = this.chart.visibleSamples[0];
            n = n2 + n3;
            while (chartSample == null && n3 != 0) {
                int n6 = this.aN == 0 ? n - n3 : n2 + n3 - 1;
                --n3;
                int n7 = n4;
                while (chartSample == null && n7 != 0) {
                    Polygon polygon;
                    boolean bl2;
                    Polygon polygon2;
                    int n8 = this.aO == 1 ? n7 - 1 : (this.aO == 2 ? n4 - n7 : (this.aN == 0 ? n4 - n7 : n7 - 1));
                    --n7;
                    ChartSample chartSample2 = this.chart.getSample(n8, n6);
                    Rectangle rectangle = null;
                    try {
                        rectangle = new Rectangle(this.aI[n8][n6]);
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (rectangle == null) continue;
                    Rectangle rectangle2 = new Rectangle(rectangle);
                    if (this.aO != 1 || n4 <= 1) {
                        if (this.aN == 1 && rectangle2.height < 3) {
                            rectangle2.y -= 3 - rectangle2.height;
                            rectangle2.height = 6;
                        } else if (this.aN == 0 && rectangle2.width < 3) {
                            rectangle2.x -= 3 - rectangle2.width;
                            rectangle2.width = 6;
                        }
                    }
                    if (rectangle2.contains(point)) {
                        chartSample = this.chart.getSample(n8, n6);
                    }
                    if (chartSample != null || !this.display3dOn) continue;
                    double d = this.chart.getRange(0);
                    double d2 = this.chart.getLowerRange(0);
                    boolean bl3 = this.aN != 1 || this.aO != 1 || n8 == 0;
                    bl3 |= d > d2 && this.chart.getSampleValue(n8, n6) > 0.0;
                    if ((bl3 |= d < d2 && this.chart.getSampleValue(n8, n6) < 0.0) && (polygon2 = this.do(rectangle, n8)).contains(point)) {
                        chartSample = chartSample2;
                    }
                    if (!(bl2 = this.aN != 0 || this.aO != 1 || n8 == 0) || !(polygon = this.if(rectangle, n8)).contains(point)) continue;
                    chartSample = chartSample2;
                }
            }
        }
        if (chartSample != null) {
            this.ak = chartSample.getIndex();
            this.ab = chartSample.getSeries();
            this.aj = point;
            if (bl) {
                if (this.aN == 1) {
                    this.aj.y = -1;
                } else {
                    this.aj.x = -1;
                }
            }
        } else {
            this.ak = -1;
            this.ab = -1;
        }
        return chartSample;
    }

    protected void render(Graphics graphics) {
        this.render(graphics, !this.chart.isServletModeOn());
    }

    protected void paintGrid(Graphics graphics, Grid grid, Rectangle rectangle) {
        this.gridRenderer.a(graphics, grid, rectangle);
        if (this.isAnyBelowLabelsOn()) {
            this.if(graphics, rectangle);
        } else {
            for (int i = 0; i < this.overlayRenderers.size(); ++i) {
                ChartRenderer chartRenderer = (ChartRenderer)this.overlayRenderers.elementAt(i);
                if (chartRenderer == null || !(chartRenderer.chart instanceof Chart) || !chartRenderer.isAnyBelowLabelsOn()) continue;
                chartRenderer.if(graphics, rectangle);
                break;
            }
        }
    }

    protected void renderData(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        this.new(graphics, rectangle);
        if (this.display3dOn && this.parentRenderer == null) {
            for (int i = this.chart.getRangeCount() - 1; i >= 0; --i) {
                this.a(graphics, rectangle, i);
            }
        }
        this.int(graphics, rectangle);
    }

    protected void checkDataIntegrity() {
        int n;
        int n2 = this.chart.getSampleCount();
        int n3 = this.chart.getSeriesCount();
        if (n2 == 0 || n3 == 0) {
            return;
        }
        if (this.aI == null || this.aI.length != n3 || this.aI[0].length != n2) {
            Rectangle[][] rectangleArray = new Rectangle[n3][n2];
            for (n = 0; n < n3; ++n) {
                for (int i = 0; i < n2; ++i) {
                    if (this.aI == null || n >= this.aI.length || i >= this.aI[0].length || this.aI[n][i] == null) continue;
                    rectangleArray[n][i] = this.aI[n][i];
                }
            }
            this.aI = rectangleArray;
        }
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n3; ++n) {
                if (this.aI[n][i] != null) continue;
                this.aI[n][i] = new Rectangle();
            }
        }
    }

    protected void calculateChartData(Rectangle rectangle, Rectangle rectangle2) {
        double d;
        if (!this.chart.needChartCalculation && !this.chart.isServletModeOn()) {
            return;
        }
        this.aN = this.chart.getGridAlignment();
        this.aO = this.chart.getBarType();
        this.display3dOn = this.chart.is3DModeOn();
        this.gridRenderer.do(this.chart.a(), rectangle);
        int n = this.getSampleCount();
        int n2 = this.getSeriesCount();
        this.aK = this.chart.getBarWidth();
        double d2 = 0.0;
        double d3 = rectangle2.width;
        if (n > 0 && n2 > 0) {
            d2 = this.aN == 1 ? (double)rectangle2.width / (double)n : (double)rectangle2.height / (double)n;
            d3 = d2 * this.aK;
            if (this.aO == 0) {
                d3 /= (double)n2;
            }
        }
        double d4 = d2 * (1.0 - this.aK);
        if (this.aN == 1) {
            d = (double)rectangle2.x + d4 / 2.0;
            if (this.display3dOn) {
                d -= (double)this.depth3dPoint.x;
            }
        } else {
            d = (double)rectangle2.y + d4 / 2.0;
            if (this.display3dOn) {
                d -= (double)this.depth3dPoint.y;
            }
        }
        if (this.aN == 1) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    double d5;
                    double d6;
                    double d7;
                    double d8;
                    Rectangle rectangle3 = new Rectangle();
                    if (d >= 0.0) {
                        rectangle3.x = (int)(d + 0.5);
                        rectangle3.width = (int)(d3 + 0.5);
                    } else {
                        rectangle3.x = (int)(d - 0.5);
                        rectangle3.width = (int)(d3 - 0.5);
                    }
                    if (d2 < 1.3) {
                        rectangle3.width = d >= 0.0 ? (int)(d + d2 + 0.5) - rectangle3.x : (int)(d + d2 - 0.5) - rectangle3.x;
                    }
                    rectangle3.width = Math.max(1, rectangle3.width);
                    boolean bl = this.aO == 1;
                    int n3 = this.chart.getSeriesRange(j);
                    double d9 = this.chart.getRange(n3);
                    double d10 = this.chart.getLowerRange(n3);
                    double d11 = this.chart.getCurrentRange(n3);
                    double d12 = this.chart.getCurrentLowerRange(n3);
                    int n4 = this.gridRenderer.y[n3];
                    double d13 = this.chart.getSampleValue(j, i);
                    if (d13 >= 0.0) {
                        int n5;
                        int n6;
                        d8 = d9 > d10 ? d13 / d11 * (double)(n4 - rectangle2.y) : d13 / d12 * (double)(rectangle2.y + rectangle2.height - n4);
                        rectangle3.height = (int)(d8 + 0.5);
                        rectangle3.y = n4;
                        if (d9 > d10) {
                            rectangle3.y -= rectangle3.height;
                        }
                        if (bl && j > 0) {
                            double d14 = 0.0;
                            for (int k = 0; k < j; ++k) {
                                double d15 = this.chart.getSampleValue(k, i);
                                if (!(d15 >= 0.0)) continue;
                                d14 += d15;
                            }
                            d7 = d9 > d10 ? d14 / d11 * (double)(n4 - rectangle2.y) : -(d14 / d12) * (double)(rectangle2.y + rectangle2.height - n4);
                            d6 = (double)n4 - d7;
                            if (d9 > d10) {
                                d6 -= d8;
                            }
                            rectangle3.y = d6 >= 0.0 ? (int)(d6 + 0.5) : (int)(d6 - 0.5);
                            d5 = d8 + d6 - (double)rectangle3.y;
                            rectangle3.height = d5 >= 0.0 ? (int)(d5 + 0.5) : (int)(d5 - 0.5);
                        }
                        if ((n6 = rectangle3.y + rectangle3.height) > (n5 = rectangle2.y + rectangle2.height)) {
                            rectangle3.height -= n6 - n5;
                        }
                    } else {
                        d8 = d9 > d10 ? d13 / d12 * (double)(rectangle2.y + rectangle2.height - n4) : d13 / d11 * (double)(n4 - rectangle2.y);
                        rectangle3.height = (int)(d8 + 0.5);
                        rectangle3.y = n4;
                        if (d9 < d10) {
                            rectangle3.y -= rectangle3.height;
                        }
                        if (bl && j > 0) {
                            double d16 = 0.0;
                            for (int k = 0; k < j; ++k) {
                                if (!(this.chart.getSampleValue(k, i) < 0.0)) continue;
                                d16 += this.chart.getSampleValue(k, i);
                            }
                            d7 = d9 > d10 ? d16 / d12 * (double)(rectangle2.y + rectangle2.height - n4) : -(d16 / d11) * (double)(n4 - rectangle2.y);
                            d6 = (double)n4 + d7;
                            if (d9 < d10) {
                                d6 -= d8;
                            }
                            rectangle3.y = d6 >= 0.0 ? (int)(d6 + 0.5) : (int)(d6 - 0.5);
                            d5 = d8 + d6 - (double)rectangle3.y;
                            rectangle3.height = d5 >= 0.0 ? (int)(d5 + 0.5) : (int)(d5 - 0.5);
                        }
                        if (rectangle3.y < rectangle2.y) {
                            rectangle3.height -= rectangle2.y - rectangle3.y;
                            rectangle3.y = rectangle2.y;
                        }
                    }
                    if (this.display3dOn) {
                        rectangle3.y -= this.depth3dPoint.y;
                    }
                    if (this.aO == 2 && this.display3dOn) {
                        rectangle3.x = (int)((long)rectangle3.x + ((long)j * Math.round((double)this.depth3dPoint.x / (double)n2) + Math.round((double)this.depth3dPoint.x / (double)n2 * (1.0 - this.aK) * 0.5)));
                        rectangle3.y = (int)((long)rectangle3.y + ((long)j * Math.round((double)this.depth3dPoint.y / (double)n2) + Math.round((double)this.depth3dPoint.y / (double)n2 * (1.0 - this.aK) * 0.5)));
                    }
                    if (this.display3dOn && this.parentRenderer != null && this.parentRenderer instanceof BarChartRenderer && this.parentRenderer.display3dOn) {
                        BarChartRenderer barChartRenderer = (BarChartRenderer)this.parentRenderer;
                        rectangle3.x = (int)((long)rectangle3.x + Math.round((double)barChartRenderer.depth3dPoint.x / (double)barChartRenderer.getSeriesCount() * ((1.0 - barChartRenderer.chart.getBarWidth()) * 0.5)));
                        rectangle3.y = (int)((long)rectangle3.y + Math.round((double)barChartRenderer.depth3dPoint.y / (double)barChartRenderer.getSeriesCount() * ((1.0 - barChartRenderer.chart.getBarWidth()) * 0.5)));
                    }
                    if (this.aO == 0 || j == n2 - 1) {
                        d += d3;
                    }
                    try {
                        this.aI[j][i].x = rectangle3.x;
                        this.aI[j][i].y = rectangle3.y;
                        this.aI[j][i].width = rectangle3.width;
                        this.aI[j][i].height = rectangle3.height;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                d += d4;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    double d17;
                    double d18;
                    double d19;
                    double d20;
                    double d21;
                    Rectangle rectangle4 = new Rectangle();
                    if (d >= 0.0) {
                        rectangle4.y = (int)(d + 0.5);
                        rectangle4.height = (int)(d3 + 0.5);
                    } else {
                        rectangle4.y = (int)(d - 0.5);
                        rectangle4.height = (int)(d3 - 0.5);
                    }
                    rectangle4.height = Math.max(1, rectangle4.height);
                    int n7 = this.chart.getSeriesRange(j);
                    double d22 = this.chart.getRange(n7);
                    double d23 = this.chart.getLowerRange(n7);
                    double d24 = this.chart.getCurrentRange(n7);
                    double d25 = this.chart.getCurrentLowerRange(n7);
                    int n8 = this.gridRenderer.y[n7];
                    double d26 = this.chart.getSampleValue(j, i);
                    if (d26 >= 0.0) {
                        d21 = d22 > d23 ? d26 / d24 * (double)(rectangle2.x + rectangle2.width - n8) : d26 / d25 * (double)(n8 - rectangle2.x);
                        rectangle4.width = (int)(d21 + 0.5);
                        rectangle4.x = n8;
                        if (d22 < d23) {
                            rectangle4.x -= rectangle4.width;
                        }
                        if (this.aO == 1 && j > 0) {
                            d20 = 0.0;
                            for (int k = 0; k < j; ++k) {
                                double d27 = this.chart.getSampleValue(k, i);
                                if (!(d27 >= 0.0)) continue;
                                d20 += d27;
                            }
                            d19 = this.chart.getRange(0) > this.chart.getLowerRange(0) ? d20 / this.chart.getCurrentRange(0) * (double)(rectangle2.x + rectangle2.width - this.gridRenderer.y[0]) : -(d20 / this.chart.getCurrentLowerRange(0)) * (double)(this.gridRenderer.y[0] - rectangle2.x);
                            d18 = (double)this.gridRenderer.y[0] + d19;
                            if (this.chart.getRange(0) < this.chart.getLowerRange(0)) {
                                d18 -= d21;
                            }
                            rectangle4.x = d18 >= 0.0 ? (int)(d18 + 0.5) : (int)(d18 - 0.5);
                            d17 = d21 + d18 - (double)rectangle4.x;
                            rectangle4.width = d17 >= 0.0 ? (int)(d17 + 0.5) : (int)(d17 - 0.5);
                        }
                        if (rectangle4.x < rectangle2.x) {
                            rectangle4.width -= rectangle2.x - rectangle4.x;
                            rectangle4.x = rectangle2.x;
                        }
                    } else {
                        int n9;
                        int n10;
                        d21 = d22 > d23 ? d26 / d25 * (double)(n8 - rectangle2.x) : d26 / d24 * (double)(rectangle2.x + rectangle2.width - n8);
                        rectangle4.width = (int)(d21 + 0.5);
                        rectangle4.x = n8;
                        if (d22 > d23) {
                            rectangle4.x -= rectangle4.width;
                        }
                        if (this.aO == 1 && j > 0) {
                            d20 = 0.0;
                            for (int k = 0; k < j; ++k) {
                                if (!(this.chart.getSampleValue(k, i) < 0.0)) continue;
                                d20 += this.chart.getSampleValue(k, i);
                            }
                            d19 = this.chart.getRange(0) > this.chart.getLowerRange(0) ? d20 / this.chart.getCurrentLowerRange(0) * (double)(this.gridRenderer.y[0] - rectangle2.x) : -(d20 / this.chart.getCurrentRange(0)) * (double)(rectangle2.x + rectangle2.width - this.gridRenderer.y[0]);
                            d18 = (double)this.gridRenderer.y[0] - d19;
                            if (this.chart.getRange(0) > this.chart.getLowerRange(0)) {
                                d18 -= d21;
                            }
                            rectangle4.x = d18 >= 0.0 ? (int)(d18 + 0.5) : (int)(d18 - 0.5);
                            d17 = d21 + d18 - (double)rectangle4.x;
                            rectangle4.width = d17 >= 0.0 ? (int)(d17 + 0.5) : (int)(d17 - 0.5);
                        }
                        if ((n10 = rectangle4.x + rectangle4.width) > (n9 = rectangle2.x + rectangle2.width)) {
                            rectangle4.width -= n10 - n9;
                        }
                    }
                    if (this.display3dOn) {
                        rectangle4.x -= this.depth3dPoint.x;
                    }
                    if (this.aO == 2 && this.display3dOn) {
                        rectangle4.x = (int)((long)rectangle4.x + ((long)j * Math.round((double)this.depth3dPoint.x / (double)n2) + Math.round((double)this.depth3dPoint.x / (double)n2 * (1.0 - this.aK) * 0.5)));
                        rectangle4.y = (int)((long)rectangle4.y + ((long)j * Math.round((double)this.depth3dPoint.y / (double)n2) + Math.round((double)this.depth3dPoint.y / (double)n2 * (1.0 - this.aK) * 0.5)));
                    }
                    try {
                        this.aI[j][i].x = rectangle4.x;
                        this.aI[j][i].y = rectangle4.y;
                        this.aI[j][i].width = rectangle4.width;
                        this.aI[j][i].height = rectangle4.height;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.aO != 0 && j != n2 - 1) continue;
                    d += d3;
                }
                d += d4;
            }
        }
        this.chart.needChartCalculation = false;
    }

    private void new(Graphics graphics, Rectangle rectangle) {
        int n;
        int n2;
        int n3 = this.getSeriesCount();
        int n4 = this.getSampleCount();
        if (rectangle.width < 0 || rectangle.height < 0) {
            return;
        }
        if (this.display3dOn) {
            graphics.setClip(rectangle.x - this.depth3dPoint.x + 1, rectangle.y + 1, rectangle.width + this.depth3dPoint.x - 1, rectangle.height - this.depth3dPoint.y - 1);
        } else if (this.parentRenderer != null && this.parentRenderer.chart != null && this.parentRenderer.display3dOn) {
            graphics.setClip(rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height + 1);
        } else {
            graphics.setClip(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1);
        }
        double[][] dArrayArray = new double[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            dArrayArray[n2] = this.chart.getSampleValues(n2);
        }
        n2 = Math.max(this.chart.visibleSamples[0] - 1, 0);
        int n5 = Math.min(n2 + this.chart.visibleSamples[1] + 1, n4);
        if (this.aN == 1) {
            if (this.aO == 0) {
                for (n = n2; n < n5; ++n) {
                    for (int i = 0; i < n3; ++i) {
                        this.a(graphics, rectangle, i, n);
                    }
                }
            } else if (this.aO == 2) {
                for (n = n2; n < n5; ++n) {
                    for (int i = n3 - 1; i >= 0; --i) {
                        this.a(graphics, rectangle, i, n);
                    }
                }
            } else if (this.chart.getRange(0) > this.chart.getLowerRange(0)) {
                int n6;
                for (n = n2; n < n5; ++n) {
                    for (n6 = n3 - 1; n6 >= 0; --n6) {
                        try {
                            if (!(dArrayArray[n6][n] < 0.0)) continue;
                            this.a(graphics, rectangle, n6, n);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                for (n = n2; n < n5; ++n) {
                    for (n6 = 0; n6 < n3; ++n6) {
                        try {
                            if (!(dArrayArray[n6][n] >= 0.0)) continue;
                            this.a(graphics, rectangle, n6, n);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            } else {
                int n7;
                for (n = n2; n < n5; ++n) {
                    for (n7 = n3 - 1; n7 >= 0; --n7) {
                        try {
                            if (!(dArrayArray[n7][n] >= 0.0)) continue;
                            this.a(graphics, rectangle, n7, n);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                for (n = n2; n < n5; ++n) {
                    for (n7 = 0; n7 < n3; ++n7) {
                        try {
                            if (!(dArrayArray[n7][n] < 0.0)) continue;
                            this.a(graphics, rectangle, n7, n);
                            continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            }
        } else if (this.aO == 0 || this.aO == 2) {
            for (n = n5 - 1; n >= n2; --n) {
                for (int i = n3 - 1; i >= 0; --i) {
                    this.a(graphics, rectangle, i, n);
                }
            }
        } else if (this.chart.getRange(0) > this.chart.getLowerRange(0)) {
            int n8;
            for (n = n5 - 1; n >= n2; --n) {
                for (n8 = n3 - 1; n8 >= 0; --n8) {
                    if (!(dArrayArray[n8][n] < 0.0)) continue;
                    this.a(graphics, rectangle, n8, n);
                }
            }
            for (n = n5 - 1; n >= n2; --n) {
                for (n8 = 0; n8 < n3; ++n8) {
                    if (!(dArrayArray[n8][n] >= 0.0)) continue;
                    this.a(graphics, rectangle, n8, n);
                }
            }
        } else {
            int n9;
            for (n = n5 - 1; n >= n2; --n) {
                for (n9 = n3 - 1; n9 >= 0; --n9) {
                    if (!(dArrayArray[n9][n] >= 0.0)) continue;
                    this.a(graphics, rectangle, n9, n);
                }
            }
            for (n = n5 - 1; n >= n2; --n) {
                for (n9 = 0; n9 < n3; ++n9) {
                    if (!(dArrayArray[n9][n] < 0.0)) continue;
                    this.a(graphics, rectangle, n9, n);
                }
            }
        }
        if (this.display3dOn) {
            graphics.setColor(this.chart.getBackground());
            Polygon polygon = new Polygon();
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height - this.depth3dPoint.y + 1);
            polygon.addPoint(rectangle.x + rectangle.width - this.depth3dPoint.x - 1, rectangle.y + rectangle.height - this.depth3dPoint.y + 1);
            polygon.xpoints[0] = rectangle.x;
            polygon.ypoints[0] = rectangle.y;
            polygon.xpoints[1] = rectangle.x - this.depth3dPoint.x;
            polygon.ypoints[1] = rectangle.y;
            polygon.xpoints[2] = rectangle.x - this.depth3dPoint.x;
            polygon.ypoints[2] = rectangle.y - this.depth3dPoint.y;
            graphics.setColor(this.chart.getBackground());
            if (this.parentRenderer == null) {
                graphics.setColor(this.chart.getChartForeground());
            }
        }
    }

    private void a(Graphics graphics, Rectangle rectangle, int n, int n2) {
        double d;
        ChartSample chartSample = this.chart.getSample(n, n2);
        int n3 = this.getSeriesCount();
        if (chartSample == null || chartSample.value == null || chartSample.value.isNaN() || chartSample.getFloatValue() == 0.0 && this.aO == 1 && n3 > 1) {
            return;
        }
        int n4 = this.chart.getSeriesRange(n);
        double d2 = chartSample.getFloatValue();
        double d3 = this.chart.getCurrentRange(n4);
        boolean bl = d3 > (d = this.chart.getCurrentLowerRange(n4)) && (d2 < d && d > 0.0 || d2 > d3 && d3 < 0.0);
        if (this.aO != 1 && (bl &= d3 < d && (d2 < d && d < 0.0 || d2 > d3 && d3 > 0.0))) {
            return;
        }
        double d4 = this.depth3dPoint.x;
        double d5 = this.depth3dPoint.y;
        if (this.aO == 2 && this.display3dOn) {
            d4 = (long)this.depth3dPoint.x - (long)n * Math.round((double)this.depth3dPoint.x / (double)n3);
            d5 = (long)this.depth3dPoint.y - (long)n * Math.round((double)this.depth3dPoint.y / (double)n3);
            d5 -= (double)Math.round((double)this.depth3dPoint.y / (double)n3 * (1.0 - this.aK) * 0.5);
            d4 -= (double)Math.round((double)this.depth3dPoint.x / (double)n3 * (1.0 - this.aK) * 0.5);
        }
        Rectangle rectangle2 = null;
        if (this.aI != null && n < this.aI.length && this.aI[n] != null && n2 < this.aI[n].length) {
            rectangle2 = new Rectangle(this.aI[n][n2]);
            if (this.display3dOn) {
                double d6;
                double d7;
                double d8;
                double d9 = (double)(rectangle.y - rectangle2.y) - d5;
                if (d9 > 0.0) {
                    rectangle2.y = (int)((long)rectangle2.y + Math.round(d9));
                    rectangle2.height = (int)((long)rectangle2.height - Math.round(d9));
                }
                if ((d8 = (double)(rectangle2.y + rectangle2.height) - ((double)(rectangle.y + rectangle.height) - d5)) > 0.0) {
                    rectangle2.height = (int)((long)rectangle2.height - Math.round(d8));
                }
                if ((d7 = (double)(rectangle2.x + rectangle2.width) - ((double)(rectangle.x + rectangle.width) - d4)) > 0.0) {
                    rectangle2.width = (int)((long)rectangle2.width - Math.round(d7));
                }
                if ((d6 = (double)rectangle.x - d4 - (double)rectangle2.x) > 0.0) {
                    rectangle2.x = (int)((long)rectangle2.x + Math.round(d6));
                    rectangle2.width = (int)((long)rectangle2.width - Math.round(d6));
                }
            }
        }
        boolean bl2 = false;
        if (rectangle2 != null) {
            bl2 = (long)rectangle2.x <= (long)(rectangle.x + rectangle.width) - (this.display3dOn ? Math.round(d4) : 0L);
            bl2 &= (long)(rectangle2.x + rectangle2.width) >= (long)rectangle.x - (this.display3dOn ? Math.round(d4) : 0L);
            bl2 &= (long)(rectangle2.y + rectangle2.height) >= (long)rectangle.y - (this.display3dOn ? Math.round(d5) : 0L);
            bl2 &= (long)rectangle2.y <= (long)(rectangle.y + rectangle.height) - (this.display3dOn ? Math.round(d5) : 0L);
        }
        if (bl2) {
            boolean bl3;
            boolean bl4 = bl3 = chartSample != null && chartSample.isSelected();
            if (this.chart.getBarShape() == 1) {
                this.a((Graphics2D)graphics, rectangle2, n, n2, bl3);
            } else {
                this.paintBlockBar((Graphics2D)graphics, rectangle, rectangle2, n, n2, bl3);
            }
        }
    }

    public void paintBlockBar(Graphics2D graphics2D, Rectangle rectangle, Rectangle rectangle2, int n, int n2, boolean bl) {
        Color color = this.chart.getChartForeground();
        Color color2 = this.chart.getBarOutlineColor();
        Color color3 = this.chart.getSampleColor(0);
        Color color4 = this.chart.getSampleColor2(0);
        if (this.getSeriesCount() > 1 || this.aO == 1 && this.getSeriesCount() > 1 || this.chart.u) {
            color3 = this.chart.getSampleColor(n);
            color4 = this.chart.getSampleColor2(n);
        } else if (this.chart.isMultiColorOn()) {
            color3 = this.chart.getSampleColor(n2);
            color4 = this.chart.getSampleColor2(n2);
        }
        if (color4 == null) {
            color4 = color3;
        }
        GradientPaint gradientPaint = this.aN == 1 ? new GradientPaint(0.0f, rectangle2.y + rectangle2.height, color3, 0.0f, rectangle2.y, color4) : new GradientPaint(rectangle2.x, 0.0f, color3, rectangle2.x + rectangle2.width, 0.0f, color4);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        if (this.chart.isBarOutlineOn()) {
            Color color5 = graphics2D.getColor();
            if (color2 != null) {
                graphics2D.setColor(color2);
            } else {
                graphics2D.setColor(color);
            }
            if (this.aK == 1.0) {
                graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                if (bl) {
                    graphics2D.drawRect(rectangle2.x + 1, rectangle2.y + 1, Math.max(rectangle2.width - 2, 1), rectangle2.height == 2 ? 1 : rectangle2.height - 2);
                }
            } else if (this.display3dOn) {
                graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height);
                if (bl) {
                    graphics2D.drawRect(rectangle2.x + 1, rectangle2.y + 1, Math.max(rectangle2.width - 3, 1), rectangle2.height == 2 ? 1 : rectangle2.height - 2);
                }
            } else {
                graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                if (bl) {
                    graphics2D.drawRect(rectangle2.x + 1, rectangle2.y + 1, Math.max(rectangle2.width - 2, 1), rectangle2.height == 2 ? 1 : rectangle2.height - 2);
                }
            }
            graphics2D.setColor(color5);
        } else if (bl) {
            if (color2 != null) {
                graphics2D.setColor(color2);
            } else {
                graphics2D.setColor(color);
            }
            if (this.aN == 1) {
                graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height);
            } else {
                graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
            }
        }
        if (this.display3dOn) {
            this.a((Graphics)graphics2D, rectangle2, bl, n, n2);
        }
    }

    private void a(Graphics2D graphics2D, Rectangle rectangle, int n, int n2, boolean bl) {
        Color color = this.chart.getSampleColor(0);
        Color color2 = this.chart.getSampleColor2(0);
        if (this.getSeriesCount() > 1 || this.aO == 1 && this.getSeriesCount() > 1 || this.chart.u) {
            color = this.chart.getSampleColor(n);
            color2 = this.chart.getSampleColor2(n);
        } else if (this.chart.isMultiColorOn()) {
            color = this.chart.getSampleColor(n2);
            color2 = this.chart.getSampleColor2(n2);
        }
        if (color2 == null) {
            color2 = color;
        }
        if (bl) {
            color = BarChartRenderer.getDarker(BarChartRenderer.getDarker(color));
            color2 = BarChartRenderer.getDarker(BarChartRenderer.getDarker(color2));
        }
        if (color.equals(color2)) {
            color2 = BarChartRenderer.getDarker(BarChartRenderer.getDarker(color));
            color = BarChartRenderer.getBrighter(color);
        }
        int n3 = this.depth3dPoint.x;
        int n4 = this.depth3dPoint.y;
        if (this.parentRenderer != null) {
            n3 = (int)((double)this.depth3dPoint.x * this.aK);
            n4 = (int)((double)this.depth3dPoint.y * this.aK);
        }
        if (this.chart.getBarType() == 2) {
            n3 = this.depth3dPoint.x / this.chart.getSeriesCount();
            n4 = this.depth3dPoint.y / this.chart.getSeriesCount();
        }
        if (this.display3dOn) {
            rectangle.x += n3 / 2;
            rectangle.y += n4 / 2;
        }
        if (this.chart.getGridAlignment() == 1) {
            GradientPaint gradientPaint = new GradientPaint(rectangle.x + rectangle.width / 3, 0.0f, color, rectangle.x + rectangle.width, 0.0f, color2, true);
            GradientPaint gradientPaint2 = new GradientPaint(rectangle.x, 0.0f, color, rectangle.x + rectangle.width, 0.0f, color2);
            if (this.display3dOn) {
                int n5 = Math.min((int)((double)(rectangle.width - 4) / 2.5), -n4 - 2);
                n5 = Math.max(1, n5);
                if (this.chart.getSampleValue(n, n2) > 0.0) {
                    graphics2D.setPaint(new GradientPaint(rectangle.x + rectangle.width / 3, 0.0f, BarChartRenderer.getBrighter(BarChartRenderer.getBrighter(color)), rectangle.x + rectangle.width, 0.0f, BarChartRenderer.getBrighter(BarChartRenderer.getBrighter(color2)), true));
                    graphics2D.fillArc(rectangle.x, rectangle.y + rectangle.height - n5 / 2, rectangle.width, n5, 0, 360);
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fillArc(rectangle.x, rectangle.y + rectangle.height - n5 / 2, rectangle.width, n5, 0, -180);
                    graphics2D.setPaint(gradientPaint);
                    Shape shape = graphics2D.getClip();
                    graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height + 1);
                    graphics2D.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height + 15, 5, 15);
                    graphics2D.setClip(shape);
                    graphics2D.fillArc(rectangle.x + 2, rectangle.y - n5 / 2, rectangle.width - 4, n5, 0, 180);
                    graphics2D.setColor(color);
                    graphics2D.fillArc(rectangle.x + 2, rectangle.y - n5 / 2, rectangle.width - 4, n5, 0, 360);
                } else {
                    graphics2D.setPaint(new GradientPaint(rectangle.x + rectangle.width / 3, 0.0f, BarChartRenderer.getBrighter(BarChartRenderer.getBrighter(color)), rectangle.x + rectangle.width, 0.0f, BarChartRenderer.getBrighter(BarChartRenderer.getBrighter(color2)), true));
                    graphics2D.fillArc(rectangle.x + 2, rectangle.y + rectangle.height - n5 / 2, rectangle.width - 4, n5, 0, 360);
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fillArc(rectangle.x + 2, rectangle.y + rectangle.height - n5 / 2, rectangle.width - 4, n5, 0, -180);
                    graphics2D.setPaint(gradientPaint);
                    Shape shape = graphics2D.getClip();
                    graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height + 1);
                    graphics2D.fillRoundRect(rectangle.x, rectangle.y - 13, rectangle.width, rectangle.height + 15, 5, 15);
                    graphics2D.setClip(shape);
                    graphics2D.fillArc(rectangle.x, rectangle.y - n5 / 2, rectangle.width, n5, 0, 180);
                    graphics2D.setColor(color);
                    graphics2D.fillArc(rectangle.x, rectangle.y - n5 / 2, rectangle.width, n5, 0, 360);
                }
            } else {
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics2D.setPaint(gradientPaint2);
                graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
                graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height);
            }
        } else {
            GradientPaint gradientPaint = new GradientPaint(0.0f, rectangle.y + rectangle.height / 3, color, 0.0f, rectangle.y + rectangle.height, color2, true);
            GradientPaint gradientPaint3 = new GradientPaint(0.0f, rectangle.y, color, 0.0f, rectangle.y + rectangle.height, color2);
            if (this.display3dOn) {
                int n6 = Math.min((int)((double)(rectangle.height - 4) / 1.8), n3 - 2);
                n6 = Math.max(1, n6);
                if (this.chart.getSampleValue(n, n2) > 0.0) {
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fillArc(rectangle.x - n6 / 2, rectangle.y, n6, rectangle.height, 0, 360);
                    graphics2D.fillArc(rectangle.x - n6 / 2, rectangle.y, n6, rectangle.height, -90, -180);
                    graphics2D.setPaint(gradientPaint);
                    Shape shape = graphics2D.getClip();
                    graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height);
                    graphics2D.fillRoundRect(rectangle.x - 14, rectangle.y, rectangle.width + 15, rectangle.height, 15, 5);
                    graphics2D.setClip(shape);
                    graphics2D.fillArc(rectangle.x + rectangle.width - n6 / 2, rectangle.y + 2, n6, rectangle.height - 4, -90, 180);
                    graphics2D.setColor(color);
                    graphics2D.fillArc(rectangle.x + rectangle.width - n6 / 2, rectangle.y + 2, n6, rectangle.height - 4, 0, 360);
                } else {
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fillArc(rectangle.x - n6 / 2, rectangle.y + 2, n6, rectangle.height - 4, -90, -180);
                    graphics2D.fillArc(rectangle.x - n6 / 2, rectangle.y + 2, n6, rectangle.height - 4, 0, 360);
                    graphics2D.setPaint(gradientPaint);
                    Shape shape = graphics2D.getClip();
                    graphics2D.setClip(rectangle.x - 2, rectangle.y, rectangle.width + 2, rectangle.height);
                    graphics2D.fillRoundRect(rectangle.x - 2, rectangle.y, rectangle.width + 15, rectangle.height, 15, 5);
                    graphics2D.setClip(shape);
                    graphics2D.setColor(color);
                    graphics2D.fillArc(rectangle.x + rectangle.width - n6 / 2, rectangle.y, n6, rectangle.height, 0, 360);
                    graphics2D.fillArc(rectangle.x + rectangle.width - n6 / 2, rectangle.y, n6, rectangle.height, -90, 180);
                }
            } else {
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics2D.setPaint(gradientPaint3);
                graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                graphics2D.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
            }
        }
    }

    private void a(Graphics graphics, Rectangle rectangle, boolean bl, int n, int n2) {
        Paint paint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Polygon polygon = this.do(rectangle, n);
        Polygon polygon2 = this.if(rectangle, n);
        Color color = BarChartRenderer.getDarker(this.chart.getSampleColor(0));
        Color color2 = BarChartRenderer.getDarker(this.chart.getSampleColor2(0));
        if (this.getSeriesCount() > 1 || this.aO == 1 && this.getSeriesCount() > 1 || this.chart.u) {
            color = BarChartRenderer.getDarker(this.chart.getSampleColor(n));
            color2 = BarChartRenderer.getDarker(this.chart.getSampleColor2(n));
        } else if (this.chart.isMultiColorOn()) {
            color = BarChartRenderer.getDarker(this.chart.getSampleColor(n2));
            color2 = BarChartRenderer.getDarker(this.chart.getSampleColor2(n2));
        }
        if (color2 == null) {
            color2 = color;
        }
        graphics2D.setColor(color2);
        if (this.aN == 1) {
            graphics2D.fillPolygon(polygon);
            paint = new GradientPaint(0.0f, rectangle.y + rectangle.height, color, 0.0f, rectangle.y, color2, true);
            graphics2D.setPaint(paint);
            graphics2D.fillPolygon(polygon2);
        } else {
            graphics2D.fillPolygon(polygon2);
            paint = new GradientPaint(rectangle.x, 0.0f, color, rectangle.x + rectangle.width, 0.0f, color2, true);
            graphics2D.setPaint(paint);
            graphics2D.fillPolygon(polygon);
        }
        paint = this.chart.getBarOutlineColor();
        if (this.chart.isBarOutlineOn()) {
            if (paint != null) {
                graphics.setColor((Color)paint);
            } else {
                graphics.setColor(this.chart.getChartForeground());
            }
            graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[1], polygon.ypoints[1]);
            graphics.drawLine(polygon.xpoints[1], polygon.ypoints[1], polygon.xpoints[2], polygon.ypoints[2]);
            graphics.drawLine(polygon.xpoints[2] - 1, polygon.ypoints[2], polygon.xpoints[3] - 1, polygon.ypoints[3]);
            graphics.drawLine(polygon2.xpoints[1], polygon2.ypoints[1], polygon2.xpoints[2], polygon2.ypoints[2] - 1);
            if (this.aN == 1) {
                graphics.drawLine(polygon2.xpoints[2] - 1, polygon2.ypoints[2], polygon2.xpoints[3] - 1, polygon2.ypoints[3]);
            } else {
                graphics.drawLine(polygon2.xpoints[2], polygon2.ypoints[2] - 1, polygon2.xpoints[3], polygon2.ypoints[3] - 1);
            }
            if (bl) {
                graphics.drawLine(polygon.xpoints[0] + 1, polygon.ypoints[0], polygon.xpoints[1] + 1, polygon.ypoints[1]);
                graphics.drawLine(polygon.xpoints[1], polygon.ypoints[1] + 1, polygon.xpoints[2], polygon.ypoints[2] + 1);
                graphics.drawLine(polygon2.xpoints[0], polygon2.ypoints[0], polygon2.xpoints[1], polygon2.ypoints[1]);
                graphics.drawLine(polygon2.xpoints[1] - 1, polygon2.ypoints[1], polygon2.xpoints[2] - 1, polygon2.ypoints[2]);
                if (this.aN == 1) {
                    graphics.drawLine(polygon2.xpoints[2] - 1, polygon2.ypoints[2] - 1, polygon2.xpoints[3] - 1, polygon2.ypoints[3] - 1);
                } else {
                    graphics.drawLine(polygon2.xpoints[2], polygon2.ypoints[2], polygon2.xpoints[3], polygon2.ypoints[3]);
                }
            }
        } else if (bl) {
            if (paint != null) {
                graphics.setColor((Color)paint);
            } else {
                graphics.setColor(this.chart.getChartForeground());
            }
            graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[1], polygon.ypoints[1]);
            graphics.drawLine(polygon.xpoints[1], polygon.ypoints[1], polygon.xpoints[2], polygon.ypoints[2]);
            graphics.drawLine(polygon.xpoints[2] - 1, polygon.ypoints[2], polygon.xpoints[3] - 1, polygon.ypoints[3]);
            graphics.drawLine(polygon2.xpoints[1], polygon2.ypoints[1], polygon2.xpoints[2], polygon2.ypoints[2] - 1);
            if (this.aN == 1) {
                graphics.drawLine(polygon2.xpoints[2] - 1, polygon2.ypoints[2], polygon2.xpoints[3] - 1, polygon2.ypoints[3]);
            } else {
                graphics.drawLine(polygon2.xpoints[2], polygon2.ypoints[2] - 1, polygon2.xpoints[3], polygon2.ypoints[3] - 1);
            }
        }
    }

    private Polygon do(Rectangle rectangle, int n) {
        Serializable serializable;
        int n2 = this.getSeriesCount();
        int n3 = this.depth3dPoint.x;
        int n4 = this.depth3dPoint.y;
        if (this.aO == 2) {
            n3 = (int)Math.round((double)this.depth3dPoint.x / (double)n2 * this.aK);
            n4 = (int)Math.round((double)this.depth3dPoint.y / (double)n2 * this.aK);
            if (this.aK == 1.0 && n == n2 - 1) {
                n3 = this.depth3dPoint.x - n3 * (n2 - 1);
                n4 = this.depth3dPoint.y - n4 * (n2 - 1);
            }
        }
        if (this.display3dOn && this.parentRenderer != null && this.parentRenderer instanceof BarChartRenderer && this.parentRenderer.display3dOn) {
            serializable = (BarChartRenderer)this.parentRenderer;
            n3 = (int)Math.round((double)((BarChartRenderer)serializable).depth3dPoint.x / (double)((Renderer)serializable).getSeriesCount() * ((BarChartRenderer)serializable).chart.getBarWidth());
            n4 = (int)Math.round((double)((BarChartRenderer)serializable).depth3dPoint.y / (double)((Renderer)serializable).getSeriesCount() * ((BarChartRenderer)serializable).chart.getBarWidth());
        }
        serializable = new Polygon();
        ((Polygon)serializable).addPoint(rectangle.x, rectangle.y);
        ((Polygon)serializable).addPoint(((Polygon)serializable).xpoints[0] + n3, ((Polygon)serializable).ypoints[0] + n4);
        ((Polygon)serializable).addPoint(((Polygon)serializable).xpoints[1] + rectangle.width, ((Polygon)serializable).ypoints[1]);
        ((Polygon)serializable).addPoint(rectangle.x + rectangle.width, rectangle.y);
        return serializable;
    }

    private Polygon if(Rectangle rectangle, int n) {
        Serializable serializable;
        int n2 = this.getSeriesCount();
        int n3 = this.depth3dPoint.x;
        int n4 = this.depth3dPoint.y;
        if (this.aO == 2) {
            n3 = (int)Math.round((double)this.depth3dPoint.x / (double)n2 * this.aK);
            n4 = (int)Math.round((double)this.depth3dPoint.y / (double)n2 * this.aK);
            if (this.aK == 1.0 && n == n2 - 1) {
                n3 = this.depth3dPoint.x - n3 * (n2 - 1);
                n4 = this.depth3dPoint.y - n4 * (n2 - 1);
            }
        }
        if (this.display3dOn && this.parentRenderer != null && this.parentRenderer instanceof BarChartRenderer && this.parentRenderer.display3dOn) {
            serializable = (BarChartRenderer)this.parentRenderer;
            n3 = (int)Math.round((double)((BarChartRenderer)serializable).depth3dPoint.x / (double)((Renderer)serializable).getSeriesCount() * ((BarChartRenderer)serializable).chart.getBarWidth());
            n4 = (int)Math.round((double)((BarChartRenderer)serializable).depth3dPoint.y / (double)((Renderer)serializable).getSeriesCount() * ((BarChartRenderer)serializable).chart.getBarWidth());
        }
        serializable = new Polygon();
        ((Polygon)serializable).addPoint(rectangle.x + rectangle.width, rectangle.y);
        ((Polygon)serializable).addPoint(rectangle.x + n3 + rectangle.width, rectangle.y + n4);
        ((Polygon)serializable).addPoint(rectangle.x + n3 + rectangle.width, rectangle.y + n4 + rectangle.height);
        ((Polygon)serializable).addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        return serializable;
    }

    private void a(Graphics graphics, Rectangle rectangle, int n) {
        n = Math.min(this.chart.getRangeCount() - 1, Math.max(0, n));
        if (!this.chart.isRangeOn(n) || n >= this.gridRenderer.y.length) {
            return;
        }
        Color color = n == 0 ? this.chart.getChartForeground() : this.chart.getRangeColor(n);
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 64));
        int n2 = this.gridRenderer.y[n];
        if (this.aN == 1) {
            int n3 = Math.max(n2, rectangle.y);
            n3 = Math.min(n3, rectangle.y + rectangle.height);
            int n4 = rectangle.x - this.depth3dPoint.x;
            int n5 = n3 - this.depth3dPoint.y;
            graphics.setColor(color);
            graphics.drawLine(n4, n5, n4 + rectangle.width, n5);
            graphics.drawLine(n4 + rectangle.width, n5, rectangle.x + rectangle.width, n3);
        } else {
            int n6 = Math.max(n2, rectangle.x);
            n6 = Math.min(n6, rectangle.x + rectangle.width);
            int n7 = rectangle.y - this.depth3dPoint.y;
            int n8 = n6 - this.depth3dPoint.x;
            graphics.drawLine(n8, n7, n8, n7 + rectangle.height);
            graphics.drawLine(n8, n7, n6, rectangle.y);
        }
    }

    private void int(Graphics graphics, Rectangle rectangle) {
        graphics.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        int n = this.getSampleCount();
        int n2 = this.getSeriesCount();
        if (n == 0 || n2 == 0) {
            return;
        }
        int n3 = rectangle.y;
        int n4 = n3 + rectangle.height - (this.display3dOn ? this.depth3dPoint.y : 0);
        int n5 = rectangle.x - (this.display3dOn ? this.depth3dPoint.x : 0);
        int n6 = rectangle.x + rectangle.width;
        Font font = this.getFont("valueLabelFont");
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n7 = this.getLabelAngle("valueLabelAngle");
        int n8 = fontMetrics.getAscent();
        int n9 = this.chart.getValueLabelStyle();
        Font font2 = this.getFont("sampleLabelFont");
        int n10 = this.getLabelAngle("sampleLabelAngle");
        boolean bl = this.chart.isSampleLabelsOn();
        int n11 = this.chart.getSampleLabelStyle();
        Font font3 = this.getFont("seriesLabelFont");
        boolean bl2 = this.chart.isSeriesLabelsOn();
        int n12 = this.chart.getSeriesLabelStyle();
        boolean bl3 = this.chart.isValueLabelsOn() && n9 == 1;
        bl3 |= bl && n11 == 1;
        boolean bl4 = (bl3 |= bl2 && n12 == 1) && this.aO == 1 && n2 > 1;
        int n13 = Math.max(this.chart.visibleSamples[0] - 1, 0);
        int n14 = Math.min(n13 + this.chart.visibleSamples[1] + 1, n);
        for (int i = n13; i < n14; ++i) {
            boolean bl5 = true;
            Rectangle rectangle2 = null;
            Rectangle rectangle3 = null;
            for (int j = 0; j < n2; ++j) {
                Object object;
                Object object2;
                int n15;
                int n16;
                Dimension dimension;
                Object object3;
                Serializable serializable;
                int n17;
                String string;
                if (!this.chart.isValueLabelsOn(j) && !bl && !bl2) continue;
                String string2 = this.getLabel("valueLabelPrefix_" + j);
                if (string2 == null || bl4) {
                    string2 = this.getLabel("valueLabelPrefix");
                }
                if ((string = this.getLabel("valueLabelPostfix_" + j)) == null || bl4) {
                    string = this.getLabel("valueLabelPostfix");
                }
                double d = 0.0;
                double d2 = 0.0;
                if (this.aI != null) {
                    if (j < this.aI.length && this.aI[j] != null && i < this.aI[j].length) {
                        rectangle2 = this.aI[j][i].y > (this.display3dOn ? -this.depth3dPoint.y : 0) || this.aI[j][i].height != (this.display3dOn ? -this.depth3dPoint.y : 0) ? this.aI[j][i] : null;
                    }
                    if (this.aI.length > 0 && j < this.aI.length && this.aI[0] != null && i < this.aI[0].length && (this.aI[j][i].x > 0 || this.aI[j][i].width != 0)) {
                        rectangle3 = this.aI[j][i];
                    }
                }
                if (rectangle2 == null) continue;
                if (bl4 && rectangle2 != null && rectangle3 != null) {
                    n17 = 0;
                    for (int k = 0; k < n2; ++k) {
                        serializable = this.chart.getSample(k, i);
                        if (serializable == null || ((ChartSample)serializable).value == null || ((ChartSample)serializable).value.isNaN()) continue;
                        n17 = 1;
                        double d3 = ((ChartSample)serializable).getFloatValue();
                        if (d3 >= 0.0) {
                            d += d3;
                            continue;
                        }
                        d2 += d3;
                    }
                    if (n17 == 0) {
                        continue;
                    }
                } else {
                    ChartSample chartSample = this.chart.getSample(j, i);
                    if (chartSample == null || chartSample.value == null || chartSample.value.isNaN()) continue;
                    d = chartSample.getFloatValue();
                }
                if (rectangle2 != null && (bl2 && n12 == 0 || bl && n11 == 0 || this.chart.isValueLabelsOn(-1) && n9 == 0)) {
                    n17 = 0;
                    Color color = null;
                    serializable = font3;
                    if (n9 == 0 && this.chart.isValueLabelsOn(j)) {
                        n17 = n7;
                        color = this.chart.getValueLabelColor(j);
                        serializable = font;
                    }
                    if (n11 == 0 && bl) {
                        n17 = n10;
                        if (this.chart.getSampleLabelColor(i) != null) {
                            color = this.chart.getSampleLabelColor(i);
                        }
                        serializable = font2;
                    }
                    if (n12 == 0 && bl2 && color == null) {
                        color = this.chart.getSeriesLabelColor(j);
                    }
                    fontMetrics = this.getFontMetrics((Font)serializable);
                    graphics.setFont((Font)serializable);
                    if (color == null) {
                        Color color2 = this.chart.getSampleColor(0);
                        if (this.chart.isMultiColorOn()) {
                            color2 = n2 > 1 || this.aO == 1 || this.chart.isMultiSeriesOn() ? this.chart.getSampleColor(j) : this.chart.getSampleColor(i);
                        }
                        if ((color2.getRed() + color2.getGreen() + color2.getBlue()) / 3 > 110) {
                            graphics.setColor(Color.black);
                        } else {
                            graphics.setColor(Color.white);
                        }
                    }
                    String string3 = this.chart.constructLabel(j, i, 0, bl2, null);
                    object3 = this.getLabelSize(string3, fontMetrics);
                    dimension = this.getAngledLabelSize((Dimension)object3, n17);
                    if (this.aN == 1) {
                        n16 = rectangle2.x + rectangle2.width / 2 - dimension.width / 2 + 1;
                        if (this.chart.getBarShape() == 1) {
                            int n18 = this.depth3dPoint.x;
                            if (this.chart.getBarType() == 2) {
                                n18 = this.depth3dPoint.x / this.chart.getSeriesCount();
                            }
                            n16 += n18 / 2;
                        }
                        if (d >= 0.0 && this.chart.getRange(0) >= 0.0 || d < 0.0 && this.chart.getLowerRange(0) >= 0.0) {
                            if (n17 % 180 == 0) {
                                n15 = rectangle2.y + fontMetrics.getAscent();
                                n15 = Math.max(n15, rectangle.y + fontMetrics.getAscent() - (this.display3dOn ? this.depth3dPoint.y : 0));
                                n15 = Math.min(n15, rectangle.y + rectangle.height - 2 - (this.display3dOn ? this.depth3dPoint.y : 0));
                            } else {
                                n15 = rectangle2.y + 3;
                                if (this.aO != 2) {
                                    n15 = Math.min(n15, rectangle.y + rectangle.height - dimension.height - 2 - (this.display3dOn ? this.depth3dPoint.y : 0));
                                    n15 = Math.max(n15, rectangle.y + 3 - (this.display3dOn ? this.depth3dPoint.y : 0));
                                }
                            }
                        } else if (n17 % 180 == 0) {
                            n15 = rectangle2.y + rectangle2.height - 2;
                            n15 = Math.min(n15, rectangle.y + rectangle.height - 2 - (this.display3dOn ? this.depth3dPoint.y : 0));
                            n15 = Math.max(n15, rectangle.y + dimension.height - 1 - (this.display3dOn ? this.depth3dPoint.y : 0));
                        } else {
                            n15 = rectangle2.y + rectangle2.height - dimension.height - 2;
                            n15 = Math.min(n15, rectangle.y + rectangle.height - dimension.height - 2 - (this.display3dOn ? this.depth3dPoint.y : 0));
                            n15 = Math.max(n15, rectangle.y + 3 - (this.display3dOn ? this.depth3dPoint.y : 0));
                        }
                        if (this.aO == 1 && n2 > 1) {
                            if (n17 % 180 == 0) {
                                bl5 = n15 < rectangle2.y + rectangle2.height;
                                bl5 &= n15 - fontMetrics.getAscent() >= rectangle2.y;
                            } else {
                                bl5 = n15 + dimension.height < rectangle2.y + rectangle2.height;
                                bl5 &= n15 >= rectangle2.y;
                            }
                        }
                    } else {
                        n15 = n17 % 180 == 0 ? rectangle2.y + rectangle2.height / 2 + dimension.height / 2 - 1 : rectangle2.y + rectangle2.height / 2 - dimension.height / 2 + 1;
                        if (d >= 0.0 && this.chart.getRange(0) >= 0.0 || d < 0.0 && this.chart.getLowerRange(0) >= 0.0) {
                            n16 = rectangle2.x + rectangle2.width - dimension.width - 1;
                            n16 = Math.max(n16, rectangle.x + 2 - (this.display3dOn ? this.depth3dPoint.x : 0));
                            n16 = Math.min(n16, rectangle.x + rectangle.width - dimension.width - 1 - (this.display3dOn ? this.depth3dPoint.x : 0));
                        } else {
                            n16 = rectangle2.x + 2;
                            n16 = Math.max(n16, rectangle.x + 2 - (this.display3dOn ? this.depth3dPoint.x : 0));
                            n16 = Math.min(n16, rectangle.x + rectangle.width - dimension.width - 1 - (this.display3dOn ? this.depth3dPoint.x : 0));
                        }
                        if (this.aO == 1 && n2 > 1) {
                            bl5 = n16 > rectangle2.x;
                            bl5 &= n16 + dimension.width <= rectangle2.x + rectangle2.width;
                        }
                    }
                    if (this.aN == 1) {
                        if (n16 + dimension.width / 2 < n5 - 3 || n16 + dimension.width / 2 > n6 + 3 - (this.display3dOn ? this.depth3dPoint.x : 0)) {
                            bl5 = false;
                        }
                    } else if (n17 % 180 == 0) {
                        if (n15 - fontMetrics.getHeight() / 2 > n4 || n15 - fontMetrics.getHeight() / 2 < n3 - 3 - (this.display3dOn ? this.depth3dPoint.y : 0)) {
                            bl5 = false;
                        }
                    } else if (n15 + dimension.height / 2 > n4 || n15 + dimension.height / 2 < n3 - 3 - (this.display3dOn ? this.depth3dPoint.y : 0)) {
                        bl5 = false;
                    }
                    if (bl5) {
                        graphics.setColor(color);
                        this.paintLabel(graphics, string3, n16, n15, (Dimension)object3, this.chart.getMultilineLabelAlignment(), n17, false);
                    }
                }
                if (rectangle2 == null || !(bl2 && n12 == 1 || bl && n11 == 1) && (!this.chart.isValueLabelsOn(-1) || n9 != 1) || bl4 && j < n2 - 1) continue;
                if (bl4) {
                    for (n17 = 0; n17 < this.aI.length; ++n17) {
                        Rectangle rectangle4 = this.aI[n17][i];
                        if (rectangle4 == null) continue;
                        if (this.aN == 1) {
                            if (rectangle4.y + rectangle4.height > rectangle3.y + rectangle3.height) {
                                rectangle3 = rectangle4;
                            }
                            if (rectangle4.y >= rectangle2.y && rectangle2.y + rectangle2.height + (this.display3dOn ? this.depth3dPoint.y : 0) != 0 || rectangle4.height <= 0 && rectangle4.y == n3 - (this.display3dOn ? this.depth3dPoint.y : 0)) continue;
                            rectangle2 = rectangle4;
                            continue;
                        }
                        if (rectangle4.x < rectangle3.x && rectangle4.x >= n5) {
                            rectangle3 = rectangle4;
                        }
                        if (rectangle4.x + rectangle4.width <= rectangle2.x + rectangle2.width) continue;
                        rectangle2 = rectangle4;
                    }
                }
                n17 = 0;
                Color color = null;
                serializable = null;
                if (n9 == 1 && this.chart.isValueLabelsOn(j)) {
                    n17 = n7;
                    color = this.chart.getValueLabelColor(j);
                    serializable = font;
                }
                if (n11 == 1 && bl) {
                    n17 = n10;
                    if (this.chart.getSampleLabelColor(i) != null) {
                        color = this.chart.getSampleLabelColor(i);
                    }
                    serializable = font2;
                }
                if (n12 == 1 && bl2) {
                    if (serializable == null) {
                        serializable = font3;
                    }
                    if (color == null) {
                        color = this.chart.getSeriesLabelColor(j);
                    }
                }
                if (color == null) {
                    color = this.chart.getChartForeground();
                }
                if (serializable == null) {
                    serializable = new Font("Arial", 0, 11);
                }
                fontMetrics = this.getFontMetrics((Font)serializable);
                graphics.setFont((Font)serializable);
                Object object4 = this.chart.constructLabel(j, i, 1, bl2, null);
                object3 = "";
                dimension = null;
                Dimension dimension2 = null;
                if (bl4) {
                    n17 = n7;
                    graphics.setFont(font);
                    object2 = this.chart.formatSeriesNumber(j, d);
                    object2 = string2 != null ? string2 + (String)object2 : object2;
                    object2 = string != null ? (String)object2 + string : object2;
                    object = "";
                    if (bl && n11 == 1 && (object = this.chart.getSampleLabel(i)) != null && !((String)object).endsWith("\n") && object2 != null && this.chart.isValueLabelsOn() && n9 == 1) {
                        object = (String)object + " : ";
                    }
                    object4 = object;
                    if (this.chart.isValueLabelsOn() && n9 == 1) {
                        object4 = object4 == null ? object2 : (String)object4 + (String)object2;
                    }
                    if (d2 < 0.0) {
                        if (this.chart.isValueLabelsOn() && n9 == 1) {
                            object3 = this.chart.formatSeriesNumber(j, d2);
                            object3 = string2 != null ? string2 + (String)object3 : object3;
                            Object object5 = object3 = string != null ? (String)object3 + string : object3;
                        }
                        if (object != null) {
                            object3 = (String)object + (String)object3;
                        }
                        dimension = this.getLabelSize((String)object3, this.getFontMetrics(font));
                        dimension2 = this.getAngledLabelSize(dimension, n17);
                    }
                }
                object2 = this.getLabelSize((String)object4, fontMetrics);
                object = this.getAngledLabelSize((Dimension)object2, n17);
                if (d >= 0.0 && this.chart.getRange(0) >= 0.0 || d < 0.0 && this.chart.getLowerRange(0) >= 0.0) {
                    if (this.aN == 1) {
                        n16 = rectangle2.x + rectangle2.width / 2 - ((Dimension)object).width / 2;
                        if (n17 % 180 == 0) {
                            n15 = rectangle2.y - 2 - ((Dimension)object).height + fontMetrics.getHeight() - fontMetrics.getDescent();
                            n15 = Math.max(n3 - 2 - ((Dimension)object).height + fontMetrics.getHeight() - fontMetrics.getDescent(), n15);
                            n15 = Math.min(n4 - 2 - ((Dimension)object).height + fontMetrics.getHeight() - fontMetrics.getDescent(), n15);
                        } else {
                            n15 = rectangle2.y - 2 - ((Dimension)object).height;
                            n15 = Math.max(n15, n3 - ((Dimension)object).height - 2);
                            n15 = Math.min(n15, n4 - ((Dimension)object).height - 2);
                        }
                        if (n17 % 180 > 0 && n17 % 180 < 90) {
                            n16 = rectangle2.x + rectangle2.width - ((Dimension)object).width + 1;
                        } else if (n17 % 180 > 90) {
                            n16 = rectangle2.x - 1;
                        }
                        if (this.display3dOn && (n2 == 1 || bl4)) {
                            n15 += this.depth3dPoint.y;
                            n16 += this.depth3dPoint.x;
                            n15 = n17 % 180 == 0 ? Math.max(n3 - 2, n15) : Math.max(n3 - ((Dimension)object).height - 2, n15);
                        }
                        if (n16 + ((Dimension)object).width / 2 < n5 - 3 || n16 + ((Dimension)object).width / 2 > n6 + 3) {
                            bl5 = false;
                        }
                    } else {
                        n15 = n17 % 180 == 0 ? rectangle2.y + rectangle2.height / 2 + ((Dimension)object).height / 2 - 1 : rectangle2.y + rectangle2.height / 2 - ((Dimension)object).height / 2 + 1;
                        n16 = rectangle2.x + rectangle2.width + 3;
                        n16 = Math.min(rectangle.x + rectangle.width + 3, n16);
                        n16 = Math.max(n5 + 3, n16);
                        if (this.display3dOn && (n2 == 1 || bl4)) {
                            n15 += this.depth3dPoint.y;
                            n16 += this.depth3dPoint.x;
                            n16 = Math.min(rectangle.x + rectangle.width + 3, n16);
                        }
                        if (n17 % 180 == 0) {
                            if (n15 - fontMetrics.getHeight() / 2 < n3 - 3 || n15 - fontMetrics.getHeight() / 2 > n4) {
                                bl5 = false;
                            }
                        } else if (n15 + ((Dimension)object).height / 2 < n3 - 3 || n15 + ((Dimension)object).height / 2 > n4) {
                            bl5 = false;
                        }
                    }
                    if (bl5 && (d != 0.0 || !(d2 < 0.0))) {
                        graphics.setColor(color);
                        this.paintLabel(graphics, (String)object4, n16, n15, (Dimension)object2, this.chart.getMultilineLabelAlignment(), n17, false);
                    }
                }
                if (bl4 && d2 < 0.0) {
                    d = d2;
                    object4 = object3;
                    object2 = dimension;
                    object = dimension2;
                }
                if (!(d < 0.0 && this.chart.getLowerRange(0) < 0.0) && (!(d >= 0.0) || !(this.chart.getRange(0) < 0.0))) continue;
                if (this.aN == 1) {
                    n16 = rectangle3.x + rectangle3.width / 2 - ((Dimension)object).width / 2;
                    if (n17 % 180 == 0) {
                        n15 = rectangle3.y + rectangle3.height + n8;
                        n15 = Math.min(n4 + n8, n15);
                        n15 = Math.max(n15, this.display3dOn ? n3 - this.depth3dPoint.y + n8 : n3 + n8);
                    } else {
                        n15 = rectangle3.y + rectangle3.height + 3;
                        n15 = Math.min(n4 + 3, n15);
                        n15 = Math.max(n15, this.display3dOn ? n3 - this.depth3dPoint.y + 2 : n3 + 2);
                    }
                    if (n17 % 180 > 0 && n17 % 180 < 90) {
                        n16 = rectangle2.x + rectangle2.width - ((Dimension)object).width + 1;
                    } else if (n17 % 180 > 90) {
                        n16 = rectangle2.x - 1;
                    }
                    if (n16 + ((Dimension)object).width / 2 < n5 - 3 || n16 + ((Dimension)object).width / 2 > n6 + 3) {
                        bl5 = false;
                    }
                } else {
                    n15 = n17 % 180 == 0 ? rectangle3.y + rectangle2.height / 2 + ((Dimension)object).height / 2 - 1 : rectangle3.y + rectangle2.height / 2 - ((Dimension)object).height / 2 + 1;
                    n16 = rectangle3.x - ((Dimension)object).width - 3;
                    n16 = Math.max(n5 - ((Dimension)object2).width - 3, n16);
                    n16 = Math.min(n5 + rectangle.width - ((Dimension)object2).width - 3, n16);
                    if (n17 % 180 == 0) {
                        if (n15 - fontMetrics.getHeight() / 2 < n3 - 3 || n15 - fontMetrics.getHeight() / 2 > n4) {
                            bl5 = false;
                        }
                    } else if (n15 + ((Dimension)object).height / 2 < n3 - 3 || n15 + ((Dimension)object).height / 2 > n4) {
                        bl5 = false;
                    }
                }
                if (!bl5) continue;
                graphics.setColor(color);
                this.paintLabel(graphics, (String)object4, n16, n15, (Dimension)object2, this.chart.getMultilineLabelAlignment(), n17, false);
            }
        }
    }

    void if(Graphics graphics, Rectangle rectangle) {
        boolean bl = this.chart.bB && this.chart.bG == 2;
        bl |= this.chart.bB && this.chart.bG == 4;
        if (!(bl |= this.chart.bN)) {
            return;
        }
        String[] stringArray = this.chart.getSampleLabels();
        if (this.chart.bN) {
            stringArray = this.chart.getBarLabels();
        }
        if (stringArray == null) {
            return;
        }
        Font font = this.getFont("sampleLabelFont");
        int n = this.getLabelAngle("sampleLabelAngle");
        if (this.chart.bN) {
            font = this.getFont("barLabelFont");
            n = this.getLabelAngle("barLabelAngle");
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.setFont(font);
        int n2 = this.chart.getBarType();
        if (this.aN == 1) {
            int n3 = 0;
            int n4 = Math.max(this.chart.visibleSamples[0] - 1, 0);
            int n5 = Math.min(n4 + this.chart.visibleSamples[1] + 1, stringArray.length);
            for (int i = n4; i < n5; ++i) {
                if (stringArray[i] == null) continue;
                boolean bl2 = false;
                int n6 = this.getSeriesCount();
                if (i < this.getSampleCount()) {
                    for (int j = 0; j < n6; ++j) {
                        if (!this.chart.isSelected(j, i)) continue;
                        bl2 = true;
                        break;
                    }
                }
                Color color = null;
                if (this.chart.isBarLabelsOn()) {
                    color = this.chart.getBarLabelColor(i);
                }
                if (color == null) {
                    color = this.chart.getSampleLabelColor(i);
                }
                if (color == null) {
                    color = this.chart.getForeground();
                }
                if (bl2 && this.chart.getSampleLabelSelectionColor() != null) {
                    graphics.setColor(this.chart.getSampleLabelSelectionColor());
                } else if (color != null) {
                    graphics.setColor(color);
                }
                Dimension dimension = this.getLabelSize(stringArray[i], fontMetrics);
                Dimension dimension2 = this.getAngledLabelSize(dimension, n);
                int n7 = Integer.MIN_VALUE;
                int n8 = 0;
                if (this.aI != null && this.aI.length > 0 && i < this.aI[0].length) {
                    n7 = this.aI[0][i].x;
                    n8 = this.aI[this.aI.length - 1][i].x + this.aI[this.aI.length - 1][i].width - n7;
                    if (n2 == 2) {
                        n8 = this.aI[0][i].x + this.aI[0][i].width - n7;
                    }
                }
                int n9 = n7 + n8 / 2;
                n7 = n % 90 == 0 ? n9 - dimension2.width / 2 : (n % 180 > 90 ? n9 + n8 / 2 - dimension2.width : n9 - n8 / 2);
                int n10 = rectangle.x - 2 - (this.display3dOn ? this.depth3dPoint.x : 0);
                if (n9 < n10 || n9 > rectangle.x + rectangle.width + 2) continue;
                int n11 = rectangle.y + rectangle.height + 6;
                if (n % 180 == 0) {
                    n11 += fontMetrics.getMaxAscent() - 4;
                }
                if (this.display3dOn) {
                    n11 -= this.depth3dPoint.y;
                }
                if (this.chart.isSampleScrollerOn()) {
                    n11 += 10;
                }
                if (this.chart.isValueLabelsOn() && this.chart.bz == 1 && this.chart.getLowerRange(0) < 0.0) {
                    int n12 = rectangle.y;
                    int n13 = this.gridRenderer.y[0] - (this.display3dOn ? this.depth3dPoint.y : 0);
                    for (int j = 0; j < this.aI.length; ++j) {
                        int n14 = this.aI[j][i].y + this.aI[j][i].height;
                        if (n14 <= n12 || n14 <= n13) continue;
                        n12 = n14;
                    }
                    n11 = Math.max(n11, n12 + fontMetrics.getMaxAscent() + 10);
                    n12 = rectangle.y + rectangle.height - (this.display3dOn ? this.depth3dPoint.y : 0);
                    n11 = Math.min(n11, n12 + fontMetrics.getMaxAscent() + 10);
                }
                if (this.chart.isAutoLabelSpacingOn()) {
                    if (stringArray[i] == null || stringArray[i].trim().length() <= 0 || n7 <= n3 && i != 0) continue;
                    this.paintLabel(graphics, stringArray[i], n7, n11, dimension, 0, n, false);
                    n3 = n7 + dimension2.width;
                    continue;
                }
                this.paintLabel(graphics, stringArray[i], n7, n11, dimension, 0, n, false);
            }
        } else {
            int n15 = 0;
            int n16 = Math.min(stringArray.length, this.getSampleCount());
            int n17 = Math.max(this.chart.visibleSamples[0] - 1, 0);
            int n18 = Math.min(n17 + this.chart.visibleSamples[1] + 1, n16);
            for (int i = n17; i < n18; ++i) {
                if (stringArray[i] == null) continue;
                boolean bl3 = false;
                int n19 = this.getSeriesCount();
                for (int j = 0; j < n19; ++j) {
                    if (!this.chart.isSelected(j, i)) continue;
                    bl3 = true;
                    break;
                }
                Color color = null;
                if (this.chart.isBarLabelsOn()) {
                    color = this.chart.getBarLabelColor(i);
                }
                if (color == null) {
                    color = this.chart.getSampleLabelColor(i);
                }
                if (color == null) {
                    color = this.chart.getForeground();
                }
                if (bl3 && this.chart.getSampleLabelSelectionColor() != null) {
                    graphics.setColor(this.chart.getSampleLabelSelectionColor());
                } else if (color != null) {
                    graphics.setColor(color);
                }
                Dimension dimension = this.getLabelSize(stringArray[i], fontMetrics);
                Dimension dimension3 = this.getAngledLabelSize(dimension, n);
                int n20 = dimension3.height;
                if (this.aI != null && this.aI.length > 0 && i < this.aI[this.aI.length - 1].length && i < this.aI[0].length) {
                    n20 = this.aI[this.aI.length - 1][i].y + this.aI[this.aI.length - 1][i].height - this.aI[0][i].y;
                    if (n2 == 2) {
                        n20 = this.aI[0][i].y + this.aI[0][i].height - this.aI[0][i].y;
                    }
                }
                int n21 = 0;
                if (this.aI != null && this.aI.length > 0 && i < this.aI[0].length) {
                    n21 = this.aI[0][i].y + n20 / 2;
                }
                int n22 = n21 - dimension3.height / 2;
                if (n % 180 == 0) {
                    n22 += fontMetrics.getAscent() - 1;
                } else if (n % 180 > 90) {
                    n22 = n21 - n20 / 2;
                } else if (n % 180 != 90) {
                    n22 = n21 + n20 / 2 - dimension3.height;
                }
                if (n21 < rectangle.y || n21 > rectangle.y + rectangle.height - (this.display3dOn ? this.depth3dPoint.y : 0)) continue;
                int n23 = rectangle.x - dimension3.width - 3;
                if (this.display3dOn) {
                    n23 -= this.depth3dPoint.x;
                }
                if (this.chart.isSampleScrollerOn()) {
                    n23 -= 10;
                }
                if (this.chart.isValueLabelsOn() && this.chart.bz == 1 && this.chart.getLowerRange(0) < 0.0) {
                    int n24 = rectangle.x + rectangle.width;
                    int n25 = 0;
                    double d = 0.0;
                    for (int j = 0; j < this.aI.length; ++j) {
                        if (this.chart.getSampleValue(j, i) >= 0.0) continue;
                        d = n2 == 1 ? (d += this.chart.getSampleValue(j, i)) : this.chart.getSampleValue(j, i);
                        if (this.aI[j][i].x >= n24) continue;
                        String string = this.getLabel("valueLabelPrefix");
                        String string2 = this.getLabel("valueLabelPostfix");
                        n24 = this.aI[j][i].x;
                        String string3 = this.chart.formatSeriesNumber(j, d);
                        string3 = string != null ? string + string3 : string3;
                        string3 = string2 != null ? string3 + string2 : string3;
                        n25 = fontMetrics.stringWidth(string3);
                    }
                    n23 = Math.min(n23, n24 - n25 - dimension3.width - 3);
                    n24 = rectangle.x - (this.display3dOn ? this.depth3dPoint.x : 0);
                    n23 = Math.max(n23, n24 - n25 - dimension3.width - 3);
                    n23 = Math.min(n23, (n24 -= this.chart.isSampleScrollerOn() ? 10 : 0) - dimension3.width - 3);
                }
                if (this.chart.isAutoLabelSpacingOn()) {
                    if (stringArray[i] == null || stringArray[i].trim().length() <= 0 || n22 <= n15 && i != 0) continue;
                    this.paintLabel(graphics, stringArray[i], n23, n22, dimension, 1, n, false);
                    n15 = n22 + dimension3.height;
                    continue;
                }
                this.paintLabel(graphics, stringArray[i], n23, n22, dimension, 1, n, false);
            }
        }
    }

    protected Rectangle getLineChartBounds(Rectangle rectangle) {
        Rectangle rectangle2 = rectangle;
        int n = 1;
        if (this.aO == 0) {
            n = this.getSeriesCount();
        }
        if (this.getSampleCount() > 1 && this.aI != null && this.aI.length > 0 && this.aI[0] != null && this.aI[0].length > 0) {
            int n2 = this.aI[0][0].x + this.aI[0][0].width * n / 2 - rectangle.x;
            rectangle2.x += n2;
            rectangle2.width -= n2 * 2;
            if (this.aO == 2) {
                int n3 = (int)Math.round((double)this.depth3dPoint.x / (double)this.getSeriesCount() * (1.0 - this.aK) * 0.5);
                rectangle2.x -= n3;
                rectangle2.width += n3 * 2;
            }
        }
        return rectangle2;
    }

    protected Point getSampleCenter(int n, int n2) {
        Rectangle rectangle;
        Rectangle rectangle2 = new Rectangle(this.chart.getGraphBounds());
        if (this.display3dOn) {
            rectangle2.x -= this.depth3dPoint.x;
            rectangle2.y -= this.depth3dPoint.y;
        }
        if ((rectangle = this.if(n2, n)) != null) {
            Point point;
            if (rectangle.y < rectangle2.y) {
                rectangle.height -= rectangle2.y - rectangle.y + 1;
                rectangle.y = rectangle2.y;
            }
            if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                rectangle.height -= rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
            }
            if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                rectangle.width = rectangle2.x + rectangle2.width - rectangle.x;
            }
            if (rectangle.x < rectangle2.x) {
                rectangle.width -= rectangle2.x - rectangle.x + 2;
                rectangle.x = rectangle2.x;
            }
            if (rectangle2.contains(point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2))) {
                return point;
            }
        }
        return null;
    }

    Rectangle if(int n, int n2) {
        if (this.aI != null && n >= 0 && n2 >= 0 && n < this.aI.length && n2 < this.aI[n].length) {
            return this.aI[n][n2];
        }
        return null;
    }

    private Rectangle a(Rectangle rectangle) {
        boolean bl = this.chart.isValueLabelsOn(0);
        boolean bl2 = this.chart.isSampleLabelsOn();
        boolean bl3 = this.chart.isSeriesLabelsOn();
        int n = this.chart.getValueLabelStyle();
        int n2 = this.chart.getSampleLabelStyle();
        int n3 = this.chart.getSeriesLabelStyle();
        boolean bl4 = bl && n == 1;
        bl4 |= bl2 && n2 == 1;
        if (!(bl4 |= bl3 && n3 == 1)) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n4 = 0;
        Font font = this.getFont("seriesLabelFont");
        if (n == 1 && bl) {
            n4 = this.getLabelAngle("valueLabelAngle");
            font = this.getFont("valueLabelFont");
        }
        if (n2 == 1 && bl2) {
            n4 = this.getLabelAngle("sampleLabelAngle");
            font = this.getFont("sampleLabelFont");
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n5 = this.getSeriesCount();
        int n6 = this.getSampleCount();
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                String string = this.chart.constructLabel(i, j, 1, bl3, null);
                if (this.aO == 1) {
                    double d3 = this.chart.getSampleValue(i, j);
                    String string2 = this.chart.formatSeriesNumber(0, d3);
                    String string3 = this.getLabel("valueLabelPrefix");
                    String string4 = this.getLabel("valueLabelPostfix");
                    string2 = string3 != null ? string3 + string2 : string2;
                    string2 = string4 != null ? string2 + string4 : string2;
                    String string5 = "";
                    if (bl2 && n2 == 1 && (string5 = this.chart.getSampleLabel(j)) != null && !string5.endsWith("\n") && string2 != null && n == 1) {
                        string5 = string5 + " : ";
                    }
                    string = n == 1 ? string5 + string2 : string5;
                }
                Dimension dimension = this.getLabelSize(string, fontMetrics);
                Dimension dimension2 = this.getAngledLabelSize(dimension, n4);
                double d4 = this.chart.getSampleValue(i, j);
                if (d4 == d) {
                    n7 = this.aN == 1 ? Math.max(n7, dimension2.height) : Math.max(n7, fontMetrics.stringWidth(string));
                }
                double d5 = this.chart.getRange(0);
                double d6 = this.chart.getLowerRange(0);
                if (d4 > d && d5 > d6 || d4 < d && d5 < d6) {
                    d = d4;
                    n7 = this.aN == 1 ? dimension2.height : fontMetrics.stringWidth(string);
                }
                if (!(d4 < d2 && d5 > d6) && (!(d4 > d2) || !(d5 < d6))) continue;
                d2 = d4;
                n8 = this.aN == 1 ? dimension2.height : fontMetrics.stringWidth(string);
            }
        }
        if (n4 % 180 == 0 && this.aN == 1 && n8 > 0) {
            n8 -= fontMetrics.getDescent();
        }
        if (this.aN == 1) {
            rectangle2.y += n7;
            rectangle2.height -= n7 + n8;
        } else {
            rectangle2.x += n8;
            rectangle2.width -= n7 + n8;
        }
        return rectangle2;
    }

    protected void calculateGraphBounds(Rectangle rectangle) {
        Serializable serializable;
        int n;
        int n2;
        Serializable serializable2;
        int n3;
        int n4;
        Font font;
        String[] stringArray;
        int n5;
        int n6;
        int n7;
        int n8;
        Dimension dimension;
        block20: {
            block19: {
                this.legendRenderer.calculateGraphBounds(this.legend, rectangle);
                this.aN = this.chart.getGridAlignment();
                this.aO = this.chart.getBarType();
                this.display3dOn = this.chart.is3DModeOn();
                this.aK = this.chart.getBarWidth();
                dimension = this.chart.getSize();
                n8 = rectangle.x;
                n7 = dimension.width - rectangle.width - rectangle.x;
                n6 = rectangle.y;
                n5 = dimension.height - rectangle.height - rectangle.y;
                stringArray = null;
                font = this.getFont("sampleLabelFont");
                n4 = this.getLabelAngle("sampleLabelAngle");
                if (!this.isAnyBelowLabelsOn()) break block19;
                stringArray = this.chart.getSampleLabels();
                if (!this.chart.isBarLabelsOn()) break block20;
                font = this.getFont("barLabelFont");
                n4 = this.getLabelAngle("barLabelAngle");
                stringArray = this.chart.getBarLabels();
                break block20;
            }
            for (n3 = 0; n3 < this.overlayRenderers.size(); ++n3) {
                serializable2 = (ChartRenderer)this.overlayRenderers.elementAt(n3);
                if (serializable2 == null || !(((ChartRenderer)serializable2).chart instanceof Chart) || !((ChartRenderer)serializable2).isAnyBelowLabelsOn()) continue;
                font = ((Renderer)serializable2).getFont("sampleLabelFont");
                n4 = ((Renderer)serializable2).getLabelAngle("sampleLabelAngle");
                stringArray = ((Chart)((ChartRenderer)serializable2).chart).getSampleLabels();
                if (!(serializable2 instanceof BarChartRenderer) || !((BarChart)((ChartRenderer)serializable2).chart).isBarLabelsOn()) break;
                font = ((Renderer)serializable2).getFont("barLabelFont");
                n4 = ((Renderer)serializable2).getLabelAngle("barLabelAngle");
                stringArray = ((BarChart)((ChartRenderer)serializable2).chart).getBarLabels();
                break;
            }
        }
        if (stringArray != null) {
            Dimension dimension2;
            serializable2 = this.getFontMetrics(font);
            if (this.aN == 1) {
                n2 = 0;
                for (n = 0; n < stringArray.length; ++n) {
                    dimension2 = this.getLabelSize(stringArray[n], (FontMetrics)serializable2);
                    serializable = this.getAngledLabelSize(dimension2, n4);
                    n2 = Math.max(serializable.height, n2);
                }
                n3 = n2;
                if (n4 % 180 == 0) {
                    n3 -= ((FontMetrics)serializable2).getMaxDescent();
                }
                n5 += n3;
            } else {
                n2 = 0;
                for (n = 0; n < stringArray.length; ++n) {
                    dimension2 = this.getLabelSize(stringArray[n], (FontMetrics)serializable2);
                    serializable = this.getAngledLabelSize(dimension2, n4);
                    n2 = Math.max(n2, serializable.width);
                }
                n8 += n2;
            }
        }
        serializable2 = new Rectangle(n8, n6, dimension.width - n8 - n7, dimension.height - n6 - n5);
        serializable2 = this.a((Rectangle)serializable2);
        n8 = ((Rectangle)serializable2).x;
        n7 = dimension.width - ((Rectangle)serializable2).width - ((Rectangle)serializable2).x;
        n6 = ((Rectangle)serializable2).y;
        n5 = dimension.height - ((Rectangle)serializable2).height - ((Rectangle)serializable2).y;
        n2 = this.chart.getSampleCount();
        n = this.chart.getSeriesCount();
        if (this.display3dOn && n2 > 0 && n > 0) {
            double d;
            if (this.chart.H >= 0) {
                this.depth3dPoint.x = Math.round((float)this.chart.H * 1.25f);
                this.depth3dPoint.y = Math.round((float)(-this.chart.H) / 1.25f);
            } else if (this.parentRenderer != null) {
                if (this.parentRenderer instanceof BarChartRenderer || this.parentRenderer instanceof LineChartRenderer) {
                    this.depth3dPoint.x = this.parentRenderer.depth3dPoint.x / this.parentRenderer.getSeriesCount();
                    this.depth3dPoint.y = this.parentRenderer.depth3dPoint.y / this.parentRenderer.getSeriesCount();
                }
            } else if (this.aN == 1) {
                double d2 = (double)rectangle.width / (double)n2;
                d = d2 * this.aK;
                if (this.aO == 0) {
                    d /= (double)n;
                }
                this.depth3dPoint.x = (int)Math.round(d * 1.25);
                this.depth3dPoint.y = (int)Math.round(-d / 1.25);
            } else {
                double d3 = (double)rectangle.height / (double)n2;
                d = d3 * this.aK;
                if (this.aO == 0) {
                    d /= (double)n;
                }
                this.depth3dPoint.x = (int)Math.round(d * 1.25 * 0.75);
                this.depth3dPoint.y = (int)Math.round(-(d / 1.25 * 0.75));
            }
            n8 += this.depth3dPoint.x;
            n5 -= this.depth3dPoint.y;
        }
        for (int i = 0; i < this.overlayRenderers.size(); ++i) {
            serializable = (ChartRenderer)this.overlayRenderers.elementAt(i);
            if (serializable == null || !(((ChartRenderer)serializable).chart instanceof Chart)) continue;
            if (this.aO == 2) {
                ((ChartRenderer)serializable).depth3dPoint.x = this.depth3dPoint.x / n;
                ((ChartRenderer)serializable).depth3dPoint.y = this.depth3dPoint.y / n;
                continue;
            }
            ((ChartRenderer)serializable).depth3dPoint.x = this.depth3dPoint.x;
            ((ChartRenderer)serializable).depth3dPoint.y = this.depth3dPoint.y;
        }
        rectangle.x = n8;
        rectangle.width = dimension.width - n8 - n7;
        rectangle.y = n6;
        rectangle.height = dimension.height - n6 - n5;
        this.gridRenderer.if(this.chart.a(), rectangle);
    }

    protected void paintFloatingLabel(Graphics graphics, String string, Rectangle rectangle, int n, int n2, Font font, FontMetrics fontMetrics) {
        Serializable serializable;
        if (string == null || n2 < 0 || n2 >= this.getSeriesCount() || n < 0 || n >= this.getSampleCount() || fontMetrics == null) {
            return;
        }
        Rectangle rectangle2 = this.aI[n2][n];
        if (rectangle2 == null) {
            return;
        }
        if (this.aN == 1) {
            if (rectangle2.x + rectangle2.width < rectangle.x - (this.display3dOn ? this.depth3dPoint.x : 0) || rectangle2.x > rectangle.x + rectangle.width) {
                return;
            }
            if (rectangle2.y + rectangle2.height < rectangle.y || rectangle2.y > rectangle.y + rectangle.height - (this.display3dOn ? this.depth3dPoint.y : 0)) {
                return;
            }
        } else {
            if (rectangle2.y + rectangle2.height < rectangle.y || rectangle2.y > rectangle.y + rectangle.height - (this.display3dOn ? this.depth3dPoint.y : 0)) {
                return;
            }
            if (rectangle2.x + rectangle2.width < rectangle.x - (this.display3dOn ? this.depth3dPoint.x : 0) || rectangle2.x > rectangle.x + rectangle.width) {
                return;
            }
        }
        Dimension dimension = this.getLabelSize(string, this.getFontMetrics(font));
        int n3 = this.aN == 1 ? rectangle2.x + rectangle2.width / 2 - dimension.width / 2 + 1 : (this.aj.x < 0 ? rectangle2.x + rectangle2.width / 2 - dimension.width / 2 : this.aj.x - dimension.width / 2);
        int n4 = this.aj.y - dimension.height + fontMetrics.getAscent();
        if (this.aN == 0 || this.aj.y < 0) {
            n4 = rectangle2.y + rectangle2.height / 2 - dimension.height / 2 + fontMetrics.getAscent();
        }
        if (this.aO == 1 && n4 - dimension.height / 2 < rectangle2.y) {
            n4 = rectangle2.y + dimension.height / 2 + 1;
        } else if (this.display3dOn && this.depth3dPoint.y != 0 && this.aN == 1 && this.aj.y < rectangle2.y && this.aj.y >= 0) {
            n3 += -this.depth3dPoint.x * (rectangle2.y - this.aj.y) / this.depth3dPoint.y;
            serializable = null;
            if (n2 < this.getSeriesCount() - 1) {
                serializable = this.aI[n2 + 1][n];
            } else if (n < this.getSampleCount() - 1) {
                serializable = this.aI[0][n + 1];
            }
            if (serializable != null) {
                int n5 = (int)((double)(-this.depth3dPoint.x) * (double)(((Rectangle)serializable).y - this.aj.y) / (double)this.depth3dPoint.y);
                if (n4 >= ((Rectangle)serializable).y && n3 > ((Rectangle)serializable).x - 10) {
                    n3 = ((Rectangle)serializable).x - 10;
                } else if (n4 < ((Rectangle)serializable).y && n3 > ((Rectangle)serializable).x + n5 - 10) {
                    n3 = ((Rectangle)serializable).x + n5 - 10;
                }
            }
        }
        serializable = this.chart.getChartForeground();
        if (this.getSeriesCount() == 1 && this.chart.isMultiColorOn()) {
            serializable = BarChartRenderer.getDarker(this.chart.getSampleColor(n));
        } else if (this.chart.isMultiColorOn()) {
            serializable = BarChartRenderer.getDarker(this.chart.getSampleColor(n2));
        }
        this.a(graphics, string, n3, n4, dimension, (Color)serializable, fontMetrics);
    }

    protected boolean isAnyFloatingLabelsOn(int n) {
        int n2 = this.chart.getValueLabelStyle();
        int n3 = this.chart.getSampleLabelStyle();
        int n4 = this.chart.getSeriesLabelStyle();
        boolean bl = this.chart.isValueLabelsOn(n);
        boolean bl2 = this.chart.isSampleLabelsOn();
        boolean bl3 = this.chart.isSeriesLabelsOn();
        boolean bl4 = bl && n2 == 3;
        bl4 |= bl2 && (n3 == 3 || n3 == 4);
        return bl4 |= bl3 && n4 == 3;
    }

    protected boolean isAnyBelowLabelsOn() {
        int n = this.chart.getSampleLabelStyle();
        boolean bl = this.chart.isSampleLabelsOn();
        boolean bl2 = bl && (n == 2 || n == 4);
        return bl2 |= this.chart.isBarLabelsOn();
    }
}

