/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart.ext;

import com.objectplanet.chart.Chart;
import com.objectplanet.chart.LineChart;
import java.awt.IllegalComponentStateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class TimeLineChart
extends LineChart {
    private SimpleDateFormat dateParser;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private String dateParserPattern = "ms";
    private long lowerTime = 0L;
    private long upperTime = 0L;
    private double timeScale = 1.0;
    private boolean autoTimeLabelsOn;
    private String[] timeLabels;
    private double[] gridLines = new double[1000];
    private int gridLineCount;

    public TimeLineChart() {
        try {
            this.dateParser = new SimpleDateFormat(this.dateParserPattern, this.getLocale());
        }
        catch (IllegalComponentStateException e) {
            this.dateParser = new SimpleDateFormat(this.dateParserPattern);
        }
        this.dateParser.setLenient(false);
        this.setSampleLabelsOn(true);
    }

    public void reset() {
        this.timeScale = 1.0;
        this.dateParserPattern = "ms";
        super.reset();
        try {
            this.dateParser = new SimpleDateFormat(this.dateParserPattern, this.getLocale());
        }
        catch (IllegalComponentStateException e) {
            this.dateParser = new SimpleDateFormat(this.dateParserPattern);
        }
        this.dateParser.setLenient(false);
        this.setSampleLabelsOn(true);
    }

    public void setTimeFormatInput(String pattern) {
        if (pattern != null && pattern.trim().length() > 0) {
            this.dateParser.applyPattern(pattern);
            this.dateParserPattern = pattern;
        } else {
            this.dateParser.applyPattern(this.dateParserPattern);
        }
    }

    public String getTimeFormatInput() {
        return this.dateParserPattern;
    }

    public void setTimeFormatInputLocale(String value) {
        StringTokenizer st;
        Locale locale = null;
        if (value != null && value.length() > 0 && (st = new StringTokenizer(value, ", ")).hasMoreTokens()) {
            String lang;
            String country = lang = st.nextToken();
            if (st.hasMoreElements()) {
                country = st.nextToken();
            }
            locale = new Locale(lang.toUpperCase(), country.toUpperCase());
        }
        if (locale != null) {
            this.dateParser = new SimpleDateFormat(this.dateParserPattern, locale);
        } else {
            try {
                this.dateParser = new SimpleDateFormat(this.dateParserPattern, this.getLocale());
            }
            catch (IllegalComponentStateException e) {
                this.dateParser = new SimpleDateFormat(this.dateParserPattern);
            }
        }
    }

    public void setTimeFormatOut(String pattern) {
        if (pattern != null && pattern.trim().length() > 0) {
            this.dateFormat.applyPattern(pattern);
        } else {
            this.dateFormat.applyPattern(this.dateParserPattern);
        }
        try {
            this.dateFormat.format(new Date());
        }
        catch (IllegalArgumentException e) {
            System.out.println("Invalid pattern " + pattern);
        }
    }

    public void setTimeFormatOutLocale(String value) {
        StringTokenizer st;
        Locale locale = null;
        if (value != null && value.length() > 0 && (st = new StringTokenizer(value, ", ")).hasMoreTokens()) {
            String lang;
            String country = lang = st.nextToken();
            if (st.hasMoreElements()) {
                country = st.nextToken();
            }
            locale = new Locale(lang.toUpperCase(), country.toUpperCase());
        }
        if (locale != null) {
            this.dateFormat = new SimpleDateFormat(this.dateFormat.toPattern(), locale);
        } else {
            try {
                this.dateFormat = new SimpleDateFormat(this.dateFormat.toPattern(), this.getLocale());
            }
            catch (IllegalComponentStateException e) {
                this.dateFormat = new SimpleDateFormat(this.dateFormat.toPattern());
            }
        }
    }

    public String getTimeFormatOut() {
        return this.dateFormat.toPattern();
    }

    public void setLowerTime(String time) {
        if (time != null && time.trim().length() > 0) {
            this.lowerTime = this.createTime(time);
        }
        this.upperTime = Math.max(this.lowerTime, this.upperTime);
    }

    public String getLowerTime() {
        return this.dateFormat.format(new Date(this.lowerTime));
    }

    public void setUpperTime(String time) {
        if (time != null && time.trim().length() > 0) {
            this.upperTime = this.createTime(time);
        }
        this.lowerTime = Math.min(this.lowerTime, this.upperTime);
    }

    public String getUpperTime() {
        return this.dateFormat.format(new Date(this.upperTime));
    }

    public void setTimeScale(double seconds) {
        this.timeScale = seconds;
        double diff = this.upperTime - this.lowerTime;
        int count = (int)Math.round(diff / (this.timeScale * 1000.0));
        this.setSampleCount(count + 1);
        this.setSampleAxisRange(0.0, count);
    }

    public double getTimeScale() {
        return this.timeScale;
    }

    public void setAutoTimeLabelsOn(boolean on) {
        this.autoTimeLabelsOn = on;
    }

    public boolean isAutoTimeLabelsOn() {
        return this.autoTimeLabelsOn;
    }

    public void setTimePlots(int series, String[] plots) {
        if (series >= 0 && plots != null && plots.length > 0) {
            if (this.gridLines.length < this.gridLineCount + plots.length) {
                double[] newGridLines = new double[this.gridLineCount + plots.length + 1000];
                System.arraycopy(this.gridLines, 0, newGridLines, 0, this.gridLines.length);
                this.gridLines = newGridLines;
            }
            if (this.timeLabels == null || this.timeLabels.length < this.getSampleCount()) {
                this.timeLabels = new String[this.getSampleCount()];
            }
            for (int i = 0; i < plots.length; ++i) {
                if (plots[i] == null) continue;
                String[] plot = Chart.getStringValues(plots[i], "|");
                long plot_time = Long.MIN_VALUE;
                if (plot != null && plot.length >= 1) {
                    plot_time = this.createTime(plot[0]);
                }
                double plot_value = Double.NaN;
                if (plot != null && plot.length >= 2) {
                    try {
                        plot_value = Double.valueOf(plot[1]);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid plot: " + plots[i]);
                    }
                }
                if (plot_time < this.lowerTime || plot_time > this.upperTime) continue;
                int slot = (int)Math.round((double)(plot_time - this.lowerTime) / (this.timeScale * 1000.0));
                try {
                    this.setSampleValue(series, slot, plot_value);
                    String label = this.dateFormat.format(new Date(plot_time));
                    this.timeLabels[slot] = new String(label);
                    if (this.autoTimeLabelsOn) {
                        this.setSampleLabel(slot, label);
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (!this.autoTimeLabelsOn) continue;
                this.gridLines[this.gridLineCount++] = slot;
            }
        }
    }

    public void setTimeLabels(String[] labels) {
        if (labels != null && labels.length > 0) {
            if (labels != null && this.gridLines.length < this.gridLineCount + labels.length) {
                double[] newGridLines = new double[this.gridLineCount + labels.length + 1000];
                System.arraycopy(this.gridLines, 0, newGridLines, 0, this.gridLines.length);
                this.gridLines = newGridLines;
            }
            for (int i = 0; i < labels.length; ++i) {
                long time;
                if (labels[i] == null || (time = this.createTime(labels[i])) < this.lowerTime || time > this.upperTime) continue;
                int slot = (int)Math.round((double)(time - this.lowerTime) / (this.timeScale * 1000.0));
                try {
                    this.setSampleLabel(slot, this.dateFormat.format(new Date(time)));
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                this.gridLines[this.gridLineCount++] = slot;
            }
        }
    }

    public void setDefaultGridLinesOn(boolean on) {
        if (on) {
            for (int i = 0; i < this.gridLines.length && i < this.gridLineCount; ++i) {
                this.setGridLine(i, this.gridLines[i]);
            }
        } else {
            this.setGridLines(null);
        }
    }

    long createTime(String timeString) {
        long time = 0L;
        String format = this.dateParser.toPattern();
        if (timeString != null && timeString.length() > 0 && format != null && format.trim().equalsIgnoreCase("ms")) {
            try {
                time = Long.parseLong(timeString);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid milliseconds time: " + timeString);
            }
        } else if (timeString != null && timeString.trim().length() > 0 && this.dateParser != null) {
            try {
                Date date = this.dateParser.parse(timeString.trim());
                if (date != null) {
                    time = date.getTime();
                }
            }
            catch (ParseException e) {
                System.out.println("Invalid date and time pattern match: " + timeString + " " + this.dateParser.toPattern());
            }
        }
        return time;
    }

    private void setTimeLabels() {
        int count = this.getSampleCount();
        double delta = (double)(this.upperTime - this.lowerTime) / (double)count;
        double time = this.lowerTime;
        for (int i = 0; i < count; ++i) {
            String label = this.createTimeLabel(Math.round(time));
            this.setSampleLabel(i, label);
            time += delta;
        }
    }

    private String createTimeLabel(long time) {
        String label;
        try {
            label = this.dateFormat.format(new Date(time));
        }
        catch (IllegalArgumentException e) {
            label = new Date(time).toString();
        }
        return label;
    }

    public String createTimeLabelBySample(int sample) {
        String label;
        long time = (long)((double)sample * this.timeScale * 1000.0) + this.lowerTime;
        try {
            label = this.dateParser.format(new Date(time));
        }
        catch (IllegalArgumentException e) {
            label = new Date(time).toString();
        }
        return label;
    }

    protected String constructLabel(int series, int sample, boolean paintSeriesOn, int style) {
        String seriesLabel;
        if (series < 0 || series >= this.getSeriesCount() || sample < 0 || sample >= this.getSampleCount()) {
            return "";
        }
        boolean seriesOn = paintSeriesOn && this.isSeriesLabelsOn() && this.getSeriesLabelStyle() == style;
        int sample_style = this.getSampleLabelStyle();
        if (this.getSampleLabelStyle() == 4) {
            sample_style = 3;
        }
        boolean sample_on = this.isSampleLabelsOn() && sample_style == style;
        boolean valueOn = this.isValueLabelsOn(series) && this.getValueLabelStyle() == style;
        String separator = style == 3 ? " : " : ":";
        String label = "";
        if (seriesOn && (seriesLabel = this.getSeriesLabel(series)) != null) {
            label = label + seriesLabel;
            if (!seriesLabel.endsWith("\n") && sample_on && this.getSampleLabel(sample) != null) {
                label = label + separator;
            }
        }
        if (sample_on && sample < this.timeLabels.length && this.timeLabels[sample] != null) {
            label = label + this.timeLabels[sample];
        }
        if (valueOn) {
            String postfix;
            String prefix = this.getLabel("valueLabelPrefix_" + series);
            if (prefix == null) {
                prefix = this.getLabel("valueLabelPrefix");
            }
            if ((postfix = this.getLabel("valueLabelPostfix_" + series)) == null) {
                postfix = this.getLabel("valueLabelPostfix");
            }
            if (label.length() > 0) {
                String number = this.formatSeriesNumber(series, this.getSampleValue(series, sample));
                number = prefix != null ? prefix + number : number;
                String string = number = postfix != null ? number + postfix : number;
                label = label.endsWith("\n") || number.startsWith("\n") ? label + number : label + separator + number;
            } else {
                label = this.formatSeriesNumber(series, this.getSampleValue(series, sample));
                label = prefix != null ? prefix + label : label;
                label = postfix != null ? label + postfix : label;
            }
        }
        return label;
    }
}

