/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;

public class TagToken {
    public static final char ESCAPE = '\\';
    public static final char QUOTE = '\"';
    private String name = null;
    private boolean end = false;
    private AttributeList attr = new AttributeList();

    public TagToken(String string) {
        this.tokenizeAttributes(string);
    }

    public String getName() {
        return this.name;
    }

    public AttributeList getAttributes() {
        return this.attr;
    }

    public boolean isEndTag() {
        return this.end;
    }

    public boolean isAttribute(String string) {
        return this.attr.exists(string);
    }

    public String getAttribute(String string) {
        return this.attr.get(string);
    }

    public String getQuotedAttribute(String string) {
        if (this.attr == null) {
            return null;
        }
        return this.attr.getQuoted(string);
    }

    public String getAttributeToString(String string) {
        if (this.attr == null) {
            return null;
        }
        return this.attr.toString(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.end) {
            stringBuffer.append("</" + this.name);
        } else {
            stringBuffer.append('<' + this.name);
        }
        if (this.attr != null && this.attr.size() > 0) {
            stringBuffer.append(' ').append(this.attr.toString());
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    private void setName(String string) {
        if (string == null) {
            this.name = null;
            return;
        }
        String string2 = string.toLowerCase();
        if (string2.charAt(0) == '/') {
            this.name = string2.substring(1);
            this.end = true;
        } else {
            this.name = string2;
        }
    }

    private void setAttribute(String string, String string2) {
        this.attr.set(string, string2);
    }

    private void setAttribute(String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf(61);
        if (n < 0) {
            this.setAttribute(string, "");
        } else {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            this.setAttribute(string2, string3);
        }
    }

    private void tokenizeAttributes(String string) {
        String[] stringArray = null;
        Vector vector = this.tokenizeString(string);
        if (vector == null) {
            return;
        }
        int n = vector.size() - 1;
        if (n > 0) {
            stringArray = new String[n];
        }
        Enumeration enumeration = vector.elements();
        this.setName((String)enumeration.nextElement());
        if (!enumeration.hasMoreElements()) {
            return;
        }
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        n2 = 1;
        while (n2 < n - 1) {
            if (stringArray[n2] != null && stringArray[n2].equals("=")) {
                this.setAttribute(stringArray[n2 - 1], stringArray[n2 + 1]);
                stringArray[n2] = null;
                stringArray[n2 - 1] = null;
                stringArray[n2 + 1] = null;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] != null) {
                this.setAttribute(stringArray[n2]);
            }
            ++n2;
        }
    }

    private Vector tokenizeString(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer(80);
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        while (n < n2) {
            if (bl) {
                if (this.isWhitespace(cArray[n])) {
                    ++n;
                    continue;
                }
                bl = false;
            }
            if (bl2) {
                stringBuffer.append(cArray[n++]);
                bl2 = false;
                continue;
            }
            if (cArray[n] == '\\') {
                bl2 = true;
                ++n;
                continue;
            }
            if (cArray[n] == '\"') {
                bl3 = !bl3;
                ++n;
                continue;
            }
            if (!bl3 && this.isWhitespace(cArray[n])) {
                vector.addElement(stringBuffer.toString());
                stringBuffer = new StringBuffer(80);
                bl = true;
                continue;
            }
            stringBuffer.append(cArray[n++]);
        }
        if (!bl) {
            vector.addElement(stringBuffer.toString());
        }
        return vector;
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }
}

