/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.DB2StructConstant;
import COM.ibm.db2.app.DB2StructException;
import COM.ibm.db2.app.DereferencedNativeArray;
import COM.ibm.db2.app.NativeArray;
import COM.ibm.db2.app.TypeMapTableElement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;

public class DB2Struct {
    public DereferencedNativeArray nativeStructTypeBuff;
    public HashMap typeMapTable;
    public short numAttr;
    public int totalLength;
    public int typeTag;
    public ClassLoader classLoader;
    public int indexof_currStructTypeFrame;
    public int indexof_srp;
    public int indexof_metaFlag;
    public int indexof_totalLength;
    public int indexof_currAttrData;
    public int attrCount;
    public int currAttrType;
    public int currAttrLength;
    public boolean isStructTypeHeaderProcessed;

    public DB2Struct(DereferencedNativeArray dereferencedNativeArray, HashMap hashMap, int n2, ClassLoader classLoader) throws SQLException {
        this.nativeStructTypeBuff = dereferencedNativeArray;
        this.typeMapTable = hashMap;
        this.indexof_currStructTypeFrame = n2;
        this.classLoader = classLoader;
        if (this.nativeStructTypeBuff == null) {
            DB2StructConstant.print("Warning! null nativeStructTypeBuff args.");
        }
        if (this.typeMapTable == null) {
            DB2StructConstant.print("Warning! null typeMapTable args.");
        }
    }

    public DB2Struct() {
    }

    public void reset(DereferencedNativeArray dereferencedNativeArray, HashMap hashMap, int n2) throws SQLException {
        this.nativeStructTypeBuff = dereferencedNativeArray;
        this.typeMapTable = hashMap;
        this.indexof_currStructTypeFrame = n2;
    }

    public void reset() throws SQLException {
        this.indexof_currStructTypeFrame = 0;
    }

    public static HashMap loadTypeMap(NativeArray nativeArray, boolean bl2) throws SQLException {
        if (nativeArray == null) {
            DB2Struct.error("Bad Input args");
        }
        HashMap<Object, TypeMapTableElement> hashMap = new HashMap<Object, TypeMapTableElement>();
        int n2 = nativeArray.getInt(0);
        int n3 = 4;
        File file = new File(System.getProperty("user.dir") + "/dump_java.txt");
        FileWriter fileWriter = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = nativeArray.getInt(n3);
            short s2 = nativeArray.getShort(n3 += 4);
            String string = nativeArray.getString(n3 += 2);
            if (string == null) {
                DB2Struct.error("Found Null Class Name in TypeMap !!");
            }
            n3 += 2 + string.length();
            try {
                fileWriter = new FileWriter(file);
                if (bl2) {
                    hashMap.put(new Integer(n4), new TypeMapTableElement(n4, s2, string));
                    continue;
                }
                hashMap.put(string, new TypeMapTableElement(n4, s2, string));
                continue;
            }
            catch (Exception exception) {
                try {
                    fileWriter.write(exception.getMessage());
                    fileWriter.close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return hashMap;
    }

    public void nextAttr() throws SQLException {
        this.indexof_srp = this.indexof_srp == 0 ? 32 : (this.indexof_srp += 8);
        this.indexof_metaFlag = this.indexof_metaFlag == 0 ? 32 + this.numAttr * 8 : (this.indexof_metaFlag += 2);
    }

    public static void error(String string) throws SQLException {
        try {
            FileWriter fileWriter = new FileWriter(System.getProperty("user.dir") + "/java.txt", true);
            fileWriter.write("Exception : " + string + "\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new DB2StructException(string);
    }
}

