/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.ClobReader;
import COM.ibm.db2.app.ClobWithIO;
import COM.ibm.db2.app.ClobWriter;
import COM.ibm.db2.app.Lob;
import java.io.Reader;
import java.io.Writer;

class ClobWithDB2Buffer
extends Lob
implements ClobWithIO {
    long bufferPtr;
    int bufferSize;
    long bufferUsedPtr;
    int bufferType;
    int bufferCodepage;

    ClobWithDB2Buffer(long l2, int n2, long l3, int n3, int n4) throws Exception {
        this.bufferPtr = l2;
        this.bufferSize = n2;
        this.bufferUsedPtr = l3;
        this.bufferType = n3;
        this.bufferCodepage = n4;
    }

    @Override
    public void close() {
        this.bufferPtr = 0L;
    }

    @Override
    void assertOpen() throws Exception {
        if (this.bufferPtr == 0L) {
            throw new Exception("Clob is closed.");
        }
    }

    @Override
    public long size() throws Exception {
        this.assertOpen();
        return ClobWithDB2Buffer.getSize(this.bufferUsedPtr, this.bufferType, this.bufferCodepage);
    }

    @Override
    public Reader getReader() throws Exception {
        return new ClobReader(this);
    }

    @Override
    public Writer getWriter() throws Exception {
        return new ClobWriter(this);
    }

    @Override
    public synchronized void append(char[] cArray, int n2, int n3) throws Exception {
        this.assertOpen();
        if (this.size() + (long)n3 > (long)this.bufferSize) {
            throw new Exception("cannot exceed maximum length: " + this.bufferSize);
        }
        ClobWithDB2Buffer.doAppend(cArray, n2, n3, this.bufferPtr, this.bufferUsedPtr, this.bufferType, this.bufferCodepage);
    }

    @Override
    public synchronized int substr(int n2, char[] cArray, int n3, int n4) throws Exception {
        this.assertOpen();
        int n5 = Math.min((int)this.size() - n2, n4);
        ClobWithDB2Buffer.doSubstr(n2, cArray, n3, n4, this.bufferPtr, this.bufferType, this.bufferCodepage);
        return n5;
    }

    static native int getSize(long var0, int var2, int var3) throws Exception;

    static native void doAppend(char[] var0, int var1, int var2, long var3, long var5, int var7, int var8) throws Exception;

    static native void doSubstr(int var0, char[] var1, int var2, int var3, long var4, int var6, int var7) throws Exception;
}

