/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.java2d;

import com.eteks.awt.PJAGraphicsManager;
import com.eteks.java2d.PJABufferedImage;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;

public class PJAGraphicsConfiguration
extends GraphicsConfiguration {
    private GraphicsDevice device;

    public PJAGraphicsConfiguration(GraphicsDevice graphicsDevice) {
        this.device = graphicsDevice;
    }

    public GraphicsDevice getDevice() {
        return this.device;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        ColorModel colorModel = this.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new PJABufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                return this.createCompatibleImage(n, n2);
            }
            case 2: 
            case 3: {
                ColorModel colorModel = this.getColorModel(n3);
                WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
                return new PJABufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            }
        }
        throw new IllegalArgumentException("Unknown transparency type " + n3);
    }

    public ColorModel getColorModel() {
        return PJAGraphicsManager.getDefaultGraphicsManager().getColorModel();
    }

    public ColorModel getColorModel(int n) {
        if (n == 1) {
            return this.getColorModel();
        }
        if (n == 2) {
            return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
        }
        if (n == 3) {
            return ColorModel.getRGBdefault();
        }
        throw new IllegalArgumentException("Unknown transparency type " + n);
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        int n = PJAGraphicsManager.getDefaultGraphicsManager().getScreenResolution();
        double d = (double)n / 72.0;
        double d2 = (double)n / 72.0;
        return new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
    }

    public Rectangle getBounds() {
        PJAGraphicsManager pJAGraphicsManager = PJAGraphicsManager.getDefaultGraphicsManager();
        return new Rectangle(0, 0, pJAGraphicsManager.getScreenWidth(), pJAGraphicsManager.getScreenHeight());
    }
}

