/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.util;

import com.eg.ch.qos.logback.core.util.CharSequenceState;
import java.text.DateFormatSymbols;

class CharSequenceToRegexMapper {
    DateFormatSymbols symbols = DateFormatSymbols.getInstance();

    CharSequenceToRegexMapper() {
    }

    String toRegex(CharSequenceState charSequenceState) {
        int n2 = charSequenceState.occurrences;
        char c10 = charSequenceState.c;
        switch (charSequenceState.c) {
            case 'G': 
            case 'z': {
                return ".*";
            }
            case 'M': {
                if (n2 <= 2) {
                    return this.number(n2);
                }
                if (n2 == 3) {
                    return this.getRegexForShortMonths();
                }
                return this.getRegexForLongMonths();
            }
            case 'D': 
            case 'F': 
            case 'H': 
            case 'K': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': 
            case 'w': 
            case 'y': {
                return this.number(n2);
            }
            case 'E': {
                if (n2 >= 4) {
                    return this.getRegexForLongDaysOfTheWeek();
                }
                return this.getRegexForShortDaysOfTheWeek();
            }
            case 'a': {
                return this.getRegexForAmPms();
            }
            case 'Z': {
                return "(\\+|-)\\d{4}";
            }
            case '.': {
                return "\\.";
            }
            case '\\': {
                throw new IllegalStateException("Forward slashes are not allowed");
            }
            case '\'': {
                if (n2 == 1) {
                    return "";
                }
                throw new IllegalStateException("Too many single quotes");
            }
        }
        if (n2 == 1) {
            return "" + c10;
        }
        return c10 + "{" + n2 + "}";
    }

    private String number(int n2) {
        return "\\d{" + n2 + "}";
    }

    private String getRegexForAmPms() {
        return this.symbolArrayToRegex(this.symbols.getAmPmStrings());
    }

    private String getRegexForLongDaysOfTheWeek() {
        return this.symbolArrayToRegex(this.symbols.getWeekdays());
    }

    private String getRegexForShortDaysOfTheWeek() {
        return this.symbolArrayToRegex(this.symbols.getShortWeekdays());
    }

    private String getRegexForLongMonths() {
        return this.symbolArrayToRegex(this.symbols.getMonths());
    }

    String getRegexForShortMonths() {
        return this.symbolArrayToRegex(this.symbols.getShortMonths());
    }

    private String symbolArrayToRegex(String[] stringArray) {
        int[] nArray = CharSequenceToRegexMapper.findMinMaxLengthsInSymbols(stringArray);
        return ".{" + nArray[0] + "," + nArray[1] + "}";
    }

    static int[] findMinMaxLengthsInSymbols(String[] stringArray) {
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        for (String string : stringArray) {
            int n4 = string.length();
            if (n4 == 0) continue;
            n2 = Math.min(n2, n4);
            n3 = Math.max(n3, n4);
        }
        return new int[]{n2, n3};
    }
}

