/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.boolex;

import com.eg.ch.qos.logback.core.boolex.EvaluationException;
import com.eg.ch.qos.logback.core.spi.ContextAwareBase;
import com.eg.ch.qos.logback.core.spi.LifeCycle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Matcher
extends ContextAwareBase
implements LifeCycle {
    private String regex;
    private String name;
    private boolean caseSensitive = true;
    private boolean canonEq = false;
    private boolean unicodeCase = false;
    private boolean start = false;
    private Pattern pattern;

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String string) {
        this.regex = string;
    }

    public void start() {
        if (this.name == null) {
            this.addError("All Matcher objects must be named");
            return;
        }
        try {
            int n2 = 0;
            if (!this.caseSensitive) {
                n2 |= 2;
            }
            if (this.canonEq) {
                n2 |= 0x80;
            }
            if (this.unicodeCase) {
                n2 |= 0x40;
            }
            this.pattern = Pattern.compile(this.regex, n2);
            this.start = true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.addError("Failed to compile regex [" + this.regex + "]", patternSyntaxException);
        }
    }

    public void stop() {
        this.start = false;
    }

    public boolean isStarted() {
        return this.start;
    }

    public boolean matches(String string) throws EvaluationException {
        if (this.start) {
            java.util.regex.Matcher matcher = this.pattern.matcher(string);
            return matcher.find();
        }
        throw new EvaluationException("Matcher [" + this.regex + "] not started");
    }

    public boolean isCanonEq() {
        return this.canonEq;
    }

    public void setCanonEq(boolean bl2) {
        this.canonEq = bl2;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl2) {
        this.caseSensitive = bl2;
    }

    public boolean isUnicodeCase() {
        return this.unicodeCase;
    }

    public void setUnicodeCase(boolean bl2) {
        this.unicodeCase = bl2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

