/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.client;

import com.oracle.ovm.mgr.ws.client.JacksonContextResolver;
import com.oracle.ovm.mgr.ws.model.AccessGroup;
import com.oracle.ovm.mgr.ws.model.AffinityGroup;
import com.oracle.ovm.mgr.ws.model.Assembly;
import com.oracle.ovm.mgr.ws.model.AssemblyVirtualDisk;
import com.oracle.ovm.mgr.ws.model.AssemblyVm;
import com.oracle.ovm.mgr.ws.model.BaseObject;
import com.oracle.ovm.mgr.ws.model.CloneType;
import com.oracle.ovm.mgr.ws.model.Cluster;
import com.oracle.ovm.mgr.ws.model.ClusterHeartbeatDevice;
import com.oracle.ovm.mgr.ws.model.ClusterStorageFs;
import com.oracle.ovm.mgr.ws.model.ControlDomain;
import com.oracle.ovm.mgr.ws.model.Cpu;
import com.oracle.ovm.mgr.ws.model.CpuCompatibilityGroup;
import com.oracle.ovm.mgr.ws.model.EthernetPort;
import com.oracle.ovm.mgr.ws.model.Event;
import com.oracle.ovm.mgr.ws.model.FileServer;
import com.oracle.ovm.mgr.ws.model.FileServerPlugin;
import com.oracle.ovm.mgr.ws.model.FileSystem;
import com.oracle.ovm.mgr.ws.model.FileSystemMount;
import com.oracle.ovm.mgr.ws.model.Id;
import com.oracle.ovm.mgr.ws.model.Job;
import com.oracle.ovm.mgr.ws.model.KeyValuePair;
import com.oracle.ovm.mgr.ws.model.LoggerManagementAttributes;
import com.oracle.ovm.mgr.ws.model.LoginCertificate;
import com.oracle.ovm.mgr.ws.model.Manager;
import com.oracle.ovm.mgr.ws.model.Network;
import com.oracle.ovm.mgr.ws.model.PeriodicTask;
import com.oracle.ovm.mgr.ws.model.Repository;
import com.oracle.ovm.mgr.ws.model.RepositoryExport;
import com.oracle.ovm.mgr.ws.model.ResourceGroup;
import com.oracle.ovm.mgr.ws.model.Server;
import com.oracle.ovm.mgr.ws.model.ServerController;
import com.oracle.ovm.mgr.ws.model.ServerPool;
import com.oracle.ovm.mgr.ws.model.ServerPoolNetworkPolicy;
import com.oracle.ovm.mgr.ws.model.ServerPoolPolicy;
import com.oracle.ovm.mgr.ws.model.ServerUpdateConfiguration;
import com.oracle.ovm.mgr.ws.model.ServerUpdateRepositoryConfiguration;
import com.oracle.ovm.mgr.ws.model.SimpleId;
import com.oracle.ovm.mgr.ws.model.Statistic;
import com.oracle.ovm.mgr.ws.model.StorageArray;
import com.oracle.ovm.mgr.ws.model.StorageArrayPlugin;
import com.oracle.ovm.mgr.ws.model.StorageElement;
import com.oracle.ovm.mgr.ws.model.StorageInitiator;
import com.oracle.ovm.mgr.ws.model.StoragePath;
import com.oracle.ovm.mgr.ws.model.StorageTarget;
import com.oracle.ovm.mgr.ws.model.VirtualDisk;
import com.oracle.ovm.mgr.ws.model.VirtualNic;
import com.oracle.ovm.mgr.ws.model.VirtualSwitch;
import com.oracle.ovm.mgr.ws.model.VlanInterface;
import com.oracle.ovm.mgr.ws.model.Vm;
import com.oracle.ovm.mgr.ws.model.VmCloneDefinition;
import com.oracle.ovm.mgr.ws.model.VmCloneNetworkMapping;
import com.oracle.ovm.mgr.ws.model.VmCloneStorageMapping;
import com.oracle.ovm.mgr.ws.model.VmDiskMapping;
import com.oracle.ovm.mgr.ws.model.VolumeGroup;
import com.oracle.ovm.mgr.ws.model.WsErrorCode;
import com.oracle.ovm.mgr.ws.model.WsErrorDetails;
import com.oracle.ovm.mgr.ws.model.WsException;
import com.oracle.ovm.mgr.ws.model.Zone;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

public class RestClient {
    public static final String URI_BASE_PATH = "/ovm/core/wsapi/rest";
    String SECURE_PROTOCOL = "https";
    String INSECURE_PROTOCOL = "http";
    private static final Map<Class, GenericType> genericTypeMap = new HashMap<Class, GenericType>();
    private boolean debug = false;
    private URI baseURI;
    private Client webClient = null;
    private List<NewCookie> cookies;
    private String mediaType = "application/xml";
    private Locale locale = null;
    private SSLSocketFactory sslSocketFactory = null;
    private final Map<String, String> headers = new HashMap<String, String>();

    public RestClient() {
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getClasses().add(JacksonContextResolver.class);
        this.webClient = Client.create((ClientConfig)cc);
        this.webClient.setFollowRedirects(Boolean.valueOf(true));
    }

    public RestClient(RestClient client, String uriPathSuffix) {
        this.debug = client.getDebug();
        this.baseURI = uriPathSuffix == null ? client.getBaseURI() : UriBuilder.fromUri((URI)client.getBaseURI()).path(uriPathSuffix).build(new Object[0]);
        this.webClient = client.getWebClient();
        this.cookies = client.getCookies();
        this.mediaType = client.getMediaType();
        this.locale = client.getLocale();
    }

    public RestClient(HostnameVerifier hv, SSLContext sslContext) {
        HTTPSProperties httpsProperties = new HTTPSProperties(hv, sslContext);
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", httpsProperties);
        cc.getClasses().add(JacksonContextResolver.class);
        this.webClient = Client.create((ClientConfig)cc);
        this.webClient.setFollowRedirects(Boolean.valueOf(true));
    }

    public synchronized void setDebug(boolean debug) {
        if (debug != this.debug) {
            this.debug = debug;
            if (debug) {
                this.webClient.addFilter((ClientFilter)new LoggingFilter());
            } else {
                this.webClient.removeAllFilters();
            }
        }
    }

    public synchronized boolean getDebug() {
        return this.debug;
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public synchronized void setLocale(Locale locale) {
        this.locale = locale;
    }

    public synchronized String getMediaType() {
        return this.mediaType;
    }

    public synchronized void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public synchronized URI getBaseURI() {
        return this.baseURI;
    }

    public synchronized void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    public synchronized List<NewCookie> getCookies() {
        return this.cookies;
    }

    public synchronized void setCookies(List<NewCookie> cookies) {
        this.cookies = cookies;
    }

    public synchronized Client getWebClient() {
        return this.webClient;
    }

    public void setUserCredentials(String username, String password) {
        String authHeader = this.getAuthorizationHeaderValue(username, password);
        if (authHeader != null) {
            this.addRequestHeader("Authorization", authHeader);
        }
    }

    public void addRequestHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
    }

    public void removeRequestHeader(String headerName) {
        this.headers.remove(headerName);
    }

    public boolean login(String username, String password, Locale locale, String path) throws WsException {
        try {
            if (this.getCookies() == null) {
                WebResource resource = this.getWebClient().resource(this.getBuilder().path(path).build(new Object[0]));
                WebResource.Builder resourceBuilder = resource.accept(new String[]{this.getMediaType()});
                String authHeader = this.getAuthorizationHeaderValue(username, password);
                if (authHeader != null) {
                    resourceBuilder.header("Authorization", (Object)authHeader);
                }
                if (locale != null) {
                    resourceBuilder.acceptLanguage(new Locale[]{locale});
                }
                ClientResponse response = (ClientResponse)resourceBuilder.post(ClientResponse.class);
                this.setCookies(response.getCookies());
            }
            return true;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    private String getAuthorizationHeaderValue(String username, String password) {
        if (username != null) {
            if (password == null) {
                password = "";
            }
            return "Basic " + new String(Base64.encode((String)(username + ":" + password)));
        }
        return null;
    }

    public void logout() {
        URI uri = this.getBuilder().segment(new String[]{"logout"}).build(new Object[0]);
        WebResource.Builder b = this.getResourceFromURI(uri);
        b.post();
        this.setCookies(null);
    }

    public boolean initialize(String hostname, String port, boolean secure, String path) throws MalformedURLException, URISyntaxException {
        String protocol = null;
        protocol = secure ? this.SECURE_PROTOCOL : this.INSECURE_PROTOCOL;
        URL url = new URL(protocol + "://" + hostname + ":" + port + path);
        return this.initialize(url);
    }

    public synchronized boolean initialize(URL url) throws URISyntaxException {
        this.setBaseURI(url.toURI());
        return true;
    }

    public synchronized void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) throws IOException {
        this.sslSocketFactory = sslSocketFactory;
        HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setDialect(String dialect) {
        String mediaType;
        if (dialect.equalsIgnoreCase("JSON")) {
            mediaType = "application/json";
        } else if (dialect.equalsIgnoreCase("XML")) {
            mediaType = "application/xml";
        } else {
            throw new IllegalArgumentException("Unsupported dialect for OVM REST Client: " + dialect);
        }
        this.setMediaType(mediaType);
    }

    protected WsException convertException(UniformInterfaceException ex) {
        WsException wsException = null;
        if (ex.getResponse().hasEntity()) {
            try {
                WsErrorDetails details = (WsErrorDetails)ex.getResponse().getEntity(WsErrorDetails.class);
                wsException = new WsException(details);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (wsException == null) {
            wsException = new WsException(new WsErrorDetails(null, ex.getMessage()));
        }
        return wsException;
    }

    protected GenericType getGenericListType(Class type) {
        GenericType genericType = genericTypeMap.get(type);
        if (genericType == null) {
            throw new IllegalArgumentException("No Generic Type defined for type " + type.getSimpleName());
        }
        return genericType;
    }

    protected WebResource.Builder getResourceForType(Class<?> type) {
        return this.getResourceFromPathElements(type.getSimpleName());
    }

    protected WebResource.Builder getResourceById(Id<?> id) {
        return this.getResourceFromURI(this.getUri(id));
    }

    protected WebResource.Builder getResourceForCreateChild(Id<?> id, Class<?> childType, Map<String, Object> queryParameters) {
        return this.getResourceFromUriAndPathElementsWithQueryParameters(this.getUri(id), queryParameters, childType.getSimpleName());
    }

    protected WebResource.Builder getResourceForChild(Id<?> parent, Id<?> child) {
        return this.getResourceFromUriAndPathElements(this.getUri(parent), this.getSimpleName(child.getType()), child.getValue());
    }

    protected WebResource.Builder getResourceForAction(Id<?> id, String actionType, Map<String, Object> queryParameters) {
        return this.getResourceFromUriAndPathElementsWithQueryParameters(this.getUri(id), queryParameters, actionType);
    }

    protected WebResource.Builder getResourceFromPathElements(String ... pathElements) {
        return this.getResourceFromUriAndPathElements(null, pathElements);
    }

    protected WebResource.Builder getResourceFromUriAndPathElements(URI baseUri, String ... pathElements) {
        return this.getResourceFromUriAndPathElementsWithQueryParameters(baseUri, null, pathElements);
    }

    protected WebResource.Builder getResourceFromUriAndPathElementsWithQueryParameters(URI baseUri, Map<String, Object> queryParameters, String ... pathElements) {
        UriBuilder b = baseUri == null ? this.getBuilder() : UriBuilder.fromUri((URI)baseUri);
        for (String s : pathElements) {
            b.segment(new String[]{s});
        }
        if (queryParameters != null) {
            for (Map.Entry<String, Object> queryParam : queryParameters.entrySet()) {
                if (queryParam.getValue() == null) continue;
                if (queryParam.getValue() instanceof List) {
                    List valueList = (List)queryParam.getValue();
                    for (Object value : valueList) {
                        b.queryParam(queryParam.getKey(), new Object[]{value});
                    }
                    continue;
                }
                b.queryParam(queryParam.getKey(), new Object[]{queryParam.getValue()});
            }
        }
        return this.getResourceFromURI(b.build(new Object[0]));
    }

    protected synchronized WebResource.Builder getResourceFromURI(URI uri) {
        WebResource.Builder resourceBuilder = this.webClient.resource(uri).getRequestBuilder();
        ((WebResource.Builder)resourceBuilder.accept(new String[]{this.getMediaType()})).type(this.getMediaType());
        if (this.cookies != null) {
            for (NewCookie cookie : this.cookies) {
                resourceBuilder.cookie((Cookie)cookie);
            }
        }
        for (String headerName : this.headers.keySet()) {
            resourceBuilder.header(headerName, (Object)this.headers.get(headerName));
        }
        if (this.locale != null) {
            resourceBuilder.acceptLanguage(new Locale[]{this.locale});
        }
        return resourceBuilder;
    }

    protected synchronized UriBuilder getBuilder() {
        return UriBuilder.fromUri((URI)this.baseURI);
    }

    protected <T> Object createJAXBElement(T objectToConvert) {
        if (this.getMediaType().equals("application/xml") && !objectToConvert.getClass().equals(String.class)) {
            String qname = this.makeInitialLowerCase(objectToConvert.getClass().getSimpleName());
            return new JAXBElement(new QName(qname), objectToConvert.getClass(), objectToConvert);
        }
        return objectToConvert;
    }

    protected String makeInitialLowerCase(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() <= 1) {
            return s.toLowerCase();
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    protected String getSimpleName(String typeName) {
        String simpleName = null;
        String[] components = typeName.split("\\.");
        if (components != null) {
            simpleName = components[components.length - 1];
        }
        return simpleName;
    }

    protected String getSimpleName(Class typeName) {
        return typeName.getSimpleName();
    }

    protected Map<String, Object> createQueryParameterMap(Object ... objects) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        int i = 0;
        while (i + 1 < objects.length) {
            params.put(objects[i].toString(), objects[i + 1]);
            i += 2;
        }
        return params;
    }

    protected <T> List<Id<T>> convertSimpleIdList(List<SimpleId> simpleIds, Class<T> type) {
        ArrayList<Id<T>> idList = new ArrayList<Id<T>>();
        for (SimpleId simpleId : simpleIds) {
            idList.add(new Id(simpleId));
        }
        return idList;
    }

    public <T extends BaseObject<T>> List<Id<T>> getIds(Class<T> type) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(type.getSimpleName(), "id");
            List simpleIdList = (List)b.get((GenericType)new GenericType<List<SimpleId>>(){});
            ArrayList<Id<T>> ids = new ArrayList<Id<T>>(simpleIdList.size());
            for (SimpleId simpleId : simpleIdList) {
                ids.add(new Id(simpleId));
            }
            return ids;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public <T> List<T> getAll(Class<T> type) throws WsException {
        try {
            WebResource.Builder b = this.getResourceForType(type);
            return (List)b.get(this.getGenericListType(type));
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public <T> T getById(Id<T> id, Class<T> type) throws WsException {
        try {
            WebResource.Builder b = this.getResourceById(id);
            return (T)b.get(type);
        }
        catch (UniformInterfaceException ex) {
            WsException wsEx = this.convertException(ex);
            if (wsEx.getErrorDetails().getWsErrorCode() == WsErrorCode.GENERAL_OBJECT_NOT_FOUND) {
                return null;
            }
            throw wsEx;
        }
    }

    protected <T> List<T> getListById(List<Id<T>> ids, Class<T> type) throws WsException {
        ArrayList<T> objects = new ArrayList<T>(ids.size());
        for (Id<T> id : ids) {
            T retrievedObject = this.getById(id, type);
            if (retrievedObject == null) continue;
            objects.add(retrievedObject);
        }
        return objects;
    }

    public <T extends BaseObject<T>> T refresh(T objectToRefresh) throws WsException {
        return (T)((BaseObject)this.getById(objectToRefresh.getId(), objectToRefresh.getClass()));
    }

    public <T extends BaseObject<T>> Job modify(T object) throws WsException {
        try {
            WebResource.Builder b = this.getResourceById(object.getId());
            return (Job)((WebResource.Builder)b.type(this.getMediaType())).put(Job.class, object);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public Job action(Id<?> id, String actionName) throws WsException {
        return this.action(id, actionName, null);
    }

    public Job action(Id<?> id, String actionName, Object argument) throws WsException {
        return this.actionWithQueryParameters(id, actionName, null, argument);
    }

    public Job actionWithQueryParameters(Id<?> id, String actionName, Map<String, Object> queryParameters, Object argument) throws WsException {
        if (argument instanceof List || argument instanceof Map) {
            throw new WsException(new WsErrorDetails(null, "Invalid use of a list or map in argument"));
        }
        try {
            WebResource.Builder b = this.getResourceForAction(id, actionName, queryParameters);
            if (argument != null) {
                ((WebResource.Builder)b.type(this.getMediaType())).entity(this.createJAXBElement(argument));
            }
            return (Job)b.put(Job.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    public URI getUri(Id<?> id) {
        URI uri = id.getUri();
        if (uri == null) {
            if (id.getType() == null || id.getValue() == null) {
                throw new IllegalArgumentException("Unable to determine REST URI for id " + id + ".  The id object must contain a valid URI or must contain both type and value information.");
            }
            UriBuilder b = this.getBuilder();
            b.segment(new String[]{id.getType().getSimpleName()});
            b.segment(new String[]{id.getValue()});
            uri = b.build(new Object[0]);
        }
        return uri;
    }

    static {
        genericTypeMap.put(Vm.class, (GenericType)new GenericType<List<Vm>>(){});
        genericTypeMap.put(Server.class, (GenericType)new GenericType<List<Server>>(){});
        genericTypeMap.put(VirtualNic.class, (GenericType)new GenericType<List<VirtualNic>>(){});
        genericTypeMap.put(Network.class, (GenericType)new GenericType<List<Network>>(){});
        genericTypeMap.put(Manager.class, (GenericType)new GenericType<List<Manager>>(){});
        genericTypeMap.put(Repository.class, (GenericType)new GenericType<List<Repository>>(){});
        genericTypeMap.put(ResourceGroup.class, (GenericType)new GenericType<List<ResourceGroup>>(){});
        genericTypeMap.put(ServerPool.class, (GenericType)new GenericType<List<ServerPool>>(){});
        genericTypeMap.put(VirtualDisk.class, (GenericType)new GenericType<List<VirtualDisk>>(){});
        genericTypeMap.put(String.class, (GenericType)new GenericType<List<String>>(){});
        genericTypeMap.put(AccessGroup.class, (GenericType)new GenericType<List<AccessGroup>>(){});
        genericTypeMap.put(AffinityGroup.class, (GenericType)new GenericType<List<AffinityGroup>>(){});
        genericTypeMap.put(Assembly.class, (GenericType)new GenericType<List<Assembly>>(){});
        genericTypeMap.put(AssemblyVm.class, (GenericType)new GenericType<List<AssemblyVm>>(){});
        genericTypeMap.put(AssemblyVirtualDisk.class, (GenericType)new GenericType<List<AssemblyVirtualDisk>>(){});
        genericTypeMap.put(CloneType.class, (GenericType)new GenericType<List<CloneType>>(){});
        genericTypeMap.put(ClusterStorageFs.class, (GenericType)new GenericType<List<ClusterStorageFs>>(){});
        genericTypeMap.put(Cluster.class, (GenericType)new GenericType<List<Cluster>>(){});
        genericTypeMap.put(ClusterHeartbeatDevice.class, (GenericType)new GenericType<List<ClusterHeartbeatDevice>>(){});
        genericTypeMap.put(FileServer.class, (GenericType)new GenericType<List<FileServer>>(){});
        genericTypeMap.put(FileServerPlugin.class, (GenericType)new GenericType<List<FileServerPlugin>>(){});
        genericTypeMap.put(FileSystem.class, (GenericType)new GenericType<List<FileSystem>>(){});
        genericTypeMap.put(FileSystemMount.class, (GenericType)new GenericType<List<FileSystemMount>>(){});
        genericTypeMap.put(EthernetPort.class, (GenericType)new GenericType<List<EthernetPort>>(){});
        genericTypeMap.put(Event.class, (GenericType)new GenericType<List<Event>>(){});
        genericTypeMap.put(PeriodicTask.class, (GenericType)new GenericType<List<PeriodicTask>>(){});
        genericTypeMap.put(VlanInterface.class, (GenericType)new GenericType<List<VlanInterface>>(){});
        genericTypeMap.put(SimpleId.class, (GenericType)new GenericType<List<SimpleId>>(){});
        genericTypeMap.put(Statistic.class, (GenericType)new GenericType<List<Statistic>>(){});
        genericTypeMap.put(StorageArray.class, (GenericType)new GenericType<List<StorageArray>>(){});
        genericTypeMap.put(StorageArrayPlugin.class, (GenericType)new GenericType<List<StorageArrayPlugin>>(){});
        genericTypeMap.put(StorageElement.class, (GenericType)new GenericType<List<StorageElement>>(){});
        genericTypeMap.put(StorageInitiator.class, (GenericType)new GenericType<List<StorageInitiator>>(){});
        genericTypeMap.put(StoragePath.class, (GenericType)new GenericType<List<StoragePath>>(){});
        genericTypeMap.put(StorageTarget.class, (GenericType)new GenericType<List<StorageTarget>>(){});
        genericTypeMap.put(VolumeGroup.class, (GenericType)new GenericType<List<VolumeGroup>>(){});
        genericTypeMap.put(Job.class, (GenericType)new GenericType<List<Job>>(){});
        genericTypeMap.put(ServerPoolPolicy.class, (GenericType)new GenericType<List<ServerPoolPolicy>>(){});
        genericTypeMap.put(ServerPoolNetworkPolicy.class, (GenericType)new GenericType<List<ServerPoolNetworkPolicy>>(){});
        genericTypeMap.put(VmCloneDefinition.class, (GenericType)new GenericType<List<VmCloneDefinition>>(){});
        genericTypeMap.put(VmCloneNetworkMapping.class, (GenericType)new GenericType<List<VmCloneNetworkMapping>>(){});
        genericTypeMap.put(VmCloneStorageMapping.class, (GenericType)new GenericType<List<VmCloneStorageMapping>>(){});
        genericTypeMap.put(Zone.class, (GenericType)new GenericType<List<Zone>>(){});
        genericTypeMap.put(CpuCompatibilityGroup.class, (GenericType)new GenericType<List<CpuCompatibilityGroup>>(){});
        genericTypeMap.put(ServerController.class, (GenericType)new GenericType<List<ServerController>>(){});
        genericTypeMap.put(RepositoryExport.class, (GenericType)new GenericType<List<RepositoryExport>>(){});
        genericTypeMap.put(ControlDomain.class, (GenericType)new GenericType<List<ControlDomain>>(){});
        genericTypeMap.put(LoggerManagementAttributes.class, (GenericType)new GenericType<List<LoggerManagementAttributes>>(){});
        genericTypeMap.put(Cpu.class, (GenericType)new GenericType<List<Cpu>>(){});
        genericTypeMap.put(VirtualSwitch.class, (GenericType)new GenericType<List<VirtualSwitch>>(){});
        genericTypeMap.put(LoginCertificate.class, (GenericType)new GenericType<List<LoginCertificate>>(){});
        genericTypeMap.put(ServerUpdateConfiguration.class, (GenericType)new GenericType<List<ServerUpdateConfiguration>>(){});
        genericTypeMap.put(ServerUpdateRepositoryConfiguration.class, (GenericType)new GenericType<List<ServerUpdateRepositoryConfiguration>>(){});
        genericTypeMap.put(KeyValuePair.class, (GenericType)new GenericType<List<KeyValuePair>>(){});
        genericTypeMap.put(VmDiskMapping.class, (GenericType)new GenericType<List<VmDiskMapping>>(){});
    }
}

