/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.client;

import com.oracle.ovm.mgr.ws.client.OvmWsUtilitiesClient;
import com.oracle.ovm.mgr.ws.client.RestClient;
import com.oracle.ovm.mgr.ws.model.ArchiveManagementAttributes;
import com.oracle.ovm.mgr.ws.model.BackupManagementAttributes;
import com.oracle.ovm.mgr.ws.model.BaseObject;
import com.oracle.ovm.mgr.ws.model.BusinessSelection;
import com.oracle.ovm.mgr.ws.model.CloneTargetType;
import com.oracle.ovm.mgr.ws.model.CloneType;
import com.oracle.ovm.mgr.ws.model.Cluster;
import com.oracle.ovm.mgr.ws.model.ClusterStorageFs;
import com.oracle.ovm.mgr.ws.model.EthernetPort;
import com.oracle.ovm.mgr.ws.model.EventManagementAttributes;
import com.oracle.ovm.mgr.ws.model.FileServer;
import com.oracle.ovm.mgr.ws.model.FileSystem;
import com.oracle.ovm.mgr.ws.model.Hypervisor;
import com.oracle.ovm.mgr.ws.model.Id;
import com.oracle.ovm.mgr.ws.model.Job;
import com.oracle.ovm.mgr.ws.model.JobManagementAttributes;
import com.oracle.ovm.mgr.ws.model.LoggerManagementAttributes;
import com.oracle.ovm.mgr.ws.model.LoginCertificate;
import com.oracle.ovm.mgr.ws.model.MacManagementAttributes;
import com.oracle.ovm.mgr.ws.model.Network;
import com.oracle.ovm.mgr.ws.model.PeriodicTask;
import com.oracle.ovm.mgr.ws.model.Repository;
import com.oracle.ovm.mgr.ws.model.Server;
import com.oracle.ovm.mgr.ws.model.ServerEventAttributes;
import com.oracle.ovm.mgr.ws.model.ServerPool;
import com.oracle.ovm.mgr.ws.model.SimpleId;
import com.oracle.ovm.mgr.ws.model.StatisticsManagementAttributes;
import com.oracle.ovm.mgr.ws.model.StorageArray;
import com.oracle.ovm.mgr.ws.model.StorageElement;
import com.oracle.ovm.mgr.ws.model.StorageUse;
import com.oracle.ovm.mgr.ws.model.StringList;
import com.oracle.ovm.mgr.ws.model.Vm;
import com.oracle.ovm.mgr.ws.model.VmCloneDefinition;
import com.oracle.ovm.mgr.ws.model.VolumeGroup;
import com.oracle.ovm.mgr.ws.model.WsException;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;

public class OvmWsUtilitiesRestClient
extends RestClient
implements OvmWsUtilitiesClient {
    private static final String ATTRIBUTES_PATH = "attributes";
    private static final String UTILITIES_PATH = "Utilities";
    private static final String BUSINESS_MANAGEMENT_PATH = "BusinessManagement";
    private static final String STATISTICS_MANAGEMENT_PATH = "StatisticsManagement";
    private static final String STATISTICS_ATTRIBUTES_PATH = "attributes";
    private static final String MAC_MANAGEMENT_PATH = "MacManagement";
    private static final String MAC_ATTRIBUTES_PATH = "attributes";
    private static final String ARCHIVE_MANAGEMENT_PATH = "ArchiveManagement";
    private static final String ARCHIVE_ATTRIBUTES_PATH = "attributes";
    private static final String BACKUP_MANAGEMENT_PATH = "BackupManagement";
    private static final String BACKUP_ATTRIBUTES_PATH = "attributes";
    private static final String EVENT_MANAGEMENT_PATH = "EventManagement";
    private static final String EVENT_ATTRIBUTES_PATH = "attributes";
    private static final String SVR_EVENT_ATTRIBUTES_PATH = "serverAttributes";
    private static final String JOB_MANAGEMENT_PATH = "JobManagement";
    private static final String JOB_ATTRIBUTES_PATH = "attributes";
    private static final String LOG_MANAGEMENT_PATH = "LogManagement";
    private static final String LOG_LOGGERATTRIBUTES_PATH = "attributes";
    private static final String RAS_MANAGEMENT_PATH = "RasManagement";
    private static final String MODEL_MANAGEMENT_PATH = "ModelManagement";
    private final URI businessManagementURI = UriBuilder.fromUri((URI)this.getBaseURI()).segment(new String[]{"BusinessManagement"}).build(new Object[0]);
    private final URI backupManagementURI = UriBuilder.fromUri((URI)this.getBaseURI()).segment(new String[]{"BackupManagement"}).build(new Object[0]);
    private final URI logManagementURI = UriBuilder.fromUri((URI)this.getBaseURI()).segment(new String[]{"LogManagement"}).build(new Object[0]);
    private final URI jobManagementURI = UriBuilder.fromUri((URI)this.getBaseURI()).segment(new String[]{"JobManagement"}).build(new Object[0]);
    private final URI modelManagementURI = UriBuilder.fromUri((URI)this.getBaseURI()).segment(new String[]{"ModelManagement"}).build(new Object[0]);

    public OvmWsUtilitiesRestClient(RestClient parentClient) {
        super(parentClient, UTILITIES_PATH);
    }

    @Override
    public BusinessSelection<EthernetPort> utilGetAvailableEthernetPorts(Id<Server> serverId, Id<Network> networkId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("serverId", serverId.getValue());
            if (networkId != null) {
                queryParameters.put("networkId", networkId.getValue());
            }
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "availableEthernetPorts");
            BusinessSelection ethernetPorts = (BusinessSelection)b.get(BusinessSelection.class);
            return ethernetPorts;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<FileSystem> utilGetAvailableFileSystems(Id<FileServer> fileServerId, StorageUse intendedUse) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap(new Object[]{"fileServerId", fileServerId.getValue(), "intendedUse", intendedUse});
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "availableFileSystems");
            BusinessSelection fileSystems = (BusinessSelection)b.get(BusinessSelection.class);
            return fileSystems;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<Network> utilGetAvailableNetworksForVm(Id<Vm> vmId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("vmId", vmId.getValue());
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "availableNetworksForVm");
            BusinessSelection networks = (BusinessSelection)b.get(BusinessSelection.class);
            return networks;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Repository>> utilGetAvailableRepositoriesForExport(Id<Server> serverId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("serverId", serverId.getValue());
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "availableRepositoriesForExport");
            List simpleIds = (List)b.get((GenericType)new GenericType<List<SimpleId>>(){});
            ArrayList<Id<Repository>> repositoryIds = new ArrayList<Id<Repository>>();
            for (SimpleId simpleId : simpleIds) {
                repositoryIds.add(new Id(simpleId));
            }
            return repositoryIds;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetAvailableServers() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.businessManagementURI, "availableServers");
            BusinessSelection servers = (BusinessSelection)b.get(BusinessSelection.class);
            return servers;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetAvailableServersForRepository(Id<Repository> repositoryId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("repositoryId", repositoryId.getValue());
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "availableServersForRepository");
            BusinessSelection servers = (BusinessSelection)b.get(BusinessSelection.class);
            return servers;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetAvailableServersForServerPool(Id<ServerPool> serverPoolId, Server.ProcessorType cpuArchitectureType, Hypervisor.HypervisorType hypervisorType) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap(new Object[]{"serverPoolId", serverPoolId.getValue(), "cpuArchitectureType", cpuArchitectureType, "hypervisorType", hypervisorType});
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "availableServersForServerPool");
            BusinessSelection servers = (BusinessSelection)b.get(BusinessSelection.class);
            return servers;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetAvailableServersForVm(Id<Vm> vmId, List<Id<Server>> serverIds) throws WsException {
        try {
            ArrayList<String> idStrings = new ArrayList<String>();
            for (Id<Server> serverId : serverIds) {
                idStrings.add(serverId.getValue());
            }
            Map<String, Object> queryParameters = this.createQueryParameterMap("vmId", vmId.getValue(), "serverId", idStrings);
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "availableServersForVm");
            BusinessSelection servers = (BusinessSelection)b.get(BusinessSelection.class);
            return servers;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<Repository> utilGetAvailableRepositoriesForVm(Id<Vm> vmId) throws WsException {
        try {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            if (vmId != null) {
                queryParameters.put("vmId", vmId.getValue());
            }
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "availableRepositoriesForVm");
            BusinessSelection repos = (BusinessSelection)b.get(BusinessSelection.class);
            return repos;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetAvailableServersForVmClone(Id<Vm> vmId, Id<VmCloneDefinition> vmCloneDefinitionId, Id<Repository> targetRepositoryId, List<Id<Server>> serverIds) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("vmId", vmId.getValue());
            if (vmCloneDefinitionId != null) {
                queryParameters.put("vmCloneDefinitionId", vmCloneDefinitionId.getValue());
            }
            if (targetRepositoryId != null) {
                queryParameters.put("targetRepositoryId", targetRepositoryId.getValue());
            }
            if (vmCloneDefinitionId != null) {
                queryParameters.put("vmCloneDefinitionId", vmCloneDefinitionId.getValue());
            }
            if (serverIds != null) {
                ArrayList<String> idStrings = new ArrayList<String>();
                for (Id<Server> serverId : serverIds) {
                    idStrings.add(serverId.getValue());
                }
                queryParameters.put("serverId", idStrings);
            }
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "availableServersForVmClone");
            BusinessSelection servers = (BusinessSelection)b.get(BusinessSelection.class);
            return servers;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<ServerPool> utilGetAvailableServerPoolsForVmClone(Id<Vm> vmId, Id<VmCloneDefinition> vmCloneDefinitionId, Id<Repository> targetRepositoryId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("vmId", vmId.getValue());
            if (vmCloneDefinitionId != null) {
                queryParameters.put("vmCloneDefinitionId", vmCloneDefinitionId.getValue());
            }
            if (targetRepositoryId != null) {
                queryParameters.put("targetRepositoryId", targetRepositoryId.getValue());
            }
            if (vmCloneDefinitionId != null) {
                queryParameters.put("vmCloneDefinitionId", vmCloneDefinitionId.getValue());
            }
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "availableServerPoolsForVmClone");
            BusinessSelection serverPools = (BusinessSelection)b.get(BusinessSelection.class);
            return serverPools;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<StorageElement> utilGetAvailableStorageElements(List<Id<StorageElement>> candidateStorageElementIds, StorageUse intendedUse) throws WsException {
        try {
            ArrayList<String> idStrings = new ArrayList<String>();
            for (Id<StorageElement> storageElementId : candidateStorageElementIds) {
                idStrings.add(storageElementId.getValue());
            }
            Map<String, Object> queryParameters = this.createQueryParameterMap(new Object[]{"candidateStorageElementId", idStrings, "intendedUse", intendedUse});
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "availableStorageElements");
            BusinessSelection storageElements = (BusinessSelection)b.get(BusinessSelection.class);
            return storageElements;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<StorageElement> utilGetAvailableStorageElementsForVm(Id<Vm> vmId) throws WsException {
        try {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            if (vmId != null) {
                queryParameters.put("vmId", vmId.getValue());
            }
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "availableStorageElementsForVm");
            BusinessSelection storageElements = (BusinessSelection)b.get(BusinessSelection.class);
            return storageElements;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<? extends BaseObject> utilGetCloneTargets(Id<Vm> vmId, Id<?> sourceDiskId, CloneTargetType targetType) throws WsException {
        try {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            if (vmId != null) {
                queryParameters.put("vmId", vmId.getValue());
            }
            queryParameters.put("sourceDiskId", sourceDiskId.getValue());
            queryParameters.put("targetType", (Object)targetType);
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "cloneTargets");
            BusinessSelection selection = (BusinessSelection)b.get(BusinessSelection.class);
            return selection;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<CloneType> utilGetCloneTypes(Id<?> sourceDiskId, Id<?> cloneTargetId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("sourceDiskId", sourceDiskId.getValue(), "cloneTargetId", cloneTargetId.getValue());
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "cloneTypes");
            List cloneTypes = (List)b.get(this.getGenericListType(CloneType.class));
            return cloneTypes;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<FileSystem>> utilGetClusteredFileSystems() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.businessManagementURI, "clusteredFileSystems");
            List simpleIds = (List)b.get(this.getGenericListType(SimpleId.class));
            List<Id<FileSystem>> fileSystemIds = this.convertSimpleIdList(simpleIds, FileSystem.class);
            return fileSystemIds;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<ServerPool>> utilGetClusteredServerPools() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.businessManagementURI, "clusteredServerPools");
            List simpleIds = (List)b.get(this.getGenericListType(SimpleId.class));
            ArrayList<Id<ServerPool>> serverPoolIds = new ArrayList<Id<ServerPool>>();
            for (SimpleId simpleId : simpleIds) {
                serverPoolIds.add(new Id(simpleId));
            }
            return serverPoolIds;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<ClusterStorageFs>> utilGetClusterStorageFs(Id<Cluster> clusterId) throws WsException {
        try {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            queryParameters.put("clusterId", clusterId.getValue());
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "clusterStorageFs");
            List simpleIds = (List)b.get(this.getGenericListType(SimpleId.class));
            ArrayList<Id<ClusterStorageFs>> clusterStorageFsIds = new ArrayList<Id<ClusterStorageFs>>();
            for (SimpleId simpleId : simpleIds) {
                clusterStorageFsIds.add(new Id(simpleId));
            }
            return clusterStorageFsIds;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<?>> utilGetEthernetDevicesWithIpAddress(String ipAddress) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("ipAddress", ipAddress);
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "ethernetDevicesWithIpAddress");
            List simpleIds = (List)b.get(this.getGenericListType(SimpleId.class));
            ArrayList idList = new ArrayList();
            for (SimpleId simpleId : simpleIds) {
                idList.add(new Id(simpleId));
            }
            return idList;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<FileSystem>> utilGetLocalFileSystems() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.businessManagementURI, "localFileSystems");
            List simpleIds = (List)b.get(this.getGenericListType(SimpleId.class));
            List<Id<FileSystem>> fileSystemIds = this.convertSimpleIdList(simpleIds, FileSystem.class);
            return fileSystemIds;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Network>> utilGetNetworksOnServers(List<Id<Server>> serverIds) throws WsException {
        try {
            ArrayList<String> idStrings = new ArrayList<String>();
            for (Id<Server> serverId : serverIds) {
                idStrings.add(serverId.getValue());
            }
            Map<String, Object> queryParameters = this.createQueryParameterMap("serverId", idStrings);
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "networksOnServers");
            List simpleIds = (List)b.get(this.getGenericListType(SimpleId.class));
            ArrayList<Id<Network>> networkIds = new ArrayList<Id<Network>>();
            for (SimpleId simpleId : simpleIds) {
                networkIds.add(new Id(simpleId));
            }
            return networkIds;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Server>> utilGetServersByStorageElement(Id<StorageElement> storageElementId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("storageElementId", storageElementId.getValue());
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "serversByStorageElement");
            List simpleIds = (List)b.get(this.getGenericListType(SimpleId.class));
            ArrayList<Id<Server>> serverIds = new ArrayList<Id<Server>>();
            for (SimpleId simpleId : simpleIds) {
                serverIds.add(new Id(simpleId));
            }
            return serverIds;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<StorageArray> utilGetStorageArraysWithAvailableStorageElements(Id<ServerPool> serverPoolId, StorageUse intendedUse) throws WsException {
        try {
            String poolIdValue = null;
            if (serverPoolId != null) {
                poolIdValue = serverPoolId.getValue();
            }
            Map<String, Object> queryParameters = this.createQueryParameterMap(new Object[]{"serverPoolId", poolIdValue, "intendedUse", intendedUse});
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "storageArraysWithAvailableStorageElements");
            BusinessSelection storageArrays = (BusinessSelection)b.get(BusinessSelection.class);
            return storageArrays;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<VolumeGroup> utilGetVolumeGroupsWithAvailableStorageElements(Id<StorageArray> storageArrayId, StorageUse intendedUse) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap(new Object[]{"storageArrayId", storageArrayId.getValue(), "intendedUse", intendedUse});
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "volumeGroupsWithAvailableStorageElements");
            BusinessSelection volumeGroups = (BusinessSelection)b.get(BusinessSelection.class);
            return volumeGroups;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetWorkerServersForFileServer(Id<FileServer> fileServerId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("fileServerId", fileServerId.getValue());
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "workerServersForFileServer");
            BusinessSelection servers = (BusinessSelection)b.get(BusinessSelection.class);
            return servers;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetWorkerServersForFileSystem(Id<FileSystem> fileSystemId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("fileSystemId", fileSystemId.getValue());
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "workerServersForFileSystem");
            BusinessSelection servers = (BusinessSelection)b.get(BusinessSelection.class);
            return servers;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Id<Server> utilGetWorkerServerForServerPool(Id<ServerPool> serverPoolId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("serverPoolId", serverPoolId.getValue());
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "workerServerForServerPool");
            SimpleId simpleId = (SimpleId)b.get(SimpleId.class);
            Id serverId = null;
            if (simpleId != null) {
                serverId = new Id(simpleId);
            }
            return serverId;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetWorkerServersForStorageArray(Id<StorageArray> storageArrayId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("storageArrayId", storageArrayId.getValue());
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "workerServersForStorageArray");
            BusinessSelection servers = (BusinessSelection)b.get(BusinessSelection.class);
            return servers;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BusinessSelection<Server> utilGetWorkerServersForRepository(Id<Repository> repositoryId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("repositoryId", repositoryId.getValue());
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "workerServersForRepository");
            BusinessSelection servers = (BusinessSelection)b.get(BusinessSelection.class);
            return servers;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public boolean utilIsThinCloneSupported(Id<?> cloneTargetId) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("cloneTargetId", cloneTargetId.getValue());
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.businessManagementURI, queryParameters, "thinCloneSupported");
            boolean supported = Boolean.parseBoolean((String)b.get(String.class));
            return supported;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public StatisticsManagementAttributes statisticsManagementAttributesGet() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(STATISTICS_MANAGEMENT_PATH, "attributes");
            return (StatisticsManagementAttributes)b.get(StatisticsManagementAttributes.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job statisticsManagementAttributesModify(StatisticsManagementAttributes attributes) throws WsException {
        WebResource.Builder b = this.getResourceFromPathElements(STATISTICS_MANAGEMENT_PATH, "attributes");
        if (attributes != null) {
            ((WebResource.Builder)b.type(this.getMediaType())).entity(this.createJAXBElement(attributes));
        }
        return (Job)b.put(Job.class);
    }

    @Override
    public MacManagementAttributes macManagementAttributesGet() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(MAC_MANAGEMENT_PATH, "attributes");
            MacManagementAttributes macManagementAttributes = (MacManagementAttributes)b.get(MacManagementAttributes.class);
            return macManagementAttributes;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job macManagementAttributesModify(MacManagementAttributes macManagementAttributes) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(MAC_MANAGEMENT_PATH, "attributes");
            return (Job)b.put(Job.class, (Object)macManagementAttributes);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ArchiveManagementAttributes archiveManagementAttributesGet() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(ARCHIVE_MANAGEMENT_PATH, "attributes");
            ArchiveManagementAttributes archiveAttributes = (ArchiveManagementAttributes)b.get(ArchiveManagementAttributes.class);
            return archiveAttributes;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job archiveManagementAttributesModify(ArchiveManagementAttributes archiveAttributes) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(ARCHIVE_MANAGEMENT_PATH, "attributes");
            return (Job)b.put(Job.class, (Object)archiveAttributes);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public BackupManagementAttributes backupManagementAttributesGet() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(BACKUP_MANAGEMENT_PATH, "attributes");
            BackupManagementAttributes backupAttributes = (BackupManagementAttributes)b.get(BackupManagementAttributes.class);
            return backupAttributes;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<String> backupManagementGetAvailableBackups() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.backupManagementURI, "availableBackups");
            StringList availableBackups = (StringList)b.get(StringList.class);
            return availableBackups.getStrings();
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job backupManagementStartBackup(String location) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("location", location);
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.backupManagementURI, queryParameters, "startBackup");
            return (Job)b.post(Job.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job backupManagementCleanupOldBackups(int numToKeep) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("numToKeep", numToKeep);
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.backupManagementURI, queryParameters, "cleanupOldBackups");
            return (Job)b.post(Job.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job modelManagementExportModelData() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.modelManagementURI, "exportModelData");
            return (Job)b.post(Job.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job modelManagementCleanupOldExportedModelData(int numToKeep) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("numToKeep", numToKeep);
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.modelManagementURI, queryParameters, "cleanupOldExportedModelData");
            return (Job)b.post(Job.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public EventManagementAttributes eventManagementAttributesGet() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(EVENT_MANAGEMENT_PATH, "attributes");
            EventManagementAttributes eventAttributes = (EventManagementAttributes)b.get(EventManagementAttributes.class);
            return eventAttributes;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job eventManagementAttributesModify(EventManagementAttributes eventAttributes) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(EVENT_MANAGEMENT_PATH, "attributes");
            return (Job)b.put(Job.class, (Object)eventAttributes);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ServerEventAttributes eventManagementServerAttributesGet(Id<Server> serverId) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(EVENT_MANAGEMENT_PATH, SVR_EVENT_ATTRIBUTES_PATH, serverId.getValue());
            ServerEventAttributes attributes = (ServerEventAttributes)b.get(ServerEventAttributes.class);
            return attributes;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job eventManagementServerAttributesModify(Id<Server> serverId, ServerEventAttributes attributes) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(EVENT_MANAGEMENT_PATH, SVR_EVENT_ATTRIBUTES_PATH, serverId.getValue());
            return (Job)b.put(Job.class, (Object)attributes);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public JobManagementAttributes jobManagementAttributesGet() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(JOB_MANAGEMENT_PATH, "attributes");
            JobManagementAttributes jobAttributes = (JobManagementAttributes)b.get(JobManagementAttributes.class);
            return jobAttributes;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job jobManagementAttributesModify(JobManagementAttributes jobAttributes) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(JOB_MANAGEMENT_PATH, "attributes");
            return (Job)b.put(Job.class, (Object)jobAttributes);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Id<Job> jobManagementGetLockingJob(Id<? extends BaseObject> objectId) throws WsException {
        try {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            if (objectId != null) {
                queryParameters.put("objectType", objectId.getType().getCanonicalName());
                queryParameters.put("objectId", objectId.getValue());
            }
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.jobManagementURI, queryParameters, "lockingJob");
            SimpleId simpleJobId = (SimpleId)((WebResource.Builder)b.type(this.getMediaType())).get(SimpleId.class);
            return new Id<Job>(simpleJobId);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<LoggerManagementAttributes> loggerManagementAttributesGet(String name) throws WsException {
        try {
            Map<String, Object> queryParameters = this.createQueryParameterMap("name", name);
            WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.logManagementURI, queryParameters, "attributes");
            List loggerAttributes = (List)b.get(this.getGenericListType(LoggerManagementAttributes.class));
            return loggerAttributes;
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job loggerManagementAttributesModify(List<LoggerManagementAttributes> loggerAttributes) throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(LOG_MANAGEMENT_PATH, "attributes");
            return (Job)b.put(Job.class, (Object)loggerAttributes.toArray(new LoggerManagementAttributes[loggerAttributes.size()]));
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public String rasManagementGenerateUniqueSessionId() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromPathElements(RAS_MANAGEMENT_PATH, "uniqueSessionId");
            return (String)b.get(String.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<PeriodicTask> periodicTaskGetAll() throws WsException {
        return this.getAll(PeriodicTask.class);
    }

    @Override
    public PeriodicTask periodicTaskGetById(Id<PeriodicTask> periodicTaskId) throws WsException {
        return this.getById(periodicTaskId, PeriodicTask.class);
    }

    @Override
    public List<Id<PeriodicTask>> periodicTaskGetIds() throws WsException {
        return this.getIds(PeriodicTask.class);
    }

    @Override
    public List<PeriodicTask> periodicTaskGetListById(List<Id<PeriodicTask>> periodicTaskIds) throws WsException {
        return this.getListById(periodicTaskIds, PeriodicTask.class);
    }

    @Override
    public Job periodicTaskResetToDefaults(Id<PeriodicTask> periodicTaskId) throws WsException {
        return this.action(periodicTaskId, "resetToDefaults");
    }

    @Override
    public Job periodicTaskModify(PeriodicTask periodicTask) throws WsException {
        return this.modify(periodicTask);
    }

    @Override
    public Job modelManagementRefreshModel() throws WsException {
        try {
            WebResource.Builder b = this.getResourceFromUriAndPathElements(this.modelManagementURI, "refreshModel");
            return (Job)b.post(Job.class);
        }
        catch (UniformInterfaceException ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<LoginCertificate> certificateGetAll() throws WsException {
        WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getBaseURI(), "Certificate");
        return (List)b.get(this.getGenericListType(LoginCertificate.class));
    }

    @Override
    public LoginCertificate certificateCreate() throws WsException {
        WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getBaseURI(), "Certificate");
        LoginCertificate loginCertificate = (LoginCertificate)((WebResource.Builder)b.type(this.getMediaType())).post(LoginCertificate.class, (Object)new LoginCertificate());
        return loginCertificate;
    }

    @Override
    public void certificateRegister(LoginCertificate certificate) throws WsException {
        WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getBaseURI(), "Certificate");
        ((WebResource.Builder)b.type(this.getMediaType())).post((Object)certificate);
    }

    @Override
    public LoginCertificate certificateSignAndRegister(LoginCertificate certificate) throws WsException {
        Map<String, Object> queryParameters = this.createQueryParameterMap("sign", true);
        WebResource.Builder b = this.getResourceFromUriAndPathElementsWithQueryParameters(this.getBaseURI(), queryParameters, "Certificate");
        LoginCertificate loginCertificate = (LoginCertificate)((WebResource.Builder)b.type(this.getMediaType())).post(LoginCertificate.class, (Object)certificate);
        return loginCertificate;
    }

    @Override
    public void certificateUnregister(String certificateFingerprint) throws WsException {
        WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getBaseURI(), "Certificate", certificateFingerprint);
        b.delete();
    }

    @Override
    public String certificateGetCaCertificate() throws WsException {
        WebResource.Builder b = this.getResourceFromUriAndPathElements(this.getBaseURI(), "Certificate", "CaCertificate");
        return (String)b.get(String.class);
    }
}

