/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.client;

import com.oracle.ovm.mgr.ws.OvmApi;
import com.oracle.ovm.mgr.ws.OvmApi_Service;
import com.oracle.ovm.mgr.ws.OvmUtilities;
import com.oracle.ovm.mgr.ws.OvmUtilities_Service;
import com.oracle.ovm.mgr.ws.WsException_Exception;
import com.oracle.ovm.mgr.ws.client.OvmWsClient;
import com.oracle.ovm.mgr.ws.client.OvmWsUtilitiesClient;
import com.oracle.ovm.mgr.ws.client.OvmWsUtilitiesSoapClient;
import com.oracle.ovm.mgr.ws.model.AccessGroup;
import com.oracle.ovm.mgr.ws.model.AffinityGroup;
import com.oracle.ovm.mgr.ws.model.Assembly;
import com.oracle.ovm.mgr.ws.model.AssemblyVirtualDisk;
import com.oracle.ovm.mgr.ws.model.AssemblyVm;
import com.oracle.ovm.mgr.ws.model.BaseObject;
import com.oracle.ovm.mgr.ws.model.CloneType;
import com.oracle.ovm.mgr.ws.model.Cluster;
import com.oracle.ovm.mgr.ws.model.ClusterHeartbeatDevice;
import com.oracle.ovm.mgr.ws.model.ClusterStorageFs;
import com.oracle.ovm.mgr.ws.model.ControlDomain;
import com.oracle.ovm.mgr.ws.model.Cpu;
import com.oracle.ovm.mgr.ws.model.CpuCompatibilityGroup;
import com.oracle.ovm.mgr.ws.model.EthernetPort;
import com.oracle.ovm.mgr.ws.model.Event;
import com.oracle.ovm.mgr.ws.model.FileServer;
import com.oracle.ovm.mgr.ws.model.FileServerPlugin;
import com.oracle.ovm.mgr.ws.model.FileSystem;
import com.oracle.ovm.mgr.ws.model.FileSystemMount;
import com.oracle.ovm.mgr.ws.model.Id;
import com.oracle.ovm.mgr.ws.model.Job;
import com.oracle.ovm.mgr.ws.model.KeyValuePair;
import com.oracle.ovm.mgr.ws.model.Manager;
import com.oracle.ovm.mgr.ws.model.Network;
import com.oracle.ovm.mgr.ws.model.PasswordChange;
import com.oracle.ovm.mgr.ws.model.Repository;
import com.oracle.ovm.mgr.ws.model.RepositoryExport;
import com.oracle.ovm.mgr.ws.model.ResourceGroup;
import com.oracle.ovm.mgr.ws.model.Server;
import com.oracle.ovm.mgr.ws.model.ServerController;
import com.oracle.ovm.mgr.ws.model.ServerPool;
import com.oracle.ovm.mgr.ws.model.ServerPoolNetworkPolicy;
import com.oracle.ovm.mgr.ws.model.ServerPoolPolicy;
import com.oracle.ovm.mgr.ws.model.ServerUpdateConfiguration;
import com.oracle.ovm.mgr.ws.model.ServerUpdateRepositoryConfiguration;
import com.oracle.ovm.mgr.ws.model.SessionProperties;
import com.oracle.ovm.mgr.ws.model.Statistic;
import com.oracle.ovm.mgr.ws.model.StorageArray;
import com.oracle.ovm.mgr.ws.model.StorageArrayPlugin;
import com.oracle.ovm.mgr.ws.model.StorageElement;
import com.oracle.ovm.mgr.ws.model.StorageInitiator;
import com.oracle.ovm.mgr.ws.model.StoragePath;
import com.oracle.ovm.mgr.ws.model.StorageTarget;
import com.oracle.ovm.mgr.ws.model.VirtualDisk;
import com.oracle.ovm.mgr.ws.model.VirtualNic;
import com.oracle.ovm.mgr.ws.model.VirtualSwitch;
import com.oracle.ovm.mgr.ws.model.VlanInterface;
import com.oracle.ovm.mgr.ws.model.Vm;
import com.oracle.ovm.mgr.ws.model.VmCloneDefinition;
import com.oracle.ovm.mgr.ws.model.VmCloneNetworkMapping;
import com.oracle.ovm.mgr.ws.model.VmCloneStorageMapping;
import com.oracle.ovm.mgr.ws.model.VmDiskMapping;
import com.oracle.ovm.mgr.ws.model.VmMessageType;
import com.oracle.ovm.mgr.ws.model.VolumeGroup;
import com.oracle.ovm.mgr.ws.model.WsException;
import com.oracle.ovm.mgr.ws.model.Zone;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;

public class OvmWsSoapClient
implements OvmWsClient {
    protected static final String WSAPI_BASE_PATH = "/ovm/core/wsapi/soap";
    private static final String WSDL_LOCATION = "META-INF/wsdl/OvmApi.wsdl";
    private static final String UTILITIES_WSDL_LOCATION = "META-INF/wsdl/OvmUtilities.wsdl";
    private static final String JAXWS_DEBUG_PROP = "com.sun.xml.ws.transport.http.client.HttpTransportPipe.dump";
    private static final String JAXWS_DEBUG_PROP2 = "com.sun.xml.internal.ws.transport.http.client.HttpTransportPipe.dump";
    private static final String JAXWS_SOCKET_FACTORY_PROP = "com.sun.xml.ws.transport.https.client.SSLSocketFactory";
    private static final String JAXWS_SOCKET_FACTORY_PROP2 = "com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory";
    private OvmApi api;
    private String hostname;
    private int port;
    private String protocol;
    private SSLSocketFactory sslSocketFactory;

    @Override
    public void setDebug(boolean debug) {
        System.setProperty(JAXWS_DEBUG_PROP, Boolean.toString(debug));
        System.setProperty(JAXWS_DEBUG_PROP2, Boolean.toString(debug));
    }

    @Override
    public void setDialect(String dialect) {
    }

    @Override
    public boolean initialize(String hostname, String port, boolean secure) throws MalformedURLException {
        String protocol = secure ? "https" : "http";
        URL url = new URL(protocol + "://" + hostname + ":" + port + WSAPI_BASE_PATH);
        return this.initialize(url);
    }

    @Override
    public boolean initialize(URL url) {
        this.hostname = url.getHost();
        this.port = url.getPort();
        this.protocol = url.getProtocol();
        URL resource = this.getClass().getClassLoader().getResource(WSDL_LOCATION);
        if (resource == null) {
            resource = url;
        }
        OvmApi_Service service = new OvmApi_Service(resource);
        this.api = service.getOvmApiPort();
        this.getBindingProvider().getRequestContext().put("javax.xml.ws.service.endpoint.address", url.toString());
        this.getBindingProvider().getRequestContext().put("javax.xml.ws.session.maintain", true);
        return true;
    }

    public BindingProvider getBindingProvider() {
        return (BindingProvider)this.api;
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) throws IOException {
        this.sslSocketFactory = sslSocketFactory;
        this.getBindingProvider().getRequestContext().put(JAXWS_SOCKET_FACTORY_PROP, sslSocketFactory);
        this.getBindingProvider().getRequestContext().put(JAXWS_SOCKET_FACTORY_PROP2, sslSocketFactory);
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    private WsException convertException(WsException_Exception ex) {
        return new WsException(ex.getFaultInfo().getErrorDetails());
    }

    @Override
    public boolean login(String username, String password, Locale locale) throws WsException {
        try {
            SessionProperties props = new SessionProperties();
            props.setLocale(locale.toString());
            return this.api.login(username, password, props);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void authenticate(String s) {
    }

    @Override
    public void logout() throws WsException {
        try {
            this.api.logout();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public OvmWsUtilitiesClient getWsUtilities() throws WsException, MalformedURLException {
        return this.getWsUtilities(this.getWsUtilitiesURL());
    }

    protected OvmWsUtilitiesClient getWsUtilities(URL url) {
        URL resource = this.getClass().getClassLoader().getResource(UTILITIES_WSDL_LOCATION);
        if (resource == null) {
            resource = url;
        }
        OvmUtilities_Service utilitiesService = new OvmUtilities_Service();
        OvmUtilities utilityApi = (OvmUtilities)utilitiesService.getPort((EndpointReference)this.api.getOvmWsUtilitiesEndpoint(), OvmUtilities.class, new WebServiceFeature[]{new AddressingFeature()});
        return new OvmWsUtilitiesSoapClient(utilityApi);
    }

    protected URL getWsUtilitiesURL() throws MalformedURLException {
        return new URL(this.protocol + "://" + this.hostname + ":" + this.port + WSAPI_BASE_PATH + "/utilities");
    }

    @Override
    public List<AccessGroup> accessGroupGetAll() throws WsException {
        try {
            return this.api.accessGroupGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<AccessGroup>> accessGroupGetIds() throws WsException {
        try {
            return this.api.accessGroupGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public AccessGroup accessGroupGetById(Id<AccessGroup> accessGroupId) throws WsException {
        try {
            return this.api.accessGroupGetById(accessGroupId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<AccessGroup> accessGroupGetListById(List<Id<AccessGroup>> accessGroupIds) throws WsException {
        try {
            return this.api.accessGroupGetListById(accessGroupIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job accessGroupModify(AccessGroup accessGroup) throws WsException {
        try {
            return this.api.accessGroupModify(accessGroup);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job accessGroupAddStorageElement(Id<AccessGroup> accessGroupId, Id<StorageElement> storageElementId) throws WsException {
        try {
            return this.api.accessGroupAddStorageElement(accessGroupId, storageElementId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job accessGroupRemoveStorageElement(Id<AccessGroup> accessGroupId, Id<StorageElement> storageElementId) throws WsException {
        try {
            return this.api.accessGroupRemoveStorageElement(accessGroupId, storageElementId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job accessGroupAddStorageInitiator(Id<AccessGroup> accessGroupId, Id<StorageInitiator> storageInitiatorId) throws WsException {
        try {
            return this.api.accessGroupAddStorageInitiator(accessGroupId, storageInitiatorId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job accessGroupRemoveStorageInitiator(Id<AccessGroup> accessGroupId, Id<StorageInitiator> storageInitiatorId) throws WsException {
        try {
            return this.api.accessGroupRemoveStorageInitiator(accessGroupId, storageInitiatorId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job accessGroupAddServer(Id<AccessGroup> accessGroupId, Id<Server> serverId) throws WsException {
        try {
            return this.api.accessGroupAddServer(accessGroupId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job accessGroupRemoveServer(Id<AccessGroup> accessGroupId, Id<Server> serverId) throws WsException {
        try {
            return this.api.accessGroupRemoveServer(accessGroupId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job accessGroupAddFileSystem(Id<AccessGroup> accessGroupId, Id<FileSystem> fileSystemId) throws WsException {
        try {
            return this.api.accessGroupAddFileSystem(accessGroupId, fileSystemId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job accessGroupRemoveFileSystem(Id<AccessGroup> accessGroupId, Id<FileSystem> fileSystemId) throws WsException {
        try {
            return this.api.accessGroupRemoveFileSystem(accessGroupId, fileSystemId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job accessGroupRefresh(Id<AccessGroup> accessGroupId) throws WsException {
        try {
            return this.api.accessGroupRefresh(accessGroupId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job affinityGroupAddServer(Id<AffinityGroup> affinityGroupId, Id<Server> serverId) throws WsException {
        try {
            return this.api.affinityGroupAddServer(affinityGroupId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job affinityGroupRemoveServer(Id<AffinityGroup> affinityGroupId, Id<Server> serverId) throws WsException {
        try {
            return this.api.affinityGroupRemoveServer(affinityGroupId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job affinityGroupAddVm(Id<AffinityGroup> affinityGroupId, Id<Vm> vmId) throws WsException {
        try {
            return this.api.affinityGroupAddVm(affinityGroupId, vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job affinityGroupRemoveVm(Id<AffinityGroup> affinityGroupId, Id<Vm> vmId) throws WsException {
        try {
            return this.api.affinityGroupRemoveVm(affinityGroupId, vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<AffinityGroup> affinityGroupGetAll() throws WsException {
        try {
            return this.api.affinityGroupGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<AffinityGroup>> affinityGroupGetIds() throws WsException {
        try {
            return this.api.affinityGroupGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public AffinityGroup affinityGroupGetById(Id<AffinityGroup> affinityGroupId) throws WsException {
        try {
            return this.api.affinityGroupGetById(affinityGroupId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<AffinityGroup> affinityGroupGetListById(List<Id<AffinityGroup>> affinityGroupIds) throws WsException {
        try {
            return this.api.affinityGroupGetListById(affinityGroupIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job affinityGroupModify(AffinityGroup affinityGroup) throws WsException {
        try {
            return this.api.affinityGroupModify(affinityGroup);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Assembly> assemblyGetAll() throws WsException {
        try {
            return this.api.assemblyGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Assembly>> assemblyGetIds() throws WsException {
        try {
            return this.api.assemblyGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Assembly assemblyGetById(Id<Assembly> assemblyId) throws WsException {
        try {
            return this.api.assemblyGetById(assemblyId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Assembly> assemblyGetListById(List<Id<Assembly>> assemblyIds) throws WsException {
        try {
            return this.api.assemblyGetListById(assemblyIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job assemblyModify(Assembly assembly) throws WsException {
        try {
            return this.api.assemblyModify(assembly);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public String assemblyGetDescriptor(Id<Assembly> assemblyId) throws WsException {
        try {
            return this.api.assemblyGetDescriptor(assemblyId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job assemblyRefresh(Id<Assembly> assemblyId) throws WsException {
        try {
            return this.api.assemblyRefresh(assemblyId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<AssemblyVm> assemblyVmGetAll() throws WsException {
        try {
            return this.api.assemblyVmGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<AssemblyVm>> assemblyVmGetIds() throws WsException {
        try {
            return this.api.assemblyVmGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public AssemblyVm assemblyVmGetById(Id<AssemblyVm> assemblyVmId) throws WsException {
        try {
            return this.api.assemblyVmGetById(assemblyVmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<AssemblyVm> assemblyVmGetListById(List<Id<AssemblyVm>> assemblyVmIds) throws WsException {
        try {
            return this.api.assemblyVmGetListById(assemblyVmIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job assemblyVmModify(AssemblyVm assemblyVm) throws WsException {
        try {
            return this.api.assemblyVmModify(assemblyVm);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<AssemblyVirtualDisk> assemblyVirtualDiskGetAll() throws WsException {
        try {
            return this.api.assemblyVirtualDiskGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<AssemblyVirtualDisk>> assemblyVirtualDiskGetIds() throws WsException {
        try {
            return this.api.assemblyVirtualDiskGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job assemblyVirtualDiskModify(AssemblyVirtualDisk assemblyVirtualDisk) throws WsException {
        try {
            return this.api.assemblyVirtualDiskModify(assemblyVirtualDisk);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public AssemblyVirtualDisk assemblyVirtualDiskGetById(Id<AssemblyVirtualDisk> assemblyVirtualDiskId) throws WsException {
        try {
            return this.api.assemblyVirtualDiskGetById(assemblyVirtualDiskId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<AssemblyVirtualDisk> assemblyVirtualDiskGetListById(List<Id<AssemblyVirtualDisk>> assemblyVirtualDiskIds) throws WsException {
        try {
            return this.api.assemblyVirtualDiskGetListById(assemblyVirtualDiskIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job clusterCreateHeartbeatDevice(Id<Cluster> clusterId, ClusterHeartbeatDevice heartbeatDevice) throws WsException {
        try {
            return this.api.clusterCreateHeartbeatDevice(clusterId, heartbeatDevice);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job clusterDeleteHeartbeatDevice(Id<Cluster> clusterId, Id<ClusterHeartbeatDevice> heartbeatDeviceId) throws WsException {
        try {
            return this.api.clusterDeleteHeartbeatDevice(clusterId, heartbeatDeviceId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job clusterAddFileSystem(Id<Cluster> clusterId, Id<FileSystem> fileSystemId) throws WsException {
        try {
            return this.api.clusterAddFileSystem(clusterId, fileSystemId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job clusterRemoveFileSystem(Id<Cluster> clusterId, Id<FileSystem> fileSystemId) throws WsException {
        try {
            return this.api.clusterRemoveFileSystem(clusterId, fileSystemId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Cluster> clusterGetAll() throws WsException {
        try {
            return this.api.clusterGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Cluster>> clusterGetIds() throws WsException {
        try {
            return this.api.clusterGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Cluster clusterGetById(Id<Cluster> clusterId) throws WsException {
        try {
            return this.api.clusterGetById(clusterId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Cluster> clusterGetListById(List<Id<Cluster>> clusterIds) throws WsException {
        try {
            return this.api.clusterGetListById(clusterIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job clusterModify(Cluster cluster) throws WsException {
        try {
            return this.api.clusterModify(cluster);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ClusterHeartbeatDevice> clusterHeartbeatDeviceGetAll() throws WsException {
        try {
            return this.api.clusterHeartbeatDeviceGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<ClusterHeartbeatDevice>> clusterHeartbeatDeviceGetIds() throws WsException {
        try {
            return this.api.clusterHeartbeatDeviceGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ClusterHeartbeatDevice clusterHeartbeatDeviceGetById(Id<ClusterHeartbeatDevice> clusterHeartbeatDeviceId) throws WsException {
        try {
            return this.api.clusterHeartbeatDeviceGetById(clusterHeartbeatDeviceId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ClusterHeartbeatDevice> clusterHeartbeatDeviceGetListById(List<Id<ClusterHeartbeatDevice>> clusterHeartbeatDeviceIds) throws WsException {
        try {
            return this.api.clusterHeartbeatDeviceGetListById(clusterHeartbeatDeviceIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job clusterHeartbeatDeviceModify(ClusterHeartbeatDevice clusterHeartbeatDevice) throws WsException {
        try {
            return this.api.clusterHeartbeatDeviceModify(clusterHeartbeatDevice);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ClusterStorageFs> clusterStorageFsGetAll() throws WsException {
        try {
            return this.api.clusterStorageFsGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<ClusterStorageFs>> clusterStorageFsGetIds() throws WsException {
        try {
            return this.api.clusterStorageFsGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ClusterStorageFs clusterStorageFsGetById(Id<ClusterStorageFs> clusterStorageFsId) throws WsException {
        try {
            return this.api.clusterStorageFsGetById(clusterStorageFsId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ClusterStorageFs> clusterStorageFsGetListById(List<Id<ClusterStorageFs>> clusterStorageFsIds) throws WsException {
        try {
            return this.api.clusterStorageFsGetListById(clusterStorageFsIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job clusterStorageFsModify(ClusterStorageFs clusterStorageFs) throws WsException {
        try {
            return this.api.clusterStorageFsModify(clusterStorageFs);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ControlDomain> controlDomainGetAll() throws WsException {
        try {
            return this.api.controlDomainGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<ControlDomain>> controlDomainGetIds() throws WsException {
        try {
            return this.api.controlDomainGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ControlDomain controlDomainGetById(Id<ControlDomain> controlDomainId) throws WsException {
        try {
            return this.api.controlDomainGetById(controlDomainId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ControlDomain> controlDomainGetListById(List<Id<ControlDomain>> controlDomainIds) throws WsException {
        try {
            return this.api.controlDomainGetListById(controlDomainIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job controlDomainModify(ControlDomain controlDomain) throws WsException {
        try {
            return this.api.controlDomainModify(controlDomain);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Cpu> cpuGetAll() throws WsException {
        try {
            return this.api.cpuGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Cpu>> cpuGetIds() throws WsException {
        try {
            return this.api.cpuGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Cpu cpuGetById(Id<Cpu> cpuId) throws WsException {
        try {
            return this.api.cpuGetById(cpuId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Cpu> cpuGetListById(List<Id<Cpu>> cpuIds) throws WsException {
        try {
            return this.api.cpuGetListById(cpuIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job cpuModify(Cpu cpu) throws WsException {
        try {
            return this.api.cpuModify(cpu);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job cpuCompatibilityGroupCreate(CpuCompatibilityGroup cpuCompatibilityGroup) throws WsException {
        try {
            return this.api.cpuCompatibilityGroupCreate(cpuCompatibilityGroup);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job cpuCompatibilityGroupDelete(Id<CpuCompatibilityGroup> cpuCompatibilityGroupId) throws WsException {
        try {
            return this.api.cpuCompatibilityGroupDelete(cpuCompatibilityGroupId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<CpuCompatibilityGroup> cpuCompatibilityGroupGetAll() throws WsException {
        try {
            return this.api.cpuCompatibilityGroupGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<CpuCompatibilityGroup>> cpuCompatibilityGroupGetIds() throws WsException {
        try {
            return this.api.cpuCompatibilityGroupGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public CpuCompatibilityGroup cpuCompatibilityGroupGetById(Id<CpuCompatibilityGroup> cpuCompatibilityGroupId) throws WsException {
        try {
            return this.api.cpuCompatibilityGroupGetById(cpuCompatibilityGroupId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<CpuCompatibilityGroup> cpuCompatibilityGroupGetListById(List<Id<CpuCompatibilityGroup>> cpuCompatibilityGroupIds) throws WsException {
        try {
            return this.api.cpuCompatibilityGroupGetListById(cpuCompatibilityGroupIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job cpuCompatibilityGroupModify(CpuCompatibilityGroup cpuCompatibilityGroup) throws WsException {
        try {
            return this.api.cpuCompatibilityGroupModify(cpuCompatibilityGroup);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job cpuCompatibilityGroupAddServer(Id<CpuCompatibilityGroup> cpuCompatibilityGroupId, Id<Server> serverId) throws WsException {
        try {
            return this.api.cpuCompatibilityGroupAddServer(cpuCompatibilityGroupId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job cpuCompatibilityGroupRemoveServer(Id<CpuCompatibilityGroup> cpuCompatibilityGroupId, Id<Server> serverId) throws WsException {
        try {
            return this.api.cpuCompatibilityGroupRemoveServer(cpuCompatibilityGroupId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<EthernetPort> ethernetPortGetAll() throws WsException {
        try {
            return this.api.ethernetPortGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<EthernetPort>> ethernetPortGetIds() throws WsException {
        try {
            return this.api.ethernetPortGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public EthernetPort ethernetPortGetById(Id<EthernetPort> ethernetPortId) throws WsException {
        try {
            return this.api.ethernetPortGetById(ethernetPortId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<EthernetPort> ethernetPortGetListById(List<Id<EthernetPort>> ethernetPortIds) throws WsException {
        try {
            return this.api.ethernetPortGetListById(ethernetPortIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job ethernetPortModify(EthernetPort ethernetPort) throws WsException {
        try {
            return this.api.ethernetPortModify(ethernetPort);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job ethernetPortAddEthernetPortToBond(Id<EthernetPort> bondPortId, Id<EthernetPort> ethernetPortId) throws WsException {
        try {
            return this.api.ethernetPortAddEthernetPortToBond(bondPortId, ethernetPortId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job ethernetPortRemoveEthernetPortFromBond(Id<EthernetPort> bondPortId, Id<EthernetPort> ethernetPortId) throws WsException {
        try {
            return this.api.ethernetPortRemoveEthernetPortFromBond(bondPortId, ethernetPortId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job ethernetPortCreateVlanInterface(Id<EthernetPort> ethernetPortId, VlanInterface vlanInterface) throws WsException {
        try {
            return this.api.ethernetPortCreateVlanInterface(ethernetPortId, vlanInterface);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job ethernetPortDeleteVlanInterface(Id<EthernetPort> ethernetPortId, Id<VlanInterface> vlanInterfaceId) throws WsException {
        try {
            return this.api.ethernetPortDeleteVlanInterface(ethernetPortId, vlanInterfaceId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job eventAcknowledge(Id<Event> eventId) throws WsException {
        try {
            return this.api.eventAcknowledge(eventId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Event> eventGetAll(Id<? extends BaseObject> objectId, String eventType, Event.EventSeverity eventSeverity, boolean acknowledged, long startTime, long endTime, boolean queryModifyTime, int maxEvents) throws WsException {
        try {
            return this.api.eventGetAll(objectId, eventType, eventSeverity, acknowledged, startTime, endTime, queryModifyTime, maxEvents);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Event>> eventGetIds(Id<? extends BaseObject> objectId, String eventType, Event.EventSeverity eventSeverity, boolean acknowledged, long startTime, long endTime, boolean queryModifyTime, int maxEvents) throws WsException {
        try {
            return this.api.eventGetIds(objectId, eventType, eventSeverity, acknowledged, startTime, endTime, queryModifyTime, maxEvents);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Event eventGetById(Id<Event> eventId) throws WsException {
        try {
            return this.api.eventGetById(eventId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Event> eventGetListById(List<Id<Event>> eventIds) throws WsException {
        try {
            return this.api.eventGetListById(eventIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Event eventGetTriage(Id<? extends BaseObject> objectId) throws WsException {
        try {
            return this.api.eventGetTriage(objectId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Event> eventGetTriageList(List<Id<? extends BaseObject>> objectIds) throws WsException {
        try {
            return this.api.eventGetTriageList(objectIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<? extends BaseObject>> eventGetFullyPopulatedIds(List<Id<? extends BaseObject>> objectIds) throws WsException {
        try {
            return this.api.eventGetFullyPopulatedIds(objectIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<String> eventGetTypes() throws WsException {
        try {
            return this.api.eventGetTypes();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<FileServerPlugin> fileServerPluginGetAll() throws WsException {
        try {
            return this.api.fileServerPluginGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<FileServerPlugin>> fileServerPluginGetIds() throws WsException {
        try {
            return this.api.fileServerPluginGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public FileServerPlugin fileServerPluginGetById(Id<FileServerPlugin> fileServerPluginId) throws WsException {
        try {
            return this.api.fileServerPluginGetById(fileServerPluginId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<FileServerPlugin> fileServerPluginGetListById(List<Id<FileServerPlugin>> fileServerPluginIds) throws WsException {
        try {
            return this.api.fileServerPluginGetListById(fileServerPluginIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerPluginModify(FileServerPlugin fileServerPlugin) throws WsException {
        try {
            return this.api.fileServerPluginModify(fileServerPlugin);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<FileServer> fileServerGetAll() throws WsException {
        try {
            return this.api.fileServerGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<FileServer>> fileServerGetIds() throws WsException {
        try {
            return this.api.fileServerGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public FileServer fileServerGetById(Id<FileServer> fileServerId) throws WsException {
        try {
            return this.api.fileServerGetById(fileServerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<FileServer> fileServerGetListById(List<Id<FileServer>> fileServerIds) throws WsException {
        try {
            return this.api.fileServerGetListById(fileServerIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerDiscover(FileServer fileServer) throws WsException {
        try {
            return this.api.fileServerDiscover(fileServer);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerDelete(Id<FileServer> fileServerId) throws WsException {
        try {
            return this.api.fileServerDelete(fileServerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerModify(FileServer fileServer) throws WsException {
        try {
            return this.api.fileServerModify(fileServer);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerRefresh(Id<FileServer> fileServerId) throws WsException {
        try {
            return this.api.fileServerRefresh(fileServerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerAddAdminServer(Id<FileServer> fileServerId, Id<Server> adminServerId) throws WsException {
        try {
            return this.api.fileServerAddAdminServer(fileServerId, adminServerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerRemoveAdminServer(Id<FileServer> fileServerId, Id<Server> adminServerId) throws WsException {
        try {
            return this.api.fileServerRemoveAdminServer(fileServerId, adminServerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerSetFileServerPlugin(Id<FileServer> fileServerId, Id<FileServerPlugin> pluginId) throws WsException {
        try {
            return this.api.fileServerSetFileServerPlugin(fileServerId, pluginId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerAddRefreshServer(Id<FileServer> fileServerId, Id<Server> refreshServerId) throws WsException {
        try {
            return this.api.fileServerAddRefreshServer(fileServerId, refreshServerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerRemoveRefreshServer(Id<FileServer> fileServerId, Id<Server> refreshServerId) throws WsException {
        try {
            return this.api.fileServerRemoveRefreshServer(fileServerId, refreshServerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerCreateAccessGroup(Id<FileServer> fileServerId, AccessGroup accessGroup) throws WsException {
        try {
            return this.api.fileServerCreateAccessGroup(fileServerId, accessGroup);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerDeleteAccessGroup(Id<FileServer> fileServerId, Id<AccessGroup> accessGroupId) throws WsException {
        try {
            return this.api.fileServerDeleteAccessGroup(fileServerId, accessGroupId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerCreateFileSystem(Id<FileServer> fileServerId, FileSystem fileSystem) throws WsException {
        try {
            return this.api.fileServerCreateFileSystem(fileServerId, fileSystem);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileServerDeleteFileSystem(Id<FileServer> fileServerId, Id<FileSystem> fileSystemId) throws WsException {
        try {
            return this.api.fileServerDeleteFileSystem(fileServerId, fileSystemId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<FileSystem> fileSystemGetAll() throws WsException {
        try {
            return this.api.fileSystemGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<FileSystem>> fileSystemGetIds() throws WsException {
        try {
            return this.api.fileSystemGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public FileSystem fileSystemGetById(Id<FileSystem> fileSystemId) throws WsException {
        try {
            return this.api.fileSystemGetById(fileSystemId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<FileSystem> fileSystemGetListById(List<Id<FileSystem>> fileSystemIds) throws WsException {
        try {
            return this.api.fileSystemGetListById(fileSystemIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileSystemModify(FileSystem fileSystem) throws WsException {
        try {
            return this.api.fileSystemModify(fileSystem);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileSystemCreateRepository(Id<FileSystem> fileSystemId, Repository repository) throws WsException {
        try {
            return this.api.fileSystemCreateRepository(fileSystemId, repository);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileSystemDeleteRepository(Id<FileSystem> fileSystemId, Id<Repository> repositoryId) throws WsException {
        try {
            return this.api.fileSystemDeleteRepository(fileSystemId, repositoryId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileSystemRefresh(Id<FileSystem> fileSystemId) throws WsException {
        try {
            return this.api.fileSystemRefresh(fileSystemId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileSystemRefreshMetadata(Id<FileSystem> fileSystemId) throws WsException {
        try {
            return this.api.fileSystemRefreshMetadata(fileSystemId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<FileSystemMount> fileSystemMountGetAll() throws WsException {
        try {
            return this.api.fileSystemMountGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<FileSystemMount>> fileSystemMountGetIds() throws WsException {
        try {
            return this.api.fileSystemMountGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public FileSystemMount fileSystemMountGetById(Id<FileSystemMount> fileSystemMountId) throws WsException {
        try {
            return this.api.fileSystemMountGetById(fileSystemMountId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<FileSystemMount> fileSystemMountGetListById(List<Id<FileSystemMount>> fileSystemMountIds) throws WsException {
        try {
            return this.api.fileSystemMountGetListById(fileSystemMountIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job fileSystemMountModify(FileSystemMount fileSystemMount) throws WsException {
        try {
            return this.api.fileSystemMountModify(fileSystemMount);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Job> jobGetAll(long startTime, long endTime, int maxJobs) throws WsException {
        try {
            return this.api.jobGetAll(startTime, endTime, maxJobs);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Job>> jobGetIds(long startTime, long endTime, int maxJobs) throws WsException {
        try {
            return this.api.jobGetIds(startTime, endTime, maxJobs);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job jobGetById(Id<Job> jobId) throws WsException {
        try {
            return this.api.jobGetById(jobId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public String jobGetDebugTranscript(Id<Job> jobId) throws WsException {
        try {
            return this.api.jobGetDebugTranscript(jobId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Job> jobGetListById(List<Id<Job>> jobIds) throws WsException {
        try {
            return this.api.jobGetListById(jobIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void jobAbort(Id<Job> jobId) throws WsException {
        try {
            this.api.jobAbort(jobId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Id<Job> jobCreateGroup(Job jobGroup) throws WsException {
        try {
            return this.api.jobCreateGroup(jobGroup);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void jobDelete(Id<Job> jobId) throws WsException {
        try {
            this.api.jobDelete(jobId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void jobAddChildToGroup(Id<Job> jobGroupId, Id<Job> jobId) throws WsException {
        try {
            this.api.jobAddChildToGroup(jobGroupId, jobId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public void jobModify(Job job) throws WsException {
        try {
            this.api.jobModify(job);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Manager managerGet() throws WsException {
        try {
            return this.api.managerGet();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Manager> managerGetAll() throws WsException {
        try {
            return this.api.managerGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Manager>> managerGetIds() throws WsException {
        try {
            return this.api.managerGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Manager managerGetById(Id<Manager> managerId) throws WsException {
        try {
            return this.api.managerGetById(managerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Manager> managerGetListById(List<Id<Manager>> managerIds) throws WsException {
        try {
            return this.api.managerGetListById(managerIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job managerModify(Manager manager) throws WsException {
        try {
            return this.api.managerModify(manager);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job networkAddEthernetPort(Id<Network> networkId, Id<EthernetPort> ethernetPortId) throws WsException {
        try {
            return this.api.networkAddEthernetPort(networkId, ethernetPortId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job networkAddVlanInterface(Id<Network> networkId, Id<VlanInterface> vlanInterfaceId) throws WsException {
        try {
            return this.api.networkAddVlanInterface(networkId, vlanInterfaceId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job networkAddVirtualNic(Id<Network> networkId, Id<VirtualNic> virtualNicId) throws WsException {
        try {
            return this.api.networkAddVirtualNic(networkId, virtualNicId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job networkCreate(Network network) throws WsException {
        try {
            return this.api.networkCreate(network);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job networkDelete(Id<Network> networkId) throws WsException {
        try {
            return this.api.networkDelete(networkId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Network> networkGetAll() throws WsException {
        try {
            return this.api.networkGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Network>> networkGetIds() throws WsException {
        try {
            return this.api.networkGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Network networkGetById(Id<Network> networkId) throws WsException {
        try {
            return this.api.networkGetById(networkId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Network> networkGetListById(List<Id<Network>> networkIds) throws WsException {
        try {
            return this.api.networkGetListById(networkIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job networkModify(Network network) throws WsException {
        try {
            return this.api.networkModify(network);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job networkRemoveEthernetPort(Id<Network> networkId, Id<EthernetPort> ethernetPortId) throws WsException {
        try {
            return this.api.networkRemoveEthernetPort(networkId, ethernetPortId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job networkRemoveVlanInterface(Id<Network> networkId, Id<VlanInterface> vlanInterfaceId) throws WsException {
        try {
            return this.api.networkRemoveVlanInterface(networkId, vlanInterfaceId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job networkRemoveVirtualNic(Id<Network> networkId, Id<VirtualNic> virtualNicId) throws WsException {
        try {
            return this.api.networkRemoveVirtualNic(networkId, virtualNicId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Repository> repositoryGetAll() throws WsException {
        try {
            return this.api.repositoryGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Repository>> repositoryGetIds() throws WsException {
        try {
            return this.api.repositoryGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Repository repositoryGetById(Id<Repository> repositoryId) throws WsException {
        try {
            return this.api.repositoryGetById(repositoryId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Repository> repositoryGetListById(List<Id<Repository>> repositoryIds) throws WsException {
        try {
            return this.api.repositoryGetListById(repositoryIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryImportAssembly(Id<Repository> repositoryId, String url, String proxy) throws WsException {
        try {
            return this.api.repositoryImportAssembly(repositoryId, url, proxy);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryDeleteAssembly(Id<Repository> repositoryId, Id<Assembly> assemblyId) throws WsException {
        try {
            return this.api.repositoryDeleteAssembly(repositoryId, assemblyId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryImportVm(Id<Repository> repositoryId, List<String> urls, String proxy, boolean createTemplate) throws WsException {
        try {
            return this.api.repositoryImportVm(repositoryId, urls, proxy, createTemplate);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryAddVm(Id<Repository> repositoryId, Id<Vm> vmId) throws WsException {
        try {
            return this.api.repositoryAddVm(repositoryId, vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryRemoveVm(Id<Repository> repositoryId, Id<Vm> vmId) throws WsException {
        try {
            return this.api.repositoryRemoveVm(repositoryId, vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryCreateVirtualDisk(Id<Repository> repositoryId, VirtualDisk virtualDisk, boolean sparse) throws WsException {
        try {
            return this.api.repositoryCreateVirtualDisk(repositoryId, virtualDisk, sparse);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryImportVirtualDisk(Id<Repository> repositoryId, String url, String proxy, VirtualDisk.DiskType diskType) throws WsException {
        try {
            return this.api.repositoryImportVirtualDisk(repositoryId, url, proxy, diskType);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryDeleteVirtualDisk(Id<Repository> repositoryId, Id<VirtualDisk> virtualDiskId) throws WsException {
        try {
            return this.api.repositoryDeleteVirtualDisk(repositoryId, virtualDiskId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryModify(Repository repository) throws WsException {
        try {
            return this.api.repositoryModify(repository);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryRefresh(Id<Repository> repositoryId) throws WsException {
        try {
            return this.api.repositoryRefresh(repositoryId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryPresent(Id<Repository> repositoryId, Id<Server> serverId) throws WsException {
        try {
            return this.api.repositoryPresent(repositoryId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryUnpresent(Id<Repository> repositoryId, Id<Server> serverId) throws WsException {
        try {
            return this.api.repositoryUnpresent(repositoryId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryTakeOwnership(Id<Repository> repositoryId, Id<ServerPool> serverPoolId) throws WsException {
        try {
            return this.api.repositoryTakeOwnership(repositoryId, serverPoolId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryReleaseOwnership(Id<Repository> repositoryId) throws WsException {
        try {
            return this.api.repositoryReleaseOwnership(repositoryId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<RepositoryExport> repositoryExportGetAll() throws WsException {
        try {
            return this.api.repositoryExportGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<RepositoryExport>> repositoryExportGetIds() throws WsException {
        try {
            return this.api.repositoryExportGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public RepositoryExport repositoryExportGetById(Id<RepositoryExport> repositoryExportId) throws WsException {
        try {
            return this.api.repositoryExportGetById(repositoryExportId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<RepositoryExport> repositoryExportGetListById(List<Id<RepositoryExport>> repositoryExportIds) throws WsException {
        try {
            return this.api.repositoryExportGetListById(repositoryExportIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job repositoryExportModify(RepositoryExport repositoryExport) throws WsException {
        try {
            return this.api.repositoryExportModify(repositoryExport);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ResourceGroup> resourceGroupGetAll() throws WsException {
        try {
            return this.api.resourceGroupGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ResourceGroup> resourceGroupGetListById(List<Id<ResourceGroup>> resourceGroupIds) throws WsException {
        try {
            return this.api.resourceGroupGetListById(resourceGroupIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<ResourceGroup>> resourceGroupGetIds() throws WsException {
        try {
            return this.api.resourceGroupGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ResourceGroup resourceGroupGetById(Id<ResourceGroup> resourceGroupId) throws WsException {
        try {
            return this.api.resourceGroupGetById(resourceGroupId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job resourceGroupCreate(ResourceGroup resourceGroup) throws WsException {
        try {
            return this.api.resourceGroupCreate(resourceGroup);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job resourceGroupModify(ResourceGroup resourceGroup) throws WsException {
        try {
            return this.api.resourceGroupModify(resourceGroup);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job resourceGroupDelete(Id<ResourceGroup> resourceGroupId) throws WsException {
        try {
            return this.api.resourceGroupDelete(resourceGroupId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job resourceGroupAddResource(Id<ResourceGroup> resourceGroupId, Id<? extends BaseObject> objectId) throws WsException {
        try {
            return this.api.resourceGroupAddResource(resourceGroupId, objectId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job resourceGroupRemoveResource(Id<ResourceGroup> resourceGroupId, Id<? extends BaseObject> objectId) throws WsException {
        try {
            return this.api.resourceGroupRemoveResource(resourceGroupId, objectId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverCreateNetwork(Id<Server> serverId, Network network) throws WsException {
        try {
            return this.api.serverCreateNetwork(serverId, network);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverDeleteNetwork(Id<Server> serverId, Id<Network> networkId) throws WsException {
        try {
            return this.api.serverDeleteNetwork(serverId, networkId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Server> serverGetAll() throws WsException {
        try {
            return this.api.serverGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Server>> serverGetIds() throws WsException {
        try {
            return this.api.serverGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Server serverGetById(Id<Server> serverId) throws WsException {
        try {
            return this.api.serverGetById(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Server> serverGetListById(List<Id<Server>> serverIds) throws WsException {
        try {
            return this.api.serverGetListById(serverIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverModify(Server server) throws WsException {
        try {
            return this.api.serverModify(server);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverDiscover(String serverName, String agentPassword, boolean takeOwnership) throws WsException {
        try {
            return this.api.serverDiscover(serverName, agentPassword, takeOwnership);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverDelete(Id<Server> serverId) throws WsException {
        try {
            return this.api.serverDelete(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverRefresh(Id<Server> serverId) throws WsException {
        try {
            return this.api.serverRefresh(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverRefreshStorageLayer(Id<Server> serverId) throws WsException {
        try {
            return this.api.serverRefreshStorageLayer(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverTakeOwnership(Id<Server> serverId, String agentPassword) throws WsException {
        try {
            return this.api.serverTakeOwnership(serverId, agentPassword);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverReleaseOwnership(Id<Server> serverId) throws WsException {
        try {
            return this.api.serverReleaseOwnership(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverEnableMaintenanceMode(Id<Server> serverId, boolean enabled) throws WsException {
        try {
            return this.api.serverEnableMaintenanceMode(serverId, enabled);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverUpdateAgentPassword(Id<Server> serverId, String currentPassword, String newPassword) throws WsException {
        try {
            PasswordChange passwords = new PasswordChange();
            passwords.setCurrentPassword(currentPassword);
            passwords.setNewPassword(newPassword);
            return this.api.serverUpdateAgentPassword(serverId, passwords);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ServerUpdateConfiguration serverUpdateConfigurationGetDefault(ServerUpdateConfiguration.ServerUpdateRepositoryType repositoryType) throws WsException {
        try {
            return this.api.serverUpdateConfigurationGetDefault(repositoryType);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<ServerUpdateConfiguration>> serverUpdateConfigurationGetIds() throws WsException {
        try {
            return this.api.serverUpdateConfigurationGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ServerUpdateConfiguration> serverUpdateConfigurationGetAll() throws WsException {
        try {
            return this.api.serverUpdateConfigurationGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ServerUpdateConfiguration serverUpdateConfigurationGetById(Id<ServerUpdateConfiguration> serverUpdateConfigurationId) throws WsException {
        try {
            return this.api.serverUpdateConfigurationGetById(serverUpdateConfigurationId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ServerUpdateConfiguration> serverUpdateConfigurationGetListById(List<Id<ServerUpdateConfiguration>> serverUpdateConfigurationIds) throws WsException {
        try {
            return this.api.serverUpdateConfigurationGetListById(serverUpdateConfigurationIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverUpdateConfigurationModify(ServerUpdateConfiguration serverUpdateConfiguration) throws WsException {
        try {
            return this.api.serverUpdateConfigurationModify(serverUpdateConfiguration);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<ServerUpdateRepositoryConfiguration>> serverUpdateRepositoryConfigurationGetIds() throws WsException {
        try {
            return this.api.serverUpdateRepositoryConfigurationGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverUpdateConfigurationCreateServerUpdateRepositoryConfiguration(Id<ServerUpdateConfiguration> serverUpdateConfigurationId, ServerUpdateRepositoryConfiguration serverUpdateRepositoryConfiguration) throws WsException {
        try {
            return this.api.serverUpdateConfigurationCreateServerUpdateRepositoryConfiguration(serverUpdateConfigurationId, serverUpdateRepositoryConfiguration);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverUpdateConfigurationDeleteServerUpdateRepositoryConfiguration(Id<ServerUpdateConfiguration> serverUpdateConfiguration, Id<ServerUpdateRepositoryConfiguration> serverUpdateRepositoryConfigurationId) throws WsException {
        try {
            return this.api.serverUpdateConfigurationDeleteServerUpdateRepositoryConfiguration(serverUpdateConfiguration, serverUpdateRepositoryConfigurationId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ServerUpdateRepositoryConfiguration> serverUpdateRepositoryConfigurationGetAll() throws WsException {
        try {
            return this.api.serverUpdateRepositoryConfigurationGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ServerUpdateRepositoryConfiguration> serverUpdateRepositoryConfigurationGetListById(List<Id<ServerUpdateRepositoryConfiguration>> serverUpdateRepositoryConfigurationIds) throws WsException {
        try {
            return this.api.serverUpdateRepositoryConfigurationGetListById(serverUpdateRepositoryConfigurationIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverUpdateRepositoryConfigurationModify(ServerUpdateRepositoryConfiguration serverUpdateRepositoryConfiguration) throws WsException {
        try {
            return this.api.serverUpdateRepositoryConfigurationModify(serverUpdateRepositoryConfiguration);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ServerUpdateRepositoryConfiguration serverUpdateRepositoryConfigurationGetById(Id<ServerUpdateRepositoryConfiguration> serverUpdateRepositoryConfigurationId) throws WsException {
        try {
            return this.api.serverUpdateRepositoryConfigurationGetById(serverUpdateRepositoryConfigurationId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverStop(Id<Server> serverId) throws WsException {
        try {
            return this.api.serverStop(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverKill(Id<Server> serverId) throws WsException {
        try {
            return this.api.serverKill(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverStart(Id<Server> serverId) throws WsException {
        try {
            return this.api.serverStart(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverRestart(Id<Server> serverId) throws WsException {
        try {
            return this.api.serverRestart(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverUpgrade(Id<Server> serverId) throws WsException {
        try {
            return this.api.serverUpgrade(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverCheckUpToDate(Id<Server> serverId) throws WsException {
        try {
            return this.api.serverCheckUpToDate(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverCreateRepositoryExport(Id<Server> serverId, RepositoryExport repositoryExport) throws WsException {
        try {
            return this.api.serverCreateRepositoryExport(serverId, repositoryExport);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverDeleteRepositoryExport(Id<Server> serverId, Id<RepositoryExport> repositoryExportId) throws WsException {
        try {
            return this.api.serverDeleteRepositoryExport(serverId, repositoryExportId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverCreateServerController(Id<Server> serverId, ServerController serverController) throws WsException {
        try {
            return this.api.serverCreateServerController(serverId, serverController);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverDeleteServerController(Id<Server> serverId) throws WsException {
        try {
            return this.api.serverDeleteServerController(serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ServerController> serverControllerGetAll() throws WsException {
        try {
            return this.api.serverControllerGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<ServerController>> serverControllerGetIds() throws WsException {
        try {
            return this.api.serverControllerGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ServerController serverControllerGetById(Id<ServerController> serverControllerId) throws WsException {
        try {
            return this.api.serverControllerGetById(serverControllerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ServerController> serverControllerGetListById(List<Id<ServerController>> serverControllerIds) throws WsException {
        try {
            return this.api.serverControllerGetListById(serverControllerIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverControllerModify(ServerController serverController) throws WsException {
        try {
            return this.api.serverControllerModify(serverController);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverAddVm(Id<Server> serverId, Id<Vm> vm) throws WsException {
        try {
            return this.api.serverAddVm(serverId, vm);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverRemoveVm(Id<Server> serverId, Id<Vm> vm) throws WsException {
        try {
            return this.api.serverRemoveVm(serverId, vm);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverCreateBondPort(Id<Server> serverId, EthernetPort ethernetPort) throws WsException {
        try {
            return this.api.serverCreateBondPort(serverId, ethernetPort);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverDeleteBondPort(Id<Server> serverId, Id<EthernetPort> ethernetPortId) throws WsException {
        try {
            return this.api.serverDeleteBondPort(serverId, ethernetPortId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<String> serverGetPackageList(Id<Server> serverId, Server.PackageType packageType) throws WsException {
        try {
            return this.api.serverGetPackageList(serverId, packageType);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverRefreshPackageList(Id<Server> serverId, Server.PackageType packageType) throws WsException {
        try {
            return this.api.serverRefreshPackageList(serverId, packageType);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverRemovePackageList(Id<Server> serverId, List<String> packageNames) throws WsException {
        try {
            return this.api.serverRemovePackageList(serverId, packageNames);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolAddServer(Id<ServerPool> serverPoolId, Id<Server> serverId) throws WsException {
        try {
            return this.api.serverPoolAddServer(serverPoolId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolAddVm(Id<ServerPool> serverPoolId, Id<Vm> vmId) throws WsException {
        try {
            return this.api.serverPoolAddVm(serverPoolId, vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolCreate(ServerPool serverPool) throws WsException {
        try {
            return this.api.serverPoolCreate(serverPool);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolCreateAffinityGroup(Id<ServerPool> serverPoolId, AffinityGroup affinityGroup) throws WsException {
        try {
            return this.api.serverPoolCreateAffinityGroup(serverPoolId, affinityGroup);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolCreateCluster(Id<ServerPool> serverPoolId, Cluster cluster) throws WsException {
        try {
            return this.api.serverPoolCreateCluster(serverPoolId, cluster);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolCreateServerUpdateConfiguration(Id<ServerPool> serverPoolId, ServerUpdateConfiguration serverUpdateConfiguration) throws WsException {
        try {
            return this.api.serverPoolCreateServerUpdateConfiguration(serverPoolId, serverUpdateConfiguration);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolDeleteServerUpdateConfiguration(Id<ServerPool> serverPoolId) throws WsException {
        try {
            return this.api.serverPoolDeleteServerUpdateConfiguration(serverPoolId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolDelete(Id<ServerPool> serverPoolId) throws WsException {
        try {
            return this.api.serverPoolDelete(serverPoolId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolDeleteAffinityGroup(Id<ServerPool> serverPoolId, Id<AffinityGroup> affinityGroupId) throws WsException {
        try {
            return this.api.serverPoolDeleteAffinityGroup(serverPoolId, affinityGroupId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolDeleteCluster(Id<ServerPool> serverPoolId, Id<Cluster> clusterId) throws WsException {
        try {
            return this.api.serverPoolDeleteCluster(serverPoolId, clusterId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ServerPool> serverPoolGetAll() throws WsException {
        try {
            return this.api.serverPoolGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<ServerPool>> serverPoolGetIds() throws WsException {
        try {
            return this.api.serverPoolGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ServerPool serverPoolGetById(Id<ServerPool> serverPoolId) throws WsException {
        try {
            return this.api.serverPoolGetById(serverPoolId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ServerPool> serverPoolGetListById(List<Id<ServerPool>> serverPoolIds) throws WsException {
        try {
            return this.api.serverPoolGetListById(serverPoolIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolModify(ServerPool serverPool) throws WsException {
        try {
            return this.api.serverPoolModify(serverPool);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolRemoveServer(Id<ServerPool> serverPoolId, Id<Server> serverId) throws WsException {
        try {
            return this.api.serverPoolRemoveServer(serverPoolId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolRemoveVm(Id<ServerPool> serverPoolId, Id<Vm> vmId) throws WsException {
        try {
            return this.api.serverPoolRemoveVm(serverPoolId, vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolSetMasterServer(Id<ServerPool> serverPoolId, Id<Server> masterServerId) throws WsException {
        try {
            return this.api.serverPoolSetMasterServer(serverPoolId, masterServerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ServerPoolPolicy serverPoolPolicyGetById(Id<ServerPoolPolicy> serverPoolPolicyId) throws WsException {
        try {
            return this.api.serverPoolPolicyGetById(serverPoolPolicyId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ServerPoolPolicy> serverPoolPolicyGetAll() throws WsException {
        try {
            return this.api.serverPoolPolicyGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<ServerPoolPolicy>> serverPoolPolicyGetIds() throws WsException {
        try {
            return this.api.serverPoolPolicyGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ServerPoolPolicy> serverPoolPolicyGetListById(List<Id<ServerPoolPolicy>> serverPoolPolicyIds) throws WsException {
        try {
            return this.api.serverPoolPolicyGetListById(serverPoolPolicyIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public ServerPoolNetworkPolicy serverPoolNetworkPolicyGetById(Id<ServerPoolNetworkPolicy> serverPoolNetworkPolicyId) throws WsException {
        try {
            return this.api.serverPoolNetworkPolicyGetById(serverPoolNetworkPolicyId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ServerPoolNetworkPolicy> serverPoolNetworkPolicyGetAll() throws WsException {
        try {
            return this.api.serverPoolNetworkPolicyGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<ServerPoolNetworkPolicy>> serverPoolNetworkPolicyGetIds() throws WsException {
        try {
            return this.api.serverPoolNetworkPolicyGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<ServerPoolNetworkPolicy> serverPoolNetworkPolicyGetListById(List<Id<ServerPoolNetworkPolicy>> serverPoolNetworkPolicyIds) throws WsException {
        try {
            return this.api.serverPoolNetworkPolicyGetListById(serverPoolNetworkPolicyIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolNetworkPolicyModify(ServerPoolNetworkPolicy serverPoolNetworkPolicy) throws WsException {
        try {
            return this.api.serverPoolNetworkPolicyModify(serverPoolNetworkPolicy);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolPolicyModify(ServerPoolPolicy serverPoolPolicy) throws WsException {
        try {
            return this.api.serverPoolPolicyModify(serverPoolPolicy);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolPolicyAddServer(Id<ServerPoolPolicy> serverPoolPolicyId, Id<Server> serverId) throws WsException {
        try {
            return this.api.serverPoolPolicyAddServer(serverPoolPolicyId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolPolicyRemoveServer(Id<ServerPoolPolicy> serverPoolPolicyId, Id<Server> serverId) throws WsException {
        try {
            return this.api.serverPoolPolicyRemoveServer(serverPoolPolicyId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolPolicyCreateNetworkPolicy(Id<ServerPoolPolicy> serverPoolPolicyId, ServerPoolNetworkPolicy serverPoolNetworkPolicy) throws WsException {
        try {
            return this.api.serverPoolPolicyCreateNetworkPolicy(serverPoolPolicyId, serverPoolNetworkPolicy);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job serverPoolPolicyDeleteNetworkPolicy(Id<ServerPoolPolicy> serverPoolPolicyId, Id<ServerPoolNetworkPolicy> serverPoolNetworkPolicyId) throws WsException {
        try {
            return this.api.serverPoolPolicyDeleteNetworkPolicy(serverPoolPolicyId, serverPoolNetworkPolicyId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Statistic> statisticGetListForObject(Id<? extends BaseObject> objectId, Statistic.StatisticType statisticType, long startTime, long endTime) throws WsException {
        try {
            return this.api.statisticGetListForObject(objectId, statisticType, startTime, endTime);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Statistic statisticGetAverageForObject(Id<? extends BaseObject> objectId, Statistic.StatisticType statisticType, long startTime, long endTime) throws WsException {
        try {
            return this.api.statisticGetAverageForObject(objectId, statisticType, startTime, endTime);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Statistic statisticGetCurrentValueForObject(Id<? extends BaseObject> objectId, Statistic.StatisticType statisticType) throws WsException {
        try {
            return this.api.statisticGetCurrentValueForObject(objectId, statisticType);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Statistic statisticGetLatestForObject(Id<? extends BaseObject> objectId, Statistic.StatisticType statisticType) throws WsException {
        try {
            return this.api.statisticGetLatestForObject(objectId, statisticType);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Statistic> statisticGetLatestForObjectList(List<Id<? extends BaseObject>> objectIds, Statistic.StatisticType statisticType) throws WsException {
        try {
            return this.api.statisticGetLatestForObjectList(objectIds, statisticType);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<StorageArray> storageArrayGetAll() throws WsException {
        try {
            return this.api.storageArrayGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<StorageArray>> storageArrayGetIds() throws WsException {
        try {
            return this.api.storageArrayGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public StorageArray storageArrayGetById(Id<StorageArray> storageArrayId) throws WsException {
        try {
            return this.api.storageArrayGetById(storageArrayId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<StorageArray> storageArrayGetListById(List<Id<StorageArray>> storageArrayIds) throws WsException {
        try {
            return this.api.storageArrayGetListById(storageArrayIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageArrayModify(StorageArray storageArray) throws WsException {
        try {
            return this.api.storageArrayModify(storageArray);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageArraySetStorageArrayPlugin(Id<StorageArray> storageArrayId, Id<StorageArrayPlugin> pluginId) throws WsException {
        try {
            return this.api.storageArraySetStorageArrayPlugin(storageArrayId, pluginId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageArrayCreateAccessGroup(Id<StorageArray> storageArrayId, AccessGroup accessGroup) throws WsException {
        try {
            return this.api.storageArrayCreateAccessGroup(storageArrayId, accessGroup);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageArrayDeleteAccessGroup(Id<StorageArray> storageArrayId, Id<AccessGroup> accessGroupId) throws WsException {
        try {
            return this.api.storageArrayDeleteAccessGroup(storageArrayId, accessGroupId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageArrayDiscover(StorageArray storageArray) throws WsException {
        try {
            return this.api.storageArrayDiscover(storageArray);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageArrayDelete(Id<StorageArray> storageArrayId) throws WsException {
        try {
            return this.api.storageArrayDelete(storageArrayId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageArrayAddAdminServer(Id<StorageArray> storageArrayId, Id<Server> serverId) throws WsException {
        try {
            return this.api.storageArrayAddAdminServer(storageArrayId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageArrayRemoveAdminServer(Id<StorageArray> storageArrayId, Id<Server> serverId) throws WsException {
        try {
            return this.api.storageArrayRemoveAdminServer(storageArrayId, serverId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageArrayRefresh(Id<StorageArray> storageArrayId) throws WsException {
        try {
            return this.api.storageArrayRefresh(storageArrayId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageArrayValidate(Id<StorageArray> storageArrayId) throws WsException {
        try {
            return this.api.storageArrayValidate(storageArrayId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<StorageArrayPlugin> storageArrayPluginGetAll() throws WsException {
        try {
            return this.api.storageArrayPluginGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<StorageArrayPlugin>> storageArrayPluginGetIds() throws WsException {
        try {
            return this.api.storageArrayPluginGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public StorageArrayPlugin storageArrayPluginGetById(Id<StorageArrayPlugin> storageArrayPluginId) throws WsException {
        try {
            return this.api.storageArrayPluginGetById(storageArrayPluginId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<StorageArrayPlugin> storageArrayPluginGetListById(List<Id<StorageArrayPlugin>> storageArrayPluginIds) throws WsException {
        try {
            return this.api.storageArrayPluginGetListById(storageArrayPluginIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageArrayPluginModify(StorageArrayPlugin storageArrayPlugin) throws WsException {
        try {
            return this.api.storageArrayPluginModify(storageArrayPlugin);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<StorageElement> storageElementGetAll() throws WsException {
        try {
            return this.api.storageElementGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<StorageElement>> storageElementGetIds() throws WsException {
        try {
            return this.api.storageElementGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public StorageElement storageElementGetById(Id<StorageElement> storageElementId) throws WsException {
        try {
            return this.api.storageElementGetById(storageElementId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<StorageElement> storageElementGetListById(List<Id<StorageElement>> storageElementIds) throws WsException {
        try {
            return this.api.storageElementGetListById(storageElementIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageElementModify(StorageElement storageElement) throws WsException {
        try {
            return this.api.storageElementModify(storageElement);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageElementClone(Id<StorageElement> storageElementId, Id<? extends BaseObject> cloneTargetId, CloneType cloneType, String userFriendlyName) throws WsException {
        try {
            return this.api.storageElementClone(storageElementId, cloneTargetId, cloneType, userFriendlyName);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageElementRefresh(Id<StorageElement> storageElementId) throws WsException {
        try {
            return this.api.storageElementRefresh(storageElementId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageElementResize(Id<StorageElement> storageElementId, long size) throws WsException {
        try {
            return this.api.storageElementResize(storageElementId, size);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<StorageInitiator> storageInitiatorGetAll() throws WsException {
        try {
            return this.api.storageInitiatorGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<StorageInitiator>> storageInitiatorGetIds() throws WsException {
        try {
            return this.api.storageInitiatorGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public StorageInitiator storageInitiatorGetById(Id<StorageInitiator> storageInitiatorId) throws WsException {
        try {
            return this.api.storageInitiatorGetById(storageInitiatorId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<StorageInitiator> storageInitiatorGetListById(List<Id<StorageInitiator>> storageInitiatorIds) throws WsException {
        try {
            return this.api.storageInitiatorGetListById(storageInitiatorIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageInitiatorModify(StorageInitiator storageInitiator) throws WsException {
        try {
            return this.api.storageInitiatorModify(storageInitiator);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<StoragePath> storagePathGetAll() throws WsException {
        try {
            return this.api.storagePathGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<StoragePath>> storagePathGetIds() throws WsException {
        try {
            return this.api.storagePathGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public StoragePath storagePathGetById(Id<StoragePath> storagePathId) throws WsException {
        try {
            return this.api.storagePathGetById(storagePathId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<StoragePath> storagePathGetListById(List<Id<StoragePath>> storagePathIds) throws WsException {
        try {
            return this.api.storagePathGetListById(storagePathIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storagePathModify(StoragePath storagePath) throws WsException {
        try {
            return this.api.storagePathModify(storagePath);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<StorageTarget> storageTargetGetAll() throws WsException {
        try {
            return this.api.storageTargetGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<StorageTarget>> storageTargetGetIds() throws WsException {
        try {
            return this.api.storageTargetGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public StorageTarget storageTargetGetById(Id<StorageTarget> storageTargetId) throws WsException {
        try {
            return this.api.storageTargetGetById(storageTargetId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<StorageTarget> storageTargetGetListById(List<Id<StorageTarget>> storageTargetIds) throws WsException {
        try {
            return this.api.storageTargetGetListById(storageTargetIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job storageTargetModify(StorageTarget storageTarget) throws WsException {
        try {
            return this.api.storageTargetModify(storageTarget);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VirtualSwitch> virtualSwitchGetAll() throws WsException {
        try {
            return this.api.virtualSwitchGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<VirtualSwitch>> virtualSwitchGetIds() throws WsException {
        try {
            return this.api.virtualSwitchGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public VirtualSwitch virtualSwitchGetById(Id<VirtualSwitch> virtualSwitchId) throws WsException {
        try {
            return this.api.virtualSwitchGetById(virtualSwitchId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VirtualSwitch> virtualSwitchGetListById(List<Id<VirtualSwitch>> virtualSwitchIds) throws WsException {
        try {
            return this.api.virtualSwitchGetListById(virtualSwitchIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VlanInterface> vlanInterfaceGetAll() throws WsException {
        try {
            return this.api.vlanInterfaceGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<VlanInterface>> vlanInterfaceGetIds() throws WsException {
        try {
            return this.api.vlanInterfaceGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public VlanInterface vlanInterfaceGetById(Id<VlanInterface> vlanInterfaceId) throws WsException {
        try {
            return this.api.vlanInterfaceGetById(vlanInterfaceId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VlanInterface> vlanInterfaceGetListById(List<Id<VlanInterface>> vlanInterfaceIds) throws WsException {
        try {
            return this.api.vlanInterfaceGetListById(vlanInterfaceIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vlanInterfaceModify(VlanInterface vlanInterface) throws WsException {
        try {
            return this.api.vlanInterfaceModify(vlanInterface);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmClearAllMessages(Id<Vm> vmId, VmMessageType messageType) throws WsException {
        try {
            return this.api.vmClearAllMessages(vmId, messageType);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmClearMessage(Id<Vm> vmId, VmMessageType messageType, String messageKey) throws WsException {
        try {
            return this.api.vmClearMessage(vmId, messageType, messageKey);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmClearMessageList(Id<Vm> vmId, VmMessageType messageType, List<String> messageKeys) throws WsException {
        try {
            return this.api.vmClearMessageList(vmId, messageType, messageKeys);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<KeyValuePair> vmGetAllMessages(Id<Vm> vmId, VmMessageType messageType) throws WsException {
        try {
            return this.api.vmGetAllMessages(vmId, messageType);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<String> vmGetAllMessageKeys(Id<Vm> vmId, VmMessageType messageType) throws WsException {
        try {
            return this.api.vmGetAllMessageKeys(vmId, messageType);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public KeyValuePair vmGetMessage(Id<Vm> vmId, VmMessageType messageType, String messageKey) throws WsException {
        try {
            return this.api.vmGetMessage(vmId, messageType, messageKey);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<KeyValuePair> vmGetMessageList(Id<Vm> vmId, VmMessageType messageType, List<String> messageKeys) throws WsException {
        try {
            return this.api.vmGetMessageList(vmId, messageType, messageKeys);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCreateFromAssemblyVm(Id<AssemblyVm> assemblyVmId) throws WsException {
        try {
            return this.api.vmCreateFromAssemblyVm(assemblyVmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmClone(Id<Vm> vmId, Id<ServerPool> serverPoolId, Id<Repository> repositoryId, Id<VmCloneDefinition> vmCloneDefinitionId, boolean createTemplate) throws WsException {
        try {
            return this.api.vmClone(vmId, serverPoolId, repositoryId, vmCloneDefinitionId, createTemplate);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCreate(Vm vm, Id<ServerPool> serverPoolId) throws WsException {
        try {
            return this.api.vmCreate(vm, serverPoolId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCreateCloneDefinition(Id<Vm> vmId, VmCloneDefinition vmCloneDefinition) throws WsException {
        try {
            return this.api.vmCreateCloneDefinition(vmId, vmCloneDefinition);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCreateDiskMapping(Id<Vm> vmId, VmDiskMapping vmDiskMapping) throws WsException {
        try {
            return this.api.vmCreateDiskMapping(vmId, vmDiskMapping);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCreateVirtualNic(Id<Vm> vmId, VirtualNic virtualNic) throws WsException {
        try {
            return this.api.vmCreateVirtualNic(vmId, virtualNic);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmDelete(Id<Vm> vmId) throws WsException {
        try {
            return this.api.vmDelete(vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmDeleteCloneDefinition(Id<Vm> vmId, Id<VmCloneDefinition> vmCloneDefinitionId) throws WsException {
        try {
            return this.api.vmDeleteCloneDefinition(vmId, vmCloneDefinitionId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmDeleteDiskMapping(Id<Vm> vmId, Id<VmDiskMapping> vmDiskMappingId) throws WsException {
        try {
            return this.api.vmDeleteDiskMapping(vmId, vmDiskMappingId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmDeleteVirtualNic(Id<Vm> vmId, Id<VirtualNic> virtualNicId) throws WsException {
        try {
            return this.api.vmDeleteVirtualNic(vmId, virtualNicId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Vm> vmGetAll() throws WsException {
        try {
            return this.api.vmGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Vm>> vmGetIds() throws WsException {
        try {
            return this.api.vmGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Vm vmGetById(Id<Vm> vmId) throws WsException {
        try {
            return this.api.vmGetById(vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Vm> vmGetListById(List<Id<Vm>> vmIds) throws WsException {
        try {
            return this.api.vmGetListById(vmIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<String> vmGetSupportedOsTypes() throws WsException {
        try {
            return this.api.vmGetSupportedOsTypes();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmKill(Id<Vm> vmId) throws WsException {
        try {
            return this.api.vmKill(vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmMigrate(Id<Vm> vmId, Id<Server> destinationServerId) throws WsException {
        try {
            return this.api.vmMigrate(vmId, destinationServerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmModify(Vm vm) throws WsException {
        try {
            return this.api.vmModify(vm);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmMove(Id<Vm> vmId, Id<Repository> repositoryId, Id<VmCloneDefinition> vmCloneDefinitionId) throws WsException {
        try {
            return this.api.vmMove(vmId, repositoryId, vmCloneDefinitionId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmRestart(Id<Vm> vmId) throws WsException {
        try {
            return this.api.vmRestart(vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmResume(Id<Vm> vmId) throws WsException {
        try {
            return this.api.vmResume(vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmSendMessage(Id<Vm> vmId, List<KeyValuePair> message, boolean logFlag) throws WsException {
        try {
            return this.api.vmSendMessage(vmId, message, logFlag);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmStart(Id<Vm> vmId) throws WsException {
        try {
            return this.api.vmStart(vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmStop(Id<Vm> vmId) throws WsException {
        try {
            return this.api.vmStop(vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmSuspend(Id<Vm> vmId) throws WsException {
        try {
            return this.api.vmSuspend(vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public String vmGetConsoleUrl(Id<Vm> vmId) throws WsException {
        try {
            return this.api.vmGetConsoleUrl(vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public String vmGetSerialConsoleUrl(Id<Vm> vmId) throws WsException {
        try {
            return this.api.vmGetSerialConsoleUrl(vmId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VirtualDisk> virtualDiskGetAll() throws WsException {
        try {
            return this.api.virtualDiskGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<VirtualDisk>> virtualDiskGetIds() throws WsException {
        try {
            return this.api.virtualDiskGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public VirtualDisk virtualDiskGetById(Id<VirtualDisk> virtualDiskId) throws WsException {
        try {
            return this.api.virtualDiskGetById(virtualDiskId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VirtualDisk> virtualDiskGetListById(List<Id<VirtualDisk>> virtualDiskIds) throws WsException {
        try {
            return this.api.virtualDiskGetListById(virtualDiskIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job virtualDiskModify(VirtualDisk virtualDisk) throws WsException {
        try {
            return this.api.virtualDiskModify(virtualDisk);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job virtualDiskClone(Id<VirtualDisk> virtualDiskId, Id<? extends BaseObject> cloneTargetId, CloneType cloneType) throws WsException {
        try {
            return this.api.virtualDiskClone(virtualDiskId, cloneTargetId, cloneType);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public VirtualDisk virtualDiskGetEmptyCdrom() throws WsException {
        try {
            return this.api.virtualDiskGetEmptyCdrom();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job virtualDiskResize(Id<VirtualDisk> virtualDiskId, long size, boolean sparse) throws WsException {
        try {
            return this.api.virtualDiskResize(virtualDiskId, size, sparse);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VmCloneDefinition> vmCloneDefinitionGetAll() throws WsException {
        try {
            return this.api.vmCloneDefinitionGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<VmCloneDefinition>> vmCloneDefinitionGetIds() throws WsException {
        try {
            return this.api.vmCloneDefinitionGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public VmCloneDefinition vmCloneDefinitionGetById(Id<VmCloneDefinition> vmCloneDefinitionId) throws WsException {
        try {
            return this.api.vmCloneDefinitionGetById(vmCloneDefinitionId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VmCloneDefinition> vmCloneDefinitionGetListById(List<Id<VmCloneDefinition>> vmCloneDefinitionIds) throws WsException {
        try {
            return this.api.vmCloneDefinitionGetListById(vmCloneDefinitionIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCloneDefinitionModify(VmCloneDefinition vmCloneDefinition) throws WsException {
        try {
            return this.api.vmCloneDefinitionModify(vmCloneDefinition);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCloneDefinitionCreateNetworkMapping(Id<VmCloneDefinition> vmCloneDefinitionId, VmCloneNetworkMapping vmCloneNetworkMapping) throws WsException {
        try {
            return this.api.vmCloneDefinitionCreateNetworkMapping(vmCloneDefinitionId, vmCloneNetworkMapping);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCloneDefinitionDeleteNetworkMapping(Id<VmCloneDefinition> vmCloneDefinitionId, Id<VmCloneNetworkMapping> vmCloneNetworkMappingId) throws WsException {
        try {
            return this.api.vmCloneDefinitionDeleteNetworkMapping(vmCloneDefinitionId, vmCloneNetworkMappingId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCloneDefinitionCreateStorageMapping(Id<VmCloneDefinition> vmCloneDefinitionId, VmCloneStorageMapping vmCloneStorageMapping) throws WsException {
        try {
            return this.api.vmCloneDefinitionCreateStorageMapping(vmCloneDefinitionId, vmCloneStorageMapping);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCloneDefinitionDeleteStorageMapping(Id<VmCloneDefinition> vmCloneDefinitionId, Id<VmCloneStorageMapping> vmCloneStorageMappingId) throws WsException {
        try {
            return this.api.vmCloneDefinitionDeleteStorageMapping(vmCloneDefinitionId, vmCloneStorageMappingId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VmCloneNetworkMapping> vmCloneNetworkMappingGetAll() throws WsException {
        try {
            return this.api.vmCloneNetworkMappingGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<VmCloneNetworkMapping>> vmCloneNetworkMappingGetIds() throws WsException {
        try {
            return this.api.vmCloneNetworkMappingGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public VmCloneNetworkMapping vmCloneNetworkMappingGetById(Id<VmCloneNetworkMapping> vmCloneNetworkMappingId) throws WsException {
        try {
            return this.api.vmCloneNetworkMappingGetById(vmCloneNetworkMappingId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VmCloneNetworkMapping> vmCloneNetworkMappingGetListById(List<Id<VmCloneNetworkMapping>> vmCloneNetworkMappingIds) throws WsException {
        try {
            return this.api.vmCloneNetworkMappingGetListById(vmCloneNetworkMappingIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCloneNetworkMappingModify(VmCloneNetworkMapping vmCloneNetworkMapping) throws WsException {
        try {
            return this.api.vmCloneNetworkMappingModify(vmCloneNetworkMapping);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCloneNetworkMappingSetNetwork(Id<VmCloneNetworkMapping> vmCloneNetworkMappingId, Id<Network> networkId) throws WsException {
        try {
            return this.api.vmCloneNetworkMappingSetNetwork(vmCloneNetworkMappingId, networkId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VmCloneStorageMapping> vmCloneStorageMappingGetAll() throws WsException {
        try {
            return this.api.vmCloneStorageMappingGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<VmCloneStorageMapping>> vmCloneStorageMappingGetIds() throws WsException {
        try {
            return this.api.vmCloneStorageMappingGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public VmCloneStorageMapping vmCloneStorageMappingGetById(Id<VmCloneStorageMapping> vmCloneStorageMappingId) throws WsException {
        try {
            return this.api.vmCloneStorageMappingGetById(vmCloneStorageMappingId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VmCloneStorageMapping> vmCloneStorageMappingGetListById(List<Id<VmCloneStorageMapping>> vmCloneStorageMappingIds) throws WsException {
        try {
            return this.api.vmCloneStorageMappingGetListById(vmCloneStorageMappingIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCloneStorageMappingModify(VmCloneStorageMapping vmCloneStorageMapping) throws WsException {
        try {
            return this.api.vmCloneStorageMappingModify(vmCloneStorageMapping);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmCloneStorageMappingSetStorageCloneTarget(Id<VmCloneStorageMapping> vmCloneStorageMappingId, Id<? extends BaseObject> storageCloneTargetId) throws WsException {
        try {
            return this.api.vmCloneStorageMappingSetStorageCloneTarget(vmCloneStorageMappingId, storageCloneTargetId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VmDiskMapping> vmDiskMappingGetAll() throws WsException {
        try {
            return this.api.vmDiskMappingGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<VmDiskMapping>> vmDiskMappingGetIds() throws WsException {
        try {
            return this.api.vmDiskMappingGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public VmDiskMapping vmDiskMappingGetById(Id<VmDiskMapping> vmDiskMappingId) throws WsException {
        try {
            return this.api.vmDiskMappingGetById(vmDiskMappingId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VmDiskMapping> vmDiskMappingGetListById(List<Id<VmDiskMapping>> vmDiskMappingIds) throws WsException {
        try {
            return this.api.vmDiskMappingGetListById(vmDiskMappingIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmDiskMappingModify(VmDiskMapping vmDiskMapping) throws WsException {
        try {
            return this.api.vmDiskMappingModify(vmDiskMapping);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job vmDiskMappingSetVirtualDisk(Id<VmDiskMapping> vmDiskMappingId, Id<VirtualDisk> virtualDiskId) throws WsException {
        try {
            return this.api.vmDiskMappingSetVirtualDisk(vmDiskMappingId, virtualDiskId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VirtualNic> virtualNicGetAll() throws WsException {
        try {
            return this.api.virtualNicGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<VirtualNic>> virtualNicGetIds() throws WsException {
        try {
            return this.api.virtualNicGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public VirtualNic virtualNicGetById(Id<VirtualNic> virtualNicId) throws WsException {
        try {
            return this.api.virtualNicGetById(virtualNicId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job virtualNicModify(VirtualNic virtualNic) throws WsException {
        try {
            return this.api.virtualNicModify(virtualNic);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VirtualNic> virtualNicGetListById(List<Id<VirtualNic>> virtualNicIds) throws WsException {
        try {
            return this.api.virtualNicGetListById(virtualNicIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VolumeGroup> volumeGroupGetAll() throws WsException {
        try {
            return this.api.volumeGroupGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<VolumeGroup>> volumeGroupGetIds() throws WsException {
        try {
            return this.api.volumeGroupGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public VolumeGroup volumeGroupGetById(Id<VolumeGroup> volumeGroupId) throws WsException {
        try {
            return this.api.volumeGroupGetById(volumeGroupId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<VolumeGroup> volumeGroupGetListById(List<Id<VolumeGroup>> volumeGroupIds) throws WsException {
        try {
            return this.api.volumeGroupGetListById(volumeGroupIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job volumeGroupModify(VolumeGroup volumeGroup) throws WsException {
        try {
            return this.api.volumeGroupModify(volumeGroup);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job volumeGroupCreateStorageElement(Id<VolumeGroup> volumeGroupId, StorageElement storageElement) throws WsException {
        try {
            return this.api.volumeGroupCreateStorageElement(volumeGroupId, storageElement);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job volumeGroupDeleteStorageElement(Id<VolumeGroup> volumeGroupId, Id<StorageElement> storageElementId) throws WsException {
        try {
            return this.api.volumeGroupDeleteStorageElement(volumeGroupId, storageElementId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job zoneCreate(Zone zone) throws WsException {
        try {
            return this.api.zoneCreate(zone);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job zoneModify(Zone zone) throws WsException {
        try {
            return this.api.zoneModify(zone);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Zone> zoneGetAll() throws WsException {
        try {
            return this.api.zoneGetAll();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Id<Zone>> zoneGetIds() throws WsException {
        try {
            return this.api.zoneGetIds();
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Zone zoneGetById(Id<Zone> zoneId) throws WsException {
        try {
            return this.api.zoneGetById(zoneId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public List<Zone> zoneGetListById(List<Id<Zone>> zoneIds) throws WsException {
        try {
            return this.api.zoneGetListById(zoneIds);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job zoneAddServerPool(Id<Zone> zoneId, Id<ServerPool> serverPoolId) throws WsException {
        try {
            return this.api.zoneAddServerPool(zoneId, serverPoolId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job zoneRemoveServerPool(Id<Zone> zoneId, Id<ServerPool> serverPoolId) throws WsException {
        try {
            return this.api.zoneRemoveServerPool(zoneId, serverPoolId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job zoneAddStorageArray(Id<Zone> zoneId, Id<StorageArray> storageArrayId) throws WsException {
        try {
            return this.api.zoneAddStorageArray(zoneId, storageArrayId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job zoneRemoveStorageArray(Id<Zone> zoneId, Id<StorageArray> storageArrayId) throws WsException {
        try {
            return this.api.zoneRemoveStorageArray(zoneId, storageArrayId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job zoneAddFileServer(Id<Zone> zoneId, Id<FileServer> fileServerId) throws WsException {
        try {
            return this.api.zoneAddFileServer(zoneId, fileServerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job zoneRemoveFileServer(Id<Zone> zoneId, Id<FileServer> fileServerId) throws WsException {
        try {
            return this.api.zoneRemoveFileServer(zoneId, fileServerId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }

    @Override
    public Job zoneDelete(Id<Zone> zoneId) throws WsException {
        try {
            return this.api.zoneDelete(zoneId);
        }
        catch (WsException_Exception ex) {
            throw this.convertException(ex);
        }
    }
}

