/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.FileType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.ReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.AdminServiceType;
import com.vmware.vcloud.api.rest.schema.extension.AuthorizationCheckParamsType;
import com.vmware.vcloud.api.rest.schema.extension.AuthorizationCheckResponseType;
import com.vmware.vcloud.api.rest.schema.extension.BundleUploadParamsType;
import com.vmware.vcloud.api.rest.schema.extension.BundleUploadSocketType;
import com.vmware.vcloud.api.rest.schema.extension.LicensingReportListType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectExtensionType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectExtensionsType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.OperationLimitsSettingsType;
import com.vmware.vcloud.api.rest.schema.extension.RegisterVimServerParamsType;
import com.vmware.vcloud.api.rest.schema.extension.VMWExtensionType;
import com.vmware.vcloud.api.rest.schema.extension.VMWExternalNetworkReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.VMWExternalNetworkType;
import com.vmware.vcloud.api.rest.schema.extension.VMWHostReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.VMWNetworkPoolReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.VMWNetworkPoolType;
import com.vmware.vcloud.api.rest.schema.extension.VMWProviderVdcParamsType;
import com.vmware.vcloud.api.rest.schema.extension.VMWProviderVdcReferencesType;
import com.vmware.vcloud.api.rest.schema.extension.VMWProviderVdcType;
import com.vmware.vcloud.api.rest.schema.extension.VMWVdcTemplateType;
import com.vmware.vcloud.api.rest.schema.extension.VMWVimServerReferencesType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.ReferenceResult;
import com.vmware.vcloud.sdk.RestUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VCloudRuntimeException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.admin.extensions.ExtensionQueryService;
import com.vmware.vcloud.sdk.admin.extensions.VMWExternalNetwork;
import com.vmware.vcloud.sdk.admin.extensions.VMWNetworkPool;
import com.vmware.vcloud.sdk.admin.extensions.VMWProviderVdc;
import com.vmware.vcloud.sdk.admin.extensions.VMWVdcTemplate;
import com.vmware.vcloud.sdk.admin.extensions.VcloudAdminExtensionSettings;
import com.vmware.vcloud.sdk.admin.extensions.service.AdminService;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.query.FormatType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcloudAdminExtension {
    private VMWExtensionType vmwExtensionResource_v1_5;
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private VcloudClient client;

    public VcloudAdminExtension(VcloudClient client) throws VCloudException {
        this.client = client;
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + client.getVcloudApiURL() + "/admin/extension");
        this.vmwExtensionResource_v1_5 = (VMWExtensionType)SdkUtil.get(client, client.getVcloudApiURL() + "/admin/extension", 200);
    }

    public VcloudAdminExtensionSettings getVcloudAdminExtensionSettings() throws VCloudException {
        return new VcloudAdminExtensionSettings(this.client);
    }

    public ExtensionQueryService getExtensionQueryService() {
        return new ExtensionQueryService(this.client);
    }

    public VMWExtensionType getResource() {
        return this.vmwExtensionResource_v1_5;
    }

    public HashMap<String, ReferenceType> getVMWProviderVdcRefsByName() throws VCloudException {
        HashMap<String, ReferenceType> vmwProviderVdcRefs = new HashMap<String, ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/providerVdcReferences";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VMWProviderVdcReferencesType vmwProviderVdcReferencesType = (VMWProviderVdcReferencesType)SdkUtil.get(this.client, url, 200);
        for (ReferenceType ref : vmwProviderVdcReferencesType.getProviderVdcReference()) {
            vmwProviderVdcRefs.put(ref.getName(), ref);
        }
        return vmwProviderVdcRefs;
    }

    public HashMap<String, ReferenceType> getVMWExternalNetworkRefsByName() throws VCloudException {
        HashMap<String, ReferenceType> vmwExternalNetworkRefs = new HashMap<String, ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/externalNetworkReferences";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VMWExternalNetworkReferencesType vmwExternalNetworkReferencesType = (VMWExternalNetworkReferencesType)SdkUtil.get(this.client, url, 200);
        for (ReferenceType ref : vmwExternalNetworkReferencesType.getExternalNetworkReference()) {
            vmwExternalNetworkRefs.put(ref.getName(), ref);
        }
        return vmwExternalNetworkRefs;
    }

    public HashMap<String, ReferenceType> getVMWNetworkPoolRefsByName() throws VCloudException {
        HashMap<String, ReferenceType> vmwNetworkPoolRefs = new HashMap<String, ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/networkPoolReferences";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VMWNetworkPoolReferencesType vmwNetworkPoolReferencesType = (VMWNetworkPoolReferencesType)SdkUtil.get(this.client, url, 200);
        for (ReferenceType ref : vmwNetworkPoolReferencesType.getNetworkPoolReference()) {
            vmwNetworkPoolRefs.put(ref.getName(), ref);
        }
        return vmwNetworkPoolRefs;
    }

    public HashMap<String, ReferenceType> getVMWVimServerRefsByName() throws VCloudException {
        HashMap<String, ReferenceType> vmwVimServerRefs = new HashMap<String, ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/vimServerReferences";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VMWVimServerReferencesType vmwVimServerReferencesType = (VMWVimServerReferencesType)SdkUtil.get(this.client, url, 200);
        for (ReferenceType ref : vmwVimServerReferencesType.getVimServerReference()) {
            vmwVimServerRefs.put(ref.getName(), ref);
        }
        return vmwVimServerRefs;
    }

    public HashMap<String, ReferenceType> getVMWHostRefsByName() throws VCloudException {
        HashMap<String, ReferenceType> vmwHostRefs = new HashMap<String, ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/hostReferences";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        VMWHostReferencesType vmwHostReferencesType = (VMWHostReferencesType)SdkUtil.get(this.client, url, 200);
        for (ReferenceType ref : vmwHostReferencesType.getHostReference()) {
            vmwHostRefs.put(ref.getName(), ref);
        }
        return vmwHostRefs;
    }

    public List<ReferenceType> getVMWDatastoreRefs() throws VCloudException {
        ArrayList<ReferenceType> vmwDatastoreRefs = new ArrayList<ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/datastores";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        ReferencesType vmwDatastoreReferencesType = (ReferencesType)SdkUtil.get(this.client, url, 200);
        for (JAXBElement ref : vmwDatastoreReferencesType.getReference()) {
            vmwDatastoreRefs.add((ReferenceType)ref.getValue());
        }
        return vmwDatastoreRefs;
    }

    public List<ReferenceType> getVMWVdcTemplateRefs() throws VCloudException {
        ArrayList<ReferenceType> vmwVdcTemplateRefs = new ArrayList<ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/vdcTemplateReferences";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        ReferencesType vmwVdcTemplateReferencesType = (ReferencesType)SdkUtil.get(this.client, url, 200);
        for (JAXBElement ref : vmwVdcTemplateReferencesType.getReference()) {
            vmwVdcTemplateRefs.add((ReferenceType)ref.getValue());
        }
        return vmwVdcTemplateRefs;
    }

    public Collection<ReferenceType> getLicensingReportRefs() throws VCloudException {
        ArrayList<ReferenceType> licenseReportRefs = new ArrayList<ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/licensing/" + "reports";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        LicensingReportListType licensingReportListType = (LicensingReportListType)SdkUtil.get(this.client, url, 200);
        for (LinkType ref : licensingReportListType.getReport()) {
            licenseReportRefs.add((ReferenceType)ref);
        }
        return licenseReportRefs;
    }

    public RegisterVimServerParamsType registerVMWVimServer(RegisterVimServerParamsType registerVimServerParamsType) throws VCloudException {
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/action/registervimserver";
        ObjectFactory extensionFactory = new ObjectFactory();
        String registerVimServerRequestString = JAXBUtil.marshal(extensionFactory.createRegisterVimServerParams(registerVimServerParamsType));
        return (RegisterVimServerParamsType)SdkUtil.post(this.client, url, registerVimServerRequestString, "application/vnd.vmware.admin.registerVimServerParams+xml", 200);
    }

    public VMWProviderVdc createVMWProviderVdc(VMWProviderVdcType vmwProviderVdcType) throws VCloudException {
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/providervdcs";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createVMWProviderVdcRequestString = JAXBUtil.marshal(extensionFactory.createVMWProviderVdc(vmwProviderVdcType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new VMWProviderVdc(this.client, (VMWProviderVdcType)SdkUtil.post(this.client, url, createVMWProviderVdcRequestString, "application/vnd.vmware.admin.vmwprovidervdc+xml", 201));
    }

    public VMWProviderVdc createVMWProviderVdc(VMWProviderVdcParamsType vmwProviderVdcParams) throws VCloudException {
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/providervdcsparams";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createVMWProviderVdcRequestString = JAXBUtil.marshal(extensionFactory.createVMWProviderVdcParams(vmwProviderVdcParams));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new VMWProviderVdc(this.client, (VMWProviderVdcType)SdkUtil.post(this.client, url, createVMWProviderVdcRequestString, "application/vnd.vmware.admin.createProviderVdcParams+xml", 201));
    }

    public VMWExternalNetwork createVMWExternalNetwork(VMWExternalNetworkType vmwExternalNetworkType) throws VCloudException {
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/externalnets";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createVMWExternalNetworkRequestString = JAXBUtil.marshal(extensionFactory.createVMWExternalNetwork(vmwExternalNetworkType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new VMWExternalNetwork(this.client, (VMWExternalNetworkType)SdkUtil.post(this.client, url, createVMWExternalNetworkRequestString, "application/vnd.vmware.admin.vmwexternalnet+xml", 201));
    }

    public VMWNetworkPool createVMWNetworkPool(VMWNetworkPoolType vmwNetworkPoolType) throws VCloudException {
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/networkPools";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createVMWNetworkPoolRequestString = JAXBUtil.marshal(extensionFactory.createVMWNetworkPool(vmwNetworkPoolType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new VMWNetworkPool(this.client, (VMWNetworkPoolType)SdkUtil.post(this.client, url, createVMWNetworkPoolRequestString, "application/vnd.vmware.admin.networkPool+xml", 201));
    }

    public Collection<ReferenceType> getBlockingTaskRefs() throws VCloudException {
        ArrayList<ReferenceType> blockingTasks = new ArrayList<ReferenceType>();
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/blockingTasks";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        ReferencesType references = (ReferencesType)SdkUtil.get(this.client, url, 200);
        for (JAXBElement jaxbRef : references.getReference()) {
            blockingTasks.add((ReferenceType)jaxbRef.getValue());
        }
        return blockingTasks;
    }

    public ReferenceResult getStrandedItemRefs() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/admin/extension/strandedItems/query" + "?" + this.client.getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.client.getQueryService().executeQuery(query);
    }

    public ReferenceResult getAdminServiceRefs() throws VCloudException {
        String query = this.client.getVcloudApiURL() + "/admin/extension/service/query" + "?" + this.client.getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.client.getQueryService().executeQuery(query);
    }

    public AdminService getAdminServiceByName(String serviceName) throws VCloudException {
        for (ReferenceType adminServiceRef : this.getAdminServiceRefs().getReferences()) {
            if (!adminServiceRef.getName().equals(serviceName)) continue;
            return AdminService.getAdminServiceByReference(this.client, adminServiceRef);
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.SERVICE_NOT_FOUND) + " - " + serviceName);
    }

    public boolean isServiceAlreadyRegistered(String serviceName) {
        try {
            this.getAdminServiceByName(serviceName);
            return true;
        }
        catch (VCloudException e) {
            return false;
        }
    }

    public AdminService createService(AdminServiceType serviceParams) throws VCloudException {
        String requestXML = JAXBUtil.marshal(new ObjectFactory().createService(serviceParams));
        return new AdminService(this.client, (AdminServiceType)SdkUtil.post(this.client, this.client.getVcloudApiURL() + "/admin/extension" + "/service", requestXML, "application/vnd.vmware.admin.service+xml", 201));
    }

    public AdminService createService(String serviceName, String serviceNamespace, String serviceExchange, String serviceRoutingKey, int servicePriority, boolean serviceAuthorizationEnabled) throws VCloudException {
        AdminServiceType adminServiceParams = new AdminServiceType();
        adminServiceParams.setName(serviceName);
        adminServiceParams.setNamespace(serviceNamespace);
        adminServiceParams.setExchange(serviceExchange);
        adminServiceParams.setRoutingKey(serviceRoutingKey);
        adminServiceParams.setEnabled(Boolean.valueOf(true));
        adminServiceParams.setAuthorizationEnabled(Boolean.valueOf(serviceAuthorizationEnabled));
        adminServiceParams.setPriority(Integer.valueOf(servicePriority));
        return this.createService(adminServiceParams);
    }

    public void clearUnusedRights() throws VCloudException {
        SdkUtil.post(this.client, this.client.getVcloudApiURL() + "/admin/extension" + "/service" + "/action/clearunusedrights", null, null, 204);
    }

    public void clearUnusedLocalizationBundle() throws VCloudException {
        String postUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/service" + "/action/clearunusedlocalizationbundles";
        SdkUtil.post(this.client, postUrl, null, null, 204);
    }

    public void uploadLocalizationBundle(BundleUploadParamsType bundleUploadParamsType, InputStream inputStream) throws VCloudException {
        String requestXMLString = JAXBUtil.marshal(new ObjectFactory().createBundleUploadParams(bundleUploadParamsType));
        String postUrl = this.client.getVcloudApiURL() + "/admin/extension" + "/service" + "/localizationbundles";
        String uploadUrl = ((BundleUploadSocketType)SdkUtil.post(this.client, postUrl, requestXMLString, "application/vnd.vmware.admin.bundleUploadParams+xml", 200)).getUploadLocation();
        FileType file = new FileType();
        file.setName(uploadUrl);
        LinkType link = new LinkType();
        link.setHref(uploadUrl);
        link.setRel("upload:default");
        file.getLink().add(link);
        RestUtil.uploadFile(this.client, file, inputStream, bundleUploadParamsType.getFileSize(), 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadLocalizationBundle(String localFileLocation, String serviceNamespace) throws VCloudException {
        File localizationFile = new File(localFileLocation);
        try {
            FileInputStream bundleInputStream = new FileInputStream(localizationFile);
            try {
                BundleUploadParamsType bundleUploadParamsType = new BundleUploadParamsType();
                bundleUploadParamsType.setFileSize(Long.valueOf(localizationFile.length()));
                bundleUploadParamsType.setServiceNamespace(serviceNamespace);
                this.uploadLocalizationBundle(bundleUploadParamsType, bundleInputStream);
            }
            finally {
                bundleInputStream.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new VCloudRuntimeException(e);
        }
        catch (IOException e) {
            throw new VCloudRuntimeException(e);
        }
    }

    public boolean isAuthorized(AuthorizationCheckParamsType authorizationCheckParamsType) throws VCloudException {
        String checkAuthorizationUri = this.client.getVcloudApiURL() + "/admin/extension" + "/service" + "/authorizationcheck";
        ObjectFactory objectFactory_v5_1 = new ObjectFactory();
        String requestBodyXml = JAXBUtil.marshal(objectFactory_v5_1.createAuthorizationCheckParams(authorizationCheckParamsType));
        return ((AuthorizationCheckResponseType)SdkUtil.post(this.client, checkAuthorizationUri, requestBodyXml, "application/vnd.vmware.admin.authorizationCheckParams+xml", 200)).isIsAuthorized();
    }

    public VMWVdcTemplate createVMWVdcTemplate(VMWVdcTemplateType vmwVdcTemplateType) throws VCloudException {
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/vdcTemplates";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createVMWVdcTemplateRequestString = JAXBUtil.marshal(extensionFactory.createVMWVdcTemplate(vmwVdcTemplateType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return new VMWVdcTemplate(this.client, (VMWVdcTemplateType)SdkUtil.post(this.client, url, createVMWVdcTemplateRequestString, "application/vnd.vmware.admin.vmwVdcTemplate+xml", 201));
    }

    public List<ObjectExtensionType> getRegisteredObjExtensionRefs() throws VCloudException {
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/object";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        ObjectExtensionsType objectExtensions = (ObjectExtensionsType)SdkUtil.get(this.client, url, 200);
        return objectExtensions.getObjectExtension();
    }

    public ObjectExtensionType registerObjectExtension(ObjectExtensionType vmwObjExtension) throws VCloudException {
        String url = this.client.getVcloudApiURL() + "/admin/extension" + "/object";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createObjExtension = JAXBUtil.marshal(extensionFactory.createObjectExtension(vmwObjExtension));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return (ObjectExtensionType)SdkUtil.post(this.client, url, createObjExtension, "application/vnd.vmware.admin.extensibility.object+xml", 201);
    }

    public OperationLimitsSettingsType getOperationLimitsSettings() throws VCloudException {
        String updateOperationLimitsSettingsurl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/operationLimitsSettings";
        return (OperationLimitsSettingsType)SdkUtil.get(this.client, updateOperationLimitsSettingsurl, 200);
    }

    public OperationLimitsSettingsType updateOperationLimitsSettings(OperationLimitsSettingsType operationLimitsSettingsType) throws VCloudException {
        String updateOperationLimitsSettingsurl = this.client.getVcloudApiURL() + "/admin/extension" + "/settings" + "/operationLimitsSettings";
        ObjectFactory objectFactory_v1_5 = new ObjectFactory();
        String updateXml = JAXBUtil.marshal(objectFactory_v1_5.createOperationLimitsSettings(operationLimitsSettingsType));
        return (OperationLimitsSettingsType)SdkUtil.put(this.client, updateOperationLimitsSettingsurl, updateXml, "application/vnd.vmware.admin.operationLimitsSettings+xml", 200);
    }
}

