/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin.extensions;

import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.extension.HostType;
import com.vmware.vcloud.api.rest.schema.extension.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.extension.PrepareHostParamsType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMWHost
extends VcloudEntity<HostType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");

    VMWHost(VcloudClient client, HostType hostType_v1_5) {
        super(client, hostType_v1_5);
    }

    public static VMWHost getVMWHostByReference(VcloudClient client, ReferenceType reference) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + reference.getHref());
        return new VMWHost(client, (HostType)VMWHost.getResourceByReference(client, reference));
    }

    public static VMWHost getVMWHostById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new VMWHost(client, (HostType)VMWHost.getEntityById(client, vCloudId, "application/vnd.vmware.admin.host+xml"));
    }

    public Task disableHost() throws VCloudException {
        String disableUrl = this.getReference().getHref() + "/action/disable";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), disableUrl, null, null, 202));
    }

    public static Task disableHost(VcloudClient client, ReferenceType vmwHostRef) throws VCloudException {
        String disableUrl = vmwHostRef.getHref() + "/action/disable";
        return new Task(client, (TaskType)SdkUtil.post(client, disableUrl, null, null, 202));
    }

    public Task enableHost() throws VCloudException {
        String enableURL = this.getReference().getHref() + "/action/enable";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), enableURL, null, null, 202));
    }

    public static Task enableHost(VcloudClient client, ReferenceType vmwHostRef) throws VCloudException {
        String enableURL = vmwHostRef.getHref() + "/action/enable";
        return new Task(client, (TaskType)SdkUtil.post(client, enableURL, null, null, 202));
    }

    public Task unPrepareHost() throws VCloudException {
        String url = this.getReference().getHref() + "/action/unprepare";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, null, null, 202));
    }

    public static Task unPrepareHost(VcloudClient client, ReferenceType hostRef) throws VCloudException {
        String url = hostRef.getHref() + "/action/unprepare";
        return new Task(client, (TaskType)SdkUtil.post(client, url, null, null, 202));
    }

    public Task prepareHost(String username, String password) throws VCloudException {
        PrepareHostParamsType prepareHostParamsType = new PrepareHostParamsType();
        prepareHostParamsType.setPassword(password);
        prepareHostParamsType.setUsername(username);
        ObjectFactory objectFactory = new ObjectFactory();
        String requestXmlString = JAXBUtil.marshal(objectFactory.createPrepareHostParams(prepareHostParamsType));
        String url = this.getReference().getHref() + "/action/prepare";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, requestXmlString, "application/vnd.vmware.admin.prepareHostParams+xml", 202));
    }

    public static Task prepareHost(VcloudClient client, ReferenceType hostRef, String username, String password) throws VCloudException {
        PrepareHostParamsType prepareHostParamsType = new PrepareHostParamsType();
        prepareHostParamsType.setPassword(password);
        prepareHostParamsType.setUsername(username);
        ObjectFactory objectFactory = new ObjectFactory();
        String requestXmlString = JAXBUtil.marshal(objectFactory.createPrepareHostParams(prepareHostParamsType));
        String url = hostRef.getHref() + "/action/prepare";
        return new Task(client, (TaskType)SdkUtil.post(client, url, requestXmlString, "application/vnd.vmware.admin.prepareHostParams+xml", 202));
    }

    public Task repairHost() throws VCloudException {
        String url = this.getReference().getHref() + "/action/repair";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, null, null, 202));
    }

    public static Task repairHost(VcloudClient client, ReferenceType hostRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, hostRef.getHref() + "/action/repair", null, null, 202));
    }

    public Task upgradeHost() throws VCloudException {
        String url = this.getReference().getHref() + "/action/upgrade";
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), url, null, null, 202));
    }

    public static Task upgradeHost(VcloudClient client, ReferenceType hostRef) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.post(client, hostRef.getHref() + "/action/upgrade", null, null, 202));
    }
}

