/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.sdk.admin;

import com.vmware.vcloud.api.rest.schema.AdminVdcType;
import com.vmware.vcloud.api.rest.schema.AvailableNetworksType;
import com.vmware.vcloud.api.rest.schema.GatewayType;
import com.vmware.vcloud.api.rest.schema.LinkType;
import com.vmware.vcloud.api.rest.schema.ObjectFactory;
import com.vmware.vcloud.api.rest.schema.OrgVdcNetworkType;
import com.vmware.vcloud.api.rest.schema.ReferenceType;
import com.vmware.vcloud.api.rest.schema.RegisterVAppParamsType;
import com.vmware.vcloud.api.rest.schema.ResourceEntitiesType;
import com.vmware.vcloud.api.rest.schema.ResourceReferenceType;
import com.vmware.vcloud.api.rest.schema.SelectorExtensionType;
import com.vmware.vcloud.api.rest.schema.SelectorExtensionsType;
import com.vmware.vcloud.api.rest.schema.TaskType;
import com.vmware.vcloud.api.rest.schema.UpdateVdcStorageProfilesType;
import com.vmware.vcloud.api.rest.schema.VCloudExtensionType;
import com.vmware.vcloud.api.rest.schema.VdcStorageProfileParamsType;
import com.vmware.vcloud.api.rest.schema.extension.OrganizationResourcePoolSetType;
import com.vmware.vcloud.api.rest.schema.extension.VimObjectRefType;
import com.vmware.vcloud.sdk.JAXBUtil;
import com.vmware.vcloud.sdk.ReferenceResult;
import com.vmware.vcloud.sdk.SdkUtil;
import com.vmware.vcloud.sdk.Task;
import com.vmware.vcloud.sdk.VCloudException;
import com.vmware.vcloud.sdk.VcloudClient;
import com.vmware.vcloud.sdk.VcloudEntity;
import com.vmware.vcloud.sdk.admin.AdminOrgVdcNetwork;
import com.vmware.vcloud.sdk.admin.EdgeGateway;
import com.vmware.vcloud.sdk.constants.SdkMessage;
import com.vmware.vcloud.sdk.constants.VimObjectTypeEnum;
import com.vmware.vcloud.sdk.constants.query.FormatType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminVdc
extends VcloudEntity<AdminVdcType> {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.vmware.vcloud.sdk");
    private Collection<ReferenceType> vappTemplateRefs;
    private Collection<ReferenceType> mediaRefs;
    private Collection<ReferenceType> storageProfileRefs;
    private Collection<ReferenceType> diskRefs;
    private HashMap<String, ReferenceType> vappRefsByName;
    private HashMap<String, ReferenceType> orgNetworkRefsByName;
    private ReferenceType adminOrgReference;
    private ReferenceType vdcReference;
    private VimObjectRefType primaryResourcePoolVimRef;
    private ReferenceType orgVdcResourcePoolsRef;
    private VcloudClient client;

    AdminVdc(VcloudClient client, AdminVdcType adminVdcType_v1_5) {
        super(client, adminVdcType_v1_5);
        this.sortEntityAndNetworkRefs_v1_5();
        this.client = client;
    }

    public static AdminVdc getAdminVdcByReference(VcloudClient client, ReferenceType vdcRef) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + vdcRef.getHref());
        return new AdminVdc(client, (AdminVdcType)AdminVdc.getResourceByReference(client, vdcRef));
    }

    public static AdminVdc getAdminVdcById(VcloudClient client, String vCloudId) throws VCloudException {
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_VCLOUD_ID_MSG) + " - " + vCloudId);
        return new AdminVdc(client, (AdminVdcType)AdminVdc.getEntityById(client, vCloudId, "application/vnd.vmware.admin.vdc+xml"));
    }

    public Task updateAdminVdc(AdminVdcType adminVdcType) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        String adminVdcUpdateUrl = this.getReference().getHref();
        String adminVdcUpdateRequestXmlString = JAXBUtil.marshal(of.createAdminVdc(adminVdcType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + adminVdcUpdateUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.put(this.getVcloudClient(), adminVdcUpdateUrl, adminVdcUpdateRequestXmlString, "application/vnd.vmware.admin.vdc+xml", 202));
    }

    public Task delete() throws VCloudException {
        String adminVdcUrl = this.getReference().getHref();
        return AdminVdc.deleteAdminVdc(this.getVcloudClient(), adminVdcUrl);
    }

    public static Task delete(VcloudClient client, ReferenceType adminVdcRef) throws VCloudException {
        return AdminVdc.deleteAdminVdc(client, adminVdcRef.getHref());
    }

    private static Task deleteAdminVdc(VcloudClient client, String adminVdcUrl) throws VCloudException {
        return new Task(client, (TaskType)SdkUtil.delete(client, adminVdcUrl, 202));
    }

    public void enable() throws VCloudException {
        String enableURL = this.getReference().getHref() + "/action/enable";
        AdminVdc.executeVdcAction(this.getVcloudClient(), enableURL, null, null, 204);
    }

    public static void enable(VcloudClient client, ReferenceType adminVdcRef) throws VCloudException {
        String enableURL = adminVdcRef.getHref() + "/action/enable";
        AdminVdc.executeVdcAction(client, enableURL, null, null, 204);
    }

    public void disable() throws VCloudException {
        String disableUrl = this.getReference().getHref() + "/action/disable";
        AdminVdc.executeVdcAction(this.getVcloudClient(), disableUrl, null, null, 204);
    }

    public static void disable(VcloudClient client, ReferenceType adminVdcRef) throws VCloudException {
        String enableURL = adminVdcRef.getHref() + "/action/disable";
        AdminVdc.executeVdcAction(client, enableURL, null, null, 204);
    }

    public Task enableFastProvisioning() throws VCloudException {
        AdminVdcType adminVdcType = (AdminVdcType)this.getResource();
        adminVdcType.setUsesFastProvisioning(Boolean.valueOf(true));
        return this.updateAdminVdc(adminVdcType);
    }

    public Task disableFastProvisioning() throws VCloudException {
        AdminVdcType adminVdcType = (AdminVdcType)this.getResource();
        adminVdcType.setUsesFastProvisioning(Boolean.valueOf(false));
        return this.updateAdminVdc(adminVdcType);
    }

    private static void executeVdcAction(VcloudClient client, String orgActionUrl, String content, String contentType, int statusCode) throws VCloudException {
        SdkUtil.post(client, orgActionUrl, content, contentType, statusCode);
    }

    public ReferenceType getAdminOrganizationReference() throws VCloudException {
        if (this.adminOrgReference != null) {
            return this.adminOrgReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public ReferenceType getVdcReference() throws VCloudException {
        if (this.vdcReference != null) {
            return this.vdcReference;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public VimObjectRefType getResourcePoolVimRef() throws VCloudException {
        if (this.primaryResourcePoolVimRef != null) {
            return this.primaryResourcePoolVimRef;
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.VIM_OBJECT_REF_NOT_FOUND_MSG));
    }

    public HashMap<String, VimObjectRefType> getResourcePoolVimRefsByMoref() throws VCloudException {
        if (this.orgVdcResourcePoolsRef == null) {
            throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
        }
        OrganizationResourcePoolSetType organizationResourcePoolSet = (OrganizationResourcePoolSetType)SdkUtil.get(this.getVcloudClient(), this.orgVdcResourcePoolsRef.getHref(), 200);
        HashMap<String, VimObjectRefType> orgVdcResourcePoolVimRefsByMoref = new HashMap<String, VimObjectRefType>();
        for (VimObjectRefType resourcePoolVimObjectRef : organizationResourcePoolSet.getResourcePoolVimObjectRef()) {
            orgVdcResourcePoolVimRefsByMoref.put(resourcePoolVimObjectRef.getMoRef(), resourcePoolVimObjectRef);
        }
        return orgVdcResourcePoolVimRefsByMoref;
    }

    private void sortEntityAndNetworkRefs_v1_5() {
        AvailableNetworksType availableNetworksType;
        ResourceEntitiesType resEntities;
        List entities;
        this.vappTemplateRefs = new ArrayList<ReferenceType>();
        this.mediaRefs = new ArrayList<ReferenceType>();
        this.vappRefsByName = new HashMap();
        this.orgNetworkRefsByName = new HashMap();
        this.storageProfileRefs = new ArrayList<ReferenceType>();
        this.diskRefs = new ArrayList<ReferenceType>();
        if (((AdminVdcType)this.getResource()).getResourceEntities() != null && (entities = (resEntities = ((AdminVdcType)this.getResource()).getResourceEntities()).getResourceEntity()) != null) {
            for (ResourceReferenceType entity : entities) {
                if (entity.getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml")) {
                    this.vappTemplateRefs.add((ReferenceType)entity);
                    continue;
                }
                if (entity.getType().equals("application/vnd.vmware.vcloud.media+xml")) {
                    this.mediaRefs.add((ReferenceType)entity);
                    continue;
                }
                if (entity.getType().equals("application/vnd.vmware.vcloud.vApp+xml")) {
                    this.vappRefsByName.put(entity.getName(), (ReferenceType)entity);
                    continue;
                }
                if (entity.getType().equals("application/vnd.vmware.vcloud.disk+xml")) {
                    this.diskRefs.add((ReferenceType)entity);
                    continue;
                }
                logger.warn(SdkUtil.getI18nString(SdkMessage.UNKNOWN_REF_TYPE_MSG), (Object)entity.getType());
            }
        }
        if (((AdminVdcType)this.getResource()).getAvailableNetworks() != null && (availableNetworksType = ((AdminVdcType)this.getResource()).getAvailableNetworks()) != null) {
            for (ReferenceType networkRef : availableNetworksType.getNetwork()) {
                this.orgNetworkRefsByName.put(networkRef.getName(), networkRef);
            }
        }
        for (LinkType adminVdcLink : ((AdminVdcType)this.getResource()).getLink()) {
            if (adminVdcLink.getRel().equals("up") && adminVdcLink.getType().equals("application/vnd.vmware.admin.organization+xml")) {
                this.adminOrgReference = adminVdcLink;
            }
            if (adminVdcLink.getRel().equals("alternate") && adminVdcLink.getType().equals("application/vnd.vmware.vcloud.vdc+xml")) {
                this.vdcReference = adminVdcLink;
            }
            if (!adminVdcLink.getRel().equals("down") || !adminVdcLink.getType().equals("application/vnd.vmware.admin.OrganizationVdcResourcePoolSet+xml")) continue;
            this.orgVdcResourcePoolsRef = adminVdcLink;
        }
        for (VCloudExtensionType vcloudExtension : ((AdminVdcType)this.getResource()).getVCloudExtension()) {
            for (Object jaxbObject : vcloudExtension.getAny()) {
                if (!(((JAXBElement)jaxbObject).getValue() instanceof VimObjectRefType) || !((VimObjectRefType)((JAXBElement)jaxbObject).getValue()).getVimObjectType().equals(VimObjectTypeEnum.RESOURCE_POOL.value())) continue;
                this.primaryResourcePoolVimRef = (VimObjectRefType)((JAXBElement)jaxbObject).getValue();
            }
        }
        if (((AdminVdcType)this.getResource()).getVdcStorageProfiles() != null) {
            for (ReferenceType ref : ((AdminVdcType)this.getResource()).getVdcStorageProfiles().getVdcStorageProfile()) {
                this.storageProfileRefs.add(ref);
            }
        }
    }

    public HashMap<String, ReferenceType> getAdminOrgNetworkRefsByName() {
        return this.orgNetworkRefsByName;
    }

    public Collection<ReferenceType> getAdminOrgNetworkRefs() {
        return this.orgNetworkRefsByName.values();
    }

    public ReferenceType getAdminOrgNetworkRefByName(String name) {
        return this.orgNetworkRefsByName.get(name);
    }

    public Collection<ReferenceType> getVappTemplateRefs() {
        return this.vappTemplateRefs;
    }

    public Collection<ReferenceType> getMediaRefs() {
        return this.mediaRefs;
    }

    public HashMap<String, ReferenceType> getVappRefsByName() {
        return this.vappRefsByName;
    }

    public Collection<ReferenceType> getVappRefs() {
        return this.vappRefsByName.values();
    }

    public ReferenceType getVappRefByName(String name) {
        return this.vappRefsByName.get(name);
    }

    public ReferenceType getProviderVdcRef() {
        return ((AdminVdcType)this.getResource()).getProviderVdcReference();
    }

    public ReferenceType getNetworkPoolRef() throws VCloudException {
        if (((AdminVdcType)this.getResource()).getNetworkPoolReference() != null) {
            return ((AdminVdcType)this.getResource()).getNetworkPoolReference();
        }
        throw new VCloudException(SdkUtil.getI18nString(SdkMessage.REFERENCE_NOT_FOUND_MSG));
    }

    public Collection<ReferenceType> getAdminVdcStorageProfileRefs() {
        return this.storageProfileRefs;
    }

    public Collection<ReferenceType> getDiskRefs() {
        return this.diskRefs;
    }

    public Task updateAdminVdcStorageProfiles(List<VdcStorageProfileParamsType> addStorageProfiles, List<ReferenceType> removeStorageProfiles) throws VCloudException {
        ObjectFactory of = new ObjectFactory();
        UpdateVdcStorageProfilesType updateStorageProfilesType = new UpdateVdcStorageProfilesType();
        updateStorageProfilesType.getAddStorageProfile().addAll(addStorageProfiles);
        updateStorageProfilesType.getRemoveStorageProfile().addAll(removeStorageProfiles);
        String updateVdcStprageProfilesUrl = this.getReference().getHref() + "/vdcStorageProfiles";
        String adminVdcUpdateRequestXmlString = JAXBUtil.marshal(of.createUpdateVdcStorageProfiles(updateStorageProfilesType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + updateVdcStprageProfilesUrl);
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), updateVdcStprageProfilesUrl, adminVdcUpdateRequestXmlString, "application/vnd.vmware.admin.updateVdcStorageProfiles+xml", 202));
    }

    public EdgeGateway createEdgeGateway(GatewayType gatewayParams) throws VCloudException {
        String requestXml = JAXBUtil.marshal(new ObjectFactory().createEdgeGateway(gatewayParams));
        return new EdgeGateway(this.getVcloudClient(), (GatewayType)SdkUtil.post(this.getVcloudClient(), ((AdminVdcType)this.getResource()).getHref() + "/edgeGateways", requestXml, "application/vnd.vmware.admin.edgeGateway+xml", 201));
    }

    public ReferenceResult getEdgeGatewayRefs() throws VCloudException {
        String query = this.getReference().getHref() + "/edgeGateways" + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.getVcloudClient().getQueryService().executeQuery(query);
    }

    public ReferenceResult getOrgVdcNetworkRefs() throws VCloudException {
        String query = this.getReference().getHref() + "/networks" + "?" + this.getVcloudClient().getQueryService().buildQuery(FormatType.REFERENCE_VIEW);
        return (ReferenceResult)this.getVcloudClient().getQueryService().executeQuery(query);
    }

    public AdminOrgVdcNetwork createOrgVdcNetwork(OrgVdcNetworkType orgVdcNetworkParams) throws VCloudException {
        String requestXml = JAXBUtil.marshal(new ObjectFactory().createOrgVdcNetwork(orgVdcNetworkParams));
        return new AdminOrgVdcNetwork(this.getVcloudClient(), (OrgVdcNetworkType)SdkUtil.post(this.getVcloudClient(), ((AdminVdcType)this.getResource()).getHref() + "/networks", requestXml, "application/vnd.vmware.vcloud.orgVdcNetwork+xml", 201));
    }

    public Task registerVapp(RegisterVAppParamsType registerVappParams) throws VCloudException {
        String requestXml = JAXBUtil.marshal(new ObjectFactory().createRegisterVAppParams(registerVappParams));
        return new Task(this.getVcloudClient(), (TaskType)SdkUtil.post(this.getVcloudClient(), ((AdminVdcType)this.getResource()).getHref() + "/action/registerVApp", requestXml, "application/vnd.vmware.admin.registerVAppParams+xml", 202));
    }

    public SelectorExtensionType createAdminVdcSelectorExtension(SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = ((AdminVdcType)this.getResource()).getHref() + "/extension";
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.POST_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.post(this.client, url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 201);
    }

    public List<SelectorExtensionType> getAdminVdcSelectorExtension() throws VCloudException {
        String url = ((AdminVdcType)this.getResource()).getHref() + "/extension";
        logger.info(SdkUtil.getI18nString(SdkMessage.GET_URL_MSG) + " - " + url);
        SelectorExtensionsType objectExtension = (SelectorExtensionsType)SdkUtil.get(this.client, url, 200);
        return objectExtension.getSelectorExtension();
    }

    public SelectorExtensionType getAdminVdcSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = ((AdminVdcType)this.getResource()).getHref() + "/extension" + "/" + selectorExtensionId;
        return (SelectorExtensionType)SdkUtil.get(this.client, url, 200);
    }

    public SelectorExtensionType updateAdminVdcSelectorExtensionById(String selectorExtensionId, SelectorExtensionType selectorExtensionType) throws VCloudException {
        String url = ((AdminVdcType)this.getResource()).getHref() + "/extension" + "/" + selectorExtensionId;
        ObjectFactory extensionFactory = new ObjectFactory();
        String createSelectorExtension = JAXBUtil.marshal(extensionFactory.createSelectorExtension(selectorExtensionType));
        logger.info(SdkUtil.getI18nString(SdkMessage.PUT_URL_MSG) + " - " + url);
        return (SelectorExtensionType)SdkUtil.put(this.client, url, createSelectorExtension, "application/vnd.vmware.admin.extensibility.selector+xml", 200);
    }

    public void deleteAdminVdcSelectorExtensionById(String selectorExtensionId) throws VCloudException {
        String url = ((AdminVdcType)this.getResource()).getHref() + "/extension" + "/" + selectorExtensionId;
        SdkUtil.delete(this.client, url, 204);
    }
}

